/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2019. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
/* Copyright (c) 2020 Red Hat, Inc. */
'use strict'

module.exports.CFC_ACCESS_COOKIE = 'cfc-access-token-cookie'
module.exports.CFC_AUTH_COOKIE = 'cfc-acs-auth-cookie'

module.exports.REFRESH_TIMES = [15, 30, 60, 5*60, 30*60, 0]
module.exports.DEFAULT_REFRESH_TIME = 10
module.exports.POLICY_REFRESH_INTERVAL_COOKIE = 'policy-refresh-interval-cookie'
module.exports.POLICY_OVERVIEW_STATE_COOKIE = 'policy-overview-state-cookie'

module.exports.MCM_TOPOLOGY_STATE_COOKIE = 'mcm-topology-state-cookie'
module.exports.MCM_TOPOLOGY_ELEMENTS_COOKIE = 'mcm-topology-elements-cookie'

module.exports.MCM_DESIGN_SPLITTER_OPEN_COOKIE = 'mcm-design-splitter-open-cookie'
module.exports.MCM_DESIGN_SPLITTER_SIZE_COOKIE = 'mcm-design-splitter-size-cookie'
module.exports.MCM_OPEN_DIAGRAM_TAB_COOKIE = 'mcm-open-diagram-tab-cookie'

module.exports.RESOURCE_TYPES = {
  QUERY_APPLICATIONS: {
    name: 'QueryApplications',
    list: 'QueryApplicationList'
  },
  HCM_APPLICATIONS: { name: 'HCMApplication', list: 'HCMApplicationList' },
  HCM_PODS: { name: 'HCMPod', list: 'HCMPodList' },
  HCM_POLICIES: { name: 'HCMPolicy', list: 'HCMPolicyList' },
  HCM_POLICIES_PRE_CLUSTER: { name: 'HCMPolicyCluster', list: 'HCMPolicyClusterList' },
  HCM_POLICIES_PRE_POLICY: { name: 'HCMPolicyPolicy', list: 'HCMPolicyPolicyList' },
  HCM_COMPLIANCES: { name: 'HCMCompliance', list: 'HCMComplianceList' },
  HCM_CLUSTERS: { name: 'HCMCluster', list: 'HCMClusterList'},
  HCM_TOPOLOGY: { name: 'HCMTopology', list: 'HCMTopology' },
}
// keep order from lowest to highest role
module.exports.ROLES = {
  VIEWER: 'Viewer',
  EDITOR: 'Editor',
  OPERATOR: 'Operator',
  ADMIN: 'Administrator',
  ACCOUNT_ADMIN: 'AccountAdministrator',
  CLUSTER_ADMIN: 'ClusterAdministrator'
}
