/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2018. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
/* Copyright (c) 2020 Red Hat, Inc. */
import GrcApolloClient from '../../lib/client/apollo-client'
import {
  LOGS_RESET, LOGS_SEARCH, LOGS_RECEIVE_SUCCESS, LOGS_RECEIVE_FAILURE,
  REQUEST_STATUS, LOGS_RECEIVE_IN_PROGRESS
} from './index'

export const resetLogs= () => ({
  type: LOGS_RESET
})

export const searchLogs = (search, resourceType) => ({
  type: LOGS_SEARCH,
  search,
  resourceType
})

export const receiveLogsSuccess = (response) => ({
  type: LOGS_RECEIVE_SUCCESS,
  status: REQUEST_STATUS.DONE,
  data: response,
})

export const receiveLogsFailure = (response) => ({
  type: LOGS_RECEIVE_FAILURE,
  status: REQUEST_STATUS.DONE,
  data: response,
})

export const receiveLogsInProgress = () => ({
  type: LOGS_RECEIVE_IN_PROGRESS,
  status: REQUEST_STATUS.IN_PROGRESS,
})

export const fetchLogs = (containerName, podName, podNamespace, clusterName) => (dispatch => {
  dispatch(receiveLogsInProgress())
  return GrcApolloClient.getLogs(containerName, podName, podNamespace, clusterName).then(result => {
    if (result.data.logs.errors && result.data.logs.errors.length > 0){
      dispatch(receiveLogsFailure(result.data.logs.errors[0]))
    } else {
      dispatch(receiveLogsSuccess(result.data.logs))
    }
  })
})
