/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2020. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
/* Copyright (c) 2020 Red Hat, Inc. */
export const getClusterData = (subData, hasFailed, failedClusterCount, totalClusterCount) => {
  Object.keys(subData).forEach(key => {
    if (key === 'Failed') {
      hasFailed = true
      failedClusterCount = subData[key]
    } else {
      totalClusterCount += subData[key]
    }
  })
  totalClusterCount += failedClusterCount

  return [hasFailed, failedClusterCount, totalClusterCount]
}

export const getPodData = (podData, hasFailed, failedPodCount, totalPodCount) => {
  Object.keys(podData).forEach(key => {
    if (
      key.toLowerCase().includes('fail') ||
      key.toLowerCase().includes('error') ||
      key.toLowerCase().includes('backoff')
    ) {
      hasFailed = true
      failedPodCount += podData[key]
    } else {
      totalPodCount += podData[key]
    }
  })
  totalPodCount += failedPodCount

  return [hasFailed, failedPodCount, totalPodCount]
}
