/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2019. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
'use strict'

import React from 'react'
import { Portals } from './constants.js'
import resources from '../../../lib/shared/resources'

resources(() => {
  require('../../../scss/resource-toolbar.scss')
})

export default class TopologyHeader extends React.Component {
  render() {
    return (
      <div id='resource-toolbar' className='resource-toolbar'>
        <div className='resource-toolbar-container' >
          <div className='resource-toolbar-buttons' >
            <div id={Portals.refreshTimeSelectorPortal} />
            <div id={Portals.assortedFilterOpenBtn} />
          </div>
          <div id={Portals.assortedFilterCloseBtns} />
        </div>
      </div>
    )
  }
}

