/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2018, 2019. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
/* Copyright (c) 2020 Red Hat, Inc. */
'use strict'

import React from 'react'
import PropTypes from 'prop-types'
import { ComboBox } from 'carbon-components-react'
import _ from 'lodash'
import msgs from '../../../nls/platform.properties'

class FilterableSelect extends React.Component {

  static propTypes = {
    availableFilters: PropTypes.array,
    failure: PropTypes.bool,
    fetching: PropTypes.bool,
    onChange: PropTypes.func,
    selectedFilter: PropTypes.string,
    title: PropTypes.string
  }

  constructor (props) {
    super(props)
    this.setSelect = this.setSelect.bind(this)
  }

  componentDidMount () {
    this.updateTooltip()
  }

  updateTooltip () {
    if (this.multiSelectCmp) {
      this.multiSelectCmp.inputNode.title = this.tooltip.join('\n')
    }
  }

  shouldComponentUpdate(nextProps){
    return !_.isEqual(this.props.selectedFilter, nextProps.selectedFilter) ||
    !_.isEqual(this.props.availableFilters, nextProps.availableFilters)
  }

  render() {
    const {
      title,
      selectedFilter,
      availableFilters=[],
      fetching,
      failure} = this.props

    this.tooltip = []
    if (failure) {
      this.tooltip.push(msgs.get('resource.error', this.context.locale))
    } else if (fetching) {
      this.tooltip.push(msgs.get('resource.loading', this.context.locale))
    } else if (!selectedFilter) {
      this.tooltip.push(title)
    } else {
      this.tooltip.push(selectedFilter)
    }
    // set id to title for testing
    return (
      <div className='select-filter' ref={this.setSelect}>
        <ComboBox items={availableFilters}
          placeholder={this.tooltip.join(', ')}
          shouldFilterItem={({inputValue, item})=>{
            return (inputValue.length===0 ||
                selectedFilter===inputValue || item.label.indexOf(inputValue)!==-1)
          }}
          onChange={this.handleFilter}
        />
      </div>
    )
  }

  handleFilter = selection => {
    if (selection.selectedItem) {
      this.props.onChange(selection.selectedItem.value)
    }
  }

  setSelect = ref => {
    this.selectRef = ref
    this.fixTooltip()
  }

  componentDidUpdate() {
    this.fixTooltip()
  }
  // tooltip on dropdown is hardcoded
  fixTooltip = () => {
    if (this.selectRef) {
      const title = this.selectRef.querySelector('title')
      if (title) {
        title.innerHTML = msgs.get('choose.selection', this.context.locale)
      }
    }
  }

  saveMultiSelectDiv = ref => {
    this.multiSelectDiv = ref
  }

  saveMultiSelectCmp = ref => {
    this.multiSelectCmp = ref
  }
}

export default FilterableSelect
