/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2017, 2019. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
/* Copyright (c) 2020 Red Hat, Inc. */
'use strict'

import React from 'react'
import { connect } from 'react-redux'
import loadable from '@loadable/component'

let LogsModal

const Modal = ({ type, open, ...rest }) => {
  switch (type) {
  case 'view-logs':
    return open && getLogsModal({ type, open, ...rest })
  default:
    return null
  }
}

const getLogsModal = props => {
  LogsModal = (LogsModal === undefined)
    ? loadable(() => import(/* webpackChunkName: "logs-modal" */ './LogsModal'))
    : LogsModal
  return getModal(LogsModal, props)
}

const getModal = (Component, props) => <Component {...props} />

const mapStateToProps = state => state.modal

export default connect(mapStateToProps)(Modal)
