/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2019. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
/* Copyright (c) 2020 Red Hat, Inc. */
'use strict'
// seems to be an issue with this rule and redux connect method in SecondaryHeader
/* eslint-disable import/no-named-as-default */

import React from 'react'
import PropTypes from 'prop-types'
import SecondaryHeader from '../components/SecondaryHeader'
import { Route, Switch, Redirect } from 'react-router-dom'
import resources from '../../lib/shared/resources'
import client from '../../lib/shared/client'
import config from '../../lib/shared/config'
import Modal from '../components/common/Modal'
import loadable from '@loadable/component'

export const TopologyPage = loadable(
  () => import(/* webpackChunkName: "topology" */ './TopologyPage')
)
export const TopologyHeader = loadable(
  () => import(/* webpackChunkName: "ResourceToolbar" */ '../components/TopologyView/TopologyHeader')
)

resources(() => {
  require('../../scss/common.scss')
})

class App extends React.Component {

  static propTypes = {
    match: PropTypes.object,
    staticContext: PropTypes.object,
  }

  constructor(props) {
    super(props)
    if (client) {
      this.serverProps = JSON.parse(document.getElementById('propshcm').textContent)
    }
  }

  getServerProps() {
    if (client) {
      return this.serverProps
    }
    return this.props.staticContext
  }

  render() {
    const serverProps = this.getServerProps()
    const { match } = this.props
    return (
      <div className='expand-vertically'>
        <SecondaryHeader />
        <TopologyHeader />
        <Switch>
          <Route path={`${match.url}`} render={() => <TopologyPage />} />
          <Redirect to={`${config.contextPath}`} />
        </Switch>
        <Modal locale={serverProps.context.locale} />
        <input
          type='hidden'
          id='app-access'
          value={serverProps.xsrfToken.toString('base64')}
          locale={serverProps.context.locale}
        />
      </div>
    )
  }

  getChildContext() {
    return {
      locale: this.getServerProps().context.locale
    }
  }
}

App.childContextTypes = {
  locale: PropTypes.string
}

export default props => ( // eslint-disable-line react/display-name
  <div className='expand-vertically'>
    <Route path={config.contextPath} serverProps={props} component={App} />
  </div>
)
