/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2018. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
/* Copyright (c) 2020 Red Hat, Inc. */
'use strict'

import React from 'react'
import PropTypes from 'prop-types'
import { Route, Switch, withRouter } from 'react-router-dom'
import TopologyView from '../components/TopologyView/TopologyView'

const WrappedTopologyView = props =>
  <TopologyView role={props.role} />

WrappedTopologyView.propTypes = {
  role: PropTypes.string,
}

const TopologyPageWithView = props =>
  <Switch>
    <Route exact path={props.match.url} render={() => (
      <WrappedTopologyView {...props} />
    )} />
  </Switch>

TopologyPageWithView.propTypes = {
  match: PropTypes.object,
}

const wrappedTopologyPageWithView = () => {
  const WrappedTopologyPageWithView = class extends React.PureComponent {
    render() {
      return (
        <TopologyPageWithView {...this.props} />
      )
    }
  }
  WrappedTopologyPageWithView.displayName = 'TypedResourcePageWithTopology'
  return WrappedTopologyPageWithView
}

export default withRouter(wrappedTopologyPageWithView())
