/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2019. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
/* Copyright (c) 2020 Red Hat, Inc. */
/* eslint-disable no-console, import/no-unresolved */

if(!process.env.PREV_COVERAGE_REPORT
  || process.env.PREV_COVERAGE_REPORT === ''
  || process.env.PREV_COVERAGE_REPORT === '404: Not Found'){
  console.error('Skipped code coverage enforcement. Unable to find the previous coverage report.')
  console.error('Please check the value of PREV_COVERAGE_REPORT')
  // Ignoring for now, once we get the right process in place we should fail the build.
  process.exit(0)
}

console.log('Current path:', process.cwd())

const currReport = require('../test-output/coverage/coverage-summary.json')
let prevReport
try{
  prevReport = JSON.parse(process.env.PREV_COVERAGE_REPORT)
} catch (error){
  console.error('Skipped code coverage enforcement. Unable to parse the previous coverage report.')
  console.error(error)
  // Ignoring for now, once we get the right process in place we should fail the build.
  process.exit(0)
}

let result = ''
if(currReport.total.lines.pct < prevReport.total.lines.pct){
  const diff = prevReport.total.lines.pct - currReport.total.lines.pct
  result = `${result}\n  - Lines covered declined by: ${diff}%`
}
if(currReport.total.statements.pct < prevReport.total.statements.pct){
  const diff = prevReport.total.statements.pct - currReport.total.statements.pct
  result = `${result}\n  - Statements covered declined by: ${diff}%`
}
if(currReport.total.functions.pct < prevReport.total.functions.pct){
  const diff = prevReport.total.functions.pct - currReport.total.functions.pct
  result = `${result}\n  - Functions covered declined by: ${diff}%`
}
if(currReport.total.branches.pct < prevReport.total.branches.pct){
  const diff = prevReport.total.branches.pct - currReport.total.branches.pct
  result = `${result}\n  - Branches covered declined by: ${diff}%`
}

if(result !== ''){
  console.error('BUILD FAILED because code coverage declined.')
  console.error(result)
  process.exit(1)
}
