"use strict";

var _react = _interopRequireDefault(require("react"));

var _react2 = require("@storybook/react");

var _addonActions = require("@storybook/addon-actions");

var _addonKnobs = require("@storybook/addon-knobs");

var _Link = _interopRequireDefault(require("../Link"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

/* eslint-disable no-console */
var props = function props() {
  return {
    className: 'some-class',
    href: (0, _addonKnobs.text)('The link href (href)', '#'),
    onClick: function (handler) {
      return function (evt) {
        evt.preventDefault(); // Prevent link from being followed for demo purpose

        handler(evt);
      };
    }((0, _addonActions.action)('onClick')),
    disabled: (0, _addonKnobs.boolean)('Disabled', false)
  };
};

(0, _react2.storiesOf)('Link', module).addDecorator(_addonKnobs.withKnobs).add('Default', function () {
  return _react.default.createElement(_Link.default, props(), "Link");
}, {
  info: {
    text: "\n            Links are typically used as a means of navigation either within the application, to a place outside, or to a resource.\n            For anything else, especially things that change data, you should be using a button.\n          "
  }
});