// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/firestore/admin/v1beta1/firestore_admin.proto

package admin

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// The various possible states for an ongoing Operation.
type OperationState int32

const (
	// Unspecified.
	OperationState_STATE_UNSPECIFIED OperationState = 0
	// Request is being prepared for processing.
	OperationState_INITIALIZING OperationState = 1
	// Request is actively being processed.
	OperationState_PROCESSING OperationState = 2
	// Request is in the process of being cancelled after user called
	// google.longrunning.Operations.CancelOperation on the operation.
	OperationState_CANCELLING OperationState = 3
	// Request has been processed and is in its finalization stage.
	OperationState_FINALIZING OperationState = 4
	// Request has completed successfully.
	OperationState_SUCCESSFUL OperationState = 5
	// Request has finished being processed, but encountered an error.
	OperationState_FAILED OperationState = 6
	// Request has finished being cancelled after user called
	// google.longrunning.Operations.CancelOperation.
	OperationState_CANCELLED OperationState = 7
)

var OperationState_name = map[int32]string{
	0: "STATE_UNSPECIFIED",
	1: "INITIALIZING",
	2: "PROCESSING",
	3: "CANCELLING",
	4: "FINALIZING",
	5: "SUCCESSFUL",
	6: "FAILED",
	7: "CANCELLED",
}

var OperationState_value = map[string]int32{
	"STATE_UNSPECIFIED": 0,
	"INITIALIZING":      1,
	"PROCESSING":        2,
	"CANCELLING":        3,
	"FINALIZING":        4,
	"SUCCESSFUL":        5,
	"FAILED":            6,
	"CANCELLED":         7,
}

func (x OperationState) String() string {
	return proto.EnumName(OperationState_name, int32(x))
}

func (OperationState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_45deb2e54c3a4296, []int{0}
}

// The type of index operation.
type IndexOperationMetadata_OperationType int32

const (
	// Unspecified. Never set by server.
	IndexOperationMetadata_OPERATION_TYPE_UNSPECIFIED IndexOperationMetadata_OperationType = 0
	// The operation is creating the index. Initiated by a `CreateIndex` call.
	IndexOperationMetadata_CREATING_INDEX IndexOperationMetadata_OperationType = 1
)

var IndexOperationMetadata_OperationType_name = map[int32]string{
	0: "OPERATION_TYPE_UNSPECIFIED",
	1: "CREATING_INDEX",
}

var IndexOperationMetadata_OperationType_value = map[string]int32{
	"OPERATION_TYPE_UNSPECIFIED": 0,
	"CREATING_INDEX":             1,
}

func (x IndexOperationMetadata_OperationType) String() string {
	return proto.EnumName(IndexOperationMetadata_OperationType_name, int32(x))
}

func (IndexOperationMetadata_OperationType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_45deb2e54c3a4296, []int{0, 0}
}

// Metadata for index operations. This metadata populates
// the metadata field of [google.longrunning.Operation][google.longrunning.Operation].
type IndexOperationMetadata struct {
	// The time that work began on the operation.
	StartTime *timestamp.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The time the operation ended, either successfully or otherwise. Unset if
	// the operation is still active.
	EndTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The index resource that this operation is acting on. For example:
	// `projects/{project_id}/databases/{database_id}/indexes/{index_id}`
	Index string `protobuf:"bytes,3,opt,name=index,proto3" json:"index,omitempty"`
	// The type of index operation.
	OperationType IndexOperationMetadata_OperationType `protobuf:"varint,4,opt,name=operation_type,json=operationType,proto3,enum=google.firestore.admin.v1beta1.IndexOperationMetadata_OperationType" json:"operation_type,omitempty"`
	// True if the [google.longrunning.Operation] was cancelled. If the
	// cancellation is in progress, cancelled will be true but
	// [google.longrunning.Operation.done][google.longrunning.Operation.done] will be false.
	Cancelled bool `protobuf:"varint,5,opt,name=cancelled,proto3" json:"cancelled,omitempty"`
	// Progress of the existing operation, measured in number of documents.
	DocumentProgress     *Progress `protobuf:"bytes,6,opt,name=document_progress,json=documentProgress,proto3" json:"document_progress,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *IndexOperationMetadata) Reset()         { *m = IndexOperationMetadata{} }
func (m *IndexOperationMetadata) String() string { return proto.CompactTextString(m) }
func (*IndexOperationMetadata) ProtoMessage()    {}
func (*IndexOperationMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_45deb2e54c3a4296, []int{0}
}

func (m *IndexOperationMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IndexOperationMetadata.Unmarshal(m, b)
}
func (m *IndexOperationMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IndexOperationMetadata.Marshal(b, m, deterministic)
}
func (m *IndexOperationMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IndexOperationMetadata.Merge(m, src)
}
func (m *IndexOperationMetadata) XXX_Size() int {
	return xxx_messageInfo_IndexOperationMetadata.Size(m)
}
func (m *IndexOperationMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_IndexOperationMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_IndexOperationMetadata proto.InternalMessageInfo

func (m *IndexOperationMetadata) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *IndexOperationMetadata) GetEndTime() *timestamp.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func (m *IndexOperationMetadata) GetIndex() string {
	if m != nil {
		return m.Index
	}
	return ""
}

func (m *IndexOperationMetadata) GetOperationType() IndexOperationMetadata_OperationType {
	if m != nil {
		return m.OperationType
	}
	return IndexOperationMetadata_OPERATION_TYPE_UNSPECIFIED
}

func (m *IndexOperationMetadata) GetCancelled() bool {
	if m != nil {
		return m.Cancelled
	}
	return false
}

func (m *IndexOperationMetadata) GetDocumentProgress() *Progress {
	if m != nil {
		return m.DocumentProgress
	}
	return nil
}

// Measures the progress of a particular metric.
type Progress struct {
	// An estimate of how much work has been completed. Note that this may be
	// greater than `work_estimated`.
	WorkCompleted int64 `protobuf:"varint,1,opt,name=work_completed,json=workCompleted,proto3" json:"work_completed,omitempty"`
	// An estimate of how much work needs to be performed. Zero if the
	// work estimate is unavailable. May change as work progresses.
	WorkEstimated        int64    `protobuf:"varint,2,opt,name=work_estimated,json=workEstimated,proto3" json:"work_estimated,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Progress) Reset()         { *m = Progress{} }
func (m *Progress) String() string { return proto.CompactTextString(m) }
func (*Progress) ProtoMessage()    {}
func (*Progress) Descriptor() ([]byte, []int) {
	return fileDescriptor_45deb2e54c3a4296, []int{1}
}

func (m *Progress) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Progress.Unmarshal(m, b)
}
func (m *Progress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Progress.Marshal(b, m, deterministic)
}
func (m *Progress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Progress.Merge(m, src)
}
func (m *Progress) XXX_Size() int {
	return xxx_messageInfo_Progress.Size(m)
}
func (m *Progress) XXX_DiscardUnknown() {
	xxx_messageInfo_Progress.DiscardUnknown(m)
}

var xxx_messageInfo_Progress proto.InternalMessageInfo

func (m *Progress) GetWorkCompleted() int64 {
	if m != nil {
		return m.WorkCompleted
	}
	return 0
}

func (m *Progress) GetWorkEstimated() int64 {
	if m != nil {
		return m.WorkEstimated
	}
	return 0
}

// The request for [FirestoreAdmin.CreateIndex][google.firestore.admin.v1beta1.FirestoreAdmin.CreateIndex].
type CreateIndexRequest struct {
	// The name of the database this index will apply to. For example:
	// `projects/{project_id}/databases/{database_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The index to create. The name and state fields are output only and will be
	// ignored. Certain single field indexes cannot be created or deleted.
	Index                *Index   `protobuf:"bytes,2,opt,name=index,proto3" json:"index,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateIndexRequest) Reset()         { *m = CreateIndexRequest{} }
func (m *CreateIndexRequest) String() string { return proto.CompactTextString(m) }
func (*CreateIndexRequest) ProtoMessage()    {}
func (*CreateIndexRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_45deb2e54c3a4296, []int{2}
}

func (m *CreateIndexRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateIndexRequest.Unmarshal(m, b)
}
func (m *CreateIndexRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateIndexRequest.Marshal(b, m, deterministic)
}
func (m *CreateIndexRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateIndexRequest.Merge(m, src)
}
func (m *CreateIndexRequest) XXX_Size() int {
	return xxx_messageInfo_CreateIndexRequest.Size(m)
}
func (m *CreateIndexRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateIndexRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateIndexRequest proto.InternalMessageInfo

func (m *CreateIndexRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateIndexRequest) GetIndex() *Index {
	if m != nil {
		return m.Index
	}
	return nil
}

// The request for [FirestoreAdmin.GetIndex][google.firestore.admin.v1beta1.FirestoreAdmin.GetIndex].
type GetIndexRequest struct {
	// The name of the index. For example:
	// `projects/{project_id}/databases/{database_id}/indexes/{index_id}`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetIndexRequest) Reset()         { *m = GetIndexRequest{} }
func (m *GetIndexRequest) String() string { return proto.CompactTextString(m) }
func (*GetIndexRequest) ProtoMessage()    {}
func (*GetIndexRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_45deb2e54c3a4296, []int{3}
}

func (m *GetIndexRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetIndexRequest.Unmarshal(m, b)
}
func (m *GetIndexRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetIndexRequest.Marshal(b, m, deterministic)
}
func (m *GetIndexRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetIndexRequest.Merge(m, src)
}
func (m *GetIndexRequest) XXX_Size() int {
	return xxx_messageInfo_GetIndexRequest.Size(m)
}
func (m *GetIndexRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetIndexRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetIndexRequest proto.InternalMessageInfo

func (m *GetIndexRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The request for [FirestoreAdmin.ListIndexes][google.firestore.admin.v1beta1.FirestoreAdmin.ListIndexes].
type ListIndexesRequest struct {
	// The database name. For example:
	// `projects/{project_id}/databases/{database_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// The standard List page size.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The standard List page token.
	PageToken            string   `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListIndexesRequest) Reset()         { *m = ListIndexesRequest{} }
func (m *ListIndexesRequest) String() string { return proto.CompactTextString(m) }
func (*ListIndexesRequest) ProtoMessage()    {}
func (*ListIndexesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_45deb2e54c3a4296, []int{4}
}

func (m *ListIndexesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListIndexesRequest.Unmarshal(m, b)
}
func (m *ListIndexesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListIndexesRequest.Marshal(b, m, deterministic)
}
func (m *ListIndexesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListIndexesRequest.Merge(m, src)
}
func (m *ListIndexesRequest) XXX_Size() int {
	return xxx_messageInfo_ListIndexesRequest.Size(m)
}
func (m *ListIndexesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListIndexesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListIndexesRequest proto.InternalMessageInfo

func (m *ListIndexesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListIndexesRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListIndexesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListIndexesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// The request for [FirestoreAdmin.DeleteIndex][google.firestore.admin.v1beta1.FirestoreAdmin.DeleteIndex].
type DeleteIndexRequest struct {
	// The index name. For example:
	// `projects/{project_id}/databases/{database_id}/indexes/{index_id}`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteIndexRequest) Reset()         { *m = DeleteIndexRequest{} }
func (m *DeleteIndexRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteIndexRequest) ProtoMessage()    {}
func (*DeleteIndexRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_45deb2e54c3a4296, []int{5}
}

func (m *DeleteIndexRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteIndexRequest.Unmarshal(m, b)
}
func (m *DeleteIndexRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteIndexRequest.Marshal(b, m, deterministic)
}
func (m *DeleteIndexRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteIndexRequest.Merge(m, src)
}
func (m *DeleteIndexRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteIndexRequest.Size(m)
}
func (m *DeleteIndexRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteIndexRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteIndexRequest proto.InternalMessageInfo

func (m *DeleteIndexRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The response for [FirestoreAdmin.ListIndexes][google.firestore.admin.v1beta1.FirestoreAdmin.ListIndexes].
type ListIndexesResponse struct {
	// The indexes.
	Indexes []*Index `protobuf:"bytes,1,rep,name=indexes,proto3" json:"indexes,omitempty"`
	// The standard List next-page token.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListIndexesResponse) Reset()         { *m = ListIndexesResponse{} }
func (m *ListIndexesResponse) String() string { return proto.CompactTextString(m) }
func (*ListIndexesResponse) ProtoMessage()    {}
func (*ListIndexesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_45deb2e54c3a4296, []int{6}
}

func (m *ListIndexesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListIndexesResponse.Unmarshal(m, b)
}
func (m *ListIndexesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListIndexesResponse.Marshal(b, m, deterministic)
}
func (m *ListIndexesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListIndexesResponse.Merge(m, src)
}
func (m *ListIndexesResponse) XXX_Size() int {
	return xxx_messageInfo_ListIndexesResponse.Size(m)
}
func (m *ListIndexesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListIndexesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListIndexesResponse proto.InternalMessageInfo

func (m *ListIndexesResponse) GetIndexes() []*Index {
	if m != nil {
		return m.Indexes
	}
	return nil
}

func (m *ListIndexesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The request for [FirestoreAdmin.ExportDocuments][google.firestore.admin.v1beta1.FirestoreAdmin.ExportDocuments].
type ExportDocumentsRequest struct {
	// Database to export. Should be of the form:
	// `projects/{project_id}/databases/{database_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Which collection ids to export. Unspecified means all collections.
	CollectionIds []string `protobuf:"bytes,3,rep,name=collection_ids,json=collectionIds,proto3" json:"collection_ids,omitempty"`
	// The output URI. Currently only supports Google Cloud Storage URIs of the
	// form: `gs://BUCKET_NAME[/NAMESPACE_PATH]`, where `BUCKET_NAME` is the name
	// of the Google Cloud Storage bucket and `NAMESPACE_PATH` is an optional
	// Google Cloud Storage namespace path. When
	// choosing a name, be sure to consider Google Cloud Storage naming
	// guidelines: https://cloud.google.com/storage/docs/naming.
	// If the URI is a bucket (without a namespace path), a prefix will be
	// generated based on the start time.
	OutputUriPrefix      string   `protobuf:"bytes,4,opt,name=output_uri_prefix,json=outputUriPrefix,proto3" json:"output_uri_prefix,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExportDocumentsRequest) Reset()         { *m = ExportDocumentsRequest{} }
func (m *ExportDocumentsRequest) String() string { return proto.CompactTextString(m) }
func (*ExportDocumentsRequest) ProtoMessage()    {}
func (*ExportDocumentsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_45deb2e54c3a4296, []int{7}
}

func (m *ExportDocumentsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExportDocumentsRequest.Unmarshal(m, b)
}
func (m *ExportDocumentsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExportDocumentsRequest.Marshal(b, m, deterministic)
}
func (m *ExportDocumentsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExportDocumentsRequest.Merge(m, src)
}
func (m *ExportDocumentsRequest) XXX_Size() int {
	return xxx_messageInfo_ExportDocumentsRequest.Size(m)
}
func (m *ExportDocumentsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ExportDocumentsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ExportDocumentsRequest proto.InternalMessageInfo

func (m *ExportDocumentsRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ExportDocumentsRequest) GetCollectionIds() []string {
	if m != nil {
		return m.CollectionIds
	}
	return nil
}

func (m *ExportDocumentsRequest) GetOutputUriPrefix() string {
	if m != nil {
		return m.OutputUriPrefix
	}
	return ""
}

// The request for [FirestoreAdmin.ImportDocuments][google.firestore.admin.v1beta1.FirestoreAdmin.ImportDocuments].
type ImportDocumentsRequest struct {
	// Database to import into. Should be of the form:
	// `projects/{project_id}/databases/{database_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Which collection ids to import. Unspecified means all collections included
	// in the import.
	CollectionIds []string `protobuf:"bytes,3,rep,name=collection_ids,json=collectionIds,proto3" json:"collection_ids,omitempty"`
	// Location of the exported files.
	// This must match the output_uri_prefix of an ExportDocumentsResponse from
	// an export that has completed successfully.
	// See:
	// [google.firestore.admin.v1beta1.ExportDocumentsResponse.output_uri_prefix][google.firestore.admin.v1beta1.ExportDocumentsResponse.output_uri_prefix].
	InputUriPrefix       string   `protobuf:"bytes,4,opt,name=input_uri_prefix,json=inputUriPrefix,proto3" json:"input_uri_prefix,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ImportDocumentsRequest) Reset()         { *m = ImportDocumentsRequest{} }
func (m *ImportDocumentsRequest) String() string { return proto.CompactTextString(m) }
func (*ImportDocumentsRequest) ProtoMessage()    {}
func (*ImportDocumentsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_45deb2e54c3a4296, []int{8}
}

func (m *ImportDocumentsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImportDocumentsRequest.Unmarshal(m, b)
}
func (m *ImportDocumentsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImportDocumentsRequest.Marshal(b, m, deterministic)
}
func (m *ImportDocumentsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImportDocumentsRequest.Merge(m, src)
}
func (m *ImportDocumentsRequest) XXX_Size() int {
	return xxx_messageInfo_ImportDocumentsRequest.Size(m)
}
func (m *ImportDocumentsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ImportDocumentsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ImportDocumentsRequest proto.InternalMessageInfo

func (m *ImportDocumentsRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ImportDocumentsRequest) GetCollectionIds() []string {
	if m != nil {
		return m.CollectionIds
	}
	return nil
}

func (m *ImportDocumentsRequest) GetInputUriPrefix() string {
	if m != nil {
		return m.InputUriPrefix
	}
	return ""
}

// Returned in the [google.longrunning.Operation][google.longrunning.Operation] response field.
type ExportDocumentsResponse struct {
	// Location of the output files. This can be used to begin an import
	// into Cloud Firestore (this project or another project) after the operation
	// completes successfully.
	OutputUriPrefix      string   `protobuf:"bytes,1,opt,name=output_uri_prefix,json=outputUriPrefix,proto3" json:"output_uri_prefix,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExportDocumentsResponse) Reset()         { *m = ExportDocumentsResponse{} }
func (m *ExportDocumentsResponse) String() string { return proto.CompactTextString(m) }
func (*ExportDocumentsResponse) ProtoMessage()    {}
func (*ExportDocumentsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_45deb2e54c3a4296, []int{9}
}

func (m *ExportDocumentsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExportDocumentsResponse.Unmarshal(m, b)
}
func (m *ExportDocumentsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExportDocumentsResponse.Marshal(b, m, deterministic)
}
func (m *ExportDocumentsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExportDocumentsResponse.Merge(m, src)
}
func (m *ExportDocumentsResponse) XXX_Size() int {
	return xxx_messageInfo_ExportDocumentsResponse.Size(m)
}
func (m *ExportDocumentsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ExportDocumentsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ExportDocumentsResponse proto.InternalMessageInfo

func (m *ExportDocumentsResponse) GetOutputUriPrefix() string {
	if m != nil {
		return m.OutputUriPrefix
	}
	return ""
}

// Metadata for ExportDocuments operations.
type ExportDocumentsMetadata struct {
	// The time that work began on the operation.
	StartTime *timestamp.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The time the operation ended, either successfully or otherwise. Unset if
	// the operation is still active.
	EndTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The state of the export operation.
	OperationState OperationState `protobuf:"varint,3,opt,name=operation_state,json=operationState,proto3,enum=google.firestore.admin.v1beta1.OperationState" json:"operation_state,omitempty"`
	// An estimate of the number of documents processed.
	ProgressDocuments *Progress `protobuf:"bytes,4,opt,name=progress_documents,json=progressDocuments,proto3" json:"progress_documents,omitempty"`
	// An estimate of the number of bytes processed.
	ProgressBytes *Progress `protobuf:"bytes,5,opt,name=progress_bytes,json=progressBytes,proto3" json:"progress_bytes,omitempty"`
	// Which collection ids are being exported.
	CollectionIds []string `protobuf:"bytes,6,rep,name=collection_ids,json=collectionIds,proto3" json:"collection_ids,omitempty"`
	// Where the entities are being exported to.
	OutputUriPrefix      string   `protobuf:"bytes,7,opt,name=output_uri_prefix,json=outputUriPrefix,proto3" json:"output_uri_prefix,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExportDocumentsMetadata) Reset()         { *m = ExportDocumentsMetadata{} }
func (m *ExportDocumentsMetadata) String() string { return proto.CompactTextString(m) }
func (*ExportDocumentsMetadata) ProtoMessage()    {}
func (*ExportDocumentsMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_45deb2e54c3a4296, []int{10}
}

func (m *ExportDocumentsMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExportDocumentsMetadata.Unmarshal(m, b)
}
func (m *ExportDocumentsMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExportDocumentsMetadata.Marshal(b, m, deterministic)
}
func (m *ExportDocumentsMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExportDocumentsMetadata.Merge(m, src)
}
func (m *ExportDocumentsMetadata) XXX_Size() int {
	return xxx_messageInfo_ExportDocumentsMetadata.Size(m)
}
func (m *ExportDocumentsMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_ExportDocumentsMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_ExportDocumentsMetadata proto.InternalMessageInfo

func (m *ExportDocumentsMetadata) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *ExportDocumentsMetadata) GetEndTime() *timestamp.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func (m *ExportDocumentsMetadata) GetOperationState() OperationState {
	if m != nil {
		return m.OperationState
	}
	return OperationState_STATE_UNSPECIFIED
}

func (m *ExportDocumentsMetadata) GetProgressDocuments() *Progress {
	if m != nil {
		return m.ProgressDocuments
	}
	return nil
}

func (m *ExportDocumentsMetadata) GetProgressBytes() *Progress {
	if m != nil {
		return m.ProgressBytes
	}
	return nil
}

func (m *ExportDocumentsMetadata) GetCollectionIds() []string {
	if m != nil {
		return m.CollectionIds
	}
	return nil
}

func (m *ExportDocumentsMetadata) GetOutputUriPrefix() string {
	if m != nil {
		return m.OutputUriPrefix
	}
	return ""
}

// Metadata for ImportDocuments operations.
type ImportDocumentsMetadata struct {
	// The time that work began on the operation.
	StartTime *timestamp.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The time the operation ended, either successfully or otherwise. Unset if
	// the operation is still active.
	EndTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The state of the import operation.
	OperationState OperationState `protobuf:"varint,3,opt,name=operation_state,json=operationState,proto3,enum=google.firestore.admin.v1beta1.OperationState" json:"operation_state,omitempty"`
	// An estimate of the number of documents processed.
	ProgressDocuments *Progress `protobuf:"bytes,4,opt,name=progress_documents,json=progressDocuments,proto3" json:"progress_documents,omitempty"`
	// An estimate of the number of bytes processed.
	ProgressBytes *Progress `protobuf:"bytes,5,opt,name=progress_bytes,json=progressBytes,proto3" json:"progress_bytes,omitempty"`
	// Which collection ids are being imported.
	CollectionIds []string `protobuf:"bytes,6,rep,name=collection_ids,json=collectionIds,proto3" json:"collection_ids,omitempty"`
	// The location of the documents being imported.
	InputUriPrefix       string   `protobuf:"bytes,7,opt,name=input_uri_prefix,json=inputUriPrefix,proto3" json:"input_uri_prefix,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ImportDocumentsMetadata) Reset()         { *m = ImportDocumentsMetadata{} }
func (m *ImportDocumentsMetadata) String() string { return proto.CompactTextString(m) }
func (*ImportDocumentsMetadata) ProtoMessage()    {}
func (*ImportDocumentsMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_45deb2e54c3a4296, []int{11}
}

func (m *ImportDocumentsMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImportDocumentsMetadata.Unmarshal(m, b)
}
func (m *ImportDocumentsMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImportDocumentsMetadata.Marshal(b, m, deterministic)
}
func (m *ImportDocumentsMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImportDocumentsMetadata.Merge(m, src)
}
func (m *ImportDocumentsMetadata) XXX_Size() int {
	return xxx_messageInfo_ImportDocumentsMetadata.Size(m)
}
func (m *ImportDocumentsMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_ImportDocumentsMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_ImportDocumentsMetadata proto.InternalMessageInfo

func (m *ImportDocumentsMetadata) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *ImportDocumentsMetadata) GetEndTime() *timestamp.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func (m *ImportDocumentsMetadata) GetOperationState() OperationState {
	if m != nil {
		return m.OperationState
	}
	return OperationState_STATE_UNSPECIFIED
}

func (m *ImportDocumentsMetadata) GetProgressDocuments() *Progress {
	if m != nil {
		return m.ProgressDocuments
	}
	return nil
}

func (m *ImportDocumentsMetadata) GetProgressBytes() *Progress {
	if m != nil {
		return m.ProgressBytes
	}
	return nil
}

func (m *ImportDocumentsMetadata) GetCollectionIds() []string {
	if m != nil {
		return m.CollectionIds
	}
	return nil
}

func (m *ImportDocumentsMetadata) GetInputUriPrefix() string {
	if m != nil {
		return m.InputUriPrefix
	}
	return ""
}

func init() {
	proto.RegisterEnum("google.firestore.admin.v1beta1.OperationState", OperationState_name, OperationState_value)
	proto.RegisterEnum("google.firestore.admin.v1beta1.IndexOperationMetadata_OperationType", IndexOperationMetadata_OperationType_name, IndexOperationMetadata_OperationType_value)
	proto.RegisterType((*IndexOperationMetadata)(nil), "google.firestore.admin.v1beta1.IndexOperationMetadata")
	proto.RegisterType((*Progress)(nil), "google.firestore.admin.v1beta1.Progress")
	proto.RegisterType((*CreateIndexRequest)(nil), "google.firestore.admin.v1beta1.CreateIndexRequest")
	proto.RegisterType((*GetIndexRequest)(nil), "google.firestore.admin.v1beta1.GetIndexRequest")
	proto.RegisterType((*ListIndexesRequest)(nil), "google.firestore.admin.v1beta1.ListIndexesRequest")
	proto.RegisterType((*DeleteIndexRequest)(nil), "google.firestore.admin.v1beta1.DeleteIndexRequest")
	proto.RegisterType((*ListIndexesResponse)(nil), "google.firestore.admin.v1beta1.ListIndexesResponse")
	proto.RegisterType((*ExportDocumentsRequest)(nil), "google.firestore.admin.v1beta1.ExportDocumentsRequest")
	proto.RegisterType((*ImportDocumentsRequest)(nil), "google.firestore.admin.v1beta1.ImportDocumentsRequest")
	proto.RegisterType((*ExportDocumentsResponse)(nil), "google.firestore.admin.v1beta1.ExportDocumentsResponse")
	proto.RegisterType((*ExportDocumentsMetadata)(nil), "google.firestore.admin.v1beta1.ExportDocumentsMetadata")
	proto.RegisterType((*ImportDocumentsMetadata)(nil), "google.firestore.admin.v1beta1.ImportDocumentsMetadata")
}

func init() {
	proto.RegisterFile("google/firestore/admin/v1beta1/firestore_admin.proto", fileDescriptor_45deb2e54c3a4296)
}

var fileDescriptor_45deb2e54c3a4296 = []byte{
	// 1244 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xec, 0x57, 0x6d, 0x6f, 0xdb, 0xd4,
	0x17, 0xff, 0xbb, 0x69, 0xd3, 0xe6, 0xf4, 0xdf, 0x34, 0xbd, 0x83, 0x2e, 0xca, 0x1e, 0xa8, 0x0c,
	0x43, 0x51, 0x04, 0x36, 0xeb, 0x60, 0x62, 0x9d, 0xd0, 0x94, 0x3a, 0x4e, 0x65, 0x29, 0xa4, 0x91,
	0x93, 0xb2, 0xb1, 0x37, 0x96, 0x9b, 0xdc, 0x66, 0x66, 0xb6, 0xaf, 0xf1, 0xbd, 0x59, 0xdb, 0xa1,
	0x02, 0xe2, 0x2b, 0x8c, 0x97, 0xbc, 0x81, 0x97, 0x20, 0x21, 0xbe, 0x05, 0x12, 0x2f, 0xe1, 0x03,
	0x20, 0x24, 0x3e, 0x00, 0x1f, 0x01, 0xdd, 0x6b, 0x3b, 0xcf, 0x9b, 0x5b, 0x69, 0x12, 0x42, 0xe2,
	0x5d, 0xce, 0xf3, 0xef, 0x9e, 0x73, 0x72, 0xce, 0x31, 0xbc, 0xdb, 0x27, 0xa4, 0xef, 0x62, 0xf5,
	0xc8, 0x09, 0x31, 0x65, 0x24, 0xc4, 0xaa, 0xdd, 0xf3, 0x1c, 0x5f, 0x7d, 0x72, 0xf3, 0x10, 0x33,
	0xfb, 0xe6, 0x88, 0x6f, 0x09, 0xbe, 0x12, 0x84, 0x84, 0x11, 0x74, 0x3d, 0xb2, 0x52, 0x86, 0x52,
	0x25, 0x92, 0xc6, 0x56, 0xa5, 0xab, 0xb1, 0x57, 0x3b, 0x70, 0x54, 0xdb, 0xf7, 0x09, 0xb3, 0x99,
	0x43, 0x7c, 0x1a, 0x59, 0x97, 0x2a, 0x29, 0x31, 0x1d, 0xbf, 0x87, 0x4f, 0x62, 0xdd, 0xd7, 0x63,
	0x5d, 0x97, 0xf8, 0xfd, 0x70, 0xe0, 0xfb, 0x8e, 0xdf, 0x57, 0x49, 0x80, 0xc3, 0x09, 0x87, 0x57,
	0x62, 0x25, 0x41, 0x1d, 0x0e, 0x8e, 0x54, 0xec, 0x05, 0xec, 0x34, 0x16, 0xbe, 0x36, 0x2d, 0x64,
	0x8e, 0x87, 0x29, 0xb3, 0xbd, 0x20, 0x56, 0xb8, 0x3c, 0x06, 0xb6, 0xeb, 0x3a, 0xd8, 0x67, 0x91,
	0x40, 0xfe, 0x39, 0x03, 0x9b, 0x06, 0xc7, 0xb2, 0x9f, 0x04, 0xfc, 0x10, 0x33, 0xbb, 0x67, 0x33,
	0x1b, 0xdd, 0x01, 0xa0, 0xcc, 0x0e, 0x99, 0xc5, 0x9d, 0x15, 0xa5, 0x2d, 0xa9, 0xbc, 0xba, 0x5d,
	0x52, 0xe2, 0xac, 0x24, 0x91, 0x94, 0x4e, 0x12, 0xc9, 0xcc, 0x09, 0x6d, 0x4e, 0xa3, 0xf7, 0x60,
	0x05, 0xfb, 0xbd, 0xc8, 0x70, 0x21, 0xd5, 0x70, 0x19, 0xfb, 0x3d, 0x61, 0xf6, 0x0a, 0x2c, 0x89,
	0xbc, 0x14, 0x33, 0x5b, 0x52, 0x39, 0x67, 0x46, 0x04, 0x7a, 0x0c, 0xf9, 0x61, 0x36, 0x2c, 0x76,
	0x1a, 0xe0, 0xe2, 0xe2, 0x96, 0x54, 0xce, 0x6f, 0xd7, 0x94, 0x17, 0x57, 0x48, 0x99, 0xff, 0x2e,
	0x65, 0xc8, 0xe9, 0x9c, 0x06, 0xd8, 0x5c, 0x23, 0xe3, 0x24, 0xba, 0x0a, 0xb9, 0xae, 0xed, 0x77,
	0xb1, 0xeb, 0xe2, 0x5e, 0x71, 0x69, 0x4b, 0x2a, 0xaf, 0x98, 0x23, 0x06, 0x3a, 0x80, 0x8d, 0x1e,
	0xe9, 0x0e, 0x3c, 0xec, 0x33, 0x2b, 0x08, 0x49, 0x3f, 0xc4, 0x94, 0x16, 0xb3, 0xe2, 0x81, 0xe5,
	0x34, 0x34, 0xad, 0x58, 0xdf, 0x2c, 0x24, 0x2e, 0x12, 0x8e, 0xac, 0xc1, 0xda, 0x04, 0x28, 0x74,
	0x1d, 0x4a, 0xfb, 0x2d, 0xdd, 0xac, 0x76, 0x8c, 0xfd, 0xa6, 0xd5, 0xf9, 0xb8, 0xa5, 0x5b, 0x07,
	0xcd, 0x76, 0x4b, 0xd7, 0x8c, 0xba, 0xa1, 0xd7, 0x0a, 0xff, 0x43, 0x08, 0xf2, 0x9a, 0xa9, 0x57,
	0x3b, 0x46, 0x73, 0xcf, 0x32, 0x9a, 0x35, 0xfd, 0x41, 0x41, 0x92, 0x1f, 0xc0, 0x4a, 0xe2, 0x10,
	0xdd, 0x80, 0xfc, 0x31, 0x09, 0x1f, 0x5b, 0x5d, 0xe2, 0x05, 0x2e, 0x66, 0xb8, 0x27, 0xca, 0x97,
	0x31, 0xd7, 0x38, 0x57, 0x4b, 0x98, 0x43, 0x35, 0x4c, 0x99, 0xe3, 0xd9, 0x5c, 0x6d, 0x61, 0xa4,
	0xa6, 0x27, 0x4c, 0xd9, 0x01, 0xa4, 0x85, 0xd8, 0x66, 0x58, 0x24, 0xd4, 0xc4, 0x9f, 0x0e, 0x30,
	0x65, 0x68, 0x13, 0xb2, 0x81, 0x1d, 0x62, 0x9f, 0x09, 0xdf, 0x39, 0x33, 0xa6, 0xd0, 0xdd, 0xa4,
	0x88, 0x51, 0xe1, 0x6f, 0x9c, 0xab, 0x4a, 0x71, 0xad, 0xe5, 0x1b, 0xb0, 0xbe, 0x87, 0xd9, 0x44,
	0x1c, 0x04, 0x8b, 0xbe, 0x1d, 0x37, 0x60, 0xce, 0x14, 0xbf, 0xe5, 0x2f, 0x25, 0x40, 0x0d, 0x87,
	0x46, 0x8a, 0x98, 0xa6, 0x41, 0xda, 0x84, 0xec, 0x91, 0xe3, 0x32, 0x1c, 0x0a, 0x4c, 0x39, 0x33,
	0xa6, 0xd0, 0x15, 0xc8, 0x05, 0x76, 0x1f, 0x5b, 0xd4, 0x79, 0x8a, 0x45, 0xcf, 0x2d, 0x99, 0x2b,
	0x9c, 0xd1, 0x76, 0x9e, 0x62, 0x74, 0x0d, 0x40, 0x08, 0x19, 0x79, 0x8c, 0x7d, 0xd1, 0x72, 0x39,
	0x53, 0xa8, 0x77, 0x38, 0x43, 0x2e, 0x03, 0xaa, 0x61, 0x9e, 0xc6, 0x54, 0xb0, 0x9f, 0xc3, 0xa5,
	0x09, 0xac, 0x34, 0x20, 0x3e, 0xc5, 0xe8, 0x1e, 0x2c, 0x3b, 0x11, 0xab, 0x28, 0x6d, 0x65, 0xce,
	0x9f, 0xa9, 0xc4, 0x0a, 0xbd, 0x09, 0xeb, 0x3e, 0x3e, 0x61, 0xd6, 0x18, 0xca, 0xe8, 0x79, 0x6b,
	0x9c, 0xdd, 0x1a, 0x22, 0xfd, 0x02, 0x36, 0xf5, 0x93, 0x80, 0x84, 0xac, 0x16, 0xf7, 0x1d, 0x7d,
	0x01, 0x5a, 0xde, 0x13, 0x5d, 0xe2, 0xba, 0xb8, 0x2b, 0xfe, 0x6e, 0x4e, 0x8f, 0x16, 0x33, 0x5b,
	0x19, 0xee, 0x74, 0xc4, 0x35, 0x7a, 0x14, 0x55, 0x60, 0x83, 0x0c, 0x58, 0x30, 0x60, 0xd6, 0x20,
	0x74, 0xac, 0x20, 0xc4, 0x47, 0xce, 0x49, 0x9c, 0xa4, 0xf5, 0x48, 0x70, 0x10, 0x3a, 0x2d, 0xc1,
	0x96, 0xcf, 0x60, 0xd3, 0xf0, 0x5e, 0x36, 0x80, 0x32, 0x14, 0x1c, 0x7f, 0x6e, 0xfc, 0xbc, 0xe0,
	0x8f, 0xc2, 0xeb, 0x70, 0x79, 0xe6, 0xfd, 0x71, 0x0d, 0xe6, 0xbe, 0x42, 0x9a, 0xff, 0x8a, 0x3f,
	0x32, 0x33, 0x7e, 0xfe, 0xc1, 0x51, 0x79, 0x1f, 0xd6, 0x47, 0x43, 0x91, 0x32, 0x9b, 0x45, 0x0d,
	0x9c, 0xdf, 0x56, 0xd2, 0xba, 0x68, 0x38, 0x69, 0xda, 0xdc, 0xca, 0x1c, 0xcd, 0x56, 0x41, 0xa3,
	0xfb, 0x80, 0x92, 0xc9, 0x66, 0x25, 0x83, 0x8a, 0x8a, 0xcc, 0x5e, 0x64, 0xc6, 0x6d, 0x24, 0x3e,
	0x86, 0xb9, 0x42, 0xfb, 0x90, 0x1f, 0x3a, 0x3e, 0x3c, 0x65, 0x98, 0x8a, 0xf1, 0x7a, 0x11, 0xa7,
	0x6b, 0x89, 0xfd, 0x2e, 0x37, 0x9f, 0xd3, 0x28, 0xd9, 0x73, 0x77, 0xea, 0xf2, 0xfc, 0x1a, 0xff,
	0x9e, 0x81, 0xcb, 0x53, 0xad, 0xfa, 0x5f, 0x8d, 0xff, 0x05, 0x35, 0x9e, 0x37, 0x0c, 0x96, 0xe7,
	0x0d, 0x83, 0xca, 0xd7, 0x12, 0xe4, 0x27, 0xb3, 0x83, 0x5e, 0x85, 0x8d, 0x76, 0xa7, 0xda, 0x99,
	0xde, 0xb1, 0x05, 0xf8, 0xbf, 0xd1, 0x34, 0x3a, 0x46, 0xb5, 0x61, 0x3c, 0x34, 0x9a, 0x7b, 0x05,
	0x09, 0xe5, 0x01, 0x5a, 0xe6, 0xbe, 0xa6, 0xb7, 0xdb, 0x9c, 0x5e, 0xe0, 0xb4, 0x56, 0x6d, 0x6a,
	0x7a, 0xa3, 0xc1, 0xe9, 0x0c, 0xa7, 0xeb, 0x46, 0x33, 0xd1, 0x5f, 0xe4, 0x74, 0xfb, 0x40, 0xe3,
	0xfa, 0xf5, 0x83, 0x46, 0x61, 0x09, 0x01, 0x64, 0xeb, 0x55, 0xa3, 0xa1, 0xd7, 0x0a, 0x59, 0xb4,
	0x06, 0xb9, 0xd8, 0x56, 0xaf, 0x15, 0x96, 0xb7, 0xff, 0x5a, 0x81, 0x7c, 0x3d, 0xc9, 0x4d, 0x95,
	0xa7, 0x06, 0x7d, 0x2b, 0xc1, 0xea, 0xd8, 0xda, 0x45, 0xdb, 0x69, 0x39, 0x9c, 0xdd, 0xd1, 0xa5,
	0x6b, 0x89, 0xcd, 0xd8, 0x69, 0x39, 0x6a, 0x0e, 0xf9, 0xde, 0x57, 0xbf, 0xfd, 0xf9, 0x6c, 0xe1,
	0x8e, 0xfc, 0xce, 0xf0, 0x2c, 0xfd, 0x2c, 0xda, 0x98, 0x1f, 0x04, 0x21, 0xf9, 0x04, 0x77, 0x19,
	0x55, 0x2b, 0x2a, 0x6f, 0xfe, 0x43, 0x9b, 0x62, 0xaa, 0x56, 0xce, 0xd4, 0x78, 0xf7, 0xec, 0xc4,
	0xa7, 0xd9, 0x4f, 0x12, 0xac, 0x8e, 0xed, 0xb6, 0x74, 0x8c, 0xb3, 0x4b, 0xbb, 0x74, 0xeb, 0x42,
	0x36, 0xd1, 0xe0, 0x96, 0xdf, 0x17, 0xc8, 0xb7, 0xd1, 0x85, 0x91, 0xa3, 0x6f, 0x24, 0x58, 0x49,
	0x4e, 0x0c, 0xa4, 0xa6, 0xc5, 0x9e, 0x3a, 0x46, 0x4a, 0xe7, 0xdb, 0xd1, 0xf3, 0xe0, 0xf1, 0xdd,
	0xf6, 0x1c, 0x70, 0x09, 0x36, 0xb5, 0x72, 0x86, 0x9e, 0x49, 0xb0, 0x3a, 0x76, 0x57, 0xa4, 0x67,
	0x74, 0xf6, 0x08, 0x29, 0x6d, 0xce, 0x0c, 0x17, 0x9d, 0x7f, 0x2b, 0x24, 0xa8, 0x2a, 0x17, 0x47,
	0xf5, 0x83, 0x04, 0xeb, 0x53, 0xbb, 0x0f, 0xdd, 0x4e, 0x43, 0x36, 0xff, 0xe8, 0x48, 0xeb, 0xc9,
	0xaa, 0x00, 0x79, 0x57, 0xbe, 0x7d, 0x2e, 0x90, 0x67, 0x3b, 0x78, 0x32, 0xca, 0x8e, 0x54, 0x11,
	0x68, 0xa7, 0xa6, 0x78, 0x3a, 0xda, 0xf9, 0x17, 0xca, 0xcb, 0x46, 0xeb, 0x78, 0xd3, 0x68, 0x4b,
	0x4f, 0x7e, 0xa9, 0x16, 0x47, 0xa0, 0xa2, 0x68, 0x76, 0xe0, 0x50, 0xa5, 0x4b, 0xbc, 0x5f, 0xab,
	0x0f, 0x1e, 0x31, 0x16, 0xd0, 0x1d, 0x55, 0x3d, 0x3e, 0x3e, 0x9e, 0x12, 0xaa, 0xf6, 0x80, 0x3d,
	0x52, 0xbb, 0x2e, 0x19, 0xf4, 0xde, 0x0e, 0x5c, 0x9b, 0x1d, 0x91, 0xd0, 0x7b, 0x2b, 0x4d, 0x9d,
	0xa3, 0x11, 0x91, 0x76, 0x7f, 0x94, 0x40, 0xee, 0x12, 0x2f, 0x25, 0x2f, 0xbb, 0x97, 0x26, 0xc7,
	0x52, 0x8b, 0xb7, 0x54, 0x4b, 0x7a, 0xa8, 0xc5, 0x66, 0x7d, 0xe2, 0xda, 0x7e, 0x5f, 0x21, 0x61,
	0x5f, 0xed, 0x63, 0x5f, 0x34, 0x9c, 0x3a, 0x8a, 0xfb, 0xbc, 0xcf, 0xdf, 0xbb, 0x82, 0xfa, 0x6e,
	0x61, 0x71, 0x4f, 0xab, 0xb7, 0xbf, 0x5f, 0x78, 0x63, 0x2f, 0x72, 0xa6, 0xf1, 0xb7, 0x28, 0xc3,
	0x80, 0x8a, 0x88, 0xa8, 0x7c, 0x74, 0x73, 0x97, 0xdb, 0x1c, 0x66, 0x85, 0xf7, 0x5b, 0x7f, 0x07,
	0x00, 0x00, 0xff, 0xff, 0x31, 0x42, 0x70, 0xc3, 0xcf, 0x0f, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// FirestoreAdminClient is the client API for FirestoreAdmin service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type FirestoreAdminClient interface {
	// Creates the specified index.
	// A newly created index's initial state is `CREATING`. On completion of the
	// returned [google.longrunning.Operation][google.longrunning.Operation], the state will be `READY`.
	// If the index already exists, the call will return an `ALREADY_EXISTS`
	// status.
	//
	// During creation, the process could result in an error, in which case the
	// index will move to the `ERROR` state. The process can be recovered by
	// fixing the data that caused the error, removing the index with
	// [delete][google.firestore.admin.v1beta1.FirestoreAdmin.DeleteIndex], then re-creating the index with
	// [create][google.firestore.admin.v1beta1.FirestoreAdmin.CreateIndex].
	//
	// Indexes with a single field cannot be created.
	CreateIndex(ctx context.Context, in *CreateIndexRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Lists the indexes that match the specified filters.
	ListIndexes(ctx context.Context, in *ListIndexesRequest, opts ...grpc.CallOption) (*ListIndexesResponse, error)
	// Gets an index.
	GetIndex(ctx context.Context, in *GetIndexRequest, opts ...grpc.CallOption) (*Index, error)
	// Deletes an index.
	DeleteIndex(ctx context.Context, in *DeleteIndexRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Exports a copy of all or a subset of documents from Google Cloud Firestore
	// to another storage system, such as Google Cloud Storage. Recent updates to
	// documents may not be reflected in the export. The export occurs in the
	// background and its progress can be monitored and managed via the
	// Operation resource that is created. The output of an export may only be
	// used once the associated operation is done. If an export operation is
	// cancelled before completion it may leave partial data behind in Google
	// Cloud Storage.
	ExportDocuments(ctx context.Context, in *ExportDocumentsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Imports documents into Google Cloud Firestore. Existing documents with the
	// same name are overwritten. The import occurs in the background and its
	// progress can be monitored and managed via the Operation resource that is
	// created. If an ImportDocuments operation is cancelled, it is possible
	// that a subset of the data has already been imported to Cloud Firestore.
	ImportDocuments(ctx context.Context, in *ImportDocumentsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type firestoreAdminClient struct {
	cc *grpc.ClientConn
}

func NewFirestoreAdminClient(cc *grpc.ClientConn) FirestoreAdminClient {
	return &firestoreAdminClient{cc}
}

func (c *firestoreAdminClient) CreateIndex(ctx context.Context, in *CreateIndexRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.firestore.admin.v1beta1.FirestoreAdmin/CreateIndex", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreAdminClient) ListIndexes(ctx context.Context, in *ListIndexesRequest, opts ...grpc.CallOption) (*ListIndexesResponse, error) {
	out := new(ListIndexesResponse)
	err := c.cc.Invoke(ctx, "/google.firestore.admin.v1beta1.FirestoreAdmin/ListIndexes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreAdminClient) GetIndex(ctx context.Context, in *GetIndexRequest, opts ...grpc.CallOption) (*Index, error) {
	out := new(Index)
	err := c.cc.Invoke(ctx, "/google.firestore.admin.v1beta1.FirestoreAdmin/GetIndex", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreAdminClient) DeleteIndex(ctx context.Context, in *DeleteIndexRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.firestore.admin.v1beta1.FirestoreAdmin/DeleteIndex", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreAdminClient) ExportDocuments(ctx context.Context, in *ExportDocumentsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.firestore.admin.v1beta1.FirestoreAdmin/ExportDocuments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firestoreAdminClient) ImportDocuments(ctx context.Context, in *ImportDocumentsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.firestore.admin.v1beta1.FirestoreAdmin/ImportDocuments", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// FirestoreAdminServer is the server API for FirestoreAdmin service.
type FirestoreAdminServer interface {
	// Creates the specified index.
	// A newly created index's initial state is `CREATING`. On completion of the
	// returned [google.longrunning.Operation][google.longrunning.Operation], the state will be `READY`.
	// If the index already exists, the call will return an `ALREADY_EXISTS`
	// status.
	//
	// During creation, the process could result in an error, in which case the
	// index will move to the `ERROR` state. The process can be recovered by
	// fixing the data that caused the error, removing the index with
	// [delete][google.firestore.admin.v1beta1.FirestoreAdmin.DeleteIndex], then re-creating the index with
	// [create][google.firestore.admin.v1beta1.FirestoreAdmin.CreateIndex].
	//
	// Indexes with a single field cannot be created.
	CreateIndex(context.Context, *CreateIndexRequest) (*longrunning.Operation, error)
	// Lists the indexes that match the specified filters.
	ListIndexes(context.Context, *ListIndexesRequest) (*ListIndexesResponse, error)
	// Gets an index.
	GetIndex(context.Context, *GetIndexRequest) (*Index, error)
	// Deletes an index.
	DeleteIndex(context.Context, *DeleteIndexRequest) (*empty.Empty, error)
	// Exports a copy of all or a subset of documents from Google Cloud Firestore
	// to another storage system, such as Google Cloud Storage. Recent updates to
	// documents may not be reflected in the export. The export occurs in the
	// background and its progress can be monitored and managed via the
	// Operation resource that is created. The output of an export may only be
	// used once the associated operation is done. If an export operation is
	// cancelled before completion it may leave partial data behind in Google
	// Cloud Storage.
	ExportDocuments(context.Context, *ExportDocumentsRequest) (*longrunning.Operation, error)
	// Imports documents into Google Cloud Firestore. Existing documents with the
	// same name are overwritten. The import occurs in the background and its
	// progress can be monitored and managed via the Operation resource that is
	// created. If an ImportDocuments operation is cancelled, it is possible
	// that a subset of the data has already been imported to Cloud Firestore.
	ImportDocuments(context.Context, *ImportDocumentsRequest) (*longrunning.Operation, error)
}

// UnimplementedFirestoreAdminServer can be embedded to have forward compatible implementations.
type UnimplementedFirestoreAdminServer struct {
}

func (*UnimplementedFirestoreAdminServer) CreateIndex(ctx context.Context, req *CreateIndexRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateIndex not implemented")
}
func (*UnimplementedFirestoreAdminServer) ListIndexes(ctx context.Context, req *ListIndexesRequest) (*ListIndexesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListIndexes not implemented")
}
func (*UnimplementedFirestoreAdminServer) GetIndex(ctx context.Context, req *GetIndexRequest) (*Index, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIndex not implemented")
}
func (*UnimplementedFirestoreAdminServer) DeleteIndex(ctx context.Context, req *DeleteIndexRequest) (*empty.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteIndex not implemented")
}
func (*UnimplementedFirestoreAdminServer) ExportDocuments(ctx context.Context, req *ExportDocumentsRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportDocuments not implemented")
}
func (*UnimplementedFirestoreAdminServer) ImportDocuments(ctx context.Context, req *ImportDocumentsRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportDocuments not implemented")
}

func RegisterFirestoreAdminServer(s *grpc.Server, srv FirestoreAdminServer) {
	s.RegisterService(&_FirestoreAdmin_serviceDesc, srv)
}

func _FirestoreAdmin_CreateIndex_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateIndexRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreAdminServer).CreateIndex(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.firestore.admin.v1beta1.FirestoreAdmin/CreateIndex",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreAdminServer).CreateIndex(ctx, req.(*CreateIndexRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirestoreAdmin_ListIndexes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListIndexesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreAdminServer).ListIndexes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.firestore.admin.v1beta1.FirestoreAdmin/ListIndexes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreAdminServer).ListIndexes(ctx, req.(*ListIndexesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirestoreAdmin_GetIndex_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIndexRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreAdminServer).GetIndex(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.firestore.admin.v1beta1.FirestoreAdmin/GetIndex",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreAdminServer).GetIndex(ctx, req.(*GetIndexRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirestoreAdmin_DeleteIndex_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteIndexRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreAdminServer).DeleteIndex(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.firestore.admin.v1beta1.FirestoreAdmin/DeleteIndex",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreAdminServer).DeleteIndex(ctx, req.(*DeleteIndexRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirestoreAdmin_ExportDocuments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportDocumentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreAdminServer).ExportDocuments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.firestore.admin.v1beta1.FirestoreAdmin/ExportDocuments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreAdminServer).ExportDocuments(ctx, req.(*ExportDocumentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirestoreAdmin_ImportDocuments_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportDocumentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirestoreAdminServer).ImportDocuments(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.firestore.admin.v1beta1.FirestoreAdmin/ImportDocuments",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirestoreAdminServer).ImportDocuments(ctx, req.(*ImportDocumentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _FirestoreAdmin_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.firestore.admin.v1beta1.FirestoreAdmin",
	HandlerType: (*FirestoreAdminServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateIndex",
			Handler:    _FirestoreAdmin_CreateIndex_Handler,
		},
		{
			MethodName: "ListIndexes",
			Handler:    _FirestoreAdmin_ListIndexes_Handler,
		},
		{
			MethodName: "GetIndex",
			Handler:    _FirestoreAdmin_GetIndex_Handler,
		},
		{
			MethodName: "DeleteIndex",
			Handler:    _FirestoreAdmin_DeleteIndex_Handler,
		},
		{
			MethodName: "ExportDocuments",
			Handler:    _FirestoreAdmin_ExportDocuments_Handler,
		},
		{
			MethodName: "ImportDocuments",
			Handler:    _FirestoreAdmin_ImportDocuments_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/firestore/admin/v1beta1/firestore_admin.proto",
}
