// Code generated by protoc-gen-gogo.
// source: cockroach/pkg/roachpb/api.proto
// DO NOT EDIT!

/*
	Package roachpb is a generated protocol buffer package.

	It is generated from these files:
		cockroach/pkg/roachpb/api.proto
		cockroach/pkg/roachpb/app_stats.proto
		cockroach/pkg/roachpb/data.proto
		cockroach/pkg/roachpb/errors.proto
		cockroach/pkg/roachpb/internal.proto
		cockroach/pkg/roachpb/internal_raft.proto
		cockroach/pkg/roachpb/metadata.proto

	It has these top-level messages:
		RangeInfo
		ResponseHeader
		GetRequest
		GetResponse
		PutRequest
		PutResponse
		ConditionalPutRequest
		ConditionalPutResponse
		InitPutRequest
		InitPutResponse
		IncrementRequest
		IncrementResponse
		DeleteRequest
		DeleteResponse
		DeleteRangeRequest
		DeleteRangeResponse
		ScanRequest
		ScanResponse
		ReverseScanRequest
		ReverseScanResponse
		CheckConsistencyRequest
		CheckConsistencyResponse
		BeginTransactionRequest
		BeginTransactionResponse
		EndTransactionRequest
		EndTransactionResponse
		AdminSplitRequest
		AdminSplitResponse
		AdminMergeRequest
		AdminMergeResponse
		AdminTransferLeaseRequest
		AdminTransferLeaseResponse
		AdminChangeReplicasRequest
		AdminChangeReplicasResponse
		RangeLookupRequest
		RangeLookupResponse
		HeartbeatTxnRequest
		HeartbeatTxnResponse
		GCRequest
		GCResponse
		PushTxnRequest
		PushTxnResponse
		QueryTxnRequest
		QueryTxnResponse
		ResolveIntentRequest
		ResolveIntentResponse
		ResolveIntentRangeRequest
		NoopResponse
		NoopRequest
		ResolveIntentRangeResponse
		MergeRequest
		MergeResponse
		TruncateLogRequest
		TruncateLogResponse
		RequestLeaseRequest
		TransferLeaseRequest
		LeaseInfoRequest
		LeaseInfoResponse
		RequestLeaseResponse
		ComputeChecksumRequest
		ComputeChecksumResponse
		DeprecatedVerifyChecksumRequest
		DeprecatedVerifyChecksumResponse
		ExportStorage
		WriteBatchRequest
		WriteBatchResponse
		ExportRequest
		ExportResponse
		ImportRequest
		ImportResponse
		AdminScatterRequest
		AdminScatterResponse
		AddSSTableRequest
		AddSSTableResponse
		RequestUnion
		ResponseUnion
		Header
		BatchRequest
		BatchResponse
		StatementStatistics
		NumericStat
		Span
		Value
		KeyValue
		StoreIdent
		SplitTrigger
		MergeTrigger
		ChangeReplicasTrigger
		ModifiedSpanTrigger
		InternalCommitTrigger
		ObservedTimestamp
		Transaction
		Intent
		Lease
		AbortCacheEntry
		NotLeaseHolderError
		NodeUnavailableError
		RangeNotFoundError
		RangeKeyMismatchError
		ReadWithinUncertaintyIntervalError
		TransactionAbortedError
		TransactionPushError
		TransactionRetryError
		TransactionReplayError
		TransactionStatusError
		WriteIntentError
		WriteTooOldError
		OpRequiresTxnError
		ConditionFailedError
		LeaseRejectedError
		SendError
		AmbiguousResultError
		RaftGroupDeletedError
		ReplicaCorruptionError
		ReplicaTooOldError
		StoreNotFoundError
		ErrorDetail
		ErrPosition
		Error
		UnhandledRetryableError
		HandledRetryableTxnError
		InternalTimeSeriesData
		InternalTimeSeriesSample
		RaftTruncatedState
		RaftTombstone
		RaftSnapshotData
		Attributes
		ReplicationTarget
		ReplicaDescriptor
		ReplicaIdent
		RangeDescriptor
		StoreCapacity
		NodeDescriptor
		StoreDescriptor
		StoreDeadReplicas
		Locality
		Tier
*/
package roachpb

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import cockroach_storage_engine_enginepb "github.com/cockroachdb/cockroach/pkg/storage/engine/enginepb"
import cockroach_util_hlc "github.com/cockroachdb/cockroach/pkg/util/hlc"
import cockroach_util_tracing "github.com/cockroachdb/cockroach/pkg/util/tracing"

import github_com_cockroachdb_cockroach_pkg_util_uuid "github.com/cockroachdb/cockroach/pkg/util/uuid"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// ReadConsistencyType specifies what type of consistency is observed
// during read operations.
type ReadConsistencyType int32

const (
	// CONSISTENT reads are guaranteed to read committed data; the
	// mechanism relies on clocks to determine lease expirations.
	CONSISTENT ReadConsistencyType = 0
	// CONSENSUS requires that reads must achieve consensus. This is a
	// stronger guarantee of consistency than CONSISTENT.
	//
	// TODO(spencer): current unimplemented.
	CONSENSUS ReadConsistencyType = 1
	// INCONSISTENT reads return the latest available, committed values.
	// They are more efficient, but may read stale values as pending
	// intents are ignored.
	INCONSISTENT ReadConsistencyType = 2
)

var ReadConsistencyType_name = map[int32]string{
	0: "CONSISTENT",
	1: "CONSENSUS",
	2: "INCONSISTENT",
}
var ReadConsistencyType_value = map[string]int32{
	"CONSISTENT":   0,
	"CONSENSUS":    1,
	"INCONSISTENT": 2,
}

func (x ReadConsistencyType) Enum() *ReadConsistencyType {
	p := new(ReadConsistencyType)
	*p = x
	return p
}
func (x ReadConsistencyType) String() string {
	return proto.EnumName(ReadConsistencyType_name, int32(x))
}
func (x *ReadConsistencyType) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(ReadConsistencyType_value, data, "ReadConsistencyType")
	if err != nil {
		return err
	}
	*x = ReadConsistencyType(value)
	return nil
}
func (ReadConsistencyType) EnumDescriptor() ([]byte, []int) { return fileDescriptorApi, []int{0} }

// TxnPushType determines what action to take when pushing a transaction.
type PushTxnType int32

const (
	// Push the timestamp forward if possible to accommodate a concurrent reader.
	PUSH_TIMESTAMP PushTxnType = 0
	// Abort the transaction if possible to accommodate a concurrent writer.
	PUSH_ABORT PushTxnType = 1
	// Abort the transaction if it's abandoned, but don't attempt to mutate it
	// otherwise.
	PUSH_TOUCH PushTxnType = 2
	// Deprecated. Use QueryTxn instead.
	PUSH_QUERY PushTxnType = 3
)

var PushTxnType_name = map[int32]string{
	0: "PUSH_TIMESTAMP",
	1: "PUSH_ABORT",
	2: "PUSH_TOUCH",
	3: "PUSH_QUERY",
}
var PushTxnType_value = map[string]int32{
	"PUSH_TIMESTAMP": 0,
	"PUSH_ABORT":     1,
	"PUSH_TOUCH":     2,
	"PUSH_QUERY":     3,
}

func (x PushTxnType) Enum() *PushTxnType {
	p := new(PushTxnType)
	*p = x
	return p
}
func (x PushTxnType) String() string {
	return proto.EnumName(PushTxnType_name, int32(x))
}
func (x *PushTxnType) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(PushTxnType_value, data, "PushTxnType")
	if err != nil {
		return err
	}
	*x = PushTxnType(value)
	return nil
}
func (PushTxnType) EnumDescriptor() ([]byte, []int) { return fileDescriptorApi, []int{1} }

type ExportStorageProvider int32

const (
	ExportStorageProvider_Unknown     ExportStorageProvider = 0
	ExportStorageProvider_LocalFile   ExportStorageProvider = 1
	ExportStorageProvider_Http        ExportStorageProvider = 2
	ExportStorageProvider_S3          ExportStorageProvider = 3
	ExportStorageProvider_GoogleCloud ExportStorageProvider = 4
	ExportStorageProvider_Azure       ExportStorageProvider = 5
)

var ExportStorageProvider_name = map[int32]string{
	0: "Unknown",
	1: "LocalFile",
	2: "Http",
	3: "S3",
	4: "GoogleCloud",
	5: "Azure",
}
var ExportStorageProvider_value = map[string]int32{
	"Unknown":     0,
	"LocalFile":   1,
	"Http":        2,
	"S3":          3,
	"GoogleCloud": 4,
	"Azure":       5,
}

func (x ExportStorageProvider) Enum() *ExportStorageProvider {
	p := new(ExportStorageProvider)
	*p = x
	return p
}
func (x ExportStorageProvider) String() string {
	return proto.EnumName(ExportStorageProvider_name, int32(x))
}
func (x *ExportStorageProvider) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(ExportStorageProvider_value, data, "ExportStorageProvider")
	if err != nil {
		return err
	}
	*x = ExportStorageProvider(value)
	return nil
}
func (ExportStorageProvider) EnumDescriptor() ([]byte, []int) { return fileDescriptorApi, []int{2} }

// RangeInfo describes a range which executed a request. It contains
// the range descriptor and lease information at the time of execution.
type RangeInfo struct {
	Desc  RangeDescriptor `protobuf:"bytes,1,opt,name=desc" json:"desc"`
	Lease Lease           `protobuf:"bytes,2,opt,name=lease" json:"lease"`
}

func (m *RangeInfo) Reset()                    { *m = RangeInfo{} }
func (m *RangeInfo) String() string            { return proto.CompactTextString(m) }
func (*RangeInfo) ProtoMessage()               {}
func (*RangeInfo) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{0} }

// ResponseHeader is returned with every storage node response.
type ResponseHeader struct {
	// txn is non-nil if the request specified a non-nil transaction.
	// The transaction timestamp and/or priority may have been updated,
	// depending on the outcome of the request.
	Txn *Transaction `protobuf:"bytes,3,opt,name=txn" json:"txn,omitempty"`
	// The next span to resume from when a bound on the
	// keys is set through max_span_request_keys in the batch header.
	// ResumeSpan is unset when the entire span of keys have been
	// operated on. The span is set to the original span if the request
	// was ignored because max_span_request_keys was hit due to another
	// request in the batch. For a reverse scan the end_key is updated.
	ResumeSpan *Span `protobuf:"bytes,4,opt,name=resume_span,json=resumeSpan" json:"resume_span,omitempty"`
	// The number of keys operated on.
	NumKeys int64 `protobuf:"varint,5,opt,name=num_keys,json=numKeys" json:"num_keys"`
	// Range or list of ranges used to execute the request. Multiple
	// ranges may be returned for Scan, ReverseScan or DeleteRange.
	RangeInfos []RangeInfo `protobuf:"bytes,6,rep,name=range_infos,json=rangeInfos" json:"range_infos"`
}

func (m *ResponseHeader) Reset()                    { *m = ResponseHeader{} }
func (m *ResponseHeader) String() string            { return proto.CompactTextString(m) }
func (*ResponseHeader) ProtoMessage()               {}
func (*ResponseHeader) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{1} }

// A GetRequest is the argument for the Get() method.
type GetRequest struct {
	Span `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *GetRequest) Reset()                    { *m = GetRequest{} }
func (m *GetRequest) String() string            { return proto.CompactTextString(m) }
func (*GetRequest) ProtoMessage()               {}
func (*GetRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{2} }

// A GetResponse is the return value from the Get() method.
// If the key doesn't exist, returns nil for Value.Bytes.
type GetResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	Value          *Value `protobuf:"bytes,2,opt,name=value" json:"value,omitempty"`
}

func (m *GetResponse) Reset()                    { *m = GetResponse{} }
func (m *GetResponse) String() string            { return proto.CompactTextString(m) }
func (*GetResponse) ProtoMessage()               {}
func (*GetResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{3} }

// A PutRequest is the argument to the Put() method.
type PutRequest struct {
	Span  `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	Value Value `protobuf:"bytes,2,opt,name=value" json:"value"`
	// Specify as true to put the value without a corresponding
	// timestamp. This option should be used with care as it precludes
	// the use of this value with transactions.
	Inline bool `protobuf:"varint,3,opt,name=inline" json:"inline"`
	// NOTE: For internal use only! Set to indicate that the put is
	// writing to virgin keyspace and no reads are necessary to
	// rationalize MVCC.
	Blind bool `protobuf:"varint,4,opt,name=blind" json:"blind"`
}

func (m *PutRequest) Reset()                    { *m = PutRequest{} }
func (m *PutRequest) String() string            { return proto.CompactTextString(m) }
func (*PutRequest) ProtoMessage()               {}
func (*PutRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{4} }

// A PutResponse is the return value from the Put() method.
type PutResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *PutResponse) Reset()                    { *m = PutResponse{} }
func (m *PutResponse) String() string            { return proto.CompactTextString(m) }
func (*PutResponse) ProtoMessage()               {}
func (*PutResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{5} }

// A ConditionalPutRequest is the argument to the ConditionalPut() method.
//
// - Returns true and sets value if exp_value equals existing value.
// - If key doesn't exist and exp_value is nil, sets value.
// - If key exists, but value is empty and exp_value is not nil but empty, sets value.
// - Otherwise, returns error and the actual value of the key in the response.
type ConditionalPutRequest struct {
	Span `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// The value to put.
	Value Value `protobuf:"bytes,2,opt,name=value" json:"value"`
	// Set exp_value.bytes empty to test for non-existence. Specify as nil
	// to indicate there should be no existing entry. This is different
	// from the expectation that the value exists but is empty.
	ExpValue *Value `protobuf:"bytes,3,opt,name=exp_value,json=expValue" json:"exp_value,omitempty"`
	// NOTE: For internal use only! Set to indicate that the put is
	// writing to virgin keyspace and no reads are necessary to
	// rationalize MVCC.
	Blind bool `protobuf:"varint,4,opt,name=blind" json:"blind"`
}

func (m *ConditionalPutRequest) Reset()                    { *m = ConditionalPutRequest{} }
func (m *ConditionalPutRequest) String() string            { return proto.CompactTextString(m) }
func (*ConditionalPutRequest) ProtoMessage()               {}
func (*ConditionalPutRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{6} }

// A ConditionalPutResponse is the return value from the
// ConditionalPut() method.
type ConditionalPutResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *ConditionalPutResponse) Reset()                    { *m = ConditionalPutResponse{} }
func (m *ConditionalPutResponse) String() string            { return proto.CompactTextString(m) }
func (*ConditionalPutResponse) ProtoMessage()               {}
func (*ConditionalPutResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{7} }

// An InitPutRequest is the argument to the InitPut() method.
//
// - If key doesn't exist, sets value.
// - If key exists, returns an error if value != existing value.
type InitPutRequest struct {
	Span  `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	Value Value `protobuf:"bytes,2,opt,name=value" json:"value"`
	// NOTE: For internal use only! Set to indicate that the put is
	// writing to virgin keyspace and no reads are necessary to
	// rationalize MVCC.
	Blind bool `protobuf:"varint,3,opt,name=blind" json:"blind"`
}

func (m *InitPutRequest) Reset()                    { *m = InitPutRequest{} }
func (m *InitPutRequest) String() string            { return proto.CompactTextString(m) }
func (*InitPutRequest) ProtoMessage()               {}
func (*InitPutRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{8} }

// A InitPutResponse is the return value from the InitPut() method.
type InitPutResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *InitPutResponse) Reset()                    { *m = InitPutResponse{} }
func (m *InitPutResponse) String() string            { return proto.CompactTextString(m) }
func (*InitPutResponse) ProtoMessage()               {}
func (*InitPutResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{9} }

// An IncrementRequest is the argument to the Increment() method. It
// increments the value for key, and returns the new value. If no
// value exists for a key, incrementing by 0 is not a noop, but will
// create a zero value. IncrementRequest cannot be called on a key set
// by Put() or ConditionalPut(). Similarly, Put() and ConditionalPut()
// cannot be invoked on an incremented key.
type IncrementRequest struct {
	Span      `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	Increment int64 `protobuf:"varint,2,opt,name=increment" json:"increment"`
}

func (m *IncrementRequest) Reset()                    { *m = IncrementRequest{} }
func (m *IncrementRequest) String() string            { return proto.CompactTextString(m) }
func (*IncrementRequest) ProtoMessage()               {}
func (*IncrementRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{10} }

// An IncrementResponse is the return value from the Increment
// method. The new value after increment is specified in NewValue. If
// the value could not be decoded as specified, Error will be set.
type IncrementResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	NewValue       int64 `protobuf:"varint,2,opt,name=new_value,json=newValue" json:"new_value"`
}

func (m *IncrementResponse) Reset()                    { *m = IncrementResponse{} }
func (m *IncrementResponse) String() string            { return proto.CompactTextString(m) }
func (*IncrementResponse) ProtoMessage()               {}
func (*IncrementResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{11} }

// A DeleteRequest is the argument to the Delete() method.
type DeleteRequest struct {
	Span `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *DeleteRequest) Reset()                    { *m = DeleteRequest{} }
func (m *DeleteRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteRequest) ProtoMessage()               {}
func (*DeleteRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{12} }

// A DeleteResponse is the return value from the Delete() method.
type DeleteResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *DeleteResponse) Reset()                    { *m = DeleteResponse{} }
func (m *DeleteResponse) String() string            { return proto.CompactTextString(m) }
func (*DeleteResponse) ProtoMessage()               {}
func (*DeleteResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{13} }

// A DeleteRangeRequest is the argument to the DeleteRange() method. It
// specifies the range of keys to delete.
type DeleteRangeRequest struct {
	Span `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// return the keys that are deleted in the response.
	ReturnKeys bool `protobuf:"varint,3,opt,name=return_keys,json=returnKeys" json:"return_keys"`
	// delete "inline" keys which are stored without MVCC timestamps. Note that
	// an "inline" DeleteRange will fail if it attempts to delete any keys which
	// contain timestamped (non-inline) values; this option should only be used on
	// keys which are known to store inline values, such as data in cockroach's
	// time series system.
	//
	// Similarly, attempts to delete keys with inline values will fail unless this
	// flag is set to true; the setting must match the data being deleted.
	//
	// Inline values cannot be deleted transactionally; a DeleteRange with
	// "inline" set to true will fail if it is executed within a transaction.
	Inline bool `protobuf:"varint,4,opt,name=inline" json:"inline"`
}

func (m *DeleteRangeRequest) Reset()                    { *m = DeleteRangeRequest{} }
func (m *DeleteRangeRequest) String() string            { return proto.CompactTextString(m) }
func (*DeleteRangeRequest) ProtoMessage()               {}
func (*DeleteRangeRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{14} }

// A DeleteRangeResponse is the return value from the DeleteRange()
// method.
type DeleteRangeResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// All the deleted keys if return_keys is set.
	Keys []Key `protobuf:"bytes,2,rep,name=keys,casttype=Key" json:"keys,omitempty"`
}

func (m *DeleteRangeResponse) Reset()                    { *m = DeleteRangeResponse{} }
func (m *DeleteRangeResponse) String() string            { return proto.CompactTextString(m) }
func (*DeleteRangeResponse) ProtoMessage()               {}
func (*DeleteRangeResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{15} }

// A ScanRequest is the argument to the Scan() method. It specifies the
// start and end keys for an ascending scan of [start,end) and the maximum
// number of results (unbounded if zero).
type ScanRequest struct {
	Span `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *ScanRequest) Reset()                    { *m = ScanRequest{} }
func (m *ScanRequest) String() string            { return proto.CompactTextString(m) }
func (*ScanRequest) ProtoMessage()               {}
func (*ScanRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{16} }

// A ScanResponse is the return value from the Scan() method.
type ScanResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// Empty if no rows were scanned.
	Rows []KeyValue `protobuf:"bytes,2,rep,name=rows" json:"rows"`
}

func (m *ScanResponse) Reset()                    { *m = ScanResponse{} }
func (m *ScanResponse) String() string            { return proto.CompactTextString(m) }
func (*ScanResponse) ProtoMessage()               {}
func (*ScanResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{17} }

// A ReverseScanRequest is the argument to the ReverseScan() method. It specifies the
// start and end keys for a descending scan of [start,end) and the maximum
// number of results (unbounded if zero).
type ReverseScanRequest struct {
	Span `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *ReverseScanRequest) Reset()                    { *m = ReverseScanRequest{} }
func (m *ReverseScanRequest) String() string            { return proto.CompactTextString(m) }
func (*ReverseScanRequest) ProtoMessage()               {}
func (*ReverseScanRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{18} }

// A ReverseScanResponse is the return value from the ReverseScan() method.
type ReverseScanResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// Empty if no rows were scanned.
	Rows []KeyValue `protobuf:"bytes,2,rep,name=rows" json:"rows"`
}

func (m *ReverseScanResponse) Reset()                    { *m = ReverseScanResponse{} }
func (m *ReverseScanResponse) String() string            { return proto.CompactTextString(m) }
func (*ReverseScanResponse) ProtoMessage()               {}
func (*ReverseScanResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{19} }

// A CheckConsistencyRequest is the argument to the CheckConsistency() method.
// It specifies the start and end keys for a span of ranges to which a
// consistency check should be applied. A consistency check on a range involves
// running a ComputeChecksum on the range followed by a storage.CollectChecksum.
type CheckConsistencyRequest struct {
	Span `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// log a diff of inconsistencies if such inconsistencies are found.
	WithDiff bool `protobuf:"varint,2,opt,name=with_diff,json=withDiff" json:"with_diff"`
}

func (m *CheckConsistencyRequest) Reset()                    { *m = CheckConsistencyRequest{} }
func (m *CheckConsistencyRequest) String() string            { return proto.CompactTextString(m) }
func (*CheckConsistencyRequest) ProtoMessage()               {}
func (*CheckConsistencyRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{20} }

// A CheckConsistencyResponse is the return value from the CheckConsistency() method.
// If a replica finds itself to be inconsistent with its lease holder it will panic.
type CheckConsistencyResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *CheckConsistencyResponse) Reset()                    { *m = CheckConsistencyResponse{} }
func (m *CheckConsistencyResponse) String() string            { return proto.CompactTextString(m) }
func (*CheckConsistencyResponse) ProtoMessage()               {}
func (*CheckConsistencyResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{21} }

// A BeginTransactionRequest is the argument to the BeginTransaction() method.
type BeginTransactionRequest struct {
	Span `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *BeginTransactionRequest) Reset()                    { *m = BeginTransactionRequest{} }
func (m *BeginTransactionRequest) String() string            { return proto.CompactTextString(m) }
func (*BeginTransactionRequest) ProtoMessage()               {}
func (*BeginTransactionRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{22} }

// A BeginTransactionResponse is the return value from the BeginTransaction() method.
type BeginTransactionResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *BeginTransactionResponse) Reset()                    { *m = BeginTransactionResponse{} }
func (m *BeginTransactionResponse) String() string            { return proto.CompactTextString(m) }
func (*BeginTransactionResponse) ProtoMessage()               {}
func (*BeginTransactionResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{23} }

// An EndTransactionRequest is the argument to the EndTransaction() method. It
// specifies whether to commit or roll back an extant transaction.
type EndTransactionRequest struct {
	Span `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// False to abort and rollback.
	Commit bool `protobuf:"varint,2,opt,name=commit" json:"commit"`
	// The deadline by which the transaction must commit, if present.
	Deadline *cockroach_util_hlc.Timestamp `protobuf:"bytes,3,opt,name=deadline" json:"deadline,omitempty"`
	// Optional commit triggers. Note that commit triggers are for
	// internal use only and will cause an error if requested through the
	// external-facing KV API.
	InternalCommitTrigger *InternalCommitTrigger `protobuf:"bytes,4,opt,name=internal_commit_trigger,json=internalCommitTrigger" json:"internal_commit_trigger,omitempty"`
	// List of intents written by the transaction.
	IntentSpans []Span `protobuf:"bytes,5,rep,name=intent_spans,json=intentSpans" json:"intent_spans"`
	// Requires that the transaction completes as a 1 phase commit. This
	// guarantees that all writes are to the same range and that no
	// intents are left in the event of an error.
	Require1PC bool `protobuf:"varint,6,opt,name=require_1pc,json=require1pc" json:"require_1pc"`
}

func (m *EndTransactionRequest) Reset()                    { *m = EndTransactionRequest{} }
func (m *EndTransactionRequest) String() string            { return proto.CompactTextString(m) }
func (*EndTransactionRequest) ProtoMessage()               {}
func (*EndTransactionRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{24} }

// An EndTransactionResponse is the return value from the
// EndTransaction() method. The final transaction record is returned
// as part of the response header. In particular, transaction status
// and timestamp will be updated to reflect final committed
// values. Clients may propagate the transaction timestamp as the
// final txn commit timestamp in order to preserve causal ordering
// between subsequent transactions.
type EndTransactionResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// True if the transaction committed on the one phase commit path.
	// This means that all writes which were part of the transaction
	// were written as a single, atomic write batch to just one range.
	OnePhaseCommit bool `protobuf:"varint,4,opt,name=one_phase_commit,json=onePhaseCommit" json:"one_phase_commit"`
}

func (m *EndTransactionResponse) Reset()                    { *m = EndTransactionResponse{} }
func (m *EndTransactionResponse) String() string            { return proto.CompactTextString(m) }
func (*EndTransactionResponse) ProtoMessage()               {}
func (*EndTransactionResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{25} }

// An AdminSplitRequest is the argument to the AdminSplit() method. The
// existing range which contains header.key is split by
// split_key. If split_key is not specified, then this method will
// determine a split key that is roughly halfway through the
// range. The existing range is resized to cover only its start key to
// the split key. The new range created by the split starts at the
// split key and extends to the original range's end key. If split_key
// is known, header.key should also be set to split_key.
//
// New range IDs for each of the split range's replica and a new Raft
// ID are generated by the operation. Split requests are done in the
// context of a distributed transaction which updates range addressing
// records, range metadata and finally, provides a commit trigger to
// update bookkeeping and instantiate the new range on commit.
//
// The new range contains range replicas located on the same stores;
// no range data is moved during this operation. The split can be
// thought of as a mostly logical operation, though some other
// metadata (e.g. sequence cache and range stats must be copied or
// recomputed).
type AdminSplitRequest struct {
	Span     `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	SplitKey Key `protobuf:"bytes,2,opt,name=split_key,json=splitKey,casttype=Key" json:"split_key,omitempty"`
}

func (m *AdminSplitRequest) Reset()                    { *m = AdminSplitRequest{} }
func (m *AdminSplitRequest) String() string            { return proto.CompactTextString(m) }
func (*AdminSplitRequest) ProtoMessage()               {}
func (*AdminSplitRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{26} }

// An AdminSplitResponse is the return value from the AdminSplit()
// method.
type AdminSplitResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *AdminSplitResponse) Reset()                    { *m = AdminSplitResponse{} }
func (m *AdminSplitResponse) String() string            { return proto.CompactTextString(m) }
func (*AdminSplitResponse) ProtoMessage()               {}
func (*AdminSplitResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{27} }

// An AdminMergeRequest is the argument to the AdminMerge() method. A
// merge is performed by calling AdminMerge on the left-hand range of
// two consecutive ranges (i.e. the range which contains keys which
// sort first). This range will be the subsuming range and the right
// hand range will be subsumed. After the merge operation, the
// subsumed range will no longer exist and the subsuming range will
// now encompass all keys from its original start key to the end key
// of the subsumed range. If AdminMerge is called on the final range
// in the key space, it is a noop.
type AdminMergeRequest struct {
	Span `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *AdminMergeRequest) Reset()                    { *m = AdminMergeRequest{} }
func (m *AdminMergeRequest) String() string            { return proto.CompactTextString(m) }
func (*AdminMergeRequest) ProtoMessage()               {}
func (*AdminMergeRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{28} }

// An AdminMergeResponse is the return value from the AdminMerge()
// method.
type AdminMergeResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *AdminMergeResponse) Reset()                    { *m = AdminMergeResponse{} }
func (m *AdminMergeResponse) String() string            { return proto.CompactTextString(m) }
func (*AdminMergeResponse) ProtoMessage()               {}
func (*AdminMergeResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{29} }

// An AdminTransferLeaseRequest is the argument to the AdminTransferLease()
// method. A lease transfer allows an external entity to control the lease
// holder for a range. The target of the lease transfer needs to be a valid
// replica of the range.
type AdminTransferLeaseRequest struct {
	Span   `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	Target StoreID `protobuf:"varint,2,opt,name=target,casttype=StoreID" json:"target"`
}

func (m *AdminTransferLeaseRequest) Reset()                    { *m = AdminTransferLeaseRequest{} }
func (m *AdminTransferLeaseRequest) String() string            { return proto.CompactTextString(m) }
func (*AdminTransferLeaseRequest) ProtoMessage()               {}
func (*AdminTransferLeaseRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{30} }

type AdminTransferLeaseResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *AdminTransferLeaseResponse) Reset()                    { *m = AdminTransferLeaseResponse{} }
func (m *AdminTransferLeaseResponse) String() string            { return proto.CompactTextString(m) }
func (*AdminTransferLeaseResponse) ProtoMessage()               {}
func (*AdminTransferLeaseResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{31} }

// An AdminChangeReplicasRequest is the argument to the AdminChangeReplicas()
// method. A change replicas operation allows adding or removing a set of
// replicas for a range.
type AdminChangeReplicasRequest struct {
	Span       `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	ChangeType ReplicaChangeType   `protobuf:"varint,2,opt,name=change_type,json=changeType,enum=cockroach.roachpb.ReplicaChangeType" json:"change_type"`
	Targets    []ReplicationTarget `protobuf:"bytes,3,rep,name=targets" json:"targets"`
}

func (m *AdminChangeReplicasRequest) Reset()                    { *m = AdminChangeReplicasRequest{} }
func (m *AdminChangeReplicasRequest) String() string            { return proto.CompactTextString(m) }
func (*AdminChangeReplicasRequest) ProtoMessage()               {}
func (*AdminChangeReplicasRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{32} }

type AdminChangeReplicasResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *AdminChangeReplicasResponse) Reset()                    { *m = AdminChangeReplicasResponse{} }
func (m *AdminChangeReplicasResponse) String() string            { return proto.CompactTextString(m) }
func (*AdminChangeReplicasResponse) ProtoMessage()               {}
func (*AdminChangeReplicasResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{33} }

// A RangeLookupRequest is arguments to the RangeLookup() method. A
// forward lookup request returns a range containing the requested
// key. A reverse lookup request returns a range containing the
// previous key of the requested key (e.g., if a requested key is the
// end key of range R, the reverse lookup request returns R).
//
// RangeLookupRequest also specifies the maximum number of range
// descriptors that should be returned, if there are additional
// consecutive addressable ranges. Specify max_ranges > 1 to pre-fill the
// range descriptor cache. The additional ranges are scanned in the same
// direction as lookup (forward v.s. reverse).
type RangeLookupRequest struct {
	Span      `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	MaxRanges int32 `protobuf:"varint,2,opt,name=max_ranges,json=maxRanges" json:"max_ranges"`
	// Use a reverse scan to pre-fill the range descriptor cache instead
	// of an ascending scan.
	Reverse bool `protobuf:"varint,4,opt,name=reverse" json:"reverse"`
}

func (m *RangeLookupRequest) Reset()                    { *m = RangeLookupRequest{} }
func (m *RangeLookupRequest) String() string            { return proto.CompactTextString(m) }
func (*RangeLookupRequest) ProtoMessage()               {}
func (*RangeLookupRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{34} }

// A RangeLookupResponse is the return value from the RangeLookup()
// method. It returns metadata for the range containing the requested
// key, optionally returning the metadata for additional consecutive
// ranges beyond the requested range to pre-fill the range descriptor
// cache.
type RangeLookupResponse struct {
	ResponseHeader   `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	Ranges           []RangeDescriptor `protobuf:"bytes,2,rep,name=ranges" json:"ranges"`
	PrefetchedRanges []RangeDescriptor `protobuf:"bytes,3,rep,name=prefetched_ranges,json=prefetchedRanges" json:"prefetched_ranges"`
}

func (m *RangeLookupResponse) Reset()                    { *m = RangeLookupResponse{} }
func (m *RangeLookupResponse) String() string            { return proto.CompactTextString(m) }
func (*RangeLookupResponse) ProtoMessage()               {}
func (*RangeLookupResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{35} }

// A HeartbeatTxnRequest is arguments to the HeartbeatTxn()
// method. It's sent by transaction coordinators to let the system
// know that the transaction is still ongoing. Note that this
// heartbeat message is different from the heartbeat message in the
// gossip protocol.
type HeartbeatTxnRequest struct {
	Span `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	Now  cockroach_util_hlc.Timestamp `protobuf:"bytes,2,opt,name=now" json:"now"`
}

func (m *HeartbeatTxnRequest) Reset()                    { *m = HeartbeatTxnRequest{} }
func (m *HeartbeatTxnRequest) String() string            { return proto.CompactTextString(m) }
func (*HeartbeatTxnRequest) ProtoMessage()               {}
func (*HeartbeatTxnRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{36} }

// A HeartbeatTxnResponse is the return value from the HeartbeatTxn()
// method. It returns the transaction info in the response header. The
// returned transaction lets the coordinator know the disposition of
// the transaction (i.e. aborted, committed, or pending).
type HeartbeatTxnResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *HeartbeatTxnResponse) Reset()                    { *m = HeartbeatTxnResponse{} }
func (m *HeartbeatTxnResponse) String() string            { return proto.CompactTextString(m) }
func (*HeartbeatTxnResponse) ProtoMessage()               {}
func (*HeartbeatTxnResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{37} }

// A GCRequest is arguments to the GC() method. It's sent by range
// lease holders after scanning range data to find expired MVCC values.
type GCRequest struct {
	Span `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	Keys []GCRequest_GCKey `protobuf:"bytes,3,rep,name=keys" json:"keys"`
	// Threshold is the expiration timestamp.
	Threshold cockroach_util_hlc.Timestamp `protobuf:"bytes,4,opt,name=threshold" json:"threshold"`
	// TxnSpanGCThreshold is the timestamp below which inactive transactions were
	// considered for GC (and thus might have been removed).
	TxnSpanGCThreshold cockroach_util_hlc.Timestamp `protobuf:"bytes,5,opt,name=txn_span_gc_threshold,json=txnSpanGcThreshold" json:"txn_span_gc_threshold"`
}

func (m *GCRequest) Reset()                    { *m = GCRequest{} }
func (m *GCRequest) String() string            { return proto.CompactTextString(m) }
func (*GCRequest) ProtoMessage()               {}
func (*GCRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{38} }

type GCRequest_GCKey struct {
	Key       Key                          `protobuf:"bytes,1,opt,name=key,casttype=Key" json:"key,omitempty"`
	Timestamp cockroach_util_hlc.Timestamp `protobuf:"bytes,2,opt,name=timestamp" json:"timestamp"`
}

func (m *GCRequest_GCKey) Reset()                    { *m = GCRequest_GCKey{} }
func (m *GCRequest_GCKey) String() string            { return proto.CompactTextString(m) }
func (*GCRequest_GCKey) ProtoMessage()               {}
func (*GCRequest_GCKey) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{38, 0} }

// A GCResponse is the return value from the GC() method.
type GCResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *GCResponse) Reset()                    { *m = GCResponse{} }
func (m *GCResponse) String() string            { return proto.CompactTextString(m) }
func (*GCResponse) ProtoMessage()               {}
func (*GCResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{39} }

// A PushTxnRequest is arguments to the PushTxn() method. It's sent by
// readers or writers which have encountered an "intent" laid down by
// another transaction. The goal is to resolve the conflict. Note that
// args.Key should be set to the txn ID of args.PusheeTxn, not
// args.PusherTxn. This RPC is addressed to the range which owns the pushee's
// txn record. If the pusher is not transactional, it must be set to a
// Transaction record with only the Priority present.
//
// Resolution is trivial if the txn which owns the intent has either
// been committed or aborted already. Otherwise, the existing txn can
// either be aborted (for write/write conflicts), or its commit
// timestamp can be moved forward (for read/write conflicts). The
// course of action is determined by the specified push type, and by
// the owning txn's status and priority.
type PushTxnRequest struct {
	Span `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// Transaction which encountered the intent, if applicable. For a
	// non-transactional operation, pusher_txn will be nil. Used to
	// compare priorities and timestamps if priorities are equal.
	PusherTxn Transaction `protobuf:"bytes,2,opt,name=pusher_txn,json=pusherTxn" json:"pusher_txn"`
	// Transaction to be pushed, as specified at the intent which led to
	// the push transaction request. Note that this may not be the most
	// up-to-date value of the transaction record, but will be set or
	// merged as appropriate.
	PusheeTxn cockroach_storage_engine_enginepb.TxnMeta `protobuf:"bytes,3,opt,name=pushee_txn,json=pusheeTxn" json:"pushee_txn"`
	// PushTo is the timestamp just after which PusheeTxn is attempted to be
	// pushed. During conflict resolution, it should be set to the timestamp
	// of the its conflicting write.
	PushTo cockroach_util_hlc.Timestamp `protobuf:"bytes,4,opt,name=push_to,json=pushTo" json:"push_to"`
	// Now holds the timestamp used to compare the last heartbeat of the pushee
	// against. This is necessary since the request header's timestamp does not
	// necessarily advance with the node clock across retries and hence cannot
	// detect abandoned transactions.
	Now cockroach_util_hlc.Timestamp `protobuf:"bytes,5,opt,name=now" json:"now"`
	// Readers set this to PUSH_TIMESTAMP to move pushee_txn's provisional
	// commit timestamp forward. Writers set this to PUSH_ABORT to request
	// that pushee_txn be aborted if possible. Inconsistent readers set
	// this to PUSH_TOUCH to determine whether the pushee can be aborted
	// due to inactivity (based on the now field).
	PushType PushTxnType `protobuf:"varint,6,opt,name=push_type,json=pushType,enum=cockroach.roachpb.PushTxnType" json:"push_type"`
	// Forces the push by overriding the normal checks in PushTxn to
	// either abort or push the timestamp.
	Force bool `protobuf:"varint,7,opt,name=force" json:"force"`
	// Specifies how to interpret priorities on a push. If false, higher
	// priorities are allowed to push txns with lower priorities. If
	// true, txns can only be pushed if the pusher has MaxTxnPriority
	// or the pushee has MinTxnPriority.
	// TODO(spencer): this field is necessary to upgrade from the old
	// priority-based push mechanism. Remove this field at some point.
	NewPriorities bool `protobuf:"varint,8,opt,name=new_priorities,json=newPriorities" json:"new_priorities"`
}

func (m *PushTxnRequest) Reset()                    { *m = PushTxnRequest{} }
func (m *PushTxnRequest) String() string            { return proto.CompactTextString(m) }
func (*PushTxnRequest) ProtoMessage()               {}
func (*PushTxnRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{40} }

// A PushTxnResponse is the return value from the PushTxn() method. It
// returns success and the resulting state of PusheeTxn if the
// conflict was resolved in favor of the caller; the caller should
// subsequently invoke ResolveIntent() on the conflicted key. It
// returns an error otherwise.
type PushTxnResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// pushee_txn is non-nil if the transaction was pushed and contains
	// the current value of the transaction.
	// TODO(tschottdorf): Maybe this can be a TxnMeta instead; probably requires
	// factoring out the new Priority.
	PusheeTxn Transaction `protobuf:"bytes,2,opt,name=pushee_txn,json=pusheeTxn" json:"pushee_txn"`
}

func (m *PushTxnResponse) Reset()                    { *m = PushTxnResponse{} }
func (m *PushTxnResponse) String() string            { return proto.CompactTextString(m) }
func (*PushTxnResponse) ProtoMessage()               {}
func (*PushTxnResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{41} }

// A QueryTxnResponse is arguments to the QueryTxn() method. It's sent
// by transactions which are waiting to push another transaction because
// of conflicting write intents to fetch updates to either the pusher's
// or the pushee's transaction records.
type QueryTxnRequest struct {
	Span `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// Transaction record to query.
	Txn cockroach_storage_engine_enginepb.TxnMeta `protobuf:"bytes,2,opt,name=txn" json:"txn"`
	// If true, the query will not return until there are changes to either the
	// transaction status or priority -OR- to the set of dependent transactions.
	WaitForUpdate bool `protobuf:"varint,3,opt,name=wait_for_update,json=waitForUpdate" json:"wait_for_update"`
	// Set of known dependent transactions.
	KnownWaitingTxns []github_com_cockroachdb_cockroach_pkg_util_uuid.UUID `protobuf:"bytes,4,rep,name=known_waiting_txns,json=knownWaitingTxns,customtype=github.com/cockroachdb/cockroach/pkg/util/uuid.UUID" json:"known_waiting_txns,omitempty"`
}

func (m *QueryTxnRequest) Reset()                    { *m = QueryTxnRequest{} }
func (m *QueryTxnRequest) String() string            { return proto.CompactTextString(m) }
func (*QueryTxnRequest) ProtoMessage()               {}
func (*QueryTxnRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{42} }

// A QueryTxnResponse is the return value from the QueryTxn() method.
type QueryTxnResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// Contains the current state of the queried transaction. If the queried
	// transaction record does not exist, this will be empty.
	QueriedTxn Transaction `protobuf:"bytes,2,opt,name=queried_txn,json=queriedTxn" json:"queried_txn"`
	// Specifies a list of transaction IDs which are waiting on the txn.
	WaitingTxns []github_com_cockroachdb_cockroach_pkg_util_uuid.UUID `protobuf:"bytes,3,rep,name=waiting_txns,json=waitingTxns,customtype=github.com/cockroachdb/cockroach/pkg/util/uuid.UUID" json:"waiting_txns,omitempty"`
}

func (m *QueryTxnResponse) Reset()                    { *m = QueryTxnResponse{} }
func (m *QueryTxnResponse) String() string            { return proto.CompactTextString(m) }
func (*QueryTxnResponse) ProtoMessage()               {}
func (*QueryTxnResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{43} }

// A ResolveIntentRequest is arguments to the ResolveIntent()
// method. It is sent by transaction coordinators after success
// calling PushTxn to clean up write intents: either to remove, commit
// or move them forward in time.
type ResolveIntentRequest struct {
	Span `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// The transaction whose intent is being resolved.
	IntentTxn cockroach_storage_engine_enginepb.TxnMeta `protobuf:"bytes,2,opt,name=intent_txn,json=intentTxn" json:"intent_txn"`
	// The status of the transaction.
	Status TransactionStatus `protobuf:"varint,3,opt,name=status,enum=cockroach.roachpb.TransactionStatus" json:"status"`
	// Optionally poison the sequence cache for the transaction the intent's
	// range.
	Poison bool `protobuf:"varint,4,opt,name=poison" json:"poison"`
}

func (m *ResolveIntentRequest) Reset()                    { *m = ResolveIntentRequest{} }
func (m *ResolveIntentRequest) String() string            { return proto.CompactTextString(m) }
func (*ResolveIntentRequest) ProtoMessage()               {}
func (*ResolveIntentRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{44} }

// A ResolveIntentResponse is the return value from the
// ResolveIntent() method.
type ResolveIntentResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *ResolveIntentResponse) Reset()                    { *m = ResolveIntentResponse{} }
func (m *ResolveIntentResponse) String() string            { return proto.CompactTextString(m) }
func (*ResolveIntentResponse) ProtoMessage()               {}
func (*ResolveIntentResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{45} }

// A ResolveIntentRangeRequest is arguments to the ResolveIntentRange() method.
// It is sent by transaction coordinators after success calling PushTxn to
// clean up write intents: either to remove, commit or move them forward in
// time.
type ResolveIntentRangeRequest struct {
	Span `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// The transaction whose intents are being resolved.
	IntentTxn cockroach_storage_engine_enginepb.TxnMeta `protobuf:"bytes,2,opt,name=intent_txn,json=intentTxn" json:"intent_txn"`
	// The status of the transaction.
	Status TransactionStatus `protobuf:"varint,3,opt,name=status,enum=cockroach.roachpb.TransactionStatus" json:"status"`
	// Optionally poison the sequence cache for the transaction on all ranges
	// on which the intents reside.
	Poison bool `protobuf:"varint,4,opt,name=poison" json:"poison"`
}

func (m *ResolveIntentRangeRequest) Reset()                    { *m = ResolveIntentRangeRequest{} }
func (m *ResolveIntentRangeRequest) String() string            { return proto.CompactTextString(m) }
func (*ResolveIntentRangeRequest) ProtoMessage()               {}
func (*ResolveIntentRangeRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{46} }

// A NoopResponse is the return value from a no-op operation.
type NoopResponse struct {
}

func (m *NoopResponse) Reset()                    { *m = NoopResponse{} }
func (m *NoopResponse) String() string            { return proto.CompactTextString(m) }
func (*NoopResponse) ProtoMessage()               {}
func (*NoopResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{47} }

// A NoopRequest is a no-op.
type NoopRequest struct {
}

func (m *NoopRequest) Reset()                    { *m = NoopRequest{} }
func (m *NoopRequest) String() string            { return proto.CompactTextString(m) }
func (*NoopRequest) ProtoMessage()               {}
func (*NoopRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{48} }

// A ResolveIntentRangeResponse is the return value from the
// ResolveIntent() method.
type ResolveIntentRangeResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *ResolveIntentRangeResponse) Reset()                    { *m = ResolveIntentRangeResponse{} }
func (m *ResolveIntentRangeResponse) String() string            { return proto.CompactTextString(m) }
func (*ResolveIntentRangeResponse) ProtoMessage()               {}
func (*ResolveIntentRangeResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{49} }

// A MergeRequest contains arguments to the Merge() method. It
// specifies a key and a value which should be merged into the
// existing value at that key.
type MergeRequest struct {
	Span  `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	Value Value `protobuf:"bytes,2,opt,name=value" json:"value"`
}

func (m *MergeRequest) Reset()                    { *m = MergeRequest{} }
func (m *MergeRequest) String() string            { return proto.CompactTextString(m) }
func (*MergeRequest) ProtoMessage()               {}
func (*MergeRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{50} }

// MergeResponse is the response to a Merge() operation.
type MergeResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *MergeResponse) Reset()                    { *m = MergeResponse{} }
func (m *MergeResponse) String() string            { return proto.CompactTextString(m) }
func (*MergeResponse) ProtoMessage()               {}
func (*MergeResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{51} }

// TruncateLogRequest is used to remove a prefix of the raft log. While there
// is no requirement for correctness that the raft log truncation be synchronized across
// replicas, it is nice to preserve the property that all replicas of a range are as close
// to identical as possible. The raft leader can also inform decisions about the cutoff point
// with its knowledge of the replicas' acknowledgment status.
type TruncateLogRequest struct {
	Span `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// Log entries < this index are to be discarded.
	Index uint64 `protobuf:"varint,2,opt,name=index" json:"index"`
	// RangeID is used to double check that the correct range is being truncated.
	// The header specifies a span, start and end keys, but not the range id
	// itself. The range may have changed from the one specified in the header
	// in the case of a merge.
	RangeID RangeID `protobuf:"varint,3,opt,name=range_id,json=rangeId,casttype=RangeID" json:"range_id"`
}

func (m *TruncateLogRequest) Reset()                    { *m = TruncateLogRequest{} }
func (m *TruncateLogRequest) String() string            { return proto.CompactTextString(m) }
func (*TruncateLogRequest) ProtoMessage()               {}
func (*TruncateLogRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{52} }

// TruncateLogResponse is the response to a TruncateLog() operation.
type TruncateLogResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *TruncateLogResponse) Reset()                    { *m = TruncateLogResponse{} }
func (m *TruncateLogResponse) String() string            { return proto.CompactTextString(m) }
func (*TruncateLogResponse) ProtoMessage()               {}
func (*TruncateLogResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{53} }

// A RequestLeaseRequest is arguments to the RequestLease()
// method. It is sent by the store on behalf of one of its ranges upon receipt
// of a command requiring a lease when none is found.
type RequestLeaseRequest struct {
	Span  `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	Lease Lease `protobuf:"bytes,2,opt,name=lease" json:"lease"`
	// The previous lease is specified by the caller to verify
	// it has not changed when executing this command.
	PrevLease Lease `protobuf:"bytes,3,opt,name=prev_lease,json=prevLease" json:"prev_lease"`
}

func (m *RequestLeaseRequest) Reset()                    { *m = RequestLeaseRequest{} }
func (m *RequestLeaseRequest) String() string            { return proto.CompactTextString(m) }
func (*RequestLeaseRequest) ProtoMessage()               {}
func (*RequestLeaseRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{54} }

// A TransferLeaseRequest represents the arguments to the TransferLease()
// method. It is sent by a replica that currently holds the range lease and
// wants to transfer it away.
//
// Like a RequestLeaseRequest, this request has the effect of instituting a new
// lease. The difference is that the new lease is allowed to overlap the
// existing one. It is a separate request because the RequestLeaseRequest is
// special - it's not subject to the same replay protection restrictions as
// other requests, instead being protected from replays by the fact that leases
// are not generally allowed to overlap. The TransferLeaseRequest is not
// special in this respect (for example, the proposer of this command is
// checked to have been holding the lease when the proposal was made).
type TransferLeaseRequest struct {
	Span  `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	Lease Lease `protobuf:"bytes,2,opt,name=lease" json:"lease"`
	// The previous lease is specified by the caller to verify
	// it has not changed when executing this command.
	PrevLease Lease `protobuf:"bytes,3,opt,name=prev_lease,json=prevLease" json:"prev_lease"`
}

func (m *TransferLeaseRequest) Reset()                    { *m = TransferLeaseRequest{} }
func (m *TransferLeaseRequest) String() string            { return proto.CompactTextString(m) }
func (*TransferLeaseRequest) ProtoMessage()               {}
func (*TransferLeaseRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{55} }

// LeaseInfoRequest is the argument to the LeaseInfo() method, for getting
// information about a range's lease.
// It's a point request, so it addresses one single range, and returns the lease
// currently in effect for that range.
type LeaseInfoRequest struct {
	Span `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *LeaseInfoRequest) Reset()                    { *m = LeaseInfoRequest{} }
func (m *LeaseInfoRequest) String() string            { return proto.CompactTextString(m) }
func (*LeaseInfoRequest) ProtoMessage()               {}
func (*LeaseInfoRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{56} }

// LeaseInfoResponse is the response to a LeaseInfo() operation.
type LeaseInfoResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// The last lease known by the replica serving the request. It can also be the
	// tentative future lease, if a lease transfer is in progress.
	Lease Lease `protobuf:"bytes,2,opt,name=lease" json:"lease"`
}

func (m *LeaseInfoResponse) Reset()                    { *m = LeaseInfoResponse{} }
func (m *LeaseInfoResponse) String() string            { return proto.CompactTextString(m) }
func (*LeaseInfoResponse) ProtoMessage()               {}
func (*LeaseInfoResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{57} }

// A RequestLeaseResponse is the response to a RequestLease() or TransferLease()
// operation.
type RequestLeaseResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *RequestLeaseResponse) Reset()                    { *m = RequestLeaseResponse{} }
func (m *RequestLeaseResponse) String() string            { return proto.CompactTextString(m) }
func (*RequestLeaseResponse) ProtoMessage()               {}
func (*RequestLeaseResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{58} }

// A ComputeChecksumRequest is arguments to the ComputeChecksum() method, to
// start computing the checksum for the specified range at the snapshot for this
// request command. A response is returned without the checksum. The computed
// checksum is retrieved via a storage.CollectChecksumRequest.
type ComputeChecksumRequest struct {
	Span `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// The version used to pick the checksum method. It allows us to use a
	// consistent checksumming method across replicas.
	Version uint32 `protobuf:"varint,2,opt,name=version" json:"version"`
	// A unique identifier to match a future storage.CollectChecksumRequest with
	// this request.
	ChecksumID github_com_cockroachdb_cockroach_pkg_util_uuid.UUID `protobuf:"bytes,3,opt,name=checksum_id,json=checksumId,customtype=github.com/cockroachdb/cockroach/pkg/util/uuid.UUID" json:"checksum_id"`
	// Compute a checksum along with a snapshot of the entire range, that will be
	// used in logging a diff during checksum verification.
	Snapshot bool `protobuf:"varint,4,opt,name=snapshot" json:"snapshot"`
}

func (m *ComputeChecksumRequest) Reset()                    { *m = ComputeChecksumRequest{} }
func (m *ComputeChecksumRequest) String() string            { return proto.CompactTextString(m) }
func (*ComputeChecksumRequest) ProtoMessage()               {}
func (*ComputeChecksumRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{59} }

// A ComputeChecksumResponse is the response to a ComputeChecksum() operation.
type ComputeChecksumResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *ComputeChecksumResponse) Reset()                    { *m = ComputeChecksumResponse{} }
func (m *ComputeChecksumResponse) String() string            { return proto.CompactTextString(m) }
func (*ComputeChecksumResponse) ProtoMessage()               {}
func (*ComputeChecksumResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{60} }

type DeprecatedVerifyChecksumRequest struct {
	Span `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *DeprecatedVerifyChecksumRequest) Reset()         { *m = DeprecatedVerifyChecksumRequest{} }
func (m *DeprecatedVerifyChecksumRequest) String() string { return proto.CompactTextString(m) }
func (*DeprecatedVerifyChecksumRequest) ProtoMessage()    {}
func (*DeprecatedVerifyChecksumRequest) Descriptor() ([]byte, []int) {
	return fileDescriptorApi, []int{61}
}

type DeprecatedVerifyChecksumResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *DeprecatedVerifyChecksumResponse) Reset()         { *m = DeprecatedVerifyChecksumResponse{} }
func (m *DeprecatedVerifyChecksumResponse) String() string { return proto.CompactTextString(m) }
func (*DeprecatedVerifyChecksumResponse) ProtoMessage()    {}
func (*DeprecatedVerifyChecksumResponse) Descriptor() ([]byte, []int) {
	return fileDescriptorApi, []int{62}
}

type ExportStorage struct {
	Provider          ExportStorageProvider       `protobuf:"varint,1,opt,name=provider,enum=cockroach.roachpb.ExportStorageProvider" json:"provider"`
	LocalFile         ExportStorage_LocalFilePath `protobuf:"bytes,2,opt,name=LocalFile" json:"LocalFile"`
	HttpPath          ExportStorage_Http          `protobuf:"bytes,3,opt,name=HttpPath" json:"HttpPath"`
	GoogleCloudConfig *ExportStorage_GCS          `protobuf:"bytes,4,opt,name=GoogleCloudConfig" json:"GoogleCloudConfig,omitempty"`
	S3Config          *ExportStorage_S3           `protobuf:"bytes,5,opt,name=S3Config" json:"S3Config,omitempty"`
	AzureConfig       *ExportStorage_Azure        `protobuf:"bytes,6,opt,name=AzureConfig" json:"AzureConfig,omitempty"`
}

func (m *ExportStorage) Reset()                    { *m = ExportStorage{} }
func (m *ExportStorage) String() string            { return proto.CompactTextString(m) }
func (*ExportStorage) ProtoMessage()               {}
func (*ExportStorage) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{63} }

type ExportStorage_LocalFilePath struct {
	Path string `protobuf:"bytes,1,opt,name=path" json:"path"`
}

func (m *ExportStorage_LocalFilePath) Reset()         { *m = ExportStorage_LocalFilePath{} }
func (m *ExportStorage_LocalFilePath) String() string { return proto.CompactTextString(m) }
func (*ExportStorage_LocalFilePath) ProtoMessage()    {}
func (*ExportStorage_LocalFilePath) Descriptor() ([]byte, []int) {
	return fileDescriptorApi, []int{63, 0}
}

type ExportStorage_Http struct {
	BaseUri string `protobuf:"bytes,1,opt,name=baseUri" json:"baseUri"`
}

func (m *ExportStorage_Http) Reset()                    { *m = ExportStorage_Http{} }
func (m *ExportStorage_Http) String() string            { return proto.CompactTextString(m) }
func (*ExportStorage_Http) ProtoMessage()               {}
func (*ExportStorage_Http) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{63, 1} }

type ExportStorage_S3 struct {
	Bucket    string `protobuf:"bytes,1,opt,name=bucket" json:"bucket"`
	Prefix    string `protobuf:"bytes,2,opt,name=prefix" json:"prefix"`
	AccessKey string `protobuf:"bytes,3,opt,name=access_key,json=accessKey" json:"access_key"`
	Secret    string `protobuf:"bytes,4,opt,name=secret" json:"secret"`
	TempToken string `protobuf:"bytes,5,opt,name=temp_token,json=tempToken" json:"temp_token"`
}

func (m *ExportStorage_S3) Reset()                    { *m = ExportStorage_S3{} }
func (m *ExportStorage_S3) String() string            { return proto.CompactTextString(m) }
func (*ExportStorage_S3) ProtoMessage()               {}
func (*ExportStorage_S3) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{63, 2} }

type ExportStorage_GCS struct {
	Bucket string `protobuf:"bytes,1,opt,name=bucket" json:"bucket"`
	Prefix string `protobuf:"bytes,2,opt,name=prefix" json:"prefix"`
}

func (m *ExportStorage_GCS) Reset()                    { *m = ExportStorage_GCS{} }
func (m *ExportStorage_GCS) String() string            { return proto.CompactTextString(m) }
func (*ExportStorage_GCS) ProtoMessage()               {}
func (*ExportStorage_GCS) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{63, 3} }

type ExportStorage_Azure struct {
	Container   string `protobuf:"bytes,1,opt,name=container" json:"container"`
	Prefix      string `protobuf:"bytes,2,opt,name=prefix" json:"prefix"`
	AccountName string `protobuf:"bytes,3,opt,name=account_name,json=accountName" json:"account_name"`
	AccountKey  string `protobuf:"bytes,4,opt,name=account_key,json=accountKey" json:"account_key"`
}

func (m *ExportStorage_Azure) Reset()                    { *m = ExportStorage_Azure{} }
func (m *ExportStorage_Azure) String() string            { return proto.CompactTextString(m) }
func (*ExportStorage_Azure) ProtoMessage()               {}
func (*ExportStorage_Azure) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{63, 4} }

// WriteBatchRequest is arguments to the WriteBatch() method, to apply the
// operations encoded in a BatchRepr.
type WriteBatchRequest struct {
	Span `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// The span of keys encoded in data, duplicated because the header span can
	// be modified by DistSender and we use this one to fail fast.
	DataSpan Span `protobuf:"bytes,2,opt,name=data_span,json=dataSpan" json:"data_span"`
	// A BatchRepr, the serialized form of a RocksDB Batch.
	Data []byte `protobuf:"bytes,3,opt,name=data" json:"data,omitempty"`
}

func (m *WriteBatchRequest) Reset()                    { *m = WriteBatchRequest{} }
func (m *WriteBatchRequest) String() string            { return proto.CompactTextString(m) }
func (*WriteBatchRequest) ProtoMessage()               {}
func (*WriteBatchRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{64} }

// WriteBatchResponse is the response to a WriteBatch() operation.
type WriteBatchResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *WriteBatchResponse) Reset()                    { *m = WriteBatchResponse{} }
func (m *WriteBatchResponse) String() string            { return proto.CompactTextString(m) }
func (*WriteBatchResponse) ProtoMessage()               {}
func (*WriteBatchResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{65} }

// ExportRequest is the argument to the Export() method, to dump a keyrange into
// files under a basepath.
type ExportRequest struct {
	Span      `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	Storage   ExportStorage                `protobuf:"bytes,2,opt,name=storage" json:"storage"`
	StartTime cockroach_util_hlc.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime" json:"start_time"`
}

func (m *ExportRequest) Reset()                    { *m = ExportRequest{} }
func (m *ExportRequest) String() string            { return proto.CompactTextString(m) }
func (*ExportRequest) ProtoMessage()               {}
func (*ExportRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{66} }

// ExportResponse is the response to an Export() operation.
type ExportResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	Files          []ExportResponse_File `protobuf:"bytes,2,rep,name=files" json:"files"`
}

func (m *ExportResponse) Reset()                    { *m = ExportResponse{} }
func (m *ExportResponse) String() string            { return proto.CompactTextString(m) }
func (*ExportResponse) ProtoMessage()               {}
func (*ExportResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{67} }

// File describes a keyrange that has been dumped to a file at the given
// path.
type ExportResponse_File struct {
	Span     Span   `protobuf:"bytes,1,opt,name=span" json:"span"`
	Path     string `protobuf:"bytes,2,opt,name=path" json:"path"`
	DataSize int64  `protobuf:"varint,3,opt,name=data_size,json=dataSize" json:"data_size"`
	Sha512   []byte `protobuf:"bytes,5,opt,name=sha512" json:"sha512,omitempty"`
}

func (m *ExportResponse_File) Reset()                    { *m = ExportResponse_File{} }
func (m *ExportResponse_File) String() string            { return proto.CompactTextString(m) }
func (*ExportResponse_File) ProtoMessage()               {}
func (*ExportResponse_File) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{67, 0} }

// ImportRequest is the argument to the Import() method, to bulk load key/value
// entries.
type ImportRequest struct {
	Span `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	// Files contains an ordered list of files, each containing kv entries to
	// import. Entries in later files with the same key override earlier ones.
	Files []ImportRequest_File `protobuf:"bytes,2,rep,name=files" json:"files"`
	// DataSpan is the pre-rewrite keyrange of the data in `Files`.
	DataSpan Span `protobuf:"bytes,3,opt,name=data_span,json=dataSpan" json:"data_span"`
	// Rekeys contains the descriptors for the data being Imported and the
	// previous ID for each (which is the ID used in the source data pointed to by
	// `files`).
	// TODO(dan): This field is a superset of the information represented by
	// `key_rewrites` and will supercede it once rekeying of interleaved tables is
	// fixed.
	Rekeys []ImportRequest_TableRekey `protobuf:"bytes,5,rep,name=rekeys" json:"rekeys"`
}

func (m *ImportRequest) Reset()                    { *m = ImportRequest{} }
func (m *ImportRequest) String() string            { return proto.CompactTextString(m) }
func (*ImportRequest) ProtoMessage()               {}
func (*ImportRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{68} }

type ImportRequest_File struct {
	Dir    ExportStorage `protobuf:"bytes,1,opt,name=dir" json:"dir"`
	Path   string        `protobuf:"bytes,2,opt,name=path" json:"path"`
	Sha512 []byte        `protobuf:"bytes,4,opt,name=sha512" json:"sha512,omitempty"`
}

func (m *ImportRequest_File) Reset()                    { *m = ImportRequest_File{} }
func (m *ImportRequest_File) String() string            { return proto.CompactTextString(m) }
func (*ImportRequest_File) ProtoMessage()               {}
func (*ImportRequest_File) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{68, 0} }

type ImportRequest_TableRekey struct {
	// OldID is the previous ID of `new_desc`.
	OldID uint32 `protobuf:"varint,1,opt,name=old_id,json=oldId" json:"old_id"`
	// NewDesc is an encoded Descriptor message.
	NewDesc []byte `protobuf:"bytes,2,opt,name=new_desc,json=newDesc" json:"new_desc,omitempty"`
}

func (m *ImportRequest_TableRekey) Reset()                    { *m = ImportRequest_TableRekey{} }
func (m *ImportRequest_TableRekey) String() string            { return proto.CompactTextString(m) }
func (*ImportRequest_TableRekey) ProtoMessage()               {}
func (*ImportRequest_TableRekey) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{68, 1} }

// ImportResponse is the response to a Import() operation.
type ImportResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	DataSize       int64 `protobuf:"varint,2,opt,name=data_size,json=dataSize" json:"data_size"`
}

func (m *ImportResponse) Reset()                    { *m = ImportResponse{} }
func (m *ImportResponse) String() string            { return proto.CompactTextString(m) }
func (*ImportResponse) ProtoMessage()               {}
func (*ImportResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{69} }

// AdminScatterRequest is the argument to the AdminScatter() method, which moves
// replicas and leaseholders for a selection of ranges. Scatter is best-effort;
// ranges that cannot be moved will include an error detail in the response and
// won't fail the request.
type AdminScatterRequest struct {
	Span `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *AdminScatterRequest) Reset()                    { *m = AdminScatterRequest{} }
func (m *AdminScatterRequest) String() string            { return proto.CompactTextString(m) }
func (*AdminScatterRequest) ProtoMessage()               {}
func (*AdminScatterRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{70} }

// ScatterResponse is the response to a Scatter() operation.
type AdminScatterResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	Ranges         []AdminScatterResponse_Range `protobuf:"bytes,2,rep,name=ranges" json:"ranges"`
}

func (m *AdminScatterResponse) Reset()                    { *m = AdminScatterResponse{} }
func (m *AdminScatterResponse) String() string            { return proto.CompactTextString(m) }
func (*AdminScatterResponse) ProtoMessage()               {}
func (*AdminScatterResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{71} }

type AdminScatterResponse_Range struct {
	Span Span `protobuf:"bytes,1,opt,name=span" json:"span"`
	// Error will be nil if this range was successfully scattered.
	Error *Error `protobuf:"bytes,2,opt,name=error" json:"error,omitempty"`
}

func (m *AdminScatterResponse_Range) Reset()         { *m = AdminScatterResponse_Range{} }
func (m *AdminScatterResponse_Range) String() string { return proto.CompactTextString(m) }
func (*AdminScatterResponse_Range) ProtoMessage()    {}
func (*AdminScatterResponse_Range) Descriptor() ([]byte, []int) {
	return fileDescriptorApi, []int{71, 0}
}

// AddSSTableRequest is arguments to the AddSSTable() method, to link a file
// into the RocksDB log-structured merge-tree.
type AddSSTableRequest struct {
	Span `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	Data []byte `protobuf:"bytes,2,opt,name=data" json:"data,omitempty"`
}

func (m *AddSSTableRequest) Reset()                    { *m = AddSSTableRequest{} }
func (m *AddSSTableRequest) String() string            { return proto.CompactTextString(m) }
func (*AddSSTableRequest) ProtoMessage()               {}
func (*AddSSTableRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{72} }

// AddSSTableResponse is the response to a AddSSTable() operation.
type AddSSTableResponse struct {
	ResponseHeader `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
}

func (m *AddSSTableResponse) Reset()                    { *m = AddSSTableResponse{} }
func (m *AddSSTableResponse) String() string            { return proto.CompactTextString(m) }
func (*AddSSTableResponse) ProtoMessage()               {}
func (*AddSSTableResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{73} }

// A RequestUnion contains exactly one of the optional requests.
// The values added here must match those in ResponseUnion.
//
// WARNING: Do not remove fields from RequestUnion. Instead, remove
// all non-header fields from the request message and prepend its
// name with "Deprecated". See DeprecatedVerifyChecksumRequest for an
// example.
//
// Be cautious about deprecating fields as doing so can lead to inconsistencies
// between replicas.
type RequestUnion struct {
	Get                      *GetRequest                      `protobuf:"bytes,1,opt,name=get" json:"get,omitempty"`
	Put                      *PutRequest                      `protobuf:"bytes,2,opt,name=put" json:"put,omitempty"`
	ConditionalPut           *ConditionalPutRequest           `protobuf:"bytes,3,opt,name=conditional_put,json=conditionalPut" json:"conditional_put,omitempty"`
	Increment                *IncrementRequest                `protobuf:"bytes,4,opt,name=increment" json:"increment,omitempty"`
	Delete                   *DeleteRequest                   `protobuf:"bytes,5,opt,name=delete" json:"delete,omitempty"`
	DeleteRange              *DeleteRangeRequest              `protobuf:"bytes,6,opt,name=delete_range,json=deleteRange" json:"delete_range,omitempty"`
	Scan                     *ScanRequest                     `protobuf:"bytes,7,opt,name=scan" json:"scan,omitempty"`
	BeginTransaction         *BeginTransactionRequest         `protobuf:"bytes,8,opt,name=begin_transaction,json=beginTransaction" json:"begin_transaction,omitempty"`
	EndTransaction           *EndTransactionRequest           `protobuf:"bytes,9,opt,name=end_transaction,json=endTransaction" json:"end_transaction,omitempty"`
	AdminSplit               *AdminSplitRequest               `protobuf:"bytes,10,opt,name=admin_split,json=adminSplit" json:"admin_split,omitempty"`
	AdminMerge               *AdminMergeRequest               `protobuf:"bytes,11,opt,name=admin_merge,json=adminMerge" json:"admin_merge,omitempty"`
	AdminTransferLease       *AdminTransferLeaseRequest       `protobuf:"bytes,29,opt,name=admin_transfer_lease,json=adminTransferLease" json:"admin_transfer_lease,omitempty"`
	AdminChangeReplicas      *AdminChangeReplicasRequest      `protobuf:"bytes,35,opt,name=admin_change_replicas,json=adminChangeReplicas" json:"admin_change_replicas,omitempty"`
	HeartbeatTxn             *HeartbeatTxnRequest             `protobuf:"bytes,12,opt,name=heartbeat_txn,json=heartbeatTxn" json:"heartbeat_txn,omitempty"`
	Gc                       *GCRequest                       `protobuf:"bytes,13,opt,name=gc" json:"gc,omitempty"`
	PushTxn                  *PushTxnRequest                  `protobuf:"bytes,14,opt,name=push_txn,json=pushTxn" json:"push_txn,omitempty"`
	RangeLookup              *RangeLookupRequest              `protobuf:"bytes,15,opt,name=range_lookup,json=rangeLookup" json:"range_lookup,omitempty"`
	ResolveIntent            *ResolveIntentRequest            `protobuf:"bytes,16,opt,name=resolve_intent,json=resolveIntent" json:"resolve_intent,omitempty"`
	ResolveIntentRange       *ResolveIntentRangeRequest       `protobuf:"bytes,17,opt,name=resolve_intent_range,json=resolveIntentRange" json:"resolve_intent_range,omitempty"`
	Merge                    *MergeRequest                    `protobuf:"bytes,18,opt,name=merge" json:"merge,omitempty"`
	TruncateLog              *TruncateLogRequest              `protobuf:"bytes,19,opt,name=truncate_log,json=truncateLog" json:"truncate_log,omitempty"`
	RequestLease             *RequestLeaseRequest             `protobuf:"bytes,20,opt,name=request_lease,json=requestLease" json:"request_lease,omitempty"`
	ReverseScan              *ReverseScanRequest              `protobuf:"bytes,21,opt,name=reverse_scan,json=reverseScan" json:"reverse_scan,omitempty"`
	ComputeChecksum          *ComputeChecksumRequest          `protobuf:"bytes,22,opt,name=compute_checksum,json=computeChecksum" json:"compute_checksum,omitempty"`
	DeprecatedVerifyChecksum *DeprecatedVerifyChecksumRequest `protobuf:"bytes,23,opt,name=deprecated_verify_checksum,json=deprecatedVerifyChecksum" json:"deprecated_verify_checksum,omitempty"`
	CheckConsistency         *CheckConsistencyRequest         `protobuf:"bytes,24,opt,name=check_consistency,json=checkConsistency" json:"check_consistency,omitempty"`
	Noop                     *NoopRequest                     `protobuf:"bytes,25,opt,name=noop" json:"noop,omitempty"`
	InitPut                  *InitPutRequest                  `protobuf:"bytes,26,opt,name=init_put,json=initPut" json:"init_put,omitempty"`
	TransferLease            *TransferLeaseRequest            `protobuf:"bytes,28,opt,name=transfer_lease,json=transferLease" json:"transfer_lease,omitempty"`
	LeaseInfo                *LeaseInfoRequest                `protobuf:"bytes,30,opt,name=lease_info,json=leaseInfo" json:"lease_info,omitempty"`
	WriteBatch               *WriteBatchRequest               `protobuf:"bytes,31,opt,name=write_batch,json=writeBatch" json:"write_batch,omitempty"`
	Export                   *ExportRequest                   `protobuf:"bytes,32,opt,name=export" json:"export,omitempty"`
	Import                   *ImportRequest                   `protobuf:"bytes,34,opt,name=import" json:"import,omitempty"`
	QueryTxn                 *QueryTxnRequest                 `protobuf:"bytes,33,opt,name=query_txn,json=queryTxn" json:"query_txn,omitempty"`
	AdminScatter             *AdminScatterRequest             `protobuf:"bytes,36,opt,name=admin_scatter,json=adminScatter" json:"admin_scatter,omitempty"`
	AddSstable               *AddSSTableRequest               `protobuf:"bytes,37,opt,name=add_sstable,json=addSstable" json:"add_sstable,omitempty"`
}

func (m *RequestUnion) Reset()                    { *m = RequestUnion{} }
func (m *RequestUnion) String() string            { return proto.CompactTextString(m) }
func (*RequestUnion) ProtoMessage()               {}
func (*RequestUnion) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{74} }

// A ResponseUnion contains exactly one of the optional responses.
// The values added here must match those in RequestUnion.
//
// WARNING: Do not remove fields from ResponseUnion. Instead, remove
// all non-header fields from the response message and prepend its
// name with "Deprecated". See DeprecatedVerifyChecksumResponse for an
// example.
type ResponseUnion struct {
	Get                      *GetResponse                      `protobuf:"bytes,1,opt,name=get" json:"get,omitempty"`
	Put                      *PutResponse                      `protobuf:"bytes,2,opt,name=put" json:"put,omitempty"`
	ConditionalPut           *ConditionalPutResponse           `protobuf:"bytes,3,opt,name=conditional_put,json=conditionalPut" json:"conditional_put,omitempty"`
	Increment                *IncrementResponse                `protobuf:"bytes,4,opt,name=increment" json:"increment,omitempty"`
	Delete                   *DeleteResponse                   `protobuf:"bytes,5,opt,name=delete" json:"delete,omitempty"`
	DeleteRange              *DeleteRangeResponse              `protobuf:"bytes,6,opt,name=delete_range,json=deleteRange" json:"delete_range,omitempty"`
	Scan                     *ScanResponse                     `protobuf:"bytes,7,opt,name=scan" json:"scan,omitempty"`
	BeginTransaction         *BeginTransactionResponse         `protobuf:"bytes,8,opt,name=begin_transaction,json=beginTransaction" json:"begin_transaction,omitempty"`
	EndTransaction           *EndTransactionResponse           `protobuf:"bytes,9,opt,name=end_transaction,json=endTransaction" json:"end_transaction,omitempty"`
	AdminSplit               *AdminSplitResponse               `protobuf:"bytes,10,opt,name=admin_split,json=adminSplit" json:"admin_split,omitempty"`
	AdminMerge               *AdminMergeResponse               `protobuf:"bytes,11,opt,name=admin_merge,json=adminMerge" json:"admin_merge,omitempty"`
	AdminTransferLease       *AdminTransferLeaseResponse       `protobuf:"bytes,29,opt,name=admin_transfer_lease,json=adminTransferLease" json:"admin_transfer_lease,omitempty"`
	AdminChangeReplicas      *AdminChangeReplicasResponse      `protobuf:"bytes,35,opt,name=admin_change_replicas,json=adminChangeReplicas" json:"admin_change_replicas,omitempty"`
	HeartbeatTxn             *HeartbeatTxnResponse             `protobuf:"bytes,12,opt,name=heartbeat_txn,json=heartbeatTxn" json:"heartbeat_txn,omitempty"`
	Gc                       *GCResponse                       `protobuf:"bytes,13,opt,name=gc" json:"gc,omitempty"`
	PushTxn                  *PushTxnResponse                  `protobuf:"bytes,14,opt,name=push_txn,json=pushTxn" json:"push_txn,omitempty"`
	RangeLookup              *RangeLookupResponse              `protobuf:"bytes,15,opt,name=range_lookup,json=rangeLookup" json:"range_lookup,omitempty"`
	ResolveIntent            *ResolveIntentResponse            `protobuf:"bytes,16,opt,name=resolve_intent,json=resolveIntent" json:"resolve_intent,omitempty"`
	ResolveIntentRange       *ResolveIntentRangeResponse       `protobuf:"bytes,17,opt,name=resolve_intent_range,json=resolveIntentRange" json:"resolve_intent_range,omitempty"`
	Merge                    *MergeResponse                    `protobuf:"bytes,18,opt,name=merge" json:"merge,omitempty"`
	TruncateLog              *TruncateLogResponse              `protobuf:"bytes,19,opt,name=truncate_log,json=truncateLog" json:"truncate_log,omitempty"`
	RequestLease             *RequestLeaseResponse             `protobuf:"bytes,20,opt,name=request_lease,json=requestLease" json:"request_lease,omitempty"`
	ReverseScan              *ReverseScanResponse              `protobuf:"bytes,21,opt,name=reverse_scan,json=reverseScan" json:"reverse_scan,omitempty"`
	ComputeChecksum          *ComputeChecksumResponse          `protobuf:"bytes,22,opt,name=compute_checksum,json=computeChecksum" json:"compute_checksum,omitempty"`
	DeprecatedVerifyChecksum *DeprecatedVerifyChecksumResponse `protobuf:"bytes,23,opt,name=deprecated_verify_checksum,json=deprecatedVerifyChecksum" json:"deprecated_verify_checksum,omitempty"`
	CheckConsistency         *CheckConsistencyResponse         `protobuf:"bytes,24,opt,name=check_consistency,json=checkConsistency" json:"check_consistency,omitempty"`
	Noop                     *NoopResponse                     `protobuf:"bytes,25,opt,name=noop" json:"noop,omitempty"`
	InitPut                  *InitPutResponse                  `protobuf:"bytes,26,opt,name=init_put,json=initPut" json:"init_put,omitempty"`
	LeaseInfo                *LeaseInfoResponse                `protobuf:"bytes,30,opt,name=lease_info,json=leaseInfo" json:"lease_info,omitempty"`
	WriteBatch               *WriteBatchResponse               `protobuf:"bytes,31,opt,name=write_batch,json=writeBatch" json:"write_batch,omitempty"`
	Export                   *ExportResponse                   `protobuf:"bytes,32,opt,name=export" json:"export,omitempty"`
	Import                   *ImportResponse                   `protobuf:"bytes,34,opt,name=import" json:"import,omitempty"`
	QueryTxn                 *QueryTxnResponse                 `protobuf:"bytes,33,opt,name=query_txn,json=queryTxn" json:"query_txn,omitempty"`
	AdminScatter             *AdminScatterResponse             `protobuf:"bytes,36,opt,name=admin_scatter,json=adminScatter" json:"admin_scatter,omitempty"`
	AddSstable               *AddSSTableResponse               `protobuf:"bytes,37,opt,name=add_sstable,json=addSstable" json:"add_sstable,omitempty"`
}

func (m *ResponseUnion) Reset()                    { *m = ResponseUnion{} }
func (m *ResponseUnion) String() string            { return proto.CompactTextString(m) }
func (*ResponseUnion) ProtoMessage()               {}
func (*ResponseUnion) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{75} }

// A Header is attached to a BatchRequest, encapsulating routing and auxiliary
// information required for executing it.
type Header struct {
	// timestamp specifies time at which read or writes should be
	// performed. If the timestamp is set to zero value, its value
	// is initialized to the wall time of the receiving node.
	Timestamp cockroach_util_hlc.Timestamp `protobuf:"bytes,1,opt,name=timestamp" json:"timestamp"`
	// replica specifies the destination of the request.
	Replica ReplicaDescriptor `protobuf:"bytes,2,opt,name=replica" json:"replica"`
	// range_id specifies the ID of the Raft consensus group which the key
	// range belongs to. This is used by the receiving node to route the
	// request to the correct range.
	RangeID RangeID `protobuf:"varint,3,opt,name=range_id,json=rangeId,casttype=RangeID" json:"range_id"`
	// user_priority allows any command's priority to be biased from the
	// default random priority. It specifies a multiple. If set to 0.5,
	// the chosen priority will be 1/2x as likely to beat any default
	// random priority. If set to 1, a default random priority is
	// chosen. If set to 2, the chosen priority will be 2x as likely to
	// beat any default random priority, and so on. As a special case, 0
	// priority is treated the same as 1. This value is ignored if txn
	// is specified. The min and max user priorities are set via
	// MinUserPriority and MaxUserPriority in data.go.
	UserPriority UserPriority `protobuf:"fixed64,4,opt,name=user_priority,json=userPriority,casttype=UserPriority" json:"user_priority"`
	// txn is set non-nil if a transaction is underway. To start a txn,
	// the first request should set this field to non-nil with name and
	// isolation level set as desired. The response will contain the
	// fully-initialized transaction with txn ID, priority, initial
	// timestamp, and maximum timestamp.
	Txn *Transaction `protobuf:"bytes,5,opt,name=txn" json:"txn,omitempty"`
	// read_consistency specifies the consistency for read
	// operations. The default is CONSISTENT. This value is ignored for
	// write operations.
	ReadConsistency ReadConsistencyType `protobuf:"varint,6,opt,name=read_consistency,json=readConsistency,enum=cockroach.roachpb.ReadConsistencyType" json:"read_consistency"`
	// If set to a non-zero value, it limits the total number of keys touched
	// by span requests in the batch. Span requests are requests like
	// Scan, ReverseScan, and DelRange. If two requests touch the
	// same key it is double counted.
	//
	// If a batch limit is used with Scan requests, the spans for the requests
	// must be non-overlapping and in increasing order.
	//
	// If a batch limit is used with ReverseScan requests, the spans for the
	// requests must be non-overlapping and in decreasing order.
	MaxSpanRequestKeys int64 `protobuf:"varint,8,opt,name=max_span_request_keys,json=maxSpanRequestKeys" json:"max_span_request_keys"`
	// If set, all of the spans in the batch are distinct. Note that the
	// calculation of distinct spans does not include intents in an
	// EndTransactionRequest. Currently set conservatively: a request
	// might be composed of distinct spans yet have this field set to
	// false.
	DistinctSpans bool `protobuf:"varint,9,opt,name=distinct_spans,json=distinctSpans" json:"distinct_spans"`
	// If set, return_range_info causes RangeInfo details to be returned with
	// each ResponseHeader.
	ReturnRangeInfo bool `protobuf:"varint,10,opt,name=return_range_info,json=returnRangeInfo" json:"return_range_info"`
	// gateway_node_id is the ID of the gateway node where the request originated.
	GatewayNodeID NodeID `protobuf:"varint,11,opt,name=gateway_node_id,json=gatewayNodeId,casttype=NodeID" json:"gateway_node_id"`
}

func (m *Header) Reset()                    { *m = Header{} }
func (m *Header) String() string            { return proto.CompactTextString(m) }
func (*Header) ProtoMessage()               {}
func (*Header) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{76} }

// A BatchRequest contains one or more requests to be executed in
// parallel, or if applicable (based on write-only commands and
// range-locality), as a single update.
type BatchRequest struct {
	Header   `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	Requests []RequestUnion `protobuf:"bytes,2,rep,name=requests" json:"requests"`
}

func (m *BatchRequest) Reset()                    { *m = BatchRequest{} }
func (*BatchRequest) ProtoMessage()               {}
func (*BatchRequest) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{77} }

// A BatchResponse contains one or more responses, one per request
// corresponding to the requests in the matching BatchRequest. The
// error in the response header is set to the first error from the
// slice of responses, if applicable.
type BatchResponse struct {
	BatchResponse_Header `protobuf:"bytes,1,opt,name=header,embedded=header" json:"header"`
	Responses            []ResponseUnion `protobuf:"bytes,2,rep,name=responses" json:"responses"`
}

func (m *BatchResponse) Reset()                    { *m = BatchResponse{} }
func (*BatchResponse) ProtoMessage()               {}
func (*BatchResponse) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{78} }

type BatchResponse_Header struct {
	// error is non-nil if an error occurred.
	Error *Error `protobuf:"bytes,1,opt,name=error" json:"error,omitempty"`
	// timestamp is set only for non-transactional responses and denotes the
	// highest timestamp at which a command from the batch executed. At the
	// time of writing, it is used solely for informational purposes and tests.
	Timestamp cockroach_util_hlc.Timestamp `protobuf:"bytes,2,opt,name=Timestamp" json:"Timestamp"`
	// txn is non-nil if the request specified a non-nil
	// transaction. The transaction timestamp and/or priority may have
	// been updated, depending on the outcome of the request.
	Txn *Transaction `protobuf:"bytes,3,opt,name=txn" json:"txn,omitempty"`
	// now is the current time at the node sending the response,
	// which can be used by the receiver to update its local HLC.
	Now cockroach_util_hlc.Timestamp `protobuf:"bytes,5,opt,name=now" json:"now"`
	// collected_spans stores trace spans recorded during the execution of this
	// request.
	CollectedSpans []cockroach_util_tracing.RecordedSpan `protobuf:"bytes,6,rep,name=collected_spans,json=collectedSpans" json:"collected_spans"`
}

func (m *BatchResponse_Header) Reset()                    { *m = BatchResponse_Header{} }
func (m *BatchResponse_Header) String() string            { return proto.CompactTextString(m) }
func (*BatchResponse_Header) ProtoMessage()               {}
func (*BatchResponse_Header) Descriptor() ([]byte, []int) { return fileDescriptorApi, []int{78, 0} }

func init() {
	proto.RegisterType((*RangeInfo)(nil), "cockroach.roachpb.RangeInfo")
	proto.RegisterType((*ResponseHeader)(nil), "cockroach.roachpb.ResponseHeader")
	proto.RegisterType((*GetRequest)(nil), "cockroach.roachpb.GetRequest")
	proto.RegisterType((*GetResponse)(nil), "cockroach.roachpb.GetResponse")
	proto.RegisterType((*PutRequest)(nil), "cockroach.roachpb.PutRequest")
	proto.RegisterType((*PutResponse)(nil), "cockroach.roachpb.PutResponse")
	proto.RegisterType((*ConditionalPutRequest)(nil), "cockroach.roachpb.ConditionalPutRequest")
	proto.RegisterType((*ConditionalPutResponse)(nil), "cockroach.roachpb.ConditionalPutResponse")
	proto.RegisterType((*InitPutRequest)(nil), "cockroach.roachpb.InitPutRequest")
	proto.RegisterType((*InitPutResponse)(nil), "cockroach.roachpb.InitPutResponse")
	proto.RegisterType((*IncrementRequest)(nil), "cockroach.roachpb.IncrementRequest")
	proto.RegisterType((*IncrementResponse)(nil), "cockroach.roachpb.IncrementResponse")
	proto.RegisterType((*DeleteRequest)(nil), "cockroach.roachpb.DeleteRequest")
	proto.RegisterType((*DeleteResponse)(nil), "cockroach.roachpb.DeleteResponse")
	proto.RegisterType((*DeleteRangeRequest)(nil), "cockroach.roachpb.DeleteRangeRequest")
	proto.RegisterType((*DeleteRangeResponse)(nil), "cockroach.roachpb.DeleteRangeResponse")
	proto.RegisterType((*ScanRequest)(nil), "cockroach.roachpb.ScanRequest")
	proto.RegisterType((*ScanResponse)(nil), "cockroach.roachpb.ScanResponse")
	proto.RegisterType((*ReverseScanRequest)(nil), "cockroach.roachpb.ReverseScanRequest")
	proto.RegisterType((*ReverseScanResponse)(nil), "cockroach.roachpb.ReverseScanResponse")
	proto.RegisterType((*CheckConsistencyRequest)(nil), "cockroach.roachpb.CheckConsistencyRequest")
	proto.RegisterType((*CheckConsistencyResponse)(nil), "cockroach.roachpb.CheckConsistencyResponse")
	proto.RegisterType((*BeginTransactionRequest)(nil), "cockroach.roachpb.BeginTransactionRequest")
	proto.RegisterType((*BeginTransactionResponse)(nil), "cockroach.roachpb.BeginTransactionResponse")
	proto.RegisterType((*EndTransactionRequest)(nil), "cockroach.roachpb.EndTransactionRequest")
	proto.RegisterType((*EndTransactionResponse)(nil), "cockroach.roachpb.EndTransactionResponse")
	proto.RegisterType((*AdminSplitRequest)(nil), "cockroach.roachpb.AdminSplitRequest")
	proto.RegisterType((*AdminSplitResponse)(nil), "cockroach.roachpb.AdminSplitResponse")
	proto.RegisterType((*AdminMergeRequest)(nil), "cockroach.roachpb.AdminMergeRequest")
	proto.RegisterType((*AdminMergeResponse)(nil), "cockroach.roachpb.AdminMergeResponse")
	proto.RegisterType((*AdminTransferLeaseRequest)(nil), "cockroach.roachpb.AdminTransferLeaseRequest")
	proto.RegisterType((*AdminTransferLeaseResponse)(nil), "cockroach.roachpb.AdminTransferLeaseResponse")
	proto.RegisterType((*AdminChangeReplicasRequest)(nil), "cockroach.roachpb.AdminChangeReplicasRequest")
	proto.RegisterType((*AdminChangeReplicasResponse)(nil), "cockroach.roachpb.AdminChangeReplicasResponse")
	proto.RegisterType((*RangeLookupRequest)(nil), "cockroach.roachpb.RangeLookupRequest")
	proto.RegisterType((*RangeLookupResponse)(nil), "cockroach.roachpb.RangeLookupResponse")
	proto.RegisterType((*HeartbeatTxnRequest)(nil), "cockroach.roachpb.HeartbeatTxnRequest")
	proto.RegisterType((*HeartbeatTxnResponse)(nil), "cockroach.roachpb.HeartbeatTxnResponse")
	proto.RegisterType((*GCRequest)(nil), "cockroach.roachpb.GCRequest")
	proto.RegisterType((*GCRequest_GCKey)(nil), "cockroach.roachpb.GCRequest.GCKey")
	proto.RegisterType((*GCResponse)(nil), "cockroach.roachpb.GCResponse")
	proto.RegisterType((*PushTxnRequest)(nil), "cockroach.roachpb.PushTxnRequest")
	proto.RegisterType((*PushTxnResponse)(nil), "cockroach.roachpb.PushTxnResponse")
	proto.RegisterType((*QueryTxnRequest)(nil), "cockroach.roachpb.QueryTxnRequest")
	proto.RegisterType((*QueryTxnResponse)(nil), "cockroach.roachpb.QueryTxnResponse")
	proto.RegisterType((*ResolveIntentRequest)(nil), "cockroach.roachpb.ResolveIntentRequest")
	proto.RegisterType((*ResolveIntentResponse)(nil), "cockroach.roachpb.ResolveIntentResponse")
	proto.RegisterType((*ResolveIntentRangeRequest)(nil), "cockroach.roachpb.ResolveIntentRangeRequest")
	proto.RegisterType((*NoopResponse)(nil), "cockroach.roachpb.NoopResponse")
	proto.RegisterType((*NoopRequest)(nil), "cockroach.roachpb.NoopRequest")
	proto.RegisterType((*ResolveIntentRangeResponse)(nil), "cockroach.roachpb.ResolveIntentRangeResponse")
	proto.RegisterType((*MergeRequest)(nil), "cockroach.roachpb.MergeRequest")
	proto.RegisterType((*MergeResponse)(nil), "cockroach.roachpb.MergeResponse")
	proto.RegisterType((*TruncateLogRequest)(nil), "cockroach.roachpb.TruncateLogRequest")
	proto.RegisterType((*TruncateLogResponse)(nil), "cockroach.roachpb.TruncateLogResponse")
	proto.RegisterType((*RequestLeaseRequest)(nil), "cockroach.roachpb.RequestLeaseRequest")
	proto.RegisterType((*TransferLeaseRequest)(nil), "cockroach.roachpb.TransferLeaseRequest")
	proto.RegisterType((*LeaseInfoRequest)(nil), "cockroach.roachpb.LeaseInfoRequest")
	proto.RegisterType((*LeaseInfoResponse)(nil), "cockroach.roachpb.LeaseInfoResponse")
	proto.RegisterType((*RequestLeaseResponse)(nil), "cockroach.roachpb.RequestLeaseResponse")
	proto.RegisterType((*ComputeChecksumRequest)(nil), "cockroach.roachpb.ComputeChecksumRequest")
	proto.RegisterType((*ComputeChecksumResponse)(nil), "cockroach.roachpb.ComputeChecksumResponse")
	proto.RegisterType((*DeprecatedVerifyChecksumRequest)(nil), "cockroach.roachpb.DeprecatedVerifyChecksumRequest")
	proto.RegisterType((*DeprecatedVerifyChecksumResponse)(nil), "cockroach.roachpb.DeprecatedVerifyChecksumResponse")
	proto.RegisterType((*ExportStorage)(nil), "cockroach.roachpb.ExportStorage")
	proto.RegisterType((*ExportStorage_LocalFilePath)(nil), "cockroach.roachpb.ExportStorage.LocalFilePath")
	proto.RegisterType((*ExportStorage_Http)(nil), "cockroach.roachpb.ExportStorage.Http")
	proto.RegisterType((*ExportStorage_S3)(nil), "cockroach.roachpb.ExportStorage.S3")
	proto.RegisterType((*ExportStorage_GCS)(nil), "cockroach.roachpb.ExportStorage.GCS")
	proto.RegisterType((*ExportStorage_Azure)(nil), "cockroach.roachpb.ExportStorage.Azure")
	proto.RegisterType((*WriteBatchRequest)(nil), "cockroach.roachpb.WriteBatchRequest")
	proto.RegisterType((*WriteBatchResponse)(nil), "cockroach.roachpb.WriteBatchResponse")
	proto.RegisterType((*ExportRequest)(nil), "cockroach.roachpb.ExportRequest")
	proto.RegisterType((*ExportResponse)(nil), "cockroach.roachpb.ExportResponse")
	proto.RegisterType((*ExportResponse_File)(nil), "cockroach.roachpb.ExportResponse.File")
	proto.RegisterType((*ImportRequest)(nil), "cockroach.roachpb.ImportRequest")
	proto.RegisterType((*ImportRequest_File)(nil), "cockroach.roachpb.ImportRequest.File")
	proto.RegisterType((*ImportRequest_TableRekey)(nil), "cockroach.roachpb.ImportRequest.TableRekey")
	proto.RegisterType((*ImportResponse)(nil), "cockroach.roachpb.ImportResponse")
	proto.RegisterType((*AdminScatterRequest)(nil), "cockroach.roachpb.AdminScatterRequest")
	proto.RegisterType((*AdminScatterResponse)(nil), "cockroach.roachpb.AdminScatterResponse")
	proto.RegisterType((*AdminScatterResponse_Range)(nil), "cockroach.roachpb.AdminScatterResponse.Range")
	proto.RegisterType((*AddSSTableRequest)(nil), "cockroach.roachpb.AddSSTableRequest")
	proto.RegisterType((*AddSSTableResponse)(nil), "cockroach.roachpb.AddSSTableResponse")
	proto.RegisterType((*RequestUnion)(nil), "cockroach.roachpb.RequestUnion")
	proto.RegisterType((*ResponseUnion)(nil), "cockroach.roachpb.ResponseUnion")
	proto.RegisterType((*Header)(nil), "cockroach.roachpb.Header")
	proto.RegisterType((*BatchRequest)(nil), "cockroach.roachpb.BatchRequest")
	proto.RegisterType((*BatchResponse)(nil), "cockroach.roachpb.BatchResponse")
	proto.RegisterType((*BatchResponse_Header)(nil), "cockroach.roachpb.BatchResponse.Header")
	proto.RegisterEnum("cockroach.roachpb.ReadConsistencyType", ReadConsistencyType_name, ReadConsistencyType_value)
	proto.RegisterEnum("cockroach.roachpb.PushTxnType", PushTxnType_name, PushTxnType_value)
	proto.RegisterEnum("cockroach.roachpb.ExportStorageProvider", ExportStorageProvider_name, ExportStorageProvider_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for Internal service

type InternalClient interface {
	Batch(ctx context.Context, in *BatchRequest, opts ...grpc.CallOption) (*BatchResponse, error)
}

type internalClient struct {
	cc *grpc.ClientConn
}

func NewInternalClient(cc *grpc.ClientConn) InternalClient {
	return &internalClient{cc}
}

func (c *internalClient) Batch(ctx context.Context, in *BatchRequest, opts ...grpc.CallOption) (*BatchResponse, error) {
	out := new(BatchResponse)
	err := grpc.Invoke(ctx, "/cockroach.roachpb.Internal/Batch", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for Internal service

type InternalServer interface {
	Batch(context.Context, *BatchRequest) (*BatchResponse, error)
}

func RegisterInternalServer(s *grpc.Server, srv InternalServer) {
	s.RegisterService(&_Internal_serviceDesc, srv)
}

func _Internal_Batch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InternalServer).Batch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.roachpb.Internal/Batch",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InternalServer).Batch(ctx, req.(*BatchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Internal_serviceDesc = grpc.ServiceDesc{
	ServiceName: "cockroach.roachpb.Internal",
	HandlerType: (*InternalServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Batch",
			Handler:    _Internal_Batch_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "cockroach/pkg/roachpb/api.proto",
}

// Client API for External service

type ExternalClient interface {
	Batch(ctx context.Context, in *BatchRequest, opts ...grpc.CallOption) (*BatchResponse, error)
}

type externalClient struct {
	cc *grpc.ClientConn
}

func NewExternalClient(cc *grpc.ClientConn) ExternalClient {
	return &externalClient{cc}
}

func (c *externalClient) Batch(ctx context.Context, in *BatchRequest, opts ...grpc.CallOption) (*BatchResponse, error) {
	out := new(BatchResponse)
	err := grpc.Invoke(ctx, "/cockroach.roachpb.External/Batch", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for External service

type ExternalServer interface {
	Batch(context.Context, *BatchRequest) (*BatchResponse, error)
}

func RegisterExternalServer(s *grpc.Server, srv ExternalServer) {
	s.RegisterService(&_External_serviceDesc, srv)
}

func _External_Batch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExternalServer).Batch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/cockroach.roachpb.External/Batch",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExternalServer).Batch(ctx, req.(*BatchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _External_serviceDesc = grpc.ServiceDesc{
	ServiceName: "cockroach.roachpb.External",
	HandlerType: (*ExternalServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Batch",
			Handler:    _External_Batch_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "cockroach/pkg/roachpb/api.proto",
}

func (m *RangeInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RangeInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Desc.Size()))
	n1, err := m.Desc.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n1
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Lease.Size()))
	n2, err := m.Lease.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n2
	return i, nil
}

func (m *ResponseHeader) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResponseHeader) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Txn != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Txn.Size()))
		n3, err := m.Txn.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.ResumeSpan != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.ResumeSpan.Size()))
		n4, err := m.ResumeSpan.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	dAtA[i] = 0x28
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.NumKeys))
	if len(m.RangeInfos) > 0 {
		for _, msg := range m.RangeInfos {
			dAtA[i] = 0x32
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *GetRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Span.Size()))
	n5, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n5
	return i, nil
}

func (m *GetResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GetResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n6, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n6
	if m.Value != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Value.Size()))
		n7, err := m.Value.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	return i, nil
}

func (m *PutRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PutRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Span.Size()))
	n8, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n8
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Value.Size()))
	n9, err := m.Value.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n9
	dAtA[i] = 0x18
	i++
	if m.Inline {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	dAtA[i] = 0x20
	i++
	if m.Blind {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	return i, nil
}

func (m *PutResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PutResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n10, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n10
	return i, nil
}

func (m *ConditionalPutRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConditionalPutRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Span.Size()))
	n11, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n11
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Value.Size()))
	n12, err := m.Value.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n12
	if m.ExpValue != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.ExpValue.Size()))
		n13, err := m.ExpValue.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	dAtA[i] = 0x20
	i++
	if m.Blind {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	return i, nil
}

func (m *ConditionalPutResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConditionalPutResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n14, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n14
	return i, nil
}

func (m *InitPutRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InitPutRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Span.Size()))
	n15, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n15
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Value.Size()))
	n16, err := m.Value.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n16
	dAtA[i] = 0x18
	i++
	if m.Blind {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	return i, nil
}

func (m *InitPutResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InitPutResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n17, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n17
	return i, nil
}

func (m *IncrementRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IncrementRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Span.Size()))
	n18, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n18
	dAtA[i] = 0x10
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Increment))
	return i, nil
}

func (m *IncrementResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IncrementResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n19, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n19
	dAtA[i] = 0x10
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.NewValue))
	return i, nil
}

func (m *DeleteRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeleteRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Span.Size()))
	n20, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n20
	return i, nil
}

func (m *DeleteResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeleteResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n21, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n21
	return i, nil
}

func (m *DeleteRangeRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeleteRangeRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Span.Size()))
	n22, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n22
	dAtA[i] = 0x18
	i++
	if m.ReturnKeys {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	dAtA[i] = 0x20
	i++
	if m.Inline {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	return i, nil
}

func (m *DeleteRangeResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeleteRangeResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n23, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n23
	if len(m.Keys) > 0 {
		for _, b := range m.Keys {
			dAtA[i] = 0x12
			i++
			i = encodeVarintApi(dAtA, i, uint64(len(b)))
			i += copy(dAtA[i:], b)
		}
	}
	return i, nil
}

func (m *ScanRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ScanRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Span.Size()))
	n24, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n24
	return i, nil
}

func (m *ScanResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ScanResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n25, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n25
	if len(m.Rows) > 0 {
		for _, msg := range m.Rows {
			dAtA[i] = 0x12
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *ReverseScanRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReverseScanRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Span.Size()))
	n26, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n26
	return i, nil
}

func (m *ReverseScanResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReverseScanResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n27, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n27
	if len(m.Rows) > 0 {
		for _, msg := range m.Rows {
			dAtA[i] = 0x12
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *CheckConsistencyRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CheckConsistencyRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Span.Size()))
	n28, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n28
	dAtA[i] = 0x10
	i++
	if m.WithDiff {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	return i, nil
}

func (m *CheckConsistencyResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CheckConsistencyResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n29, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n29
	return i, nil
}

func (m *BeginTransactionRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BeginTransactionRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Span.Size()))
	n30, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n30
	return i, nil
}

func (m *BeginTransactionResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BeginTransactionResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n31, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n31
	return i, nil
}

func (m *EndTransactionRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EndTransactionRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Span.Size()))
	n32, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n32
	dAtA[i] = 0x10
	i++
	if m.Commit {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	if m.Deadline != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Deadline.Size()))
		n33, err := m.Deadline.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n33
	}
	if m.InternalCommitTrigger != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.InternalCommitTrigger.Size()))
		n34, err := m.InternalCommitTrigger.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n34
	}
	if len(m.IntentSpans) > 0 {
		for _, msg := range m.IntentSpans {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x30
	i++
	if m.Require1PC {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	return i, nil
}

func (m *EndTransactionResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *EndTransactionResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n35, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n35
	dAtA[i] = 0x20
	i++
	if m.OnePhaseCommit {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	return i, nil
}

func (m *AdminSplitRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AdminSplitRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Span.Size()))
	n36, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n36
	if m.SplitKey != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.SplitKey)))
		i += copy(dAtA[i:], m.SplitKey)
	}
	return i, nil
}

func (m *AdminSplitResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AdminSplitResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n37, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n37
	return i, nil
}

func (m *AdminMergeRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AdminMergeRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Span.Size()))
	n38, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n38
	return i, nil
}

func (m *AdminMergeResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AdminMergeResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n39, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n39
	return i, nil
}

func (m *AdminTransferLeaseRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AdminTransferLeaseRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Span.Size()))
	n40, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n40
	dAtA[i] = 0x10
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Target))
	return i, nil
}

func (m *AdminTransferLeaseResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AdminTransferLeaseResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n41, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n41
	return i, nil
}

func (m *AdminChangeReplicasRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AdminChangeReplicasRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Span.Size()))
	n42, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n42
	dAtA[i] = 0x10
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ChangeType))
	if len(m.Targets) > 0 {
		for _, msg := range m.Targets {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *AdminChangeReplicasResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AdminChangeReplicasResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n43, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n43
	return i, nil
}

func (m *RangeLookupRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RangeLookupRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Span.Size()))
	n44, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n44
	dAtA[i] = 0x10
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.MaxRanges))
	dAtA[i] = 0x20
	i++
	if m.Reverse {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	return i, nil
}

func (m *RangeLookupResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RangeLookupResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n45, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n45
	if len(m.Ranges) > 0 {
		for _, msg := range m.Ranges {
			dAtA[i] = 0x12
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.PrefetchedRanges) > 0 {
		for _, msg := range m.PrefetchedRanges {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *HeartbeatTxnRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HeartbeatTxnRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Span.Size()))
	n46, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n46
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Now.Size()))
	n47, err := m.Now.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n47
	return i, nil
}

func (m *HeartbeatTxnResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HeartbeatTxnResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n48, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n48
	return i, nil
}

func (m *GCRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GCRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Span.Size()))
	n49, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n49
	if len(m.Keys) > 0 {
		for _, msg := range m.Keys {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x22
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Threshold.Size()))
	n50, err := m.Threshold.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n50
	dAtA[i] = 0x2a
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.TxnSpanGCThreshold.Size()))
	n51, err := m.TxnSpanGCThreshold.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n51
	return i, nil
}

func (m *GCRequest_GCKey) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GCRequest_GCKey) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Key != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Key)))
		i += copy(dAtA[i:], m.Key)
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Timestamp.Size()))
	n52, err := m.Timestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n52
	return i, nil
}

func (m *GCResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GCResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n53, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n53
	return i, nil
}

func (m *PushTxnRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PushTxnRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Span.Size()))
	n54, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n54
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.PusherTxn.Size()))
	n55, err := m.PusherTxn.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n55
	dAtA[i] = 0x1a
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.PusheeTxn.Size()))
	n56, err := m.PusheeTxn.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n56
	dAtA[i] = 0x22
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.PushTo.Size()))
	n57, err := m.PushTo.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n57
	dAtA[i] = 0x2a
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Now.Size()))
	n58, err := m.Now.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n58
	dAtA[i] = 0x30
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.PushType))
	dAtA[i] = 0x38
	i++
	if m.Force {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	dAtA[i] = 0x40
	i++
	if m.NewPriorities {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	return i, nil
}

func (m *PushTxnResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PushTxnResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n59, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n59
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.PusheeTxn.Size()))
	n60, err := m.PusheeTxn.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n60
	return i, nil
}

func (m *QueryTxnRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryTxnRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Span.Size()))
	n61, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n61
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Txn.Size()))
	n62, err := m.Txn.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n62
	dAtA[i] = 0x18
	i++
	if m.WaitForUpdate {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	if len(m.KnownWaitingTxns) > 0 {
		for _, msg := range m.KnownWaitingTxns {
			dAtA[i] = 0x22
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *QueryTxnResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *QueryTxnResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n63, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n63
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.QueriedTxn.Size()))
	n64, err := m.QueriedTxn.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n64
	if len(m.WaitingTxns) > 0 {
		for _, msg := range m.WaitingTxns {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *ResolveIntentRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResolveIntentRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Span.Size()))
	n65, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n65
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.IntentTxn.Size()))
	n66, err := m.IntentTxn.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n66
	dAtA[i] = 0x18
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Status))
	dAtA[i] = 0x20
	i++
	if m.Poison {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	return i, nil
}

func (m *ResolveIntentResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResolveIntentResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n67, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n67
	return i, nil
}

func (m *ResolveIntentRangeRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResolveIntentRangeRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Span.Size()))
	n68, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n68
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.IntentTxn.Size()))
	n69, err := m.IntentTxn.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n69
	dAtA[i] = 0x18
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Status))
	dAtA[i] = 0x20
	i++
	if m.Poison {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	return i, nil
}

func (m *NoopResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NoopResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *NoopRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NoopRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *ResolveIntentRangeResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResolveIntentRangeResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n70, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n70
	return i, nil
}

func (m *MergeRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MergeRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Span.Size()))
	n71, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n71
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Value.Size()))
	n72, err := m.Value.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n72
	return i, nil
}

func (m *MergeResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MergeResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n73, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n73
	return i, nil
}

func (m *TruncateLogRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TruncateLogRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Span.Size()))
	n74, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n74
	dAtA[i] = 0x10
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Index))
	dAtA[i] = 0x18
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RangeID))
	return i, nil
}

func (m *TruncateLogResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TruncateLogResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n75, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n75
	return i, nil
}

func (m *RequestLeaseRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RequestLeaseRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Span.Size()))
	n76, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n76
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Lease.Size()))
	n77, err := m.Lease.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n77
	dAtA[i] = 0x1a
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.PrevLease.Size()))
	n78, err := m.PrevLease.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n78
	return i, nil
}

func (m *TransferLeaseRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TransferLeaseRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Span.Size()))
	n79, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n79
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Lease.Size()))
	n80, err := m.Lease.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n80
	dAtA[i] = 0x1a
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.PrevLease.Size()))
	n81, err := m.PrevLease.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n81
	return i, nil
}

func (m *LeaseInfoRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LeaseInfoRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Span.Size()))
	n82, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n82
	return i, nil
}

func (m *LeaseInfoResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LeaseInfoResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n83, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n83
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Lease.Size()))
	n84, err := m.Lease.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n84
	return i, nil
}

func (m *RequestLeaseResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RequestLeaseResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n85, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n85
	return i, nil
}

func (m *ComputeChecksumRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ComputeChecksumRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Span.Size()))
	n86, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n86
	dAtA[i] = 0x10
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Version))
	dAtA[i] = 0x1a
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ChecksumID.Size()))
	n87, err := m.ChecksumID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n87
	dAtA[i] = 0x20
	i++
	if m.Snapshot {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	return i, nil
}

func (m *ComputeChecksumResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ComputeChecksumResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n88, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n88
	return i, nil
}

func (m *DeprecatedVerifyChecksumRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeprecatedVerifyChecksumRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Span.Size()))
	n89, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n89
	return i, nil
}

func (m *DeprecatedVerifyChecksumResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DeprecatedVerifyChecksumResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n90, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n90
	return i, nil
}

func (m *ExportStorage) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExportStorage) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Provider))
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.LocalFile.Size()))
	n91, err := m.LocalFile.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n91
	dAtA[i] = 0x1a
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.HttpPath.Size()))
	n92, err := m.HttpPath.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n92
	if m.GoogleCloudConfig != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.GoogleCloudConfig.Size()))
		n93, err := m.GoogleCloudConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n93
	}
	if m.S3Config != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.S3Config.Size()))
		n94, err := m.S3Config.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n94
	}
	if m.AzureConfig != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.AzureConfig.Size()))
		n95, err := m.AzureConfig.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n95
	}
	return i, nil
}

func (m *ExportStorage_LocalFilePath) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExportStorage_LocalFilePath) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(len(m.Path)))
	i += copy(dAtA[i:], m.Path)
	return i, nil
}

func (m *ExportStorage_Http) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExportStorage_Http) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(len(m.BaseUri)))
	i += copy(dAtA[i:], m.BaseUri)
	return i, nil
}

func (m *ExportStorage_S3) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExportStorage_S3) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(len(m.Bucket)))
	i += copy(dAtA[i:], m.Bucket)
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(len(m.Prefix)))
	i += copy(dAtA[i:], m.Prefix)
	dAtA[i] = 0x1a
	i++
	i = encodeVarintApi(dAtA, i, uint64(len(m.AccessKey)))
	i += copy(dAtA[i:], m.AccessKey)
	dAtA[i] = 0x22
	i++
	i = encodeVarintApi(dAtA, i, uint64(len(m.Secret)))
	i += copy(dAtA[i:], m.Secret)
	dAtA[i] = 0x2a
	i++
	i = encodeVarintApi(dAtA, i, uint64(len(m.TempToken)))
	i += copy(dAtA[i:], m.TempToken)
	return i, nil
}

func (m *ExportStorage_GCS) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExportStorage_GCS) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(len(m.Bucket)))
	i += copy(dAtA[i:], m.Bucket)
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(len(m.Prefix)))
	i += copy(dAtA[i:], m.Prefix)
	return i, nil
}

func (m *ExportStorage_Azure) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExportStorage_Azure) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(len(m.Container)))
	i += copy(dAtA[i:], m.Container)
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(len(m.Prefix)))
	i += copy(dAtA[i:], m.Prefix)
	dAtA[i] = 0x1a
	i++
	i = encodeVarintApi(dAtA, i, uint64(len(m.AccountName)))
	i += copy(dAtA[i:], m.AccountName)
	dAtA[i] = 0x22
	i++
	i = encodeVarintApi(dAtA, i, uint64(len(m.AccountKey)))
	i += copy(dAtA[i:], m.AccountKey)
	return i, nil
}

func (m *WriteBatchRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WriteBatchRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Span.Size()))
	n96, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n96
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.DataSpan.Size()))
	n97, err := m.DataSpan.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n97
	if m.Data != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Data)))
		i += copy(dAtA[i:], m.Data)
	}
	return i, nil
}

func (m *WriteBatchResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WriteBatchResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n98, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n98
	return i, nil
}

func (m *ExportRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExportRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Span.Size()))
	n99, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n99
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Storage.Size()))
	n100, err := m.Storage.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n100
	dAtA[i] = 0x1a
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.StartTime.Size()))
	n101, err := m.StartTime.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n101
	return i, nil
}

func (m *ExportResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExportResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n102, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n102
	if len(m.Files) > 0 {
		for _, msg := range m.Files {
			dAtA[i] = 0x12
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *ExportResponse_File) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ExportResponse_File) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Span.Size()))
	n103, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n103
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(len(m.Path)))
	i += copy(dAtA[i:], m.Path)
	dAtA[i] = 0x18
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.DataSize))
	if m.Sha512 != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Sha512)))
		i += copy(dAtA[i:], m.Sha512)
	}
	return i, nil
}

func (m *ImportRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ImportRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Span.Size()))
	n104, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n104
	if len(m.Files) > 0 {
		for _, msg := range m.Files {
			dAtA[i] = 0x12
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x1a
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.DataSpan.Size()))
	n105, err := m.DataSpan.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n105
	if len(m.Rekeys) > 0 {
		for _, msg := range m.Rekeys {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *ImportRequest_File) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ImportRequest_File) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Dir.Size()))
	n106, err := m.Dir.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n106
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(len(m.Path)))
	i += copy(dAtA[i:], m.Path)
	if m.Sha512 != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Sha512)))
		i += copy(dAtA[i:], m.Sha512)
	}
	return i, nil
}

func (m *ImportRequest_TableRekey) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ImportRequest_TableRekey) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.OldID))
	if m.NewDesc != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.NewDesc)))
		i += copy(dAtA[i:], m.NewDesc)
	}
	return i, nil
}

func (m *ImportResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ImportResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n107, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n107
	dAtA[i] = 0x10
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.DataSize))
	return i, nil
}

func (m *AdminScatterRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AdminScatterRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Span.Size()))
	n108, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n108
	return i, nil
}

func (m *AdminScatterResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AdminScatterResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n109, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n109
	if len(m.Ranges) > 0 {
		for _, msg := range m.Ranges {
			dAtA[i] = 0x12
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *AdminScatterResponse_Range) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AdminScatterResponse_Range) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Span.Size()))
	n110, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n110
	if m.Error != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Error.Size()))
		n111, err := m.Error.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n111
	}
	return i, nil
}

func (m *AddSSTableRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AddSSTableRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Span.Size()))
	n112, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n112
	if m.Data != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintApi(dAtA, i, uint64(len(m.Data)))
		i += copy(dAtA[i:], m.Data)
	}
	return i, nil
}

func (m *AddSSTableResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AddSSTableResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ResponseHeader.Size()))
	n113, err := m.ResponseHeader.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n113
	return i, nil
}

func (m *RequestUnion) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RequestUnion) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Get != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Get.Size()))
		n114, err := m.Get.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n114
	}
	if m.Put != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Put.Size()))
		n115, err := m.Put.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n115
	}
	if m.ConditionalPut != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.ConditionalPut.Size()))
		n116, err := m.ConditionalPut.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n116
	}
	if m.Increment != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Increment.Size()))
		n117, err := m.Increment.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n117
	}
	if m.Delete != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Delete.Size()))
		n118, err := m.Delete.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n118
	}
	if m.DeleteRange != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.DeleteRange.Size()))
		n119, err := m.DeleteRange.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n119
	}
	if m.Scan != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Scan.Size()))
		n120, err := m.Scan.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n120
	}
	if m.BeginTransaction != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.BeginTransaction.Size()))
		n121, err := m.BeginTransaction.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n121
	}
	if m.EndTransaction != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.EndTransaction.Size()))
		n122, err := m.EndTransaction.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n122
	}
	if m.AdminSplit != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.AdminSplit.Size()))
		n123, err := m.AdminSplit.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n123
	}
	if m.AdminMerge != nil {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.AdminMerge.Size()))
		n124, err := m.AdminMerge.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n124
	}
	if m.HeartbeatTxn != nil {
		dAtA[i] = 0x62
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.HeartbeatTxn.Size()))
		n125, err := m.HeartbeatTxn.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n125
	}
	if m.Gc != nil {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Gc.Size()))
		n126, err := m.Gc.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n126
	}
	if m.PushTxn != nil {
		dAtA[i] = 0x72
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.PushTxn.Size()))
		n127, err := m.PushTxn.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n127
	}
	if m.RangeLookup != nil {
		dAtA[i] = 0x7a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.RangeLookup.Size()))
		n128, err := m.RangeLookup.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n128
	}
	if m.ResolveIntent != nil {
		dAtA[i] = 0x82
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.ResolveIntent.Size()))
		n129, err := m.ResolveIntent.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n129
	}
	if m.ResolveIntentRange != nil {
		dAtA[i] = 0x8a
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.ResolveIntentRange.Size()))
		n130, err := m.ResolveIntentRange.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n130
	}
	if m.Merge != nil {
		dAtA[i] = 0x92
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Merge.Size()))
		n131, err := m.Merge.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n131
	}
	if m.TruncateLog != nil {
		dAtA[i] = 0x9a
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.TruncateLog.Size()))
		n132, err := m.TruncateLog.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n132
	}
	if m.RequestLease != nil {
		dAtA[i] = 0xa2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.RequestLease.Size()))
		n133, err := m.RequestLease.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n133
	}
	if m.ReverseScan != nil {
		dAtA[i] = 0xaa
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.ReverseScan.Size()))
		n134, err := m.ReverseScan.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n134
	}
	if m.ComputeChecksum != nil {
		dAtA[i] = 0xb2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.ComputeChecksum.Size()))
		n135, err := m.ComputeChecksum.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n135
	}
	if m.DeprecatedVerifyChecksum != nil {
		dAtA[i] = 0xba
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.DeprecatedVerifyChecksum.Size()))
		n136, err := m.DeprecatedVerifyChecksum.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n136
	}
	if m.CheckConsistency != nil {
		dAtA[i] = 0xc2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.CheckConsistency.Size()))
		n137, err := m.CheckConsistency.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n137
	}
	if m.Noop != nil {
		dAtA[i] = 0xca
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Noop.Size()))
		n138, err := m.Noop.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n138
	}
	if m.InitPut != nil {
		dAtA[i] = 0xd2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.InitPut.Size()))
		n139, err := m.InitPut.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n139
	}
	if m.TransferLease != nil {
		dAtA[i] = 0xe2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.TransferLease.Size()))
		n140, err := m.TransferLease.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n140
	}
	if m.AdminTransferLease != nil {
		dAtA[i] = 0xea
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.AdminTransferLease.Size()))
		n141, err := m.AdminTransferLease.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n141
	}
	if m.LeaseInfo != nil {
		dAtA[i] = 0xf2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.LeaseInfo.Size()))
		n142, err := m.LeaseInfo.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n142
	}
	if m.WriteBatch != nil {
		dAtA[i] = 0xfa
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.WriteBatch.Size()))
		n143, err := m.WriteBatch.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n143
	}
	if m.Export != nil {
		dAtA[i] = 0x82
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Export.Size()))
		n144, err := m.Export.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n144
	}
	if m.QueryTxn != nil {
		dAtA[i] = 0x8a
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.QueryTxn.Size()))
		n145, err := m.QueryTxn.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n145
	}
	if m.Import != nil {
		dAtA[i] = 0x92
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Import.Size()))
		n146, err := m.Import.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n146
	}
	if m.AdminChangeReplicas != nil {
		dAtA[i] = 0x9a
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.AdminChangeReplicas.Size()))
		n147, err := m.AdminChangeReplicas.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n147
	}
	if m.AdminScatter != nil {
		dAtA[i] = 0xa2
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.AdminScatter.Size()))
		n148, err := m.AdminScatter.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n148
	}
	if m.AddSstable != nil {
		dAtA[i] = 0xaa
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.AddSstable.Size()))
		n149, err := m.AddSstable.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n149
	}
	return i, nil
}

func (m *ResponseUnion) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ResponseUnion) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Get != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Get.Size()))
		n150, err := m.Get.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n150
	}
	if m.Put != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Put.Size()))
		n151, err := m.Put.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n151
	}
	if m.ConditionalPut != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.ConditionalPut.Size()))
		n152, err := m.ConditionalPut.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n152
	}
	if m.Increment != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Increment.Size()))
		n153, err := m.Increment.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n153
	}
	if m.Delete != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Delete.Size()))
		n154, err := m.Delete.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n154
	}
	if m.DeleteRange != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.DeleteRange.Size()))
		n155, err := m.DeleteRange.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n155
	}
	if m.Scan != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Scan.Size()))
		n156, err := m.Scan.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n156
	}
	if m.BeginTransaction != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.BeginTransaction.Size()))
		n157, err := m.BeginTransaction.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n157
	}
	if m.EndTransaction != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.EndTransaction.Size()))
		n158, err := m.EndTransaction.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n158
	}
	if m.AdminSplit != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.AdminSplit.Size()))
		n159, err := m.AdminSplit.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n159
	}
	if m.AdminMerge != nil {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.AdminMerge.Size()))
		n160, err := m.AdminMerge.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n160
	}
	if m.HeartbeatTxn != nil {
		dAtA[i] = 0x62
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.HeartbeatTxn.Size()))
		n161, err := m.HeartbeatTxn.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n161
	}
	if m.Gc != nil {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Gc.Size()))
		n162, err := m.Gc.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n162
	}
	if m.PushTxn != nil {
		dAtA[i] = 0x72
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.PushTxn.Size()))
		n163, err := m.PushTxn.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n163
	}
	if m.RangeLookup != nil {
		dAtA[i] = 0x7a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.RangeLookup.Size()))
		n164, err := m.RangeLookup.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n164
	}
	if m.ResolveIntent != nil {
		dAtA[i] = 0x82
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.ResolveIntent.Size()))
		n165, err := m.ResolveIntent.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n165
	}
	if m.ResolveIntentRange != nil {
		dAtA[i] = 0x8a
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.ResolveIntentRange.Size()))
		n166, err := m.ResolveIntentRange.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n166
	}
	if m.Merge != nil {
		dAtA[i] = 0x92
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Merge.Size()))
		n167, err := m.Merge.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n167
	}
	if m.TruncateLog != nil {
		dAtA[i] = 0x9a
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.TruncateLog.Size()))
		n168, err := m.TruncateLog.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n168
	}
	if m.RequestLease != nil {
		dAtA[i] = 0xa2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.RequestLease.Size()))
		n169, err := m.RequestLease.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n169
	}
	if m.ReverseScan != nil {
		dAtA[i] = 0xaa
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.ReverseScan.Size()))
		n170, err := m.ReverseScan.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n170
	}
	if m.ComputeChecksum != nil {
		dAtA[i] = 0xb2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.ComputeChecksum.Size()))
		n171, err := m.ComputeChecksum.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n171
	}
	if m.DeprecatedVerifyChecksum != nil {
		dAtA[i] = 0xba
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.DeprecatedVerifyChecksum.Size()))
		n172, err := m.DeprecatedVerifyChecksum.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n172
	}
	if m.CheckConsistency != nil {
		dAtA[i] = 0xc2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.CheckConsistency.Size()))
		n173, err := m.CheckConsistency.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n173
	}
	if m.Noop != nil {
		dAtA[i] = 0xca
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Noop.Size()))
		n174, err := m.Noop.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n174
	}
	if m.InitPut != nil {
		dAtA[i] = 0xd2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.InitPut.Size()))
		n175, err := m.InitPut.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n175
	}
	if m.AdminTransferLease != nil {
		dAtA[i] = 0xea
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.AdminTransferLease.Size()))
		n176, err := m.AdminTransferLease.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n176
	}
	if m.LeaseInfo != nil {
		dAtA[i] = 0xf2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.LeaseInfo.Size()))
		n177, err := m.LeaseInfo.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n177
	}
	if m.WriteBatch != nil {
		dAtA[i] = 0xfa
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.WriteBatch.Size()))
		n178, err := m.WriteBatch.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n178
	}
	if m.Export != nil {
		dAtA[i] = 0x82
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Export.Size()))
		n179, err := m.Export.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n179
	}
	if m.QueryTxn != nil {
		dAtA[i] = 0x8a
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.QueryTxn.Size()))
		n180, err := m.QueryTxn.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n180
	}
	if m.Import != nil {
		dAtA[i] = 0x92
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Import.Size()))
		n181, err := m.Import.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n181
	}
	if m.AdminChangeReplicas != nil {
		dAtA[i] = 0x9a
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.AdminChangeReplicas.Size()))
		n182, err := m.AdminChangeReplicas.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n182
	}
	if m.AdminScatter != nil {
		dAtA[i] = 0xa2
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.AdminScatter.Size()))
		n183, err := m.AdminScatter.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n183
	}
	if m.AddSstable != nil {
		dAtA[i] = 0xaa
		i++
		dAtA[i] = 0x2
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.AddSstable.Size()))
		n184, err := m.AddSstable.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n184
	}
	return i, nil
}

func (m *Header) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Header) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Timestamp.Size()))
	n185, err := m.Timestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n185
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Replica.Size()))
	n186, err := m.Replica.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n186
	dAtA[i] = 0x18
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.RangeID))
	dAtA[i] = 0x21
	i++
	i = encodeFixed64Api(dAtA, i, uint64(math.Float64bits(float64(m.UserPriority))))
	if m.Txn != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Txn.Size()))
		n187, err := m.Txn.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n187
	}
	dAtA[i] = 0x30
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.ReadConsistency))
	dAtA[i] = 0x40
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.MaxSpanRequestKeys))
	dAtA[i] = 0x48
	i++
	if m.DistinctSpans {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	dAtA[i] = 0x50
	i++
	if m.ReturnRangeInfo {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	dAtA[i] = 0x58
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.GatewayNodeID))
	return i, nil
}

func (m *BatchRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BatchRequest) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Header.Size()))
	n188, err := m.Header.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n188
	if len(m.Requests) > 0 {
		for _, msg := range m.Requests {
			dAtA[i] = 0x12
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *BatchResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BatchResponse) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.BatchResponse_Header.Size()))
	n189, err := m.BatchResponse_Header.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n189
	if len(m.Responses) > 0 {
		for _, msg := range m.Responses {
			dAtA[i] = 0x12
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *BatchResponse_Header) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BatchResponse_Header) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Error != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Error.Size()))
		n190, err := m.Error.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n190
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Timestamp.Size()))
	n191, err := m.Timestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n191
	if m.Txn != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintApi(dAtA, i, uint64(m.Txn.Size()))
		n192, err := m.Txn.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n192
	}
	dAtA[i] = 0x2a
	i++
	i = encodeVarintApi(dAtA, i, uint64(m.Now.Size()))
	n193, err := m.Now.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n193
	if len(m.CollectedSpans) > 0 {
		for _, msg := range m.CollectedSpans {
			dAtA[i] = 0x32
			i++
			i = encodeVarintApi(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func encodeFixed64Api(dAtA []byte, offset int, v uint64) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	dAtA[offset+4] = uint8(v >> 32)
	dAtA[offset+5] = uint8(v >> 40)
	dAtA[offset+6] = uint8(v >> 48)
	dAtA[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32Api(dAtA []byte, offset int, v uint32) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintApi(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *RangeInfo) Size() (n int) {
	var l int
	_ = l
	l = m.Desc.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.Lease.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *ResponseHeader) Size() (n int) {
	var l int
	_ = l
	if m.Txn != nil {
		l = m.Txn.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.ResumeSpan != nil {
		l = m.ResumeSpan.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	n += 1 + sovApi(uint64(m.NumKeys))
	if len(m.RangeInfos) > 0 {
		for _, e := range m.RangeInfos {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *GetRequest) Size() (n int) {
	var l int
	_ = l
	l = m.Span.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *GetResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.Value != nil {
		l = m.Value.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *PutRequest) Size() (n int) {
	var l int
	_ = l
	l = m.Span.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.Value.Size()
	n += 1 + l + sovApi(uint64(l))
	n += 2
	n += 2
	return n
}

func (m *PutResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *ConditionalPutRequest) Size() (n int) {
	var l int
	_ = l
	l = m.Span.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.Value.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.ExpValue != nil {
		l = m.ExpValue.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	n += 2
	return n
}

func (m *ConditionalPutResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *InitPutRequest) Size() (n int) {
	var l int
	_ = l
	l = m.Span.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.Value.Size()
	n += 1 + l + sovApi(uint64(l))
	n += 2
	return n
}

func (m *InitPutResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *IncrementRequest) Size() (n int) {
	var l int
	_ = l
	l = m.Span.Size()
	n += 1 + l + sovApi(uint64(l))
	n += 1 + sovApi(uint64(m.Increment))
	return n
}

func (m *IncrementResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	n += 1 + sovApi(uint64(m.NewValue))
	return n
}

func (m *DeleteRequest) Size() (n int) {
	var l int
	_ = l
	l = m.Span.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *DeleteResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *DeleteRangeRequest) Size() (n int) {
	var l int
	_ = l
	l = m.Span.Size()
	n += 1 + l + sovApi(uint64(l))
	n += 2
	n += 2
	return n
}

func (m *DeleteRangeResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if len(m.Keys) > 0 {
		for _, b := range m.Keys {
			l = len(b)
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *ScanRequest) Size() (n int) {
	var l int
	_ = l
	l = m.Span.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *ScanResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if len(m.Rows) > 0 {
		for _, e := range m.Rows {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *ReverseScanRequest) Size() (n int) {
	var l int
	_ = l
	l = m.Span.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *ReverseScanResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if len(m.Rows) > 0 {
		for _, e := range m.Rows {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *CheckConsistencyRequest) Size() (n int) {
	var l int
	_ = l
	l = m.Span.Size()
	n += 1 + l + sovApi(uint64(l))
	n += 2
	return n
}

func (m *CheckConsistencyResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *BeginTransactionRequest) Size() (n int) {
	var l int
	_ = l
	l = m.Span.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *BeginTransactionResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *EndTransactionRequest) Size() (n int) {
	var l int
	_ = l
	l = m.Span.Size()
	n += 1 + l + sovApi(uint64(l))
	n += 2
	if m.Deadline != nil {
		l = m.Deadline.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.InternalCommitTrigger != nil {
		l = m.InternalCommitTrigger.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if len(m.IntentSpans) > 0 {
		for _, e := range m.IntentSpans {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	n += 2
	return n
}

func (m *EndTransactionResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	n += 2
	return n
}

func (m *AdminSplitRequest) Size() (n int) {
	var l int
	_ = l
	l = m.Span.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.SplitKey != nil {
		l = len(m.SplitKey)
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *AdminSplitResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *AdminMergeRequest) Size() (n int) {
	var l int
	_ = l
	l = m.Span.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *AdminMergeResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *AdminTransferLeaseRequest) Size() (n int) {
	var l int
	_ = l
	l = m.Span.Size()
	n += 1 + l + sovApi(uint64(l))
	n += 1 + sovApi(uint64(m.Target))
	return n
}

func (m *AdminTransferLeaseResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *AdminChangeReplicasRequest) Size() (n int) {
	var l int
	_ = l
	l = m.Span.Size()
	n += 1 + l + sovApi(uint64(l))
	n += 1 + sovApi(uint64(m.ChangeType))
	if len(m.Targets) > 0 {
		for _, e := range m.Targets {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *AdminChangeReplicasResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *RangeLookupRequest) Size() (n int) {
	var l int
	_ = l
	l = m.Span.Size()
	n += 1 + l + sovApi(uint64(l))
	n += 1 + sovApi(uint64(m.MaxRanges))
	n += 2
	return n
}

func (m *RangeLookupResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if len(m.Ranges) > 0 {
		for _, e := range m.Ranges {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	if len(m.PrefetchedRanges) > 0 {
		for _, e := range m.PrefetchedRanges {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *HeartbeatTxnRequest) Size() (n int) {
	var l int
	_ = l
	l = m.Span.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.Now.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *HeartbeatTxnResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *GCRequest) Size() (n int) {
	var l int
	_ = l
	l = m.Span.Size()
	n += 1 + l + sovApi(uint64(l))
	if len(m.Keys) > 0 {
		for _, e := range m.Keys {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	l = m.Threshold.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.TxnSpanGCThreshold.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *GCRequest_GCKey) Size() (n int) {
	var l int
	_ = l
	if m.Key != nil {
		l = len(m.Key)
		n += 1 + l + sovApi(uint64(l))
	}
	l = m.Timestamp.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *GCResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *PushTxnRequest) Size() (n int) {
	var l int
	_ = l
	l = m.Span.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.PusherTxn.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.PusheeTxn.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.PushTo.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.Now.Size()
	n += 1 + l + sovApi(uint64(l))
	n += 1 + sovApi(uint64(m.PushType))
	n += 2
	n += 2
	return n
}

func (m *PushTxnResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.PusheeTxn.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *QueryTxnRequest) Size() (n int) {
	var l int
	_ = l
	l = m.Span.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.Txn.Size()
	n += 1 + l + sovApi(uint64(l))
	n += 2
	if len(m.KnownWaitingTxns) > 0 {
		for _, e := range m.KnownWaitingTxns {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *QueryTxnResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.QueriedTxn.Size()
	n += 1 + l + sovApi(uint64(l))
	if len(m.WaitingTxns) > 0 {
		for _, e := range m.WaitingTxns {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *ResolveIntentRequest) Size() (n int) {
	var l int
	_ = l
	l = m.Span.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.IntentTxn.Size()
	n += 1 + l + sovApi(uint64(l))
	n += 1 + sovApi(uint64(m.Status))
	n += 2
	return n
}

func (m *ResolveIntentResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *ResolveIntentRangeRequest) Size() (n int) {
	var l int
	_ = l
	l = m.Span.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.IntentTxn.Size()
	n += 1 + l + sovApi(uint64(l))
	n += 1 + sovApi(uint64(m.Status))
	n += 2
	return n
}

func (m *NoopResponse) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *NoopRequest) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *ResolveIntentRangeResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *MergeRequest) Size() (n int) {
	var l int
	_ = l
	l = m.Span.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.Value.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *MergeResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *TruncateLogRequest) Size() (n int) {
	var l int
	_ = l
	l = m.Span.Size()
	n += 1 + l + sovApi(uint64(l))
	n += 1 + sovApi(uint64(m.Index))
	n += 1 + sovApi(uint64(m.RangeID))
	return n
}

func (m *TruncateLogResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *RequestLeaseRequest) Size() (n int) {
	var l int
	_ = l
	l = m.Span.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.Lease.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.PrevLease.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *TransferLeaseRequest) Size() (n int) {
	var l int
	_ = l
	l = m.Span.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.Lease.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.PrevLease.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *LeaseInfoRequest) Size() (n int) {
	var l int
	_ = l
	l = m.Span.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *LeaseInfoResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.Lease.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *RequestLeaseResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *ComputeChecksumRequest) Size() (n int) {
	var l int
	_ = l
	l = m.Span.Size()
	n += 1 + l + sovApi(uint64(l))
	n += 1 + sovApi(uint64(m.Version))
	l = m.ChecksumID.Size()
	n += 1 + l + sovApi(uint64(l))
	n += 2
	return n
}

func (m *ComputeChecksumResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *DeprecatedVerifyChecksumRequest) Size() (n int) {
	var l int
	_ = l
	l = m.Span.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *DeprecatedVerifyChecksumResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *ExportStorage) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovApi(uint64(m.Provider))
	l = m.LocalFile.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.HttpPath.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.GoogleCloudConfig != nil {
		l = m.GoogleCloudConfig.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.S3Config != nil {
		l = m.S3Config.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.AzureConfig != nil {
		l = m.AzureConfig.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *ExportStorage_LocalFilePath) Size() (n int) {
	var l int
	_ = l
	l = len(m.Path)
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *ExportStorage_Http) Size() (n int) {
	var l int
	_ = l
	l = len(m.BaseUri)
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *ExportStorage_S3) Size() (n int) {
	var l int
	_ = l
	l = len(m.Bucket)
	n += 1 + l + sovApi(uint64(l))
	l = len(m.Prefix)
	n += 1 + l + sovApi(uint64(l))
	l = len(m.AccessKey)
	n += 1 + l + sovApi(uint64(l))
	l = len(m.Secret)
	n += 1 + l + sovApi(uint64(l))
	l = len(m.TempToken)
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *ExportStorage_GCS) Size() (n int) {
	var l int
	_ = l
	l = len(m.Bucket)
	n += 1 + l + sovApi(uint64(l))
	l = len(m.Prefix)
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *ExportStorage_Azure) Size() (n int) {
	var l int
	_ = l
	l = len(m.Container)
	n += 1 + l + sovApi(uint64(l))
	l = len(m.Prefix)
	n += 1 + l + sovApi(uint64(l))
	l = len(m.AccountName)
	n += 1 + l + sovApi(uint64(l))
	l = len(m.AccountKey)
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *WriteBatchRequest) Size() (n int) {
	var l int
	_ = l
	l = m.Span.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.DataSpan.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.Data != nil {
		l = len(m.Data)
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *WriteBatchResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *ExportRequest) Size() (n int) {
	var l int
	_ = l
	l = m.Span.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.Storage.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.StartTime.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *ExportResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if len(m.Files) > 0 {
		for _, e := range m.Files {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *ExportResponse_File) Size() (n int) {
	var l int
	_ = l
	l = m.Span.Size()
	n += 1 + l + sovApi(uint64(l))
	l = len(m.Path)
	n += 1 + l + sovApi(uint64(l))
	n += 1 + sovApi(uint64(m.DataSize))
	if m.Sha512 != nil {
		l = len(m.Sha512)
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *ImportRequest) Size() (n int) {
	var l int
	_ = l
	l = m.Span.Size()
	n += 1 + l + sovApi(uint64(l))
	if len(m.Files) > 0 {
		for _, e := range m.Files {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	l = m.DataSpan.Size()
	n += 1 + l + sovApi(uint64(l))
	if len(m.Rekeys) > 0 {
		for _, e := range m.Rekeys {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *ImportRequest_File) Size() (n int) {
	var l int
	_ = l
	l = m.Dir.Size()
	n += 1 + l + sovApi(uint64(l))
	l = len(m.Path)
	n += 1 + l + sovApi(uint64(l))
	if m.Sha512 != nil {
		l = len(m.Sha512)
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *ImportRequest_TableRekey) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovApi(uint64(m.OldID))
	if m.NewDesc != nil {
		l = len(m.NewDesc)
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *ImportResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	n += 1 + sovApi(uint64(m.DataSize))
	return n
}

func (m *AdminScatterRequest) Size() (n int) {
	var l int
	_ = l
	l = m.Span.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *AdminScatterResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	if len(m.Ranges) > 0 {
		for _, e := range m.Ranges {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *AdminScatterResponse_Range) Size() (n int) {
	var l int
	_ = l
	l = m.Span.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.Error != nil {
		l = m.Error.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *AddSSTableRequest) Size() (n int) {
	var l int
	_ = l
	l = m.Span.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.Data != nil {
		l = len(m.Data)
		n += 1 + l + sovApi(uint64(l))
	}
	return n
}

func (m *AddSSTableResponse) Size() (n int) {
	var l int
	_ = l
	l = m.ResponseHeader.Size()
	n += 1 + l + sovApi(uint64(l))
	return n
}

func (m *RequestUnion) Size() (n int) {
	var l int
	_ = l
	if m.Get != nil {
		l = m.Get.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Put != nil {
		l = m.Put.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.ConditionalPut != nil {
		l = m.ConditionalPut.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Increment != nil {
		l = m.Increment.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Delete != nil {
		l = m.Delete.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.DeleteRange != nil {
		l = m.DeleteRange.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Scan != nil {
		l = m.Scan.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.BeginTransaction != nil {
		l = m.BeginTransaction.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.EndTransaction != nil {
		l = m.EndTransaction.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.AdminSplit != nil {
		l = m.AdminSplit.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.AdminMerge != nil {
		l = m.AdminMerge.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.HeartbeatTxn != nil {
		l = m.HeartbeatTxn.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Gc != nil {
		l = m.Gc.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.PushTxn != nil {
		l = m.PushTxn.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.RangeLookup != nil {
		l = m.RangeLookup.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.ResolveIntent != nil {
		l = m.ResolveIntent.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	if m.ResolveIntentRange != nil {
		l = m.ResolveIntentRange.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	if m.Merge != nil {
		l = m.Merge.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	if m.TruncateLog != nil {
		l = m.TruncateLog.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	if m.RequestLease != nil {
		l = m.RequestLease.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	if m.ReverseScan != nil {
		l = m.ReverseScan.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	if m.ComputeChecksum != nil {
		l = m.ComputeChecksum.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	if m.DeprecatedVerifyChecksum != nil {
		l = m.DeprecatedVerifyChecksum.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	if m.CheckConsistency != nil {
		l = m.CheckConsistency.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	if m.Noop != nil {
		l = m.Noop.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	if m.InitPut != nil {
		l = m.InitPut.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	if m.TransferLease != nil {
		l = m.TransferLease.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	if m.AdminTransferLease != nil {
		l = m.AdminTransferLease.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	if m.LeaseInfo != nil {
		l = m.LeaseInfo.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	if m.WriteBatch != nil {
		l = m.WriteBatch.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	if m.Export != nil {
		l = m.Export.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	if m.QueryTxn != nil {
		l = m.QueryTxn.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	if m.Import != nil {
		l = m.Import.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	if m.AdminChangeReplicas != nil {
		l = m.AdminChangeReplicas.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	if m.AdminScatter != nil {
		l = m.AdminScatter.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	if m.AddSstable != nil {
		l = m.AddSstable.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}

func (m *ResponseUnion) Size() (n int) {
	var l int
	_ = l
	if m.Get != nil {
		l = m.Get.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Put != nil {
		l = m.Put.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.ConditionalPut != nil {
		l = m.ConditionalPut.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Increment != nil {
		l = m.Increment.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Delete != nil {
		l = m.Delete.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.DeleteRange != nil {
		l = m.DeleteRange.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Scan != nil {
		l = m.Scan.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.BeginTransaction != nil {
		l = m.BeginTransaction.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.EndTransaction != nil {
		l = m.EndTransaction.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.AdminSplit != nil {
		l = m.AdminSplit.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.AdminMerge != nil {
		l = m.AdminMerge.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.HeartbeatTxn != nil {
		l = m.HeartbeatTxn.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.Gc != nil {
		l = m.Gc.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.PushTxn != nil {
		l = m.PushTxn.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.RangeLookup != nil {
		l = m.RangeLookup.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	if m.ResolveIntent != nil {
		l = m.ResolveIntent.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	if m.ResolveIntentRange != nil {
		l = m.ResolveIntentRange.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	if m.Merge != nil {
		l = m.Merge.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	if m.TruncateLog != nil {
		l = m.TruncateLog.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	if m.RequestLease != nil {
		l = m.RequestLease.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	if m.ReverseScan != nil {
		l = m.ReverseScan.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	if m.ComputeChecksum != nil {
		l = m.ComputeChecksum.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	if m.DeprecatedVerifyChecksum != nil {
		l = m.DeprecatedVerifyChecksum.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	if m.CheckConsistency != nil {
		l = m.CheckConsistency.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	if m.Noop != nil {
		l = m.Noop.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	if m.InitPut != nil {
		l = m.InitPut.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	if m.AdminTransferLease != nil {
		l = m.AdminTransferLease.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	if m.LeaseInfo != nil {
		l = m.LeaseInfo.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	if m.WriteBatch != nil {
		l = m.WriteBatch.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	if m.Export != nil {
		l = m.Export.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	if m.QueryTxn != nil {
		l = m.QueryTxn.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	if m.Import != nil {
		l = m.Import.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	if m.AdminChangeReplicas != nil {
		l = m.AdminChangeReplicas.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	if m.AdminScatter != nil {
		l = m.AdminScatter.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	if m.AddSstable != nil {
		l = m.AddSstable.Size()
		n += 2 + l + sovApi(uint64(l))
	}
	return n
}

func (m *Header) Size() (n int) {
	var l int
	_ = l
	l = m.Timestamp.Size()
	n += 1 + l + sovApi(uint64(l))
	l = m.Replica.Size()
	n += 1 + l + sovApi(uint64(l))
	n += 1 + sovApi(uint64(m.RangeID))
	n += 9
	if m.Txn != nil {
		l = m.Txn.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	n += 1 + sovApi(uint64(m.ReadConsistency))
	n += 1 + sovApi(uint64(m.MaxSpanRequestKeys))
	n += 2
	n += 2
	n += 1 + sovApi(uint64(m.GatewayNodeID))
	return n
}

func (m *BatchRequest) Size() (n int) {
	var l int
	_ = l
	l = m.Header.Size()
	n += 1 + l + sovApi(uint64(l))
	if len(m.Requests) > 0 {
		for _, e := range m.Requests {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *BatchResponse) Size() (n int) {
	var l int
	_ = l
	l = m.BatchResponse_Header.Size()
	n += 1 + l + sovApi(uint64(l))
	if len(m.Responses) > 0 {
		for _, e := range m.Responses {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func (m *BatchResponse_Header) Size() (n int) {
	var l int
	_ = l
	if m.Error != nil {
		l = m.Error.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	l = m.Timestamp.Size()
	n += 1 + l + sovApi(uint64(l))
	if m.Txn != nil {
		l = m.Txn.Size()
		n += 1 + l + sovApi(uint64(l))
	}
	l = m.Now.Size()
	n += 1 + l + sovApi(uint64(l))
	if len(m.CollectedSpans) > 0 {
		for _, e := range m.CollectedSpans {
			l = e.Size()
			n += 1 + l + sovApi(uint64(l))
		}
	}
	return n
}

func sovApi(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozApi(x uint64) (n int) {
	return sovApi(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *RequestUnion) GetValue() interface{} {
	if this.Get != nil {
		return this.Get
	}
	if this.Put != nil {
		return this.Put
	}
	if this.ConditionalPut != nil {
		return this.ConditionalPut
	}
	if this.Increment != nil {
		return this.Increment
	}
	if this.Delete != nil {
		return this.Delete
	}
	if this.DeleteRange != nil {
		return this.DeleteRange
	}
	if this.Scan != nil {
		return this.Scan
	}
	if this.BeginTransaction != nil {
		return this.BeginTransaction
	}
	if this.EndTransaction != nil {
		return this.EndTransaction
	}
	if this.AdminSplit != nil {
		return this.AdminSplit
	}
	if this.AdminMerge != nil {
		return this.AdminMerge
	}
	if this.HeartbeatTxn != nil {
		return this.HeartbeatTxn
	}
	if this.Gc != nil {
		return this.Gc
	}
	if this.PushTxn != nil {
		return this.PushTxn
	}
	if this.RangeLookup != nil {
		return this.RangeLookup
	}
	if this.ResolveIntent != nil {
		return this.ResolveIntent
	}
	if this.ResolveIntentRange != nil {
		return this.ResolveIntentRange
	}
	if this.Merge != nil {
		return this.Merge
	}
	if this.TruncateLog != nil {
		return this.TruncateLog
	}
	if this.RequestLease != nil {
		return this.RequestLease
	}
	if this.ReverseScan != nil {
		return this.ReverseScan
	}
	if this.ComputeChecksum != nil {
		return this.ComputeChecksum
	}
	if this.DeprecatedVerifyChecksum != nil {
		return this.DeprecatedVerifyChecksum
	}
	if this.CheckConsistency != nil {
		return this.CheckConsistency
	}
	if this.Noop != nil {
		return this.Noop
	}
	if this.InitPut != nil {
		return this.InitPut
	}
	if this.TransferLease != nil {
		return this.TransferLease
	}
	if this.AdminTransferLease != nil {
		return this.AdminTransferLease
	}
	if this.LeaseInfo != nil {
		return this.LeaseInfo
	}
	if this.WriteBatch != nil {
		return this.WriteBatch
	}
	if this.Export != nil {
		return this.Export
	}
	if this.QueryTxn != nil {
		return this.QueryTxn
	}
	if this.Import != nil {
		return this.Import
	}
	if this.AdminChangeReplicas != nil {
		return this.AdminChangeReplicas
	}
	if this.AdminScatter != nil {
		return this.AdminScatter
	}
	if this.AddSstable != nil {
		return this.AddSstable
	}
	return nil
}

func (this *RequestUnion) SetValue(value interface{}) bool {
	switch vt := value.(type) {
	case *GetRequest:
		this.Get = vt
	case *PutRequest:
		this.Put = vt
	case *ConditionalPutRequest:
		this.ConditionalPut = vt
	case *IncrementRequest:
		this.Increment = vt
	case *DeleteRequest:
		this.Delete = vt
	case *DeleteRangeRequest:
		this.DeleteRange = vt
	case *ScanRequest:
		this.Scan = vt
	case *BeginTransactionRequest:
		this.BeginTransaction = vt
	case *EndTransactionRequest:
		this.EndTransaction = vt
	case *AdminSplitRequest:
		this.AdminSplit = vt
	case *AdminMergeRequest:
		this.AdminMerge = vt
	case *HeartbeatTxnRequest:
		this.HeartbeatTxn = vt
	case *GCRequest:
		this.Gc = vt
	case *PushTxnRequest:
		this.PushTxn = vt
	case *RangeLookupRequest:
		this.RangeLookup = vt
	case *ResolveIntentRequest:
		this.ResolveIntent = vt
	case *ResolveIntentRangeRequest:
		this.ResolveIntentRange = vt
	case *MergeRequest:
		this.Merge = vt
	case *TruncateLogRequest:
		this.TruncateLog = vt
	case *RequestLeaseRequest:
		this.RequestLease = vt
	case *ReverseScanRequest:
		this.ReverseScan = vt
	case *ComputeChecksumRequest:
		this.ComputeChecksum = vt
	case *DeprecatedVerifyChecksumRequest:
		this.DeprecatedVerifyChecksum = vt
	case *CheckConsistencyRequest:
		this.CheckConsistency = vt
	case *NoopRequest:
		this.Noop = vt
	case *InitPutRequest:
		this.InitPut = vt
	case *TransferLeaseRequest:
		this.TransferLease = vt
	case *AdminTransferLeaseRequest:
		this.AdminTransferLease = vt
	case *LeaseInfoRequest:
		this.LeaseInfo = vt
	case *WriteBatchRequest:
		this.WriteBatch = vt
	case *ExportRequest:
		this.Export = vt
	case *QueryTxnRequest:
		this.QueryTxn = vt
	case *ImportRequest:
		this.Import = vt
	case *AdminChangeReplicasRequest:
		this.AdminChangeReplicas = vt
	case *AdminScatterRequest:
		this.AdminScatter = vt
	case *AddSSTableRequest:
		this.AddSstable = vt
	default:
		return false
	}
	return true
}
func (this *ResponseUnion) GetValue() interface{} {
	if this.Get != nil {
		return this.Get
	}
	if this.Put != nil {
		return this.Put
	}
	if this.ConditionalPut != nil {
		return this.ConditionalPut
	}
	if this.Increment != nil {
		return this.Increment
	}
	if this.Delete != nil {
		return this.Delete
	}
	if this.DeleteRange != nil {
		return this.DeleteRange
	}
	if this.Scan != nil {
		return this.Scan
	}
	if this.BeginTransaction != nil {
		return this.BeginTransaction
	}
	if this.EndTransaction != nil {
		return this.EndTransaction
	}
	if this.AdminSplit != nil {
		return this.AdminSplit
	}
	if this.AdminMerge != nil {
		return this.AdminMerge
	}
	if this.HeartbeatTxn != nil {
		return this.HeartbeatTxn
	}
	if this.Gc != nil {
		return this.Gc
	}
	if this.PushTxn != nil {
		return this.PushTxn
	}
	if this.RangeLookup != nil {
		return this.RangeLookup
	}
	if this.ResolveIntent != nil {
		return this.ResolveIntent
	}
	if this.ResolveIntentRange != nil {
		return this.ResolveIntentRange
	}
	if this.Merge != nil {
		return this.Merge
	}
	if this.TruncateLog != nil {
		return this.TruncateLog
	}
	if this.RequestLease != nil {
		return this.RequestLease
	}
	if this.ReverseScan != nil {
		return this.ReverseScan
	}
	if this.ComputeChecksum != nil {
		return this.ComputeChecksum
	}
	if this.DeprecatedVerifyChecksum != nil {
		return this.DeprecatedVerifyChecksum
	}
	if this.CheckConsistency != nil {
		return this.CheckConsistency
	}
	if this.Noop != nil {
		return this.Noop
	}
	if this.InitPut != nil {
		return this.InitPut
	}
	if this.AdminTransferLease != nil {
		return this.AdminTransferLease
	}
	if this.LeaseInfo != nil {
		return this.LeaseInfo
	}
	if this.WriteBatch != nil {
		return this.WriteBatch
	}
	if this.Export != nil {
		return this.Export
	}
	if this.QueryTxn != nil {
		return this.QueryTxn
	}
	if this.Import != nil {
		return this.Import
	}
	if this.AdminChangeReplicas != nil {
		return this.AdminChangeReplicas
	}
	if this.AdminScatter != nil {
		return this.AdminScatter
	}
	if this.AddSstable != nil {
		return this.AddSstable
	}
	return nil
}

func (this *ResponseUnion) SetValue(value interface{}) bool {
	switch vt := value.(type) {
	case *GetResponse:
		this.Get = vt
	case *PutResponse:
		this.Put = vt
	case *ConditionalPutResponse:
		this.ConditionalPut = vt
	case *IncrementResponse:
		this.Increment = vt
	case *DeleteResponse:
		this.Delete = vt
	case *DeleteRangeResponse:
		this.DeleteRange = vt
	case *ScanResponse:
		this.Scan = vt
	case *BeginTransactionResponse:
		this.BeginTransaction = vt
	case *EndTransactionResponse:
		this.EndTransaction = vt
	case *AdminSplitResponse:
		this.AdminSplit = vt
	case *AdminMergeResponse:
		this.AdminMerge = vt
	case *HeartbeatTxnResponse:
		this.HeartbeatTxn = vt
	case *GCResponse:
		this.Gc = vt
	case *PushTxnResponse:
		this.PushTxn = vt
	case *RangeLookupResponse:
		this.RangeLookup = vt
	case *ResolveIntentResponse:
		this.ResolveIntent = vt
	case *ResolveIntentRangeResponse:
		this.ResolveIntentRange = vt
	case *MergeResponse:
		this.Merge = vt
	case *TruncateLogResponse:
		this.TruncateLog = vt
	case *RequestLeaseResponse:
		this.RequestLease = vt
	case *ReverseScanResponse:
		this.ReverseScan = vt
	case *ComputeChecksumResponse:
		this.ComputeChecksum = vt
	case *DeprecatedVerifyChecksumResponse:
		this.DeprecatedVerifyChecksum = vt
	case *CheckConsistencyResponse:
		this.CheckConsistency = vt
	case *NoopResponse:
		this.Noop = vt
	case *InitPutResponse:
		this.InitPut = vt
	case *AdminTransferLeaseResponse:
		this.AdminTransferLease = vt
	case *LeaseInfoResponse:
		this.LeaseInfo = vt
	case *WriteBatchResponse:
		this.WriteBatch = vt
	case *ExportResponse:
		this.Export = vt
	case *QueryTxnResponse:
		this.QueryTxn = vt
	case *ImportResponse:
		this.Import = vt
	case *AdminChangeReplicasResponse:
		this.AdminChangeReplicas = vt
	case *AdminScatterResponse:
		this.AdminScatter = vt
	case *AddSSTableResponse:
		this.AddSstable = vt
	default:
		return false
	}
	return true
}
func (m *RangeInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RangeInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RangeInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Desc", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Desc.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Lease", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Lease.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResponseHeader) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResponseHeader: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResponseHeader: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Txn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Txn == nil {
				m.Txn = &Transaction{}
			}
			if err := m.Txn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResumeSpan", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ResumeSpan == nil {
				m.ResumeSpan = &Span{}
			}
			if err := m.ResumeSpan.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumKeys", wireType)
			}
			m.NumKeys = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NumKeys |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeInfos", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RangeInfos = append(m.RangeInfos, RangeInfo{})
			if err := m.RangeInfos[len(m.RangeInfos)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GetResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GetResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GetResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Value == nil {
				m.Value = &Value{}
			}
			if err := m.Value.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PutRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PutRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PutRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Value.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Inline", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Inline = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Blind", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Blind = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PutResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PutResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PutResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ConditionalPutRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ConditionalPutRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ConditionalPutRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Value.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExpValue", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExpValue == nil {
				m.ExpValue = &Value{}
			}
			if err := m.ExpValue.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Blind", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Blind = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ConditionalPutResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ConditionalPutResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ConditionalPutResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InitPutRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InitPutRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InitPutRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Value.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Blind", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Blind = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InitPutResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InitPutResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InitPutResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IncrementRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IncrementRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IncrementRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Increment", wireType)
			}
			m.Increment = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Increment |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IncrementResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IncrementResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IncrementResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NewValue", wireType)
			}
			m.NewValue = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NewValue |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeleteRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeleteRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeleteRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeleteResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeleteResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeleteResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeleteRangeRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeleteRangeRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeleteRangeRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReturnKeys", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ReturnKeys = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Inline", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Inline = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeleteRangeResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeleteRangeResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeleteRangeResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Keys", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Keys = append(m.Keys, make([]byte, postIndex-iNdEx))
			copy(m.Keys[len(m.Keys)-1], dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ScanRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ScanRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ScanRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ScanResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ScanResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ScanResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Rows", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Rows = append(m.Rows, KeyValue{})
			if err := m.Rows[len(m.Rows)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReverseScanRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReverseScanRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReverseScanRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReverseScanResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReverseScanResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReverseScanResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Rows", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Rows = append(m.Rows, KeyValue{})
			if err := m.Rows[len(m.Rows)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CheckConsistencyRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CheckConsistencyRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CheckConsistencyRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WithDiff", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.WithDiff = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CheckConsistencyResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CheckConsistencyResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CheckConsistencyResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BeginTransactionRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BeginTransactionRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BeginTransactionRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BeginTransactionResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BeginTransactionResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BeginTransactionResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EndTransactionRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EndTransactionRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EndTransactionRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Commit", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Commit = bool(v != 0)
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Deadline", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Deadline == nil {
				m.Deadline = &cockroach_util_hlc.Timestamp{}
			}
			if err := m.Deadline.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InternalCommitTrigger", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.InternalCommitTrigger == nil {
				m.InternalCommitTrigger = &InternalCommitTrigger{}
			}
			if err := m.InternalCommitTrigger.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntentSpans", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.IntentSpans = append(m.IntentSpans, Span{})
			if err := m.IntentSpans[len(m.IntentSpans)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Require1PC", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Require1PC = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *EndTransactionResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: EndTransactionResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: EndTransactionResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field OnePhaseCommit", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.OnePhaseCommit = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AdminSplitRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AdminSplitRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AdminSplitRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SplitKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.SplitKey = append(m.SplitKey[:0], dAtA[iNdEx:postIndex]...)
			if m.SplitKey == nil {
				m.SplitKey = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AdminSplitResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AdminSplitResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AdminSplitResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AdminMergeRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AdminMergeRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AdminMergeRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AdminMergeResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AdminMergeResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AdminMergeResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AdminTransferLeaseRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AdminTransferLeaseRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AdminTransferLeaseRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Target", wireType)
			}
			m.Target = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Target |= (StoreID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AdminTransferLeaseResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AdminTransferLeaseResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AdminTransferLeaseResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AdminChangeReplicasRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AdminChangeReplicasRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AdminChangeReplicasRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ChangeType", wireType)
			}
			m.ChangeType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ChangeType |= (ReplicaChangeType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Targets", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Targets = append(m.Targets, ReplicationTarget{})
			if err := m.Targets[len(m.Targets)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AdminChangeReplicasResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AdminChangeReplicasResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AdminChangeReplicasResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RangeLookupRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RangeLookupRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RangeLookupRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxRanges", wireType)
			}
			m.MaxRanges = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxRanges |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reverse", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Reverse = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RangeLookupResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RangeLookupResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RangeLookupResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ranges", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Ranges = append(m.Ranges, RangeDescriptor{})
			if err := m.Ranges[len(m.Ranges)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PrefetchedRanges", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.PrefetchedRanges = append(m.PrefetchedRanges, RangeDescriptor{})
			if err := m.PrefetchedRanges[len(m.PrefetchedRanges)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HeartbeatTxnRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HeartbeatTxnRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HeartbeatTxnRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Now", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Now.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HeartbeatTxnResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HeartbeatTxnResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HeartbeatTxnResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GCRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GCRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GCRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Keys", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Keys = append(m.Keys, GCRequest_GCKey{})
			if err := m.Keys[len(m.Keys)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Threshold", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Threshold.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnSpanGCThreshold", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.TxnSpanGCThreshold.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GCRequest_GCKey) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GCKey: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GCKey: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GCResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GCResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GCResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PushTxnRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PushTxnRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PushTxnRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PusherTxn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.PusherTxn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PusheeTxn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.PusheeTxn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PushTo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.PushTo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Now", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Now.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field PushType", wireType)
			}
			m.PushType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.PushType |= (PushTxnType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Force", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Force = bool(v != 0)
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NewPriorities", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.NewPriorities = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PushTxnResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PushTxnResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PushTxnResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PusheeTxn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.PusheeTxn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QueryTxnRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryTxnRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryTxnRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Txn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Txn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field WaitForUpdate", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.WaitForUpdate = bool(v != 0)
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field KnownWaitingTxns", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var v github_com_cockroachdb_cockroach_pkg_util_uuid.UUID
			m.KnownWaitingTxns = append(m.KnownWaitingTxns, v)
			if err := m.KnownWaitingTxns[len(m.KnownWaitingTxns)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *QueryTxnResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: QueryTxnResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: QueryTxnResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field QueriedTxn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.QueriedTxn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WaitingTxns", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var v github_com_cockroachdb_cockroach_pkg_util_uuid.UUID
			m.WaitingTxns = append(m.WaitingTxns, v)
			if err := m.WaitingTxns[len(m.WaitingTxns)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResolveIntentRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResolveIntentRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResolveIntentRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntentTxn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.IntentTxn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			m.Status = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Status |= (TransactionStatus(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Poison", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Poison = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResolveIntentResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResolveIntentResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResolveIntentResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResolveIntentRangeRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResolveIntentRangeRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResolveIntentRangeRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntentTxn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.IntentTxn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			m.Status = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Status |= (TransactionStatus(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Poison", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Poison = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NoopResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NoopResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NoopResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NoopRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NoopRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NoopRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResolveIntentRangeResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResolveIntentRangeResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResolveIntentRangeResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MergeRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MergeRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MergeRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Value.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MergeResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MergeResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MergeResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TruncateLogRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TruncateLogRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TruncateLogRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Index", wireType)
			}
			m.Index = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Index |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeID", wireType)
			}
			m.RangeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RangeID |= (RangeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TruncateLogResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TruncateLogResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TruncateLogResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RequestLeaseRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RequestLeaseRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RequestLeaseRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Lease", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Lease.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PrevLease", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.PrevLease.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TransferLeaseRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TransferLeaseRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TransferLeaseRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Lease", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Lease.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PrevLease", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.PrevLease.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LeaseInfoRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LeaseInfoRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LeaseInfoRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LeaseInfoResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LeaseInfoResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LeaseInfoResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Lease", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Lease.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RequestLeaseResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RequestLeaseResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RequestLeaseResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ComputeChecksumRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ComputeChecksumRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ComputeChecksumRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			m.Version = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Version |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ChecksumID", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ChecksumID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Snapshot", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Snapshot = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ComputeChecksumResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ComputeChecksumResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ComputeChecksumResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeprecatedVerifyChecksumRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeprecatedVerifyChecksumRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeprecatedVerifyChecksumRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DeprecatedVerifyChecksumResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DeprecatedVerifyChecksumResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DeprecatedVerifyChecksumResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExportStorage) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExportStorage: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExportStorage: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Provider", wireType)
			}
			m.Provider = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Provider |= (ExportStorageProvider(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LocalFile", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.LocalFile.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HttpPath", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.HttpPath.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field GoogleCloudConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.GoogleCloudConfig == nil {
				m.GoogleCloudConfig = &ExportStorage_GCS{}
			}
			if err := m.GoogleCloudConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field S3Config", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.S3Config == nil {
				m.S3Config = &ExportStorage_S3{}
			}
			if err := m.S3Config.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AzureConfig", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AzureConfig == nil {
				m.AzureConfig = &ExportStorage_Azure{}
			}
			if err := m.AzureConfig.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExportStorage_LocalFilePath) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LocalFilePath: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LocalFilePath: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Path = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExportStorage_Http) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Http: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Http: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BaseUri", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.BaseUri = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExportStorage_S3) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: S3: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: S3: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bucket", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Bucket = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Prefix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Prefix = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AccessKey", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AccessKey = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Secret", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Secret = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TempToken", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.TempToken = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExportStorage_GCS) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GCS: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GCS: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Bucket", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Bucket = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Prefix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Prefix = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExportStorage_Azure) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Azure: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Azure: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Container", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Container = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Prefix", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Prefix = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AccountName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AccountName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AccountKey", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.AccountKey = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WriteBatchRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WriteBatchRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WriteBatchRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DataSpan", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.DataSpan.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], dAtA[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WriteBatchResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WriteBatchResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WriteBatchResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExportRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExportRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExportRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Storage", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Storage.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.StartTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExportResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ExportResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ExportResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Files", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Files = append(m.Files, ExportResponse_File{})
			if err := m.Files[len(m.Files)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ExportResponse_File) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: File: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: File: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Path = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DataSize", wireType)
			}
			m.DataSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DataSize |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sha512", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Sha512 = append(m.Sha512[:0], dAtA[iNdEx:postIndex]...)
			if m.Sha512 == nil {
				m.Sha512 = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ImportRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ImportRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ImportRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Files", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Files = append(m.Files, ImportRequest_File{})
			if err := m.Files[len(m.Files)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DataSpan", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.DataSpan.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Rekeys", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Rekeys = append(m.Rekeys, ImportRequest_TableRekey{})
			if err := m.Rekeys[len(m.Rekeys)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ImportRequest_File) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: File: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: File: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Dir", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Dir.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Path = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sha512", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Sha512 = append(m.Sha512[:0], dAtA[iNdEx:postIndex]...)
			if m.Sha512 == nil {
				m.Sha512 = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ImportRequest_TableRekey) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TableRekey: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TableRekey: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field OldID", wireType)
			}
			m.OldID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.OldID |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NewDesc", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.NewDesc = append(m.NewDesc[:0], dAtA[iNdEx:postIndex]...)
			if m.NewDesc == nil {
				m.NewDesc = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ImportResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ImportResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ImportResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DataSize", wireType)
			}
			m.DataSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DataSize |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AdminScatterRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AdminScatterRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AdminScatterRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AdminScatterResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AdminScatterResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AdminScatterResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ranges", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Ranges = append(m.Ranges, AdminScatterResponse_Range{})
			if err := m.Ranges[len(m.Ranges)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AdminScatterResponse_Range) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Range: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Range: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Error == nil {
				m.Error = &Error{}
			}
			if err := m.Error.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AddSSTableRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AddSSTableRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AddSSTableRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Data", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Data = append(m.Data[:0], dAtA[iNdEx:postIndex]...)
			if m.Data == nil {
				m.Data = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AddSSTableResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AddSSTableResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AddSSTableResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResponseHeader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ResponseHeader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RequestUnion) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RequestUnion: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RequestUnion: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Get", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Get == nil {
				m.Get = &GetRequest{}
			}
			if err := m.Get.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Put", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Put == nil {
				m.Put = &PutRequest{}
			}
			if err := m.Put.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConditionalPut", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ConditionalPut == nil {
				m.ConditionalPut = &ConditionalPutRequest{}
			}
			if err := m.ConditionalPut.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Increment", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Increment == nil {
				m.Increment = &IncrementRequest{}
			}
			if err := m.Increment.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Delete", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Delete == nil {
				m.Delete = &DeleteRequest{}
			}
			if err := m.Delete.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeleteRange", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeleteRange == nil {
				m.DeleteRange = &DeleteRangeRequest{}
			}
			if err := m.DeleteRange.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Scan", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Scan == nil {
				m.Scan = &ScanRequest{}
			}
			if err := m.Scan.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BeginTransaction", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.BeginTransaction == nil {
				m.BeginTransaction = &BeginTransactionRequest{}
			}
			if err := m.BeginTransaction.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndTransaction", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.EndTransaction == nil {
				m.EndTransaction = &EndTransactionRequest{}
			}
			if err := m.EndTransaction.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdminSplit", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AdminSplit == nil {
				m.AdminSplit = &AdminSplitRequest{}
			}
			if err := m.AdminSplit.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdminMerge", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AdminMerge == nil {
				m.AdminMerge = &AdminMergeRequest{}
			}
			if err := m.AdminMerge.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HeartbeatTxn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.HeartbeatTxn == nil {
				m.HeartbeatTxn = &HeartbeatTxnRequest{}
			}
			if err := m.HeartbeatTxn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Gc", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Gc == nil {
				m.Gc = &GCRequest{}
			}
			if err := m.Gc.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PushTxn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PushTxn == nil {
				m.PushTxn = &PushTxnRequest{}
			}
			if err := m.PushTxn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeLookup", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RangeLookup == nil {
				m.RangeLookup = &RangeLookupRequest{}
			}
			if err := m.RangeLookup.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResolveIntent", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ResolveIntent == nil {
				m.ResolveIntent = &ResolveIntentRequest{}
			}
			if err := m.ResolveIntent.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResolveIntentRange", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ResolveIntentRange == nil {
				m.ResolveIntentRange = &ResolveIntentRangeRequest{}
			}
			if err := m.ResolveIntentRange.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 18:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Merge", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Merge == nil {
				m.Merge = &MergeRequest{}
			}
			if err := m.Merge.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 19:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TruncateLog", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TruncateLog == nil {
				m.TruncateLog = &TruncateLogRequest{}
			}
			if err := m.TruncateLog.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 20:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestLease", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RequestLease == nil {
				m.RequestLease = &RequestLeaseRequest{}
			}
			if err := m.RequestLease.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 21:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReverseScan", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ReverseScan == nil {
				m.ReverseScan = &ReverseScanRequest{}
			}
			if err := m.ReverseScan.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 22:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ComputeChecksum", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ComputeChecksum == nil {
				m.ComputeChecksum = &ComputeChecksumRequest{}
			}
			if err := m.ComputeChecksum.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 23:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeprecatedVerifyChecksum", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeprecatedVerifyChecksum == nil {
				m.DeprecatedVerifyChecksum = &DeprecatedVerifyChecksumRequest{}
			}
			if err := m.DeprecatedVerifyChecksum.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 24:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CheckConsistency", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CheckConsistency == nil {
				m.CheckConsistency = &CheckConsistencyRequest{}
			}
			if err := m.CheckConsistency.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 25:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Noop", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Noop == nil {
				m.Noop = &NoopRequest{}
			}
			if err := m.Noop.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 26:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InitPut", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.InitPut == nil {
				m.InitPut = &InitPutRequest{}
			}
			if err := m.InitPut.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 28:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TransferLease", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TransferLease == nil {
				m.TransferLease = &TransferLeaseRequest{}
			}
			if err := m.TransferLease.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 29:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdminTransferLease", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AdminTransferLease == nil {
				m.AdminTransferLease = &AdminTransferLeaseRequest{}
			}
			if err := m.AdminTransferLease.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 30:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LeaseInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LeaseInfo == nil {
				m.LeaseInfo = &LeaseInfoRequest{}
			}
			if err := m.LeaseInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 31:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WriteBatch", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WriteBatch == nil {
				m.WriteBatch = &WriteBatchRequest{}
			}
			if err := m.WriteBatch.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 32:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Export", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Export == nil {
				m.Export = &ExportRequest{}
			}
			if err := m.Export.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 33:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field QueryTxn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.QueryTxn == nil {
				m.QueryTxn = &QueryTxnRequest{}
			}
			if err := m.QueryTxn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 34:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Import", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Import == nil {
				m.Import = &ImportRequest{}
			}
			if err := m.Import.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 35:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdminChangeReplicas", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AdminChangeReplicas == nil {
				m.AdminChangeReplicas = &AdminChangeReplicasRequest{}
			}
			if err := m.AdminChangeReplicas.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 36:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdminScatter", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AdminScatter == nil {
				m.AdminScatter = &AdminScatterRequest{}
			}
			if err := m.AdminScatter.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 37:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AddSstable", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AddSstable == nil {
				m.AddSstable = &AddSSTableRequest{}
			}
			if err := m.AddSstable.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ResponseUnion) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ResponseUnion: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ResponseUnion: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Get", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Get == nil {
				m.Get = &GetResponse{}
			}
			if err := m.Get.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Put", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Put == nil {
				m.Put = &PutResponse{}
			}
			if err := m.Put.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConditionalPut", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ConditionalPut == nil {
				m.ConditionalPut = &ConditionalPutResponse{}
			}
			if err := m.ConditionalPut.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Increment", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Increment == nil {
				m.Increment = &IncrementResponse{}
			}
			if err := m.Increment.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Delete", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Delete == nil {
				m.Delete = &DeleteResponse{}
			}
			if err := m.Delete.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeleteRange", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeleteRange == nil {
				m.DeleteRange = &DeleteRangeResponse{}
			}
			if err := m.DeleteRange.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Scan", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Scan == nil {
				m.Scan = &ScanResponse{}
			}
			if err := m.Scan.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BeginTransaction", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.BeginTransaction == nil {
				m.BeginTransaction = &BeginTransactionResponse{}
			}
			if err := m.BeginTransaction.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndTransaction", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.EndTransaction == nil {
				m.EndTransaction = &EndTransactionResponse{}
			}
			if err := m.EndTransaction.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdminSplit", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AdminSplit == nil {
				m.AdminSplit = &AdminSplitResponse{}
			}
			if err := m.AdminSplit.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdminMerge", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AdminMerge == nil {
				m.AdminMerge = &AdminMergeResponse{}
			}
			if err := m.AdminMerge.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HeartbeatTxn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.HeartbeatTxn == nil {
				m.HeartbeatTxn = &HeartbeatTxnResponse{}
			}
			if err := m.HeartbeatTxn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Gc", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Gc == nil {
				m.Gc = &GCResponse{}
			}
			if err := m.Gc.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PushTxn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.PushTxn == nil {
				m.PushTxn = &PushTxnResponse{}
			}
			if err := m.PushTxn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeLookup", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RangeLookup == nil {
				m.RangeLookup = &RangeLookupResponse{}
			}
			if err := m.RangeLookup.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResolveIntent", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ResolveIntent == nil {
				m.ResolveIntent = &ResolveIntentResponse{}
			}
			if err := m.ResolveIntent.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResolveIntentRange", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ResolveIntentRange == nil {
				m.ResolveIntentRange = &ResolveIntentRangeResponse{}
			}
			if err := m.ResolveIntentRange.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 18:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Merge", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Merge == nil {
				m.Merge = &MergeResponse{}
			}
			if err := m.Merge.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 19:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TruncateLog", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TruncateLog == nil {
				m.TruncateLog = &TruncateLogResponse{}
			}
			if err := m.TruncateLog.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 20:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestLease", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RequestLease == nil {
				m.RequestLease = &RequestLeaseResponse{}
			}
			if err := m.RequestLease.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 21:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReverseScan", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ReverseScan == nil {
				m.ReverseScan = &ReverseScanResponse{}
			}
			if err := m.ReverseScan.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 22:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ComputeChecksum", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ComputeChecksum == nil {
				m.ComputeChecksum = &ComputeChecksumResponse{}
			}
			if err := m.ComputeChecksum.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 23:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DeprecatedVerifyChecksum", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.DeprecatedVerifyChecksum == nil {
				m.DeprecatedVerifyChecksum = &DeprecatedVerifyChecksumResponse{}
			}
			if err := m.DeprecatedVerifyChecksum.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 24:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CheckConsistency", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.CheckConsistency == nil {
				m.CheckConsistency = &CheckConsistencyResponse{}
			}
			if err := m.CheckConsistency.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 25:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Noop", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Noop == nil {
				m.Noop = &NoopResponse{}
			}
			if err := m.Noop.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 26:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InitPut", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.InitPut == nil {
				m.InitPut = &InitPutResponse{}
			}
			if err := m.InitPut.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 29:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdminTransferLease", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AdminTransferLease == nil {
				m.AdminTransferLease = &AdminTransferLeaseResponse{}
			}
			if err := m.AdminTransferLease.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 30:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LeaseInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LeaseInfo == nil {
				m.LeaseInfo = &LeaseInfoResponse{}
			}
			if err := m.LeaseInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 31:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WriteBatch", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WriteBatch == nil {
				m.WriteBatch = &WriteBatchResponse{}
			}
			if err := m.WriteBatch.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 32:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Export", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Export == nil {
				m.Export = &ExportResponse{}
			}
			if err := m.Export.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 33:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field QueryTxn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.QueryTxn == nil {
				m.QueryTxn = &QueryTxnResponse{}
			}
			if err := m.QueryTxn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 34:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Import", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Import == nil {
				m.Import = &ImportResponse{}
			}
			if err := m.Import.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 35:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdminChangeReplicas", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AdminChangeReplicas == nil {
				m.AdminChangeReplicas = &AdminChangeReplicasResponse{}
			}
			if err := m.AdminChangeReplicas.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 36:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AdminScatter", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AdminScatter == nil {
				m.AdminScatter = &AdminScatterResponse{}
			}
			if err := m.AdminScatter.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 37:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AddSstable", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AddSstable == nil {
				m.AddSstable = &AddSSTableResponse{}
			}
			if err := m.AddSstable.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Header) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Header: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Header: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Replica", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Replica.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeID", wireType)
			}
			m.RangeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RangeID |= (RangeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field UserPriority", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			v = uint64(dAtA[iNdEx-8])
			v |= uint64(dAtA[iNdEx-7]) << 8
			v |= uint64(dAtA[iNdEx-6]) << 16
			v |= uint64(dAtA[iNdEx-5]) << 24
			v |= uint64(dAtA[iNdEx-4]) << 32
			v |= uint64(dAtA[iNdEx-3]) << 40
			v |= uint64(dAtA[iNdEx-2]) << 48
			v |= uint64(dAtA[iNdEx-1]) << 56
			m.UserPriority = UserPriority(math.Float64frombits(v))
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Txn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Txn == nil {
				m.Txn = &Transaction{}
			}
			if err := m.Txn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadConsistency", wireType)
			}
			m.ReadConsistency = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ReadConsistency |= (ReadConsistencyType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxSpanRequestKeys", wireType)
			}
			m.MaxSpanRequestKeys = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxSpanRequestKeys |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DistinctSpans", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.DistinctSpans = bool(v != 0)
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReturnRangeInfo", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ReturnRangeInfo = bool(v != 0)
		case 11:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field GatewayNodeID", wireType)
			}
			m.GatewayNodeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.GatewayNodeID |= (NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BatchRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BatchRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BatchRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Header", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Header.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Requests", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Requests = append(m.Requests, RequestUnion{})
			if err := m.Requests[len(m.Requests)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BatchResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BatchResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BatchResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BatchResponse_Header", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.BatchResponse_Header.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Responses", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Responses = append(m.Responses, ResponseUnion{})
			if err := m.Responses[len(m.Responses)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BatchResponse_Header) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowApi
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Header: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Header: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Error == nil {
				m.Error = &Error{}
			}
			if err := m.Error.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Txn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Txn == nil {
				m.Txn = &Transaction{}
			}
			if err := m.Txn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Now", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Now.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CollectedSpans", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowApi
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthApi
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CollectedSpans = append(m.CollectedSpans, cockroach_util_tracing.RecordedSpan{})
			if err := m.CollectedSpans[len(m.CollectedSpans)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipApi(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthApi
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipApi(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowApi
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowApi
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowApi
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthApi
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowApi
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipApi(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthApi = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowApi   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("cockroach/pkg/roachpb/api.proto", fileDescriptorApi) }

var fileDescriptorApi = []byte{
	// 4531 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xd4, 0x7c, 0x4d, 0x6c, 0x1b, 0x49,
	0x76, 0xbf, 0x9b, 0x1f, 0x12, 0xf9, 0x48, 0x4a, 0x54, 0x59, 0xb6, 0x69, 0x8e, 0x47, 0x94, 0xdb,
	0x9f, 0x33, 0x9e, 0xa1, 0x3c, 0xf6, 0xdf, 0xff, 0x1d, 0x4f, 0x66, 0xb0, 0x23, 0x51, 0xb2, 0x4c,
	0xcb, 0x96, 0x35, 0x4d, 0x6a, 0x3c, 0x33, 0xbb, 0xd9, 0x4e, 0xab, 0xbb, 0x44, 0xf6, 0x9a, 0xec,
	0xa6, 0xbb, 0x9b, 0x16, 0x35, 0x39, 0x2c, 0x12, 0x2c, 0x90, 0x8f, 0x43, 0x90, 0x00, 0x73, 0xc8,
	0xe6, 0x0b, 0x8b, 0x2c, 0x02, 0xe4, 0x98, 0x43, 0x80, 0x1c, 0x73, 0x4a, 0x30, 0xb9, 0xcd, 0x31,
	0x48, 0x00, 0x23, 0xf1, 0x5e, 0x82, 0x5c, 0x83, 0x5c, 0xe6, 0x14, 0xd4, 0x47, 0x37, 0xbb, 0xc9,
	0x6e, 0x92, 0x96, 0x7b, 0x31, 0xc9, 0x49, 0xad, 0x57, 0xf5, 0x7e, 0x5d, 0xf5, 0xaa, 0xea, 0xd5,
	0xaf, 0xde, 0xab, 0x26, 0x54, 0x54, 0x53, 0x7d, 0x6a, 0x99, 0x8a, 0xda, 0x5e, 0xeb, 0x3d, 0x6d,
	0xad, 0xd1, 0xa7, 0xde, 0xc1, 0x9a, 0xd2, 0xd3, 0xab, 0x3d, 0xcb, 0x74, 0x4c, 0xb4, 0xe4, 0x55,
	0xa8, 0xf2, 0xc2, 0xf2, 0x6a, 0xb8, 0x8e, 0xa6, 0x38, 0x0a, 0x53, 0x2a, 0x8b, 0xe1, 0x35, 0xb0,
	0x65, 0x99, 0x96, 0xcd, 0xeb, 0x5c, 0x0e, 0xaf, 0xd3, 0xc5, 0x8e, 0xe2, 0x43, 0xba, 0x19, 0xac,
	0x65, 0x3b, 0xa6, 0xa5, 0xb4, 0xf0, 0x1a, 0x36, 0x5a, 0xba, 0xe1, 0xfe, 0x21, 0x5a, 0xcf, 0x55,
	0x95, 0x6b, 0x5c, 0x0d, 0x6a, 0xf4, 0x1d, 0xbd, 0xb3, 0xd6, 0xee, 0xa8, 0x6b, 0x8e, 0xde, 0xc5,
	0xb6, 0xa3, 0x74, 0x7b, 0xbc, 0x5e, 0x35, 0xa4, 0x9e, 0x63, 0x29, 0xaa, 0x6e, 0xb4, 0xd6, 0x2c,
	0xac, 0x9a, 0x96, 0x86, 0x35, 0xd9, 0xee, 0x29, 0x06, 0xaf, 0xbf, 0xdc, 0x32, 0x5b, 0x26, 0x7d,
	0x5c, 0x23, 0x4f, 0x4c, 0x2a, 0xfe, 0x04, 0xb2, 0x92, 0x62, 0xb4, 0x70, 0xdd, 0x38, 0x34, 0xd1,
	0x87, 0x90, 0xd2, 0xb0, 0xad, 0x96, 0x84, 0x55, 0xe1, 0x7a, 0xee, 0x96, 0x58, 0x1d, 0x33, 0x5d,
	0x95, 0xd6, 0xdd, 0xc4, 0xb6, 0x6a, 0xe9, 0x3d, 0xc7, 0xb4, 0x36, 0x52, 0x5f, 0xbf, 0xa8, 0x9c,
	0x92, 0xa8, 0x16, 0xfa, 0x7f, 0x90, 0xee, 0x60, 0xc5, 0xc6, 0xa5, 0x04, 0x55, 0x2f, 0x85, 0xa8,
	0x3f, 0x24, 0xe5, 0x5c, 0x89, 0x55, 0x16, 0x5f, 0x0a, 0xb0, 0x20, 0x61, 0xbb, 0x67, 0x1a, 0x36,
	0xbe, 0x8f, 0x15, 0x0d, 0x5b, 0xe8, 0x26, 0x24, 0x9d, 0x81, 0x51, 0x4a, 0x52, 0x98, 0x95, 0x10,
	0x98, 0xa6, 0xa5, 0x18, 0xb6, 0xa2, 0x3a, 0xba, 0x69, 0x48, 0xa4, 0x2a, 0x7a, 0x1f, 0x72, 0x16,
	0xb6, 0xfb, 0x5d, 0x4c, 0x3b, 0x5c, 0x4a, 0x51, 0xcd, 0x73, 0x21, 0x9a, 0x8d, 0x9e, 0x62, 0x48,
	0xc0, 0xea, 0x92, 0x67, 0x54, 0x81, 0x8c, 0xd1, 0xef, 0xca, 0x4f, 0xf1, 0xb1, 0x5d, 0x4a, 0xaf,
	0x0a, 0xd7, 0x93, 0xbc, 0x75, 0xf3, 0x46, 0xbf, 0xbb, 0x83, 0x8f, 0x6d, 0x54, 0x83, 0x9c, 0x45,
	0x3a, 0x2d, 0xeb, 0xc6, 0xa1, 0x69, 0x97, 0xe6, 0x56, 0x93, 0xd7, 0x73, 0xb7, 0x2e, 0x44, 0x99,
	0x86, 0x98, 0x91, 0x23, 0x80, 0xe5, 0x0a, 0x6c, 0x71, 0x1b, 0x60, 0x1b, 0x3b, 0x12, 0x7e, 0xd6,
	0xc7, 0xb6, 0x83, 0xee, 0xc2, 0x5c, 0x9b, 0xf6, 0x94, 0x1b, 0x3a, 0xaa, 0xa1, 0x1b, 0x19, 0x02,
	0xf4, 0xcd, 0x8b, 0x8a, 0x20, 0x71, 0x05, 0xf1, 0xb7, 0x05, 0xc8, 0x51, 0x24, 0x66, 0x30, 0x54,
	0x1b, 0x81, 0xba, 0x18, 0xd6, 0xb0, 0x80, 0x75, 0xc7, 0x41, 0x51, 0x15, 0xd2, 0xcf, 0x95, 0x4e,
	0x7f, 0xd2, 0xc0, 0x7d, 0x4a, 0xca, 0x25, 0x56, 0x4d, 0xfc, 0x3b, 0x01, 0x60, 0xaf, 0x1f, 0x43,
	0x77, 0xc8, 0x94, 0x99, 0xe9, 0xcd, 0xee, 0x94, 0xa1, 0x95, 0xd1, 0x05, 0x98, 0xd3, 0x8d, 0x8e,
	0x6e, 0x60, 0x3a, 0x45, 0x32, 0xbc, 0x90, 0xcb, 0x50, 0x19, 0xd2, 0x07, 0x1d, 0xdd, 0xd0, 0xe8,
	0x2c, 0x70, 0x0b, 0x99, 0x48, 0x94, 0x20, 0x47, 0x1b, 0x1e, 0xa3, 0xf5, 0xc4, 0x7f, 0x15, 0xe0,
	0x4c, 0xcd, 0x34, 0x34, 0x9d, 0x4c, 0x47, 0xa5, 0xf3, 0x5d, 0x1a, 0xe6, 0x0e, 0x64, 0xf1, 0xa0,
	0x27, 0x33, 0xcd, 0xe4, 0x94, 0xc1, 0xcc, 0xe0, 0x41, 0x8f, 0x3e, 0x4d, 0xb4, 0xd8, 0xaf, 0xc3,
	0xd9, 0xd1, 0xce, 0xc5, 0x69, 0xbc, 0x3f, 0x17, 0x60, 0xa1, 0x6e, 0xe8, 0xce, 0x77, 0x69, 0x35,
	0xaf, 0xfb, 0xc9, 0xf1, 0xee, 0x7f, 0x0a, 0x8b, 0x5e, 0xf3, 0xe2, 0xec, 0xf7, 0x33, 0x28, 0xd6,
	0x0d, 0xd5, 0xc2, 0x5d, 0x6c, 0xc4, 0xd1, 0x71, 0x11, 0xb2, 0xba, 0x0b, 0x47, 0x3b, 0xef, 0xba,
	0xb1, 0xa1, 0x58, 0xfc, 0x4d, 0x58, 0xf2, 0xbd, 0x32, 0x4e, 0xff, 0x71, 0x11, 0xb2, 0x06, 0x3e,
	0x92, 0x87, 0xa6, 0x77, 0xdf, 0x9e, 0x31, 0xf0, 0x11, 0x35, 0xb8, 0xf8, 0x00, 0x0a, 0x9b, 0xb8,
	0x83, 0x1d, 0x1c, 0x83, 0x0f, 0xdc, 0x87, 0x05, 0x17, 0x2b, 0xce, 0x21, 0xf9, 0x13, 0x01, 0x10,
	0xc7, 0x25, 0x8e, 0x3b, 0x86, 0x51, 0xb9, 0x42, 0x76, 0x25, 0xa7, 0x6f, 0x19, 0x6c, 0x7b, 0xf1,
	0x4f, 0x2f, 0x60, 0x05, 0x74, 0x87, 0x19, 0xba, 0xb3, 0xd4, 0xb8, 0x3b, 0x7b, 0x90, 0xca, 0x24,
	0x8a, 0x49, 0xf1, 0x08, 0x4e, 0x07, 0xda, 0x16, 0xe7, 0xf0, 0xbd, 0x01, 0x29, 0xda, 0xbe, 0xc4,
	0x6a, 0xf2, 0x7a, 0x7e, 0x63, 0xfe, 0xdb, 0x17, 0x95, 0xe4, 0x0e, 0x3e, 0x96, 0xa8, 0x50, 0xdc,
	0x85, 0x5c, 0x43, 0x55, 0x8c, 0xd7, 0xb7, 0x06, 0xef, 0xc8, 0xef, 0x0b, 0x90, 0x67, 0x80, 0x71,
	0x76, 0xe1, 0x0e, 0xa4, 0x2c, 0xf3, 0x88, 0x75, 0x21, 0x77, 0xeb, 0x8d, 0x10, 0x88, 0x1d, 0x7c,
	0xec, 0x5f, 0xfa, 0xb4, 0xba, 0xb8, 0x0f, 0x48, 0xc2, 0xcf, 0xb1, 0x65, 0xe3, 0x58, 0xfb, 0xf8,
	0x47, 0x02, 0x9c, 0x0e, 0xe0, 0xfe, 0x2f, 0xe8, 0xea, 0x11, 0x9c, 0xab, 0xb5, 0xb1, 0xfa, 0xb4,
	0x66, 0x1a, 0xb6, 0x6e, 0x3b, 0xd8, 0x50, 0x8f, 0x63, 0x98, 0xe1, 0x17, 0x21, 0x7b, 0xa4, 0x3b,
	0x6d, 0x59, 0xd3, 0x0f, 0x0f, 0xe9, 0xca, 0x77, 0x67, 0x6f, 0x86, 0x88, 0x37, 0xf5, 0xc3, 0x43,
	0x51, 0x86, 0xd2, 0xf8, 0x8b, 0xe3, 0x5c, 0xb7, 0x4d, 0x38, 0xb7, 0x81, 0x5b, 0xba, 0xe1, 0x27,
	0x85, 0xaf, 0xef, 0x64, 0x64, 0x28, 0x8d, 0xa3, 0xc6, 0xd9, 0xec, 0x9f, 0x26, 0xe1, 0xcc, 0x96,
	0xa1, 0xc5, 0xda, 0x6a, 0xe2, 0x4a, 0x54, 0xb3, 0xdb, 0xd5, 0x9d, 0xc0, 0x60, 0x70, 0x19, 0xba,
	0x0b, 0x19, 0x0d, 0x2b, 0x9a, 0xc7, 0x9c, 0x72, 0xb7, 0xde, 0xf4, 0x41, 0x93, 0x03, 0x44, 0xb5,
	0xdd, 0x51, 0xab, 0x4d, 0xf7, 0xa0, 0x21, 0x79, 0xd5, 0xd1, 0x6f, 0xc0, 0x39, 0xdd, 0x70, 0xb0,
	0x65, 0x28, 0x1d, 0x99, 0xa1, 0xc9, 0x8e, 0xa5, 0xb7, 0x5a, 0xd8, 0xe2, 0x64, 0xfb, 0x7a, 0x48,
	0x23, 0xeb, 0x5c, 0xa3, 0x46, 0x15, 0x9a, 0xac, 0xbe, 0x74, 0x46, 0x0f, 0x13, 0xa3, 0x8f, 0x21,
	0x4f, 0x0a, 0x0c, 0x87, 0x52, 0x78, 0x42, 0xc6, 0x93, 0x93, 0xfa, 0xce, 0x7a, 0x96, 0x63, 0x2a,
	0x44, 0x62, 0xa3, 0xdb, 0xc4, 0xdd, 0x3e, 0xeb, 0xeb, 0x16, 0x96, 0xdf, 0xeb, 0xa9, 0xa5, 0x39,
	0x6a, 0x01, 0x44, 0xea, 0xbd, 0x7c, 0x51, 0x01, 0x89, 0x15, 0xbd, 0xb7, 0x57, 0x23, 0xce, 0x97,
	0x3d, 0xf7, 0x54, 0xf1, 0x67, 0x02, 0x9c, 0x1d, 0x1d, 0x86, 0x78, 0xb9, 0x75, 0xd1, 0x34, 0xb0,
	0xdc, 0x6b, 0x2b, 0x36, 0xe6, 0x96, 0x0b, 0xb8, 0xf9, 0x05, 0xd3, 0xc0, 0x7b, 0xa4, 0x90, 0x59,
	0x83, 0x79, 0x90, 0x07, 0xa9, 0x4c, 0xb2, 0x98, 0x12, 0x1d, 0x58, 0x5a, 0xd7, 0xba, 0xba, 0xd1,
	0xe8, 0x75, 0xf4, 0x38, 0x58, 0xc2, 0x65, 0xc8, 0xda, 0x04, 0x8a, 0x6c, 0x47, 0x74, 0x82, 0xf8,
	0xbc, 0x7d, 0x86, 0x96, 0xec, 0xe0, 0x63, 0xf1, 0x73, 0x40, 0xfe, 0xb7, 0xc6, 0x39, 0xe7, 0x77,
	0x79, 0x87, 0x1e, 0x61, 0x2b, 0x8e, 0x0d, 0xd6, 0x6b, 0x2a, 0xc7, 0x8b, 0xb3, 0xa9, 0x3f, 0x81,
	0xf3, 0x14, 0x9a, 0x4e, 0x8c, 0x43, 0x6c, 0xd1, 0x93, 0x6b, 0x0c, 0x63, 0x70, 0x0d, 0xe6, 0x1c,
	0xc5, 0x6a, 0x61, 0xb6, 0x42, 0xd3, 0x1b, 0x8b, 0xa4, 0xc6, 0xb7, 0x2f, 0x2a, 0xf3, 0x0d, 0xc7,
	0xb4, 0x70, 0x7d, 0x53, 0xe2, 0xc5, 0xa2, 0x02, 0xe5, 0xb0, 0x06, 0xc4, 0xd9, 0xc7, 0xff, 0x14,
	0xf8, 0x3b, 0x6a, 0x6d, 0xc6, 0x2a, 0x7a, 0x1d, 0x5d, 0x55, 0xec, 0x18, 0x7a, 0xb9, 0x03, 0x39,
	0x95, 0x62, 0xca, 0xce, 0x71, 0x8f, 0x71, 0xc2, 0x85, 0x5b, 0x97, 0x43, 0xdb, 0x48, 0xdf, 0xc9,
	0x1a, 0xd0, 0x3c, 0xee, 0xb9, 0x9b, 0x16, 0xa8, 0x9e, 0x04, 0x6d, 0xc2, 0x3c, 0xb3, 0x09, 0xa1,
	0x50, 0xc4, 0x29, 0x4c, 0x00, 0x22, 0x0b, 0xb8, 0x49, 0x2b, 0xbb, 0xe7, 0x78, 0xae, 0x2a, 0x1e,
	0xc0, 0x1b, 0xa1, 0x7d, 0x8d, 0x9b, 0x42, 0x52, 0x82, 0xf6, 0xd0, 0x34, 0x9f, 0xf6, 0x7b, 0x31,
	0x18, 0xf2, 0x12, 0x40, 0x57, 0x19, 0xc8, 0x34, 0x94, 0x60, 0xf3, 0x29, 0xc3, 0x99, 0x7d, 0x57,
	0x19, 0xd0, 0x77, 0xd9, 0x68, 0x05, 0xe6, 0x2d, 0x46, 0x37, 0x02, 0xae, 0xc5, 0x15, 0x72, 0x6f,
	0xf2, 0x5f, 0x84, 0x95, 0xf8, 0x1b, 0x17, 0xa7, 0x9b, 0xfb, 0x18, 0xe6, 0xbc, 0x36, 0x26, 0x5f,
	0x29, 0x76, 0xc4, 0xf5, 0xd0, 0x3e, 0x2c, 0xf5, 0x2c, 0x7c, 0x88, 0x1d, 0xb5, 0x8d, 0x35, 0xb7,
	0xc3, 0xc9, 0x57, 0x04, 0x2b, 0x0e, 0x21, 0x98, 0x6d, 0xc4, 0xdf, 0x11, 0xe0, 0xf4, 0x7d, 0xac,
	0x58, 0xce, 0x01, 0x56, 0x9c, 0xe6, 0x20, 0x8e, 0x4d, 0xf6, 0x0e, 0x24, 0x0d, 0xf3, 0x88, 0x9f,
	0x31, 0x27, 0xef, 0xa0, 0xbc, 0x59, 0xa4, 0xbe, 0xf8, 0x03, 0x58, 0x0e, 0x36, 0x24, 0xce, 0x99,
	0xf7, 0x67, 0x49, 0xc8, 0x6e, 0xd7, 0x62, 0xe8, 0xdc, 0x87, 0xfc, 0x30, 0x10, 0x6d, 0x79, 0xef,
	0x35, 0xd5, 0xed, 0xda, 0x0e, 0x3e, 0x76, 0x59, 0x26, 0xd1, 0x42, 0xeb, 0x90, 0x75, 0xda, 0x16,
	0xb6, 0xdb, 0x66, 0x47, 0xe3, 0xc4, 0x60, 0x26, 0x03, 0x0d, 0xb5, 0x50, 0x07, 0xce, 0x38, 0x03,
	0x83, 0x92, 0x00, 0xb9, 0xa5, 0xca, 0x43, 0xb8, 0xf4, 0x2c, 0x70, 0x65, 0xbe, 0xdd, 0xa3, 0xe6,
	0xc0, 0x20, 0x3d, 0xdc, 0xae, 0x35, 0x5d, 0x00, 0x09, 0x39, 0x5c, 0xa6, 0x7a, 0xb2, 0x32, 0x86,
	0x34, 0xed, 0x05, 0x3a, 0x0f, 0x49, 0xb2, 0x2b, 0x0a, 0xc1, 0x5d, 0x91, 0xc8, 0x68, 0xa7, 0xdc,
	0x17, 0xbc, 0xca, 0xa8, 0x0f, 0xb5, 0xc4, 0x4f, 0x00, 0x88, 0xd9, 0xe2, 0x1c, 0xf1, 0x97, 0x49,
	0x58, 0xd8, 0xeb, 0xdb, 0xed, 0x78, 0xe6, 0x74, 0x0d, 0xa0, 0xd7, 0xb7, 0xdb, 0xd8, 0x92, 0x9d,
	0x81, 0xc1, 0x3b, 0x39, 0x25, 0xf2, 0xea, 0xf6, 0x92, 0xe9, 0x35, 0x07, 0x06, 0x7a, 0xcc, 0x41,
	0xb0, 0x3c, 0x0c, 0xdf, 0xbe, 0xed, 0x03, 0xe1, 0xc1, 0xef, 0x2a, 0x8b, 0x7a, 0x57, 0xdd, 0xe0,
	0x77, 0xb5, 0x39, 0x30, 0x1e, 0x61, 0x47, 0x09, 0x00, 0x62, 0x02, 0xf8, 0x21, 0xcc, 0x93, 0x7f,
	0x64, 0xc7, 0x7c, 0x95, 0xc9, 0x34, 0x47, 0x74, 0x9a, 0xa6, 0xbb, 0x4e, 0xd3, 0xaf, 0xb6, 0x4e,
	0xc9, 0x70, 0xb3, 0x97, 0x92, 0x9d, 0x6b, 0x8e, 0xee, 0x5c, 0x61, 0x96, 0xe0, 0xb6, 0xf7, 0xed,
	0x59, 0x19, 0xfa, 0x5e, 0xb2, 0x63, 0x95, 0x21, 0x7d, 0x68, 0x5a, 0x2a, 0x2e, 0xcd, 0xfb, 0x23,
	0x4a, 0x54, 0x84, 0x6e, 0xc0, 0x82, 0x81, 0x8f, 0xe4, 0x9e, 0xa5, 0x9b, 0x96, 0xee, 0xe8, 0xd8,
	0x2e, 0x65, 0x7c, 0x95, 0x0a, 0x06, 0x3e, 0xda, 0xf3, 0x8a, 0xc4, 0x3f, 0x15, 0x60, 0xd1, 0x1b,
	0xe4, 0x38, 0xfd, 0x75, 0x2d, 0x30, 0x54, 0xaf, 0x3e, 0xde, 0x64, 0x78, 0xc4, 0xbf, 0x4a, 0xc0,
	0xe2, 0x27, 0x7d, 0x6c, 0x1d, 0xc7, 0x33, 0x07, 0x37, 0x58, 0xd8, 0x3f, 0x71, 0xc2, 0x79, 0x43,
	0x13, 0x01, 0xef, 0xc0, 0xe2, 0x91, 0xa2, 0x3b, 0xf2, 0xa1, 0x69, 0xc9, 0xfd, 0x9e, 0xa6, 0x38,
	0xc1, 0x18, 0x71, 0x81, 0x14, 0xde, 0x33, 0xad, 0x7d, 0x5a, 0x84, 0x30, 0xa0, 0xa7, 0x86, 0x79,
	0x64, 0xc8, 0x44, 0xac, 0x1b, 0x2d, 0x62, 0x0c, 0xbb, 0x94, 0xa2, 0x71, 0x90, 0xef, 0xfd, 0xcb,
	0x8b, 0xca, 0xed, 0x96, 0xee, 0xb4, 0xfb, 0x07, 0x55, 0xd5, 0xec, 0xae, 0x79, 0xcd, 0xd1, 0x0e,
	0xd6, 0x42, 0x32, 0x2f, 0xfd, 0xbe, 0xae, 0x55, 0xf7, 0xf7, 0xeb, 0x9b, 0x52, 0x91, 0x42, 0x3e,
	0x61, 0x88, 0xcd, 0x81, 0x61, 0x8b, 0xdf, 0x0a, 0x50, 0x1c, 0xda, 0x29, 0xce, 0x61, 0xdc, 0x82,
	0xdc, 0xb3, 0x3e, 0xb6, 0x74, 0xac, 0xbd, 0xf2, 0x38, 0x02, 0x57, 0x24, 0xeb, 0xec, 0x0b, 0xc8,
	0x07, 0x2c, 0x90, 0x7c, 0x3d, 0x0b, 0xe4, 0x8e, 0x7c, 0x9d, 0xff, 0x69, 0x02, 0x96, 0x25, 0x6c,
	0x9b, 0x9d, 0xe7, 0xb8, 0x4e, 0x0f, 0x6b, 0x31, 0xcc, 0x94, 0xc7, 0x00, 0xfc, 0xac, 0xf8, 0x3a,
	0x13, 0x26, 0xcb, 0x30, 0x88, 0x01, 0x36, 0x60, 0xce, 0x76, 0x14, 0xa7, 0xcf, 0x82, 0x74, 0xe1,
	0x54, 0xd5, 0x67, 0xc2, 0x06, 0xad, 0xeb, 0xba, 0x1b, 0xa6, 0x49, 0xce, 0xde, 0x3d, 0x53, 0xb7,
	0x4d, 0x23, 0x18, 0xc6, 0x63, 0x32, 0xf1, 0x87, 0x70, 0x66, 0xc4, 0x0a, 0x71, 0x6e, 0x06, 0xbf,
	0x97, 0x80, 0xf3, 0x41, 0xf8, 0x98, 0x42, 0x98, 0xff, 0x07, 0x2d, 0xbd, 0x00, 0xf9, 0x5d, 0xd3,
	0xf4, 0xf8, 0xad, 0x58, 0x80, 0x1c, 0xfb, 0x9f, 0x1a, 0x83, 0x9c, 0xab, 0xc2, 0x2c, 0x15, 0xef,
	0xd9, 0x31, 0x1f, 0xd3, 0x09, 0xf7, 0x64, 0x19, 0x0d, 0xb1, 0x09, 0x85, 0x5f, 0xc1, 0x91, 0xf8,
	0x2f, 0x05, 0x40, 0x4d, 0xab, 0x6f, 0xa8, 0x8a, 0x83, 0x1f, 0x9a, 0xad, 0x18, 0x7a, 0x57, 0x86,
	0xb4, 0x6e, 0x68, 0x78, 0x40, 0x7b, 0x97, 0x72, 0xfb, 0x40, 0x45, 0xe8, 0x0e, 0x64, 0x78, 0xde,
	0x95, 0x25, 0x66, 0x92, 0x1e, 0xb7, 0x9b, 0x67, 0x99, 0xd6, 0xcd, 0x6f, 0x87, 0x8f, 0xd2, 0x3c,
	0x4b, 0xb6, 0x6a, 0xe2, 0x17, 0x70, 0x3a, 0xd0, 0xc6, 0x38, 0x0d, 0xf0, 0x0f, 0x34, 0xae, 0x4b,
	0x7b, 0x1d, 0x57, 0x38, 0xe0, 0x44, 0x39, 0x73, 0xf4, 0x11, 0x40, 0xcf, 0xc2, 0xcf, 0x65, 0xa6,
	0x9a, 0x9c, 0x49, 0x35, 0x4b, 0x34, 0xa8, 0x40, 0xfc, 0x47, 0x01, 0x96, 0xe3, 0x8e, 0x6b, 0x7c,
	0x27, 0x1d, 0x79, 0x04, 0x45, 0xfa, 0x50, 0x37, 0x0e, 0xcd, 0x18, 0xc2, 0x49, 0x7f, 0x20, 0xc0,
	0x92, 0x0f, 0x2f, 0xce, 0x8d, 0xfa, 0x64, 0x77, 0x23, 0x7e, 0x40, 0xb6, 0x4e, 0xff, 0x7c, 0x8b,
	0x73, 0x36, 0xff, 0x56, 0x02, 0xce, 0xd6, 0xcc, 0x6e, 0xaf, 0xef, 0x60, 0x1a, 0xa0, 0xb7, 0xfb,
	0xdd, 0x18, 0xe6, 0xc1, 0x0a, 0xcc, 0x3f, 0xc7, 0x96, 0xad, 0x9b, 0x6c, 0xb7, 0x28, 0xb8, 0xb1,
	0x08, 0x2e, 0x44, 0x3f, 0x86, 0x9c, 0xca, 0xdf, 0xe6, 0xae, 0xec, 0xfc, 0x46, 0x9d, 0xd4, 0x39,
	0x21, 0xdb, 0x78, 0xf9, 0xa2, 0x02, 0x6e, 0xfb, 0xeb, 0x9b, 0x12, 0xb8, 0xe8, 0x75, 0x0d, 0xad,
	0x42, 0xc6, 0x36, 0x94, 0x9e, 0xdd, 0x36, 0x83, 0x31, 0x57, 0x4f, 0x2a, 0xfe, 0x08, 0xce, 0x8d,
	0x99, 0x20, 0x4e, 0x1b, 0xff, 0x10, 0x2a, 0x9b, 0xb8, 0x67, 0x61, 0xe2, 0x8e, 0xb4, 0x4f, 0xb1,
	0xa5, 0x1f, 0x1e, 0xc7, 0x67, 0x6b, 0xb1, 0x05, 0xab, 0xd1, 0xe8, 0x71, 0x76, 0xe3, 0x6f, 0xe7,
	0xa1, 0xb0, 0x35, 0xe8, 0x99, 0x96, 0xd3, 0x60, 0xfb, 0x3d, 0x7a, 0x00, 0x99, 0x9e, 0x65, 0x3e,
	0xd7, 0x5d, 0xe0, 0x85, 0xd0, 0x04, 0x40, 0x40, 0x67, 0x8f, 0xd7, 0xf7, 0x4e, 0x4b, 0xfc, 0x7f,
	0x24, 0x41, 0xf6, 0xa1, 0xa9, 0x2a, 0x9d, 0x7b, 0x7a, 0xc7, 0x5d, 0x1f, 0xd5, 0x69, 0x60, 0x55,
	0x4f, 0x63, 0x4f, 0x71, 0xda, 0xae, 0x67, 0xf0, 0x84, 0x68, 0x1b, 0x32, 0xf7, 0x1d, 0xa7, 0x47,
	0x0a, 0xb9, 0x5b, 0xb9, 0x32, 0x15, 0x92, 0x28, 0xb8, 0x8d, 0x73, 0x95, 0x91, 0x04, 0x4b, 0xdb,
	0xa6, 0xd9, 0xea, 0xe0, 0x5a, 0xc7, 0xec, 0x6b, 0x35, 0xd3, 0x38, 0xd4, 0x5b, 0xfc, 0x30, 0x7a,
	0x79, 0x2a, 0xe2, 0x76, 0xad, 0x21, 0x8d, 0xab, 0xa3, 0xef, 0x43, 0xa6, 0x71, 0x9b, 0x43, 0xb1,
	0xd3, 0xe9, 0xa5, 0xa9, 0x50, 0x8d, 0xdb, 0x92, 0xa7, 0x84, 0xee, 0x43, 0x6e, 0xfd, 0xcb, 0xbe,
	0x85, 0x39, 0xc6, 0x1c, 0xc5, 0xb8, 0x3a, 0x15, 0x83, 0xea, 0x48, 0x7e, 0xd5, 0xf2, 0x5b, 0x50,
	0x08, 0x58, 0x12, 0x95, 0x20, 0xd5, 0x23, 0x46, 0x23, 0x83, 0x9a, 0x75, 0x63, 0x3b, 0x44, 0x52,
	0xbe, 0x0a, 0x29, 0x62, 0x15, 0xb2, 0xc2, 0x0f, 0x14, 0x1b, 0xef, 0x5b, 0x7a, 0xa0, 0x92, 0x2b,
	0x2c, 0xff, 0xb5, 0x00, 0x89, 0xc6, 0x6d, 0x42, 0xd2, 0x0e, 0xfa, 0xea, 0x53, 0xec, 0x04, 0x6a,
	0x71, 0x19, 0xa5, 0x70, 0x16, 0x3e, 0xd4, 0xd9, 0xd6, 0xef, 0x95, 0x32, 0x19, 0xba, 0x04, 0xa0,
	0xa8, 0x2a, 0xb6, 0x6d, 0x9a, 0xa9, 0x48, 0xfa, 0x6a, 0x64, 0x99, 0x7c, 0x07, 0x1f, 0x13, 0x08,
	0x1b, 0xab, 0x16, 0x66, 0x6b, 0xdb, 0x83, 0x60, 0x32, 0x02, 0xe1, 0xe0, 0x6e, 0x4f, 0x76, 0xcc,
	0xa7, 0xd8, 0xa0, 0x56, 0xf6, 0x20, 0x88, 0xbc, 0x49, 0xc4, 0xe5, 0x75, 0x48, 0x6e, 0xd7, 0x1a,
	0xaf, 0xd3, 0xd4, 0xf2, 0xcf, 0x04, 0x48, 0x53, 0x83, 0x22, 0x11, 0xb2, 0xaa, 0x69, 0x38, 0x8a,
	0x6e, 0xf0, 0x35, 0xe1, 0xbd, 0xd0, 0x13, 0x4f, 0xe9, 0xf6, 0x35, 0xc8, 0x2b, 0xaa, 0x6a, 0xf6,
	0x0d, 0x47, 0x36, 0x94, 0x2e, 0x0e, 0x74, 0x3c, 0xc7, 0x4b, 0x76, 0x95, 0x2e, 0x46, 0x57, 0xc0,
	0xfd, 0x97, 0x1a, 0xc8, 0xdf, 0x7f, 0xe0, 0x05, 0x3b, 0xf8, 0x58, 0xfc, 0x0b, 0x01, 0x96, 0x9e,
	0x58, 0xba, 0x83, 0x37, 0x14, 0x47, 0x6d, 0xc7, 0xe0, 0xdc, 0x3f, 0x80, 0xac, 0xa6, 0x38, 0x0a,
	0xbb, 0x64, 0x97, 0x98, 0xac, 0xcd, 0x17, 0x12, 0xa9, 0x4f, 0x2f, 0xda, 0x21, 0x48, 0x91, 0x67,
	0xe6, 0xf1, 0x25, 0xfa, 0x2c, 0x7e, 0x0e, 0xc8, 0xdf, 0xbe, 0x38, 0x5d, 0xd6, 0x37, 0x82, 0xeb,
	0xb2, 0x62, 0xe8, 0xf7, 0xc7, 0x30, 0xcf, 0x0f, 0x3a, 0xbc, 0xd7, 0xab, 0xd3, 0xd6, 0x9a, 0xbb,
	0x28, 0xb8, 0x1a, 0xda, 0x00, 0xb0, 0x1d, 0xc5, 0x72, 0x64, 0x47, 0xef, 0xce, 0x96, 0x7c, 0x75,
	0x27, 0x0f, 0x55, 0x23, 0x52, 0xf1, 0x6f, 0x12, 0xb0, 0xe0, 0x76, 0x29, 0x4e, 0x6e, 0xb2, 0x01,
	0xe9, 0x43, 0xbd, 0xe3, 0x85, 0xee, 0xa3, 0xfd, 0x88, 0x8b, 0x54, 0x25, 0xde, 0xc2, 0x8b, 0x6a,
	0x11, 0xd5, 0xf2, 0x57, 0x02, 0xa4, 0xa8, 0xe3, 0x7d, 0x0f, 0x52, 0x74, 0x76, 0x08, 0xb3, 0xcc,
	0x0e, 0x5a, 0xd5, 0x73, 0x39, 0x89, 0x51, 0x97, 0x83, 0x2e, 0xba, 0xf3, 0x4d, 0xff, 0x12, 0xf3,
	0x43, 0x80, 0x7f, 0x5a, 0xe9, 0x5f, 0x62, 0x74, 0x16, 0xe6, 0xec, 0xb6, 0x72, 0xe7, 0xbd, 0x5b,
	0x74, 0x8d, 0xe7, 0x25, 0xfe, 0xdf, 0x83, 0x54, 0x26, 0x55, 0x4c, 0x8b, 0xbf, 0x4c, 0x42, 0xa1,
	0xde, 0x8d, 0x69, 0x16, 0xac, 0x07, 0xed, 0x14, 0xb6, 0xa1, 0x04, 0xde, 0x35, 0x6e, 0xa6, 0xe0,
	0x02, 0x4a, 0xbe, 0xda, 0x02, 0xaa, 0xc3, 0x9c, 0x85, 0xf9, 0x3d, 0x55, 0xf2, 0xfe, 0x1b, 0x53,
	0xdf, 0xdf, 0x54, 0x0e, 0x3a, 0x58, 0x22, 0x3a, 0x5e, 0xae, 0x85, 0x02, 0x94, 0x07, 0x7c, 0xb0,
	0xde, 0x87, 0xa4, 0xa6, 0xbb, 0x96, 0x98, 0x75, 0x4e, 0x13, 0x95, 0x09, 0x63, 0x36, 0x1c, 0x90,
	0xd4, 0xc8, 0x80, 0x24, 0x8b, 0xa9, 0xf2, 0x23, 0x80, 0x61, 0xab, 0xd0, 0x65, 0x98, 0x33, 0x3b,
	0x1a, 0xe1, 0x81, 0x02, 0xe5, 0x8a, 0x05, 0x7e, 0xc2, 0x4b, 0x3f, 0xee, 0x68, 0xf5, 0x4d, 0x29,
	0x6d, 0x76, 0xb4, 0xba, 0x86, 0xce, 0x43, 0xc6, 0xc0, 0x47, 0x32, 0xbd, 0x99, 0x4c, 0xb3, 0xd6,
	0xd2, 0xbc, 0x81, 0x8f, 0x36, 0xb1, 0xad, 0xf2, 0x51, 0x1e, 0xc0, 0x82, 0xdb, 0xf1, 0x98, 0xaf,
	0xb5, 0x0d, 0x67, 0x5f, 0x22, 0x6c, 0xf6, 0x89, 0x7b, 0x70, 0x9a, 0xe5, 0xca, 0x55, 0xc5, 0x71,
	0xb0, 0x15, 0x03, 0xa7, 0xfb, 0x2a, 0x01, 0xcb, 0x41, 0xc8, 0x38, 0xbb, 0xb4, 0x33, 0x92, 0xa6,
	0x7b, 0x37, 0x04, 0x24, 0xec, 0xed, 0x2c, 0xdd, 0x16, 0xcc, 0xd8, 0x95, 0x7f, 0x0c, 0x69, 0x2a,
	0x3e, 0xc9, 0x9a, 0xaf, 0x42, 0x9a, 0x5e, 0xa6, 0x9f, 0x70, 0x1e, 0xda, 0x22, 0xe5, 0x12, 0xab,
	0x26, 0x1e, 0xc0, 0xd2, 0xba, 0xa6, 0x35, 0x1a, 0x7c, 0xf2, 0xbc, 0xf6, 0x5a, 0x76, 0x77, 0xa3,
	0x44, 0x70, 0x37, 0xf2, 0xbf, 0x23, 0xce, 0xdd, 0xe8, 0x9f, 0x96, 0x21, 0xcf, 0x5b, 0xbd, 0x6f,
	0x90, 0x63, 0xd0, 0x1a, 0x24, 0x5b, 0x9c, 0x6f, 0x04, 0x37, 0x02, 0x2f, 0xcb, 0xe6, 0x5d, 0x17,
	0x97, 0x48, 0x4d, 0xa2, 0xd0, 0xeb, 0x3b, 0x21, 0xe9, 0xa7, 0x61, 0x3e, 0x62, 0xa8, 0xd0, 0xeb,
	0x3b, 0xe8, 0x13, 0x58, 0x54, 0x87, 0x17, 0x77, 0x65, 0xa2, 0x9c, 0x8c, 0xbc, 0xa9, 0x13, 0x7a,
	0x7f, 0x59, 0x5a, 0x50, 0x03, 0x62, 0xb4, 0xee, 0xbf, 0x65, 0x9a, 0x8a, 0x24, 0xae, 0xa3, 0x17,
	0x5b, 0x7d, 0x97, 0x50, 0xd1, 0xfb, 0x30, 0xa7, 0xd1, 0x7b, 0x8c, 0x9c, 0xf8, 0x86, 0x39, 0x9d,
	0xc0, 0x45, 0x51, 0x89, 0xd7, 0x47, 0xf7, 0x21, 0xcf, 0x9e, 0x58, 0x6e, 0x98, 0x93, 0xde, 0x2b,
	0xd1, 0xfa, 0xbe, 0x08, 0xa8, 0x94, 0xd3, 0x86, 0x32, 0x74, 0x0b, 0x52, 0xb6, 0xaa, 0x18, 0x34,
	0x39, 0x13, 0x1e, 0x2d, 0xf7, 0xdd, 0x06, 0x94, 0x68, 0x5d, 0xf4, 0x04, 0x96, 0x0e, 0x70, 0x4b,
	0x37, 0x64, 0x67, 0x18, 0x9b, 0xa4, 0x89, 0x9b, 0x60, 0x38, 0xd4, 0x05, 0x88, 0xb8, 0x90, 0x26,
	0x15, 0x0f, 0x46, 0x0a, 0xc8, 0x30, 0x61, 0x43, 0x0b, 0xc0, 0x66, 0x23, 0x87, 0x29, 0xf4, 0xbe,
	0x98, 0xb4, 0x80, 0x03, 0x62, 0xb4, 0x05, 0x39, 0x85, 0xac, 0x61, 0x99, 0x5e, 0xe9, 0x29, 0x41,
	0xe4, 0x61, 0x65, 0xec, 0x72, 0x91, 0x04, 0x8a, 0x27, 0x1a, 0xc2, 0x74, 0xb1, 0xd5, 0xc2, 0xa5,
	0xdc, 0x64, 0x18, 0x7f, 0xc0, 0x93, 0xc3, 0x50, 0x11, 0xda, 0x81, 0x42, 0xdb, 0x4d, 0x7b, 0xd3,
	0x20, 0x72, 0x3e, 0xf2, 0xb4, 0x12, 0x92, 0xa7, 0x97, 0xf2, 0x6d, 0x9f, 0x10, 0xbd, 0x03, 0x89,
	0x96, 0x5a, 0x2a, 0x50, 0x84, 0x0b, 0x93, 0x72, 0xd3, 0x52, 0xa2, 0xa5, 0xa2, 0x0f, 0x21, 0xc3,
	0x32, 0x79, 0x03, 0xa3, 0xb4, 0x10, 0xb9, 0x78, 0x83, 0x49, 0x54, 0x89, 0x66, 0x1c, 0xc9, 0xbb,
	0xee, 0x43, 0x9e, 0x05, 0x20, 0x3b, 0xf4, 0xbe, 0x44, 0x69, 0x31, 0x72, 0xc2, 0x8d, 0x5f, 0xf9,
	0x90, 0xd8, 0x37, 0x23, 0x4c, 0x86, 0x76, 0x61, 0xc1, 0x62, 0x21, 0x67, 0x99, 0x05, 0xc2, 0x4b,
	0x45, 0x8a, 0x75, 0x2d, 0xdc, 0x95, 0x8c, 0xa5, 0x4a, 0xa4, 0x82, 0xe5, 0x97, 0xa2, 0x1f, 0xc1,
	0x72, 0x10, 0x8f, 0x2f, 0x89, 0x25, 0x8a, 0xfa, 0xce, 0x54, 0x54, 0xff, 0xca, 0x40, 0xd6, 0x58,
	0x11, 0xba, 0x03, 0x69, 0x36, 0xe6, 0x88, 0x02, 0x56, 0x42, 0x00, 0x03, 0xc3, 0xcd, 0x6a, 0x13,
	0x83, 0x39, 0x3c, 0xf4, 0x2a, 0x77, 0xcc, 0x56, 0xe9, 0x74, 0xa4, 0xc1, 0xc6, 0xa3, 0xc8, 0x52,
	0xce, 0x19, 0xca, 0xc8, 0x9c, 0xb1, 0x98, 0x9c, 0x47, 0x06, 0x97, 0x23, 0xe7, 0x4c, 0x48, 0x3c,
	0x56, 0xca, 0x5b, 0x3e, 0x21, 0x1d, 0x47, 0x76, 0x11, 0x46, 0xa6, 0xcb, 0xfe, 0x4c, 0xf4, 0x38,
	0x8e, 0xdd, 0x05, 0x96, 0x72, 0xd6, 0x50, 0x86, 0x9a, 0x50, 0x54, 0x59, 0xb4, 0x48, 0x76, 0xa3,
	0x4c, 0xa5, 0xb3, 0x14, 0xed, 0xad, 0x50, 0x9f, 0x1a, 0x16, 0x5b, 0x93, 0x16, 0xd5, 0xa0, 0x1c,
	0xf5, 0xa0, 0xac, 0x79, 0x51, 0x1c, 0xf9, 0x39, 0x0d, 0xe3, 0x0c, 0xf1, 0xcf, 0x51, 0xfc, 0x5b,
	0xa1, 0x6e, 0x6e, 0x62, 0x60, 0x49, 0x2a, 0x69, 0x11, 0x15, 0x88, 0x33, 0xa3, 0xf8, 0xb2, 0x3a,
	0xbc, 0x93, 0x5b, 0x2a, 0x45, 0x3a, 0xb3, 0x88, 0x7b, 0xc3, 0x52, 0x51, 0x1d, 0x29, 0x20, 0x9e,
	0xd5, 0x30, 0xcd, 0x5e, 0xe9, 0x7c, 0xa4, 0x67, 0xf5, 0x65, 0x62, 0x24, 0x5a, 0x97, 0x2c, 0x52,
	0xdd, 0xd0, 0x1d, 0xba, 0x41, 0x95, 0x23, 0x17, 0x69, 0xf0, 0x1b, 0x11, 0x69, 0x5e, 0x67, 0xff,
	0x93, 0xa5, 0xe5, 0xf0, 0x48, 0x36, 0x9f, 0x2a, 0x17, 0x22, 0x97, 0x56, 0x58, 0xc8, 0x5b, 0x2a,
	0x38, 0x7e, 0x29, 0x59, 0x5a, 0xcc, 0xe9, 0x8d, 0xa0, 0xbe, 0x19, 0xb9, 0xb4, 0x22, 0x6f, 0x09,
	0x4a, 0x48, 0x19, 0x2b, 0x22, 0xe7, 0x40, 0x0a, 0x48, 0xbf, 0x26, 0x2b, 0xad, 0x44, 0xee, 0xa1,
	0xa3, 0x61, 0x6d, 0x29, 0xdb, 0x71, 0x25, 0xc4, 0x31, 0x1f, 0x91, 0x53, 0xb3, 0x7c, 0x40, 0x8e,
	0xcd, 0xa5, 0x4a, 0xa4, 0x63, 0x1e, 0x3b, 0xfb, 0x4b, 0x70, 0xe4, 0x89, 0xc8, 0x56, 0x8c, 0x29,
	0xbd, 0x2f, 0xad, 0x4e, 0xe1, 0xff, 0xde, 0x56, 0xcc, 0xea, 0xa3, 0xef, 0x43, 0xf6, 0x59, 0x1f,
	0x5b, 0xc7, 0xd4, 0xb1, 0x5e, 0x8c, 0xfc, 0x56, 0x70, 0xe4, 0x6a, 0x80, 0x94, 0x79, 0xc6, 0x05,
	0xe4, 0xd5, 0x3a, 0x25, 0xec, 0x25, 0x31, 0xf2, 0xd5, 0x81, 0xa3, 0x8c, 0xc4, 0xeb, 0x23, 0x05,
	0xce, 0xb0, 0xf1, 0xe1, 0xd7, 0x0b, 0x2d, 0x7e, 0x8f, 0xaf, 0x74, 0x89, 0x02, 0x45, 0xf2, 0xd9,
	0xd0, 0x1b, 0x8e, 0xd2, 0x69, 0x65, 0xbc, 0x8c, 0x38, 0x1f, 0xbe, 0x7d, 0x32, 0x0e, 0x5c, 0xba,
	0x1c, 0xe9, 0x7c, 0x42, 0xb8, 0xbf, 0x94, 0x57, 0x7c, 0x42, 0xb6, 0x89, 0x6a, 0xb2, 0x6d, 0x3b,
	0x84, 0x54, 0x96, 0xae, 0x4c, 0xd8, 0x44, 0x47, 0xd8, 0x2d, 0xd9, 0x44, 0xb5, 0x06, 0xd3, 0xfb,
	0x20, 0xf5, 0xf5, 0xcf, 0x2b, 0xc2, 0x83, 0x54, 0xe6, 0x8d, 0xe2, 0x05, 0xf1, 0x17, 0xcb, 0x50,
	0x70, 0x09, 0x27, 0x23, 0x93, 0x37, 0xfd, 0x64, 0x72, 0x25, 0x8a, 0x4c, 0x32, 0x0d, 0xc6, 0x26,
	0x6f, 0xfa, 0xd9, 0xe4, 0x4a, 0x14, 0x9b, 0x74, 0x35, 0x08, 0x9d, 0x94, 0xa2, 0xe8, 0xe4, 0x5b,
	0x33, 0xd0, 0x49, 0x0e, 0x34, 0xca, 0x27, 0x37, 0xc6, 0xf9, 0xe4, 0xe5, 0xc9, 0x7c, 0x92, 0x03,
	0xf9, 0x08, 0xe5, 0xdd, 0x11, 0x42, 0x79, 0x71, 0x02, 0xa1, 0xe4, 0xda, 0x2e, 0xa3, 0xac, 0x87,
	0x32, 0xca, 0xab, 0xd3, 0x18, 0x25, 0x47, 0x09, 0x50, 0xca, 0xdb, 0x01, 0x4a, 0x59, 0x89, 0xa4,
	0x94, 0x5c, 0x97, 0x71, 0xca, 0xcf, 0xa2, 0x39, 0xe5, 0x8d, 0x99, 0x38, 0x25, 0x47, 0x1b, 0x27,
	0x95, 0x52, 0x14, 0xa9, 0x7c, 0x6b, 0x06, 0x52, 0xe9, 0x0e, 0xd6, 0x08, 0xab, 0xbc, 0x17, 0xc6,
	0x2a, 0xaf, 0x4c, 0x61, 0x95, 0x1c, 0xcb, 0x4f, 0x2b, 0xef, 0x85, 0xd1, 0xca, 0x2b, 0x53, 0x68,
	0x65, 0x00, 0x87, 0xf1, 0xca, 0x87, 0xe1, 0xbc, 0xf2, 0xda, 0x54, 0x5e, 0xc9, 0xb1, 0x82, 0xc4,
	0xf2, 0x5d, 0x1f, 0xb1, 0x7c, 0x33, 0x82, 0x58, 0x72, 0x45, 0xc2, 0x2c, 0x3f, 0x1a, 0x63, 0x96,
	0xe2, 0x24, 0x66, 0xc9, 0x35, 0x3d, 0x6a, 0x59, 0x0f, 0xa5, 0x96, 0x57, 0xa7, 0x51, 0x4b, 0x77,
	0xe6, 0xf9, 0xb9, 0xe5, 0xe3, 0x08, 0x6e, 0x79, 0x7d, 0x3a, 0xb7, 0xe4, 0x70, 0x23, 0xe4, 0x52,
	0x9e, 0x48, 0x2e, 0xdf, 0x9d, 0x91, 0x5c, 0x72, 0xec, 0x30, 0x76, 0xf9, 0xff, 0x83, 0xec, 0x72,
	0x35, 0x9a, 0x5d, 0x72, 0x10, 0x4e, 0x2f, 0xeb, 0xa1, 0xf4, 0xf2, 0xea, 0x34, 0x7a, 0xe9, 0x1a,
	0xcd, 0xcf, 0x2f, 0x1f, 0x86, 0xf3, 0xcb, 0x6b, 0x53, 0xf9, 0xa5, 0x3b, 0x77, 0x02, 0x04, 0xb3,
	0x1e, 0x4a, 0x30, 0xaf, 0x4e, 0x23, 0x98, 0xde, 0x68, 0xfa, 0x18, 0xe6, 0x7e, 0x24, 0xc3, 0x7c,
	0x7b, 0x16, 0x86, 0xc9, 0x21, 0xc7, 0x28, 0xe6, 0xb3, 0x19, 0x28, 0xe6, 0xed, 0x57, 0xa2, 0x98,
	0xfc, 0x4d, 0xd1, 0x1c, 0xf3, 0xb3, 0x68, 0x8e, 0x79, 0x63, 0x26, 0x8e, 0xe9, 0x3a, 0xb7, 0x31,
	0x92, 0x79, 0x3b, 0x40, 0x32, 0x2b, 0x91, 0x24, 0xd3, 0xf5, 0xb5, 0x94, 0x65, 0x7e, 0x34, 0xc6,
	0x32, 0xc5, 0x49, 0x2c, 0xd3, 0x5d, 0xb0, 0x2e, 0xcd, 0x94, 0x27, 0xd2, 0xc2, 0x77, 0x67, 0xa4,
	0x85, 0xee, 0xa2, 0x08, 0xe1, 0x85, 0xb5, 0x10, 0x5e, 0x78, 0x79, 0x32, 0x2f, 0x74, 0xf7, 0xc2,
	0x21, 0x31, 0xbc, 0x17, 0x46, 0x0c, 0xaf, 0x4c, 0x21, 0x86, 0xae, 0x6b, 0xf5, 0x31, 0xc3, 0xbb,
	0x23, 0xcc, 0xf0, 0xe2, 0xd4, 0x8c, 0x80, 0x47, 0x0d, 0x3f, 0x1e, 0xa7, 0x86, 0x97, 0x26, 0x52,
	0x43, 0xae, 0x3f, 0xe4, 0x86, 0x77, 0x47, 0xb8, 0xe1, 0xc5, 0x09, 0xdc, 0xd0, 0x7d, 0x39, 0x27,
	0x87, 0x07, 0x93, 0xc9, 0x61, 0x75, 0x56, 0x72, 0xc8, 0x61, 0x43, 0xd9, 0xe1, 0xc3, 0x70, 0x76,
	0x78, 0x6d, 0xc6, 0x40, 0xea, 0x08, 0x3d, 0xbc, 0x17, 0x46, 0x0f, 0xaf, 0x4c, 0xa1, 0x87, 0xc3,
	0xcd, 0x30, 0x8c, 0x1f, 0x3e, 0x48, 0x65, 0x2e, 0x14, 0xdf, 0x14, 0xff, 0x3b, 0x05, 0x73, 0xf7,
	0xdd, 0xbc, 0x85, 0xef, 0xfe, 0xba, 0x70, 0x92, 0xfb, 0xeb, 0x68, 0x13, 0xe6, 0xb9, 0x31, 0x39,
	0x67, 0x9c, 0xf0, 0x09, 0xce, 0xd8, 0x47, 0x19, 0xae, 0xea, 0x09, 0xaf, 0x74, 0xa1, 0xbb, 0x50,
	0xe8, 0xdb, 0xd8, 0x72, 0xaf, 0x4c, 0xb3, 0x7c, 0xa7, 0xb0, 0xb1, 0xcc, 0xbf, 0x9c, 0xca, 0xef,
	0xdb, 0xd8, 0xe2, 0x77, 0xa6, 0x8f, 0xa5, 0x7c, 0xdf, 0xf7, 0x9f, 0xfb, 0x4b, 0x22, 0xe9, 0xd9,
	0x7f, 0x49, 0xe4, 0x09, 0x14, 0x2d, 0xac, 0x68, 0x01, 0xb7, 0xc5, 0x2e, 0x81, 0x87, 0x3b, 0x74,
	0x45, 0xf3, 0xf9, 0x26, 0xdf, 0x65, 0xf0, 0x45, 0x2b, 0x58, 0x84, 0xbe, 0x07, 0x67, 0xba, 0xca,
	0x80, 0x7d, 0xd7, 0xe0, 0x6e, 0x3e, 0x34, 0x9b, 0x93, 0xf1, 0x65, 0x16, 0x50, 0x57, 0x19, 0xd0,
	0x9f, 0x28, 0x61, 0x15, 0xe8, 0xe7, 0xe1, 0x37, 0x60, 0x41, 0xd3, 0x6d, 0x47, 0x37, 0x54, 0xf7,
	0xd3, 0xc8, 0xac, 0xff, 0x46, 0xb3, 0x5b, 0xc6, 0xbe, 0x81, 0xbc, 0x09, 0x4b, 0xfc, 0x93, 0xf3,
	0xe1, 0x8f, 0x96, 0x50, 0xae, 0x96, 0x19, 0xb6, 0x8b, 0x14, 0x0f, 0x7f, 0xf3, 0x65, 0x1b, 0x16,
	0x5b, 0x8a, 0x83, 0x8f, 0x94, 0x63, 0xd9, 0x30, 0x35, 0x3a, 0x36, 0x39, 0xfa, 0x99, 0x51, 0x85,
	0x8f, 0x4d, 0x61, 0x9b, 0x15, 0xef, 0x9a, 0x1a, 0x1b, 0xa1, 0x39, 0xf6, 0x24, 0x15, 0x5a, 0xbe,
	0x02, 0xed, 0x41, 0x2a, 0x33, 0x5f, 0xcc, 0x88, 0x5f, 0x09, 0x90, 0x0f, 0xa4, 0x9b, 0x7f, 0x6d,
	0x24, 0x7e, 0x7e, 0x3e, 0x9c, 0xa0, 0x85, 0xe7, 0x2b, 0xd6, 0x21, 0xc3, 0x6d, 0xe5, 0x66, 0x2c,
	0x2a, 0xd1, 0x7b, 0x34, 0x3d, 0x0c, 0xb9, 0x29, 0x1a, 0x57, 0xed, 0x83, 0xd4, 0x1f, 0xff, 0xbc,
	0x72, 0x4a, 0xfc, 0x8f, 0x24, 0x14, 0x82, 0x59, 0xe6, 0xfa, 0x48, 0xbb, 0xc2, 0x56, 0x70, 0x40,
	0x23, 0xba, 0x95, 0x9b, 0x90, 0xb5, 0x78, 0x25, 0xb7, 0x99, 0xab, 0x13, 0xb2, 0x04, 0xfe, 0x76,
	0x0e, 0x15, 0xcb, 0x7f, 0x9f, 0xf0, 0x56, 0xac, 0x97, 0x1d, 0x11, 0x66, 0xca, 0x8e, 0x90, 0x15,
	0xde, 0x3c, 0xd1, 0x17, 0x2a, 0x9e, 0xe0, 0x04, 0xbf, 0xb9, 0x73, 0xc2, 0xcf, 0x2b, 0x1a, 0xe4,
	0x20, 0xd9, 0xe9, 0x60, 0xd5, 0xe1, 0x3f, 0x4f, 0xe4, 0xfe, 0xa6, 0xce, 0xe5, 0x51, 0x08, 0xfe,
	0x63, 0x46, 0x55, 0x89, 0xff, 0x98, 0x91, 0x2f, 0x89, 0xb4, 0xe0, 0x41, 0xd0, 0x69, 0xcf, 0xf2,
	0x80, 0x6c, 0xa8, 0xdf, 0x7e, 0x08, 0xa7, 0x43, 0x96, 0x25, 0x5a, 0x00, 0xa8, 0x3d, 0xde, 0x6d,
	0xd4, 0x1b, 0xcd, 0xad, 0xdd, 0x66, 0xf1, 0x14, 0x2a, 0x40, 0x96, 0xfc, 0xbf, 0xb5, 0xdb, 0xd8,
	0x6f, 0x14, 0x05, 0x54, 0x84, 0x7c, 0x7d, 0xd7, 0x57, 0x21, 0x51, 0x4e, 0xfd, 0xee, 0x2f, 0x56,
	0x4e, 0xbd, 0xfd, 0x04, 0x72, 0xbe, 0x2f, 0x3d, 0x10, 0x82, 0x85, 0xbd, 0xfd, 0xc6, 0x7d, 0xb9,
	0x59, 0x7f, 0xb4, 0xd5, 0x68, 0xae, 0x3f, 0xda, 0x2b, 0x9e, 0x22, 0xc8, 0x54, 0xb6, 0xbe, 0xf1,
	0x58, 0x6a, 0x16, 0x05, 0xef, 0xff, 0xe6, 0xe3, 0xfd, 0xda, 0xfd, 0x62, 0xc2, 0xfb, 0xff, 0x93,
	0xfd, 0x2d, 0xe9, 0xf3, 0x62, 0x92, 0x03, 0x2b, 0x70, 0x26, 0xf4, 0x7a, 0x14, 0xca, 0xc1, 0xfc,
	0xbe, 0x41, 0xbf, 0x21, 0x60, 0xad, 0xf4, 0xee, 0xe7, 0x14, 0x05, 0x94, 0x61, 0x77, 0x70, 0x8a,
	0x09, 0x34, 0x07, 0x89, 0xc6, 0xed, 0x62, 0x12, 0x2d, 0x42, 0xce, 0x77, 0xc1, 0xa8, 0x98, 0x42,
	0x59, 0x7e, 0x1f, 0xa5, 0x98, 0xbe, 0xf5, 0x19, 0x64, 0xdc, 0x4f, 0xb0, 0xd1, 0x43, 0x48, 0xb3,
	0xcd, 0xbd, 0x12, 0x3d, 0xcf, 0xe9, 0x8a, 0x29, 0xaf, 0x4e, 0x5b, 0x08, 0xe2, 0x29, 0x82, 0xbc,
	0x35, 0xf8, 0x55, 0x20, 0x6f, 0x5c, 0xfc, 0xfa, 0xdf, 0x57, 0x4e, 0x7d, 0xfd, 0x72, 0x45, 0xf8,
	0xe6, 0xe5, 0x8a, 0xf0, 0xcf, 0x2f, 0x57, 0x84, 0x7f, 0x7b, 0xb9, 0x22, 0xfc, 0xe1, 0x2f, 0x57,
	0x4e, 0x7d, 0x31, 0xcf, 0x55, 0xfe, 0x27, 0x00, 0x00, 0xff, 0xff, 0xe6, 0xc0, 0x09, 0xce, 0xf3,
	0x4b, 0x00, 0x00,
}
