// Code generated by protoc-gen-gogo.
// source: cockroach/pkg/sql/distsqlrun/processors.proto
// DO NOT EDIT!

package distsqlrun

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import cockroach_roachpb1 "github.com/cockroachdb/cockroach/pkg/roachpb"
import cockroach_sql_sqlbase1 "github.com/cockroachdb/cockroach/pkg/sql/sqlbase"

import time "time"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf
var _ = time.Kitchen

type JoinType int32

const (
	JoinType_INNER       JoinType = 0
	JoinType_LEFT_OUTER  JoinType = 1
	JoinType_RIGHT_OUTER JoinType = 2
	JoinType_FULL_OUTER  JoinType = 3
)

var JoinType_name = map[int32]string{
	0: "INNER",
	1: "LEFT_OUTER",
	2: "RIGHT_OUTER",
	3: "FULL_OUTER",
}
var JoinType_value = map[string]int32{
	"INNER":       0,
	"LEFT_OUTER":  1,
	"RIGHT_OUTER": 2,
	"FULL_OUTER":  3,
}

func (x JoinType) Enum() *JoinType {
	p := new(JoinType)
	*p = x
	return p
}
func (x JoinType) String() string {
	return proto.EnumName(JoinType_name, int32(x))
}
func (x *JoinType) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(JoinType_value, data, "JoinType")
	if err != nil {
		return err
	}
	*x = JoinType(value)
	return nil
}
func (JoinType) EnumDescriptor() ([]byte, []int) { return fileDescriptorProcessors, []int{0} }

// These mirror the aggregate functions supported by sql/parser. See
// sql/parser/aggregate_builtins.go.
type AggregatorSpec_Func int32

const (
	// The identity function is set to be the default zero-value function,
	// returning the last value added.
	AggregatorSpec_IDENT      AggregatorSpec_Func = 0
	AggregatorSpec_AVG        AggregatorSpec_Func = 1
	AggregatorSpec_BOOL_AND   AggregatorSpec_Func = 2
	AggregatorSpec_BOOL_OR    AggregatorSpec_Func = 3
	AggregatorSpec_CONCAT_AGG AggregatorSpec_Func = 4
	AggregatorSpec_COUNT      AggregatorSpec_Func = 5
	AggregatorSpec_MAX        AggregatorSpec_Func = 7
	AggregatorSpec_MIN        AggregatorSpec_Func = 8
	AggregatorSpec_STDDEV     AggregatorSpec_Func = 9
	AggregatorSpec_SUM        AggregatorSpec_Func = 10
	AggregatorSpec_SUM_INT    AggregatorSpec_Func = 11
	AggregatorSpec_VARIANCE   AggregatorSpec_Func = 12
	AggregatorSpec_XOR_AGG    AggregatorSpec_Func = 13
)

var AggregatorSpec_Func_name = map[int32]string{
	0:  "IDENT",
	1:  "AVG",
	2:  "BOOL_AND",
	3:  "BOOL_OR",
	4:  "CONCAT_AGG",
	5:  "COUNT",
	7:  "MAX",
	8:  "MIN",
	9:  "STDDEV",
	10: "SUM",
	11: "SUM_INT",
	12: "VARIANCE",
	13: "XOR_AGG",
}
var AggregatorSpec_Func_value = map[string]int32{
	"IDENT":      0,
	"AVG":        1,
	"BOOL_AND":   2,
	"BOOL_OR":    3,
	"CONCAT_AGG": 4,
	"COUNT":      5,
	"MAX":        7,
	"MIN":        8,
	"STDDEV":     9,
	"SUM":        10,
	"SUM_INT":    11,
	"VARIANCE":   12,
	"XOR_AGG":    13,
}

func (x AggregatorSpec_Func) Enum() *AggregatorSpec_Func {
	p := new(AggregatorSpec_Func)
	*p = x
	return p
}
func (x AggregatorSpec_Func) String() string {
	return proto.EnumName(AggregatorSpec_Func_name, int32(x))
}
func (x *AggregatorSpec_Func) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(AggregatorSpec_Func_value, data, "AggregatorSpec_Func")
	if err != nil {
		return err
	}
	*x = AggregatorSpec_Func(value)
	return nil
}
func (AggregatorSpec_Func) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorProcessors, []int{12, 0}
}

type BackfillerSpec_Type int32

const (
	BackfillerSpec_Invalid BackfillerSpec_Type = 0
	BackfillerSpec_Column  BackfillerSpec_Type = 1
	BackfillerSpec_Index   BackfillerSpec_Type = 2
)

var BackfillerSpec_Type_name = map[int32]string{
	0: "Invalid",
	1: "Column",
	2: "Index",
}
var BackfillerSpec_Type_value = map[string]int32{
	"Invalid": 0,
	"Column":  1,
	"Index":   2,
}

func (x BackfillerSpec_Type) Enum() *BackfillerSpec_Type {
	p := new(BackfillerSpec_Type)
	*p = x
	return p
}
func (x BackfillerSpec_Type) String() string {
	return proto.EnumName(BackfillerSpec_Type_name, int32(x))
}
func (x *BackfillerSpec_Type) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(BackfillerSpec_Type_value, data, "BackfillerSpec_Type")
	if err != nil {
		return err
	}
	*x = BackfillerSpec_Type(value)
	return nil
}
func (BackfillerSpec_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorProcessors, []int{13, 0}
}

type AlgebraicSetOpSpec_SetOpType int32

const (
	AlgebraicSetOpSpec_Except_all AlgebraicSetOpSpec_SetOpType = 0
)

var AlgebraicSetOpSpec_SetOpType_name = map[int32]string{
	0: "Except_all",
}
var AlgebraicSetOpSpec_SetOpType_value = map[string]int32{
	"Except_all": 0,
}

func (x AlgebraicSetOpSpec_SetOpType) Enum() *AlgebraicSetOpSpec_SetOpType {
	p := new(AlgebraicSetOpSpec_SetOpType)
	*p = x
	return p
}
func (x AlgebraicSetOpSpec_SetOpType) String() string {
	return proto.EnumName(AlgebraicSetOpSpec_SetOpType_name, int32(x))
}
func (x *AlgebraicSetOpSpec_SetOpType) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(AlgebraicSetOpSpec_SetOpType_value, data, "AlgebraicSetOpSpec_SetOpType")
	if err != nil {
		return err
	}
	*x = AlgebraicSetOpSpec_SetOpType(value)
	return nil
}
func (AlgebraicSetOpSpec_SetOpType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorProcessors, []int{15, 0}
}

// Each processor has the following components:
//  - one or more input synchronizers; each one merges rows between one or more
//    input streams;
//
//  - a processor "core" which encapsulates the inner logic of each processor;
//
//  - a post-processing stage which allows "inline" post-processing on results
//    (like projection or filtering);
//
//  - one or more output synchronizers; each one directs rows to one or more
//  output streams.
//
//
// == Internal columns ==
//
// The core outputs rows of a certain schema to the post-processing stage. We
// call this the "internal schema" (or "internal columns") and it differs for
// each type of core. Column indices in a PostProcessSpec refers to these
// internal columns. Some columns may be unused by the post-processing stage;
// processor implementations are internally optimized to not produce values for
// such unneded columns.
type ProcessorSpec struct {
	// In most cases, there is one input.
	Input []InputSyncSpec    `protobuf:"bytes,1,rep,name=input" json:"input"`
	Core  ProcessorCoreUnion `protobuf:"bytes,2,opt,name=core" json:"core"`
	Post  PostProcessSpec    `protobuf:"bytes,4,opt,name=post" json:"post"`
	// In most cases, there is one output.
	Output []OutputRouterSpec `protobuf:"bytes,3,rep,name=output" json:"output"`
	// An optional identifier that can be used to correlate processors that are
	// part of the same stage (e.g. multiple joiners that are part of a
	// distributed join). This has no consequence on the running of flows, but is
	// useful for plan diagrams.
	StageID int32 `protobuf:"varint,5,opt,name=stage_id,json=stageId" json:"stage_id"`
}

func (m *ProcessorSpec) Reset()                    { *m = ProcessorSpec{} }
func (m *ProcessorSpec) String() string            { return proto.CompactTextString(m) }
func (*ProcessorSpec) ProtoMessage()               {}
func (*ProcessorSpec) Descriptor() ([]byte, []int) { return fileDescriptorProcessors, []int{0} }

// PostProcessSpec describes the processing required to obtain the output
// (filtering, projection). It operates on the internal schema of the processor
// (see ProcessorSpec).
type PostProcessSpec struct {
	// A filtering expression which references the internal columns of the
	// processor via ordinal references (@1, @2, etc).
	Filter Expression `protobuf:"bytes,1,opt,name=filter" json:"filter"`
	// If true, output_columns describes a projection. Used to differentiate
	// between an empty projection and no projection.
	//
	// Cannot be set at the same time with render expressions.
	Projection bool `protobuf:"varint,2,opt,name=projection" json:"projection"`
	// The output columns describe a projection on the internal set of columns;
	// only the columns in this list will be emitted.
	//
	// Can only be set if projection is true. Cannot be set at the same time with
	// render expressions.
	OutputColumns []uint32 `protobuf:"varint,3,rep,packed,name=output_columns,json=outputColumns" json:"output_columns,omitempty"`
	// If set, the output is the result of rendering these expressions. The
	// expressions reference the internal columns of the processor.
	//
	// Cannot be set at the same time with output columns.
	RenderExprs []Expression `protobuf:"bytes,4,rep,name=render_exprs,json=renderExprs" json:"render_exprs"`
	// If nonzero, the first <offset> rows will be suppressed.
	Offset uint64 `protobuf:"varint,5,opt,name=offset" json:"offset"`
	// If nonzero, the processor will stop after emitting this many rows. The rows
	// suppressed by <offset>, if any, do not count towards this limit.
	Limit uint64 `protobuf:"varint,6,opt,name=limit" json:"limit"`
}

func (m *PostProcessSpec) Reset()                    { *m = PostProcessSpec{} }
func (m *PostProcessSpec) String() string            { return proto.CompactTextString(m) }
func (*PostProcessSpec) ProtoMessage()               {}
func (*PostProcessSpec) Descriptor() ([]byte, []int) { return fileDescriptorProcessors, []int{1} }

type ProcessorCoreUnion struct {
	Noop        *NoopCoreSpec       `protobuf:"bytes,1,opt,name=noop" json:"noop,omitempty"`
	TableReader *TableReaderSpec    `protobuf:"bytes,2,opt,name=tableReader" json:"tableReader,omitempty"`
	JoinReader  *JoinReaderSpec     `protobuf:"bytes,3,opt,name=joinReader" json:"joinReader,omitempty"`
	Sorter      *SorterSpec         `protobuf:"bytes,4,opt,name=sorter" json:"sorter,omitempty"`
	Aggregator  *AggregatorSpec     `protobuf:"bytes,5,opt,name=aggregator" json:"aggregator,omitempty"`
	Distinct    *DistinctSpec       `protobuf:"bytes,7,opt,name=distinct" json:"distinct,omitempty"`
	MergeJoiner *MergeJoinerSpec    `protobuf:"bytes,8,opt,name=mergeJoiner" json:"mergeJoiner,omitempty"`
	HashJoiner  *HashJoinerSpec     `protobuf:"bytes,9,opt,name=hashJoiner" json:"hashJoiner,omitempty"`
	Values      *ValuesCoreSpec     `protobuf:"bytes,10,opt,name=values" json:"values,omitempty"`
	Backfiller  *BackfillerSpec     `protobuf:"bytes,11,opt,name=backfiller" json:"backfiller,omitempty"`
	SetOp       *AlgebraicSetOpSpec `protobuf:"bytes,12,opt,name=setOp" json:"setOp,omitempty"`
}

func (m *ProcessorCoreUnion) Reset()                    { *m = ProcessorCoreUnion{} }
func (m *ProcessorCoreUnion) String() string            { return proto.CompactTextString(m) }
func (*ProcessorCoreUnion) ProtoMessage()               {}
func (*ProcessorCoreUnion) Descriptor() ([]byte, []int) { return fileDescriptorProcessors, []int{2} }

// NoopCoreSpec indicates a "no-op" processor core. This is used when we just
// need post-processing or when only a synchronizer is required (e.g. at the
// final endpoint).
type NoopCoreSpec struct {
}

func (m *NoopCoreSpec) Reset()                    { *m = NoopCoreSpec{} }
func (m *NoopCoreSpec) String() string            { return proto.CompactTextString(m) }
func (*NoopCoreSpec) ProtoMessage()               {}
func (*NoopCoreSpec) Descriptor() ([]byte, []int) { return fileDescriptorProcessors, []int{3} }

// ValuesCoreSpec is the core of a processor that has no inputs and generates
// "pre-canned" rows. This is not intended to be used for very large datasets.
type ValuesCoreSpec struct {
	// There is one DatumInfo for each element in a row.
	Columns []DatumInfo `protobuf:"bytes,1,rep,name=columns" json:"columns"`
	// Each raw block encodes one or more data rows; each datum is encoded
	// according to the corresponding DatumInfo.
	RawBytes [][]byte `protobuf:"bytes,2,rep,name=raw_bytes,json=rawBytes" json:"raw_bytes,omitempty"`
}

func (m *ValuesCoreSpec) Reset()                    { *m = ValuesCoreSpec{} }
func (m *ValuesCoreSpec) String() string            { return proto.CompactTextString(m) }
func (*ValuesCoreSpec) ProtoMessage()               {}
func (*ValuesCoreSpec) Descriptor() ([]byte, []int) { return fileDescriptorProcessors, []int{4} }

type TableReaderSpan struct {
	// TODO(radu): the dist_sql APIs should be agnostic to how we map tables to
	// KVs. The span should be described as starting and ending lists of values
	// for a prefix of the index columns, along with inclusive/exclusive flags.
	Span cockroach_roachpb1.Span `protobuf:"bytes,1,opt,name=span" json:"span"`
}

func (m *TableReaderSpan) Reset()                    { *m = TableReaderSpan{} }
func (m *TableReaderSpan) String() string            { return proto.CompactTextString(m) }
func (*TableReaderSpan) ProtoMessage()               {}
func (*TableReaderSpan) Descriptor() ([]byte, []int) { return fileDescriptorProcessors, []int{5} }

// TableReaderSpec is the specification for a "table reader". A table reader
// performs KV operations to retrieve rows for a table and outputs the desired
// columns of the rows that pass a filter expression.
//
// The "internal columns" of a TableReader (see ProcessorSpec) are all the
// columns of the table. Internally, only the values for the columns needed by
// the post-processing stage are be populated.
type TableReaderSpec struct {
	Table cockroach_sql_sqlbase1.TableDescriptor `protobuf:"bytes,1,opt,name=table" json:"table"`
	// If 0, we use the primary index. If non-zero, we use the index_idx-th index,
	// i.e. table.indexes[index_idx-1]
	IndexIdx uint32            `protobuf:"varint,2,opt,name=index_idx,json=indexIdx" json:"index_idx"`
	Reverse  bool              `protobuf:"varint,3,opt,name=reverse" json:"reverse"`
	Spans    []TableReaderSpan `protobuf:"bytes,4,rep,name=spans" json:"spans"`
	// A hint for how many rows the consumer of the table reader output might
	// need. This is used to size the initial KV batches to try to avoid reading
	// many more rows than needed by the processor receiving the output.
	//
	// Not used if there is a limit set in the PostProcessSpec of this processor
	// (that value will be used for sizing batches instead).
	LimitHint int64 `protobuf:"varint,5,opt,name=limit_hint,json=limitHint" json:"limit_hint"`
}

func (m *TableReaderSpec) Reset()                    { *m = TableReaderSpec{} }
func (m *TableReaderSpec) String() string            { return proto.CompactTextString(m) }
func (*TableReaderSpec) ProtoMessage()               {}
func (*TableReaderSpec) Descriptor() ([]byte, []int) { return fileDescriptorProcessors, []int{6} }

// JoinReaderSpec is the specification for a "join reader". A join reader
// performs KV operations to retrieve specific rows that correspond to the
// values in the input stream (join by lookup).
//
// The "internal columns" of a JoinReader (see ProcessorSpec) are all the
// columns of the table. Internally, only the values for the columns needed by
// the post-processing stage are be populated.
type JoinReaderSpec struct {
	Table cockroach_sql_sqlbase1.TableDescriptor `protobuf:"bytes,1,opt,name=table" json:"table"`
	// If 0, we use the primary index; each row in the input stream has a value
	// for each primary key.
	// TODO(radu): figure out the correct semantics when joining with an index.
	IndexIdx uint32 `protobuf:"varint,2,opt,name=index_idx,json=indexIdx" json:"index_idx"`
}

func (m *JoinReaderSpec) Reset()                    { *m = JoinReaderSpec{} }
func (m *JoinReaderSpec) String() string            { return proto.CompactTextString(m) }
func (*JoinReaderSpec) ProtoMessage()               {}
func (*JoinReaderSpec) Descriptor() ([]byte, []int) { return fileDescriptorProcessors, []int{7} }

// SorterSpec is the specification for a "sorting aggregator". A sorting
// processor sorts elements in the input stream providing a certain output
// order guarantee regardless of the input ordering. The output ordering is
// according to a configurable set of columns.
//
// The "internal columns" of a Sorter (see ProcessorSpec) are the same as the
// input columns.
type SorterSpec struct {
	OutputOrdering Ordering `protobuf:"bytes,1,opt,name=output_ordering,json=outputOrdering" json:"output_ordering"`
	// Ordering match length, specifying that the input is already sorted by the
	// first 'n' output ordering columns, can be optionally specified for
	// possible speed-ups taking advantage of the partial orderings.
	OrderingMatchLen uint32 `protobuf:"varint,2,opt,name=ordering_match_len,json=orderingMatchLen" json:"ordering_match_len"`
}

func (m *SorterSpec) Reset()                    { *m = SorterSpec{} }
func (m *SorterSpec) String() string            { return proto.CompactTextString(m) }
func (*SorterSpec) ProtoMessage()               {}
func (*SorterSpec) Descriptor() ([]byte, []int) { return fileDescriptorProcessors, []int{8} }

type DistinctSpec struct {
	// The ordered columns in the input stream can be optionally specified for
	// possible optimizations. The specific ordering (ascending/descending) of
	// the column itself is not important nor is the order in which the columns
	// are specified.
	OrderedColumns []uint32 `protobuf:"varint,1,rep,name=ordered_columns,json=orderedColumns" json:"ordered_columns,omitempty"`
	// The distinct columns in the input stream are those columns on which we
	// check for distinct rows. If A,B,C are in distinct_columns and there is a
	// 4th column D which is not included in distinct_columns, its values are not
	// considered, so rows A1,B1,C1,D1 and A1,B1,C1,D2 are considered equal and
	// only one of them (the first) is output.
	DistinctColumns []uint32 `protobuf:"varint,2,rep,name=distinct_columns,json=distinctColumns" json:"distinct_columns,omitempty"`
}

func (m *DistinctSpec) Reset()                    { *m = DistinctSpec{} }
func (m *DistinctSpec) String() string            { return proto.CompactTextString(m) }
func (*DistinctSpec) ProtoMessage()               {}
func (*DistinctSpec) Descriptor() ([]byte, []int) { return fileDescriptorProcessors, []int{9} }

// MergeJoinerSpec is the specification for a merge join processor. The processor
// has two inputs and one output. The inputs must have the same ordering on the
// columns that have equality constraints. For example:
//   SELECT * FROM T1 INNER JOIN T2 ON T1.C1 = T2.C5 AND T1.C2 = T2.C4
//
// To perform a merge join, the streams corresponding to T1 and T2 must have the
// same ordering on columns C1, C2 and C5, C4 respectively. For example: C1+,C2-
// and C5+,C4-.
//
// The "internal columns" of a MergeJoiner (see ProcessorSpec) are the
// concatenation of left input columns and right input columns. If the left
// input has N columns and the right input has M columns, the first N columns
// contain values from the left side and the following M columns contain values
// from the right side.
type MergeJoinerSpec struct {
	// The streams must be ordered according to the columns that have equality
	// constraints. The first column of the left ordering is constrained to be
	// equal to the first column in the right ordering and so on. The ordering
	// lengths and directions must match.
	// In the example above, left ordering describes C1+,C2- and right ordering
	// describes C5+,C4-.
	LeftOrdering  Ordering `protobuf:"bytes,1,opt,name=left_ordering,json=leftOrdering" json:"left_ordering"`
	RightOrdering Ordering `protobuf:"bytes,2,opt,name=right_ordering,json=rightOrdering" json:"right_ordering"`
	// "ON" expression (in addition to the equality constraints captured by the
	// orderings). Assuming that the left stream has N columns and the right
	// stream has M columns, in this expression ordinal references @1 to @N refer
	// to columns of the left stream and variables @(N+1) to @(N+M) refer to
	// columns in the right stream.
	OnExpr Expression `protobuf:"bytes,5,opt,name=on_expr,json=onExpr" json:"on_expr"`
	Type   JoinType   `protobuf:"varint,6,opt,name=type,enum=cockroach.sql.distsqlrun.JoinType" json:"type"`
}

func (m *MergeJoinerSpec) Reset()                    { *m = MergeJoinerSpec{} }
func (m *MergeJoinerSpec) String() string            { return proto.CompactTextString(m) }
func (*MergeJoinerSpec) ProtoMessage()               {}
func (*MergeJoinerSpec) Descriptor() ([]byte, []int) { return fileDescriptorProcessors, []int{10} }

// HashJoinerSpec is the specification for a hash join processor. The processor
// has two inputs and one output.
//
// The processor works by reading the entire right input and putting it in a hash
// table. Thus, there is no guarantee on the ordering of results that stem only
// from the right input (in the case of RIGHT_OUTER, FULL_OUTER). However, it is
// guaranteed that results that involve the left stream preserve the ordering;
// i.e. all results that stem from left row (i) precede results that stem from
// left row (i+1).
//
// The "internal columns" of a HashJoiner (see ProcessorSpec) are the
// concatenation of left input columns and right input columns. If the left
// input has N columns and the right input has M columns, the first N columns
// contain values from the left side and the following M columns contain values
// from the right side.
type HashJoinerSpec struct {
	// The join constraints certain columns from the left stream to equal
	// corresponding columns on the right stream. These must have the same length.
	LeftEqColumns  []uint32 `protobuf:"varint,1,rep,packed,name=left_eq_columns,json=leftEqColumns" json:"left_eq_columns,omitempty"`
	RightEqColumns []uint32 `protobuf:"varint,2,rep,packed,name=right_eq_columns,json=rightEqColumns" json:"right_eq_columns,omitempty"`
	// "ON" expression (in addition to the equality constraints captured by the
	// orderings). Assuming that the left stream has N columns and the right
	// stream has M columns, in this expression variables @1 to @N refer to
	// columns of the left stream and variables @N to @(N+M) refer to columns in
	// the right stream.
	OnExpr Expression `protobuf:"bytes,5,opt,name=on_expr,json=onExpr" json:"on_expr"`
	Type   JoinType   `protobuf:"varint,6,opt,name=type,enum=cockroach.sql.distsqlrun.JoinType" json:"type"`
}

func (m *HashJoinerSpec) Reset()                    { *m = HashJoinerSpec{} }
func (m *HashJoinerSpec) String() string            { return proto.CompactTextString(m) }
func (*HashJoinerSpec) ProtoMessage()               {}
func (*HashJoinerSpec) Descriptor() ([]byte, []int) { return fileDescriptorProcessors, []int{11} }

// AggregatorSpec is the specification for an "aggregator" (processor core
// type, not the logical plan computation stage). An aggregator performs
// 'aggregation' in the SQL sense in that it groups rows and computes an aggregate
// for each group. The group is configured using the group key. The aggregator
// can be configured with one or more aggregation functions.
//
// The "internal columns" of an Aggregator map 1-1 to the aggregations.
type AggregatorSpec struct {
	// The group key is a subset of the columns in the input stream schema on the
	// basis of which we define our groups.
	GroupCols    []uint32                     `protobuf:"varint,2,rep,packed,name=group_cols,json=groupCols" json:"group_cols,omitempty"`
	Aggregations []AggregatorSpec_Aggregation `protobuf:"bytes,3,rep,name=aggregations" json:"aggregations"`
}

func (m *AggregatorSpec) Reset()                    { *m = AggregatorSpec{} }
func (m *AggregatorSpec) String() string            { return proto.CompactTextString(m) }
func (*AggregatorSpec) ProtoMessage()               {}
func (*AggregatorSpec) Descriptor() ([]byte, []int) { return fileDescriptorProcessors, []int{12} }

type AggregatorSpec_Aggregation struct {
	Func AggregatorSpec_Func `protobuf:"varint,1,opt,name=func,enum=cockroach.sql.distsqlrun.AggregatorSpec_Func" json:"func"`
	// Aggregation functions with distinct = true functions like you would
	// expect '<FUNC> DISTINCT' to operate, the default behaviour would be
	// the '<FUNC> ALL' operation.
	Distinct bool `protobuf:"varint,2,opt,name=distinct" json:"distinct"`
	// The column index specifies the argument to the aggregator function.
	ColIdx uint32 `protobuf:"varint,3,opt,name=col_idx,json=colIdx" json:"col_idx"`
	// If set, this column index specifies a boolean argument; rows for which
	// this value is not true don't contribute to this aggregation. This enables
	// the filter clause, e.g.:
	//   SELECT SUM(x) FILTER (WHERE y > 1), SUM(x) FILTER (WHERE y < 1) FROM t
	FilterColIdx *uint32 `protobuf:"varint,4,opt,name=filter_col_idx,json=filterColIdx" json:"filter_col_idx,omitempty"`
}

func (m *AggregatorSpec_Aggregation) Reset()         { *m = AggregatorSpec_Aggregation{} }
func (m *AggregatorSpec_Aggregation) String() string { return proto.CompactTextString(m) }
func (*AggregatorSpec_Aggregation) ProtoMessage()    {}
func (*AggregatorSpec_Aggregation) Descriptor() ([]byte, []int) {
	return fileDescriptorProcessors, []int{12, 0}
}

// BackfillerSpec is the specification for a "schema change backfiller".
// The created backfill processor runs a backfill for the first mutations in
// the table descriptor mutation list with the same mutation id and type.
// A backfiller processor performs KV operations to retrieve rows for a
// table and backfills the new indexes/columns contained in the table
// descriptor. It checkpoints its progress by updating the table
// descriptor in the database, and doesn't emit any rows nor support
// any post-processing.
type BackfillerSpec struct {
	Type  BackfillerSpec_Type                    `protobuf:"varint,1,opt,name=type,enum=cockroach.sql.distsqlrun.BackfillerSpec_Type" json:"type"`
	Table cockroach_sql_sqlbase1.TableDescriptor `protobuf:"bytes,2,opt,name=table" json:"table"`
	// Sections of the table to be backfilled.
	Spans []TableReaderSpan `protobuf:"bytes,3,rep,name=spans" json:"spans"`
	// Run the backfill for approximately this duration.
	// The backfill will always process at least one backfill chunk.
	Duration time.Duration `protobuf:"varint,4,opt,name=duration,casttype=time.Duration" json:"duration"`
	// The backfill involves a complete table scan in chunks,
	// where each chunk is a transactional read of a set of rows
	// along with a backfill for the rows. This is the maximum number
	// of entries backfilled per chunk.
	ChunkSize int64 `protobuf:"varint,5,opt,name=chunk_size,json=chunkSize" json:"chunk_size"`
	// Any other (leased) table descriptors necessary for the
	// backfiller to do its job, such as the descriptors for tables with fk
	// relationships to the table being modified.
	OtherTables []cockroach_sql_sqlbase1.TableDescriptor `protobuf:"bytes,6,rep,name=other_tables,json=otherTables" json:"other_tables"`
}

func (m *BackfillerSpec) Reset()                    { *m = BackfillerSpec{} }
func (m *BackfillerSpec) String() string            { return proto.CompactTextString(m) }
func (*BackfillerSpec) ProtoMessage()               {}
func (*BackfillerSpec) Descriptor() ([]byte, []int) { return fileDescriptorProcessors, []int{13} }

// FlowSpec describes a "flow" which is a subgraph of a distributed SQL
// computation consisting of processors and streams.
type FlowSpec struct {
	FlowID     FlowID          `protobuf:"bytes,1,opt,name=flow_id,json=flowId,customtype=FlowID" json:"flow_id"`
	Processors []ProcessorSpec `protobuf:"bytes,2,rep,name=processors" json:"processors"`
}

func (m *FlowSpec) Reset()                    { *m = FlowSpec{} }
func (m *FlowSpec) String() string            { return proto.CompactTextString(m) }
func (*FlowSpec) ProtoMessage()               {}
func (*FlowSpec) Descriptor() ([]byte, []int) { return fileDescriptorProcessors, []int{14} }

// AlgebraicSetOpSpec is a specification for algebraic set operations currently
// only the EXCEPT ALL set operation, but extensible to other set operations.
// INTERSECT ALL is implemented with HashJoinerSpec, and UNION ALL with
// a no-op processor. EXCEPT/INTERSECT/UNION use a DISTINCT processor at
// the end. The two input streams should have the same schema. The ordering
// of the left stream will be preserved in the output stream.
type AlgebraicSetOpSpec struct {
	// If the two input streams are both ordered by a common column ordering,
	// that ordering can be used to optimize resource usage in the processor.
	Ordering Ordering                     `protobuf:"bytes,1,opt,name=ordering" json:"ordering"`
	OpType   AlgebraicSetOpSpec_SetOpType `protobuf:"varint,2,opt,name=op_type,json=opType,enum=cockroach.sql.distsqlrun.AlgebraicSetOpSpec_SetOpType" json:"op_type"`
}

func (m *AlgebraicSetOpSpec) Reset()                    { *m = AlgebraicSetOpSpec{} }
func (m *AlgebraicSetOpSpec) String() string            { return proto.CompactTextString(m) }
func (*AlgebraicSetOpSpec) ProtoMessage()               {}
func (*AlgebraicSetOpSpec) Descriptor() ([]byte, []int) { return fileDescriptorProcessors, []int{15} }

func init() {
	proto.RegisterType((*ProcessorSpec)(nil), "cockroach.sql.distsqlrun.ProcessorSpec")
	proto.RegisterType((*PostProcessSpec)(nil), "cockroach.sql.distsqlrun.PostProcessSpec")
	proto.RegisterType((*ProcessorCoreUnion)(nil), "cockroach.sql.distsqlrun.ProcessorCoreUnion")
	proto.RegisterType((*NoopCoreSpec)(nil), "cockroach.sql.distsqlrun.NoopCoreSpec")
	proto.RegisterType((*ValuesCoreSpec)(nil), "cockroach.sql.distsqlrun.ValuesCoreSpec")
	proto.RegisterType((*TableReaderSpan)(nil), "cockroach.sql.distsqlrun.TableReaderSpan")
	proto.RegisterType((*TableReaderSpec)(nil), "cockroach.sql.distsqlrun.TableReaderSpec")
	proto.RegisterType((*JoinReaderSpec)(nil), "cockroach.sql.distsqlrun.JoinReaderSpec")
	proto.RegisterType((*SorterSpec)(nil), "cockroach.sql.distsqlrun.SorterSpec")
	proto.RegisterType((*DistinctSpec)(nil), "cockroach.sql.distsqlrun.DistinctSpec")
	proto.RegisterType((*MergeJoinerSpec)(nil), "cockroach.sql.distsqlrun.MergeJoinerSpec")
	proto.RegisterType((*HashJoinerSpec)(nil), "cockroach.sql.distsqlrun.HashJoinerSpec")
	proto.RegisterType((*AggregatorSpec)(nil), "cockroach.sql.distsqlrun.AggregatorSpec")
	proto.RegisterType((*AggregatorSpec_Aggregation)(nil), "cockroach.sql.distsqlrun.AggregatorSpec.Aggregation")
	proto.RegisterType((*BackfillerSpec)(nil), "cockroach.sql.distsqlrun.BackfillerSpec")
	proto.RegisterType((*FlowSpec)(nil), "cockroach.sql.distsqlrun.FlowSpec")
	proto.RegisterType((*AlgebraicSetOpSpec)(nil), "cockroach.sql.distsqlrun.AlgebraicSetOpSpec")
	proto.RegisterEnum("cockroach.sql.distsqlrun.JoinType", JoinType_name, JoinType_value)
	proto.RegisterEnum("cockroach.sql.distsqlrun.AggregatorSpec_Func", AggregatorSpec_Func_name, AggregatorSpec_Func_value)
	proto.RegisterEnum("cockroach.sql.distsqlrun.BackfillerSpec_Type", BackfillerSpec_Type_name, BackfillerSpec_Type_value)
	proto.RegisterEnum("cockroach.sql.distsqlrun.AlgebraicSetOpSpec_SetOpType", AlgebraicSetOpSpec_SetOpType_name, AlgebraicSetOpSpec_SetOpType_value)
}
func (m *ProcessorSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProcessorSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Input) > 0 {
		for _, msg := range m.Input {
			dAtA[i] = 0xa
			i++
			i = encodeVarintProcessors(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.Core.Size()))
	n1, err := m.Core.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n1
	if len(m.Output) > 0 {
		for _, msg := range m.Output {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintProcessors(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x22
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.Post.Size()))
	n2, err := m.Post.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n2
	dAtA[i] = 0x28
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.StageID))
	return i, nil
}

func (m *PostProcessSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *PostProcessSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.Filter.Size()))
	n3, err := m.Filter.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n3
	dAtA[i] = 0x10
	i++
	if m.Projection {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	if len(m.OutputColumns) > 0 {
		dAtA5 := make([]byte, len(m.OutputColumns)*10)
		var j4 int
		for _, num := range m.OutputColumns {
			for num >= 1<<7 {
				dAtA5[j4] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j4++
			}
			dAtA5[j4] = uint8(num)
			j4++
		}
		dAtA[i] = 0x1a
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(j4))
		i += copy(dAtA[i:], dAtA5[:j4])
	}
	if len(m.RenderExprs) > 0 {
		for _, msg := range m.RenderExprs {
			dAtA[i] = 0x22
			i++
			i = encodeVarintProcessors(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x28
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.Offset))
	dAtA[i] = 0x30
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.Limit))
	return i, nil
}

func (m *ProcessorCoreUnion) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ProcessorCoreUnion) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Noop != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(m.Noop.Size()))
		n6, err := m.Noop.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.TableReader != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(m.TableReader.Size()))
		n7, err := m.TableReader.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if m.JoinReader != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(m.JoinReader.Size()))
		n8, err := m.JoinReader.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	if m.Sorter != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(m.Sorter.Size()))
		n9, err := m.Sorter.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	if m.Aggregator != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(m.Aggregator.Size()))
		n10, err := m.Aggregator.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	if m.Distinct != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(m.Distinct.Size()))
		n11, err := m.Distinct.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	if m.MergeJoiner != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(m.MergeJoiner.Size()))
		n12, err := m.MergeJoiner.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n12
	}
	if m.HashJoiner != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(m.HashJoiner.Size()))
		n13, err := m.HashJoiner.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	if m.Values != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(m.Values.Size()))
		n14, err := m.Values.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n14
	}
	if m.Backfiller != nil {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(m.Backfiller.Size()))
		n15, err := m.Backfiller.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n15
	}
	if m.SetOp != nil {
		dAtA[i] = 0x62
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(m.SetOp.Size()))
		n16, err := m.SetOp.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n16
	}
	return i, nil
}

func (m *NoopCoreSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NoopCoreSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *ValuesCoreSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ValuesCoreSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Columns) > 0 {
		for _, msg := range m.Columns {
			dAtA[i] = 0xa
			i++
			i = encodeVarintProcessors(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.RawBytes) > 0 {
		for _, b := range m.RawBytes {
			dAtA[i] = 0x12
			i++
			i = encodeVarintProcessors(dAtA, i, uint64(len(b)))
			i += copy(dAtA[i:], b)
		}
	}
	return i, nil
}

func (m *TableReaderSpan) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TableReaderSpan) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.Span.Size()))
	n17, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n17
	return i, nil
}

func (m *TableReaderSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TableReaderSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.Table.Size()))
	n18, err := m.Table.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n18
	dAtA[i] = 0x10
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.IndexIdx))
	dAtA[i] = 0x18
	i++
	if m.Reverse {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	if len(m.Spans) > 0 {
		for _, msg := range m.Spans {
			dAtA[i] = 0x22
			i++
			i = encodeVarintProcessors(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x28
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.LimitHint))
	return i, nil
}

func (m *JoinReaderSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *JoinReaderSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.Table.Size()))
	n19, err := m.Table.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n19
	dAtA[i] = 0x10
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.IndexIdx))
	return i, nil
}

func (m *SorterSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SorterSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.OutputOrdering.Size()))
	n20, err := m.OutputOrdering.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n20
	dAtA[i] = 0x10
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.OrderingMatchLen))
	return i, nil
}

func (m *DistinctSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DistinctSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.OrderedColumns) > 0 {
		for _, num := range m.OrderedColumns {
			dAtA[i] = 0x8
			i++
			i = encodeVarintProcessors(dAtA, i, uint64(num))
		}
	}
	if len(m.DistinctColumns) > 0 {
		for _, num := range m.DistinctColumns {
			dAtA[i] = 0x10
			i++
			i = encodeVarintProcessors(dAtA, i, uint64(num))
		}
	}
	return i, nil
}

func (m *MergeJoinerSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MergeJoinerSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.LeftOrdering.Size()))
	n21, err := m.LeftOrdering.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n21
	dAtA[i] = 0x12
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.RightOrdering.Size()))
	n22, err := m.RightOrdering.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n22
	dAtA[i] = 0x2a
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.OnExpr.Size()))
	n23, err := m.OnExpr.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n23
	dAtA[i] = 0x30
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.Type))
	return i, nil
}

func (m *HashJoinerSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HashJoinerSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.LeftEqColumns) > 0 {
		dAtA25 := make([]byte, len(m.LeftEqColumns)*10)
		var j24 int
		for _, num := range m.LeftEqColumns {
			for num >= 1<<7 {
				dAtA25[j24] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j24++
			}
			dAtA25[j24] = uint8(num)
			j24++
		}
		dAtA[i] = 0xa
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(j24))
		i += copy(dAtA[i:], dAtA25[:j24])
	}
	if len(m.RightEqColumns) > 0 {
		dAtA27 := make([]byte, len(m.RightEqColumns)*10)
		var j26 int
		for _, num := range m.RightEqColumns {
			for num >= 1<<7 {
				dAtA27[j26] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j26++
			}
			dAtA27[j26] = uint8(num)
			j26++
		}
		dAtA[i] = 0x12
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(j26))
		i += copy(dAtA[i:], dAtA27[:j26])
	}
	dAtA[i] = 0x2a
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.OnExpr.Size()))
	n28, err := m.OnExpr.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n28
	dAtA[i] = 0x30
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.Type))
	return i, nil
}

func (m *AggregatorSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AggregatorSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.GroupCols) > 0 {
		dAtA30 := make([]byte, len(m.GroupCols)*10)
		var j29 int
		for _, num := range m.GroupCols {
			for num >= 1<<7 {
				dAtA30[j29] = uint8(uint64(num)&0x7f | 0x80)
				num >>= 7
				j29++
			}
			dAtA30[j29] = uint8(num)
			j29++
		}
		dAtA[i] = 0x12
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(j29))
		i += copy(dAtA[i:], dAtA30[:j29])
	}
	if len(m.Aggregations) > 0 {
		for _, msg := range m.Aggregations {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintProcessors(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *AggregatorSpec_Aggregation) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AggregatorSpec_Aggregation) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.Func))
	dAtA[i] = 0x10
	i++
	if m.Distinct {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	dAtA[i] = 0x18
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.ColIdx))
	if m.FilterColIdx != nil {
		dAtA[i] = 0x20
		i++
		i = encodeVarintProcessors(dAtA, i, uint64(*m.FilterColIdx))
	}
	return i, nil
}

func (m *BackfillerSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BackfillerSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.Type))
	dAtA[i] = 0x12
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.Table.Size()))
	n31, err := m.Table.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n31
	if len(m.Spans) > 0 {
		for _, msg := range m.Spans {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintProcessors(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x20
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.Duration))
	dAtA[i] = 0x28
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.ChunkSize))
	if len(m.OtherTables) > 0 {
		for _, msg := range m.OtherTables {
			dAtA[i] = 0x32
			i++
			i = encodeVarintProcessors(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *FlowSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *FlowSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.FlowID.Size()))
	n32, err := m.FlowID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n32
	if len(m.Processors) > 0 {
		for _, msg := range m.Processors {
			dAtA[i] = 0x12
			i++
			i = encodeVarintProcessors(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *AlgebraicSetOpSpec) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AlgebraicSetOpSpec) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.Ordering.Size()))
	n33, err := m.Ordering.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n33
	dAtA[i] = 0x10
	i++
	i = encodeVarintProcessors(dAtA, i, uint64(m.OpType))
	return i, nil
}

func encodeFixed64Processors(dAtA []byte, offset int, v uint64) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	dAtA[offset+4] = uint8(v >> 32)
	dAtA[offset+5] = uint8(v >> 40)
	dAtA[offset+6] = uint8(v >> 48)
	dAtA[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32Processors(dAtA []byte, offset int, v uint32) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintProcessors(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *ProcessorSpec) Size() (n int) {
	var l int
	_ = l
	if len(m.Input) > 0 {
		for _, e := range m.Input {
			l = e.Size()
			n += 1 + l + sovProcessors(uint64(l))
		}
	}
	l = m.Core.Size()
	n += 1 + l + sovProcessors(uint64(l))
	if len(m.Output) > 0 {
		for _, e := range m.Output {
			l = e.Size()
			n += 1 + l + sovProcessors(uint64(l))
		}
	}
	l = m.Post.Size()
	n += 1 + l + sovProcessors(uint64(l))
	n += 1 + sovProcessors(uint64(m.StageID))
	return n
}

func (m *PostProcessSpec) Size() (n int) {
	var l int
	_ = l
	l = m.Filter.Size()
	n += 1 + l + sovProcessors(uint64(l))
	n += 2
	if len(m.OutputColumns) > 0 {
		l = 0
		for _, e := range m.OutputColumns {
			l += sovProcessors(uint64(e))
		}
		n += 1 + sovProcessors(uint64(l)) + l
	}
	if len(m.RenderExprs) > 0 {
		for _, e := range m.RenderExprs {
			l = e.Size()
			n += 1 + l + sovProcessors(uint64(l))
		}
	}
	n += 1 + sovProcessors(uint64(m.Offset))
	n += 1 + sovProcessors(uint64(m.Limit))
	return n
}

func (m *ProcessorCoreUnion) Size() (n int) {
	var l int
	_ = l
	if m.Noop != nil {
		l = m.Noop.Size()
		n += 1 + l + sovProcessors(uint64(l))
	}
	if m.TableReader != nil {
		l = m.TableReader.Size()
		n += 1 + l + sovProcessors(uint64(l))
	}
	if m.JoinReader != nil {
		l = m.JoinReader.Size()
		n += 1 + l + sovProcessors(uint64(l))
	}
	if m.Sorter != nil {
		l = m.Sorter.Size()
		n += 1 + l + sovProcessors(uint64(l))
	}
	if m.Aggregator != nil {
		l = m.Aggregator.Size()
		n += 1 + l + sovProcessors(uint64(l))
	}
	if m.Distinct != nil {
		l = m.Distinct.Size()
		n += 1 + l + sovProcessors(uint64(l))
	}
	if m.MergeJoiner != nil {
		l = m.MergeJoiner.Size()
		n += 1 + l + sovProcessors(uint64(l))
	}
	if m.HashJoiner != nil {
		l = m.HashJoiner.Size()
		n += 1 + l + sovProcessors(uint64(l))
	}
	if m.Values != nil {
		l = m.Values.Size()
		n += 1 + l + sovProcessors(uint64(l))
	}
	if m.Backfiller != nil {
		l = m.Backfiller.Size()
		n += 1 + l + sovProcessors(uint64(l))
	}
	if m.SetOp != nil {
		l = m.SetOp.Size()
		n += 1 + l + sovProcessors(uint64(l))
	}
	return n
}

func (m *NoopCoreSpec) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *ValuesCoreSpec) Size() (n int) {
	var l int
	_ = l
	if len(m.Columns) > 0 {
		for _, e := range m.Columns {
			l = e.Size()
			n += 1 + l + sovProcessors(uint64(l))
		}
	}
	if len(m.RawBytes) > 0 {
		for _, b := range m.RawBytes {
			l = len(b)
			n += 1 + l + sovProcessors(uint64(l))
		}
	}
	return n
}

func (m *TableReaderSpan) Size() (n int) {
	var l int
	_ = l
	l = m.Span.Size()
	n += 1 + l + sovProcessors(uint64(l))
	return n
}

func (m *TableReaderSpec) Size() (n int) {
	var l int
	_ = l
	l = m.Table.Size()
	n += 1 + l + sovProcessors(uint64(l))
	n += 1 + sovProcessors(uint64(m.IndexIdx))
	n += 2
	if len(m.Spans) > 0 {
		for _, e := range m.Spans {
			l = e.Size()
			n += 1 + l + sovProcessors(uint64(l))
		}
	}
	n += 1 + sovProcessors(uint64(m.LimitHint))
	return n
}

func (m *JoinReaderSpec) Size() (n int) {
	var l int
	_ = l
	l = m.Table.Size()
	n += 1 + l + sovProcessors(uint64(l))
	n += 1 + sovProcessors(uint64(m.IndexIdx))
	return n
}

func (m *SorterSpec) Size() (n int) {
	var l int
	_ = l
	l = m.OutputOrdering.Size()
	n += 1 + l + sovProcessors(uint64(l))
	n += 1 + sovProcessors(uint64(m.OrderingMatchLen))
	return n
}

func (m *DistinctSpec) Size() (n int) {
	var l int
	_ = l
	if len(m.OrderedColumns) > 0 {
		for _, e := range m.OrderedColumns {
			n += 1 + sovProcessors(uint64(e))
		}
	}
	if len(m.DistinctColumns) > 0 {
		for _, e := range m.DistinctColumns {
			n += 1 + sovProcessors(uint64(e))
		}
	}
	return n
}

func (m *MergeJoinerSpec) Size() (n int) {
	var l int
	_ = l
	l = m.LeftOrdering.Size()
	n += 1 + l + sovProcessors(uint64(l))
	l = m.RightOrdering.Size()
	n += 1 + l + sovProcessors(uint64(l))
	l = m.OnExpr.Size()
	n += 1 + l + sovProcessors(uint64(l))
	n += 1 + sovProcessors(uint64(m.Type))
	return n
}

func (m *HashJoinerSpec) Size() (n int) {
	var l int
	_ = l
	if len(m.LeftEqColumns) > 0 {
		l = 0
		for _, e := range m.LeftEqColumns {
			l += sovProcessors(uint64(e))
		}
		n += 1 + sovProcessors(uint64(l)) + l
	}
	if len(m.RightEqColumns) > 0 {
		l = 0
		for _, e := range m.RightEqColumns {
			l += sovProcessors(uint64(e))
		}
		n += 1 + sovProcessors(uint64(l)) + l
	}
	l = m.OnExpr.Size()
	n += 1 + l + sovProcessors(uint64(l))
	n += 1 + sovProcessors(uint64(m.Type))
	return n
}

func (m *AggregatorSpec) Size() (n int) {
	var l int
	_ = l
	if len(m.GroupCols) > 0 {
		l = 0
		for _, e := range m.GroupCols {
			l += sovProcessors(uint64(e))
		}
		n += 1 + sovProcessors(uint64(l)) + l
	}
	if len(m.Aggregations) > 0 {
		for _, e := range m.Aggregations {
			l = e.Size()
			n += 1 + l + sovProcessors(uint64(l))
		}
	}
	return n
}

func (m *AggregatorSpec_Aggregation) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovProcessors(uint64(m.Func))
	n += 2
	n += 1 + sovProcessors(uint64(m.ColIdx))
	if m.FilterColIdx != nil {
		n += 1 + sovProcessors(uint64(*m.FilterColIdx))
	}
	return n
}

func (m *BackfillerSpec) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovProcessors(uint64(m.Type))
	l = m.Table.Size()
	n += 1 + l + sovProcessors(uint64(l))
	if len(m.Spans) > 0 {
		for _, e := range m.Spans {
			l = e.Size()
			n += 1 + l + sovProcessors(uint64(l))
		}
	}
	n += 1 + sovProcessors(uint64(m.Duration))
	n += 1 + sovProcessors(uint64(m.ChunkSize))
	if len(m.OtherTables) > 0 {
		for _, e := range m.OtherTables {
			l = e.Size()
			n += 1 + l + sovProcessors(uint64(l))
		}
	}
	return n
}

func (m *FlowSpec) Size() (n int) {
	var l int
	_ = l
	l = m.FlowID.Size()
	n += 1 + l + sovProcessors(uint64(l))
	if len(m.Processors) > 0 {
		for _, e := range m.Processors {
			l = e.Size()
			n += 1 + l + sovProcessors(uint64(l))
		}
	}
	return n
}

func (m *AlgebraicSetOpSpec) Size() (n int) {
	var l int
	_ = l
	l = m.Ordering.Size()
	n += 1 + l + sovProcessors(uint64(l))
	n += 1 + sovProcessors(uint64(m.OpType))
	return n
}

func sovProcessors(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozProcessors(x uint64) (n int) {
	return sovProcessors(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *ProcessorCoreUnion) GetValue() interface{} {
	if this.Noop != nil {
		return this.Noop
	}
	if this.TableReader != nil {
		return this.TableReader
	}
	if this.JoinReader != nil {
		return this.JoinReader
	}
	if this.Sorter != nil {
		return this.Sorter
	}
	if this.Aggregator != nil {
		return this.Aggregator
	}
	if this.Distinct != nil {
		return this.Distinct
	}
	if this.MergeJoiner != nil {
		return this.MergeJoiner
	}
	if this.HashJoiner != nil {
		return this.HashJoiner
	}
	if this.Values != nil {
		return this.Values
	}
	if this.Backfiller != nil {
		return this.Backfiller
	}
	if this.SetOp != nil {
		return this.SetOp
	}
	return nil
}

func (this *ProcessorCoreUnion) SetValue(value interface{}) bool {
	switch vt := value.(type) {
	case *NoopCoreSpec:
		this.Noop = vt
	case *TableReaderSpec:
		this.TableReader = vt
	case *JoinReaderSpec:
		this.JoinReader = vt
	case *SorterSpec:
		this.Sorter = vt
	case *AggregatorSpec:
		this.Aggregator = vt
	case *DistinctSpec:
		this.Distinct = vt
	case *MergeJoinerSpec:
		this.MergeJoiner = vt
	case *HashJoinerSpec:
		this.HashJoiner = vt
	case *ValuesCoreSpec:
		this.Values = vt
	case *BackfillerSpec:
		this.Backfiller = vt
	case *AlgebraicSetOpSpec:
		this.SetOp = vt
	default:
		return false
	}
	return true
}
func (m *ProcessorSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProcessorSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProcessorSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Input", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Input = append(m.Input, InputSyncSpec{})
			if err := m.Input[len(m.Input)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Core", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Core.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Output", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Output = append(m.Output, OutputRouterSpec{})
			if err := m.Output[len(m.Output)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Post", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Post.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StageID", wireType)
			}
			m.StageID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StageID |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *PostProcessSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: PostProcessSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: PostProcessSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Filter", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Filter.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Projection", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Projection = bool(v != 0)
		case 3:
			if wireType == 0 {
				var v uint32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProcessors
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (uint32(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.OutputColumns = append(m.OutputColumns, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProcessors
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthProcessors
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowProcessors
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (uint32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.OutputColumns = append(m.OutputColumns, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field OutputColumns", wireType)
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RenderExprs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RenderExprs = append(m.RenderExprs, Expression{})
			if err := m.RenderExprs[len(m.RenderExprs)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Offset", wireType)
			}
			m.Offset = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Offset |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Limit", wireType)
			}
			m.Limit = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Limit |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ProcessorCoreUnion) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ProcessorCoreUnion: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ProcessorCoreUnion: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Noop", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Noop == nil {
				m.Noop = &NoopCoreSpec{}
			}
			if err := m.Noop.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TableReader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TableReader == nil {
				m.TableReader = &TableReaderSpec{}
			}
			if err := m.TableReader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field JoinReader", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.JoinReader == nil {
				m.JoinReader = &JoinReaderSpec{}
			}
			if err := m.JoinReader.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sorter", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Sorter == nil {
				m.Sorter = &SorterSpec{}
			}
			if err := m.Sorter.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Aggregator", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Aggregator == nil {
				m.Aggregator = &AggregatorSpec{}
			}
			if err := m.Aggregator.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Distinct", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Distinct == nil {
				m.Distinct = &DistinctSpec{}
			}
			if err := m.Distinct.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MergeJoiner", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MergeJoiner == nil {
				m.MergeJoiner = &MergeJoinerSpec{}
			}
			if err := m.MergeJoiner.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HashJoiner", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.HashJoiner == nil {
				m.HashJoiner = &HashJoinerSpec{}
			}
			if err := m.HashJoiner.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Values", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Values == nil {
				m.Values = &ValuesCoreSpec{}
			}
			if err := m.Values.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Backfiller", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Backfiller == nil {
				m.Backfiller = &BackfillerSpec{}
			}
			if err := m.Backfiller.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SetOp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SetOp == nil {
				m.SetOp = &AlgebraicSetOpSpec{}
			}
			if err := m.SetOp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NoopCoreSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NoopCoreSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NoopCoreSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ValuesCoreSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ValuesCoreSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ValuesCoreSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Columns", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Columns = append(m.Columns, DatumInfo{})
			if err := m.Columns[len(m.Columns)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RawBytes", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RawBytes = append(m.RawBytes, make([]byte, postIndex-iNdEx))
			copy(m.RawBytes[len(m.RawBytes)-1], dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TableReaderSpan) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TableReaderSpan: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TableReaderSpan: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TableReaderSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TableReaderSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TableReaderSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Table", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Table.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IndexIdx", wireType)
			}
			m.IndexIdx = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.IndexIdx |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reverse", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Reverse = bool(v != 0)
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Spans", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Spans = append(m.Spans, TableReaderSpan{})
			if err := m.Spans[len(m.Spans)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LimitHint", wireType)
			}
			m.LimitHint = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LimitHint |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *JoinReaderSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: JoinReaderSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: JoinReaderSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Table", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Table.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IndexIdx", wireType)
			}
			m.IndexIdx = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.IndexIdx |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SorterSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SorterSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SorterSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OutputOrdering", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.OutputOrdering.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field OrderingMatchLen", wireType)
			}
			m.OrderingMatchLen = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.OrderingMatchLen |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DistinctSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DistinctSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DistinctSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType == 0 {
				var v uint32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProcessors
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (uint32(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.OrderedColumns = append(m.OrderedColumns, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProcessors
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthProcessors
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowProcessors
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (uint32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.OrderedColumns = append(m.OrderedColumns, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field OrderedColumns", wireType)
			}
		case 2:
			if wireType == 0 {
				var v uint32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProcessors
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (uint32(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.DistinctColumns = append(m.DistinctColumns, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProcessors
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthProcessors
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowProcessors
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (uint32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.DistinctColumns = append(m.DistinctColumns, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field DistinctColumns", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MergeJoinerSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MergeJoinerSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MergeJoinerSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LeftOrdering", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.LeftOrdering.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RightOrdering", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RightOrdering.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OnExpr", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.OnExpr.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= (JoinType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HashJoinerSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HashJoinerSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HashJoinerSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType == 0 {
				var v uint32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProcessors
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (uint32(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.LeftEqColumns = append(m.LeftEqColumns, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProcessors
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthProcessors
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowProcessors
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (uint32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.LeftEqColumns = append(m.LeftEqColumns, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field LeftEqColumns", wireType)
			}
		case 2:
			if wireType == 0 {
				var v uint32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProcessors
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (uint32(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.RightEqColumns = append(m.RightEqColumns, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProcessors
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthProcessors
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowProcessors
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (uint32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.RightEqColumns = append(m.RightEqColumns, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field RightEqColumns", wireType)
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OnExpr", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.OnExpr.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= (JoinType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AggregatorSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AggregatorSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AggregatorSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 2:
			if wireType == 0 {
				var v uint32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProcessors
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (uint32(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.GroupCols = append(m.GroupCols, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowProcessors
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthProcessors
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v uint32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowProcessors
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (uint32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.GroupCols = append(m.GroupCols, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field GroupCols", wireType)
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Aggregations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Aggregations = append(m.Aggregations, AggregatorSpec_Aggregation{})
			if err := m.Aggregations[len(m.Aggregations)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AggregatorSpec_Aggregation) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Aggregation: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Aggregation: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Func", wireType)
			}
			m.Func = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Func |= (AggregatorSpec_Func(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Distinct", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Distinct = bool(v != 0)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ColIdx", wireType)
			}
			m.ColIdx = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ColIdx |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FilterColIdx", wireType)
			}
			var v uint32
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.FilterColIdx = &v
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BackfillerSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BackfillerSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BackfillerSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= (BackfillerSpec_Type(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Table", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Table.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Spans", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Spans = append(m.Spans, TableReaderSpan{})
			if err := m.Spans[len(m.Spans)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Duration", wireType)
			}
			m.Duration = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Duration |= (time.Duration(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ChunkSize", wireType)
			}
			m.ChunkSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ChunkSize |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OtherTables", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OtherTables = append(m.OtherTables, cockroach_sql_sqlbase1.TableDescriptor{})
			if err := m.OtherTables[len(m.OtherTables)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *FlowSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: FlowSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: FlowSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field FlowID", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.FlowID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Processors", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Processors = append(m.Processors, ProcessorSpec{})
			if err := m.Processors[len(m.Processors)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AlgebraicSetOpSpec) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AlgebraicSetOpSpec: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AlgebraicSetOpSpec: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ordering", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthProcessors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Ordering.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field OpType", wireType)
			}
			m.OpType = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.OpType |= (AlgebraicSetOpSpec_SetOpType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipProcessors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthProcessors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipProcessors(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowProcessors
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowProcessors
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthProcessors
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowProcessors
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipProcessors(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthProcessors = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowProcessors   = fmt.Errorf("proto: integer overflow")
)

func init() {
	proto.RegisterFile("cockroach/pkg/sql/distsqlrun/processors.proto", fileDescriptorProcessors)
}

var fileDescriptorProcessors = []byte{
	// 1650 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x58, 0xcd, 0x6f, 0xeb, 0x58,
	0x15, 0xaf, 0xf3, 0x9d, 0x93, 0x2f, 0xeb, 0x0a, 0x84, 0xd5, 0x81, 0xb6, 0xe3, 0xa9, 0x78, 0x7d,
	0xd5, 0xbc, 0x54, 0xaf, 0x42, 0x2c, 0x46, 0xb3, 0x20, 0x5f, 0x6d, 0x03, 0x4d, 0x02, 0x4e, 0x5a,
	0x8d, 0x58, 0x60, 0xb9, 0xf6, 0x4d, 0xe2, 0xa9, 0xeb, 0xeb, 0x5e, 0x3b, 0xaf, 0xed, 0xac, 0x59,
	0xb2, 0x40, 0xe2, 0x0f, 0x60, 0xfe, 0x03, 0x36, 0x6c, 0x58, 0xb0, 0xef, 0x0a, 0xb1, 0x03, 0xb1,
	0xa8, 0xa0, 0xac, 0x59, 0xb2, 0x61, 0x85, 0xee, 0xf5, 0xb5, 0xe3, 0xf4, 0x91, 0xe4, 0xf5, 0x3d,
	0x09, 0xcd, 0xce, 0x39, 0xf7, 0xf7, 0xfb, 0xf9, 0xdc, 0x73, 0xcf, 0xc7, 0x75, 0xe0, 0x95, 0x49,
	0xcc, 0x4b, 0x4a, 0x0c, 0x73, 0x7a, 0xe0, 0x5d, 0x4e, 0x0e, 0xfc, 0x6b, 0xe7, 0xc0, 0xb2, 0xfd,
	0xc0, 0xbf, 0x76, 0xe8, 0xcc, 0x3d, 0xf0, 0x28, 0x31, 0xb1, 0xef, 0x13, 0xea, 0xd7, 0x3d, 0x4a,
	0x02, 0x82, 0x94, 0x18, 0x5e, 0xf7, 0xaf, 0x9d, 0xfa, 0x1c, 0xba, 0xb9, 0xb3, 0x28, 0xc4, 0x9f,
	0xbc, 0x8b, 0x03, 0xcb, 0x08, 0x8c, 0x90, 0xbb, 0xa9, 0xfe, 0x6f, 0x04, 0xa6, 0x34, 0xd6, 0xdf,
	0xdc, 0x7f, 0xdb, 0x1d, 0xff, 0xda, 0xb9, 0x30, 0x7c, 0x7c, 0xe0, 0x07, 0x74, 0x66, 0x06, 0x33,
	0x8a, 0x2d, 0x81, 0x7d, 0xb5, 0x1c, 0x8b, 0x5d, 0x93, 0x58, 0xd8, 0xd2, 0x2d, 0x23, 0x98, 0x5d,
	0x09, 0xf8, 0x8b, 0x95, 0x3b, 0x4d, 0xf8, 0xf9, 0xad, 0x09, 0x99, 0x10, 0xfe, 0x78, 0xc0, 0x9e,
	0x42, 0xab, 0xfa, 0x97, 0x14, 0x54, 0x7e, 0x1a, 0x85, 0x63, 0xe8, 0x61, 0x13, 0xb5, 0x20, 0x6b,
	0xbb, 0xde, 0x2c, 0x50, 0xa4, 0x9d, 0xf4, 0x5e, 0xe9, 0xf0, 0x45, 0x7d, 0x59, 0x6c, 0xea, 0x5d,
	0x06, 0x1b, 0xde, 0xb9, 0x26, 0xe3, 0x35, 0x33, 0xf7, 0x0f, 0xdb, 0x1b, 0x5a, 0xc8, 0x45, 0x47,
	0x90, 0x31, 0x09, 0xc5, 0x4a, 0x6a, 0x47, 0xda, 0x2b, 0x1d, 0x7e, 0xba, 0x5c, 0x23, 0x7e, 0x77,
	0x8b, 0x50, 0x7c, 0xe6, 0xda, 0xc4, 0x15, 0x42, 0x9c, 0x8f, 0x4e, 0x20, 0x47, 0x66, 0x01, 0xf3,
	0x26, 0xcd, 0xbd, 0xd9, 0x5f, 0xae, 0x34, 0xe0, 0x38, 0x8d, 0xcc, 0x02, 0x4c, 0x13, 0x0e, 0x09,
	0x3e, 0x6a, 0x41, 0xc6, 0x23, 0x7e, 0xa0, 0x64, 0xb8, 0x47, 0x2f, 0x57, 0x78, 0x44, 0xfc, 0x40,
	0x78, 0x95, 0x90, 0xe1, 0x64, 0xb4, 0x0f, 0x05, 0x3f, 0x30, 0x26, 0x58, 0xb7, 0x2d, 0x25, 0xbb,
	0x23, 0xed, 0x65, 0x9b, 0x35, 0xb6, 0xfa, 0xf8, 0xb0, 0x9d, 0x1f, 0x32, 0x7b, 0xb7, 0xad, 0xe5,
	0x39, 0xa0, 0x6b, 0xa9, 0xbf, 0x4b, 0x41, 0xed, 0x89, 0x16, 0x6a, 0x42, 0x6e, 0x6c, 0x3b, 0x01,
	0xa6, 0x8a, 0xc4, 0xdd, 0xd8, 0x5d, 0xee, 0x46, 0xe7, 0xd6, 0xa3, 0xd8, 0xf7, 0xe7, 0x01, 0x11,
	0x4c, 0xb4, 0x0b, 0xe0, 0x51, 0xf2, 0x25, 0x36, 0x03, 0x9b, 0xb8, 0x3c, 0xc0, 0x05, 0x81, 0x48,
	0xd8, 0xd1, 0x4b, 0xa8, 0x86, 0x1b, 0xd7, 0x4d, 0xe2, 0xcc, 0xae, 0x5c, 0x9f, 0x07, 0xb0, 0xd2,
	0x4c, 0xc9, 0x92, 0x56, 0x09, 0x57, 0x5a, 0xe1, 0x02, 0xea, 0x41, 0x99, 0x62, 0xd7, 0xc2, 0x54,
	0xc7, 0xb7, 0x1e, 0xf5, 0x95, 0x0c, 0x8f, 0xf4, 0x73, 0x5c, 0x2b, 0x85, 0x7c, 0x66, 0xf7, 0xd1,
	0x77, 0x21, 0x47, 0xc6, 0x63, 0x1f, 0x07, 0x3c, 0x42, 0x99, 0xf8, 0x18, 0xb8, 0x0d, 0x6d, 0x42,
	0xd6, 0xb1, 0xaf, 0xec, 0x40, 0xc9, 0x25, 0x16, 0x43, 0x93, 0xfa, 0x75, 0x0e, 0xd0, 0xdb, 0xf9,
	0x80, 0x3e, 0x83, 0x8c, 0x4b, 0x88, 0x27, 0x42, 0xf6, 0xfd, 0xe5, 0x7e, 0xf5, 0x09, 0xf1, 0x18,
	0x8d, 0x85, 0x5a, 0xe3, 0x1c, 0xf4, 0x13, 0x28, 0x05, 0xc6, 0x85, 0x83, 0x35, 0x6c, 0x58, 0x98,
	0x8a, 0x74, 0x5c, 0x71, 0xf8, 0xa3, 0x39, 0x98, 0xab, 0x24, 0xd9, 0xe8, 0x04, 0xe0, 0x4b, 0x62,
	0xbb, 0x42, 0x2b, 0xcd, 0xb5, 0xf6, 0x96, 0x6b, 0xfd, 0x38, 0xc6, 0x72, 0xa9, 0x04, 0x17, 0x7d,
	0x0e, 0x39, 0x9f, 0x50, 0x96, 0x07, 0x99, 0x75, 0x79, 0x30, 0xe4, 0x38, 0xae, 0x20, 0x38, 0xcc,
	0x0f, 0x63, 0x32, 0xa1, 0x78, 0x62, 0x04, 0x84, 0xf2, 0x28, 0xaf, 0xf4, 0xa3, 0x11, 0x63, 0x43,
	0x3f, 0xe6, 0x5c, 0xd4, 0x84, 0x02, 0x03, 0xda, 0xae, 0x19, 0x28, 0xf9, 0x75, 0xe1, 0x6d, 0x0b,
	0x24, 0x57, 0x89, 0x79, 0x2c, 0xc4, 0x57, 0x98, 0x4e, 0x30, 0xdb, 0x2e, 0xa6, 0x4a, 0x61, 0x5d,
	0x88, 0x7b, 0x73, 0x70, 0x18, 0xe2, 0x04, 0x9b, 0x6d, 0x6d, 0x6a, 0xf8, 0x53, 0xa1, 0x55, 0x5c,
	0xb7, 0xb5, 0x93, 0x18, 0x1b, 0x6e, 0x6d, 0xce, 0x45, 0x3f, 0x82, 0xdc, 0x1b, 0xc3, 0x99, 0x61,
	0x5f, 0x81, 0x75, 0x2a, 0xe7, 0x1c, 0x17, 0x67, 0x8e, 0xe0, 0x31, 0x5f, 0x2e, 0x0c, 0xf3, 0x72,
	0x6c, 0x3b, 0x0e, 0xa6, 0x4a, 0x69, 0x9d, 0x4a, 0x33, 0xc6, 0x86, 0xbe, 0xcc, 0xb9, 0xa8, 0x09,
	0x59, 0x1f, 0x07, 0x03, 0x4f, 0x29, 0xaf, 0x6b, 0x87, 0x0d, 0x67, 0x82, 0x2f, 0xa8, 0x61, 0x9b,
	0x43, 0x86, 0xe7, 0x42, 0x21, 0xf5, 0xb3, 0xcc, 0xfd, 0xd7, 0xdb, 0x92, 0x5a, 0x85, 0x72, 0x32,
	0xcb, 0x55, 0x0a, 0xd5, 0x45, 0xef, 0x51, 0x0b, 0xf2, 0x51, 0xc5, 0x87, 0x0d, 0xfc, 0x93, 0x15,
	0x27, 0xca, 0xe6, 0x48, 0xd7, 0x1d, 0x13, 0x51, 0x87, 0x11, 0x13, 0x7d, 0x04, 0x45, 0x6a, 0xdc,
	0xe8, 0x17, 0x77, 0x01, 0xf6, 0x95, 0xd4, 0x4e, 0x7a, 0xaf, 0xac, 0x15, 0xa8, 0x71, 0xd3, 0x64,
	0xbf, 0xd5, 0x36, 0xd4, 0x16, 0xca, 0xc4, 0x70, 0xd1, 0x6b, 0xc8, 0xf8, 0x9e, 0xe1, 0x8a, 0x12,
	0xfd, 0x4e, 0xe2, 0x8d, 0x62, 0x1c, 0xd6, 0x19, 0x2c, 0x6a, 0xa5, 0x0c, 0xaa, 0xfe, 0x32, 0xf5,
	0x44, 0x86, 0xb7, 0xc7, 0x2c, 0xaf, 0xb7, 0x25, 0xa5, 0x2e, 0xc6, 0x60, 0x58, 0xa4, 0x6d, 0xec,
	0x9b, 0xd4, 0xf6, 0x02, 0x42, 0xa3, 0x26, 0xc2, 0xa9, 0xe8, 0x63, 0x28, 0xda, 0xae, 0x85, 0x6f,
	0x75, 0xdb, 0xba, 0xe5, 0xf5, 0x5e, 0x11, 0xeb, 0x05, 0x6e, 0xee, 0x5a, 0xb7, 0x68, 0x0b, 0xf2,
	0x14, 0xbf, 0xc1, 0xd4, 0xc7, 0xbc, 0x88, 0xa3, 0xf6, 0x19, 0x19, 0x51, 0x07, 0xb2, 0xcc, 0xc5,
	0xa8, 0x13, 0xbe, 0x6b, 0xbb, 0x88, 0x37, 0x18, 0xb2, 0xd1, 0x27, 0x00, 0xbc, 0xaf, 0xe9, 0x53,
	0xdb, 0x0d, 0x9b, 0x61, 0x5a, 0x00, 0x8a, 0xdc, 0x7e, 0x62, 0xbb, 0x81, 0x7a, 0x03, 0xd5, 0xc5,
	0x3e, 0xf1, 0x7f, 0x0a, 0x82, 0xfa, 0x1b, 0x09, 0x60, 0xde, 0x5b, 0xd0, 0xcf, 0xa0, 0x26, 0xe6,
	0x05, 0xa1, 0x16, 0xa6, 0xb6, 0x3b, 0x11, 0xef, 0x57, 0x57, 0x4c, 0x5c, 0x81, 0x14, 0xda, 0x62,
	0xe0, 0x44, 0x56, 0x74, 0x08, 0x28, 0xd2, 0xd2, 0xaf, 0x8c, 0xc0, 0x9c, 0xea, 0x0e, 0x76, 0x17,
	0xbc, 0x91, 0xa3, 0xf5, 0x1e, 0x5b, 0x3e, 0xc5, 0xae, 0x7a, 0x01, 0xe5, 0x64, 0x9b, 0x41, 0x2f,
	0xa0, 0xc6, 0x31, 0xd8, 0xd2, 0x93, 0x59, 0x5d, 0xd1, 0xaa, 0xc2, 0x1c, 0x0d, 0xb1, 0x97, 0x20,
	0x47, 0x1d, 0x29, 0x46, 0xa6, 0x38, 0xb2, 0x16, 0xd9, 0x05, 0x54, 0xfd, 0x7d, 0x0a, 0x6a, 0x4f,
	0x9a, 0x10, 0xea, 0x41, 0xc5, 0xc1, 0xe3, 0x0f, 0xd8, 0x7c, 0x99, 0xd1, 0xe3, 0xad, 0x0f, 0xa0,
	0x4a, 0xed, 0xc9, 0x34, 0xa1, 0x97, 0x7a, 0xa6, 0x5e, 0x85, 0xf3, 0x63, 0xc1, 0x16, 0xe4, 0x89,
	0xcb, 0xe7, 0xb3, 0xe8, 0xf7, 0xcf, 0xba, 0x39, 0x10, 0x97, 0xd9, 0xd0, 0xe7, 0x90, 0x09, 0xee,
	0x3c, 0xcc, 0x47, 0x6f, 0x75, 0x95, 0x2f, 0x2c, 0x30, 0xa3, 0x3b, 0x0f, 0x47, 0x05, 0xcb, 0x58,
	0xea, 0xbf, 0x24, 0xa8, 0x2e, 0xf6, 0x5b, 0xb4, 0x0f, 0x35, 0x1e, 0x35, 0x7c, 0xbd, 0x78, 0x3a,
	0xe1, 0x2d, 0x83, 0x2d, 0x75, 0xae, 0xa3, 0x03, 0xfa, 0x14, 0xe4, 0x30, 0x24, 0x09, 0x70, 0x2a,
	0x06, 0x87, 0xe1, 0x9a, 0xa3, 0xbf, 0x01, 0xfb, 0xfd, 0x77, 0x1a, 0xaa, 0x8b, 0xa3, 0x13, 0x7d,
	0x0c, 0x30, 0xa1, 0x64, 0xe6, 0xb1, 0x0d, 0x24, 0xbd, 0x2f, 0x72, 0x6b, 0x8b, 0x38, 0x3e, 0xfa,
	0x05, 0x94, 0xa3, 0xf9, 0x6a, 0x13, 0x71, 0xeb, 0x2a, 0x1d, 0xfe, 0xe0, 0x5d, 0xa7, 0x73, 0xfc,
	0x73, 0xbe, 0x9b, 0x05, 0xbd, 0xcd, 0x3f, 0x4a, 0x50, 0x4a, 0x60, 0xd0, 0x31, 0x64, 0xc6, 0x33,
	0xd7, 0xe4, 0xf9, 0x5a, 0x3d, 0x7c, 0xf5, 0xce, 0xef, 0x39, 0x9a, 0xb9, 0xf1, 0xd5, 0x96, 0x09,
	0xa0, 0x9d, 0xc4, 0x55, 0x20, 0x79, 0xa9, 0x9c, 0x0f, 0xfa, 0xef, 0xf1, 0xc9, 0xc2, 0x5b, 0x4a,
	0x3a, 0x51, 0xc4, 0x39, 0x93, 0x38, 0xac, 0xab, 0xee, 0x42, 0x35, 0xbc, 0xa1, 0xea, 0x11, 0x8a,
	0xdd, 0x6d, 0x2a, 0x5a, 0x39, 0xb4, 0xb6, 0x38, 0x4a, 0xfd, 0xad, 0x04, 0x19, 0xf6, 0x6e, 0x54,
	0x84, 0x6c, 0xb7, 0xdd, 0xe9, 0x8f, 0xe4, 0x0d, 0x94, 0x87, 0x74, 0xe3, 0xfc, 0x58, 0x96, 0x50,
	0x19, 0x0a, 0xcd, 0xc1, 0xe0, 0x54, 0x6f, 0xf4, 0xdb, 0x72, 0x0a, 0x95, 0x20, 0xcf, 0x7f, 0x0d,
	0x34, 0x39, 0x8d, 0xaa, 0x00, 0xad, 0x41, 0xbf, 0xd5, 0x18, 0xe9, 0x8d, 0xe3, 0x63, 0x39, 0xc3,
	0xe8, 0xad, 0xc1, 0x59, 0x7f, 0x24, 0x67, 0x19, 0xbd, 0xd7, 0xf8, 0x42, 0xce, 0xf3, 0x87, 0x6e,
	0x5f, 0x2e, 0x20, 0x80, 0xdc, 0x70, 0xd4, 0x6e, 0x77, 0xce, 0xe5, 0x22, 0x33, 0x0e, 0xcf, 0x7a,
	0x32, 0x30, 0xb9, 0xe1, 0x59, 0x4f, 0xef, 0xf6, 0x47, 0x72, 0x89, 0xbd, 0xe9, 0xbc, 0xa1, 0x75,
	0x1b, 0xfd, 0x56, 0x47, 0x2e, 0xb3, 0xa5, 0x2f, 0x06, 0x1a, 0x57, 0xae, 0xa8, 0x7f, 0x48, 0x43,
	0x75, 0x71, 0x96, 0xb3, 0x20, 0xf3, 0x44, 0x5a, 0x1b, 0xe4, 0x45, 0x5e, 0xfd, 0x69, 0x4e, 0xcd,
	0x7b, 0x7b, 0xea, 0xfd, 0x7b, 0x7b, 0x3c, 0x9d, 0xd2, 0x1f, 0x34, 0x9d, 0x5e, 0x43, 0xc1, 0x9a,
	0x51, 0x9e, 0x44, 0xfc, 0xa0, 0xd2, 0xcd, 0x6f, 0xb3, 0xe5, 0xff, 0x3c, 0x6c, 0x57, 0x02, 0xfb,
	0x0a, 0xd7, 0xdb, 0x62, 0x51, 0x8b, 0x61, 0x6c, 0xa0, 0x99, 0xd3, 0x99, 0x7b, 0xa9, 0xfb, 0xf6,
	0x57, 0x78, 0x71, 0xa0, 0x71, 0xfb, 0xd0, 0xfe, 0x0a, 0xa3, 0x01, 0x94, 0x49, 0x30, 0xc5, 0x54,
	0xe7, 0xde, 0xfa, 0x4a, 0x8e, 0x7b, 0xf9, 0xbc, 0x9d, 0x96, 0xb8, 0x02, 0x5f, 0xf3, 0xd5, 0x7d,
	0xc8, 0xb0, 0x38, 0xb2, 0x43, 0xea, 0xba, 0x6f, 0x0c, 0xc7, 0xb6, 0xe4, 0x0d, 0x76, 0xc2, 0x61,
	0xab, 0x90, 0x25, 0x9e, 0x49, 0x6c, 0xaa, 0xc9, 0x29, 0xf5, 0x57, 0x12, 0x14, 0x8e, 0x1c, 0x72,
	0xc3, 0x4f, 0xed, 0x35, 0xe4, 0xc7, 0x0e, 0xb9, 0x61, 0xdf, 0x6a, 0xec, 0xe0, 0xca, 0x4d, 0x85,
	0x89, 0xff, 0xed, 0x61, 0x3b, 0xc7, 0x20, 0xdd, 0xf6, 0x63, 0xfc, 0xa4, 0xe5, 0x18, 0xb0, 0x6b,
	0xa1, 0x1e, 0xff, 0xb6, 0x12, 0xff, 0x0d, 0xf0, 0x02, 0x5f, 0xf9, 0x01, 0xbc, 0xf0, 0xe1, 0x9c,
	0xf8, 0x08, 0x13, 0x02, 0xea, 0x9f, 0x24, 0x40, 0x6f, 0xdf, 0xe8, 0x50, 0x1b, 0x0a, 0xef, 0x3d,
	0x67, 0x62, 0x26, 0x3a, 0x83, 0x3c, 0xf1, 0x74, 0x9e, 0x97, 0x29, 0x9e, 0x97, 0x3f, 0x7c, 0xce,
	0xb5, 0xb2, 0xce, 0x9f, 0x12, 0x09, 0x9a, 0x23, 0xfc, 0x97, 0xfa, 0x11, 0x14, 0xe3, 0x25, 0x56,
	0x75, 0x9d, 0x5b, 0x13, 0x7b, 0x81, 0x6e, 0x38, 0x8e, 0xbc, 0xb1, 0x7f, 0x04, 0x85, 0xa8, 0x57,
	0xf2, 0xb0, 0xf7, 0xfb, 0x1d, 0x4d, 0xde, 0x60, 0xb0, 0xd3, 0xce, 0xd1, 0x48, 0x1f, 0x9c, 0x8d,
	0x3a, 0x9a, 0x2c, 0xa1, 0x1a, 0x94, 0xb4, 0xee, 0xf1, 0x49, 0x64, 0x48, 0x31, 0xc0, 0xd1, 0xd9,
	0xe9, 0xa9, 0xf8, 0x9d, 0x6e, 0xee, 0xde, 0xff, 0x63, 0x6b, 0xe3, 0xfe, 0x71, 0x4b, 0xfa, 0xf3,
	0xe3, 0x96, 0xf4, 0xd7, 0xc7, 0x2d, 0xe9, 0xef, 0x8f, 0x5b, 0xd2, 0xaf, 0xff, 0xb9, 0xb5, 0xf1,
	0x73, 0x98, 0x7b, 0xfd, 0xdf, 0x00, 0x00, 0x00, 0xff, 0xff, 0xcd, 0x02, 0x69, 0x7a, 0xc5, 0x11,
	0x00, 0x00,
}
