// Code generated by protoc-gen-gogo.
// source: cockroach/pkg/roachpb/metadata.proto
// DO NOT EDIT!

package roachpb

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import cockroach_util "github.com/cockroachdb/cockroach/pkg/util"

import bytes "bytes"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// Attributes specifies a list of arbitrary strings describing
// node topology, store type, and machine capabilities.
type Attributes struct {
	Attrs []string `protobuf:"bytes,1,rep,name=attrs" json:"attrs,omitempty" yaml:"attrs,flow"`
}

func (m *Attributes) Reset()                    { *m = Attributes{} }
func (*Attributes) ProtoMessage()               {}
func (*Attributes) Descriptor() ([]byte, []int) { return fileDescriptorMetadata, []int{0} }

// ReplicationTarget identifies a node/store pair.
type ReplicationTarget struct {
	NodeID  NodeID  `protobuf:"varint,1,opt,name=node_id,json=nodeId,casttype=NodeID" json:"node_id"`
	StoreID StoreID `protobuf:"varint,2,opt,name=store_id,json=storeId,casttype=StoreID" json:"store_id"`
}

func (m *ReplicationTarget) Reset()                    { *m = ReplicationTarget{} }
func (*ReplicationTarget) ProtoMessage()               {}
func (*ReplicationTarget) Descriptor() ([]byte, []int) { return fileDescriptorMetadata, []int{1} }

// ReplicaDescriptor describes a replica location by node ID
// (corresponds to a host:port via lookup on gossip network) and store
// ID (identifies the device).
type ReplicaDescriptor struct {
	NodeID  NodeID  `protobuf:"varint,1,opt,name=node_id,json=nodeId,casttype=NodeID" json:"node_id"`
	StoreID StoreID `protobuf:"varint,2,opt,name=store_id,json=storeId,casttype=StoreID" json:"store_id"`
	// replica_id uniquely identifies a replica instance. If a range is removed from
	// a store and then re-added to the same store, the new instance will have a
	// higher replica_id.
	ReplicaID ReplicaID `protobuf:"varint,3,opt,name=replica_id,json=replicaId,casttype=ReplicaID" json:"replica_id"`
}

func (m *ReplicaDescriptor) Reset()                    { *m = ReplicaDescriptor{} }
func (*ReplicaDescriptor) ProtoMessage()               {}
func (*ReplicaDescriptor) Descriptor() ([]byte, []int) { return fileDescriptorMetadata, []int{2} }

// ReplicaIdent uniquely identifies a specific replica.
type ReplicaIdent struct {
	RangeID RangeID           `protobuf:"varint,1,opt,name=range_id,json=rangeId,casttype=RangeID" json:"range_id"`
	Replica ReplicaDescriptor `protobuf:"bytes,2,opt,name=replica" json:"replica"`
}

func (m *ReplicaIdent) Reset()                    { *m = ReplicaIdent{} }
func (m *ReplicaIdent) String() string            { return proto.CompactTextString(m) }
func (*ReplicaIdent) ProtoMessage()               {}
func (*ReplicaIdent) Descriptor() ([]byte, []int) { return fileDescriptorMetadata, []int{3} }

// RangeDescriptor is the value stored in a range metadata key.
// A range is described using an inclusive start key, a non-inclusive end key,
// and a list of replicas where the range is stored.
type RangeDescriptor struct {
	RangeID RangeID `protobuf:"varint,1,opt,name=range_id,json=rangeId,casttype=RangeID" json:"range_id"`
	// start_key is the first key which may be contained by this range.
	StartKey RKey `protobuf:"bytes,2,opt,name=start_key,json=startKey,casttype=RKey" json:"start_key,omitempty"`
	// end_key marks the end of the range's possible keys.  EndKey itself is not
	// contained in this range - it will be contained in the immediately
	// subsequent range.
	EndKey RKey `protobuf:"bytes,3,opt,name=end_key,json=endKey,casttype=RKey" json:"end_key,omitempty"`
	// replicas is the set of nodes/stores on which replicas of this
	// range are stored, the ordering being arbitrary and subject to
	// permutation.
	Replicas []ReplicaDescriptor `protobuf:"bytes,4,rep,name=replicas" json:"replicas"`
	// next_replica_id is a counter used to generate replica IDs.
	NextReplicaID ReplicaID `protobuf:"varint,5,opt,name=next_replica_id,json=nextReplicaId,casttype=ReplicaID" json:"next_replica_id"`
}

func (m *RangeDescriptor) Reset()                    { *m = RangeDescriptor{} }
func (*RangeDescriptor) ProtoMessage()               {}
func (*RangeDescriptor) Descriptor() ([]byte, []int) { return fileDescriptorMetadata, []int{4} }

// StoreCapacity contains capacity information for a storage device.
type StoreCapacity struct {
	Capacity   int64 `protobuf:"varint,1,opt,name=capacity" json:"capacity"`
	Available  int64 `protobuf:"varint,2,opt,name=available" json:"available"`
	RangeCount int32 `protobuf:"varint,3,opt,name=range_count,json=rangeCount" json:"range_count"`
	LeaseCount int32 `protobuf:"varint,4,opt,name=lease_count,json=leaseCount" json:"lease_count"`
}

func (m *StoreCapacity) Reset()                    { *m = StoreCapacity{} }
func (m *StoreCapacity) String() string            { return proto.CompactTextString(m) }
func (*StoreCapacity) ProtoMessage()               {}
func (*StoreCapacity) Descriptor() ([]byte, []int) { return fileDescriptorMetadata, []int{5} }

// NodeDescriptor holds details on node physical/network topology.
type NodeDescriptor struct {
	NodeID   NodeID                        `protobuf:"varint,1,opt,name=node_id,json=nodeId,casttype=NodeID" json:"node_id"`
	Address  cockroach_util.UnresolvedAddr `protobuf:"bytes,2,opt,name=address" json:"address"`
	Attrs    Attributes                    `protobuf:"bytes,3,opt,name=attrs" json:"attrs"`
	Locality Locality                      `protobuf:"bytes,4,opt,name=locality" json:"locality"`
}

func (m *NodeDescriptor) Reset()                    { *m = NodeDescriptor{} }
func (m *NodeDescriptor) String() string            { return proto.CompactTextString(m) }
func (*NodeDescriptor) ProtoMessage()               {}
func (*NodeDescriptor) Descriptor() ([]byte, []int) { return fileDescriptorMetadata, []int{6} }

// StoreDescriptor holds store information including store attributes, node
// descriptor and store capacity.
type StoreDescriptor struct {
	StoreID  StoreID        `protobuf:"varint,1,opt,name=store_id,json=storeId,casttype=StoreID" json:"store_id"`
	Attrs    Attributes     `protobuf:"bytes,2,opt,name=attrs" json:"attrs"`
	Node     NodeDescriptor `protobuf:"bytes,3,opt,name=node" json:"node"`
	Capacity StoreCapacity  `protobuf:"bytes,4,opt,name=capacity" json:"capacity"`
}

func (m *StoreDescriptor) Reset()                    { *m = StoreDescriptor{} }
func (m *StoreDescriptor) String() string            { return proto.CompactTextString(m) }
func (*StoreDescriptor) ProtoMessage()               {}
func (*StoreDescriptor) Descriptor() ([]byte, []int) { return fileDescriptorMetadata, []int{7} }

// StoreDeadReplicas holds a storeID and a list of dead replicas on that store.
// Used to let the range lease holder know about corrupted or otherwise
// destroyed replicas that should be transferred to a different store.
type StoreDeadReplicas struct {
	StoreID  StoreID        `protobuf:"varint,1,opt,name=store_id,json=storeId,casttype=StoreID" json:"store_id"`
	Replicas []ReplicaIdent `protobuf:"bytes,2,rep,name=replicas" json:"replicas"`
}

func (m *StoreDeadReplicas) Reset()                    { *m = StoreDeadReplicas{} }
func (m *StoreDeadReplicas) String() string            { return proto.CompactTextString(m) }
func (*StoreDeadReplicas) ProtoMessage()               {}
func (*StoreDeadReplicas) Descriptor() ([]byte, []int) { return fileDescriptorMetadata, []int{8} }

// Locality is an ordered set of key value Tiers that describe a node's
// location. The tier keys should be the same across all nodes.
type Locality struct {
	Tiers []Tier `protobuf:"bytes,1,rep,name=tiers" json:"tiers"`
}

func (m *Locality) Reset()                    { *m = Locality{} }
func (*Locality) ProtoMessage()               {}
func (*Locality) Descriptor() ([]byte, []int) { return fileDescriptorMetadata, []int{9} }

// Tier represents one level of the locality hierarchy.
type Tier struct {
	// Key is the name of tier and should match all other nodes.
	Key string `protobuf:"bytes,1,opt,name=key" json:"key"`
	// Value is node specific value corresponding to the key.
	Value string `protobuf:"bytes,2,opt,name=value" json:"value"`
}

func (m *Tier) Reset()                    { *m = Tier{} }
func (*Tier) ProtoMessage()               {}
func (*Tier) Descriptor() ([]byte, []int) { return fileDescriptorMetadata, []int{10} }

func init() {
	proto.RegisterType((*Attributes)(nil), "cockroach.roachpb.Attributes")
	proto.RegisterType((*ReplicationTarget)(nil), "cockroach.roachpb.ReplicationTarget")
	proto.RegisterType((*ReplicaDescriptor)(nil), "cockroach.roachpb.ReplicaDescriptor")
	proto.RegisterType((*ReplicaIdent)(nil), "cockroach.roachpb.ReplicaIdent")
	proto.RegisterType((*RangeDescriptor)(nil), "cockroach.roachpb.RangeDescriptor")
	proto.RegisterType((*StoreCapacity)(nil), "cockroach.roachpb.StoreCapacity")
	proto.RegisterType((*NodeDescriptor)(nil), "cockroach.roachpb.NodeDescriptor")
	proto.RegisterType((*StoreDescriptor)(nil), "cockroach.roachpb.StoreDescriptor")
	proto.RegisterType((*StoreDeadReplicas)(nil), "cockroach.roachpb.StoreDeadReplicas")
	proto.RegisterType((*Locality)(nil), "cockroach.roachpb.Locality")
	proto.RegisterType((*Tier)(nil), "cockroach.roachpb.Tier")
}
func (this *ReplicaDescriptor) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*ReplicaDescriptor)
	if !ok {
		that2, ok := that.(ReplicaDescriptor)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.NodeID != that1.NodeID {
		return false
	}
	if this.StoreID != that1.StoreID {
		return false
	}
	if this.ReplicaID != that1.ReplicaID {
		return false
	}
	return true
}
func (this *RangeDescriptor) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*RangeDescriptor)
	if !ok {
		that2, ok := that.(RangeDescriptor)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.RangeID != that1.RangeID {
		return false
	}
	if !bytes.Equal(this.StartKey, that1.StartKey) {
		return false
	}
	if !bytes.Equal(this.EndKey, that1.EndKey) {
		return false
	}
	if len(this.Replicas) != len(that1.Replicas) {
		return false
	}
	for i := range this.Replicas {
		if !this.Replicas[i].Equal(&that1.Replicas[i]) {
			return false
		}
	}
	if this.NextReplicaID != that1.NextReplicaID {
		return false
	}
	return true
}
func (m *Attributes) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Attributes) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Attrs) > 0 {
		for _, s := range m.Attrs {
			dAtA[i] = 0xa
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	return i, nil
}

func (m *ReplicationTarget) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReplicationTarget) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.NodeID))
	dAtA[i] = 0x10
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.StoreID))
	return i, nil
}

func (m *ReplicaDescriptor) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReplicaDescriptor) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.NodeID))
	dAtA[i] = 0x10
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.StoreID))
	dAtA[i] = 0x18
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.ReplicaID))
	return i, nil
}

func (m *ReplicaIdent) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReplicaIdent) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.RangeID))
	dAtA[i] = 0x12
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.Replica.Size()))
	n1, err := m.Replica.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n1
	return i, nil
}

func (m *RangeDescriptor) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RangeDescriptor) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.RangeID))
	if m.StartKey != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintMetadata(dAtA, i, uint64(len(m.StartKey)))
		i += copy(dAtA[i:], m.StartKey)
	}
	if m.EndKey != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintMetadata(dAtA, i, uint64(len(m.EndKey)))
		i += copy(dAtA[i:], m.EndKey)
	}
	if len(m.Replicas) > 0 {
		for _, msg := range m.Replicas {
			dAtA[i] = 0x22
			i++
			i = encodeVarintMetadata(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x28
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.NextReplicaID))
	return i, nil
}

func (m *StoreCapacity) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StoreCapacity) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.Capacity))
	dAtA[i] = 0x10
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.Available))
	dAtA[i] = 0x18
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.RangeCount))
	dAtA[i] = 0x20
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.LeaseCount))
	return i, nil
}

func (m *NodeDescriptor) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodeDescriptor) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.NodeID))
	dAtA[i] = 0x12
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.Address.Size()))
	n2, err := m.Address.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n2
	dAtA[i] = 0x1a
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.Attrs.Size()))
	n3, err := m.Attrs.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n3
	dAtA[i] = 0x22
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.Locality.Size()))
	n4, err := m.Locality.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n4
	return i, nil
}

func (m *StoreDescriptor) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StoreDescriptor) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.StoreID))
	dAtA[i] = 0x12
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.Attrs.Size()))
	n5, err := m.Attrs.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n5
	dAtA[i] = 0x1a
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.Node.Size()))
	n6, err := m.Node.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n6
	dAtA[i] = 0x22
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.Capacity.Size()))
	n7, err := m.Capacity.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n7
	return i, nil
}

func (m *StoreDeadReplicas) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StoreDeadReplicas) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(m.StoreID))
	if len(m.Replicas) > 0 {
		for _, msg := range m.Replicas {
			dAtA[i] = 0x12
			i++
			i = encodeVarintMetadata(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Locality) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Locality) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Tiers) > 0 {
		for _, msg := range m.Tiers {
			dAtA[i] = 0xa
			i++
			i = encodeVarintMetadata(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *Tier) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Tier) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(len(m.Key)))
	i += copy(dAtA[i:], m.Key)
	dAtA[i] = 0x12
	i++
	i = encodeVarintMetadata(dAtA, i, uint64(len(m.Value)))
	i += copy(dAtA[i:], m.Value)
	return i, nil
}

func encodeFixed64Metadata(dAtA []byte, offset int, v uint64) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	dAtA[offset+4] = uint8(v >> 32)
	dAtA[offset+5] = uint8(v >> 40)
	dAtA[offset+6] = uint8(v >> 48)
	dAtA[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32Metadata(dAtA []byte, offset int, v uint32) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintMetadata(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func NewPopulatedReplicaDescriptor(r randyMetadata, easy bool) *ReplicaDescriptor {
	this := &ReplicaDescriptor{}
	this.NodeID = NodeID(r.Int31())
	if r.Intn(2) == 0 {
		this.NodeID *= -1
	}
	this.StoreID = StoreID(r.Int31())
	if r.Intn(2) == 0 {
		this.StoreID *= -1
	}
	this.ReplicaID = ReplicaID(r.Int31())
	if r.Intn(2) == 0 {
		this.ReplicaID *= -1
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

type randyMetadata interface {
	Float32() float32
	Float64() float64
	Int63() int64
	Int31() int32
	Uint32() uint32
	Intn(n int) int
}

func randUTF8RuneMetadata(r randyMetadata) rune {
	ru := r.Intn(62)
	if ru < 10 {
		return rune(ru + 48)
	} else if ru < 36 {
		return rune(ru + 55)
	}
	return rune(ru + 61)
}
func randStringMetadata(r randyMetadata) string {
	v1 := r.Intn(100)
	tmps := make([]rune, v1)
	for i := 0; i < v1; i++ {
		tmps[i] = randUTF8RuneMetadata(r)
	}
	return string(tmps)
}
func randUnrecognizedMetadata(r randyMetadata, maxFieldNumber int) (dAtA []byte) {
	l := r.Intn(5)
	for i := 0; i < l; i++ {
		wire := r.Intn(4)
		if wire == 3 {
			wire = 5
		}
		fieldNumber := maxFieldNumber + r.Intn(100)
		dAtA = randFieldMetadata(dAtA, r, fieldNumber, wire)
	}
	return dAtA
}
func randFieldMetadata(dAtA []byte, r randyMetadata, fieldNumber int, wire int) []byte {
	key := uint32(fieldNumber)<<3 | uint32(wire)
	switch wire {
	case 0:
		dAtA = encodeVarintPopulateMetadata(dAtA, uint64(key))
		v2 := r.Int63()
		if r.Intn(2) == 0 {
			v2 *= -1
		}
		dAtA = encodeVarintPopulateMetadata(dAtA, uint64(v2))
	case 1:
		dAtA = encodeVarintPopulateMetadata(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	case 2:
		dAtA = encodeVarintPopulateMetadata(dAtA, uint64(key))
		ll := r.Intn(100)
		dAtA = encodeVarintPopulateMetadata(dAtA, uint64(ll))
		for j := 0; j < ll; j++ {
			dAtA = append(dAtA, byte(r.Intn(256)))
		}
	default:
		dAtA = encodeVarintPopulateMetadata(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	}
	return dAtA
}
func encodeVarintPopulateMetadata(dAtA []byte, v uint64) []byte {
	for v >= 1<<7 {
		dAtA = append(dAtA, uint8(uint64(v)&0x7f|0x80))
		v >>= 7
	}
	dAtA = append(dAtA, uint8(v))
	return dAtA
}
func (m *Attributes) Size() (n int) {
	var l int
	_ = l
	if len(m.Attrs) > 0 {
		for _, s := range m.Attrs {
			l = len(s)
			n += 1 + l + sovMetadata(uint64(l))
		}
	}
	return n
}

func (m *ReplicationTarget) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovMetadata(uint64(m.NodeID))
	n += 1 + sovMetadata(uint64(m.StoreID))
	return n
}

func (m *ReplicaDescriptor) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovMetadata(uint64(m.NodeID))
	n += 1 + sovMetadata(uint64(m.StoreID))
	n += 1 + sovMetadata(uint64(m.ReplicaID))
	return n
}

func (m *ReplicaIdent) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovMetadata(uint64(m.RangeID))
	l = m.Replica.Size()
	n += 1 + l + sovMetadata(uint64(l))
	return n
}

func (m *RangeDescriptor) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovMetadata(uint64(m.RangeID))
	if m.StartKey != nil {
		l = len(m.StartKey)
		n += 1 + l + sovMetadata(uint64(l))
	}
	if m.EndKey != nil {
		l = len(m.EndKey)
		n += 1 + l + sovMetadata(uint64(l))
	}
	if len(m.Replicas) > 0 {
		for _, e := range m.Replicas {
			l = e.Size()
			n += 1 + l + sovMetadata(uint64(l))
		}
	}
	n += 1 + sovMetadata(uint64(m.NextReplicaID))
	return n
}

func (m *StoreCapacity) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovMetadata(uint64(m.Capacity))
	n += 1 + sovMetadata(uint64(m.Available))
	n += 1 + sovMetadata(uint64(m.RangeCount))
	n += 1 + sovMetadata(uint64(m.LeaseCount))
	return n
}

func (m *NodeDescriptor) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovMetadata(uint64(m.NodeID))
	l = m.Address.Size()
	n += 1 + l + sovMetadata(uint64(l))
	l = m.Attrs.Size()
	n += 1 + l + sovMetadata(uint64(l))
	l = m.Locality.Size()
	n += 1 + l + sovMetadata(uint64(l))
	return n
}

func (m *StoreDescriptor) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovMetadata(uint64(m.StoreID))
	l = m.Attrs.Size()
	n += 1 + l + sovMetadata(uint64(l))
	l = m.Node.Size()
	n += 1 + l + sovMetadata(uint64(l))
	l = m.Capacity.Size()
	n += 1 + l + sovMetadata(uint64(l))
	return n
}

func (m *StoreDeadReplicas) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovMetadata(uint64(m.StoreID))
	if len(m.Replicas) > 0 {
		for _, e := range m.Replicas {
			l = e.Size()
			n += 1 + l + sovMetadata(uint64(l))
		}
	}
	return n
}

func (m *Locality) Size() (n int) {
	var l int
	_ = l
	if len(m.Tiers) > 0 {
		for _, e := range m.Tiers {
			l = e.Size()
			n += 1 + l + sovMetadata(uint64(l))
		}
	}
	return n
}

func (m *Tier) Size() (n int) {
	var l int
	_ = l
	l = len(m.Key)
	n += 1 + l + sovMetadata(uint64(l))
	l = len(m.Value)
	n += 1 + l + sovMetadata(uint64(l))
	return n
}

func sovMetadata(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozMetadata(x uint64) (n int) {
	return sovMetadata(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *Attributes) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetadata
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Attributes: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Attributes: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attrs", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMetadata
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Attrs = append(m.Attrs, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetadata(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetadata
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReplicationTarget) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetadata
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReplicationTarget: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReplicationTarget: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			m.NodeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeID |= (NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StoreID", wireType)
			}
			m.StoreID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StoreID |= (StoreID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMetadata(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetadata
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReplicaDescriptor) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetadata
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReplicaDescriptor: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReplicaDescriptor: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			m.NodeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeID |= (NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StoreID", wireType)
			}
			m.StoreID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StoreID |= (StoreID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplicaID", wireType)
			}
			m.ReplicaID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ReplicaID |= (ReplicaID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMetadata(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetadata
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReplicaIdent) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetadata
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReplicaIdent: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReplicaIdent: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeID", wireType)
			}
			m.RangeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RangeID |= (RangeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Replica", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetadata
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Replica.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetadata(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetadata
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RangeDescriptor) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetadata
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RangeDescriptor: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RangeDescriptor: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeID", wireType)
			}
			m.RangeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RangeID |= (RangeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMetadata
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StartKey = append(m.StartKey[:0], dAtA[iNdEx:postIndex]...)
			if m.StartKey == nil {
				m.StartKey = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMetadata
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.EndKey = append(m.EndKey[:0], dAtA[iNdEx:postIndex]...)
			if m.EndKey == nil {
				m.EndKey = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Replicas", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetadata
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Replicas = append(m.Replicas, ReplicaDescriptor{})
			if err := m.Replicas[len(m.Replicas)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextReplicaID", wireType)
			}
			m.NextReplicaID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NextReplicaID |= (ReplicaID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMetadata(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetadata
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StoreCapacity) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetadata
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StoreCapacity: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StoreCapacity: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Capacity", wireType)
			}
			m.Capacity = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Capacity |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Available", wireType)
			}
			m.Available = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Available |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeCount", wireType)
			}
			m.RangeCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RangeCount |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field LeaseCount", wireType)
			}
			m.LeaseCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.LeaseCount |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMetadata(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetadata
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NodeDescriptor) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetadata
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NodeDescriptor: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NodeDescriptor: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			m.NodeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeID |= (NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Address", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetadata
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Address.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attrs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetadata
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Attrs.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Locality", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetadata
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Locality.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetadata(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetadata
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StoreDescriptor) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetadata
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StoreDescriptor: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StoreDescriptor: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StoreID", wireType)
			}
			m.StoreID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StoreID |= (StoreID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Attrs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetadata
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Attrs.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Node", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetadata
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Node.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Capacity", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetadata
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Capacity.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetadata(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetadata
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StoreDeadReplicas) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetadata
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StoreDeadReplicas: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StoreDeadReplicas: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StoreID", wireType)
			}
			m.StoreID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StoreID |= (StoreID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Replicas", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetadata
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Replicas = append(m.Replicas, ReplicaIdent{})
			if err := m.Replicas[len(m.Replicas)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetadata(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetadata
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Locality) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetadata
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Locality: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Locality: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Tiers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMetadata
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Tiers = append(m.Tiers, Tier{})
			if err := m.Tiers[len(m.Tiers)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetadata(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetadata
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Tier) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMetadata
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Tier: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Tier: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMetadata
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthMetadata
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMetadata(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMetadata
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipMetadata(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowMetadata
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMetadata
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthMetadata
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowMetadata
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipMetadata(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthMetadata = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowMetadata   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("cockroach/pkg/roachpb/metadata.proto", fileDescriptorMetadata) }

var fileDescriptorMetadata = []byte{
	// 789 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x55, 0xcf, 0x6b, 0x13, 0x4f,
	0x14, 0xcf, 0x26, 0x9b, 0xee, 0xe6, 0xb5, 0xfd, 0x96, 0x0c, 0x5f, 0x35, 0x44, 0xdc, 0x4d, 0x97,
	0x16, 0x0a, 0x4a, 0x82, 0x15, 0x0f, 0x46, 0xaa, 0x36, 0xad, 0x42, 0xac, 0xf4, 0xb0, 0xd6, 0x8b,
	0x97, 0x30, 0xdd, 0x19, 0xe3, 0xd2, 0xed, 0x6e, 0xd8, 0x9d, 0xd4, 0xe6, 0xac, 0x37, 0x11, 0x3c,
	0x7a, 0x2c, 0xf8, 0x0f, 0x78, 0xf4, 0x4f, 0x28, 0x9e, 0x3c, 0x7a, 0x0a, 0x1a, 0x2f, 0x9e, 0x3d,
	0x16, 0x04, 0x99, 0xd9, 0xd9, 0x4d, 0xd2, 0xa6, 0x60, 0x2b, 0x78, 0x7b, 0x79, 0xef, 0xf3, 0x99,
	0x7d, 0xef, 0xf3, 0x7e, 0x04, 0x16, 0x9c, 0xc0, 0xd9, 0x09, 0x03, 0xec, 0x3c, 0xaf, 0x75, 0x76,
	0xda, 0x35, 0x61, 0x75, 0xb6, 0x6b, 0xbb, 0x94, 0x61, 0x82, 0x19, 0xae, 0x76, 0xc2, 0x80, 0x05,
	0xa8, 0x98, 0xa2, 0xaa, 0x12, 0x51, 0x5e, 0x1a, 0x27, 0x76, 0x99, 0xeb, 0xd5, 0xba, 0x7e, 0x48,
	0xa3, 0xc0, 0xdb, 0xa3, 0xa4, 0x85, 0x09, 0x09, 0x63, 0x72, 0xf9, 0xff, 0x76, 0xd0, 0x0e, 0x84,
	0x59, 0xe3, 0x56, 0xec, 0xb5, 0xee, 0x02, 0xac, 0x32, 0x16, 0xba, 0xdb, 0x5d, 0x46, 0x23, 0x74,
	0x15, 0xf2, 0x98, 0xb1, 0x30, 0x2a, 0x29, 0x95, 0xdc, 0x52, 0xa1, 0x71, 0xe1, 0x67, 0xdf, 0x2c,
	0xf6, 0xf0, 0xae, 0x57, 0xb7, 0x84, 0xfb, 0xda, 0x33, 0x2f, 0x78, 0x61, 0xd9, 0x31, 0xa6, 0xae,
	0xbe, 0x3b, 0x30, 0x33, 0xd6, 0x4b, 0x05, 0x8a, 0x36, 0xed, 0x78, 0xae, 0x83, 0x99, 0x1b, 0xf8,
	0x5b, 0x38, 0x6c, 0x53, 0x86, 0xae, 0x83, 0xe6, 0x07, 0x84, 0xb6, 0x5c, 0x52, 0x52, 0x2a, 0xca,
	0x52, 0xbe, 0x51, 0x3a, 0xec, 0x9b, 0x99, 0x41, 0xdf, 0x9c, 0xda, 0x0c, 0x08, 0x6d, 0xae, 0x1f,
	0xa5, 0x96, 0x3d, 0xc5, 0x81, 0x4d, 0x82, 0x6e, 0x82, 0x1e, 0xb1, 0x20, 0x14, 0x9c, 0xac, 0xe0,
	0x94, 0x25, 0x47, 0x7b, 0xcc, 0xfd, 0x82, 0x94, 0x98, 0xb6, 0x26, 0xb0, 0x4d, 0x22, 0xb3, 0xf8,
	0x34, 0xcc, 0x62, 0x9d, 0x46, 0x4e, 0xe8, 0x76, 0x58, 0x10, 0xfe, 0xbb, 0x2c, 0xd0, 0x0a, 0x40,
	0x18, 0x7f, 0x9e, 0x13, 0x73, 0x82, 0x68, 0x48, 0x62, 0x41, 0x26, 0x26, 0xa8, 0xc3, 0x1f, 0x76,
	0x41, 0x32, 0x9a, 0xa4, 0x3e, 0xc3, 0x8b, 0xf8, 0x78, 0x60, 0x2a, 0x3f, 0x0e, 0x4c, 0xc5, 0x7a,
	0xad, 0xc0, 0x4c, 0x02, 0x23, 0xd4, 0x67, 0x3c, 0xa9, 0x10, 0xfb, 0xed, 0xb4, 0x90, 0xdc, 0x30,
	0x29, 0x9b, 0xfb, 0xe3, 0xa4, 0xa4, 0x69, 0x6b, 0x02, 0xdb, 0x24, 0x68, 0x1d, 0x34, 0xf9, 0x09,
	0x51, 0xca, 0xf4, 0xf2, 0x42, 0xf5, 0xc4, 0x00, 0x55, 0x4f, 0xa8, 0xd6, 0x50, 0xf9, 0xdb, 0x76,
	0x42, 0xb5, 0x3e, 0x64, 0x61, 0x4e, 0x3c, 0x3d, 0x22, 0xec, 0x39, 0x13, 0x5a, 0x84, 0x42, 0xc4,
	0x70, 0xc8, 0x5a, 0x3b, 0xb4, 0x27, 0x52, 0x9a, 0x69, 0xe8, 0x47, 0x7d, 0x53, 0xb5, 0x37, 0x68,
	0xcf, 0xd6, 0x45, 0x68, 0x83, 0xf6, 0xd0, 0x3c, 0x68, 0xd4, 0x27, 0x02, 0x94, 0x3b, 0x06, 0x9a,
	0xa2, 0x3e, 0xe1, 0x90, 0x07, 0xa0, 0xcb, 0xfc, 0xa2, 0x92, 0x5a, 0xc9, 0x9d, 0xb1, 0xb6, 0x94,
	0x8b, 0x1e, 0xc2, 0x9c, 0x4f, 0xf7, 0x59, 0x6b, 0xa4, 0x79, 0x79, 0xd1, 0x3c, 0x4b, 0xd6, 0x33,
	0xbb, 0x49, 0xf7, 0xd9, 0x29, 0x0d, 0x9c, 0xf5, 0x47, 0x62, 0xa4, 0xae, 0xf3, 0x26, 0x8a, 0x06,
	0xbe, 0x57, 0x60, 0x56, 0x8c, 0xc8, 0x1a, 0xee, 0x60, 0xc7, 0x65, 0x3d, 0x54, 0x01, 0xdd, 0x91,
	0xb6, 0x14, 0x4c, 0x66, 0x92, 0x78, 0x91, 0x05, 0x05, 0xbc, 0x87, 0x5d, 0x0f, 0x6f, 0x7b, 0x54,
	0x68, 0x93, 0x40, 0x86, 0x6e, 0xb4, 0x08, 0xd3, 0xb1, 0xec, 0x4e, 0xd0, 0xf5, 0x99, 0x1c, 0xb3,
	0x18, 0x05, 0x22, 0xb0, 0xc6, 0xfd, 0x1c, 0xe6, 0x51, 0x1c, 0x25, 0x30, 0x75, 0x14, 0x26, 0x02,
	0x02, 0x66, 0xfd, 0x52, 0xe0, 0x3f, 0x3e, 0xfd, 0x7f, 0xb7, 0x30, 0x77, 0x40, 0xe3, 0x47, 0x86,
	0x46, 0x91, 0x1c, 0x32, 0x63, 0xa4, 0x11, 0xfc, 0x1c, 0x55, 0x9f, 0xa4, 0xe7, 0x68, 0x95, 0x90,
	0x74, 0xbc, 0x24, 0x09, 0xdd, 0x4a, 0x4e, 0x4e, 0x4e, 0xb0, 0xaf, 0x4c, 0x68, 0xe3, 0xf0, 0x40,
	0x49, 0x72, 0xcc, 0x40, 0x2b, 0xa0, 0x7b, 0x81, 0x83, 0x3d, 0x2e, 0xaa, 0x2a, 0xd8, 0x97, 0x27,
	0xb0, 0x1f, 0x49, 0x48, 0xa2, 0x78, 0x42, 0xb1, 0x5e, 0x65, 0x61, 0x4e, 0x74, 0x69, 0x7c, 0xb0,
	0xd3, 0xf5, 0x57, 0xfe, 0x7c, 0xfd, 0xd3, 0x22, 0xb2, 0x67, 0x2e, 0xe2, 0x36, 0xa8, 0x5c, 0x49,
	0x59, 0xfe, 0xfc, 0x04, 0xe6, 0x78, 0x8f, 0x24, 0x5b, 0x90, 0x50, 0x63, 0x64, 0xac, 0x62, 0x05,
	0x2a, 0x13, 0x1e, 0x18, 0x1b, 0xc5, 0xe3, 0x83, 0x67, 0xbd, 0x51, 0xa0, 0x28, 0x65, 0xc0, 0xc4,
	0x4e, 0x16, 0xe3, 0x9c, 0x42, 0xac, 0x8e, 0xec, 0x65, 0x56, 0xec, 0xa5, 0x79, 0xfa, 0x5e, 0x8a,
	0xe3, 0x76, 0x7c, 0x25, 0xad, 0xfb, 0xa0, 0x27, 0x2d, 0x43, 0x37, 0x20, 0xcf, 0x5c, 0x2a, 0xff,
	0x8f, 0xa6, 0x97, 0x2f, 0x4d, 0x78, 0x6b, 0xcb, 0xa5, 0x89, 0x26, 0x31, 0x56, 0xfe, 0x23, 0xdc,
	0x03, 0x95, 0x87, 0xd0, 0x45, 0xc8, 0xf1, 0x43, 0xc2, 0x6b, 0x28, 0x48, 0x1c, 0x77, 0xa0, 0x32,
	0xe4, 0xf7, 0xb0, 0xd7, 0x8d, 0x77, 0x2d, 0x89, 0xc4, 0xae, 0xf8, 0x85, 0xc6, 0xfc, 0xe1, 0x37,
	0x23, 0x73, 0x38, 0x30, 0x94, 0xcf, 0x03, 0x43, 0xf9, 0x32, 0x30, 0x94, 0xaf, 0x03, 0x43, 0x79,
	0xfb, 0xdd, 0xc8, 0x3c, 0xd5, 0xe4, 0xc7, 0x7f, 0x07, 0x00, 0x00, 0xff, 0xff, 0x10, 0xeb, 0xea,
	0xe1, 0xb7, 0x07, 0x00, 0x00,
}
