// Author: Max Lang (max@cockroachlabs.com)

// Exports the following icons as SVG strings:
//
// clusterIcon, cockroachIcon, databaseIcon, gearIcon
// nodesIcon, storesIcon, usersIcon

export const clusterIcon: string = `<svg width="24px" height="24px" viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:sketch="http://www.bohemiancoding.com/sketch/ns">
  <!-- Generator: Sketch 3.3.3 (12081) - http://www.bohemiancoding.com/sketch -->
  <title>Cluster Icon</title>
  <desc>Created with Sketch.</desc>
  <defs></defs>
  <g id="Update-6" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd" sketch:type="MSPage">
    <g id="UI-Kit" sketch:type="MSArtboardGroup" transform="translate(-143.000000, -3020.000000)" fill="#959797">
      <g id="Navigation" sketch:type="MSLayerGroup" transform="translate(112.000000, 2654.000000)">
        <g id="Main-Navigation" transform="translate(3.000000, 225.000000)" sketch:type="MSShapeGroup">
          <g id="Rest" transform="translate(0.000000, 90.000000)">
            <g id="Clusters" transform="translate(16.000000, 51.000000)">
              <path d="M23.5767273,0 C17.1832727,0 12,5.34525 12,11.9385 C12,18.53175 17.1832727,23.877 23.5767273,23.877 C29.9701818,23.877 35.1534545,18.53175 35.1534545,11.9385 C35.1534545,5.34525 29.9701818,0 23.5767273,0 M20.0254545,11.9385 C20.0254545,10.8495 20.1090909,9.76425 20.2567273,8.6895 C21.3505455,8.84625 22.4538182,8.9535 23.5767273,8.9535 C24.6996364,8.9535 25.8036364,8.84625 26.8974545,8.6895 C27.0450909,9.76425 27.128,10.84875 27.128,11.9385 C27.128,13.0275 27.0450909,14.11275 26.8974545,15.18675 C25.8036364,15.03 24.6996364,14.92275 23.5767273,14.92275 C22.4538182,14.92275 21.3498182,15.03 20.2567273,15.18675 C20.1090909,14.11275 20.0254545,13.0275 20.0254545,11.9385 M28.3250909,8.451 C29.7701818,8.15025 31.1789091,7.69425 32.5541818,7.11675 C33.2858182,8.56125 33.7061818,10.19925 33.7061818,11.9385 C33.7061818,13.67775 33.2858182,15.31575 32.5541818,16.76025 C31.1789091,16.182 29.7701818,15.726 28.3250909,15.426 C28.4850909,14.2725 28.5752727,13.10775 28.5752727,11.9385 C28.5752727,10.76925 28.4850909,9.6045 28.3250909,8.451 M31.7781818,5.83125 C30.5716364,6.32175 29.3410909,6.71775 28.0778182,6.9825 C27.7338182,5.25 27.2123636,3.5595 26.5192727,1.9455 C28.6596364,2.61675 30.4945455,4.00425 31.7781818,5.83125 M24.7432727,1.5675 C25.6130909,3.35625 26.2530909,5.259 26.6487273,7.22175 C25.6363636,7.36425 24.6152727,7.46175 23.5767273,7.46175 C22.5381818,7.46175 21.5170909,7.36425 20.5054545,7.22175 C20.9003636,5.25975 21.5410909,3.35625 22.4109091,1.5675 C22.7941818,1.52175 23.1818182,1.4925 23.5767273,1.4925 C23.9716364,1.4925 24.36,1.52175 24.7432727,1.5675 M20.6349091,1.9455 C19.9418182,3.5595 19.4203636,5.25 19.0763636,6.9825 C17.8130909,6.717 16.5818182,6.32175 15.376,5.83125 C16.6596364,4.0035 18.4945455,2.61675 20.6349091,1.9455 M14.6,7.11675 C15.9752727,7.69425 17.3832727,8.15025 18.8290909,8.451 C18.6690909,9.6045 18.5789091,10.76925 18.5789091,11.9385 C18.5789091,13.10775 18.6690909,14.2725 18.8283636,15.42525 C17.3832727,15.726 15.9752727,16.182 14.6,16.76025 C13.8676364,15.31575 13.448,13.67775 13.448,11.9385 C13.448,10.1985 13.8676364,8.5605 14.6,7.11675 M15.376,18.04575 C16.5818182,17.556 17.8130909,17.16 19.0756364,16.8945 C19.4196364,18.62775 19.9425455,20.31825 20.6370909,21.93225 C18.496,21.261 16.6603636,19.8735 15.376,18.04575 M22.4138182,22.31025 C21.5425455,20.5215 20.9010909,18.618 20.5054545,16.65525 C21.5170909,16.51275 22.5381818,16.41525 23.5767273,16.41525 C24.6152727,16.41525 25.6363636,16.51275 26.648,16.65525 C26.2530909,18.618 25.6116364,20.52075 24.7418182,22.3095 C24.3585455,22.35525 23.9709091,22.3845 23.5767273,22.3845 C23.1832727,22.3845 22.7956364,22.35525 22.4138182,22.31025 M26.5170909,21.93225 C27.2109091,20.31825 27.7330909,18.62775 28.0778182,16.8945 C29.3403636,17.16 30.5716364,17.556 31.7774545,18.04575 C30.4938182,19.8735 28.6581818,21.261 26.5170909,21.93225" id="Cluster-Icon"></path>
            </g>
          </g>
        </g>
      </g>
    </g>
  </g>
</svg>`;

export const cockroachIcon: string = `<svg width="38px" height="38px" viewBox="0 0 38 38" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:sketch="http://www.bohemiancoding.com/sketch/ns">
  <!-- Generator: Sketch 3.3.3 (12081) - http://www.bohemiancoding.com/sketch -->
  <title>CL Mark</title>
  <desc>Created with Sketch.</desc>
  <g id="Update-6" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd" sketch:type="MSPage">
    <g id="Line-Chart-(v4)" sketch:type="MSArtboardGroup" transform="translate(-20.000000, -29.000000)">
      <g id="Header" sketch:type="MSLayerGroup" transform="translate(-15.000000, -47.000000)">
        <g id="CL-Mark" transform="translate(35.000000, 76.000000)">
          <g id="Group-3">
            <g id="Clip-2"></g>
            <path d="M23.0622,10.88928 C21.72574,11.2024 20.3281,11.36466 18.89664,11.36466 C17.46518,11.36466 16.06754,11.2024 14.72538,10.88928 C15.84372,9.11696 17.25846,7.53996 18.89664,6.24302 C20.5352,7.54566 21.94386,9.11696 23.0622,10.88928 L23.0622,10.88928 Z M35.66034,0.68134 C33.97998,0.23294 32.2088,0 30.3867,0 C26.14058,0 22.18972,1.27718 18.89132,3.47396 C15.599,1.27718 11.64814,0 7.39632,0 C5.57384,0 3.80266,0.23294 2.1223,0.68134 C1.41322,0.86108 0.72504,1.08832 0.05244,1.34292 C0.00874,1.35926 -0.01216,1.41094 0.00722,1.4535 C0.30134,2.0919 0.62928,2.71054 0.98192,3.30942 C1.0013,3.34248 1.04158,3.35692 1.07768,3.344 C1.77878,3.09244 2.49622,2.87888 3.22962,2.70788 C4.56912,2.39552 5.96562,2.23668 7.39632,2.23668 C10.90448,2.23668 14.1854,3.2186 16.9898,4.91036 C15.21292,6.41478 13.69178,8.21408 12.50504,10.2296 C12.27248,10.6153 12.06234,11.00708 11.8579,11.40456 C11.72186,11.67132 11.59114,11.94378 11.4608,12.22764 C11.27346,12.65324 11.09182,13.07922 10.9326,13.51622 C10.09242,15.77 9.63262,18.21074 9.63262,20.74838 C9.63262,26.62356 12.09084,31.9371 16.0303,35.71772 C16.33696,36.01868 16.65502,36.30254 16.9898,36.5807 C17.25086,36.80756 17.51192,37.0177 17.78438,37.22214 C18.12752,37.4946 18.48662,37.74578 18.8461,37.98632 C18.87346,38.00494 18.90956,38.00456 18.93692,37.98594 C19.29602,37.74008 19.64942,37.4889 19.99256,37.22214 C20.27072,37.0177 20.53216,36.80756 20.79322,36.5807 C21.1223,36.30254 21.45176,36.01298 21.75804,35.71772 C25.69218,31.9371 28.15002,26.61786 28.15002,20.74838 C28.15002,18.21074 27.69022,15.7757 26.85004,13.52192 C26.6855,13.08492 26.50956,12.65324 26.31652,12.22764 C26.19188,11.94378 26.06116,11.67132 25.93044,11.40456 C25.72068,11.00708 25.51054,10.6153 25.2776,10.2296 C24.08554,8.21408 22.5701,6.41478 20.79322,4.91036 C23.59762,3.2186 26.87854,2.23668 30.3867,2.23668 C31.8174,2.23668 33.2139,2.39552 34.5534,2.70788 C35.28642,2.87888 36.00918,3.09244 36.70534,3.34362 C36.74144,3.35692 36.78172,3.34248 36.8011,3.30942 C37.15336,2.71054 37.47636,2.0919 37.77466,1.45388 C37.7948,1.41094 37.7739,1.35926 37.72944,1.34254 C37.05228,1.08832 36.3641,0.86108 35.66034,0.68134 L35.66034,0.68134 Z" id="Fill-1" fill="#151F34" sketch:type="MSShapeGroup"></path>
          </g>
          <path d="M25.91372,20.7499 C25.91372,25.65912 23.99396,30.12526 20.86086,33.4419 C20.31024,31.68174 20.0108,29.81404 20.0108,27.88212 C20.0108,22.97328 21.93056,18.49916 25.06366,15.1905 C25.61428,16.94648 25.91372,18.81418 25.91372,20.7499" id="Fill-4" fill="#348540" sketch:type="MSShapeGroup"></path>
          <path d="M17.77184,27.88212 C17.77184,29.81404 17.4762,31.68174 16.9214,33.4419 C13.7883,30.12526 11.86854,25.65912 11.86854,20.7499 C11.86854,18.81418 12.17216,16.94648 12.72696,15.1905 C15.86006,18.49916 17.77184,22.97328 17.77184,27.88212" id="Fill-5" fill="#7DBC42" sketch:type="MSShapeGroup"></path>
        </g>
      </g>
    </g>
  </g>
</svg>`;

export const cockroachIconSmall: string = `<svg width="22px" height="22px" viewBox="0 0 38 38" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:sketch="http://www.bohemiancoding.com/sketch/ns">
  <!-- Generator: Sketch 3.3.3 (12081) - http://www.bohemiancoding.com/sketch -->
  <title>CL Mark</title>
  <desc>Created with Sketch.</desc>
  <g id="Update-6" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd" sketch:type="MSPage" >
    <g id="Line-Chart-(v4)" sketch:type="MSArtboardGroup" transform="translate(-20.000000, -29.000000)">
      <g id="Header" sketch:type="MSLayerGroup" transform="translate(-15.000000, -47.000000)">
        <g id="CL-Mark" transform="translate(35.000000, 76.000000)">
          <g id="Group-3">
            <g id="Clip-2"></g>
            <path d="M23.0622,10.88928 C21.72574,11.2024 20.3281,11.36466 18.89664,11.36466 C17.46518,11.36466 16.06754,11.2024 14.72538,10.88928 C15.84372,9.11696 17.25846,7.53996 18.89664,6.24302 C20.5352,7.54566 21.94386,9.11696 23.0622,10.88928 L23.0622,10.88928 Z M35.66034,0.68134 C33.97998,0.23294 32.2088,0 30.3867,0 C26.14058,0 22.18972,1.27718 18.89132,3.47396 C15.599,1.27718 11.64814,0 7.39632,0 C5.57384,0 3.80266,0.23294 2.1223,0.68134 C1.41322,0.86108 0.72504,1.08832 0.05244,1.34292 C0.00874,1.35926 -0.01216,1.41094 0.00722,1.4535 C0.30134,2.0919 0.62928,2.71054 0.98192,3.30942 C1.0013,3.34248 1.04158,3.35692 1.07768,3.344 C1.77878,3.09244 2.49622,2.87888 3.22962,2.70788 C4.56912,2.39552 5.96562,2.23668 7.39632,2.23668 C10.90448,2.23668 14.1854,3.2186 16.9898,4.91036 C15.21292,6.41478 13.69178,8.21408 12.50504,10.2296 C12.27248,10.6153 12.06234,11.00708 11.8579,11.40456 C11.72186,11.67132 11.59114,11.94378 11.4608,12.22764 C11.27346,12.65324 11.09182,13.07922 10.9326,13.51622 C10.09242,15.77 9.63262,18.21074 9.63262,20.74838 C9.63262,26.62356 12.09084,31.9371 16.0303,35.71772 C16.33696,36.01868 16.65502,36.30254 16.9898,36.5807 C17.25086,36.80756 17.51192,37.0177 17.78438,37.22214 C18.12752,37.4946 18.48662,37.74578 18.8461,37.98632 C18.87346,38.00494 18.90956,38.00456 18.93692,37.98594 C19.29602,37.74008 19.64942,37.4889 19.99256,37.22214 C20.27072,37.0177 20.53216,36.80756 20.79322,36.5807 C21.1223,36.30254 21.45176,36.01298 21.75804,35.71772 C25.69218,31.9371 28.15002,26.61786 28.15002,20.74838 C28.15002,18.21074 27.69022,15.7757 26.85004,13.52192 C26.6855,13.08492 26.50956,12.65324 26.31652,12.22764 C26.19188,11.94378 26.06116,11.67132 25.93044,11.40456 C25.72068,11.00708 25.51054,10.6153 25.2776,10.2296 C24.08554,8.21408 22.5701,6.41478 20.79322,4.91036 C23.59762,3.2186 26.87854,2.23668 30.3867,2.23668 C31.8174,2.23668 33.2139,2.39552 34.5534,2.70788 C35.28642,2.87888 36.00918,3.09244 36.70534,3.34362 C36.74144,3.35692 36.78172,3.34248 36.8011,3.30942 C37.15336,2.71054 37.47636,2.0919 37.77466,1.45388 C37.7948,1.41094 37.7739,1.35926 37.72944,1.34254 C37.05228,1.08832 36.3641,0.86108 35.66034,0.68134 L35.66034,0.68134 Z" id="Fill-1" fill="#151F34" sketch:type="MSShapeGroup"></path>
          </g>
          <path d="M25.91372,20.7499 C25.91372,25.65912 23.99396,30.12526 20.86086,33.4419 C20.31024,31.68174 20.0108,29.81404 20.0108,27.88212 C20.0108,22.97328 21.93056,18.49916 25.06366,15.1905 C25.61428,16.94648 25.91372,18.81418 25.91372,20.7499" id="Fill-6" fill="#348540" sketch:type="MSShapeGroup"></path>
          <path d="M17.77184,27.88212 C17.77184,29.81404 17.4762,31.68174 16.9214,33.4419 C13.7883,30.12526 11.86854,25.65912 11.86854,20.7499 C11.86854,18.81418 12.17216,16.94648 12.72696,15.1905 C15.86006,18.49916 17.77184,22.97328 17.77184,27.88212" id="Fill-7" fill="#7DBC42" sketch:type="MSShapeGroup"></path>
        </g>
      </g>
    </g>
  </g>
</svg>`;

export const databaseIcon: string = `<svg width="24px" height="24px" viewBox="0 0 22 22" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:sketch="http://www.bohemiancoding.com/sketch/ns">
  <!-- Generator: Sketch 3.3.3 (12081) - http://www.bohemiancoding.com/sketch -->
  <title>Database Icon</title>
  <desc>Created with Sketch.</desc>
  <defs></defs>
  <g id="Update-6" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd" sketch:type="MSPage">
    <g id="UI-Kit" sketch:type="MSArtboardGroup" transform="translate(-144.000000, -3260.000000)" fill="#959797">
      <g id="Navigation" sketch:type="MSLayerGroup" transform="translate(112.000000, 2654.000000)">
        <g id="Main-Navigation" transform="translate(3.000000, 225.000000)" sketch:type="MSShapeGroup">
          <g id="Rest" transform="translate(0.000000, 90.000000)">
            <g id="Databases" transform="translate(8.000000, 291.000000)">
              <path d="M31.6666667,0 C26.5293333,0 21,1.042 21,3.326 L21,18.2466667 C21,20.5306667 26.5293333,21.5726667 31.6666667,21.5726667 C36.8033333,21.5726667 42.3326667,20.5306667 42.3326667,18.2466667 L42.3326667,3.326 C42.3326667,1.042 36.8033333,0 31.6666667,0 L31.6666667,0 Z M40.942,18.2466667 C40.942,18.3586667 40.514,18.9253333 38.5373333,19.4473333 C36.7106667,19.9313333 34.2706667,20.1966667 31.6666667,20.1966667 C29.062,20.1966667 26.6213333,19.9313333 24.7953333,19.4473333 C22.8186667,18.9253333 22.3906667,18.3586667 22.3906667,18.2466667 L22.3906667,15.0293333 C24.3566667,16.0986667 28.1046667,16.5993333 31.6666667,16.5993333 C35.228,16.5993333 38.976,16.0986667 40.942,15.0293333 L40.942,18.2466667 L40.942,18.2466667 Z M40.942,13.2733333 C40.942,13.3853333 40.514,13.9506667 38.5373333,14.474 C36.7106667,14.9566667 34.2706667,15.2226667 31.6666667,15.2226667 C29.062,15.2226667 26.6213333,14.9566667 24.7953333,14.474 C22.8186667,13.9506667 22.3906667,13.3853333 22.3906667,13.2733333 L22.3906667,10.056 C24.3566667,11.1253333 28.1046667,11.6253333 31.6666667,11.6253333 C35.228,11.6253333 38.976,11.1253333 40.942,10.056 L40.942,13.2733333 L40.942,13.2733333 Z M40.942,8.29933333 C40.942,8.41133333 40.514,8.97733333 38.5373333,9.49933333 C36.7106667,9.98266667 34.2706667,10.248 31.6666667,10.248 C29.062,10.248 26.6213333,9.98266667 24.7953333,9.49933333 C22.8186667,8.97733333 22.3906667,8.41133333 22.3906667,8.29933333 L22.3906667,5.082 C24.3566667,6.15133333 28.1046667,6.652 31.6666667,6.652 C35.228,6.652 38.976,6.15133333 40.942,5.082 L40.942,8.29933333 L40.942,8.29933333 Z M38.5373333,4.52533333 C36.7106667,5.00933333 34.2706667,5.27466667 31.6666667,5.27466667 C29.062,5.27466667 26.6213333,5.00933333 24.7953333,4.52533333 C22.8186667,4.00333333 22.3906667,3.438 22.3906667,3.326 C22.3906667,3.214 22.8186667,2.64866667 24.7953333,2.12533333 C26.6213333,1.642 29.062,1.37666667 31.6666667,1.37666667 C34.2706667,1.37666667 36.7106667,1.642 38.5373333,2.12533333 C40.514,2.64866667 40.942,3.214 40.942,3.326 C40.942,3.438 40.514,4.00333333 38.5373333,4.52533333 L38.5373333,4.52533333 Z" id="Database-Icon"></path>
            </g>
          </g>
        </g>
      </g>
    </g>
  </g>
</svg>`;

export const gearIcon: string = `<svg width="24px" height="24px" viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:sketch="http://www.bohemiancoding.com/sketch/ns">
  <!-- Generator: Sketch 3.3.3 (12081) - http://www.bohemiancoding.com/sketch -->
  <title>Gear Icon</title>
  <desc>Created with Sketch.</desc>
  <defs></defs>
  <g id="Update-6" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd" sketch:type="MSPage">
    <g id="UI-Kit" sketch:type="MSArtboardGroup" transform="translate(-143.000000, -3483.000000)" fill="#959797">
      <g id="Navigation" sketch:type="MSLayerGroup" transform="translate(112.000000, 2654.000000)">
        <g id="Main-Navigation" transform="translate(3.000000, 225.000000)" sketch:type="MSShapeGroup">
          <g id="Rest" transform="translate(0.000000, 90.000000)">
            <g id="Account" transform="translate(1.000000, 494.000000)">
              <g id="Gear-Icon" transform="translate(27.000000, 20.000000)">
                <path d="M12.1133333,7.70466667 C9.80466667,7.70466667 7.92466667,9.58333333 7.92466667,11.8926667 C7.92466667,14.2033333 9.80466667,16.082 12.1133333,16.082 C14.4253333,16.082 16.3053333,14.2033333 16.3053333,11.894 C16.3053333,9.58333333 14.424,7.70466667 12.1133333,7.70466667 M12.1133333,14.6106667 C10.6153333,14.6106667 9.39533333,13.3913333 9.39533333,11.8926667 C9.39533333,10.394 10.6153333,9.17466667 12.1133333,9.17466667 C13.6146667,9.17466667 14.8346667,10.394 14.8346667,11.8926667 C14.8346667,13.3913333 13.6146667,14.6106667 12.1133333,14.6106667" id="Fill-1"></path>
                <path d="M23.264,11.4553333 L21.0273333,10.2326667 C20.9833333,9.988 20.9293333,9.74733333 20.8646667,9.51266667 L22.344,7.43933333 C22.582,7.10533333 22.5713333,6.65333333 22.316,6.334 L21.0706667,4.768 C21.0626667,4.758 21.0546667,4.748 21.0466667,4.73866667 L19.8,3.178 C19.5446667,2.856 19.106,2.744 18.728,2.90333333 L16.3766667,3.88666667 C16.1533333,3.76666667 15.9233333,3.65666667 15.6893333,3.558 L15.0173333,1.186 C14.906,0.790666667 14.544,0.516666667 14.1333333,0.516666667 L10.1006667,0.516666667 C9.69,0.516666667 9.328,0.790666667 9.216,1.186 L8.54466667,3.55666667 C8.308,3.65666667 8.078,3.76666667 7.85333333,3.88666667 L5.50266667,2.90333333 C5.124,2.744 4.68533333,2.85733333 4.43,3.178 L3.19466667,4.72533333 L3.186,4.73466667 C3.17666667,4.74533333 3.16733333,4.75666667 3.158,4.768 L1.91333333,6.334 C1.65933333,6.65466667 1.64666667,7.10533333 1.88533333,7.43933333 L3.368,9.516 C3.30466667,9.75066667 3.24933333,9.988 3.20533333,10.2313333 L0.967333333,11.46 C0.608,11.658 0.422,12.0706667 0.514,12.47 L0.958,14.42 C0.961333333,14.4406667 0.967333333,14.4613333 0.974,14.484 L1.41,16.4013333 C1.50133333,16.8 1.84733333,17.0926667 2.258,17.114 L4.80533333,17.248 C4.94933333,17.4466667 5.10266667,17.6393333 5.26533333,17.8253333 L4.82933333,20.3386667 C4.75933333,20.7426667 4.96533333,21.1446667 5.33533333,21.3233333 L7.136,22.192 C7.156,22.204 7.176,22.2113333 7.19666667,22.2193333 L8.96733333,23.0753333 C9.336,23.256 9.78,23.1653333 10.0533333,22.8586667 L11.7486667,20.9493333 C11.9886667,20.9593333 12.236,20.9593333 12.4806667,20.9493333 L14.178,22.8586667 C14.3566667,23.0593333 14.6086667,23.1673333 14.8653333,23.1673333 C15,23.1673333 15.136,23.1373333 15.2653333,23.074 L17.036,22.2193333 C17.0566667,22.2113333 17.0766667,22.2026667 17.0966667,22.192 L18.8973333,21.3233333 C19.2673333,21.146 19.4733333,20.7426667 19.4033333,20.34 L18.9673333,17.824 C19.126,17.6406667 19.2793333,17.4493333 19.4246667,17.252 L21.9733333,17.1173333 C22.384,17.0953333 22.73,16.804 22.8213333,16.4033333 L23.7186667,12.4653333 C23.8106667,12.0653333 23.6246667,11.6533333 23.264,11.4553333 M21.938,14.1253333 C21.9366667,14.1346667 21.9333333,14.144 21.932,14.1533333 L21.628,15.494 L19.212,15.622 C18.9066667,15.6366667 18.6273333,15.796 18.4593333,16.052 C18.1966667,16.4493333 17.9006667,16.8206667 17.58,17.1513333 C17.3666667,17.3733333 17.272,17.684 17.324,17.9866667 L17.738,20.3753333 L16.5353333,20.9553333 C16.514,20.9633333 16.4926667,20.974 16.4713333,20.984 L15.238,21.5786667 L13.6273333,19.7653333 C13.442,19.5593333 13.1793333,19.4413333 12.906,19.4413333 C12.8733333,19.4413333 12.8406667,19.4426667 12.8113333,19.444 C12.356,19.4893333 11.882,19.4893333 11.4233333,19.444 C11.114,19.4133333 10.812,19.5326667 10.6073333,19.7633333 L8.99666667,21.5773333 L7.76266667,20.9826667 C7.74133333,20.9706667 7.72,20.962 7.69933333,20.954 L6.496,20.3733333 L6.91,17.9886667 C6.96266667,17.6853333 6.866,17.376 6.65266667,17.1546667 C6.32,16.8106667 6.028,16.4426667 5.78333333,16.0626667 C5.61533333,15.8006667 5.33133333,15.6366667 5.022,15.6206667 L2.60266667,15.4926667 L2.29866667,14.1573333 C2.29466667,14.1346667 2.28933333,14.114 2.282,14.0913333 L1.98533333,12.7886667 L4.11066667,11.6213333 C4.38,11.4726667 4.562,11.2046667 4.602,10.8993333 C4.66266667,10.4293333 4.76533333,9.97333333 4.91066667,9.54066667 C5.008,9.24733333 4.96,8.926 4.78066667,8.67466667 L3.372,6.70266667 L4.212,5.648 L4.22066667,5.63933333 C4.23066667,5.62733333 4.23866667,5.61666667 4.24866667,5.60466667 L5.10466667,4.53266667 L7.33466667,5.46533333 C7.61866667,5.584 7.94133333,5.56 8.206,5.40266667 C8.61066667,5.15733333 9.04733333,4.948 9.50066667,4.78133333 C9.78866667,4.67533333 10.0086667,4.436 10.0933333,4.14 L10.7286667,1.89933333 L13.5,1.89933333 L14.1353333,4.14266667 C14.22,4.44 14.442,4.67933333 14.7326667,4.78533333 C15.1786667,4.94933333 15.6133333,5.156 16.0213333,5.40266667 C16.2833333,5.56 16.6073333,5.584 16.8906667,5.46533333 L19.1213333,4.53266667 L19.9766667,5.60466667 C19.9853333,5.61533333 19.994,5.62533333 20.0026667,5.63466667 L20.852,6.704 L19.4473333,8.67333333 C19.2666667,8.92466667 19.2193333,9.24533333 19.3173333,9.54 C19.4613333,9.97133333 19.566,10.4306667 19.6266667,10.9013333 C19.6666667,11.208 19.85,11.4766667 20.1213333,11.6253333 L22.2446667,12.7873333 L21.938,14.1253333" id="Fill-2"></path>
              </g>
            </g>
          </g>
        </g>
      </g>
    </g>
  </g>
</svg>`;

export const nodesIcon: string = `<svg width="24px" height="20px" viewBox="0 0 24 20" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:sketch="http://www.bohemiancoding.com/sketch/ns">
  <!-- Generator: Sketch 3.3.3 (12081) - http://www.bohemiancoding.com/sketch -->
  <title>Nodes Icon</title>
  <desc>Created with Sketch.</desc>
  <defs></defs>
  <g id="Update-6" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd" sketch:type="MSPage">
    <g id="UI-Kit" sketch:type="MSArtboardGroup" transform="translate(-143.000000, -3102.000000)" fill="#959797">
      <g id="Navigation" sketch:type="MSLayerGroup" transform="translate(112.000000, 2654.000000)">
        <g id="Main-Navigation" transform="translate(3.000000, 225.000000)" sketch:type="MSShapeGroup">
          <g id="Rest" transform="translate(0.000000, 90.000000)">
            <g id="Nodes" transform="translate(21.000000, 133.000000)">
              <path d="M11.198,5.48266667 L29.4493333,5.48266667 C29.8266667,5.48266667 30.1326667,5.17666667 30.1326667,4.79866667 L30.1326667,0.684 C30.1326667,0.306 29.8266667,0 29.4493333,0 L11.198,0 C10.8206667,0 10.5146667,0.306 10.5146667,0.684 L10.5146667,2.286 L7.68333333,2.286 C7.306,2.286 7,2.592 7,2.97 L7,16.606 C7,16.984 7.306,17.29 7.68333333,17.29 L10.5146667,17.29 L10.5146667,19.0013333 C10.5146667,19.3793333 10.8206667,19.6853333 11.198,19.6853333 L29.4493333,19.6853333 C29.8266667,19.6853333 30.1326667,19.3793333 30.1326667,19.0013333 L30.1326667,14.8866667 C30.1326667,14.5086667 29.8266667,14.2026667 29.4493333,14.2026667 L11.198,14.2026667 C10.8206667,14.2026667 10.5146667,14.5086667 10.5146667,14.8866667 L10.5146667,15.922 L8.36733333,15.922 L8.36733333,10.472 L10.5146667,10.472 L10.5146667,11.898 C10.5146667,12.276 10.8206667,12.582 11.198,12.582 L29.4493333,12.582 C29.8266667,12.582 30.1326667,12.276 30.1326667,11.898 L30.1326667,7.78266667 C30.1326667,7.40466667 29.8266667,7.09866667 29.4493333,7.09866667 L11.198,7.09866667 C10.8206667,7.09866667 10.5146667,7.40466667 10.5146667,7.78266667 L10.5146667,9.10333333 L8.36733333,9.10333333 L8.36733333,3.654 L10.5146667,3.654 L10.5146667,4.79866667 C10.5146667,5.17666667 10.8206667,5.48266667 11.198,5.48266667 L11.198,5.48266667 Z M11.8813333,1.368 L28.7653333,1.368 L28.7653333,4.11466667 L11.8813333,4.11466667 L11.8813333,1.368 Z M11.8813333,15.5706667 L28.7653333,15.5706667 L28.7653333,18.3173333 L11.8813333,18.3173333 L11.8813333,15.5706667 Z M11.8813333,8.46666667 L28.7653333,8.46666667 L28.7653333,11.214 L11.8813333,11.214 L11.8813333,8.46666667 Z" id="Nodes-Icon"></path>
            </g>
          </g>
        </g>
      </g>
    </g>
  </g>
</svg>`;

export const storesIcon: string = `<svg width="24px" height="22px" viewBox="0 0 24 22" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:sketch="http://www.bohemiancoding.com/sketch/ns">
  <!-- Generator: Sketch 3.3.3 (12081) - http://www.bohemiancoding.com/sketch -->
  <title>Stores Icon</title>
  <desc>Created with Sketch.</desc>
  <defs></defs>
  <g id="Update-6" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd" sketch:type="MSPage">
    <g id="UI-Kit" sketch:type="MSArtboardGroup" transform="translate(-143.000000, -3181.000000)" fill="#959797">
      <g id="Navigation" sketch:type="MSLayerGroup" transform="translate(112.000000, 2654.000000)">
        <g id="Main-Navigation" transform="translate(3.000000, 225.000000)" sketch:type="MSShapeGroup">
          <g id="Rest" transform="translate(0.000000, 90.000000)">
            <g id="Stores" transform="translate(19.000000, 212.000000)">
              <g id="Stores-Icon" transform="translate(9.000000, 0.000000)">
                <path d="M23.4893333,15.794 L20.032,2.808 C19.836,1.984 18.8633333,0.424 16.5906667,0.424 L7.64133333,0.424 C5.386,0.424 4.404,1.97933333 4.20333333,2.79 L0.742666667,15.7946667 C0.664666667,16.0653333 0.61,16.346 0.61,16.6413333 L0.61,18.6986667 C0.61,20.3966667 1.99066667,21.7766667 3.688,21.7766667 L20.544,21.7766667 C22.242,21.7766667 23.6226667,20.3966667 23.6226667,18.6986667 L23.6226667,16.6413333 C23.6226667,16.3453333 23.5673333,16.0653333 23.4893333,15.794 L23.4893333,15.794 Z M5.63866667,3.15866667 C5.642,3.146 5.968,1.90733333 7.64133333,1.90733333 L16.5906667,1.90733333 C18.2106667,1.90733333 18.5593333,3.034 18.5966667,3.17066667 L21.398,13.6986667 C21.126,13.6193333 20.8426667,13.5633333 20.544,13.5633333 L3.688,13.5633333 C3.39,13.5633333 3.10666667,13.6193333 2.83466667,13.6986667 L5.63866667,3.15866667 L5.63866667,3.15866667 Z M22.026,18.6986667 C22.026,19.516 21.3613333,20.1806667 20.544,20.1806667 L3.688,20.1806667 C2.87066667,20.1806667 2.206,19.516 2.206,18.6986667 L2.206,16.6413333 C2.206,15.824 2.87066667,15.1593333 3.688,15.1593333 L20.544,15.1593333 C21.3613333,15.1593333 22.026,15.824 22.026,16.6413333 L22.026,18.6986667 L22.026,18.6986667 Z" id="Fill-1"></path>
                <path d="M18.1166667,16.2533333 C17.334,16.2533333 16.7,16.8873333 16.7,17.67 C16.7,18.452 17.334,19.086 18.1166667,19.086 C18.8986667,19.086 19.5333333,18.452 19.5333333,17.67 C19.5333333,16.8873333 18.8986667,16.2533333 18.1166667,16.2533333" id="Fill-2"></path>
              </g>
            </g>
          </g>
        </g>
      </g>
    </g>
  </g>
</svg>`;

export const usersIcon: string = `<svg width="17px" height="24px" viewBox="0 0 17 24" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:sketch="http://www.bohemiancoding.com/sketch/ns">
  <!-- Generator: Sketch 3.3.3 (12081) - http://www.bohemiancoding.com/sketch -->
  <title>Users Icon</title>
  <desc>Created with Sketch.</desc>
  <defs></defs>
  <g id="Update-6" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd" sketch:type="MSPage">
    <g id="UI-Kit" sketch:type="MSArtboardGroup" transform="translate(-147.000000, -3337.000000)" fill="#959797">
      <g id="Navigation" sketch:type="MSLayerGroup" transform="translate(112.000000, 2654.000000)">
        <g id="Main-Navigation" transform="translate(3.000000, 225.000000)" sketch:type="MSShapeGroup">
          <g id="Rest" transform="translate(0.000000, 90.000000)">
            <g id="Users" transform="translate(23.000000, 368.000000)">
              <g id="Users-Icon" transform="translate(9.000000, 0.000000)">
                <path d="M8.784,10.0686667 C11.534,10.0686667 13.7626667,7.84066667 13.7626667,5.09066667 C13.7626667,2.34066667 11.534,0.112 8.784,0.112 C6.034,0.112 3.80533333,2.34066667 3.80533333,5.09066667 C3.80533333,7.84066667 6.034,10.0686667 8.784,10.0686667 M8.784,1.66533333 C10.672,1.66533333 12.2093333,3.202 12.2093333,5.09066667 C12.2093333,6.97866667 10.672,8.51533333 8.784,8.51533333 C6.896,8.51533333 5.35866667,6.97866667 5.35866667,5.09066667 C5.35866667,3.202 6.896,1.66533333 8.784,1.66533333" id="Fill-1"></path>
                <path d="M11.666,10.892 C10.82,11.2753333 9.88133333,11.4346667 8.89133333,11.4346667 L8.67466667,11.4346667 C7.686,11.4346667 6.74466667,11.274 5.9,10.892 C2.83866667,12.02 0.659333333,14.908 0.659333333,18.3593333 L0.659333333,21.1106667 C2.738,22.512 5.56133333,23.4693333 8.67466667,23.4693333 L8.89133333,23.4693333 C12.006,23.4693333 14.828,22.512 16.9066667,21.1106667 L16.9066667,18.3593333 C16.9066667,14.908 14.7273333,12.02 11.666,10.892 M15.34,20.24 C13.462,21.3146667 11.204,21.9013333 8.892,21.9013333 L8.67466667,21.9013333 C6.36466667,21.9013333 4.10533333,21.3146667 2.22733333,20.24 L2.22733333,18.3606667 C2.22733333,15.85 3.65933333,13.6373333 5.918,12.5813333 C6.754,12.8613333 7.67866667,13.0033333 8.676,13.0033333 L8.89266667,13.0033333 C9.88866667,13.0033333 10.8133333,12.8613333 11.6493333,12.5813333 C13.91,13.6373333 15.34,15.85 15.34,18.3606667 L15.34,20.24" id="Fill-2"></path>
              </g>
            </g>
          </g>
        </g>
      </g>
    </g>
  </g>
</svg>`;

// TODO: replace with icon from Andrew
export const wrenchIcon: string = `<svg width="24px" height="24px" viewBox="0 0 24 24" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:sketch="http://www.bohemiancoding.com/sketch/ns">
  <!-- Generator: Sketch 3.4.4 (17249) - http://www.bohemiancoding.com/sketch -->
  <title>Wrench Icon</title>
  <desc>Created with Sketch.</desc>
  <defs></defs>
  <g id="Update-7" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd" sketch:type="MSPage">
    <g id="Settings---Account" sketch:type="MSArtboardGroup" transform="translate(-27.000000, -493.000000)" fill="#959797">
      <g id="Left-Column" sketch:type="MSLayerGroup" transform="translate(-1.000000, 93.000000)">
        <g id="Main-Nav" transform="translate(8.000000, 20.213675)" sketch:type="MSShapeGroup">
          <g id="Support" transform="translate(6.000000, 379.226496)">
            <g id="Wrench" transform="translate(14.000000, 0.559829)">
              <path d="M18.9659312,18.8968134 C18.8051665,18.8968134 18.6540476,18.9600475 18.5404405,19.0736546 C18.3057239,19.3083712 18.3057239,19.6909913 18.5404405,19.9257079 C18.7676547,20.1539938 19.1642078,20.1539938 19.391422,19.9257079 C19.6261385,19.6909913 19.6261385,19.3083712 19.391422,19.0736546 C19.2778149,18.9600475 19.126696,18.8968134 18.9659312,18.8968134 M18.9659312,21.4422555 C18.4471969,21.4422555 17.9595438,21.2407637 17.5930001,20.87422 C16.8352622,20.1164821 16.8352622,18.8828804 17.5930001,18.1251425 C18.3260875,17.3931269 19.605775,17.3931269 20.3388623,18.1251425 C20.705406,18.4927579 20.9079696,18.980411 20.9079696,19.4991454 C20.9079696,20.0189514 20.705406,20.5066046 20.3388623,20.87422 C19.9723187,21.2407637 19.4846656,21.4422555 18.9659312,21.4422555 M7.85601415,12.2593721 C9.07889814,12.2593721 10.2492656,12.8016852 11.0648789,13.7491256 L17.0828399,21.6662544 C17.5597754,22.1346158 18.277858,22.4304229 19.0441701,22.4304229 C19.8104821,22.4304229 20.5285648,22.1346158 21.0644473,21.5976614 C22.1780113,20.4830257 22.1769395,18.6695992 21.0633756,17.5560352 L13.254495,11.5648683 C12.1452181,10.6067103 11.5996897,9.2144874 11.7647415,7.81583394 C11.9458698,6.27570748 11.429279,4.75487279 10.347868,3.64666767 C9.41221708,2.6874379 8.16039544,2.14619652 6.81211494,2.11297181 L9.04996048,4.34974558 C9.85378431,5.15464118 9.85378431,6.46112284 9.04996048,7.26601844 L6.73280432,9.5831746 C5.95470285,10.3602043 4.59677646,10.3634196 3.81653146,9.58210283 L1.57118357,7.33568317 C1.59904946,8.64752366 2.12635789,9.89613001 3.06736766,10.836068 C4.18736219,11.9549908 5.7628569,12.4887298 7.33513631,12.2925968 C7.50876226,12.2700897 7.6823882,12.2593721 7.85601415,12.2593721 M19.0441701,23.7701293 C17.9198885,23.7701293 16.8652716,23.3349927 16.0753807,22.5451018 L10.024195,14.5915329 C9.41328885,13.8852397 8.4594179,13.4940455 7.50554696,13.6215855 C5.52063798,13.8734503 3.53358548,13.1960948 2.1199273,11.7835084 C0.728776194,10.3923573 0.0535641769,8.46961065 0.268988963,6.51042404 C0.324720749,5.98740266 0.767359738,5.59084958 1.29573993,5.59084958 C1.5701118,5.59084958 1.82840719,5.69909785 2.02346844,5.89308734 L4.76504358,8.63466248 C5.03834369,8.90903434 5.51313563,8.90796258 5.78536396,8.63573424 L8.10252012,6.31857808 C8.38332258,6.03670386 8.38332258,5.57906016 8.10252012,5.2982577 L5.36737557,2.56311315 C5.08442959,2.2790954 4.99118602,1.86860936 5.12408489,1.49134804 C5.25698377,1.1119432 5.58815919,0.851504276 5.9868558,0.808633671 C7.97926714,0.593208885 9.92559257,1.29521503 11.3070978,2.70994497 C12.6714548,4.1096702 13.323088,6.02812974 13.094802,7.97338341 C12.9822667,8.92939788 13.3584562,9.88434059 14.1011894,10.5263279 L21.9443665,16.5507196 C23.6463295,18.2451802 23.6474012,20.9074447 22.0129594,22.54403 C21.2219968,23.3349927 20.1684517,23.7701293 19.0441701,23.7701293" id="Fill-1"></path>
            </g>
          </g>
        </g>
      </g>
    </g>
  </g>
</svg>`;

// TODO: replace with icon from Andrew
export const logsIcon: string = `<svg width="23px" height="24px" viewBox="0 0 23 24" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:sketch="http://www.bohemiancoding.com/sketch/ns">
  <!-- Generator: Sketch 3.5.2 (25235) - http://www.bohemiancoding.com/sketch -->
  <title>Imported Layers</title>
  <desc>Created with Sketch.</desc>
  <defs></defs>
  <g id="Update-8" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd" sketch:type="MSPage">
    <g id="Cluster-Overview" sketch:type="MSArtboardGroup" transform="translate(-28.000000, -191.000000)" fill="#959797">
      <g id="Cluster-Column" sketch:type="MSLayerGroup" transform="translate(-1.000000, 93.000000)">
        <g id="Main-Nav" transform="translate(0.000000, 0.213675)" sketch:type="MSShapeGroup">
          <g id="Nodes" transform="translate(0.000000, 0.608974)">
            <path d="M29,98 L51.1186667,98 L51.1186667,101.636678 L29,101.636678 L29,98 Z M29,116.804803 L51.1186667,116.804803 L51.1186667,120.441481 L29,120.441481 L29,116.804803 Z M29,107.398871 L51.1186667,107.398871 L51.1186667,111.036431 L29,111.036431 L29,107.398871 Z" id="Imported-Layers"></path>
          </g>
        </g>
      </g>
    </g>
  </g>
</svg>`;

export const leftArrow: string = `<svg width="7px" height="10px" viewBox="0 0 7 10" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
  <!-- Generator: Sketch 41.2 (35397) - http://www.bohemiancoding.com/sketch -->
  <title>Path 2</title>
  <desc>Created with Sketch.</desc>
  <defs></defs>
  <g id="Symbols" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
    <g id="View-button" transform="translate(-18.000000, -15.000000)" stroke-width="2" stroke="#51BBFD">
      <g id="Path-2">
        <polyline points="24 16 20 20 24 24"></polyline>
      </g>
    </g>
  </g>
</svg>`;

export const rightArrow: string = `<svg width="7px" height="10px" viewBox="0 0 7 10" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <!-- Generator: Sketch 41.2 (35397) - http://www.bohemiancoding.com/sketch -->
    <title>Path 2 Copy</title>
    <desc>Created with Sketch.</desc>
    <defs></defs>
    <g id="Symbols" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
      <g id="View-button" transform="translate(-241.000000, -15.000000)" stroke-width="2" stroke="#51BBFD">
        <g id="Path-2-Copy">
          <polyline transform="translate(244.000000, 20.000000) scale(-1, 1) translate(-244.000000, -20.000000) " points="246 16 242 20 246 24"></polyline>
        </g>
      </g>
    </g>
</svg>`;

export let criticalIcon: string = `<svg width="20px" height="20px" viewBox="0 0 20 20" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <!-- Generator: Sketch 42 (36781) - http://www.bohemiancoding.com/sketch -->
    <title>Group 3</title>
    <desc>Created with Sketch.</desc>
    <defs></defs>
    <g id="Symbols" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <g id="Warning---Connection-Lost" transform="translate(-25.000000, -19.000000)">
            <g id="Group-3">
                <g transform="translate(25.000000, 19.000000)">
                    <path d="M8.75139389,1.26729609 C9.24631171,0.277343549 10.0519669,0.283622947 10.5438615,1.26729609 L19.1995435,18.5766161 C19.4476073,19.0726851 19.1933971,19.4748284 18.6568996,19.4748284 L0.640505826,19.4748284 C0.092748094,19.4748284 -0.15156708,19.0753209 0.0977558747,18.5766161 L8.75139389,1.26729609 Z" id="Rectangle-4" fill="#F26969"></path>
                    <g id="Group-2" transform="translate(8.000000, 3.000000)" font-size="14" font-family="Lato-Bold, Lato" fill="#FFFFFF" font-weight="bold">
                        <text id="!">
                            <tspan x="0" y="14">!</tspan>
                        </text>
                    </g>
                </g>
            </g>
        </g>
    </g>
</svg>`;

export let warningIcon: string = `<svg width="21px" height="21px" viewBox="0 0 21 21" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink">
    <!-- Generator: Sketch 41.2 (35397) - http://www.bohemiancoding.com/sketch -->
    <title>Group 2</title>
    <desc>Created with Sketch.</desc>
    <defs></defs>
    <g id="Symbols" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
        <g id="Alert" transform="translate(-18.000000, -20.000000)">
            <g id="Group-4">
                <g id="Group-2" transform="translate(18.000000, 20.000000)">
                    <circle id="Oval-5" fill="#F2BE2C" cx="10.5" cy="10.5" r="10.5"></circle>
                    <text id="!" font-family="Lato-Bold, Lato" font-size="14" font-weight="bold" fill="#FFFFFF">
                        <tspan x="8" y="16">!</tspan>
                    </text>
                </g>
            </g>
        </g>
    </g>
</svg>`;

export let notificationIcon: string = `
  <svg width="22px" height="22px" viewBox="0 0 38 38" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" xmlns:sketch="http://www.bohemiancoding.com/sketch/ns">
    <!-- Generator: Sketch 3.3.3 (12081) - http://www.bohemiancoding.com/sketch -->
    <title>CL Mark</title>
    <desc>Created with Sketch.</desc>
    <g id="Update-6" stroke="none" stroke-width="1" fill="none" fill-rule="evenodd" sketch:type="MSPage" >
        <g id="Line-Chart-(v4)" sketch:type="MSArtboardGroup" transform="translate(-20.000000, -29.000000)">
            <g id="Header" sketch:type="MSLayerGroup" transform="translate(-15.000000, -47.000000)">
                <g id="CL-Mark" transform="translate(35.000000, 76.000000)">
                    <g id="Group-3">
                        <g id="Clip-2"></g>
                        <path d="M23.0622,10.88928 C21.72574,11.2024 20.3281,11.36466 18.89664,11.36466 C17.46518,11.36466 16.06754,11.2024 14.72538,10.88928 C15.84372,9.11696 17.25846,7.53996 18.89664,6.24302 C20.5352,7.54566 21.94386,9.11696 23.0622,10.88928 L23.0622,10.88928 Z M35.66034,0.68134 C33.97998,0.23294 32.2088,0 30.3867,0 C26.14058,0 22.18972,1.27718 18.89132,3.47396 C15.599,1.27718 11.64814,0 7.39632,0 C5.57384,0 3.80266,0.23294 2.1223,0.68134 C1.41322,0.86108 0.72504,1.08832 0.05244,1.34292 C0.00874,1.35926 -0.01216,1.41094 0.00722,1.4535 C0.30134,2.0919 0.62928,2.71054 0.98192,3.30942 C1.0013,3.34248 1.04158,3.35692 1.07768,3.344 C1.77878,3.09244 2.49622,2.87888 3.22962,2.70788 C4.56912,2.39552 5.96562,2.23668 7.39632,2.23668 C10.90448,2.23668 14.1854,3.2186 16.9898,4.91036 C15.21292,6.41478 13.69178,8.21408 12.50504,10.2296 C12.27248,10.6153 12.06234,11.00708 11.8579,11.40456 C11.72186,11.67132 11.59114,11.94378 11.4608,12.22764 C11.27346,12.65324 11.09182,13.07922 10.9326,13.51622 C10.09242,15.77 9.63262,18.21074 9.63262,20.74838 C9.63262,26.62356 12.09084,31.9371 16.0303,35.71772 C16.33696,36.01868 16.65502,36.30254 16.9898,36.5807 C17.25086,36.80756 17.51192,37.0177 17.78438,37.22214 C18.12752,37.4946 18.48662,37.74578 18.8461,37.98632 C18.87346,38.00494 18.90956,38.00456 18.93692,37.98594 C19.29602,37.74008 19.64942,37.4889 19.99256,37.22214 C20.27072,37.0177 20.53216,36.80756 20.79322,36.5807 C21.1223,36.30254 21.45176,36.01298 21.75804,35.71772 C25.69218,31.9371 28.15002,26.61786 28.15002,20.74838 C28.15002,18.21074 27.69022,15.7757 26.85004,13.52192 C26.6855,13.08492 26.50956,12.65324 26.31652,12.22764 C26.19188,11.94378 26.06116,11.67132 25.93044,11.40456 C25.72068,11.00708 25.51054,10.6153 25.2776,10.2296 C24.08554,8.21408 22.5701,6.41478 20.79322,4.91036 C23.59762,3.2186 26.87854,2.23668 30.3867,2.23668 C31.8174,2.23668 33.2139,2.39552 34.5534,2.70788 C35.28642,2.87888 36.00918,3.09244 36.70534,3.34362 C36.74144,3.35692 36.78172,3.34248 36.8011,3.30942 C37.15336,2.71054 37.47636,2.0919 37.77466,1.45388 C37.7948,1.41094 37.7739,1.35926 37.72944,1.34254 C37.05228,1.08832 36.3641,0.86108 35.66034,0.68134 L35.66034,0.68134 Z" id="Fill-1" fill="#152849" sketch:type="MSShapeGroup"></path>
                    </g>
                    <path d="M25.91372,20.7499 C25.91372,25.65912 23.99396,30.12526 20.86086,33.4419 C20.31024,31.68174 20.0108,29.81404 20.0108,27.88212 C20.0108,22.97328 21.93056,18.49916 25.06366,15.1905 C25.61428,16.94648 25.91372,18.81418 25.91372,20.7499" id="Fill-6" fill="#348540" sketch:type="MSShapeGroup"></path>
                    <path d="M17.77184,27.88212 C17.77184,29.81404 17.4762,31.68174 16.9214,33.4419 C13.7883,30.12526 11.86854,25.65912 11.86854,20.7499 C11.86854,18.81418 12.17216,16.94648 12.72696,15.1905 C15.86006,18.49916 17.77184,22.97328 17.77184,27.88212" id="Fill-7" fill="#7DBC42" sketch:type="MSShapeGroup"></path>
                </g>
            </g>
        </g>
    </g>
  </svg>`;
