// Code generated by protoc-gen-gogo.
// source: cockroach/pkg/ccl/sqlccl/backup.proto
// DO NOT EDIT!

/*
	Package sqlccl is a generated protocol buffer package.

	It is generated from these files:
		cockroach/pkg/ccl/sqlccl/backup.proto

	It has these top-level messages:
		BackupDescriptor
*/
package sqlccl

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import cockroach_build "github.com/cockroachdb/cockroach/pkg/build"
import cockroach_roachpb3 "github.com/cockroachdb/cockroach/pkg/roachpb"
import cockroach_roachpb1 "github.com/cockroachdb/cockroach/pkg/roachpb"
import cockroach_sql_sqlbase1 "github.com/cockroachdb/cockroach/pkg/sql/sqlbase"
import cockroach_util_hlc "github.com/cockroachdb/cockroach/pkg/util/hlc"

import github_com_cockroachdb_cockroach_pkg_util_uuid "github.com/cockroachdb/cockroach/pkg/util/uuid"
import github_com_cockroachdb_cockroach_pkg_roachpb "github.com/cockroachdb/cockroach/pkg/roachpb"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// BackupDescriptor represents a consistent snapshot of ranges.
//
// Each range snapshot includes a path to data that is a diff of the data in
// that key range between a start and end timestamp. The end timestamp of all
// ranges in a backup is the same, but the start may vary (to allow individual
// tables to be backed up on different schedules).
type BackupDescriptor struct {
	StartTime cockroach_util_hlc.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime" json:"start_time"`
	EndTime   cockroach_util_hlc.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime" json:"end_time"`
	// Spans contains the spans requested for backup. The keyranges covered by
	// `files` may be a subset of this if there were ranges with no changes since
	// the last backup.
	Spans         []cockroach_roachpb1.Span                           `protobuf:"bytes,3,rep,name=spans" json:"spans"`
	Files         []BackupDescriptor_File                             `protobuf:"bytes,4,rep,name=files" json:"files"`
	Descriptors   []cockroach_sql_sqlbase1.Descriptor                 `protobuf:"bytes,5,rep,name=descriptors" json:"descriptors"`
	DataSize      int64                                               `protobuf:"varint,6,opt,name=data_size,json=dataSize,proto3" json:"data_size,omitempty"`
	Dir           cockroach_roachpb3.ExportStorage                    `protobuf:"bytes,7,opt,name=dir" json:"dir"`
	FormatVersion uint32                                              `protobuf:"varint,8,opt,name=format_version,json=formatVersion,proto3" json:"format_version,omitempty"`
	ClusterID     github_com_cockroachdb_cockroach_pkg_util_uuid.UUID `protobuf:"bytes,9,opt,name=cluster_id,json=clusterId,proto3,customtype=github.com/cockroachdb/cockroach/pkg/util/uuid.UUID" json:"cluster_id"`
	// node_id and build_info of the gateway node (which writes the descriptor).
	NodeID    github_com_cockroachdb_cockroach_pkg_roachpb.NodeID `protobuf:"varint,10,opt,name=node_id,json=nodeId,proto3,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.NodeID" json:"node_id,omitempty"`
	BuildInfo cockroach_build.Info                                `protobuf:"bytes,11,opt,name=build_info,json=buildInfo" json:"build_info"`
}

func (m *BackupDescriptor) Reset()                    { *m = BackupDescriptor{} }
func (m *BackupDescriptor) String() string            { return proto.CompactTextString(m) }
func (*BackupDescriptor) ProtoMessage()               {}
func (*BackupDescriptor) Descriptor() ([]byte, []int) { return fileDescriptorBackup, []int{0} }

// BackupDescriptor_File represents a file that contains the diff for a key
// range between two timestamps.
type BackupDescriptor_File struct {
	Span   cockroach_roachpb1.Span `protobuf:"bytes,1,opt,name=span" json:"span"`
	Path   string                  `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
	Sha512 []byte                  `protobuf:"bytes,4,opt,name=sha512,proto3" json:"sha512,omitempty"`
}

func (m *BackupDescriptor_File) Reset()                    { *m = BackupDescriptor_File{} }
func (m *BackupDescriptor_File) String() string            { return proto.CompactTextString(m) }
func (*BackupDescriptor_File) ProtoMessage()               {}
func (*BackupDescriptor_File) Descriptor() ([]byte, []int) { return fileDescriptorBackup, []int{0, 0} }

func init() {
	proto.RegisterType((*BackupDescriptor)(nil), "cockroach.ccl.sqlccl.BackupDescriptor")
	proto.RegisterType((*BackupDescriptor_File)(nil), "cockroach.ccl.sqlccl.BackupDescriptor.File")
}
func (m *BackupDescriptor) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BackupDescriptor) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintBackup(dAtA, i, uint64(m.StartTime.Size()))
	n1, err := m.StartTime.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n1
	dAtA[i] = 0x12
	i++
	i = encodeVarintBackup(dAtA, i, uint64(m.EndTime.Size()))
	n2, err := m.EndTime.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n2
	if len(m.Spans) > 0 {
		for _, msg := range m.Spans {
			dAtA[i] = 0x1a
			i++
			i = encodeVarintBackup(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Files) > 0 {
		for _, msg := range m.Files {
			dAtA[i] = 0x22
			i++
			i = encodeVarintBackup(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Descriptors) > 0 {
		for _, msg := range m.Descriptors {
			dAtA[i] = 0x2a
			i++
			i = encodeVarintBackup(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.DataSize != 0 {
		dAtA[i] = 0x30
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.DataSize))
	}
	dAtA[i] = 0x3a
	i++
	i = encodeVarintBackup(dAtA, i, uint64(m.Dir.Size()))
	n3, err := m.Dir.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n3
	if m.FormatVersion != 0 {
		dAtA[i] = 0x40
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.FormatVersion))
	}
	dAtA[i] = 0x4a
	i++
	i = encodeVarintBackup(dAtA, i, uint64(m.ClusterID.Size()))
	n4, err := m.ClusterID.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n4
	if m.NodeID != 0 {
		dAtA[i] = 0x50
		i++
		i = encodeVarintBackup(dAtA, i, uint64(m.NodeID))
	}
	dAtA[i] = 0x5a
	i++
	i = encodeVarintBackup(dAtA, i, uint64(m.BuildInfo.Size()))
	n5, err := m.BuildInfo.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n5
	return i, nil
}

func (m *BackupDescriptor_File) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *BackupDescriptor_File) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintBackup(dAtA, i, uint64(m.Span.Size()))
	n6, err := m.Span.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n6
	if len(m.Path) > 0 {
		dAtA[i] = 0x12
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.Path)))
		i += copy(dAtA[i:], m.Path)
	}
	if len(m.Sha512) > 0 {
		dAtA[i] = 0x22
		i++
		i = encodeVarintBackup(dAtA, i, uint64(len(m.Sha512)))
		i += copy(dAtA[i:], m.Sha512)
	}
	return i, nil
}

func encodeFixed64Backup(dAtA []byte, offset int, v uint64) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	dAtA[offset+4] = uint8(v >> 32)
	dAtA[offset+5] = uint8(v >> 40)
	dAtA[offset+6] = uint8(v >> 48)
	dAtA[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32Backup(dAtA []byte, offset int, v uint32) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintBackup(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *BackupDescriptor) Size() (n int) {
	var l int
	_ = l
	l = m.StartTime.Size()
	n += 1 + l + sovBackup(uint64(l))
	l = m.EndTime.Size()
	n += 1 + l + sovBackup(uint64(l))
	if len(m.Spans) > 0 {
		for _, e := range m.Spans {
			l = e.Size()
			n += 1 + l + sovBackup(uint64(l))
		}
	}
	if len(m.Files) > 0 {
		for _, e := range m.Files {
			l = e.Size()
			n += 1 + l + sovBackup(uint64(l))
		}
	}
	if len(m.Descriptors) > 0 {
		for _, e := range m.Descriptors {
			l = e.Size()
			n += 1 + l + sovBackup(uint64(l))
		}
	}
	if m.DataSize != 0 {
		n += 1 + sovBackup(uint64(m.DataSize))
	}
	l = m.Dir.Size()
	n += 1 + l + sovBackup(uint64(l))
	if m.FormatVersion != 0 {
		n += 1 + sovBackup(uint64(m.FormatVersion))
	}
	l = m.ClusterID.Size()
	n += 1 + l + sovBackup(uint64(l))
	if m.NodeID != 0 {
		n += 1 + sovBackup(uint64(m.NodeID))
	}
	l = m.BuildInfo.Size()
	n += 1 + l + sovBackup(uint64(l))
	return n
}

func (m *BackupDescriptor_File) Size() (n int) {
	var l int
	_ = l
	l = m.Span.Size()
	n += 1 + l + sovBackup(uint64(l))
	l = len(m.Path)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	l = len(m.Sha512)
	if l > 0 {
		n += 1 + l + sovBackup(uint64(l))
	}
	return n
}

func sovBackup(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozBackup(x uint64) (n int) {
	return sovBackup(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *BackupDescriptor) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBackup
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: BackupDescriptor: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: BackupDescriptor: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StartTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.StartTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field EndTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.EndTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Spans", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Spans = append(m.Spans, cockroach_roachpb1.Span{})
			if err := m.Spans[len(m.Spans)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Files", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Files = append(m.Files, BackupDescriptor_File{})
			if err := m.Files[len(m.Files)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Descriptors", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Descriptors = append(m.Descriptors, cockroach_sql_sqlbase1.Descriptor{})
			if err := m.Descriptors[len(m.Descriptors)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DataSize", wireType)
			}
			m.DataSize = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DataSize |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Dir", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Dir.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FormatVersion", wireType)
			}
			m.FormatVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FormatVersion |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ClusterID", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ClusterID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			m.NodeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeID |= (github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field BuildInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.BuildInfo.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBackup(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBackup
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *BackupDescriptor_File) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowBackup
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: File: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: File: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Span", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Span.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Path = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sha512", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthBackup
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Sha512 = append(m.Sha512[:0], dAtA[iNdEx:postIndex]...)
			if m.Sha512 == nil {
				m.Sha512 = []byte{}
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipBackup(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthBackup
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipBackup(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowBackup
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowBackup
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthBackup
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowBackup
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipBackup(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthBackup = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowBackup   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("cockroach/pkg/ccl/sqlccl/backup.proto", fileDescriptorBackup) }

var fileDescriptorBackup = []byte{
	// 617 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x53, 0x4f, 0x6f, 0xd3, 0x3e,
	0x18, 0x5e, 0x7e, 0x4d, 0xbb, 0xd6, 0xfd, 0x0d, 0x4d, 0xd6, 0x80, 0xa8, 0x88, 0x34, 0x20, 0x0d,
	0x55, 0x20, 0x39, 0xda, 0x26, 0x24, 0xc4, 0x01, 0x89, 0x52, 0xfe, 0x84, 0x03, 0x87, 0x8c, 0x71,
	0xd8, 0xa5, 0x72, 0x6c, 0xb7, 0xb5, 0x9a, 0xc6, 0x99, 0xed, 0x20, 0xb4, 0x4f, 0xc1, 0xc7, 0x9a,
	0xc4, 0x85, 0x23, 0xe2, 0x50, 0x41, 0xf9, 0x16, 0x9c, 0x90, 0x9d, 0x74, 0x6b, 0x51, 0x25, 0x76,
	0xca, 0x9b, 0xd7, 0xcf, 0xf3, 0xbc, 0x7e, 0xdf, 0xf7, 0x31, 0xd8, 0x27, 0x82, 0x4c, 0xa5, 0xc0,
	0x64, 0x12, 0xe6, 0xd3, 0x71, 0x48, 0x48, 0x1a, 0xaa, 0xb3, 0xd4, 0x7c, 0x12, 0x4c, 0xa6, 0x45,
	0x8e, 0x72, 0x29, 0xb4, 0x80, 0x7b, 0x97, 0x30, 0x44, 0x48, 0x8a, 0x4a, 0x48, 0xc7, 0x5f, 0x27,
	0x27, 0x05, 0x4f, 0x69, 0xc8, 0xb3, 0x91, 0x28, 0x59, 0x9d, 0xee, 0xfa, 0xb9, 0x8d, 0xf2, 0x24,
	0xc4, 0x39, 0xaf, 0x00, 0xc1, 0x66, 0x00, 0xc5, 0x1a, 0x57, 0x88, 0x87, 0xeb, 0x08, 0x75, 0x66,
	0xef, 0x97, 0x60, 0xc5, 0x42, 0xa5, 0x65, 0x41, 0x74, 0x21, 0x19, 0xad, 0xb0, 0x0f, 0xd6, 0xb1,
	0x85, 0xe6, 0x69, 0x38, 0x49, 0x49, 0xa8, 0xf9, 0x8c, 0x29, 0x8d, 0x67, 0x55, 0x33, 0x9d, 0xbd,
	0xb1, 0x18, 0x0b, 0x1b, 0x86, 0x26, 0x2a, 0xb3, 0xf7, 0xbf, 0x34, 0xc0, 0x6e, 0xdf, 0xf6, 0x3c,
	0x60, 0x8a, 0x48, 0x9e, 0x6b, 0x21, 0x61, 0x1f, 0x00, 0xa5, 0xb1, 0xd4, 0x43, 0xa3, 0xe1, 0x39,
	0x81, 0xd3, 0x6b, 0x1f, 0xde, 0x45, 0x57, 0xc3, 0x30, 0x35, 0xd0, 0x24, 0x25, 0xe8, 0xfd, 0xb2,
	0x46, 0xdf, 0xbd, 0x98, 0x77, 0xb7, 0xe2, 0x96, 0xa5, 0x99, 0x2c, 0x7c, 0x06, 0x9a, 0x2c, 0xa3,
	0xa5, 0xc2, 0x7f, 0xd7, 0x57, 0xd8, 0x66, 0x19, 0xb5, 0xfc, 0x23, 0x50, 0x57, 0x39, 0xce, 0x94,
	0x57, 0x0b, 0x6a, 0xbd, 0xf6, 0xe1, 0xed, 0x15, 0x72, 0x35, 0x30, 0x74, 0x9c, 0xe3, 0xac, 0xa2,
	0x95, 0x58, 0xf8, 0x1a, 0xd4, 0x47, 0x3c, 0x65, 0xca, 0x73, 0x2d, 0xe9, 0x11, 0xda, 0xb4, 0x40,
	0xf4, 0x77, 0xbf, 0xe8, 0x15, 0x4f, 0xd9, 0x52, 0xc8, 0xf2, 0x61, 0x04, 0xda, 0xf4, 0xf2, 0x5c,
	0x79, 0x75, 0x2b, 0x77, 0x6f, 0x45, 0x4e, 0x9d, 0x59, 0x39, 0xb3, 0x12, 0x74, 0xa5, 0x54, 0x89,
	0xac, 0x72, 0xe1, 0x1d, 0xd0, 0x32, 0x9b, 0x1d, 0x2a, 0x7e, 0xce, 0xbc, 0x46, 0xe0, 0xf4, 0x6a,
	0x71, 0xd3, 0x24, 0x8e, 0xf9, 0x39, 0x83, 0x4f, 0x40, 0x8d, 0x72, 0xe9, 0x6d, 0xdb, 0x01, 0x05,
	0x1b, 0x7a, 0x7c, 0xf9, 0x29, 0x17, 0x52, 0x1f, 0x6b, 0x21, 0xf1, 0x78, 0x79, 0x47, 0x43, 0x81,
	0xfb, 0xe0, 0xc6, 0x48, 0xc8, 0x19, 0xd6, 0xc3, 0x8f, 0x4c, 0x2a, 0x2e, 0x32, 0xaf, 0x19, 0x38,
	0xbd, 0x9d, 0x78, 0xa7, 0xcc, 0x7e, 0x28, 0x93, 0x70, 0x0c, 0x00, 0x49, 0x0b, 0xa5, 0x99, 0x1c,
	0x72, 0xea, 0xb5, 0x02, 0xa7, 0xf7, 0x7f, 0xff, 0x8d, 0x51, 0xf9, 0x3e, 0xef, 0x1e, 0x8d, 0xb9,
	0x9e, 0x14, 0x09, 0x22, 0x62, 0x16, 0x5e, 0x56, 0xa6, 0x49, 0xb8, 0xc1, 0x50, 0x45, 0xc1, 0x29,
	0x3a, 0x39, 0x89, 0x06, 0x8b, 0x79, 0xb7, 0xf5, 0xa2, 0x14, 0x8c, 0x06, 0x71, 0xab, 0xd2, 0x8e,
	0x28, 0x3c, 0x05, 0xdb, 0x99, 0xa0, 0xcc, 0x54, 0x01, 0x81, 0xd3, 0xab, 0xf7, 0x9f, 0x2f, 0xe6,
	0xdd, 0xc6, 0x3b, 0x41, 0x59, 0x34, 0xf8, 0x7d, 0xdd, 0x5a, 0xcb, 0xae, 0x4b, 0x5a, 0xdc, 0x30,
	0x8a, 0x11, 0x85, 0x4f, 0x01, 0xb0, 0xaf, 0x6c, 0x68, 0x5e, 0x99, 0xd7, 0xb6, 0xc3, 0xba, 0xb9,
	0x32, 0x2c, 0x7b, 0x88, 0xa2, 0x6c, 0x24, 0x96, 0x3e, 0xb4, 0x19, 0x93, 0xe8, 0x4c, 0x81, 0x6b,
	0xd6, 0x0b, 0x0f, 0x80, 0x6b, 0x3c, 0x52, 0xb9, 0xf9, 0x1f, 0x76, 0xb2, 0x50, 0x08, 0x81, 0x9b,
	0x63, 0x3d, 0xb1, 0xf6, 0x6d, 0xc5, 0x36, 0x86, 0xb7, 0x40, 0x43, 0x4d, 0xf0, 0xe3, 0x83, 0x43,
	0xcf, 0x35, 0xb3, 0x8c, 0xab, 0xbf, 0xb7, 0x6e, 0xb3, 0xb6, 0xeb, 0xf6, 0x83, 0x8b, 0x9f, 0xfe,
	0xd6, 0xc5, 0xc2, 0x77, 0xbe, 0x2e, 0x7c, 0xe7, 0xdb, 0xc2, 0x77, 0x7e, 0x2c, 0x7c, 0xe7, 0xf3,
	0x2f, 0x7f, 0xeb, 0xb4, 0x51, 0x7a, 0x2f, 0x69, 0xd8, 0x67, 0x77, 0xf4, 0x27, 0x00, 0x00, 0xff,
	0xff, 0x54, 0xf7, 0x0d, 0x22, 0x82, 0x04, 0x00, 0x00,
}
