// Code generated by protoc-gen-gogo.
// source: cockroach/pkg/roachpb/app_stats.proto
// DO NOT EDIT!

package roachpb

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

type StatementStatistics struct {
	// Count is the total number of times this statement was executed
	// since the begin of the reporting period.
	Count int64 `protobuf:"varint,1,opt,name=count" json:"count"`
	// FirstAttemptCount collects the total number of times a first
	// attempt was executed (either the one time in explicitly committed
	// statements, or the first time in implicitly committed statements
	// with implicit retries).
	// The proportion of statements that could be executed without retry
	// can be computed as FirstAttemptCount / Count.
	// The cumulative number of retries can be computed with
	// Count - FirstAttemptCount.
	FirstAttemptCount int64 `protobuf:"varint,2,opt,name=first_attempt_count,json=firstAttemptCount" json:"first_attempt_count"`
	// MaxRetries collects the maximum observed number of automatic
	// retries in the reporting period.
	MaxRetries int64 `protobuf:"varint,3,opt,name=max_retries,json=maxRetries" json:"max_retries"`
	// LastErr collects the last error encountered.
	LastErr string `protobuf:"bytes,4,opt,name=last_err,json=lastErr" json:"last_err"`
	// NumRows collects the number of rows returned or observed.
	NumRows NumericStat `protobuf:"bytes,5,opt,name=num_rows,json=numRows" json:"num_rows"`
	// ParseLat is the time to transform the SQL string into an AST.
	ParseLat NumericStat `protobuf:"bytes,6,opt,name=parse_lat,json=parseLat" json:"parse_lat"`
	// PlanLat is the time to transform the AST into a logical query plan.
	PlanLat NumericStat `protobuf:"bytes,7,opt,name=plan_lat,json=planLat" json:"plan_lat"`
	// RunLat is the time to run the query and fetch/compute the result rows.
	RunLat NumericStat `protobuf:"bytes,8,opt,name=run_lat,json=runLat" json:"run_lat"`
	// ServiceLat is the time to service the query, from start of parse to end of execute.
	ServiceLat NumericStat `protobuf:"bytes,9,opt,name=service_lat,json=serviceLat" json:"service_lat"`
	// OverheadLat is the difference between ServiceLat and the sum of parse+plan+run latencies.
	// We store it separately (as opposed to computing it post-hoc) because the combined
	// variance for the overhead cannot be derived from the variance of the separate latencies.
	OverheadLat NumericStat `protobuf:"bytes,10,opt,name=overhead_lat,json=overheadLat" json:"overhead_lat"`
}

func (m *StatementStatistics) Reset()                    { *m = StatementStatistics{} }
func (m *StatementStatistics) String() string            { return proto.CompactTextString(m) }
func (*StatementStatistics) ProtoMessage()               {}
func (*StatementStatistics) Descriptor() ([]byte, []int) { return fileDescriptorAppStats, []int{0} }

type NumericStat struct {
	Mean         float64 `protobuf:"fixed64,1,opt,name=mean" json:"mean"`
	SquaredDiffs float64 `protobuf:"fixed64,2,opt,name=squared_diffs,json=squaredDiffs" json:"squared_diffs"`
}

func (m *NumericStat) Reset()                    { *m = NumericStat{} }
func (m *NumericStat) String() string            { return proto.CompactTextString(m) }
func (*NumericStat) ProtoMessage()               {}
func (*NumericStat) Descriptor() ([]byte, []int) { return fileDescriptorAppStats, []int{1} }

func init() {
	proto.RegisterType((*StatementStatistics)(nil), "cockroach.sql.StatementStatistics")
	proto.RegisterType((*NumericStat)(nil), "cockroach.sql.NumericStat")
}
func (m *StatementStatistics) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StatementStatistics) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintAppStats(dAtA, i, uint64(m.Count))
	dAtA[i] = 0x10
	i++
	i = encodeVarintAppStats(dAtA, i, uint64(m.FirstAttemptCount))
	dAtA[i] = 0x18
	i++
	i = encodeVarintAppStats(dAtA, i, uint64(m.MaxRetries))
	dAtA[i] = 0x22
	i++
	i = encodeVarintAppStats(dAtA, i, uint64(len(m.LastErr)))
	i += copy(dAtA[i:], m.LastErr)
	dAtA[i] = 0x2a
	i++
	i = encodeVarintAppStats(dAtA, i, uint64(m.NumRows.Size()))
	n1, err := m.NumRows.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n1
	dAtA[i] = 0x32
	i++
	i = encodeVarintAppStats(dAtA, i, uint64(m.ParseLat.Size()))
	n2, err := m.ParseLat.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n2
	dAtA[i] = 0x3a
	i++
	i = encodeVarintAppStats(dAtA, i, uint64(m.PlanLat.Size()))
	n3, err := m.PlanLat.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n3
	dAtA[i] = 0x42
	i++
	i = encodeVarintAppStats(dAtA, i, uint64(m.RunLat.Size()))
	n4, err := m.RunLat.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n4
	dAtA[i] = 0x4a
	i++
	i = encodeVarintAppStats(dAtA, i, uint64(m.ServiceLat.Size()))
	n5, err := m.ServiceLat.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n5
	dAtA[i] = 0x52
	i++
	i = encodeVarintAppStats(dAtA, i, uint64(m.OverheadLat.Size()))
	n6, err := m.OverheadLat.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n6
	return i, nil
}

func (m *NumericStat) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NumericStat) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x9
	i++
	i = encodeFixed64AppStats(dAtA, i, uint64(math.Float64bits(float64(m.Mean))))
	dAtA[i] = 0x11
	i++
	i = encodeFixed64AppStats(dAtA, i, uint64(math.Float64bits(float64(m.SquaredDiffs))))
	return i, nil
}

func encodeFixed64AppStats(dAtA []byte, offset int, v uint64) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	dAtA[offset+4] = uint8(v >> 32)
	dAtA[offset+5] = uint8(v >> 40)
	dAtA[offset+6] = uint8(v >> 48)
	dAtA[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32AppStats(dAtA []byte, offset int, v uint32) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintAppStats(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *StatementStatistics) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovAppStats(uint64(m.Count))
	n += 1 + sovAppStats(uint64(m.FirstAttemptCount))
	n += 1 + sovAppStats(uint64(m.MaxRetries))
	l = len(m.LastErr)
	n += 1 + l + sovAppStats(uint64(l))
	l = m.NumRows.Size()
	n += 1 + l + sovAppStats(uint64(l))
	l = m.ParseLat.Size()
	n += 1 + l + sovAppStats(uint64(l))
	l = m.PlanLat.Size()
	n += 1 + l + sovAppStats(uint64(l))
	l = m.RunLat.Size()
	n += 1 + l + sovAppStats(uint64(l))
	l = m.ServiceLat.Size()
	n += 1 + l + sovAppStats(uint64(l))
	l = m.OverheadLat.Size()
	n += 1 + l + sovAppStats(uint64(l))
	return n
}

func (m *NumericStat) Size() (n int) {
	var l int
	_ = l
	n += 9
	n += 9
	return n
}

func sovAppStats(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozAppStats(x uint64) (n int) {
	return sovAppStats(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *StatementStatistics) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAppStats
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StatementStatistics: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StatementStatistics: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Count", wireType)
			}
			m.Count = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAppStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Count |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FirstAttemptCount", wireType)
			}
			m.FirstAttemptCount = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAppStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FirstAttemptCount |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MaxRetries", wireType)
			}
			m.MaxRetries = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAppStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MaxRetries |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastErr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAppStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthAppStats
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.LastErr = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NumRows", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAppStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAppStats
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.NumRows.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ParseLat", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAppStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAppStats
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ParseLat.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PlanLat", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAppStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAppStats
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.PlanLat.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RunLat", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAppStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAppStats
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.RunLat.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ServiceLat", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAppStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAppStats
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ServiceLat.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OverheadLat", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowAppStats
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthAppStats
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.OverheadLat.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipAppStats(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAppStats
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NumericStat) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowAppStats
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NumericStat: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NumericStat: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mean", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			v = uint64(dAtA[iNdEx-8])
			v |= uint64(dAtA[iNdEx-7]) << 8
			v |= uint64(dAtA[iNdEx-6]) << 16
			v |= uint64(dAtA[iNdEx-5]) << 24
			v |= uint64(dAtA[iNdEx-4]) << 32
			v |= uint64(dAtA[iNdEx-3]) << 40
			v |= uint64(dAtA[iNdEx-2]) << 48
			v |= uint64(dAtA[iNdEx-1]) << 56
			m.Mean = float64(math.Float64frombits(v))
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field SquaredDiffs", wireType)
			}
			var v uint64
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			v = uint64(dAtA[iNdEx-8])
			v |= uint64(dAtA[iNdEx-7]) << 8
			v |= uint64(dAtA[iNdEx-6]) << 16
			v |= uint64(dAtA[iNdEx-5]) << 24
			v |= uint64(dAtA[iNdEx-4]) << 32
			v |= uint64(dAtA[iNdEx-3]) << 40
			v |= uint64(dAtA[iNdEx-2]) << 48
			v |= uint64(dAtA[iNdEx-1]) << 56
			m.SquaredDiffs = float64(math.Float64frombits(v))
		default:
			iNdEx = preIndex
			skippy, err := skipAppStats(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthAppStats
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipAppStats(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowAppStats
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAppStats
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowAppStats
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthAppStats
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowAppStats
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipAppStats(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthAppStats = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowAppStats   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("cockroach/pkg/roachpb/app_stats.proto", fileDescriptorAppStats) }

var fileDescriptorAppStats = []byte{
	// 402 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x92, 0xb1, 0x6e, 0x13, 0x41,
	0x10, 0x86, 0xbd, 0xc4, 0x89, 0xed, 0xb9, 0xa4, 0x60, 0x43, 0x71, 0x72, 0x71, 0x31, 0x91, 0x22,
	0x99, 0xc6, 0x96, 0x10, 0x0d, 0x42, 0x14, 0x49, 0xa0, 0x8b, 0x28, 0x4c, 0x47, 0xb3, 0x1a, 0xce,
	0x6b, 0xe7, 0x14, 0xef, 0xed, 0x66, 0x76, 0x2e, 0xf1, 0x63, 0xf0, 0x1e, 0xbc, 0x88, 0x4b, 0x4a,
	0x2a, 0x04, 0xe6, 0x45, 0xd0, 0xee, 0x9d, 0x91, 0xd3, 0x5d, 0x37, 0x9a, 0xff, 0xfb, 0x66, 0x77,
	0xa4, 0x81, 0x8b, 0xdc, 0xe6, 0x77, 0x64, 0x31, 0xbf, 0x9d, 0xba, 0xbb, 0xe5, 0x34, 0x56, 0xee,
	0xeb, 0x14, 0x9d, 0x53, 0x9e, 0x91, 0xfd, 0xc4, 0x91, 0x65, 0x2b, 0x4f, 0xfe, 0x63, 0x13, 0x7f,
	0xbf, 0x1a, 0xbe, 0x58, 0xda, 0xa5, 0x8d, 0xc9, 0x34, 0x54, 0x35, 0x74, 0xfe, 0xbd, 0x0b, 0xa7,
	0x9f, 0x19, 0x59, 0x1b, 0x5d, 0x72, 0x28, 0x0a, 0xcf, 0x45, 0xee, 0xe5, 0x10, 0x0e, 0x73, 0x5b,
	0x95, 0x9c, 0x8a, 0x91, 0x18, 0x1f, 0x5c, 0x75, 0x37, 0xbf, 0xce, 0x3a, 0xb3, 0xba, 0x25, 0xdf,
	0xc0, 0xe9, 0xa2, 0x20, 0xcf, 0x0a, 0x99, 0xb5, 0x71, 0xac, 0x6a, 0xf2, 0xd9, 0x1e, 0xf9, 0x3c,
	0x02, 0x97, 0x75, 0x7e, 0x1d, 0xad, 0x0b, 0x48, 0x0c, 0xae, 0x15, 0x69, 0xa6, 0x42, 0xfb, 0xf4,
	0x60, 0x8f, 0x06, 0x83, 0xeb, 0x59, 0xdd, 0x97, 0x67, 0xd0, 0x5f, 0xa1, 0x67, 0xa5, 0x89, 0xd2,
	0xee, 0x48, 0x8c, 0x07, 0x0d, 0xd3, 0x0b, 0xdd, 0x8f, 0x44, 0xf2, 0x1d, 0xf4, 0xcb, 0xca, 0x28,
	0xb2, 0x8f, 0x3e, 0x3d, 0x1c, 0x89, 0x71, 0xf2, 0x7a, 0x38, 0x79, 0xb2, 0xe9, 0xe4, 0x53, 0x65,
	0x34, 0x15, 0x79, 0xd8, 0x66, 0x27, 0x97, 0x95, 0x99, 0xd9, 0x47, 0x2f, 0xdf, 0xc3, 0xc0, 0x21,
	0x79, 0xad, 0x56, 0xc8, 0xe9, 0x51, 0x4b, 0xbb, 0x1f, 0x95, 0x1b, 0xe4, 0xf0, 0xb6, 0x5b, 0x61,
	0x19, 0xed, 0x5e, 0xdb, 0xb7, 0x83, 0x11, 0xe4, 0xb7, 0xd0, 0xa3, 0xaa, 0x76, 0xfb, 0x2d, 0xdd,
	0x23, 0xaa, 0xa2, 0x7a, 0x09, 0x89, 0xd7, 0xf4, 0x50, 0xe4, 0xf5, 0xc7, 0x07, 0x2d, 0x75, 0x68,
	0xa4, 0x30, 0xe2, 0x1a, 0x8e, 0xed, 0x83, 0xa6, 0x5b, 0x8d, 0xf3, 0x38, 0x03, 0x5a, 0xce, 0x48,
	0x76, 0xd6, 0x0d, 0xf2, 0xf9, 0x0c, 0x92, 0x3d, 0x42, 0xa6, 0xd0, 0x35, 0x1a, 0xcb, 0x78, 0x23,
	0xa2, 0xe1, 0x63, 0x47, 0xbe, 0x82, 0x13, 0x7f, 0x5f, 0x21, 0xe9, 0xb9, 0x9a, 0x17, 0x8b, 0x85,
	0x8f, 0xc7, 0xb1, 0x43, 0x8e, 0x9b, 0xe8, 0x43, 0x48, 0xae, 0x5e, 0x6e, 0xfe, 0x64, 0x9d, 0xcd,
	0x36, 0x13, 0x3f, 0xb6, 0x99, 0xf8, 0xb9, 0xcd, 0xc4, 0xef, 0x6d, 0x26, 0xbe, 0xfd, 0xcd, 0x3a,
	0x5f, 0x7a, 0xcd, 0x65, 0xff, 0x0b, 0x00, 0x00, 0xff, 0xff, 0xdd, 0x58, 0x4f, 0x9f, 0xf1, 0x02,
	0x00, 0x00,
}
