// Code generated by protoc-gen-gogo.
// source: cockroach/pkg/sql/sqlbase/structured.proto
// DO NOT EDIT!

package sqlbase

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import cockroach_roachpb1 "github.com/cockroachdb/cockroach/pkg/roachpb"
import cockroach_util_hlc "github.com/cockroachdb/cockroach/pkg/util/hlc"

import github_com_cockroachdb_cockroach_pkg_roachpb "github.com/cockroachdb/cockroach/pkg/roachpb"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

type ConstraintValidity int32

const (
	ConstraintValidity_Validated   ConstraintValidity = 0
	ConstraintValidity_Unvalidated ConstraintValidity = 1
)

var ConstraintValidity_name = map[int32]string{
	0: "Validated",
	1: "Unvalidated",
}
var ConstraintValidity_value = map[string]int32{
	"Validated":   0,
	"Unvalidated": 1,
}

func (x ConstraintValidity) Enum() *ConstraintValidity {
	p := new(ConstraintValidity)
	*p = x
	return p
}
func (x ConstraintValidity) String() string {
	return proto.EnumName(ConstraintValidity_name, int32(x))
}
func (x *ConstraintValidity) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(ConstraintValidity_value, data, "ConstraintValidity")
	if err != nil {
		return err
	}
	*x = ConstraintValidity(value)
	return nil
}
func (ConstraintValidity) EnumDescriptor() ([]byte, []int) { return fileDescriptorStructured, []int{0} }

// These mirror the types supported by the sql/parser. See
// sql/parser/col_types.go.
type ColumnType_Kind int32

const (
	ColumnType_BOOL           ColumnType_Kind = 0
	ColumnType_INT            ColumnType_Kind = 1
	ColumnType_FLOAT          ColumnType_Kind = 2
	ColumnType_DECIMAL        ColumnType_Kind = 3
	ColumnType_DATE           ColumnType_Kind = 4
	ColumnType_TIMESTAMP      ColumnType_Kind = 5
	ColumnType_INTERVAL       ColumnType_Kind = 6
	ColumnType_STRING         ColumnType_Kind = 7
	ColumnType_BYTES          ColumnType_Kind = 8
	ColumnType_TIMESTAMPTZ    ColumnType_Kind = 9
	ColumnType_COLLATEDSTRING ColumnType_Kind = 10
	ColumnType_NAME           ColumnType_Kind = 11
	ColumnType_OID            ColumnType_Kind = 12
	// NULL is not supported as a table column type, however it can be
	// transferred through distsql streams.
	ColumnType_NULL ColumnType_Kind = 13
	ColumnType_UUID ColumnType_Kind = 14
	// Array and vector types.
	//
	// TODO(cuongdo): Fix this before allowing persistence of array/vector types
	// It would be cleaner if when array_dimensions are specified, Kind is
	// simply the parameterized type of the array. However, because Kind is used
	// to determine type information elsewhere, it isn't possible to take the
	// cleaner approach without an extensive refactoring.
	ColumnType_INT_ARRAY  ColumnType_Kind = 100
	ColumnType_INT2VECTOR ColumnType_Kind = 200
)

var ColumnType_Kind_name = map[int32]string{
	0:   "BOOL",
	1:   "INT",
	2:   "FLOAT",
	3:   "DECIMAL",
	4:   "DATE",
	5:   "TIMESTAMP",
	6:   "INTERVAL",
	7:   "STRING",
	8:   "BYTES",
	9:   "TIMESTAMPTZ",
	10:  "COLLATEDSTRING",
	11:  "NAME",
	12:  "OID",
	13:  "NULL",
	14:  "UUID",
	100: "INT_ARRAY",
	200: "INT2VECTOR",
}
var ColumnType_Kind_value = map[string]int32{
	"BOOL":           0,
	"INT":            1,
	"FLOAT":          2,
	"DECIMAL":        3,
	"DATE":           4,
	"TIMESTAMP":      5,
	"INTERVAL":       6,
	"STRING":         7,
	"BYTES":          8,
	"TIMESTAMPTZ":    9,
	"COLLATEDSTRING": 10,
	"NAME":           11,
	"OID":            12,
	"NULL":           13,
	"UUID":           14,
	"INT_ARRAY":      100,
	"INT2VECTOR":     200,
}

func (x ColumnType_Kind) Enum() *ColumnType_Kind {
	p := new(ColumnType_Kind)
	*p = x
	return p
}
func (x ColumnType_Kind) String() string {
	return proto.EnumName(ColumnType_Kind_name, int32(x))
}
func (x *ColumnType_Kind) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(ColumnType_Kind_value, data, "ColumnType_Kind")
	if err != nil {
		return err
	}
	*x = ColumnType_Kind(value)
	return nil
}
func (ColumnType_Kind) EnumDescriptor() ([]byte, []int) { return fileDescriptorStructured, []int{0, 0} }

// The direction of a column in the index.
type IndexDescriptor_Direction int32

const (
	IndexDescriptor_ASC  IndexDescriptor_Direction = 0
	IndexDescriptor_DESC IndexDescriptor_Direction = 1
)

var IndexDescriptor_Direction_name = map[int32]string{
	0: "ASC",
	1: "DESC",
}
var IndexDescriptor_Direction_value = map[string]int32{
	"ASC":  0,
	"DESC": 1,
}

func (x IndexDescriptor_Direction) Enum() *IndexDescriptor_Direction {
	p := new(IndexDescriptor_Direction)
	*p = x
	return p
}
func (x IndexDescriptor_Direction) String() string {
	return proto.EnumName(IndexDescriptor_Direction_name, int32(x))
}
func (x *IndexDescriptor_Direction) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(IndexDescriptor_Direction_value, data, "IndexDescriptor_Direction")
	if err != nil {
		return err
	}
	*x = IndexDescriptor_Direction(value)
	return nil
}
func (IndexDescriptor_Direction) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorStructured, []int{5, 0}
}

// A descriptor within a mutation is unavailable for reads, writes
// and deletes. It is only available for implicit (internal to
// the database) writes and deletes depending on the state of the mutation.
type DescriptorMutation_State int32

const (
	// Not used.
	DescriptorMutation_UNKNOWN DescriptorMutation_State = 0
	// Operations can use this invisible descriptor to implicitly
	// delete entries.
	// Column: A descriptor in this state is invisible to
	// INSERT and UPDATE. DELETE must delete a column in this state.
	// Index: A descriptor in this state is invisible to an INSERT.
	// UPDATE must delete the old value of the index but doesn't write
	// the new value. DELETE must delete the index.
	//
	// When deleting a descriptor, all descriptor related data
	// (column or index data) can only be mass deleted once
	// all the nodes have transitioned to the DELETE_ONLY state.
	DescriptorMutation_DELETE_ONLY DescriptorMutation_State = 1
	// Operations can use this invisible descriptor to implicitly
	// write and delete entries.
	// Column: INSERT will populate this column with the default
	// value. UPDATE ignores this descriptor. DELETE must delete
	// the column.
	// Index: INSERT, UPDATE and DELETE treat this index like any
	// other index.
	//
	// When adding a descriptor, all descriptor related data
	// (column default or index data) can only be backfilled once
	// all nodes have transitioned into the WRITE_ONLY state.
	DescriptorMutation_WRITE_ONLY DescriptorMutation_State = 2
)

var DescriptorMutation_State_name = map[int32]string{
	0: "UNKNOWN",
	1: "DELETE_ONLY",
	2: "WRITE_ONLY",
}
var DescriptorMutation_State_value = map[string]int32{
	"UNKNOWN":     0,
	"DELETE_ONLY": 1,
	"WRITE_ONLY":  2,
}

func (x DescriptorMutation_State) Enum() *DescriptorMutation_State {
	p := new(DescriptorMutation_State)
	*p = x
	return p
}
func (x DescriptorMutation_State) String() string {
	return proto.EnumName(DescriptorMutation_State_name, int32(x))
}
func (x *DescriptorMutation_State) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(DescriptorMutation_State_value, data, "DescriptorMutation_State")
	if err != nil {
		return err
	}
	*x = DescriptorMutation_State(value)
	return nil
}
func (DescriptorMutation_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorStructured, []int{6, 0}
}

// Direction of mutation.
type DescriptorMutation_Direction int32

const (
	// Not used.
	DescriptorMutation_NONE DescriptorMutation_Direction = 0
	// Descriptor is being added.
	DescriptorMutation_ADD DescriptorMutation_Direction = 1
	// Descriptor is being dropped.
	DescriptorMutation_DROP DescriptorMutation_Direction = 2
)

var DescriptorMutation_Direction_name = map[int32]string{
	0: "NONE",
	1: "ADD",
	2: "DROP",
}
var DescriptorMutation_Direction_value = map[string]int32{
	"NONE": 0,
	"ADD":  1,
	"DROP": 2,
}

func (x DescriptorMutation_Direction) Enum() *DescriptorMutation_Direction {
	p := new(DescriptorMutation_Direction)
	*p = x
	return p
}
func (x DescriptorMutation_Direction) String() string {
	return proto.EnumName(DescriptorMutation_Direction_name, int32(x))
}
func (x *DescriptorMutation_Direction) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(DescriptorMutation_Direction_value, data, "DescriptorMutation_Direction")
	if err != nil {
		return err
	}
	*x = DescriptorMutation_Direction(value)
	return nil
}
func (DescriptorMutation_Direction) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorStructured, []int{6, 1}
}

// State is set if this TableDescriptor is in the process of being added or deleted.
// A non-public table descriptor cannot be leased.
// A schema changer observing DROP set will truncate the table and delete the
// descriptor.
// It is illegal to transition DROP to any other state.
type TableDescriptor_State int32

const (
	// Not used.
	TableDescriptor_PUBLIC TableDescriptor_State = 0
	// Descriptor is being added.
	TableDescriptor_ADD TableDescriptor_State = 1
	// Descriptor is being dropped.
	TableDescriptor_DROP TableDescriptor_State = 2
)

var TableDescriptor_State_name = map[int32]string{
	0: "PUBLIC",
	1: "ADD",
	2: "DROP",
}
var TableDescriptor_State_value = map[string]int32{
	"PUBLIC": 0,
	"ADD":    1,
	"DROP":   2,
}

func (x TableDescriptor_State) Enum() *TableDescriptor_State {
	p := new(TableDescriptor_State)
	*p = x
	return p
}
func (x TableDescriptor_State) String() string {
	return proto.EnumName(TableDescriptor_State_name, int32(x))
}
func (x *TableDescriptor_State) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(TableDescriptor_State_value, data, "TableDescriptor_State")
	if err != nil {
		return err
	}
	*x = TableDescriptor_State(value)
	return nil
}
func (TableDescriptor_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptorStructured, []int{7, 0}
}

type ColumnType struct {
	Kind ColumnType_Kind `protobuf:"varint,1,opt,name=kind,enum=cockroach.sql.sqlbase.ColumnType_Kind" json:"kind"`
	// BIT, INT, FLOAT, DECIMAL, CHAR and BINARY
	Width int32 `protobuf:"varint,2,opt,name=width" json:"width"`
	// FLOAT and DECIMAL.
	Precision int32 `protobuf:"varint,3,opt,name=precision" json:"precision"`
	// The length of each dimension in the array. A dimension of -1 means that
	// no bound was specified for that dimension.
	ArrayDimensions []int32 `protobuf:"varint,4,rep,name=array_dimensions,json=arrayDimensions" json:"array_dimensions,omitempty"`
	// Collated STRING, CHAR, and VARCHAR
	Locale *string `protobuf:"bytes,5,opt,name=locale" json:"locale,omitempty"`
}

func (m *ColumnType) Reset()                    { *m = ColumnType{} }
func (m *ColumnType) String() string            { return proto.CompactTextString(m) }
func (*ColumnType) ProtoMessage()               {}
func (*ColumnType) Descriptor() ([]byte, []int) { return fileDescriptorStructured, []int{0} }

type ForeignKeyReference struct {
	Table    ID                 `protobuf:"varint,1,opt,name=table,casttype=ID" json:"table"`
	Index    IndexID            `protobuf:"varint,2,opt,name=index,casttype=IndexID" json:"index"`
	Name     string             `protobuf:"bytes,3,opt,name=name" json:"name"`
	Validity ConstraintValidity `protobuf:"varint,4,opt,name=validity,enum=cockroach.sql.sqlbase.ConstraintValidity" json:"validity"`
	// If this FK only uses a prefix of the columns in its index, we record how
	// many to avoid spuriously counting the additional cols as used by this FK.
	SharedPrefixLen int32 `protobuf:"varint,5,opt,name=shared_prefix_len,json=sharedPrefixLen" json:"shared_prefix_len"`
}

func (m *ForeignKeyReference) Reset()                    { *m = ForeignKeyReference{} }
func (m *ForeignKeyReference) String() string            { return proto.CompactTextString(m) }
func (*ForeignKeyReference) ProtoMessage()               {}
func (*ForeignKeyReference) Descriptor() ([]byte, []int) { return fileDescriptorStructured, []int{1} }

type ColumnDescriptor struct {
	Name     string     `protobuf:"bytes,1,opt,name=name" json:"name"`
	ID       ColumnID   `protobuf:"varint,2,opt,name=id,casttype=ColumnID" json:"id"`
	Type     ColumnType `protobuf:"bytes,3,opt,name=type" json:"type"`
	Nullable bool       `protobuf:"varint,4,opt,name=nullable" json:"nullable"`
	// Default expression to use to populate the column on insert if no
	// value is provided.
	DefaultExpr *string `protobuf:"bytes,5,opt,name=default_expr,json=defaultExpr" json:"default_expr,omitempty"`
	Hidden      bool    `protobuf:"varint,6,opt,name=hidden" json:"hidden"`
}

func (m *ColumnDescriptor) Reset()                    { *m = ColumnDescriptor{} }
func (m *ColumnDescriptor) String() string            { return proto.CompactTextString(m) }
func (*ColumnDescriptor) ProtoMessage()               {}
func (*ColumnDescriptor) Descriptor() ([]byte, []int) { return fileDescriptorStructured, []int{2} }

// ColumnFamilyDescriptor is set of columns stored together in one kv entry.
type ColumnFamilyDescriptor struct {
	Name string   `protobuf:"bytes,1,opt,name=name" json:"name"`
	ID   FamilyID `protobuf:"varint,2,opt,name=id,casttype=FamilyID" json:"id"`
	// A list of column names of which the family is comprised. This list
	// parallels the column_ids list. If duplicating the storage of the column
	// names here proves to be prohibitive, we could clear this field before
	// saving and reconstruct it after loading.
	ColumnNames []string `protobuf:"bytes,3,rep,name=column_names,json=columnNames" json:"column_names,omitempty"`
	// A list of column ids of which the family is comprised. This list parallels
	// the column_names list.
	ColumnIDs []ColumnID `protobuf:"varint,4,rep,name=column_ids,json=columnIds,casttype=ColumnID" json:"column_ids,omitempty"`
	// If nonzero, the column involved in the single column optimization.
	//
	// Families store colums in a ValueType_TUPLE as repeated <colid><data>
	// entries. As a space optimization and for backward compatibility, a single
	// column is written without the columnid prefix. Because more columns could
	// be added, it would be ambiguous which column was stored when read back in,
	// so this field supplies it.
	DefaultColumnID ColumnID `protobuf:"varint,5,opt,name=default_column_id,json=defaultColumnId,casttype=ColumnID" json:"default_column_id"`
}

func (m *ColumnFamilyDescriptor) Reset()                    { *m = ColumnFamilyDescriptor{} }
func (m *ColumnFamilyDescriptor) String() string            { return proto.CompactTextString(m) }
func (*ColumnFamilyDescriptor) ProtoMessage()               {}
func (*ColumnFamilyDescriptor) Descriptor() ([]byte, []int) { return fileDescriptorStructured, []int{3} }

// InterleaveDescriptor represents an index (either primary or secondary) that
// is interleaved into another table's data.
//
// Example:
// Table 1 -> /a/b
// Table 2 -> /a/b/c
// Table 3 -> /a/b/c/d
//
// There are two components (table 2 is the parent and table 1 is the
// grandparent) with shared lengths 2 and 1.
type InterleaveDescriptor struct {
	// Ancestors contains the nesting of interleaves in the order they appear in
	// an encoded key. This means they are always in the far-to-near ancestor
	// order (e.g. grand-grand-parent, grand-parent, parent).
	Ancestors []InterleaveDescriptor_Ancestor `protobuf:"bytes,1,rep,name=ancestors" json:"ancestors"`
}

func (m *InterleaveDescriptor) Reset()                    { *m = InterleaveDescriptor{} }
func (m *InterleaveDescriptor) String() string            { return proto.CompactTextString(m) }
func (*InterleaveDescriptor) ProtoMessage()               {}
func (*InterleaveDescriptor) Descriptor() ([]byte, []int) { return fileDescriptorStructured, []int{4} }

type InterleaveDescriptor_Ancestor struct {
	// TableID the ID of the table being interleaved into.
	TableID ID `protobuf:"varint,1,opt,name=table_id,json=tableId,casttype=ID" json:"table_id"`
	// IndexID is the ID of the parent index being interleaved into.
	IndexID IndexID `protobuf:"varint,2,opt,name=index_id,json=indexId,casttype=IndexID" json:"index_id"`
	// SharedPrefixLen is how many fields are shared between a parent and child
	// being interleaved, excluding any fields shared between parent and
	// grandparent. Thus, the sum of SharedPrefixLens in the components of an
	// InterleaveDescriptor is always strictly less than the number of fields
	// in the index being interleaved.
	SharedPrefixLen uint32 `protobuf:"varint,3,opt,name=shared_prefix_len,json=sharedPrefixLen" json:"shared_prefix_len"`
}

func (m *InterleaveDescriptor_Ancestor) Reset()         { *m = InterleaveDescriptor_Ancestor{} }
func (m *InterleaveDescriptor_Ancestor) String() string { return proto.CompactTextString(m) }
func (*InterleaveDescriptor_Ancestor) ProtoMessage()    {}
func (*InterleaveDescriptor_Ancestor) Descriptor() ([]byte, []int) {
	return fileDescriptorStructured, []int{4, 0}
}

// IndexDescriptor describes an index (primary or secondary).
//
// Sample field values on the following table:
//
//   CREATE TABLE t (
//     k1 INT NOT NULL,   // column ID: 1
//     k2 INT NOT NULL,   // column ID: 2
//     u INT NULL,        // column ID: 3
//     v INT NULL,        // column ID: 4
//     w INT NULL,        // column ID: 5
//     CONSTRAINT "primary" PRIMARY KEY (k1, k2),
//     INDEX k1v (k1, v) STORING (w),
//     FAMILY "primary" (k1, k2, u, v, w)
//   )
//
// Primary index:
//   name:                primary
//   id:                  1
//   unique:              true
//   column_names:        k1, k2
//   column_directions:   ASC, ASC
//   column_ids:          1, 2   // k1, k2
//
// [old STORING encoding] Index k1v (k1, v) STORING (w):
//   name:                k1v
//   id:                  2
//   unique:              false
//   column_names:        k1, v
//   column_directions:   ASC, ASC
//   store_column_names:  w
//   column_ids:          1, 4   // k1, v
//   extra_column_ids:    2, 5   // k2, w
//
// [new STORING encoding] Index k1v (k1, v) STORING (w):
//   name:                k1v
//   id:                  2
//   unique:              false
//   column_names:        k1, v
//   column_directions:   ASC, ASC
//   store_column_names:  w
//   column_ids:          1, 4   // k1, v
//   extra_column_ids:    2      // k2
//   store_column_ids:    5      // w
type IndexDescriptor struct {
	Name   string  `protobuf:"bytes,1,opt,name=name" json:"name"`
	ID     IndexID `protobuf:"varint,2,opt,name=id,casttype=IndexID" json:"id"`
	Unique bool    `protobuf:"varint,3,opt,name=unique" json:"unique"`
	// An ordered list of column names of which the index is comprised; these
	// columns do not include any additional stored columns (which are in
	// stored_column_names). This list parallels the column_ids list.
	//
	// Note: if duplicating the storage of the column names here proves to be
	// prohibitive, we could clear this field before saving and reconstruct it
	// after loading.
	ColumnNames []string `protobuf:"bytes,4,rep,name=column_names,json=columnNames" json:"column_names,omitempty"`
	// The sort direction of each column in column_names.
	ColumnDirections []IndexDescriptor_Direction `protobuf:"varint,8,rep,name=column_directions,json=columnDirections,enum=cockroach.sql.sqlbase.IndexDescriptor_Direction" json:"column_directions,omitempty"`
	// An ordered list of column names which the index stores in addition to the
	// columns which are explicitly part of the index (STORING clause). Only used
	// for secondary indexes.
	StoreColumnNames []string `protobuf:"bytes,5,rep,name=store_column_names,json=storeColumnNames" json:"store_column_names,omitempty"`
	// An ordered list of column IDs of which the index is comprised. This list
	// parallels the column_names list and does not include any additional stored
	// columns.
	ColumnIDs []ColumnID `protobuf:"varint,6,rep,name=column_ids,json=columnIds,casttype=ColumnID" json:"column_ids,omitempty"`
	// An ordered list of IDs for the additional columns associated with the
	// index:
	//  - implicit columns, which are all the primary key columns that are not
	//    already part of the index (i.e. PrimaryIndex.column_ids - column_ids).
	//  - stored columns (the columns in store_column_names) if this index uses the
	//    old STORING encoding (key-encoded data).
	//
	// Only used for secondary indexes.
	// For non-unique indexes, these columns are appended to the key.
	// For unique indexes, these columns are stored in the value.
	// This distinction exists because we want to be able to insert an entry using
	// a single conditional put on the key.
	ExtraColumnIDs []ColumnID `protobuf:"varint,7,rep,name=extra_column_ids,json=extraColumnIds,casttype=ColumnID" json:"extra_column_ids,omitempty"`
	// An ordered list of column IDs that parallels store_column_names if this
	// index uses the new STORING encoding (value-encoded data, always in the KV
	// value).
	StoreColumnIDs []ColumnID `protobuf:"varint,14,rep,name=store_column_ids,json=storeColumnIds,casttype=ColumnID" json:"store_column_ids,omitempty"`
	// CompositeColumnIDs contains an ordered list of IDs of columns that appear
	// in the index and have a composite encoding. Includes IDs from both
	// column_ids and extra_column_ids.
	CompositeColumnIDs []ColumnID            `protobuf:"varint,13,rep,name=composite_column_ids,json=compositeColumnIds,casttype=ColumnID" json:"composite_column_ids,omitempty"`
	ForeignKey         ForeignKeyReference   `protobuf:"bytes,9,opt,name=foreign_key,json=foreignKey" json:"foreign_key"`
	ReferencedBy       []ForeignKeyReference `protobuf:"bytes,10,rep,name=referenced_by,json=referencedBy" json:"referenced_by"`
	// Interleave, if it's not the zero value, describes how this index's data is
	// interleaved into another index's data.
	Interleave InterleaveDescriptor `protobuf:"bytes,11,opt,name=interleave" json:"interleave"`
	// InterleavedBy contains a reference to every table/index that is interleaved
	// into this one.
	InterleavedBy []ForeignKeyReference `protobuf:"bytes,12,rep,name=interleaved_by,json=interleavedBy" json:"interleaved_by"`
}

func (m *IndexDescriptor) Reset()                    { *m = IndexDescriptor{} }
func (m *IndexDescriptor) String() string            { return proto.CompactTextString(m) }
func (*IndexDescriptor) ProtoMessage()               {}
func (*IndexDescriptor) Descriptor() ([]byte, []int) { return fileDescriptorStructured, []int{5} }

// A DescriptorMutation represents a column or an index that
// has either been added or dropped and hasn't yet transitioned
// into a stable state: completely backfilled and visible, or
// completely deleted. A table descriptor in the middle of a
// schema change will have a DescriptorMutation FIFO queue
// containing each column/index descriptor being added or dropped.
type DescriptorMutation struct {
	// Types that are valid to be assigned to Descriptor_:
	//	*DescriptorMutation_Column
	//	*DescriptorMutation_Index
	Descriptor_ isDescriptorMutation_Descriptor_ `protobuf_oneof:"descriptor"`
	State       DescriptorMutation_State         `protobuf:"varint,3,opt,name=state,enum=cockroach.sql.sqlbase.DescriptorMutation_State" json:"state"`
	Direction   DescriptorMutation_Direction     `protobuf:"varint,4,opt,name=direction,enum=cockroach.sql.sqlbase.DescriptorMutation_Direction" json:"direction"`
	// The mutation id used to group mutations that should be applied together.
	// This is used for situations like creating a unique column, which
	// involve adding two mutations: one for the column, and another for the
	// unique constraint index.
	MutationID MutationID `protobuf:"varint,5,opt,name=mutation_id,json=mutationId,casttype=MutationID" json:"mutation_id"`
	// A schema change can involve running multiple processors backfilling
	// or deleting data. They occasionally checkpoint Spans so that the
	// processing can resume in the event of a node failure. The spans are
	// non-overlapping contiguous areas of the KV space that still need to
	// be processed.
	ResumeSpans []cockroach_roachpb1.Span `protobuf:"bytes,6,rep,name=resume_spans,json=resumeSpans" json:"resume_spans"`
}

func (m *DescriptorMutation) Reset()                    { *m = DescriptorMutation{} }
func (m *DescriptorMutation) String() string            { return proto.CompactTextString(m) }
func (*DescriptorMutation) ProtoMessage()               {}
func (*DescriptorMutation) Descriptor() ([]byte, []int) { return fileDescriptorStructured, []int{6} }

type isDescriptorMutation_Descriptor_ interface {
	isDescriptorMutation_Descriptor_()
	MarshalTo([]byte) (int, error)
	Size() int
}

type DescriptorMutation_Column struct {
	Column *ColumnDescriptor `protobuf:"bytes,1,opt,name=column,oneof"`
}
type DescriptorMutation_Index struct {
	Index *IndexDescriptor `protobuf:"bytes,2,opt,name=index,oneof"`
}

func (*DescriptorMutation_Column) isDescriptorMutation_Descriptor_() {}
func (*DescriptorMutation_Index) isDescriptorMutation_Descriptor_()  {}

func (m *DescriptorMutation) GetDescriptor_() isDescriptorMutation_Descriptor_ {
	if m != nil {
		return m.Descriptor_
	}
	return nil
}

func (m *DescriptorMutation) GetColumn() *ColumnDescriptor {
	if x, ok := m.GetDescriptor_().(*DescriptorMutation_Column); ok {
		return x.Column
	}
	return nil
}

func (m *DescriptorMutation) GetIndex() *IndexDescriptor {
	if x, ok := m.GetDescriptor_().(*DescriptorMutation_Index); ok {
		return x.Index
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*DescriptorMutation) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _DescriptorMutation_OneofMarshaler, _DescriptorMutation_OneofUnmarshaler, _DescriptorMutation_OneofSizer, []interface{}{
		(*DescriptorMutation_Column)(nil),
		(*DescriptorMutation_Index)(nil),
	}
}

func _DescriptorMutation_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*DescriptorMutation)
	// descriptor
	switch x := m.Descriptor_.(type) {
	case *DescriptorMutation_Column:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Column); err != nil {
			return err
		}
	case *DescriptorMutation_Index:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Index); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("DescriptorMutation.Descriptor_ has unexpected type %T", x)
	}
	return nil
}

func _DescriptorMutation_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*DescriptorMutation)
	switch tag {
	case 1: // descriptor.column
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ColumnDescriptor)
		err := b.DecodeMessage(msg)
		m.Descriptor_ = &DescriptorMutation_Column{msg}
		return true, err
	case 2: // descriptor.index
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(IndexDescriptor)
		err := b.DecodeMessage(msg)
		m.Descriptor_ = &DescriptorMutation_Index{msg}
		return true, err
	default:
		return false, nil
	}
}

func _DescriptorMutation_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*DescriptorMutation)
	// descriptor
	switch x := m.Descriptor_.(type) {
	case *DescriptorMutation_Column:
		s := proto.Size(x.Column)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *DescriptorMutation_Index:
		s := proto.Size(x.Index)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A TableDescriptor represents a table or view and is stored in a
// structured metadata key. The TableDescriptor has a globally-unique ID,
// while its member {Column,Index}Descriptors have locally-unique IDs.
type TableDescriptor struct {
	// The table name. It should be normalized using sqlbase.NormalizeName()
	// before comparing it.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name"`
	ID   ID     `protobuf:"varint,3,opt,name=id,casttype=ID" json:"id"`
	// ID of the parent database.
	ParentID ID `protobuf:"varint,4,opt,name=parent_id,json=parentId,casttype=ID" json:"parent_id"`
	// Monotonically increasing version of the table descriptor.
	//
	// Invariants:
	// 1. not more than two subsequent versions of the table
	// descriptor can be leased. This is to make the system
	// easy to reason about, by permiting mutation state
	// changes (reflected in the next version), only when the existing
	// state (reflected in the current version) is present on all
	// outstanding unexpired leases.
	// 2. A schema change command (ALTER, RENAME, etc) never directly
	// increments the version. This allows the command to execute without
	// waiting for the entire cluster to converge to a single version
	// preventing weird deadlock situations. For instance, a transaction
	// with a schema change command might use a descriptor lease that is
	// at version: v - 1, and therefore deadlock when it tries to wait
	// for version: v, in the process of incrementing it to v + 1.
	// Therefore, a schema change command never increments the version,
	// and instead, sets the up_version boolean to notify the schema
	// changer execution engine that runs a future transaction to
	// increment the version.
	//
	// The schema change commands must therefore make *safe* modifications
	// to the table descriptor, such as scheduling long running schema
	// changes through mutations for future execution, or making simple
	// schema changes like RENAME that only modify the table descriptor in a
	// single transaction.
	//
	// Multiple schema changes in the same transaction set up_version.
	// The actual schema change execution that follows a schema change
	// command sees the up_version boolean set, and increments the
	// table version after ensuring that there are no unexpired leases
	// for version - 1. The schema change execution must increment
	// the version before executing future state changes, to ensure
	// that the scheduled mutations made by the original commands are
	// visible on all leases. Multiple schema change mutations can be
	// grouped together on a particular version increment.
	//
	// If schema change commands are safe to run without incrementing
	// the version, why do it later on? We increment the version
	// to ensure that all the nodes renew their leases with the new version
	// and get to see what the schema change command has done quickly.
	Version DescriptorVersion `protobuf:"varint,5,opt,name=version,casttype=DescriptorVersion" json:"version"`
	// See comment above.
	UpVersion bool `protobuf:"varint,6,opt,name=up_version,json=upVersion" json:"up_version"`
	// Last modification time of the table descriptor.
	ModificationTime cockroach_util_hlc.Timestamp `protobuf:"bytes,7,opt,name=modification_time,json=modificationTime" json:"modification_time"`
	Columns          []ColumnDescriptor           `protobuf:"bytes,8,rep,name=columns" json:"columns"`
	// next_column_id is used to ensure that deleted column ids are not reused.
	NextColumnID ColumnID                 `protobuf:"varint,9,opt,name=next_column_id,json=nextColumnId,casttype=ColumnID" json:"next_column_id"`
	Families     []ColumnFamilyDescriptor `protobuf:"bytes,22,rep,name=families" json:"families"`
	// next_family_id is used to ensure that deleted family ids are not reused.
	NextFamilyID FamilyID        `protobuf:"varint,23,opt,name=next_family_id,json=nextFamilyId,casttype=FamilyID" json:"next_family_id"`
	PrimaryIndex IndexDescriptor `protobuf:"bytes,10,opt,name=primary_index,json=primaryIndex" json:"primary_index"`
	// indexes are all the secondary indexes.
	Indexes []IndexDescriptor `protobuf:"bytes,11,rep,name=indexes" json:"indexes"`
	// next_index_id is used to ensure that deleted index ids are not reused.
	NextIndexID IndexID              `protobuf:"varint,12,opt,name=next_index_id,json=nextIndexId,casttype=IndexID" json:"next_index_id"`
	Privileges  *PrivilegeDescriptor `protobuf:"bytes,13,opt,name=privileges" json:"privileges,omitempty"`
	// Columns or indexes being added or deleted in a FIFO order.
	Mutations []DescriptorMutation               `protobuf:"bytes,14,rep,name=mutations" json:"mutations"`
	Lease     *TableDescriptor_SchemaChangeLease `protobuf:"bytes,15,opt,name=lease" json:"lease,omitempty"`
	// An id for the next group of mutations to be applied together.
	NextMutationID MutationID `protobuf:"varint,16,opt,name=next_mutation_id,json=nextMutationId,casttype=MutationID" json:"next_mutation_id"`
	// format_version declares which sql to key:value mapping is being used to
	// represent the data in this table.
	FormatVersion FormatVersion                      `protobuf:"varint,17,opt,name=format_version,json=formatVersion,casttype=FormatVersion" json:"format_version"`
	State         TableDescriptor_State              `protobuf:"varint,19,opt,name=state,enum=cockroach.sql.sqlbase.TableDescriptor_State" json:"state"`
	Checks        []*TableDescriptor_CheckConstraint `protobuf:"bytes,20,rep,name=checks" json:"checks,omitempty"`
	// This array is populated if the descriptor was renamed. If the descriptor is
	// renamed multiple times before the schema chage is processed, there will be
	// one element for each rename.
	// When this is detected in a schema change, the records for the old names are
	// deleted and this field is cleared.
	Renames []TableDescriptor_RenameInfo `protobuf:"bytes,21,rep,name=renames" json:"renames"`
	// The TableDescriptor is used for views in addition to tables. Views
	// use mostly the same fields as tables, but need to track the actual
	// query from the view definition as well.
	//
	// For now we only track a string representation of the query. This prevents
	// us from easily supporting things like renames of the dependencies of a
	// view. Eventually we'll want to switch to a semantic encoding of the query
	// that relies on IDs rather than names so that we can support renames of
	// fields relied on by the query, as Postgres does.
	//
	// Note: The presence of this field is used to determine whether or not
	// a TableDescriptor represents a view.
	ViewQuery string `protobuf:"bytes,24,opt,name=view_query,json=viewQuery" json:"view_query"`
	// The IDs of all relations that this depends on.
	// Only ever populated if this descriptor is for a view.
	DependsOn []ID `protobuf:"varint,25,rep,name=dependsOn,casttype=ID" json:"dependsOn,omitempty"`
	// All references to this table/view from other views in the system, tracked
	// down to the column/index so that we can restrict changes to them while
	// they're still being referred to.
	DependedOnBy []TableDescriptor_Reference `protobuf:"bytes,26,rep,name=dependedOnBy" json:"dependedOnBy"`
	// Mutation jobs queued for execution in a FIFO order. Remains synchronized
	// with the mutations list.
	MutationJobs []TableDescriptor_MutationJob `protobuf:"bytes,27,rep,name=mutationJobs" json:"mutationJobs"`
}

func (m *TableDescriptor) Reset()                    { *m = TableDescriptor{} }
func (m *TableDescriptor) String() string            { return proto.CompactTextString(m) }
func (*TableDescriptor) ProtoMessage()               {}
func (*TableDescriptor) Descriptor() ([]byte, []int) { return fileDescriptorStructured, []int{7} }

func (m *TableDescriptor) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *TableDescriptor) GetID() ID {
	if m != nil {
		return m.ID
	}
	return 0
}

func (m *TableDescriptor) GetParentID() ID {
	if m != nil {
		return m.ParentID
	}
	return 0
}

func (m *TableDescriptor) GetVersion() DescriptorVersion {
	if m != nil {
		return m.Version
	}
	return 0
}

func (m *TableDescriptor) GetUpVersion() bool {
	if m != nil {
		return m.UpVersion
	}
	return false
}

func (m *TableDescriptor) GetModificationTime() cockroach_util_hlc.Timestamp {
	if m != nil {
		return m.ModificationTime
	}
	return cockroach_util_hlc.Timestamp{}
}

func (m *TableDescriptor) GetColumns() []ColumnDescriptor {
	if m != nil {
		return m.Columns
	}
	return nil
}

func (m *TableDescriptor) GetNextColumnID() ColumnID {
	if m != nil {
		return m.NextColumnID
	}
	return 0
}

func (m *TableDescriptor) GetFamilies() []ColumnFamilyDescriptor {
	if m != nil {
		return m.Families
	}
	return nil
}

func (m *TableDescriptor) GetNextFamilyID() FamilyID {
	if m != nil {
		return m.NextFamilyID
	}
	return 0
}

func (m *TableDescriptor) GetPrimaryIndex() IndexDescriptor {
	if m != nil {
		return m.PrimaryIndex
	}
	return IndexDescriptor{}
}

func (m *TableDescriptor) GetIndexes() []IndexDescriptor {
	if m != nil {
		return m.Indexes
	}
	return nil
}

func (m *TableDescriptor) GetNextIndexID() IndexID {
	if m != nil {
		return m.NextIndexID
	}
	return 0
}

func (m *TableDescriptor) GetPrivileges() *PrivilegeDescriptor {
	if m != nil {
		return m.Privileges
	}
	return nil
}

func (m *TableDescriptor) GetMutations() []DescriptorMutation {
	if m != nil {
		return m.Mutations
	}
	return nil
}

func (m *TableDescriptor) GetLease() *TableDescriptor_SchemaChangeLease {
	if m != nil {
		return m.Lease
	}
	return nil
}

func (m *TableDescriptor) GetNextMutationID() MutationID {
	if m != nil {
		return m.NextMutationID
	}
	return 0
}

func (m *TableDescriptor) GetFormatVersion() FormatVersion {
	if m != nil {
		return m.FormatVersion
	}
	return 0
}

func (m *TableDescriptor) GetState() TableDescriptor_State {
	if m != nil {
		return m.State
	}
	return TableDescriptor_PUBLIC
}

func (m *TableDescriptor) GetChecks() []*TableDescriptor_CheckConstraint {
	if m != nil {
		return m.Checks
	}
	return nil
}

func (m *TableDescriptor) GetRenames() []TableDescriptor_RenameInfo {
	if m != nil {
		return m.Renames
	}
	return nil
}

func (m *TableDescriptor) GetViewQuery() string {
	if m != nil {
		return m.ViewQuery
	}
	return ""
}

func (m *TableDescriptor) GetDependsOn() []ID {
	if m != nil {
		return m.DependsOn
	}
	return nil
}

func (m *TableDescriptor) GetDependedOnBy() []TableDescriptor_Reference {
	if m != nil {
		return m.DependedOnBy
	}
	return nil
}

func (m *TableDescriptor) GetMutationJobs() []TableDescriptor_MutationJob {
	if m != nil {
		return m.MutationJobs
	}
	return nil
}

// The schema update lease. A single goroutine across a cockroach cluster
// can own it, and will execute pending schema changes for this table.
// Since the execution of a pending schema change is through transactions,
// it is legal for more than one goroutine to attempt to execute it. This
// lease reduces write contention on the schema change.
type TableDescriptor_SchemaChangeLease struct {
	NodeID github_com_cockroachdb_cockroach_pkg_roachpb.NodeID `protobuf:"varint,1,opt,name=node_id,json=nodeId,casttype=github.com/cockroachdb/cockroach/pkg/roachpb.NodeID" json:"node_id"`
	// Nanoseconds since the Unix epoch.
	ExpirationTime int64 `protobuf:"varint,2,opt,name=expiration_time,json=expirationTime" json:"expiration_time"`
}

func (m *TableDescriptor_SchemaChangeLease) Reset()         { *m = TableDescriptor_SchemaChangeLease{} }
func (m *TableDescriptor_SchemaChangeLease) String() string { return proto.CompactTextString(m) }
func (*TableDescriptor_SchemaChangeLease) ProtoMessage()    {}
func (*TableDescriptor_SchemaChangeLease) Descriptor() ([]byte, []int) {
	return fileDescriptorStructured, []int{7, 0}
}

type TableDescriptor_CheckConstraint struct {
	Expr     string             `protobuf:"bytes,1,opt,name=expr" json:"expr"`
	Name     string             `protobuf:"bytes,2,opt,name=name" json:"name"`
	Validity ConstraintValidity `protobuf:"varint,3,opt,name=validity,enum=cockroach.sql.sqlbase.ConstraintValidity" json:"validity"`
}

func (m *TableDescriptor_CheckConstraint) Reset()         { *m = TableDescriptor_CheckConstraint{} }
func (m *TableDescriptor_CheckConstraint) String() string { return proto.CompactTextString(m) }
func (*TableDescriptor_CheckConstraint) ProtoMessage()    {}
func (*TableDescriptor_CheckConstraint) Descriptor() ([]byte, []int) {
	return fileDescriptorStructured, []int{7, 1}
}

type TableDescriptor_RenameInfo struct {
	// The database that the table belonged to before the rename (tables can be
	// renamed from one db to another).
	OldParentID ID     `protobuf:"varint,1,opt,name=old_parent_id,json=oldParentId,casttype=ID" json:"old_parent_id"`
	OldName     string `protobuf:"bytes,2,opt,name=old_name,json=oldName" json:"old_name"`
}

func (m *TableDescriptor_RenameInfo) Reset()         { *m = TableDescriptor_RenameInfo{} }
func (m *TableDescriptor_RenameInfo) String() string { return proto.CompactTextString(m) }
func (*TableDescriptor_RenameInfo) ProtoMessage()    {}
func (*TableDescriptor_RenameInfo) Descriptor() ([]byte, []int) {
	return fileDescriptorStructured, []int{7, 2}
}

type TableDescriptor_Reference struct {
	// The ID of the relation that depends on this one.
	ID ID `protobuf:"varint,1,opt,name=id,casttype=ID" json:"id"`
	// If applicable, the ID of this table's index that is refenced by the
	// dependent relation.
	IndexID IndexID `protobuf:"varint,2,opt,name=index_id,json=indexId,casttype=IndexID" json:"index_id"`
	// The IDs of this table's columns that are referenced by the dependent
	// relation.
	ColumnIDs []ColumnID `protobuf:"varint,3,rep,name=column_ids,json=columnIds,casttype=ColumnID" json:"column_ids,omitempty"`
}

func (m *TableDescriptor_Reference) Reset()         { *m = TableDescriptor_Reference{} }
func (m *TableDescriptor_Reference) String() string { return proto.CompactTextString(m) }
func (*TableDescriptor_Reference) ProtoMessage()    {}
func (*TableDescriptor_Reference) Descriptor() ([]byte, []int) {
	return fileDescriptorStructured, []int{7, 3}
}

type TableDescriptor_MutationJob struct {
	// The mutation id of this mutation job.
	MutationID MutationID `protobuf:"varint,1,opt,name=mutation_id,json=mutationId,casttype=MutationID" json:"mutation_id"`
	// The job id for a mutation job is the id in the system.jobs table of the
	// schema change job executing the mutation referenced by mutation_id.
	JobID int64 `protobuf:"varint,2,opt,name=job_id,json=jobId" json:"job_id"`
}

func (m *TableDescriptor_MutationJob) Reset()         { *m = TableDescriptor_MutationJob{} }
func (m *TableDescriptor_MutationJob) String() string { return proto.CompactTextString(m) }
func (*TableDescriptor_MutationJob) ProtoMessage()    {}
func (*TableDescriptor_MutationJob) Descriptor() ([]byte, []int) {
	return fileDescriptorStructured, []int{7, 4}
}

// DatabaseDescriptor represents a namespace (aka database) and is stored
// in a structured metadata key. The DatabaseDescriptor has a globally-unique
// ID shared with the TableDescriptor ID.
// Permissions are applied to all tables in the namespace.
type DatabaseDescriptor struct {
	Name       string               `protobuf:"bytes,1,opt,name=name" json:"name"`
	ID         ID                   `protobuf:"varint,2,opt,name=id,casttype=ID" json:"id"`
	Privileges *PrivilegeDescriptor `protobuf:"bytes,3,opt,name=privileges" json:"privileges,omitempty"`
}

func (m *DatabaseDescriptor) Reset()                    { *m = DatabaseDescriptor{} }
func (m *DatabaseDescriptor) String() string            { return proto.CompactTextString(m) }
func (*DatabaseDescriptor) ProtoMessage()               {}
func (*DatabaseDescriptor) Descriptor() ([]byte, []int) { return fileDescriptorStructured, []int{8} }

func (m *DatabaseDescriptor) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DatabaseDescriptor) GetID() ID {
	if m != nil {
		return m.ID
	}
	return 0
}

func (m *DatabaseDescriptor) GetPrivileges() *PrivilegeDescriptor {
	if m != nil {
		return m.Privileges
	}
	return nil
}

// Descriptor is a union type holding either a table or database descriptor.
type Descriptor struct {
	// Types that are valid to be assigned to Union:
	//	*Descriptor_Table
	//	*Descriptor_Database
	Union isDescriptor_Union `protobuf_oneof:"union"`
}

func (m *Descriptor) Reset()                    { *m = Descriptor{} }
func (m *Descriptor) String() string            { return proto.CompactTextString(m) }
func (*Descriptor) ProtoMessage()               {}
func (*Descriptor) Descriptor() ([]byte, []int) { return fileDescriptorStructured, []int{9} }

type isDescriptor_Union interface {
	isDescriptor_Union()
	MarshalTo([]byte) (int, error)
	Size() int
}

type Descriptor_Table struct {
	Table *TableDescriptor `protobuf:"bytes,1,opt,name=table,oneof"`
}
type Descriptor_Database struct {
	Database *DatabaseDescriptor `protobuf:"bytes,2,opt,name=database,oneof"`
}

func (*Descriptor_Table) isDescriptor_Union()    {}
func (*Descriptor_Database) isDescriptor_Union() {}

func (m *Descriptor) GetUnion() isDescriptor_Union {
	if m != nil {
		return m.Union
	}
	return nil
}

func (m *Descriptor) GetTable() *TableDescriptor {
	if x, ok := m.GetUnion().(*Descriptor_Table); ok {
		return x.Table
	}
	return nil
}

func (m *Descriptor) GetDatabase() *DatabaseDescriptor {
	if x, ok := m.GetUnion().(*Descriptor_Database); ok {
		return x.Database
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Descriptor) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Descriptor_OneofMarshaler, _Descriptor_OneofUnmarshaler, _Descriptor_OneofSizer, []interface{}{
		(*Descriptor_Table)(nil),
		(*Descriptor_Database)(nil),
	}
}

func _Descriptor_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Descriptor)
	// union
	switch x := m.Union.(type) {
	case *Descriptor_Table:
		_ = b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Table); err != nil {
			return err
		}
	case *Descriptor_Database:
		_ = b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Database); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Descriptor.Union has unexpected type %T", x)
	}
	return nil
}

func _Descriptor_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Descriptor)
	switch tag {
	case 1: // union.table
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(TableDescriptor)
		err := b.DecodeMessage(msg)
		m.Union = &Descriptor_Table{msg}
		return true, err
	case 2: // union.database
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DatabaseDescriptor)
		err := b.DecodeMessage(msg)
		m.Union = &Descriptor_Database{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Descriptor_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Descriptor)
	// union
	switch x := m.Union.(type) {
	case *Descriptor_Table:
		s := proto.Size(x.Table)
		n += proto.SizeVarint(1<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Descriptor_Database:
		s := proto.Size(x.Database)
		n += proto.SizeVarint(2<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

func init() {
	proto.RegisterType((*ColumnType)(nil), "cockroach.sql.sqlbase.ColumnType")
	proto.RegisterType((*ForeignKeyReference)(nil), "cockroach.sql.sqlbase.ForeignKeyReference")
	proto.RegisterType((*ColumnDescriptor)(nil), "cockroach.sql.sqlbase.ColumnDescriptor")
	proto.RegisterType((*ColumnFamilyDescriptor)(nil), "cockroach.sql.sqlbase.ColumnFamilyDescriptor")
	proto.RegisterType((*InterleaveDescriptor)(nil), "cockroach.sql.sqlbase.InterleaveDescriptor")
	proto.RegisterType((*InterleaveDescriptor_Ancestor)(nil), "cockroach.sql.sqlbase.InterleaveDescriptor.Ancestor")
	proto.RegisterType((*IndexDescriptor)(nil), "cockroach.sql.sqlbase.IndexDescriptor")
	proto.RegisterType((*DescriptorMutation)(nil), "cockroach.sql.sqlbase.DescriptorMutation")
	proto.RegisterType((*TableDescriptor)(nil), "cockroach.sql.sqlbase.TableDescriptor")
	proto.RegisterType((*TableDescriptor_SchemaChangeLease)(nil), "cockroach.sql.sqlbase.TableDescriptor.SchemaChangeLease")
	proto.RegisterType((*TableDescriptor_CheckConstraint)(nil), "cockroach.sql.sqlbase.TableDescriptor.CheckConstraint")
	proto.RegisterType((*TableDescriptor_RenameInfo)(nil), "cockroach.sql.sqlbase.TableDescriptor.RenameInfo")
	proto.RegisterType((*TableDescriptor_Reference)(nil), "cockroach.sql.sqlbase.TableDescriptor.Reference")
	proto.RegisterType((*TableDescriptor_MutationJob)(nil), "cockroach.sql.sqlbase.TableDescriptor.MutationJob")
	proto.RegisterType((*DatabaseDescriptor)(nil), "cockroach.sql.sqlbase.DatabaseDescriptor")
	proto.RegisterType((*Descriptor)(nil), "cockroach.sql.sqlbase.Descriptor")
	proto.RegisterEnum("cockroach.sql.sqlbase.ConstraintValidity", ConstraintValidity_name, ConstraintValidity_value)
	proto.RegisterEnum("cockroach.sql.sqlbase.ColumnType_Kind", ColumnType_Kind_name, ColumnType_Kind_value)
	proto.RegisterEnum("cockroach.sql.sqlbase.IndexDescriptor_Direction", IndexDescriptor_Direction_name, IndexDescriptor_Direction_value)
	proto.RegisterEnum("cockroach.sql.sqlbase.DescriptorMutation_State", DescriptorMutation_State_name, DescriptorMutation_State_value)
	proto.RegisterEnum("cockroach.sql.sqlbase.DescriptorMutation_Direction", DescriptorMutation_Direction_name, DescriptorMutation_Direction_value)
	proto.RegisterEnum("cockroach.sql.sqlbase.TableDescriptor_State", TableDescriptor_State_name, TableDescriptor_State_value)
}
func (m *ColumnType) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ColumnType) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintStructured(dAtA, i, uint64(m.Kind))
	dAtA[i] = 0x10
	i++
	i = encodeVarintStructured(dAtA, i, uint64(m.Width))
	dAtA[i] = 0x18
	i++
	i = encodeVarintStructured(dAtA, i, uint64(m.Precision))
	if len(m.ArrayDimensions) > 0 {
		for _, num := range m.ArrayDimensions {
			dAtA[i] = 0x20
			i++
			i = encodeVarintStructured(dAtA, i, uint64(num))
		}
	}
	if m.Locale != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintStructured(dAtA, i, uint64(len(*m.Locale)))
		i += copy(dAtA[i:], *m.Locale)
	}
	return i, nil
}

func (m *ForeignKeyReference) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ForeignKeyReference) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintStructured(dAtA, i, uint64(m.Table))
	dAtA[i] = 0x10
	i++
	i = encodeVarintStructured(dAtA, i, uint64(m.Index))
	dAtA[i] = 0x1a
	i++
	i = encodeVarintStructured(dAtA, i, uint64(len(m.Name)))
	i += copy(dAtA[i:], m.Name)
	dAtA[i] = 0x20
	i++
	i = encodeVarintStructured(dAtA, i, uint64(m.Validity))
	dAtA[i] = 0x28
	i++
	i = encodeVarintStructured(dAtA, i, uint64(m.SharedPrefixLen))
	return i, nil
}

func (m *ColumnDescriptor) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ColumnDescriptor) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintStructured(dAtA, i, uint64(len(m.Name)))
	i += copy(dAtA[i:], m.Name)
	dAtA[i] = 0x10
	i++
	i = encodeVarintStructured(dAtA, i, uint64(m.ID))
	dAtA[i] = 0x1a
	i++
	i = encodeVarintStructured(dAtA, i, uint64(m.Type.Size()))
	n1, err := m.Type.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n1
	dAtA[i] = 0x20
	i++
	if m.Nullable {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	if m.DefaultExpr != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintStructured(dAtA, i, uint64(len(*m.DefaultExpr)))
		i += copy(dAtA[i:], *m.DefaultExpr)
	}
	dAtA[i] = 0x30
	i++
	if m.Hidden {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	return i, nil
}

func (m *ColumnFamilyDescriptor) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ColumnFamilyDescriptor) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintStructured(dAtA, i, uint64(len(m.Name)))
	i += copy(dAtA[i:], m.Name)
	dAtA[i] = 0x10
	i++
	i = encodeVarintStructured(dAtA, i, uint64(m.ID))
	if len(m.ColumnNames) > 0 {
		for _, s := range m.ColumnNames {
			dAtA[i] = 0x1a
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.ColumnIDs) > 0 {
		for _, num := range m.ColumnIDs {
			dAtA[i] = 0x20
			i++
			i = encodeVarintStructured(dAtA, i, uint64(num))
		}
	}
	dAtA[i] = 0x28
	i++
	i = encodeVarintStructured(dAtA, i, uint64(m.DefaultColumnID))
	return i, nil
}

func (m *InterleaveDescriptor) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InterleaveDescriptor) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Ancestors) > 0 {
		for _, msg := range m.Ancestors {
			dAtA[i] = 0xa
			i++
			i = encodeVarintStructured(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *InterleaveDescriptor_Ancestor) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *InterleaveDescriptor_Ancestor) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintStructured(dAtA, i, uint64(m.TableID))
	dAtA[i] = 0x10
	i++
	i = encodeVarintStructured(dAtA, i, uint64(m.IndexID))
	dAtA[i] = 0x18
	i++
	i = encodeVarintStructured(dAtA, i, uint64(m.SharedPrefixLen))
	return i, nil
}

func (m *IndexDescriptor) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *IndexDescriptor) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintStructured(dAtA, i, uint64(len(m.Name)))
	i += copy(dAtA[i:], m.Name)
	dAtA[i] = 0x10
	i++
	i = encodeVarintStructured(dAtA, i, uint64(m.ID))
	dAtA[i] = 0x18
	i++
	if m.Unique {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	if len(m.ColumnNames) > 0 {
		for _, s := range m.ColumnNames {
			dAtA[i] = 0x22
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.StoreColumnNames) > 0 {
		for _, s := range m.StoreColumnNames {
			dAtA[i] = 0x2a
			i++
			l = len(s)
			for l >= 1<<7 {
				dAtA[i] = uint8(uint64(l)&0x7f | 0x80)
				l >>= 7
				i++
			}
			dAtA[i] = uint8(l)
			i++
			i += copy(dAtA[i:], s)
		}
	}
	if len(m.ColumnIDs) > 0 {
		for _, num := range m.ColumnIDs {
			dAtA[i] = 0x30
			i++
			i = encodeVarintStructured(dAtA, i, uint64(num))
		}
	}
	if len(m.ExtraColumnIDs) > 0 {
		for _, num := range m.ExtraColumnIDs {
			dAtA[i] = 0x38
			i++
			i = encodeVarintStructured(dAtA, i, uint64(num))
		}
	}
	if len(m.ColumnDirections) > 0 {
		for _, num := range m.ColumnDirections {
			dAtA[i] = 0x40
			i++
			i = encodeVarintStructured(dAtA, i, uint64(num))
		}
	}
	dAtA[i] = 0x4a
	i++
	i = encodeVarintStructured(dAtA, i, uint64(m.ForeignKey.Size()))
	n2, err := m.ForeignKey.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n2
	if len(m.ReferencedBy) > 0 {
		for _, msg := range m.ReferencedBy {
			dAtA[i] = 0x52
			i++
			i = encodeVarintStructured(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x5a
	i++
	i = encodeVarintStructured(dAtA, i, uint64(m.Interleave.Size()))
	n3, err := m.Interleave.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n3
	if len(m.InterleavedBy) > 0 {
		for _, msg := range m.InterleavedBy {
			dAtA[i] = 0x62
			i++
			i = encodeVarintStructured(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.CompositeColumnIDs) > 0 {
		for _, num := range m.CompositeColumnIDs {
			dAtA[i] = 0x68
			i++
			i = encodeVarintStructured(dAtA, i, uint64(num))
		}
	}
	if len(m.StoreColumnIDs) > 0 {
		for _, num := range m.StoreColumnIDs {
			dAtA[i] = 0x70
			i++
			i = encodeVarintStructured(dAtA, i, uint64(num))
		}
	}
	return i, nil
}

func (m *DescriptorMutation) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DescriptorMutation) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Descriptor_ != nil {
		nn4, err := m.Descriptor_.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn4
	}
	dAtA[i] = 0x18
	i++
	i = encodeVarintStructured(dAtA, i, uint64(m.State))
	dAtA[i] = 0x20
	i++
	i = encodeVarintStructured(dAtA, i, uint64(m.Direction))
	dAtA[i] = 0x28
	i++
	i = encodeVarintStructured(dAtA, i, uint64(m.MutationID))
	if len(m.ResumeSpans) > 0 {
		for _, msg := range m.ResumeSpans {
			dAtA[i] = 0x32
			i++
			i = encodeVarintStructured(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *DescriptorMutation_Column) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Column != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStructured(dAtA, i, uint64(m.Column.Size()))
		n5, err := m.Column.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	return i, nil
}
func (m *DescriptorMutation_Index) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Index != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintStructured(dAtA, i, uint64(m.Index.Size()))
		n6, err := m.Index.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	return i, nil
}
func (m *TableDescriptor) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TableDescriptor) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintStructured(dAtA, i, uint64(len(m.Name)))
	i += copy(dAtA[i:], m.Name)
	dAtA[i] = 0x18
	i++
	i = encodeVarintStructured(dAtA, i, uint64(m.ID))
	dAtA[i] = 0x20
	i++
	i = encodeVarintStructured(dAtA, i, uint64(m.ParentID))
	dAtA[i] = 0x28
	i++
	i = encodeVarintStructured(dAtA, i, uint64(m.Version))
	dAtA[i] = 0x30
	i++
	if m.UpVersion {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	dAtA[i] = 0x3a
	i++
	i = encodeVarintStructured(dAtA, i, uint64(m.ModificationTime.Size()))
	n7, err := m.ModificationTime.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n7
	if len(m.Columns) > 0 {
		for _, msg := range m.Columns {
			dAtA[i] = 0x42
			i++
			i = encodeVarintStructured(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x48
	i++
	i = encodeVarintStructured(dAtA, i, uint64(m.NextColumnID))
	dAtA[i] = 0x52
	i++
	i = encodeVarintStructured(dAtA, i, uint64(m.PrimaryIndex.Size()))
	n8, err := m.PrimaryIndex.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n8
	if len(m.Indexes) > 0 {
		for _, msg := range m.Indexes {
			dAtA[i] = 0x5a
			i++
			i = encodeVarintStructured(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0x60
	i++
	i = encodeVarintStructured(dAtA, i, uint64(m.NextIndexID))
	if m.Privileges != nil {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintStructured(dAtA, i, uint64(m.Privileges.Size()))
		n9, err := m.Privileges.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n9
	}
	if len(m.Mutations) > 0 {
		for _, msg := range m.Mutations {
			dAtA[i] = 0x72
			i++
			i = encodeVarintStructured(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.Lease != nil {
		dAtA[i] = 0x7a
		i++
		i = encodeVarintStructured(dAtA, i, uint64(m.Lease.Size()))
		n10, err := m.Lease.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n10
	}
	dAtA[i] = 0x80
	i++
	dAtA[i] = 0x1
	i++
	i = encodeVarintStructured(dAtA, i, uint64(m.NextMutationID))
	dAtA[i] = 0x88
	i++
	dAtA[i] = 0x1
	i++
	i = encodeVarintStructured(dAtA, i, uint64(m.FormatVersion))
	dAtA[i] = 0x98
	i++
	dAtA[i] = 0x1
	i++
	i = encodeVarintStructured(dAtA, i, uint64(m.State))
	if len(m.Checks) > 0 {
		for _, msg := range m.Checks {
			dAtA[i] = 0xa2
			i++
			dAtA[i] = 0x1
			i++
			i = encodeVarintStructured(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Renames) > 0 {
		for _, msg := range m.Renames {
			dAtA[i] = 0xaa
			i++
			dAtA[i] = 0x1
			i++
			i = encodeVarintStructured(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.Families) > 0 {
		for _, msg := range m.Families {
			dAtA[i] = 0xb2
			i++
			dAtA[i] = 0x1
			i++
			i = encodeVarintStructured(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	dAtA[i] = 0xb8
	i++
	dAtA[i] = 0x1
	i++
	i = encodeVarintStructured(dAtA, i, uint64(m.NextFamilyID))
	dAtA[i] = 0xc2
	i++
	dAtA[i] = 0x1
	i++
	i = encodeVarintStructured(dAtA, i, uint64(len(m.ViewQuery)))
	i += copy(dAtA[i:], m.ViewQuery)
	if len(m.DependsOn) > 0 {
		for _, num := range m.DependsOn {
			dAtA[i] = 0xc8
			i++
			dAtA[i] = 0x1
			i++
			i = encodeVarintStructured(dAtA, i, uint64(num))
		}
	}
	if len(m.DependedOnBy) > 0 {
		for _, msg := range m.DependedOnBy {
			dAtA[i] = 0xd2
			i++
			dAtA[i] = 0x1
			i++
			i = encodeVarintStructured(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if len(m.MutationJobs) > 0 {
		for _, msg := range m.MutationJobs {
			dAtA[i] = 0xda
			i++
			dAtA[i] = 0x1
			i++
			i = encodeVarintStructured(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *TableDescriptor_SchemaChangeLease) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TableDescriptor_SchemaChangeLease) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintStructured(dAtA, i, uint64(m.NodeID))
	dAtA[i] = 0x10
	i++
	i = encodeVarintStructured(dAtA, i, uint64(m.ExpirationTime))
	return i, nil
}

func (m *TableDescriptor_CheckConstraint) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TableDescriptor_CheckConstraint) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintStructured(dAtA, i, uint64(len(m.Expr)))
	i += copy(dAtA[i:], m.Expr)
	dAtA[i] = 0x12
	i++
	i = encodeVarintStructured(dAtA, i, uint64(len(m.Name)))
	i += copy(dAtA[i:], m.Name)
	dAtA[i] = 0x18
	i++
	i = encodeVarintStructured(dAtA, i, uint64(m.Validity))
	return i, nil
}

func (m *TableDescriptor_RenameInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TableDescriptor_RenameInfo) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintStructured(dAtA, i, uint64(m.OldParentID))
	dAtA[i] = 0x12
	i++
	i = encodeVarintStructured(dAtA, i, uint64(len(m.OldName)))
	i += copy(dAtA[i:], m.OldName)
	return i, nil
}

func (m *TableDescriptor_Reference) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TableDescriptor_Reference) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintStructured(dAtA, i, uint64(m.ID))
	dAtA[i] = 0x10
	i++
	i = encodeVarintStructured(dAtA, i, uint64(m.IndexID))
	if len(m.ColumnIDs) > 0 {
		for _, num := range m.ColumnIDs {
			dAtA[i] = 0x18
			i++
			i = encodeVarintStructured(dAtA, i, uint64(num))
		}
	}
	return i, nil
}

func (m *TableDescriptor_MutationJob) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TableDescriptor_MutationJob) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintStructured(dAtA, i, uint64(m.MutationID))
	dAtA[i] = 0x10
	i++
	i = encodeVarintStructured(dAtA, i, uint64(m.JobID))
	return i, nil
}

func (m *DatabaseDescriptor) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *DatabaseDescriptor) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintStructured(dAtA, i, uint64(len(m.Name)))
	i += copy(dAtA[i:], m.Name)
	dAtA[i] = 0x10
	i++
	i = encodeVarintStructured(dAtA, i, uint64(m.ID))
	if m.Privileges != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintStructured(dAtA, i, uint64(m.Privileges.Size()))
		n11, err := m.Privileges.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	return i, nil
}

func (m *Descriptor) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Descriptor) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Union != nil {
		nn12, err := m.Union.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += nn12
	}
	return i, nil
}

func (m *Descriptor_Table) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Table != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintStructured(dAtA, i, uint64(m.Table.Size()))
		n13, err := m.Table.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n13
	}
	return i, nil
}
func (m *Descriptor_Database) MarshalTo(dAtA []byte) (int, error) {
	i := 0
	if m.Database != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintStructured(dAtA, i, uint64(m.Database.Size()))
		n14, err := m.Database.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n14
	}
	return i, nil
}
func encodeFixed64Structured(dAtA []byte, offset int, v uint64) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	dAtA[offset+4] = uint8(v >> 32)
	dAtA[offset+5] = uint8(v >> 40)
	dAtA[offset+6] = uint8(v >> 48)
	dAtA[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32Structured(dAtA []byte, offset int, v uint32) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintStructured(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *ColumnType) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovStructured(uint64(m.Kind))
	n += 1 + sovStructured(uint64(m.Width))
	n += 1 + sovStructured(uint64(m.Precision))
	if len(m.ArrayDimensions) > 0 {
		for _, e := range m.ArrayDimensions {
			n += 1 + sovStructured(uint64(e))
		}
	}
	if m.Locale != nil {
		l = len(*m.Locale)
		n += 1 + l + sovStructured(uint64(l))
	}
	return n
}

func (m *ForeignKeyReference) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovStructured(uint64(m.Table))
	n += 1 + sovStructured(uint64(m.Index))
	l = len(m.Name)
	n += 1 + l + sovStructured(uint64(l))
	n += 1 + sovStructured(uint64(m.Validity))
	n += 1 + sovStructured(uint64(m.SharedPrefixLen))
	return n
}

func (m *ColumnDescriptor) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	n += 1 + l + sovStructured(uint64(l))
	n += 1 + sovStructured(uint64(m.ID))
	l = m.Type.Size()
	n += 1 + l + sovStructured(uint64(l))
	n += 2
	if m.DefaultExpr != nil {
		l = len(*m.DefaultExpr)
		n += 1 + l + sovStructured(uint64(l))
	}
	n += 2
	return n
}

func (m *ColumnFamilyDescriptor) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	n += 1 + l + sovStructured(uint64(l))
	n += 1 + sovStructured(uint64(m.ID))
	if len(m.ColumnNames) > 0 {
		for _, s := range m.ColumnNames {
			l = len(s)
			n += 1 + l + sovStructured(uint64(l))
		}
	}
	if len(m.ColumnIDs) > 0 {
		for _, e := range m.ColumnIDs {
			n += 1 + sovStructured(uint64(e))
		}
	}
	n += 1 + sovStructured(uint64(m.DefaultColumnID))
	return n
}

func (m *InterleaveDescriptor) Size() (n int) {
	var l int
	_ = l
	if len(m.Ancestors) > 0 {
		for _, e := range m.Ancestors {
			l = e.Size()
			n += 1 + l + sovStructured(uint64(l))
		}
	}
	return n
}

func (m *InterleaveDescriptor_Ancestor) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovStructured(uint64(m.TableID))
	n += 1 + sovStructured(uint64(m.IndexID))
	n += 1 + sovStructured(uint64(m.SharedPrefixLen))
	return n
}

func (m *IndexDescriptor) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	n += 1 + l + sovStructured(uint64(l))
	n += 1 + sovStructured(uint64(m.ID))
	n += 2
	if len(m.ColumnNames) > 0 {
		for _, s := range m.ColumnNames {
			l = len(s)
			n += 1 + l + sovStructured(uint64(l))
		}
	}
	if len(m.StoreColumnNames) > 0 {
		for _, s := range m.StoreColumnNames {
			l = len(s)
			n += 1 + l + sovStructured(uint64(l))
		}
	}
	if len(m.ColumnIDs) > 0 {
		for _, e := range m.ColumnIDs {
			n += 1 + sovStructured(uint64(e))
		}
	}
	if len(m.ExtraColumnIDs) > 0 {
		for _, e := range m.ExtraColumnIDs {
			n += 1 + sovStructured(uint64(e))
		}
	}
	if len(m.ColumnDirections) > 0 {
		for _, e := range m.ColumnDirections {
			n += 1 + sovStructured(uint64(e))
		}
	}
	l = m.ForeignKey.Size()
	n += 1 + l + sovStructured(uint64(l))
	if len(m.ReferencedBy) > 0 {
		for _, e := range m.ReferencedBy {
			l = e.Size()
			n += 1 + l + sovStructured(uint64(l))
		}
	}
	l = m.Interleave.Size()
	n += 1 + l + sovStructured(uint64(l))
	if len(m.InterleavedBy) > 0 {
		for _, e := range m.InterleavedBy {
			l = e.Size()
			n += 1 + l + sovStructured(uint64(l))
		}
	}
	if len(m.CompositeColumnIDs) > 0 {
		for _, e := range m.CompositeColumnIDs {
			n += 1 + sovStructured(uint64(e))
		}
	}
	if len(m.StoreColumnIDs) > 0 {
		for _, e := range m.StoreColumnIDs {
			n += 1 + sovStructured(uint64(e))
		}
	}
	return n
}

func (m *DescriptorMutation) Size() (n int) {
	var l int
	_ = l
	if m.Descriptor_ != nil {
		n += m.Descriptor_.Size()
	}
	n += 1 + sovStructured(uint64(m.State))
	n += 1 + sovStructured(uint64(m.Direction))
	n += 1 + sovStructured(uint64(m.MutationID))
	if len(m.ResumeSpans) > 0 {
		for _, e := range m.ResumeSpans {
			l = e.Size()
			n += 1 + l + sovStructured(uint64(l))
		}
	}
	return n
}

func (m *DescriptorMutation_Column) Size() (n int) {
	var l int
	_ = l
	if m.Column != nil {
		l = m.Column.Size()
		n += 1 + l + sovStructured(uint64(l))
	}
	return n
}
func (m *DescriptorMutation_Index) Size() (n int) {
	var l int
	_ = l
	if m.Index != nil {
		l = m.Index.Size()
		n += 1 + l + sovStructured(uint64(l))
	}
	return n
}
func (m *TableDescriptor) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	n += 1 + l + sovStructured(uint64(l))
	n += 1 + sovStructured(uint64(m.ID))
	n += 1 + sovStructured(uint64(m.ParentID))
	n += 1 + sovStructured(uint64(m.Version))
	n += 2
	l = m.ModificationTime.Size()
	n += 1 + l + sovStructured(uint64(l))
	if len(m.Columns) > 0 {
		for _, e := range m.Columns {
			l = e.Size()
			n += 1 + l + sovStructured(uint64(l))
		}
	}
	n += 1 + sovStructured(uint64(m.NextColumnID))
	l = m.PrimaryIndex.Size()
	n += 1 + l + sovStructured(uint64(l))
	if len(m.Indexes) > 0 {
		for _, e := range m.Indexes {
			l = e.Size()
			n += 1 + l + sovStructured(uint64(l))
		}
	}
	n += 1 + sovStructured(uint64(m.NextIndexID))
	if m.Privileges != nil {
		l = m.Privileges.Size()
		n += 1 + l + sovStructured(uint64(l))
	}
	if len(m.Mutations) > 0 {
		for _, e := range m.Mutations {
			l = e.Size()
			n += 1 + l + sovStructured(uint64(l))
		}
	}
	if m.Lease != nil {
		l = m.Lease.Size()
		n += 1 + l + sovStructured(uint64(l))
	}
	n += 2 + sovStructured(uint64(m.NextMutationID))
	n += 2 + sovStructured(uint64(m.FormatVersion))
	n += 2 + sovStructured(uint64(m.State))
	if len(m.Checks) > 0 {
		for _, e := range m.Checks {
			l = e.Size()
			n += 2 + l + sovStructured(uint64(l))
		}
	}
	if len(m.Renames) > 0 {
		for _, e := range m.Renames {
			l = e.Size()
			n += 2 + l + sovStructured(uint64(l))
		}
	}
	if len(m.Families) > 0 {
		for _, e := range m.Families {
			l = e.Size()
			n += 2 + l + sovStructured(uint64(l))
		}
	}
	n += 2 + sovStructured(uint64(m.NextFamilyID))
	l = len(m.ViewQuery)
	n += 2 + l + sovStructured(uint64(l))
	if len(m.DependsOn) > 0 {
		for _, e := range m.DependsOn {
			n += 2 + sovStructured(uint64(e))
		}
	}
	if len(m.DependedOnBy) > 0 {
		for _, e := range m.DependedOnBy {
			l = e.Size()
			n += 2 + l + sovStructured(uint64(l))
		}
	}
	if len(m.MutationJobs) > 0 {
		for _, e := range m.MutationJobs {
			l = e.Size()
			n += 2 + l + sovStructured(uint64(l))
		}
	}
	return n
}

func (m *TableDescriptor_SchemaChangeLease) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovStructured(uint64(m.NodeID))
	n += 1 + sovStructured(uint64(m.ExpirationTime))
	return n
}

func (m *TableDescriptor_CheckConstraint) Size() (n int) {
	var l int
	_ = l
	l = len(m.Expr)
	n += 1 + l + sovStructured(uint64(l))
	l = len(m.Name)
	n += 1 + l + sovStructured(uint64(l))
	n += 1 + sovStructured(uint64(m.Validity))
	return n
}

func (m *TableDescriptor_RenameInfo) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovStructured(uint64(m.OldParentID))
	l = len(m.OldName)
	n += 1 + l + sovStructured(uint64(l))
	return n
}

func (m *TableDescriptor_Reference) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovStructured(uint64(m.ID))
	n += 1 + sovStructured(uint64(m.IndexID))
	if len(m.ColumnIDs) > 0 {
		for _, e := range m.ColumnIDs {
			n += 1 + sovStructured(uint64(e))
		}
	}
	return n
}

func (m *TableDescriptor_MutationJob) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovStructured(uint64(m.MutationID))
	n += 1 + sovStructured(uint64(m.JobID))
	return n
}

func (m *DatabaseDescriptor) Size() (n int) {
	var l int
	_ = l
	l = len(m.Name)
	n += 1 + l + sovStructured(uint64(l))
	n += 1 + sovStructured(uint64(m.ID))
	if m.Privileges != nil {
		l = m.Privileges.Size()
		n += 1 + l + sovStructured(uint64(l))
	}
	return n
}

func (m *Descriptor) Size() (n int) {
	var l int
	_ = l
	if m.Union != nil {
		n += m.Union.Size()
	}
	return n
}

func (m *Descriptor_Table) Size() (n int) {
	var l int
	_ = l
	if m.Table != nil {
		l = m.Table.Size()
		n += 1 + l + sovStructured(uint64(l))
	}
	return n
}
func (m *Descriptor_Database) Size() (n int) {
	var l int
	_ = l
	if m.Database != nil {
		l = m.Database.Size()
		n += 1 + l + sovStructured(uint64(l))
	}
	return n
}

func sovStructured(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozStructured(x uint64) (n int) {
	return sovStructured(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *ColumnType) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStructured
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ColumnType: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ColumnType: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Kind", wireType)
			}
			m.Kind = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Kind |= (ColumnType_Kind(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Width", wireType)
			}
			m.Width = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Width |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Precision", wireType)
			}
			m.Precision = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Precision |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType == 0 {
				var v int32
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStructured
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (int32(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.ArrayDimensions = append(m.ArrayDimensions, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStructured
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthStructured
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v int32
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowStructured
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (int32(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.ArrayDimensions = append(m.ArrayDimensions, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field ArrayDimensions", wireType)
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Locale", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStructured
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.Locale = &s
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStructured(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStructured
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ForeignKeyReference) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStructured
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ForeignKeyReference: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ForeignKeyReference: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Table", wireType)
			}
			m.Table = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Table |= (ID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Index", wireType)
			}
			m.Index = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Index |= (IndexID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStructured
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Validity", wireType)
			}
			m.Validity = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Validity |= (ConstraintValidity(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SharedPrefixLen", wireType)
			}
			m.SharedPrefixLen = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SharedPrefixLen |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipStructured(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStructured
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ColumnDescriptor) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStructured
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ColumnDescriptor: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ColumnDescriptor: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStructured
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			m.ID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ID |= (ColumnID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStructured
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Type.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Nullable", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Nullable = bool(v != 0)
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DefaultExpr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStructured
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(dAtA[iNdEx:postIndex])
			m.DefaultExpr = &s
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Hidden", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Hidden = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipStructured(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStructured
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ColumnFamilyDescriptor) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStructured
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ColumnFamilyDescriptor: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ColumnFamilyDescriptor: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStructured
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			m.ID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ID |= (FamilyID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ColumnNames", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStructured
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ColumnNames = append(m.ColumnNames, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 4:
			if wireType == 0 {
				var v ColumnID
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStructured
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (ColumnID(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.ColumnIDs = append(m.ColumnIDs, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStructured
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthStructured
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v ColumnID
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowStructured
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (ColumnID(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.ColumnIDs = append(m.ColumnIDs, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field ColumnIDs", wireType)
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field DefaultColumnID", wireType)
			}
			m.DefaultColumnID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.DefaultColumnID |= (ColumnID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipStructured(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStructured
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InterleaveDescriptor) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStructured
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: InterleaveDescriptor: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: InterleaveDescriptor: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Ancestors", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStructured
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Ancestors = append(m.Ancestors, InterleaveDescriptor_Ancestor{})
			if err := m.Ancestors[len(m.Ancestors)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStructured(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStructured
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *InterleaveDescriptor_Ancestor) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStructured
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Ancestor: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Ancestor: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TableID", wireType)
			}
			m.TableID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TableID |= (ID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IndexID", wireType)
			}
			m.IndexID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.IndexID |= (IndexID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field SharedPrefixLen", wireType)
			}
			m.SharedPrefixLen = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.SharedPrefixLen |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipStructured(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStructured
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *IndexDescriptor) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStructured
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: IndexDescriptor: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: IndexDescriptor: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStructured
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			m.ID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ID |= (IndexID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Unique", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Unique = bool(v != 0)
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ColumnNames", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStructured
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ColumnNames = append(m.ColumnNames, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StoreColumnNames", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStructured
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.StoreColumnNames = append(m.StoreColumnNames, string(dAtA[iNdEx:postIndex]))
			iNdEx = postIndex
		case 6:
			if wireType == 0 {
				var v ColumnID
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStructured
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (ColumnID(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.ColumnIDs = append(m.ColumnIDs, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStructured
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthStructured
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v ColumnID
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowStructured
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (ColumnID(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.ColumnIDs = append(m.ColumnIDs, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field ColumnIDs", wireType)
			}
		case 7:
			if wireType == 0 {
				var v ColumnID
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStructured
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (ColumnID(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.ExtraColumnIDs = append(m.ExtraColumnIDs, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStructured
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthStructured
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v ColumnID
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowStructured
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (ColumnID(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.ExtraColumnIDs = append(m.ExtraColumnIDs, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field ExtraColumnIDs", wireType)
			}
		case 8:
			if wireType == 0 {
				var v IndexDescriptor_Direction
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStructured
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (IndexDescriptor_Direction(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.ColumnDirections = append(m.ColumnDirections, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStructured
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthStructured
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v IndexDescriptor_Direction
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowStructured
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (IndexDescriptor_Direction(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.ColumnDirections = append(m.ColumnDirections, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field ColumnDirections", wireType)
			}
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ForeignKey", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStructured
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ForeignKey.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReferencedBy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStructured
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ReferencedBy = append(m.ReferencedBy, ForeignKeyReference{})
			if err := m.ReferencedBy[len(m.ReferencedBy)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Interleave", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStructured
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Interleave.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field InterleavedBy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStructured
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.InterleavedBy = append(m.InterleavedBy, ForeignKeyReference{})
			if err := m.InterleavedBy[len(m.InterleavedBy)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType == 0 {
				var v ColumnID
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStructured
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (ColumnID(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.CompositeColumnIDs = append(m.CompositeColumnIDs, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStructured
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthStructured
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v ColumnID
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowStructured
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (ColumnID(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.CompositeColumnIDs = append(m.CompositeColumnIDs, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field CompositeColumnIDs", wireType)
			}
		case 14:
			if wireType == 0 {
				var v ColumnID
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStructured
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (ColumnID(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.StoreColumnIDs = append(m.StoreColumnIDs, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStructured
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthStructured
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v ColumnID
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowStructured
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (ColumnID(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.StoreColumnIDs = append(m.StoreColumnIDs, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field StoreColumnIDs", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipStructured(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStructured
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DescriptorMutation) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStructured
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DescriptorMutation: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DescriptorMutation: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Column", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStructured
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ColumnDescriptor{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Descriptor_ = &DescriptorMutation_Column{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Index", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStructured
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &IndexDescriptor{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Descriptor_ = &DescriptorMutation_Index{v}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			m.State = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.State |= (DescriptorMutation_State(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Direction", wireType)
			}
			m.Direction = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Direction |= (DescriptorMutation_Direction(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MutationID", wireType)
			}
			m.MutationID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MutationID |= (MutationID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ResumeSpans", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStructured
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ResumeSpans = append(m.ResumeSpans, cockroach_roachpb1.Span{})
			if err := m.ResumeSpans[len(m.ResumeSpans)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStructured(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStructured
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TableDescriptor) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStructured
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TableDescriptor: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TableDescriptor: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStructured
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			m.ID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ID |= (ID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ParentID", wireType)
			}
			m.ParentID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ParentID |= (ID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Version", wireType)
			}
			m.Version = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Version |= (DescriptorVersion(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field UpVersion", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.UpVersion = bool(v != 0)
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ModificationTime", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStructured
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ModificationTime.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Columns", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStructured
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Columns = append(m.Columns, ColumnDescriptor{})
			if err := m.Columns[len(m.Columns)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextColumnID", wireType)
			}
			m.NextColumnID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NextColumnID |= (ColumnID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PrimaryIndex", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStructured
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.PrimaryIndex.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Indexes", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStructured
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Indexes = append(m.Indexes, IndexDescriptor{})
			if err := m.Indexes[len(m.Indexes)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextIndexID", wireType)
			}
			m.NextIndexID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NextIndexID |= (IndexID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Privileges", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStructured
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Privileges == nil {
				m.Privileges = &PrivilegeDescriptor{}
			}
			if err := m.Privileges.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Mutations", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStructured
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Mutations = append(m.Mutations, DescriptorMutation{})
			if err := m.Mutations[len(m.Mutations)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Lease", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStructured
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Lease == nil {
				m.Lease = &TableDescriptor_SchemaChangeLease{}
			}
			if err := m.Lease.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 16:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextMutationID", wireType)
			}
			m.NextMutationID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NextMutationID |= (MutationID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 17:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field FormatVersion", wireType)
			}
			m.FormatVersion = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.FormatVersion |= (FormatVersion(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 19:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field State", wireType)
			}
			m.State = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.State |= (TableDescriptor_State(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 20:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Checks", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStructured
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Checks = append(m.Checks, &TableDescriptor_CheckConstraint{})
			if err := m.Checks[len(m.Checks)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 21:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Renames", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStructured
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Renames = append(m.Renames, TableDescriptor_RenameInfo{})
			if err := m.Renames[len(m.Renames)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 22:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Families", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStructured
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Families = append(m.Families, ColumnFamilyDescriptor{})
			if err := m.Families[len(m.Families)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 23:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NextFamilyID", wireType)
			}
			m.NextFamilyID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NextFamilyID |= (FamilyID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 24:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ViewQuery", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStructured
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ViewQuery = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 25:
			if wireType == 0 {
				var v ID
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStructured
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (ID(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.DependsOn = append(m.DependsOn, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStructured
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthStructured
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v ID
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowStructured
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (ID(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.DependsOn = append(m.DependsOn, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field DependsOn", wireType)
			}
		case 26:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field DependedOnBy", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStructured
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.DependedOnBy = append(m.DependedOnBy, TableDescriptor_Reference{})
			if err := m.DependedOnBy[len(m.DependedOnBy)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 27:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MutationJobs", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStructured
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.MutationJobs = append(m.MutationJobs, TableDescriptor_MutationJob{})
			if err := m.MutationJobs[len(m.MutationJobs)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStructured(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStructured
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TableDescriptor_SchemaChangeLease) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStructured
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SchemaChangeLease: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SchemaChangeLease: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeID", wireType)
			}
			m.NodeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.NodeID |= (github_com_cockroachdb_cockroach_pkg_roachpb.NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExpirationTime", wireType)
			}
			m.ExpirationTime = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ExpirationTime |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipStructured(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStructured
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TableDescriptor_CheckConstraint) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStructured
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CheckConstraint: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CheckConstraint: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Expr", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStructured
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Expr = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStructured
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Validity", wireType)
			}
			m.Validity = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Validity |= (ConstraintValidity(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipStructured(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStructured
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TableDescriptor_RenameInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStructured
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RenameInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RenameInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field OldParentID", wireType)
			}
			m.OldParentID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.OldParentID |= (ID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OldName", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStructured
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.OldName = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStructured(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStructured
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TableDescriptor_Reference) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStructured
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Reference: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Reference: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			m.ID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ID |= (ID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field IndexID", wireType)
			}
			m.IndexID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.IndexID |= (IndexID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType == 0 {
				var v ColumnID
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStructured
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					v |= (ColumnID(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				m.ColumnIDs = append(m.ColumnIDs, v)
			} else if wireType == 2 {
				var packedLen int
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return ErrIntOverflowStructured
					}
					if iNdEx >= l {
						return io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					packedLen |= (int(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				if packedLen < 0 {
					return ErrInvalidLengthStructured
				}
				postIndex := iNdEx + packedLen
				if postIndex > l {
					return io.ErrUnexpectedEOF
				}
				for iNdEx < postIndex {
					var v ColumnID
					for shift := uint(0); ; shift += 7 {
						if shift >= 64 {
							return ErrIntOverflowStructured
						}
						if iNdEx >= l {
							return io.ErrUnexpectedEOF
						}
						b := dAtA[iNdEx]
						iNdEx++
						v |= (ColumnID(b) & 0x7F) << shift
						if b < 0x80 {
							break
						}
					}
					m.ColumnIDs = append(m.ColumnIDs, v)
				}
			} else {
				return fmt.Errorf("proto: wrong wireType = %d for field ColumnIDs", wireType)
			}
		default:
			iNdEx = preIndex
			skippy, err := skipStructured(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStructured
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TableDescriptor_MutationJob) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStructured
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MutationJob: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MutationJob: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field MutationID", wireType)
			}
			m.MutationID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.MutationID |= (MutationID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field JobID", wireType)
			}
			m.JobID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.JobID |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipStructured(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStructured
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *DatabaseDescriptor) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStructured
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: DatabaseDescriptor: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: DatabaseDescriptor: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Name", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthStructured
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Name = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			m.ID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ID |= (ID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Privileges", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStructured
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Privileges == nil {
				m.Privileges = &PrivilegeDescriptor{}
			}
			if err := m.Privileges.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStructured(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStructured
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Descriptor) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowStructured
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Descriptor: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Descriptor: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Table", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStructured
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &TableDescriptor{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Union = &Descriptor_Table{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Database", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthStructured
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &DatabaseDescriptor{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Union = &Descriptor_Database{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipStructured(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthStructured
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipStructured(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowStructured
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowStructured
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthStructured
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowStructured
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipStructured(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthStructured = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowStructured   = fmt.Errorf("proto: integer overflow")
)

func init() {
	proto.RegisterFile("cockroach/pkg/sql/sqlbase/structured.proto", fileDescriptorStructured)
}

var fileDescriptorStructured = []byte{
	// 2277 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x58, 0xdb, 0x6f, 0xdb, 0xd6,
	0x19, 0x37, 0x75, 0xd7, 0xa7, 0x1b, 0x7d, 0x72, 0x29, 0xeb, 0x75, 0xb6, 0xa2, 0xb6, 0x99, 0x9b,
	0xb5, 0x72, 0xea, 0xb4, 0x43, 0xb1, 0x4b, 0x51, 0xdd, 0x9c, 0xd0, 0x91, 0x25, 0x87, 0x96, 0x93,
	0xa5, 0xd8, 0x26, 0xd0, 0x3a, 0xc7, 0x36, 0x13, 0x8a, 0x54, 0x48, 0xca, 0xb5, 0xfe, 0x81, 0xa1,
	0x8f, 0xc3, 0xfe, 0x80, 0x62, 0xe8, 0xeb, 0x1e, 0x86, 0x01, 0x7b, 0x18, 0xf6, 0x17, 0xe4, 0x71,
	0x8f, 0x03, 0x06, 0x18, 0x9b, 0xf7, 0x47, 0x0c, 0xc8, 0xd3, 0x70, 0x0e, 0xcf, 0x21, 0x29, 0x4b,
	0xca, 0xec, 0xe4, 0x41, 0x80, 0xf8, 0x5d, 0x7e, 0xfc, 0xce, 0x77, 0xbe, 0x2b, 0xe1, 0xce, 0xc0,
	0x1e, 0x3c, 0x77, 0x6c, 0x7d, 0x70, 0xbc, 0x31, 0x7a, 0x7e, 0xb4, 0xe1, 0xbe, 0x30, 0xe9, 0xef,
	0x40, 0x77, 0xc9, 0x86, 0xeb, 0x39, 0xe3, 0x81, 0x37, 0x76, 0x08, 0xae, 0x8e, 0x1c, 0xdb, 0xb3,
	0xd1, 0x8d, 0x40, 0xb6, 0xea, 0xbe, 0x30, 0xab, 0x5c, 0x6e, 0xa5, 0x3c, 0x0d, 0xc1, 0xfe, 0x8d,
	0x0e, 0x36, 0xb0, 0xee, 0xe9, 0xbe, 0xe2, 0xca, 0xed, 0x69, 0x89, 0xb1, 0x67, 0x98, 0x1b, 0xc7,
	0xe6, 0x60, 0xc3, 0x33, 0x86, 0xc4, 0xf5, 0xf4, 0xe1, 0x88, 0xcb, 0x7d, 0xb4, 0xd8, 0x98, 0x91,
	0x63, 0x9c, 0x18, 0x26, 0x39, 0x22, 0x5c, 0xf4, 0xfa, 0x91, 0x7d, 0x64, 0xb3, 0xbf, 0x1b, 0xf4,
	0x9f, 0x4f, 0xad, 0xfc, 0x29, 0x0e, 0xd0, 0xb0, 0xcd, 0xf1, 0xd0, 0xea, 0x4d, 0x46, 0x04, 0x7d,
	0x05, 0x89, 0xe7, 0x86, 0x85, 0x15, 0xa9, 0x2c, 0xad, 0x17, 0x37, 0x6f, 0x57, 0xe7, 0xda, 0x5f,
	0x0d, 0x15, 0xaa, 0x0f, 0x0d, 0x0b, 0xd7, 0x13, 0x2f, 0xcf, 0xd6, 0x96, 0x34, 0xa6, 0x89, 0x56,
	0x20, 0xf9, 0x8d, 0x81, 0xbd, 0x63, 0x25, 0x56, 0x96, 0xd6, 0x93, 0x9c, 0xe5, 0x93, 0x50, 0x05,
	0xb2, 0x23, 0x87, 0x0c, 0x0c, 0xd7, 0xb0, 0x2d, 0x25, 0x1e, 0xe1, 0x87, 0x64, 0xf4, 0x11, 0xc8,
	0xba, 0xe3, 0xe8, 0x93, 0x3e, 0x36, 0x86, 0xc4, 0xa2, 0x24, 0x57, 0x49, 0x94, 0xe3, 0xeb, 0x49,
	0xad, 0xc4, 0xe8, 0xcd, 0x80, 0x8c, 0x6e, 0x42, 0xca, 0xb4, 0x07, 0xba, 0x49, 0x94, 0x64, 0x59,
	0x5a, 0xcf, 0x6a, 0xfc, 0xa9, 0xf2, 0x4f, 0x09, 0x12, 0xd4, 0x2e, 0x94, 0x81, 0x44, 0xbd, 0xdb,
	0x6d, 0xcb, 0x4b, 0x28, 0x0d, 0x71, 0xb5, 0xd3, 0x93, 0x25, 0x94, 0x85, 0xe4, 0x56, 0xbb, 0x5b,
	0xeb, 0xc9, 0x31, 0x94, 0x83, 0x74, 0xb3, 0xd5, 0x50, 0x77, 0x6a, 0x6d, 0x39, 0x4e, 0x45, 0x9b,
	0xb5, 0x5e, 0x4b, 0x4e, 0xa0, 0x02, 0x64, 0x7b, 0xea, 0x4e, 0x6b, 0xaf, 0x57, 0xdb, 0xd9, 0x95,
	0x93, 0x28, 0x0f, 0x19, 0xb5, 0xd3, 0x6b, 0x69, 0x8f, 0x6b, 0x6d, 0x39, 0x85, 0x00, 0x52, 0x7b,
	0x3d, 0x4d, 0xed, 0xdc, 0x97, 0xd3, 0x14, 0xaa, 0xfe, 0xb4, 0xd7, 0xda, 0x93, 0x33, 0xa8, 0x04,
	0xb9, 0x40, 0xa7, 0xf7, 0xb5, 0x9c, 0x45, 0x08, 0x8a, 0x8d, 0x6e, 0xbb, 0x5d, 0xeb, 0xb5, 0x9a,
	0x5c, 0x1e, 0xe8, 0x2b, 0x3a, 0xb5, 0x9d, 0x96, 0x9c, 0xa3, 0xd6, 0x74, 0xd5, 0xa6, 0x9c, 0x67,
	0xa4, 0xfd, 0x76, 0x5b, 0x2e, 0xd0, 0x7f, 0xfb, 0xfb, 0x6a, 0x53, 0x2e, 0xd2, 0xf7, 0xab, 0x9d,
	0x5e, 0xbf, 0xa6, 0x69, 0xb5, 0xa7, 0x32, 0x46, 0x25, 0x00, 0xb5, 0xd3, 0xdb, 0x7c, 0xdc, 0x6a,
	0xf4, 0xba, 0x9a, 0xfc, 0x52, 0xaa, 0xfc, 0x57, 0x82, 0x6b, 0x5b, 0xb6, 0x43, 0x8c, 0x23, 0xeb,
	0x21, 0x99, 0x68, 0xe4, 0x90, 0x38, 0xc4, 0x1a, 0x10, 0x54, 0x86, 0xa4, 0xa7, 0x1f, 0x98, 0x84,
	0xdd, 0x5d, 0xa1, 0x0e, 0xd4, 0xb1, 0xaf, 0xce, 0xd6, 0x62, 0x6a, 0x53, 0xf3, 0x19, 0xe8, 0x43,
	0x48, 0x1a, 0x16, 0x26, 0xa7, 0xec, 0x6a, 0x0a, 0xf5, 0x12, 0x97, 0x48, 0xab, 0x94, 0x48, 0xc5,
	0x18, 0x17, 0x29, 0x90, 0xb0, 0xf4, 0x21, 0x61, 0x17, 0x94, 0x15, 0x77, 0x4b, 0x29, 0xe8, 0x21,
	0x64, 0x4e, 0x74, 0xd3, 0xc0, 0x86, 0x37, 0x51, 0x12, 0x2c, 0x42, 0x3e, 0x5a, 0x18, 0x21, 0x96,
	0xeb, 0x39, 0xba, 0x61, 0x79, 0x8f, 0xb9, 0x02, 0x07, 0x0a, 0x00, 0xd0, 0x5d, 0x58, 0x76, 0x8f,
	0x75, 0x87, 0xe0, 0xfe, 0xc8, 0x21, 0x87, 0xc6, 0x69, 0xdf, 0x24, 0x16, 0xbb, 0x48, 0x11, 0x14,
	0x25, 0x9f, 0xbd, 0xcb, 0xb8, 0x6d, 0x62, 0x55, 0x7e, 0x1b, 0x03, 0xd9, 0x0f, 0xbd, 0x26, 0x71,
	0x07, 0x8e, 0x31, 0xf2, 0x6c, 0x27, 0xb0, 0x56, 0x9a, 0xb1, 0xf6, 0x36, 0xc4, 0x0c, 0xcc, 0xcf,
	0x7a, 0x93, 0xd2, 0xcf, 0x99, 0x37, 0x5e, 0x9d, 0xad, 0x65, 0x7c, 0x14, 0xb5, 0xa9, 0xc5, 0x0c,
	0x8c, 0x7e, 0x06, 0x09, 0x6f, 0x32, 0xf2, 0xcf, 0x9b, 0xdb, 0xbc, 0xf5, 0x7f, 0x63, 0x5e, 0xbc,
	0x84, 0x2a, 0xa1, 0x32, 0x64, 0xac, 0xb1, 0x69, 0x32, 0xc7, 0x53, 0x97, 0x64, 0xc4, 0x39, 0x05,
	0x15, 0xdd, 0x82, 0x3c, 0x26, 0x87, 0xfa, 0xd8, 0xf4, 0xfa, 0xe4, 0x74, 0xe4, 0xf0, 0x58, 0xcd,
	0x71, 0x5a, 0xeb, 0x74, 0xe4, 0xa0, 0xf7, 0x20, 0x75, 0x6c, 0x60, 0x4c, 0x2c, 0x25, 0x15, 0x81,
	0xe0, 0xb4, 0xed, 0x44, 0x26, 0x23, 0x67, 0xb7, 0x13, 0x99, 0xac, 0x0c, 0xdb, 0x89, 0x4c, 0x5a,
	0xce, 0x54, 0xbe, 0x8d, 0xc1, 0x4d, 0xdf, 0x9e, 0x2d, 0x7d, 0x68, 0x98, 0x93, 0xb7, 0x75, 0x87,
	0x8f, 0xc2, 0xdd, 0x71, 0x0b, 0xf2, 0x03, 0x86, 0xdd, 0xa7, 0x6a, 0xae, 0x12, 0x2f, 0xc7, 0xa9,
	0xbd, 0x3e, 0xad, 0x43, 0x49, 0xe8, 0x0b, 0x00, 0x2e, 0x62, 0x60, 0x3f, 0x3b, 0x0b, 0xf5, 0x77,
	0xcf, 0xcf, 0xd6, 0xb2, 0xc2, 0xaf, 0xee, 0x94, 0x93, 0xb3, 0xbe, 0xb0, 0x8a, 0x5d, 0xd4, 0x85,
	0x65, 0xe1, 0x8c, 0x00, 0x81, 0x79, 0xa4, 0x50, 0x7f, 0x9f, 0xdb, 0x54, 0x6a, 0xfa, 0x02, 0x42,
	0x7d, 0x0a, 0xaa, 0x84, 0xa7, 0x98, 0xb8, 0xf2, 0xc7, 0x18, 0x5c, 0x57, 0x2d, 0x8f, 0x38, 0x26,
	0xd1, 0x4f, 0x48, 0xc4, 0x11, 0xbf, 0x84, 0xac, 0x6e, 0x0d, 0x88, 0xeb, 0xd9, 0x8e, 0xab, 0x48,
	0xe5, 0xf8, 0x7a, 0x6e, 0xf3, 0xb3, 0x05, 0x57, 0x3b, 0x4f, 0xbf, 0x5a, 0xe3, 0xca, 0xa2, 0x42,
	0x05, 0x60, 0x2b, 0x7f, 0x95, 0x20, 0x23, 0xb8, 0xe8, 0x2e, 0x64, 0x58, 0x72, 0xd1, 0x73, 0xf8,
	0x89, 0x77, 0x83, 0x9f, 0x23, 0xdd, 0xa3, 0x74, 0x66, 0x3f, 0xcd, 0xc1, 0x34, 0x13, 0x53, 0x31,
	0xfa, 0x1c, 0x32, 0x2c, 0xcf, 0xfa, 0xc1, 0x6d, 0xac, 0x08, 0x0d, 0x9e, 0x88, 0xd1, 0x9c, 0x4c,
	0x33, 0x59, 0x15, 0xa3, 0xc6, 0xbc, 0x74, 0x89, 0x33, 0xfd, 0x77, 0x84, 0xe7, 0xf6, 0xa6, 0x13,
	0x66, 0x36, 0x83, 0xfe, 0x96, 0x86, 0x12, 0x43, 0xbe, 0x54, 0xc4, 0x7c, 0x18, 0x89, 0x98, 0x1b,
	0x53, 0x11, 0x13, 0x98, 0x47, 0x03, 0xe6, 0x3d, 0x48, 0x8d, 0x2d, 0xe3, 0xc5, 0xd8, 0xcf, 0xa0,
	0x20, 0x7a, 0x7d, 0xda, 0x4c, 0x38, 0x25, 0x66, 0xc3, 0xe9, 0x63, 0x40, 0xd4, 0x97, 0xa4, 0x3f,
	0x25, 0x98, 0x64, 0x82, 0x32, 0xe3, 0x34, 0x16, 0x06, 0x5f, 0xea, 0x0a, 0xc1, 0xf7, 0x00, 0x64,
	0x72, 0xea, 0x39, 0x7a, 0x3f, 0xa2, 0x9f, 0x66, 0xfa, 0xab, 0xe7, 0x67, 0x6b, 0xc5, 0x16, 0xe5,
	0xcd, 0x07, 0x29, 0x92, 0x08, 0x0f, 0xbb, 0xe8, 0xd7, 0xb0, 0xcc, 0x31, 0xb0, 0xe1, 0x90, 0x81,
	0xc7, 0xba, 0x54, 0xa6, 0x1c, 0x5f, 0x2f, 0x6e, 0xde, 0x5d, 0x18, 0x64, 0x53, 0x6e, 0xaf, 0x36,
	0x85, 0xa2, 0x26, 0xfb, 0x50, 0x01, 0xc1, 0x45, 0x8f, 0x20, 0x77, 0xe8, 0x57, 0xf8, 0xfe, 0x73,
	0x32, 0x51, 0xb2, 0xac, 0x30, 0xdd, 0x59, 0x00, 0x3c, 0xa7, 0x17, 0xf0, 0x2b, 0x80, 0xc3, 0x80,
	0x85, 0xf6, 0xa1, 0xe0, 0x08, 0x36, 0xee, 0x1f, 0x4c, 0x14, 0x60, 0x29, 0x71, 0x75, 0xd0, 0x7c,
	0x08, 0x53, 0x9f, 0xa0, 0x47, 0x00, 0x46, 0x90, 0x3d, 0x4a, 0x8e, 0x19, 0xfa, 0xe3, 0x2b, 0xa4,
	0x99, 0xb0, 0x34, 0x04, 0x41, 0x4f, 0xa0, 0x18, 0x3e, 0x31, 0x53, 0xf3, 0x6f, 0x68, 0x6a, 0x21,
	0x82, 0x53, 0x9f, 0xa0, 0x1e, 0x5c, 0x1f, 0xd8, 0xc3, 0x91, 0xed, 0x1a, 0x1e, 0x89, 0x86, 0x40,
	0x81, 0x85, 0x40, 0xe5, 0xfc, 0x6c, 0x0d, 0x35, 0x04, 0x7f, 0x7e, 0x18, 0xa0, 0xc1, 0x05, 0xbe,
	0x1f, 0x54, 0x53, 0xc1, 0x4b, 0x11, 0x8b, 0x61, 0x50, 0xed, 0x85, 0xe1, 0x3b, 0x13, 0x54, 0x91,
	0xd0, 0x56, 0xb1, 0x5b, 0x59, 0x85, 0x6c, 0x10, 0x03, 0x74, 0x44, 0xa8, 0xed, 0x35, 0xe4, 0x25,
	0x36, 0x98, 0xb4, 0xf6, 0x1a, 0xb2, 0x54, 0xf9, 0x73, 0x02, 0x50, 0xe8, 0xb9, 0x9d, 0xb1, 0xa7,
	0x33, 0xc9, 0x1a, 0xa4, 0xfc, 0x57, 0xb3, 0x0c, 0xce, 0x6d, 0xfe, 0xe8, 0xb5, 0x0d, 0x2c, 0x04,
	0x78, 0xb0, 0xa4, 0x71, 0x45, 0xf4, 0x65, 0x74, 0x30, 0xc8, 0x2d, 0x1c, 0xfb, 0x2e, 0x84, 0xf0,
	0x83, 0x25, 0x31, 0x31, 0x3c, 0x84, 0xa4, 0xeb, 0xe9, 0x9e, 0x5f, 0x00, 0x8a, 0x9b, 0x1b, 0x0b,
	0xf4, 0x67, 0x8d, 0xaf, 0xee, 0x51, 0x35, 0x31, 0x24, 0x32, 0x0c, 0xf4, 0x04, 0xb2, 0x41, 0x52,
	0xf1, 0x29, 0xe3, 0xde, 0xe5, 0x01, 0x03, 0x0f, 0x8a, 0xba, 0x1d, 0x60, 0xa1, 0x1a, 0xe4, 0x86,
	0x5c, 0x2c, 0xec, 0x3a, 0x65, 0x5e, 0xd7, 0x40, 0x20, 0xb0, 0xfa, 0x16, 0x79, 0xd2, 0x40, 0x28,
	0xa9, 0x18, 0x7d, 0x05, 0x79, 0x87, 0xb8, 0xe3, 0x21, 0xe9, 0xbb, 0x23, 0xdd, 0xf2, 0xab, 0x4f,
	0x6e, 0xf3, 0x9d, 0x88, 0x79, 0x7c, 0x96, 0xaf, 0xee, 0x8d, 0x74, 0x61, 0x42, 0xce, 0x57, 0xa1,
	0x14, 0xb7, 0xf2, 0x39, 0x24, 0xd9, 0x99, 0xe9, 0xf4, 0xb9, 0xdf, 0x79, 0xd8, 0xe9, 0x3e, 0xe9,
	0xc8, 0x4b, 0x74, 0x7e, 0x6c, 0xb6, 0xda, 0xad, 0x5e, 0xab, 0xdf, 0xed, 0xb4, 0x9f, 0xca, 0x12,
	0x2a, 0x02, 0x3c, 0xd1, 0x54, 0xf1, 0x1c, 0xab, 0xac, 0x47, 0x63, 0x83, 0x4e, 0x8d, 0xdd, 0x4e,
	0xcb, 0x1f, 0x6b, 0x6b, 0xcd, 0xa6, 0x2c, 0xb1, 0x28, 0xd1, 0xba, 0xbb, 0x72, 0xac, 0x9e, 0x07,
	0xc0, 0x81, 0x5b, 0x2a, 0x7f, 0xb9, 0x06, 0x25, 0xd6, 0x87, 0x2e, 0x55, 0xf0, 0xcb, 0xac, 0xe0,
	0xfb, 0x4d, 0x45, 0x9e, 0x2a, 0xf8, 0x31, 0x5e, 0xeb, 0xef, 0x41, 0x76, 0xa4, 0x3b, 0xc4, 0xf2,
	0xa8, 0x07, 0x13, 0x53, 0xb3, 0x44, 0x66, 0x97, 0x31, 0x02, 0xf1, 0x8c, 0x2f, 0xa8, 0x52, 0xa5,
	0xf4, 0x09, 0x71, 0xd8, 0xd0, 0xef, 0x3b, 0xfd, 0x5d, 0x3e, 0x79, 0x2e, 0x87, 0x56, 0x3d, 0xf6,
	0x05, 0x34, 0x21, 0x89, 0xde, 0x07, 0x18, 0x8f, 0xfa, 0x42, 0x2f, 0x3a, 0x17, 0x65, 0xc7, 0x23,
	0x2e, 0x8d, 0x76, 0x61, 0x79, 0x68, 0x63, 0xe3, 0xd0, 0x18, 0xf8, 0xd7, 0x4a, 0xd7, 0x23, 0x25,
	0xcd, 0x82, 0xf8, 0x87, 0x91, 0x4b, 0xa1, 0xeb, 0x53, 0xf5, 0xd8, 0x1c, 0x54, 0x7b, 0x62, 0x7d,
	0xe2, 0x50, 0x72, 0x54, 0x9b, 0x32, 0xd1, 0x7d, 0x48, 0xfb, 0x49, 0xe1, 0xd7, 0xf3, 0xcb, 0xa7,
	0x13, 0x47, 0x14, 0xda, 0x68, 0x0b, 0x8a, 0x16, 0x39, 0x8d, 0x8e, 0x39, 0xd9, 0xa9, 0x80, 0xcb,
	0x77, 0xc8, 0xe9, 0xfc, 0x19, 0x27, 0x6f, 0x85, 0x1c, 0x8c, 0x1e, 0x41, 0x61, 0xe4, 0x18, 0x43,
	0xdd, 0x99, 0xf4, 0xfd, 0x1c, 0x85, 0xab, 0xe4, 0xa8, 0x28, 0xda, 0x1c, 0x82, 0x71, 0xd1, 0x16,
	0xf8, 0x53, 0x05, 0x71, 0x95, 0x1c, 0x3b, 0xe3, 0xd5, 0xc0, 0x84, 0x32, 0xaa, 0x43, 0x81, 0x1d,
	0x31, 0x18, 0x67, 0xf2, 0xec, 0x84, 0xab, 0xfc, 0x84, 0x39, 0x7a, 0xc2, 0x39, 0x23, 0x4d, 0xce,
	0x0a, 0xe8, 0x18, 0x6d, 0x03, 0x04, 0x8b, 0x2a, 0x2d, 0xc5, 0xaf, 0xeb, 0x74, 0xbb, 0x42, 0x30,
	0x34, 0x49, 0x8b, 0x68, 0xa3, 0x1d, 0xc8, 0x8a, 0x5c, 0xf5, 0x6b, 0x70, 0x6e, 0xe1, 0x7e, 0x32,
	0x5b, 0x39, 0x44, 0x70, 0x05, 0x08, 0xa8, 0x03, 0x49, 0x93, 0xe8, 0x2e, 0x51, 0x4a, 0xcc, 0xaa,
	0x2f, 0x16, 0x40, 0x5d, 0x48, 0xaf, 0xea, 0xde, 0xe0, 0x98, 0x0c, 0xf5, 0xc6, 0xb1, 0x6e, 0x1d,
	0x91, 0x36, 0xd5, 0xd7, 0x7c, 0x18, 0xd4, 0x01, 0x99, 0xb9, 0x2b, 0x5a, 0x84, 0x64, 0xe6, 0xb1,
	0x0f, 0xb8, 0xc7, 0x8a, 0xd4, 0x63, 0x0b, 0x0b, 0x11, 0x8b, 0xa7, 0x9d, 0xb0, 0x18, 0xfd, 0x1c,
	0x8a, 0x87, 0xb6, 0x33, 0xd4, 0xbd, 0x20, 0x4b, 0x96, 0xc3, 0x51, 0xed, 0xd5, 0xd9, 0x5a, 0x61,
	0x8b, 0x71, 0x45, 0x66, 0x15, 0x0e, 0xa3, 0x8f, 0xe8, 0x81, 0xa8, 0xd9, 0xd7, 0x58, 0x89, 0xfd,
	0xf8, 0xb2, 0xa7, 0x9b, 0x2d, 0xd8, 0x1d, 0x48, 0x0d, 0x8e, 0xc9, 0xe0, 0xb9, 0xab, 0x5c, 0x67,
	0x3e, 0xff, 0xc9, 0x25, 0xa1, 0x1a, 0x54, 0x29, 0x5c, 0x14, 0x35, 0x8e, 0x82, 0x1e, 0x41, 0xda,
	0x21, 0xfe, 0x0c, 0x78, 0x83, 0x01, 0x7e, 0x7a, 0x49, 0x40, 0x8d, 0x69, 0xa9, 0xd6, 0xa1, 0x2d,
	0x22, 0x95, 0xe3, 0xa0, 0x2e, 0x64, 0x0e, 0xe9, 0x8e, 0x63, 0x10, 0x57, 0xb9, 0xc9, 0x30, 0x3f,
	0x79, 0x6d, 0x5a, 0x5f, 0x5c, 0xab, 0xc4, 0x52, 0x27, 0x40, 0x82, 0xec, 0x66, 0x84, 0x09, 0xbd,
	0xc9, 0x77, 0x66, 0xb3, 0x5b, 0xac, 0x55, 0x53, 0x2b, 0x16, 0xcb, 0x6e, 0xfe, 0x84, 0x69, 0x95,
	0x3b, 0x31, 0xc8, 0x37, 0xfd, 0x17, 0x63, 0xe2, 0x4c, 0x14, 0x25, 0x52, 0x91, 0xb3, 0x94, 0xfe,
	0x88, 0x92, 0xd1, 0xa7, 0x90, 0xc5, 0x64, 0x44, 0x2c, 0xec, 0x76, 0x2d, 0xe5, 0x5d, 0x36, 0x5b,
	0x5c, 0xa3, 0x03, 0x6f, 0x53, 0x10, 0x79, 0xc5, 0x0d, 0xa5, 0xd0, 0x33, 0xba, 0x74, 0xd2, 0x07,
	0x82, 0xbb, 0x56, 0x7d, 0xa2, 0xac, 0xb0, 0x43, 0xdf, 0xbd, 0xb4, 0x23, 0xc5, 0x20, 0x75, 0x5d,
	0x9c, 0xa7, 0x19, 0x41, 0xd3, 0xa6, 0xb0, 0xd1, 0xaf, 0x20, 0x2f, 0x42, 0x7a, 0xdb, 0x3e, 0x70,
	0x95, 0x1f, 0xb0, 0x77, 0x6d, 0x5e, 0xf2, 0x5d, 0x3b, 0xa1, 0xaa, 0x28, 0x56, 0x51, 0xb4, 0x95,
	0xef, 0x25, 0x58, 0x9e, 0x49, 0x29, 0xf4, 0x1b, 0x48, 0x5b, 0x36, 0x8e, 0x6c, 0x5d, 0x2d, 0x6e,
	0x68, 0xaa, 0x63, 0x63, 0x7f, 0xe9, 0xba, 0x77, 0x64, 0x78, 0xc7, 0xe3, 0x83, 0xea, 0xc0, 0x1e,
	0x6e, 0x04, 0xa6, 0xe0, 0x83, 0x8d, 0xb9, 0xdf, 0xde, 0xaa, 0xbe, 0x9a, 0x96, 0xa2, 0xa8, 0x2a,
	0x46, 0x9f, 0x40, 0x89, 0x9c, 0x8e, 0x0c, 0x27, 0xd2, 0x56, 0xe8, 0x6c, 0x14, 0xe7, 0x26, 0x16,
	0x43, 0x26, 0xed, 0x1a, 0x2b, 0xbf, 0x97, 0xa0, 0x74, 0x21, 0x9c, 0x69, 0x9b, 0x65, 0xfb, 0xfe,
	0x54, 0x9b, 0xa5, 0x94, 0xa0, 0x01, 0xc7, 0x5e, 0xfb, 0x81, 0x25, 0xfe, 0x96, 0x1f, 0x58, 0x56,
	0x4c, 0x80, 0x30, 0x23, 0xd0, 0x2f, 0xa0, 0x60, 0x9b, 0xb8, 0x1f, 0x76, 0x6f, 0x29, 0x6c, 0xc5,
	0xb4, 0x58, 0x77, 0x4d, 0x7c, 0xa1, 0x81, 0xe7, 0xec, 0x80, 0x84, 0xd1, 0x1a, 0x64, 0xa8, 0xfa,
	0x8c, 0xdd, 0x69, 0xdb, 0xc4, 0x74, 0x2f, 0x5b, 0xf9, 0x4e, 0x82, 0x6c, 0xf4, 0x63, 0x54, 0x2c,
	0x78, 0xc5, 0xfc, 0x49, 0xe2, 0x0d, 0xd7, 0xe0, 0xe9, 0xed, 0x2f, 0x7e, 0xf9, 0xed, 0x6f, 0xe5,
	0x04, 0x72, 0x91, 0x58, 0xbb, 0x38, 0x0d, 0x4a, 0x6f, 0x30, 0x0d, 0x7e, 0x00, 0xa9, 0x67, 0xf6,
	0x81, 0x38, 0x40, 0xbc, 0x5e, 0xe0, 0xda, 0xc9, 0x6d, 0xfb, 0x40, 0x6d, 0x6a, 0xc9, 0x67, 0xf6,
	0x81, 0x8a, 0x2b, 0xb7, 0xc5, 0xc4, 0x07, 0x90, 0xda, 0xdd, 0xaf, 0xb7, 0xd5, 0xc6, 0xdc, 0xc1,
	0xed, 0xa7, 0x89, 0x6f, 0xff, 0xb0, 0x26, 0x6d, 0x27, 0x32, 0x48, 0xbe, 0x56, 0xf9, 0x5e, 0x02,
	0xd4, 0xd4, 0x3d, 0x9d, 0x5e, 0xf5, 0x15, 0x26, 0xb7, 0xd8, 0x6b, 0xfc, 0x3d, 0xdd, 0x68, 0xe3,
	0x6f, 0xd3, 0x68, 0x7d, 0x53, 0x2b, 0xdf, 0x49, 0x00, 0x11, 0xe3, 0xbe, 0x8c, 0x7e, 0x7f, 0x5c,
	0x3c, 0x53, 0x5c, 0xc8, 0x7f, 0xba, 0x44, 0xf8, 0x5f, 0x27, 0xef, 0x43, 0x06, 0xf3, 0x23, 0xf3,
	0x3d, 0x64, 0x61, 0xf3, 0x9e, 0xf1, 0xcc, 0x83, 0x25, 0x2d, 0x50, 0xae, 0xa7, 0x21, 0x39, 0xb6,
	0x0c, 0xdb, 0xba, 0xf3, 0x19, 0xa0, 0xd9, 0x34, 0x41, 0x05, 0xc8, 0xb2, 0xff, 0xba, 0x47, 0xb0,
	0x3f, 0x7a, 0xef, 0x5b, 0x27, 0x01, 0x41, 0xaa, 0xdf, 0x7a, 0xf9, 0xef, 0xd5, 0xa5, 0x97, 0xe7,
	0xab, 0xd2, 0xdf, 0xcf, 0x57, 0xa5, 0x7f, 0x9c, 0xaf, 0x4a, 0xff, 0x3a, 0x5f, 0x95, 0x7e, 0xf7,
	0x9f, 0xd5, 0xa5, 0xaf, 0xd3, 0xdc, 0x80, 0xff, 0x05, 0x00, 0x00, 0xff, 0xff, 0xd5, 0x28, 0xfc,
	0x9a, 0x03, 0x18, 0x00, 0x00,
}
