// Code generated by protoc-gen-gogo.
// source: cockroach/pkg/storage/engine/enginepb/mvcc.proto
// DO NOT EDIT!

/*
	Package enginepb is a generated protocol buffer package.

	It is generated from these files:
		cockroach/pkg/storage/engine/enginepb/mvcc.proto
		cockroach/pkg/storage/engine/enginepb/rocksdb.proto

	It has these top-level messages:
		TxnMeta
		MVCCMetadata
		MVCCStats
		SSTUserProperties
		SSTUserPropertiesCollection
*/
package enginepb

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import cockroach_util_hlc "github.com/cockroachdb/cockroach/pkg/util/hlc"

import github_com_cockroachdb_cockroach_pkg_util_uuid "github.com/cockroachdb/cockroach/pkg/util/uuid"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion2 // please upgrade the proto package

// TODO(tschottdorf): Should not live in enginepb (but can't live in roachpb
// either).
type IsolationType int32

const (
	SERIALIZABLE IsolationType = 0
	SNAPSHOT     IsolationType = 1
)

var IsolationType_name = map[int32]string{
	0: "SERIALIZABLE",
	1: "SNAPSHOT",
}
var IsolationType_value = map[string]int32{
	"SERIALIZABLE": 0,
	"SNAPSHOT":     1,
}

func (x IsolationType) Enum() *IsolationType {
	p := new(IsolationType)
	*p = x
	return p
}
func (x IsolationType) String() string {
	return proto.EnumName(IsolationType_name, int32(x))
}
func (x *IsolationType) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(IsolationType_value, data, "IsolationType")
	if err != nil {
		return err
	}
	*x = IsolationType(value)
	return nil
}
func (IsolationType) EnumDescriptor() ([]byte, []int) { return fileDescriptorMvcc, []int{0} }

// TxnMeta is the metadata of a Transaction record.
type TxnMeta struct {
	// id is a unique UUID value which identifies the transaction.
	ID        *github_com_cockroachdb_cockroach_pkg_util_uuid.UUID `protobuf:"bytes,1,opt,name=id,customtype=github.com/cockroachdb/cockroach/pkg/util/uuid.UUID" json:"id,omitempty"`
	Isolation IsolationType                                        `protobuf:"varint,2,opt,name=isolation,enum=cockroach.storage.engine.enginepb.IsolationType" json:"isolation"`
	// key is the key which anchors the transaction. This is typically
	// the first key read or written during the transaction and determines which
	// range in the cluster will hold the transaction record.
	Key []byte `protobuf:"bytes,3,opt,name=key" json:"key,omitempty"`
	// Incremented on txn retry.
	Epoch uint32 `protobuf:"varint,4,opt,name=epoch" json:"epoch"`
	// The proposed timestamp for the transaction. This starts as
	// the current wall time on the txn coordinator.
	Timestamp cockroach_util_hlc.Timestamp `protobuf:"bytes,5,opt,name=timestamp" json:"timestamp"`
	Priority  int32                        `protobuf:"varint,6,opt,name=priority" json:"priority"`
	// A one-indexed sequence number which is increased on each batch
	// sent as part of the transaction. Used to prevent replay and
	// out-of-order application protection (by means of a transaction
	// retry).
	Sequence int32 `protobuf:"varint,7,opt,name=sequence" json:"sequence"`
	// A zero-indexed sequence number indicating the index of a
	// command within a batch. This disambiguate Raft replays of a batch
	// from multiple commands in a batch which modify the same key.
	BatchIndex int32 `protobuf:"varint,8,opt,name=batch_index,json=batchIndex" json:"batch_index"`
}

func (m *TxnMeta) Reset()                    { *m = TxnMeta{} }
func (m *TxnMeta) String() string            { return proto.CompactTextString(m) }
func (*TxnMeta) ProtoMessage()               {}
func (*TxnMeta) Descriptor() ([]byte, []int) { return fileDescriptorMvcc, []int{0} }

// MVCCMetadata holds MVCC metadata for a key. Used by storage/engine/mvcc.go.
type MVCCMetadata struct {
	Txn *TxnMeta `protobuf:"bytes,1,opt,name=txn" json:"txn,omitempty"`
	// The timestamp of the most recent versioned value if this is a
	// value that may have multiple versions. For values which may have
	// only one version, the data is stored inline (via raw_bytes), and
	// timestamp is set to zero.
	Timestamp cockroach_util_hlc.Timestamp `protobuf:"bytes,2,opt,name=timestamp" json:"timestamp"`
	// Is the most recent value a deletion tombstone?
	Deleted bool `protobuf:"varint,3,opt,name=deleted" json:"deleted"`
	// The size in bytes of the most recent encoded key.
	KeyBytes int64 `protobuf:"varint,4,opt,name=key_bytes,json=keyBytes" json:"key_bytes"`
	// The size in bytes of the most recent versioned value.
	ValBytes int64 `protobuf:"varint,5,opt,name=val_bytes,json=valBytes" json:"val_bytes"`
	// Inline value, used for non-versioned values with zero
	// timestamp. This provides an efficient short circuit of the normal
	// MVCC metadata sentinel and subsequent version rows. If timestamp
	// == (0, 0), then there is only a single MVCC metadata row with
	// value inlined, and with empty timestamp, key_bytes, and
	// val_bytes.
	RawBytes []byte `protobuf:"bytes,6,opt,name=raw_bytes,json=rawBytes" json:"raw_bytes,omitempty"`
	// This provides a measure of protection against replays caused by
	// Raft duplicating merge commands.
	MergeTimestamp *cockroach_util_hlc.Timestamp `protobuf:"bytes,7,opt,name=merge_timestamp,json=mergeTimestamp" json:"merge_timestamp,omitempty"`
}

func (m *MVCCMetadata) Reset()                    { *m = MVCCMetadata{} }
func (m *MVCCMetadata) String() string            { return proto.CompactTextString(m) }
func (*MVCCMetadata) ProtoMessage()               {}
func (*MVCCMetadata) Descriptor() ([]byte, []int) { return fileDescriptorMvcc, []int{1} }

// MVCCStats tracks byte and instance counts for various groups of keys,
// values, or key-value pairs; see the field comments for details.
//
// It also tracks two cumulative ages, namely that of intents and non-live
// (i.e. GC-able) bytes. This computation is intrinsically linked to
// last_update_nanos and is easy to get wrong. Updates happen only once every
// full second, as measured by last_update_nanos/1e9. That is, forward updates
// don't change last_update_nanos until an update at a timestamp which,
// truncated to the second, is ahead of last_update_nanos/1e9. Then, that
// difference in seconds times the base quantity (excluding the currently
// running update) is added to the age. It gets more complicated when data is
// accounted for with a timestamp behind last_update_nanos. In this case, if
// more than a second has passed (computed via truncation above), the ages have
// to be adjusted to account for this late addition. This isn't hard: add the
// new data's base quantity times the (truncated) number of seconds behind.
// Important to keep in mind with those computations is that (x/1e9 - y/1e9)
// does not equal (x-y)/1e9 in most cases.
//
// Note that this struct must be kept at a fixed size by using fixed-size
// encodings for all fields and by making all fields non-nullable. This is
// so that it can predict its own impact on the size of the system-local
// kv-pairs.
type MVCCStats struct {
	// contains_estimates indicates that the MVCCStats object contains values
	// which have been estimated. This means that the stats should not be used
	// where complete accuracy is required, and instead should be recomputed
	// when necessary.
	ContainsEstimates bool `protobuf:"varint,14,opt,name=contains_estimates,json=containsEstimates" json:"contains_estimates"`
	// last_update_nanos is a timestamp at which the ages were last
	// updated. See the comment on MVCCStats.
	LastUpdateNanos int64 `protobuf:"fixed64,1,opt,name=last_update_nanos,json=lastUpdateNanos" json:"last_update_nanos"`
	// intent_age is the cumulative age of the tracked intents.
	// See the comment on MVCCStats.
	IntentAge int64 `protobuf:"fixed64,2,opt,name=intent_age,json=intentAge" json:"intent_age"`
	// gc_bytes_age is the cumulative age of the non-live data (i.e.
	// data included in key_bytes and val_bytes, but not live_bytes).
	// See the comment on MVCCStats.
	GCBytesAge int64 `protobuf:"fixed64,3,opt,name=gc_bytes_age,json=gcBytesAge" json:"gc_bytes_age"`
	// live_bytes is the number of bytes stored in keys and values which can in
	// principle be read by means of a Scan or Get in the far future, including
	// intents but not deletion tombstones (or their intents). Note that the
	// size of the meta kv pair (which could be explicit or implicit) is
	// included in this. Only the meta kv pair counts for the actual length of
	// the encoded key (regular pairs only count the timestamp suffix).
	LiveBytes int64 `protobuf:"fixed64,4,opt,name=live_bytes,json=liveBytes" json:"live_bytes"`
	// live_count is the number of meta keys tracked under live_bytes.
	LiveCount int64 `protobuf:"fixed64,5,opt,name=live_count,json=liveCount" json:"live_count"`
	// key_bytes is the number of bytes stored in all non-system
	// keys, including live, meta, old, and deleted keys.
	// Only meta keys really account for the "full" key; value
	// keys only for the timestamp suffix.
	KeyBytes int64 `protobuf:"fixed64,6,opt,name=key_bytes,json=keyBytes" json:"key_bytes"`
	// key_count is the number of meta keys tracked under key_bytes.
	KeyCount int64 `protobuf:"fixed64,7,opt,name=key_count,json=keyCount" json:"key_count"`
	// value_bytes is the number of bytes in all non-system version
	// values, including meta values.
	ValBytes int64 `protobuf:"fixed64,8,opt,name=val_bytes,json=valBytes" json:"val_bytes"`
	// val_count is the number of meta values tracked under val_bytes.
	ValCount int64 `protobuf:"fixed64,9,opt,name=val_count,json=valCount" json:"val_count"`
	// intent_bytes is the number of bytes in intent key-value
	// pairs (without their meta keys).
	IntentBytes int64 `protobuf:"fixed64,10,opt,name=intent_bytes,json=intentBytes" json:"intent_bytes"`
	// intent_count is the number of keys tracked under intent_bytes.
	// It is equal to the number of meta keys in the system with
	// a non-empty Transaction proto.
	IntentCount int64 `protobuf:"fixed64,11,opt,name=intent_count,json=intentCount" json:"intent_count"`
	// sys_bytes is the number of bytes stored in system-local kv-pairs.
	// This tracks the same quantity as (key_bytes + val_bytes), but
	// for system-local metadata keys (which aren't counted in either
	// key_bytes or val_bytes). Each of the keys falling into this group
	// is documented in keys/constants.go under the localPrefix constant
	// and is prefixed by either LocalRangeIDPrefix or LocalRangePrefix.
	SysBytes int64 `protobuf:"fixed64,12,opt,name=sys_bytes,json=sysBytes" json:"sys_bytes"`
	// sys_count is the number of meta keys tracked under sys_bytes.
	SysCount int64 `protobuf:"fixed64,13,opt,name=sys_count,json=sysCount" json:"sys_count"`
}

func (m *MVCCStats) Reset()                    { *m = MVCCStats{} }
func (m *MVCCStats) String() string            { return proto.CompactTextString(m) }
func (*MVCCStats) ProtoMessage()               {}
func (*MVCCStats) Descriptor() ([]byte, []int) { return fileDescriptorMvcc, []int{2} }

func init() {
	proto.RegisterType((*TxnMeta)(nil), "cockroach.storage.engine.enginepb.TxnMeta")
	proto.RegisterType((*MVCCMetadata)(nil), "cockroach.storage.engine.enginepb.MVCCMetadata")
	proto.RegisterType((*MVCCStats)(nil), "cockroach.storage.engine.enginepb.MVCCStats")
	proto.RegisterEnum("cockroach.storage.engine.enginepb.IsolationType", IsolationType_name, IsolationType_value)
}
func (m *TxnMeta) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TxnMeta) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ID != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintMvcc(dAtA, i, uint64(m.ID.Size()))
		n1, err := m.ID.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	dAtA[i] = 0x10
	i++
	i = encodeVarintMvcc(dAtA, i, uint64(m.Isolation))
	if m.Key != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintMvcc(dAtA, i, uint64(len(m.Key)))
		i += copy(dAtA[i:], m.Key)
	}
	dAtA[i] = 0x20
	i++
	i = encodeVarintMvcc(dAtA, i, uint64(m.Epoch))
	dAtA[i] = 0x2a
	i++
	i = encodeVarintMvcc(dAtA, i, uint64(m.Timestamp.Size()))
	n2, err := m.Timestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n2
	dAtA[i] = 0x30
	i++
	i = encodeVarintMvcc(dAtA, i, uint64(m.Priority))
	dAtA[i] = 0x38
	i++
	i = encodeVarintMvcc(dAtA, i, uint64(m.Sequence))
	dAtA[i] = 0x40
	i++
	i = encodeVarintMvcc(dAtA, i, uint64(m.BatchIndex))
	return i, nil
}

func (m *MVCCMetadata) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MVCCMetadata) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Txn != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintMvcc(dAtA, i, uint64(m.Txn.Size()))
		n3, err := m.Txn.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	dAtA[i] = 0x12
	i++
	i = encodeVarintMvcc(dAtA, i, uint64(m.Timestamp.Size()))
	n4, err := m.Timestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n4
	dAtA[i] = 0x18
	i++
	if m.Deleted {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	dAtA[i] = 0x20
	i++
	i = encodeVarintMvcc(dAtA, i, uint64(m.KeyBytes))
	dAtA[i] = 0x28
	i++
	i = encodeVarintMvcc(dAtA, i, uint64(m.ValBytes))
	if m.RawBytes != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintMvcc(dAtA, i, uint64(len(m.RawBytes)))
		i += copy(dAtA[i:], m.RawBytes)
	}
	if m.MergeTimestamp != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintMvcc(dAtA, i, uint64(m.MergeTimestamp.Size()))
		n5, err := m.MergeTimestamp.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	return i, nil
}

func (m *MVCCStats) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *MVCCStats) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x9
	i++
	i = encodeFixed64Mvcc(dAtA, i, uint64(m.LastUpdateNanos))
	dAtA[i] = 0x11
	i++
	i = encodeFixed64Mvcc(dAtA, i, uint64(m.IntentAge))
	dAtA[i] = 0x19
	i++
	i = encodeFixed64Mvcc(dAtA, i, uint64(m.GCBytesAge))
	dAtA[i] = 0x21
	i++
	i = encodeFixed64Mvcc(dAtA, i, uint64(m.LiveBytes))
	dAtA[i] = 0x29
	i++
	i = encodeFixed64Mvcc(dAtA, i, uint64(m.LiveCount))
	dAtA[i] = 0x31
	i++
	i = encodeFixed64Mvcc(dAtA, i, uint64(m.KeyBytes))
	dAtA[i] = 0x39
	i++
	i = encodeFixed64Mvcc(dAtA, i, uint64(m.KeyCount))
	dAtA[i] = 0x41
	i++
	i = encodeFixed64Mvcc(dAtA, i, uint64(m.ValBytes))
	dAtA[i] = 0x49
	i++
	i = encodeFixed64Mvcc(dAtA, i, uint64(m.ValCount))
	dAtA[i] = 0x51
	i++
	i = encodeFixed64Mvcc(dAtA, i, uint64(m.IntentBytes))
	dAtA[i] = 0x59
	i++
	i = encodeFixed64Mvcc(dAtA, i, uint64(m.IntentCount))
	dAtA[i] = 0x61
	i++
	i = encodeFixed64Mvcc(dAtA, i, uint64(m.SysBytes))
	dAtA[i] = 0x69
	i++
	i = encodeFixed64Mvcc(dAtA, i, uint64(m.SysCount))
	dAtA[i] = 0x70
	i++
	if m.ContainsEstimates {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	return i, nil
}

func encodeFixed64Mvcc(dAtA []byte, offset int, v uint64) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	dAtA[offset+4] = uint8(v >> 32)
	dAtA[offset+5] = uint8(v >> 40)
	dAtA[offset+6] = uint8(v >> 48)
	dAtA[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32Mvcc(dAtA []byte, offset int, v uint32) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintMvcc(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func NewPopulatedTxnMeta(r randyMvcc, easy bool) *TxnMeta {
	this := &TxnMeta{}
	if r.Intn(10) != 0 {
		this.ID = github_com_cockroachdb_cockroach_pkg_util_uuid.NewPopulatedUUID(r)
	}
	this.Isolation = IsolationType([]int32{0, 1}[r.Intn(2)])
	if r.Intn(10) != 0 {
		v1 := r.Intn(100)
		this.Key = make([]byte, v1)
		for i := 0; i < v1; i++ {
			this.Key[i] = byte(r.Intn(256))
		}
	}
	this.Epoch = uint32(r.Uint32())
	v2 := cockroach_util_hlc.NewPopulatedTimestamp(r, easy)
	this.Timestamp = *v2
	this.Priority = int32(r.Int31())
	if r.Intn(2) == 0 {
		this.Priority *= -1
	}
	this.Sequence = int32(r.Int31())
	if r.Intn(2) == 0 {
		this.Sequence *= -1
	}
	this.BatchIndex = int32(r.Int31())
	if r.Intn(2) == 0 {
		this.BatchIndex *= -1
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedMVCCMetadata(r randyMvcc, easy bool) *MVCCMetadata {
	this := &MVCCMetadata{}
	if r.Intn(10) != 0 {
		this.Txn = NewPopulatedTxnMeta(r, easy)
	}
	v3 := cockroach_util_hlc.NewPopulatedTimestamp(r, easy)
	this.Timestamp = *v3
	this.Deleted = bool(bool(r.Intn(2) == 0))
	this.KeyBytes = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.KeyBytes *= -1
	}
	this.ValBytes = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.ValBytes *= -1
	}
	if r.Intn(10) != 0 {
		v4 := r.Intn(100)
		this.RawBytes = make([]byte, v4)
		for i := 0; i < v4; i++ {
			this.RawBytes[i] = byte(r.Intn(256))
		}
	}
	if r.Intn(10) != 0 {
		this.MergeTimestamp = cockroach_util_hlc.NewPopulatedTimestamp(r, easy)
	}
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

func NewPopulatedMVCCStats(r randyMvcc, easy bool) *MVCCStats {
	this := &MVCCStats{}
	this.LastUpdateNanos = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.LastUpdateNanos *= -1
	}
	this.IntentAge = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.IntentAge *= -1
	}
	this.GCBytesAge = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.GCBytesAge *= -1
	}
	this.LiveBytes = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.LiveBytes *= -1
	}
	this.LiveCount = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.LiveCount *= -1
	}
	this.KeyBytes = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.KeyBytes *= -1
	}
	this.KeyCount = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.KeyCount *= -1
	}
	this.ValBytes = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.ValBytes *= -1
	}
	this.ValCount = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.ValCount *= -1
	}
	this.IntentBytes = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.IntentBytes *= -1
	}
	this.IntentCount = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.IntentCount *= -1
	}
	this.SysBytes = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.SysBytes *= -1
	}
	this.SysCount = int64(r.Int63())
	if r.Intn(2) == 0 {
		this.SysCount *= -1
	}
	this.ContainsEstimates = bool(bool(r.Intn(2) == 0))
	if !easy && r.Intn(10) != 0 {
	}
	return this
}

type randyMvcc interface {
	Float32() float32
	Float64() float64
	Int63() int64
	Int31() int32
	Uint32() uint32
	Intn(n int) int
}

func randUTF8RuneMvcc(r randyMvcc) rune {
	ru := r.Intn(62)
	if ru < 10 {
		return rune(ru + 48)
	} else if ru < 36 {
		return rune(ru + 55)
	}
	return rune(ru + 61)
}
func randStringMvcc(r randyMvcc) string {
	v5 := r.Intn(100)
	tmps := make([]rune, v5)
	for i := 0; i < v5; i++ {
		tmps[i] = randUTF8RuneMvcc(r)
	}
	return string(tmps)
}
func randUnrecognizedMvcc(r randyMvcc, maxFieldNumber int) (dAtA []byte) {
	l := r.Intn(5)
	for i := 0; i < l; i++ {
		wire := r.Intn(4)
		if wire == 3 {
			wire = 5
		}
		fieldNumber := maxFieldNumber + r.Intn(100)
		dAtA = randFieldMvcc(dAtA, r, fieldNumber, wire)
	}
	return dAtA
}
func randFieldMvcc(dAtA []byte, r randyMvcc, fieldNumber int, wire int) []byte {
	key := uint32(fieldNumber)<<3 | uint32(wire)
	switch wire {
	case 0:
		dAtA = encodeVarintPopulateMvcc(dAtA, uint64(key))
		v6 := r.Int63()
		if r.Intn(2) == 0 {
			v6 *= -1
		}
		dAtA = encodeVarintPopulateMvcc(dAtA, uint64(v6))
	case 1:
		dAtA = encodeVarintPopulateMvcc(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	case 2:
		dAtA = encodeVarintPopulateMvcc(dAtA, uint64(key))
		ll := r.Intn(100)
		dAtA = encodeVarintPopulateMvcc(dAtA, uint64(ll))
		for j := 0; j < ll; j++ {
			dAtA = append(dAtA, byte(r.Intn(256)))
		}
	default:
		dAtA = encodeVarintPopulateMvcc(dAtA, uint64(key))
		dAtA = append(dAtA, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	}
	return dAtA
}
func encodeVarintPopulateMvcc(dAtA []byte, v uint64) []byte {
	for v >= 1<<7 {
		dAtA = append(dAtA, uint8(uint64(v)&0x7f|0x80))
		v >>= 7
	}
	dAtA = append(dAtA, uint8(v))
	return dAtA
}
func (m *TxnMeta) Size() (n int) {
	var l int
	_ = l
	if m.ID != nil {
		l = m.ID.Size()
		n += 1 + l + sovMvcc(uint64(l))
	}
	n += 1 + sovMvcc(uint64(m.Isolation))
	if m.Key != nil {
		l = len(m.Key)
		n += 1 + l + sovMvcc(uint64(l))
	}
	n += 1 + sovMvcc(uint64(m.Epoch))
	l = m.Timestamp.Size()
	n += 1 + l + sovMvcc(uint64(l))
	n += 1 + sovMvcc(uint64(m.Priority))
	n += 1 + sovMvcc(uint64(m.Sequence))
	n += 1 + sovMvcc(uint64(m.BatchIndex))
	return n
}

func (m *MVCCMetadata) Size() (n int) {
	var l int
	_ = l
	if m.Txn != nil {
		l = m.Txn.Size()
		n += 1 + l + sovMvcc(uint64(l))
	}
	l = m.Timestamp.Size()
	n += 1 + l + sovMvcc(uint64(l))
	n += 2
	n += 1 + sovMvcc(uint64(m.KeyBytes))
	n += 1 + sovMvcc(uint64(m.ValBytes))
	if m.RawBytes != nil {
		l = len(m.RawBytes)
		n += 1 + l + sovMvcc(uint64(l))
	}
	if m.MergeTimestamp != nil {
		l = m.MergeTimestamp.Size()
		n += 1 + l + sovMvcc(uint64(l))
	}
	return n
}

func (m *MVCCStats) Size() (n int) {
	var l int
	_ = l
	n += 9
	n += 9
	n += 9
	n += 9
	n += 9
	n += 9
	n += 9
	n += 9
	n += 9
	n += 9
	n += 9
	n += 9
	n += 9
	n += 2
	return n
}

func sovMvcc(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozMvcc(x uint64) (n int) {
	return sovMvcc(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (m *TxnMeta) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMvcc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TxnMeta: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TxnMeta: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ID", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMvcc
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var v github_com_cockroachdb_cockroach_pkg_util_uuid.UUID
			m.ID = &v
			if err := m.ID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Isolation", wireType)
			}
			m.Isolation = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Isolation |= (IsolationType(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMvcc
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = append(m.Key[:0], dAtA[iNdEx:postIndex]...)
			if m.Key == nil {
				m.Key = []byte{}
			}
			iNdEx = postIndex
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Epoch", wireType)
			}
			m.Epoch = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Epoch |= (uint32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMvcc
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Priority", wireType)
			}
			m.Priority = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Priority |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 7:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Sequence", wireType)
			}
			m.Sequence = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Sequence |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field BatchIndex", wireType)
			}
			m.BatchIndex = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.BatchIndex |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipMvcc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMvcc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MVCCMetadata) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMvcc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MVCCMetadata: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MVCCMetadata: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Txn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMvcc
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Txn == nil {
				m.Txn = &TxnMeta{}
			}
			if err := m.Txn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMvcc
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Deleted", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Deleted = bool(v != 0)
		case 4:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field KeyBytes", wireType)
			}
			m.KeyBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.KeyBytes |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ValBytes", wireType)
			}
			m.ValBytes = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ValBytes |= (int64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RawBytes", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthMvcc
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RawBytes = append(m.RawBytes[:0], dAtA[iNdEx:postIndex]...)
			if m.RawBytes == nil {
				m.RawBytes = []byte{}
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MergeTimestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthMvcc
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MergeTimestamp == nil {
				m.MergeTimestamp = &cockroach_util_hlc.Timestamp{}
			}
			if err := m.MergeTimestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipMvcc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMvcc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *MVCCStats) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowMvcc
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: MVCCStats: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: MVCCStats: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field LastUpdateNanos", wireType)
			}
			m.LastUpdateNanos = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			m.LastUpdateNanos = int64(dAtA[iNdEx-8])
			m.LastUpdateNanos |= int64(dAtA[iNdEx-7]) << 8
			m.LastUpdateNanos |= int64(dAtA[iNdEx-6]) << 16
			m.LastUpdateNanos |= int64(dAtA[iNdEx-5]) << 24
			m.LastUpdateNanos |= int64(dAtA[iNdEx-4]) << 32
			m.LastUpdateNanos |= int64(dAtA[iNdEx-3]) << 40
			m.LastUpdateNanos |= int64(dAtA[iNdEx-2]) << 48
			m.LastUpdateNanos |= int64(dAtA[iNdEx-1]) << 56
		case 2:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntentAge", wireType)
			}
			m.IntentAge = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			m.IntentAge = int64(dAtA[iNdEx-8])
			m.IntentAge |= int64(dAtA[iNdEx-7]) << 8
			m.IntentAge |= int64(dAtA[iNdEx-6]) << 16
			m.IntentAge |= int64(dAtA[iNdEx-5]) << 24
			m.IntentAge |= int64(dAtA[iNdEx-4]) << 32
			m.IntentAge |= int64(dAtA[iNdEx-3]) << 40
			m.IntentAge |= int64(dAtA[iNdEx-2]) << 48
			m.IntentAge |= int64(dAtA[iNdEx-1]) << 56
		case 3:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field GCBytesAge", wireType)
			}
			m.GCBytesAge = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			m.GCBytesAge = int64(dAtA[iNdEx-8])
			m.GCBytesAge |= int64(dAtA[iNdEx-7]) << 8
			m.GCBytesAge |= int64(dAtA[iNdEx-6]) << 16
			m.GCBytesAge |= int64(dAtA[iNdEx-5]) << 24
			m.GCBytesAge |= int64(dAtA[iNdEx-4]) << 32
			m.GCBytesAge |= int64(dAtA[iNdEx-3]) << 40
			m.GCBytesAge |= int64(dAtA[iNdEx-2]) << 48
			m.GCBytesAge |= int64(dAtA[iNdEx-1]) << 56
		case 4:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field LiveBytes", wireType)
			}
			m.LiveBytes = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			m.LiveBytes = int64(dAtA[iNdEx-8])
			m.LiveBytes |= int64(dAtA[iNdEx-7]) << 8
			m.LiveBytes |= int64(dAtA[iNdEx-6]) << 16
			m.LiveBytes |= int64(dAtA[iNdEx-5]) << 24
			m.LiveBytes |= int64(dAtA[iNdEx-4]) << 32
			m.LiveBytes |= int64(dAtA[iNdEx-3]) << 40
			m.LiveBytes |= int64(dAtA[iNdEx-2]) << 48
			m.LiveBytes |= int64(dAtA[iNdEx-1]) << 56
		case 5:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field LiveCount", wireType)
			}
			m.LiveCount = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			m.LiveCount = int64(dAtA[iNdEx-8])
			m.LiveCount |= int64(dAtA[iNdEx-7]) << 8
			m.LiveCount |= int64(dAtA[iNdEx-6]) << 16
			m.LiveCount |= int64(dAtA[iNdEx-5]) << 24
			m.LiveCount |= int64(dAtA[iNdEx-4]) << 32
			m.LiveCount |= int64(dAtA[iNdEx-3]) << 40
			m.LiveCount |= int64(dAtA[iNdEx-2]) << 48
			m.LiveCount |= int64(dAtA[iNdEx-1]) << 56
		case 6:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field KeyBytes", wireType)
			}
			m.KeyBytes = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			m.KeyBytes = int64(dAtA[iNdEx-8])
			m.KeyBytes |= int64(dAtA[iNdEx-7]) << 8
			m.KeyBytes |= int64(dAtA[iNdEx-6]) << 16
			m.KeyBytes |= int64(dAtA[iNdEx-5]) << 24
			m.KeyBytes |= int64(dAtA[iNdEx-4]) << 32
			m.KeyBytes |= int64(dAtA[iNdEx-3]) << 40
			m.KeyBytes |= int64(dAtA[iNdEx-2]) << 48
			m.KeyBytes |= int64(dAtA[iNdEx-1]) << 56
		case 7:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field KeyCount", wireType)
			}
			m.KeyCount = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			m.KeyCount = int64(dAtA[iNdEx-8])
			m.KeyCount |= int64(dAtA[iNdEx-7]) << 8
			m.KeyCount |= int64(dAtA[iNdEx-6]) << 16
			m.KeyCount |= int64(dAtA[iNdEx-5]) << 24
			m.KeyCount |= int64(dAtA[iNdEx-4]) << 32
			m.KeyCount |= int64(dAtA[iNdEx-3]) << 40
			m.KeyCount |= int64(dAtA[iNdEx-2]) << 48
			m.KeyCount |= int64(dAtA[iNdEx-1]) << 56
		case 8:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field ValBytes", wireType)
			}
			m.ValBytes = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			m.ValBytes = int64(dAtA[iNdEx-8])
			m.ValBytes |= int64(dAtA[iNdEx-7]) << 8
			m.ValBytes |= int64(dAtA[iNdEx-6]) << 16
			m.ValBytes |= int64(dAtA[iNdEx-5]) << 24
			m.ValBytes |= int64(dAtA[iNdEx-4]) << 32
			m.ValBytes |= int64(dAtA[iNdEx-3]) << 40
			m.ValBytes |= int64(dAtA[iNdEx-2]) << 48
			m.ValBytes |= int64(dAtA[iNdEx-1]) << 56
		case 9:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field ValCount", wireType)
			}
			m.ValCount = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			m.ValCount = int64(dAtA[iNdEx-8])
			m.ValCount |= int64(dAtA[iNdEx-7]) << 8
			m.ValCount |= int64(dAtA[iNdEx-6]) << 16
			m.ValCount |= int64(dAtA[iNdEx-5]) << 24
			m.ValCount |= int64(dAtA[iNdEx-4]) << 32
			m.ValCount |= int64(dAtA[iNdEx-3]) << 40
			m.ValCount |= int64(dAtA[iNdEx-2]) << 48
			m.ValCount |= int64(dAtA[iNdEx-1]) << 56
		case 10:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntentBytes", wireType)
			}
			m.IntentBytes = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			m.IntentBytes = int64(dAtA[iNdEx-8])
			m.IntentBytes |= int64(dAtA[iNdEx-7]) << 8
			m.IntentBytes |= int64(dAtA[iNdEx-6]) << 16
			m.IntentBytes |= int64(dAtA[iNdEx-5]) << 24
			m.IntentBytes |= int64(dAtA[iNdEx-4]) << 32
			m.IntentBytes |= int64(dAtA[iNdEx-3]) << 40
			m.IntentBytes |= int64(dAtA[iNdEx-2]) << 48
			m.IntentBytes |= int64(dAtA[iNdEx-1]) << 56
		case 11:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field IntentCount", wireType)
			}
			m.IntentCount = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			m.IntentCount = int64(dAtA[iNdEx-8])
			m.IntentCount |= int64(dAtA[iNdEx-7]) << 8
			m.IntentCount |= int64(dAtA[iNdEx-6]) << 16
			m.IntentCount |= int64(dAtA[iNdEx-5]) << 24
			m.IntentCount |= int64(dAtA[iNdEx-4]) << 32
			m.IntentCount |= int64(dAtA[iNdEx-3]) << 40
			m.IntentCount |= int64(dAtA[iNdEx-2]) << 48
			m.IntentCount |= int64(dAtA[iNdEx-1]) << 56
		case 12:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field SysBytes", wireType)
			}
			m.SysBytes = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			m.SysBytes = int64(dAtA[iNdEx-8])
			m.SysBytes |= int64(dAtA[iNdEx-7]) << 8
			m.SysBytes |= int64(dAtA[iNdEx-6]) << 16
			m.SysBytes |= int64(dAtA[iNdEx-5]) << 24
			m.SysBytes |= int64(dAtA[iNdEx-4]) << 32
			m.SysBytes |= int64(dAtA[iNdEx-3]) << 40
			m.SysBytes |= int64(dAtA[iNdEx-2]) << 48
			m.SysBytes |= int64(dAtA[iNdEx-1]) << 56
		case 13:
			if wireType != 1 {
				return fmt.Errorf("proto: wrong wireType = %d for field SysCount", wireType)
			}
			m.SysCount = 0
			if (iNdEx + 8) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += 8
			m.SysCount = int64(dAtA[iNdEx-8])
			m.SysCount |= int64(dAtA[iNdEx-7]) << 8
			m.SysCount |= int64(dAtA[iNdEx-6]) << 16
			m.SysCount |= int64(dAtA[iNdEx-5]) << 24
			m.SysCount |= int64(dAtA[iNdEx-4]) << 32
			m.SysCount |= int64(dAtA[iNdEx-3]) << 40
			m.SysCount |= int64(dAtA[iNdEx-2]) << 48
			m.SysCount |= int64(dAtA[iNdEx-1]) << 56
		case 14:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainsEstimates", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowMvcc
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.ContainsEstimates = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipMvcc(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthMvcc
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipMvcc(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowMvcc
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMvcc
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowMvcc
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthMvcc
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowMvcc
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipMvcc(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthMvcc = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowMvcc   = fmt.Errorf("proto: integer overflow")
)

func init() {
	proto.RegisterFile("cockroach/pkg/storage/engine/enginepb/mvcc.proto", fileDescriptorMvcc)
}

var fileDescriptorMvcc = []byte{
	// 760 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x94, 0xcf, 0x6e, 0xd3, 0x40,
	0x10, 0xc6, 0xe3, 0xfc, 0x69, 0x92, 0x4d, 0xda, 0xa6, 0x2b, 0x0e, 0x56, 0x10, 0x4e, 0x5a, 0x04,
	0x44, 0x3d, 0xd8, 0x55, 0x0b, 0x17, 0x04, 0x87, 0x24, 0x2d, 0x10, 0xa9, 0x2d, 0x28, 0x49, 0x39,
	0xf4, 0x12, 0x6d, 0xec, 0x95, 0xb3, 0x8a, 0x63, 0x1b, 0x7b, 0x93, 0xd6, 0x6f, 0xc0, 0xb1, 0x8f,
	0x80, 0xc4, 0x4b, 0x70, 0xe5, 0xd6, 0x23, 0x47, 0xc4, 0x21, 0x2a, 0xe1, 0x45, 0xd0, 0xee, 0xda,
	0x8e, 0x53, 0x90, 0xa8, 0x38, 0x65, 0x33, 0xf3, 0x9b, 0x6f, 0x67, 0xbe, 0xd9, 0x04, 0xec, 0xe9,
	0x8e, 0x3e, 0xf6, 0x1c, 0xa4, 0x8f, 0x34, 0x77, 0x6c, 0x6a, 0x3e, 0x75, 0x3c, 0x64, 0x62, 0x0d,
	0xdb, 0x26, 0xb1, 0xa3, 0x0f, 0x77, 0xa8, 0x4d, 0x66, 0xba, 0xae, 0xba, 0x9e, 0x43, 0x1d, 0xb8,
	0x1d, 0x57, 0xa8, 0x21, 0xad, 0x0a, 0x4c, 0x8d, 0xe8, 0xea, 0xe3, 0x55, 0xd1, 0x29, 0x25, 0x96,
	0x36, 0xb2, 0x74, 0x8d, 0x92, 0x09, 0xf6, 0x29, 0x9a, 0xb8, 0x42, 0xaa, 0x7a, 0xcf, 0x74, 0x4c,
	0x87, 0x1f, 0x35, 0x76, 0x12, 0xd1, 0x9d, 0xab, 0x0c, 0xc8, 0xf7, 0x2f, 0xed, 0x13, 0x4c, 0x11,
	0x3c, 0x01, 0x69, 0x62, 0xc8, 0x52, 0x5d, 0x6a, 0x94, 0x5b, 0x2f, 0x7f, 0xcc, 0x6b, 0x07, 0x26,
	0xa1, 0xa3, 0xe9, 0x50, 0xd5, 0x9d, 0x89, 0x16, 0x5f, 0x62, 0x0c, 0xb5, 0xbf, 0x5c, 0x38, 0x9d,
	0x12, 0x43, 0x3d, 0x3b, 0xeb, 0x1c, 0x2e, 0xe6, 0xb5, 0x74, 0xe7, 0xb0, 0x9b, 0x26, 0x06, 0xec,
	0x83, 0x22, 0xf1, 0x1d, 0x0b, 0x51, 0xe2, 0xd8, 0x72, 0xba, 0x2e, 0x35, 0x36, 0xf6, 0xf7, 0xd4,
	0x7f, 0xce, 0xa3, 0x76, 0xa2, 0x9a, 0x7e, 0xe0, 0xe2, 0x56, 0xf6, 0x7a, 0x5e, 0x4b, 0x75, 0x97,
	0x42, 0xb0, 0x02, 0x32, 0x63, 0x1c, 0xc8, 0x19, 0xd6, 0x65, 0x97, 0x1d, 0x61, 0x15, 0xe4, 0xb0,
	0xeb, 0xe8, 0x23, 0x39, 0x5b, 0x97, 0x1a, 0xeb, 0x61, 0x85, 0x08, 0xc1, 0x26, 0x28, 0xc6, 0x3e,
	0xc8, 0xb9, 0xba, 0xd4, 0x28, 0xed, 0x3f, 0x48, 0xf4, 0xc0, 0x7a, 0x57, 0x47, 0x96, 0xae, 0xf6,
	0x23, 0x28, 0xba, 0x30, 0xae, 0x82, 0x75, 0x50, 0x70, 0x3d, 0xe2, 0x78, 0x84, 0x06, 0xf2, 0x5a,
	0x5d, 0x6a, 0xe4, 0x42, 0x24, 0x8e, 0x32, 0xc2, 0xc7, 0x1f, 0xa6, 0xd8, 0xd6, 0xb1, 0x9c, 0x4f,
	0x12, 0x51, 0x14, 0x3e, 0x02, 0xa5, 0x21, 0xa2, 0xfa, 0x68, 0x40, 0x6c, 0x03, 0x5f, 0xca, 0x85,
	0x04, 0x04, 0x78, 0xa2, 0xc3, 0xe2, 0xcf, 0xb3, 0x5f, 0x3e, 0xd5, 0xa4, 0x9d, 0x9b, 0x34, 0x28,
	0x9f, 0xbc, 0x6f, 0xb7, 0xd9, 0x4e, 0x0c, 0x44, 0x11, 0x7c, 0x01, 0x32, 0xf4, 0xd2, 0xe6, 0x8b,
	0x29, 0xed, 0xef, 0xde, 0xc1, 0xc2, 0x70, 0xa1, 0x5d, 0x56, 0xb6, 0x6a, 0x41, 0xfa, 0xbf, 0x2c,
	0x50, 0x40, 0xde, 0xc0, 0x16, 0xa6, 0xd8, 0xe0, 0xbe, 0x17, 0x42, 0x22, 0x0a, 0xc2, 0x6d, 0x50,
	0x1c, 0xe3, 0x60, 0x30, 0x0c, 0x28, 0xf6, 0xf9, 0x16, 0x32, 0x91, 0x03, 0x63, 0x1c, 0xb4, 0x58,
	0x94, 0x21, 0x33, 0x64, 0x85, 0x48, 0x2e, 0x89, 0xcc, 0x90, 0x25, 0x90, 0xfb, 0xa0, 0xe8, 0xa1,
	0x8b, 0x10, 0x59, 0xe3, 0xfb, 0x2d, 0x78, 0xe8, 0x42, 0x24, 0x5f, 0x81, 0xcd, 0x09, 0xf6, 0x4c,
	0x3c, 0x58, 0xce, 0x92, 0xbf, 0xc3, 0x2c, 0xdd, 0x0d, 0x5e, 0x15, 0x7f, 0x0f, 0x2d, 0xfe, 0x9a,
	0x05, 0x45, 0x66, 0x71, 0x8f, 0x22, 0xea, 0xc3, 0x3d, 0xb0, 0x65, 0x21, 0x9f, 0x0e, 0xa6, 0xae,
	0x81, 0x28, 0x1e, 0xd8, 0xc8, 0x76, 0x7c, 0xee, 0x76, 0x25, 0xec, 0x71, 0x93, 0xa5, 0xcf, 0x78,
	0xf6, 0x94, 0x25, 0xe1, 0x43, 0x00, 0x88, 0x4d, 0xb1, 0x4d, 0x07, 0xc8, 0xc4, 0xdc, 0xd4, 0x4a,
	0xfc, 0x52, 0x79, 0xbc, 0x69, 0x62, 0xf8, 0x14, 0x94, 0x4d, 0x5d, 0x8c, 0xc3, 0xb1, 0x0c, 0xc7,
	0x20, 0xc3, 0x16, 0xf3, 0x1a, 0x78, 0xdd, 0xe6, 0x93, 0x35, 0x4d, 0xdc, 0x05, 0xa6, 0x1e, 0x9d,
	0x99, 0xb4, 0x45, 0x66, 0x38, 0x61, 0x66, 0x2c, 0xcd, 0xe2, 0xc2, 0x8d, 0x08, 0xd2, 0x9d, 0xa9,
	0x4d, 0xb9, 0x9d, 0x2b, 0x50, 0x9b, 0x85, 0x57, 0xb7, 0xb2, 0x96, 0x60, 0x56, 0xb6, 0xc2, 0x10,
	0x21, 0x93, 0xbf, 0x85, 0xc4, 0x2a, 0xcb, 0xc5, 0x15, 0x92, 0x48, 0xbc, 0xb8, 0x10, 0x11, 0x2a,
	0xc5, 0x5b, 0x88, 0x50, 0x79, 0x02, 0xca, 0xa1, 0x61, 0x42, 0x08, 0x24, 0xa8, 0x92, 0xc8, 0x08,
	0xad, 0x25, 0x28, 0xe4, 0x4a, 0x7f, 0x82, 0x71, 0x5f, 0x7e, 0xe0, 0x87, 0x72, 0xe5, 0xe4, 0xa5,
	0x7e, 0xe0, 0xc7, 0x7d, 0x31, 0x44, 0x08, 0xad, 0xdf, 0x42, 0x84, 0xca, 0x01, 0x80, 0xba, 0x63,
	0x53, 0x44, 0x6c, 0x7f, 0x80, 0x7d, 0x4a, 0x26, 0x88, 0xc9, 0x6d, 0x24, 0x1e, 0xf9, 0x56, 0x94,
	0x3f, 0x8a, 0xd2, 0xe2, 0x0d, 0xed, 0x3e, 0x03, 0xeb, 0x2b, 0x7f, 0x55, 0xb0, 0x02, 0xca, 0xbd,
	0xa3, 0x6e, 0xa7, 0x79, 0xdc, 0x39, 0x6f, 0xb6, 0x8e, 0x8f, 0x2a, 0x29, 0x58, 0x06, 0x85, 0xde,
	0x69, 0xf3, 0x5d, 0xef, 0xcd, 0xdb, 0x7e, 0x45, 0xaa, 0x66, 0x3f, 0x7e, 0x56, 0x52, 0xad, 0x9d,
	0xeb, 0x9f, 0x4a, 0xea, 0x7a, 0xa1, 0x48, 0xdf, 0x16, 0x8a, 0xf4, 0x7d, 0xa1, 0x48, 0x37, 0x0b,
	0x45, 0xba, 0xfa, 0xa5, 0xa4, 0xce, 0x0b, 0xd1, 0xef, 0xf7, 0x77, 0x00, 0x00, 0x00, 0xff, 0xff,
	0x23, 0xa0, 0xaa, 0x43, 0x28, 0x06, 0x00, 0x00,
}
