// +build go1.9

// Copyright 2018 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package alertsmanagement

import (
	"context"

	original "github.com/Azure/azure-sdk-for-go/services/alertsmanagement/mgmt/2018-05-05/alertsmanagement"
)

type AlertsClient = original.AlertsClient

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type BaseClient = original.BaseClient
type AlertModificationEvent = original.AlertModificationEvent

const (
	AlertCreated           AlertModificationEvent = original.AlertCreated
	MonitorConditionChange AlertModificationEvent = original.MonitorConditionChange
	StateChange            AlertModificationEvent = original.StateChange
)

type AlertsSortByFields = original.AlertsSortByFields

const (
	AlertsSortByFieldsAlertState           AlertsSortByFields = original.AlertsSortByFieldsAlertState
	AlertsSortByFieldsLastModifiedDateTime AlertsSortByFields = original.AlertsSortByFieldsLastModifiedDateTime
	AlertsSortByFieldsMonitorCondition     AlertsSortByFields = original.AlertsSortByFieldsMonitorCondition
	AlertsSortByFieldsName                 AlertsSortByFields = original.AlertsSortByFieldsName
	AlertsSortByFieldsSeverity             AlertsSortByFields = original.AlertsSortByFieldsSeverity
	AlertsSortByFieldsStartDateTime        AlertsSortByFields = original.AlertsSortByFieldsStartDateTime
	AlertsSortByFieldsTargetResource       AlertsSortByFields = original.AlertsSortByFieldsTargetResource
	AlertsSortByFieldsTargetResourceGroup  AlertsSortByFields = original.AlertsSortByFieldsTargetResourceGroup
	AlertsSortByFieldsTargetResourceName   AlertsSortByFields = original.AlertsSortByFieldsTargetResourceName
	AlertsSortByFieldsTargetResourceType   AlertsSortByFields = original.AlertsSortByFieldsTargetResourceType
)

type AlertsSummaryGroupByFields = original.AlertsSummaryGroupByFields

const (
	AlertsSummaryGroupByFieldsAlertRule        AlertsSummaryGroupByFields = original.AlertsSummaryGroupByFieldsAlertRule
	AlertsSummaryGroupByFieldsAlertState       AlertsSummaryGroupByFields = original.AlertsSummaryGroupByFieldsAlertState
	AlertsSummaryGroupByFieldsMonitorCondition AlertsSummaryGroupByFields = original.AlertsSummaryGroupByFieldsMonitorCondition
	AlertsSummaryGroupByFieldsMonitorService   AlertsSummaryGroupByFields = original.AlertsSummaryGroupByFieldsMonitorService
	AlertsSummaryGroupByFieldsSeverity         AlertsSummaryGroupByFields = original.AlertsSummaryGroupByFieldsSeverity
	AlertsSummaryGroupByFieldsSignalType       AlertsSummaryGroupByFields = original.AlertsSummaryGroupByFieldsSignalType
)

type AlertState = original.AlertState

const (
	AlertStateAcknowledged AlertState = original.AlertStateAcknowledged
	AlertStateClosed       AlertState = original.AlertStateClosed
	AlertStateNew          AlertState = original.AlertStateNew
)

type MonitorCondition = original.MonitorCondition

const (
	Fired    MonitorCondition = original.Fired
	Resolved MonitorCondition = original.Resolved
)

type MonitorService = original.MonitorService

const (
	ActivityLogAdministrative MonitorService = original.ActivityLogAdministrative
	ActivityLogAutoscale      MonitorService = original.ActivityLogAutoscale
	ActivityLogPolicy         MonitorService = original.ActivityLogPolicy
	ActivityLogRecommendation MonitorService = original.ActivityLogRecommendation
	ActivityLogSecurity       MonitorService = original.ActivityLogSecurity
	ApplicationInsights       MonitorService = original.ApplicationInsights
	LogAnalytics              MonitorService = original.LogAnalytics
	Nagios                    MonitorService = original.Nagios
	Platform                  MonitorService = original.Platform
	SCOM                      MonitorService = original.SCOM
	ServiceHealth             MonitorService = original.ServiceHealth
	SmartDetector             MonitorService = original.SmartDetector
	VMInsights                MonitorService = original.VMInsights
	Zabbix                    MonitorService = original.Zabbix
)

type Severity = original.Severity

const (
	Sev0 Severity = original.Sev0
	Sev1 Severity = original.Sev1
	Sev2 Severity = original.Sev2
	Sev3 Severity = original.Sev3
	Sev4 Severity = original.Sev4
)

type SignalType = original.SignalType

const (
	Log     SignalType = original.Log
	Metric  SignalType = original.Metric
	Unknown SignalType = original.Unknown
)

type SmartGroupModificationEvent = original.SmartGroupModificationEvent

const (
	SmartGroupModificationEventAlertAdded        SmartGroupModificationEvent = original.SmartGroupModificationEventAlertAdded
	SmartGroupModificationEventAlertRemoved      SmartGroupModificationEvent = original.SmartGroupModificationEventAlertRemoved
	SmartGroupModificationEventSmartGroupCreated SmartGroupModificationEvent = original.SmartGroupModificationEventSmartGroupCreated
	SmartGroupModificationEventStateChange       SmartGroupModificationEvent = original.SmartGroupModificationEventStateChange
)

type SmartGroupsSortByFields = original.SmartGroupsSortByFields

const (
	SmartGroupsSortByFieldsAlertsCount          SmartGroupsSortByFields = original.SmartGroupsSortByFieldsAlertsCount
	SmartGroupsSortByFieldsLastModifiedDateTime SmartGroupsSortByFields = original.SmartGroupsSortByFieldsLastModifiedDateTime
	SmartGroupsSortByFieldsSeverity             SmartGroupsSortByFields = original.SmartGroupsSortByFieldsSeverity
	SmartGroupsSortByFieldsStartDateTime        SmartGroupsSortByFields = original.SmartGroupsSortByFieldsStartDateTime
	SmartGroupsSortByFieldsState                SmartGroupsSortByFields = original.SmartGroupsSortByFieldsState
)

type State = original.State

const (
	StateAcknowledged State = original.StateAcknowledged
	StateClosed       State = original.StateClosed
	StateNew          State = original.StateNew
)

type TimeRange = original.TimeRange

const (
	Oned       TimeRange = original.Oned
	Oneh       TimeRange = original.Oneh
	Sevend     TimeRange = original.Sevend
	ThreeZerod TimeRange = original.ThreeZerod
)

type Alert = original.Alert
type AlertModification = original.AlertModification
type AlertModificationItem = original.AlertModificationItem
type AlertModificationProperties = original.AlertModificationProperties
type AlertProperties = original.AlertProperties
type AlertsList = original.AlertsList
type AlertsListIterator = original.AlertsListIterator
type AlertsListPage = original.AlertsListPage
type AlertsSummary = original.AlertsSummary
type AlertsSummaryGroup = original.AlertsSummaryGroup
type AlertsSummaryGroupItem = original.AlertsSummaryGroupItem
type ErrorResponse = original.ErrorResponse
type ErrorResponseBody = original.ErrorResponseBody
type Essentials = original.Essentials
type Operation = original.Operation
type OperationDisplay = original.OperationDisplay
type OperationsList = original.OperationsList
type OperationsListIterator = original.OperationsListIterator
type OperationsListPage = original.OperationsListPage
type Resource = original.Resource
type SmartGroup = original.SmartGroup
type SmartGroupAggregatedProperty = original.SmartGroupAggregatedProperty
type SmartGroupModification = original.SmartGroupModification
type SmartGroupModificationItem = original.SmartGroupModificationItem
type SmartGroupModificationProperties = original.SmartGroupModificationProperties
type SmartGroupProperties = original.SmartGroupProperties
type SmartGroupsList = original.SmartGroupsList
type OperationsClient = original.OperationsClient
type SmartGroupsClient = original.SmartGroupsClient

func NewAlertsClient(subscriptionID string) AlertsClient {
	return original.NewAlertsClient(subscriptionID)
}
func NewAlertsClientWithBaseURI(baseURI string, subscriptionID string) AlertsClient {
	return original.NewAlertsClientWithBaseURI(baseURI, subscriptionID)
}
func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleAlertModificationEventValues() []AlertModificationEvent {
	return original.PossibleAlertModificationEventValues()
}
func PossibleAlertsSortByFieldsValues() []AlertsSortByFields {
	return original.PossibleAlertsSortByFieldsValues()
}
func PossibleAlertsSummaryGroupByFieldsValues() []AlertsSummaryGroupByFields {
	return original.PossibleAlertsSummaryGroupByFieldsValues()
}
func PossibleAlertStateValues() []AlertState {
	return original.PossibleAlertStateValues()
}
func PossibleMonitorConditionValues() []MonitorCondition {
	return original.PossibleMonitorConditionValues()
}
func PossibleMonitorServiceValues() []MonitorService {
	return original.PossibleMonitorServiceValues()
}
func PossibleSeverityValues() []Severity {
	return original.PossibleSeverityValues()
}
func PossibleSignalTypeValues() []SignalType {
	return original.PossibleSignalTypeValues()
}
func PossibleSmartGroupModificationEventValues() []SmartGroupModificationEvent {
	return original.PossibleSmartGroupModificationEventValues()
}
func PossibleSmartGroupsSortByFieldsValues() []SmartGroupsSortByFields {
	return original.PossibleSmartGroupsSortByFieldsValues()
}
func PossibleStateValues() []State {
	return original.PossibleStateValues()
}
func PossibleTimeRangeValues() []TimeRange {
	return original.PossibleTimeRangeValues()
}
func NewAlertsListIterator(page AlertsListPage) AlertsListIterator {
	return original.NewAlertsListIterator(page)
}
func NewAlertsListPage(getNextPage func(context.Context, AlertsList) (AlertsList, error)) AlertsListPage {
	return original.NewAlertsListPage(getNextPage)
}
func NewOperationsListIterator(page OperationsListPage) OperationsListIterator {
	return original.NewOperationsListIterator(page)
}
func NewOperationsListPage(getNextPage func(context.Context, OperationsList) (OperationsList, error)) OperationsListPage {
	return original.NewOperationsListPage(getNextPage)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewSmartGroupsClient(subscriptionID string) SmartGroupsClient {
	return original.NewSmartGroupsClient(subscriptionID)
}
func NewSmartGroupsClientWithBaseURI(baseURI string, subscriptionID string) SmartGroupsClient {
	return original.NewSmartGroupsClientWithBaseURI(baseURI, subscriptionID)
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
