// +build go1.9

// Copyright 2018 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package autosuggest

import original "github.com/Azure/azure-sdk-for-go/services/cognitiveservices/v1.0/autosuggest"

const (
	DefaultEndpoint = original.DefaultEndpoint
)

type BaseClient = original.BaseClient
type ErrorCode = original.ErrorCode

const (
	InsufficientAuthorization ErrorCode = original.InsufficientAuthorization
	InvalidAuthorization      ErrorCode = original.InvalidAuthorization
	InvalidRequest            ErrorCode = original.InvalidRequest
	None                      ErrorCode = original.None
	RateLimitExceeded         ErrorCode = original.RateLimitExceeded
	ServerError               ErrorCode = original.ServerError
)

type ResponseFormat = original.ResponseFormat

const (
	JSON   ResponseFormat = original.JSON
	JSONLd ResponseFormat = original.JSONLd
)

type SafeSearch = original.SafeSearch

const (
	Moderate SafeSearch = original.Moderate
	Off      SafeSearch = original.Off
	Strict   SafeSearch = original.Strict
)

type ScenarioType = original.ScenarioType

const (
	Custom                  ScenarioType = original.Custom
	PersonalSearchDocuments ScenarioType = original.PersonalSearchDocuments
	PersonalSearchTags      ScenarioType = original.PersonalSearchTags
	SearchHistory           ScenarioType = original.SearchHistory
	StoreApps               ScenarioType = original.StoreApps
	Unknown                 ScenarioType = original.Unknown
	Web                     ScenarioType = original.Web
)

type SearchKind = original.SearchKind

const (
	CustomSearch   SearchKind = original.CustomSearch
	DocumentSearch SearchKind = original.DocumentSearch
	HistorySearch  SearchKind = original.HistorySearch
	LocationSearch SearchKind = original.LocationSearch
	TagSearch      SearchKind = original.TagSearch
	WebSearch      SearchKind = original.WebSearch
)

type Type = original.Type

const (
	TypeSuggestionsSuggestionGroup Type = original.TypeSuggestionsSuggestionGroup
)

type TypeBasicError = original.TypeBasicError

const (
	TypeError TypeBasicError = original.TypeError
)

type TypeBasicQueryContext = original.TypeBasicQueryContext

const (
	TypeQueryContext TypeBasicQueryContext = original.TypeQueryContext
)

type TypeBasicResponseBase = original.TypeBasicResponseBase

const (
	TypeAction              TypeBasicResponseBase = original.TypeAction
	TypeAnswer              TypeBasicResponseBase = original.TypeAnswer
	TypeCreativeWork        TypeBasicResponseBase = original.TypeCreativeWork
	TypeErrorResponse       TypeBasicResponseBase = original.TypeErrorResponse
	TypeIdentifiable        TypeBasicResponseBase = original.TypeIdentifiable
	TypeResponse            TypeBasicResponseBase = original.TypeResponse
	TypeResponseBase        TypeBasicResponseBase = original.TypeResponseBase
	TypeSearchAction        TypeBasicResponseBase = original.TypeSearchAction
	TypeSearchResultsAnswer TypeBasicResponseBase = original.TypeSearchResultsAnswer
	TypeSuggestions         TypeBasicResponseBase = original.TypeSuggestions
	TypeThing               TypeBasicResponseBase = original.TypeThing
)

type BasicAction = original.BasicAction
type Action = original.Action
type BasicAnswer = original.BasicAnswer
type Answer = original.Answer
type BasicCreativeWork = original.BasicCreativeWork
type CreativeWork = original.CreativeWork
type BasicError = original.BasicError
type Error = original.Error
type ErrorResponse = original.ErrorResponse
type BasicIdentifiable = original.BasicIdentifiable
type Identifiable = original.Identifiable
type BasicQueryContext = original.BasicQueryContext
type QueryContext = original.QueryContext
type BasicResponse = original.BasicResponse
type Response = original.Response
type BasicResponseBase = original.BasicResponseBase
type ResponseBase = original.ResponseBase
type SearchAction = original.SearchAction
type BasicSearchResultsAnswer = original.BasicSearchResultsAnswer
type SearchResultsAnswer = original.SearchResultsAnswer
type Suggestions = original.Suggestions
type BasicSuggestionsSuggestionGroup = original.BasicSuggestionsSuggestionGroup
type SuggestionsSuggestionGroup = original.SuggestionsSuggestionGroup
type BasicThing = original.BasicThing
type Thing = original.Thing

func New() BaseClient {
	return original.New()
}
func NewWithoutDefaults(endpoint string) BaseClient {
	return original.NewWithoutDefaults(endpoint)
}
func PossibleErrorCodeValues() []ErrorCode {
	return original.PossibleErrorCodeValues()
}
func PossibleResponseFormatValues() []ResponseFormat {
	return original.PossibleResponseFormatValues()
}
func PossibleSafeSearchValues() []SafeSearch {
	return original.PossibleSafeSearchValues()
}
func PossibleScenarioTypeValues() []ScenarioType {
	return original.PossibleScenarioTypeValues()
}
func PossibleSearchKindValues() []SearchKind {
	return original.PossibleSearchKindValues()
}
func PossibleTypeValues() []Type {
	return original.PossibleTypeValues()
}
func PossibleTypeBasicErrorValues() []TypeBasicError {
	return original.PossibleTypeBasicErrorValues()
}
func PossibleTypeBasicQueryContextValues() []TypeBasicQueryContext {
	return original.PossibleTypeBasicQueryContextValues()
}
func PossibleTypeBasicResponseBaseValues() []TypeBasicResponseBase {
	return original.PossibleTypeBasicResponseBaseValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
