// Code generated by protoc-gen-gogo.
// source: cockroach/pkg/roachpb/errors.proto
// DO NOT EDIT!

package roachpb

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"
import cockroach_util_hlc "github.com/cockroachdb/cockroach/pkg/util/hlc"

import github_com_cockroachdb_cockroach_pkg_util_uuid "github.com/cockroachdb/cockroach/pkg/util/uuid"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// TransactionRetryReason specifies what caused a transaction retry.
type TransactionRetryReason int32

const (
	// For backwards compatibility.
	RETRY_REASON_UNKNOWN TransactionRetryReason = 0
	// A concurrent writer finished first, causing restart.
	RETRY_WRITE_TOO_OLD TransactionRetryReason = 1
	// A transaction containing a delete range command had its timestamp
	// moved forward.
	RETRY_DELETE_RANGE TransactionRetryReason = 2
	// A SERIALIZABLE transaction had its timestamp moved forward.
	RETRY_SERIALIZABLE TransactionRetryReason = 3
	// A possible replay caused by duplicate begin txn or out-of-order
	// txn sequence number.
	RETRY_POSSIBLE_REPLAY TransactionRetryReason = 4
)

var TransactionRetryReason_name = map[int32]string{
	0: "RETRY_REASON_UNKNOWN",
	1: "RETRY_WRITE_TOO_OLD",
	2: "RETRY_DELETE_RANGE",
	3: "RETRY_SERIALIZABLE",
	4: "RETRY_POSSIBLE_REPLAY",
}
var TransactionRetryReason_value = map[string]int32{
	"RETRY_REASON_UNKNOWN":  0,
	"RETRY_WRITE_TOO_OLD":   1,
	"RETRY_DELETE_RANGE":    2,
	"RETRY_SERIALIZABLE":    3,
	"RETRY_POSSIBLE_REPLAY": 4,
}

func (x TransactionRetryReason) Enum() *TransactionRetryReason {
	p := new(TransactionRetryReason)
	*p = x
	return p
}
func (x TransactionRetryReason) String() string {
	return proto.EnumName(TransactionRetryReason_name, int32(x))
}
func (x *TransactionRetryReason) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(TransactionRetryReason_value, data, "TransactionRetryReason")
	if err != nil {
		return err
	}
	*x = TransactionRetryReason(value)
	return nil
}
func (TransactionRetryReason) EnumDescriptor() ([]byte, []int) { return fileDescriptorErrors, []int{0} }

// TransactionRestart indicates how an error should be handled in a
// transactional context.
type TransactionRestart int32

const (
	//  NONE (the default) is used for errors which have no effect on the
	//  transaction state. That is, a transactional operation which receives such
	//  an error is still PENDING and does not need to restart (at least not as a
	//  result of the error). Examples are a CPut whose condition wasn't met, or
	//  a spurious RPC error.
	TransactionRestart_NONE TransactionRestart = 0
	// BACKOFF is for errors that can retried by restarting the transaction
	// after an exponential backoff.
	// Note: Deprecated.
	TransactionRestart_BACKOFF TransactionRestart = 1
	// IMMEDIATE is for errors that can be retried by restarting the
	// transaction immediately.
	TransactionRestart_IMMEDIATE TransactionRestart = 2
)

var TransactionRestart_name = map[int32]string{
	0: "NONE",
	1: "BACKOFF",
	2: "IMMEDIATE",
}
var TransactionRestart_value = map[string]int32{
	"NONE":      0,
	"BACKOFF":   1,
	"IMMEDIATE": 2,
}

func (x TransactionRestart) Enum() *TransactionRestart {
	p := new(TransactionRestart)
	*p = x
	return p
}
func (x TransactionRestart) String() string {
	return proto.EnumName(TransactionRestart_name, int32(x))
}
func (x *TransactionRestart) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(TransactionRestart_value, data, "TransactionRestart")
	if err != nil {
		return err
	}
	*x = TransactionRestart(value)
	return nil
}
func (TransactionRestart) EnumDescriptor() ([]byte, []int) { return fileDescriptorErrors, []int{1} }

// A NotLeaseHolderError indicates that the current range is not the lease
// holder. If the lease holder is known, its Replica is set in the error.
type NotLeaseHolderError struct {
	// The replica the error originated from. Used in the error's string
	// representation.
	Replica ReplicaDescriptor `protobuf:"bytes,1,opt,name=replica" json:"replica"`
	// The lease holder, if known.
	LeaseHolder *ReplicaDescriptor `protobuf:"bytes,2,opt,name=lease_holder,json=leaseHolder" json:"lease_holder,omitempty"`
	// The current lease, if known. This might be nil even when lease_holder is
	// set, as sometimes one can create this error without actually knowing the
	// current lease, but having a guess about who the leader is.
	Lease   *Lease  `protobuf:"bytes,4,opt,name=lease" json:"lease,omitempty"`
	RangeID RangeID `protobuf:"varint,3,opt,name=range_id,json=rangeId,casttype=RangeID" json:"range_id"`
	// If set, the Error() method will return this instead of composing its
	// regular spiel. Useful because we reuse this error when rejecting a command
	// because the lease under which its application was attempted is different
	// than the lease under which it had been proposed.
	CustomMsg string `protobuf:"bytes,5,opt,name=custom_msg,json=customMsg" json:"custom_msg"`
}

func (m *NotLeaseHolderError) Reset()                    { *m = NotLeaseHolderError{} }
func (m *NotLeaseHolderError) String() string            { return proto.CompactTextString(m) }
func (*NotLeaseHolderError) ProtoMessage()               {}
func (*NotLeaseHolderError) Descriptor() ([]byte, []int) { return fileDescriptorErrors, []int{0} }

// A NodeUnavailableError indicates that the sending gateway can
// not process requests at the time, and that the client should
// retry the request with another peer.
type NodeUnavailableError struct {
}

func (m *NodeUnavailableError) Reset()                    { *m = NodeUnavailableError{} }
func (m *NodeUnavailableError) String() string            { return proto.CompactTextString(m) }
func (*NodeUnavailableError) ProtoMessage()               {}
func (*NodeUnavailableError) Descriptor() ([]byte, []int) { return fileDescriptorErrors, []int{1} }

// A RangeNotFoundError indicates that a command was sent to a range
// which is not hosted on this store.
type RangeNotFoundError struct {
	RangeID RangeID `protobuf:"varint,1,opt,name=range_id,json=rangeId,casttype=RangeID" json:"range_id"`
}

func (m *RangeNotFoundError) Reset()                    { *m = RangeNotFoundError{} }
func (m *RangeNotFoundError) String() string            { return proto.CompactTextString(m) }
func (*RangeNotFoundError) ProtoMessage()               {}
func (*RangeNotFoundError) Descriptor() ([]byte, []int) { return fileDescriptorErrors, []int{2} }

// A RangeKeyMismatchError indicates that a command was sent to a
// range which did not contain the key(s) specified by the command.
type RangeKeyMismatchError struct {
	RequestStartKey Key `protobuf:"bytes,1,opt,name=request_start_key,json=requestStartKey,casttype=Key" json:"request_start_key,omitempty"`
	RequestEndKey   Key `protobuf:"bytes,2,opt,name=request_end_key,json=requestEndKey,casttype=Key" json:"request_end_key,omitempty"`
	// mismatched_range is the range that the command was incorrectly sent to.
	// It is used to update the sender's range cache without an additional range
	// lookup.
	MismatchedRange *RangeDescriptor `protobuf:"bytes,3,opt,name=mismatched_range,json=mismatchedRange" json:"mismatched_range,omitempty"`
	// suggested_range is a hint to the sender of a command about the range
	// they may be looking for. It is only populated when the recipient has
	// authoritative knowledge of the range requested by the sender.
	SuggestedRange *RangeDescriptor `protobuf:"bytes,4,opt,name=suggested_range,json=suggestedRange" json:"suggested_range,omitempty"`
}

func (m *RangeKeyMismatchError) Reset()                    { *m = RangeKeyMismatchError{} }
func (m *RangeKeyMismatchError) String() string            { return proto.CompactTextString(m) }
func (*RangeKeyMismatchError) ProtoMessage()               {}
func (*RangeKeyMismatchError) Descriptor() ([]byte, []int) { return fileDescriptorErrors, []int{3} }

// A ReadWithinUncertaintyIntervalError indicates that a read at timestamp
// encountered a write within the uncertainty interval of the reader.
// The read should be retried at a higher timestamp; the timestamps contained
// within are purely informational, though typically existing_timestamp is a
// lower bound for a new timestamp at which at least the read producing
// this error would succeed on retry.
type ReadWithinUncertaintyIntervalError struct {
	ReadTimestamp     cockroach_util_hlc.Timestamp `protobuf:"bytes,1,opt,name=read_timestamp,json=readTimestamp" json:"read_timestamp"`
	ExistingTimestamp cockroach_util_hlc.Timestamp `protobuf:"bytes,2,opt,name=existing_timestamp,json=existingTimestamp" json:"existing_timestamp"`
}

func (m *ReadWithinUncertaintyIntervalError) Reset()         { *m = ReadWithinUncertaintyIntervalError{} }
func (m *ReadWithinUncertaintyIntervalError) String() string { return proto.CompactTextString(m) }
func (*ReadWithinUncertaintyIntervalError) ProtoMessage()    {}
func (*ReadWithinUncertaintyIntervalError) Descriptor() ([]byte, []int) {
	return fileDescriptorErrors, []int{4}
}

// A TransactionAbortedError indicates that the transaction was aborted by
// another concurrent transaction. Upon seeing this error, the client is
// supposed to reset its Transaction proto and try the transaction again.
//
// In contrast with other errors, the Transaction that the client gets in the
// pErr carrying this ErrorDetail is not supposed to be used by the client,
// besides checking that the transaction's ID is right.
type TransactionAbortedError struct {
}

func (m *TransactionAbortedError) Reset()                    { *m = TransactionAbortedError{} }
func (m *TransactionAbortedError) String() string            { return proto.CompactTextString(m) }
func (*TransactionAbortedError) ProtoMessage()               {}
func (*TransactionAbortedError) Descriptor() ([]byte, []int) { return fileDescriptorErrors, []int{5} }

// A TransactionPushError indicates that the transaction could not
// continue because it encountered a write intent from another
// transaction which it was unable to push.
type TransactionPushError struct {
	PusheeTxn Transaction `protobuf:"bytes,1,opt,name=pushee_txn,json=pusheeTxn" json:"pushee_txn"`
}

func (m *TransactionPushError) Reset()                    { *m = TransactionPushError{} }
func (m *TransactionPushError) String() string            { return proto.CompactTextString(m) }
func (*TransactionPushError) ProtoMessage()               {}
func (*TransactionPushError) Descriptor() ([]byte, []int) { return fileDescriptorErrors, []int{6} }

// A TransactionRetryError indicates that the transaction must be
// retried, usually with an increased transaction timestamp.
type TransactionRetryError struct {
	Reason TransactionRetryReason `protobuf:"varint,1,opt,name=reason,enum=cockroach.roachpb.TransactionRetryReason" json:"reason"`
}

func (m *TransactionRetryError) Reset()                    { *m = TransactionRetryError{} }
func (m *TransactionRetryError) String() string            { return proto.CompactTextString(m) }
func (*TransactionRetryError) ProtoMessage()               {}
func (*TransactionRetryError) Descriptor() ([]byte, []int) { return fileDescriptorErrors, []int{7} }

// A TransactionReplayError indicates that a BeginTransaction request
// is being replayed. This can happen on network replays in which a
// BeginTransaction request is sent again either from the client or
// is belatedly delivered after an earlier attempt succeeded.
type TransactionReplayError struct {
}

func (m *TransactionReplayError) Reset()                    { *m = TransactionReplayError{} }
func (m *TransactionReplayError) String() string            { return proto.CompactTextString(m) }
func (*TransactionReplayError) ProtoMessage()               {}
func (*TransactionReplayError) Descriptor() ([]byte, []int) { return fileDescriptorErrors, []int{8} }

// A TransactionStatusError indicates that the transaction status is
// incompatible with the requested operation. This might mean the
// transaction has already been committed. It might also be the case
// that the request to modify the transaction failed due to a
// regression in transaction epoch or timestamp, both of which may
// only monotonically increase.
type TransactionStatusError struct {
	Msg string `protobuf:"bytes,1,opt,name=msg" json:"msg"`
}

func (m *TransactionStatusError) Reset()                    { *m = TransactionStatusError{} }
func (m *TransactionStatusError) String() string            { return proto.CompactTextString(m) }
func (*TransactionStatusError) ProtoMessage()               {}
func (*TransactionStatusError) Descriptor() ([]byte, []int) { return fileDescriptorErrors, []int{9} }

// A WriteIntentError indicates that one or more write intent
// belonging to another transaction were encountered leading to a
// read/write or write/write conflict. The keys at which the intent
// was encountered are set, as are the txn records for the intents'
// transactions.
type WriteIntentError struct {
	Intents []Intent `protobuf:"bytes,1,rep,name=intents" json:"intents"`
}

func (m *WriteIntentError) Reset()                    { *m = WriteIntentError{} }
func (m *WriteIntentError) String() string            { return proto.CompactTextString(m) }
func (*WriteIntentError) ProtoMessage()               {}
func (*WriteIntentError) Descriptor() ([]byte, []int) { return fileDescriptorErrors, []int{10} }

// A WriteTooOldError indicates that a write encountered a versioned
// value newer than its timestamp, making it impossible to rewrite
// history. The write is instead done at actual timestamp, which is
// the timestamp of the existing version+1.
type WriteTooOldError struct {
	Timestamp       cockroach_util_hlc.Timestamp `protobuf:"bytes,1,opt,name=timestamp" json:"timestamp"`
	ActualTimestamp cockroach_util_hlc.Timestamp `protobuf:"bytes,2,opt,name=actual_timestamp,json=actualTimestamp" json:"actual_timestamp"`
}

func (m *WriteTooOldError) Reset()                    { *m = WriteTooOldError{} }
func (m *WriteTooOldError) String() string            { return proto.CompactTextString(m) }
func (*WriteTooOldError) ProtoMessage()               {}
func (*WriteTooOldError) Descriptor() ([]byte, []int) { return fileDescriptorErrors, []int{11} }

// An OpRequiresTxnError indicates that a command required to be
// carried out in a transactional context but was not.
// For example, a Scan which spans ranges requires a transaction.
// The operation should be retried inside of a transaction.
type OpRequiresTxnError struct {
}

func (m *OpRequiresTxnError) Reset()                    { *m = OpRequiresTxnError{} }
func (m *OpRequiresTxnError) String() string            { return proto.CompactTextString(m) }
func (*OpRequiresTxnError) ProtoMessage()               {}
func (*OpRequiresTxnError) Descriptor() ([]byte, []int) { return fileDescriptorErrors, []int{12} }

// A ConditionFailedError indicates that the expected value
// of a ConditionalPutRequest was not found, either
// because it was missing or was not equal. The error will
// contain the actual value found.
type ConditionFailedError struct {
	ActualValue *Value `protobuf:"bytes,1,opt,name=actual_value,json=actualValue" json:"actual_value,omitempty"`
}

func (m *ConditionFailedError) Reset()                    { *m = ConditionFailedError{} }
func (m *ConditionFailedError) String() string            { return proto.CompactTextString(m) }
func (*ConditionFailedError) ProtoMessage()               {}
func (*ConditionFailedError) Descriptor() ([]byte, []int) { return fileDescriptorErrors, []int{13} }

// A LeaseRejectedError indicates that the requested replica could
// not acquire the desired lease because of an existing range lease.
type LeaseRejectedError struct {
	Message   string `protobuf:"bytes,1,opt,name=message" json:"message"`
	Requested Lease  `protobuf:"bytes,2,opt,name=requested" json:"requested"`
	Existing  Lease  `protobuf:"bytes,3,opt,name=existing" json:"existing"`
}

func (m *LeaseRejectedError) Reset()                    { *m = LeaseRejectedError{} }
func (m *LeaseRejectedError) String() string            { return proto.CompactTextString(m) }
func (*LeaseRejectedError) ProtoMessage()               {}
func (*LeaseRejectedError) Descriptor() ([]byte, []int) { return fileDescriptorErrors, []int{14} }

// A SendError indicates that a message could not be delivered to
// the desired recipient(s).
type SendError struct {
	Message string `protobuf:"bytes,1,opt,name=message" json:"message"`
}

func (m *SendError) Reset()                    { *m = SendError{} }
func (m *SendError) String() string            { return proto.CompactTextString(m) }
func (*SendError) ProtoMessage()               {}
func (*SendError) Descriptor() ([]byte, []int) { return fileDescriptorErrors, []int{15} }

// An AmbiguousResultError indicates that a request may have succeeded or
// failed, but the response was not received and the final result is ambiguous.
type AmbiguousResultError struct {
	Message string `protobuf:"bytes,1,opt,name=message" json:"message"`
	// This can be set to give extra information about which error was converted
	// into an AmbiguousResultError. Useful for tests.
	WrappedErr *Error `protobuf:"bytes,2,opt,name=wrapped_err,json=wrappedErr" json:"wrapped_err,omitempty"`
}

func (m *AmbiguousResultError) Reset()                    { *m = AmbiguousResultError{} }
func (m *AmbiguousResultError) String() string            { return proto.CompactTextString(m) }
func (*AmbiguousResultError) ProtoMessage()               {}
func (*AmbiguousResultError) Descriptor() ([]byte, []int) { return fileDescriptorErrors, []int{16} }

// A RaftGroupDeletedError indicates a raft group has been deleted for
// the replica.
type RaftGroupDeletedError struct {
}

func (m *RaftGroupDeletedError) Reset()                    { *m = RaftGroupDeletedError{} }
func (m *RaftGroupDeletedError) String() string            { return proto.CompactTextString(m) }
func (*RaftGroupDeletedError) ProtoMessage()               {}
func (*RaftGroupDeletedError) Descriptor() ([]byte, []int) { return fileDescriptorErrors, []int{17} }

// A ReplicaCorruptionError indicates that the replica has experienced
// an error which puts its integrity at risk.
type ReplicaCorruptionError struct {
	ErrorMsg string `protobuf:"bytes,1,opt,name=error_msg,json=errorMsg" json:"error_msg"`
	// processed indicates that the error has been taken into account and
	// necessary steps will be taken. For now, required for testing.
	Processed bool `protobuf:"varint,2,opt,name=processed" json:"processed"`
}

func (m *ReplicaCorruptionError) Reset()                    { *m = ReplicaCorruptionError{} }
func (m *ReplicaCorruptionError) String() string            { return proto.CompactTextString(m) }
func (*ReplicaCorruptionError) ProtoMessage()               {}
func (*ReplicaCorruptionError) Descriptor() ([]byte, []int) { return fileDescriptorErrors, []int{18} }

// ReplicaTooOldError is sent in response to a raft message when the
// recipient of the raft message believes the sender of the raft
// message to have been removed from the raft group
type ReplicaTooOldError struct {
	// replica_id is the ID of the replica that is too old.
	ReplicaID ReplicaID `protobuf:"varint,1,opt,name=replica_id,json=replicaId,casttype=ReplicaID" json:"replica_id"`
}

func (m *ReplicaTooOldError) Reset()                    { *m = ReplicaTooOldError{} }
func (m *ReplicaTooOldError) String() string            { return proto.CompactTextString(m) }
func (*ReplicaTooOldError) ProtoMessage()               {}
func (*ReplicaTooOldError) Descriptor() ([]byte, []int) { return fileDescriptorErrors, []int{19} }

// A StoreNotFoundError indicates that a command was sent to a store
// which is not hosted on this node.
type StoreNotFoundError struct {
	StoreID StoreID `protobuf:"varint,1,opt,name=store_id,json=storeId,casttype=StoreID" json:"store_id"`
}

func (m *StoreNotFoundError) Reset()                    { *m = StoreNotFoundError{} }
func (m *StoreNotFoundError) String() string            { return proto.CompactTextString(m) }
func (*StoreNotFoundError) ProtoMessage()               {}
func (*StoreNotFoundError) Descriptor() ([]byte, []int) { return fileDescriptorErrors, []int{20} }

// ErrorDetail is a union type containing all available errors.
type ErrorDetail struct {
	NotLeaseHolder                *NotLeaseHolderError                `protobuf:"bytes,1,opt,name=not_lease_holder,json=notLeaseHolder" json:"not_lease_holder,omitempty"`
	RangeNotFound                 *RangeNotFoundError                 `protobuf:"bytes,2,opt,name=range_not_found,json=rangeNotFound" json:"range_not_found,omitempty"`
	RangeKeyMismatch              *RangeKeyMismatchError              `protobuf:"bytes,3,opt,name=range_key_mismatch,json=rangeKeyMismatch" json:"range_key_mismatch,omitempty"`
	ReadWithinUncertaintyInterval *ReadWithinUncertaintyIntervalError `protobuf:"bytes,4,opt,name=read_within_uncertainty_interval,json=readWithinUncertaintyInterval" json:"read_within_uncertainty_interval,omitempty"`
	TransactionAborted            *TransactionAbortedError            `protobuf:"bytes,5,opt,name=transaction_aborted,json=transactionAborted" json:"transaction_aborted,omitempty"`
	TransactionPush               *TransactionPushError               `protobuf:"bytes,6,opt,name=transaction_push,json=transactionPush" json:"transaction_push,omitempty"`
	TransactionRetry              *TransactionRetryError              `protobuf:"bytes,7,opt,name=transaction_retry,json=transactionRetry" json:"transaction_retry,omitempty"`
	TransactionReplay             *TransactionReplayError             `protobuf:"bytes,22,opt,name=transaction_replay,json=transactionReplay" json:"transaction_replay,omitempty"`
	TransactionStatus             *TransactionStatusError             `protobuf:"bytes,8,opt,name=transaction_status,json=transactionStatus" json:"transaction_status,omitempty"`
	WriteIntent                   *WriteIntentError                   `protobuf:"bytes,9,opt,name=write_intent,json=writeIntent" json:"write_intent,omitempty"`
	WriteTooOld                   *WriteTooOldError                   `protobuf:"bytes,10,opt,name=write_too_old,json=writeTooOld" json:"write_too_old,omitempty"`
	OpRequiresTxn                 *OpRequiresTxnError                 `protobuf:"bytes,11,opt,name=op_requires_txn,json=opRequiresTxn" json:"op_requires_txn,omitempty"`
	ConditionFailed               *ConditionFailedError               `protobuf:"bytes,12,opt,name=condition_failed,json=conditionFailed" json:"condition_failed,omitempty"`
	LeaseRejected                 *LeaseRejectedError                 `protobuf:"bytes,13,opt,name=lease_rejected,json=leaseRejected" json:"lease_rejected,omitempty"`
	NodeUnavailable               *NodeUnavailableError               `protobuf:"bytes,14,opt,name=node_unavailable,json=nodeUnavailable" json:"node_unavailable,omitempty"`
	Send                          *SendError                          `protobuf:"bytes,15,opt,name=send" json:"send,omitempty"`
	AmbiguousResult               *AmbiguousResultError               `protobuf:"bytes,26,opt,name=ambiguous_result,json=ambiguousResult" json:"ambiguous_result,omitempty"`
	StoreNotFound                 *StoreNotFoundError                 `protobuf:"bytes,27,opt,name=store_not_found,json=storeNotFound" json:"store_not_found,omitempty"`
	// HandledRetryableError is an ErrorDetail (and a proto message) because it
	// needs to be communicated from the TxnCoordSender to the upper layers
	// through the Sender interface.
	HandledRetryableTxnError *HandledRetryableTxnError `protobuf:"bytes,28,opt,name=handled_retryable_txn_error,json=handledRetryableTxnError" json:"handled_retryable_txn_error,omitempty"`
	// TODO(kaneda): Following are added to preserve the type when
	// converting Go errors from/to proto Errors. Revisit this design.
	RaftGroupDeleted  *RaftGroupDeletedError  `protobuf:"bytes,16,opt,name=raft_group_deleted,json=raftGroupDeleted" json:"raft_group_deleted,omitempty"`
	ReplicaCorruption *ReplicaCorruptionError `protobuf:"bytes,17,opt,name=replica_corruption,json=replicaCorruption" json:"replica_corruption,omitempty"`
	ReplicaTooOld     *ReplicaTooOldError     `protobuf:"bytes,18,opt,name=replica_too_old,json=replicaTooOld" json:"replica_too_old,omitempty"`
}

func (m *ErrorDetail) Reset()                    { *m = ErrorDetail{} }
func (m *ErrorDetail) String() string            { return proto.CompactTextString(m) }
func (*ErrorDetail) ProtoMessage()               {}
func (*ErrorDetail) Descriptor() ([]byte, []int) { return fileDescriptorErrors, []int{21} }

// ErrPosition describes the position of an error in a Batch. A simple nullable
// primitive field would break compatibility with proto3, where primitive fields
// are no longer allowed to be nullable.
type ErrPosition struct {
	Index int32 `protobuf:"varint,1,opt,name=index" json:"index"`
}

func (m *ErrPosition) Reset()                    { *m = ErrPosition{} }
func (m *ErrPosition) String() string            { return proto.CompactTextString(m) }
func (*ErrPosition) ProtoMessage()               {}
func (*ErrPosition) Descriptor() ([]byte, []int) { return fileDescriptorErrors, []int{22} }

// Error is a generic representation including a string message
// and information about retryability.
type Error struct {
	// message is a human-readable error message.
	Message string `protobuf:"bytes,1,opt,name=message" json:"message"`
	// If transaction_restart is not ABORT, the error condition may be handled by
	// restarting the transaction.
	TransactionRestart TransactionRestart `protobuf:"varint,3,opt,name=transaction_restart,json=transactionRestart,enum=cockroach.roachpb.TransactionRestart" json:"transaction_restart"`
	// An optional updated transaction. This is to be used by the client in case
	// of retryable errors.
	//
	// Not to be accessed directly - use Error.GetTxn().
	UnexposedTxn *Transaction `protobuf:"bytes,4,opt,name=unexposed_txn,json=unexposedTxn" json:"unexposed_txn,omitempty"`
	// Node at which the error was generated (zero if does not apply).
	OriginNode NodeID `protobuf:"varint,5,opt,name=origin_node,json=originNode,casttype=NodeID" json:"origin_node"`
	// If an ErrorDetail is present, it may contain additional structured data
	// about the error.
	Detail *ErrorDetail `protobuf:"bytes,6,opt,name=detail" json:"detail,omitempty"`
	// The index, if given, contains the index of the request (in the batch)
	// whose execution caused the error.
	Index *ErrPosition `protobuf:"bytes,7,opt,name=index" json:"index,omitempty"`
	// now is the current time at the node sending the response,
	// which can be used by the receiver to update its local HLC.
	Now cockroach_util_hlc.Timestamp `protobuf:"bytes,8,opt,name=now" json:"now"`
}

func (m *Error) Reset()                    { *m = Error{} }
func (*Error) ProtoMessage()               {}
func (*Error) Descriptor() ([]byte, []int) { return fileDescriptorErrors, []int{23} }

// UnhandledRetryableError tells the recipient that a KV request must be
// retried. In case the request was transactional, the whole transaction needs
// to be retried. This is returned generally as a result of a transaction
// conflict.
//
// This error is generated by pErr.GoError() in case of a retryable error (other
// than HandledRetryableTxnError). For transactional requests, the
// TxnCoordSender handles retryable pErrs and transform them into
// HandledRetryableTxnError. So, for transactional requests, only DistSQL is
// supposed to see this error (as it doesn't go through TxnCoordSender). For
// non-transactional requests, this error will be observed by layers above the
// TxnCoordSender.
type UnhandledRetryableError struct {
	// The underlying storage error that is being marshalled.
	// pErr.TransactionRestart is exected to be set, and the error detail is one
	// of the retryable ones.
	PErr Error `protobuf:"bytes,1,opt,name=pErr" json:"pErr"`
}

func (m *UnhandledRetryableError) Reset()                    { *m = UnhandledRetryableError{} }
func (m *UnhandledRetryableError) String() string            { return proto.CompactTextString(m) }
func (*UnhandledRetryableError) ProtoMessage()               {}
func (*UnhandledRetryableError) Descriptor() ([]byte, []int) { return fileDescriptorErrors, []int{24} }

// HandledRetryableTxnError is an error detail representing a retryable error
// that has been "handled" by the TxnCoordSender. This error is produced by the
// TxnCoordSender and is only produced for transactional requests.
//
// It contains the final form of the Transaction proto that should be used on
// next attempts. After being produced by the TxnCoordSender, this error is
// handled first by the client.Txn, which uses the Transaction inside to update
// its state, and then passed along to SQL in a pErr (through the
// client.Sender() interface).
type HandledRetryableTxnError struct {
	// A user-readable message.
	Msg string `protobuf:"bytes,1,opt,name=msg" json:"msg"`
	// The ID of the transaction being restarted. The client is supposed to check
	// this against the ID of its transaction and make sure the retryable error
	// is meant for its level and didn't escape from some inner transaction.
	//
	// TODO(andrei): make this non-nullable (and thus required) if we manage to
	// make Transaction.ID non-nullable.
	TxnID *github_com_cockroachdb_cockroach_pkg_util_uuid.UUID `protobuf:"bytes,2,opt,name=txn_id,json=txnId,customtype=github.com/cockroachdb/cockroach/pkg/util/uuid.UUID" json:"txn_id,omitempty"`
	// The Transaction that should be used by next attempts. Depending on the
	// original cause of this method, this can either be the same Transaction as
	// before, but with an incremented epoch and timestamp, or a completely new
	// Transaction.
	Transaction *Transaction `protobuf:"bytes,3,opt,name=transaction" json:"transaction,omitempty"`
}

func (m *HandledRetryableTxnError) Reset()                    { *m = HandledRetryableTxnError{} }
func (m *HandledRetryableTxnError) String() string            { return proto.CompactTextString(m) }
func (*HandledRetryableTxnError) ProtoMessage()               {}
func (*HandledRetryableTxnError) Descriptor() ([]byte, []int) { return fileDescriptorErrors, []int{25} }

func init() {
	proto.RegisterType((*NotLeaseHolderError)(nil), "cockroach.roachpb.NotLeaseHolderError")
	proto.RegisterType((*NodeUnavailableError)(nil), "cockroach.roachpb.NodeUnavailableError")
	proto.RegisterType((*RangeNotFoundError)(nil), "cockroach.roachpb.RangeNotFoundError")
	proto.RegisterType((*RangeKeyMismatchError)(nil), "cockroach.roachpb.RangeKeyMismatchError")
	proto.RegisterType((*ReadWithinUncertaintyIntervalError)(nil), "cockroach.roachpb.ReadWithinUncertaintyIntervalError")
	proto.RegisterType((*TransactionAbortedError)(nil), "cockroach.roachpb.TransactionAbortedError")
	proto.RegisterType((*TransactionPushError)(nil), "cockroach.roachpb.TransactionPushError")
	proto.RegisterType((*TransactionRetryError)(nil), "cockroach.roachpb.TransactionRetryError")
	proto.RegisterType((*TransactionReplayError)(nil), "cockroach.roachpb.TransactionReplayError")
	proto.RegisterType((*TransactionStatusError)(nil), "cockroach.roachpb.TransactionStatusError")
	proto.RegisterType((*WriteIntentError)(nil), "cockroach.roachpb.WriteIntentError")
	proto.RegisterType((*WriteTooOldError)(nil), "cockroach.roachpb.WriteTooOldError")
	proto.RegisterType((*OpRequiresTxnError)(nil), "cockroach.roachpb.OpRequiresTxnError")
	proto.RegisterType((*ConditionFailedError)(nil), "cockroach.roachpb.ConditionFailedError")
	proto.RegisterType((*LeaseRejectedError)(nil), "cockroach.roachpb.LeaseRejectedError")
	proto.RegisterType((*SendError)(nil), "cockroach.roachpb.SendError")
	proto.RegisterType((*AmbiguousResultError)(nil), "cockroach.roachpb.AmbiguousResultError")
	proto.RegisterType((*RaftGroupDeletedError)(nil), "cockroach.roachpb.RaftGroupDeletedError")
	proto.RegisterType((*ReplicaCorruptionError)(nil), "cockroach.roachpb.ReplicaCorruptionError")
	proto.RegisterType((*ReplicaTooOldError)(nil), "cockroach.roachpb.ReplicaTooOldError")
	proto.RegisterType((*StoreNotFoundError)(nil), "cockroach.roachpb.StoreNotFoundError")
	proto.RegisterType((*ErrorDetail)(nil), "cockroach.roachpb.ErrorDetail")
	proto.RegisterType((*ErrPosition)(nil), "cockroach.roachpb.ErrPosition")
	proto.RegisterType((*Error)(nil), "cockroach.roachpb.Error")
	proto.RegisterType((*UnhandledRetryableError)(nil), "cockroach.roachpb.UnhandledRetryableError")
	proto.RegisterType((*HandledRetryableTxnError)(nil), "cockroach.roachpb.HandledRetryableTxnError")
	proto.RegisterEnum("cockroach.roachpb.TransactionRetryReason", TransactionRetryReason_name, TransactionRetryReason_value)
	proto.RegisterEnum("cockroach.roachpb.TransactionRestart", TransactionRestart_name, TransactionRestart_value)
}
func (m *NotLeaseHolderError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NotLeaseHolderError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintErrors(dAtA, i, uint64(m.Replica.Size()))
	n1, err := m.Replica.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n1
	if m.LeaseHolder != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.LeaseHolder.Size()))
		n2, err := m.LeaseHolder.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	dAtA[i] = 0x18
	i++
	i = encodeVarintErrors(dAtA, i, uint64(m.RangeID))
	if m.Lease != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.Lease.Size()))
		n3, err := m.Lease.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	dAtA[i] = 0x2a
	i++
	i = encodeVarintErrors(dAtA, i, uint64(len(m.CustomMsg)))
	i += copy(dAtA[i:], m.CustomMsg)
	return i, nil
}

func (m *NodeUnavailableError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *NodeUnavailableError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *RangeNotFoundError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RangeNotFoundError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintErrors(dAtA, i, uint64(m.RangeID))
	return i, nil
}

func (m *RangeKeyMismatchError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RangeKeyMismatchError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.RequestStartKey != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintErrors(dAtA, i, uint64(len(m.RequestStartKey)))
		i += copy(dAtA[i:], m.RequestStartKey)
	}
	if m.RequestEndKey != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintErrors(dAtA, i, uint64(len(m.RequestEndKey)))
		i += copy(dAtA[i:], m.RequestEndKey)
	}
	if m.MismatchedRange != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.MismatchedRange.Size()))
		n4, err := m.MismatchedRange.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if m.SuggestedRange != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.SuggestedRange.Size()))
		n5, err := m.SuggestedRange.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	return i, nil
}

func (m *ReadWithinUncertaintyIntervalError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReadWithinUncertaintyIntervalError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintErrors(dAtA, i, uint64(m.ReadTimestamp.Size()))
	n6, err := m.ReadTimestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n6
	dAtA[i] = 0x12
	i++
	i = encodeVarintErrors(dAtA, i, uint64(m.ExistingTimestamp.Size()))
	n7, err := m.ExistingTimestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n7
	return i, nil
}

func (m *TransactionAbortedError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TransactionAbortedError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *TransactionPushError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TransactionPushError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintErrors(dAtA, i, uint64(m.PusheeTxn.Size()))
	n8, err := m.PusheeTxn.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n8
	return i, nil
}

func (m *TransactionRetryError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TransactionRetryError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintErrors(dAtA, i, uint64(m.Reason))
	return i, nil
}

func (m *TransactionReplayError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TransactionReplayError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *TransactionStatusError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *TransactionStatusError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintErrors(dAtA, i, uint64(len(m.Msg)))
	i += copy(dAtA[i:], m.Msg)
	return i, nil
}

func (m *WriteIntentError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WriteIntentError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Intents) > 0 {
		for _, msg := range m.Intents {
			dAtA[i] = 0xa
			i++
			i = encodeVarintErrors(dAtA, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(dAtA[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	return i, nil
}

func (m *WriteTooOldError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *WriteTooOldError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintErrors(dAtA, i, uint64(m.Timestamp.Size()))
	n9, err := m.Timestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n9
	dAtA[i] = 0x12
	i++
	i = encodeVarintErrors(dAtA, i, uint64(m.ActualTimestamp.Size()))
	n10, err := m.ActualTimestamp.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n10
	return i, nil
}

func (m *OpRequiresTxnError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *OpRequiresTxnError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *ConditionFailedError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ConditionFailedError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ActualValue != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.ActualValue.Size()))
		n11, err := m.ActualValue.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n11
	}
	return i, nil
}

func (m *LeaseRejectedError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *LeaseRejectedError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintErrors(dAtA, i, uint64(len(m.Message)))
	i += copy(dAtA[i:], m.Message)
	dAtA[i] = 0x12
	i++
	i = encodeVarintErrors(dAtA, i, uint64(m.Requested.Size()))
	n12, err := m.Requested.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n12
	dAtA[i] = 0x1a
	i++
	i = encodeVarintErrors(dAtA, i, uint64(m.Existing.Size()))
	n13, err := m.Existing.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n13
	return i, nil
}

func (m *SendError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *SendError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintErrors(dAtA, i, uint64(len(m.Message)))
	i += copy(dAtA[i:], m.Message)
	return i, nil
}

func (m *AmbiguousResultError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *AmbiguousResultError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintErrors(dAtA, i, uint64(len(m.Message)))
	i += copy(dAtA[i:], m.Message)
	if m.WrappedErr != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.WrappedErr.Size()))
		n14, err := m.WrappedErr.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n14
	}
	return i, nil
}

func (m *RaftGroupDeletedError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *RaftGroupDeletedError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	return i, nil
}

func (m *ReplicaCorruptionError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReplicaCorruptionError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintErrors(dAtA, i, uint64(len(m.ErrorMsg)))
	i += copy(dAtA[i:], m.ErrorMsg)
	dAtA[i] = 0x10
	i++
	if m.Processed {
		dAtA[i] = 1
	} else {
		dAtA[i] = 0
	}
	i++
	return i, nil
}

func (m *ReplicaTooOldError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ReplicaTooOldError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintErrors(dAtA, i, uint64(m.ReplicaID))
	return i, nil
}

func (m *StoreNotFoundError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *StoreNotFoundError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintErrors(dAtA, i, uint64(m.StoreID))
	return i, nil
}

func (m *ErrorDetail) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ErrorDetail) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.NotLeaseHolder != nil {
		dAtA[i] = 0xa
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.NotLeaseHolder.Size()))
		n15, err := m.NotLeaseHolder.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n15
	}
	if m.RangeNotFound != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.RangeNotFound.Size()))
		n16, err := m.RangeNotFound.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n16
	}
	if m.RangeKeyMismatch != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.RangeKeyMismatch.Size()))
		n17, err := m.RangeKeyMismatch.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n17
	}
	if m.ReadWithinUncertaintyInterval != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.ReadWithinUncertaintyInterval.Size()))
		n18, err := m.ReadWithinUncertaintyInterval.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n18
	}
	if m.TransactionAborted != nil {
		dAtA[i] = 0x2a
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.TransactionAborted.Size()))
		n19, err := m.TransactionAborted.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n19
	}
	if m.TransactionPush != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.TransactionPush.Size()))
		n20, err := m.TransactionPush.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n20
	}
	if m.TransactionRetry != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.TransactionRetry.Size()))
		n21, err := m.TransactionRetry.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n21
	}
	if m.TransactionStatus != nil {
		dAtA[i] = 0x42
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.TransactionStatus.Size()))
		n22, err := m.TransactionStatus.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n22
	}
	if m.WriteIntent != nil {
		dAtA[i] = 0x4a
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.WriteIntent.Size()))
		n23, err := m.WriteIntent.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n23
	}
	if m.WriteTooOld != nil {
		dAtA[i] = 0x52
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.WriteTooOld.Size()))
		n24, err := m.WriteTooOld.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n24
	}
	if m.OpRequiresTxn != nil {
		dAtA[i] = 0x5a
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.OpRequiresTxn.Size()))
		n25, err := m.OpRequiresTxn.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n25
	}
	if m.ConditionFailed != nil {
		dAtA[i] = 0x62
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.ConditionFailed.Size()))
		n26, err := m.ConditionFailed.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n26
	}
	if m.LeaseRejected != nil {
		dAtA[i] = 0x6a
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.LeaseRejected.Size()))
		n27, err := m.LeaseRejected.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n27
	}
	if m.NodeUnavailable != nil {
		dAtA[i] = 0x72
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.NodeUnavailable.Size()))
		n28, err := m.NodeUnavailable.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n28
	}
	if m.Send != nil {
		dAtA[i] = 0x7a
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.Send.Size()))
		n29, err := m.Send.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n29
	}
	if m.RaftGroupDeleted != nil {
		dAtA[i] = 0x82
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.RaftGroupDeleted.Size()))
		n30, err := m.RaftGroupDeleted.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n30
	}
	if m.ReplicaCorruption != nil {
		dAtA[i] = 0x8a
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.ReplicaCorruption.Size()))
		n31, err := m.ReplicaCorruption.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n31
	}
	if m.ReplicaTooOld != nil {
		dAtA[i] = 0x92
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.ReplicaTooOld.Size()))
		n32, err := m.ReplicaTooOld.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n32
	}
	if m.TransactionReplay != nil {
		dAtA[i] = 0xb2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.TransactionReplay.Size()))
		n33, err := m.TransactionReplay.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n33
	}
	if m.AmbiguousResult != nil {
		dAtA[i] = 0xd2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.AmbiguousResult.Size()))
		n34, err := m.AmbiguousResult.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n34
	}
	if m.StoreNotFound != nil {
		dAtA[i] = 0xda
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.StoreNotFound.Size()))
		n35, err := m.StoreNotFound.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n35
	}
	if m.HandledRetryableTxnError != nil {
		dAtA[i] = 0xe2
		i++
		dAtA[i] = 0x1
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.HandledRetryableTxnError.Size()))
		n36, err := m.HandledRetryableTxnError.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n36
	}
	return i, nil
}

func (m *ErrPosition) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ErrPosition) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0x8
	i++
	i = encodeVarintErrors(dAtA, i, uint64(m.Index))
	return i, nil
}

func (m *Error) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *Error) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintErrors(dAtA, i, uint64(len(m.Message)))
	i += copy(dAtA[i:], m.Message)
	dAtA[i] = 0x18
	i++
	i = encodeVarintErrors(dAtA, i, uint64(m.TransactionRestart))
	if m.UnexposedTxn != nil {
		dAtA[i] = 0x22
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.UnexposedTxn.Size()))
		n37, err := m.UnexposedTxn.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n37
	}
	dAtA[i] = 0x28
	i++
	i = encodeVarintErrors(dAtA, i, uint64(m.OriginNode))
	if m.Detail != nil {
		dAtA[i] = 0x32
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.Detail.Size()))
		n38, err := m.Detail.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n38
	}
	if m.Index != nil {
		dAtA[i] = 0x3a
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.Index.Size()))
		n39, err := m.Index.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n39
	}
	dAtA[i] = 0x42
	i++
	i = encodeVarintErrors(dAtA, i, uint64(m.Now.Size()))
	n40, err := m.Now.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n40
	return i, nil
}

func (m *UnhandledRetryableError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *UnhandledRetryableError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintErrors(dAtA, i, uint64(m.PErr.Size()))
	n41, err := m.PErr.MarshalTo(dAtA[i:])
	if err != nil {
		return 0, err
	}
	i += n41
	return i, nil
}

func (m *HandledRetryableTxnError) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalTo(dAtA)
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *HandledRetryableTxnError) MarshalTo(dAtA []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	dAtA[i] = 0xa
	i++
	i = encodeVarintErrors(dAtA, i, uint64(len(m.Msg)))
	i += copy(dAtA[i:], m.Msg)
	if m.TxnID != nil {
		dAtA[i] = 0x12
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.TxnID.Size()))
		n42, err := m.TxnID.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n42
	}
	if m.Transaction != nil {
		dAtA[i] = 0x1a
		i++
		i = encodeVarintErrors(dAtA, i, uint64(m.Transaction.Size()))
		n43, err := m.Transaction.MarshalTo(dAtA[i:])
		if err != nil {
			return 0, err
		}
		i += n43
	}
	return i, nil
}

func encodeFixed64Errors(dAtA []byte, offset int, v uint64) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	dAtA[offset+4] = uint8(v >> 32)
	dAtA[offset+5] = uint8(v >> 40)
	dAtA[offset+6] = uint8(v >> 48)
	dAtA[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32Errors(dAtA []byte, offset int, v uint32) int {
	dAtA[offset] = uint8(v)
	dAtA[offset+1] = uint8(v >> 8)
	dAtA[offset+2] = uint8(v >> 16)
	dAtA[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintErrors(dAtA []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return offset + 1
}
func (m *NotLeaseHolderError) Size() (n int) {
	var l int
	_ = l
	l = m.Replica.Size()
	n += 1 + l + sovErrors(uint64(l))
	if m.LeaseHolder != nil {
		l = m.LeaseHolder.Size()
		n += 1 + l + sovErrors(uint64(l))
	}
	n += 1 + sovErrors(uint64(m.RangeID))
	if m.Lease != nil {
		l = m.Lease.Size()
		n += 1 + l + sovErrors(uint64(l))
	}
	l = len(m.CustomMsg)
	n += 1 + l + sovErrors(uint64(l))
	return n
}

func (m *NodeUnavailableError) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *RangeNotFoundError) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovErrors(uint64(m.RangeID))
	return n
}

func (m *RangeKeyMismatchError) Size() (n int) {
	var l int
	_ = l
	if m.RequestStartKey != nil {
		l = len(m.RequestStartKey)
		n += 1 + l + sovErrors(uint64(l))
	}
	if m.RequestEndKey != nil {
		l = len(m.RequestEndKey)
		n += 1 + l + sovErrors(uint64(l))
	}
	if m.MismatchedRange != nil {
		l = m.MismatchedRange.Size()
		n += 1 + l + sovErrors(uint64(l))
	}
	if m.SuggestedRange != nil {
		l = m.SuggestedRange.Size()
		n += 1 + l + sovErrors(uint64(l))
	}
	return n
}

func (m *ReadWithinUncertaintyIntervalError) Size() (n int) {
	var l int
	_ = l
	l = m.ReadTimestamp.Size()
	n += 1 + l + sovErrors(uint64(l))
	l = m.ExistingTimestamp.Size()
	n += 1 + l + sovErrors(uint64(l))
	return n
}

func (m *TransactionAbortedError) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *TransactionPushError) Size() (n int) {
	var l int
	_ = l
	l = m.PusheeTxn.Size()
	n += 1 + l + sovErrors(uint64(l))
	return n
}

func (m *TransactionRetryError) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovErrors(uint64(m.Reason))
	return n
}

func (m *TransactionReplayError) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *TransactionStatusError) Size() (n int) {
	var l int
	_ = l
	l = len(m.Msg)
	n += 1 + l + sovErrors(uint64(l))
	return n
}

func (m *WriteIntentError) Size() (n int) {
	var l int
	_ = l
	if len(m.Intents) > 0 {
		for _, e := range m.Intents {
			l = e.Size()
			n += 1 + l + sovErrors(uint64(l))
		}
	}
	return n
}

func (m *WriteTooOldError) Size() (n int) {
	var l int
	_ = l
	l = m.Timestamp.Size()
	n += 1 + l + sovErrors(uint64(l))
	l = m.ActualTimestamp.Size()
	n += 1 + l + sovErrors(uint64(l))
	return n
}

func (m *OpRequiresTxnError) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *ConditionFailedError) Size() (n int) {
	var l int
	_ = l
	if m.ActualValue != nil {
		l = m.ActualValue.Size()
		n += 1 + l + sovErrors(uint64(l))
	}
	return n
}

func (m *LeaseRejectedError) Size() (n int) {
	var l int
	_ = l
	l = len(m.Message)
	n += 1 + l + sovErrors(uint64(l))
	l = m.Requested.Size()
	n += 1 + l + sovErrors(uint64(l))
	l = m.Existing.Size()
	n += 1 + l + sovErrors(uint64(l))
	return n
}

func (m *SendError) Size() (n int) {
	var l int
	_ = l
	l = len(m.Message)
	n += 1 + l + sovErrors(uint64(l))
	return n
}

func (m *AmbiguousResultError) Size() (n int) {
	var l int
	_ = l
	l = len(m.Message)
	n += 1 + l + sovErrors(uint64(l))
	if m.WrappedErr != nil {
		l = m.WrappedErr.Size()
		n += 1 + l + sovErrors(uint64(l))
	}
	return n
}

func (m *RaftGroupDeletedError) Size() (n int) {
	var l int
	_ = l
	return n
}

func (m *ReplicaCorruptionError) Size() (n int) {
	var l int
	_ = l
	l = len(m.ErrorMsg)
	n += 1 + l + sovErrors(uint64(l))
	n += 2
	return n
}

func (m *ReplicaTooOldError) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovErrors(uint64(m.ReplicaID))
	return n
}

func (m *StoreNotFoundError) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovErrors(uint64(m.StoreID))
	return n
}

func (m *ErrorDetail) Size() (n int) {
	var l int
	_ = l
	if m.NotLeaseHolder != nil {
		l = m.NotLeaseHolder.Size()
		n += 1 + l + sovErrors(uint64(l))
	}
	if m.RangeNotFound != nil {
		l = m.RangeNotFound.Size()
		n += 1 + l + sovErrors(uint64(l))
	}
	if m.RangeKeyMismatch != nil {
		l = m.RangeKeyMismatch.Size()
		n += 1 + l + sovErrors(uint64(l))
	}
	if m.ReadWithinUncertaintyInterval != nil {
		l = m.ReadWithinUncertaintyInterval.Size()
		n += 1 + l + sovErrors(uint64(l))
	}
	if m.TransactionAborted != nil {
		l = m.TransactionAborted.Size()
		n += 1 + l + sovErrors(uint64(l))
	}
	if m.TransactionPush != nil {
		l = m.TransactionPush.Size()
		n += 1 + l + sovErrors(uint64(l))
	}
	if m.TransactionRetry != nil {
		l = m.TransactionRetry.Size()
		n += 1 + l + sovErrors(uint64(l))
	}
	if m.TransactionStatus != nil {
		l = m.TransactionStatus.Size()
		n += 1 + l + sovErrors(uint64(l))
	}
	if m.WriteIntent != nil {
		l = m.WriteIntent.Size()
		n += 1 + l + sovErrors(uint64(l))
	}
	if m.WriteTooOld != nil {
		l = m.WriteTooOld.Size()
		n += 1 + l + sovErrors(uint64(l))
	}
	if m.OpRequiresTxn != nil {
		l = m.OpRequiresTxn.Size()
		n += 1 + l + sovErrors(uint64(l))
	}
	if m.ConditionFailed != nil {
		l = m.ConditionFailed.Size()
		n += 1 + l + sovErrors(uint64(l))
	}
	if m.LeaseRejected != nil {
		l = m.LeaseRejected.Size()
		n += 1 + l + sovErrors(uint64(l))
	}
	if m.NodeUnavailable != nil {
		l = m.NodeUnavailable.Size()
		n += 1 + l + sovErrors(uint64(l))
	}
	if m.Send != nil {
		l = m.Send.Size()
		n += 1 + l + sovErrors(uint64(l))
	}
	if m.RaftGroupDeleted != nil {
		l = m.RaftGroupDeleted.Size()
		n += 2 + l + sovErrors(uint64(l))
	}
	if m.ReplicaCorruption != nil {
		l = m.ReplicaCorruption.Size()
		n += 2 + l + sovErrors(uint64(l))
	}
	if m.ReplicaTooOld != nil {
		l = m.ReplicaTooOld.Size()
		n += 2 + l + sovErrors(uint64(l))
	}
	if m.TransactionReplay != nil {
		l = m.TransactionReplay.Size()
		n += 2 + l + sovErrors(uint64(l))
	}
	if m.AmbiguousResult != nil {
		l = m.AmbiguousResult.Size()
		n += 2 + l + sovErrors(uint64(l))
	}
	if m.StoreNotFound != nil {
		l = m.StoreNotFound.Size()
		n += 2 + l + sovErrors(uint64(l))
	}
	if m.HandledRetryableTxnError != nil {
		l = m.HandledRetryableTxnError.Size()
		n += 2 + l + sovErrors(uint64(l))
	}
	return n
}

func (m *ErrPosition) Size() (n int) {
	var l int
	_ = l
	n += 1 + sovErrors(uint64(m.Index))
	return n
}

func (m *Error) Size() (n int) {
	var l int
	_ = l
	l = len(m.Message)
	n += 1 + l + sovErrors(uint64(l))
	n += 1 + sovErrors(uint64(m.TransactionRestart))
	if m.UnexposedTxn != nil {
		l = m.UnexposedTxn.Size()
		n += 1 + l + sovErrors(uint64(l))
	}
	n += 1 + sovErrors(uint64(m.OriginNode))
	if m.Detail != nil {
		l = m.Detail.Size()
		n += 1 + l + sovErrors(uint64(l))
	}
	if m.Index != nil {
		l = m.Index.Size()
		n += 1 + l + sovErrors(uint64(l))
	}
	l = m.Now.Size()
	n += 1 + l + sovErrors(uint64(l))
	return n
}

func (m *UnhandledRetryableError) Size() (n int) {
	var l int
	_ = l
	l = m.PErr.Size()
	n += 1 + l + sovErrors(uint64(l))
	return n
}

func (m *HandledRetryableTxnError) Size() (n int) {
	var l int
	_ = l
	l = len(m.Msg)
	n += 1 + l + sovErrors(uint64(l))
	if m.TxnID != nil {
		l = m.TxnID.Size()
		n += 1 + l + sovErrors(uint64(l))
	}
	if m.Transaction != nil {
		l = m.Transaction.Size()
		n += 1 + l + sovErrors(uint64(l))
	}
	return n
}

func sovErrors(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozErrors(x uint64) (n int) {
	return sovErrors(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *ErrorDetail) GetValue() interface{} {
	if this.NotLeaseHolder != nil {
		return this.NotLeaseHolder
	}
	if this.RangeNotFound != nil {
		return this.RangeNotFound
	}
	if this.RangeKeyMismatch != nil {
		return this.RangeKeyMismatch
	}
	if this.ReadWithinUncertaintyInterval != nil {
		return this.ReadWithinUncertaintyInterval
	}
	if this.TransactionAborted != nil {
		return this.TransactionAborted
	}
	if this.TransactionPush != nil {
		return this.TransactionPush
	}
	if this.TransactionRetry != nil {
		return this.TransactionRetry
	}
	if this.TransactionStatus != nil {
		return this.TransactionStatus
	}
	if this.WriteIntent != nil {
		return this.WriteIntent
	}
	if this.WriteTooOld != nil {
		return this.WriteTooOld
	}
	if this.OpRequiresTxn != nil {
		return this.OpRequiresTxn
	}
	if this.ConditionFailed != nil {
		return this.ConditionFailed
	}
	if this.LeaseRejected != nil {
		return this.LeaseRejected
	}
	if this.NodeUnavailable != nil {
		return this.NodeUnavailable
	}
	if this.Send != nil {
		return this.Send
	}
	if this.RaftGroupDeleted != nil {
		return this.RaftGroupDeleted
	}
	if this.ReplicaCorruption != nil {
		return this.ReplicaCorruption
	}
	if this.ReplicaTooOld != nil {
		return this.ReplicaTooOld
	}
	if this.TransactionReplay != nil {
		return this.TransactionReplay
	}
	if this.AmbiguousResult != nil {
		return this.AmbiguousResult
	}
	if this.StoreNotFound != nil {
		return this.StoreNotFound
	}
	if this.HandledRetryableTxnError != nil {
		return this.HandledRetryableTxnError
	}
	return nil
}

func (this *ErrorDetail) SetValue(value interface{}) bool {
	switch vt := value.(type) {
	case *NotLeaseHolderError:
		this.NotLeaseHolder = vt
	case *RangeNotFoundError:
		this.RangeNotFound = vt
	case *RangeKeyMismatchError:
		this.RangeKeyMismatch = vt
	case *ReadWithinUncertaintyIntervalError:
		this.ReadWithinUncertaintyInterval = vt
	case *TransactionAbortedError:
		this.TransactionAborted = vt
	case *TransactionPushError:
		this.TransactionPush = vt
	case *TransactionRetryError:
		this.TransactionRetry = vt
	case *TransactionStatusError:
		this.TransactionStatus = vt
	case *WriteIntentError:
		this.WriteIntent = vt
	case *WriteTooOldError:
		this.WriteTooOld = vt
	case *OpRequiresTxnError:
		this.OpRequiresTxn = vt
	case *ConditionFailedError:
		this.ConditionFailed = vt
	case *LeaseRejectedError:
		this.LeaseRejected = vt
	case *NodeUnavailableError:
		this.NodeUnavailable = vt
	case *SendError:
		this.Send = vt
	case *RaftGroupDeletedError:
		this.RaftGroupDeleted = vt
	case *ReplicaCorruptionError:
		this.ReplicaCorruption = vt
	case *ReplicaTooOldError:
		this.ReplicaTooOld = vt
	case *TransactionReplayError:
		this.TransactionReplay = vt
	case *AmbiguousResultError:
		this.AmbiguousResult = vt
	case *StoreNotFoundError:
		this.StoreNotFound = vt
	case *HandledRetryableTxnError:
		this.HandledRetryableTxnError = vt
	default:
		return false
	}
	return true
}
func (m *NotLeaseHolderError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NotLeaseHolderError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NotLeaseHolderError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Replica", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Replica.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LeaseHolder", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LeaseHolder == nil {
				m.LeaseHolder = &ReplicaDescriptor{}
			}
			if err := m.LeaseHolder.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeID", wireType)
			}
			m.RangeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RangeID |= (RangeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Lease", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Lease == nil {
				m.Lease = &Lease{}
			}
			if err := m.Lease.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field CustomMsg", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.CustomMsg = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *NodeUnavailableError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: NodeUnavailableError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: NodeUnavailableError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RangeNotFoundError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RangeNotFoundError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RangeNotFoundError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeID", wireType)
			}
			m.RangeID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.RangeID |= (RangeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RangeKeyMismatchError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RangeKeyMismatchError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RangeKeyMismatchError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestStartKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RequestStartKey = append(m.RequestStartKey[:0], dAtA[iNdEx:postIndex]...)
			if m.RequestStartKey == nil {
				m.RequestStartKey = []byte{}
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RequestEndKey", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.RequestEndKey = append(m.RequestEndKey[:0], dAtA[iNdEx:postIndex]...)
			if m.RequestEndKey == nil {
				m.RequestEndKey = []byte{}
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field MismatchedRange", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.MismatchedRange == nil {
				m.MismatchedRange = &RangeDescriptor{}
			}
			if err := m.MismatchedRange.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SuggestedRange", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SuggestedRange == nil {
				m.SuggestedRange = &RangeDescriptor{}
			}
			if err := m.SuggestedRange.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReadWithinUncertaintyIntervalError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReadWithinUncertaintyIntervalError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReadWithinUncertaintyIntervalError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadTimestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ReadTimestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExistingTimestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ExistingTimestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TransactionAbortedError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TransactionAbortedError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TransactionAbortedError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TransactionPushError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TransactionPushError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TransactionPushError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PusheeTxn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.PusheeTxn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TransactionRetryError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TransactionRetryError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TransactionRetryError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Reason", wireType)
			}
			m.Reason = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Reason |= (TransactionRetryReason(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TransactionReplayError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TransactionReplayError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TransactionReplayError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *TransactionStatusError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: TransactionStatusError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: TransactionStatusError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Msg", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Msg = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WriteIntentError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WriteIntentError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WriteIntentError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Intents", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Intents = append(m.Intents, Intent{})
			if err := m.Intents[len(m.Intents)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *WriteTooOldError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: WriteTooOldError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: WriteTooOldError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Timestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Timestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ActualTimestamp", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.ActualTimestamp.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *OpRequiresTxnError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: OpRequiresTxnError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: OpRequiresTxnError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ConditionFailedError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ConditionFailedError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ConditionFailedError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ActualValue", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ActualValue == nil {
				m.ActualValue = &Value{}
			}
			if err := m.ActualValue.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *LeaseRejectedError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: LeaseRejectedError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: LeaseRejectedError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Requested", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Requested.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Existing", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Existing.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *SendError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: SendError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: SendError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *AmbiguousResultError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: AmbiguousResultError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: AmbiguousResultError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WrappedErr", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WrappedErr == nil {
				m.WrappedErr = &Error{}
			}
			if err := m.WrappedErr.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *RaftGroupDeletedError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: RaftGroupDeletedError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: RaftGroupDeletedError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReplicaCorruptionError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReplicaCorruptionError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReplicaCorruptionError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ErrorMsg", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.ErrorMsg = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Processed", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Processed = bool(v != 0)
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ReplicaTooOldError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ReplicaTooOldError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ReplicaTooOldError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplicaID", wireType)
			}
			m.ReplicaID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.ReplicaID |= (ReplicaID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *StoreNotFoundError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: StoreNotFoundError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: StoreNotFoundError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field StoreID", wireType)
			}
			m.StoreID = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.StoreID |= (StoreID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ErrorDetail) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ErrorDetail: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ErrorDetail: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NotLeaseHolder", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.NotLeaseHolder == nil {
				m.NotLeaseHolder = &NotLeaseHolderError{}
			}
			if err := m.NotLeaseHolder.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeNotFound", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RangeNotFound == nil {
				m.RangeNotFound = &RangeNotFoundError{}
			}
			if err := m.RangeNotFound.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RangeKeyMismatch", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RangeKeyMismatch == nil {
				m.RangeKeyMismatch = &RangeKeyMismatchError{}
			}
			if err := m.RangeKeyMismatch.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReadWithinUncertaintyInterval", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ReadWithinUncertaintyInterval == nil {
				m.ReadWithinUncertaintyInterval = &ReadWithinUncertaintyIntervalError{}
			}
			if err := m.ReadWithinUncertaintyInterval.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TransactionAborted", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TransactionAborted == nil {
				m.TransactionAborted = &TransactionAbortedError{}
			}
			if err := m.TransactionAborted.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TransactionPush", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TransactionPush == nil {
				m.TransactionPush = &TransactionPushError{}
			}
			if err := m.TransactionPush.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TransactionRetry", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TransactionRetry == nil {
				m.TransactionRetry = &TransactionRetryError{}
			}
			if err := m.TransactionRetry.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TransactionStatus", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TransactionStatus == nil {
				m.TransactionStatus = &TransactionStatusError{}
			}
			if err := m.TransactionStatus.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 9:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WriteIntent", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WriteIntent == nil {
				m.WriteIntent = &WriteIntentError{}
			}
			if err := m.WriteIntent.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 10:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field WriteTooOld", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.WriteTooOld == nil {
				m.WriteTooOld = &WriteTooOldError{}
			}
			if err := m.WriteTooOld.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 11:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field OpRequiresTxn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.OpRequiresTxn == nil {
				m.OpRequiresTxn = &OpRequiresTxnError{}
			}
			if err := m.OpRequiresTxn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 12:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ConditionFailed", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ConditionFailed == nil {
				m.ConditionFailed = &ConditionFailedError{}
			}
			if err := m.ConditionFailed.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 13:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field LeaseRejected", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.LeaseRejected == nil {
				m.LeaseRejected = &LeaseRejectedError{}
			}
			if err := m.LeaseRejected.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 14:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field NodeUnavailable", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.NodeUnavailable == nil {
				m.NodeUnavailable = &NodeUnavailableError{}
			}
			if err := m.NodeUnavailable.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 15:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Send", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Send == nil {
				m.Send = &SendError{}
			}
			if err := m.Send.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 16:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field RaftGroupDeleted", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.RaftGroupDeleted == nil {
				m.RaftGroupDeleted = &RaftGroupDeletedError{}
			}
			if err := m.RaftGroupDeleted.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 17:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplicaCorruption", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ReplicaCorruption == nil {
				m.ReplicaCorruption = &ReplicaCorruptionError{}
			}
			if err := m.ReplicaCorruption.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 18:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ReplicaTooOld", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ReplicaTooOld == nil {
				m.ReplicaTooOld = &ReplicaTooOldError{}
			}
			if err := m.ReplicaTooOld.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 22:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TransactionReplay", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TransactionReplay == nil {
				m.TransactionReplay = &TransactionReplayError{}
			}
			if err := m.TransactionReplay.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 26:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field AmbiguousResult", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.AmbiguousResult == nil {
				m.AmbiguousResult = &AmbiguousResultError{}
			}
			if err := m.AmbiguousResult.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 27:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field StoreNotFound", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.StoreNotFound == nil {
				m.StoreNotFound = &StoreNotFoundError{}
			}
			if err := m.StoreNotFound.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 28:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field HandledRetryableTxnError", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.HandledRetryableTxnError == nil {
				m.HandledRetryableTxnError = &HandledRetryableTxnError{}
			}
			if err := m.HandledRetryableTxnError.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ErrPosition) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ErrPosition: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ErrPosition: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Index", wireType)
			}
			m.Index = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Index |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *Error) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: Error: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: Error: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field TransactionRestart", wireType)
			}
			m.TransactionRestart = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.TransactionRestart |= (TransactionRestart(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field UnexposedTxn", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.UnexposedTxn == nil {
				m.UnexposedTxn = &Transaction{}
			}
			if err := m.UnexposedTxn.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 5:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field OriginNode", wireType)
			}
			m.OriginNode = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.OriginNode |= (NodeID(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Detail", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Detail == nil {
				m.Detail = &ErrorDetail{}
			}
			if err := m.Detail.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Index", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Index == nil {
				m.Index = &ErrPosition{}
			}
			if err := m.Index.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 8:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Now", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.Now.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *UnhandledRetryableError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: UnhandledRetryableError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: UnhandledRetryableError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field PErr", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if err := m.PErr.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *HandledRetryableTxnError) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: HandledRetryableTxnError: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: HandledRetryableTxnError: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Msg", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Msg = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TxnID", wireType)
			}
			var byteLen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				byteLen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if byteLen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + byteLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			var v github_com_cockroachdb_cockroach_pkg_util_uuid.UUID
			m.TxnID = &v
			if err := m.TxnID.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Transaction", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthErrors
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.Transaction == nil {
				m.Transaction = &Transaction{}
			}
			if err := m.Transaction.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipErrors(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthErrors
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipErrors(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowErrors
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowErrors
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthErrors
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if shift >= 64 {
						return 0, ErrIntOverflowErrors
					}
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := dAtA[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipErrors(dAtA[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthErrors = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowErrors   = fmt.Errorf("proto: integer overflow")
)

func init() { proto.RegisterFile("cockroach/pkg/roachpb/errors.proto", fileDescriptorErrors) }

var fileDescriptorErrors = []byte{
	// 1933 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x58, 0x4f, 0x6f, 0x1b, 0xc7,
	0x15, 0xd7, 0x4a, 0x94, 0x28, 0x3e, 0x8a, 0x22, 0x35, 0x96, 0xe5, 0xb5, 0x92, 0x50, 0xca, 0x26,
	0x4d, 0x15, 0x17, 0x10, 0x53, 0xa5, 0x2e, 0x10, 0xb7, 0x05, 0x42, 0x89, 0x94, 0x42, 0x4b, 0x22,
	0x85, 0x21, 0x15, 0x35, 0x49, 0x81, 0xed, 0x8a, 0x3b, 0x26, 0x37, 0x5e, 0xee, 0xd2, 0xb3, 0xb3,
	0x96, 0x74, 0xe9, 0xb9, 0xc7, 0x1e, 0x5b, 0xa0, 0x87, 0x00, 0x45, 0x6f, 0x45, 0xd1, 0x0f, 0xd1,
	0x83, 0x2f, 0x05, 0x7a, 0x2c, 0x7a, 0x10, 0x5a, 0x15, 0xe8, 0x87, 0xf0, 0x29, 0x98, 0x3f, 0x4b,
	0x2e, 0xa5, 0x25, 0x4d, 0xf8, 0xb6, 0x7c, 0xf3, 0xde, 0x6f, 0xde, 0xcc, 0xfb, 0xf3, 0x7b, 0x43,
	0x30, 0xda, 0x7e, 0xfb, 0x39, 0xf5, 0xad, 0x76, 0xb7, 0xd4, 0x7f, 0xde, 0x29, 0x89, 0xaf, 0xfe,
	0x79, 0x89, 0x50, 0xea, 0xd3, 0x60, 0xbb, 0x4f, 0x7d, 0xe6, 0xa3, 0x95, 0x81, 0xce, 0xb6, 0x5a,
	0x5f, 0xff, 0x30, 0xd9, 0xac, 0x47, 0x98, 0x65, 0x5b, 0xcc, 0x92, 0x86, 0xeb, 0x9b, 0xc9, 0x5a,
	0x31, 0x8d, 0x8f, 0x46, 0x35, 0x42, 0xe6, 0xb8, 0xa5, 0xae, 0xdb, 0x2e, 0x31, 0xa7, 0x47, 0x02,
	0x66, 0xf5, 0xfa, 0x4a, 0x6f, 0xb5, 0xe3, 0x77, 0x7c, 0xf1, 0x59, 0xe2, 0x5f, 0x52, 0x6a, 0xfc,
	0x6d, 0x16, 0xee, 0xd5, 0x7d, 0x76, 0x44, 0xac, 0x80, 0x7c, 0xe1, 0xbb, 0x36, 0xa1, 0x55, 0xee,
	0x37, 0xaa, 0x40, 0x9a, 0x92, 0xbe, 0xeb, 0xb4, 0x2d, 0x5d, 0xdb, 0xd4, 0xb6, 0xb2, 0x3b, 0x1f,
	0x6e, 0xdf, 0x39, 0xc2, 0x36, 0x96, 0x1a, 0x15, 0x12, 0xb4, 0xa9, 0xd3, 0x67, 0x3e, 0xdd, 0x4d,
	0xbd, 0xba, 0xde, 0x98, 0xc1, 0x91, 0x29, 0x3a, 0x80, 0x25, 0x97, 0x23, 0x9b, 0x5d, 0x01, 0xad,
	0xcf, 0x4e, 0x0f, 0x85, 0xb3, 0xee, 0xd0, 0x27, 0xf4, 0x18, 0x16, 0xa9, 0xe5, 0x75, 0x88, 0xe9,
	0xd8, 0xfa, 0xdc, 0xa6, 0xb6, 0x35, 0xb7, 0xbb, 0xce, 0x77, 0xba, 0xb9, 0xde, 0x48, 0x63, 0x2e,
	0xaf, 0x55, 0x5e, 0x0f, 0x3f, 0x71, 0x5a, 0xe8, 0xd6, 0x6c, 0xb4, 0x0d, 0xf3, 0x02, 0x45, 0x4f,
	0x89, 0x8d, 0xf5, 0x84, 0x8d, 0xc5, 0xc9, 0xb1, 0x54, 0x43, 0x1f, 0x00, 0xb4, 0xc3, 0x80, 0xf9,
	0x3d, 0xb3, 0x17, 0x74, 0xf4, 0xf9, 0x4d, 0x6d, 0x2b, 0xa3, 0x8e, 0x94, 0x91, 0xf2, 0xe3, 0xa0,
	0x63, 0xac, 0xc1, 0x6a, 0xdd, 0xb7, 0xc9, 0xa9, 0x67, 0xbd, 0xb4, 0x1c, 0xd7, 0x3a, 0x77, 0x89,
	0xb8, 0x32, 0xe3, 0x10, 0x90, 0x70, 0xa0, 0xee, 0xb3, 0x7d, 0x3f, 0xf4, 0x6c, 0x79, 0x91, 0x71,
	0xcf, 0xb5, 0xa9, 0x3d, 0x37, 0xfe, 0x30, 0x0b, 0xf7, 0x85, 0xf0, 0x90, 0x5c, 0x1d, 0x3b, 0x41,
	0xcf, 0x62, 0xed, 0xae, 0x04, 0xfc, 0x14, 0x56, 0x28, 0x79, 0x11, 0x92, 0x80, 0x99, 0x01, 0xb3,
	0x28, 0x33, 0x9f, 0x93, 0x2b, 0x81, 0xbc, 0xb4, 0x9b, 0x7e, 0x7d, 0xbd, 0x31, 0x77, 0x48, 0xae,
	0x70, 0x5e, 0x69, 0x34, 0xb9, 0xc2, 0x21, 0xb9, 0x42, 0x25, 0x88, 0x44, 0x26, 0xf1, 0x6c, 0x61,
	0x32, 0x3b, 0x6a, 0x92, 0x53, 0xeb, 0x55, 0xcf, 0xe6, 0x06, 0xc7, 0x50, 0xe8, 0xa9, 0x6d, 0x89,
	0x6d, 0x0a, 0xaf, 0xc4, 0xc5, 0x67, 0x77, 0x8c, 0xa4, 0xe8, 0xf1, 0xf5, 0x58, 0xec, 0xf2, 0x43,
	0x5b, 0xb1, 0x84, 0x0e, 0x21, 0x1f, 0x84, 0x9d, 0x0e, 0x09, 0xd8, 0x00, 0x2d, 0x35, 0x35, 0xda,
	0xf2, 0xc0, 0x54, 0xac, 0x18, 0x7f, 0xd7, 0xc0, 0xc0, 0xc4, 0xb2, 0xcf, 0x1c, 0xd6, 0x75, 0xbc,
	0x53, 0xaf, 0x4d, 0x28, 0xb3, 0x1c, 0x8f, 0x5d, 0xd5, 0x3c, 0x46, 0xe8, 0x4b, 0xcb, 0x95, 0x17,
	0xf5, 0x14, 0x96, 0x29, 0xb1, 0x6c, 0x73, 0x50, 0x08, 0x2a, 0x93, 0xdf, 0x8b, 0x6d, 0xc9, 0xab,
	0x65, 0xbb, 0xeb, 0xb6, 0xb7, 0x5b, 0x91, 0x92, 0x8a, 0x77, 0x8e, 0x9b, 0x0e, 0x84, 0x08, 0x03,
	0x22, 0x97, 0x4e, 0xc0, 0x1c, 0xaf, 0x13, 0xc3, 0x9b, 0x9d, 0x1e, 0x6f, 0x25, 0x32, 0x1f, 0x2c,
	0x18, 0x0f, 0xe1, 0x41, 0x8b, 0x5a, 0x5e, 0x60, 0xb5, 0x99, 0xe3, 0x7b, 0xe5, 0x73, 0x9f, 0x32,
	0x22, 0x93, 0xc6, 0xf8, 0x06, 0x56, 0x63, 0x4b, 0x27, 0x61, 0xa0, 0x62, 0xbf, 0x07, 0xd0, 0x0f,
	0x83, 0x2e, 0x21, 0x26, 0xbb, 0xf4, 0xd4, 0x71, 0x8a, 0x09, 0x37, 0x18, 0x33, 0x8e, 0xf2, 0x57,
	0xda, 0xb5, 0x2e, 0x3d, 0xe3, 0xd7, 0x70, 0x3f, 0xb6, 0x8e, 0x09, 0xa3, 0x57, 0x12, 0xfd, 0x00,
	0x16, 0x28, 0xb1, 0x02, 0x5f, 0x22, 0x2f, 0xef, 0x7c, 0x3c, 0x19, 0x59, 0x58, 0x62, 0x61, 0xa0,
	0x36, 0x51, 0xe6, 0x86, 0x0e, 0x6b, 0x23, 0x7a, 0x7d, 0xd7, 0x92, 0x5b, 0x18, 0x9f, 0x8c, 0xac,
	0x34, 0x99, 0xc5, 0xc2, 0x40, 0x6e, 0xbe, 0x06, 0x73, 0xbc, 0xe6, 0xb4, 0x58, 0xcd, 0x71, 0x81,
	0xd1, 0x84, 0xc2, 0x19, 0x75, 0x18, 0xe1, 0xb1, 0xf5, 0x98, 0xd4, 0xfd, 0x0c, 0xd2, 0x8e, 0xf8,
	0x19, 0xe8, 0xda, 0xe6, 0xdc, 0x56, 0x76, 0xe7, 0x61, 0x82, 0xa7, 0xd2, 0x20, 0xea, 0x48, 0x4a,
	0xff, 0x69, 0x6a, 0x71, 0xb6, 0x30, 0x67, 0xfc, 0x59, 0x53, 0xa8, 0x2d, 0xdf, 0x6f, 0xb8, 0xaa,
	0x52, 0xcb, 0x90, 0x79, 0xab, 0x54, 0x19, 0x5a, 0xa1, 0x3a, 0x14, 0xac, 0x36, 0x0b, 0x2d, 0xf7,
	0xed, 0x92, 0x24, 0x2f, 0x8d, 0x87, 0x29, 0xb2, 0x0a, 0xa8, 0xd1, 0xc7, 0xe4, 0x45, 0xe8, 0x50,
	0x12, 0xb4, 0x2e, 0x3d, 0x79, 0x89, 0x4d, 0x58, 0xdd, 0xf3, 0x3d, 0xdb, 0xe1, 0x57, 0xb8, 0x6f,
	0x39, 0xae, 0xca, 0x1a, 0xf4, 0x33, 0x58, 0x52, 0xbb, 0xbf, 0xb4, 0xdc, 0x90, 0xa8, 0x33, 0x24,
	0x35, 0xbd, 0x2f, 0xf9, 0x3a, 0xce, 0x4a, 0x6d, 0xf1, 0xc3, 0xf8, 0xab, 0x06, 0x48, 0xf6, 0x42,
	0xf2, 0x2d, 0x69, 0x47, 0x99, 0x88, 0x8a, 0x90, 0xee, 0x91, 0x20, 0xb0, 0x3a, 0x64, 0x24, 0x34,
	0x91, 0x10, 0xfd, 0x1c, 0x32, 0xaa, 0x71, 0x10, 0x5b, 0x1d, 0x75, 0x6c, 0x97, 0x8d, 0xee, 0x6b,
	0x60, 0x80, 0x9e, 0xc0, 0x62, 0x54, 0x17, 0xaa, 0xbb, 0xbc, 0xc9, 0x78, 0xa0, 0x6f, 0xfc, 0x18,
	0x32, 0x4d, 0xe2, 0x4d, 0xe7, 0xa6, 0x0a, 0xfb, 0x0b, 0x58, 0x2d, 0xf7, 0xce, 0x9d, 0x4e, 0xe8,
	0x87, 0x01, 0x26, 0x41, 0xe8, 0xb2, 0xe9, 0x0e, 0xf9, 0x19, 0x64, 0x2f, 0xa8, 0xd5, 0xef, 0x13,
	0xdb, 0x24, 0x94, 0x4e, 0x38, 0xa6, 0x80, 0xc3, 0xa0, 0x94, 0xab, 0x94, 0x1a, 0x0f, 0x78, 0x1b,
	0x7f, 0xc6, 0x0e, 0xa8, 0x1f, 0xf6, 0x2b, 0xc4, 0x25, 0x83, 0x12, 0x37, 0x61, 0x4d, 0x71, 0xde,
	0x9e, 0x4f, 0x69, 0xd8, 0xe7, 0xc1, 0x94, 0xde, 0xbc, 0x0f, 0x19, 0x31, 0x3b, 0x98, 0xb7, 0xeb,
	0x61, 0x51, 0x88, 0x8f, 0x83, 0x0e, 0x32, 0x20, 0xd3, 0xa7, 0x7e, 0x9b, 0x04, 0x81, 0xba, 0xf5,
	0xc5, 0x41, 0x99, 0x47, 0x62, 0xa3, 0x09, 0x48, 0x6d, 0x10, 0x4f, 0xf2, 0x5f, 0x00, 0x28, 0x72,
	0x8e, 0x08, 0x69, 0x7e, 0xb7, 0xa8, 0x08, 0x29, 0xa3, 0xf4, 0x05, 0x25, 0x0d, 0x7f, 0xf0, 0x80,
	0xc9, 0x4f, 0x9b, 0x73, 0x5c, 0x93, 0xf9, 0xf4, 0x2e, 0xc7, 0x05, 0x5c, 0x9a, 0xc0, 0x71, 0x42,
	0x5b, 0x72, 0x9c, 0xfa, 0xc4, 0x69, 0xa1, 0x5b, 0xb3, 0x8d, 0xff, 0x2f, 0x43, 0x56, 0x00, 0x54,
	0x08, 0xb3, 0x1c, 0x17, 0x9d, 0x40, 0xc1, 0xf3, 0x99, 0x39, 0x32, 0x31, 0xc8, 0x1c, 0xfe, 0x28,
	0xe1, 0xae, 0x13, 0xa6, 0x16, 0xbc, 0xec, 0x8d, 0x08, 0xd1, 0x31, 0xe4, 0x25, 0xf9, 0x72, 0xdc,
	0x67, 0xdc, 0x61, 0x15, 0xbc, 0x1f, 0x8c, 0xa3, 0x9d, 0x91, 0x83, 0xe1, 0x1c, 0x8d, 0xcb, 0xd0,
	0x97, 0x80, 0x24, 0xdc, 0x73, 0x72, 0x65, 0x46, 0x14, 0xa7, 0x12, 0x77, 0x6b, 0x1c, 0xe2, 0x6d,
	0x02, 0xc7, 0x05, 0x7a, 0x4b, 0x8c, 0x7e, 0x03, 0x9b, 0x82, 0xa9, 0x2e, 0x04, 0xa1, 0x99, 0xe1,
	0x90, 0xd1, 0x4c, 0x47, 0x51, 0x9a, 0xa2, 0xcb, 0xc7, 0x89, 0xa3, 0xd3, 0x9b, 0xa8, 0x10, 0xbf,
	0x47, 0x27, 0xe9, 0xa0, 0x6f, 0xe0, 0x1e, 0x1b, 0x76, 0x65, 0xd3, 0x92, 0x54, 0x24, 0xe6, 0x9f,
	0xec, 0xce, 0xa3, 0xc9, 0x2c, 0x10, 0xe7, 0x2d, 0x8c, 0xd8, 0x9d, 0x05, 0x84, 0xa1, 0x10, 0x07,
	0xe7, 0x3c, 0xa4, 0x2f, 0x08, 0xe4, 0x1f, 0x4e, 0x46, 0x1e, 0xd0, 0x1e, 0xce, 0xb3, 0x51, 0x29,
	0x3a, 0x85, 0x95, 0x38, 0x26, 0xe5, 0x4c, 0xa4, 0xa7, 0xc7, 0xc6, 0x21, 0x91, 0xee, 0x70, 0xdc,
	0x2d, 0x21, 0x46, 0xbf, 0x84, 0xf8, 0x01, 0xf8, 0x78, 0xc5, 0xc2, 0x40, 0x5f, 0x14, 0xb8, 0x6f,
	0x20, 0xc3, 0x18, 0x95, 0xe1, 0xb8, 0x6f, 0x52, 0x8e, 0xf6, 0x61, 0xe9, 0x82, 0xf3, 0x8d, 0x29,
	0x79, 0x48, 0xcf, 0x08, 0xcc, 0x0f, 0x12, 0x30, 0x6f, 0x93, 0x1d, 0xce, 0x5e, 0x0c, 0x25, 0xe8,
	0x00, 0x72, 0x12, 0x87, 0xf9, 0xbe, 0xe9, 0xbb, 0xb6, 0x0e, 0x93, 0x81, 0x62, 0xa5, 0xaf, 0x80,
	0xa4, 0x84, 0x57, 0x86, 0xdf, 0x37, 0xa9, 0xa2, 0x16, 0x31, 0x4e, 0x64, 0xc7, 0x56, 0xc6, 0x5d,
	0x0e, 0xc2, 0x39, 0x3f, 0x2e, 0xe3, 0x41, 0x6e, 0x47, 0x94, 0x64, 0x3e, 0x13, 0x9c, 0xa4, 0x2f,
	0x8d, 0x0d, 0x72, 0x12, 0x7b, 0xe1, 0x7c, 0x7b, 0x54, 0x8a, 0x8e, 0x60, 0x59, 0xb6, 0x02, 0xaa,
	0x18, 0x49, 0xcf, 0x8d, 0xf5, 0xf0, 0x2e, 0x73, 0xe1, 0x9c, 0x1b, 0x97, 0x71, 0x0f, 0x3d, 0xdf,
	0x26, 0x66, 0x38, 0x1c, 0xdb, 0xf5, 0xe5, 0xb1, 0x1e, 0x26, 0x0d, 0xf8, 0x38, 0xef, 0x8d, 0x4a,
	0xd1, 0x27, 0x90, 0x0a, 0x88, 0x67, 0xeb, 0x79, 0x81, 0xf3, 0x6e, 0x02, 0xce, 0x80, 0xa1, 0xb0,
	0xd0, 0x94, 0x1d, 0xe4, 0x19, 0x33, 0x3b, 0x9c, 0x0f, 0x4c, 0x5b, 0x12, 0x82, 0x5e, 0x98, 0xd0,
	0x41, 0x12, 0xb8, 0x83, 0x77, 0x90, 0x51, 0x31, 0xcf, 0xdc, 0xa8, 0xad, 0xb7, 0x07, 0x74, 0xa2,
	0xaf, 0x8c, 0xcd, 0xdc, 0x64, 0xea, 0xc1, 0x2b, 0xf4, 0xb6, 0x5c, 0xb4, 0x50, 0x85, 0x1c, 0xe5,
	0x1c, 0x1a, 0xdf, 0x42, 0xef, 0x10, 0x0e, 0x1f, 0xa4, 0x63, 0xb2, 0xdb, 0x25, 0x46, 0xc5, 0x6c,
	0xa8, 0xaf, 0x4d, 0x53, 0x62, 0xb1, 0x39, 0x72, 0xa4, 0xc4, 0xa4, 0x9c, 0x07, 0xd8, 0x8a, 0xc8,
	0xdd, 0xa4, 0x82, 0xdd, 0xf5, 0xf5, 0xb1, 0x01, 0x4e, 0x9a, 0x03, 0x70, 0xde, 0x1a, 0x95, 0xf2,
	0xc3, 0x4b, 0x62, 0x1b, 0xf2, 0xc7, 0x3b, 0x63, 0x0f, 0x7f, 0x97, 0x18, 0x71, 0x2e, 0x88, 0xcb,
	0xd0, 0xb7, 0xf0, 0x4e, 0xd7, 0xf2, 0x6c, 0x97, 0xbf, 0x81, 0x78, 0xc3, 0xe1, 0x49, 0xc4, 0x4b,
	0xcf, 0x14, 0xc4, 0xae, 0xbf, 0x2b, 0xa0, 0x7f, 0x94, 0x00, 0xfd, 0x85, 0xb4, 0xc2, 0x91, 0xd1,
	0xa0, 0x0c, 0xf5, 0xee, 0x98, 0x95, 0x27, 0xa9, 0x57, 0xdf, 0x6d, 0x68, 0x4f, 0x53, 0x8b, 0x0f,
	0x0b, 0xeb, 0xc6, 0xc7, 0x82, 0x67, 0x4f, 0xfc, 0x40, 0x94, 0x17, 0x5a, 0x87, 0x79, 0xc7, 0xb3,
	0xc9, 0xa5, 0xa2, 0x7f, 0x39, 0x39, 0x48, 0x91, 0xf1, 0x97, 0x39, 0x98, 0x9f, 0x6e, 0x28, 0xfa,
	0xd5, 0x28, 0x69, 0x50, 0x22, 0x5e, 0xa3, 0x82, 0x0d, 0x97, 0x13, 0xef, 0x67, 0x24, 0x94, 0x42,
	0x59, 0x41, 0x22, 0x76, 0x67, 0x05, 0xed, 0x41, 0x2e, 0xf4, 0xc8, 0x65, 0xdf, 0x0f, 0x88, 0x2d,
	0xba, 0x53, 0x6a, 0x9a, 0xc7, 0x0e, 0x5e, 0x1a, 0x18, 0xf1, 0xae, 0x54, 0x82, 0xac, 0x4f, 0x9d,
	0x8e, 0xe3, 0x99, 0xbc, 0x72, 0x05, 0x9f, 0xcd, 0xef, 0x2e, 0xf3, 0x3d, 0x5f, 0x5f, 0x6f, 0x2c,
	0xf0, 0x1a, 0xaf, 0x55, 0x30, 0x48, 0x15, 0xfe, 0x0b, 0xfd, 0x14, 0x16, 0x6c, 0x31, 0x8b, 0x28,
	0x86, 0x2a, 0x8e, 0x9b, 0xf1, 0xe4, 0xc4, 0x82, 0x95, 0x36, 0xfa, 0x49, 0x74, 0xa3, 0xe9, 0x49,
	0x66, 0x51, 0x00, 0xd4, 0x5d, 0xa3, 0xc7, 0x30, 0xe7, 0xf9, 0x17, 0x8a, 0x5f, 0xa6, 0x7a, 0x20,
	0x70, 0xfd, 0x27, 0xa9, 0xdf, 0x7f, 0xb7, 0x31, 0xa3, 0x26, 0xda, 0x63, 0x78, 0x70, 0xea, 0xdd,
	0xce, 0x01, 0x19, 0xbf, 0x1d, 0x48, 0xf5, 0xab, 0x94, 0x4e, 0x78, 0x05, 0x08, 0x3d, 0x85, 0x2c,
	0x74, 0x8d, 0x7f, 0x68, 0xa0, 0x8f, 0xcb, 0xb5, 0x71, 0x2f, 0x34, 0x74, 0x06, 0x0b, 0x3c, 0x87,
	0x1d, 0x5b, 0xfd, 0xa5, 0xf0, 0xf9, 0xbf, 0xaf, 0x37, 0x3e, 0xed, 0x38, 0xac, 0x1b, 0x9e, 0x6f,
	0xb7, 0xfd, 0x5e, 0x69, 0xb0, 0xb1, 0x7d, 0x5e, 0x4a, 0xf8, 0xaf, 0x2a, 0x0c, 0x1d, 0x7b, 0xfb,
	0xf4, 0xb4, 0x56, 0xb9, 0xb9, 0xde, 0x98, 0x6f, 0x5d, 0x7a, 0xb5, 0x0a, 0x9e, 0x67, 0x97, 0x5e,
	0xcd, 0x46, 0x9f, 0x43, 0x36, 0x96, 0x19, 0x6a, 0xce, 0x7a, 0x53, 0x06, 0xc4, 0x4d, 0x1e, 0xfd,
	0x51, 0xbb, 0xf5, 0x12, 0x1d, 0xbc, 0x58, 0x91, 0x0e, 0xab, 0xb8, 0xda, 0xc2, 0x5f, 0x99, 0xb8,
	0x5a, 0x6e, 0x36, 0xea, 0xe6, 0x69, 0xfd, 0xb0, 0xde, 0x38, 0xab, 0x17, 0x66, 0xd0, 0x03, 0xb8,
	0x27, 0x57, 0xce, 0x70, 0xad, 0x55, 0x35, 0x5b, 0x8d, 0x86, 0xd9, 0x38, 0xaa, 0x14, 0x34, 0xb4,
	0x06, 0x48, 0x2e, 0x54, 0xaa, 0x47, 0xd5, 0x56, 0xd5, 0xc4, 0xe5, 0xfa, 0x41, 0xb5, 0x30, 0x3b,
	0x94, 0x37, 0xab, 0xb8, 0x56, 0x3e, 0xaa, 0x7d, 0x5d, 0xde, 0x3d, 0xaa, 0x16, 0xe6, 0xd0, 0x43,
	0xb8, 0x2f, 0xe5, 0x27, 0x8d, 0x66, 0xb3, 0xb6, 0x7b, 0x54, 0x35, 0x71, 0xf5, 0xe4, 0xa8, 0xfc,
	0x55, 0x21, 0xb5, 0x9e, 0xfa, 0xed, 0x9f, 0x8a, 0x33, 0x8f, 0x9e, 0x00, 0xba, 0x5b, 0x14, 0x68,
	0x11, 0x52, 0xf5, 0x46, 0xbd, 0x5a, 0x98, 0x41, 0x59, 0x48, 0xef, 0x96, 0xf7, 0x0e, 0x1b, 0xfb,
	0xfb, 0x05, 0x0d, 0xe5, 0x20, 0x53, 0x3b, 0x3e, 0xae, 0x56, 0x6a, 0xe5, 0x56, 0xb5, 0x30, 0xbb,
	0xfb, 0xfe, 0xab, 0xff, 0x16, 0x67, 0x5e, 0xdd, 0x14, 0xb5, 0x7f, 0xde, 0x14, 0xb5, 0x7f, 0xdd,
	0x14, 0xb5, 0xff, 0xdc, 0x14, 0xb5, 0xdf, 0xfd, 0xaf, 0x38, 0xf3, 0x75, 0x5a, 0x5d, 0xcb, 0xf7,
	0x01, 0x00, 0x00, 0xff, 0xff, 0x19, 0x93, 0x0e, 0x00, 0x99, 0x14, 0x00, 0x00,
}
