// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.25.0
// 	protoc        v3.13.0
// source: google/ads/googleads/v6/common/extensions.proto

package common

import (
	reflect "reflect"
	sync "sync"

	proto "github.com/golang/protobuf/proto"
	enums "google.golang.org/genproto/googleapis/ads/googleads/v6/enums"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// Represents an App extension.
type AppFeedItem struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The visible text displayed when the link is rendered in an ad.
	// This string must not be empty, and the length of this string should
	// be between 1 and 25, inclusive.
	LinkText *string `protobuf:"bytes,9,opt,name=link_text,json=linkText,proto3,oneof" json:"link_text,omitempty"`
	// The store-specific ID for the target application.
	// This string must not be empty.
	AppId *string `protobuf:"bytes,10,opt,name=app_id,json=appId,proto3,oneof" json:"app_id,omitempty"`
	// The application store that the target application belongs to.
	// This field is required.
	AppStore enums.AppStoreEnum_AppStore `protobuf:"varint,3,opt,name=app_store,json=appStore,proto3,enum=google.ads.googleads.v6.enums.AppStoreEnum_AppStore" json:"app_store,omitempty"`
	// A list of possible final URLs after all cross domain redirects.
	// This list must not be empty.
	FinalUrls []string `protobuf:"bytes,11,rep,name=final_urls,json=finalUrls,proto3" json:"final_urls,omitempty"`
	// A list of possible final mobile URLs after all cross domain redirects.
	FinalMobileUrls []string `protobuf:"bytes,12,rep,name=final_mobile_urls,json=finalMobileUrls,proto3" json:"final_mobile_urls,omitempty"`
	// URL template for constructing a tracking URL. Default value is "{lpurl}".
	TrackingUrlTemplate *string `protobuf:"bytes,13,opt,name=tracking_url_template,json=trackingUrlTemplate,proto3,oneof" json:"tracking_url_template,omitempty"`
	// A list of mappings to be used for substituting URL custom parameter tags in
	// the tracking_url_template, final_urls, and/or final_mobile_urls.
	UrlCustomParameters []*CustomParameter `protobuf:"bytes,7,rep,name=url_custom_parameters,json=urlCustomParameters,proto3" json:"url_custom_parameters,omitempty"`
	// URL template for appending params to landing page URLs served with parallel
	// tracking.
	FinalUrlSuffix *string `protobuf:"bytes,14,opt,name=final_url_suffix,json=finalUrlSuffix,proto3,oneof" json:"final_url_suffix,omitempty"`
}

func (x *AppFeedItem) Reset() {
	*x = AppFeedItem{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v6_common_extensions_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AppFeedItem) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AppFeedItem) ProtoMessage() {}

func (x *AppFeedItem) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v6_common_extensions_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AppFeedItem.ProtoReflect.Descriptor instead.
func (*AppFeedItem) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v6_common_extensions_proto_rawDescGZIP(), []int{0}
}

func (x *AppFeedItem) GetLinkText() string {
	if x != nil && x.LinkText != nil {
		return *x.LinkText
	}
	return ""
}

func (x *AppFeedItem) GetAppId() string {
	if x != nil && x.AppId != nil {
		return *x.AppId
	}
	return ""
}

func (x *AppFeedItem) GetAppStore() enums.AppStoreEnum_AppStore {
	if x != nil {
		return x.AppStore
	}
	return enums.AppStoreEnum_UNSPECIFIED
}

func (x *AppFeedItem) GetFinalUrls() []string {
	if x != nil {
		return x.FinalUrls
	}
	return nil
}

func (x *AppFeedItem) GetFinalMobileUrls() []string {
	if x != nil {
		return x.FinalMobileUrls
	}
	return nil
}

func (x *AppFeedItem) GetTrackingUrlTemplate() string {
	if x != nil && x.TrackingUrlTemplate != nil {
		return *x.TrackingUrlTemplate
	}
	return ""
}

func (x *AppFeedItem) GetUrlCustomParameters() []*CustomParameter {
	if x != nil {
		return x.UrlCustomParameters
	}
	return nil
}

func (x *AppFeedItem) GetFinalUrlSuffix() string {
	if x != nil && x.FinalUrlSuffix != nil {
		return *x.FinalUrlSuffix
	}
	return ""
}

// Represents a Call extension.
type CallFeedItem struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The advertiser's phone number to append to the ad.
	// This string must not be empty.
	PhoneNumber *string `protobuf:"bytes,7,opt,name=phone_number,json=phoneNumber,proto3,oneof" json:"phone_number,omitempty"`
	// Uppercase two-letter country code of the advertiser's phone number.
	// This string must not be empty.
	CountryCode *string `protobuf:"bytes,8,opt,name=country_code,json=countryCode,proto3,oneof" json:"country_code,omitempty"`
	// Indicates whether call tracking is enabled. By default, call tracking is
	// not enabled.
	CallTrackingEnabled *bool `protobuf:"varint,9,opt,name=call_tracking_enabled,json=callTrackingEnabled,proto3,oneof" json:"call_tracking_enabled,omitempty"`
	// The conversion action to attribute a call conversion to. If not set a
	// default conversion action is used. This field only has effect if
	// call_tracking_enabled is set to true. Otherwise this field is ignored.
	CallConversionAction *string `protobuf:"bytes,10,opt,name=call_conversion_action,json=callConversionAction,proto3,oneof" json:"call_conversion_action,omitempty"`
	// If true, disable call conversion tracking. call_conversion_action should
	// not be set if this is true. Optional.
	CallConversionTrackingDisabled *bool `protobuf:"varint,11,opt,name=call_conversion_tracking_disabled,json=callConversionTrackingDisabled,proto3,oneof" json:"call_conversion_tracking_disabled,omitempty"`
	// Enum value that indicates whether this call extension uses its own call
	// conversion setting (or just have call conversion disabled), or following
	// the account level setting.
	CallConversionReportingState enums.CallConversionReportingStateEnum_CallConversionReportingState `protobuf:"varint,6,opt,name=call_conversion_reporting_state,json=callConversionReportingState,proto3,enum=google.ads.googleads.v6.enums.CallConversionReportingStateEnum_CallConversionReportingState" json:"call_conversion_reporting_state,omitempty"`
}

func (x *CallFeedItem) Reset() {
	*x = CallFeedItem{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v6_common_extensions_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CallFeedItem) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CallFeedItem) ProtoMessage() {}

func (x *CallFeedItem) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v6_common_extensions_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CallFeedItem.ProtoReflect.Descriptor instead.
func (*CallFeedItem) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v6_common_extensions_proto_rawDescGZIP(), []int{1}
}

func (x *CallFeedItem) GetPhoneNumber() string {
	if x != nil && x.PhoneNumber != nil {
		return *x.PhoneNumber
	}
	return ""
}

func (x *CallFeedItem) GetCountryCode() string {
	if x != nil && x.CountryCode != nil {
		return *x.CountryCode
	}
	return ""
}

func (x *CallFeedItem) GetCallTrackingEnabled() bool {
	if x != nil && x.CallTrackingEnabled != nil {
		return *x.CallTrackingEnabled
	}
	return false
}

func (x *CallFeedItem) GetCallConversionAction() string {
	if x != nil && x.CallConversionAction != nil {
		return *x.CallConversionAction
	}
	return ""
}

func (x *CallFeedItem) GetCallConversionTrackingDisabled() bool {
	if x != nil && x.CallConversionTrackingDisabled != nil {
		return *x.CallConversionTrackingDisabled
	}
	return false
}

func (x *CallFeedItem) GetCallConversionReportingState() enums.CallConversionReportingStateEnum_CallConversionReportingState {
	if x != nil {
		return x.CallConversionReportingState
	}
	return enums.CallConversionReportingStateEnum_UNSPECIFIED
}

// Represents a callout extension.
type CalloutFeedItem struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The callout text.
	// The length of this string should be between 1 and 25, inclusive.
	CalloutText *string `protobuf:"bytes,2,opt,name=callout_text,json=calloutText,proto3,oneof" json:"callout_text,omitempty"`
}

func (x *CalloutFeedItem) Reset() {
	*x = CalloutFeedItem{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v6_common_extensions_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CalloutFeedItem) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CalloutFeedItem) ProtoMessage() {}

func (x *CalloutFeedItem) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v6_common_extensions_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CalloutFeedItem.ProtoReflect.Descriptor instead.
func (*CalloutFeedItem) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v6_common_extensions_proto_rawDescGZIP(), []int{2}
}

func (x *CalloutFeedItem) GetCalloutText() string {
	if x != nil && x.CalloutText != nil {
		return *x.CalloutText
	}
	return ""
}

// Represents a location extension.
type LocationFeedItem struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the business.
	BusinessName *string `protobuf:"bytes,9,opt,name=business_name,json=businessName,proto3,oneof" json:"business_name,omitempty"`
	// Line 1 of the business address.
	AddressLine_1 *string `protobuf:"bytes,10,opt,name=address_line_1,json=addressLine1,proto3,oneof" json:"address_line_1,omitempty"`
	// Line 2 of the business address.
	AddressLine_2 *string `protobuf:"bytes,11,opt,name=address_line_2,json=addressLine2,proto3,oneof" json:"address_line_2,omitempty"`
	// City of the business address.
	City *string `protobuf:"bytes,12,opt,name=city,proto3,oneof" json:"city,omitempty"`
	// Province of the business address.
	Province *string `protobuf:"bytes,13,opt,name=province,proto3,oneof" json:"province,omitempty"`
	// Postal code of the business address.
	PostalCode *string `protobuf:"bytes,14,opt,name=postal_code,json=postalCode,proto3,oneof" json:"postal_code,omitempty"`
	// Country code of the business address.
	CountryCode *string `protobuf:"bytes,15,opt,name=country_code,json=countryCode,proto3,oneof" json:"country_code,omitempty"`
	// Phone number of the business.
	PhoneNumber *string `protobuf:"bytes,16,opt,name=phone_number,json=phoneNumber,proto3,oneof" json:"phone_number,omitempty"`
}

func (x *LocationFeedItem) Reset() {
	*x = LocationFeedItem{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v6_common_extensions_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *LocationFeedItem) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LocationFeedItem) ProtoMessage() {}

func (x *LocationFeedItem) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v6_common_extensions_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use LocationFeedItem.ProtoReflect.Descriptor instead.
func (*LocationFeedItem) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v6_common_extensions_proto_rawDescGZIP(), []int{3}
}

func (x *LocationFeedItem) GetBusinessName() string {
	if x != nil && x.BusinessName != nil {
		return *x.BusinessName
	}
	return ""
}

func (x *LocationFeedItem) GetAddressLine_1() string {
	if x != nil && x.AddressLine_1 != nil {
		return *x.AddressLine_1
	}
	return ""
}

func (x *LocationFeedItem) GetAddressLine_2() string {
	if x != nil && x.AddressLine_2 != nil {
		return *x.AddressLine_2
	}
	return ""
}

func (x *LocationFeedItem) GetCity() string {
	if x != nil && x.City != nil {
		return *x.City
	}
	return ""
}

func (x *LocationFeedItem) GetProvince() string {
	if x != nil && x.Province != nil {
		return *x.Province
	}
	return ""
}

func (x *LocationFeedItem) GetPostalCode() string {
	if x != nil && x.PostalCode != nil {
		return *x.PostalCode
	}
	return ""
}

func (x *LocationFeedItem) GetCountryCode() string {
	if x != nil && x.CountryCode != nil {
		return *x.CountryCode
	}
	return ""
}

func (x *LocationFeedItem) GetPhoneNumber() string {
	if x != nil && x.PhoneNumber != nil {
		return *x.PhoneNumber
	}
	return ""
}

// Represents an affiliate location extension.
type AffiliateLocationFeedItem struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the business.
	BusinessName *string `protobuf:"bytes,11,opt,name=business_name,json=businessName,proto3,oneof" json:"business_name,omitempty"`
	// Line 1 of the business address.
	AddressLine_1 *string `protobuf:"bytes,12,opt,name=address_line_1,json=addressLine1,proto3,oneof" json:"address_line_1,omitempty"`
	// Line 2 of the business address.
	AddressLine_2 *string `protobuf:"bytes,13,opt,name=address_line_2,json=addressLine2,proto3,oneof" json:"address_line_2,omitempty"`
	// City of the business address.
	City *string `protobuf:"bytes,14,opt,name=city,proto3,oneof" json:"city,omitempty"`
	// Province of the business address.
	Province *string `protobuf:"bytes,15,opt,name=province,proto3,oneof" json:"province,omitempty"`
	// Postal code of the business address.
	PostalCode *string `protobuf:"bytes,16,opt,name=postal_code,json=postalCode,proto3,oneof" json:"postal_code,omitempty"`
	// Country code of the business address.
	CountryCode *string `protobuf:"bytes,17,opt,name=country_code,json=countryCode,proto3,oneof" json:"country_code,omitempty"`
	// Phone number of the business.
	PhoneNumber *string `protobuf:"bytes,18,opt,name=phone_number,json=phoneNumber,proto3,oneof" json:"phone_number,omitempty"`
	// Id of the retail chain that is advertised as a seller of your product.
	ChainId *int64 `protobuf:"varint,19,opt,name=chain_id,json=chainId,proto3,oneof" json:"chain_id,omitempty"`
	// Name of chain.
	ChainName *string `protobuf:"bytes,20,opt,name=chain_name,json=chainName,proto3,oneof" json:"chain_name,omitempty"`
}

func (x *AffiliateLocationFeedItem) Reset() {
	*x = AffiliateLocationFeedItem{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v6_common_extensions_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *AffiliateLocationFeedItem) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AffiliateLocationFeedItem) ProtoMessage() {}

func (x *AffiliateLocationFeedItem) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v6_common_extensions_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AffiliateLocationFeedItem.ProtoReflect.Descriptor instead.
func (*AffiliateLocationFeedItem) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v6_common_extensions_proto_rawDescGZIP(), []int{4}
}

func (x *AffiliateLocationFeedItem) GetBusinessName() string {
	if x != nil && x.BusinessName != nil {
		return *x.BusinessName
	}
	return ""
}

func (x *AffiliateLocationFeedItem) GetAddressLine_1() string {
	if x != nil && x.AddressLine_1 != nil {
		return *x.AddressLine_1
	}
	return ""
}

func (x *AffiliateLocationFeedItem) GetAddressLine_2() string {
	if x != nil && x.AddressLine_2 != nil {
		return *x.AddressLine_2
	}
	return ""
}

func (x *AffiliateLocationFeedItem) GetCity() string {
	if x != nil && x.City != nil {
		return *x.City
	}
	return ""
}

func (x *AffiliateLocationFeedItem) GetProvince() string {
	if x != nil && x.Province != nil {
		return *x.Province
	}
	return ""
}

func (x *AffiliateLocationFeedItem) GetPostalCode() string {
	if x != nil && x.PostalCode != nil {
		return *x.PostalCode
	}
	return ""
}

func (x *AffiliateLocationFeedItem) GetCountryCode() string {
	if x != nil && x.CountryCode != nil {
		return *x.CountryCode
	}
	return ""
}

func (x *AffiliateLocationFeedItem) GetPhoneNumber() string {
	if x != nil && x.PhoneNumber != nil {
		return *x.PhoneNumber
	}
	return ""
}

func (x *AffiliateLocationFeedItem) GetChainId() int64 {
	if x != nil && x.ChainId != nil {
		return *x.ChainId
	}
	return 0
}

func (x *AffiliateLocationFeedItem) GetChainName() string {
	if x != nil && x.ChainName != nil {
		return *x.ChainName
	}
	return ""
}

// An extension that users can click on to send a text message to the
// advertiser.
type TextMessageFeedItem struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The business name to prepend to the message text.
	// This field is required.
	BusinessName *string `protobuf:"bytes,6,opt,name=business_name,json=businessName,proto3,oneof" json:"business_name,omitempty"`
	// Uppercase two-letter country code of the advertiser's phone number.
	// This field is required.
	CountryCode *string `protobuf:"bytes,7,opt,name=country_code,json=countryCode,proto3,oneof" json:"country_code,omitempty"`
	// The advertiser's phone number the message will be sent to. Required.
	PhoneNumber *string `protobuf:"bytes,8,opt,name=phone_number,json=phoneNumber,proto3,oneof" json:"phone_number,omitempty"`
	// The text to show in the ad.
	// This field is required.
	Text *string `protobuf:"bytes,9,opt,name=text,proto3,oneof" json:"text,omitempty"`
	// The message extension_text populated in the messaging app.
	ExtensionText *string `protobuf:"bytes,10,opt,name=extension_text,json=extensionText,proto3,oneof" json:"extension_text,omitempty"`
}

func (x *TextMessageFeedItem) Reset() {
	*x = TextMessageFeedItem{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v6_common_extensions_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TextMessageFeedItem) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TextMessageFeedItem) ProtoMessage() {}

func (x *TextMessageFeedItem) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v6_common_extensions_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TextMessageFeedItem.ProtoReflect.Descriptor instead.
func (*TextMessageFeedItem) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v6_common_extensions_proto_rawDescGZIP(), []int{5}
}

func (x *TextMessageFeedItem) GetBusinessName() string {
	if x != nil && x.BusinessName != nil {
		return *x.BusinessName
	}
	return ""
}

func (x *TextMessageFeedItem) GetCountryCode() string {
	if x != nil && x.CountryCode != nil {
		return *x.CountryCode
	}
	return ""
}

func (x *TextMessageFeedItem) GetPhoneNumber() string {
	if x != nil && x.PhoneNumber != nil {
		return *x.PhoneNumber
	}
	return ""
}

func (x *TextMessageFeedItem) GetText() string {
	if x != nil && x.Text != nil {
		return *x.Text
	}
	return ""
}

func (x *TextMessageFeedItem) GetExtensionText() string {
	if x != nil && x.ExtensionText != nil {
		return *x.ExtensionText
	}
	return ""
}

// Represents a Price extension.
type PriceFeedItem struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Price extension type of this extension.
	Type enums.PriceExtensionTypeEnum_PriceExtensionType `protobuf:"varint,1,opt,name=type,proto3,enum=google.ads.googleads.v6.enums.PriceExtensionTypeEnum_PriceExtensionType" json:"type,omitempty"`
	// Price qualifier for all offers of this price extension.
	PriceQualifier enums.PriceExtensionPriceQualifierEnum_PriceExtensionPriceQualifier `protobuf:"varint,2,opt,name=price_qualifier,json=priceQualifier,proto3,enum=google.ads.googleads.v6.enums.PriceExtensionPriceQualifierEnum_PriceExtensionPriceQualifier" json:"price_qualifier,omitempty"`
	// Tracking URL template for all offers of this price extension.
	TrackingUrlTemplate *string `protobuf:"bytes,7,opt,name=tracking_url_template,json=trackingUrlTemplate,proto3,oneof" json:"tracking_url_template,omitempty"`
	// The code of the language used for this price extension.
	LanguageCode *string `protobuf:"bytes,8,opt,name=language_code,json=languageCode,proto3,oneof" json:"language_code,omitempty"`
	// The price offerings in this price extension.
	PriceOfferings []*PriceOffer `protobuf:"bytes,5,rep,name=price_offerings,json=priceOfferings,proto3" json:"price_offerings,omitempty"`
	// Tracking URL template for all offers of this price extension.
	FinalUrlSuffix *string `protobuf:"bytes,9,opt,name=final_url_suffix,json=finalUrlSuffix,proto3,oneof" json:"final_url_suffix,omitempty"`
}

func (x *PriceFeedItem) Reset() {
	*x = PriceFeedItem{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v6_common_extensions_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PriceFeedItem) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PriceFeedItem) ProtoMessage() {}

func (x *PriceFeedItem) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v6_common_extensions_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PriceFeedItem.ProtoReflect.Descriptor instead.
func (*PriceFeedItem) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v6_common_extensions_proto_rawDescGZIP(), []int{6}
}

func (x *PriceFeedItem) GetType() enums.PriceExtensionTypeEnum_PriceExtensionType {
	if x != nil {
		return x.Type
	}
	return enums.PriceExtensionTypeEnum_UNSPECIFIED
}

func (x *PriceFeedItem) GetPriceQualifier() enums.PriceExtensionPriceQualifierEnum_PriceExtensionPriceQualifier {
	if x != nil {
		return x.PriceQualifier
	}
	return enums.PriceExtensionPriceQualifierEnum_UNSPECIFIED
}

func (x *PriceFeedItem) GetTrackingUrlTemplate() string {
	if x != nil && x.TrackingUrlTemplate != nil {
		return *x.TrackingUrlTemplate
	}
	return ""
}

func (x *PriceFeedItem) GetLanguageCode() string {
	if x != nil && x.LanguageCode != nil {
		return *x.LanguageCode
	}
	return ""
}

func (x *PriceFeedItem) GetPriceOfferings() []*PriceOffer {
	if x != nil {
		return x.PriceOfferings
	}
	return nil
}

func (x *PriceFeedItem) GetFinalUrlSuffix() string {
	if x != nil && x.FinalUrlSuffix != nil {
		return *x.FinalUrlSuffix
	}
	return ""
}

// Represents one price offer in a price extension.
type PriceOffer struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Header text of this offer.
	Header *string `protobuf:"bytes,7,opt,name=header,proto3,oneof" json:"header,omitempty"`
	// Description text of this offer.
	Description *string `protobuf:"bytes,8,opt,name=description,proto3,oneof" json:"description,omitempty"`
	// Price value of this offer.
	Price *Money `protobuf:"bytes,3,opt,name=price,proto3" json:"price,omitempty"`
	// Price unit for this offer.
	Unit enums.PriceExtensionPriceUnitEnum_PriceExtensionPriceUnit `protobuf:"varint,4,opt,name=unit,proto3,enum=google.ads.googleads.v6.enums.PriceExtensionPriceUnitEnum_PriceExtensionPriceUnit" json:"unit,omitempty"`
	// A list of possible final URLs after all cross domain redirects.
	FinalUrls []string `protobuf:"bytes,9,rep,name=final_urls,json=finalUrls,proto3" json:"final_urls,omitempty"`
	// A list of possible final mobile URLs after all cross domain redirects.
	FinalMobileUrls []string `protobuf:"bytes,10,rep,name=final_mobile_urls,json=finalMobileUrls,proto3" json:"final_mobile_urls,omitempty"`
}

func (x *PriceOffer) Reset() {
	*x = PriceOffer{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v6_common_extensions_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PriceOffer) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PriceOffer) ProtoMessage() {}

func (x *PriceOffer) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v6_common_extensions_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PriceOffer.ProtoReflect.Descriptor instead.
func (*PriceOffer) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v6_common_extensions_proto_rawDescGZIP(), []int{7}
}

func (x *PriceOffer) GetHeader() string {
	if x != nil && x.Header != nil {
		return *x.Header
	}
	return ""
}

func (x *PriceOffer) GetDescription() string {
	if x != nil && x.Description != nil {
		return *x.Description
	}
	return ""
}

func (x *PriceOffer) GetPrice() *Money {
	if x != nil {
		return x.Price
	}
	return nil
}

func (x *PriceOffer) GetUnit() enums.PriceExtensionPriceUnitEnum_PriceExtensionPriceUnit {
	if x != nil {
		return x.Unit
	}
	return enums.PriceExtensionPriceUnitEnum_UNSPECIFIED
}

func (x *PriceOffer) GetFinalUrls() []string {
	if x != nil {
		return x.FinalUrls
	}
	return nil
}

func (x *PriceOffer) GetFinalMobileUrls() []string {
	if x != nil {
		return x.FinalMobileUrls
	}
	return nil
}

// Represents a Promotion extension.
type PromotionFeedItem struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A freeform description of what the promotion is targeting.
	// This field is required.
	PromotionTarget *string `protobuf:"bytes,16,opt,name=promotion_target,json=promotionTarget,proto3,oneof" json:"promotion_target,omitempty"`
	// Enum that modifies the qualification of the discount.
	DiscountModifier enums.PromotionExtensionDiscountModifierEnum_PromotionExtensionDiscountModifier `protobuf:"varint,2,opt,name=discount_modifier,json=discountModifier,proto3,enum=google.ads.googleads.v6.enums.PromotionExtensionDiscountModifierEnum_PromotionExtensionDiscountModifier" json:"discount_modifier,omitempty"`
	// Start date of when the promotion is eligible to be redeemed.
	PromotionStartDate *string `protobuf:"bytes,19,opt,name=promotion_start_date,json=promotionStartDate,proto3,oneof" json:"promotion_start_date,omitempty"`
	// End date of when the promotion is eligible to be redeemed.
	PromotionEndDate *string `protobuf:"bytes,20,opt,name=promotion_end_date,json=promotionEndDate,proto3,oneof" json:"promotion_end_date,omitempty"`
	// The occasion the promotion was intended for.
	// If an occasion is set, the redemption window will need to fall within
	// the date range associated with the occasion.
	Occasion enums.PromotionExtensionOccasionEnum_PromotionExtensionOccasion `protobuf:"varint,9,opt,name=occasion,proto3,enum=google.ads.googleads.v6.enums.PromotionExtensionOccasionEnum_PromotionExtensionOccasion" json:"occasion,omitempty"`
	// A list of possible final URLs after all cross domain redirects.
	// This field is required.
	FinalUrls []string `protobuf:"bytes,21,rep,name=final_urls,json=finalUrls,proto3" json:"final_urls,omitempty"`
	// A list of possible final mobile URLs after all cross domain redirects.
	FinalMobileUrls []string `protobuf:"bytes,22,rep,name=final_mobile_urls,json=finalMobileUrls,proto3" json:"final_mobile_urls,omitempty"`
	// URL template for constructing a tracking URL.
	TrackingUrlTemplate *string `protobuf:"bytes,23,opt,name=tracking_url_template,json=trackingUrlTemplate,proto3,oneof" json:"tracking_url_template,omitempty"`
	// A list of mappings to be used for substituting URL custom parameter tags in
	// the tracking_url_template, final_urls, and/or final_mobile_urls.
	UrlCustomParameters []*CustomParameter `protobuf:"bytes,13,rep,name=url_custom_parameters,json=urlCustomParameters,proto3" json:"url_custom_parameters,omitempty"`
	// URL template for appending params to landing page URLs served with parallel
	// tracking.
	FinalUrlSuffix *string `protobuf:"bytes,24,opt,name=final_url_suffix,json=finalUrlSuffix,proto3,oneof" json:"final_url_suffix,omitempty"`
	// The language of the promotion.
	// Represented as BCP 47 language tag.
	LanguageCode *string `protobuf:"bytes,25,opt,name=language_code,json=languageCode,proto3,oneof" json:"language_code,omitempty"`
	// Discount type, can be percentage off or amount off.
	//
	// Types that are assignable to DiscountType:
	//	*PromotionFeedItem_PercentOff
	//	*PromotionFeedItem_MoneyAmountOff
	DiscountType isPromotionFeedItem_DiscountType `protobuf_oneof:"discount_type"`
	// Promotion trigger. Can be by promotion code or promo by eligible order
	// amount.
	//
	// Types that are assignable to PromotionTrigger:
	//	*PromotionFeedItem_PromotionCode
	//	*PromotionFeedItem_OrdersOverAmount
	PromotionTrigger isPromotionFeedItem_PromotionTrigger `protobuf_oneof:"promotion_trigger"`
}

func (x *PromotionFeedItem) Reset() {
	*x = PromotionFeedItem{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v6_common_extensions_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PromotionFeedItem) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PromotionFeedItem) ProtoMessage() {}

func (x *PromotionFeedItem) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v6_common_extensions_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PromotionFeedItem.ProtoReflect.Descriptor instead.
func (*PromotionFeedItem) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v6_common_extensions_proto_rawDescGZIP(), []int{8}
}

func (x *PromotionFeedItem) GetPromotionTarget() string {
	if x != nil && x.PromotionTarget != nil {
		return *x.PromotionTarget
	}
	return ""
}

func (x *PromotionFeedItem) GetDiscountModifier() enums.PromotionExtensionDiscountModifierEnum_PromotionExtensionDiscountModifier {
	if x != nil {
		return x.DiscountModifier
	}
	return enums.PromotionExtensionDiscountModifierEnum_UNSPECIFIED
}

func (x *PromotionFeedItem) GetPromotionStartDate() string {
	if x != nil && x.PromotionStartDate != nil {
		return *x.PromotionStartDate
	}
	return ""
}

func (x *PromotionFeedItem) GetPromotionEndDate() string {
	if x != nil && x.PromotionEndDate != nil {
		return *x.PromotionEndDate
	}
	return ""
}

func (x *PromotionFeedItem) GetOccasion() enums.PromotionExtensionOccasionEnum_PromotionExtensionOccasion {
	if x != nil {
		return x.Occasion
	}
	return enums.PromotionExtensionOccasionEnum_UNSPECIFIED
}

func (x *PromotionFeedItem) GetFinalUrls() []string {
	if x != nil {
		return x.FinalUrls
	}
	return nil
}

func (x *PromotionFeedItem) GetFinalMobileUrls() []string {
	if x != nil {
		return x.FinalMobileUrls
	}
	return nil
}

func (x *PromotionFeedItem) GetTrackingUrlTemplate() string {
	if x != nil && x.TrackingUrlTemplate != nil {
		return *x.TrackingUrlTemplate
	}
	return ""
}

func (x *PromotionFeedItem) GetUrlCustomParameters() []*CustomParameter {
	if x != nil {
		return x.UrlCustomParameters
	}
	return nil
}

func (x *PromotionFeedItem) GetFinalUrlSuffix() string {
	if x != nil && x.FinalUrlSuffix != nil {
		return *x.FinalUrlSuffix
	}
	return ""
}

func (x *PromotionFeedItem) GetLanguageCode() string {
	if x != nil && x.LanguageCode != nil {
		return *x.LanguageCode
	}
	return ""
}

func (m *PromotionFeedItem) GetDiscountType() isPromotionFeedItem_DiscountType {
	if m != nil {
		return m.DiscountType
	}
	return nil
}

func (x *PromotionFeedItem) GetPercentOff() int64 {
	if x, ok := x.GetDiscountType().(*PromotionFeedItem_PercentOff); ok {
		return x.PercentOff
	}
	return 0
}

func (x *PromotionFeedItem) GetMoneyAmountOff() *Money {
	if x, ok := x.GetDiscountType().(*PromotionFeedItem_MoneyAmountOff); ok {
		return x.MoneyAmountOff
	}
	return nil
}

func (m *PromotionFeedItem) GetPromotionTrigger() isPromotionFeedItem_PromotionTrigger {
	if m != nil {
		return m.PromotionTrigger
	}
	return nil
}

func (x *PromotionFeedItem) GetPromotionCode() string {
	if x, ok := x.GetPromotionTrigger().(*PromotionFeedItem_PromotionCode); ok {
		return x.PromotionCode
	}
	return ""
}

func (x *PromotionFeedItem) GetOrdersOverAmount() *Money {
	if x, ok := x.GetPromotionTrigger().(*PromotionFeedItem_OrdersOverAmount); ok {
		return x.OrdersOverAmount
	}
	return nil
}

type isPromotionFeedItem_DiscountType interface {
	isPromotionFeedItem_DiscountType()
}

type PromotionFeedItem_PercentOff struct {
	// Percentage off discount in the promotion in micros.
	// One million is equivalent to one percent.
	// Either this or money_off_amount is required.
	PercentOff int64 `protobuf:"varint,17,opt,name=percent_off,json=percentOff,proto3,oneof"`
}

type PromotionFeedItem_MoneyAmountOff struct {
	// Money amount off for discount in the promotion.
	// Either this or percent_off is required.
	MoneyAmountOff *Money `protobuf:"bytes,4,opt,name=money_amount_off,json=moneyAmountOff,proto3,oneof"`
}

func (*PromotionFeedItem_PercentOff) isPromotionFeedItem_DiscountType() {}

func (*PromotionFeedItem_MoneyAmountOff) isPromotionFeedItem_DiscountType() {}

type isPromotionFeedItem_PromotionTrigger interface {
	isPromotionFeedItem_PromotionTrigger()
}

type PromotionFeedItem_PromotionCode struct {
	// A code the user should use in order to be eligible for the promotion.
	PromotionCode string `protobuf:"bytes,18,opt,name=promotion_code,json=promotionCode,proto3,oneof"`
}

type PromotionFeedItem_OrdersOverAmount struct {
	// The amount the total order needs to be for the user to be eligible for
	// the promotion.
	OrdersOverAmount *Money `protobuf:"bytes,6,opt,name=orders_over_amount,json=ordersOverAmount,proto3,oneof"`
}

func (*PromotionFeedItem_PromotionCode) isPromotionFeedItem_PromotionTrigger() {}

func (*PromotionFeedItem_OrdersOverAmount) isPromotionFeedItem_PromotionTrigger() {}

// Represents a structured snippet extension.
type StructuredSnippetFeedItem struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The header of the snippet.
	// This string must not be empty.
	Header *string `protobuf:"bytes,3,opt,name=header,proto3,oneof" json:"header,omitempty"`
	// The values in the snippet.
	// The maximum size of this collection is 10.
	Values []string `protobuf:"bytes,4,rep,name=values,proto3" json:"values,omitempty"`
}

func (x *StructuredSnippetFeedItem) Reset() {
	*x = StructuredSnippetFeedItem{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v6_common_extensions_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StructuredSnippetFeedItem) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StructuredSnippetFeedItem) ProtoMessage() {}

func (x *StructuredSnippetFeedItem) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v6_common_extensions_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StructuredSnippetFeedItem.ProtoReflect.Descriptor instead.
func (*StructuredSnippetFeedItem) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v6_common_extensions_proto_rawDescGZIP(), []int{9}
}

func (x *StructuredSnippetFeedItem) GetHeader() string {
	if x != nil && x.Header != nil {
		return *x.Header
	}
	return ""
}

func (x *StructuredSnippetFeedItem) GetValues() []string {
	if x != nil {
		return x.Values
	}
	return nil
}

// Represents a sitelink extension.
type SitelinkFeedItem struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// URL display text for the sitelink.
	// The length of this string should be between 1 and 25, inclusive.
	LinkText *string `protobuf:"bytes,9,opt,name=link_text,json=linkText,proto3,oneof" json:"link_text,omitempty"`
	// First line of the description for the sitelink.
	// If this value is set, line2 must also be set.
	// The length of this string should be between 0 and 35, inclusive.
	Line1 *string `protobuf:"bytes,10,opt,name=line1,proto3,oneof" json:"line1,omitempty"`
	// Second line of the description for the sitelink.
	// If this value is set, line1 must also be set.
	// The length of this string should be between 0 and 35, inclusive.
	Line2 *string `protobuf:"bytes,11,opt,name=line2,proto3,oneof" json:"line2,omitempty"`
	// A list of possible final URLs after all cross domain redirects.
	FinalUrls []string `protobuf:"bytes,12,rep,name=final_urls,json=finalUrls,proto3" json:"final_urls,omitempty"`
	// A list of possible final mobile URLs after all cross domain redirects.
	FinalMobileUrls []string `protobuf:"bytes,13,rep,name=final_mobile_urls,json=finalMobileUrls,proto3" json:"final_mobile_urls,omitempty"`
	// URL template for constructing a tracking URL.
	TrackingUrlTemplate *string `protobuf:"bytes,14,opt,name=tracking_url_template,json=trackingUrlTemplate,proto3,oneof" json:"tracking_url_template,omitempty"`
	// A list of mappings to be used for substituting URL custom parameter tags in
	// the tracking_url_template, final_urls, and/or final_mobile_urls.
	UrlCustomParameters []*CustomParameter `protobuf:"bytes,7,rep,name=url_custom_parameters,json=urlCustomParameters,proto3" json:"url_custom_parameters,omitempty"`
	// Final URL suffix to be appended to landing page URLs served with
	// parallel tracking.
	FinalUrlSuffix *string `protobuf:"bytes,15,opt,name=final_url_suffix,json=finalUrlSuffix,proto3,oneof" json:"final_url_suffix,omitempty"`
}

func (x *SitelinkFeedItem) Reset() {
	*x = SitelinkFeedItem{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v6_common_extensions_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SitelinkFeedItem) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SitelinkFeedItem) ProtoMessage() {}

func (x *SitelinkFeedItem) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v6_common_extensions_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SitelinkFeedItem.ProtoReflect.Descriptor instead.
func (*SitelinkFeedItem) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v6_common_extensions_proto_rawDescGZIP(), []int{10}
}

func (x *SitelinkFeedItem) GetLinkText() string {
	if x != nil && x.LinkText != nil {
		return *x.LinkText
	}
	return ""
}

func (x *SitelinkFeedItem) GetLine1() string {
	if x != nil && x.Line1 != nil {
		return *x.Line1
	}
	return ""
}

func (x *SitelinkFeedItem) GetLine2() string {
	if x != nil && x.Line2 != nil {
		return *x.Line2
	}
	return ""
}

func (x *SitelinkFeedItem) GetFinalUrls() []string {
	if x != nil {
		return x.FinalUrls
	}
	return nil
}

func (x *SitelinkFeedItem) GetFinalMobileUrls() []string {
	if x != nil {
		return x.FinalMobileUrls
	}
	return nil
}

func (x *SitelinkFeedItem) GetTrackingUrlTemplate() string {
	if x != nil && x.TrackingUrlTemplate != nil {
		return *x.TrackingUrlTemplate
	}
	return ""
}

func (x *SitelinkFeedItem) GetUrlCustomParameters() []*CustomParameter {
	if x != nil {
		return x.UrlCustomParameters
	}
	return nil
}

func (x *SitelinkFeedItem) GetFinalUrlSuffix() string {
	if x != nil && x.FinalUrlSuffix != nil {
		return *x.FinalUrlSuffix
	}
	return ""
}

// Represents a hotel callout extension.
type HotelCalloutFeedItem struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The callout text.
	// The length of this string should be between 1 and 25, inclusive.
	Text *string `protobuf:"bytes,3,opt,name=text,proto3,oneof" json:"text,omitempty"`
	// The language of the hotel callout text.
	// IETF BCP 47 compliant language code.
	LanguageCode *string `protobuf:"bytes,4,opt,name=language_code,json=languageCode,proto3,oneof" json:"language_code,omitempty"`
}

func (x *HotelCalloutFeedItem) Reset() {
	*x = HotelCalloutFeedItem{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v6_common_extensions_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *HotelCalloutFeedItem) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*HotelCalloutFeedItem) ProtoMessage() {}

func (x *HotelCalloutFeedItem) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v6_common_extensions_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use HotelCalloutFeedItem.ProtoReflect.Descriptor instead.
func (*HotelCalloutFeedItem) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v6_common_extensions_proto_rawDescGZIP(), []int{11}
}

func (x *HotelCalloutFeedItem) GetText() string {
	if x != nil && x.Text != nil {
		return *x.Text
	}
	return ""
}

func (x *HotelCalloutFeedItem) GetLanguageCode() string {
	if x != nil && x.LanguageCode != nil {
		return *x.LanguageCode
	}
	return ""
}

// Represents an advertiser provided image extension.
type ImageFeedItem struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the image asset.
	ImageAsset string `protobuf:"bytes,1,opt,name=image_asset,json=imageAsset,proto3" json:"image_asset,omitempty"`
}

func (x *ImageFeedItem) Reset() {
	*x = ImageFeedItem{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_ads_googleads_v6_common_extensions_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImageFeedItem) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImageFeedItem) ProtoMessage() {}

func (x *ImageFeedItem) ProtoReflect() protoreflect.Message {
	mi := &file_google_ads_googleads_v6_common_extensions_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImageFeedItem.ProtoReflect.Descriptor instead.
func (*ImageFeedItem) Descriptor() ([]byte, []int) {
	return file_google_ads_googleads_v6_common_extensions_proto_rawDescGZIP(), []int{12}
}

func (x *ImageFeedItem) GetImageAsset() string {
	if x != nil {
		return x.ImageAsset
	}
	return ""
}

var File_google_ads_googleads_v6_common_extensions_proto protoreflect.FileDescriptor

var file_google_ads_googleads_v6_common_extensions_proto_rawDesc = []byte{
	0x0a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
	0x2f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x1a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x2f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74,
	0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76,
	0x36, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2f, 0x66, 0x65, 0x65, 0x64, 0x5f, 0x63, 0x6f,
	0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x2d, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73,
	0x2f, 0x76, 0x36, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x61, 0x70, 0x70, 0x5f, 0x73, 0x74,
	0x6f, 0x72, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x43, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f,
	0x76, 0x36, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x63, 0x61, 0x6c, 0x6c, 0x5f, 0x63, 0x6f,
	0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69,
	0x6e, 0x67, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x43,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x70, 0x72,
	0x69, 0x63, 0x65, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x70, 0x72,
	0x69, 0x63, 0x65, 0x5f, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x66, 0x69, 0x65, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x3e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f, 0x65, 0x6e, 0x75,
	0x6d, 0x73, 0x2f, 0x70, 0x72, 0x69, 0x63, 0x65, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x5f, 0x70, 0x72, 0x69, 0x63, 0x65, 0x5f, 0x75, 0x6e, 0x69, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x38, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f, 0x65, 0x6e, 0x75,
	0x6d, 0x73, 0x2f, 0x70, 0x72, 0x69, 0x63, 0x65, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x49, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x70, 0x72, 0x6f,
	0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x5f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69,
	0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x40, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76,
	0x36, 0x2f, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2f, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f,
	0x6e, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x6f, 0x63, 0x63, 0x61,
	0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xfe, 0x03, 0x0a, 0x0b, 0x41, 0x70, 0x70, 0x46, 0x65, 0x65, 0x64,
	0x49, 0x74, 0x65, 0x6d, 0x12, 0x20, 0x0a, 0x09, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x74, 0x65, 0x78,
	0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x08, 0x6c, 0x69, 0x6e, 0x6b, 0x54,
	0x65, 0x78, 0x74, 0x88, 0x01, 0x01, 0x12, 0x1a, 0x0a, 0x06, 0x61, 0x70, 0x70, 0x5f, 0x69, 0x64,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x05, 0x61, 0x70, 0x70, 0x49, 0x64, 0x88,
	0x01, 0x01, 0x12, 0x51, 0x0a, 0x09, 0x61, 0x70, 0x70, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e,
	0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x41, 0x70, 0x70, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x45, 0x6e,
	0x75, 0x6d, 0x2e, 0x41, 0x70, 0x70, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x08, 0x61, 0x70, 0x70,
	0x53, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x75,
	0x72, 0x6c, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x66, 0x69, 0x6e, 0x61, 0x6c,
	0x55, 0x72, 0x6c, 0x73, 0x12, 0x2a, 0x0a, 0x11, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x6d, 0x6f,
	0x62, 0x69, 0x6c, 0x65, 0x5f, 0x75, 0x72, 0x6c, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x0f, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x4d, 0x6f, 0x62, 0x69, 0x6c, 0x65, 0x55, 0x72, 0x6c, 0x73,
	0x12, 0x37, 0x0a, 0x15, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x75, 0x72, 0x6c,
	0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x02, 0x52, 0x13, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x55, 0x72, 0x6c, 0x54, 0x65,
	0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x88, 0x01, 0x01, 0x12, 0x63, 0x0a, 0x15, 0x75, 0x72, 0x6c,
	0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e,
	0x76, 0x36, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x52, 0x13, 0x75, 0x72, 0x6c, 0x43, 0x75,
	0x73, 0x74, 0x6f, 0x6d, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x2d,
	0x0a, 0x10, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x75, 0x72, 0x6c, 0x5f, 0x73, 0x75, 0x66, 0x66,
	0x69, 0x78, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x48, 0x03, 0x52, 0x0e, 0x66, 0x69, 0x6e, 0x61,
	0x6c, 0x55, 0x72, 0x6c, 0x53, 0x75, 0x66, 0x66, 0x69, 0x78, 0x88, 0x01, 0x01, 0x42, 0x0c, 0x0a,
	0x0a, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x42, 0x09, 0x0a, 0x07, 0x5f,
	0x61, 0x70, 0x70, 0x5f, 0x69, 0x64, 0x42, 0x18, 0x0a, 0x16, 0x5f, 0x74, 0x72, 0x61, 0x63, 0x6b,
	0x69, 0x6e, 0x67, 0x5f, 0x75, 0x72, 0x6c, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65,
	0x42, 0x13, 0x0a, 0x11, 0x5f, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x75, 0x72, 0x6c, 0x5f, 0x73,
	0x75, 0x66, 0x66, 0x69, 0x78, 0x22, 0xc5, 0x04, 0x0a, 0x0c, 0x43, 0x61, 0x6c, 0x6c, 0x46, 0x65,
	0x65, 0x64, 0x49, 0x74, 0x65, 0x6d, 0x12, 0x26, 0x0a, 0x0c, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x5f,
	0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0b,
	0x70, 0x68, 0x6f, 0x6e, 0x65, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x88, 0x01, 0x01, 0x12, 0x26,
	0x0a, 0x0c, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x0b, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x43,
	0x6f, 0x64, 0x65, 0x88, 0x01, 0x01, 0x12, 0x37, 0x0a, 0x15, 0x63, 0x61, 0x6c, 0x6c, 0x5f, 0x74,
	0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x08, 0x48, 0x02, 0x52, 0x13, 0x63, 0x61, 0x6c, 0x6c, 0x54, 0x72, 0x61,
	0x63, 0x6b, 0x69, 0x6e, 0x67, 0x45, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x88, 0x01, 0x01, 0x12,
	0x39, 0x0a, 0x16, 0x63, 0x61, 0x6c, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x03, 0x52, 0x14, 0x63, 0x61, 0x6c, 0x6c, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x4e, 0x0a, 0x21, 0x63, 0x61,
	0x6c, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x72,
	0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x18,
	0x0b, 0x20, 0x01, 0x28, 0x08, 0x48, 0x04, 0x52, 0x1e, 0x63, 0x61, 0x6c, 0x6c, 0x43, 0x6f, 0x6e,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x44,
	0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x88, 0x01, 0x01, 0x12, 0xa3, 0x01, 0x0a, 0x1f, 0x63,
	0x61, 0x6c, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x72,
	0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x5c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x65,
	0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
	0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74,
	0x65, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61,
	0x74, 0x65, 0x52, 0x1c, 0x63, 0x61, 0x6c, 0x6c, 0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69,
	0x6f, 0x6e, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65,
	0x72, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x63, 0x6f,
	0x64, 0x65, 0x42, 0x18, 0x0a, 0x16, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x5f, 0x74, 0x72, 0x61, 0x63,
	0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x42, 0x19, 0x0a, 0x17,
	0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x5f, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x24, 0x0a, 0x22, 0x5f, 0x63, 0x61, 0x6c, 0x6c,
	0x5f, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x72, 0x61, 0x63,
	0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x64, 0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x22, 0x4a, 0x0a,
	0x0f, 0x43, 0x61, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x46, 0x65, 0x65, 0x64, 0x49, 0x74, 0x65, 0x6d,
	0x12, 0x26, 0x0a, 0x0c, 0x63, 0x61, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x5f, 0x74, 0x65, 0x78, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0b, 0x63, 0x61, 0x6c, 0x6c, 0x6f, 0x75,
	0x74, 0x54, 0x65, 0x78, 0x74, 0x88, 0x01, 0x01, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x63, 0x61, 0x6c,
	0x6c, 0x6f, 0x75, 0x74, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x22, 0xc2, 0x03, 0x0a, 0x10, 0x4c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x65, 0x65, 0x64, 0x49, 0x74, 0x65, 0x6d, 0x12, 0x28,
	0x0a, 0x0d, 0x62, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0c, 0x62, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73,
	0x73, 0x4e, 0x61, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x29, 0x0a, 0x0e, 0x61, 0x64, 0x64, 0x72,
	0x65, 0x73, 0x73, 0x5f, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x31, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x01, 0x52, 0x0c, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x4c, 0x69, 0x6e, 0x65, 0x31,
	0x88, 0x01, 0x01, 0x12, 0x29, 0x0a, 0x0e, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x6c,
	0x69, 0x6e, 0x65, 0x5f, 0x32, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x48, 0x02, 0x52, 0x0c, 0x61,
	0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x4c, 0x69, 0x6e, 0x65, 0x32, 0x88, 0x01, 0x01, 0x12, 0x17,
	0x0a, 0x04, 0x63, 0x69, 0x74, 0x79, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x48, 0x03, 0x52, 0x04,
	0x63, 0x69, 0x74, 0x79, 0x88, 0x01, 0x01, 0x12, 0x1f, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x76, 0x69,
	0x6e, 0x63, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x48, 0x04, 0x52, 0x08, 0x70, 0x72, 0x6f,
	0x76, 0x69, 0x6e, 0x63, 0x65, 0x88, 0x01, 0x01, 0x12, 0x24, 0x0a, 0x0b, 0x70, 0x6f, 0x73, 0x74,
	0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x48, 0x05, 0x52,
	0x0a, 0x70, 0x6f, 0x73, 0x74, 0x61, 0x6c, 0x43, 0x6f, 0x64, 0x65, 0x88, 0x01, 0x01, 0x12, 0x26,
	0x0a, 0x0c, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x0f,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x06, 0x52, 0x0b, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x43,
	0x6f, 0x64, 0x65, 0x88, 0x01, 0x01, 0x12, 0x26, 0x0a, 0x0c, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x5f,
	0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x48, 0x07, 0x52, 0x0b,
	0x70, 0x68, 0x6f, 0x6e, 0x65, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x88, 0x01, 0x01, 0x42, 0x10,
	0x0a, 0x0e, 0x5f, 0x62, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x6c, 0x69, 0x6e,
	0x65, 0x5f, 0x31, 0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x5f,
	0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x32, 0x42, 0x07, 0x0a, 0x05, 0x5f, 0x63, 0x69, 0x74, 0x79, 0x42,
	0x0b, 0x0a, 0x09, 0x5f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x6e, 0x63, 0x65, 0x42, 0x0e, 0x0a, 0x0c,
	0x5f, 0x70, 0x6f, 0x73, 0x74, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x42, 0x0f, 0x0a, 0x0d,
	0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x42, 0x0f, 0x0a,
	0x0d, 0x5f, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x22, 0xab,
	0x04, 0x0a, 0x19, 0x41, 0x66, 0x66, 0x69, 0x6c, 0x69, 0x61, 0x74, 0x65, 0x4c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x46, 0x65, 0x65, 0x64, 0x49, 0x74, 0x65, 0x6d, 0x12, 0x28, 0x0a, 0x0d,
	0x62, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0b, 0x20,
	0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0c, 0x62, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x4e,
	0x61, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x29, 0x0a, 0x0e, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x5f, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x31, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01,
	0x52, 0x0c, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x4c, 0x69, 0x6e, 0x65, 0x31, 0x88, 0x01,
	0x01, 0x12, 0x29, 0x0a, 0x0e, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x6c, 0x69, 0x6e,
	0x65, 0x5f, 0x32, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x09, 0x48, 0x02, 0x52, 0x0c, 0x61, 0x64, 0x64,
	0x72, 0x65, 0x73, 0x73, 0x4c, 0x69, 0x6e, 0x65, 0x32, 0x88, 0x01, 0x01, 0x12, 0x17, 0x0a, 0x04,
	0x63, 0x69, 0x74, 0x79, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x48, 0x03, 0x52, 0x04, 0x63, 0x69,
	0x74, 0x79, 0x88, 0x01, 0x01, 0x12, 0x1f, 0x0a, 0x08, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x6e, 0x63,
	0x65, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x48, 0x04, 0x52, 0x08, 0x70, 0x72, 0x6f, 0x76, 0x69,
	0x6e, 0x63, 0x65, 0x88, 0x01, 0x01, 0x12, 0x24, 0x0a, 0x0b, 0x70, 0x6f, 0x73, 0x74, 0x61, 0x6c,
	0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x10, 0x20, 0x01, 0x28, 0x09, 0x48, 0x05, 0x52, 0x0a, 0x70,
	0x6f, 0x73, 0x74, 0x61, 0x6c, 0x43, 0x6f, 0x64, 0x65, 0x88, 0x01, 0x01, 0x12, 0x26, 0x0a, 0x0c,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x11, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x06, 0x52, 0x0b, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x43, 0x6f, 0x64,
	0x65, 0x88, 0x01, 0x01, 0x12, 0x26, 0x0a, 0x0c, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x5f, 0x6e, 0x75,
	0x6d, 0x62, 0x65, 0x72, 0x18, 0x12, 0x20, 0x01, 0x28, 0x09, 0x48, 0x07, 0x52, 0x0b, 0x70, 0x68,
	0x6f, 0x6e, 0x65, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x88, 0x01, 0x01, 0x12, 0x1e, 0x0a, 0x08,
	0x63, 0x68, 0x61, 0x69, 0x6e, 0x5f, 0x69, 0x64, 0x18, 0x13, 0x20, 0x01, 0x28, 0x03, 0x48, 0x08,
	0x52, 0x07, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x49, 0x64, 0x88, 0x01, 0x01, 0x12, 0x22, 0x0a, 0x0a,
	0x63, 0x68, 0x61, 0x69, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x14, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x09, 0x52, 0x09, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x88, 0x01, 0x01,
	0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x62, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x5f, 0x6e, 0x61,
	0x6d, 0x65, 0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x5f, 0x6c,
	0x69, 0x6e, 0x65, 0x5f, 0x31, 0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73,
	0x73, 0x5f, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x32, 0x42, 0x07, 0x0a, 0x05, 0x5f, 0x63, 0x69, 0x74,
	0x79, 0x42, 0x0b, 0x0a, 0x09, 0x5f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x6e, 0x63, 0x65, 0x42, 0x0e,
	0x0a, 0x0c, 0x5f, 0x70, 0x6f, 0x73, 0x74, 0x61, 0x6c, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x42, 0x0f,
	0x0a, 0x0d, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x42,
	0x0f, 0x0a, 0x0d, 0x5f, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72,
	0x42, 0x0b, 0x0a, 0x09, 0x5f, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x5f, 0x69, 0x64, 0x42, 0x0d, 0x0a,
	0x0b, 0x5f, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xa4, 0x02, 0x0a,
	0x13, 0x54, 0x65, 0x78, 0x74, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x46, 0x65, 0x65, 0x64,
	0x49, 0x74, 0x65, 0x6d, 0x12, 0x28, 0x0a, 0x0d, 0x62, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x0c, 0x62,
	0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x4e, 0x61, 0x6d, 0x65, 0x88, 0x01, 0x01, 0x12, 0x26,
	0x0a, 0x0c, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x0b, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x43,
	0x6f, 0x64, 0x65, 0x88, 0x01, 0x01, 0x12, 0x26, 0x0a, 0x0c, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x5f,
	0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x48, 0x02, 0x52, 0x0b,
	0x70, 0x68, 0x6f, 0x6e, 0x65, 0x4e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x88, 0x01, 0x01, 0x12, 0x17,
	0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x48, 0x03, 0x52, 0x04,
	0x74, 0x65, 0x78, 0x74, 0x88, 0x01, 0x01, 0x12, 0x2a, 0x0a, 0x0e, 0x65, 0x78, 0x74, 0x65, 0x6e,
	0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x04, 0x52, 0x0d, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x65, 0x78, 0x74,
	0x88, 0x01, 0x01, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x62, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72,
	0x79, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x42, 0x0f, 0x0a, 0x0d, 0x5f, 0x70, 0x68, 0x6f, 0x6e, 0x65,
	0x5f, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x42, 0x07, 0x0a, 0x05, 0x5f, 0x74, 0x65, 0x78, 0x74,
	0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x5f, 0x74,
	0x65, 0x78, 0x74, 0x22, 0x9d, 0x04, 0x0a, 0x0d, 0x50, 0x72, 0x69, 0x63, 0x65, 0x46, 0x65, 0x65,
	0x64, 0x49, 0x74, 0x65, 0x6d, 0x12, 0x5c, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x48, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x65, 0x6e,
	0x75, 0x6d, 0x73, 0x2e, 0x50, 0x72, 0x69, 0x63, 0x65, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69,
	0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x50, 0x72, 0x69, 0x63, 0x65,
	0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74,
	0x79, 0x70, 0x65, 0x12, 0x85, 0x01, 0x0a, 0x0f, 0x70, 0x72, 0x69, 0x63, 0x65, 0x5f, 0x71, 0x75,
	0x61, 0x6c, 0x69, 0x66, 0x69, 0x65, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x5c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x50, 0x72,
	0x69, 0x63, 0x65, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x69, 0x63,
	0x65, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x66, 0x69, 0x65, 0x72, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x50,
	0x72, 0x69, 0x63, 0x65, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x69,
	0x63, 0x65, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x66, 0x69, 0x65, 0x72, 0x52, 0x0e, 0x70, 0x72, 0x69,
	0x63, 0x65, 0x51, 0x75, 0x61, 0x6c, 0x69, 0x66, 0x69, 0x65, 0x72, 0x12, 0x37, 0x0a, 0x15, 0x74,
	0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x75, 0x72, 0x6c, 0x5f, 0x74, 0x65, 0x6d, 0x70,
	0x6c, 0x61, 0x74, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x13, 0x74, 0x72,
	0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x55, 0x72, 0x6c, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x88, 0x01, 0x01, 0x12, 0x28, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
	0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x0c, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x88, 0x01, 0x01, 0x12, 0x53,
	0x0a, 0x0f, 0x70, 0x72, 0x69, 0x63, 0x65, 0x5f, 0x6f, 0x66, 0x66, 0x65, 0x72, 0x69, 0x6e, 0x67,
	0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76,
	0x36, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x50, 0x72, 0x69, 0x63, 0x65, 0x4f, 0x66,
	0x66, 0x65, 0x72, 0x52, 0x0e, 0x70, 0x72, 0x69, 0x63, 0x65, 0x4f, 0x66, 0x66, 0x65, 0x72, 0x69,
	0x6e, 0x67, 0x73, 0x12, 0x2d, 0x0a, 0x10, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x75, 0x72, 0x6c,
	0x5f, 0x73, 0x75, 0x66, 0x66, 0x69, 0x78, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x48, 0x02, 0x52,
	0x0e, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x55, 0x72, 0x6c, 0x53, 0x75, 0x66, 0x66, 0x69, 0x78, 0x88,
	0x01, 0x01, 0x42, 0x18, 0x0a, 0x16, 0x5f, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x5f,
	0x75, 0x72, 0x6c, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x42, 0x10, 0x0a, 0x0e,
	0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x42, 0x13,
	0x0a, 0x11, 0x5f, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x75, 0x72, 0x6c, 0x5f, 0x73, 0x75, 0x66,
	0x66, 0x69, 0x78, 0x22, 0xdb, 0x02, 0x0a, 0x0a, 0x50, 0x72, 0x69, 0x63, 0x65, 0x4f, 0x66, 0x66,
	0x65, 0x72, 0x12, 0x1b, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x00, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x88, 0x01, 0x01, 0x12,
	0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
	0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12, 0x3b, 0x0a, 0x05, 0x70, 0x72, 0x69, 0x63, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61,
	0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x4d, 0x6f, 0x6e, 0x65, 0x79, 0x52, 0x05, 0x70, 0x72,
	0x69, 0x63, 0x65, 0x12, 0x66, 0x0a, 0x04, 0x75, 0x6e, 0x69, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x52, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x65, 0x6e, 0x75, 0x6d,
	0x73, 0x2e, 0x50, 0x72, 0x69, 0x63, 0x65, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
	0x50, 0x72, 0x69, 0x63, 0x65, 0x55, 0x6e, 0x69, 0x74, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x50, 0x72,
	0x69, 0x63, 0x65, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x69, 0x63,
	0x65, 0x55, 0x6e, 0x69, 0x74, 0x52, 0x04, 0x75, 0x6e, 0x69, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x66,
	0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x75, 0x72, 0x6c, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x09, 0x52,
	0x09, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x55, 0x72, 0x6c, 0x73, 0x12, 0x2a, 0x0a, 0x11, 0x66, 0x69,
	0x6e, 0x61, 0x6c, 0x5f, 0x6d, 0x6f, 0x62, 0x69, 0x6c, 0x65, 0x5f, 0x75, 0x72, 0x6c, 0x73, 0x18,
	0x0a, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x4d, 0x6f, 0x62, 0x69,
	0x6c, 0x65, 0x55, 0x72, 0x6c, 0x73, 0x42, 0x09, 0x0a, 0x07, 0x5f, 0x68, 0x65, 0x61, 0x64, 0x65,
	0x72, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x9f, 0x09, 0x0a, 0x11, 0x50, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x46,
	0x65, 0x65, 0x64, 0x49, 0x74, 0x65, 0x6d, 0x12, 0x2e, 0x0a, 0x10, 0x70, 0x72, 0x6f, 0x6d, 0x6f,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x18, 0x10, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x02, 0x52, 0x0f, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x88, 0x01, 0x01, 0x12, 0x95, 0x01, 0x0a, 0x11, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x72, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x68, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x65, 0x6e,
	0x75, 0x6d, 0x73, 0x2e, 0x50, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x78, 0x74,
	0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4d, 0x6f,
	0x64, 0x69, 0x66, 0x69, 0x65, 0x72, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x50, 0x72, 0x6f, 0x6d, 0x6f,
	0x74, 0x69, 0x6f, 0x6e, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x44, 0x69, 0x73,
	0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x72, 0x52, 0x10, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x72, 0x12,
	0x35, 0x0a, 0x14, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x13, 0x20, 0x01, 0x28, 0x09, 0x48, 0x03, 0x52,
	0x12, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x61, 0x72, 0x74, 0x44,
	0x61, 0x74, 0x65, 0x88, 0x01, 0x01, 0x12, 0x31, 0x0a, 0x12, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74,
	0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x14, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x04, 0x52, 0x10, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x45,
	0x6e, 0x64, 0x44, 0x61, 0x74, 0x65, 0x88, 0x01, 0x01, 0x12, 0x74, 0x0a, 0x08, 0x6f, 0x63, 0x63,
	0x61, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x58, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x65, 0x6e, 0x75, 0x6d, 0x73, 0x2e, 0x50, 0x72, 0x6f, 0x6d,
	0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4f, 0x63,
	0x63, 0x61, 0x73, 0x69, 0x6f, 0x6e, 0x45, 0x6e, 0x75, 0x6d, 0x2e, 0x50, 0x72, 0x6f, 0x6d, 0x6f,
	0x74, 0x69, 0x6f, 0x6e, 0x45, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x4f, 0x63, 0x63,
	0x61, 0x73, 0x69, 0x6f, 0x6e, 0x52, 0x08, 0x6f, 0x63, 0x63, 0x61, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x1d, 0x0a, 0x0a, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x75, 0x72, 0x6c, 0x73, 0x18, 0x15, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x09, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x55, 0x72, 0x6c, 0x73, 0x12, 0x2a,
	0x0a, 0x11, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x6d, 0x6f, 0x62, 0x69, 0x6c, 0x65, 0x5f, 0x75,
	0x72, 0x6c, 0x73, 0x18, 0x16, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x66, 0x69, 0x6e, 0x61, 0x6c,
	0x4d, 0x6f, 0x62, 0x69, 0x6c, 0x65, 0x55, 0x72, 0x6c, 0x73, 0x12, 0x37, 0x0a, 0x15, 0x74, 0x72,
	0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x75, 0x72, 0x6c, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c,
	0x61, 0x74, 0x65, 0x18, 0x17, 0x20, 0x01, 0x28, 0x09, 0x48, 0x05, 0x52, 0x13, 0x74, 0x72, 0x61,
	0x63, 0x6b, 0x69, 0x6e, 0x67, 0x55, 0x72, 0x6c, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65,
	0x88, 0x01, 0x01, 0x12, 0x63, 0x0a, 0x15, 0x75, 0x72, 0x6c, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f,
	0x6d, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x0d, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x63, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65,
	0x74, 0x65, 0x72, 0x52, 0x13, 0x75, 0x72, 0x6c, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x50, 0x61,
	0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x2d, 0x0a, 0x10, 0x66, 0x69, 0x6e, 0x61,
	0x6c, 0x5f, 0x75, 0x72, 0x6c, 0x5f, 0x73, 0x75, 0x66, 0x66, 0x69, 0x78, 0x18, 0x18, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x06, 0x52, 0x0e, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x55, 0x72, 0x6c, 0x53, 0x75,
	0x66, 0x66, 0x69, 0x78, 0x88, 0x01, 0x01, 0x12, 0x28, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x19, 0x20, 0x01, 0x28, 0x09, 0x48, 0x07,
	0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x88, 0x01,
	0x01, 0x12, 0x21, 0x0a, 0x0b, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x5f, 0x6f, 0x66, 0x66,
	0x18, 0x11, 0x20, 0x01, 0x28, 0x03, 0x48, 0x00, 0x52, 0x0a, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e,
	0x74, 0x4f, 0x66, 0x66, 0x12, 0x51, 0x0a, 0x10, 0x6d, 0x6f, 0x6e, 0x65, 0x79, 0x5f, 0x61, 0x6d,
	0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x6f, 0x66, 0x66, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e,
	0x4d, 0x6f, 0x6e, 0x65, 0x79, 0x48, 0x00, 0x52, 0x0e, 0x6d, 0x6f, 0x6e, 0x65, 0x79, 0x41, 0x6d,
	0x6f, 0x75, 0x6e, 0x74, 0x4f, 0x66, 0x66, 0x12, 0x27, 0x0a, 0x0e, 0x70, 0x72, 0x6f, 0x6d, 0x6f,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x12, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x01, 0x52, 0x0d, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x64, 0x65,
	0x12, 0x55, 0x0a, 0x12, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x73, 0x5f, 0x6f, 0x76, 0x65, 0x72, 0x5f,
	0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x4d, 0x6f,
	0x6e, 0x65, 0x79, 0x48, 0x01, 0x52, 0x10, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x73, 0x4f, 0x76, 0x65,
	0x72, 0x41, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x0f, 0x0a, 0x0d, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x42, 0x13, 0x0a, 0x11, 0x70, 0x72, 0x6f, 0x6d,
	0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x42, 0x13, 0x0a,
	0x11, 0x5f, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x42, 0x17, 0x0a, 0x15, 0x5f, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x42, 0x15, 0x0a, 0x13, 0x5f,
	0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x65, 0x6e, 0x64, 0x5f, 0x64, 0x61,
	0x74, 0x65, 0x42, 0x18, 0x0a, 0x16, 0x5f, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x5f,
	0x75, 0x72, 0x6c, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x42, 0x13, 0x0a, 0x11,
	0x5f, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x75, 0x72, 0x6c, 0x5f, 0x73, 0x75, 0x66, 0x66, 0x69,
	0x78, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63,
	0x6f, 0x64, 0x65, 0x22, 0x5b, 0x0a, 0x19, 0x53, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65,
	0x64, 0x53, 0x6e, 0x69, 0x70, 0x70, 0x65, 0x74, 0x46, 0x65, 0x65, 0x64, 0x49, 0x74, 0x65, 0x6d,
	0x12, 0x1b, 0x0a, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x00, 0x52, 0x06, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x88, 0x01, 0x01, 0x12, 0x16, 0x0a,
	0x06, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x73, 0x42, 0x09, 0x0a, 0x07, 0x5f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72,
	0x22, 0xd3, 0x03, 0x0a, 0x10, 0x53, 0x69, 0x74, 0x65, 0x6c, 0x69, 0x6e, 0x6b, 0x46, 0x65, 0x65,
	0x64, 0x49, 0x74, 0x65, 0x6d, 0x12, 0x20, 0x0a, 0x09, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x74, 0x65,
	0x78, 0x74, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x08, 0x6c, 0x69, 0x6e, 0x6b,
	0x54, 0x65, 0x78, 0x74, 0x88, 0x01, 0x01, 0x12, 0x19, 0x0a, 0x05, 0x6c, 0x69, 0x6e, 0x65, 0x31,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x05, 0x6c, 0x69, 0x6e, 0x65, 0x31, 0x88,
	0x01, 0x01, 0x12, 0x19, 0x0a, 0x05, 0x6c, 0x69, 0x6e, 0x65, 0x32, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x09, 0x48, 0x02, 0x52, 0x05, 0x6c, 0x69, 0x6e, 0x65, 0x32, 0x88, 0x01, 0x01, 0x12, 0x1d, 0x0a,
	0x0a, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x75, 0x72, 0x6c, 0x73, 0x18, 0x0c, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x09, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x55, 0x72, 0x6c, 0x73, 0x12, 0x2a, 0x0a, 0x11,
	0x66, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x6d, 0x6f, 0x62, 0x69, 0x6c, 0x65, 0x5f, 0x75, 0x72, 0x6c,
	0x73, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0f, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x4d, 0x6f,
	0x62, 0x69, 0x6c, 0x65, 0x55, 0x72, 0x6c, 0x73, 0x12, 0x37, 0x0a, 0x15, 0x74, 0x72, 0x61, 0x63,
	0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x75, 0x72, 0x6c, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x18, 0x0e, 0x20, 0x01, 0x28, 0x09, 0x48, 0x03, 0x52, 0x13, 0x74, 0x72, 0x61, 0x63, 0x6b,
	0x69, 0x6e, 0x67, 0x55, 0x72, 0x6c, 0x54, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x88, 0x01,
	0x01, 0x12, 0x63, 0x0a, 0x15, 0x75, 0x72, 0x6c, 0x5f, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f,
	0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f,
	0x6e, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x50, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
	0x72, 0x52, 0x13, 0x75, 0x72, 0x6c, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x50, 0x61, 0x72, 0x61,
	0x6d, 0x65, 0x74, 0x65, 0x72, 0x73, 0x12, 0x2d, 0x0a, 0x10, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x5f,
	0x75, 0x72, 0x6c, 0x5f, 0x73, 0x75, 0x66, 0x66, 0x69, 0x78, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09,
	0x48, 0x04, 0x52, 0x0e, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x55, 0x72, 0x6c, 0x53, 0x75, 0x66, 0x66,
	0x69, 0x78, 0x88, 0x01, 0x01, 0x42, 0x0c, 0x0a, 0x0a, 0x5f, 0x6c, 0x69, 0x6e, 0x6b, 0x5f, 0x74,
	0x65, 0x78, 0x74, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x6c, 0x69, 0x6e, 0x65, 0x31, 0x42, 0x08, 0x0a,
	0x06, 0x5f, 0x6c, 0x69, 0x6e, 0x65, 0x32, 0x42, 0x18, 0x0a, 0x16, 0x5f, 0x74, 0x72, 0x61, 0x63,
	0x6b, 0x69, 0x6e, 0x67, 0x5f, 0x75, 0x72, 0x6c, 0x5f, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74,
	0x65, 0x42, 0x13, 0x0a, 0x11, 0x5f, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x75, 0x72, 0x6c, 0x5f,
	0x73, 0x75, 0x66, 0x66, 0x69, 0x78, 0x22, 0x74, 0x0a, 0x14, 0x48, 0x6f, 0x74, 0x65, 0x6c, 0x43,
	0x61, 0x6c, 0x6c, 0x6f, 0x75, 0x74, 0x46, 0x65, 0x65, 0x64, 0x49, 0x74, 0x65, 0x6d, 0x12, 0x17,
	0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x04,
	0x74, 0x65, 0x78, 0x74, 0x88, 0x01, 0x01, 0x12, 0x28, 0x0a, 0x0d, 0x6c, 0x61, 0x6e, 0x67, 0x75,
	0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01,
	0x52, 0x0c, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f, 0x64, 0x65, 0x88, 0x01,
	0x01, 0x42, 0x07, 0x0a, 0x05, 0x5f, 0x74, 0x65, 0x78, 0x74, 0x42, 0x10, 0x0a, 0x0e, 0x5f, 0x6c,
	0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x22, 0x58, 0x0a, 0x0d,
	0x49, 0x6d, 0x61, 0x67, 0x65, 0x46, 0x65, 0x65, 0x64, 0x49, 0x74, 0x65, 0x6d, 0x12, 0x47, 0x0a,
	0x0b, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x5f, 0x61, 0x73, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a, 0x1e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x73, 0x73, 0x65, 0x74, 0x52, 0x0a, 0x69, 0x6d, 0x61, 0x67,
	0x65, 0x41, 0x73, 0x73, 0x65, 0x74, 0x42, 0xea, 0x01, 0x0a, 0x22, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x61, 0x64, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x64, 0x73, 0x2e, 0x76, 0x36, 0x2e, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x42, 0x0f, 0x45,
	0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x44, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e,
	0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x61, 0x64, 0x73, 0x2f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x61, 0x64, 0x73, 0x2f, 0x76, 0x36, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x3b,
	0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0xa2, 0x02, 0x03, 0x47, 0x41, 0x41, 0xaa, 0x02, 0x1e, 0x47,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x41, 0x64, 0x73, 0x2e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x41, 0x64, 0x73, 0x2e, 0x56, 0x36, 0x2e, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0xca, 0x02, 0x1e,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x41, 0x64, 0x73, 0x5c, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x41, 0x64, 0x73, 0x5c, 0x56, 0x36, 0x5c, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0xea, 0x02,
	0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x41, 0x64, 0x73, 0x3a, 0x3a, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x41, 0x64, 0x73, 0x3a, 0x3a, 0x56, 0x36, 0x3a, 0x3a, 0x43, 0x6f, 0x6d,
	0x6d, 0x6f, 0x6e, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_ads_googleads_v6_common_extensions_proto_rawDescOnce sync.Once
	file_google_ads_googleads_v6_common_extensions_proto_rawDescData = file_google_ads_googleads_v6_common_extensions_proto_rawDesc
)

func file_google_ads_googleads_v6_common_extensions_proto_rawDescGZIP() []byte {
	file_google_ads_googleads_v6_common_extensions_proto_rawDescOnce.Do(func() {
		file_google_ads_googleads_v6_common_extensions_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_ads_googleads_v6_common_extensions_proto_rawDescData)
	})
	return file_google_ads_googleads_v6_common_extensions_proto_rawDescData
}

var file_google_ads_googleads_v6_common_extensions_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_google_ads_googleads_v6_common_extensions_proto_goTypes = []interface{}{
	(*AppFeedItem)(nil),               // 0: google.ads.googleads.v6.common.AppFeedItem
	(*CallFeedItem)(nil),              // 1: google.ads.googleads.v6.common.CallFeedItem
	(*CalloutFeedItem)(nil),           // 2: google.ads.googleads.v6.common.CalloutFeedItem
	(*LocationFeedItem)(nil),          // 3: google.ads.googleads.v6.common.LocationFeedItem
	(*AffiliateLocationFeedItem)(nil), // 4: google.ads.googleads.v6.common.AffiliateLocationFeedItem
	(*TextMessageFeedItem)(nil),       // 5: google.ads.googleads.v6.common.TextMessageFeedItem
	(*PriceFeedItem)(nil),             // 6: google.ads.googleads.v6.common.PriceFeedItem
	(*PriceOffer)(nil),                // 7: google.ads.googleads.v6.common.PriceOffer
	(*PromotionFeedItem)(nil),         // 8: google.ads.googleads.v6.common.PromotionFeedItem
	(*StructuredSnippetFeedItem)(nil), // 9: google.ads.googleads.v6.common.StructuredSnippetFeedItem
	(*SitelinkFeedItem)(nil),          // 10: google.ads.googleads.v6.common.SitelinkFeedItem
	(*HotelCalloutFeedItem)(nil),      // 11: google.ads.googleads.v6.common.HotelCalloutFeedItem
	(*ImageFeedItem)(nil),             // 12: google.ads.googleads.v6.common.ImageFeedItem
	(enums.AppStoreEnum_AppStore)(0),  // 13: google.ads.googleads.v6.enums.AppStoreEnum.AppStore
	(*CustomParameter)(nil),           // 14: google.ads.googleads.v6.common.CustomParameter
	(enums.CallConversionReportingStateEnum_CallConversionReportingState)(0), // 15: google.ads.googleads.v6.enums.CallConversionReportingStateEnum.CallConversionReportingState
	(enums.PriceExtensionTypeEnum_PriceExtensionType)(0),                     // 16: google.ads.googleads.v6.enums.PriceExtensionTypeEnum.PriceExtensionType
	(enums.PriceExtensionPriceQualifierEnum_PriceExtensionPriceQualifier)(0), // 17: google.ads.googleads.v6.enums.PriceExtensionPriceQualifierEnum.PriceExtensionPriceQualifier
	(*Money)(nil), // 18: google.ads.googleads.v6.common.Money
	(enums.PriceExtensionPriceUnitEnum_PriceExtensionPriceUnit)(0),                       // 19: google.ads.googleads.v6.enums.PriceExtensionPriceUnitEnum.PriceExtensionPriceUnit
	(enums.PromotionExtensionDiscountModifierEnum_PromotionExtensionDiscountModifier)(0), // 20: google.ads.googleads.v6.enums.PromotionExtensionDiscountModifierEnum.PromotionExtensionDiscountModifier
	(enums.PromotionExtensionOccasionEnum_PromotionExtensionOccasion)(0),                 // 21: google.ads.googleads.v6.enums.PromotionExtensionOccasionEnum.PromotionExtensionOccasion
}
var file_google_ads_googleads_v6_common_extensions_proto_depIdxs = []int32{
	13, // 0: google.ads.googleads.v6.common.AppFeedItem.app_store:type_name -> google.ads.googleads.v6.enums.AppStoreEnum.AppStore
	14, // 1: google.ads.googleads.v6.common.AppFeedItem.url_custom_parameters:type_name -> google.ads.googleads.v6.common.CustomParameter
	15, // 2: google.ads.googleads.v6.common.CallFeedItem.call_conversion_reporting_state:type_name -> google.ads.googleads.v6.enums.CallConversionReportingStateEnum.CallConversionReportingState
	16, // 3: google.ads.googleads.v6.common.PriceFeedItem.type:type_name -> google.ads.googleads.v6.enums.PriceExtensionTypeEnum.PriceExtensionType
	17, // 4: google.ads.googleads.v6.common.PriceFeedItem.price_qualifier:type_name -> google.ads.googleads.v6.enums.PriceExtensionPriceQualifierEnum.PriceExtensionPriceQualifier
	7,  // 5: google.ads.googleads.v6.common.PriceFeedItem.price_offerings:type_name -> google.ads.googleads.v6.common.PriceOffer
	18, // 6: google.ads.googleads.v6.common.PriceOffer.price:type_name -> google.ads.googleads.v6.common.Money
	19, // 7: google.ads.googleads.v6.common.PriceOffer.unit:type_name -> google.ads.googleads.v6.enums.PriceExtensionPriceUnitEnum.PriceExtensionPriceUnit
	20, // 8: google.ads.googleads.v6.common.PromotionFeedItem.discount_modifier:type_name -> google.ads.googleads.v6.enums.PromotionExtensionDiscountModifierEnum.PromotionExtensionDiscountModifier
	21, // 9: google.ads.googleads.v6.common.PromotionFeedItem.occasion:type_name -> google.ads.googleads.v6.enums.PromotionExtensionOccasionEnum.PromotionExtensionOccasion
	14, // 10: google.ads.googleads.v6.common.PromotionFeedItem.url_custom_parameters:type_name -> google.ads.googleads.v6.common.CustomParameter
	18, // 11: google.ads.googleads.v6.common.PromotionFeedItem.money_amount_off:type_name -> google.ads.googleads.v6.common.Money
	18, // 12: google.ads.googleads.v6.common.PromotionFeedItem.orders_over_amount:type_name -> google.ads.googleads.v6.common.Money
	14, // 13: google.ads.googleads.v6.common.SitelinkFeedItem.url_custom_parameters:type_name -> google.ads.googleads.v6.common.CustomParameter
	14, // [14:14] is the sub-list for method output_type
	14, // [14:14] is the sub-list for method input_type
	14, // [14:14] is the sub-list for extension type_name
	14, // [14:14] is the sub-list for extension extendee
	0,  // [0:14] is the sub-list for field type_name
}

func init() { file_google_ads_googleads_v6_common_extensions_proto_init() }
func file_google_ads_googleads_v6_common_extensions_proto_init() {
	if File_google_ads_googleads_v6_common_extensions_proto != nil {
		return
	}
	file_google_ads_googleads_v6_common_custom_parameter_proto_init()
	file_google_ads_googleads_v6_common_feed_common_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_ads_googleads_v6_common_extensions_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AppFeedItem); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v6_common_extensions_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CallFeedItem); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v6_common_extensions_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CalloutFeedItem); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v6_common_extensions_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*LocationFeedItem); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v6_common_extensions_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*AffiliateLocationFeedItem); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v6_common_extensions_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TextMessageFeedItem); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v6_common_extensions_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PriceFeedItem); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v6_common_extensions_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PriceOffer); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v6_common_extensions_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PromotionFeedItem); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v6_common_extensions_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StructuredSnippetFeedItem); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v6_common_extensions_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SitelinkFeedItem); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v6_common_extensions_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*HotelCalloutFeedItem); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_ads_googleads_v6_common_extensions_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImageFeedItem); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_ads_googleads_v6_common_extensions_proto_msgTypes[0].OneofWrappers = []interface{}{}
	file_google_ads_googleads_v6_common_extensions_proto_msgTypes[1].OneofWrappers = []interface{}{}
	file_google_ads_googleads_v6_common_extensions_proto_msgTypes[2].OneofWrappers = []interface{}{}
	file_google_ads_googleads_v6_common_extensions_proto_msgTypes[3].OneofWrappers = []interface{}{}
	file_google_ads_googleads_v6_common_extensions_proto_msgTypes[4].OneofWrappers = []interface{}{}
	file_google_ads_googleads_v6_common_extensions_proto_msgTypes[5].OneofWrappers = []interface{}{}
	file_google_ads_googleads_v6_common_extensions_proto_msgTypes[6].OneofWrappers = []interface{}{}
	file_google_ads_googleads_v6_common_extensions_proto_msgTypes[7].OneofWrappers = []interface{}{}
	file_google_ads_googleads_v6_common_extensions_proto_msgTypes[8].OneofWrappers = []interface{}{
		(*PromotionFeedItem_PercentOff)(nil),
		(*PromotionFeedItem_MoneyAmountOff)(nil),
		(*PromotionFeedItem_PromotionCode)(nil),
		(*PromotionFeedItem_OrdersOverAmount)(nil),
	}
	file_google_ads_googleads_v6_common_extensions_proto_msgTypes[9].OneofWrappers = []interface{}{}
	file_google_ads_googleads_v6_common_extensions_proto_msgTypes[10].OneofWrappers = []interface{}{}
	file_google_ads_googleads_v6_common_extensions_proto_msgTypes[11].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_ads_googleads_v6_common_extensions_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_ads_googleads_v6_common_extensions_proto_goTypes,
		DependencyIndexes: file_google_ads_googleads_v6_common_extensions_proto_depIdxs,
		MessageInfos:      file_google_ads_googleads_v6_common_extensions_proto_msgTypes,
	}.Build()
	File_google_ads_googleads_v6_common_extensions_proto = out.File
	file_google_ads_googleads_v6_common_extensions_proto_rawDesc = nil
	file_google_ads_googleads_v6_common_extensions_proto_goTypes = nil
	file_google_ads_googleads_v6_common_extensions_proto_depIdxs = nil
}
