// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iot

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Input for the DeleteCACertificate operation.
type DeleteCACertificateInput struct {
	_ struct{} `type:"structure"`

	// The ID of the certificate to delete. (The last part of the certificate ARN
	// contains the certificate ID.)
	//
	// CertificateId is a required field
	CertificateId *string `location:"uri" locationName:"caCertificateId" min:"64" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteCACertificateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteCACertificateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteCACertificateInput"}

	if s.CertificateId == nil {
		invalidParams.Add(aws.NewErrParamRequired("CertificateId"))
	}
	if s.CertificateId != nil && len(*s.CertificateId) < 64 {
		invalidParams.Add(aws.NewErrParamMinLen("CertificateId", 64))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteCACertificateInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.CertificateId != nil {
		v := *s.CertificateId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "caCertificateId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The output for the DeleteCACertificate operation.
type DeleteCACertificateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteCACertificateOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteCACertificateOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteCACertificate = "DeleteCACertificate"

// DeleteCACertificateRequest returns a request value for making API operation for
// AWS IoT.
//
// Deletes a registered CA certificate.
//
//    // Example sending a request using DeleteCACertificateRequest.
//    req := client.DeleteCACertificateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) DeleteCACertificateRequest(input *DeleteCACertificateInput) DeleteCACertificateRequest {
	op := &aws.Operation{
		Name:       opDeleteCACertificate,
		HTTPMethod: "DELETE",
		HTTPPath:   "/cacertificate/{caCertificateId}",
	}

	if input == nil {
		input = &DeleteCACertificateInput{}
	}

	req := c.newRequest(op, input, &DeleteCACertificateOutput{})
	return DeleteCACertificateRequest{Request: req, Input: input, Copy: c.DeleteCACertificateRequest}
}

// DeleteCACertificateRequest is the request type for the
// DeleteCACertificate API operation.
type DeleteCACertificateRequest struct {
	*aws.Request
	Input *DeleteCACertificateInput
	Copy  func(*DeleteCACertificateInput) DeleteCACertificateRequest
}

// Send marshals and sends the DeleteCACertificate API request.
func (r DeleteCACertificateRequest) Send(ctx context.Context) (*DeleteCACertificateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteCACertificateResponse{
		DeleteCACertificateOutput: r.Request.Data.(*DeleteCACertificateOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteCACertificateResponse is the response type for the
// DeleteCACertificate API operation.
type DeleteCACertificateResponse struct {
	*DeleteCACertificateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteCACertificate request.
func (r *DeleteCACertificateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
