// Generated by tmpl
// https://github.com/benbjohnson/tmpl
//
// DO NOT EDIT!
// Source: compare.gen.go.tmpl

package arrowutil

import (
	"fmt"

	"github.com/apache/arrow/go/arrow/array"
)

// CompareFunc defines the interface for a comparison function.
// The comparison function should return 0 for equivalent values,
// -1 if x[i] is before y[j], and +1 if x[i] is after y[j].
type CompareFunc func(x, y array.Interface, i, j int) int

// Compare will compare two values in the various arrays.
// The result will be 0 if x[i] == y[j], -1 if x[i] < y[j], and +1 if x[i] > y[j].
// A null value is always less than every non-null value.
func Compare(x, y array.Interface, i, j int) int {
	switch x := x.(type) {

	case *array.Int64:
		return Int64Compare(x, y.(*array.Int64), i, j)

	case *array.Uint64:
		return Uint64Compare(x, y.(*array.Uint64), i, j)

	case *array.Float64:
		return Float64Compare(x, y.(*array.Float64), i, j)

	case *array.Boolean:
		return BooleanCompare(x, y.(*array.Boolean), i, j)

	case *array.Binary:
		return StringCompare(x, y.(*array.Binary), i, j)

	default:
		panic(fmt.Errorf("unsupported array data type: %s", x.DataType()))
	}
}

// CompareDesc will compare two values in the various arrays.
// The result will be 0 if x[i] == y[j], -1 if x[i] > y[j], and +1 if x[i] < y[j].
// A null value is always greater than every non-null value.
func CompareDesc(x, y array.Interface, i, j int) int {
	switch x := x.(type) {

	case *array.Int64:
		return Int64CompareDesc(x, y.(*array.Int64), i, j)

	case *array.Uint64:
		return Uint64CompareDesc(x, y.(*array.Uint64), i, j)

	case *array.Float64:
		return Float64CompareDesc(x, y.(*array.Float64), i, j)

	case *array.Boolean:
		return BooleanCompareDesc(x, y.(*array.Boolean), i, j)

	case *array.Binary:
		return StringCompareDesc(x, y.(*array.Binary), i, j)

	default:
		panic(fmt.Errorf("unsupported array data type: %s", x.DataType()))
	}
}

func Int64Compare(x, y *array.Int64, i, j int) int {
	if x.IsNull(i) {
		if y.IsNull(j) {
			return 0
		}
		return -1
	} else if y.IsNull(j) {
		return 1
	}

	if l, r := x.Value(i), y.Value(j); l < r {
		return -1
	} else if l == r {
		return 0
	}
	return 1

}

func Int64CompareDesc(x, y *array.Int64, i, j int) int {
	if x.IsNull(i) {
		if y.IsNull(j) {
			return 0
		}
		return 1
	} else if y.IsNull(j) {
		return -1
	}

	if l, r := x.Value(i), y.Value(j); l > r {
		return -1
	} else if l == r {
		return 0
	}
	return 1

}

func Uint64Compare(x, y *array.Uint64, i, j int) int {
	if x.IsNull(i) {
		if y.IsNull(j) {
			return 0
		}
		return -1
	} else if y.IsNull(j) {
		return 1
	}

	if l, r := x.Value(i), y.Value(j); l < r {
		return -1
	} else if l == r {
		return 0
	}
	return 1

}

func Uint64CompareDesc(x, y *array.Uint64, i, j int) int {
	if x.IsNull(i) {
		if y.IsNull(j) {
			return 0
		}
		return 1
	} else if y.IsNull(j) {
		return -1
	}

	if l, r := x.Value(i), y.Value(j); l > r {
		return -1
	} else if l == r {
		return 0
	}
	return 1

}

func Float64Compare(x, y *array.Float64, i, j int) int {
	if x.IsNull(i) {
		if y.IsNull(j) {
			return 0
		}
		return -1
	} else if y.IsNull(j) {
		return 1
	}

	if l, r := x.Value(i), y.Value(j); l < r {
		return -1
	} else if l == r {
		return 0
	}
	return 1

}

func Float64CompareDesc(x, y *array.Float64, i, j int) int {
	if x.IsNull(i) {
		if y.IsNull(j) {
			return 0
		}
		return 1
	} else if y.IsNull(j) {
		return -1
	}

	if l, r := x.Value(i), y.Value(j); l > r {
		return -1
	} else if l == r {
		return 0
	}
	return 1

}

func BooleanCompare(x, y *array.Boolean, i, j int) int {
	if x.IsNull(i) {
		if y.IsNull(j) {
			return 0
		}
		return -1
	} else if y.IsNull(j) {
		return 1
	}

	if x.Value(i) {
		if y.Value(j) {
			return 0
		}
		return 1
	} else if y.Value(j) {
		return -1
	}
	return 0

}

func BooleanCompareDesc(x, y *array.Boolean, i, j int) int {
	if x.IsNull(i) {
		if y.IsNull(j) {
			return 0
		}
		return 1
	} else if y.IsNull(j) {
		return -1
	}

	if x.Value(i) {
		if y.Value(j) {
			return 0
		}
		return 1
	} else if y.Value(j) {
		return -1
	}
	return 0

}

func StringCompare(x, y *array.Binary, i, j int) int {
	if x.IsNull(i) {
		if y.IsNull(j) {
			return 0
		}
		return -1
	} else if y.IsNull(j) {
		return 1
	}

	if l, r := x.ValueString(i), y.ValueString(j); l < r {
		return -1
	} else if l == r {
		return 0
	}
	return 1

}

func StringCompareDesc(x, y *array.Binary, i, j int) int {
	if x.IsNull(i) {
		if y.IsNull(j) {
			return 0
		}
		return 1
	} else if y.IsNull(j) {
		return -1
	}

	if l, r := x.ValueString(i), y.ValueString(j); l > r {
		return -1
	} else if l == r {
		return 0
	}
	return 1

}
