// DO NOT EDIT: This file is autogenerated via the builtin command.

package zenoss

import (
	ast "github.com/influxdata/flux/ast"
	runtime "github.com/influxdata/flux/runtime"
)

func init() {
	runtime.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 6,
					Line:   114,
				},
				File:   "zenoss.flux",
				Source: "package zenoss\n\n\nimport \"http\"\nimport \"json\"\n\n// event sends event to Zenoss.\n// `url` - string - events web service URL.\n// `username` - string - username for HTTP BASIC authentication. Default is empty string (no auth).\n// `password` - string - password for HTTP BASIC authentication. Default is empty string (no auth).\n// `action` - string - routername. Default is \"EventsRouter\".\n// `method` - string - router name. Default is \"add_event\".\n// `type` - string - event type. Default is \"rpc\".\n// `tid` - int - temporary transaction ID. Default is 1.\n// `summary` - string - event summary. Default is empty string.\n// `device` - string - related device. Default is empty string.\n// `component` - string - related component.\n// `severity` - string - severity of the event.\n// `eventClass` - string - event class. Default is empty string.\n// `eventClassKey` - string - event class key. Default is empty string.\n// `collector` - string - collector. Default is empty string.\n// `message` - string - event message. Default is empty string.\nevent = (\n        url,\n        username,\n        password,\n        action=\"EventsRouter\",\n        method=\"add_event\",\n        type=\"rpc\",\n        tid=1,\n        summary=\"\",\n        device=\"\",\n        component=\"\",\n        severity,\n        eventClass=\"\",\n        eventClassKey=\"\",\n        collector=\"\",\n        message=\"\",\n) => {\n    event = {\n        summary: summary,\n        device: device,\n        component: component,\n        severity: severity,\n        evclass: eventClass,\n        evclasskey: eventClassKey,\n        collector: collector,\n        message: message,\n    }\n    payload = {\n        action: action,\n        method: method,\n        data: [\n            event,\n        ],\n        type: type,\n        tid: tid,\n    }\n    headers = {\n        \"Authorization\": http.basicAuth(u: username, p: password),\n        \"Content-Type\": \"application/json\",\n    }\n    body = json.encode(v: payload)\n\n    return http.post(headers: headers, url: url, data: body)\n}\n\n// endpoint return method for sending events to Zenoss.\n// Parameters:\n// `url` - string - events web service URL.\n// `username` - string - username for HTTP BASIC authentication. Default is empty string (no auth).\n// `password` - string - password for HTTP BASIC authentication. Default is empty string (no auth).\n// `action` - string - routername. Default is \"EventsRouter\".\n// `method` - string - router name. Default is \"add_event\".\n// `type` - string - event type. Default is \"rpc\".\n// `tid` - int - temporary transaction ID. Default is 1.\n// The returned factory function accepts a `mapFn` parameter.\n// The `mapFn` must return record with `summary`, `device`, `component`, `severity`, `eventClass`, `eventClassKey`, `collector` and `message` fields as defined in the `event` function arguments.\nendpoint = (\n        url,\n        username,\n        password,\n        action=\"EventsRouter\",\n        method=\"add_event\",\n        type=\"rpc\",\n        tid=1,\n) => (mapFn) => (tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == event(\n                        url: url,\n                        username: username,\n                        password: password,\n                        action: action,\n                        method: method,\n                        type: type,\n                        tid: tid,\n                        summary: obj.summary,\n                        device: obj.device,\n                        component: obj.component,\n                        severity: obj.severity,\n                        eventClass: obj.eventClass,\n                        eventClassKey: obj.eventClassKey,\n                        collector: obj.collector,\n                        message: obj.message,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   66,
					},
					File:   "zenoss.flux",
					Source: "event = (\n        url,\n        username,\n        password,\n        action=\"EventsRouter\",\n        method=\"add_event\",\n        type=\"rpc\",\n        tid=1,\n        summary=\"\",\n        device=\"\",\n        component=\"\",\n        severity,\n        eventClass=\"\",\n        eventClassKey=\"\",\n        collector=\"\",\n        message=\"\",\n) => {\n    event = {\n        summary: summary,\n        device: device,\n        component: component,\n        severity: severity,\n        evclass: eventClass,\n        evclasskey: eventClassKey,\n        collector: collector,\n        message: message,\n    }\n    payload = {\n        action: action,\n        method: method,\n        data: [\n            event,\n        ],\n        type: type,\n        tid: tid,\n    }\n    headers = {\n        \"Authorization\": http.basicAuth(u: username, p: password),\n        \"Content-Type\": \"application/json\",\n    }\n    body = json.encode(v: payload)\n\n    return http.post(headers: headers, url: url, data: body)\n}",
					Start: ast.Position{
						Column: 1,
						Line:   23,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// event sends event to Zenoss.\n"}, ast.Comment{Text: "// `url` - string - events web service URL.\n"}, ast.Comment{Text: "// `username` - string - username for HTTP BASIC authentication. Default is empty string (no auth).\n"}, ast.Comment{Text: "// `password` - string - password for HTTP BASIC authentication. Default is empty string (no auth).\n"}, ast.Comment{Text: "// `action` - string - routername. Default is \"EventsRouter\".\n"}, ast.Comment{Text: "// `method` - string - router name. Default is \"add_event\".\n"}, ast.Comment{Text: "// `type` - string - event type. Default is \"rpc\".\n"}, ast.Comment{Text: "// `tid` - int - temporary transaction ID. Default is 1.\n"}, ast.Comment{Text: "// `summary` - string - event summary. Default is empty string.\n"}, ast.Comment{Text: "// `device` - string - related device. Default is empty string.\n"}, ast.Comment{Text: "// `component` - string - related component.\n"}, ast.Comment{Text: "// `severity` - string - severity of the event.\n"}, ast.Comment{Text: "// `eventClass` - string - event class. Default is empty string.\n"}, ast.Comment{Text: "// `eventClassKey` - string - event class key. Default is empty string.\n"}, ast.Comment{Text: "// `collector` - string - collector. Default is empty string.\n"}, ast.Comment{Text: "// `message` - string - event message. Default is empty string.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   23,
						},
						File:   "zenoss.flux",
						Source: "event",
						Start: ast.Position{
							Column: 1,
							Line:   23,
						},
					},
				},
				Name: "event",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   66,
						},
						File:   "zenoss.flux",
						Source: "(\n        url,\n        username,\n        password,\n        action=\"EventsRouter\",\n        method=\"add_event\",\n        type=\"rpc\",\n        tid=1,\n        summary=\"\",\n        device=\"\",\n        component=\"\",\n        severity,\n        eventClass=\"\",\n        eventClassKey=\"\",\n        collector=\"\",\n        message=\"\",\n) => {\n    event = {\n        summary: summary,\n        device: device,\n        component: component,\n        severity: severity,\n        evclass: eventClass,\n        evclasskey: eventClassKey,\n        collector: collector,\n        message: message,\n    }\n    payload = {\n        action: action,\n        method: method,\n        data: [\n            event,\n        ],\n        type: type,\n        tid: tid,\n    }\n    headers = {\n        \"Authorization\": http.basicAuth(u: username, p: password),\n        \"Content-Type\": \"application/json\",\n    }\n    body = json.encode(v: payload)\n\n    return http.post(headers: headers, url: url, data: body)\n}",
						Start: ast.Position{
							Column: 9,
							Line:   23,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   66,
							},
							File:   "zenoss.flux",
							Source: "{\n    event = {\n        summary: summary,\n        device: device,\n        component: component,\n        severity: severity,\n        evclass: eventClass,\n        evclasskey: eventClassKey,\n        collector: collector,\n        message: message,\n    }\n    payload = {\n        action: action,\n        method: method,\n        data: [\n            event,\n        ],\n        type: type,\n        tid: tid,\n    }\n    headers = {\n        \"Authorization\": http.basicAuth(u: username, p: password),\n        \"Content-Type\": \"application/json\",\n    }\n    body = json.encode(v: payload)\n\n    return http.post(headers: headers, url: url, data: body)\n}",
							Start: ast.Position{
								Column: 6,
								Line:   39,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   49,
								},
								File:   "zenoss.flux",
								Source: "event = {\n        summary: summary,\n        device: device,\n        component: component,\n        severity: severity,\n        evclass: eventClass,\n        evclasskey: eventClassKey,\n        collector: collector,\n        message: message,\n    }",
								Start: ast.Position{
									Column: 5,
									Line:   40,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 10,
										Line:   40,
									},
									File:   "zenoss.flux",
									Source: "event",
									Start: ast.Position{
										Column: 5,
										Line:   40,
									},
								},
							},
							Name: "event",
						},
						Init: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   49,
									},
									File:   "zenoss.flux",
									Source: "{\n        summary: summary,\n        device: device,\n        component: component,\n        severity: severity,\n        evclass: eventClass,\n        evclasskey: eventClassKey,\n        collector: collector,\n        message: message,\n    }",
									Start: ast.Position{
										Column: 13,
										Line:   40,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   41,
										},
										File:   "zenoss.flux",
										Source: "summary: summary",
										Start: ast.Position{
											Column: 9,
											Line:   41,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   41,
											},
											File:   "zenoss.flux",
											Source: "summary",
											Start: ast.Position{
												Column: 9,
												Line:   41,
											},
										},
									},
									Name: "summary",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   41,
											},
											File:   "zenoss.flux",
											Source: "summary",
											Start: ast.Position{
												Column: 18,
												Line:   41,
											},
										},
									},
									Name: "summary",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   42,
										},
										File:   "zenoss.flux",
										Source: "device: device",
										Start: ast.Position{
											Column: 9,
											Line:   42,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   42,
											},
											File:   "zenoss.flux",
											Source: "device",
											Start: ast.Position{
												Column: 9,
												Line:   42,
											},
										},
									},
									Name: "device",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   42,
											},
											File:   "zenoss.flux",
											Source: "device",
											Start: ast.Position{
												Column: 17,
												Line:   42,
											},
										},
									},
									Name: "device",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   43,
										},
										File:   "zenoss.flux",
										Source: "component: component",
										Start: ast.Position{
											Column: 9,
											Line:   43,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   43,
											},
											File:   "zenoss.flux",
											Source: "component",
											Start: ast.Position{
												Column: 9,
												Line:   43,
											},
										},
									},
									Name: "component",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   43,
											},
											File:   "zenoss.flux",
											Source: "component",
											Start: ast.Position{
												Column: 20,
												Line:   43,
											},
										},
									},
									Name: "component",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   44,
										},
										File:   "zenoss.flux",
										Source: "severity: severity",
										Start: ast.Position{
											Column: 9,
											Line:   44,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   44,
											},
											File:   "zenoss.flux",
											Source: "severity",
											Start: ast.Position{
												Column: 9,
												Line:   44,
											},
										},
									},
									Name: "severity",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 27,
												Line:   44,
											},
											File:   "zenoss.flux",
											Source: "severity",
											Start: ast.Position{
												Column: 19,
												Line:   44,
											},
										},
									},
									Name: "severity",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   45,
										},
										File:   "zenoss.flux",
										Source: "evclass: eventClass",
										Start: ast.Position{
											Column: 9,
											Line:   45,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   45,
											},
											File:   "zenoss.flux",
											Source: "evclass",
											Start: ast.Position{
												Column: 9,
												Line:   45,
											},
										},
									},
									Name: "evclass",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 28,
												Line:   45,
											},
											File:   "zenoss.flux",
											Source: "eventClass",
											Start: ast.Position{
												Column: 18,
												Line:   45,
											},
										},
									},
									Name: "eventClass",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   46,
										},
										File:   "zenoss.flux",
										Source: "evclasskey: eventClassKey",
										Start: ast.Position{
											Column: 9,
											Line:   46,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   46,
											},
											File:   "zenoss.flux",
											Source: "evclasskey",
											Start: ast.Position{
												Column: 9,
												Line:   46,
											},
										},
									},
									Name: "evclasskey",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   46,
											},
											File:   "zenoss.flux",
											Source: "eventClassKey",
											Start: ast.Position{
												Column: 21,
												Line:   46,
											},
										},
									},
									Name: "eventClassKey",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   47,
										},
										File:   "zenoss.flux",
										Source: "collector: collector",
										Start: ast.Position{
											Column: 9,
											Line:   47,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   47,
											},
											File:   "zenoss.flux",
											Source: "collector",
											Start: ast.Position{
												Column: 9,
												Line:   47,
											},
										},
									},
									Name: "collector",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 29,
												Line:   47,
											},
											File:   "zenoss.flux",
											Source: "collector",
											Start: ast.Position{
												Column: 20,
												Line:   47,
											},
										},
									},
									Name: "collector",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   48,
										},
										File:   "zenoss.flux",
										Source: "message: message",
										Start: ast.Position{
											Column: 9,
											Line:   48,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   48,
											},
											File:   "zenoss.flux",
											Source: "message",
											Start: ast.Position{
												Column: 9,
												Line:   48,
											},
										},
									},
									Name: "message",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 25,
												Line:   48,
											},
											File:   "zenoss.flux",
											Source: "message",
											Start: ast.Position{
												Column: 18,
												Line:   48,
											},
										},
									},
									Name: "message",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   58,
								},
								File:   "zenoss.flux",
								Source: "payload = {\n        action: action,\n        method: method,\n        data: [\n            event,\n        ],\n        type: type,\n        tid: tid,\n    }",
								Start: ast.Position{
									Column: 5,
									Line:   50,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   50,
									},
									File:   "zenoss.flux",
									Source: "payload",
									Start: ast.Position{
										Column: 5,
										Line:   50,
									},
								},
							},
							Name: "payload",
						},
						Init: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   58,
									},
									File:   "zenoss.flux",
									Source: "{\n        action: action,\n        method: method,\n        data: [\n            event,\n        ],\n        type: type,\n        tid: tid,\n    }",
									Start: ast.Position{
										Column: 15,
										Line:   50,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   51,
										},
										File:   "zenoss.flux",
										Source: "action: action",
										Start: ast.Position{
											Column: 9,
											Line:   51,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   51,
											},
											File:   "zenoss.flux",
											Source: "action",
											Start: ast.Position{
												Column: 9,
												Line:   51,
											},
										},
									},
									Name: "action",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   51,
											},
											File:   "zenoss.flux",
											Source: "action",
											Start: ast.Position{
												Column: 17,
												Line:   51,
											},
										},
									},
									Name: "action",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   52,
										},
										File:   "zenoss.flux",
										Source: "method: method",
										Start: ast.Position{
											Column: 9,
											Line:   52,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 15,
												Line:   52,
											},
											File:   "zenoss.flux",
											Source: "method",
											Start: ast.Position{
												Column: 9,
												Line:   52,
											},
										},
									},
									Name: "method",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   52,
											},
											File:   "zenoss.flux",
											Source: "method",
											Start: ast.Position{
												Column: 17,
												Line:   52,
											},
										},
									},
									Name: "method",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 10,
											Line:   55,
										},
										File:   "zenoss.flux",
										Source: "data: [\n            event,\n        ]",
										Start: ast.Position{
											Column: 9,
											Line:   53,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   53,
											},
											File:   "zenoss.flux",
											Source: "data",
											Start: ast.Position{
												Column: 9,
												Line:   53,
											},
										},
									},
									Name: "data",
								},
								Separator: nil,
								Value: &ast.ArrayExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 10,
												Line:   55,
											},
											File:   "zenoss.flux",
											Source: "[\n            event,\n        ]",
											Start: ast.Position{
												Column: 15,
												Line:   53,
											},
										},
									},
									Elements: []ast.Expression{&ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 18,
													Line:   54,
												},
												File:   "zenoss.flux",
												Source: "event",
												Start: ast.Position{
													Column: 13,
													Line:   54,
												},
											},
										},
										Name: "event",
									}},
									Lbrack: nil,
									Rbrack: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 19,
											Line:   56,
										},
										File:   "zenoss.flux",
										Source: "type: type",
										Start: ast.Position{
											Column: 9,
											Line:   56,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 13,
												Line:   56,
											},
											File:   "zenoss.flux",
											Source: "type",
											Start: ast.Position{
												Column: 9,
												Line:   56,
											},
										},
									},
									Name: "type",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   56,
											},
											File:   "zenoss.flux",
											Source: "type",
											Start: ast.Position{
												Column: 15,
												Line:   56,
											},
										},
									},
									Name: "type",
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 17,
											Line:   57,
										},
										File:   "zenoss.flux",
										Source: "tid: tid",
										Start: ast.Position{
											Column: 9,
											Line:   57,
										},
									},
								},
								Comma: nil,
								Key: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 12,
												Line:   57,
											},
											File:   "zenoss.flux",
											Source: "tid",
											Start: ast.Position{
												Column: 9,
												Line:   57,
											},
										},
									},
									Name: "tid",
								},
								Separator: nil,
								Value: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   57,
											},
											File:   "zenoss.flux",
											Source: "tid",
											Start: ast.Position{
												Column: 14,
												Line:   57,
											},
										},
									},
									Name: "tid",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   62,
								},
								File:   "zenoss.flux",
								Source: "headers = {\n        \"Authorization\": http.basicAuth(u: username, p: password),\n        \"Content-Type\": \"application/json\",\n    }",
								Start: ast.Position{
									Column: 5,
									Line:   59,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   59,
									},
									File:   "zenoss.flux",
									Source: "headers",
									Start: ast.Position{
										Column: 5,
										Line:   59,
									},
								},
							},
							Name: "headers",
						},
						Init: &ast.ObjectExpression{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   62,
									},
									File:   "zenoss.flux",
									Source: "{\n        \"Authorization\": http.basicAuth(u: username, p: password),\n        \"Content-Type\": \"application/json\",\n    }",
									Start: ast.Position{
										Column: 15,
										Line:   59,
									},
								},
							},
							Lbrace: nil,
							Properties: []*ast.Property{&ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 66,
											Line:   60,
										},
										File:   "zenoss.flux",
										Source: "\"Authorization\": http.basicAuth(u: username, p: password)",
										Start: ast.Position{
											Column: 9,
											Line:   60,
										},
									},
								},
								Comma: nil,
								Key: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   60,
											},
											File:   "zenoss.flux",
											Source: "\"Authorization\"",
											Start: ast.Position{
												Column: 9,
												Line:   60,
											},
										},
									},
									Value: "Authorization",
								},
								Separator: nil,
								Value: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 65,
													Line:   60,
												},
												File:   "zenoss.flux",
												Source: "u: username, p: password",
												Start: ast.Position{
													Column: 41,
													Line:   60,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 52,
														Line:   60,
													},
													File:   "zenoss.flux",
													Source: "u: username",
													Start: ast.Position{
														Column: 41,
														Line:   60,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 42,
															Line:   60,
														},
														File:   "zenoss.flux",
														Source: "u",
														Start: ast.Position{
															Column: 41,
															Line:   60,
														},
													},
												},
												Name: "u",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 52,
															Line:   60,
														},
														File:   "zenoss.flux",
														Source: "username",
														Start: ast.Position{
															Column: 44,
															Line:   60,
														},
													},
												},
												Name: "username",
											},
										}, &ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 65,
														Line:   60,
													},
													File:   "zenoss.flux",
													Source: "p: password",
													Start: ast.Position{
														Column: 54,
														Line:   60,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 55,
															Line:   60,
														},
														File:   "zenoss.flux",
														Source: "p",
														Start: ast.Position{
															Column: 54,
															Line:   60,
														},
													},
												},
												Name: "p",
											},
											Separator: nil,
											Value: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 65,
															Line:   60,
														},
														File:   "zenoss.flux",
														Source: "password",
														Start: ast.Position{
															Column: 57,
															Line:   60,
														},
													},
												},
												Name: "password",
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 66,
												Line:   60,
											},
											File:   "zenoss.flux",
											Source: "http.basicAuth(u: username, p: password)",
											Start: ast.Position{
												Column: 26,
												Line:   60,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 40,
													Line:   60,
												},
												File:   "zenoss.flux",
												Source: "http.basicAuth",
												Start: ast.Position{
													Column: 26,
													Line:   60,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 30,
														Line:   60,
													},
													File:   "zenoss.flux",
													Source: "http",
													Start: ast.Position{
														Column: 26,
														Line:   60,
													},
												},
											},
											Name: "http",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 40,
														Line:   60,
													},
													File:   "zenoss.flux",
													Source: "basicAuth",
													Start: ast.Position{
														Column: 31,
														Line:   60,
													},
												},
											},
											Name: "basicAuth",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
							}, &ast.Property{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   61,
										},
										File:   "zenoss.flux",
										Source: "\"Content-Type\": \"application/json\"",
										Start: ast.Position{
											Column: 9,
											Line:   61,
										},
									},
								},
								Comma: nil,
								Key: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   61,
											},
											File:   "zenoss.flux",
											Source: "\"Content-Type\"",
											Start: ast.Position{
												Column: 9,
												Line:   61,
											},
										},
									},
									Value: "Content-Type",
								},
								Separator: nil,
								Value: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 43,
												Line:   61,
											},
											File:   "zenoss.flux",
											Source: "\"application/json\"",
											Start: ast.Position{
												Column: 25,
												Line:   61,
											},
										},
									},
									Value: "application/json",
								},
							}},
							Rbrace: nil,
							With:   nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   63,
								},
								File:   "zenoss.flux",
								Source: "body = json.encode(v: payload)",
								Start: ast.Position{
									Column: 5,
									Line:   63,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 9,
										Line:   63,
									},
									File:   "zenoss.flux",
									Source: "body",
									Start: ast.Position{
										Column: 5,
										Line:   63,
									},
								},
							},
							Name: "body",
						},
						Init: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 34,
											Line:   63,
										},
										File:   "zenoss.flux",
										Source: "v: payload",
										Start: ast.Position{
											Column: 24,
											Line:   63,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   63,
											},
											File:   "zenoss.flux",
											Source: "v: payload",
											Start: ast.Position{
												Column: 24,
												Line:   63,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 25,
													Line:   63,
												},
												File:   "zenoss.flux",
												Source: "v",
												Start: ast.Position{
													Column: 24,
													Line:   63,
												},
											},
										},
										Name: "v",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 34,
													Line:   63,
												},
												File:   "zenoss.flux",
												Source: "payload",
												Start: ast.Position{
													Column: 27,
													Line:   63,
												},
											},
										},
										Name: "payload",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   63,
									},
									File:   "zenoss.flux",
									Source: "json.encode(v: payload)",
									Start: ast.Position{
										Column: 12,
										Line:   63,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   63,
										},
										File:   "zenoss.flux",
										Source: "json.encode",
										Start: ast.Position{
											Column: 12,
											Line:   63,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   63,
											},
											File:   "zenoss.flux",
											Source: "json",
											Start: ast.Position{
												Column: 12,
												Line:   63,
											},
										},
									},
									Name: "json",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 23,
												Line:   63,
											},
											File:   "zenoss.flux",
											Source: "encode",
											Start: ast.Position{
												Column: 17,
												Line:   63,
											},
										},
									},
									Name: "encode",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
					}, &ast.ReturnStatement{
						Argument: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 60,
											Line:   65,
										},
										File:   "zenoss.flux",
										Source: "headers: headers, url: url, data: body",
										Start: ast.Position{
											Column: 22,
											Line:   65,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 38,
												Line:   65,
											},
											File:   "zenoss.flux",
											Source: "headers: headers",
											Start: ast.Position{
												Column: 22,
												Line:   65,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 29,
													Line:   65,
												},
												File:   "zenoss.flux",
												Source: "headers",
												Start: ast.Position{
													Column: 22,
													Line:   65,
												},
											},
										},
										Name: "headers",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 38,
													Line:   65,
												},
												File:   "zenoss.flux",
												Source: "headers",
												Start: ast.Position{
													Column: 31,
													Line:   65,
												},
											},
										},
										Name: "headers",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 48,
												Line:   65,
											},
											File:   "zenoss.flux",
											Source: "url: url",
											Start: ast.Position{
												Column: 40,
												Line:   65,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 43,
													Line:   65,
												},
												File:   "zenoss.flux",
												Source: "url",
												Start: ast.Position{
													Column: 40,
													Line:   65,
												},
											},
										},
										Name: "url",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 48,
													Line:   65,
												},
												File:   "zenoss.flux",
												Source: "url",
												Start: ast.Position{
													Column: 45,
													Line:   65,
												},
											},
										},
										Name: "url",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 60,
												Line:   65,
											},
											File:   "zenoss.flux",
											Source: "data: body",
											Start: ast.Position{
												Column: 50,
												Line:   65,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 54,
													Line:   65,
												},
												File:   "zenoss.flux",
												Source: "data",
												Start: ast.Position{
													Column: 50,
													Line:   65,
												},
											},
										},
										Name: "data",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 60,
													Line:   65,
												},
												File:   "zenoss.flux",
												Source: "body",
												Start: ast.Position{
													Column: 56,
													Line:   65,
												},
											},
										},
										Name: "body",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 61,
										Line:   65,
									},
									File:   "zenoss.flux",
									Source: "http.post(headers: headers, url: url, data: body)",
									Start: ast.Position{
										Column: 12,
										Line:   65,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   65,
										},
										File:   "zenoss.flux",
										Source: "http.post",
										Start: ast.Position{
											Column: 12,
											Line:   65,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 16,
												Line:   65,
											},
											File:   "zenoss.flux",
											Source: "http",
											Start: ast.Position{
												Column: 12,
												Line:   65,
											},
										},
									},
									Name: "http",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   65,
											},
											File:   "zenoss.flux",
											Source: "post",
											Start: ast.Position{
												Column: 17,
												Line:   65,
											},
										},
									},
									Name: "post",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 61,
									Line:   65,
								},
								File:   "zenoss.flux",
								Source: "return http.post(headers: headers, url: url, data: body)",
								Start: ast.Position{
									Column: 5,
									Line:   65,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 12,
								Line:   24,
							},
							File:   "zenoss.flux",
							Source: "url",
							Start: ast.Position{
								Column: 9,
								Line:   24,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   24,
								},
								File:   "zenoss.flux",
								Source: "url",
								Start: ast.Position{
									Column: 9,
									Line:   24,
								},
							},
						},
						Name: "url",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 17,
								Line:   25,
							},
							File:   "zenoss.flux",
							Source: "username",
							Start: ast.Position{
								Column: 9,
								Line:   25,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   25,
								},
								File:   "zenoss.flux",
								Source: "username",
								Start: ast.Position{
									Column: 9,
									Line:   25,
								},
							},
						},
						Name: "username",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 17,
								Line:   26,
							},
							File:   "zenoss.flux",
							Source: "password",
							Start: ast.Position{
								Column: 9,
								Line:   26,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   26,
								},
								File:   "zenoss.flux",
								Source: "password",
								Start: ast.Position{
									Column: 9,
									Line:   26,
								},
							},
						},
						Name: "password",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   27,
							},
							File:   "zenoss.flux",
							Source: "action=\"EventsRouter\"",
							Start: ast.Position{
								Column: 9,
								Line:   27,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   27,
								},
								File:   "zenoss.flux",
								Source: "action",
								Start: ast.Position{
									Column: 9,
									Line:   27,
								},
							},
						},
						Name: "action",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   27,
								},
								File:   "zenoss.flux",
								Source: "\"EventsRouter\"",
								Start: ast.Position{
									Column: 16,
									Line:   27,
								},
							},
						},
						Value: "EventsRouter",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   28,
							},
							File:   "zenoss.flux",
							Source: "method=\"add_event\"",
							Start: ast.Position{
								Column: 9,
								Line:   28,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   28,
								},
								File:   "zenoss.flux",
								Source: "method",
								Start: ast.Position{
									Column: 9,
									Line:   28,
								},
							},
						},
						Name: "method",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   28,
								},
								File:   "zenoss.flux",
								Source: "\"add_event\"",
								Start: ast.Position{
									Column: 16,
									Line:   28,
								},
							},
						},
						Value: "add_event",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   29,
							},
							File:   "zenoss.flux",
							Source: "type=\"rpc\"",
							Start: ast.Position{
								Column: 9,
								Line:   29,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   29,
								},
								File:   "zenoss.flux",
								Source: "type",
								Start: ast.Position{
									Column: 9,
									Line:   29,
								},
							},
						},
						Name: "type",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   29,
								},
								File:   "zenoss.flux",
								Source: "\"rpc\"",
								Start: ast.Position{
									Column: 14,
									Line:   29,
								},
							},
						},
						Value: "rpc",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   30,
							},
							File:   "zenoss.flux",
							Source: "tid=1",
							Start: ast.Position{
								Column: 9,
								Line:   30,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   30,
								},
								File:   "zenoss.flux",
								Source: "tid",
								Start: ast.Position{
									Column: 9,
									Line:   30,
								},
							},
						},
						Name: "tid",
					},
					Separator: nil,
					Value: &ast.IntegerLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   30,
								},
								File:   "zenoss.flux",
								Source: "1",
								Start: ast.Position{
									Column: 13,
									Line:   30,
								},
							},
						},
						Value: int64(1),
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   31,
							},
							File:   "zenoss.flux",
							Source: "summary=\"\"",
							Start: ast.Position{
								Column: 9,
								Line:   31,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   31,
								},
								File:   "zenoss.flux",
								Source: "summary",
								Start: ast.Position{
									Column: 9,
									Line:   31,
								},
							},
						},
						Name: "summary",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   31,
								},
								File:   "zenoss.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 17,
									Line:   31,
								},
							},
						},
						Value: "",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   32,
							},
							File:   "zenoss.flux",
							Source: "device=\"\"",
							Start: ast.Position{
								Column: 9,
								Line:   32,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   32,
								},
								File:   "zenoss.flux",
								Source: "device",
								Start: ast.Position{
									Column: 9,
									Line:   32,
								},
							},
						},
						Name: "device",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   32,
								},
								File:   "zenoss.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 16,
									Line:   32,
								},
							},
						},
						Value: "",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   33,
							},
							File:   "zenoss.flux",
							Source: "component=\"\"",
							Start: ast.Position{
								Column: 9,
								Line:   33,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   33,
								},
								File:   "zenoss.flux",
								Source: "component",
								Start: ast.Position{
									Column: 9,
									Line:   33,
								},
							},
						},
						Name: "component",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   33,
								},
								File:   "zenoss.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 19,
									Line:   33,
								},
							},
						},
						Value: "",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 17,
								Line:   34,
							},
							File:   "zenoss.flux",
							Source: "severity",
							Start: ast.Position{
								Column: 9,
								Line:   34,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   34,
								},
								File:   "zenoss.flux",
								Source: "severity",
								Start: ast.Position{
									Column: 9,
									Line:   34,
								},
							},
						},
						Name: "severity",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 22,
								Line:   35,
							},
							File:   "zenoss.flux",
							Source: "eventClass=\"\"",
							Start: ast.Position{
								Column: 9,
								Line:   35,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   35,
								},
								File:   "zenoss.flux",
								Source: "eventClass",
								Start: ast.Position{
									Column: 9,
									Line:   35,
								},
							},
						},
						Name: "eventClass",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   35,
								},
								File:   "zenoss.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 20,
									Line:   35,
								},
							},
						},
						Value: "",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 25,
								Line:   36,
							},
							File:   "zenoss.flux",
							Source: "eventClassKey=\"\"",
							Start: ast.Position{
								Column: 9,
								Line:   36,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   36,
								},
								File:   "zenoss.flux",
								Source: "eventClassKey",
								Start: ast.Position{
									Column: 9,
									Line:   36,
								},
							},
						},
						Name: "eventClassKey",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   36,
								},
								File:   "zenoss.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 23,
									Line:   36,
								},
							},
						},
						Value: "",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 21,
								Line:   37,
							},
							File:   "zenoss.flux",
							Source: "collector=\"\"",
							Start: ast.Position{
								Column: 9,
								Line:   37,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   37,
								},
								File:   "zenoss.flux",
								Source: "collector",
								Start: ast.Position{
									Column: 9,
									Line:   37,
								},
							},
						},
						Name: "collector",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   37,
								},
								File:   "zenoss.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 19,
									Line:   37,
								},
							},
						},
						Value: "",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   38,
							},
							File:   "zenoss.flux",
							Source: "message=\"\"",
							Start: ast.Position{
								Column: 9,
								Line:   38,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   38,
								},
								File:   "zenoss.flux",
								Source: "message",
								Start: ast.Position{
									Column: 9,
									Line:   38,
								},
							},
						},
						Name: "message",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   38,
								},
								File:   "zenoss.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 17,
									Line:   38,
								},
							},
						},
						Value: "",
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 6,
						Line:   114,
					},
					File:   "zenoss.flux",
					Source: "endpoint = (\n        url,\n        username,\n        password,\n        action=\"EventsRouter\",\n        method=\"add_event\",\n        type=\"rpc\",\n        tid=1,\n) => (mapFn) => (tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == event(\n                        url: url,\n                        username: username,\n                        password: password,\n                        action: action,\n                        method: method,\n                        type: type,\n                        tid: tid,\n                        summary: obj.summary,\n                        device: obj.device,\n                        component: obj.component,\n                        severity: obj.severity,\n                        eventClass: obj.eventClass,\n                        eventClassKey: obj.eventClassKey,\n                        collector: obj.collector,\n                        message: obj.message,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
					Start: ast.Position{
						Column: 1,
						Line:   79,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// endpoint return method for sending events to Zenoss.\n"}, ast.Comment{Text: "// Parameters:\n"}, ast.Comment{Text: "// `url` - string - events web service URL.\n"}, ast.Comment{Text: "// `username` - string - username for HTTP BASIC authentication. Default is empty string (no auth).\n"}, ast.Comment{Text: "// `password` - string - password for HTTP BASIC authentication. Default is empty string (no auth).\n"}, ast.Comment{Text: "// `action` - string - routername. Default is \"EventsRouter\".\n"}, ast.Comment{Text: "// `method` - string - router name. Default is \"add_event\".\n"}, ast.Comment{Text: "// `type` - string - event type. Default is \"rpc\".\n"}, ast.Comment{Text: "// `tid` - int - temporary transaction ID. Default is 1.\n"}, ast.Comment{Text: "// The returned factory function accepts a `mapFn` parameter.\n"}, ast.Comment{Text: "// The `mapFn` must return record with `summary`, `device`, `component`, `severity`, `eventClass`, `eventClassKey`, `collector` and `message` fields as defined in the `event` function arguments.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   79,
						},
						File:   "zenoss.flux",
						Source: "endpoint",
						Start: ast.Position{
							Column: 1,
							Line:   79,
						},
					},
				},
				Name: "endpoint",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   114,
						},
						File:   "zenoss.flux",
						Source: "(\n        url,\n        username,\n        password,\n        action=\"EventsRouter\",\n        method=\"add_event\",\n        type=\"rpc\",\n        tid=1,\n) => (mapFn) => (tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == event(\n                        url: url,\n                        username: username,\n                        password: password,\n                        action: action,\n                        method: method,\n                        type: type,\n                        tid: tid,\n                        summary: obj.summary,\n                        device: obj.device,\n                        component: obj.component,\n                        severity: obj.severity,\n                        eventClass: obj.eventClass,\n                        eventClassKey: obj.eventClassKey,\n                        collector: obj.collector,\n                        message: obj.message,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
						Start: ast.Position{
							Column: 12,
							Line:   79,
						},
					},
				},
				Body: &ast.FunctionExpression{
					Arrow: nil,
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 6,
								Line:   114,
							},
							File:   "zenoss.flux",
							Source: "(mapFn) => (tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == event(\n                        url: url,\n                        username: username,\n                        password: password,\n                        action: action,\n                        method: method,\n                        type: type,\n                        tid: tid,\n                        summary: obj.summary,\n                        device: obj.device,\n                        component: obj.component,\n                        severity: obj.severity,\n                        eventClass: obj.eventClass,\n                        eventClassKey: obj.eventClassKey,\n                        collector: obj.collector,\n                        message: obj.message,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
							Start: ast.Position{
								Column: 6,
								Line:   87,
							},
						},
					},
					Body: &ast.FunctionExpression{
						Arrow: nil,
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   114,
								},
								File:   "zenoss.flux",
								Source: "(tables=<-) => tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == event(\n                        url: url,\n                        username: username,\n                        password: password,\n                        action: action,\n                        method: method,\n                        type: type,\n                        tid: tid,\n                        summary: obj.summary,\n                        device: obj.device,\n                        component: obj.component,\n                        severity: obj.severity,\n                        eventClass: obj.eventClass,\n                        eventClassKey: obj.eventClassKey,\n                        collector: obj.collector,\n                        message: obj.message,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
								Start: ast.Position{
									Column: 17,
									Line:   87,
								},
							},
						},
						Body: &ast.PipeExpression{
							Argument: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 38,
											Line:   87,
										},
										File:   "zenoss.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 32,
											Line:   87,
										},
									},
								},
								Name: "tables",
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   114,
									},
									File:   "zenoss.flux",
									Source: "tables\n    |> map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == event(\n                        url: url,\n                        username: username,\n                        password: password,\n                        action: action,\n                        method: method,\n                        type: type,\n                        tid: tid,\n                        summary: obj.summary,\n                        device: obj.device,\n                        component: obj.component,\n                        severity: obj.severity,\n                        eventClass: obj.eventClass,\n                        eventClassKey: obj.eventClassKey,\n                        collector: obj.collector,\n                        message: obj.message,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
									Start: ast.Position{
										Column: 32,
										Line:   87,
									},
								},
							},
							Call: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 10,
												Line:   113,
											},
											File:   "zenoss.flux",
											Source: "fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == event(\n                        url: url,\n                        username: username,\n                        password: password,\n                        action: action,\n                        method: method,\n                        type: type,\n                        tid: tid,\n                        summary: obj.summary,\n                        device: obj.device,\n                        component: obj.component,\n                        severity: obj.severity,\n                        eventClass: obj.eventClass,\n                        eventClassKey: obj.eventClassKey,\n                        collector: obj.collector,\n                        message: obj.message,\n                    ) / 100,\n                ),\n            }\n        }",
											Start: ast.Position{
												Column: 9,
												Line:   89,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 10,
													Line:   113,
												},
												File:   "zenoss.flux",
												Source: "fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == event(\n                        url: url,\n                        username: username,\n                        password: password,\n                        action: action,\n                        method: method,\n                        type: type,\n                        tid: tid,\n                        summary: obj.summary,\n                        device: obj.device,\n                        component: obj.component,\n                        severity: obj.severity,\n                        eventClass: obj.eventClass,\n                        eventClassKey: obj.eventClassKey,\n                        collector: obj.collector,\n                        message: obj.message,\n                    ) / 100,\n                ),\n            }\n        }",
												Start: ast.Position{
													Column: 9,
													Line:   89,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 11,
														Line:   89,
													},
													File:   "zenoss.flux",
													Source: "fn",
													Start: ast.Position{
														Column: 9,
														Line:   89,
													},
												},
											},
											Name: "fn",
										},
										Separator: nil,
										Value: &ast.FunctionExpression{
											Arrow: nil,
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 10,
														Line:   113,
													},
													File:   "zenoss.flux",
													Source: "(r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == event(\n                        url: url,\n                        username: username,\n                        password: password,\n                        action: action,\n                        method: method,\n                        type: type,\n                        tid: tid,\n                        summary: obj.summary,\n                        device: obj.device,\n                        component: obj.component,\n                        severity: obj.severity,\n                        eventClass: obj.eventClass,\n                        eventClassKey: obj.eventClassKey,\n                        collector: obj.collector,\n                        message: obj.message,\n                    ) / 100,\n                ),\n            }\n        }",
													Start: ast.Position{
														Column: 13,
														Line:   89,
													},
												},
											},
											Body: &ast.Block{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 10,
															Line:   113,
														},
														File:   "zenoss.flux",
														Source: "{\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == event(\n                        url: url,\n                        username: username,\n                        password: password,\n                        action: action,\n                        method: method,\n                        type: type,\n                        tid: tid,\n                        summary: obj.summary,\n                        device: obj.device,\n                        component: obj.component,\n                        severity: obj.severity,\n                        eventClass: obj.eventClass,\n                        eventClassKey: obj.eventClassKey,\n                        collector: obj.collector,\n                        message: obj.message,\n                    ) / 100,\n                ),\n            }\n        }",
														Start: ast.Position{
															Column: 20,
															Line:   89,
														},
													},
												},
												Body: []ast.Statement{&ast.VariableAssignment{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 30,
																Line:   90,
															},
															File:   "zenoss.flux",
															Source: "obj = mapFn(r: r)",
															Start: ast.Position{
																Column: 13,
																Line:   90,
															},
														},
													},
													ID: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 16,
																	Line:   90,
																},
																File:   "zenoss.flux",
																Source: "obj",
																Start: ast.Position{
																	Column: 13,
																	Line:   90,
																},
															},
														},
														Name: "obj",
													},
													Init: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 29,
																		Line:   90,
																	},
																	File:   "zenoss.flux",
																	Source: "r: r",
																	Start: ast.Position{
																		Column: 25,
																		Line:   90,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 29,
																			Line:   90,
																		},
																		File:   "zenoss.flux",
																		Source: "r: r",
																		Start: ast.Position{
																			Column: 25,
																			Line:   90,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 26,
																				Line:   90,
																			},
																			File:   "zenoss.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 25,
																				Line:   90,
																			},
																		},
																	},
																	Name: "r",
																},
																Separator: nil,
																Value: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 29,
																				Line:   90,
																			},
																			File:   "zenoss.flux",
																			Source: "r",
																			Start: ast.Position{
																				Column: 28,
																				Line:   90,
																			},
																		},
																	},
																	Name: "r",
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 30,
																	Line:   90,
																},
																File:   "zenoss.flux",
																Source: "mapFn(r: r)",
																Start: ast.Position{
																	Column: 19,
																	Line:   90,
																},
															},
														},
														Callee: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 24,
																		Line:   90,
																	},
																	File:   "zenoss.flux",
																	Source: "mapFn",
																	Start: ast.Position{
																		Column: 19,
																		Line:   90,
																	},
																},
															},
															Name: "mapFn",
														},
														Lparen: nil,
														Rparen: nil,
													},
												}, &ast.ReturnStatement{
													Argument: &ast.ObjectExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 14,
																	Line:   112,
																},
																File:   "zenoss.flux",
																Source: "{r with\n                _sent: string(\n                    v: 2 == event(\n                        url: url,\n                        username: username,\n                        password: password,\n                        action: action,\n                        method: method,\n                        type: type,\n                        tid: tid,\n                        summary: obj.summary,\n                        device: obj.device,\n                        component: obj.component,\n                        severity: obj.severity,\n                        eventClass: obj.eventClass,\n                        eventClassKey: obj.eventClassKey,\n                        collector: obj.collector,\n                        message: obj.message,\n                    ) / 100,\n                ),\n            }",
																Start: ast.Position{
																	Column: 20,
																	Line:   92,
																},
															},
														},
														Lbrace: nil,
														Properties: []*ast.Property{&ast.Property{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 18,
																		Line:   111,
																	},
																	File:   "zenoss.flux",
																	Source: "_sent: string(\n                    v: 2 == event(\n                        url: url,\n                        username: username,\n                        password: password,\n                        action: action,\n                        method: method,\n                        type: type,\n                        tid: tid,\n                        summary: obj.summary,\n                        device: obj.device,\n                        component: obj.component,\n                        severity: obj.severity,\n                        eventClass: obj.eventClass,\n                        eventClassKey: obj.eventClassKey,\n                        collector: obj.collector,\n                        message: obj.message,\n                    ) / 100,\n                )",
																	Start: ast.Position{
																		Column: 17,
																		Line:   93,
																	},
																},
															},
															Comma: nil,
															Key: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 22,
																			Line:   93,
																		},
																		File:   "zenoss.flux",
																		Source: "_sent",
																		Start: ast.Position{
																			Column: 17,
																			Line:   93,
																		},
																	},
																},
																Name: "_sent",
															},
															Separator: nil,
															Value: &ast.CallExpression{
																Arguments: []ast.Expression{&ast.ObjectExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 28,
																				Line:   110,
																			},
																			File:   "zenoss.flux",
																			Source: "v: 2 == event(\n                        url: url,\n                        username: username,\n                        password: password,\n                        action: action,\n                        method: method,\n                        type: type,\n                        tid: tid,\n                        summary: obj.summary,\n                        device: obj.device,\n                        component: obj.component,\n                        severity: obj.severity,\n                        eventClass: obj.eventClass,\n                        eventClassKey: obj.eventClassKey,\n                        collector: obj.collector,\n                        message: obj.message,\n                    ) / 100",
																			Start: ast.Position{
																				Column: 21,
																				Line:   94,
																			},
																		},
																	},
																	Lbrace: nil,
																	Properties: []*ast.Property{&ast.Property{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 28,
																					Line:   110,
																				},
																				File:   "zenoss.flux",
																				Source: "v: 2 == event(\n                        url: url,\n                        username: username,\n                        password: password,\n                        action: action,\n                        method: method,\n                        type: type,\n                        tid: tid,\n                        summary: obj.summary,\n                        device: obj.device,\n                        component: obj.component,\n                        severity: obj.severity,\n                        eventClass: obj.eventClass,\n                        eventClassKey: obj.eventClassKey,\n                        collector: obj.collector,\n                        message: obj.message,\n                    ) / 100",
																				Start: ast.Position{
																					Column: 21,
																					Line:   94,
																				},
																			},
																		},
																		Comma: nil,
																		Key: &ast.Identifier{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 22,
																						Line:   94,
																					},
																					File:   "zenoss.flux",
																					Source: "v",
																					Start: ast.Position{
																						Column: 21,
																						Line:   94,
																					},
																				},
																			},
																			Name: "v",
																		},
																		Separator: nil,
																		Value: &ast.BinaryExpression{
																			BaseNode: ast.BaseNode{
																				Comments: nil,
																				Errors:   nil,
																				Loc: &ast.SourceLocation{
																					End: ast.Position{
																						Column: 28,
																						Line:   110,
																					},
																					File:   "zenoss.flux",
																					Source: "2 == event(\n                        url: url,\n                        username: username,\n                        password: password,\n                        action: action,\n                        method: method,\n                        type: type,\n                        tid: tid,\n                        summary: obj.summary,\n                        device: obj.device,\n                        component: obj.component,\n                        severity: obj.severity,\n                        eventClass: obj.eventClass,\n                        eventClassKey: obj.eventClassKey,\n                        collector: obj.collector,\n                        message: obj.message,\n                    ) / 100",
																					Start: ast.Position{
																						Column: 24,
																						Line:   94,
																					},
																				},
																			},
																			Left: &ast.IntegerLiteral{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 25,
																							Line:   94,
																						},
																						File:   "zenoss.flux",
																						Source: "2",
																						Start: ast.Position{
																							Column: 24,
																							Line:   94,
																						},
																					},
																				},
																				Value: int64(2),
																			},
																			Operator: 17,
																			Right: &ast.BinaryExpression{
																				BaseNode: ast.BaseNode{
																					Comments: nil,
																					Errors:   nil,
																					Loc: &ast.SourceLocation{
																						End: ast.Position{
																							Column: 28,
																							Line:   110,
																						},
																						File:   "zenoss.flux",
																						Source: "event(\n                        url: url,\n                        username: username,\n                        password: password,\n                        action: action,\n                        method: method,\n                        type: type,\n                        tid: tid,\n                        summary: obj.summary,\n                        device: obj.device,\n                        component: obj.component,\n                        severity: obj.severity,\n                        eventClass: obj.eventClass,\n                        eventClassKey: obj.eventClassKey,\n                        collector: obj.collector,\n                        message: obj.message,\n                    ) / 100",
																						Start: ast.Position{
																							Column: 29,
																							Line:   94,
																						},
																					},
																				},
																				Left: &ast.CallExpression{
																					Arguments: []ast.Expression{&ast.ObjectExpression{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 45,
																									Line:   109,
																								},
																								File:   "zenoss.flux",
																								Source: "url: url,\n                        username: username,\n                        password: password,\n                        action: action,\n                        method: method,\n                        type: type,\n                        tid: tid,\n                        summary: obj.summary,\n                        device: obj.device,\n                        component: obj.component,\n                        severity: obj.severity,\n                        eventClass: obj.eventClass,\n                        eventClassKey: obj.eventClassKey,\n                        collector: obj.collector,\n                        message: obj.message",
																								Start: ast.Position{
																									Column: 25,
																									Line:   95,
																								},
																							},
																						},
																						Lbrace: nil,
																						Properties: []*ast.Property{&ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 33,
																										Line:   95,
																									},
																									File:   "zenoss.flux",
																									Source: "url: url",
																									Start: ast.Position{
																										Column: 25,
																										Line:   95,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 28,
																											Line:   95,
																										},
																										File:   "zenoss.flux",
																										Source: "url",
																										Start: ast.Position{
																											Column: 25,
																											Line:   95,
																										},
																									},
																								},
																								Name: "url",
																							},
																							Separator: nil,
																							Value: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 33,
																											Line:   95,
																										},
																										File:   "zenoss.flux",
																										Source: "url",
																										Start: ast.Position{
																											Column: 30,
																											Line:   95,
																										},
																									},
																								},
																								Name: "url",
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 43,
																										Line:   96,
																									},
																									File:   "zenoss.flux",
																									Source: "username: username",
																									Start: ast.Position{
																										Column: 25,
																										Line:   96,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 33,
																											Line:   96,
																										},
																										File:   "zenoss.flux",
																										Source: "username",
																										Start: ast.Position{
																											Column: 25,
																											Line:   96,
																										},
																									},
																								},
																								Name: "username",
																							},
																							Separator: nil,
																							Value: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 43,
																											Line:   96,
																										},
																										File:   "zenoss.flux",
																										Source: "username",
																										Start: ast.Position{
																											Column: 35,
																											Line:   96,
																										},
																									},
																								},
																								Name: "username",
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 43,
																										Line:   97,
																									},
																									File:   "zenoss.flux",
																									Source: "password: password",
																									Start: ast.Position{
																										Column: 25,
																										Line:   97,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 33,
																											Line:   97,
																										},
																										File:   "zenoss.flux",
																										Source: "password",
																										Start: ast.Position{
																											Column: 25,
																											Line:   97,
																										},
																									},
																								},
																								Name: "password",
																							},
																							Separator: nil,
																							Value: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 43,
																											Line:   97,
																										},
																										File:   "zenoss.flux",
																										Source: "password",
																										Start: ast.Position{
																											Column: 35,
																											Line:   97,
																										},
																									},
																								},
																								Name: "password",
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 39,
																										Line:   98,
																									},
																									File:   "zenoss.flux",
																									Source: "action: action",
																									Start: ast.Position{
																										Column: 25,
																										Line:   98,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 31,
																											Line:   98,
																										},
																										File:   "zenoss.flux",
																										Source: "action",
																										Start: ast.Position{
																											Column: 25,
																											Line:   98,
																										},
																									},
																								},
																								Name: "action",
																							},
																							Separator: nil,
																							Value: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 39,
																											Line:   98,
																										},
																										File:   "zenoss.flux",
																										Source: "action",
																										Start: ast.Position{
																											Column: 33,
																											Line:   98,
																										},
																									},
																								},
																								Name: "action",
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 39,
																										Line:   99,
																									},
																									File:   "zenoss.flux",
																									Source: "method: method",
																									Start: ast.Position{
																										Column: 25,
																										Line:   99,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 31,
																											Line:   99,
																										},
																										File:   "zenoss.flux",
																										Source: "method",
																										Start: ast.Position{
																											Column: 25,
																											Line:   99,
																										},
																									},
																								},
																								Name: "method",
																							},
																							Separator: nil,
																							Value: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 39,
																											Line:   99,
																										},
																										File:   "zenoss.flux",
																										Source: "method",
																										Start: ast.Position{
																											Column: 33,
																											Line:   99,
																										},
																									},
																								},
																								Name: "method",
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 35,
																										Line:   100,
																									},
																									File:   "zenoss.flux",
																									Source: "type: type",
																									Start: ast.Position{
																										Column: 25,
																										Line:   100,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 29,
																											Line:   100,
																										},
																										File:   "zenoss.flux",
																										Source: "type",
																										Start: ast.Position{
																											Column: 25,
																											Line:   100,
																										},
																									},
																								},
																								Name: "type",
																							},
																							Separator: nil,
																							Value: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 35,
																											Line:   100,
																										},
																										File:   "zenoss.flux",
																										Source: "type",
																										Start: ast.Position{
																											Column: 31,
																											Line:   100,
																										},
																									},
																								},
																								Name: "type",
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 33,
																										Line:   101,
																									},
																									File:   "zenoss.flux",
																									Source: "tid: tid",
																									Start: ast.Position{
																										Column: 25,
																										Line:   101,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 28,
																											Line:   101,
																										},
																										File:   "zenoss.flux",
																										Source: "tid",
																										Start: ast.Position{
																											Column: 25,
																											Line:   101,
																										},
																									},
																								},
																								Name: "tid",
																							},
																							Separator: nil,
																							Value: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 33,
																											Line:   101,
																										},
																										File:   "zenoss.flux",
																										Source: "tid",
																										Start: ast.Position{
																											Column: 30,
																											Line:   101,
																										},
																									},
																								},
																								Name: "tid",
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 45,
																										Line:   102,
																									},
																									File:   "zenoss.flux",
																									Source: "summary: obj.summary",
																									Start: ast.Position{
																										Column: 25,
																										Line:   102,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 32,
																											Line:   102,
																										},
																										File:   "zenoss.flux",
																										Source: "summary",
																										Start: ast.Position{
																											Column: 25,
																											Line:   102,
																										},
																									},
																								},
																								Name: "summary",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 45,
																											Line:   102,
																										},
																										File:   "zenoss.flux",
																										Source: "obj.summary",
																										Start: ast.Position{
																											Column: 34,
																											Line:   102,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 37,
																												Line:   102,
																											},
																											File:   "zenoss.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 34,
																												Line:   102,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 45,
																												Line:   102,
																											},
																											File:   "zenoss.flux",
																											Source: "summary",
																											Start: ast.Position{
																												Column: 38,
																												Line:   102,
																											},
																										},
																									},
																									Name: "summary",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 43,
																										Line:   103,
																									},
																									File:   "zenoss.flux",
																									Source: "device: obj.device",
																									Start: ast.Position{
																										Column: 25,
																										Line:   103,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 31,
																											Line:   103,
																										},
																										File:   "zenoss.flux",
																										Source: "device",
																										Start: ast.Position{
																											Column: 25,
																											Line:   103,
																										},
																									},
																								},
																								Name: "device",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 43,
																											Line:   103,
																										},
																										File:   "zenoss.flux",
																										Source: "obj.device",
																										Start: ast.Position{
																											Column: 33,
																											Line:   103,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 36,
																												Line:   103,
																											},
																											File:   "zenoss.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 33,
																												Line:   103,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 43,
																												Line:   103,
																											},
																											File:   "zenoss.flux",
																											Source: "device",
																											Start: ast.Position{
																												Column: 37,
																												Line:   103,
																											},
																										},
																									},
																									Name: "device",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 49,
																										Line:   104,
																									},
																									File:   "zenoss.flux",
																									Source: "component: obj.component",
																									Start: ast.Position{
																										Column: 25,
																										Line:   104,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 34,
																											Line:   104,
																										},
																										File:   "zenoss.flux",
																										Source: "component",
																										Start: ast.Position{
																											Column: 25,
																											Line:   104,
																										},
																									},
																								},
																								Name: "component",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 49,
																											Line:   104,
																										},
																										File:   "zenoss.flux",
																										Source: "obj.component",
																										Start: ast.Position{
																											Column: 36,
																											Line:   104,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 39,
																												Line:   104,
																											},
																											File:   "zenoss.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 36,
																												Line:   104,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 49,
																												Line:   104,
																											},
																											File:   "zenoss.flux",
																											Source: "component",
																											Start: ast.Position{
																												Column: 40,
																												Line:   104,
																											},
																										},
																									},
																									Name: "component",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 47,
																										Line:   105,
																									},
																									File:   "zenoss.flux",
																									Source: "severity: obj.severity",
																									Start: ast.Position{
																										Column: 25,
																										Line:   105,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 33,
																											Line:   105,
																										},
																										File:   "zenoss.flux",
																										Source: "severity",
																										Start: ast.Position{
																											Column: 25,
																											Line:   105,
																										},
																									},
																								},
																								Name: "severity",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 47,
																											Line:   105,
																										},
																										File:   "zenoss.flux",
																										Source: "obj.severity",
																										Start: ast.Position{
																											Column: 35,
																											Line:   105,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 38,
																												Line:   105,
																											},
																											File:   "zenoss.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 35,
																												Line:   105,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 47,
																												Line:   105,
																											},
																											File:   "zenoss.flux",
																											Source: "severity",
																											Start: ast.Position{
																												Column: 39,
																												Line:   105,
																											},
																										},
																									},
																									Name: "severity",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 51,
																										Line:   106,
																									},
																									File:   "zenoss.flux",
																									Source: "eventClass: obj.eventClass",
																									Start: ast.Position{
																										Column: 25,
																										Line:   106,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 35,
																											Line:   106,
																										},
																										File:   "zenoss.flux",
																										Source: "eventClass",
																										Start: ast.Position{
																											Column: 25,
																											Line:   106,
																										},
																									},
																								},
																								Name: "eventClass",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 51,
																											Line:   106,
																										},
																										File:   "zenoss.flux",
																										Source: "obj.eventClass",
																										Start: ast.Position{
																											Column: 37,
																											Line:   106,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 40,
																												Line:   106,
																											},
																											File:   "zenoss.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 37,
																												Line:   106,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 51,
																												Line:   106,
																											},
																											File:   "zenoss.flux",
																											Source: "eventClass",
																											Start: ast.Position{
																												Column: 41,
																												Line:   106,
																											},
																										},
																									},
																									Name: "eventClass",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 57,
																										Line:   107,
																									},
																									File:   "zenoss.flux",
																									Source: "eventClassKey: obj.eventClassKey",
																									Start: ast.Position{
																										Column: 25,
																										Line:   107,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 38,
																											Line:   107,
																										},
																										File:   "zenoss.flux",
																										Source: "eventClassKey",
																										Start: ast.Position{
																											Column: 25,
																											Line:   107,
																										},
																									},
																								},
																								Name: "eventClassKey",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 57,
																											Line:   107,
																										},
																										File:   "zenoss.flux",
																										Source: "obj.eventClassKey",
																										Start: ast.Position{
																											Column: 40,
																											Line:   107,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 43,
																												Line:   107,
																											},
																											File:   "zenoss.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 40,
																												Line:   107,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 57,
																												Line:   107,
																											},
																											File:   "zenoss.flux",
																											Source: "eventClassKey",
																											Start: ast.Position{
																												Column: 44,
																												Line:   107,
																											},
																										},
																									},
																									Name: "eventClassKey",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 49,
																										Line:   108,
																									},
																									File:   "zenoss.flux",
																									Source: "collector: obj.collector",
																									Start: ast.Position{
																										Column: 25,
																										Line:   108,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 34,
																											Line:   108,
																										},
																										File:   "zenoss.flux",
																										Source: "collector",
																										Start: ast.Position{
																											Column: 25,
																											Line:   108,
																										},
																									},
																								},
																								Name: "collector",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 49,
																											Line:   108,
																										},
																										File:   "zenoss.flux",
																										Source: "obj.collector",
																										Start: ast.Position{
																											Column: 36,
																											Line:   108,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 39,
																												Line:   108,
																											},
																											File:   "zenoss.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 36,
																												Line:   108,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 49,
																												Line:   108,
																											},
																											File:   "zenoss.flux",
																											Source: "collector",
																											Start: ast.Position{
																												Column: 40,
																												Line:   108,
																											},
																										},
																									},
																									Name: "collector",
																								},
																								Rbrack: nil,
																							},
																						}, &ast.Property{
																							BaseNode: ast.BaseNode{
																								Comments: nil,
																								Errors:   nil,
																								Loc: &ast.SourceLocation{
																									End: ast.Position{
																										Column: 45,
																										Line:   109,
																									},
																									File:   "zenoss.flux",
																									Source: "message: obj.message",
																									Start: ast.Position{
																										Column: 25,
																										Line:   109,
																									},
																								},
																							},
																							Comma: nil,
																							Key: &ast.Identifier{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 32,
																											Line:   109,
																										},
																										File:   "zenoss.flux",
																										Source: "message",
																										Start: ast.Position{
																											Column: 25,
																											Line:   109,
																										},
																									},
																								},
																								Name: "message",
																							},
																							Separator: nil,
																							Value: &ast.MemberExpression{
																								BaseNode: ast.BaseNode{
																									Comments: nil,
																									Errors:   nil,
																									Loc: &ast.SourceLocation{
																										End: ast.Position{
																											Column: 45,
																											Line:   109,
																										},
																										File:   "zenoss.flux",
																										Source: "obj.message",
																										Start: ast.Position{
																											Column: 34,
																											Line:   109,
																										},
																									},
																								},
																								Lbrack: nil,
																								Object: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 37,
																												Line:   109,
																											},
																											File:   "zenoss.flux",
																											Source: "obj",
																											Start: ast.Position{
																												Column: 34,
																												Line:   109,
																											},
																										},
																									},
																									Name: "obj",
																								},
																								Property: &ast.Identifier{
																									BaseNode: ast.BaseNode{
																										Comments: nil,
																										Errors:   nil,
																										Loc: &ast.SourceLocation{
																											End: ast.Position{
																												Column: 45,
																												Line:   109,
																											},
																											File:   "zenoss.flux",
																											Source: "message",
																											Start: ast.Position{
																												Column: 38,
																												Line:   109,
																											},
																										},
																									},
																									Name: "message",
																								},
																								Rbrack: nil,
																							},
																						}},
																						Rbrace: nil,
																						With:   nil,
																					}},
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 22,
																								Line:   110,
																							},
																							File:   "zenoss.flux",
																							Source: "event(\n                        url: url,\n                        username: username,\n                        password: password,\n                        action: action,\n                        method: method,\n                        type: type,\n                        tid: tid,\n                        summary: obj.summary,\n                        device: obj.device,\n                        component: obj.component,\n                        severity: obj.severity,\n                        eventClass: obj.eventClass,\n                        eventClassKey: obj.eventClassKey,\n                        collector: obj.collector,\n                        message: obj.message,\n                    )",
																							Start: ast.Position{
																								Column: 29,
																								Line:   94,
																							},
																						},
																					},
																					Callee: &ast.Identifier{
																						BaseNode: ast.BaseNode{
																							Comments: nil,
																							Errors:   nil,
																							Loc: &ast.SourceLocation{
																								End: ast.Position{
																									Column: 34,
																									Line:   94,
																								},
																								File:   "zenoss.flux",
																								Source: "event",
																								Start: ast.Position{
																									Column: 29,
																									Line:   94,
																								},
																							},
																						},
																						Name: "event",
																					},
																					Lparen: nil,
																					Rparen: nil,
																				},
																				Operator: 2,
																				Right: &ast.IntegerLiteral{
																					BaseNode: ast.BaseNode{
																						Comments: nil,
																						Errors:   nil,
																						Loc: &ast.SourceLocation{
																							End: ast.Position{
																								Column: 28,
																								Line:   110,
																							},
																							File:   "zenoss.flux",
																							Source: "100",
																							Start: ast.Position{
																								Column: 25,
																								Line:   110,
																							},
																						},
																					},
																					Value: int64(100),
																				},
																			},
																		},
																	}},
																	Rbrace: nil,
																	With:   nil,
																}},
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 18,
																			Line:   111,
																		},
																		File:   "zenoss.flux",
																		Source: "string(\n                    v: 2 == event(\n                        url: url,\n                        username: username,\n                        password: password,\n                        action: action,\n                        method: method,\n                        type: type,\n                        tid: tid,\n                        summary: obj.summary,\n                        device: obj.device,\n                        component: obj.component,\n                        severity: obj.severity,\n                        eventClass: obj.eventClass,\n                        eventClassKey: obj.eventClassKey,\n                        collector: obj.collector,\n                        message: obj.message,\n                    ) / 100,\n                )",
																		Start: ast.Position{
																			Column: 24,
																			Line:   93,
																		},
																	},
																},
																Callee: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 30,
																				Line:   93,
																			},
																			File:   "zenoss.flux",
																			Source: "string",
																			Start: ast.Position{
																				Column: 24,
																				Line:   93,
																			},
																		},
																	},
																	Name: "string",
																},
																Lparen: nil,
																Rparen: nil,
															},
														}},
														Rbrace: nil,
														With: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 22,
																		Line:   92,
																	},
																	File:   "zenoss.flux",
																	Source: "r",
																	Start: ast.Position{
																		Column: 21,
																		Line:   92,
																	},
																},
															},
															Name: "r",
														},
													},
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 14,
																Line:   112,
															},
															File:   "zenoss.flux",
															Source: "return {r with\n                _sent: string(\n                    v: 2 == event(\n                        url: url,\n                        username: username,\n                        password: password,\n                        action: action,\n                        method: method,\n                        type: type,\n                        tid: tid,\n                        summary: obj.summary,\n                        device: obj.device,\n                        component: obj.component,\n                        severity: obj.severity,\n                        eventClass: obj.eventClass,\n                        eventClassKey: obj.eventClassKey,\n                        collector: obj.collector,\n                        message: obj.message,\n                    ) / 100,\n                ),\n            }",
															Start: ast.Position{
																Column: 13,
																Line:   92,
															},
														},
													},
												}},
												Lbrace: nil,
												Rbrace: nil,
											},
											Lparen: nil,
											Params: []*ast.Property{&ast.Property{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 15,
															Line:   89,
														},
														File:   "zenoss.flux",
														Source: "r",
														Start: ast.Position{
															Column: 14,
															Line:   89,
														},
													},
												},
												Comma: nil,
												Key: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 15,
																Line:   89,
															},
															File:   "zenoss.flux",
															Source: "r",
															Start: ast.Position{
																Column: 14,
																Line:   89,
															},
														},
													},
													Name: "r",
												},
												Separator: nil,
												Value:     nil,
											}},
											Rparan: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 6,
											Line:   114,
										},
										File:   "zenoss.flux",
										Source: "map(\n        fn: (r) => {\n            obj = mapFn(r: r)\n\n            return {r with\n                _sent: string(\n                    v: 2 == event(\n                        url: url,\n                        username: username,\n                        password: password,\n                        action: action,\n                        method: method,\n                        type: type,\n                        tid: tid,\n                        summary: obj.summary,\n                        device: obj.device,\n                        component: obj.component,\n                        severity: obj.severity,\n                        eventClass: obj.eventClass,\n                        eventClassKey: obj.eventClassKey,\n                        collector: obj.collector,\n                        message: obj.message,\n                    ) / 100,\n                ),\n            }\n        },\n    )",
										Start: ast.Position{
											Column: 8,
											Line:   88,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 11,
												Line:   88,
											},
											File:   "zenoss.flux",
											Source: "map",
											Start: ast.Position{
												Column: 8,
												Line:   88,
											},
										},
									},
									Name: "map",
								},
								Lparen: nil,
								Rparen: nil,
							},
						},
						Lparen: nil,
						Params: []*ast.Property{&ast.Property{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   87,
									},
									File:   "zenoss.flux",
									Source: "tables=<-",
									Start: ast.Position{
										Column: 18,
										Line:   87,
									},
								},
							},
							Comma: nil,
							Key: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   87,
										},
										File:   "zenoss.flux",
										Source: "tables",
										Start: ast.Position{
											Column: 18,
											Line:   87,
										},
									},
								},
								Name: "tables",
							},
							Separator: nil,
							Value: &ast.PipeLiteral{BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   87,
									},
									File:   "zenoss.flux",
									Source: "<-",
									Start: ast.Position{
										Column: 25,
										Line:   87,
									},
								},
							}},
						}},
						Rparan: nil,
					},
					Lparen: nil,
					Params: []*ast.Property{&ast.Property{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   87,
								},
								File:   "zenoss.flux",
								Source: "mapFn",
								Start: ast.Position{
									Column: 7,
									Line:   87,
								},
							},
						},
						Comma: nil,
						Key: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 12,
										Line:   87,
									},
									File:   "zenoss.flux",
									Source: "mapFn",
									Start: ast.Position{
										Column: 7,
										Line:   87,
									},
								},
							},
							Name: "mapFn",
						},
						Separator: nil,
						Value:     nil,
					}},
					Rparan: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 12,
								Line:   80,
							},
							File:   "zenoss.flux",
							Source: "url",
							Start: ast.Position{
								Column: 9,
								Line:   80,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   80,
								},
								File:   "zenoss.flux",
								Source: "url",
								Start: ast.Position{
									Column: 9,
									Line:   80,
								},
							},
						},
						Name: "url",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 17,
								Line:   81,
							},
							File:   "zenoss.flux",
							Source: "username",
							Start: ast.Position{
								Column: 9,
								Line:   81,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   81,
								},
								File:   "zenoss.flux",
								Source: "username",
								Start: ast.Position{
									Column: 9,
									Line:   81,
								},
							},
						},
						Name: "username",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 17,
								Line:   82,
							},
							File:   "zenoss.flux",
							Source: "password",
							Start: ast.Position{
								Column: 9,
								Line:   82,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   82,
								},
								File:   "zenoss.flux",
								Source: "password",
								Start: ast.Position{
									Column: 9,
									Line:   82,
								},
							},
						},
						Name: "password",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   83,
							},
							File:   "zenoss.flux",
							Source: "action=\"EventsRouter\"",
							Start: ast.Position{
								Column: 9,
								Line:   83,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   83,
								},
								File:   "zenoss.flux",
								Source: "action",
								Start: ast.Position{
									Column: 9,
									Line:   83,
								},
							},
						},
						Name: "action",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   83,
								},
								File:   "zenoss.flux",
								Source: "\"EventsRouter\"",
								Start: ast.Position{
									Column: 16,
									Line:   83,
								},
							},
						},
						Value: "EventsRouter",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 27,
								Line:   84,
							},
							File:   "zenoss.flux",
							Source: "method=\"add_event\"",
							Start: ast.Position{
								Column: 9,
								Line:   84,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   84,
								},
								File:   "zenoss.flux",
								Source: "method",
								Start: ast.Position{
									Column: 9,
									Line:   84,
								},
							},
						},
						Name: "method",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   84,
								},
								File:   "zenoss.flux",
								Source: "\"add_event\"",
								Start: ast.Position{
									Column: 16,
									Line:   84,
								},
							},
						},
						Value: "add_event",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 19,
								Line:   85,
							},
							File:   "zenoss.flux",
							Source: "type=\"rpc\"",
							Start: ast.Position{
								Column: 9,
								Line:   85,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   85,
								},
								File:   "zenoss.flux",
								Source: "type",
								Start: ast.Position{
									Column: 9,
									Line:   85,
								},
							},
						},
						Name: "type",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 19,
									Line:   85,
								},
								File:   "zenoss.flux",
								Source: "\"rpc\"",
								Start: ast.Position{
									Column: 14,
									Line:   85,
								},
							},
						},
						Value: "rpc",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   86,
							},
							File:   "zenoss.flux",
							Source: "tid=1",
							Start: ast.Position{
								Column: 9,
								Line:   86,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   86,
								},
								File:   "zenoss.flux",
								Source: "tid",
								Start: ast.Position{
									Column: 9,
									Line:   86,
								},
							},
						},
						Name: "tid",
					},
					Separator: nil,
					Value: &ast.IntegerLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   86,
								},
								File:   "zenoss.flux",
								Source: "1",
								Start: ast.Position{
									Column: 13,
									Line:   86,
								},
							},
						},
						Value: int64(1),
					},
				}},
				Rparan: nil,
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   4,
					},
					File:   "zenoss.flux",
					Source: "import \"http\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   4,
						},
						File:   "zenoss.flux",
						Source: "\"http\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "http",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   5,
					},
					File:   "zenoss.flux",
					Source: "import \"json\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   5,
						},
						File:   "zenoss.flux",
						Source: "\"json\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "json",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "zenoss.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   1,
					},
					File:   "zenoss.flux",
					Source: "package zenoss",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   1,
						},
						File:   "zenoss.flux",
						Source: "zenoss",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "zenoss",
			},
		},
	}},
	Package: "zenoss",
	Path:    "contrib/bonitoo-io/zenoss",
}
