// Package iotspaces implements the Azure ARM Iotspaces service API version 2017-10-01-preview.
//
// Use this API to manage the IoTSpaces service instances in your Azure subscription.
package iotspaces

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/gofrs/uuid"
)

const (
	// DefaultBaseURI is the default URI used for the service Iotspaces
	DefaultBaseURI = "https://management.azure.com"
)

// BaseClient is the base client for Iotspaces.
type BaseClient struct {
	autorest.Client
	BaseURI        string
	SubscriptionID uuid.UUID
}

// New creates an instance of the BaseClient client.
func New(subscriptionID uuid.UUID) BaseClient {
	return NewWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewWithBaseURI creates an instance of the BaseClient client using a custom endpoint.  Use this when interacting with
// an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewWithBaseURI(baseURI string, subscriptionID uuid.UUID) BaseClient {
	return BaseClient{
		Client:         autorest.NewClientWithUserAgent(UserAgent()),
		BaseURI:        baseURI,
		SubscriptionID: subscriptionID,
	}
}
