// Copyright 2019 The Kubernetes Authors.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package helmrepo

import (
	"testing"
	"time"

	. "github.com/onsi/ginkgo"
	. "github.com/onsi/gomega"

	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	"k8s.io/apimachinery/pkg/types"

	chnv1alpha1 "github.com/open-cluster-management/multicloud-operators-channel/pkg/apis/apps/v1"
	appv1alpha1 "github.com/open-cluster-management/multicloud-operators-subscription/pkg/apis/apps/v1"
)

var (
	repourl   = "https://kubernetes-charts.storage.googleapis.com/"
	sharedkey = types.NamespacedName{
		Name:      "test",
		Namespace: "default",
	}
	helmchn = &chnv1alpha1.Channel{
		ObjectMeta: metav1.ObjectMeta{
			Name:      sharedkey.Name,
			Namespace: sharedkey.Namespace,
		},
		Spec: chnv1alpha1.ChannelSpec{
			Type:     chnv1alpha1.ChannelTypeHelmRepo,
			Pathname: repourl,
		},
	}
	helmsub = &appv1alpha1.Subscription{
		ObjectMeta: metav1.ObjectMeta{
			Name:      sharedkey.Name,
			Namespace: sharedkey.Namespace,
		},
		Spec: appv1alpha1.SubscriptionSpec{
			Channel: sharedkey.String(),
			Package: "nginx-ingress",
		},
	}
	subitem = &appv1alpha1.SubscriberItem{
		Subscription: helmsub,
		Channel:      helmchn,
	}
)

func TestHelmSubscriber(t *testing.T) {
}

var _ = Describe("", func() {
	It("", func() {
		Expect(defaultSubscriber.SubscribeItem(subitem)).NotTo(HaveOccurred())

		time.Sleep(k8swait)

		Expect(defaultSubscriber.UnsubscribeItem(sharedkey)).NotTo(HaveOccurred())
	})
})
