package backup

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/recoveryservices/mgmt/2016-06-01/backup"

// AzureBackupServerEngine the backup engine type when Azure Backup Server is used to manage the backups.
type AzureBackupServerEngine struct {
	// FriendlyName - The friendly name of the backup engine.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// BackupManagementType - The type of backup management associated with the backup engine. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// RegistrationStatus - The status of the backup engine registration with the Recovery Services vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`
	// HealthStatus - The backup status of the backup engine.
	HealthStatus *string `json:"healthStatus,omitempty"`
	// CanReRegister - The flag indicating whether the backup engine be registered again, once the engine has been initially registered.
	CanReRegister *bool `json:"canReRegister,omitempty"`
	// BackupEngineID - The ID of the backup engine.
	BackupEngineID *string `json:"backupEngineId,omitempty"`
	// BackupEngineType - Possible values include: 'BackupEngineTypeBackupEngineBase', 'BackupEngineTypeAzureBackupServerEngine', 'BackupEngineTypeDpmBackupEngine'
	BackupEngineType EngineType `json:"backupEngineType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureBackupServerEngine.
func (abse AzureBackupServerEngine) MarshalJSON() ([]byte, error) {
	abse.BackupEngineType = BackupEngineTypeAzureBackupServerEngine
	objectMap := make(map[string]interface{})
	if abse.FriendlyName != nil {
		objectMap["friendlyName"] = abse.FriendlyName
	}
	if abse.BackupManagementType != "" {
		objectMap["backupManagementType"] = abse.BackupManagementType
	}
	if abse.RegistrationStatus != nil {
		objectMap["registrationStatus"] = abse.RegistrationStatus
	}
	if abse.HealthStatus != nil {
		objectMap["healthStatus"] = abse.HealthStatus
	}
	if abse.CanReRegister != nil {
		objectMap["canReRegister"] = abse.CanReRegister
	}
	if abse.BackupEngineID != nil {
		objectMap["backupEngineId"] = abse.BackupEngineID
	}
	if abse.BackupEngineType != "" {
		objectMap["backupEngineType"] = abse.BackupEngineType
	}
	return json.Marshal(objectMap)
}

// AsAzureBackupServerEngine is the BasicEngineBase implementation for AzureBackupServerEngine.
func (abse AzureBackupServerEngine) AsAzureBackupServerEngine() (*AzureBackupServerEngine, bool) {
	return &abse, true
}

// AsDpmBackupEngine is the BasicEngineBase implementation for AzureBackupServerEngine.
func (abse AzureBackupServerEngine) AsDpmBackupEngine() (*DpmBackupEngine, bool) {
	return nil, false
}

// AsEngineBase is the BasicEngineBase implementation for AzureBackupServerEngine.
func (abse AzureBackupServerEngine) AsEngineBase() (*EngineBase, bool) {
	return nil, false
}

// AsBasicEngineBase is the BasicEngineBase implementation for AzureBackupServerEngine.
func (abse AzureBackupServerEngine) AsBasicEngineBase() (BasicEngineBase, bool) {
	return &abse, true
}

// AzureIaaSClassicComputeVMContainer iaaS VM workload-specific backup item representing a classic-deployed
// virtual machine.
type AzureIaaSClassicComputeVMContainer struct {
	// VirtualMachineID - The fully qualified Resource Manager URL of the virtual machine represented by this Azure IaaS VM container.
	VirtualMachineID *string `json:"virtualMachineId,omitempty"`
	// VirtualMachineVersion - Specifies whether the container represents a classic or a Resource Manager-deployed virtual machine.
	VirtualMachineVersion *string `json:"virtualMachineVersion,omitempty"`
	// ResourceGroup - The resource group name associated with the Recovery Services vault.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
	// FriendlyName - Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// BackupManagementType - The backup management type for the container. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// RegistrationStatus - The container's registration status with the Recovery Services vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`
	// HealthStatus - The status of the container's health.
	HealthStatus *string `json:"healthStatus,omitempty"`
	// ContainerType - READ-ONLY; The type assigned to the container. The values to use for each of these properties are:<br/> 1. Compute Azure VM is Microsoft.Compute/virtualMachines<br/> 2. Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines<br/> 3. Windows machines (like Azure Backup Server and DPM) is Windows<br/> 4. Azure SQL instance is AzureSqlContainer.
	ContainerType *string `json:"containerType,omitempty"`
	// ProtectableObjectType - Possible values include: 'ProtectableObjectTypeProtectionContainer', 'ProtectableObjectTypeAzureSQLContainer', 'ProtectableObjectTypeIaaSVMContainer', 'ProtectableObjectTypeMABWindowsContainer', 'ProtectableObjectTypeMicrosoftComputevirtualMachines', 'ProtectableObjectTypeMicrosoftClassicComputevirtualMachines'
	ProtectableObjectType ProtectableObjectType `json:"protectableObjectType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureIaaSClassicComputeVMContainer.
func (aisccvc AzureIaaSClassicComputeVMContainer) MarshalJSON() ([]byte, error) {
	aisccvc.ProtectableObjectType = ProtectableObjectTypeMicrosoftClassicComputevirtualMachines
	objectMap := make(map[string]interface{})
	if aisccvc.VirtualMachineID != nil {
		objectMap["virtualMachineId"] = aisccvc.VirtualMachineID
	}
	if aisccvc.VirtualMachineVersion != nil {
		objectMap["virtualMachineVersion"] = aisccvc.VirtualMachineVersion
	}
	if aisccvc.ResourceGroup != nil {
		objectMap["resourceGroup"] = aisccvc.ResourceGroup
	}
	if aisccvc.FriendlyName != nil {
		objectMap["friendlyName"] = aisccvc.FriendlyName
	}
	if aisccvc.BackupManagementType != "" {
		objectMap["backupManagementType"] = aisccvc.BackupManagementType
	}
	if aisccvc.RegistrationStatus != nil {
		objectMap["registrationStatus"] = aisccvc.RegistrationStatus
	}
	if aisccvc.HealthStatus != nil {
		objectMap["healthStatus"] = aisccvc.HealthStatus
	}
	if aisccvc.ProtectableObjectType != "" {
		objectMap["protectableObjectType"] = aisccvc.ProtectableObjectType
	}
	return json.Marshal(objectMap)
}

// AsAzureSQLContainer is the BasicProtectionContainer implementation for AzureIaaSClassicComputeVMContainer.
func (aisccvc AzureIaaSClassicComputeVMContainer) AsAzureSQLContainer() (*AzureSQLContainer, bool) {
	return nil, false
}

// AsIaaSVMContainer is the BasicProtectionContainer implementation for AzureIaaSClassicComputeVMContainer.
func (aisccvc AzureIaaSClassicComputeVMContainer) AsIaaSVMContainer() (*IaaSVMContainer, bool) {
	return nil, false
}

// AsBasicIaaSVMContainer is the BasicProtectionContainer implementation for AzureIaaSClassicComputeVMContainer.
func (aisccvc AzureIaaSClassicComputeVMContainer) AsBasicIaaSVMContainer() (BasicIaaSVMContainer, bool) {
	return &aisccvc, true
}

// AsMabContainer is the BasicProtectionContainer implementation for AzureIaaSClassicComputeVMContainer.
func (aisccvc AzureIaaSClassicComputeVMContainer) AsMabContainer() (*MabContainer, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMContainer is the BasicProtectionContainer implementation for AzureIaaSClassicComputeVMContainer.
func (aisccvc AzureIaaSClassicComputeVMContainer) AsAzureIaaSComputeVMContainer() (*AzureIaaSComputeVMContainer, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMContainer is the BasicProtectionContainer implementation for AzureIaaSClassicComputeVMContainer.
func (aisccvc AzureIaaSClassicComputeVMContainer) AsAzureIaaSClassicComputeVMContainer() (*AzureIaaSClassicComputeVMContainer, bool) {
	return &aisccvc, true
}

// AsProtectionContainer is the BasicProtectionContainer implementation for AzureIaaSClassicComputeVMContainer.
func (aisccvc AzureIaaSClassicComputeVMContainer) AsProtectionContainer() (*ProtectionContainer, bool) {
	return nil, false
}

// AsBasicProtectionContainer is the BasicProtectionContainer implementation for AzureIaaSClassicComputeVMContainer.
func (aisccvc AzureIaaSClassicComputeVMContainer) AsBasicProtectionContainer() (BasicProtectionContainer, bool) {
	return &aisccvc, true
}

// AzureIaaSClassicComputeVMProtectableItem iaaS VM workload-specific backup item representing a classic
// VM.
type AzureIaaSClassicComputeVMProtectableItem struct {
	// VirtualMachineID - The fully qualified Resource Manager ID of the virtual machine.
	VirtualMachineID *string `json:"virtualMachineId,omitempty"`
	// BackupManagementType - The backup management type.
	BackupManagementType *string `json:"backupManagementType,omitempty"`
	// FriendlyName - The friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ProtectionState - The state of the back up item. Possible values include: 'ProtectionStatusInvalid', 'ProtectionStatusNotProtected', 'ProtectionStatusProtecting', 'ProtectionStatusProtected'
	ProtectionState ProtectionStatus `json:"protectionState,omitempty"`
	// ProtectableItemType - Possible values include: 'ProtectableItemTypeWorkloadProtectableItem', 'ProtectableItemTypeIaaSVMProtectableItem', 'ProtectableItemTypeMicrosoftComputevirtualMachines', 'ProtectableItemTypeMicrosoftClassicComputevirtualMachines'
	ProtectableItemType ProtectableItemType `json:"protectableItemType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureIaaSClassicComputeVMProtectableItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectableItem) MarshalJSON() ([]byte, error) {
	aisccvpi.ProtectableItemType = ProtectableItemTypeMicrosoftClassicComputevirtualMachines
	objectMap := make(map[string]interface{})
	if aisccvpi.VirtualMachineID != nil {
		objectMap["virtualMachineId"] = aisccvpi.VirtualMachineID
	}
	if aisccvpi.BackupManagementType != nil {
		objectMap["backupManagementType"] = aisccvpi.BackupManagementType
	}
	if aisccvpi.FriendlyName != nil {
		objectMap["friendlyName"] = aisccvpi.FriendlyName
	}
	if aisccvpi.ProtectionState != "" {
		objectMap["protectionState"] = aisccvpi.ProtectionState
	}
	if aisccvpi.ProtectableItemType != "" {
		objectMap["protectableItemType"] = aisccvpi.ProtectableItemType
	}
	return json.Marshal(objectMap)
}

// AsIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSClassicComputeVMProtectableItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectableItem) AsIaaSVMProtectableItem() (*IaaSVMProtectableItem, bool) {
	return nil, false
}

// AsBasicIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSClassicComputeVMProtectableItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectableItem) AsBasicIaaSVMProtectableItem() (BasicIaaSVMProtectableItem, bool) {
	return &aisccvpi, true
}

// AsAzureIaaSComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSClassicComputeVMProtectableItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectableItem) AsAzureIaaSComputeVMProtectableItem() (*AzureIaaSComputeVMProtectableItem, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSClassicComputeVMProtectableItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectableItem) AsAzureIaaSClassicComputeVMProtectableItem() (*AzureIaaSClassicComputeVMProtectableItem, bool) {
	return &aisccvpi, true
}

// AsWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSClassicComputeVMProtectableItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectableItem) AsWorkloadProtectableItem() (*WorkloadProtectableItem, bool) {
	return nil, false
}

// AsBasicWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSClassicComputeVMProtectableItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectableItem) AsBasicWorkloadProtectableItem() (BasicWorkloadProtectableItem, bool) {
	return &aisccvpi, true
}

// AzureIaaSClassicComputeVMProtectedItem iaaS VM workload-specific backup item representing the classic
// VM.
type AzureIaaSClassicComputeVMProtectedItem struct {
	// FriendlyName - The friendly name of the VM represented by this backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// VirtualMachineID - The fully qualified Resource Manager ID of the virtual machine represented by this item.
	VirtualMachineID *string `json:"virtualMachineId,omitempty"`
	// ProtectionStatus - The backup status of this backup item.
	ProtectionStatus *string `json:"protectionStatus,omitempty"`
	// ProtectionState - The backup state of this backup item. Possible values include: 'ProtectionStateInvalid', 'ProtectionStateIRPending', 'ProtectionStateProtected', 'ProtectionStateProtectionError', 'ProtectionStateProtectionStopped', 'ProtectionStateProtectionPaused'
	ProtectionState ProtectionState `json:"protectionState,omitempty"`
	// LastBackupStatus - The last backup operation status. The possible values are: Healthy or Unhealthy.
	LastBackupStatus *string `json:"lastBackupStatus,omitempty"`
	// LastBackupTime - The timestamp of the last backup operation for this backup item.
	LastBackupTime *date.Time `json:"lastBackupTime,omitempty"`
	// ExtendedInfo - Additional information for this backup item.
	ExtendedInfo *AzureIaaSVMProtectedItemExtendedInfo `json:"extendedInfo,omitempty"`
	// BackupManagementType - The backup management type associated with the backup item. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// WorkloadType - The workload type for this item. Possible values include: 'Invalid', 'VM', 'FileFolder', 'AzureSQLDb', 'SQLDB', 'Exchange', 'Sharepoint', 'DPMUnknown'
	WorkloadType DataSourceType `json:"workloadType,omitempty"`
	// SourceResourceID - The ID of the resource to be backed up.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
	// PolicyID - The ID of the backup policy associated with this backup item.
	PolicyID *string `json:"policyId,omitempty"`
	// LastRecoveryPoint - The timestamp when the most recent backup copy was created for this backup item.
	LastRecoveryPoint *date.Time `json:"lastRecoveryPoint,omitempty"`
	// ProtectedItemType - Possible values include: 'ProtectedItemTypeProtectedItem', 'ProtectedItemTypeAzureIaaSVMProtectedItem', 'ProtectedItemTypeMabFileFolderProtectedItem', 'ProtectedItemTypeMicrosoftSqlserversdatabases', 'ProtectedItemTypeMicrosoftComputevirtualMachines', 'ProtectedItemTypeMicrosoftClassicComputevirtualMachines'
	ProtectedItemType ProtectedItemType `json:"protectedItemType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureIaaSClassicComputeVMProtectedItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectedItem) MarshalJSON() ([]byte, error) {
	aisccvpi.ProtectedItemType = ProtectedItemTypeMicrosoftClassicComputevirtualMachines
	objectMap := make(map[string]interface{})
	if aisccvpi.FriendlyName != nil {
		objectMap["friendlyName"] = aisccvpi.FriendlyName
	}
	if aisccvpi.VirtualMachineID != nil {
		objectMap["virtualMachineId"] = aisccvpi.VirtualMachineID
	}
	if aisccvpi.ProtectionStatus != nil {
		objectMap["protectionStatus"] = aisccvpi.ProtectionStatus
	}
	if aisccvpi.ProtectionState != "" {
		objectMap["protectionState"] = aisccvpi.ProtectionState
	}
	if aisccvpi.LastBackupStatus != nil {
		objectMap["lastBackupStatus"] = aisccvpi.LastBackupStatus
	}
	if aisccvpi.LastBackupTime != nil {
		objectMap["lastBackupTime"] = aisccvpi.LastBackupTime
	}
	if aisccvpi.ExtendedInfo != nil {
		objectMap["extendedInfo"] = aisccvpi.ExtendedInfo
	}
	if aisccvpi.BackupManagementType != "" {
		objectMap["backupManagementType"] = aisccvpi.BackupManagementType
	}
	if aisccvpi.WorkloadType != "" {
		objectMap["workloadType"] = aisccvpi.WorkloadType
	}
	if aisccvpi.SourceResourceID != nil {
		objectMap["sourceResourceId"] = aisccvpi.SourceResourceID
	}
	if aisccvpi.PolicyID != nil {
		objectMap["policyId"] = aisccvpi.PolicyID
	}
	if aisccvpi.LastRecoveryPoint != nil {
		objectMap["lastRecoveryPoint"] = aisccvpi.LastRecoveryPoint
	}
	if aisccvpi.ProtectedItemType != "" {
		objectMap["protectedItemType"] = aisccvpi.ProtectedItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureIaaSVMProtectedItem is the BasicProtectedItem implementation for AzureIaaSClassicComputeVMProtectedItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectedItem) AsAzureIaaSVMProtectedItem() (*AzureIaaSVMProtectedItem, bool) {
	return nil, false
}

// AsBasicAzureIaaSVMProtectedItem is the BasicProtectedItem implementation for AzureIaaSClassicComputeVMProtectedItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectedItem) AsBasicAzureIaaSVMProtectedItem() (BasicAzureIaaSVMProtectedItem, bool) {
	return &aisccvpi, true
}

// AsMabFileFolderProtectedItem is the BasicProtectedItem implementation for AzureIaaSClassicComputeVMProtectedItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectedItem) AsMabFileFolderProtectedItem() (*MabFileFolderProtectedItem, bool) {
	return nil, false
}

// AsAzureSQLProtectedItem is the BasicProtectedItem implementation for AzureIaaSClassicComputeVMProtectedItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectedItem) AsAzureSQLProtectedItem() (*AzureSQLProtectedItem, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMProtectedItem is the BasicProtectedItem implementation for AzureIaaSClassicComputeVMProtectedItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectedItem) AsAzureIaaSComputeVMProtectedItem() (*AzureIaaSComputeVMProtectedItem, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMProtectedItem is the BasicProtectedItem implementation for AzureIaaSClassicComputeVMProtectedItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectedItem) AsAzureIaaSClassicComputeVMProtectedItem() (*AzureIaaSClassicComputeVMProtectedItem, bool) {
	return &aisccvpi, true
}

// AsProtectedItem is the BasicProtectedItem implementation for AzureIaaSClassicComputeVMProtectedItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectedItem) AsProtectedItem() (*ProtectedItem, bool) {
	return nil, false
}

// AsBasicProtectedItem is the BasicProtectedItem implementation for AzureIaaSClassicComputeVMProtectedItem.
func (aisccvpi AzureIaaSClassicComputeVMProtectedItem) AsBasicProtectedItem() (BasicProtectedItem, bool) {
	return &aisccvpi, true
}

// AzureIaaSComputeVMContainer iaaS VM workload-specific backup item representing a Resource
// Manager-deployed virtual machine.
type AzureIaaSComputeVMContainer struct {
	// VirtualMachineID - The fully qualified Resource Manager URL of the virtual machine represented by this Azure IaaS VM container.
	VirtualMachineID *string `json:"virtualMachineId,omitempty"`
	// VirtualMachineVersion - Specifies whether the container represents a classic or a Resource Manager-deployed virtual machine.
	VirtualMachineVersion *string `json:"virtualMachineVersion,omitempty"`
	// ResourceGroup - The resource group name associated with the Recovery Services vault.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
	// FriendlyName - Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// BackupManagementType - The backup management type for the container. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// RegistrationStatus - The container's registration status with the Recovery Services vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`
	// HealthStatus - The status of the container's health.
	HealthStatus *string `json:"healthStatus,omitempty"`
	// ContainerType - READ-ONLY; The type assigned to the container. The values to use for each of these properties are:<br/> 1. Compute Azure VM is Microsoft.Compute/virtualMachines<br/> 2. Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines<br/> 3. Windows machines (like Azure Backup Server and DPM) is Windows<br/> 4. Azure SQL instance is AzureSqlContainer.
	ContainerType *string `json:"containerType,omitempty"`
	// ProtectableObjectType - Possible values include: 'ProtectableObjectTypeProtectionContainer', 'ProtectableObjectTypeAzureSQLContainer', 'ProtectableObjectTypeIaaSVMContainer', 'ProtectableObjectTypeMABWindowsContainer', 'ProtectableObjectTypeMicrosoftComputevirtualMachines', 'ProtectableObjectTypeMicrosoftClassicComputevirtualMachines'
	ProtectableObjectType ProtectableObjectType `json:"protectableObjectType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureIaaSComputeVMContainer.
func (aiscvc AzureIaaSComputeVMContainer) MarshalJSON() ([]byte, error) {
	aiscvc.ProtectableObjectType = ProtectableObjectTypeMicrosoftComputevirtualMachines
	objectMap := make(map[string]interface{})
	if aiscvc.VirtualMachineID != nil {
		objectMap["virtualMachineId"] = aiscvc.VirtualMachineID
	}
	if aiscvc.VirtualMachineVersion != nil {
		objectMap["virtualMachineVersion"] = aiscvc.VirtualMachineVersion
	}
	if aiscvc.ResourceGroup != nil {
		objectMap["resourceGroup"] = aiscvc.ResourceGroup
	}
	if aiscvc.FriendlyName != nil {
		objectMap["friendlyName"] = aiscvc.FriendlyName
	}
	if aiscvc.BackupManagementType != "" {
		objectMap["backupManagementType"] = aiscvc.BackupManagementType
	}
	if aiscvc.RegistrationStatus != nil {
		objectMap["registrationStatus"] = aiscvc.RegistrationStatus
	}
	if aiscvc.HealthStatus != nil {
		objectMap["healthStatus"] = aiscvc.HealthStatus
	}
	if aiscvc.ProtectableObjectType != "" {
		objectMap["protectableObjectType"] = aiscvc.ProtectableObjectType
	}
	return json.Marshal(objectMap)
}

// AsAzureSQLContainer is the BasicProtectionContainer implementation for AzureIaaSComputeVMContainer.
func (aiscvc AzureIaaSComputeVMContainer) AsAzureSQLContainer() (*AzureSQLContainer, bool) {
	return nil, false
}

// AsIaaSVMContainer is the BasicProtectionContainer implementation for AzureIaaSComputeVMContainer.
func (aiscvc AzureIaaSComputeVMContainer) AsIaaSVMContainer() (*IaaSVMContainer, bool) {
	return nil, false
}

// AsBasicIaaSVMContainer is the BasicProtectionContainer implementation for AzureIaaSComputeVMContainer.
func (aiscvc AzureIaaSComputeVMContainer) AsBasicIaaSVMContainer() (BasicIaaSVMContainer, bool) {
	return &aiscvc, true
}

// AsMabContainer is the BasicProtectionContainer implementation for AzureIaaSComputeVMContainer.
func (aiscvc AzureIaaSComputeVMContainer) AsMabContainer() (*MabContainer, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMContainer is the BasicProtectionContainer implementation for AzureIaaSComputeVMContainer.
func (aiscvc AzureIaaSComputeVMContainer) AsAzureIaaSComputeVMContainer() (*AzureIaaSComputeVMContainer, bool) {
	return &aiscvc, true
}

// AsAzureIaaSClassicComputeVMContainer is the BasicProtectionContainer implementation for AzureIaaSComputeVMContainer.
func (aiscvc AzureIaaSComputeVMContainer) AsAzureIaaSClassicComputeVMContainer() (*AzureIaaSClassicComputeVMContainer, bool) {
	return nil, false
}

// AsProtectionContainer is the BasicProtectionContainer implementation for AzureIaaSComputeVMContainer.
func (aiscvc AzureIaaSComputeVMContainer) AsProtectionContainer() (*ProtectionContainer, bool) {
	return nil, false
}

// AsBasicProtectionContainer is the BasicProtectionContainer implementation for AzureIaaSComputeVMContainer.
func (aiscvc AzureIaaSComputeVMContainer) AsBasicProtectionContainer() (BasicProtectionContainer, bool) {
	return &aiscvc, true
}

// AzureIaaSComputeVMProtectableItem iaaS VM workload-specific backup item representing a Resource Manager
// VM.
type AzureIaaSComputeVMProtectableItem struct {
	// VirtualMachineID - The fully qualified Resource Manager ID of the virtual machine.
	VirtualMachineID *string `json:"virtualMachineId,omitempty"`
	// BackupManagementType - The backup management type.
	BackupManagementType *string `json:"backupManagementType,omitempty"`
	// FriendlyName - The friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ProtectionState - The state of the back up item. Possible values include: 'ProtectionStatusInvalid', 'ProtectionStatusNotProtected', 'ProtectionStatusProtecting', 'ProtectionStatusProtected'
	ProtectionState ProtectionStatus `json:"protectionState,omitempty"`
	// ProtectableItemType - Possible values include: 'ProtectableItemTypeWorkloadProtectableItem', 'ProtectableItemTypeIaaSVMProtectableItem', 'ProtectableItemTypeMicrosoftComputevirtualMachines', 'ProtectableItemTypeMicrosoftClassicComputevirtualMachines'
	ProtectableItemType ProtectableItemType `json:"protectableItemType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureIaaSComputeVMProtectableItem.
func (aiscvpi AzureIaaSComputeVMProtectableItem) MarshalJSON() ([]byte, error) {
	aiscvpi.ProtectableItemType = ProtectableItemTypeMicrosoftComputevirtualMachines
	objectMap := make(map[string]interface{})
	if aiscvpi.VirtualMachineID != nil {
		objectMap["virtualMachineId"] = aiscvpi.VirtualMachineID
	}
	if aiscvpi.BackupManagementType != nil {
		objectMap["backupManagementType"] = aiscvpi.BackupManagementType
	}
	if aiscvpi.FriendlyName != nil {
		objectMap["friendlyName"] = aiscvpi.FriendlyName
	}
	if aiscvpi.ProtectionState != "" {
		objectMap["protectionState"] = aiscvpi.ProtectionState
	}
	if aiscvpi.ProtectableItemType != "" {
		objectMap["protectableItemType"] = aiscvpi.ProtectableItemType
	}
	return json.Marshal(objectMap)
}

// AsIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSComputeVMProtectableItem.
func (aiscvpi AzureIaaSComputeVMProtectableItem) AsIaaSVMProtectableItem() (*IaaSVMProtectableItem, bool) {
	return nil, false
}

// AsBasicIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSComputeVMProtectableItem.
func (aiscvpi AzureIaaSComputeVMProtectableItem) AsBasicIaaSVMProtectableItem() (BasicIaaSVMProtectableItem, bool) {
	return &aiscvpi, true
}

// AsAzureIaaSComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSComputeVMProtectableItem.
func (aiscvpi AzureIaaSComputeVMProtectableItem) AsAzureIaaSComputeVMProtectableItem() (*AzureIaaSComputeVMProtectableItem, bool) {
	return &aiscvpi, true
}

// AsAzureIaaSClassicComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSComputeVMProtectableItem.
func (aiscvpi AzureIaaSComputeVMProtectableItem) AsAzureIaaSClassicComputeVMProtectableItem() (*AzureIaaSClassicComputeVMProtectableItem, bool) {
	return nil, false
}

// AsWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSComputeVMProtectableItem.
func (aiscvpi AzureIaaSComputeVMProtectableItem) AsWorkloadProtectableItem() (*WorkloadProtectableItem, bool) {
	return nil, false
}

// AsBasicWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for AzureIaaSComputeVMProtectableItem.
func (aiscvpi AzureIaaSComputeVMProtectableItem) AsBasicWorkloadProtectableItem() (BasicWorkloadProtectableItem, bool) {
	return &aiscvpi, true
}

// AzureIaaSComputeVMProtectedItem iaaS VM workload-specific backup item representing the Resource Manager
// VM.
type AzureIaaSComputeVMProtectedItem struct {
	// FriendlyName - The friendly name of the VM represented by this backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// VirtualMachineID - The fully qualified Resource Manager ID of the virtual machine represented by this item.
	VirtualMachineID *string `json:"virtualMachineId,omitempty"`
	// ProtectionStatus - The backup status of this backup item.
	ProtectionStatus *string `json:"protectionStatus,omitempty"`
	// ProtectionState - The backup state of this backup item. Possible values include: 'ProtectionStateInvalid', 'ProtectionStateIRPending', 'ProtectionStateProtected', 'ProtectionStateProtectionError', 'ProtectionStateProtectionStopped', 'ProtectionStateProtectionPaused'
	ProtectionState ProtectionState `json:"protectionState,omitempty"`
	// LastBackupStatus - The last backup operation status. The possible values are: Healthy or Unhealthy.
	LastBackupStatus *string `json:"lastBackupStatus,omitempty"`
	// LastBackupTime - The timestamp of the last backup operation for this backup item.
	LastBackupTime *date.Time `json:"lastBackupTime,omitempty"`
	// ExtendedInfo - Additional information for this backup item.
	ExtendedInfo *AzureIaaSVMProtectedItemExtendedInfo `json:"extendedInfo,omitempty"`
	// BackupManagementType - The backup management type associated with the backup item. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// WorkloadType - The workload type for this item. Possible values include: 'Invalid', 'VM', 'FileFolder', 'AzureSQLDb', 'SQLDB', 'Exchange', 'Sharepoint', 'DPMUnknown'
	WorkloadType DataSourceType `json:"workloadType,omitempty"`
	// SourceResourceID - The ID of the resource to be backed up.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
	// PolicyID - The ID of the backup policy associated with this backup item.
	PolicyID *string `json:"policyId,omitempty"`
	// LastRecoveryPoint - The timestamp when the most recent backup copy was created for this backup item.
	LastRecoveryPoint *date.Time `json:"lastRecoveryPoint,omitempty"`
	// ProtectedItemType - Possible values include: 'ProtectedItemTypeProtectedItem', 'ProtectedItemTypeAzureIaaSVMProtectedItem', 'ProtectedItemTypeMabFileFolderProtectedItem', 'ProtectedItemTypeMicrosoftSqlserversdatabases', 'ProtectedItemTypeMicrosoftComputevirtualMachines', 'ProtectedItemTypeMicrosoftClassicComputevirtualMachines'
	ProtectedItemType ProtectedItemType `json:"protectedItemType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureIaaSComputeVMProtectedItem.
func (aiscvpi AzureIaaSComputeVMProtectedItem) MarshalJSON() ([]byte, error) {
	aiscvpi.ProtectedItemType = ProtectedItemTypeMicrosoftComputevirtualMachines
	objectMap := make(map[string]interface{})
	if aiscvpi.FriendlyName != nil {
		objectMap["friendlyName"] = aiscvpi.FriendlyName
	}
	if aiscvpi.VirtualMachineID != nil {
		objectMap["virtualMachineId"] = aiscvpi.VirtualMachineID
	}
	if aiscvpi.ProtectionStatus != nil {
		objectMap["protectionStatus"] = aiscvpi.ProtectionStatus
	}
	if aiscvpi.ProtectionState != "" {
		objectMap["protectionState"] = aiscvpi.ProtectionState
	}
	if aiscvpi.LastBackupStatus != nil {
		objectMap["lastBackupStatus"] = aiscvpi.LastBackupStatus
	}
	if aiscvpi.LastBackupTime != nil {
		objectMap["lastBackupTime"] = aiscvpi.LastBackupTime
	}
	if aiscvpi.ExtendedInfo != nil {
		objectMap["extendedInfo"] = aiscvpi.ExtendedInfo
	}
	if aiscvpi.BackupManagementType != "" {
		objectMap["backupManagementType"] = aiscvpi.BackupManagementType
	}
	if aiscvpi.WorkloadType != "" {
		objectMap["workloadType"] = aiscvpi.WorkloadType
	}
	if aiscvpi.SourceResourceID != nil {
		objectMap["sourceResourceId"] = aiscvpi.SourceResourceID
	}
	if aiscvpi.PolicyID != nil {
		objectMap["policyId"] = aiscvpi.PolicyID
	}
	if aiscvpi.LastRecoveryPoint != nil {
		objectMap["lastRecoveryPoint"] = aiscvpi.LastRecoveryPoint
	}
	if aiscvpi.ProtectedItemType != "" {
		objectMap["protectedItemType"] = aiscvpi.ProtectedItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureIaaSVMProtectedItem is the BasicProtectedItem implementation for AzureIaaSComputeVMProtectedItem.
func (aiscvpi AzureIaaSComputeVMProtectedItem) AsAzureIaaSVMProtectedItem() (*AzureIaaSVMProtectedItem, bool) {
	return nil, false
}

// AsBasicAzureIaaSVMProtectedItem is the BasicProtectedItem implementation for AzureIaaSComputeVMProtectedItem.
func (aiscvpi AzureIaaSComputeVMProtectedItem) AsBasicAzureIaaSVMProtectedItem() (BasicAzureIaaSVMProtectedItem, bool) {
	return &aiscvpi, true
}

// AsMabFileFolderProtectedItem is the BasicProtectedItem implementation for AzureIaaSComputeVMProtectedItem.
func (aiscvpi AzureIaaSComputeVMProtectedItem) AsMabFileFolderProtectedItem() (*MabFileFolderProtectedItem, bool) {
	return nil, false
}

// AsAzureSQLProtectedItem is the BasicProtectedItem implementation for AzureIaaSComputeVMProtectedItem.
func (aiscvpi AzureIaaSComputeVMProtectedItem) AsAzureSQLProtectedItem() (*AzureSQLProtectedItem, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMProtectedItem is the BasicProtectedItem implementation for AzureIaaSComputeVMProtectedItem.
func (aiscvpi AzureIaaSComputeVMProtectedItem) AsAzureIaaSComputeVMProtectedItem() (*AzureIaaSComputeVMProtectedItem, bool) {
	return &aiscvpi, true
}

// AsAzureIaaSClassicComputeVMProtectedItem is the BasicProtectedItem implementation for AzureIaaSComputeVMProtectedItem.
func (aiscvpi AzureIaaSComputeVMProtectedItem) AsAzureIaaSClassicComputeVMProtectedItem() (*AzureIaaSClassicComputeVMProtectedItem, bool) {
	return nil, false
}

// AsProtectedItem is the BasicProtectedItem implementation for AzureIaaSComputeVMProtectedItem.
func (aiscvpi AzureIaaSComputeVMProtectedItem) AsProtectedItem() (*ProtectedItem, bool) {
	return nil, false
}

// AsBasicProtectedItem is the BasicProtectedItem implementation for AzureIaaSComputeVMProtectedItem.
func (aiscvpi AzureIaaSComputeVMProtectedItem) AsBasicProtectedItem() (BasicProtectedItem, bool) {
	return &aiscvpi, true
}

// AzureIaaSVMErrorInfo azure IaaS VM workload-specific error information.
type AzureIaaSVMErrorInfo struct {
	// ErrorCode - Error code.
	ErrorCode *int32 `json:"errorCode,omitempty"`
	// ErrorTitle - Title: typically, the entity associated the error.
	ErrorTitle *string `json:"errorTitle,omitempty"`
	// ErrorString - Localized error string.
	ErrorString *string `json:"errorString,omitempty"`
	// Recommendations - List of localized recommendations for the error string.
	Recommendations *[]string `json:"recommendations,omitempty"`
}

// AzureIaaSVMJob the Azure IaaS VM workload-specific job object.
type AzureIaaSVMJob struct {
	// Duration - The time that elapsed during the execution of this job.
	Duration *string `json:"duration,omitempty"`
	// ActionsInfo - Gets or sets the state, or actions, applicable on this job. Examples of the actions are: Cancel or Retry.
	ActionsInfo *[]JobSupportedAction `json:"actionsInfo,omitempty"`
	// ErrorDetails - Error details about this job.
	ErrorDetails *[]AzureIaaSVMErrorInfo `json:"errorDetails,omitempty"`
	// VirtualMachineVersion - Specifies whether the backup item is a Classic VM or a Resource Manager VM.
	VirtualMachineVersion *string `json:"virtualMachineVersion,omitempty"`
	// ExtendedInfo - Additional information for this job.
	ExtendedInfo *AzureIaaSVMJobExtendedInfo `json:"extendedInfo,omitempty"`
	// EntityFriendlyName - The friendly name of the entity on which the current job is executing.
	EntityFriendlyName *string `json:"entityFriendlyName,omitempty"`
	// BackupManagementType - The backup management type for the current job. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// Operation - The operation name.
	Operation *string `json:"operation,omitempty"`
	// Status - The job status.
	Status *string `json:"status,omitempty"`
	// StartTime - The start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The end time.
	EndTime *date.Time `json:"endTime,omitempty"`
	// ActivityID - ActivityId of job.
	ActivityID *string `json:"activityId,omitempty"`
	// JobType - Possible values include: 'JobTypeJob', 'JobTypeAzureIaaSVMJob', 'JobTypeDpmJob', 'JobTypeMabJob'
	JobType JobType `json:"jobType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureIaaSVMJob.
func (aisj AzureIaaSVMJob) MarshalJSON() ([]byte, error) {
	aisj.JobType = JobTypeAzureIaaSVMJob
	objectMap := make(map[string]interface{})
	if aisj.Duration != nil {
		objectMap["duration"] = aisj.Duration
	}
	if aisj.ActionsInfo != nil {
		objectMap["actionsInfo"] = aisj.ActionsInfo
	}
	if aisj.ErrorDetails != nil {
		objectMap["errorDetails"] = aisj.ErrorDetails
	}
	if aisj.VirtualMachineVersion != nil {
		objectMap["virtualMachineVersion"] = aisj.VirtualMachineVersion
	}
	if aisj.ExtendedInfo != nil {
		objectMap["extendedInfo"] = aisj.ExtendedInfo
	}
	if aisj.EntityFriendlyName != nil {
		objectMap["entityFriendlyName"] = aisj.EntityFriendlyName
	}
	if aisj.BackupManagementType != "" {
		objectMap["backupManagementType"] = aisj.BackupManagementType
	}
	if aisj.Operation != nil {
		objectMap["operation"] = aisj.Operation
	}
	if aisj.Status != nil {
		objectMap["status"] = aisj.Status
	}
	if aisj.StartTime != nil {
		objectMap["startTime"] = aisj.StartTime
	}
	if aisj.EndTime != nil {
		objectMap["endTime"] = aisj.EndTime
	}
	if aisj.ActivityID != nil {
		objectMap["activityId"] = aisj.ActivityID
	}
	if aisj.JobType != "" {
		objectMap["jobType"] = aisj.JobType
	}
	return json.Marshal(objectMap)
}

// AsAzureIaaSVMJob is the BasicJob implementation for AzureIaaSVMJob.
func (aisj AzureIaaSVMJob) AsAzureIaaSVMJob() (*AzureIaaSVMJob, bool) {
	return &aisj, true
}

// AsDpmJob is the BasicJob implementation for AzureIaaSVMJob.
func (aisj AzureIaaSVMJob) AsDpmJob() (*DpmJob, bool) {
	return nil, false
}

// AsMabJob is the BasicJob implementation for AzureIaaSVMJob.
func (aisj AzureIaaSVMJob) AsMabJob() (*MabJob, bool) {
	return nil, false
}

// AsJob is the BasicJob implementation for AzureIaaSVMJob.
func (aisj AzureIaaSVMJob) AsJob() (*Job, bool) {
	return nil, false
}

// AsBasicJob is the BasicJob implementation for AzureIaaSVMJob.
func (aisj AzureIaaSVMJob) AsBasicJob() (BasicJob, bool) {
	return &aisj, true
}

// AzureIaaSVMJobExtendedInfo additional information for the Azure IaaS VM workload-specific job.
type AzureIaaSVMJobExtendedInfo struct {
	// TasksList - List of tasks associated with this job.
	TasksList *[]AzureIaaSVMJobTaskDetails `json:"tasksList,omitempty"`
	// PropertyBag - Job properties.
	PropertyBag map[string]*string `json:"propertyBag"`
	// ProgressPercentage - Indicates progress of the job. Null if it has not started or completed.
	ProgressPercentage *float64 `json:"progressPercentage,omitempty"`
	// DynamicErrorMessage - Non-localized error message for job execution.
	DynamicErrorMessage *string `json:"dynamicErrorMessage,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureIaaSVMJobExtendedInfo.
func (aisjei AzureIaaSVMJobExtendedInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if aisjei.TasksList != nil {
		objectMap["tasksList"] = aisjei.TasksList
	}
	if aisjei.PropertyBag != nil {
		objectMap["propertyBag"] = aisjei.PropertyBag
	}
	if aisjei.ProgressPercentage != nil {
		objectMap["progressPercentage"] = aisjei.ProgressPercentage
	}
	if aisjei.DynamicErrorMessage != nil {
		objectMap["dynamicErrorMessage"] = aisjei.DynamicErrorMessage
	}
	return json.Marshal(objectMap)
}

// AzureIaaSVMJobTaskDetails azure IaaS VM workload-specific job task details.
type AzureIaaSVMJobTaskDetails struct {
	// TaskID - The task display name.
	TaskID *string `json:"taskId,omitempty"`
	// StartTime - The start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The end time.
	EndTime *date.Time `json:"endTime,omitempty"`
	// InstanceID - The instance ID.
	InstanceID *string `json:"instanceId,omitempty"`
	// Duration - The time elapsed for the task.
	Duration *string `json:"duration,omitempty"`
	// Status - The status.
	Status *string `json:"status,omitempty"`
	// ProgressPercentage - The progress of the task, as a percentage.
	ProgressPercentage *float64 `json:"progressPercentage,omitempty"`
}

// BasicAzureIaaSVMProtectedItem this Azure VM workload-specific (also known as IaaS VM workload-specific) backup item
// has been backed up.
type BasicAzureIaaSVMProtectedItem interface {
	AsAzureIaaSComputeVMProtectedItem() (*AzureIaaSComputeVMProtectedItem, bool)
	AsAzureIaaSClassicComputeVMProtectedItem() (*AzureIaaSClassicComputeVMProtectedItem, bool)
	AsAzureIaaSVMProtectedItem() (*AzureIaaSVMProtectedItem, bool)
}

// AzureIaaSVMProtectedItem this Azure VM workload-specific (also known as IaaS VM workload-specific) backup
// item has been backed up.
type AzureIaaSVMProtectedItem struct {
	// FriendlyName - The friendly name of the VM represented by this backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// VirtualMachineID - The fully qualified Resource Manager ID of the virtual machine represented by this item.
	VirtualMachineID *string `json:"virtualMachineId,omitempty"`
	// ProtectionStatus - The backup status of this backup item.
	ProtectionStatus *string `json:"protectionStatus,omitempty"`
	// ProtectionState - The backup state of this backup item. Possible values include: 'ProtectionStateInvalid', 'ProtectionStateIRPending', 'ProtectionStateProtected', 'ProtectionStateProtectionError', 'ProtectionStateProtectionStopped', 'ProtectionStateProtectionPaused'
	ProtectionState ProtectionState `json:"protectionState,omitempty"`
	// LastBackupStatus - The last backup operation status. The possible values are: Healthy or Unhealthy.
	LastBackupStatus *string `json:"lastBackupStatus,omitempty"`
	// LastBackupTime - The timestamp of the last backup operation for this backup item.
	LastBackupTime *date.Time `json:"lastBackupTime,omitempty"`
	// ExtendedInfo - Additional information for this backup item.
	ExtendedInfo *AzureIaaSVMProtectedItemExtendedInfo `json:"extendedInfo,omitempty"`
	// BackupManagementType - The backup management type associated with the backup item. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// WorkloadType - The workload type for this item. Possible values include: 'Invalid', 'VM', 'FileFolder', 'AzureSQLDb', 'SQLDB', 'Exchange', 'Sharepoint', 'DPMUnknown'
	WorkloadType DataSourceType `json:"workloadType,omitempty"`
	// SourceResourceID - The ID of the resource to be backed up.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
	// PolicyID - The ID of the backup policy associated with this backup item.
	PolicyID *string `json:"policyId,omitempty"`
	// LastRecoveryPoint - The timestamp when the most recent backup copy was created for this backup item.
	LastRecoveryPoint *date.Time `json:"lastRecoveryPoint,omitempty"`
	// ProtectedItemType - Possible values include: 'ProtectedItemTypeProtectedItem', 'ProtectedItemTypeAzureIaaSVMProtectedItem', 'ProtectedItemTypeMabFileFolderProtectedItem', 'ProtectedItemTypeMicrosoftSqlserversdatabases', 'ProtectedItemTypeMicrosoftComputevirtualMachines', 'ProtectedItemTypeMicrosoftClassicComputevirtualMachines'
	ProtectedItemType ProtectedItemType `json:"protectedItemType,omitempty"`
}

func unmarshalBasicAzureIaaSVMProtectedItem(body []byte) (BasicAzureIaaSVMProtectedItem, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["protectedItemType"] {
	case string(ProtectedItemTypeMicrosoftComputevirtualMachines):
		var aiscvpi AzureIaaSComputeVMProtectedItem
		err := json.Unmarshal(body, &aiscvpi)
		return aiscvpi, err
	case string(ProtectedItemTypeMicrosoftClassicComputevirtualMachines):
		var aisccvpi AzureIaaSClassicComputeVMProtectedItem
		err := json.Unmarshal(body, &aisccvpi)
		return aisccvpi, err
	default:
		var aispi AzureIaaSVMProtectedItem
		err := json.Unmarshal(body, &aispi)
		return aispi, err
	}
}
func unmarshalBasicAzureIaaSVMProtectedItemArray(body []byte) ([]BasicAzureIaaSVMProtectedItem, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	aispiArray := make([]BasicAzureIaaSVMProtectedItem, len(rawMessages))

	for index, rawMessage := range rawMessages {
		aispi, err := unmarshalBasicAzureIaaSVMProtectedItem(*rawMessage)
		if err != nil {
			return nil, err
		}
		aispiArray[index] = aispi
	}
	return aispiArray, nil
}

// MarshalJSON is the custom marshaler for AzureIaaSVMProtectedItem.
func (aispi AzureIaaSVMProtectedItem) MarshalJSON() ([]byte, error) {
	aispi.ProtectedItemType = ProtectedItemTypeAzureIaaSVMProtectedItem
	objectMap := make(map[string]interface{})
	if aispi.FriendlyName != nil {
		objectMap["friendlyName"] = aispi.FriendlyName
	}
	if aispi.VirtualMachineID != nil {
		objectMap["virtualMachineId"] = aispi.VirtualMachineID
	}
	if aispi.ProtectionStatus != nil {
		objectMap["protectionStatus"] = aispi.ProtectionStatus
	}
	if aispi.ProtectionState != "" {
		objectMap["protectionState"] = aispi.ProtectionState
	}
	if aispi.LastBackupStatus != nil {
		objectMap["lastBackupStatus"] = aispi.LastBackupStatus
	}
	if aispi.LastBackupTime != nil {
		objectMap["lastBackupTime"] = aispi.LastBackupTime
	}
	if aispi.ExtendedInfo != nil {
		objectMap["extendedInfo"] = aispi.ExtendedInfo
	}
	if aispi.BackupManagementType != "" {
		objectMap["backupManagementType"] = aispi.BackupManagementType
	}
	if aispi.WorkloadType != "" {
		objectMap["workloadType"] = aispi.WorkloadType
	}
	if aispi.SourceResourceID != nil {
		objectMap["sourceResourceId"] = aispi.SourceResourceID
	}
	if aispi.PolicyID != nil {
		objectMap["policyId"] = aispi.PolicyID
	}
	if aispi.LastRecoveryPoint != nil {
		objectMap["lastRecoveryPoint"] = aispi.LastRecoveryPoint
	}
	if aispi.ProtectedItemType != "" {
		objectMap["protectedItemType"] = aispi.ProtectedItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureIaaSVMProtectedItem is the BasicProtectedItem implementation for AzureIaaSVMProtectedItem.
func (aispi AzureIaaSVMProtectedItem) AsAzureIaaSVMProtectedItem() (*AzureIaaSVMProtectedItem, bool) {
	return &aispi, true
}

// AsBasicAzureIaaSVMProtectedItem is the BasicProtectedItem implementation for AzureIaaSVMProtectedItem.
func (aispi AzureIaaSVMProtectedItem) AsBasicAzureIaaSVMProtectedItem() (BasicAzureIaaSVMProtectedItem, bool) {
	return &aispi, true
}

// AsMabFileFolderProtectedItem is the BasicProtectedItem implementation for AzureIaaSVMProtectedItem.
func (aispi AzureIaaSVMProtectedItem) AsMabFileFolderProtectedItem() (*MabFileFolderProtectedItem, bool) {
	return nil, false
}

// AsAzureSQLProtectedItem is the BasicProtectedItem implementation for AzureIaaSVMProtectedItem.
func (aispi AzureIaaSVMProtectedItem) AsAzureSQLProtectedItem() (*AzureSQLProtectedItem, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMProtectedItem is the BasicProtectedItem implementation for AzureIaaSVMProtectedItem.
func (aispi AzureIaaSVMProtectedItem) AsAzureIaaSComputeVMProtectedItem() (*AzureIaaSComputeVMProtectedItem, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMProtectedItem is the BasicProtectedItem implementation for AzureIaaSVMProtectedItem.
func (aispi AzureIaaSVMProtectedItem) AsAzureIaaSClassicComputeVMProtectedItem() (*AzureIaaSClassicComputeVMProtectedItem, bool) {
	return nil, false
}

// AsProtectedItem is the BasicProtectedItem implementation for AzureIaaSVMProtectedItem.
func (aispi AzureIaaSVMProtectedItem) AsProtectedItem() (*ProtectedItem, bool) {
	return nil, false
}

// AsBasicProtectedItem is the BasicProtectedItem implementation for AzureIaaSVMProtectedItem.
func (aispi AzureIaaSVMProtectedItem) AsBasicProtectedItem() (BasicProtectedItem, bool) {
	return &aispi, true
}

// AzureIaaSVMProtectedItemExtendedInfo additional information for the Azure VM (also known as IaaS
// VM)-specific backup item.
type AzureIaaSVMProtectedItemExtendedInfo struct {
	// OldestRecoveryPoint - The oldest backup copy available for this backup item.
	OldestRecoveryPoint *date.Time `json:"oldestRecoveryPoint,omitempty"`
	// RecoveryPointCount - The number of backup copies available for this backup item.
	RecoveryPointCount *int32 `json:"recoveryPointCount,omitempty"`
	// PolicyInconsistent - Specifies if the backup policy associated with the backup item is inconsistent.
	PolicyInconsistent *bool `json:"policyInconsistent,omitempty"`
}

// AzureIaaSVMProtectionPolicy azure VM (also known as IaaS VM) workload-specific backup policy.
type AzureIaaSVMProtectionPolicy struct {
	// SchedulePolicy - The backup schedule specified as part of backup policy.
	SchedulePolicy BasicSchedulePolicy `json:"schedulePolicy,omitempty"`
	// RetentionPolicy - The retention policy with the details on backup copy retention ranges.
	RetentionPolicy BasicRetentionPolicy `json:"retentionPolicy,omitempty"`
	// ProtectedItemsCount - The number of items associated with this policy.
	ProtectedItemsCount *int32 `json:"protectedItemsCount,omitempty"`
	// BackupManagementType - Possible values include: 'BackupManagementTypeProtectionPolicy', 'BackupManagementTypeAzureIaasVM', 'BackupManagementTypeMAB', 'BackupManagementTypeAzureSQL'
	BackupManagementType ManagementTypeBasicProtectionPolicy `json:"backupManagementType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureIaaSVMProtectionPolicy.
func (aispp AzureIaaSVMProtectionPolicy) MarshalJSON() ([]byte, error) {
	aispp.BackupManagementType = BackupManagementTypeAzureIaasVM
	objectMap := make(map[string]interface{})
	objectMap["schedulePolicy"] = aispp.SchedulePolicy
	objectMap["retentionPolicy"] = aispp.RetentionPolicy
	if aispp.ProtectedItemsCount != nil {
		objectMap["protectedItemsCount"] = aispp.ProtectedItemsCount
	}
	if aispp.BackupManagementType != "" {
		objectMap["backupManagementType"] = aispp.BackupManagementType
	}
	return json.Marshal(objectMap)
}

// AsAzureIaaSVMProtectionPolicy is the BasicProtectionPolicy implementation for AzureIaaSVMProtectionPolicy.
func (aispp AzureIaaSVMProtectionPolicy) AsAzureIaaSVMProtectionPolicy() (*AzureIaaSVMProtectionPolicy, bool) {
	return &aispp, true
}

// AsMabProtectionPolicy is the BasicProtectionPolicy implementation for AzureIaaSVMProtectionPolicy.
func (aispp AzureIaaSVMProtectionPolicy) AsMabProtectionPolicy() (*MabProtectionPolicy, bool) {
	return nil, false
}

// AsAzureSQLProtectionPolicy is the BasicProtectionPolicy implementation for AzureIaaSVMProtectionPolicy.
func (aispp AzureIaaSVMProtectionPolicy) AsAzureSQLProtectionPolicy() (*AzureSQLProtectionPolicy, bool) {
	return nil, false
}

// AsProtectionPolicy is the BasicProtectionPolicy implementation for AzureIaaSVMProtectionPolicy.
func (aispp AzureIaaSVMProtectionPolicy) AsProtectionPolicy() (*ProtectionPolicy, bool) {
	return nil, false
}

// AsBasicProtectionPolicy is the BasicProtectionPolicy implementation for AzureIaaSVMProtectionPolicy.
func (aispp AzureIaaSVMProtectionPolicy) AsBasicProtectionPolicy() (BasicProtectionPolicy, bool) {
	return &aispp, true
}

// UnmarshalJSON is the custom unmarshaler for AzureIaaSVMProtectionPolicy struct.
func (aispp *AzureIaaSVMProtectionPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "schedulePolicy":
			if v != nil {
				schedulePolicy, err := unmarshalBasicSchedulePolicy(*v)
				if err != nil {
					return err
				}
				aispp.SchedulePolicy = schedulePolicy
			}
		case "retentionPolicy":
			if v != nil {
				retentionPolicy, err := unmarshalBasicRetentionPolicy(*v)
				if err != nil {
					return err
				}
				aispp.RetentionPolicy = retentionPolicy
			}
		case "protectedItemsCount":
			if v != nil {
				var protectedItemsCount int32
				err = json.Unmarshal(*v, &protectedItemsCount)
				if err != nil {
					return err
				}
				aispp.ProtectedItemsCount = &protectedItemsCount
			}
		case "backupManagementType":
			if v != nil {
				var backupManagementType ManagementTypeBasicProtectionPolicy
				err = json.Unmarshal(*v, &backupManagementType)
				if err != nil {
					return err
				}
				aispp.BackupManagementType = backupManagementType
			}
		}
	}

	return nil
}

// AzureSQLContainer azure SQL workload-specific container.
type AzureSQLContainer struct {
	// FriendlyName - Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// BackupManagementType - The backup management type for the container. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// RegistrationStatus - The container's registration status with the Recovery Services vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`
	// HealthStatus - The status of the container's health.
	HealthStatus *string `json:"healthStatus,omitempty"`
	// ContainerType - READ-ONLY; The type assigned to the container. The values to use for each of these properties are:<br/> 1. Compute Azure VM is Microsoft.Compute/virtualMachines<br/> 2. Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines<br/> 3. Windows machines (like Azure Backup Server and DPM) is Windows<br/> 4. Azure SQL instance is AzureSqlContainer.
	ContainerType *string `json:"containerType,omitempty"`
	// ProtectableObjectType - Possible values include: 'ProtectableObjectTypeProtectionContainer', 'ProtectableObjectTypeAzureSQLContainer', 'ProtectableObjectTypeIaaSVMContainer', 'ProtectableObjectTypeMABWindowsContainer', 'ProtectableObjectTypeMicrosoftComputevirtualMachines', 'ProtectableObjectTypeMicrosoftClassicComputevirtualMachines'
	ProtectableObjectType ProtectableObjectType `json:"protectableObjectType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureSQLContainer.
func (asc AzureSQLContainer) MarshalJSON() ([]byte, error) {
	asc.ProtectableObjectType = ProtectableObjectTypeAzureSQLContainer
	objectMap := make(map[string]interface{})
	if asc.FriendlyName != nil {
		objectMap["friendlyName"] = asc.FriendlyName
	}
	if asc.BackupManagementType != "" {
		objectMap["backupManagementType"] = asc.BackupManagementType
	}
	if asc.RegistrationStatus != nil {
		objectMap["registrationStatus"] = asc.RegistrationStatus
	}
	if asc.HealthStatus != nil {
		objectMap["healthStatus"] = asc.HealthStatus
	}
	if asc.ProtectableObjectType != "" {
		objectMap["protectableObjectType"] = asc.ProtectableObjectType
	}
	return json.Marshal(objectMap)
}

// AsAzureSQLContainer is the BasicProtectionContainer implementation for AzureSQLContainer.
func (asc AzureSQLContainer) AsAzureSQLContainer() (*AzureSQLContainer, bool) {
	return &asc, true
}

// AsIaaSVMContainer is the BasicProtectionContainer implementation for AzureSQLContainer.
func (asc AzureSQLContainer) AsIaaSVMContainer() (*IaaSVMContainer, bool) {
	return nil, false
}

// AsBasicIaaSVMContainer is the BasicProtectionContainer implementation for AzureSQLContainer.
func (asc AzureSQLContainer) AsBasicIaaSVMContainer() (BasicIaaSVMContainer, bool) {
	return nil, false
}

// AsMabContainer is the BasicProtectionContainer implementation for AzureSQLContainer.
func (asc AzureSQLContainer) AsMabContainer() (*MabContainer, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMContainer is the BasicProtectionContainer implementation for AzureSQLContainer.
func (asc AzureSQLContainer) AsAzureIaaSComputeVMContainer() (*AzureIaaSComputeVMContainer, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMContainer is the BasicProtectionContainer implementation for AzureSQLContainer.
func (asc AzureSQLContainer) AsAzureIaaSClassicComputeVMContainer() (*AzureIaaSClassicComputeVMContainer, bool) {
	return nil, false
}

// AsProtectionContainer is the BasicProtectionContainer implementation for AzureSQLContainer.
func (asc AzureSQLContainer) AsProtectionContainer() (*ProtectionContainer, bool) {
	return nil, false
}

// AsBasicProtectionContainer is the BasicProtectionContainer implementation for AzureSQLContainer.
func (asc AzureSQLContainer) AsBasicProtectionContainer() (BasicProtectionContainer, bool) {
	return &asc, true
}

// AzureSQLProtectedItem this is an Azure SQL workload-specific backup item.
type AzureSQLProtectedItem struct {
	// ProtectedItemDataID - The internal ID of a backup item. The internal ID is used by the Azure SQL Backup engine to contact Recovery Services.
	ProtectedItemDataID *string `json:"protectedItemDataId,omitempty"`
	// ProtectionState - The backup state of the backup item. Possible values include: 'ProtectedItemStateInvalid', 'ProtectedItemStateIRPending', 'ProtectedItemStateProtected', 'ProtectedItemStateProtectionError', 'ProtectedItemStateProtectionStopped', 'ProtectedItemStateProtectionPaused'
	ProtectionState ProtectedItemState `json:"protectionState,omitempty"`
	// ExtendedInfo - Additional information for this backup item.
	ExtendedInfo *AzureSQLProtectedItemExtendedInfo `json:"extendedInfo,omitempty"`
	// BackupManagementType - The backup management type associated with the backup item. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// WorkloadType - The workload type for this item. Possible values include: 'Invalid', 'VM', 'FileFolder', 'AzureSQLDb', 'SQLDB', 'Exchange', 'Sharepoint', 'DPMUnknown'
	WorkloadType DataSourceType `json:"workloadType,omitempty"`
	// SourceResourceID - The ID of the resource to be backed up.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
	// PolicyID - The ID of the backup policy associated with this backup item.
	PolicyID *string `json:"policyId,omitempty"`
	// LastRecoveryPoint - The timestamp when the most recent backup copy was created for this backup item.
	LastRecoveryPoint *date.Time `json:"lastRecoveryPoint,omitempty"`
	// ProtectedItemType - Possible values include: 'ProtectedItemTypeProtectedItem', 'ProtectedItemTypeAzureIaaSVMProtectedItem', 'ProtectedItemTypeMabFileFolderProtectedItem', 'ProtectedItemTypeMicrosoftSqlserversdatabases', 'ProtectedItemTypeMicrosoftComputevirtualMachines', 'ProtectedItemTypeMicrosoftClassicComputevirtualMachines'
	ProtectedItemType ProtectedItemType `json:"protectedItemType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureSQLProtectedItem.
func (aspi AzureSQLProtectedItem) MarshalJSON() ([]byte, error) {
	aspi.ProtectedItemType = ProtectedItemTypeMicrosoftSqlserversdatabases
	objectMap := make(map[string]interface{})
	if aspi.ProtectedItemDataID != nil {
		objectMap["protectedItemDataId"] = aspi.ProtectedItemDataID
	}
	if aspi.ProtectionState != "" {
		objectMap["protectionState"] = aspi.ProtectionState
	}
	if aspi.ExtendedInfo != nil {
		objectMap["extendedInfo"] = aspi.ExtendedInfo
	}
	if aspi.BackupManagementType != "" {
		objectMap["backupManagementType"] = aspi.BackupManagementType
	}
	if aspi.WorkloadType != "" {
		objectMap["workloadType"] = aspi.WorkloadType
	}
	if aspi.SourceResourceID != nil {
		objectMap["sourceResourceId"] = aspi.SourceResourceID
	}
	if aspi.PolicyID != nil {
		objectMap["policyId"] = aspi.PolicyID
	}
	if aspi.LastRecoveryPoint != nil {
		objectMap["lastRecoveryPoint"] = aspi.LastRecoveryPoint
	}
	if aspi.ProtectedItemType != "" {
		objectMap["protectedItemType"] = aspi.ProtectedItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureIaaSVMProtectedItem is the BasicProtectedItem implementation for AzureSQLProtectedItem.
func (aspi AzureSQLProtectedItem) AsAzureIaaSVMProtectedItem() (*AzureIaaSVMProtectedItem, bool) {
	return nil, false
}

// AsBasicAzureIaaSVMProtectedItem is the BasicProtectedItem implementation for AzureSQLProtectedItem.
func (aspi AzureSQLProtectedItem) AsBasicAzureIaaSVMProtectedItem() (BasicAzureIaaSVMProtectedItem, bool) {
	return nil, false
}

// AsMabFileFolderProtectedItem is the BasicProtectedItem implementation for AzureSQLProtectedItem.
func (aspi AzureSQLProtectedItem) AsMabFileFolderProtectedItem() (*MabFileFolderProtectedItem, bool) {
	return nil, false
}

// AsAzureSQLProtectedItem is the BasicProtectedItem implementation for AzureSQLProtectedItem.
func (aspi AzureSQLProtectedItem) AsAzureSQLProtectedItem() (*AzureSQLProtectedItem, bool) {
	return &aspi, true
}

// AsAzureIaaSComputeVMProtectedItem is the BasicProtectedItem implementation for AzureSQLProtectedItem.
func (aspi AzureSQLProtectedItem) AsAzureIaaSComputeVMProtectedItem() (*AzureIaaSComputeVMProtectedItem, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMProtectedItem is the BasicProtectedItem implementation for AzureSQLProtectedItem.
func (aspi AzureSQLProtectedItem) AsAzureIaaSClassicComputeVMProtectedItem() (*AzureIaaSClassicComputeVMProtectedItem, bool) {
	return nil, false
}

// AsProtectedItem is the BasicProtectedItem implementation for AzureSQLProtectedItem.
func (aspi AzureSQLProtectedItem) AsProtectedItem() (*ProtectedItem, bool) {
	return nil, false
}

// AsBasicProtectedItem is the BasicProtectedItem implementation for AzureSQLProtectedItem.
func (aspi AzureSQLProtectedItem) AsBasicProtectedItem() (BasicProtectedItem, bool) {
	return &aspi, true
}

// AzureSQLProtectedItemExtendedInfo additional information for the Azure SQL specific backup item.
type AzureSQLProtectedItemExtendedInfo struct {
	// OldestRecoveryPoint - The oldest backup copy available for this item in the service.
	OldestRecoveryPoint *date.Time `json:"oldestRecoveryPoint,omitempty"`
	// RecoveryPointCount - The number of available backup copies for this backup item.
	RecoveryPointCount *int32 `json:"recoveryPointCount,omitempty"`
	// PolicyState - The state of the backup policy associated with this backup item.
	PolicyState *string `json:"policyState,omitempty"`
}

// AzureSQLProtectionPolicy the Azure SQL workload-specific backup policy.
type AzureSQLProtectionPolicy struct {
	// RetentionPolicy - The retention policy details.
	RetentionPolicy BasicRetentionPolicy `json:"retentionPolicy,omitempty"`
	// ProtectedItemsCount - The number of items associated with this policy.
	ProtectedItemsCount *int32 `json:"protectedItemsCount,omitempty"`
	// BackupManagementType - Possible values include: 'BackupManagementTypeProtectionPolicy', 'BackupManagementTypeAzureIaasVM', 'BackupManagementTypeMAB', 'BackupManagementTypeAzureSQL'
	BackupManagementType ManagementTypeBasicProtectionPolicy `json:"backupManagementType,omitempty"`
}

// MarshalJSON is the custom marshaler for AzureSQLProtectionPolicy.
func (aspp AzureSQLProtectionPolicy) MarshalJSON() ([]byte, error) {
	aspp.BackupManagementType = BackupManagementTypeAzureSQL
	objectMap := make(map[string]interface{})
	objectMap["retentionPolicy"] = aspp.RetentionPolicy
	if aspp.ProtectedItemsCount != nil {
		objectMap["protectedItemsCount"] = aspp.ProtectedItemsCount
	}
	if aspp.BackupManagementType != "" {
		objectMap["backupManagementType"] = aspp.BackupManagementType
	}
	return json.Marshal(objectMap)
}

// AsAzureIaaSVMProtectionPolicy is the BasicProtectionPolicy implementation for AzureSQLProtectionPolicy.
func (aspp AzureSQLProtectionPolicy) AsAzureIaaSVMProtectionPolicy() (*AzureIaaSVMProtectionPolicy, bool) {
	return nil, false
}

// AsMabProtectionPolicy is the BasicProtectionPolicy implementation for AzureSQLProtectionPolicy.
func (aspp AzureSQLProtectionPolicy) AsMabProtectionPolicy() (*MabProtectionPolicy, bool) {
	return nil, false
}

// AsAzureSQLProtectionPolicy is the BasicProtectionPolicy implementation for AzureSQLProtectionPolicy.
func (aspp AzureSQLProtectionPolicy) AsAzureSQLProtectionPolicy() (*AzureSQLProtectionPolicy, bool) {
	return &aspp, true
}

// AsProtectionPolicy is the BasicProtectionPolicy implementation for AzureSQLProtectionPolicy.
func (aspp AzureSQLProtectionPolicy) AsProtectionPolicy() (*ProtectionPolicy, bool) {
	return nil, false
}

// AsBasicProtectionPolicy is the BasicProtectionPolicy implementation for AzureSQLProtectionPolicy.
func (aspp AzureSQLProtectionPolicy) AsBasicProtectionPolicy() (BasicProtectionPolicy, bool) {
	return &aspp, true
}

// UnmarshalJSON is the custom unmarshaler for AzureSQLProtectionPolicy struct.
func (aspp *AzureSQLProtectionPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "retentionPolicy":
			if v != nil {
				retentionPolicy, err := unmarshalBasicRetentionPolicy(*v)
				if err != nil {
					return err
				}
				aspp.RetentionPolicy = retentionPolicy
			}
		case "protectedItemsCount":
			if v != nil {
				var protectedItemsCount int32
				err = json.Unmarshal(*v, &protectedItemsCount)
				if err != nil {
					return err
				}
				aspp.ProtectedItemsCount = &protectedItemsCount
			}
		case "backupManagementType":
			if v != nil {
				var backupManagementType ManagementTypeBasicProtectionPolicy
				err = json.Unmarshal(*v, &backupManagementType)
				if err != nil {
					return err
				}
				aspp.BackupManagementType = backupManagementType
			}
		}
	}

	return nil
}

// BEKDetails BEK is Bitlocker Encryption Key.
type BEKDetails struct {
	// SecretURL - Secret refers to Bitlocker Encryption Key (BEK). The Secret can be unlocked by the key (or KEK).
	SecretURL *string `json:"secretUrl,omitempty"`
	// SecretVaultID - ID of the Key Vault where this Secret is stored.
	SecretVaultID *string `json:"secretVaultId,omitempty"`
	// SecretData - Bitlocker Encryption Key (BEK) data.
	SecretData *string `json:"secretData,omitempty"`
}

// BMSBackupEngineQueryObject the query parameters used to GET the list of backup engines.
type BMSBackupEngineQueryObject struct {
	// BackupManagementType - The backup management type associated with the backup engine. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
}

// BMSContainerQueryObject the query filters that can be used with the list containers API.
type BMSContainerQueryObject struct {
	// BackupManagementType - The backup management type for this container. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// Status - The status of the container's registration with the Recovery Services vault.
	Status *string `json:"status,omitempty"`
	// FriendlyName - The friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// BMSPOQueryObject filters the list of backup items.
type BMSPOQueryObject struct {
	// BackupManagementType - The backup management type. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// Status - The backup status query parameter.
	Status *string `json:"status,omitempty"`
	// FriendlyName - The friendly name for the item.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// BMSRPQueryObject filters the list of backup copies based on the property.
type BMSRPQueryObject struct {
	// StartDate - Use backup copies created after this time.
	StartDate *date.Time `json:"startDate,omitempty"`
	// EndDate - Use backup copies created before this time.
	EndDate *date.Time `json:"endDate,omitempty"`
}

// ClientScriptForConnect client script details for the file or folder restore.
type ClientScriptForConnect struct {
	// ScriptContent - File content of the client script for file or folder restore.
	ScriptContent *string `json:"scriptContent,omitempty"`
	// ScriptExtension - File extension of the client script for the file or folder restore. Some examples of the extension are: .ps1 and .sh.
	ScriptExtension *string `json:"scriptExtension,omitempty"`
	// OsType - The operating system platform ("Windows" or "Linux") for which this file or folder restore client script works.
	OsType *string `json:"osType,omitempty"`
}

// DailyRetentionFormat daily retention format.
type DailyRetentionFormat struct {
	// DaysOfTheMonth - List of days of the month.
	DaysOfTheMonth *[]Day `json:"daysOfTheMonth,omitempty"`
}

// DailyRetentionSchedule daily retention schedule.
type DailyRetentionSchedule struct {
	// RetentionTimes - The retention times of retention policy.
	RetentionTimes *[]date.Time `json:"retentionTimes,omitempty"`
	// RetentionDuration - The retention duration of retention policy.
	RetentionDuration *RetentionDuration `json:"retentionDuration,omitempty"`
}

// Day day of the week.
type Day struct {
	Date   *int32 `json:"date,omitempty"`
	IsLast *bool  `json:"isLast,omitempty"`
}

// DpmBackupEngine the backup engine type when Data Protection Manager (DPM) is used to manage backups.
type DpmBackupEngine struct {
	// FriendlyName - The friendly name of the backup engine.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// BackupManagementType - The type of backup management associated with the backup engine. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// RegistrationStatus - The status of the backup engine registration with the Recovery Services vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`
	// HealthStatus - The backup status of the backup engine.
	HealthStatus *string `json:"healthStatus,omitempty"`
	// CanReRegister - The flag indicating whether the backup engine be registered again, once the engine has been initially registered.
	CanReRegister *bool `json:"canReRegister,omitempty"`
	// BackupEngineID - The ID of the backup engine.
	BackupEngineID *string `json:"backupEngineId,omitempty"`
	// BackupEngineType - Possible values include: 'BackupEngineTypeBackupEngineBase', 'BackupEngineTypeAzureBackupServerEngine', 'BackupEngineTypeDpmBackupEngine'
	BackupEngineType EngineType `json:"backupEngineType,omitempty"`
}

// MarshalJSON is the custom marshaler for DpmBackupEngine.
func (dbe DpmBackupEngine) MarshalJSON() ([]byte, error) {
	dbe.BackupEngineType = BackupEngineTypeDpmBackupEngine
	objectMap := make(map[string]interface{})
	if dbe.FriendlyName != nil {
		objectMap["friendlyName"] = dbe.FriendlyName
	}
	if dbe.BackupManagementType != "" {
		objectMap["backupManagementType"] = dbe.BackupManagementType
	}
	if dbe.RegistrationStatus != nil {
		objectMap["registrationStatus"] = dbe.RegistrationStatus
	}
	if dbe.HealthStatus != nil {
		objectMap["healthStatus"] = dbe.HealthStatus
	}
	if dbe.CanReRegister != nil {
		objectMap["canReRegister"] = dbe.CanReRegister
	}
	if dbe.BackupEngineID != nil {
		objectMap["backupEngineId"] = dbe.BackupEngineID
	}
	if dbe.BackupEngineType != "" {
		objectMap["backupEngineType"] = dbe.BackupEngineType
	}
	return json.Marshal(objectMap)
}

// AsAzureBackupServerEngine is the BasicEngineBase implementation for DpmBackupEngine.
func (dbe DpmBackupEngine) AsAzureBackupServerEngine() (*AzureBackupServerEngine, bool) {
	return nil, false
}

// AsDpmBackupEngine is the BasicEngineBase implementation for DpmBackupEngine.
func (dbe DpmBackupEngine) AsDpmBackupEngine() (*DpmBackupEngine, bool) {
	return &dbe, true
}

// AsEngineBase is the BasicEngineBase implementation for DpmBackupEngine.
func (dbe DpmBackupEngine) AsEngineBase() (*EngineBase, bool) {
	return nil, false
}

// AsBasicEngineBase is the BasicEngineBase implementation for DpmBackupEngine.
func (dbe DpmBackupEngine) AsBasicEngineBase() (BasicEngineBase, bool) {
	return &dbe, true
}

// DpmErrorInfo DPM workload-specific error information.
type DpmErrorInfo struct {
	// ErrorString - Localized error string.
	ErrorString *string `json:"errorString,omitempty"`
	// Recommendations - The list of localized recommendations for the error string.
	Recommendations *[]string `json:"recommendations,omitempty"`
}

// DpmJob the DPM workload-specific job object.
type DpmJob struct {
	// Duration - The time elapsed for the job.
	Duration *string `json:"duration,omitempty"`
	// DpmServerName - DPM server name managing the backup item or backup job.
	DpmServerName *string `json:"dpmServerName,omitempty"`
	// ContainerName - The name of the cluster or server protecting the current backup item, if any.
	ContainerName *string `json:"containerName,omitempty"`
	// ContainerType - The type of container.
	ContainerType *string `json:"containerType,omitempty"`
	// WorkloadType - The type of backup item.
	WorkloadType *string `json:"workloadType,omitempty"`
	// ActionsInfo - The state or actions applicable on this job, such as Cancel or Retry.
	ActionsInfo *[]JobSupportedAction `json:"actionsInfo,omitempty"`
	// ErrorDetails - The errors.
	ErrorDetails *[]DpmErrorInfo `json:"errorDetails,omitempty"`
	// ExtendedInfo - Additional information for this job.
	ExtendedInfo *DpmJobExtendedInfo `json:"extendedInfo,omitempty"`
	// EntityFriendlyName - The friendly name of the entity on which the current job is executing.
	EntityFriendlyName *string `json:"entityFriendlyName,omitempty"`
	// BackupManagementType - The backup management type for the current job. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// Operation - The operation name.
	Operation *string `json:"operation,omitempty"`
	// Status - The job status.
	Status *string `json:"status,omitempty"`
	// StartTime - The start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The end time.
	EndTime *date.Time `json:"endTime,omitempty"`
	// ActivityID - ActivityId of job.
	ActivityID *string `json:"activityId,omitempty"`
	// JobType - Possible values include: 'JobTypeJob', 'JobTypeAzureIaaSVMJob', 'JobTypeDpmJob', 'JobTypeMabJob'
	JobType JobType `json:"jobType,omitempty"`
}

// MarshalJSON is the custom marshaler for DpmJob.
func (dj DpmJob) MarshalJSON() ([]byte, error) {
	dj.JobType = JobTypeDpmJob
	objectMap := make(map[string]interface{})
	if dj.Duration != nil {
		objectMap["duration"] = dj.Duration
	}
	if dj.DpmServerName != nil {
		objectMap["dpmServerName"] = dj.DpmServerName
	}
	if dj.ContainerName != nil {
		objectMap["containerName"] = dj.ContainerName
	}
	if dj.ContainerType != nil {
		objectMap["containerType"] = dj.ContainerType
	}
	if dj.WorkloadType != nil {
		objectMap["workloadType"] = dj.WorkloadType
	}
	if dj.ActionsInfo != nil {
		objectMap["actionsInfo"] = dj.ActionsInfo
	}
	if dj.ErrorDetails != nil {
		objectMap["errorDetails"] = dj.ErrorDetails
	}
	if dj.ExtendedInfo != nil {
		objectMap["extendedInfo"] = dj.ExtendedInfo
	}
	if dj.EntityFriendlyName != nil {
		objectMap["entityFriendlyName"] = dj.EntityFriendlyName
	}
	if dj.BackupManagementType != "" {
		objectMap["backupManagementType"] = dj.BackupManagementType
	}
	if dj.Operation != nil {
		objectMap["operation"] = dj.Operation
	}
	if dj.Status != nil {
		objectMap["status"] = dj.Status
	}
	if dj.StartTime != nil {
		objectMap["startTime"] = dj.StartTime
	}
	if dj.EndTime != nil {
		objectMap["endTime"] = dj.EndTime
	}
	if dj.ActivityID != nil {
		objectMap["activityId"] = dj.ActivityID
	}
	if dj.JobType != "" {
		objectMap["jobType"] = dj.JobType
	}
	return json.Marshal(objectMap)
}

// AsAzureIaaSVMJob is the BasicJob implementation for DpmJob.
func (dj DpmJob) AsAzureIaaSVMJob() (*AzureIaaSVMJob, bool) {
	return nil, false
}

// AsDpmJob is the BasicJob implementation for DpmJob.
func (dj DpmJob) AsDpmJob() (*DpmJob, bool) {
	return &dj, true
}

// AsMabJob is the BasicJob implementation for DpmJob.
func (dj DpmJob) AsMabJob() (*MabJob, bool) {
	return nil, false
}

// AsJob is the BasicJob implementation for DpmJob.
func (dj DpmJob) AsJob() (*Job, bool) {
	return nil, false
}

// AsBasicJob is the BasicJob implementation for DpmJob.
func (dj DpmJob) AsBasicJob() (BasicJob, bool) {
	return &dj, true
}

// DpmJobExtendedInfo additional information on the DPM workload-specific job.
type DpmJobExtendedInfo struct {
	// TasksList - List of tasks associated with this job.
	TasksList *[]DpmJobTaskDetails `json:"tasksList,omitempty"`
	// PropertyBag - The job properties.
	PropertyBag map[string]*string `json:"propertyBag"`
	// DynamicErrorMessage - Non-localized error message on job execution.
	DynamicErrorMessage *string `json:"dynamicErrorMessage,omitempty"`
}

// MarshalJSON is the custom marshaler for DpmJobExtendedInfo.
func (djei DpmJobExtendedInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if djei.TasksList != nil {
		objectMap["tasksList"] = djei.TasksList
	}
	if djei.PropertyBag != nil {
		objectMap["propertyBag"] = djei.PropertyBag
	}
	if djei.DynamicErrorMessage != nil {
		objectMap["dynamicErrorMessage"] = djei.DynamicErrorMessage
	}
	return json.Marshal(objectMap)
}

// DpmJobTaskDetails DPM workload-specific job task details.
type DpmJobTaskDetails struct {
	// TaskID - The task display name.
	TaskID *string `json:"taskId,omitempty"`
	// StartTime - The start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The end time.
	EndTime *date.Time `json:"endTime,omitempty"`
	// Duration - The time elapsed for task.
	Duration *string `json:"duration,omitempty"`
	// Status - The status.
	Status *string `json:"status,omitempty"`
}

// EncryptionDetails details needed if the VM was encrypted at the time of backup.
type EncryptionDetails struct {
	// EncryptionEnabled - Identifies whether the backup copy represents an encrypted VM at the time of backup.
	EncryptionEnabled *bool `json:"encryptionEnabled,omitempty"`
	// KekURL - URL of the Key Encryption Key (KEK).
	KekURL *string `json:"kekUrl,omitempty"`
	// SecretKeyURL - URL of the Bitlocker Encryption Key (BEK).
	SecretKeyURL *string `json:"secretKeyUrl,omitempty"`
	// KekVaultID - The ID of Key Vault where the Key Encryption Key (KEK) is stored.
	KekVaultID *string `json:"kekVaultId,omitempty"`
	// SecretKeyVaultID - The ID of Key Vault where the Bitlocker Encryption Key (BEK), or Secret, is stored.
	SecretKeyVaultID *string `json:"secretKeyVaultId,omitempty"`
}

// BasicEngineBase the base backup engine class. All workload-specific backup engines derive from this class.
type BasicEngineBase interface {
	AsAzureBackupServerEngine() (*AzureBackupServerEngine, bool)
	AsDpmBackupEngine() (*DpmBackupEngine, bool)
	AsEngineBase() (*EngineBase, bool)
}

// EngineBase the base backup engine class. All workload-specific backup engines derive from this class.
type EngineBase struct {
	// FriendlyName - The friendly name of the backup engine.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// BackupManagementType - The type of backup management associated with the backup engine. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// RegistrationStatus - The status of the backup engine registration with the Recovery Services vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`
	// HealthStatus - The backup status of the backup engine.
	HealthStatus *string `json:"healthStatus,omitempty"`
	// CanReRegister - The flag indicating whether the backup engine be registered again, once the engine has been initially registered.
	CanReRegister *bool `json:"canReRegister,omitempty"`
	// BackupEngineID - The ID of the backup engine.
	BackupEngineID *string `json:"backupEngineId,omitempty"`
	// BackupEngineType - Possible values include: 'BackupEngineTypeBackupEngineBase', 'BackupEngineTypeAzureBackupServerEngine', 'BackupEngineTypeDpmBackupEngine'
	BackupEngineType EngineType `json:"backupEngineType,omitempty"`
}

func unmarshalBasicEngineBase(body []byte) (BasicEngineBase, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["backupEngineType"] {
	case string(BackupEngineTypeAzureBackupServerEngine):
		var abse AzureBackupServerEngine
		err := json.Unmarshal(body, &abse)
		return abse, err
	case string(BackupEngineTypeDpmBackupEngine):
		var dbe DpmBackupEngine
		err := json.Unmarshal(body, &dbe)
		return dbe, err
	default:
		var eb EngineBase
		err := json.Unmarshal(body, &eb)
		return eb, err
	}
}
func unmarshalBasicEngineBaseArray(body []byte) ([]BasicEngineBase, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	ebArray := make([]BasicEngineBase, len(rawMessages))

	for index, rawMessage := range rawMessages {
		eb, err := unmarshalBasicEngineBase(*rawMessage)
		if err != nil {
			return nil, err
		}
		ebArray[index] = eb
	}
	return ebArray, nil
}

// MarshalJSON is the custom marshaler for EngineBase.
func (eb EngineBase) MarshalJSON() ([]byte, error) {
	eb.BackupEngineType = BackupEngineTypeBackupEngineBase
	objectMap := make(map[string]interface{})
	if eb.FriendlyName != nil {
		objectMap["friendlyName"] = eb.FriendlyName
	}
	if eb.BackupManagementType != "" {
		objectMap["backupManagementType"] = eb.BackupManagementType
	}
	if eb.RegistrationStatus != nil {
		objectMap["registrationStatus"] = eb.RegistrationStatus
	}
	if eb.HealthStatus != nil {
		objectMap["healthStatus"] = eb.HealthStatus
	}
	if eb.CanReRegister != nil {
		objectMap["canReRegister"] = eb.CanReRegister
	}
	if eb.BackupEngineID != nil {
		objectMap["backupEngineId"] = eb.BackupEngineID
	}
	if eb.BackupEngineType != "" {
		objectMap["backupEngineType"] = eb.BackupEngineType
	}
	return json.Marshal(objectMap)
}

// AsAzureBackupServerEngine is the BasicEngineBase implementation for EngineBase.
func (eb EngineBase) AsAzureBackupServerEngine() (*AzureBackupServerEngine, bool) {
	return nil, false
}

// AsDpmBackupEngine is the BasicEngineBase implementation for EngineBase.
func (eb EngineBase) AsDpmBackupEngine() (*DpmBackupEngine, bool) {
	return nil, false
}

// AsEngineBase is the BasicEngineBase implementation for EngineBase.
func (eb EngineBase) AsEngineBase() (*EngineBase, bool) {
	return &eb, true
}

// AsBasicEngineBase is the BasicEngineBase implementation for EngineBase.
func (eb EngineBase) AsBasicEngineBase() (BasicEngineBase, bool) {
	return &eb, true
}

// EngineBaseResource the base backup engine class. All workload-specific backup engines derive from this
// class.
type EngineBaseResource struct {
	Properties BasicEngineBase `json:"properties,omitempty"`
	// ID - Resource ID represents the complete path to the resource.
	ID *string `json:"id,omitempty"`
	// Name - Resource name associated with the resource.
	Name *string `json:"name,omitempty"`
	// Type - Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ETag - Optional ETag.
	ETag *string `json:"eTag,omitempty"`
}

// MarshalJSON is the custom marshaler for EngineBaseResource.
func (ebr EngineBaseResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = ebr.Properties
	if ebr.ID != nil {
		objectMap["id"] = ebr.ID
	}
	if ebr.Name != nil {
		objectMap["name"] = ebr.Name
	}
	if ebr.Type != nil {
		objectMap["type"] = ebr.Type
	}
	if ebr.Location != nil {
		objectMap["location"] = ebr.Location
	}
	if ebr.Tags != nil {
		objectMap["tags"] = ebr.Tags
	}
	if ebr.ETag != nil {
		objectMap["eTag"] = ebr.ETag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for EngineBaseResource struct.
func (ebr *EngineBaseResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicEngineBase(*v)
				if err != nil {
					return err
				}
				ebr.Properties = properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ebr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ebr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ebr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ebr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ebr.Tags = tags
			}
		case "eTag":
			if v != nil {
				var eTag string
				err = json.Unmarshal(*v, &eTag)
				if err != nil {
					return err
				}
				ebr.ETag = &eTag
			}
		}
	}

	return nil
}

// EngineBaseResourceList list of BackupEngineBase resources
type EngineBaseResourceList struct {
	autorest.Response `json:"-"`
	// Value - List of resources.
	Value *[]EngineBaseResource `json:"value,omitempty"`
	// NextLink - The URI to GET the next page of resources. Call ListNext() gets the next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// EngineBaseResourceListIterator provides access to a complete listing of EngineBaseResource values.
type EngineBaseResourceListIterator struct {
	i    int
	page EngineBaseResourceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *EngineBaseResourceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EngineBaseResourceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *EngineBaseResourceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter EngineBaseResourceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter EngineBaseResourceListIterator) Response() EngineBaseResourceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter EngineBaseResourceListIterator) Value() EngineBaseResource {
	if !iter.page.NotDone() {
		return EngineBaseResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the EngineBaseResourceListIterator type.
func NewEngineBaseResourceListIterator(page EngineBaseResourceListPage) EngineBaseResourceListIterator {
	return EngineBaseResourceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (ebrl EngineBaseResourceList) IsEmpty() bool {
	return ebrl.Value == nil || len(*ebrl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (ebrl EngineBaseResourceList) hasNextLink() bool {
	return ebrl.NextLink != nil && len(*ebrl.NextLink) != 0
}

// engineBaseResourceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (ebrl EngineBaseResourceList) engineBaseResourceListPreparer(ctx context.Context) (*http.Request, error) {
	if !ebrl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(ebrl.NextLink)))
}

// EngineBaseResourceListPage contains a page of EngineBaseResource values.
type EngineBaseResourceListPage struct {
	fn   func(context.Context, EngineBaseResourceList) (EngineBaseResourceList, error)
	ebrl EngineBaseResourceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *EngineBaseResourceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/EngineBaseResourceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.ebrl)
		if err != nil {
			return err
		}
		page.ebrl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *EngineBaseResourceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page EngineBaseResourceListPage) NotDone() bool {
	return !page.ebrl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page EngineBaseResourceListPage) Response() EngineBaseResourceList {
	return page.ebrl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page EngineBaseResourceListPage) Values() []EngineBaseResource {
	if page.ebrl.IsEmpty() {
		return nil
	}
	return *page.ebrl.Value
}

// Creates a new instance of the EngineBaseResourceListPage type.
func NewEngineBaseResourceListPage(cur EngineBaseResourceList, getNextPage func(context.Context, EngineBaseResourceList) (EngineBaseResourceList, error)) EngineBaseResourceListPage {
	return EngineBaseResourceListPage{
		fn:   getNextPage,
		ebrl: cur,
	}
}

// ExportJobsOperationResultInfo this class is used to send blob details after exporting jobs.
type ExportJobsOperationResultInfo struct {
	// BlobURL - The URL of the blob. The serialized string, which is the list of jobs, is exported to this URL.
	BlobURL *string `json:"blobUrl,omitempty"`
	// BlobSasKey - The Shared Access Signatures (SAS) key used to access the blob. The key expires after 15 minutes.
	BlobSasKey *string `json:"blobSasKey,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeOperationResultInfoBase', 'ObjectTypeOperationResultInfo', 'ObjectTypeExportJobsOperationResultInfo'
	ObjectType ObjectTypeBasicOperationResultInfoBase `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for ExportJobsOperationResultInfo.
func (ejori ExportJobsOperationResultInfo) MarshalJSON() ([]byte, error) {
	ejori.ObjectType = ObjectTypeExportJobsOperationResultInfo
	objectMap := make(map[string]interface{})
	if ejori.BlobURL != nil {
		objectMap["blobUrl"] = ejori.BlobURL
	}
	if ejori.BlobSasKey != nil {
		objectMap["blobSasKey"] = ejori.BlobSasKey
	}
	if ejori.ObjectType != "" {
		objectMap["objectType"] = ejori.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsOperationResultInfo is the BasicOperationResultInfoBase implementation for ExportJobsOperationResultInfo.
func (ejori ExportJobsOperationResultInfo) AsOperationResultInfo() (*OperationResultInfo, bool) {
	return nil, false
}

// AsExportJobsOperationResultInfo is the BasicOperationResultInfoBase implementation for ExportJobsOperationResultInfo.
func (ejori ExportJobsOperationResultInfo) AsExportJobsOperationResultInfo() (*ExportJobsOperationResultInfo, bool) {
	return &ejori, true
}

// AsOperationResultInfoBase is the BasicOperationResultInfoBase implementation for ExportJobsOperationResultInfo.
func (ejori ExportJobsOperationResultInfo) AsOperationResultInfoBase() (*OperationResultInfoBase, bool) {
	return nil, false
}

// AsBasicOperationResultInfoBase is the BasicOperationResultInfoBase implementation for ExportJobsOperationResultInfo.
func (ejori ExportJobsOperationResultInfo) AsBasicOperationResultInfoBase() (BasicOperationResultInfoBase, bool) {
	return &ejori, true
}

// GenericRecoveryPoint generic backup copy.
type GenericRecoveryPoint struct {
	// FriendlyName - Friendly name of the backup copy.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// RecoveryPointType - Type of the backup copy.
	RecoveryPointType *string `json:"recoveryPointType,omitempty"`
	// RecoveryPointTime - The time when this backup copy was created.
	RecoveryPointTime *date.Time `json:"recoveryPointTime,omitempty"`
	// RecoveryPointAdditionalInfo - Additional information associated with this backup copy.
	RecoveryPointAdditionalInfo *string `json:"recoveryPointAdditionalInfo,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeRecoveryPoint', 'ObjectTypeIaasVMRecoveryPoint', 'ObjectTypeGenericRecoveryPoint'
	ObjectType ObjectTypeBasicRecoveryPoint `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for GenericRecoveryPoint.
func (grp GenericRecoveryPoint) MarshalJSON() ([]byte, error) {
	grp.ObjectType = ObjectTypeGenericRecoveryPoint
	objectMap := make(map[string]interface{})
	if grp.FriendlyName != nil {
		objectMap["friendlyName"] = grp.FriendlyName
	}
	if grp.RecoveryPointType != nil {
		objectMap["recoveryPointType"] = grp.RecoveryPointType
	}
	if grp.RecoveryPointTime != nil {
		objectMap["recoveryPointTime"] = grp.RecoveryPointTime
	}
	if grp.RecoveryPointAdditionalInfo != nil {
		objectMap["recoveryPointAdditionalInfo"] = grp.RecoveryPointAdditionalInfo
	}
	if grp.ObjectType != "" {
		objectMap["objectType"] = grp.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsIaasVMRecoveryPoint is the BasicRecoveryPoint implementation for GenericRecoveryPoint.
func (grp GenericRecoveryPoint) AsIaasVMRecoveryPoint() (*IaasVMRecoveryPoint, bool) {
	return nil, false
}

// AsGenericRecoveryPoint is the BasicRecoveryPoint implementation for GenericRecoveryPoint.
func (grp GenericRecoveryPoint) AsGenericRecoveryPoint() (*GenericRecoveryPoint, bool) {
	return &grp, true
}

// AsRecoveryPoint is the BasicRecoveryPoint implementation for GenericRecoveryPoint.
func (grp GenericRecoveryPoint) AsRecoveryPoint() (*RecoveryPoint, bool) {
	return nil, false
}

// AsBasicRecoveryPoint is the BasicRecoveryPoint implementation for GenericRecoveryPoint.
func (grp GenericRecoveryPoint) AsBasicRecoveryPoint() (BasicRecoveryPoint, bool) {
	return &grp, true
}

// GetProtectedItemQueryObject this object filters the list of backup items.
type GetProtectedItemQueryObject struct {
	// Expand - Specifies if the additional information should be provided for this item.
	Expand *string `json:"expand,omitempty"`
}

// IaasVMBackupRequest this is an Azure VM (also known as IaaS VM) workload-specific backup request.
type IaasVMBackupRequest struct {
	// RecoveryPointExpiryTimeInUTC - The backup copy will expire after the time specified. The time is in UTC format.
	RecoveryPointExpiryTimeInUTC *date.Time `json:"recoveryPointExpiryTimeInUTC,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeBackupRequest', 'ObjectTypeIaasVMBackupRequest'
	ObjectType ObjectTypeBasicRequest `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for IaasVMBackupRequest.
func (ivbr IaasVMBackupRequest) MarshalJSON() ([]byte, error) {
	ivbr.ObjectType = ObjectTypeIaasVMBackupRequest
	objectMap := make(map[string]interface{})
	if ivbr.RecoveryPointExpiryTimeInUTC != nil {
		objectMap["recoveryPointExpiryTimeInUTC"] = ivbr.RecoveryPointExpiryTimeInUTC
	}
	if ivbr.ObjectType != "" {
		objectMap["objectType"] = ivbr.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsIaasVMBackupRequest is the BasicRequest implementation for IaasVMBackupRequest.
func (ivbr IaasVMBackupRequest) AsIaasVMBackupRequest() (*IaasVMBackupRequest, bool) {
	return &ivbr, true
}

// AsRequest is the BasicRequest implementation for IaasVMBackupRequest.
func (ivbr IaasVMBackupRequest) AsRequest() (*Request, bool) {
	return nil, false
}

// AsBasicRequest is the BasicRequest implementation for IaasVMBackupRequest.
func (ivbr IaasVMBackupRequest) AsBasicRequest() (BasicRequest, bool) {
	return &ivbr, true
}

// BasicIaaSVMContainer iaaS VM workload-specific container.
type BasicIaaSVMContainer interface {
	AsAzureIaaSComputeVMContainer() (*AzureIaaSComputeVMContainer, bool)
	AsAzureIaaSClassicComputeVMContainer() (*AzureIaaSClassicComputeVMContainer, bool)
	AsIaaSVMContainer() (*IaaSVMContainer, bool)
}

// IaaSVMContainer iaaS VM workload-specific container.
type IaaSVMContainer struct {
	// VirtualMachineID - The fully qualified Resource Manager URL of the virtual machine represented by this Azure IaaS VM container.
	VirtualMachineID *string `json:"virtualMachineId,omitempty"`
	// VirtualMachineVersion - Specifies whether the container represents a classic or a Resource Manager-deployed virtual machine.
	VirtualMachineVersion *string `json:"virtualMachineVersion,omitempty"`
	// ResourceGroup - The resource group name associated with the Recovery Services vault.
	ResourceGroup *string `json:"resourceGroup,omitempty"`
	// FriendlyName - Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// BackupManagementType - The backup management type for the container. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// RegistrationStatus - The container's registration status with the Recovery Services vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`
	// HealthStatus - The status of the container's health.
	HealthStatus *string `json:"healthStatus,omitempty"`
	// ContainerType - READ-ONLY; The type assigned to the container. The values to use for each of these properties are:<br/> 1. Compute Azure VM is Microsoft.Compute/virtualMachines<br/> 2. Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines<br/> 3. Windows machines (like Azure Backup Server and DPM) is Windows<br/> 4. Azure SQL instance is AzureSqlContainer.
	ContainerType *string `json:"containerType,omitempty"`
	// ProtectableObjectType - Possible values include: 'ProtectableObjectTypeProtectionContainer', 'ProtectableObjectTypeAzureSQLContainer', 'ProtectableObjectTypeIaaSVMContainer', 'ProtectableObjectTypeMABWindowsContainer', 'ProtectableObjectTypeMicrosoftComputevirtualMachines', 'ProtectableObjectTypeMicrosoftClassicComputevirtualMachines'
	ProtectableObjectType ProtectableObjectType `json:"protectableObjectType,omitempty"`
}

func unmarshalBasicIaaSVMContainer(body []byte) (BasicIaaSVMContainer, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["protectableObjectType"] {
	case string(ProtectableObjectTypeMicrosoftComputevirtualMachines):
		var aiscvc AzureIaaSComputeVMContainer
		err := json.Unmarshal(body, &aiscvc)
		return aiscvc, err
	case string(ProtectableObjectTypeMicrosoftClassicComputevirtualMachines):
		var aisccvc AzureIaaSClassicComputeVMContainer
		err := json.Unmarshal(body, &aisccvc)
		return aisccvc, err
	default:
		var isc IaaSVMContainer
		err := json.Unmarshal(body, &isc)
		return isc, err
	}
}
func unmarshalBasicIaaSVMContainerArray(body []byte) ([]BasicIaaSVMContainer, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	iscArray := make([]BasicIaaSVMContainer, len(rawMessages))

	for index, rawMessage := range rawMessages {
		isc, err := unmarshalBasicIaaSVMContainer(*rawMessage)
		if err != nil {
			return nil, err
		}
		iscArray[index] = isc
	}
	return iscArray, nil
}

// MarshalJSON is the custom marshaler for IaaSVMContainer.
func (isc IaaSVMContainer) MarshalJSON() ([]byte, error) {
	isc.ProtectableObjectType = ProtectableObjectTypeIaaSVMContainer
	objectMap := make(map[string]interface{})
	if isc.VirtualMachineID != nil {
		objectMap["virtualMachineId"] = isc.VirtualMachineID
	}
	if isc.VirtualMachineVersion != nil {
		objectMap["virtualMachineVersion"] = isc.VirtualMachineVersion
	}
	if isc.ResourceGroup != nil {
		objectMap["resourceGroup"] = isc.ResourceGroup
	}
	if isc.FriendlyName != nil {
		objectMap["friendlyName"] = isc.FriendlyName
	}
	if isc.BackupManagementType != "" {
		objectMap["backupManagementType"] = isc.BackupManagementType
	}
	if isc.RegistrationStatus != nil {
		objectMap["registrationStatus"] = isc.RegistrationStatus
	}
	if isc.HealthStatus != nil {
		objectMap["healthStatus"] = isc.HealthStatus
	}
	if isc.ProtectableObjectType != "" {
		objectMap["protectableObjectType"] = isc.ProtectableObjectType
	}
	return json.Marshal(objectMap)
}

// AsAzureSQLContainer is the BasicProtectionContainer implementation for IaaSVMContainer.
func (isc IaaSVMContainer) AsAzureSQLContainer() (*AzureSQLContainer, bool) {
	return nil, false
}

// AsIaaSVMContainer is the BasicProtectionContainer implementation for IaaSVMContainer.
func (isc IaaSVMContainer) AsIaaSVMContainer() (*IaaSVMContainer, bool) {
	return &isc, true
}

// AsBasicIaaSVMContainer is the BasicProtectionContainer implementation for IaaSVMContainer.
func (isc IaaSVMContainer) AsBasicIaaSVMContainer() (BasicIaaSVMContainer, bool) {
	return &isc, true
}

// AsMabContainer is the BasicProtectionContainer implementation for IaaSVMContainer.
func (isc IaaSVMContainer) AsMabContainer() (*MabContainer, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMContainer is the BasicProtectionContainer implementation for IaaSVMContainer.
func (isc IaaSVMContainer) AsAzureIaaSComputeVMContainer() (*AzureIaaSComputeVMContainer, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMContainer is the BasicProtectionContainer implementation for IaaSVMContainer.
func (isc IaaSVMContainer) AsAzureIaaSClassicComputeVMContainer() (*AzureIaaSClassicComputeVMContainer, bool) {
	return nil, false
}

// AsProtectionContainer is the BasicProtectionContainer implementation for IaaSVMContainer.
func (isc IaaSVMContainer) AsProtectionContainer() (*ProtectionContainer, bool) {
	return nil, false
}

// AsBasicProtectionContainer is the BasicProtectionContainer implementation for IaaSVMContainer.
func (isc IaaSVMContainer) AsBasicProtectionContainer() (BasicProtectionContainer, bool) {
	return &isc, true
}

// IaasVMILRRegistrationRequest restore files or folders from a backup copy, or recovery point, of an IaaS
// (or Azure) VM.
type IaasVMILRRegistrationRequest struct {
	// RecoveryPointID - The ID of the IaaS VM recovery point used to restore the files or folders.
	RecoveryPointID *string `json:"recoveryPointId,omitempty"`
	// VirtualMachineID - The fully qualified Resource Manager ID of the VM used to restore the files or folders.
	VirtualMachineID *string `json:"virtualMachineId,omitempty"`
	// InitiatorName - The iSCSI initiator name.
	InitiatorName *string `json:"initiatorName,omitempty"`
	// RenewExistingRegistration - Whether to renew the existing registration with the iSCSI server.
	RenewExistingRegistration *bool `json:"renewExistingRegistration,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeILRRequest', 'ObjectTypeIaasVMILRRegistrationRequest'
	ObjectType ObjectTypeBasicILRRequest `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for IaasVMILRRegistrationRequest.
func (ivrr IaasVMILRRegistrationRequest) MarshalJSON() ([]byte, error) {
	ivrr.ObjectType = ObjectTypeIaasVMILRRegistrationRequest
	objectMap := make(map[string]interface{})
	if ivrr.RecoveryPointID != nil {
		objectMap["recoveryPointId"] = ivrr.RecoveryPointID
	}
	if ivrr.VirtualMachineID != nil {
		objectMap["virtualMachineId"] = ivrr.VirtualMachineID
	}
	if ivrr.InitiatorName != nil {
		objectMap["initiatorName"] = ivrr.InitiatorName
	}
	if ivrr.RenewExistingRegistration != nil {
		objectMap["renewExistingRegistration"] = ivrr.RenewExistingRegistration
	}
	if ivrr.ObjectType != "" {
		objectMap["objectType"] = ivrr.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsIaasVMILRRegistrationRequest is the BasicILRRequest implementation for IaasVMILRRegistrationRequest.
func (ivrr IaasVMILRRegistrationRequest) AsIaasVMILRRegistrationRequest() (*IaasVMILRRegistrationRequest, bool) {
	return &ivrr, true
}

// AsILRRequest is the BasicILRRequest implementation for IaasVMILRRegistrationRequest.
func (ivrr IaasVMILRRegistrationRequest) AsILRRequest() (*ILRRequest, bool) {
	return nil, false
}

// AsBasicILRRequest is the BasicILRRequest implementation for IaasVMILRRegistrationRequest.
func (ivrr IaasVMILRRegistrationRequest) AsBasicILRRequest() (BasicILRRequest, bool) {
	return &ivrr, true
}

// BasicIaaSVMProtectableItem this Azure VM workload-specific (also known as IaaS VM workload-specific) backup item can
// be backed up.
type BasicIaaSVMProtectableItem interface {
	AsAzureIaaSComputeVMProtectableItem() (*AzureIaaSComputeVMProtectableItem, bool)
	AsAzureIaaSClassicComputeVMProtectableItem() (*AzureIaaSClassicComputeVMProtectableItem, bool)
	AsIaaSVMProtectableItem() (*IaaSVMProtectableItem, bool)
}

// IaaSVMProtectableItem this Azure VM workload-specific (also known as IaaS VM workload-specific) backup item
// can be backed up.
type IaaSVMProtectableItem struct {
	// VirtualMachineID - The fully qualified Resource Manager ID of the virtual machine.
	VirtualMachineID *string `json:"virtualMachineId,omitempty"`
	// BackupManagementType - The backup management type.
	BackupManagementType *string `json:"backupManagementType,omitempty"`
	// FriendlyName - The friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ProtectionState - The state of the back up item. Possible values include: 'ProtectionStatusInvalid', 'ProtectionStatusNotProtected', 'ProtectionStatusProtecting', 'ProtectionStatusProtected'
	ProtectionState ProtectionStatus `json:"protectionState,omitempty"`
	// ProtectableItemType - Possible values include: 'ProtectableItemTypeWorkloadProtectableItem', 'ProtectableItemTypeIaaSVMProtectableItem', 'ProtectableItemTypeMicrosoftComputevirtualMachines', 'ProtectableItemTypeMicrosoftClassicComputevirtualMachines'
	ProtectableItemType ProtectableItemType `json:"protectableItemType,omitempty"`
}

func unmarshalBasicIaaSVMProtectableItem(body []byte) (BasicIaaSVMProtectableItem, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["protectableItemType"] {
	case string(ProtectableItemTypeMicrosoftComputevirtualMachines):
		var aiscvpi AzureIaaSComputeVMProtectableItem
		err := json.Unmarshal(body, &aiscvpi)
		return aiscvpi, err
	case string(ProtectableItemTypeMicrosoftClassicComputevirtualMachines):
		var aisccvpi AzureIaaSClassicComputeVMProtectableItem
		err := json.Unmarshal(body, &aisccvpi)
		return aisccvpi, err
	default:
		var ispi IaaSVMProtectableItem
		err := json.Unmarshal(body, &ispi)
		return ispi, err
	}
}
func unmarshalBasicIaaSVMProtectableItemArray(body []byte) ([]BasicIaaSVMProtectableItem, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	ispiArray := make([]BasicIaaSVMProtectableItem, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ispi, err := unmarshalBasicIaaSVMProtectableItem(*rawMessage)
		if err != nil {
			return nil, err
		}
		ispiArray[index] = ispi
	}
	return ispiArray, nil
}

// MarshalJSON is the custom marshaler for IaaSVMProtectableItem.
func (ispi IaaSVMProtectableItem) MarshalJSON() ([]byte, error) {
	ispi.ProtectableItemType = ProtectableItemTypeIaaSVMProtectableItem
	objectMap := make(map[string]interface{})
	if ispi.VirtualMachineID != nil {
		objectMap["virtualMachineId"] = ispi.VirtualMachineID
	}
	if ispi.BackupManagementType != nil {
		objectMap["backupManagementType"] = ispi.BackupManagementType
	}
	if ispi.FriendlyName != nil {
		objectMap["friendlyName"] = ispi.FriendlyName
	}
	if ispi.ProtectionState != "" {
		objectMap["protectionState"] = ispi.ProtectionState
	}
	if ispi.ProtectableItemType != "" {
		objectMap["protectableItemType"] = ispi.ProtectableItemType
	}
	return json.Marshal(objectMap)
}

// AsIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for IaaSVMProtectableItem.
func (ispi IaaSVMProtectableItem) AsIaaSVMProtectableItem() (*IaaSVMProtectableItem, bool) {
	return &ispi, true
}

// AsBasicIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for IaaSVMProtectableItem.
func (ispi IaaSVMProtectableItem) AsBasicIaaSVMProtectableItem() (BasicIaaSVMProtectableItem, bool) {
	return &ispi, true
}

// AsAzureIaaSComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for IaaSVMProtectableItem.
func (ispi IaaSVMProtectableItem) AsAzureIaaSComputeVMProtectableItem() (*AzureIaaSComputeVMProtectableItem, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for IaaSVMProtectableItem.
func (ispi IaaSVMProtectableItem) AsAzureIaaSClassicComputeVMProtectableItem() (*AzureIaaSClassicComputeVMProtectableItem, bool) {
	return nil, false
}

// AsWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for IaaSVMProtectableItem.
func (ispi IaaSVMProtectableItem) AsWorkloadProtectableItem() (*WorkloadProtectableItem, bool) {
	return nil, false
}

// AsBasicWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for IaaSVMProtectableItem.
func (ispi IaaSVMProtectableItem) AsBasicWorkloadProtectableItem() (BasicWorkloadProtectableItem, bool) {
	return &ispi, true
}

// IaasVMRecoveryPoint azure VM (also known as IaaS VM) workload-specific backup copy.
type IaasVMRecoveryPoint struct {
	// RecoveryPointType - Type of the backup copy.
	RecoveryPointType *string `json:"recoveryPointType,omitempty"`
	// RecoveryPointTime - The date and time when the backup copy was created.
	RecoveryPointTime *date.Time `json:"recoveryPointTime,omitempty"`
	// RecoveryPointAdditionalInfo - Additional information associated with this backup copy.
	RecoveryPointAdditionalInfo *string `json:"recoveryPointAdditionalInfo,omitempty"`
	// SourceVMStorageType - The storage type for the VM whose backup copy was created.
	SourceVMStorageType *string `json:"sourceVMStorageType,omitempty"`
	// IsSourceVMEncrypted - Identifies whether the VM was encrypted when the backup copy is created.
	IsSourceVMEncrypted *bool `json:"isSourceVMEncrypted,omitempty"`
	// KeyAndSecret - Required details for recovering an encrypted VM. Applicable only when IsSourceVMEncrypted is true.
	KeyAndSecret *KeyAndSecretDetails `json:"keyAndSecret,omitempty"`
	// IsInstantILRSessionActive - Answer to the question - Is the session to recover items from this backup copy still active.
	IsInstantILRSessionActive *bool `json:"isInstantILRSessionActive,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeRecoveryPoint', 'ObjectTypeIaasVMRecoveryPoint', 'ObjectTypeGenericRecoveryPoint'
	ObjectType ObjectTypeBasicRecoveryPoint `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for IaasVMRecoveryPoint.
func (ivrp IaasVMRecoveryPoint) MarshalJSON() ([]byte, error) {
	ivrp.ObjectType = ObjectTypeIaasVMRecoveryPoint
	objectMap := make(map[string]interface{})
	if ivrp.RecoveryPointType != nil {
		objectMap["recoveryPointType"] = ivrp.RecoveryPointType
	}
	if ivrp.RecoveryPointTime != nil {
		objectMap["recoveryPointTime"] = ivrp.RecoveryPointTime
	}
	if ivrp.RecoveryPointAdditionalInfo != nil {
		objectMap["recoveryPointAdditionalInfo"] = ivrp.RecoveryPointAdditionalInfo
	}
	if ivrp.SourceVMStorageType != nil {
		objectMap["sourceVMStorageType"] = ivrp.SourceVMStorageType
	}
	if ivrp.IsSourceVMEncrypted != nil {
		objectMap["isSourceVMEncrypted"] = ivrp.IsSourceVMEncrypted
	}
	if ivrp.KeyAndSecret != nil {
		objectMap["keyAndSecret"] = ivrp.KeyAndSecret
	}
	if ivrp.IsInstantILRSessionActive != nil {
		objectMap["isInstantILRSessionActive"] = ivrp.IsInstantILRSessionActive
	}
	if ivrp.ObjectType != "" {
		objectMap["objectType"] = ivrp.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsIaasVMRecoveryPoint is the BasicRecoveryPoint implementation for IaasVMRecoveryPoint.
func (ivrp IaasVMRecoveryPoint) AsIaasVMRecoveryPoint() (*IaasVMRecoveryPoint, bool) {
	return &ivrp, true
}

// AsGenericRecoveryPoint is the BasicRecoveryPoint implementation for IaasVMRecoveryPoint.
func (ivrp IaasVMRecoveryPoint) AsGenericRecoveryPoint() (*GenericRecoveryPoint, bool) {
	return nil, false
}

// AsRecoveryPoint is the BasicRecoveryPoint implementation for IaasVMRecoveryPoint.
func (ivrp IaasVMRecoveryPoint) AsRecoveryPoint() (*RecoveryPoint, bool) {
	return nil, false
}

// AsBasicRecoveryPoint is the BasicRecoveryPoint implementation for IaasVMRecoveryPoint.
func (ivrp IaasVMRecoveryPoint) AsBasicRecoveryPoint() (BasicRecoveryPoint, bool) {
	return &ivrp, true
}

// IaasVMRestoreRequest iaaS VM workload-specific restore.
type IaasVMRestoreRequest struct {
	// RecoveryPointID - The ID of the backup copy to be recovered.
	RecoveryPointID *string `json:"recoveryPointId,omitempty"`
	// RecoveryType - The type of this recovery. Possible values include: 'RecoveryTypeInvalid', 'RecoveryTypeOriginalLocation', 'RecoveryTypeAlternateLocation', 'RecoveryTypeRestoreDisks'
	RecoveryType RecoveryType `json:"recoveryType,omitempty"`
	// SourceResourceID - The fully qualified Resource Manager ID of the VM being recovered.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
	// TargetVirtualMachineID - The complete Resource Manager ID of the VM that will be created.
	//             For example: /subscriptions/{subId}/resourcegroups/{rg}/provider/Microsoft.Compute/virtualmachines/{vm}
	TargetVirtualMachineID *string `json:"targetVirtualMachineId,omitempty"`
	// TargetResourceGroupID - The Resource Manager ID of the resource group you're creating for this VM and other artifacts.
	//     For example: /subscriptions/{subId}/resourcegroups/{rg}
	TargetResourceGroupID *string `json:"targetResourceGroupId,omitempty"`
	// StorageAccountID - The fully qualified Resource Manager ID of the storage account where the VM will be restored.
	StorageAccountID *string `json:"storageAccountId,omitempty"`
	// VirtualNetworkID - This is the virtual network ID of the vnet that is attached to the virtual machine.
	//             Your join action permissions are validated during the linked access.
	VirtualNetworkID *string `json:"virtualNetworkId,omitempty"`
	// SubnetID - Subnet ID is the identifier for the VM to be restored. For Classic VMs the subnet ID would be {VnetID}/Subnet/{SubnetName}, and for the Resource Manager VMs, the subnet ID would be the Resource Manager resource ID used to represent the subnet.
	SubnetID *string `json:"subnetId,omitempty"`
	// TargetDomainNameID - The fully qualified Resource Manager ID of the domain name to be associated with the VM being restored. Use the Resource Manager ID to identify the domain, only for Classic-deployed virtual machines.
	TargetDomainNameID *string `json:"targetDomainNameId,omitempty"`
	// Region - The region where the virtual machine is restored.
	Region *string `json:"region,omitempty"`
	// AffinityGroup - The affinity group associated with the VM to be restored. Affinity groups are used only for Classic-deployed virtual machines.
	AffinityGroup *string `json:"affinityGroup,omitempty"`
	// CreateNewCloudService - Asks the question if a new cloud service should be created while restoring the VM. If the answer is false, the VM is restored to the same cloud service.
	CreateNewCloudService *bool `json:"createNewCloudService,omitempty"`
	// EncryptionDetails - If the VM was encrypted at the time of backup, these details are needed.
	EncryptionDetails *EncryptionDetails `json:"encryptionDetails,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeRestoreRequest', 'ObjectTypeIaasVMRestoreRequest'
	ObjectType ObjectTypeBasicRestoreRequest `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for IaasVMRestoreRequest.
func (ivrr IaasVMRestoreRequest) MarshalJSON() ([]byte, error) {
	ivrr.ObjectType = ObjectTypeIaasVMRestoreRequest
	objectMap := make(map[string]interface{})
	if ivrr.RecoveryPointID != nil {
		objectMap["recoveryPointId"] = ivrr.RecoveryPointID
	}
	if ivrr.RecoveryType != "" {
		objectMap["recoveryType"] = ivrr.RecoveryType
	}
	if ivrr.SourceResourceID != nil {
		objectMap["sourceResourceId"] = ivrr.SourceResourceID
	}
	if ivrr.TargetVirtualMachineID != nil {
		objectMap["targetVirtualMachineId"] = ivrr.TargetVirtualMachineID
	}
	if ivrr.TargetResourceGroupID != nil {
		objectMap["targetResourceGroupId"] = ivrr.TargetResourceGroupID
	}
	if ivrr.StorageAccountID != nil {
		objectMap["storageAccountId"] = ivrr.StorageAccountID
	}
	if ivrr.VirtualNetworkID != nil {
		objectMap["virtualNetworkId"] = ivrr.VirtualNetworkID
	}
	if ivrr.SubnetID != nil {
		objectMap["subnetId"] = ivrr.SubnetID
	}
	if ivrr.TargetDomainNameID != nil {
		objectMap["targetDomainNameId"] = ivrr.TargetDomainNameID
	}
	if ivrr.Region != nil {
		objectMap["region"] = ivrr.Region
	}
	if ivrr.AffinityGroup != nil {
		objectMap["affinityGroup"] = ivrr.AffinityGroup
	}
	if ivrr.CreateNewCloudService != nil {
		objectMap["createNewCloudService"] = ivrr.CreateNewCloudService
	}
	if ivrr.EncryptionDetails != nil {
		objectMap["encryptionDetails"] = ivrr.EncryptionDetails
	}
	if ivrr.ObjectType != "" {
		objectMap["objectType"] = ivrr.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsIaasVMRestoreRequest is the BasicRestoreRequest implementation for IaasVMRestoreRequest.
func (ivrr IaasVMRestoreRequest) AsIaasVMRestoreRequest() (*IaasVMRestoreRequest, bool) {
	return &ivrr, true
}

// AsRestoreRequest is the BasicRestoreRequest implementation for IaasVMRestoreRequest.
func (ivrr IaasVMRestoreRequest) AsRestoreRequest() (*RestoreRequest, bool) {
	return nil, false
}

// AsBasicRestoreRequest is the BasicRestoreRequest implementation for IaasVMRestoreRequest.
func (ivrr IaasVMRestoreRequest) AsBasicRestoreRequest() (BasicRestoreRequest, bool) {
	return &ivrr, true
}

// BasicILRRequest parameters to restore file or folders API.
type BasicILRRequest interface {
	AsIaasVMILRRegistrationRequest() (*IaasVMILRRegistrationRequest, bool)
	AsILRRequest() (*ILRRequest, bool)
}

// ILRRequest parameters to restore file or folders API.
type ILRRequest struct {
	// ObjectType - Possible values include: 'ObjectTypeILRRequest', 'ObjectTypeIaasVMILRRegistrationRequest'
	ObjectType ObjectTypeBasicILRRequest `json:"objectType,omitempty"`
}

func unmarshalBasicILRRequest(body []byte) (BasicILRRequest, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["objectType"] {
	case string(ObjectTypeIaasVMILRRegistrationRequest):
		var ivrr IaasVMILRRegistrationRequest
		err := json.Unmarshal(body, &ivrr)
		return ivrr, err
	default:
		var ir ILRRequest
		err := json.Unmarshal(body, &ir)
		return ir, err
	}
}
func unmarshalBasicILRRequestArray(body []byte) ([]BasicILRRequest, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	irArray := make([]BasicILRRequest, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ir, err := unmarshalBasicILRRequest(*rawMessage)
		if err != nil {
			return nil, err
		}
		irArray[index] = ir
	}
	return irArray, nil
}

// MarshalJSON is the custom marshaler for ILRRequest.
func (ir ILRRequest) MarshalJSON() ([]byte, error) {
	ir.ObjectType = ObjectTypeILRRequest
	objectMap := make(map[string]interface{})
	if ir.ObjectType != "" {
		objectMap["objectType"] = ir.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsIaasVMILRRegistrationRequest is the BasicILRRequest implementation for ILRRequest.
func (ir ILRRequest) AsIaasVMILRRegistrationRequest() (*IaasVMILRRegistrationRequest, bool) {
	return nil, false
}

// AsILRRequest is the BasicILRRequest implementation for ILRRequest.
func (ir ILRRequest) AsILRRequest() (*ILRRequest, bool) {
	return &ir, true
}

// AsBasicILRRequest is the BasicILRRequest implementation for ILRRequest.
func (ir ILRRequest) AsBasicILRRequest() (BasicILRRequest, bool) {
	return &ir, true
}

// ILRRequestResource the parameters to restore files or folders.
type ILRRequestResource struct {
	Properties BasicILRRequest `json:"properties,omitempty"`
	// ID - Resource ID represents the complete path to the resource.
	ID *string `json:"id,omitempty"`
	// Name - Resource name associated with the resource.
	Name *string `json:"name,omitempty"`
	// Type - Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ETag - Optional ETag.
	ETag *string `json:"eTag,omitempty"`
}

// MarshalJSON is the custom marshaler for ILRRequestResource.
func (irr ILRRequestResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = irr.Properties
	if irr.ID != nil {
		objectMap["id"] = irr.ID
	}
	if irr.Name != nil {
		objectMap["name"] = irr.Name
	}
	if irr.Type != nil {
		objectMap["type"] = irr.Type
	}
	if irr.Location != nil {
		objectMap["location"] = irr.Location
	}
	if irr.Tags != nil {
		objectMap["tags"] = irr.Tags
	}
	if irr.ETag != nil {
		objectMap["eTag"] = irr.ETag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ILRRequestResource struct.
func (irr *ILRRequestResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicILRRequest(*v)
				if err != nil {
					return err
				}
				irr.Properties = properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				irr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				irr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				irr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				irr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				irr.Tags = tags
			}
		case "eTag":
			if v != nil {
				var eTag string
				err = json.Unmarshal(*v, &eTag)
				if err != nil {
					return err
				}
				irr.ETag = &eTag
			}
		}
	}

	return nil
}

// InstantItemRecoveryTarget target details for the file or folder restore.
type InstantItemRecoveryTarget struct {
	// ClientScripts - List of client scripts.
	ClientScripts *[]ClientScriptForConnect `json:"clientScripts,omitempty"`
}

// BasicJob defines workload-agnostic properties for a job.
type BasicJob interface {
	AsAzureIaaSVMJob() (*AzureIaaSVMJob, bool)
	AsDpmJob() (*DpmJob, bool)
	AsMabJob() (*MabJob, bool)
	AsJob() (*Job, bool)
}

// Job defines workload-agnostic properties for a job.
type Job struct {
	// EntityFriendlyName - The friendly name of the entity on which the current job is executing.
	EntityFriendlyName *string `json:"entityFriendlyName,omitempty"`
	// BackupManagementType - The backup management type for the current job. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// Operation - The operation name.
	Operation *string `json:"operation,omitempty"`
	// Status - The job status.
	Status *string `json:"status,omitempty"`
	// StartTime - The start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The end time.
	EndTime *date.Time `json:"endTime,omitempty"`
	// ActivityID - ActivityId of job.
	ActivityID *string `json:"activityId,omitempty"`
	// JobType - Possible values include: 'JobTypeJob', 'JobTypeAzureIaaSVMJob', 'JobTypeDpmJob', 'JobTypeMabJob'
	JobType JobType `json:"jobType,omitempty"`
}

func unmarshalBasicJob(body []byte) (BasicJob, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["jobType"] {
	case string(JobTypeAzureIaaSVMJob):
		var aisj AzureIaaSVMJob
		err := json.Unmarshal(body, &aisj)
		return aisj, err
	case string(JobTypeDpmJob):
		var dj DpmJob
		err := json.Unmarshal(body, &dj)
		return dj, err
	case string(JobTypeMabJob):
		var mj MabJob
		err := json.Unmarshal(body, &mj)
		return mj, err
	default:
		var j Job
		err := json.Unmarshal(body, &j)
		return j, err
	}
}
func unmarshalBasicJobArray(body []byte) ([]BasicJob, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	jArray := make([]BasicJob, len(rawMessages))

	for index, rawMessage := range rawMessages {
		j, err := unmarshalBasicJob(*rawMessage)
		if err != nil {
			return nil, err
		}
		jArray[index] = j
	}
	return jArray, nil
}

// MarshalJSON is the custom marshaler for Job.
func (j Job) MarshalJSON() ([]byte, error) {
	j.JobType = JobTypeJob
	objectMap := make(map[string]interface{})
	if j.EntityFriendlyName != nil {
		objectMap["entityFriendlyName"] = j.EntityFriendlyName
	}
	if j.BackupManagementType != "" {
		objectMap["backupManagementType"] = j.BackupManagementType
	}
	if j.Operation != nil {
		objectMap["operation"] = j.Operation
	}
	if j.Status != nil {
		objectMap["status"] = j.Status
	}
	if j.StartTime != nil {
		objectMap["startTime"] = j.StartTime
	}
	if j.EndTime != nil {
		objectMap["endTime"] = j.EndTime
	}
	if j.ActivityID != nil {
		objectMap["activityId"] = j.ActivityID
	}
	if j.JobType != "" {
		objectMap["jobType"] = j.JobType
	}
	return json.Marshal(objectMap)
}

// AsAzureIaaSVMJob is the BasicJob implementation for Job.
func (j Job) AsAzureIaaSVMJob() (*AzureIaaSVMJob, bool) {
	return nil, false
}

// AsDpmJob is the BasicJob implementation for Job.
func (j Job) AsDpmJob() (*DpmJob, bool) {
	return nil, false
}

// AsMabJob is the BasicJob implementation for Job.
func (j Job) AsMabJob() (*MabJob, bool) {
	return nil, false
}

// AsJob is the BasicJob implementation for Job.
func (j Job) AsJob() (*Job, bool) {
	return &j, true
}

// AsBasicJob is the BasicJob implementation for Job.
func (j Job) AsBasicJob() (BasicJob, bool) {
	return &j, true
}

// JobQueryObject the filters to list the jobs.
type JobQueryObject struct {
	// Status - Status of the job. Possible values include: 'JobStatusInvalid', 'JobStatusInProgress', 'JobStatusCompleted', 'JobStatusFailed', 'JobStatusCompletedWithWarnings', 'JobStatusCancelled', 'JobStatusCancelling'
	Status JobStatus `json:"status,omitempty"`
	// BackupManagementType - Type of backup management for the job. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// Operation - The type of operation. Possible values include: 'JobOperationTypeInvalid', 'JobOperationTypeConfigureBackup', 'JobOperationTypeBackup', 'JobOperationTypeRestore', 'JobOperationTypeDisableBackup', 'JobOperationTypeDeleteBackupData'
	Operation JobOperationType `json:"operation,omitempty"`
	// JobID - The ID of the job. Each jobID is unique.
	JobID *string `json:"jobId,omitempty"`
	// StartTime - The time when the job starts. The value is in UTC.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The time when the job ends. The value is in UTC.
	EndTime *date.Time `json:"endTime,omitempty"`
}

// JobResource defines the workload-agnostic properties for a job.
type JobResource struct {
	autorest.Response `json:"-"`
	Properties        BasicJob `json:"properties,omitempty"`
	// ID - Resource ID represents the complete path to the resource.
	ID *string `json:"id,omitempty"`
	// Name - Resource name associated with the resource.
	Name *string `json:"name,omitempty"`
	// Type - Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ETag - Optional ETag.
	ETag *string `json:"eTag,omitempty"`
}

// MarshalJSON is the custom marshaler for JobResource.
func (jr JobResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = jr.Properties
	if jr.ID != nil {
		objectMap["id"] = jr.ID
	}
	if jr.Name != nil {
		objectMap["name"] = jr.Name
	}
	if jr.Type != nil {
		objectMap["type"] = jr.Type
	}
	if jr.Location != nil {
		objectMap["location"] = jr.Location
	}
	if jr.Tags != nil {
		objectMap["tags"] = jr.Tags
	}
	if jr.ETag != nil {
		objectMap["eTag"] = jr.ETag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for JobResource struct.
func (jr *JobResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicJob(*v)
				if err != nil {
					return err
				}
				jr.Properties = properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				jr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				jr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				jr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				jr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				jr.Tags = tags
			}
		case "eTag":
			if v != nil {
				var eTag string
				err = json.Unmarshal(*v, &eTag)
				if err != nil {
					return err
				}
				jr.ETag = &eTag
			}
		}
	}

	return nil
}

// JobResourceList list of Job resources.
type JobResourceList struct {
	autorest.Response `json:"-"`
	// Value - List of resources.
	Value *[]JobResource `json:"value,omitempty"`
	// NextLink - The URI to GET the next page of resources. Call ListNext() gets the next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// JobResourceListIterator provides access to a complete listing of JobResource values.
type JobResourceListIterator struct {
	i    int
	page JobResourceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *JobResourceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobResourceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *JobResourceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter JobResourceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter JobResourceListIterator) Response() JobResourceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter JobResourceListIterator) Value() JobResource {
	if !iter.page.NotDone() {
		return JobResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the JobResourceListIterator type.
func NewJobResourceListIterator(page JobResourceListPage) JobResourceListIterator {
	return JobResourceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (jrl JobResourceList) IsEmpty() bool {
	return jrl.Value == nil || len(*jrl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (jrl JobResourceList) hasNextLink() bool {
	return jrl.NextLink != nil && len(*jrl.NextLink) != 0
}

// jobResourceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (jrl JobResourceList) jobResourceListPreparer(ctx context.Context) (*http.Request, error) {
	if !jrl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(jrl.NextLink)))
}

// JobResourceListPage contains a page of JobResource values.
type JobResourceListPage struct {
	fn  func(context.Context, JobResourceList) (JobResourceList, error)
	jrl JobResourceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *JobResourceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/JobResourceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.jrl)
		if err != nil {
			return err
		}
		page.jrl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *JobResourceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page JobResourceListPage) NotDone() bool {
	return !page.jrl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page JobResourceListPage) Response() JobResourceList {
	return page.jrl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page JobResourceListPage) Values() []JobResource {
	if page.jrl.IsEmpty() {
		return nil
	}
	return *page.jrl.Value
}

// Creates a new instance of the JobResourceListPage type.
func NewJobResourceListPage(cur JobResourceList, getNextPage func(context.Context, JobResourceList) (JobResourceList, error)) JobResourceListPage {
	return JobResourceListPage{
		fn:  getNextPage,
		jrl: cur,
	}
}

// KEKDetails the Key Encryption Key (KEK) is the encryption key for the Bitlocker Encryption Key (BEK).
type KEKDetails struct {
	// KeyURL - Key refers to the Key Encryption Key (KEK). The KEK is the Key to unlock the Secret.
	KeyURL *string `json:"keyUrl,omitempty"`
	// KeyVaultID - Key Vault ID identifies where the KEK is stored.
	KeyVaultID *string `json:"keyVaultId,omitempty"`
	// KeyBackupData - Key Backup Data refers to Key Encryption Key (KEK) data.
	KeyBackupData *string `json:"keyBackupData,omitempty"`
}

// KeyAndSecretDetails BEK stands for Bitlocker Encryption Key.
// KEK stands for Key Encryption Key. KEK is the encryption key used to protect the Secret for the BEK
// If the VM is encrypted, then the service stores the following details :
// 1. Secret(BEK) - Url + Backup Data + vaultID.
// 2. Key(KEK) - Url + Backup Data + vaultID.
// It is possible for the BEK and KEK to have different vaultIDs.
type KeyAndSecretDetails struct {
	// KekDetails - The Key Encryption Key (KEK) is the encryption key for the Bitlocker Encryption Key (BEK).
	KekDetails *KEKDetails `json:"kekDetails,omitempty"`
	// BekDetails - BEK is Bitlocker Encryption Key.
	BekDetails *BEKDetails `json:"bekDetails,omitempty"`
}

// LongTermRetentionPolicy long-term retention policy.
type LongTermRetentionPolicy struct {
	// DailySchedule - Daily retention schedule of the backup policy.
	DailySchedule *DailyRetentionSchedule `json:"dailySchedule,omitempty"`
	// WeeklySchedule - Weekly retention schedule of the backup policy.
	WeeklySchedule *WeeklyRetentionSchedule `json:"weeklySchedule,omitempty"`
	// MonthlySchedule - Monthly retention schedule of the backup policy.
	MonthlySchedule *MonthlyRetentionSchedule `json:"monthlySchedule,omitempty"`
	// YearlySchedule - Yearly retention schedule of the backup policy.
	YearlySchedule *YearlyRetentionSchedule `json:"yearlySchedule,omitempty"`
	// RetentionPolicyType - Possible values include: 'RetentionPolicyTypeRetentionPolicy', 'RetentionPolicyTypeSimpleRetentionPolicy', 'RetentionPolicyTypeLongTermRetentionPolicy'
	RetentionPolicyType RetentionPolicyType `json:"retentionPolicyType,omitempty"`
}

// MarshalJSON is the custom marshaler for LongTermRetentionPolicy.
func (ltrp LongTermRetentionPolicy) MarshalJSON() ([]byte, error) {
	ltrp.RetentionPolicyType = RetentionPolicyTypeLongTermRetentionPolicy
	objectMap := make(map[string]interface{})
	if ltrp.DailySchedule != nil {
		objectMap["dailySchedule"] = ltrp.DailySchedule
	}
	if ltrp.WeeklySchedule != nil {
		objectMap["weeklySchedule"] = ltrp.WeeklySchedule
	}
	if ltrp.MonthlySchedule != nil {
		objectMap["monthlySchedule"] = ltrp.MonthlySchedule
	}
	if ltrp.YearlySchedule != nil {
		objectMap["yearlySchedule"] = ltrp.YearlySchedule
	}
	if ltrp.RetentionPolicyType != "" {
		objectMap["retentionPolicyType"] = ltrp.RetentionPolicyType
	}
	return json.Marshal(objectMap)
}

// AsSimpleRetentionPolicy is the BasicRetentionPolicy implementation for LongTermRetentionPolicy.
func (ltrp LongTermRetentionPolicy) AsSimpleRetentionPolicy() (*SimpleRetentionPolicy, bool) {
	return nil, false
}

// AsLongTermRetentionPolicy is the BasicRetentionPolicy implementation for LongTermRetentionPolicy.
func (ltrp LongTermRetentionPolicy) AsLongTermRetentionPolicy() (*LongTermRetentionPolicy, bool) {
	return &ltrp, true
}

// AsRetentionPolicy is the BasicRetentionPolicy implementation for LongTermRetentionPolicy.
func (ltrp LongTermRetentionPolicy) AsRetentionPolicy() (*RetentionPolicy, bool) {
	return nil, false
}

// AsBasicRetentionPolicy is the BasicRetentionPolicy implementation for LongTermRetentionPolicy.
func (ltrp LongTermRetentionPolicy) AsBasicRetentionPolicy() (BasicRetentionPolicy, bool) {
	return &ltrp, true
}

// LongTermSchedulePolicy long-term policy schedule.
type LongTermSchedulePolicy struct {
	// SchedulePolicyType - Possible values include: 'SchedulePolicyTypeSchedulePolicy', 'SchedulePolicyTypeLongTermSchedulePolicy', 'SchedulePolicyTypeSimpleSchedulePolicy'
	SchedulePolicyType SchedulePolicyType `json:"schedulePolicyType,omitempty"`
}

// MarshalJSON is the custom marshaler for LongTermSchedulePolicy.
func (ltsp LongTermSchedulePolicy) MarshalJSON() ([]byte, error) {
	ltsp.SchedulePolicyType = SchedulePolicyTypeLongTermSchedulePolicy
	objectMap := make(map[string]interface{})
	if ltsp.SchedulePolicyType != "" {
		objectMap["schedulePolicyType"] = ltsp.SchedulePolicyType
	}
	return json.Marshal(objectMap)
}

// AsLongTermSchedulePolicy is the BasicSchedulePolicy implementation for LongTermSchedulePolicy.
func (ltsp LongTermSchedulePolicy) AsLongTermSchedulePolicy() (*LongTermSchedulePolicy, bool) {
	return &ltsp, true
}

// AsSimpleSchedulePolicy is the BasicSchedulePolicy implementation for LongTermSchedulePolicy.
func (ltsp LongTermSchedulePolicy) AsSimpleSchedulePolicy() (*SimpleSchedulePolicy, bool) {
	return nil, false
}

// AsSchedulePolicy is the BasicSchedulePolicy implementation for LongTermSchedulePolicy.
func (ltsp LongTermSchedulePolicy) AsSchedulePolicy() (*SchedulePolicy, bool) {
	return nil, false
}

// AsBasicSchedulePolicy is the BasicSchedulePolicy implementation for LongTermSchedulePolicy.
func (ltsp LongTermSchedulePolicy) AsBasicSchedulePolicy() (BasicSchedulePolicy, bool) {
	return &ltsp, true
}

// MabContainer the container associated with items backed up using Azure Backup Server.
type MabContainer struct {
	// CanReRegister - The container can be registered one more time.
	CanReRegister *bool `json:"canReRegister,omitempty"`
	// ContainerID - The ID for the container.
	ContainerID *int64 `json:"containerId,omitempty"`
	// ProtectedItemCount - The number of backup items in the container.
	ProtectedItemCount *int64 `json:"protectedItemCount,omitempty"`
	// AgentVersion - The version of the agent used with this container.
	AgentVersion *string `json:"agentVersion,omitempty"`
	// ExtendedInfo - Additional information for the container.
	ExtendedInfo *MabContainerExtendedInfo `json:"extendedInfo,omitempty"`
	// FriendlyName - Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// BackupManagementType - The backup management type for the container. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// RegistrationStatus - The container's registration status with the Recovery Services vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`
	// HealthStatus - The status of the container's health.
	HealthStatus *string `json:"healthStatus,omitempty"`
	// ContainerType - READ-ONLY; The type assigned to the container. The values to use for each of these properties are:<br/> 1. Compute Azure VM is Microsoft.Compute/virtualMachines<br/> 2. Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines<br/> 3. Windows machines (like Azure Backup Server and DPM) is Windows<br/> 4. Azure SQL instance is AzureSqlContainer.
	ContainerType *string `json:"containerType,omitempty"`
	// ProtectableObjectType - Possible values include: 'ProtectableObjectTypeProtectionContainer', 'ProtectableObjectTypeAzureSQLContainer', 'ProtectableObjectTypeIaaSVMContainer', 'ProtectableObjectTypeMABWindowsContainer', 'ProtectableObjectTypeMicrosoftComputevirtualMachines', 'ProtectableObjectTypeMicrosoftClassicComputevirtualMachines'
	ProtectableObjectType ProtectableObjectType `json:"protectableObjectType,omitempty"`
}

// MarshalJSON is the custom marshaler for MabContainer.
func (mc MabContainer) MarshalJSON() ([]byte, error) {
	mc.ProtectableObjectType = ProtectableObjectTypeMABWindowsContainer
	objectMap := make(map[string]interface{})
	if mc.CanReRegister != nil {
		objectMap["canReRegister"] = mc.CanReRegister
	}
	if mc.ContainerID != nil {
		objectMap["containerId"] = mc.ContainerID
	}
	if mc.ProtectedItemCount != nil {
		objectMap["protectedItemCount"] = mc.ProtectedItemCount
	}
	if mc.AgentVersion != nil {
		objectMap["agentVersion"] = mc.AgentVersion
	}
	if mc.ExtendedInfo != nil {
		objectMap["extendedInfo"] = mc.ExtendedInfo
	}
	if mc.FriendlyName != nil {
		objectMap["friendlyName"] = mc.FriendlyName
	}
	if mc.BackupManagementType != "" {
		objectMap["backupManagementType"] = mc.BackupManagementType
	}
	if mc.RegistrationStatus != nil {
		objectMap["registrationStatus"] = mc.RegistrationStatus
	}
	if mc.HealthStatus != nil {
		objectMap["healthStatus"] = mc.HealthStatus
	}
	if mc.ProtectableObjectType != "" {
		objectMap["protectableObjectType"] = mc.ProtectableObjectType
	}
	return json.Marshal(objectMap)
}

// AsAzureSQLContainer is the BasicProtectionContainer implementation for MabContainer.
func (mc MabContainer) AsAzureSQLContainer() (*AzureSQLContainer, bool) {
	return nil, false
}

// AsIaaSVMContainer is the BasicProtectionContainer implementation for MabContainer.
func (mc MabContainer) AsIaaSVMContainer() (*IaaSVMContainer, bool) {
	return nil, false
}

// AsBasicIaaSVMContainer is the BasicProtectionContainer implementation for MabContainer.
func (mc MabContainer) AsBasicIaaSVMContainer() (BasicIaaSVMContainer, bool) {
	return nil, false
}

// AsMabContainer is the BasicProtectionContainer implementation for MabContainer.
func (mc MabContainer) AsMabContainer() (*MabContainer, bool) {
	return &mc, true
}

// AsAzureIaaSComputeVMContainer is the BasicProtectionContainer implementation for MabContainer.
func (mc MabContainer) AsAzureIaaSComputeVMContainer() (*AzureIaaSComputeVMContainer, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMContainer is the BasicProtectionContainer implementation for MabContainer.
func (mc MabContainer) AsAzureIaaSClassicComputeVMContainer() (*AzureIaaSClassicComputeVMContainer, bool) {
	return nil, false
}

// AsProtectionContainer is the BasicProtectionContainer implementation for MabContainer.
func (mc MabContainer) AsProtectionContainer() (*ProtectionContainer, bool) {
	return nil, false
}

// AsBasicProtectionContainer is the BasicProtectionContainer implementation for MabContainer.
func (mc MabContainer) AsBasicProtectionContainer() (BasicProtectionContainer, bool) {
	return &mc, true
}

// MabContainerExtendedInfo additional information for the container.
type MabContainerExtendedInfo struct {
	// LastRefreshedAt - The time stamp when this container was refreshed.
	LastRefreshedAt *date.Time `json:"lastRefreshedAt,omitempty"`
	// BackupItemType - The type of backup items associated with this container. Possible values include: 'ItemTypeInvalid', 'ItemTypeVM', 'ItemTypeFileFolder', 'ItemTypeAzureSQLDb', 'ItemTypeSQLDB', 'ItemTypeExchange', 'ItemTypeSharepoint', 'ItemTypeDPMUnknown'
	BackupItemType ItemType `json:"backupItemType,omitempty"`
	// BackupItems - The list of backup items associated with this container.
	BackupItems *[]string `json:"backupItems,omitempty"`
	// PolicyName - The backup policy associated with this container.
	PolicyName *string `json:"policyName,omitempty"`
	// LastBackupStatus - The latest backup status of this container.
	LastBackupStatus *string `json:"lastBackupStatus,omitempty"`
}

// MabErrorInfo azure Backup Server workload-specific error information.
type MabErrorInfo struct {
	// ErrorString - Localized error string.
	ErrorString *string `json:"errorString,omitempty"`
	// Recommendations - List of localized recommendations.
	Recommendations *[]string `json:"recommendations,omitempty"`
}

// MabFileFolderProtectedItem this is a file or folder workload-specific backup item.
type MabFileFolderProtectedItem struct {
	// FriendlyName - The friendly name of this backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ComputerName - The name of the computer associated with this backup item.
	ComputerName *string `json:"computerName,omitempty"`
	// LastBackupStatus - The status of last backup operation.
	LastBackupStatus *string `json:"lastBackupStatus,omitempty"`
	// ProtectionState - The states for this property are: Protected, ProtectionStopped, IRPending, or ProtectionError.
	ProtectionState              *string `json:"protectionState,omitempty"`
	IsScheduledForDeferredDelete *bool   `json:"isScheduledForDeferredDelete,omitempty"`
	// ExtendedInfo - Additional information for this backup item.
	ExtendedInfo *MabFileFolderProtectedItemExtendedInfo `json:"extendedInfo,omitempty"`
	// BackupManagementType - The backup management type associated with the backup item. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// WorkloadType - The workload type for this item. Possible values include: 'Invalid', 'VM', 'FileFolder', 'AzureSQLDb', 'SQLDB', 'Exchange', 'Sharepoint', 'DPMUnknown'
	WorkloadType DataSourceType `json:"workloadType,omitempty"`
	// SourceResourceID - The ID of the resource to be backed up.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
	// PolicyID - The ID of the backup policy associated with this backup item.
	PolicyID *string `json:"policyId,omitempty"`
	// LastRecoveryPoint - The timestamp when the most recent backup copy was created for this backup item.
	LastRecoveryPoint *date.Time `json:"lastRecoveryPoint,omitempty"`
	// ProtectedItemType - Possible values include: 'ProtectedItemTypeProtectedItem', 'ProtectedItemTypeAzureIaaSVMProtectedItem', 'ProtectedItemTypeMabFileFolderProtectedItem', 'ProtectedItemTypeMicrosoftSqlserversdatabases', 'ProtectedItemTypeMicrosoftComputevirtualMachines', 'ProtectedItemTypeMicrosoftClassicComputevirtualMachines'
	ProtectedItemType ProtectedItemType `json:"protectedItemType,omitempty"`
}

// MarshalJSON is the custom marshaler for MabFileFolderProtectedItem.
func (mffpi MabFileFolderProtectedItem) MarshalJSON() ([]byte, error) {
	mffpi.ProtectedItemType = ProtectedItemTypeMabFileFolderProtectedItem
	objectMap := make(map[string]interface{})
	if mffpi.FriendlyName != nil {
		objectMap["friendlyName"] = mffpi.FriendlyName
	}
	if mffpi.ComputerName != nil {
		objectMap["computerName"] = mffpi.ComputerName
	}
	if mffpi.LastBackupStatus != nil {
		objectMap["lastBackupStatus"] = mffpi.LastBackupStatus
	}
	if mffpi.ProtectionState != nil {
		objectMap["protectionState"] = mffpi.ProtectionState
	}
	if mffpi.IsScheduledForDeferredDelete != nil {
		objectMap["isScheduledForDeferredDelete"] = mffpi.IsScheduledForDeferredDelete
	}
	if mffpi.ExtendedInfo != nil {
		objectMap["extendedInfo"] = mffpi.ExtendedInfo
	}
	if mffpi.BackupManagementType != "" {
		objectMap["backupManagementType"] = mffpi.BackupManagementType
	}
	if mffpi.WorkloadType != "" {
		objectMap["workloadType"] = mffpi.WorkloadType
	}
	if mffpi.SourceResourceID != nil {
		objectMap["sourceResourceId"] = mffpi.SourceResourceID
	}
	if mffpi.PolicyID != nil {
		objectMap["policyId"] = mffpi.PolicyID
	}
	if mffpi.LastRecoveryPoint != nil {
		objectMap["lastRecoveryPoint"] = mffpi.LastRecoveryPoint
	}
	if mffpi.ProtectedItemType != "" {
		objectMap["protectedItemType"] = mffpi.ProtectedItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureIaaSVMProtectedItem is the BasicProtectedItem implementation for MabFileFolderProtectedItem.
func (mffpi MabFileFolderProtectedItem) AsAzureIaaSVMProtectedItem() (*AzureIaaSVMProtectedItem, bool) {
	return nil, false
}

// AsBasicAzureIaaSVMProtectedItem is the BasicProtectedItem implementation for MabFileFolderProtectedItem.
func (mffpi MabFileFolderProtectedItem) AsBasicAzureIaaSVMProtectedItem() (BasicAzureIaaSVMProtectedItem, bool) {
	return nil, false
}

// AsMabFileFolderProtectedItem is the BasicProtectedItem implementation for MabFileFolderProtectedItem.
func (mffpi MabFileFolderProtectedItem) AsMabFileFolderProtectedItem() (*MabFileFolderProtectedItem, bool) {
	return &mffpi, true
}

// AsAzureSQLProtectedItem is the BasicProtectedItem implementation for MabFileFolderProtectedItem.
func (mffpi MabFileFolderProtectedItem) AsAzureSQLProtectedItem() (*AzureSQLProtectedItem, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMProtectedItem is the BasicProtectedItem implementation for MabFileFolderProtectedItem.
func (mffpi MabFileFolderProtectedItem) AsAzureIaaSComputeVMProtectedItem() (*AzureIaaSComputeVMProtectedItem, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMProtectedItem is the BasicProtectedItem implementation for MabFileFolderProtectedItem.
func (mffpi MabFileFolderProtectedItem) AsAzureIaaSClassicComputeVMProtectedItem() (*AzureIaaSClassicComputeVMProtectedItem, bool) {
	return nil, false
}

// AsProtectedItem is the BasicProtectedItem implementation for MabFileFolderProtectedItem.
func (mffpi MabFileFolderProtectedItem) AsProtectedItem() (*ProtectedItem, bool) {
	return nil, false
}

// AsBasicProtectedItem is the BasicProtectedItem implementation for MabFileFolderProtectedItem.
func (mffpi MabFileFolderProtectedItem) AsBasicProtectedItem() (BasicProtectedItem, bool) {
	return &mffpi, true
}

// MabFileFolderProtectedItemExtendedInfo additional information for the backup item.
type MabFileFolderProtectedItemExtendedInfo struct {
	// LastRefreshedAt - The last day and time the agent synced with the service.
	LastRefreshedAt *date.Time `json:"lastRefreshedAt,omitempty"`
	// OldestRecoveryPoint - The oldest backup copy available.
	OldestRecoveryPoint *date.Time `json:"oldestRecoveryPoint,omitempty"`
	// RecoveryPointCount - The number of backup copies associated with the backup item.
	RecoveryPointCount *int32 `json:"recoveryPointCount,omitempty"`
}

// MabJob the Azure Backup Server workload-specific job.
type MabJob struct {
	// Duration - The time required for the job to run.
	Duration *string `json:"duration,omitempty"`
	// ActionsInfo - The state or actions applicable on jobs such as Cancel or Retry.
	ActionsInfo *[]JobSupportedAction `json:"actionsInfo,omitempty"`
	// MabServerName - The name of server protecting the data store.
	MabServerName *string `json:"mabServerName,omitempty"`
	// MabServerType - Server type of the Azure Backup Server container. Possible values include: 'MabServerTypeInvalid', 'MabServerTypeUnknown', 'MabServerTypeIaasVMContainer', 'MabServerTypeIaasVMServiceContainer', 'MabServerTypeDPMContainer', 'MabServerTypeDPMVenusContainer', 'MabServerTypeMABContainer', 'MabServerTypeClusterResource', 'MabServerTypeAzureSQLContainer', 'MabServerTypeWindowsServer', 'MabServerTypeWindows'
	MabServerType MabServerType `json:"mabServerType,omitempty"`
	// WorkloadType - Workload type of backup item. Possible values include: 'WorkloadTypeInvalid', 'WorkloadTypeVM', 'WorkloadTypeFileFolder', 'WorkloadTypeAzureSQLDb', 'WorkloadTypeSQLDB', 'WorkloadTypeExchange', 'WorkloadTypeSharepoint', 'WorkloadTypeDPMUnknown'
	WorkloadType WorkloadType `json:"workloadType,omitempty"`
	// ErrorDetails - The errors.
	ErrorDetails *[]MabErrorInfo `json:"errorDetails,omitempty"`
	// ExtendedInfo - Additional information on the job.
	ExtendedInfo *MabJobExtendedInfo `json:"extendedInfo,omitempty"`
	// EntityFriendlyName - The friendly name of the entity on which the current job is executing.
	EntityFriendlyName *string `json:"entityFriendlyName,omitempty"`
	// BackupManagementType - The backup management type for the current job. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// Operation - The operation name.
	Operation *string `json:"operation,omitempty"`
	// Status - The job status.
	Status *string `json:"status,omitempty"`
	// StartTime - The start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The end time.
	EndTime *date.Time `json:"endTime,omitempty"`
	// ActivityID - ActivityId of job.
	ActivityID *string `json:"activityId,omitempty"`
	// JobType - Possible values include: 'JobTypeJob', 'JobTypeAzureIaaSVMJob', 'JobTypeDpmJob', 'JobTypeMabJob'
	JobType JobType `json:"jobType,omitempty"`
}

// MarshalJSON is the custom marshaler for MabJob.
func (mj MabJob) MarshalJSON() ([]byte, error) {
	mj.JobType = JobTypeMabJob
	objectMap := make(map[string]interface{})
	if mj.Duration != nil {
		objectMap["duration"] = mj.Duration
	}
	if mj.ActionsInfo != nil {
		objectMap["actionsInfo"] = mj.ActionsInfo
	}
	if mj.MabServerName != nil {
		objectMap["mabServerName"] = mj.MabServerName
	}
	if mj.MabServerType != "" {
		objectMap["mabServerType"] = mj.MabServerType
	}
	if mj.WorkloadType != "" {
		objectMap["workloadType"] = mj.WorkloadType
	}
	if mj.ErrorDetails != nil {
		objectMap["errorDetails"] = mj.ErrorDetails
	}
	if mj.ExtendedInfo != nil {
		objectMap["extendedInfo"] = mj.ExtendedInfo
	}
	if mj.EntityFriendlyName != nil {
		objectMap["entityFriendlyName"] = mj.EntityFriendlyName
	}
	if mj.BackupManagementType != "" {
		objectMap["backupManagementType"] = mj.BackupManagementType
	}
	if mj.Operation != nil {
		objectMap["operation"] = mj.Operation
	}
	if mj.Status != nil {
		objectMap["status"] = mj.Status
	}
	if mj.StartTime != nil {
		objectMap["startTime"] = mj.StartTime
	}
	if mj.EndTime != nil {
		objectMap["endTime"] = mj.EndTime
	}
	if mj.ActivityID != nil {
		objectMap["activityId"] = mj.ActivityID
	}
	if mj.JobType != "" {
		objectMap["jobType"] = mj.JobType
	}
	return json.Marshal(objectMap)
}

// AsAzureIaaSVMJob is the BasicJob implementation for MabJob.
func (mj MabJob) AsAzureIaaSVMJob() (*AzureIaaSVMJob, bool) {
	return nil, false
}

// AsDpmJob is the BasicJob implementation for MabJob.
func (mj MabJob) AsDpmJob() (*DpmJob, bool) {
	return nil, false
}

// AsMabJob is the BasicJob implementation for MabJob.
func (mj MabJob) AsMabJob() (*MabJob, bool) {
	return &mj, true
}

// AsJob is the BasicJob implementation for MabJob.
func (mj MabJob) AsJob() (*Job, bool) {
	return nil, false
}

// AsBasicJob is the BasicJob implementation for MabJob.
func (mj MabJob) AsBasicJob() (BasicJob, bool) {
	return &mj, true
}

// MabJobExtendedInfo additional information for the Azure Backup Server workload-specific job.
type MabJobExtendedInfo struct {
	// TasksList - List of tasks for this job.
	TasksList *[]MabJobTaskDetails `json:"tasksList,omitempty"`
	// PropertyBag - The job properties.
	PropertyBag map[string]*string `json:"propertyBag"`
	// DynamicErrorMessage - Non-localized error message specific to this job.
	DynamicErrorMessage *string `json:"dynamicErrorMessage,omitempty"`
}

// MarshalJSON is the custom marshaler for MabJobExtendedInfo.
func (mjei MabJobExtendedInfo) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mjei.TasksList != nil {
		objectMap["tasksList"] = mjei.TasksList
	}
	if mjei.PropertyBag != nil {
		objectMap["propertyBag"] = mjei.PropertyBag
	}
	if mjei.DynamicErrorMessage != nil {
		objectMap["dynamicErrorMessage"] = mjei.DynamicErrorMessage
	}
	return json.Marshal(objectMap)
}

// MabJobTaskDetails azure Backup Server workload-specific job task details.
type MabJobTaskDetails struct {
	// TaskID - The task display name.
	TaskID *string `json:"taskId,omitempty"`
	// StartTime - The start time.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The end time.
	EndTime *date.Time `json:"endTime,omitempty"`
	// Duration - Time elapsed for task.
	Duration *string `json:"duration,omitempty"`
	// Status - The status.
	Status *string `json:"status,omitempty"`
}

// MabProtectionPolicy the backup policy for the file or folder container.
type MabProtectionPolicy struct {
	// SchedulePolicy - The schedule specified in the backup policy.
	SchedulePolicy BasicSchedulePolicy `json:"schedulePolicy,omitempty"`
	// RetentionPolicy - The details specified in the Retention policy.
	RetentionPolicy BasicRetentionPolicy `json:"retentionPolicy,omitempty"`
	// ProtectedItemsCount - The number of items associated with this policy.
	ProtectedItemsCount *int32 `json:"protectedItemsCount,omitempty"`
	// BackupManagementType - Possible values include: 'BackupManagementTypeProtectionPolicy', 'BackupManagementTypeAzureIaasVM', 'BackupManagementTypeMAB', 'BackupManagementTypeAzureSQL'
	BackupManagementType ManagementTypeBasicProtectionPolicy `json:"backupManagementType,omitempty"`
}

// MarshalJSON is the custom marshaler for MabProtectionPolicy.
func (mpp MabProtectionPolicy) MarshalJSON() ([]byte, error) {
	mpp.BackupManagementType = BackupManagementTypeMAB
	objectMap := make(map[string]interface{})
	objectMap["schedulePolicy"] = mpp.SchedulePolicy
	objectMap["retentionPolicy"] = mpp.RetentionPolicy
	if mpp.ProtectedItemsCount != nil {
		objectMap["protectedItemsCount"] = mpp.ProtectedItemsCount
	}
	if mpp.BackupManagementType != "" {
		objectMap["backupManagementType"] = mpp.BackupManagementType
	}
	return json.Marshal(objectMap)
}

// AsAzureIaaSVMProtectionPolicy is the BasicProtectionPolicy implementation for MabProtectionPolicy.
func (mpp MabProtectionPolicy) AsAzureIaaSVMProtectionPolicy() (*AzureIaaSVMProtectionPolicy, bool) {
	return nil, false
}

// AsMabProtectionPolicy is the BasicProtectionPolicy implementation for MabProtectionPolicy.
func (mpp MabProtectionPolicy) AsMabProtectionPolicy() (*MabProtectionPolicy, bool) {
	return &mpp, true
}

// AsAzureSQLProtectionPolicy is the BasicProtectionPolicy implementation for MabProtectionPolicy.
func (mpp MabProtectionPolicy) AsAzureSQLProtectionPolicy() (*AzureSQLProtectionPolicy, bool) {
	return nil, false
}

// AsProtectionPolicy is the BasicProtectionPolicy implementation for MabProtectionPolicy.
func (mpp MabProtectionPolicy) AsProtectionPolicy() (*ProtectionPolicy, bool) {
	return nil, false
}

// AsBasicProtectionPolicy is the BasicProtectionPolicy implementation for MabProtectionPolicy.
func (mpp MabProtectionPolicy) AsBasicProtectionPolicy() (BasicProtectionPolicy, bool) {
	return &mpp, true
}

// UnmarshalJSON is the custom unmarshaler for MabProtectionPolicy struct.
func (mpp *MabProtectionPolicy) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "schedulePolicy":
			if v != nil {
				schedulePolicy, err := unmarshalBasicSchedulePolicy(*v)
				if err != nil {
					return err
				}
				mpp.SchedulePolicy = schedulePolicy
			}
		case "retentionPolicy":
			if v != nil {
				retentionPolicy, err := unmarshalBasicRetentionPolicy(*v)
				if err != nil {
					return err
				}
				mpp.RetentionPolicy = retentionPolicy
			}
		case "protectedItemsCount":
			if v != nil {
				var protectedItemsCount int32
				err = json.Unmarshal(*v, &protectedItemsCount)
				if err != nil {
					return err
				}
				mpp.ProtectedItemsCount = &protectedItemsCount
			}
		case "backupManagementType":
			if v != nil {
				var backupManagementType ManagementTypeBasicProtectionPolicy
				err = json.Unmarshal(*v, &backupManagementType)
				if err != nil {
					return err
				}
				mpp.BackupManagementType = backupManagementType
			}
		}
	}

	return nil
}

// MonthlyRetentionSchedule the monthly retention schedule.
type MonthlyRetentionSchedule struct {
	// RetentionScheduleFormatType - Retention schedule format type for monthly retention policy. Possible values include: 'RetentionScheduleFormatInvalid', 'RetentionScheduleFormatDaily', 'RetentionScheduleFormatWeekly'
	RetentionScheduleFormatType RetentionScheduleFormat `json:"retentionScheduleFormatType,omitempty"`
	// RetentionScheduleDaily - Daily retention format for the monthly retention policy.
	RetentionScheduleDaily *DailyRetentionFormat `json:"retentionScheduleDaily,omitempty"`
	// RetentionScheduleWeekly - Weekly retention format for the monthly retention policy.
	RetentionScheduleWeekly *WeeklyRetentionFormat `json:"retentionScheduleWeekly,omitempty"`
	// RetentionTimes - Retention times of the retention policy.
	RetentionTimes *[]date.Time `json:"retentionTimes,omitempty"`
	// RetentionDuration - Retention duration of the retention policy.
	RetentionDuration *RetentionDuration `json:"retentionDuration,omitempty"`
}

// OperationResultInfo information about the result of the operation.
type OperationResultInfo struct {
	// JobList - List of jobs created by this operation.
	JobList *[]string `json:"jobList,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeOperationResultInfoBase', 'ObjectTypeOperationResultInfo', 'ObjectTypeExportJobsOperationResultInfo'
	ObjectType ObjectTypeBasicOperationResultInfoBase `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationResultInfo.
func (ori OperationResultInfo) MarshalJSON() ([]byte, error) {
	ori.ObjectType = ObjectTypeOperationResultInfo
	objectMap := make(map[string]interface{})
	if ori.JobList != nil {
		objectMap["jobList"] = ori.JobList
	}
	if ori.ObjectType != "" {
		objectMap["objectType"] = ori.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsOperationResultInfo is the BasicOperationResultInfoBase implementation for OperationResultInfo.
func (ori OperationResultInfo) AsOperationResultInfo() (*OperationResultInfo, bool) {
	return &ori, true
}

// AsExportJobsOperationResultInfo is the BasicOperationResultInfoBase implementation for OperationResultInfo.
func (ori OperationResultInfo) AsExportJobsOperationResultInfo() (*ExportJobsOperationResultInfo, bool) {
	return nil, false
}

// AsOperationResultInfoBase is the BasicOperationResultInfoBase implementation for OperationResultInfo.
func (ori OperationResultInfo) AsOperationResultInfoBase() (*OperationResultInfoBase, bool) {
	return nil, false
}

// AsBasicOperationResultInfoBase is the BasicOperationResultInfoBase implementation for OperationResultInfo.
func (ori OperationResultInfo) AsBasicOperationResultInfoBase() (BasicOperationResultInfoBase, bool) {
	return &ori, true
}

// BasicOperationResultInfoBase the base class for operation result information.
type BasicOperationResultInfoBase interface {
	AsOperationResultInfo() (*OperationResultInfo, bool)
	AsExportJobsOperationResultInfo() (*ExportJobsOperationResultInfo, bool)
	AsOperationResultInfoBase() (*OperationResultInfoBase, bool)
}

// OperationResultInfoBase the base class for operation result information.
type OperationResultInfoBase struct {
	// ObjectType - Possible values include: 'ObjectTypeOperationResultInfoBase', 'ObjectTypeOperationResultInfo', 'ObjectTypeExportJobsOperationResultInfo'
	ObjectType ObjectTypeBasicOperationResultInfoBase `json:"objectType,omitempty"`
}

func unmarshalBasicOperationResultInfoBase(body []byte) (BasicOperationResultInfoBase, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["objectType"] {
	case string(ObjectTypeOperationResultInfo):
		var ori OperationResultInfo
		err := json.Unmarshal(body, &ori)
		return ori, err
	case string(ObjectTypeExportJobsOperationResultInfo):
		var ejori ExportJobsOperationResultInfo
		err := json.Unmarshal(body, &ejori)
		return ejori, err
	default:
		var orib OperationResultInfoBase
		err := json.Unmarshal(body, &orib)
		return orib, err
	}
}
func unmarshalBasicOperationResultInfoBaseArray(body []byte) ([]BasicOperationResultInfoBase, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	oribArray := make([]BasicOperationResultInfoBase, len(rawMessages))

	for index, rawMessage := range rawMessages {
		orib, err := unmarshalBasicOperationResultInfoBase(*rawMessage)
		if err != nil {
			return nil, err
		}
		oribArray[index] = orib
	}
	return oribArray, nil
}

// MarshalJSON is the custom marshaler for OperationResultInfoBase.
func (orib OperationResultInfoBase) MarshalJSON() ([]byte, error) {
	orib.ObjectType = ObjectTypeOperationResultInfoBase
	objectMap := make(map[string]interface{})
	if orib.ObjectType != "" {
		objectMap["objectType"] = orib.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsOperationResultInfo is the BasicOperationResultInfoBase implementation for OperationResultInfoBase.
func (orib OperationResultInfoBase) AsOperationResultInfo() (*OperationResultInfo, bool) {
	return nil, false
}

// AsExportJobsOperationResultInfo is the BasicOperationResultInfoBase implementation for OperationResultInfoBase.
func (orib OperationResultInfoBase) AsExportJobsOperationResultInfo() (*ExportJobsOperationResultInfo, bool) {
	return nil, false
}

// AsOperationResultInfoBase is the BasicOperationResultInfoBase implementation for OperationResultInfoBase.
func (orib OperationResultInfoBase) AsOperationResultInfoBase() (*OperationResultInfoBase, bool) {
	return &orib, true
}

// AsBasicOperationResultInfoBase is the BasicOperationResultInfoBase implementation for OperationResultInfoBase.
func (orib OperationResultInfoBase) AsBasicOperationResultInfoBase() (BasicOperationResultInfoBase, bool) {
	return &orib, true
}

// OperationResultInfoBaseResource base class for operation result information.
type OperationResultInfoBaseResource struct {
	autorest.Response `json:"-"`
	Properties        BasicOperationResultInfoBase `json:"properties,omitempty"`
	// StatusCode - The HTTP status code of the operation. Possible values include: 'Continue', 'SwitchingProtocols', 'OK', 'Created', 'Accepted', 'NonAuthoritativeInformation', 'NoContent', 'ResetContent', 'PartialContent', 'MultipleChoices', 'Ambiguous', 'MovedPermanently', 'Moved', 'Found', 'Redirect', 'SeeOther', 'RedirectMethod', 'NotModified', 'UseProxy', 'Unused', 'TemporaryRedirect', 'RedirectKeepVerb', 'BadRequest', 'Unauthorized', 'PaymentRequired', 'Forbidden', 'NotFound', 'MethodNotAllowed', 'NotAcceptable', 'ProxyAuthenticationRequired', 'RequestTimeout', 'Conflict', 'Gone', 'LengthRequired', 'PreconditionFailed', 'RequestEntityTooLarge', 'RequestURITooLong', 'UnsupportedMediaType', 'RequestedRangeNotSatisfiable', 'ExpectationFailed', 'UpgradeRequired', 'InternalServerError', 'NotImplemented', 'BadGateway', 'ServiceUnavailable', 'GatewayTimeout', 'HTTPVersionNotSupported'
	StatusCode HTTPStatusCode `json:"statusCode,omitempty"`
	// Headers - The HTTP headers associated with this operation.
	Headers map[string][]string `json:"Headers"`
}

// MarshalJSON is the custom marshaler for OperationResultInfoBaseResource.
func (oribr OperationResultInfoBaseResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = oribr.Properties
	if oribr.StatusCode != "" {
		objectMap["statusCode"] = oribr.StatusCode
	}
	if oribr.Headers != nil {
		objectMap["Headers"] = oribr.Headers
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for OperationResultInfoBaseResource struct.
func (oribr *OperationResultInfoBaseResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicOperationResultInfoBase(*v)
				if err != nil {
					return err
				}
				oribr.Properties = properties
			}
		case "statusCode":
			if v != nil {
				var statusCode HTTPStatusCode
				err = json.Unmarshal(*v, &statusCode)
				if err != nil {
					return err
				}
				oribr.StatusCode = statusCode
			}
		case "Headers":
			if v != nil {
				var headers map[string][]string
				err = json.Unmarshal(*v, &headers)
				if err != nil {
					return err
				}
				oribr.Headers = headers
			}
		}
	}

	return nil
}

// OperationStatus operation status.
type OperationStatus struct {
	autorest.Response `json:"-"`
	// ID - ID of the operation.
	ID *string `json:"id,omitempty"`
	// Name - Name of the operation.
	Name *string `json:"name,omitempty"`
	// Status - Operation status. Possible values include: 'OperationStatusValuesInvalid', 'OperationStatusValuesInProgress', 'OperationStatusValuesSucceeded', 'OperationStatusValuesFailed', 'OperationStatusValuesCanceled'
	Status OperationStatusValues `json:"status,omitempty"`
	// StartTime - The operation start time. The format of the time is ISO-8601.
	StartTime *date.Time `json:"startTime,omitempty"`
	// EndTime - The operation end time. The format of the time is ISO-8601.
	EndTime *date.Time `json:"endTime,omitempty"`
	// Error - Error information related to this operation.
	Error *OperationStatusError `json:"error,omitempty"`
	// Properties - Additional information associated with this operation.
	Properties BasicOperationStatusExtendedInfo `json:"properties,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for OperationStatus struct.
func (osVar *OperationStatus) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				osVar.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				osVar.Name = &name
			}
		case "status":
			if v != nil {
				var status OperationStatusValues
				err = json.Unmarshal(*v, &status)
				if err != nil {
					return err
				}
				osVar.Status = status
			}
		case "startTime":
			if v != nil {
				var startTime date.Time
				err = json.Unmarshal(*v, &startTime)
				if err != nil {
					return err
				}
				osVar.StartTime = &startTime
			}
		case "endTime":
			if v != nil {
				var endTime date.Time
				err = json.Unmarshal(*v, &endTime)
				if err != nil {
					return err
				}
				osVar.EndTime = &endTime
			}
		case "error":
			if v != nil {
				var errorVar OperationStatusError
				err = json.Unmarshal(*v, &errorVar)
				if err != nil {
					return err
				}
				osVar.Error = &errorVar
			}
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicOperationStatusExtendedInfo(*v)
				if err != nil {
					return err
				}
				osVar.Properties = properties
			}
		}
	}

	return nil
}

// OperationStatusError error information associated with the operation status call.
type OperationStatusError struct {
	// Code - The error code for the failed operation.
	Code *string `json:"code,omitempty"`
	// Message - The error message for the failed operation.
	Message *string `json:"message,omitempty"`
}

// BasicOperationStatusExtendedInfo the base class for additional information about the operation status.
type BasicOperationStatusExtendedInfo interface {
	AsOperationStatusJobExtendedInfo() (*OperationStatusJobExtendedInfo, bool)
	AsOperationStatusProvisionILRExtendedInfo() (*OperationStatusProvisionILRExtendedInfo, bool)
	AsOperationStatusJobsExtendedInfo() (*OperationStatusJobsExtendedInfo, bool)
	AsOperationStatusExtendedInfo() (*OperationStatusExtendedInfo, bool)
}

// OperationStatusExtendedInfo the base class for additional information about the operation status.
type OperationStatusExtendedInfo struct {
	// ObjectType - Possible values include: 'ObjectTypeOperationStatusExtendedInfo', 'ObjectTypeOperationStatusJobExtendedInfo', 'ObjectTypeOperationStatusProvisionILRExtendedInfo', 'ObjectTypeOperationStatusJobsExtendedInfo'
	ObjectType ObjectType `json:"objectType,omitempty"`
}

func unmarshalBasicOperationStatusExtendedInfo(body []byte) (BasicOperationStatusExtendedInfo, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["objectType"] {
	case string(ObjectTypeOperationStatusJobExtendedInfo):
		var osjei OperationStatusJobExtendedInfo
		err := json.Unmarshal(body, &osjei)
		return osjei, err
	case string(ObjectTypeOperationStatusProvisionILRExtendedInfo):
		var ospiei OperationStatusProvisionILRExtendedInfo
		err := json.Unmarshal(body, &ospiei)
		return ospiei, err
	case string(ObjectTypeOperationStatusJobsExtendedInfo):
		var osjei OperationStatusJobsExtendedInfo
		err := json.Unmarshal(body, &osjei)
		return osjei, err
	default:
		var osei OperationStatusExtendedInfo
		err := json.Unmarshal(body, &osei)
		return osei, err
	}
}
func unmarshalBasicOperationStatusExtendedInfoArray(body []byte) ([]BasicOperationStatusExtendedInfo, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	oseiArray := make([]BasicOperationStatusExtendedInfo, len(rawMessages))

	for index, rawMessage := range rawMessages {
		osei, err := unmarshalBasicOperationStatusExtendedInfo(*rawMessage)
		if err != nil {
			return nil, err
		}
		oseiArray[index] = osei
	}
	return oseiArray, nil
}

// MarshalJSON is the custom marshaler for OperationStatusExtendedInfo.
func (osei OperationStatusExtendedInfo) MarshalJSON() ([]byte, error) {
	osei.ObjectType = ObjectTypeOperationStatusExtendedInfo
	objectMap := make(map[string]interface{})
	if osei.ObjectType != "" {
		objectMap["objectType"] = osei.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsOperationStatusJobExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusExtendedInfo.
func (osei OperationStatusExtendedInfo) AsOperationStatusJobExtendedInfo() (*OperationStatusJobExtendedInfo, bool) {
	return nil, false
}

// AsOperationStatusProvisionILRExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusExtendedInfo.
func (osei OperationStatusExtendedInfo) AsOperationStatusProvisionILRExtendedInfo() (*OperationStatusProvisionILRExtendedInfo, bool) {
	return nil, false
}

// AsOperationStatusJobsExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusExtendedInfo.
func (osei OperationStatusExtendedInfo) AsOperationStatusJobsExtendedInfo() (*OperationStatusJobsExtendedInfo, bool) {
	return nil, false
}

// AsOperationStatusExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusExtendedInfo.
func (osei OperationStatusExtendedInfo) AsOperationStatusExtendedInfo() (*OperationStatusExtendedInfo, bool) {
	return &osei, true
}

// AsBasicOperationStatusExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusExtendedInfo.
func (osei OperationStatusExtendedInfo) AsBasicOperationStatusExtendedInfo() (BasicOperationStatusExtendedInfo, bool) {
	return &osei, true
}

// OperationStatusJobExtendedInfo extended information about the operation status job.
type OperationStatusJobExtendedInfo struct {
	// JobID - ID of the job created for this backup item.
	JobID *string `json:"jobId,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeOperationStatusExtendedInfo', 'ObjectTypeOperationStatusJobExtendedInfo', 'ObjectTypeOperationStatusProvisionILRExtendedInfo', 'ObjectTypeOperationStatusJobsExtendedInfo'
	ObjectType ObjectType `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationStatusJobExtendedInfo.
func (osjei OperationStatusJobExtendedInfo) MarshalJSON() ([]byte, error) {
	osjei.ObjectType = ObjectTypeOperationStatusJobExtendedInfo
	objectMap := make(map[string]interface{})
	if osjei.JobID != nil {
		objectMap["jobId"] = osjei.JobID
	}
	if osjei.ObjectType != "" {
		objectMap["objectType"] = osjei.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsOperationStatusJobExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusJobExtendedInfo.
func (osjei OperationStatusJobExtendedInfo) AsOperationStatusJobExtendedInfo() (*OperationStatusJobExtendedInfo, bool) {
	return &osjei, true
}

// AsOperationStatusProvisionILRExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusJobExtendedInfo.
func (osjei OperationStatusJobExtendedInfo) AsOperationStatusProvisionILRExtendedInfo() (*OperationStatusProvisionILRExtendedInfo, bool) {
	return nil, false
}

// AsOperationStatusJobsExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusJobExtendedInfo.
func (osjei OperationStatusJobExtendedInfo) AsOperationStatusJobsExtendedInfo() (*OperationStatusJobsExtendedInfo, bool) {
	return nil, false
}

// AsOperationStatusExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusJobExtendedInfo.
func (osjei OperationStatusJobExtendedInfo) AsOperationStatusExtendedInfo() (*OperationStatusExtendedInfo, bool) {
	return nil, false
}

// AsBasicOperationStatusExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusJobExtendedInfo.
func (osjei OperationStatusJobExtendedInfo) AsBasicOperationStatusExtendedInfo() (BasicOperationStatusExtendedInfo, bool) {
	return &osjei, true
}

// OperationStatusJobsExtendedInfo operation status extended info for the job list.
type OperationStatusJobsExtendedInfo struct {
	// JobIds - IDs of the jobs created for the backup item.
	JobIds *[]string `json:"jobIds,omitempty"`
	// FailedJobsError - Stores all the failed jobs along with the corresponding error codes.
	FailedJobsError map[string]*string `json:"failedJobsError"`
	// ObjectType - Possible values include: 'ObjectTypeOperationStatusExtendedInfo', 'ObjectTypeOperationStatusJobExtendedInfo', 'ObjectTypeOperationStatusProvisionILRExtendedInfo', 'ObjectTypeOperationStatusJobsExtendedInfo'
	ObjectType ObjectType `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationStatusJobsExtendedInfo.
func (osjei OperationStatusJobsExtendedInfo) MarshalJSON() ([]byte, error) {
	osjei.ObjectType = ObjectTypeOperationStatusJobsExtendedInfo
	objectMap := make(map[string]interface{})
	if osjei.JobIds != nil {
		objectMap["jobIds"] = osjei.JobIds
	}
	if osjei.FailedJobsError != nil {
		objectMap["failedJobsError"] = osjei.FailedJobsError
	}
	if osjei.ObjectType != "" {
		objectMap["objectType"] = osjei.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsOperationStatusJobExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusJobsExtendedInfo.
func (osjei OperationStatusJobsExtendedInfo) AsOperationStatusJobExtendedInfo() (*OperationStatusJobExtendedInfo, bool) {
	return nil, false
}

// AsOperationStatusProvisionILRExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusJobsExtendedInfo.
func (osjei OperationStatusJobsExtendedInfo) AsOperationStatusProvisionILRExtendedInfo() (*OperationStatusProvisionILRExtendedInfo, bool) {
	return nil, false
}

// AsOperationStatusJobsExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusJobsExtendedInfo.
func (osjei OperationStatusJobsExtendedInfo) AsOperationStatusJobsExtendedInfo() (*OperationStatusJobsExtendedInfo, bool) {
	return &osjei, true
}

// AsOperationStatusExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusJobsExtendedInfo.
func (osjei OperationStatusJobsExtendedInfo) AsOperationStatusExtendedInfo() (*OperationStatusExtendedInfo, bool) {
	return nil, false
}

// AsBasicOperationStatusExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusJobsExtendedInfo.
func (osjei OperationStatusJobsExtendedInfo) AsBasicOperationStatusExtendedInfo() (BasicOperationStatusExtendedInfo, bool) {
	return &osjei, true
}

// OperationStatusProvisionILRExtendedInfo extended information about the Item Level Recovery (ILR)
// provision action, operation status.
type OperationStatusProvisionILRExtendedInfo struct {
	// RecoveryTarget - Target details for the file or folder restore.
	RecoveryTarget *InstantItemRecoveryTarget `json:"recoveryTarget,omitempty"`
	// ObjectType - Possible values include: 'ObjectTypeOperationStatusExtendedInfo', 'ObjectTypeOperationStatusJobExtendedInfo', 'ObjectTypeOperationStatusProvisionILRExtendedInfo', 'ObjectTypeOperationStatusJobsExtendedInfo'
	ObjectType ObjectType `json:"objectType,omitempty"`
}

// MarshalJSON is the custom marshaler for OperationStatusProvisionILRExtendedInfo.
func (ospiei OperationStatusProvisionILRExtendedInfo) MarshalJSON() ([]byte, error) {
	ospiei.ObjectType = ObjectTypeOperationStatusProvisionILRExtendedInfo
	objectMap := make(map[string]interface{})
	if ospiei.RecoveryTarget != nil {
		objectMap["recoveryTarget"] = ospiei.RecoveryTarget
	}
	if ospiei.ObjectType != "" {
		objectMap["objectType"] = ospiei.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsOperationStatusJobExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusProvisionILRExtendedInfo.
func (ospiei OperationStatusProvisionILRExtendedInfo) AsOperationStatusJobExtendedInfo() (*OperationStatusJobExtendedInfo, bool) {
	return nil, false
}

// AsOperationStatusProvisionILRExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusProvisionILRExtendedInfo.
func (ospiei OperationStatusProvisionILRExtendedInfo) AsOperationStatusProvisionILRExtendedInfo() (*OperationStatusProvisionILRExtendedInfo, bool) {
	return &ospiei, true
}

// AsOperationStatusJobsExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusProvisionILRExtendedInfo.
func (ospiei OperationStatusProvisionILRExtendedInfo) AsOperationStatusJobsExtendedInfo() (*OperationStatusJobsExtendedInfo, bool) {
	return nil, false
}

// AsOperationStatusExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusProvisionILRExtendedInfo.
func (ospiei OperationStatusProvisionILRExtendedInfo) AsOperationStatusExtendedInfo() (*OperationStatusExtendedInfo, bool) {
	return nil, false
}

// AsBasicOperationStatusExtendedInfo is the BasicOperationStatusExtendedInfo implementation for OperationStatusProvisionILRExtendedInfo.
func (ospiei OperationStatusProvisionILRExtendedInfo) AsBasicOperationStatusExtendedInfo() (BasicOperationStatusExtendedInfo, bool) {
	return &ospiei, true
}

// OperationWorkerResponse the base class for operation result responses.
type OperationWorkerResponse struct {
	// StatusCode - The HTTP status code of the operation. Possible values include: 'Continue', 'SwitchingProtocols', 'OK', 'Created', 'Accepted', 'NonAuthoritativeInformation', 'NoContent', 'ResetContent', 'PartialContent', 'MultipleChoices', 'Ambiguous', 'MovedPermanently', 'Moved', 'Found', 'Redirect', 'SeeOther', 'RedirectMethod', 'NotModified', 'UseProxy', 'Unused', 'TemporaryRedirect', 'RedirectKeepVerb', 'BadRequest', 'Unauthorized', 'PaymentRequired', 'Forbidden', 'NotFound', 'MethodNotAllowed', 'NotAcceptable', 'ProxyAuthenticationRequired', 'RequestTimeout', 'Conflict', 'Gone', 'LengthRequired', 'PreconditionFailed', 'RequestEntityTooLarge', 'RequestURITooLong', 'UnsupportedMediaType', 'RequestedRangeNotSatisfiable', 'ExpectationFailed', 'UpgradeRequired', 'InternalServerError', 'NotImplemented', 'BadGateway', 'ServiceUnavailable', 'GatewayTimeout', 'HTTPVersionNotSupported'
	StatusCode HTTPStatusCode `json:"statusCode,omitempty"`
	// Headers - The HTTP headers associated with this operation.
	Headers map[string][]string `json:"Headers"`
}

// MarshalJSON is the custom marshaler for OperationWorkerResponse.
func (owr OperationWorkerResponse) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if owr.StatusCode != "" {
		objectMap["statusCode"] = owr.StatusCode
	}
	if owr.Headers != nil {
		objectMap["Headers"] = owr.Headers
	}
	return json.Marshal(objectMap)
}

// BasicProtectedItem the base class for backup items.
type BasicProtectedItem interface {
	AsAzureIaaSVMProtectedItem() (*AzureIaaSVMProtectedItem, bool)
	AsBasicAzureIaaSVMProtectedItem() (BasicAzureIaaSVMProtectedItem, bool)
	AsMabFileFolderProtectedItem() (*MabFileFolderProtectedItem, bool)
	AsAzureSQLProtectedItem() (*AzureSQLProtectedItem, bool)
	AsAzureIaaSComputeVMProtectedItem() (*AzureIaaSComputeVMProtectedItem, bool)
	AsAzureIaaSClassicComputeVMProtectedItem() (*AzureIaaSClassicComputeVMProtectedItem, bool)
	AsProtectedItem() (*ProtectedItem, bool)
}

// ProtectedItem the base class for backup items.
type ProtectedItem struct {
	// BackupManagementType - The backup management type associated with the backup item. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// WorkloadType - The workload type for this item. Possible values include: 'Invalid', 'VM', 'FileFolder', 'AzureSQLDb', 'SQLDB', 'Exchange', 'Sharepoint', 'DPMUnknown'
	WorkloadType DataSourceType `json:"workloadType,omitempty"`
	// SourceResourceID - The ID of the resource to be backed up.
	SourceResourceID *string `json:"sourceResourceId,omitempty"`
	// PolicyID - The ID of the backup policy associated with this backup item.
	PolicyID *string `json:"policyId,omitempty"`
	// LastRecoveryPoint - The timestamp when the most recent backup copy was created for this backup item.
	LastRecoveryPoint *date.Time `json:"lastRecoveryPoint,omitempty"`
	// ProtectedItemType - Possible values include: 'ProtectedItemTypeProtectedItem', 'ProtectedItemTypeAzureIaaSVMProtectedItem', 'ProtectedItemTypeMabFileFolderProtectedItem', 'ProtectedItemTypeMicrosoftSqlserversdatabases', 'ProtectedItemTypeMicrosoftComputevirtualMachines', 'ProtectedItemTypeMicrosoftClassicComputevirtualMachines'
	ProtectedItemType ProtectedItemType `json:"protectedItemType,omitempty"`
}

func unmarshalBasicProtectedItem(body []byte) (BasicProtectedItem, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["protectedItemType"] {
	case string(ProtectedItemTypeAzureIaaSVMProtectedItem):
		var aispi AzureIaaSVMProtectedItem
		err := json.Unmarshal(body, &aispi)
		return aispi, err
	case string(ProtectedItemTypeMabFileFolderProtectedItem):
		var mffpi MabFileFolderProtectedItem
		err := json.Unmarshal(body, &mffpi)
		return mffpi, err
	case string(ProtectedItemTypeMicrosoftSqlserversdatabases):
		var aspi AzureSQLProtectedItem
		err := json.Unmarshal(body, &aspi)
		return aspi, err
	case string(ProtectedItemTypeMicrosoftComputevirtualMachines):
		var aiscvpi AzureIaaSComputeVMProtectedItem
		err := json.Unmarshal(body, &aiscvpi)
		return aiscvpi, err
	case string(ProtectedItemTypeMicrosoftClassicComputevirtualMachines):
		var aisccvpi AzureIaaSClassicComputeVMProtectedItem
		err := json.Unmarshal(body, &aisccvpi)
		return aisccvpi, err
	default:
		var pi ProtectedItem
		err := json.Unmarshal(body, &pi)
		return pi, err
	}
}
func unmarshalBasicProtectedItemArray(body []byte) ([]BasicProtectedItem, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	piArray := make([]BasicProtectedItem, len(rawMessages))

	for index, rawMessage := range rawMessages {
		pi, err := unmarshalBasicProtectedItem(*rawMessage)
		if err != nil {
			return nil, err
		}
		piArray[index] = pi
	}
	return piArray, nil
}

// MarshalJSON is the custom marshaler for ProtectedItem.
func (pi ProtectedItem) MarshalJSON() ([]byte, error) {
	pi.ProtectedItemType = ProtectedItemTypeProtectedItem
	objectMap := make(map[string]interface{})
	if pi.BackupManagementType != "" {
		objectMap["backupManagementType"] = pi.BackupManagementType
	}
	if pi.WorkloadType != "" {
		objectMap["workloadType"] = pi.WorkloadType
	}
	if pi.SourceResourceID != nil {
		objectMap["sourceResourceId"] = pi.SourceResourceID
	}
	if pi.PolicyID != nil {
		objectMap["policyId"] = pi.PolicyID
	}
	if pi.LastRecoveryPoint != nil {
		objectMap["lastRecoveryPoint"] = pi.LastRecoveryPoint
	}
	if pi.ProtectedItemType != "" {
		objectMap["protectedItemType"] = pi.ProtectedItemType
	}
	return json.Marshal(objectMap)
}

// AsAzureIaaSVMProtectedItem is the BasicProtectedItem implementation for ProtectedItem.
func (pi ProtectedItem) AsAzureIaaSVMProtectedItem() (*AzureIaaSVMProtectedItem, bool) {
	return nil, false
}

// AsBasicAzureIaaSVMProtectedItem is the BasicProtectedItem implementation for ProtectedItem.
func (pi ProtectedItem) AsBasicAzureIaaSVMProtectedItem() (BasicAzureIaaSVMProtectedItem, bool) {
	return nil, false
}

// AsMabFileFolderProtectedItem is the BasicProtectedItem implementation for ProtectedItem.
func (pi ProtectedItem) AsMabFileFolderProtectedItem() (*MabFileFolderProtectedItem, bool) {
	return nil, false
}

// AsAzureSQLProtectedItem is the BasicProtectedItem implementation for ProtectedItem.
func (pi ProtectedItem) AsAzureSQLProtectedItem() (*AzureSQLProtectedItem, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMProtectedItem is the BasicProtectedItem implementation for ProtectedItem.
func (pi ProtectedItem) AsAzureIaaSComputeVMProtectedItem() (*AzureIaaSComputeVMProtectedItem, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMProtectedItem is the BasicProtectedItem implementation for ProtectedItem.
func (pi ProtectedItem) AsAzureIaaSClassicComputeVMProtectedItem() (*AzureIaaSClassicComputeVMProtectedItem, bool) {
	return nil, false
}

// AsProtectedItem is the BasicProtectedItem implementation for ProtectedItem.
func (pi ProtectedItem) AsProtectedItem() (*ProtectedItem, bool) {
	return &pi, true
}

// AsBasicProtectedItem is the BasicProtectedItem implementation for ProtectedItem.
func (pi ProtectedItem) AsBasicProtectedItem() (BasicProtectedItem, bool) {
	return &pi, true
}

// ProtectedItemQueryObject filters the list of backup items.
type ProtectedItemQueryObject struct {
	// BackupManagementType - The backup management type associated with an item. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// ItemType - The workload type associated with an item. Possible values include: 'Invalid', 'VM', 'FileFolder', 'AzureSQLDb', 'SQLDB', 'Exchange', 'Sharepoint', 'DPMUnknown'
	ItemType DataSourceType `json:"itemType,omitempty"`
	// PolicyName - The name of the backup policy associated with the item.
	PolicyName *string `json:"policyName,omitempty"`
	// ContainerName - The name of the container.
	ContainerName *string `json:"containerName,omitempty"`
}

// ProtectedItemResource the base class for backup items.
type ProtectedItemResource struct {
	autorest.Response `json:"-"`
	Properties        BasicProtectedItem `json:"properties,omitempty"`
	// ID - Resource ID represents the complete path to the resource.
	ID *string `json:"id,omitempty"`
	// Name - Resource name associated with the resource.
	Name *string `json:"name,omitempty"`
	// Type - Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ETag - Optional ETag.
	ETag *string `json:"eTag,omitempty"`
}

// MarshalJSON is the custom marshaler for ProtectedItemResource.
func (pir ProtectedItemResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = pir.Properties
	if pir.ID != nil {
		objectMap["id"] = pir.ID
	}
	if pir.Name != nil {
		objectMap["name"] = pir.Name
	}
	if pir.Type != nil {
		objectMap["type"] = pir.Type
	}
	if pir.Location != nil {
		objectMap["location"] = pir.Location
	}
	if pir.Tags != nil {
		objectMap["tags"] = pir.Tags
	}
	if pir.ETag != nil {
		objectMap["eTag"] = pir.ETag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ProtectedItemResource struct.
func (pir *ProtectedItemResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicProtectedItem(*v)
				if err != nil {
					return err
				}
				pir.Properties = properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pir.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pir.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pir.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				pir.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				pir.Tags = tags
			}
		case "eTag":
			if v != nil {
				var eTag string
				err = json.Unmarshal(*v, &eTag)
				if err != nil {
					return err
				}
				pir.ETag = &eTag
			}
		}
	}

	return nil
}

// ProtectedItemResourceList the list of ProtectedItem resources.
type ProtectedItemResourceList struct {
	autorest.Response `json:"-"`
	// Value - The list of resources.
	Value *[]ProtectedItemResource `json:"value,omitempty"`
	// NextLink - The URI to GET the next page of resources. Call ListNext() gets the next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// ProtectedItemResourceListIterator provides access to a complete listing of ProtectedItemResource values.
type ProtectedItemResourceListIterator struct {
	i    int
	page ProtectedItemResourceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ProtectedItemResourceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProtectedItemResourceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ProtectedItemResourceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ProtectedItemResourceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ProtectedItemResourceListIterator) Response() ProtectedItemResourceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ProtectedItemResourceListIterator) Value() ProtectedItemResource {
	if !iter.page.NotDone() {
		return ProtectedItemResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ProtectedItemResourceListIterator type.
func NewProtectedItemResourceListIterator(page ProtectedItemResourceListPage) ProtectedItemResourceListIterator {
	return ProtectedItemResourceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pirl ProtectedItemResourceList) IsEmpty() bool {
	return pirl.Value == nil || len(*pirl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (pirl ProtectedItemResourceList) hasNextLink() bool {
	return pirl.NextLink != nil && len(*pirl.NextLink) != 0
}

// protectedItemResourceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pirl ProtectedItemResourceList) protectedItemResourceListPreparer(ctx context.Context) (*http.Request, error) {
	if !pirl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pirl.NextLink)))
}

// ProtectedItemResourceListPage contains a page of ProtectedItemResource values.
type ProtectedItemResourceListPage struct {
	fn   func(context.Context, ProtectedItemResourceList) (ProtectedItemResourceList, error)
	pirl ProtectedItemResourceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ProtectedItemResourceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ProtectedItemResourceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.pirl)
		if err != nil {
			return err
		}
		page.pirl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ProtectedItemResourceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ProtectedItemResourceListPage) NotDone() bool {
	return !page.pirl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ProtectedItemResourceListPage) Response() ProtectedItemResourceList {
	return page.pirl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ProtectedItemResourceListPage) Values() []ProtectedItemResource {
	if page.pirl.IsEmpty() {
		return nil
	}
	return *page.pirl.Value
}

// Creates a new instance of the ProtectedItemResourceListPage type.
func NewProtectedItemResourceListPage(cur ProtectedItemResourceList, getNextPage func(context.Context, ProtectedItemResourceList) (ProtectedItemResourceList, error)) ProtectedItemResourceListPage {
	return ProtectedItemResourceListPage{
		fn:   getNextPage,
		pirl: cur,
	}
}

// BasicProtectionContainer the base class for a container with backup items. Containers with specific workloads are
// derived from this class.
type BasicProtectionContainer interface {
	AsAzureSQLContainer() (*AzureSQLContainer, bool)
	AsIaaSVMContainer() (*IaaSVMContainer, bool)
	AsBasicIaaSVMContainer() (BasicIaaSVMContainer, bool)
	AsMabContainer() (*MabContainer, bool)
	AsAzureIaaSComputeVMContainer() (*AzureIaaSComputeVMContainer, bool)
	AsAzureIaaSClassicComputeVMContainer() (*AzureIaaSClassicComputeVMContainer, bool)
	AsProtectionContainer() (*ProtectionContainer, bool)
}

// ProtectionContainer the base class for a container with backup items. Containers with specific workloads are
// derived from this class.
type ProtectionContainer struct {
	// FriendlyName - Friendly name of the container.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// BackupManagementType - The backup management type for the container. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
	// RegistrationStatus - The container's registration status with the Recovery Services vault.
	RegistrationStatus *string `json:"registrationStatus,omitempty"`
	// HealthStatus - The status of the container's health.
	HealthStatus *string `json:"healthStatus,omitempty"`
	// ContainerType - READ-ONLY; The type assigned to the container. The values to use for each of these properties are:<br/> 1. Compute Azure VM is Microsoft.Compute/virtualMachines<br/> 2. Classic Compute Azure VM is Microsoft.ClassicCompute/virtualMachines<br/> 3. Windows machines (like Azure Backup Server and DPM) is Windows<br/> 4. Azure SQL instance is AzureSqlContainer.
	ContainerType *string `json:"containerType,omitempty"`
	// ProtectableObjectType - Possible values include: 'ProtectableObjectTypeProtectionContainer', 'ProtectableObjectTypeAzureSQLContainer', 'ProtectableObjectTypeIaaSVMContainer', 'ProtectableObjectTypeMABWindowsContainer', 'ProtectableObjectTypeMicrosoftComputevirtualMachines', 'ProtectableObjectTypeMicrosoftClassicComputevirtualMachines'
	ProtectableObjectType ProtectableObjectType `json:"protectableObjectType,omitempty"`
}

func unmarshalBasicProtectionContainer(body []byte) (BasicProtectionContainer, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["protectableObjectType"] {
	case string(ProtectableObjectTypeAzureSQLContainer):
		var asc AzureSQLContainer
		err := json.Unmarshal(body, &asc)
		return asc, err
	case string(ProtectableObjectTypeIaaSVMContainer):
		var isc IaaSVMContainer
		err := json.Unmarshal(body, &isc)
		return isc, err
	case string(ProtectableObjectTypeMABWindowsContainer):
		var mc MabContainer
		err := json.Unmarshal(body, &mc)
		return mc, err
	case string(ProtectableObjectTypeMicrosoftComputevirtualMachines):
		var aiscvc AzureIaaSComputeVMContainer
		err := json.Unmarshal(body, &aiscvc)
		return aiscvc, err
	case string(ProtectableObjectTypeMicrosoftClassicComputevirtualMachines):
		var aisccvc AzureIaaSClassicComputeVMContainer
		err := json.Unmarshal(body, &aisccvc)
		return aisccvc, err
	default:
		var pc ProtectionContainer
		err := json.Unmarshal(body, &pc)
		return pc, err
	}
}
func unmarshalBasicProtectionContainerArray(body []byte) ([]BasicProtectionContainer, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	pcArray := make([]BasicProtectionContainer, len(rawMessages))

	for index, rawMessage := range rawMessages {
		pc, err := unmarshalBasicProtectionContainer(*rawMessage)
		if err != nil {
			return nil, err
		}
		pcArray[index] = pc
	}
	return pcArray, nil
}

// MarshalJSON is the custom marshaler for ProtectionContainer.
func (pc ProtectionContainer) MarshalJSON() ([]byte, error) {
	pc.ProtectableObjectType = ProtectableObjectTypeProtectionContainer
	objectMap := make(map[string]interface{})
	if pc.FriendlyName != nil {
		objectMap["friendlyName"] = pc.FriendlyName
	}
	if pc.BackupManagementType != "" {
		objectMap["backupManagementType"] = pc.BackupManagementType
	}
	if pc.RegistrationStatus != nil {
		objectMap["registrationStatus"] = pc.RegistrationStatus
	}
	if pc.HealthStatus != nil {
		objectMap["healthStatus"] = pc.HealthStatus
	}
	if pc.ProtectableObjectType != "" {
		objectMap["protectableObjectType"] = pc.ProtectableObjectType
	}
	return json.Marshal(objectMap)
}

// AsAzureSQLContainer is the BasicProtectionContainer implementation for ProtectionContainer.
func (pc ProtectionContainer) AsAzureSQLContainer() (*AzureSQLContainer, bool) {
	return nil, false
}

// AsIaaSVMContainer is the BasicProtectionContainer implementation for ProtectionContainer.
func (pc ProtectionContainer) AsIaaSVMContainer() (*IaaSVMContainer, bool) {
	return nil, false
}

// AsBasicIaaSVMContainer is the BasicProtectionContainer implementation for ProtectionContainer.
func (pc ProtectionContainer) AsBasicIaaSVMContainer() (BasicIaaSVMContainer, bool) {
	return nil, false
}

// AsMabContainer is the BasicProtectionContainer implementation for ProtectionContainer.
func (pc ProtectionContainer) AsMabContainer() (*MabContainer, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMContainer is the BasicProtectionContainer implementation for ProtectionContainer.
func (pc ProtectionContainer) AsAzureIaaSComputeVMContainer() (*AzureIaaSComputeVMContainer, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMContainer is the BasicProtectionContainer implementation for ProtectionContainer.
func (pc ProtectionContainer) AsAzureIaaSClassicComputeVMContainer() (*AzureIaaSClassicComputeVMContainer, bool) {
	return nil, false
}

// AsProtectionContainer is the BasicProtectionContainer implementation for ProtectionContainer.
func (pc ProtectionContainer) AsProtectionContainer() (*ProtectionContainer, bool) {
	return &pc, true
}

// AsBasicProtectionContainer is the BasicProtectionContainer implementation for ProtectionContainer.
func (pc ProtectionContainer) AsBasicProtectionContainer() (BasicProtectionContainer, bool) {
	return &pc, true
}

// ProtectionContainerResource base class for a container with backup items. Containers with specific
// workloads are derived from this class.
type ProtectionContainerResource struct {
	autorest.Response `json:"-"`
	Properties        BasicProtectionContainer `json:"properties,omitempty"`
	// ID - Resource ID represents the complete path to the resource.
	ID *string `json:"id,omitempty"`
	// Name - Resource name associated with the resource.
	Name *string `json:"name,omitempty"`
	// Type - Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ETag - Optional ETag.
	ETag *string `json:"eTag,omitempty"`
}

// MarshalJSON is the custom marshaler for ProtectionContainerResource.
func (pcr ProtectionContainerResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = pcr.Properties
	if pcr.ID != nil {
		objectMap["id"] = pcr.ID
	}
	if pcr.Name != nil {
		objectMap["name"] = pcr.Name
	}
	if pcr.Type != nil {
		objectMap["type"] = pcr.Type
	}
	if pcr.Location != nil {
		objectMap["location"] = pcr.Location
	}
	if pcr.Tags != nil {
		objectMap["tags"] = pcr.Tags
	}
	if pcr.ETag != nil {
		objectMap["eTag"] = pcr.ETag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ProtectionContainerResource struct.
func (pcr *ProtectionContainerResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicProtectionContainer(*v)
				if err != nil {
					return err
				}
				pcr.Properties = properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pcr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pcr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pcr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				pcr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				pcr.Tags = tags
			}
		case "eTag":
			if v != nil {
				var eTag string
				err = json.Unmarshal(*v, &eTag)
				if err != nil {
					return err
				}
				pcr.ETag = &eTag
			}
		}
	}

	return nil
}

// ProtectionContainerResourceList the list of ProtectionContainer resources.
type ProtectionContainerResourceList struct {
	autorest.Response `json:"-"`
	// Value - The list of resources.
	Value *[]ProtectionContainerResource `json:"value,omitempty"`
	// NextLink - The URI to GET the next page of resources. Call ListNext() gets the next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// BasicProtectionPolicy the base class for a backup policy. Workload-specific backup policies are derived from this
// class.
type BasicProtectionPolicy interface {
	AsAzureIaaSVMProtectionPolicy() (*AzureIaaSVMProtectionPolicy, bool)
	AsMabProtectionPolicy() (*MabProtectionPolicy, bool)
	AsAzureSQLProtectionPolicy() (*AzureSQLProtectionPolicy, bool)
	AsProtectionPolicy() (*ProtectionPolicy, bool)
}

// ProtectionPolicy the base class for a backup policy. Workload-specific backup policies are derived from this
// class.
type ProtectionPolicy struct {
	// ProtectedItemsCount - The number of items associated with this policy.
	ProtectedItemsCount *int32 `json:"protectedItemsCount,omitempty"`
	// BackupManagementType - Possible values include: 'BackupManagementTypeProtectionPolicy', 'BackupManagementTypeAzureIaasVM', 'BackupManagementTypeMAB', 'BackupManagementTypeAzureSQL'
	BackupManagementType ManagementTypeBasicProtectionPolicy `json:"backupManagementType,omitempty"`
}

func unmarshalBasicProtectionPolicy(body []byte) (BasicProtectionPolicy, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["backupManagementType"] {
	case string(BackupManagementTypeAzureIaasVM):
		var aispp AzureIaaSVMProtectionPolicy
		err := json.Unmarshal(body, &aispp)
		return aispp, err
	case string(BackupManagementTypeMAB):
		var mpp MabProtectionPolicy
		err := json.Unmarshal(body, &mpp)
		return mpp, err
	case string(BackupManagementTypeAzureSQL):
		var aspp AzureSQLProtectionPolicy
		err := json.Unmarshal(body, &aspp)
		return aspp, err
	default:
		var pp ProtectionPolicy
		err := json.Unmarshal(body, &pp)
		return pp, err
	}
}
func unmarshalBasicProtectionPolicyArray(body []byte) ([]BasicProtectionPolicy, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	ppArray := make([]BasicProtectionPolicy, len(rawMessages))

	for index, rawMessage := range rawMessages {
		pp, err := unmarshalBasicProtectionPolicy(*rawMessage)
		if err != nil {
			return nil, err
		}
		ppArray[index] = pp
	}
	return ppArray, nil
}

// MarshalJSON is the custom marshaler for ProtectionPolicy.
func (pp ProtectionPolicy) MarshalJSON() ([]byte, error) {
	pp.BackupManagementType = BackupManagementTypeProtectionPolicy
	objectMap := make(map[string]interface{})
	if pp.ProtectedItemsCount != nil {
		objectMap["protectedItemsCount"] = pp.ProtectedItemsCount
	}
	if pp.BackupManagementType != "" {
		objectMap["backupManagementType"] = pp.BackupManagementType
	}
	return json.Marshal(objectMap)
}

// AsAzureIaaSVMProtectionPolicy is the BasicProtectionPolicy implementation for ProtectionPolicy.
func (pp ProtectionPolicy) AsAzureIaaSVMProtectionPolicy() (*AzureIaaSVMProtectionPolicy, bool) {
	return nil, false
}

// AsMabProtectionPolicy is the BasicProtectionPolicy implementation for ProtectionPolicy.
func (pp ProtectionPolicy) AsMabProtectionPolicy() (*MabProtectionPolicy, bool) {
	return nil, false
}

// AsAzureSQLProtectionPolicy is the BasicProtectionPolicy implementation for ProtectionPolicy.
func (pp ProtectionPolicy) AsAzureSQLProtectionPolicy() (*AzureSQLProtectionPolicy, bool) {
	return nil, false
}

// AsProtectionPolicy is the BasicProtectionPolicy implementation for ProtectionPolicy.
func (pp ProtectionPolicy) AsProtectionPolicy() (*ProtectionPolicy, bool) {
	return &pp, true
}

// AsBasicProtectionPolicy is the BasicProtectionPolicy implementation for ProtectionPolicy.
func (pp ProtectionPolicy) AsBasicProtectionPolicy() (BasicProtectionPolicy, bool) {
	return &pp, true
}

// ProtectionPolicyQueryObject this object filters the list of backup policies.
type ProtectionPolicyQueryObject struct {
	// BackupManagementType - The backup management type associated with the backup policy. Possible values include: 'ManagementTypeInvalid', 'ManagementTypeAzureIaasVM', 'ManagementTypeMAB', 'ManagementTypeDPM', 'ManagementTypeAzureBackupServer', 'ManagementTypeAzureSQL'
	BackupManagementType ManagementType `json:"backupManagementType,omitempty"`
}

// ProtectionPolicyResource the base class for backup policy. Workload-specific backup policies are derived
// from this class.
type ProtectionPolicyResource struct {
	autorest.Response `json:"-"`
	Properties        BasicProtectionPolicy `json:"properties,omitempty"`
	// ID - Resource ID represents the complete path to the resource.
	ID *string `json:"id,omitempty"`
	// Name - Resource name associated with the resource.
	Name *string `json:"name,omitempty"`
	// Type - Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ETag - Optional ETag.
	ETag *string `json:"eTag,omitempty"`
}

// MarshalJSON is the custom marshaler for ProtectionPolicyResource.
func (ppr ProtectionPolicyResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = ppr.Properties
	if ppr.ID != nil {
		objectMap["id"] = ppr.ID
	}
	if ppr.Name != nil {
		objectMap["name"] = ppr.Name
	}
	if ppr.Type != nil {
		objectMap["type"] = ppr.Type
	}
	if ppr.Location != nil {
		objectMap["location"] = ppr.Location
	}
	if ppr.Tags != nil {
		objectMap["tags"] = ppr.Tags
	}
	if ppr.ETag != nil {
		objectMap["eTag"] = ppr.ETag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ProtectionPolicyResource struct.
func (ppr *ProtectionPolicyResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicProtectionPolicy(*v)
				if err != nil {
					return err
				}
				ppr.Properties = properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ppr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ppr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ppr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				ppr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				ppr.Tags = tags
			}
		case "eTag":
			if v != nil {
				var eTag string
				err = json.Unmarshal(*v, &eTag)
				if err != nil {
					return err
				}
				ppr.ETag = &eTag
			}
		}
	}

	return nil
}

// ProtectionPolicyResourceList the list of ProtectionPolicy resources.
type ProtectionPolicyResourceList struct {
	autorest.Response `json:"-"`
	// Value - The list of resources.
	Value *[]ProtectionPolicyResource `json:"value,omitempty"`
	// NextLink - The URI to GET the next page of resources. Call ListNext() gets the next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// BasicRecoveryPoint the base class for backup copies. Workload-specific backup copies are derived from this class.
type BasicRecoveryPoint interface {
	AsIaasVMRecoveryPoint() (*IaasVMRecoveryPoint, bool)
	AsGenericRecoveryPoint() (*GenericRecoveryPoint, bool)
	AsRecoveryPoint() (*RecoveryPoint, bool)
}

// RecoveryPoint the base class for backup copies. Workload-specific backup copies are derived from this class.
type RecoveryPoint struct {
	// ObjectType - Possible values include: 'ObjectTypeRecoveryPoint', 'ObjectTypeIaasVMRecoveryPoint', 'ObjectTypeGenericRecoveryPoint'
	ObjectType ObjectTypeBasicRecoveryPoint `json:"objectType,omitempty"`
}

func unmarshalBasicRecoveryPoint(body []byte) (BasicRecoveryPoint, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["objectType"] {
	case string(ObjectTypeIaasVMRecoveryPoint):
		var ivrp IaasVMRecoveryPoint
		err := json.Unmarshal(body, &ivrp)
		return ivrp, err
	case string(ObjectTypeGenericRecoveryPoint):
		var grp GenericRecoveryPoint
		err := json.Unmarshal(body, &grp)
		return grp, err
	default:
		var rp RecoveryPoint
		err := json.Unmarshal(body, &rp)
		return rp, err
	}
}
func unmarshalBasicRecoveryPointArray(body []byte) ([]BasicRecoveryPoint, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rpArray := make([]BasicRecoveryPoint, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rp, err := unmarshalBasicRecoveryPoint(*rawMessage)
		if err != nil {
			return nil, err
		}
		rpArray[index] = rp
	}
	return rpArray, nil
}

// MarshalJSON is the custom marshaler for RecoveryPoint.
func (rp RecoveryPoint) MarshalJSON() ([]byte, error) {
	rp.ObjectType = ObjectTypeRecoveryPoint
	objectMap := make(map[string]interface{})
	if rp.ObjectType != "" {
		objectMap["objectType"] = rp.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsIaasVMRecoveryPoint is the BasicRecoveryPoint implementation for RecoveryPoint.
func (rp RecoveryPoint) AsIaasVMRecoveryPoint() (*IaasVMRecoveryPoint, bool) {
	return nil, false
}

// AsGenericRecoveryPoint is the BasicRecoveryPoint implementation for RecoveryPoint.
func (rp RecoveryPoint) AsGenericRecoveryPoint() (*GenericRecoveryPoint, bool) {
	return nil, false
}

// AsRecoveryPoint is the BasicRecoveryPoint implementation for RecoveryPoint.
func (rp RecoveryPoint) AsRecoveryPoint() (*RecoveryPoint, bool) {
	return &rp, true
}

// AsBasicRecoveryPoint is the BasicRecoveryPoint implementation for RecoveryPoint.
func (rp RecoveryPoint) AsBasicRecoveryPoint() (BasicRecoveryPoint, bool) {
	return &rp, true
}

// RecoveryPointResource the base class for backup copies. Workload-specific backup copies are derived from
// this class.
type RecoveryPointResource struct {
	autorest.Response `json:"-"`
	Properties        BasicRecoveryPoint `json:"properties,omitempty"`
	// ID - Resource ID represents the complete path to the resource.
	ID *string `json:"id,omitempty"`
	// Name - Resource name associated with the resource.
	Name *string `json:"name,omitempty"`
	// Type - Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ETag - Optional ETag.
	ETag *string `json:"eTag,omitempty"`
}

// MarshalJSON is the custom marshaler for RecoveryPointResource.
func (rpr RecoveryPointResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = rpr.Properties
	if rpr.ID != nil {
		objectMap["id"] = rpr.ID
	}
	if rpr.Name != nil {
		objectMap["name"] = rpr.Name
	}
	if rpr.Type != nil {
		objectMap["type"] = rpr.Type
	}
	if rpr.Location != nil {
		objectMap["location"] = rpr.Location
	}
	if rpr.Tags != nil {
		objectMap["tags"] = rpr.Tags
	}
	if rpr.ETag != nil {
		objectMap["eTag"] = rpr.ETag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RecoveryPointResource struct.
func (rpr *RecoveryPointResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicRecoveryPoint(*v)
				if err != nil {
					return err
				}
				rpr.Properties = properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rpr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rpr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rpr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rpr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				rpr.Tags = tags
			}
		case "eTag":
			if v != nil {
				var eTag string
				err = json.Unmarshal(*v, &eTag)
				if err != nil {
					return err
				}
				rpr.ETag = &eTag
			}
		}
	}

	return nil
}

// RecoveryPointResourceList the list of RecoveryPoint resources.
type RecoveryPointResourceList struct {
	autorest.Response `json:"-"`
	// Value - The list of resources.
	Value *[]RecoveryPointResource `json:"value,omitempty"`
	// NextLink - The URI to GET the next page of resources. Call ListNext() gets the next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// BasicRequest the base class for a backup request. Workload-specific backup requests are derived from this class.
type BasicRequest interface {
	AsIaasVMBackupRequest() (*IaasVMBackupRequest, bool)
	AsRequest() (*Request, bool)
}

// Request the base class for a backup request. Workload-specific backup requests are derived from this class.
type Request struct {
	// ObjectType - Possible values include: 'ObjectTypeBackupRequest', 'ObjectTypeIaasVMBackupRequest'
	ObjectType ObjectTypeBasicRequest `json:"objectType,omitempty"`
}

func unmarshalBasicRequest(body []byte) (BasicRequest, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["objectType"] {
	case string(ObjectTypeIaasVMBackupRequest):
		var ivbr IaasVMBackupRequest
		err := json.Unmarshal(body, &ivbr)
		return ivbr, err
	default:
		var r Request
		err := json.Unmarshal(body, &r)
		return r, err
	}
}
func unmarshalBasicRequestArray(body []byte) ([]BasicRequest, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rArray := make([]BasicRequest, len(rawMessages))

	for index, rawMessage := range rawMessages {
		r, err := unmarshalBasicRequest(*rawMessage)
		if err != nil {
			return nil, err
		}
		rArray[index] = r
	}
	return rArray, nil
}

// MarshalJSON is the custom marshaler for Request.
func (r Request) MarshalJSON() ([]byte, error) {
	r.ObjectType = ObjectTypeBackupRequest
	objectMap := make(map[string]interface{})
	if r.ObjectType != "" {
		objectMap["objectType"] = r.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsIaasVMBackupRequest is the BasicRequest implementation for Request.
func (r Request) AsIaasVMBackupRequest() (*IaasVMBackupRequest, bool) {
	return nil, false
}

// AsRequest is the BasicRequest implementation for Request.
func (r Request) AsRequest() (*Request, bool) {
	return &r, true
}

// AsBasicRequest is the BasicRequest implementation for Request.
func (r Request) AsBasicRequest() (BasicRequest, bool) {
	return &r, true
}

// RequestResource base class for the backup request. Workload-specific backup requests are derived from
// this class.
type RequestResource struct {
	Properties BasicRequest `json:"properties,omitempty"`
	// ID - Resource ID represents the complete path to the resource.
	ID *string `json:"id,omitempty"`
	// Name - Resource name associated with the resource.
	Name *string `json:"name,omitempty"`
	// Type - Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ETag - Optional ETag.
	ETag *string `json:"eTag,omitempty"`
}

// MarshalJSON is the custom marshaler for RequestResource.
func (rr RequestResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = rr.Properties
	if rr.ID != nil {
		objectMap["id"] = rr.ID
	}
	if rr.Name != nil {
		objectMap["name"] = rr.Name
	}
	if rr.Type != nil {
		objectMap["type"] = rr.Type
	}
	if rr.Location != nil {
		objectMap["location"] = rr.Location
	}
	if rr.Tags != nil {
		objectMap["tags"] = rr.Tags
	}
	if rr.ETag != nil {
		objectMap["eTag"] = rr.ETag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RequestResource struct.
func (rr *RequestResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicRequest(*v)
				if err != nil {
					return err
				}
				rr.Properties = properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				rr.Tags = tags
			}
		case "eTag":
			if v != nil {
				var eTag string
				err = json.Unmarshal(*v, &eTag)
				if err != nil {
					return err
				}
				rr.ETag = &eTag
			}
		}
	}

	return nil
}

// Resource base for all resources.
type Resource struct {
	// ID - Resource ID represents the complete path to the resource.
	ID *string `json:"id,omitempty"`
	// Name - Resource name associated with the resource.
	Name *string `json:"name,omitempty"`
	// Type - Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ETag - Optional ETag.
	ETag *string `json:"eTag,omitempty"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.ID != nil {
		objectMap["id"] = r.ID
	}
	if r.Name != nil {
		objectMap["name"] = r.Name
	}
	if r.Type != nil {
		objectMap["type"] = r.Type
	}
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	if r.ETag != nil {
		objectMap["eTag"] = r.ETag
	}
	return json.Marshal(objectMap)
}

// ResourceList base for all lists of resources.
type ResourceList struct {
	// NextLink - The URI to GET the next page of resources. Call ListNext() gets the next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// BasicRestoreRequest the base class for restore requests. Workload-specific restore requests are derived from this
// class.
type BasicRestoreRequest interface {
	AsIaasVMRestoreRequest() (*IaasVMRestoreRequest, bool)
	AsRestoreRequest() (*RestoreRequest, bool)
}

// RestoreRequest the base class for restore requests. Workload-specific restore requests are derived from this
// class.
type RestoreRequest struct {
	// ObjectType - Possible values include: 'ObjectTypeRestoreRequest', 'ObjectTypeIaasVMRestoreRequest'
	ObjectType ObjectTypeBasicRestoreRequest `json:"objectType,omitempty"`
}

func unmarshalBasicRestoreRequest(body []byte) (BasicRestoreRequest, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["objectType"] {
	case string(ObjectTypeIaasVMRestoreRequest):
		var ivrr IaasVMRestoreRequest
		err := json.Unmarshal(body, &ivrr)
		return ivrr, err
	default:
		var rr RestoreRequest
		err := json.Unmarshal(body, &rr)
		return rr, err
	}
}
func unmarshalBasicRestoreRequestArray(body []byte) ([]BasicRestoreRequest, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rrArray := make([]BasicRestoreRequest, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rr, err := unmarshalBasicRestoreRequest(*rawMessage)
		if err != nil {
			return nil, err
		}
		rrArray[index] = rr
	}
	return rrArray, nil
}

// MarshalJSON is the custom marshaler for RestoreRequest.
func (rr RestoreRequest) MarshalJSON() ([]byte, error) {
	rr.ObjectType = ObjectTypeRestoreRequest
	objectMap := make(map[string]interface{})
	if rr.ObjectType != "" {
		objectMap["objectType"] = rr.ObjectType
	}
	return json.Marshal(objectMap)
}

// AsIaasVMRestoreRequest is the BasicRestoreRequest implementation for RestoreRequest.
func (rr RestoreRequest) AsIaasVMRestoreRequest() (*IaasVMRestoreRequest, bool) {
	return nil, false
}

// AsRestoreRequest is the BasicRestoreRequest implementation for RestoreRequest.
func (rr RestoreRequest) AsRestoreRequest() (*RestoreRequest, bool) {
	return &rr, true
}

// AsBasicRestoreRequest is the BasicRestoreRequest implementation for RestoreRequest.
func (rr RestoreRequest) AsBasicRestoreRequest() (BasicRestoreRequest, bool) {
	return &rr, true
}

// RestoreRequestResource the base class for a restore request. Workload-specific restore requests are
// derived from this class.
type RestoreRequestResource struct {
	Properties BasicRestoreRequest `json:"properties,omitempty"`
	// ID - Resource ID represents the complete path to the resource.
	ID *string `json:"id,omitempty"`
	// Name - Resource name associated with the resource.
	Name *string `json:"name,omitempty"`
	// Type - Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ETag - Optional ETag.
	ETag *string `json:"eTag,omitempty"`
}

// MarshalJSON is the custom marshaler for RestoreRequestResource.
func (rrr RestoreRequestResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = rrr.Properties
	if rrr.ID != nil {
		objectMap["id"] = rrr.ID
	}
	if rrr.Name != nil {
		objectMap["name"] = rrr.Name
	}
	if rrr.Type != nil {
		objectMap["type"] = rrr.Type
	}
	if rrr.Location != nil {
		objectMap["location"] = rrr.Location
	}
	if rrr.Tags != nil {
		objectMap["tags"] = rrr.Tags
	}
	if rrr.ETag != nil {
		objectMap["eTag"] = rrr.ETag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for RestoreRequestResource struct.
func (rrr *RestoreRequestResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicRestoreRequest(*v)
				if err != nil {
					return err
				}
				rrr.Properties = properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				rrr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				rrr.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				rrr.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				rrr.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				rrr.Tags = tags
			}
		case "eTag":
			if v != nil {
				var eTag string
				err = json.Unmarshal(*v, &eTag)
				if err != nil {
					return err
				}
				rrr.ETag = &eTag
			}
		}
	}

	return nil
}

// RetentionDuration retention duration.
type RetentionDuration struct {
	// Count - Count of the duration types. Retention duration is determined by the combining the Count times and durationType.
	//    For example, if Count = 3 and durationType = Weeks, then the retention duration is three weeks.
	Count *int32 `json:"count,omitempty"`
	// DurationType - The retention duration type of the retention policy. Possible values include: 'RetentionDurationTypeInvalid', 'RetentionDurationTypeDays', 'RetentionDurationTypeWeeks', 'RetentionDurationTypeMonths', 'RetentionDurationTypeYears'
	DurationType RetentionDurationType `json:"durationType,omitempty"`
}

// BasicRetentionPolicy the base class for retention policy.
type BasicRetentionPolicy interface {
	AsSimpleRetentionPolicy() (*SimpleRetentionPolicy, bool)
	AsLongTermRetentionPolicy() (*LongTermRetentionPolicy, bool)
	AsRetentionPolicy() (*RetentionPolicy, bool)
}

// RetentionPolicy the base class for retention policy.
type RetentionPolicy struct {
	// RetentionPolicyType - Possible values include: 'RetentionPolicyTypeRetentionPolicy', 'RetentionPolicyTypeSimpleRetentionPolicy', 'RetentionPolicyTypeLongTermRetentionPolicy'
	RetentionPolicyType RetentionPolicyType `json:"retentionPolicyType,omitempty"`
}

func unmarshalBasicRetentionPolicy(body []byte) (BasicRetentionPolicy, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["retentionPolicyType"] {
	case string(RetentionPolicyTypeSimpleRetentionPolicy):
		var srp SimpleRetentionPolicy
		err := json.Unmarshal(body, &srp)
		return srp, err
	case string(RetentionPolicyTypeLongTermRetentionPolicy):
		var ltrp LongTermRetentionPolicy
		err := json.Unmarshal(body, &ltrp)
		return ltrp, err
	default:
		var rp RetentionPolicy
		err := json.Unmarshal(body, &rp)
		return rp, err
	}
}
func unmarshalBasicRetentionPolicyArray(body []byte) ([]BasicRetentionPolicy, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rpArray := make([]BasicRetentionPolicy, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rp, err := unmarshalBasicRetentionPolicy(*rawMessage)
		if err != nil {
			return nil, err
		}
		rpArray[index] = rp
	}
	return rpArray, nil
}

// MarshalJSON is the custom marshaler for RetentionPolicy.
func (rp RetentionPolicy) MarshalJSON() ([]byte, error) {
	rp.RetentionPolicyType = RetentionPolicyTypeRetentionPolicy
	objectMap := make(map[string]interface{})
	if rp.RetentionPolicyType != "" {
		objectMap["retentionPolicyType"] = rp.RetentionPolicyType
	}
	return json.Marshal(objectMap)
}

// AsSimpleRetentionPolicy is the BasicRetentionPolicy implementation for RetentionPolicy.
func (rp RetentionPolicy) AsSimpleRetentionPolicy() (*SimpleRetentionPolicy, bool) {
	return nil, false
}

// AsLongTermRetentionPolicy is the BasicRetentionPolicy implementation for RetentionPolicy.
func (rp RetentionPolicy) AsLongTermRetentionPolicy() (*LongTermRetentionPolicy, bool) {
	return nil, false
}

// AsRetentionPolicy is the BasicRetentionPolicy implementation for RetentionPolicy.
func (rp RetentionPolicy) AsRetentionPolicy() (*RetentionPolicy, bool) {
	return &rp, true
}

// AsBasicRetentionPolicy is the BasicRetentionPolicy implementation for RetentionPolicy.
func (rp RetentionPolicy) AsBasicRetentionPolicy() (BasicRetentionPolicy, bool) {
	return &rp, true
}

// BasicSchedulePolicy the base class for backup schedules.
type BasicSchedulePolicy interface {
	AsLongTermSchedulePolicy() (*LongTermSchedulePolicy, bool)
	AsSimpleSchedulePolicy() (*SimpleSchedulePolicy, bool)
	AsSchedulePolicy() (*SchedulePolicy, bool)
}

// SchedulePolicy the base class for backup schedules.
type SchedulePolicy struct {
	// SchedulePolicyType - Possible values include: 'SchedulePolicyTypeSchedulePolicy', 'SchedulePolicyTypeLongTermSchedulePolicy', 'SchedulePolicyTypeSimpleSchedulePolicy'
	SchedulePolicyType SchedulePolicyType `json:"schedulePolicyType,omitempty"`
}

func unmarshalBasicSchedulePolicy(body []byte) (BasicSchedulePolicy, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["schedulePolicyType"] {
	case string(SchedulePolicyTypeLongTermSchedulePolicy):
		var ltsp LongTermSchedulePolicy
		err := json.Unmarshal(body, &ltsp)
		return ltsp, err
	case string(SchedulePolicyTypeSimpleSchedulePolicy):
		var ssp SimpleSchedulePolicy
		err := json.Unmarshal(body, &ssp)
		return ssp, err
	default:
		var sp SchedulePolicy
		err := json.Unmarshal(body, &sp)
		return sp, err
	}
}
func unmarshalBasicSchedulePolicyArray(body []byte) ([]BasicSchedulePolicy, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	spArray := make([]BasicSchedulePolicy, len(rawMessages))

	for index, rawMessage := range rawMessages {
		sp, err := unmarshalBasicSchedulePolicy(*rawMessage)
		if err != nil {
			return nil, err
		}
		spArray[index] = sp
	}
	return spArray, nil
}

// MarshalJSON is the custom marshaler for SchedulePolicy.
func (sp SchedulePolicy) MarshalJSON() ([]byte, error) {
	sp.SchedulePolicyType = SchedulePolicyTypeSchedulePolicy
	objectMap := make(map[string]interface{})
	if sp.SchedulePolicyType != "" {
		objectMap["schedulePolicyType"] = sp.SchedulePolicyType
	}
	return json.Marshal(objectMap)
}

// AsLongTermSchedulePolicy is the BasicSchedulePolicy implementation for SchedulePolicy.
func (sp SchedulePolicy) AsLongTermSchedulePolicy() (*LongTermSchedulePolicy, bool) {
	return nil, false
}

// AsSimpleSchedulePolicy is the BasicSchedulePolicy implementation for SchedulePolicy.
func (sp SchedulePolicy) AsSimpleSchedulePolicy() (*SimpleSchedulePolicy, bool) {
	return nil, false
}

// AsSchedulePolicy is the BasicSchedulePolicy implementation for SchedulePolicy.
func (sp SchedulePolicy) AsSchedulePolicy() (*SchedulePolicy, bool) {
	return &sp, true
}

// AsBasicSchedulePolicy is the BasicSchedulePolicy implementation for SchedulePolicy.
func (sp SchedulePolicy) AsBasicSchedulePolicy() (BasicSchedulePolicy, bool) {
	return &sp, true
}

// SimpleRetentionPolicy simple policy retention.
type SimpleRetentionPolicy struct {
	// RetentionDuration - Retention duration of the protection policy.
	RetentionDuration *RetentionDuration `json:"retentionDuration,omitempty"`
	// RetentionPolicyType - Possible values include: 'RetentionPolicyTypeRetentionPolicy', 'RetentionPolicyTypeSimpleRetentionPolicy', 'RetentionPolicyTypeLongTermRetentionPolicy'
	RetentionPolicyType RetentionPolicyType `json:"retentionPolicyType,omitempty"`
}

// MarshalJSON is the custom marshaler for SimpleRetentionPolicy.
func (srp SimpleRetentionPolicy) MarshalJSON() ([]byte, error) {
	srp.RetentionPolicyType = RetentionPolicyTypeSimpleRetentionPolicy
	objectMap := make(map[string]interface{})
	if srp.RetentionDuration != nil {
		objectMap["retentionDuration"] = srp.RetentionDuration
	}
	if srp.RetentionPolicyType != "" {
		objectMap["retentionPolicyType"] = srp.RetentionPolicyType
	}
	return json.Marshal(objectMap)
}

// AsSimpleRetentionPolicy is the BasicRetentionPolicy implementation for SimpleRetentionPolicy.
func (srp SimpleRetentionPolicy) AsSimpleRetentionPolicy() (*SimpleRetentionPolicy, bool) {
	return &srp, true
}

// AsLongTermRetentionPolicy is the BasicRetentionPolicy implementation for SimpleRetentionPolicy.
func (srp SimpleRetentionPolicy) AsLongTermRetentionPolicy() (*LongTermRetentionPolicy, bool) {
	return nil, false
}

// AsRetentionPolicy is the BasicRetentionPolicy implementation for SimpleRetentionPolicy.
func (srp SimpleRetentionPolicy) AsRetentionPolicy() (*RetentionPolicy, bool) {
	return nil, false
}

// AsBasicRetentionPolicy is the BasicRetentionPolicy implementation for SimpleRetentionPolicy.
func (srp SimpleRetentionPolicy) AsBasicRetentionPolicy() (BasicRetentionPolicy, bool) {
	return &srp, true
}

// SimpleSchedulePolicy simple policy schedule.
type SimpleSchedulePolicy struct {
	// ScheduleRunFrequency - Defines the frequency interval (daily or weekly) for the schedule policy. Possible values include: 'ScheduleRunTypeInvalid', 'ScheduleRunTypeDaily', 'ScheduleRunTypeWeekly'
	ScheduleRunFrequency ScheduleRunType `json:"scheduleRunFrequency,omitempty"`
	// ScheduleRunDays - This list is the days of the week when the schedule runs.
	ScheduleRunDays *[]DayOfWeek `json:"scheduleRunDays,omitempty"`
	// ScheduleRunTimes - List of times, during a day, when the schedule runs.
	ScheduleRunTimes *[]date.Time `json:"scheduleRunTimes,omitempty"`
	// ScheduleWeeklyFrequency - The number of times per week the schedule runs.
	ScheduleWeeklyFrequency *int32 `json:"scheduleWeeklyFrequency,omitempty"`
	// SchedulePolicyType - Possible values include: 'SchedulePolicyTypeSchedulePolicy', 'SchedulePolicyTypeLongTermSchedulePolicy', 'SchedulePolicyTypeSimpleSchedulePolicy'
	SchedulePolicyType SchedulePolicyType `json:"schedulePolicyType,omitempty"`
}

// MarshalJSON is the custom marshaler for SimpleSchedulePolicy.
func (ssp SimpleSchedulePolicy) MarshalJSON() ([]byte, error) {
	ssp.SchedulePolicyType = SchedulePolicyTypeSimpleSchedulePolicy
	objectMap := make(map[string]interface{})
	if ssp.ScheduleRunFrequency != "" {
		objectMap["scheduleRunFrequency"] = ssp.ScheduleRunFrequency
	}
	if ssp.ScheduleRunDays != nil {
		objectMap["scheduleRunDays"] = ssp.ScheduleRunDays
	}
	if ssp.ScheduleRunTimes != nil {
		objectMap["scheduleRunTimes"] = ssp.ScheduleRunTimes
	}
	if ssp.ScheduleWeeklyFrequency != nil {
		objectMap["scheduleWeeklyFrequency"] = ssp.ScheduleWeeklyFrequency
	}
	if ssp.SchedulePolicyType != "" {
		objectMap["schedulePolicyType"] = ssp.SchedulePolicyType
	}
	return json.Marshal(objectMap)
}

// AsLongTermSchedulePolicy is the BasicSchedulePolicy implementation for SimpleSchedulePolicy.
func (ssp SimpleSchedulePolicy) AsLongTermSchedulePolicy() (*LongTermSchedulePolicy, bool) {
	return nil, false
}

// AsSimpleSchedulePolicy is the BasicSchedulePolicy implementation for SimpleSchedulePolicy.
func (ssp SimpleSchedulePolicy) AsSimpleSchedulePolicy() (*SimpleSchedulePolicy, bool) {
	return &ssp, true
}

// AsSchedulePolicy is the BasicSchedulePolicy implementation for SimpleSchedulePolicy.
func (ssp SimpleSchedulePolicy) AsSchedulePolicy() (*SchedulePolicy, bool) {
	return nil, false
}

// AsBasicSchedulePolicy is the BasicSchedulePolicy implementation for SimpleSchedulePolicy.
func (ssp SimpleSchedulePolicy) AsBasicSchedulePolicy() (BasicSchedulePolicy, bool) {
	return &ssp, true
}

// WeeklyRetentionFormat weekly retention format.
type WeeklyRetentionFormat struct {
	// DaysOfTheWeek - List of days of the week.
	DaysOfTheWeek *[]DayOfWeek `json:"daysOfTheWeek,omitempty"`
	// WeeksOfTheMonth - List of weeks of the month.
	WeeksOfTheMonth *[]WeekOfMonth `json:"weeksOfTheMonth,omitempty"`
}

// WeeklyRetentionSchedule weekly retention schedule.
type WeeklyRetentionSchedule struct {
	// DaysOfTheWeek - List of the days of the week for the weekly retention policy.
	DaysOfTheWeek *[]DayOfWeek `json:"daysOfTheWeek,omitempty"`
	// RetentionTimes - Retention times of the retention policy.
	RetentionTimes *[]date.Time `json:"retentionTimes,omitempty"`
	// RetentionDuration - Retention duration of retention policy.
	RetentionDuration *RetentionDuration `json:"retentionDuration,omitempty"`
}

// BasicWorkloadProtectableItem the base class for backup item. Workload-specific backup items are derived from this
// class.
type BasicWorkloadProtectableItem interface {
	AsIaaSVMProtectableItem() (*IaaSVMProtectableItem, bool)
	AsBasicIaaSVMProtectableItem() (BasicIaaSVMProtectableItem, bool)
	AsAzureIaaSComputeVMProtectableItem() (*AzureIaaSComputeVMProtectableItem, bool)
	AsAzureIaaSClassicComputeVMProtectableItem() (*AzureIaaSClassicComputeVMProtectableItem, bool)
	AsWorkloadProtectableItem() (*WorkloadProtectableItem, bool)
}

// WorkloadProtectableItem the base class for backup item. Workload-specific backup items are derived from this
// class.
type WorkloadProtectableItem struct {
	// BackupManagementType - The backup management type.
	BackupManagementType *string `json:"backupManagementType,omitempty"`
	// FriendlyName - The friendly name of the backup item.
	FriendlyName *string `json:"friendlyName,omitempty"`
	// ProtectionState - The state of the back up item. Possible values include: 'ProtectionStatusInvalid', 'ProtectionStatusNotProtected', 'ProtectionStatusProtecting', 'ProtectionStatusProtected'
	ProtectionState ProtectionStatus `json:"protectionState,omitempty"`
	// ProtectableItemType - Possible values include: 'ProtectableItemTypeWorkloadProtectableItem', 'ProtectableItemTypeIaaSVMProtectableItem', 'ProtectableItemTypeMicrosoftComputevirtualMachines', 'ProtectableItemTypeMicrosoftClassicComputevirtualMachines'
	ProtectableItemType ProtectableItemType `json:"protectableItemType,omitempty"`
}

func unmarshalBasicWorkloadProtectableItem(body []byte) (BasicWorkloadProtectableItem, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["protectableItemType"] {
	case string(ProtectableItemTypeIaaSVMProtectableItem):
		var ispi IaaSVMProtectableItem
		err := json.Unmarshal(body, &ispi)
		return ispi, err
	case string(ProtectableItemTypeMicrosoftComputevirtualMachines):
		var aiscvpi AzureIaaSComputeVMProtectableItem
		err := json.Unmarshal(body, &aiscvpi)
		return aiscvpi, err
	case string(ProtectableItemTypeMicrosoftClassicComputevirtualMachines):
		var aisccvpi AzureIaaSClassicComputeVMProtectableItem
		err := json.Unmarshal(body, &aisccvpi)
		return aisccvpi, err
	default:
		var wpi WorkloadProtectableItem
		err := json.Unmarshal(body, &wpi)
		return wpi, err
	}
}
func unmarshalBasicWorkloadProtectableItemArray(body []byte) ([]BasicWorkloadProtectableItem, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	wpiArray := make([]BasicWorkloadProtectableItem, len(rawMessages))

	for index, rawMessage := range rawMessages {
		wpi, err := unmarshalBasicWorkloadProtectableItem(*rawMessage)
		if err != nil {
			return nil, err
		}
		wpiArray[index] = wpi
	}
	return wpiArray, nil
}

// MarshalJSON is the custom marshaler for WorkloadProtectableItem.
func (wpi WorkloadProtectableItem) MarshalJSON() ([]byte, error) {
	wpi.ProtectableItemType = ProtectableItemTypeWorkloadProtectableItem
	objectMap := make(map[string]interface{})
	if wpi.BackupManagementType != nil {
		objectMap["backupManagementType"] = wpi.BackupManagementType
	}
	if wpi.FriendlyName != nil {
		objectMap["friendlyName"] = wpi.FriendlyName
	}
	if wpi.ProtectionState != "" {
		objectMap["protectionState"] = wpi.ProtectionState
	}
	if wpi.ProtectableItemType != "" {
		objectMap["protectableItemType"] = wpi.ProtectableItemType
	}
	return json.Marshal(objectMap)
}

// AsIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for WorkloadProtectableItem.
func (wpi WorkloadProtectableItem) AsIaaSVMProtectableItem() (*IaaSVMProtectableItem, bool) {
	return nil, false
}

// AsBasicIaaSVMProtectableItem is the BasicWorkloadProtectableItem implementation for WorkloadProtectableItem.
func (wpi WorkloadProtectableItem) AsBasicIaaSVMProtectableItem() (BasicIaaSVMProtectableItem, bool) {
	return nil, false
}

// AsAzureIaaSComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for WorkloadProtectableItem.
func (wpi WorkloadProtectableItem) AsAzureIaaSComputeVMProtectableItem() (*AzureIaaSComputeVMProtectableItem, bool) {
	return nil, false
}

// AsAzureIaaSClassicComputeVMProtectableItem is the BasicWorkloadProtectableItem implementation for WorkloadProtectableItem.
func (wpi WorkloadProtectableItem) AsAzureIaaSClassicComputeVMProtectableItem() (*AzureIaaSClassicComputeVMProtectableItem, bool) {
	return nil, false
}

// AsWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for WorkloadProtectableItem.
func (wpi WorkloadProtectableItem) AsWorkloadProtectableItem() (*WorkloadProtectableItem, bool) {
	return &wpi, true
}

// AsBasicWorkloadProtectableItem is the BasicWorkloadProtectableItem implementation for WorkloadProtectableItem.
func (wpi WorkloadProtectableItem) AsBasicWorkloadProtectableItem() (BasicWorkloadProtectableItem, bool) {
	return &wpi, true
}

// WorkloadProtectableItemResource the base class for the backup item. Workload-specific backup items are
// derived from this class.
type WorkloadProtectableItemResource struct {
	Properties BasicWorkloadProtectableItem `json:"properties,omitempty"`
	// ID - Resource ID represents the complete path to the resource.
	ID *string `json:"id,omitempty"`
	// Name - Resource name associated with the resource.
	Name *string `json:"name,omitempty"`
	// Type - Resource type represents the complete path of the form Namespace/ResourceType/ResourceType/...
	Type *string `json:"type,omitempty"`
	// Location - Resource location.
	Location *string `json:"location,omitempty"`
	// Tags - Resource tags.
	Tags map[string]*string `json:"tags"`
	// ETag - Optional ETag.
	ETag *string `json:"eTag,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkloadProtectableItemResource.
func (wpir WorkloadProtectableItemResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = wpir.Properties
	if wpir.ID != nil {
		objectMap["id"] = wpir.ID
	}
	if wpir.Name != nil {
		objectMap["name"] = wpir.Name
	}
	if wpir.Type != nil {
		objectMap["type"] = wpir.Type
	}
	if wpir.Location != nil {
		objectMap["location"] = wpir.Location
	}
	if wpir.Tags != nil {
		objectMap["tags"] = wpir.Tags
	}
	if wpir.ETag != nil {
		objectMap["eTag"] = wpir.ETag
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkloadProtectableItemResource struct.
func (wpir *WorkloadProtectableItemResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicWorkloadProtectableItem(*v)
				if err != nil {
					return err
				}
				wpir.Properties = properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				wpir.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				wpir.Name = &name
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				wpir.Type = &typeVar
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				wpir.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				wpir.Tags = tags
			}
		case "eTag":
			if v != nil {
				var eTag string
				err = json.Unmarshal(*v, &eTag)
				if err != nil {
					return err
				}
				wpir.ETag = &eTag
			}
		}
	}

	return nil
}

// WorkloadProtectableItemResourceList the list of WorkloadProtectableItem resources.
type WorkloadProtectableItemResourceList struct {
	autorest.Response `json:"-"`
	// Value - List of resources.
	Value *[]WorkloadProtectableItemResource `json:"value,omitempty"`
	// NextLink - The URI to GET the next page of resources. Call ListNext() gets the next page of resources.
	NextLink *string `json:"nextLink,omitempty"`
}

// WorkloadProtectableItemResourceListIterator provides access to a complete listing of
// WorkloadProtectableItemResource values.
type WorkloadProtectableItemResourceListIterator struct {
	i    int
	page WorkloadProtectableItemResourceListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WorkloadProtectableItemResourceListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadProtectableItemResourceListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WorkloadProtectableItemResourceListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WorkloadProtectableItemResourceListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WorkloadProtectableItemResourceListIterator) Response() WorkloadProtectableItemResourceList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WorkloadProtectableItemResourceListIterator) Value() WorkloadProtectableItemResource {
	if !iter.page.NotDone() {
		return WorkloadProtectableItemResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WorkloadProtectableItemResourceListIterator type.
func NewWorkloadProtectableItemResourceListIterator(page WorkloadProtectableItemResourceListPage) WorkloadProtectableItemResourceListIterator {
	return WorkloadProtectableItemResourceListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wpirl WorkloadProtectableItemResourceList) IsEmpty() bool {
	return wpirl.Value == nil || len(*wpirl.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (wpirl WorkloadProtectableItemResourceList) hasNextLink() bool {
	return wpirl.NextLink != nil && len(*wpirl.NextLink) != 0
}

// workloadProtectableItemResourceListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wpirl WorkloadProtectableItemResourceList) workloadProtectableItemResourceListPreparer(ctx context.Context) (*http.Request, error) {
	if !wpirl.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wpirl.NextLink)))
}

// WorkloadProtectableItemResourceListPage contains a page of WorkloadProtectableItemResource values.
type WorkloadProtectableItemResourceListPage struct {
	fn    func(context.Context, WorkloadProtectableItemResourceList) (WorkloadProtectableItemResourceList, error)
	wpirl WorkloadProtectableItemResourceList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WorkloadProtectableItemResourceListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkloadProtectableItemResourceListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.wpirl)
		if err != nil {
			return err
		}
		page.wpirl = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WorkloadProtectableItemResourceListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WorkloadProtectableItemResourceListPage) NotDone() bool {
	return !page.wpirl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WorkloadProtectableItemResourceListPage) Response() WorkloadProtectableItemResourceList {
	return page.wpirl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WorkloadProtectableItemResourceListPage) Values() []WorkloadProtectableItemResource {
	if page.wpirl.IsEmpty() {
		return nil
	}
	return *page.wpirl.Value
}

// Creates a new instance of the WorkloadProtectableItemResourceListPage type.
func NewWorkloadProtectableItemResourceListPage(cur WorkloadProtectableItemResourceList, getNextPage func(context.Context, WorkloadProtectableItemResourceList) (WorkloadProtectableItemResourceList, error)) WorkloadProtectableItemResourceListPage {
	return WorkloadProtectableItemResourceListPage{
		fn:    getNextPage,
		wpirl: cur,
	}
}

// YearlyRetentionSchedule yearly retention schedule.
type YearlyRetentionSchedule struct {
	// RetentionScheduleFormatType - Retention schedule format for the yearly retention policy. Possible values include: 'RetentionScheduleFormatInvalid', 'RetentionScheduleFormatDaily', 'RetentionScheduleFormatWeekly'
	RetentionScheduleFormatType RetentionScheduleFormat `json:"retentionScheduleFormatType,omitempty"`
	// MonthsOfYear - List of the months of year for the yearly retention policy.
	MonthsOfYear *[]MonthOfYear `json:"monthsOfYear,omitempty"`
	// RetentionScheduleDaily - Daily retention format for the yearly retention policy.
	RetentionScheduleDaily *DailyRetentionFormat `json:"retentionScheduleDaily,omitempty"`
	// RetentionScheduleWeekly - Weekly retention format for the yearly retention policy.
	RetentionScheduleWeekly *WeeklyRetentionFormat `json:"retentionScheduleWeekly,omitempty"`
	// RetentionTimes - Retention times for the retention policy.
	RetentionTimes *[]date.Time `json:"retentionTimes,omitempty"`
	// RetentionDuration - Retention duration for the retention policy.
	RetentionDuration *RetentionDuration `json:"retentionDuration,omitempty"`
}
