// DO NOT EDIT: This file is autogenerated via the builtin command.

package date

import (
	ast "github.com/influxdata/flux/ast"
	runtime "github.com/influxdata/flux/runtime"
)

func init() {
	runtime.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 14,
					Line:   480,
				},
				File:   "date.flux",
				Source: "package date\n\n\n// second is a function that returns the second of a specified time. Results\n//  range from [0 - 59].\n//\n// ## Parameters\n// - `t` is the time to operate on.\n//\n//   Use an absolute time, relative duration, or integer. durations are\n//   relative to `now()`.\n//\n// ## Return the second of a time value\n//\n// ```\n// import \"date\"\n//\n// date.second(t: 2020-02-11T12:21:03.293534940Z)\n// ```\n//\n// ## Return the second of a relative duration\n//\n// ```\n// import \"date\"\n//\n// option now = () => 2020-02-11T12:21:03.293534940Z\n//\n// date.second(t: -50s)\n// ```\nbuiltin second : (t: T) => int where T: Timeable\n\n// minute is a function that returns the minute of a specified time. Results\n//  range from [0 - 59].\n//\n// ## Parameters\n// - `t` is the time to operate on.\n//\n//    Use an absolute time, relative duration, or integer. durations are\n//    relative to `now()`.\n//\n// ## Return the minute of a time value\n//\n// ```\n// import \"date\"\n//\n// date.minute(t: 2020-02-11T12:21:03.293534940Z)\n// ```\n//\n// ## Return the minute of a relative duration\n//\n// ```\n// import \"date\"\n//\n// option now = () => 2020-02-11T12:21:03.293534940Z\n//\n// date.minute(t: -45m)\n// ```\nbuiltin minute : (t: T) => int where T: Timeable\n\n// hour is a function that returns the hour of a specified time. Results\n//  range from [0 - 23].\n//\n// ## Parameters\n// - `t` is the time to operate on.\n//\n//   Use an absolute time, relative duration, or integer. durations are\n//   relative to `now()`.\n//\n// ## Return the hour of a time value\n//\n// ```\n// import \"date\"\n//\n// date.hour(t: 2020-02-11T12:21:03.293534940Z)\n// ```\n//\n// ## Return the hour of a relative duration\n//\n// ```\n// import \"date\"\n//\n// option now = () => 2020-02-11T12:21:03.293534940Z\n//\n// date.hour(t: -8h)\n// ```\nbuiltin hour : (t: T) => int where T: Timeable\n\n// weekDay is a function that returns the day of the week for a specified time.\n//  Results range from [0 - 6].\n//\n// ## Parameters\n// - `t` is the time to operate on.\n//\n//   Use an absolute time, relative duration, or integer. durations are\n//   relative to `now()`.\n//\n// ## Return the day of the week for a time value\n//\n// ```\n// import \"date\"\n//\n// date.weekDay(t: 2020-02-11T12:21:03.293534940Z)\n// ```\n//\n// ## Return the day of the week for a relative duration\n//\n// ```\n// import \"date\"\n//\n// option now = () => 2020-02-11T12:21:03.293534940Z\n//\n// date.weekDay(t: -84h)\n// ```\nbuiltin weekDay : (t: T) => int where T: Timeable\n\n// monthDay is a function that returns the day of the month for a specified\n//  time. Results range from [1 - 31].\n//\n// ## Parameters\n// - `t` is the time to operate on.\n//\n//   Use an absolute time, relative duration, or integer. durations are\n//   relative to `now()`.\n//\n// ## Return the day of the month for a time value\n//\n// ```\n// import \"date\"\n//\n// date.monthDay(t: 2020-02-11T12:21:03.293534940Z)\n// ```\n//\n// ## Return the day of the month for a relative duration\n//\n// ```\n// import \"date\"\n//\n//option now = () => 2020-02-11T12:21:03.293534940Z\n//\n//date.monthDay(t: -8d)\n// ```\nbuiltin monthDay : (t: T) => int where T: Timeable\n\n// yearDay is a function that returns the day of the year for a specified time\n//  Results can include leap days and range from [ 1 - 366].\n//\n// ## Parameters\n// - `t` is the time to operate on.\n//\n//   Use an absolute time, relative duration, or integer. durations are\n//   relative to `now()`.\n//\n// ## Return the day of the year for a time value\n//\n// ```\n// import \"date\"\n//\n//date.yearDay(t: 2020-02-11T12:21:03.293534940Z)\n// ```\n//\n// ## Return the day of the year for a relative duration\n//\n// ```\n// import \"date\"\n//\n// option now = () => 2020-02-11T12:21:03.293534940Z\n//\n// date.yearDay(t: -1mo)\n// ```\nbuiltin yearDay : (t: T) => int where T: Timeable\n\n// month is a function that returns the month of a specified time.\n//  Results range from [1 - 12].\n//\n// ## Parameters\n// - `t` is the time to operate on.\n//\n//   Use an absolute time, relative duration, or integer. durations are\n//   relative to `now()`.\n//\n// ## Return the month of a time value\n//\n// ```\n// import \"date\"\n//\n//date.month(t: 2020-02-11T12:21:03.293534940Z)\n// ```\n//\n// ## Retrun the month of a relative duration\n//\n// ```\n// import \"date\"\n//\n// option now = () => 2020-02-11T12:21:03.293534940Z\n//\n// date.month(t: -3mo)\n// ```\nbuiltin month : (t: T) => int where T: Timeable\n\n// year is a function that returns the year of a specified time.\n//\n// ## Parameters\n// - `t` is the time to operate on.\n//\n//   Use an absolute time, relative duration, or integer. durations are\n//   relative to `now()`.\n//\n// ## Return the year for a time value\n//\n// ```\n// import \"date\"\n//\n//date.year(t: 2020-02-11T12:21:03.293534940Z)\n// ```\n//\n// ## Return the year for a relative duration\n//\n// ```\n// import \"date\"\n//\n// option now = () => 2020-02-11T12:21:03.293534940Z\n//\n// date.year(t: -14y)\n// ```\nbuiltin year : (t: T) => int where T: Timeable\n\n// week is a function that returns the ISO week of the year for a specified time.\n//  Results range from [1 - 53].\n//\n// ## Parameters\n// - `t` is the time to operate on.\n//\n//   Use an absolute time, relative duration, or integer. durations are\n//   relative to `now()`. \n//\n// ## Return the week of the year\n//\n// ```\n// import \"date\"\n//\n// date.week(t: 2020-02-11T12:21:03.293534940Z)\n// ```\n//\n// ## Return the week of the year using a relative duration\n//\n// ```\n// import \"date\"\n//\n// option now = () => 2020-02-11T12:21:03.293534940Z\n//\n// date.week(t: -12d)\n// ```\nbuiltin week : (t: T) => int where T: Timeable\n\n// Quarter returns the quarter for a specified time. Results range \n//  from [1-4].\n//\n// ## Parameters\n// - `t` is the time to operate on.\n//\n//   Use an absolute time, relative duration, or integer. durations are\n//   relative to `now()`.\n//\n// ## Return the quarter for a time value\n//\n// ```\n// import \"date\"\n//\n// date.quarter(t: 2020-02-11T12:21:03.293534940Z)\n// ```\n//\n// ## Return the quarter for a relative duration\n//\n// ```\n// import \"date\"\n//\n// option now = () => 2020-02-11T12:21:03.293534940Z\n//\n// date.quarter(t: -7mo)\n// ```\nbuiltin quarter : (t: T) => int where T: Timeable\n\n// Millisecond returns the milliseconds for a specified time.\n//  Results range from [0-999].\n//\n// ## Parameters\n// - `t` is the time to operate on.\n//\n//   Use an absolute time, relative duration, or integer. durations are\n//   relative to `now()`.\n//\n// ## Return the millisecond of the time value\n//\n// ```\n// import \"date\"\n//\n// date.millisecond(t: 2020-02-11T12:21:03.293534940Z)\n// ```\n//\n// ## Return the millisecond of a relative duration\n//\n// ```\n// import \"date\"\n//\n// option now = () => 2020-02-11T12:21:03.293534940Z\n//\n// date.millisecond(t: -150ms)\n// ```\nbuiltin millisecond : (t: T) => int where T: Timeable\n\n// Microsecond returns the microseconds for a specified time.\n//  Results range from [0-999999].\n//\n// ## Parameters\n// - `t` is the time to operate on.\n//\n//   Use an absolute time, relative duration, or integer. durations are\n//   relative to `now()`.\n//\n// ## Return the microsecond of a time value\n//\n// ```\n// import \"date\"\n//\n// date.microsecond(t: 2020-02-11T12:21:03.293534940Z)\n// ```\n//\n// ## Return the microsecond of a relative duration\n//\n// ```\n// import \"date\"\n//\n// option now = () => 2020-02-11T12:21:03.293534940Z\n//\n// date.microsecond(t: -1890us)\n// ```\nbuiltin microsecond : (t: T) => int where T: Timeable\n\n// Nanosecond returns the nanoseconds for a specified time.\n// Results range from [0-999999999].\n//\n// ## Parameters\n// - `t` is the time to operate on.\n//\n//   Use an absolute time, relative duration, or integer. durations are\n//   relative to `now()`.\n//\n// ## Return the nanosecond for a time value\n//\n// ```\n// import \"date\"\n//\n// date.nanosecond(t: 2020-02-11T12:21:03.293534940Z)\n// ```\n//\n// ## Return the nanosecond for a relative duration\n//\n// ```\n// import \"date\"\n//\n// option now = () => 2020-02-11T12:21:03.293534940Z\n//\n// date.nanosecond(t: -2111984ns)\n// ```\nbuiltin nanosecond : (t: T) => int where T: Timeable\n\n// Truncate returns a time truncated to the specified duration unit.\n//\n// ## Parameters\n// - `t` is the time to operate on.\n//\n//   Use an absolute time, relative duration, or integer. durations are\n//   relative to `now()`.\n//\n// - `unit` is the unit of time to truncate to\n//\n//   Only use 1 and the unit of time to specify the unit. For example:\n//   1s, 1m, 1h.\n//\n// ## Example\n//\n// ```\n// import \"date\"\n//\n// date.truncate(\n//   t: 2019-07-17T12:05:21.012Z\n//   unit: 1s\n// )\n// ```\n//\n// ## Truncate time values\n//\n// ```\n// import \"date\"\n//\n// date.truncate(t: 2019-06-03T13:59:01.000000000Z, unit: 1s)\n// // Returns 2019-06-03T13:59:01.000000000Z\n//\n// date.truncate(t: 2019-06-03T13:59:01.000000000Z, unit: 1m)\n// // Returns 2019-06-03T13:59:00.000000000Z\n//\n// date.truncate(t: 2019-06-03T13:59:01.000000000Z, unit: 1h)\n// // Returns 2019-06-03T13:00:00.000000000Z\n// ```\n//\n// ## Truncate time values using durations\n//\n// ```\n// import \"date\"\n//\n// option now = () => 2020-01-01T00:00:30.500000000Z\n//\n// date.truncate(t: -30s, unit: 1s)\n// // Returns 2019-12-31T23:59:30.000000000Z\n//\n// date.truncate(t: -1m, unit: 1m)\n// // Returns 2019-12-31T23:59:00.000000000Z\n//\n// date.truncate(t: -1h, unit: 1h)\n// // Returns 2019-12-31T23:00:00.000000000Z\n// ```\nbuiltin truncate : (t: T, unit: duration) => time where T: Timeable\n\n// Sunday is a constant that represents Sunday as a day of the week\nSunday = 0\n\n// Monday is a constant that represents Monday as a day of the week.\nMonday = 1\n\n// Tuesday is a constant that represents Tuesday as a day of the week.\nTuesday = 2\n\n// Wednesday is a constant that represents Wednesday as a day of the week.\nWednesday = 3\n\n// Thursday is a constant that represents Thursday as a day of the week.\nThursday = 4\n\n// Friday is a constant that represents Friday as a day of the week.\nFriday = 5\n\n// Saturday is a constant that represents Saturday as a day of the week.\nSaturday = 6\n\n// January is a constant that represents the month of January.\nJanuary = 1\n\n// February is a constant that represents the month of February.\nFebruary = 2\n\n// March is a constant that represents the month of March.\nMarch = 3\n\n// April is a constant that represents the month of April.\nApril = 4\n\n// May is a constant that represents the month of May.\nMay = 5\n\n// June is a constant that represents the month of June.\nJune = 6\n\n// July is a constant that represents the month of July.\nJuly = 7\n\n// August is a constant that represents the month of August.\nAugust = 8\n\n// September is a constant that represents the month of September.\nSeptember = 9\n\n// October is a constant that represents the month of October.\nOctober = 10\n\n// November is a constant that represents the month of November.\nNovember = 11\n\n// December is a constant that represents the month of December.\nDecember = 12",
				Start: ast.Position{
					Column: 1,
					Line:   2,
				},
			},
		},
		Body: []ast.Statement{&ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// second is a function that returns the second of a specified time. Results\n"}, ast.Comment{Text: "//  range from [0 - 59].\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `t` is the time to operate on.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//   Use an absolute time, relative duration, or integer. durations are\n"}, ast.Comment{Text: "//   relative to `now()`.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Return the second of a time value\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"date\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// date.second(t: 2020-02-11T12:21:03.293534940Z)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Return the second of a relative duration\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"date\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// option now = () => 2020-02-11T12:21:03.293534940Z\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// date.second(t: -50s)\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   31,
					},
					File:   "date.flux",
					Source: "builtin second",
					Start: ast.Position{
						Column: 1,
						Line:   31,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   31,
						},
						File:   "date.flux",
						Source: "second",
						Start: ast.Position{
							Column: 9,
							Line:   31,
						},
					},
				},
				Name: "second",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 49,
							Line:   31,
						},
						File:   "date.flux",
						Source: "(t: T) => int where T: Timeable",
						Start: ast.Position{
							Column: 18,
							Line:   31,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 49,
								Line:   31,
							},
							File:   "date.flux",
							Source: "T: Timeable",
							Start: ast.Position{
								Column: 38,
								Line:   31,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 49,
									Line:   31,
								},
								File:   "date.flux",
								Source: "Timeable",
								Start: ast.Position{
									Column: 41,
									Line:   31,
								},
							},
						},
						Name: "Timeable",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 39,
									Line:   31,
								},
								File:   "date.flux",
								Source: "T",
								Start: ast.Position{
									Column: 38,
									Line:   31,
								},
							},
						},
						Name: "T",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 31,
								Line:   31,
							},
							File:   "date.flux",
							Source: "(t: T) => int",
							Start: ast.Position{
								Column: 18,
								Line:   31,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   31,
								},
								File:   "date.flux",
								Source: "t: T",
								Start: ast.Position{
									Column: 19,
									Line:   31,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   31,
									},
									File:   "date.flux",
									Source: "t",
									Start: ast.Position{
										Column: 19,
										Line:   31,
									},
								},
							},
							Name: "t",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   31,
									},
									File:   "date.flux",
									Source: "T",
									Start: ast.Position{
										Column: 22,
										Line:   31,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   31,
										},
										File:   "date.flux",
										Source: "T",
										Start: ast.Position{
											Column: 22,
											Line:   31,
										},
									},
								},
								Name: "T",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   31,
								},
								File:   "date.flux",
								Source: "int",
								Start: ast.Position{
									Column: 28,
									Line:   31,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   31,
									},
									File:   "date.flux",
									Source: "int",
									Start: ast.Position{
										Column: 28,
										Line:   31,
									},
								},
							},
							Name: "int",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// minute is a function that returns the minute of a specified time. Results\n"}, ast.Comment{Text: "//  range from [0 - 59].\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `t` is the time to operate on.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//    Use an absolute time, relative duration, or integer. durations are\n"}, ast.Comment{Text: "//    relative to `now()`.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Return the minute of a time value\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"date\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// date.minute(t: 2020-02-11T12:21:03.293534940Z)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Return the minute of a relative duration\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"date\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// option now = () => 2020-02-11T12:21:03.293534940Z\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// date.minute(t: -45m)\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   59,
					},
					File:   "date.flux",
					Source: "builtin minute",
					Start: ast.Position{
						Column: 1,
						Line:   59,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   59,
						},
						File:   "date.flux",
						Source: "minute",
						Start: ast.Position{
							Column: 9,
							Line:   59,
						},
					},
				},
				Name: "minute",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 49,
							Line:   59,
						},
						File:   "date.flux",
						Source: "(t: T) => int where T: Timeable",
						Start: ast.Position{
							Column: 18,
							Line:   59,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 49,
								Line:   59,
							},
							File:   "date.flux",
							Source: "T: Timeable",
							Start: ast.Position{
								Column: 38,
								Line:   59,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 49,
									Line:   59,
								},
								File:   "date.flux",
								Source: "Timeable",
								Start: ast.Position{
									Column: 41,
									Line:   59,
								},
							},
						},
						Name: "Timeable",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 39,
									Line:   59,
								},
								File:   "date.flux",
								Source: "T",
								Start: ast.Position{
									Column: 38,
									Line:   59,
								},
							},
						},
						Name: "T",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 31,
								Line:   59,
							},
							File:   "date.flux",
							Source: "(t: T) => int",
							Start: ast.Position{
								Column: 18,
								Line:   59,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 23,
									Line:   59,
								},
								File:   "date.flux",
								Source: "t: T",
								Start: ast.Position{
									Column: 19,
									Line:   59,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 20,
										Line:   59,
									},
									File:   "date.flux",
									Source: "t",
									Start: ast.Position{
										Column: 19,
										Line:   59,
									},
								},
							},
							Name: "t",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   59,
									},
									File:   "date.flux",
									Source: "T",
									Start: ast.Position{
										Column: 22,
										Line:   59,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 23,
											Line:   59,
										},
										File:   "date.flux",
										Source: "T",
										Start: ast.Position{
											Column: 22,
											Line:   59,
										},
									},
								},
								Name: "T",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   59,
								},
								File:   "date.flux",
								Source: "int",
								Start: ast.Position{
									Column: 28,
									Line:   59,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   59,
									},
									File:   "date.flux",
									Source: "int",
									Start: ast.Position{
										Column: 28,
										Line:   59,
									},
								},
							},
							Name: "int",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// hour is a function that returns the hour of a specified time. Results\n"}, ast.Comment{Text: "//  range from [0 - 23].\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `t` is the time to operate on.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//   Use an absolute time, relative duration, or integer. durations are\n"}, ast.Comment{Text: "//   relative to `now()`.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Return the hour of a time value\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"date\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// date.hour(t: 2020-02-11T12:21:03.293534940Z)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Return the hour of a relative duration\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"date\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// option now = () => 2020-02-11T12:21:03.293534940Z\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// date.hour(t: -8h)\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   87,
					},
					File:   "date.flux",
					Source: "builtin hour",
					Start: ast.Position{
						Column: 1,
						Line:   87,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   87,
						},
						File:   "date.flux",
						Source: "hour",
						Start: ast.Position{
							Column: 9,
							Line:   87,
						},
					},
				},
				Name: "hour",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 47,
							Line:   87,
						},
						File:   "date.flux",
						Source: "(t: T) => int where T: Timeable",
						Start: ast.Position{
							Column: 16,
							Line:   87,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 47,
								Line:   87,
							},
							File:   "date.flux",
							Source: "T: Timeable",
							Start: ast.Position{
								Column: 36,
								Line:   87,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   87,
								},
								File:   "date.flux",
								Source: "Timeable",
								Start: ast.Position{
									Column: 39,
									Line:   87,
								},
							},
						},
						Name: "Timeable",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   87,
								},
								File:   "date.flux",
								Source: "T",
								Start: ast.Position{
									Column: 36,
									Line:   87,
								},
							},
						},
						Name: "T",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   87,
							},
							File:   "date.flux",
							Source: "(t: T) => int",
							Start: ast.Position{
								Column: 16,
								Line:   87,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   87,
								},
								File:   "date.flux",
								Source: "t: T",
								Start: ast.Position{
									Column: 17,
									Line:   87,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   87,
									},
									File:   "date.flux",
									Source: "t",
									Start: ast.Position{
										Column: 17,
										Line:   87,
									},
								},
							},
							Name: "t",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   87,
									},
									File:   "date.flux",
									Source: "T",
									Start: ast.Position{
										Column: 20,
										Line:   87,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   87,
										},
										File:   "date.flux",
										Source: "T",
										Start: ast.Position{
											Column: 20,
											Line:   87,
										},
									},
								},
								Name: "T",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   87,
								},
								File:   "date.flux",
								Source: "int",
								Start: ast.Position{
									Column: 26,
									Line:   87,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   87,
									},
									File:   "date.flux",
									Source: "int",
									Start: ast.Position{
										Column: 26,
										Line:   87,
									},
								},
							},
							Name: "int",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// weekDay is a function that returns the day of the week for a specified time.\n"}, ast.Comment{Text: "//  Results range from [0 - 6].\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `t` is the time to operate on.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//   Use an absolute time, relative duration, or integer. durations are\n"}, ast.Comment{Text: "//   relative to `now()`.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Return the day of the week for a time value\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"date\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// date.weekDay(t: 2020-02-11T12:21:03.293534940Z)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Return the day of the week for a relative duration\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"date\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// option now = () => 2020-02-11T12:21:03.293534940Z\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// date.weekDay(t: -84h)\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   115,
					},
					File:   "date.flux",
					Source: "builtin weekDay",
					Start: ast.Position{
						Column: 1,
						Line:   115,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   115,
						},
						File:   "date.flux",
						Source: "weekDay",
						Start: ast.Position{
							Column: 9,
							Line:   115,
						},
					},
				},
				Name: "weekDay",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 50,
							Line:   115,
						},
						File:   "date.flux",
						Source: "(t: T) => int where T: Timeable",
						Start: ast.Position{
							Column: 19,
							Line:   115,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 50,
								Line:   115,
							},
							File:   "date.flux",
							Source: "T: Timeable",
							Start: ast.Position{
								Column: 39,
								Line:   115,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   115,
								},
								File:   "date.flux",
								Source: "Timeable",
								Start: ast.Position{
									Column: 42,
									Line:   115,
								},
							},
						},
						Name: "Timeable",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   115,
								},
								File:   "date.flux",
								Source: "T",
								Start: ast.Position{
									Column: 39,
									Line:   115,
								},
							},
						},
						Name: "T",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 32,
								Line:   115,
							},
							File:   "date.flux",
							Source: "(t: T) => int",
							Start: ast.Position{
								Column: 19,
								Line:   115,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   115,
								},
								File:   "date.flux",
								Source: "t: T",
								Start: ast.Position{
									Column: 20,
									Line:   115,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   115,
									},
									File:   "date.flux",
									Source: "t",
									Start: ast.Position{
										Column: 20,
										Line:   115,
									},
								},
							},
							Name: "t",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   115,
									},
									File:   "date.flux",
									Source: "T",
									Start: ast.Position{
										Column: 23,
										Line:   115,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   115,
										},
										File:   "date.flux",
										Source: "T",
										Start: ast.Position{
											Column: 23,
											Line:   115,
										},
									},
								},
								Name: "T",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   115,
								},
								File:   "date.flux",
								Source: "int",
								Start: ast.Position{
									Column: 29,
									Line:   115,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   115,
									},
									File:   "date.flux",
									Source: "int",
									Start: ast.Position{
										Column: 29,
										Line:   115,
									},
								},
							},
							Name: "int",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// monthDay is a function that returns the day of the month for a specified\n"}, ast.Comment{Text: "//  time. Results range from [1 - 31].\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `t` is the time to operate on.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//   Use an absolute time, relative duration, or integer. durations are\n"}, ast.Comment{Text: "//   relative to `now()`.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Return the day of the month for a time value\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"date\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// date.monthDay(t: 2020-02-11T12:21:03.293534940Z)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Return the day of the month for a relative duration\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"date\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//option now = () => 2020-02-11T12:21:03.293534940Z\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//date.monthDay(t: -8d)\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   143,
					},
					File:   "date.flux",
					Source: "builtin monthDay",
					Start: ast.Position{
						Column: 1,
						Line:   143,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   143,
						},
						File:   "date.flux",
						Source: "monthDay",
						Start: ast.Position{
							Column: 9,
							Line:   143,
						},
					},
				},
				Name: "monthDay",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 51,
							Line:   143,
						},
						File:   "date.flux",
						Source: "(t: T) => int where T: Timeable",
						Start: ast.Position{
							Column: 20,
							Line:   143,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 51,
								Line:   143,
							},
							File:   "date.flux",
							Source: "T: Timeable",
							Start: ast.Position{
								Column: 40,
								Line:   143,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 51,
									Line:   143,
								},
								File:   "date.flux",
								Source: "Timeable",
								Start: ast.Position{
									Column: 43,
									Line:   143,
								},
							},
						},
						Name: "Timeable",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 41,
									Line:   143,
								},
								File:   "date.flux",
								Source: "T",
								Start: ast.Position{
									Column: 40,
									Line:   143,
								},
							},
						},
						Name: "T",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 33,
								Line:   143,
							},
							File:   "date.flux",
							Source: "(t: T) => int",
							Start: ast.Position{
								Column: 20,
								Line:   143,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   143,
								},
								File:   "date.flux",
								Source: "t: T",
								Start: ast.Position{
									Column: 21,
									Line:   143,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   143,
									},
									File:   "date.flux",
									Source: "t",
									Start: ast.Position{
										Column: 21,
										Line:   143,
									},
								},
							},
							Name: "t",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   143,
									},
									File:   "date.flux",
									Source: "T",
									Start: ast.Position{
										Column: 24,
										Line:   143,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   143,
										},
										File:   "date.flux",
										Source: "T",
										Start: ast.Position{
											Column: 24,
											Line:   143,
										},
									},
								},
								Name: "T",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 33,
									Line:   143,
								},
								File:   "date.flux",
								Source: "int",
								Start: ast.Position{
									Column: 30,
									Line:   143,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 33,
										Line:   143,
									},
									File:   "date.flux",
									Source: "int",
									Start: ast.Position{
										Column: 30,
										Line:   143,
									},
								},
							},
							Name: "int",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// yearDay is a function that returns the day of the year for a specified time\n"}, ast.Comment{Text: "//  Results can include leap days and range from [ 1 - 366].\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `t` is the time to operate on.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//   Use an absolute time, relative duration, or integer. durations are\n"}, ast.Comment{Text: "//   relative to `now()`.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Return the day of the year for a time value\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"date\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//date.yearDay(t: 2020-02-11T12:21:03.293534940Z)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Return the day of the year for a relative duration\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"date\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// option now = () => 2020-02-11T12:21:03.293534940Z\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// date.yearDay(t: -1mo)\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   171,
					},
					File:   "date.flux",
					Source: "builtin yearDay",
					Start: ast.Position{
						Column: 1,
						Line:   171,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   171,
						},
						File:   "date.flux",
						Source: "yearDay",
						Start: ast.Position{
							Column: 9,
							Line:   171,
						},
					},
				},
				Name: "yearDay",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 50,
							Line:   171,
						},
						File:   "date.flux",
						Source: "(t: T) => int where T: Timeable",
						Start: ast.Position{
							Column: 19,
							Line:   171,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 50,
								Line:   171,
							},
							File:   "date.flux",
							Source: "T: Timeable",
							Start: ast.Position{
								Column: 39,
								Line:   171,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   171,
								},
								File:   "date.flux",
								Source: "Timeable",
								Start: ast.Position{
									Column: 42,
									Line:   171,
								},
							},
						},
						Name: "Timeable",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   171,
								},
								File:   "date.flux",
								Source: "T",
								Start: ast.Position{
									Column: 39,
									Line:   171,
								},
							},
						},
						Name: "T",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 32,
								Line:   171,
							},
							File:   "date.flux",
							Source: "(t: T) => int",
							Start: ast.Position{
								Column: 19,
								Line:   171,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   171,
								},
								File:   "date.flux",
								Source: "t: T",
								Start: ast.Position{
									Column: 20,
									Line:   171,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   171,
									},
									File:   "date.flux",
									Source: "t",
									Start: ast.Position{
										Column: 20,
										Line:   171,
									},
								},
							},
							Name: "t",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   171,
									},
									File:   "date.flux",
									Source: "T",
									Start: ast.Position{
										Column: 23,
										Line:   171,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   171,
										},
										File:   "date.flux",
										Source: "T",
										Start: ast.Position{
											Column: 23,
											Line:   171,
										},
									},
								},
								Name: "T",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   171,
								},
								File:   "date.flux",
								Source: "int",
								Start: ast.Position{
									Column: 29,
									Line:   171,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   171,
									},
									File:   "date.flux",
									Source: "int",
									Start: ast.Position{
										Column: 29,
										Line:   171,
									},
								},
							},
							Name: "int",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// month is a function that returns the month of a specified time.\n"}, ast.Comment{Text: "//  Results range from [1 - 12].\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `t` is the time to operate on.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//   Use an absolute time, relative duration, or integer. durations are\n"}, ast.Comment{Text: "//   relative to `now()`.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Return the month of a time value\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"date\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//date.month(t: 2020-02-11T12:21:03.293534940Z)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Retrun the month of a relative duration\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"date\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// option now = () => 2020-02-11T12:21:03.293534940Z\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// date.month(t: -3mo)\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   199,
					},
					File:   "date.flux",
					Source: "builtin month",
					Start: ast.Position{
						Column: 1,
						Line:   199,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   199,
						},
						File:   "date.flux",
						Source: "month",
						Start: ast.Position{
							Column: 9,
							Line:   199,
						},
					},
				},
				Name: "month",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 48,
							Line:   199,
						},
						File:   "date.flux",
						Source: "(t: T) => int where T: Timeable",
						Start: ast.Position{
							Column: 17,
							Line:   199,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 48,
								Line:   199,
							},
							File:   "date.flux",
							Source: "T: Timeable",
							Start: ast.Position{
								Column: 37,
								Line:   199,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 48,
									Line:   199,
								},
								File:   "date.flux",
								Source: "Timeable",
								Start: ast.Position{
									Column: 40,
									Line:   199,
								},
							},
						},
						Name: "Timeable",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 38,
									Line:   199,
								},
								File:   "date.flux",
								Source: "T",
								Start: ast.Position{
									Column: 37,
									Line:   199,
								},
							},
						},
						Name: "T",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 30,
								Line:   199,
							},
							File:   "date.flux",
							Source: "(t: T) => int",
							Start: ast.Position{
								Column: 17,
								Line:   199,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 22,
									Line:   199,
								},
								File:   "date.flux",
								Source: "t: T",
								Start: ast.Position{
									Column: 18,
									Line:   199,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 19,
										Line:   199,
									},
									File:   "date.flux",
									Source: "t",
									Start: ast.Position{
										Column: 18,
										Line:   199,
									},
								},
							},
							Name: "t",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   199,
									},
									File:   "date.flux",
									Source: "T",
									Start: ast.Position{
										Column: 21,
										Line:   199,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 22,
											Line:   199,
										},
										File:   "date.flux",
										Source: "T",
										Start: ast.Position{
											Column: 21,
											Line:   199,
										},
									},
								},
								Name: "T",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 30,
									Line:   199,
								},
								File:   "date.flux",
								Source: "int",
								Start: ast.Position{
									Column: 27,
									Line:   199,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   199,
									},
									File:   "date.flux",
									Source: "int",
									Start: ast.Position{
										Column: 27,
										Line:   199,
									},
								},
							},
							Name: "int",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// year is a function that returns the year of a specified time.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `t` is the time to operate on.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//   Use an absolute time, relative duration, or integer. durations are\n"}, ast.Comment{Text: "//   relative to `now()`.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Return the year for a time value\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"date\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//date.year(t: 2020-02-11T12:21:03.293534940Z)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Return the year for a relative duration\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"date\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// option now = () => 2020-02-11T12:21:03.293534940Z\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// date.year(t: -14y)\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   226,
					},
					File:   "date.flux",
					Source: "builtin year",
					Start: ast.Position{
						Column: 1,
						Line:   226,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   226,
						},
						File:   "date.flux",
						Source: "year",
						Start: ast.Position{
							Column: 9,
							Line:   226,
						},
					},
				},
				Name: "year",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 47,
							Line:   226,
						},
						File:   "date.flux",
						Source: "(t: T) => int where T: Timeable",
						Start: ast.Position{
							Column: 16,
							Line:   226,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 47,
								Line:   226,
							},
							File:   "date.flux",
							Source: "T: Timeable",
							Start: ast.Position{
								Column: 36,
								Line:   226,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   226,
								},
								File:   "date.flux",
								Source: "Timeable",
								Start: ast.Position{
									Column: 39,
									Line:   226,
								},
							},
						},
						Name: "Timeable",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   226,
								},
								File:   "date.flux",
								Source: "T",
								Start: ast.Position{
									Column: 36,
									Line:   226,
								},
							},
						},
						Name: "T",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   226,
							},
							File:   "date.flux",
							Source: "(t: T) => int",
							Start: ast.Position{
								Column: 16,
								Line:   226,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   226,
								},
								File:   "date.flux",
								Source: "t: T",
								Start: ast.Position{
									Column: 17,
									Line:   226,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   226,
									},
									File:   "date.flux",
									Source: "t",
									Start: ast.Position{
										Column: 17,
										Line:   226,
									},
								},
							},
							Name: "t",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   226,
									},
									File:   "date.flux",
									Source: "T",
									Start: ast.Position{
										Column: 20,
										Line:   226,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   226,
										},
										File:   "date.flux",
										Source: "T",
										Start: ast.Position{
											Column: 20,
											Line:   226,
										},
									},
								},
								Name: "T",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   226,
								},
								File:   "date.flux",
								Source: "int",
								Start: ast.Position{
									Column: 26,
									Line:   226,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   226,
									},
									File:   "date.flux",
									Source: "int",
									Start: ast.Position{
										Column: 26,
										Line:   226,
									},
								},
							},
							Name: "int",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// week is a function that returns the ISO week of the year for a specified time.\n"}, ast.Comment{Text: "//  Results range from [1 - 53].\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `t` is the time to operate on.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//   Use an absolute time, relative duration, or integer. durations are\n"}, ast.Comment{Text: "//   relative to `now()`. \n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Return the week of the year\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"date\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// date.week(t: 2020-02-11T12:21:03.293534940Z)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Return the week of the year using a relative duration\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"date\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// option now = () => 2020-02-11T12:21:03.293534940Z\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// date.week(t: -12d)\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   254,
					},
					File:   "date.flux",
					Source: "builtin week",
					Start: ast.Position{
						Column: 1,
						Line:   254,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   254,
						},
						File:   "date.flux",
						Source: "week",
						Start: ast.Position{
							Column: 9,
							Line:   254,
						},
					},
				},
				Name: "week",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 47,
							Line:   254,
						},
						File:   "date.flux",
						Source: "(t: T) => int where T: Timeable",
						Start: ast.Position{
							Column: 16,
							Line:   254,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 47,
								Line:   254,
							},
							File:   "date.flux",
							Source: "T: Timeable",
							Start: ast.Position{
								Column: 36,
								Line:   254,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   254,
								},
								File:   "date.flux",
								Source: "Timeable",
								Start: ast.Position{
									Column: 39,
									Line:   254,
								},
							},
						},
						Name: "Timeable",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   254,
								},
								File:   "date.flux",
								Source: "T",
								Start: ast.Position{
									Column: 36,
									Line:   254,
								},
							},
						},
						Name: "T",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 29,
								Line:   254,
							},
							File:   "date.flux",
							Source: "(t: T) => int",
							Start: ast.Position{
								Column: 16,
								Line:   254,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 21,
									Line:   254,
								},
								File:   "date.flux",
								Source: "t: T",
								Start: ast.Position{
									Column: 17,
									Line:   254,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 18,
										Line:   254,
									},
									File:   "date.flux",
									Source: "t",
									Start: ast.Position{
										Column: 17,
										Line:   254,
									},
								},
							},
							Name: "t",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   254,
									},
									File:   "date.flux",
									Source: "T",
									Start: ast.Position{
										Column: 20,
										Line:   254,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   254,
										},
										File:   "date.flux",
										Source: "T",
										Start: ast.Position{
											Column: 20,
											Line:   254,
										},
									},
								},
								Name: "T",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   254,
								},
								File:   "date.flux",
								Source: "int",
								Start: ast.Position{
									Column: 26,
									Line:   254,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   254,
									},
									File:   "date.flux",
									Source: "int",
									Start: ast.Position{
										Column: 26,
										Line:   254,
									},
								},
							},
							Name: "int",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// Quarter returns the quarter for a specified time. Results range \n"}, ast.Comment{Text: "//  from [1-4].\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `t` is the time to operate on.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//   Use an absolute time, relative duration, or integer. durations are\n"}, ast.Comment{Text: "//   relative to `now()`.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Return the quarter for a time value\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"date\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// date.quarter(t: 2020-02-11T12:21:03.293534940Z)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Return the quarter for a relative duration\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"date\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// option now = () => 2020-02-11T12:21:03.293534940Z\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// date.quarter(t: -7mo)\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   282,
					},
					File:   "date.flux",
					Source: "builtin quarter",
					Start: ast.Position{
						Column: 1,
						Line:   282,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   282,
						},
						File:   "date.flux",
						Source: "quarter",
						Start: ast.Position{
							Column: 9,
							Line:   282,
						},
					},
				},
				Name: "quarter",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 50,
							Line:   282,
						},
						File:   "date.flux",
						Source: "(t: T) => int where T: Timeable",
						Start: ast.Position{
							Column: 19,
							Line:   282,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 50,
								Line:   282,
							},
							File:   "date.flux",
							Source: "T: Timeable",
							Start: ast.Position{
								Column: 39,
								Line:   282,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   282,
								},
								File:   "date.flux",
								Source: "Timeable",
								Start: ast.Position{
									Column: 42,
									Line:   282,
								},
							},
						},
						Name: "Timeable",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   282,
								},
								File:   "date.flux",
								Source: "T",
								Start: ast.Position{
									Column: 39,
									Line:   282,
								},
							},
						},
						Name: "T",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 32,
								Line:   282,
							},
							File:   "date.flux",
							Source: "(t: T) => int",
							Start: ast.Position{
								Column: 19,
								Line:   282,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 24,
									Line:   282,
								},
								File:   "date.flux",
								Source: "t: T",
								Start: ast.Position{
									Column: 20,
									Line:   282,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   282,
									},
									File:   "date.flux",
									Source: "t",
									Start: ast.Position{
										Column: 20,
										Line:   282,
									},
								},
							},
							Name: "t",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   282,
									},
									File:   "date.flux",
									Source: "T",
									Start: ast.Position{
										Column: 23,
										Line:   282,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   282,
										},
										File:   "date.flux",
										Source: "T",
										Start: ast.Position{
											Column: 23,
											Line:   282,
										},
									},
								},
								Name: "T",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   282,
								},
								File:   "date.flux",
								Source: "int",
								Start: ast.Position{
									Column: 29,
									Line:   282,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   282,
									},
									File:   "date.flux",
									Source: "int",
									Start: ast.Position{
										Column: 29,
										Line:   282,
									},
								},
							},
							Name: "int",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// Millisecond returns the milliseconds for a specified time.\n"}, ast.Comment{Text: "//  Results range from [0-999].\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `t` is the time to operate on.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//   Use an absolute time, relative duration, or integer. durations are\n"}, ast.Comment{Text: "//   relative to `now()`.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Return the millisecond of the time value\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"date\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// date.millisecond(t: 2020-02-11T12:21:03.293534940Z)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Return the millisecond of a relative duration\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"date\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// option now = () => 2020-02-11T12:21:03.293534940Z\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// date.millisecond(t: -150ms)\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   310,
					},
					File:   "date.flux",
					Source: "builtin millisecond",
					Start: ast.Position{
						Column: 1,
						Line:   310,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   310,
						},
						File:   "date.flux",
						Source: "millisecond",
						Start: ast.Position{
							Column: 9,
							Line:   310,
						},
					},
				},
				Name: "millisecond",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 54,
							Line:   310,
						},
						File:   "date.flux",
						Source: "(t: T) => int where T: Timeable",
						Start: ast.Position{
							Column: 23,
							Line:   310,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 54,
								Line:   310,
							},
							File:   "date.flux",
							Source: "T: Timeable",
							Start: ast.Position{
								Column: 43,
								Line:   310,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 54,
									Line:   310,
								},
								File:   "date.flux",
								Source: "Timeable",
								Start: ast.Position{
									Column: 46,
									Line:   310,
								},
							},
						},
						Name: "Timeable",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 44,
									Line:   310,
								},
								File:   "date.flux",
								Source: "T",
								Start: ast.Position{
									Column: 43,
									Line:   310,
								},
							},
						},
						Name: "T",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 36,
								Line:   310,
							},
							File:   "date.flux",
							Source: "(t: T) => int",
							Start: ast.Position{
								Column: 23,
								Line:   310,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   310,
								},
								File:   "date.flux",
								Source: "t: T",
								Start: ast.Position{
									Column: 24,
									Line:   310,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   310,
									},
									File:   "date.flux",
									Source: "t",
									Start: ast.Position{
										Column: 24,
										Line:   310,
									},
								},
							},
							Name: "t",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   310,
									},
									File:   "date.flux",
									Source: "T",
									Start: ast.Position{
										Column: 27,
										Line:   310,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   310,
										},
										File:   "date.flux",
										Source: "T",
										Start: ast.Position{
											Column: 27,
											Line:   310,
										},
									},
								},
								Name: "T",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   310,
								},
								File:   "date.flux",
								Source: "int",
								Start: ast.Position{
									Column: 33,
									Line:   310,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   310,
									},
									File:   "date.flux",
									Source: "int",
									Start: ast.Position{
										Column: 33,
										Line:   310,
									},
								},
							},
							Name: "int",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// Microsecond returns the microseconds for a specified time.\n"}, ast.Comment{Text: "//  Results range from [0-999999].\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `t` is the time to operate on.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//   Use an absolute time, relative duration, or integer. durations are\n"}, ast.Comment{Text: "//   relative to `now()`.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Return the microsecond of a time value\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"date\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// date.microsecond(t: 2020-02-11T12:21:03.293534940Z)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Return the microsecond of a relative duration\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"date\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// option now = () => 2020-02-11T12:21:03.293534940Z\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// date.microsecond(t: -1890us)\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   338,
					},
					File:   "date.flux",
					Source: "builtin microsecond",
					Start: ast.Position{
						Column: 1,
						Line:   338,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   338,
						},
						File:   "date.flux",
						Source: "microsecond",
						Start: ast.Position{
							Column: 9,
							Line:   338,
						},
					},
				},
				Name: "microsecond",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 54,
							Line:   338,
						},
						File:   "date.flux",
						Source: "(t: T) => int where T: Timeable",
						Start: ast.Position{
							Column: 23,
							Line:   338,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 54,
								Line:   338,
							},
							File:   "date.flux",
							Source: "T: Timeable",
							Start: ast.Position{
								Column: 43,
								Line:   338,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 54,
									Line:   338,
								},
								File:   "date.flux",
								Source: "Timeable",
								Start: ast.Position{
									Column: 46,
									Line:   338,
								},
							},
						},
						Name: "Timeable",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 44,
									Line:   338,
								},
								File:   "date.flux",
								Source: "T",
								Start: ast.Position{
									Column: 43,
									Line:   338,
								},
							},
						},
						Name: "T",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 36,
								Line:   338,
							},
							File:   "date.flux",
							Source: "(t: T) => int",
							Start: ast.Position{
								Column: 23,
								Line:   338,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   338,
								},
								File:   "date.flux",
								Source: "t: T",
								Start: ast.Position{
									Column: 24,
									Line:   338,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   338,
									},
									File:   "date.flux",
									Source: "t",
									Start: ast.Position{
										Column: 24,
										Line:   338,
									},
								},
							},
							Name: "t",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 28,
										Line:   338,
									},
									File:   "date.flux",
									Source: "T",
									Start: ast.Position{
										Column: 27,
										Line:   338,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   338,
										},
										File:   "date.flux",
										Source: "T",
										Start: ast.Position{
											Column: 27,
											Line:   338,
										},
									},
								},
								Name: "T",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 36,
									Line:   338,
								},
								File:   "date.flux",
								Source: "int",
								Start: ast.Position{
									Column: 33,
									Line:   338,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   338,
									},
									File:   "date.flux",
									Source: "int",
									Start: ast.Position{
										Column: 33,
										Line:   338,
									},
								},
							},
							Name: "int",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// Nanosecond returns the nanoseconds for a specified time.\n"}, ast.Comment{Text: "// Results range from [0-999999999].\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `t` is the time to operate on.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//   Use an absolute time, relative duration, or integer. durations are\n"}, ast.Comment{Text: "//   relative to `now()`.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Return the nanosecond for a time value\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"date\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// date.nanosecond(t: 2020-02-11T12:21:03.293534940Z)\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Return the nanosecond for a relative duration\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"date\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// option now = () => 2020-02-11T12:21:03.293534940Z\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// date.nanosecond(t: -2111984ns)\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   366,
					},
					File:   "date.flux",
					Source: "builtin nanosecond",
					Start: ast.Position{
						Column: 1,
						Line:   366,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   366,
						},
						File:   "date.flux",
						Source: "nanosecond",
						Start: ast.Position{
							Column: 9,
							Line:   366,
						},
					},
				},
				Name: "nanosecond",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 53,
							Line:   366,
						},
						File:   "date.flux",
						Source: "(t: T) => int where T: Timeable",
						Start: ast.Position{
							Column: 22,
							Line:   366,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 53,
								Line:   366,
							},
							File:   "date.flux",
							Source: "T: Timeable",
							Start: ast.Position{
								Column: 42,
								Line:   366,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 53,
									Line:   366,
								},
								File:   "date.flux",
								Source: "Timeable",
								Start: ast.Position{
									Column: 45,
									Line:   366,
								},
							},
						},
						Name: "Timeable",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 43,
									Line:   366,
								},
								File:   "date.flux",
								Source: "T",
								Start: ast.Position{
									Column: 42,
									Line:   366,
								},
							},
						},
						Name: "T",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 35,
								Line:   366,
							},
							File:   "date.flux",
							Source: "(t: T) => int",
							Start: ast.Position{
								Column: 22,
								Line:   366,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 27,
									Line:   366,
								},
								File:   "date.flux",
								Source: "t: T",
								Start: ast.Position{
									Column: 23,
									Line:   366,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   366,
									},
									File:   "date.flux",
									Source: "t",
									Start: ast.Position{
										Column: 23,
										Line:   366,
									},
								},
							},
							Name: "t",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 27,
										Line:   366,
									},
									File:   "date.flux",
									Source: "T",
									Start: ast.Position{
										Column: 26,
										Line:   366,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 27,
											Line:   366,
										},
										File:   "date.flux",
										Source: "T",
										Start: ast.Position{
											Column: 26,
											Line:   366,
										},
									},
								},
								Name: "T",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   366,
								},
								File:   "date.flux",
								Source: "int",
								Start: ast.Position{
									Column: 32,
									Line:   366,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   366,
									},
									File:   "date.flux",
									Source: "int",
									Start: ast.Position{
										Column: 32,
										Line:   366,
									},
								},
							},
							Name: "int",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// Truncate returns a time truncated to the specified duration unit.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `t` is the time to operate on.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//   Use an absolute time, relative duration, or integer. durations are\n"}, ast.Comment{Text: "//   relative to `now()`.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// - `unit` is the unit of time to truncate to\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//   Only use 1 and the unit of time to specify the unit. For example:\n"}, ast.Comment{Text: "//   1s, 1m, 1h.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"date\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// date.truncate(\n"}, ast.Comment{Text: "//   t: 2019-07-17T12:05:21.012Z\n"}, ast.Comment{Text: "//   unit: 1s\n"}, ast.Comment{Text: "// )\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Truncate time values\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"date\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// date.truncate(t: 2019-06-03T13:59:01.000000000Z, unit: 1s)\n"}, ast.Comment{Text: "// // Returns 2019-06-03T13:59:01.000000000Z\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// date.truncate(t: 2019-06-03T13:59:01.000000000Z, unit: 1m)\n"}, ast.Comment{Text: "// // Returns 2019-06-03T13:59:00.000000000Z\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// date.truncate(t: 2019-06-03T13:59:01.000000000Z, unit: 1h)\n"}, ast.Comment{Text: "// // Returns 2019-06-03T13:00:00.000000000Z\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Truncate time values using durations\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"date\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// option now = () => 2020-01-01T00:00:30.500000000Z\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// date.truncate(t: -30s, unit: 1s)\n"}, ast.Comment{Text: "// // Returns 2019-12-31T23:59:30.000000000Z\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// date.truncate(t: -1m, unit: 1m)\n"}, ast.Comment{Text: "// // Returns 2019-12-31T23:59:00.000000000Z\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// date.truncate(t: -1h, unit: 1h)\n"}, ast.Comment{Text: "// // Returns 2019-12-31T23:00:00.000000000Z\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 17,
						Line:   423,
					},
					File:   "date.flux",
					Source: "builtin truncate",
					Start: ast.Position{
						Column: 1,
						Line:   423,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 17,
							Line:   423,
						},
						File:   "date.flux",
						Source: "truncate",
						Start: ast.Position{
							Column: 9,
							Line:   423,
						},
					},
				},
				Name: "truncate",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 68,
							Line:   423,
						},
						File:   "date.flux",
						Source: "(t: T, unit: duration) => time where T: Timeable",
						Start: ast.Position{
							Column: 20,
							Line:   423,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{&ast.TypeConstraint{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 68,
								Line:   423,
							},
							File:   "date.flux",
							Source: "T: Timeable",
							Start: ast.Position{
								Column: 57,
								Line:   423,
							},
						},
					},
					Kinds: []*ast.Identifier{&ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 68,
									Line:   423,
								},
								File:   "date.flux",
								Source: "Timeable",
								Start: ast.Position{
									Column: 60,
									Line:   423,
								},
							},
						},
						Name: "Timeable",
					}},
					Tvar: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 58,
									Line:   423,
								},
								File:   "date.flux",
								Source: "T",
								Start: ast.Position{
									Column: 57,
									Line:   423,
								},
							},
						},
						Name: "T",
					},
				}},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 50,
								Line:   423,
							},
							File:   "date.flux",
							Source: "(t: T, unit: duration) => time",
							Start: ast.Position{
								Column: 20,
								Line:   423,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   423,
								},
								File:   "date.flux",
								Source: "t: T",
								Start: ast.Position{
									Column: 21,
									Line:   423,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 22,
										Line:   423,
									},
									File:   "date.flux",
									Source: "t",
									Start: ast.Position{
										Column: 21,
										Line:   423,
									},
								},
							},
							Name: "t",
						},
						Ty: &ast.TvarType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   423,
									},
									File:   "date.flux",
									Source: "T",
									Start: ast.Position{
										Column: 24,
										Line:   423,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 25,
											Line:   423,
										},
										File:   "date.flux",
										Source: "T",
										Start: ast.Position{
											Column: 24,
											Line:   423,
										},
									},
								},
								Name: "T",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 41,
									Line:   423,
								},
								File:   "date.flux",
								Source: "unit: duration",
								Start: ast.Position{
									Column: 27,
									Line:   423,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   423,
									},
									File:   "date.flux",
									Source: "unit",
									Start: ast.Position{
										Column: 27,
										Line:   423,
									},
								},
							},
							Name: "unit",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   423,
									},
									File:   "date.flux",
									Source: "duration",
									Start: ast.Position{
										Column: 33,
										Line:   423,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 41,
											Line:   423,
										},
										File:   "date.flux",
										Source: "duration",
										Start: ast.Position{
											Column: 33,
											Line:   423,
										},
									},
								},
								Name: "duration",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   423,
								},
								File:   "date.flux",
								Source: "time",
								Start: ast.Position{
									Column: 46,
									Line:   423,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 50,
										Line:   423,
									},
									File:   "date.flux",
									Source: "time",
									Start: ast.Position{
										Column: 46,
										Line:   423,
									},
								},
							},
							Name: "time",
						},
					},
				},
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 11,
						Line:   426,
					},
					File:   "date.flux",
					Source: "Sunday = 0",
					Start: ast.Position{
						Column: 1,
						Line:   426,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// Sunday is a constant that represents Sunday as a day of the week\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   426,
						},
						File:   "date.flux",
						Source: "Sunday",
						Start: ast.Position{
							Column: 1,
							Line:   426,
						},
					},
				},
				Name: "Sunday",
			},
			Init: &ast.IntegerLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 11,
							Line:   426,
						},
						File:   "date.flux",
						Source: "0",
						Start: ast.Position{
							Column: 10,
							Line:   426,
						},
					},
				},
				Value: int64(0),
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 11,
						Line:   429,
					},
					File:   "date.flux",
					Source: "Monday = 1",
					Start: ast.Position{
						Column: 1,
						Line:   429,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// Monday is a constant that represents Monday as a day of the week.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   429,
						},
						File:   "date.flux",
						Source: "Monday",
						Start: ast.Position{
							Column: 1,
							Line:   429,
						},
					},
				},
				Name: "Monday",
			},
			Init: &ast.IntegerLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 11,
							Line:   429,
						},
						File:   "date.flux",
						Source: "1",
						Start: ast.Position{
							Column: 10,
							Line:   429,
						},
					},
				},
				Value: int64(1),
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   432,
					},
					File:   "date.flux",
					Source: "Tuesday = 2",
					Start: ast.Position{
						Column: 1,
						Line:   432,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// Tuesday is a constant that represents Tuesday as a day of the week.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   432,
						},
						File:   "date.flux",
						Source: "Tuesday",
						Start: ast.Position{
							Column: 1,
							Line:   432,
						},
					},
				},
				Name: "Tuesday",
			},
			Init: &ast.IntegerLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   432,
						},
						File:   "date.flux",
						Source: "2",
						Start: ast.Position{
							Column: 11,
							Line:   432,
						},
					},
				},
				Value: int64(2),
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   435,
					},
					File:   "date.flux",
					Source: "Wednesday = 3",
					Start: ast.Position{
						Column: 1,
						Line:   435,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// Wednesday is a constant that represents Wednesday as a day of the week.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 10,
							Line:   435,
						},
						File:   "date.flux",
						Source: "Wednesday",
						Start: ast.Position{
							Column: 1,
							Line:   435,
						},
					},
				},
				Name: "Wednesday",
			},
			Init: &ast.IntegerLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   435,
						},
						File:   "date.flux",
						Source: "3",
						Start: ast.Position{
							Column: 13,
							Line:   435,
						},
					},
				},
				Value: int64(3),
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   438,
					},
					File:   "date.flux",
					Source: "Thursday = 4",
					Start: ast.Position{
						Column: 1,
						Line:   438,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// Thursday is a constant that represents Thursday as a day of the week.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   438,
						},
						File:   "date.flux",
						Source: "Thursday",
						Start: ast.Position{
							Column: 1,
							Line:   438,
						},
					},
				},
				Name: "Thursday",
			},
			Init: &ast.IntegerLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   438,
						},
						File:   "date.flux",
						Source: "4",
						Start: ast.Position{
							Column: 12,
							Line:   438,
						},
					},
				},
				Value: int64(4),
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 11,
						Line:   441,
					},
					File:   "date.flux",
					Source: "Friday = 5",
					Start: ast.Position{
						Column: 1,
						Line:   441,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// Friday is a constant that represents Friday as a day of the week.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   441,
						},
						File:   "date.flux",
						Source: "Friday",
						Start: ast.Position{
							Column: 1,
							Line:   441,
						},
					},
				},
				Name: "Friday",
			},
			Init: &ast.IntegerLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 11,
							Line:   441,
						},
						File:   "date.flux",
						Source: "5",
						Start: ast.Position{
							Column: 10,
							Line:   441,
						},
					},
				},
				Value: int64(5),
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   444,
					},
					File:   "date.flux",
					Source: "Saturday = 6",
					Start: ast.Position{
						Column: 1,
						Line:   444,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// Saturday is a constant that represents Saturday as a day of the week.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   444,
						},
						File:   "date.flux",
						Source: "Saturday",
						Start: ast.Position{
							Column: 1,
							Line:   444,
						},
					},
				},
				Name: "Saturday",
			},
			Init: &ast.IntegerLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   444,
						},
						File:   "date.flux",
						Source: "6",
						Start: ast.Position{
							Column: 12,
							Line:   444,
						},
					},
				},
				Value: int64(6),
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 12,
						Line:   447,
					},
					File:   "date.flux",
					Source: "January = 1",
					Start: ast.Position{
						Column: 1,
						Line:   447,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// January is a constant that represents the month of January.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   447,
						},
						File:   "date.flux",
						Source: "January",
						Start: ast.Position{
							Column: 1,
							Line:   447,
						},
					},
				},
				Name: "January",
			},
			Init: &ast.IntegerLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 12,
							Line:   447,
						},
						File:   "date.flux",
						Source: "1",
						Start: ast.Position{
							Column: 11,
							Line:   447,
						},
					},
				},
				Value: int64(1),
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   450,
					},
					File:   "date.flux",
					Source: "February = 2",
					Start: ast.Position{
						Column: 1,
						Line:   450,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// February is a constant that represents the month of February.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   450,
						},
						File:   "date.flux",
						Source: "February",
						Start: ast.Position{
							Column: 1,
							Line:   450,
						},
					},
				},
				Name: "February",
			},
			Init: &ast.IntegerLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   450,
						},
						File:   "date.flux",
						Source: "2",
						Start: ast.Position{
							Column: 12,
							Line:   450,
						},
					},
				},
				Value: int64(2),
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 10,
						Line:   453,
					},
					File:   "date.flux",
					Source: "March = 3",
					Start: ast.Position{
						Column: 1,
						Line:   453,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// March is a constant that represents the month of March.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   453,
						},
						File:   "date.flux",
						Source: "March",
						Start: ast.Position{
							Column: 1,
							Line:   453,
						},
					},
				},
				Name: "March",
			},
			Init: &ast.IntegerLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 10,
							Line:   453,
						},
						File:   "date.flux",
						Source: "3",
						Start: ast.Position{
							Column: 9,
							Line:   453,
						},
					},
				},
				Value: int64(3),
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 10,
						Line:   456,
					},
					File:   "date.flux",
					Source: "April = 4",
					Start: ast.Position{
						Column: 1,
						Line:   456,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// April is a constant that represents the month of April.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 6,
							Line:   456,
						},
						File:   "date.flux",
						Source: "April",
						Start: ast.Position{
							Column: 1,
							Line:   456,
						},
					},
				},
				Name: "April",
			},
			Init: &ast.IntegerLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 10,
							Line:   456,
						},
						File:   "date.flux",
						Source: "4",
						Start: ast.Position{
							Column: 9,
							Line:   456,
						},
					},
				},
				Value: int64(4),
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 8,
						Line:   459,
					},
					File:   "date.flux",
					Source: "May = 5",
					Start: ast.Position{
						Column: 1,
						Line:   459,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// May is a constant that represents the month of May.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 4,
							Line:   459,
						},
						File:   "date.flux",
						Source: "May",
						Start: ast.Position{
							Column: 1,
							Line:   459,
						},
					},
				},
				Name: "May",
			},
			Init: &ast.IntegerLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   459,
						},
						File:   "date.flux",
						Source: "5",
						Start: ast.Position{
							Column: 7,
							Line:   459,
						},
					},
				},
				Value: int64(5),
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 9,
						Line:   462,
					},
					File:   "date.flux",
					Source: "June = 6",
					Start: ast.Position{
						Column: 1,
						Line:   462,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// June is a constant that represents the month of June.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 5,
							Line:   462,
						},
						File:   "date.flux",
						Source: "June",
						Start: ast.Position{
							Column: 1,
							Line:   462,
						},
					},
				},
				Name: "June",
			},
			Init: &ast.IntegerLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   462,
						},
						File:   "date.flux",
						Source: "6",
						Start: ast.Position{
							Column: 8,
							Line:   462,
						},
					},
				},
				Value: int64(6),
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 9,
						Line:   465,
					},
					File:   "date.flux",
					Source: "July = 7",
					Start: ast.Position{
						Column: 1,
						Line:   465,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// July is a constant that represents the month of July.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 5,
							Line:   465,
						},
						File:   "date.flux",
						Source: "July",
						Start: ast.Position{
							Column: 1,
							Line:   465,
						},
					},
				},
				Name: "July",
			},
			Init: &ast.IntegerLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   465,
						},
						File:   "date.flux",
						Source: "7",
						Start: ast.Position{
							Column: 8,
							Line:   465,
						},
					},
				},
				Value: int64(7),
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 11,
						Line:   468,
					},
					File:   "date.flux",
					Source: "August = 8",
					Start: ast.Position{
						Column: 1,
						Line:   468,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// August is a constant that represents the month of August.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   468,
						},
						File:   "date.flux",
						Source: "August",
						Start: ast.Position{
							Column: 1,
							Line:   468,
						},
					},
				},
				Name: "August",
			},
			Init: &ast.IntegerLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 11,
							Line:   468,
						},
						File:   "date.flux",
						Source: "8",
						Start: ast.Position{
							Column: 10,
							Line:   468,
						},
					},
				},
				Value: int64(8),
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   471,
					},
					File:   "date.flux",
					Source: "September = 9",
					Start: ast.Position{
						Column: 1,
						Line:   471,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// September is a constant that represents the month of September.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 10,
							Line:   471,
						},
						File:   "date.flux",
						Source: "September",
						Start: ast.Position{
							Column: 1,
							Line:   471,
						},
					},
				},
				Name: "September",
			},
			Init: &ast.IntegerLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   471,
						},
						File:   "date.flux",
						Source: "9",
						Start: ast.Position{
							Column: 13,
							Line:   471,
						},
					},
				},
				Value: int64(9),
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   474,
					},
					File:   "date.flux",
					Source: "October = 10",
					Start: ast.Position{
						Column: 1,
						Line:   474,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// October is a constant that represents the month of October.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 8,
							Line:   474,
						},
						File:   "date.flux",
						Source: "October",
						Start: ast.Position{
							Column: 1,
							Line:   474,
						},
					},
				},
				Name: "October",
			},
			Init: &ast.IntegerLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   474,
						},
						File:   "date.flux",
						Source: "10",
						Start: ast.Position{
							Column: 11,
							Line:   474,
						},
					},
				},
				Value: int64(10),
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   477,
					},
					File:   "date.flux",
					Source: "November = 11",
					Start: ast.Position{
						Column: 1,
						Line:   477,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// November is a constant that represents the month of November.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   477,
						},
						File:   "date.flux",
						Source: "November",
						Start: ast.Position{
							Column: 1,
							Line:   477,
						},
					},
				},
				Name: "November",
			},
			Init: &ast.IntegerLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   477,
						},
						File:   "date.flux",
						Source: "11",
						Start: ast.Position{
							Column: 12,
							Line:   477,
						},
					},
				},
				Value: int64(11),
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   480,
					},
					File:   "date.flux",
					Source: "December = 12",
					Start: ast.Position{
						Column: 1,
						Line:   480,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// December is a constant that represents the month of December.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 9,
							Line:   480,
						},
						File:   "date.flux",
						Source: "December",
						Start: ast.Position{
							Column: 1,
							Line:   480,
						},
					},
				},
				Name: "December",
			},
			Init: &ast.IntegerLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   480,
						},
						File:   "date.flux",
						Source: "12",
						Start: ast.Position{
							Column: 12,
							Line:   480,
						},
					},
				},
				Value: int64(12),
			},
		}},
		Eof:      nil,
		Imports:  nil,
		Metadata: "parser-type=rust",
		Name:     "date.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// Package date provides date and time constants and functions.\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   2,
					},
					File:   "date.flux",
					Source: "package date",
					Start: ast.Position{
						Column: 1,
						Line:   2,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   2,
						},
						File:   "date.flux",
						Source: "date",
						Start: ast.Position{
							Column: 9,
							Line:   2,
						},
					},
				},
				Name: "date",
			},
		},
	}},
	Package: "date",
	Path:    "date",
}
