// DO NOT EDIT: This file is autogenerated via the builtin command.

package regexp

import (
	ast "github.com/influxdata/flux/ast"
	runtime "github.com/influxdata/flux/runtime"
)

func init() {
	runtime.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 18,
					Line:   255,
				},
				File:   "regexp.flux",
				Source: "package regexp\n\n\n// compile is a function that parses a regular expression and,\n//  if successful, returns a Regexp object that can be used to\n//  match against text.\n//\n// ## Parameters\n// - `v` is the string value to parse into regular expression.\n//\n// ## Example\n//\n// ```\n// import \"regexp\"\n//\n// regexp.compile(v: \"abcd\")\n// // Returns the regexp object `abcd`\n// ```\n//\n// ## Use a string value as a regular expression\n//\n// ```\n// import \"regexp\"\n//\n// data\n//   |> map(fn: (r) => ({\n//       r with\n//       regexStr: r.regexStr,\n//       _value: r._value,\n//       firstRegexMatch: findString(\n//         r: regexp.compile(v: regexStr),\n//         v: r._value\n//       )\n//     })\n//   )\n// ```\nbuiltin compile : (v: string) => regexp\n\n// quoteMeta is a function that escapes all regular expression\n//  metacharacters inside of a string.\n//\n// ## Parameters\n// - `v` is the string that contains regular expression metacharacters\n//   to escape\n//\n// ## Example\n//\n// ```\n// import \"regexp\"\n//\n// regexp.quoteMeta(v: \".+*?()|[]{}^$\")\n// // Returns \"\\.\\+\\*\\?\\(\\)\\|\\[\\]\\{\\}\\^\\$\"\n// ```\n//\n// ## Escape regular expression meta characters in column values\n//\n// ```\n// import \"regexp\"\n//\n// data\n//   |> map(fn: (r) => ({\n//       r with\n//       notes: r.notes,\n//       notes_escaped: regexp.quoteMeta(v: r.notes)\n//     })\n//   )\n// ```\nbuiltin quoteMeta : (v: string) => string\n\n// findString is a function that returns the left-most regular expression\n//  match in a string.\n//\n// ## Parameters\n// - `r` is the regular expression used to search v.\n// - `v` is the string value to search.\n//\n// ## Example\n//\n// ```\n// import \"regexp\"\n//\n// regexp.findString(r: /foo.?/, v: \"seafood fool\")\n// // Returns \"food\"\n// ```\n//\n// ## Find the first regular expression match in each row\n//\n// ```\n// import \"regexp\"\n//\n// data\n//   |> map(fn: (r) => ({\n//       r with\n//       message: r.message,\n//       regexp: r.regexp,\n//       match: regexp.findString(r: r.regexp, v: r.message)\n//     })\n//   )\n// ```\nbuiltin findString : (r: regexp, v: string) => string\n\n// findStringIdex is a function that returns a two-element array of integers\n//  defining the beginning and ending indexes of the left-most regular\n//  expression match in a string.\n//\n// ## Parameters\n// - 'r' is the regular expression used to search v.\n// - `v` is the string value to search.\n//\n// ## Example\n//\n// ```\n// import \"regexp\"\n//\n// regexp.findStringIndex(r: /ab?/, v: \"tablet\")\n// // Returns [1, 3]\n// ```\n//\n// ## Index the bounds of first regular expression match in each row\n//\n// ```\n// import \"regexp\"\n//\n// data\n//   |> map(fn: (r) => ({\n//       r with\n//       regexStr: r.regexStr,\n//       _value: r._value,\n//       matchIndex: regexp.findStringIndex(\n//         r: regexp.compile(r.regexStr),\n//         v: r._value\n//       )\n//     })\n//   )\n// ```\nbuiltin findStringIndex : (r: regexp, v: string) => [int]\n\n// matchRegexpString is a function that tests if a string contains any\n//  match to a regular expression.\n//\n// ## Parameters\n// - `r` is the regular expression used to search v.\n// - `v` is the string value to search.\n//\n// ## Example\n//\n// ```\n// import \"regexp\"\n//\n// regexp.matchRegexpString(r: /(gopher){2}/, v: \"gophergophergopher\")\n// // Returns true\n// ```\n//\n// ## Filter by columns that contain matches to a regular expression\n//\n// ```\n// import \"regexp\"\n//\n// data\n//   |> filter(fn: (r) =>\n//     regexp.matchRegexpString(\n//       r: /Alert\\:/,\n//       v: r.message\n//     )\n//   )\n// ```\nbuiltin matchRegexpString : (r: regexp, v: string) => bool\n\n// replaceAllString is a function that replaces all reguar expression matches\n//  in a string with a specified replacement.\n//\n// ## Parameters\n// - `r` is the regular expression used to search v.\n// - `v` is the string value to search.\n// - `t` is the replacement for matches to r.\n//\n// ## Example\n//\n// ```\n// import \"regexp\"\n//\n// regexp.replaceAllString(r: /a(x*)b/, v: \"-ab-axxb-\", t: \"T\")\n// // Returns \"-T-T-\"\n// ```\n//\n// ## Replace regular expression matches in string column values\n//\n// ```\n// import \"regexp\"\n//\n// data\n//   |> map(fn: (r) => ({\n//       r with\n//       message: r.message,\n//       updated_message: regexp.replaceAllString(\n//         r: /cat|bird|ferret/,\n//         v: r.message,\n//         t: \"dog\"\n//       )\n//   }))\n// ```\nbuiltin replaceAllString : (r: regexp, v: string, t: string) => string\n\n// splitRegexp is a function that splits a string into substrings separated\n//  by regular expression matches and return an array of i substrings\n//  between matches.\n//\n// ## Parameters\n// - `r` is the regular expression used to search v.\n// - `v` is the string value to be searched.\n// - `i` is the maximum number of substrings to return.\n//\n//   -1 returns all matching substrings.\n//\n// ## Example\n//\n// ```\n// import \"regexp\"\n//\n// regexp.splitRegexp(r: /a*/, v: \"abaabaccadaaae\", i: 5)\n// // Returns [\"\", \"b\", \"b\", \"c\", \"cadaaae\"]\n// ```\nbuiltin splitRegexp : (r: regexp, v: string, i: int) => [string]\n\n// getString is a function that returns the source string used to compile\n//  a regular expression.\n//\n// ## Parameters\n// - `r` is the regular expression object to convert to a string.\n//\n// ## Example\n//\n// ```\n// import \"regexp\"\n//\n// regexp.getString(r: /[a-zA-Z]/)\n// // Returns \"[a-zA-Z]\"\n// ```\n//\n// ## Convert regular expressions into strings in each row\n//\n// ```\n// import \"regexp\"\n//\n// data\n//   |> map(fn: (r) => ({\n//       r with\n//       regex: r.regex,\n//       regexStr: regexp.getString(r: r.regex)\n//     })\n//   )\n// ```\nbuiltin getString",
				Start: ast.Position{
					Column: 1,
					Line:   3,
				},
			},
		},
		Body: []ast.Statement{&ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// compile is a function that parses a regular expression and,\n"}, ast.Comment{Text: "//  if successful, returns a Regexp object that can be used to\n"}, ast.Comment{Text: "//  match against text.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `v` is the string value to parse into regular expression.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"regexp\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// regexp.compile(v: \"abcd\")\n"}, ast.Comment{Text: "// // Returns the regexp object `abcd`\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Use a string value as a regular expression\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"regexp\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// data\n"}, ast.Comment{Text: "//   |> map(fn: (r) => ({\n"}, ast.Comment{Text: "//       r with\n"}, ast.Comment{Text: "//       regexStr: r.regexStr,\n"}, ast.Comment{Text: "//       _value: r._value,\n"}, ast.Comment{Text: "//       firstRegexMatch: findString(\n"}, ast.Comment{Text: "//         r: regexp.compile(v: regexStr),\n"}, ast.Comment{Text: "//         v: r._value\n"}, ast.Comment{Text: "//       )\n"}, ast.Comment{Text: "//     })\n"}, ast.Comment{Text: "//   )\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 16,
						Line:   39,
					},
					File:   "regexp.flux",
					Source: "builtin compile",
					Start: ast.Position{
						Column: 1,
						Line:   39,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 16,
							Line:   39,
						},
						File:   "regexp.flux",
						Source: "compile",
						Start: ast.Position{
							Column: 9,
							Line:   39,
						},
					},
				},
				Name: "compile",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 40,
							Line:   39,
						},
						File:   "regexp.flux",
						Source: "(v: string) => regexp",
						Start: ast.Position{
							Column: 19,
							Line:   39,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 40,
								Line:   39,
							},
							File:   "regexp.flux",
							Source: "(v: string) => regexp",
							Start: ast.Position{
								Column: 19,
								Line:   39,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 29,
									Line:   39,
								},
								File:   "regexp.flux",
								Source: "v: string",
								Start: ast.Position{
									Column: 20,
									Line:   39,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 21,
										Line:   39,
									},
									File:   "regexp.flux",
									Source: "v",
									Start: ast.Position{
										Column: 20,
										Line:   39,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   39,
									},
									File:   "regexp.flux",
									Source: "string",
									Start: ast.Position{
										Column: 23,
										Line:   39,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 29,
											Line:   39,
										},
										File:   "regexp.flux",
										Source: "string",
										Start: ast.Position{
											Column: 23,
											Line:   39,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 40,
									Line:   39,
								},
								File:   "regexp.flux",
								Source: "regexp",
								Start: ast.Position{
									Column: 34,
									Line:   39,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   39,
									},
									File:   "regexp.flux",
									Source: "regexp",
									Start: ast.Position{
										Column: 34,
										Line:   39,
									},
								},
							},
							Name: "regexp",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// quoteMeta is a function that escapes all regular expression\n"}, ast.Comment{Text: "//  metacharacters inside of a string.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `v` is the string that contains regular expression metacharacters\n"}, ast.Comment{Text: "//   to escape\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"regexp\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// regexp.quoteMeta(v: \".+*?()|[]{}^$\")\n"}, ast.Comment{Text: "// // Returns \"\\.\\+\\*\\?\\(\\)\\|\\[\\]\\{\\}\\^\\$\"\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Escape regular expression meta characters in column values\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"regexp\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// data\n"}, ast.Comment{Text: "//   |> map(fn: (r) => ({\n"}, ast.Comment{Text: "//       r with\n"}, ast.Comment{Text: "//       notes: r.notes,\n"}, ast.Comment{Text: "//       notes_escaped: regexp.quoteMeta(v: r.notes)\n"}, ast.Comment{Text: "//     })\n"}, ast.Comment{Text: "//   )\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   70,
					},
					File:   "regexp.flux",
					Source: "builtin quoteMeta",
					Start: ast.Position{
						Column: 1,
						Line:   70,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   70,
						},
						File:   "regexp.flux",
						Source: "quoteMeta",
						Start: ast.Position{
							Column: 9,
							Line:   70,
						},
					},
				},
				Name: "quoteMeta",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   70,
						},
						File:   "regexp.flux",
						Source: "(v: string) => string",
						Start: ast.Position{
							Column: 21,
							Line:   70,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   70,
							},
							File:   "regexp.flux",
							Source: "(v: string) => string",
							Start: ast.Position{
								Column: 21,
								Line:   70,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   70,
								},
								File:   "regexp.flux",
								Source: "v: string",
								Start: ast.Position{
									Column: 22,
									Line:   70,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   70,
									},
									File:   "regexp.flux",
									Source: "v",
									Start: ast.Position{
										Column: 22,
										Line:   70,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   70,
									},
									File:   "regexp.flux",
									Source: "string",
									Start: ast.Position{
										Column: 25,
										Line:   70,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   70,
										},
										File:   "regexp.flux",
										Source: "string",
										Start: ast.Position{
											Column: 25,
											Line:   70,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   70,
								},
								File:   "regexp.flux",
								Source: "string",
								Start: ast.Position{
									Column: 36,
									Line:   70,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   70,
									},
									File:   "regexp.flux",
									Source: "string",
									Start: ast.Position{
										Column: 36,
										Line:   70,
									},
								},
							},
							Name: "string",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// findString is a function that returns the left-most regular expression\n"}, ast.Comment{Text: "//  match in a string.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `r` is the regular expression used to search v.\n"}, ast.Comment{Text: "// - `v` is the string value to search.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"regexp\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// regexp.findString(r: /foo.?/, v: \"seafood fool\")\n"}, ast.Comment{Text: "// // Returns \"food\"\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Find the first regular expression match in each row\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"regexp\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// data\n"}, ast.Comment{Text: "//   |> map(fn: (r) => ({\n"}, ast.Comment{Text: "//       r with\n"}, ast.Comment{Text: "//       message: r.message,\n"}, ast.Comment{Text: "//       regexp: r.regexp,\n"}, ast.Comment{Text: "//       match: regexp.findString(r: r.regexp, v: r.message)\n"}, ast.Comment{Text: "//     })\n"}, ast.Comment{Text: "//   )\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 19,
						Line:   102,
					},
					File:   "regexp.flux",
					Source: "builtin findString",
					Start: ast.Position{
						Column: 1,
						Line:   102,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 19,
							Line:   102,
						},
						File:   "regexp.flux",
						Source: "findString",
						Start: ast.Position{
							Column: 9,
							Line:   102,
						},
					},
				},
				Name: "findString",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 54,
							Line:   102,
						},
						File:   "regexp.flux",
						Source: "(r: regexp, v: string) => string",
						Start: ast.Position{
							Column: 22,
							Line:   102,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 54,
								Line:   102,
							},
							File:   "regexp.flux",
							Source: "(r: regexp, v: string) => string",
							Start: ast.Position{
								Column: 22,
								Line:   102,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 32,
									Line:   102,
								},
								File:   "regexp.flux",
								Source: "r: regexp",
								Start: ast.Position{
									Column: 23,
									Line:   102,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 24,
										Line:   102,
									},
									File:   "regexp.flux",
									Source: "r",
									Start: ast.Position{
										Column: 23,
										Line:   102,
									},
								},
							},
							Name: "r",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 32,
										Line:   102,
									},
									File:   "regexp.flux",
									Source: "regexp",
									Start: ast.Position{
										Column: 26,
										Line:   102,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 32,
											Line:   102,
										},
										File:   "regexp.flux",
										Source: "regexp",
										Start: ast.Position{
											Column: 26,
											Line:   102,
										},
									},
								},
								Name: "regexp",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 43,
									Line:   102,
								},
								File:   "regexp.flux",
								Source: "v: string",
								Start: ast.Position{
									Column: 34,
									Line:   102,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 35,
										Line:   102,
									},
									File:   "regexp.flux",
									Source: "v",
									Start: ast.Position{
										Column: 34,
										Line:   102,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 43,
										Line:   102,
									},
									File:   "regexp.flux",
									Source: "string",
									Start: ast.Position{
										Column: 37,
										Line:   102,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 43,
											Line:   102,
										},
										File:   "regexp.flux",
										Source: "string",
										Start: ast.Position{
											Column: 37,
											Line:   102,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 54,
									Line:   102,
								},
								File:   "regexp.flux",
								Source: "string",
								Start: ast.Position{
									Column: 48,
									Line:   102,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 54,
										Line:   102,
									},
									File:   "regexp.flux",
									Source: "string",
									Start: ast.Position{
										Column: 48,
										Line:   102,
									},
								},
							},
							Name: "string",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// findStringIdex is a function that returns a two-element array of integers\n"}, ast.Comment{Text: "//  defining the beginning and ending indexes of the left-most regular\n"}, ast.Comment{Text: "//  expression match in a string.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - 'r' is the regular expression used to search v.\n"}, ast.Comment{Text: "// - `v` is the string value to search.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"regexp\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// regexp.findStringIndex(r: /ab?/, v: \"tablet\")\n"}, ast.Comment{Text: "// // Returns [1, 3]\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Index the bounds of first regular expression match in each row\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"regexp\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// data\n"}, ast.Comment{Text: "//   |> map(fn: (r) => ({\n"}, ast.Comment{Text: "//       r with\n"}, ast.Comment{Text: "//       regexStr: r.regexStr,\n"}, ast.Comment{Text: "//       _value: r._value,\n"}, ast.Comment{Text: "//       matchIndex: regexp.findStringIndex(\n"}, ast.Comment{Text: "//         r: regexp.compile(r.regexStr),\n"}, ast.Comment{Text: "//         v: r._value\n"}, ast.Comment{Text: "//       )\n"}, ast.Comment{Text: "//     })\n"}, ast.Comment{Text: "//   )\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 24,
						Line:   138,
					},
					File:   "regexp.flux",
					Source: "builtin findStringIndex",
					Start: ast.Position{
						Column: 1,
						Line:   138,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 24,
							Line:   138,
						},
						File:   "regexp.flux",
						Source: "findStringIndex",
						Start: ast.Position{
							Column: 9,
							Line:   138,
						},
					},
				},
				Name: "findStringIndex",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 58,
							Line:   138,
						},
						File:   "regexp.flux",
						Source: "(r: regexp, v: string) => [int]",
						Start: ast.Position{
							Column: 27,
							Line:   138,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 58,
								Line:   138,
							},
							File:   "regexp.flux",
							Source: "(r: regexp, v: string) => [int]",
							Start: ast.Position{
								Column: 27,
								Line:   138,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 37,
									Line:   138,
								},
								File:   "regexp.flux",
								Source: "r: regexp",
								Start: ast.Position{
									Column: 28,
									Line:   138,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 29,
										Line:   138,
									},
									File:   "regexp.flux",
									Source: "r",
									Start: ast.Position{
										Column: 28,
										Line:   138,
									},
								},
							},
							Name: "r",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 37,
										Line:   138,
									},
									File:   "regexp.flux",
									Source: "regexp",
									Start: ast.Position{
										Column: 31,
										Line:   138,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 37,
											Line:   138,
										},
										File:   "regexp.flux",
										Source: "regexp",
										Start: ast.Position{
											Column: 31,
											Line:   138,
										},
									},
								},
								Name: "regexp",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 48,
									Line:   138,
								},
								File:   "regexp.flux",
								Source: "v: string",
								Start: ast.Position{
									Column: 39,
									Line:   138,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 40,
										Line:   138,
									},
									File:   "regexp.flux",
									Source: "v",
									Start: ast.Position{
										Column: 39,
										Line:   138,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   138,
									},
									File:   "regexp.flux",
									Source: "string",
									Start: ast.Position{
										Column: 42,
										Line:   138,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 48,
											Line:   138,
										},
										File:   "regexp.flux",
										Source: "string",
										Start: ast.Position{
											Column: 42,
											Line:   138,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 58,
									Line:   138,
								},
								File:   "regexp.flux",
								Source: "[int]",
								Start: ast.Position{
									Column: 53,
									Line:   138,
								},
							},
						},
						ElementType: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 57,
										Line:   138,
									},
									File:   "regexp.flux",
									Source: "int",
									Start: ast.Position{
										Column: 54,
										Line:   138,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 57,
											Line:   138,
										},
										File:   "regexp.flux",
										Source: "int",
										Start: ast.Position{
											Column: 54,
											Line:   138,
										},
									},
								},
								Name: "int",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// matchRegexpString is a function that tests if a string contains any\n"}, ast.Comment{Text: "//  match to a regular expression.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `r` is the regular expression used to search v.\n"}, ast.Comment{Text: "// - `v` is the string value to search.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"regexp\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// regexp.matchRegexpString(r: /(gopher){2}/, v: \"gophergophergopher\")\n"}, ast.Comment{Text: "// // Returns true\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Filter by columns that contain matches to a regular expression\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"regexp\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// data\n"}, ast.Comment{Text: "//   |> filter(fn: (r) =>\n"}, ast.Comment{Text: "//     regexp.matchRegexpString(\n"}, ast.Comment{Text: "//       r: /Alert\\:/,\n"}, ast.Comment{Text: "//       v: r.message\n"}, ast.Comment{Text: "//     )\n"}, ast.Comment{Text: "//   )\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 26,
						Line:   169,
					},
					File:   "regexp.flux",
					Source: "builtin matchRegexpString",
					Start: ast.Position{
						Column: 1,
						Line:   169,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 26,
							Line:   169,
						},
						File:   "regexp.flux",
						Source: "matchRegexpString",
						Start: ast.Position{
							Column: 9,
							Line:   169,
						},
					},
				},
				Name: "matchRegexpString",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 59,
							Line:   169,
						},
						File:   "regexp.flux",
						Source: "(r: regexp, v: string) => bool",
						Start: ast.Position{
							Column: 29,
							Line:   169,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 59,
								Line:   169,
							},
							File:   "regexp.flux",
							Source: "(r: regexp, v: string) => bool",
							Start: ast.Position{
								Column: 29,
								Line:   169,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 39,
									Line:   169,
								},
								File:   "regexp.flux",
								Source: "r: regexp",
								Start: ast.Position{
									Column: 30,
									Line:   169,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   169,
									},
									File:   "regexp.flux",
									Source: "r",
									Start: ast.Position{
										Column: 30,
										Line:   169,
									},
								},
							},
							Name: "r",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 39,
										Line:   169,
									},
									File:   "regexp.flux",
									Source: "regexp",
									Start: ast.Position{
										Column: 33,
										Line:   169,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 39,
											Line:   169,
										},
										File:   "regexp.flux",
										Source: "regexp",
										Start: ast.Position{
											Column: 33,
											Line:   169,
										},
									},
								},
								Name: "regexp",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 50,
									Line:   169,
								},
								File:   "regexp.flux",
								Source: "v: string",
								Start: ast.Position{
									Column: 41,
									Line:   169,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   169,
									},
									File:   "regexp.flux",
									Source: "v",
									Start: ast.Position{
										Column: 41,
										Line:   169,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 50,
										Line:   169,
									},
									File:   "regexp.flux",
									Source: "string",
									Start: ast.Position{
										Column: 44,
										Line:   169,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 50,
											Line:   169,
										},
										File:   "regexp.flux",
										Source: "string",
										Start: ast.Position{
											Column: 44,
											Line:   169,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 59,
									Line:   169,
								},
								File:   "regexp.flux",
								Source: "bool",
								Start: ast.Position{
									Column: 55,
									Line:   169,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 59,
										Line:   169,
									},
									File:   "regexp.flux",
									Source: "bool",
									Start: ast.Position{
										Column: 55,
										Line:   169,
									},
								},
							},
							Name: "bool",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// replaceAllString is a function that replaces all reguar expression matches\n"}, ast.Comment{Text: "//  in a string with a specified replacement.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `r` is the regular expression used to search v.\n"}, ast.Comment{Text: "// - `v` is the string value to search.\n"}, ast.Comment{Text: "// - `t` is the replacement for matches to r.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"regexp\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// regexp.replaceAllString(r: /a(x*)b/, v: \"-ab-axxb-\", t: \"T\")\n"}, ast.Comment{Text: "// // Returns \"-T-T-\"\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Replace regular expression matches in string column values\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"regexp\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// data\n"}, ast.Comment{Text: "//   |> map(fn: (r) => ({\n"}, ast.Comment{Text: "//       r with\n"}, ast.Comment{Text: "//       message: r.message,\n"}, ast.Comment{Text: "//       updated_message: regexp.replaceAllString(\n"}, ast.Comment{Text: "//         r: /cat|bird|ferret/,\n"}, ast.Comment{Text: "//         v: r.message,\n"}, ast.Comment{Text: "//         t: \"dog\"\n"}, ast.Comment{Text: "//       )\n"}, ast.Comment{Text: "//   }))\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 25,
						Line:   204,
					},
					File:   "regexp.flux",
					Source: "builtin replaceAllString",
					Start: ast.Position{
						Column: 1,
						Line:   204,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 25,
							Line:   204,
						},
						File:   "regexp.flux",
						Source: "replaceAllString",
						Start: ast.Position{
							Column: 9,
							Line:   204,
						},
					},
				},
				Name: "replaceAllString",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 71,
							Line:   204,
						},
						File:   "regexp.flux",
						Source: "(r: regexp, v: string, t: string) => string",
						Start: ast.Position{
							Column: 28,
							Line:   204,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 71,
								Line:   204,
							},
							File:   "regexp.flux",
							Source: "(r: regexp, v: string, t: string) => string",
							Start: ast.Position{
								Column: 28,
								Line:   204,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 38,
									Line:   204,
								},
								File:   "regexp.flux",
								Source: "r: regexp",
								Start: ast.Position{
									Column: 29,
									Line:   204,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 30,
										Line:   204,
									},
									File:   "regexp.flux",
									Source: "r",
									Start: ast.Position{
										Column: 29,
										Line:   204,
									},
								},
							},
							Name: "r",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 38,
										Line:   204,
									},
									File:   "regexp.flux",
									Source: "regexp",
									Start: ast.Position{
										Column: 32,
										Line:   204,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 38,
											Line:   204,
										},
										File:   "regexp.flux",
										Source: "regexp",
										Start: ast.Position{
											Column: 32,
											Line:   204,
										},
									},
								},
								Name: "regexp",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 49,
									Line:   204,
								},
								File:   "regexp.flux",
								Source: "v: string",
								Start: ast.Position{
									Column: 40,
									Line:   204,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 41,
										Line:   204,
									},
									File:   "regexp.flux",
									Source: "v",
									Start: ast.Position{
										Column: 40,
										Line:   204,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 49,
										Line:   204,
									},
									File:   "regexp.flux",
									Source: "string",
									Start: ast.Position{
										Column: 43,
										Line:   204,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 49,
											Line:   204,
										},
										File:   "regexp.flux",
										Source: "string",
										Start: ast.Position{
											Column: 43,
											Line:   204,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 60,
									Line:   204,
								},
								File:   "regexp.flux",
								Source: "t: string",
								Start: ast.Position{
									Column: 51,
									Line:   204,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 52,
										Line:   204,
									},
									File:   "regexp.flux",
									Source: "t",
									Start: ast.Position{
										Column: 51,
										Line:   204,
									},
								},
							},
							Name: "t",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 60,
										Line:   204,
									},
									File:   "regexp.flux",
									Source: "string",
									Start: ast.Position{
										Column: 54,
										Line:   204,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 60,
											Line:   204,
										},
										File:   "regexp.flux",
										Source: "string",
										Start: ast.Position{
											Column: 54,
											Line:   204,
										},
									},
								},
								Name: "string",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 71,
									Line:   204,
								},
								File:   "regexp.flux",
								Source: "string",
								Start: ast.Position{
									Column: 65,
									Line:   204,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 71,
										Line:   204,
									},
									File:   "regexp.flux",
									Source: "string",
									Start: ast.Position{
										Column: 65,
										Line:   204,
									},
								},
							},
							Name: "string",
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// splitRegexp is a function that splits a string into substrings separated\n"}, ast.Comment{Text: "//  by regular expression matches and return an array of i substrings\n"}, ast.Comment{Text: "//  between matches.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `r` is the regular expression used to search v.\n"}, ast.Comment{Text: "// - `v` is the string value to be searched.\n"}, ast.Comment{Text: "// - `i` is the maximum number of substrings to return.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "//   -1 returns all matching substrings.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"regexp\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// regexp.splitRegexp(r: /a*/, v: \"abaabaccadaaae\", i: 5)\n"}, ast.Comment{Text: "// // Returns [\"\", \"b\", \"b\", \"c\", \"cadaaae\"]\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 20,
						Line:   225,
					},
					File:   "regexp.flux",
					Source: "builtin splitRegexp",
					Start: ast.Position{
						Column: 1,
						Line:   225,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 20,
							Line:   225,
						},
						File:   "regexp.flux",
						Source: "splitRegexp",
						Start: ast.Position{
							Column: 9,
							Line:   225,
						},
					},
				},
				Name: "splitRegexp",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 65,
							Line:   225,
						},
						File:   "regexp.flux",
						Source: "(r: regexp, v: string, i: int) => [string]",
						Start: ast.Position{
							Column: 23,
							Line:   225,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 65,
								Line:   225,
							},
							File:   "regexp.flux",
							Source: "(r: regexp, v: string, i: int) => [string]",
							Start: ast.Position{
								Column: 23,
								Line:   225,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 33,
									Line:   225,
								},
								File:   "regexp.flux",
								Source: "r: regexp",
								Start: ast.Position{
									Column: 24,
									Line:   225,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 25,
										Line:   225,
									},
									File:   "regexp.flux",
									Source: "r",
									Start: ast.Position{
										Column: 24,
										Line:   225,
									},
								},
							},
							Name: "r",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 33,
										Line:   225,
									},
									File:   "regexp.flux",
									Source: "regexp",
									Start: ast.Position{
										Column: 27,
										Line:   225,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 33,
											Line:   225,
										},
										File:   "regexp.flux",
										Source: "regexp",
										Start: ast.Position{
											Column: 27,
											Line:   225,
										},
									},
								},
								Name: "regexp",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 44,
									Line:   225,
								},
								File:   "regexp.flux",
								Source: "v: string",
								Start: ast.Position{
									Column: 35,
									Line:   225,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 36,
										Line:   225,
									},
									File:   "regexp.flux",
									Source: "v",
									Start: ast.Position{
										Column: 35,
										Line:   225,
									},
								},
							},
							Name: "v",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 44,
										Line:   225,
									},
									File:   "regexp.flux",
									Source: "string",
									Start: ast.Position{
										Column: 38,
										Line:   225,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 44,
											Line:   225,
										},
										File:   "regexp.flux",
										Source: "string",
										Start: ast.Position{
											Column: 38,
											Line:   225,
										},
									},
								},
								Name: "string",
							},
						},
					}, &ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 52,
									Line:   225,
								},
								File:   "regexp.flux",
								Source: "i: int",
								Start: ast.Position{
									Column: 46,
									Line:   225,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 47,
										Line:   225,
									},
									File:   "regexp.flux",
									Source: "i",
									Start: ast.Position{
										Column: 46,
										Line:   225,
									},
								},
							},
							Name: "i",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 52,
										Line:   225,
									},
									File:   "regexp.flux",
									Source: "int",
									Start: ast.Position{
										Column: 49,
										Line:   225,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 52,
											Line:   225,
										},
										File:   "regexp.flux",
										Source: "int",
										Start: ast.Position{
											Column: 49,
											Line:   225,
										},
									},
								},
								Name: "int",
							},
						},
					}},
					Return: &ast.ArrayType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 65,
									Line:   225,
								},
								File:   "regexp.flux",
								Source: "[string]",
								Start: ast.Position{
									Column: 57,
									Line:   225,
								},
							},
						},
						ElementType: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 64,
										Line:   225,
									},
									File:   "regexp.flux",
									Source: "string",
									Start: ast.Position{
										Column: 58,
										Line:   225,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 64,
											Line:   225,
										},
										File:   "regexp.flux",
										Source: "string",
										Start: ast.Position{
											Column: 58,
											Line:   225,
										},
									},
								},
								Name: "string",
							},
						},
					},
				},
			},
		}, &ast.BuiltinStatement{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// getString is a function that returns the source string used to compile\n"}, ast.Comment{Text: "//  a regular expression.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Parameters\n"}, ast.Comment{Text: "// - `r` is the regular expression object to convert to a string.\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Example\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"regexp\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// regexp.getString(r: /[a-zA-Z]/)\n"}, ast.Comment{Text: "// // Returns \"[a-zA-Z]\"\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ## Convert regular expressions into strings in each row\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// ```\n"}, ast.Comment{Text: "// import \"regexp\"\n"}, ast.Comment{Text: "//\n"}, ast.Comment{Text: "// data\n"}, ast.Comment{Text: "//   |> map(fn: (r) => ({\n"}, ast.Comment{Text: "//       r with\n"}, ast.Comment{Text: "//       regex: r.regex,\n"}, ast.Comment{Text: "//       regexStr: regexp.getString(r: r.regex)\n"}, ast.Comment{Text: "//     })\n"}, ast.Comment{Text: "//   )\n"}, ast.Comment{Text: "// ```\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 18,
						Line:   255,
					},
					File:   "regexp.flux",
					Source: "builtin getString",
					Start: ast.Position{
						Column: 1,
						Line:   255,
					},
				},
			},
			Colon: nil,
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 18,
							Line:   255,
						},
						File:   "regexp.flux",
						Source: "getString",
						Start: ast.Position{
							Column: 9,
							Line:   255,
						},
					},
				},
				Name: "getString",
			},
			Ty: ast.TypeExpression{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 42,
							Line:   255,
						},
						File:   "regexp.flux",
						Source: "(r: regexp) => string",
						Start: ast.Position{
							Column: 21,
							Line:   255,
						},
					},
				},
				Constraints: []*ast.TypeConstraint{},
				Ty: &ast.FunctionType{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 42,
								Line:   255,
							},
							File:   "regexp.flux",
							Source: "(r: regexp) => string",
							Start: ast.Position{
								Column: 21,
								Line:   255,
							},
						},
					},
					Parameters: []*ast.ParameterType{&ast.ParameterType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 31,
									Line:   255,
								},
								File:   "regexp.flux",
								Source: "r: regexp",
								Start: ast.Position{
									Column: 22,
									Line:   255,
								},
							},
						},
						Kind: "Required",
						Name: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 23,
										Line:   255,
									},
									File:   "regexp.flux",
									Source: "r",
									Start: ast.Position{
										Column: 22,
										Line:   255,
									},
								},
							},
							Name: "r",
						},
						Ty: &ast.NamedType{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 31,
										Line:   255,
									},
									File:   "regexp.flux",
									Source: "regexp",
									Start: ast.Position{
										Column: 25,
										Line:   255,
									},
								},
							},
							ID: &ast.Identifier{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 31,
											Line:   255,
										},
										File:   "regexp.flux",
										Source: "regexp",
										Start: ast.Position{
											Column: 25,
											Line:   255,
										},
									},
								},
								Name: "regexp",
							},
						},
					}},
					Return: &ast.NamedType{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 42,
									Line:   255,
								},
								File:   "regexp.flux",
								Source: "string",
								Start: ast.Position{
									Column: 36,
									Line:   255,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 42,
										Line:   255,
									},
									File:   "regexp.flux",
									Source: "string",
									Start: ast.Position{
										Column: 36,
										Line:   255,
									},
								},
							},
							Name: "string",
						},
					},
				},
			},
		}},
		Eof:      nil,
		Imports:  nil,
		Metadata: "parser-type=rust",
		Name:     "regexp.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: []ast.Comment{ast.Comment{Text: "// Flux regular expressions package includes functions that provide enhanced\n"}, ast.Comment{Text: "// regular expression functionality.\n"}},
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 15,
						Line:   3,
					},
					File:   "regexp.flux",
					Source: "package regexp",
					Start: ast.Position{
						Column: 1,
						Line:   3,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 15,
							Line:   3,
						},
						File:   "regexp.flux",
						Source: "regexp",
						Start: ast.Position{
							Column: 9,
							Line:   3,
						},
					},
				},
				Name: "regexp",
			},
		},
	}},
	Package: "regexp",
	Path:    "regexp",
}
