package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeOrganization invokes the baas.DescribeOrganization API synchronously
// api document: https://help.aliyun.com/api/baas/describeorganization.html
func (client *Client) DescribeOrganization(request *DescribeOrganizationRequest) (response *DescribeOrganizationResponse, err error) {
	response = CreateDescribeOrganizationResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeOrganizationWithChan invokes the baas.DescribeOrganization API asynchronously
// api document: https://help.aliyun.com/api/baas/describeorganization.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeOrganizationWithChan(request *DescribeOrganizationRequest) (<-chan *DescribeOrganizationResponse, <-chan error) {
	responseChan := make(chan *DescribeOrganizationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeOrganization(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeOrganizationWithCallback invokes the baas.DescribeOrganization API asynchronously
// api document: https://help.aliyun.com/api/baas/describeorganization.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeOrganizationWithCallback(request *DescribeOrganizationRequest, callback func(response *DescribeOrganizationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeOrganizationResponse
		var err error
		defer close(result)
		response, err = client.DescribeOrganization(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeOrganizationRequest is the request struct for api DescribeOrganization
type DescribeOrganizationRequest struct {
	*requests.RpcRequest
	OrganizationId string `position:"Query" name:"OrganizationId"`
	Location       string `position:"Body" name:"Location"`
}

// DescribeOrganizationResponse is the response struct for api DescribeOrganization
type DescribeOrganizationResponse struct {
	*responses.BaseResponse
	RequestId string                       `json:"RequestId" xml:"RequestId"`
	Success   bool                         `json:"Success" xml:"Success"`
	ErrorCode int                          `json:"ErrorCode" xml:"ErrorCode"`
	Result    ResultInDescribeOrganization `json:"Result" xml:"Result"`
}

// CreateDescribeOrganizationRequest creates a request to invoke DescribeOrganization API
func CreateDescribeOrganizationRequest() (request *DescribeOrganizationRequest) {
	request = &DescribeOrganizationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "DescribeOrganization", "", "")
	return
}

// CreateDescribeOrganizationResponse creates a response to parse from DescribeOrganization response
func CreateDescribeOrganizationResponse() (response *DescribeOrganizationResponse) {
	response = &DescribeOrganizationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
