package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetBlockchainCreateTask invokes the baas.GetBlockchainCreateTask API synchronously
// api document: https://help.aliyun.com/api/baas/getblockchaincreatetask.html
func (client *Client) GetBlockchainCreateTask(request *GetBlockchainCreateTaskRequest) (response *GetBlockchainCreateTaskResponse, err error) {
	response = CreateGetBlockchainCreateTaskResponse()
	err = client.DoAction(request, response)
	return
}

// GetBlockchainCreateTaskWithChan invokes the baas.GetBlockchainCreateTask API asynchronously
// api document: https://help.aliyun.com/api/baas/getblockchaincreatetask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetBlockchainCreateTaskWithChan(request *GetBlockchainCreateTaskRequest) (<-chan *GetBlockchainCreateTaskResponse, <-chan error) {
	responseChan := make(chan *GetBlockchainCreateTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetBlockchainCreateTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetBlockchainCreateTaskWithCallback invokes the baas.GetBlockchainCreateTask API asynchronously
// api document: https://help.aliyun.com/api/baas/getblockchaincreatetask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetBlockchainCreateTaskWithCallback(request *GetBlockchainCreateTaskRequest, callback func(response *GetBlockchainCreateTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetBlockchainCreateTaskResponse
		var err error
		defer close(result)
		response, err = client.GetBlockchainCreateTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetBlockchainCreateTaskRequest is the request struct for api GetBlockchainCreateTask
type GetBlockchainCreateTaskRequest struct {
	*requests.RpcRequest
	Current  requests.Integer `position:"Body" name:"Current"`
	PageSize requests.Integer `position:"Body" name:"PageSize"`
}

// GetBlockchainCreateTaskResponse is the response struct for api GetBlockchainCreateTask
type GetBlockchainCreateTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateGetBlockchainCreateTaskRequest creates a request to invoke GetBlockchainCreateTask API
func CreateGetBlockchainCreateTaskRequest() (request *GetBlockchainCreateTaskRequest) {
	request = &GetBlockchainCreateTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "GetBlockchainCreateTask", "", "")
	return
}

// CreateGetBlockchainCreateTaskResponse creates a response to parse from GetBlockchainCreateTask response
func CreateGetBlockchainCreateTaskResponse() (response *GetBlockchainCreateTaskResponse) {
	response = &GetBlockchainCreateTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
