package domain

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryAuctionDetail invokes the domain.QueryAuctionDetail API synchronously
// api document: https://help.aliyun.com/api/domain/queryauctiondetail.html
func (client *Client) QueryAuctionDetail(request *QueryAuctionDetailRequest) (response *QueryAuctionDetailResponse, err error) {
	response = CreateQueryAuctionDetailResponse()
	err = client.DoAction(request, response)
	return
}

// QueryAuctionDetailWithChan invokes the domain.QueryAuctionDetail API asynchronously
// api document: https://help.aliyun.com/api/domain/queryauctiondetail.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryAuctionDetailWithChan(request *QueryAuctionDetailRequest) (<-chan *QueryAuctionDetailResponse, <-chan error) {
	responseChan := make(chan *QueryAuctionDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryAuctionDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryAuctionDetailWithCallback invokes the domain.QueryAuctionDetail API asynchronously
// api document: https://help.aliyun.com/api/domain/queryauctiondetail.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) QueryAuctionDetailWithCallback(request *QueryAuctionDetailRequest, callback func(response *QueryAuctionDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryAuctionDetailResponse
		var err error
		defer close(result)
		response, err = client.QueryAuctionDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryAuctionDetailRequest is the request struct for api QueryAuctionDetail
type QueryAuctionDetailRequest struct {
	*requests.RpcRequest
	AuctionId string `position:"Body" name:"AuctionId"`
}

// QueryAuctionDetailResponse is the response struct for api QueryAuctionDetail
type QueryAuctionDetailResponse struct {
	*responses.BaseResponse
	RequestId       string  `json:"RequestId" xml:"RequestId"`
	DomainName      string  `json:"DomainName" xml:"DomainName"`
	AuctionId       string  `json:"AuctionId" xml:"AuctionId"`
	DomainType      string  `json:"DomainType" xml:"DomainType"`
	BookedPartner   string  `json:"BookedPartner" xml:"BookedPartner"`
	PartnerType     string  `json:"PartnerType" xml:"PartnerType"`
	Currency        string  `json:"Currency" xml:"Currency"`
	YourCurrentBid  float64 `json:"YourCurrentBid" xml:"YourCurrentBid"`
	YourMaxBid      float64 `json:"YourMaxBid" xml:"YourMaxBid"`
	HighBid         float64 `json:"HighBid" xml:"HighBid"`
	NextValidBid    float64 `json:"NextValidBid" xml:"NextValidBid"`
	ReserveMet      bool    `json:"ReserveMet" xml:"ReserveMet"`
	TransferInPrice float64 `json:"TransferInPrice" xml:"TransferInPrice"`
	PayPrice        float64 `json:"PayPrice" xml:"PayPrice"`
	HighBidder      string  `json:"HighBidder" xml:"HighBidder"`
	Status          string  `json:"Status" xml:"Status"`
	PayStatus       string  `json:"PayStatus" xml:"PayStatus"`
	ProduceStatus   string  `json:"ProduceStatus" xml:"ProduceStatus"`
	AuctionEndTime  int     `json:"AuctionEndTime" xml:"AuctionEndTime"`
	BookEndTime     int     `json:"BookEndTime" xml:"BookEndTime"`
	PayEndTime      int     `json:"PayEndTime" xml:"PayEndTime"`
	DeliveryTime    int     `json:"DeliveryTime" xml:"DeliveryTime"`
	FailCode        string  `json:"FailCode" xml:"FailCode"`
}

// CreateQueryAuctionDetailRequest creates a request to invoke QueryAuctionDetail API
func CreateQueryAuctionDetailRequest() (request *QueryAuctionDetailRequest) {
	request = &QueryAuctionDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Domain", "2018-02-08", "QueryAuctionDetail", "", "")
	return
}

// CreateQueryAuctionDetailResponse creates a response to parse from QueryAuctionDetail response
func CreateQueryAuctionDetailResponse() (response *QueryAuctionDetailResponse) {
	response = &QueryAuctionDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
