package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListJobExecutionPlanParams invokes the emr.ListJobExecutionPlanParams API synchronously
// api document: https://help.aliyun.com/api/emr/listjobexecutionplanparams.html
func (client *Client) ListJobExecutionPlanParams(request *ListJobExecutionPlanParamsRequest) (response *ListJobExecutionPlanParamsResponse, err error) {
	response = CreateListJobExecutionPlanParamsResponse()
	err = client.DoAction(request, response)
	return
}

// ListJobExecutionPlanParamsWithChan invokes the emr.ListJobExecutionPlanParams API asynchronously
// api document: https://help.aliyun.com/api/emr/listjobexecutionplanparams.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListJobExecutionPlanParamsWithChan(request *ListJobExecutionPlanParamsRequest) (<-chan *ListJobExecutionPlanParamsResponse, <-chan error) {
	responseChan := make(chan *ListJobExecutionPlanParamsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListJobExecutionPlanParams(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListJobExecutionPlanParamsWithCallback invokes the emr.ListJobExecutionPlanParams API asynchronously
// api document: https://help.aliyun.com/api/emr/listjobexecutionplanparams.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListJobExecutionPlanParamsWithCallback(request *ListJobExecutionPlanParamsRequest, callback func(response *ListJobExecutionPlanParamsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListJobExecutionPlanParamsResponse
		var err error
		defer close(result)
		response, err = client.ListJobExecutionPlanParams(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListJobExecutionPlanParamsRequest is the request struct for api ListJobExecutionPlanParams
type ListJobExecutionPlanParamsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	RelateId        string           `position:"Query" name:"RelateId"`
	ParamBizType    string           `position:"Query" name:"ParamBizType"`
}

// ListJobExecutionPlanParamsResponse is the response struct for api ListJobExecutionPlanParams
type ListJobExecutionPlanParamsResponse struct {
	*responses.BaseResponse
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	Success       string        `json:"Success" xml:"Success"`
	ErrCode       string        `json:"ErrCode" xml:"ErrCode"`
	ErrMsg        string        `json:"ErrMsg" xml:"ErrMsg"`
	ParamInfoList ParamInfoList `json:"ParamInfoList" xml:"ParamInfoList"`
}

// CreateListJobExecutionPlanParamsRequest creates a request to invoke ListJobExecutionPlanParams API
func CreateListJobExecutionPlanParamsRequest() (request *ListJobExecutionPlanParamsRequest) {
	request = &ListJobExecutionPlanParamsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListJobExecutionPlanParams", "emr", "openAPI")
	return
}

// CreateListJobExecutionPlanParamsResponse creates a response to parse from ListJobExecutionPlanParams response
func CreateListJobExecutionPlanParamsResponse() (response *ListJobExecutionPlanParamsResponse) {
	response = &ListJobExecutionPlanParamsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
