// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/openshift/hive/pkg/apis/hive/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// ClusterPoolLister helps list ClusterPools.
type ClusterPoolLister interface {
	// List lists all ClusterPools in the indexer.
	List(selector labels.Selector) (ret []*v1.ClusterPool, err error)
	// ClusterPools returns an object that can list and get ClusterPools.
	ClusterPools(namespace string) ClusterPoolNamespaceLister
	ClusterPoolListerExpansion
}

// clusterPoolLister implements the ClusterPoolLister interface.
type clusterPoolLister struct {
	indexer cache.Indexer
}

// NewClusterPoolLister returns a new ClusterPoolLister.
func NewClusterPoolLister(indexer cache.Indexer) ClusterPoolLister {
	return &clusterPoolLister{indexer: indexer}
}

// List lists all ClusterPools in the indexer.
func (s *clusterPoolLister) List(selector labels.Selector) (ret []*v1.ClusterPool, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.ClusterPool))
	})
	return ret, err
}

// ClusterPools returns an object that can list and get ClusterPools.
func (s *clusterPoolLister) ClusterPools(namespace string) ClusterPoolNamespaceLister {
	return clusterPoolNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// ClusterPoolNamespaceLister helps list and get ClusterPools.
type ClusterPoolNamespaceLister interface {
	// List lists all ClusterPools in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1.ClusterPool, err error)
	// Get retrieves the ClusterPool from the indexer for a given namespace and name.
	Get(name string) (*v1.ClusterPool, error)
	ClusterPoolNamespaceListerExpansion
}

// clusterPoolNamespaceLister implements the ClusterPoolNamespaceLister
// interface.
type clusterPoolNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all ClusterPools in the indexer for a given namespace.
func (s clusterPoolNamespaceLister) List(selector labels.Selector) (ret []*v1.ClusterPool, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.ClusterPool))
	})
	return ret, err
}

// Get retrieves the ClusterPool from the indexer for a given namespace and name.
func (s clusterPoolNamespaceLister) Get(name string) (*v1.ClusterPool, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("clusterpool"), name)
	}
	return obj.(*v1.ClusterPool), nil
}
