// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/openshift/hive/pkg/apis/hive/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// ClusterProvisionLister helps list ClusterProvisions.
type ClusterProvisionLister interface {
	// List lists all ClusterProvisions in the indexer.
	List(selector labels.Selector) (ret []*v1.ClusterProvision, err error)
	// ClusterProvisions returns an object that can list and get ClusterProvisions.
	ClusterProvisions(namespace string) ClusterProvisionNamespaceLister
	ClusterProvisionListerExpansion
}

// clusterProvisionLister implements the ClusterProvisionLister interface.
type clusterProvisionLister struct {
	indexer cache.Indexer
}

// NewClusterProvisionLister returns a new ClusterProvisionLister.
func NewClusterProvisionLister(indexer cache.Indexer) ClusterProvisionLister {
	return &clusterProvisionLister{indexer: indexer}
}

// List lists all ClusterProvisions in the indexer.
func (s *clusterProvisionLister) List(selector labels.Selector) (ret []*v1.ClusterProvision, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.ClusterProvision))
	})
	return ret, err
}

// ClusterProvisions returns an object that can list and get ClusterProvisions.
func (s *clusterProvisionLister) ClusterProvisions(namespace string) ClusterProvisionNamespaceLister {
	return clusterProvisionNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// ClusterProvisionNamespaceLister helps list and get ClusterProvisions.
type ClusterProvisionNamespaceLister interface {
	// List lists all ClusterProvisions in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1.ClusterProvision, err error)
	// Get retrieves the ClusterProvision from the indexer for a given namespace and name.
	Get(name string) (*v1.ClusterProvision, error)
	ClusterProvisionNamespaceListerExpansion
}

// clusterProvisionNamespaceLister implements the ClusterProvisionNamespaceLister
// interface.
type clusterProvisionNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all ClusterProvisions in the indexer for a given namespace.
func (s clusterProvisionNamespaceLister) List(selector labels.Selector) (ret []*v1.ClusterProvision, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.ClusterProvision))
	})
	return ret, err
}

// Get retrieves the ClusterProvision from the indexer for a given namespace and name.
func (s clusterProvisionNamespaceLister) Get(name string) (*v1.ClusterProvision, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("clusterprovision"), name)
	}
	return obj.(*v1.ClusterProvision), nil
}
