---
layout: "api"
page_title: "TOTP - Secrets Engines - HTTP API"
sidebar_title: "TOTP"
sidebar_current: "api-http-secret-totp"
description: |-
  This is the API documentation for the Vault TOTP secrets engine.
---

# TOTP Secrets Engine (API)

This is the API documentation for the Vault TOTP secrets engine. For general
information about the usage and operation of the TOTP secrets engine, please see
the [TOTP documentation](/docs/secrets/totp/index.html).

This documentation assumes the TOTP secrets engine is enabled at the `/totp`
path in Vault. Since it is possible to enable secrets engines at any location,
please update your API calls accordingly.

## Create Key

This endpoint creates or updates a key definition.

| Method   | Path                         |
| :--------------------------- | :--------------------------------------------------------------------------------------------- |
| `POST`   | `/totp/keys/:name`           | if generating a key and exported is true: `200 application/json` else: `204 (empty body)`      |

### Parameters

- `name` `(string: <required>)` – Specifies the name of the key to create. This is specified as part of the URL.

- `generate` `(bool: false)` – Specifies if a key should be generated by Vault or if a key is being passed from another service.

- `exported` `(bool: true)` – Specifies if a QR code and url are returned upon generating a key. Only used if generate is true.

- `key_size` `(int: 20)` – Specifies the size in bytes of the Vault generated key. Only used if generate is true.

- `url` `(string: "")` – Specifies the TOTP key url string that can be used to configure a key. Only used if generate is false.

- `key` `(string: <required - if generate is false and url is empty>)` – Specifies the master key used to generate a TOTP code. Only used if generate is false.

- `issuer` `(string: "" <required - if generate is true>)` – Specifies the name of the key’s issuing organization.

- `account_name` `(string: "" <required - if generate is true>)` – Specifies the name of the account associated with the key.

- `period` `(int or duration format string: 30)` – Specifies the length of time in seconds used to generate a counter for the TOTP code calculation.

- `algorithm` `(string: "SHA1")` – Specifies the hashing algorithm used to generate the TOTP code. Options include "SHA1", "SHA256" and "SHA512".

- `digits` `(int: 6)` – Specifies the number of digits in the generated TOTP code. This value can be set to 6 or 8.

- `skew` `(int: 1)` – Specifies the number of delay periods that are allowed when validating a TOTP code. This value can be either 0 or 1. Only used if generate is true.

- `qr_size` `(int: 200)` – Specifies the pixel size of the square QR code when generating a new key. Only used if generate is true and exported is true. If this value is 0, a QR code will not be returned.

### Sample Payload

```json
{
  "url": "otpauth://totp/Google:test@gmail.com?secret=Y64VEVMBTSXCYIWRSHRNDZW62MPGVU2G&issuer=Google"
}
```

### Sample Request

```
$ curl \
    --header "X-Vault-Token: ..." \
    --request POST \
    --data @payload.json \
    http://127.0.0.1:8200/v1/totp/keys/my-key
```

### Sample Payload

```json
{
  "generate": true,
  "issuer": "Google",
  "account_name": "test@gmail.com",
}
```

### Sample Request

```
$ curl \
    --header "X-Vault-Token: ..." \
    --request POST \
    --data @payload.json \
    http://127.0.0.1:8200/v1/totp/keys/my-key
```

### Sample Response

```json
{
  "data": {
    "barcode": "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",
    "url" : "otpauth://totp/Google:test@gmail.com?algorithm=SHA1&digits=6&issuer=Google&period=30&secret=HTXT7KJFVNAJUPYWQRWMNVQE5AF5YZI2",
  }
}
```

If a QR code is returned, it consists of base64-formatted PNG bytes. You can embed it in a web page by including the base64 string in an `img` tag with the prefix `data:image/png;base64`

```
<img src="data:image/png;base64,iVBORw0KGgoAAAANSUh.." />
```

## Read Key

This endpoint queries the key definition.

| Method   | Path                         |
| :--------------------------- | :--------------------- |
| `GET`    | `/totp/keys/:name`          |

### Parameters

- `name` `(string: <required>)` – Specifies the name of the key to read. This is specified as part of the URL.

### Sample Request

```
$ curl \
    --header "X-Vault-Token: ..." \
    http://127.0.0.1:8200/v1/totp/keys/my-key
```

### Sample Response

```json
{
  "data": {
    "account_name": "test@gmail.com",
    "algorithm" : "SHA1",
    "digits" : 6,
    "issuer": "Google",
    "period" : 30,
  }
}
```

## List Keys

This endpoint returns a list of available keys. Only the key names are
returned, not any values.

| Method   | Path                         |
| :--------------------------- | :--------------------- |
| `LIST`   | `/totp/keys`                 |

### Sample Request

```
$ curl \
    --header "X-Vault-Token: ..." \
    --request LIST \
    http://127.0.0.1:8200/v1/totp/keys
```

### Sample Response

```json
{
  "auth": null,
  "data": {
    "keys": ["my-key"]
  },
  "lease_duration": 0,
  "lease_id": "",
  "renewable": false
}
```

## Delete Key

This endpoint deletes the key definition.

| Method   | Path                         |
| :--------------------------- | :--------------------- |
| `DELETE` | `/totp/keys/:name`           |

### Parameters

- `name` `(string: <required>)` – Specifies the name of the key to delete. This
  is specified as part of the URL.

### Sample Request

```
$ curl \
    --header "X-Vault-Token: ..." \
    --request DELETE \
    http://127.0.0.1:8200/v1/totp/keys/my-key
```

## Generate Code

This endpoint generates a new time-based one-time use password based on the named
key.

| Method   | Path                         |
| :--------------------------- | :--------------------- |
| `GET`    | `/totp/code/:name`          |

### Parameters

- `name` `(string: <required>)` – Specifies the name of the key to create
  credentials against. This is specified as part of the URL.

### Sample Request

```
$ curl \
    --header "X-Vault-Token: ..." \
    http://127.0.0.1:8200/v1/totp/code/my-key
```

### Sample Response

```json
{
  "data": {
    "code": "810920",
  }
}
```

## Validate Code

This endpoint validates a time-based one-time use password generated from the named
key.

| Method   | Path                         |
| :--------------------------- | :--------------------- |
| `POST`   | `/totp/code/:name`           |

### Parameters

- `name` `(string: <required>)` – Specifies the name of the key used to generate the password. This is specified as part of the URL.

- `code` `(string: <required>)` – Specifies the password you want to validate.

### Sample Payload

```json
{
  "code": "123802"
}
```

### Sample Request

```
$ curl \
    --header "X-Vault-Token: ..." \
    --request POST \
    --data @payload.json \
    http://127.0.0.1:8200/v1/totp/code/my-key
```

### Sample Response

```json
{
  "data": {
    "valid": true,
  }
}
```
