package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// KillETLJobInstance invokes the emr.KillETLJobInstance API synchronously
// api document: https://help.aliyun.com/api/emr/killetljobinstance.html
func (client *Client) KillETLJobInstance(request *KillETLJobInstanceRequest) (response *KillETLJobInstanceResponse, err error) {
	response = CreateKillETLJobInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// KillETLJobInstanceWithChan invokes the emr.KillETLJobInstance API asynchronously
// api document: https://help.aliyun.com/api/emr/killetljobinstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) KillETLJobInstanceWithChan(request *KillETLJobInstanceRequest) (<-chan *KillETLJobInstanceResponse, <-chan error) {
	responseChan := make(chan *KillETLJobInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.KillETLJobInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// KillETLJobInstanceWithCallback invokes the emr.KillETLJobInstance API asynchronously
// api document: https://help.aliyun.com/api/emr/killetljobinstance.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) KillETLJobInstanceWithCallback(request *KillETLJobInstanceRequest, callback func(response *KillETLJobInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *KillETLJobInstanceResponse
		var err error
		defer close(result)
		response, err = client.KillETLJobInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// KillETLJobInstanceRequest is the request struct for api KillETLJobInstance
type KillETLJobInstanceRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	InstanceId      string           `position:"Query" name:"InstanceId"`
}

// KillETLJobInstanceResponse is the response struct for api KillETLJobInstance
type KillETLJobInstanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateKillETLJobInstanceRequest creates a request to invoke KillETLJobInstance API
func CreateKillETLJobInstanceRequest() (request *KillETLJobInstanceRequest) {
	request = &KillETLJobInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "KillETLJobInstance", "emr", "openAPI")
	return
}

// CreateKillETLJobInstanceResponse creates a response to parse from KillETLJobInstance response
func CreateKillETLJobInstanceResponse() (response *KillETLJobInstanceResponse) {
	response = &KillETLJobInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
