package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ConvertBandwidthPackage invokes the vpc.ConvertBandwidthPackage API synchronously
// api document: https://help.aliyun.com/api/vpc/convertbandwidthpackage.html
func (client *Client) ConvertBandwidthPackage(request *ConvertBandwidthPackageRequest) (response *ConvertBandwidthPackageResponse, err error) {
	response = CreateConvertBandwidthPackageResponse()
	err = client.DoAction(request, response)
	return
}

// ConvertBandwidthPackageWithChan invokes the vpc.ConvertBandwidthPackage API asynchronously
// api document: https://help.aliyun.com/api/vpc/convertbandwidthpackage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ConvertBandwidthPackageWithChan(request *ConvertBandwidthPackageRequest) (<-chan *ConvertBandwidthPackageResponse, <-chan error) {
	responseChan := make(chan *ConvertBandwidthPackageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ConvertBandwidthPackage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ConvertBandwidthPackageWithCallback invokes the vpc.ConvertBandwidthPackage API asynchronously
// api document: https://help.aliyun.com/api/vpc/convertbandwidthpackage.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ConvertBandwidthPackageWithCallback(request *ConvertBandwidthPackageRequest, callback func(response *ConvertBandwidthPackageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ConvertBandwidthPackageResponse
		var err error
		defer close(result)
		response, err = client.ConvertBandwidthPackage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ConvertBandwidthPackageRequest is the request struct for api ConvertBandwidthPackage
type ConvertBandwidthPackageRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	BandwidthPackageId   string           `position:"Query" name:"BandwidthPackageId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// ConvertBandwidthPackageResponse is the response struct for api ConvertBandwidthPackage
type ConvertBandwidthPackageResponse struct {
	*responses.BaseResponse
	RequestId         string `json:"RequestId" xml:"RequestId"`
	ConvertInstanceId string `json:"ConvertInstanceId" xml:"ConvertInstanceId"`
}

// CreateConvertBandwidthPackageRequest creates a request to invoke ConvertBandwidthPackage API
func CreateConvertBandwidthPackageRequest() (request *ConvertBandwidthPackageRequest) {
	request = &ConvertBandwidthPackageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "ConvertBandwidthPackage", "vpc", "openAPI")
	return
}

// CreateConvertBandwidthPackageResponse creates a response to parse from ConvertBandwidthPackage response
func CreateConvertBandwidthPackageResponse() (response *ConvertBandwidthPackageResponse) {
	response = &ConvertBandwidthPackageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
