package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyNetworkInterfaceAttribute invokes the ecs.ModifyNetworkInterfaceAttribute API synchronously
// api document: https://help.aliyun.com/api/ecs/modifynetworkinterfaceattribute.html
func (client *Client) ModifyNetworkInterfaceAttribute(request *ModifyNetworkInterfaceAttributeRequest) (response *ModifyNetworkInterfaceAttributeResponse, err error) {
	response = CreateModifyNetworkInterfaceAttributeResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyNetworkInterfaceAttributeWithChan invokes the ecs.ModifyNetworkInterfaceAttribute API asynchronously
// api document: https://help.aliyun.com/api/ecs/modifynetworkinterfaceattribute.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyNetworkInterfaceAttributeWithChan(request *ModifyNetworkInterfaceAttributeRequest) (<-chan *ModifyNetworkInterfaceAttributeResponse, <-chan error) {
	responseChan := make(chan *ModifyNetworkInterfaceAttributeResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyNetworkInterfaceAttribute(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyNetworkInterfaceAttributeWithCallback invokes the ecs.ModifyNetworkInterfaceAttribute API asynchronously
// api document: https://help.aliyun.com/api/ecs/modifynetworkinterfaceattribute.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyNetworkInterfaceAttributeWithCallback(request *ModifyNetworkInterfaceAttributeRequest, callback func(response *ModifyNetworkInterfaceAttributeResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyNetworkInterfaceAttributeResponse
		var err error
		defer close(result)
		response, err = client.ModifyNetworkInterfaceAttribute(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyNetworkInterfaceAttributeRequest is the request struct for api ModifyNetworkInterfaceAttribute
type ModifyNetworkInterfaceAttributeRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	SecurityGroupId      *[]string        `position:"Query" name:"SecurityGroupId"  type:"Repeated"`
	Description          string           `position:"Query" name:"Description"`
	NetworkInterfaceName string           `position:"Query" name:"NetworkInterfaceName"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	NetworkInterfaceId   string           `position:"Query" name:"NetworkInterfaceId"`
}

// ModifyNetworkInterfaceAttributeResponse is the response struct for api ModifyNetworkInterfaceAttribute
type ModifyNetworkInterfaceAttributeResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyNetworkInterfaceAttributeRequest creates a request to invoke ModifyNetworkInterfaceAttribute API
func CreateModifyNetworkInterfaceAttributeRequest() (request *ModifyNetworkInterfaceAttributeRequest) {
	request = &ModifyNetworkInterfaceAttributeRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "ModifyNetworkInterfaceAttribute", "ecs", "openAPI")
	return
}

// CreateModifyNetworkInterfaceAttributeResponse creates a response to parse from ModifyNetworkInterfaceAttribute response
func CreateModifyNetworkInterfaceAttributeResponse() (response *ModifyNetworkInterfaceAttributeResponse) {
	response = &ModifyNetworkInterfaceAttributeResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
