package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyHichinaDomainDNS invokes the alidns.ModifyHichinaDomainDNS API synchronously
// api document: https://help.aliyun.com/api/alidns/modifyhichinadomaindns.html
func (client *Client) ModifyHichinaDomainDNS(request *ModifyHichinaDomainDNSRequest) (response *ModifyHichinaDomainDNSResponse, err error) {
	response = CreateModifyHichinaDomainDNSResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyHichinaDomainDNSWithChan invokes the alidns.ModifyHichinaDomainDNS API asynchronously
// api document: https://help.aliyun.com/api/alidns/modifyhichinadomaindns.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyHichinaDomainDNSWithChan(request *ModifyHichinaDomainDNSRequest) (<-chan *ModifyHichinaDomainDNSResponse, <-chan error) {
	responseChan := make(chan *ModifyHichinaDomainDNSResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyHichinaDomainDNS(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyHichinaDomainDNSWithCallback invokes the alidns.ModifyHichinaDomainDNS API asynchronously
// api document: https://help.aliyun.com/api/alidns/modifyhichinadomaindns.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyHichinaDomainDNSWithCallback(request *ModifyHichinaDomainDNSRequest, callback func(response *ModifyHichinaDomainDNSResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyHichinaDomainDNSResponse
		var err error
		defer close(result)
		response, err = client.ModifyHichinaDomainDNS(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyHichinaDomainDNSRequest is the request struct for api ModifyHichinaDomainDNS
type ModifyHichinaDomainDNSRequest struct {
	*requests.RpcRequest
	UserClientIp string `position:"Query" name:"UserClientIp"`
	DomainName   string `position:"Query" name:"DomainName"`
	Lang         string `position:"Query" name:"Lang"`
}

// ModifyHichinaDomainDNSResponse is the response struct for api ModifyHichinaDomainDNS
type ModifyHichinaDomainDNSResponse struct {
	*responses.BaseResponse
	RequestId          string             `json:"RequestId" xml:"RequestId"`
	OriginalDnsServers OriginalDnsServers `json:"OriginalDnsServers" xml:"OriginalDnsServers"`
	NewDnsServers      NewDnsServers      `json:"NewDnsServers" xml:"NewDnsServers"`
}

// CreateModifyHichinaDomainDNSRequest creates a request to invoke ModifyHichinaDomainDNS API
func CreateModifyHichinaDomainDNSRequest() (request *ModifyHichinaDomainDNSRequest) {
	request = &ModifyHichinaDomainDNSRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "ModifyHichinaDomainDNS", "alidns", "openAPI")
	return
}

// CreateModifyHichinaDomainDNSResponse creates a response to parse from ModifyHichinaDomainDNS response
func CreateModifyHichinaDomainDNSResponse() (response *ModifyHichinaDomainDNSResponse) {
	response = &ModifyHichinaDomainDNSResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
