package live

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCasterVideoResources invokes the live.DescribeCasterVideoResources API synchronously
// api document: https://help.aliyun.com/api/live/describecastervideoresources.html
func (client *Client) DescribeCasterVideoResources(request *DescribeCasterVideoResourcesRequest) (response *DescribeCasterVideoResourcesResponse, err error) {
	response = CreateDescribeCasterVideoResourcesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCasterVideoResourcesWithChan invokes the live.DescribeCasterVideoResources API asynchronously
// api document: https://help.aliyun.com/api/live/describecastervideoresources.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeCasterVideoResourcesWithChan(request *DescribeCasterVideoResourcesRequest) (<-chan *DescribeCasterVideoResourcesResponse, <-chan error) {
	responseChan := make(chan *DescribeCasterVideoResourcesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCasterVideoResources(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCasterVideoResourcesWithCallback invokes the live.DescribeCasterVideoResources API asynchronously
// api document: https://help.aliyun.com/api/live/describecastervideoresources.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeCasterVideoResourcesWithCallback(request *DescribeCasterVideoResourcesRequest, callback func(response *DescribeCasterVideoResourcesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCasterVideoResourcesResponse
		var err error
		defer close(result)
		response, err = client.DescribeCasterVideoResources(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCasterVideoResourcesRequest is the request struct for api DescribeCasterVideoResources
type DescribeCasterVideoResourcesRequest struct {
	*requests.RpcRequest
	CasterId string           `position:"Query" name:"CasterId"`
	OwnerId  requests.Integer `position:"Query" name:"OwnerId"`
}

// DescribeCasterVideoResourcesResponse is the response struct for api DescribeCasterVideoResources
type DescribeCasterVideoResourcesResponse struct {
	*responses.BaseResponse
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	Total          int            `json:"Total" xml:"Total"`
	VideoResources VideoResources `json:"VideoResources" xml:"VideoResources"`
}

// CreateDescribeCasterVideoResourcesRequest creates a request to invoke DescribeCasterVideoResources API
func CreateDescribeCasterVideoResourcesRequest() (request *DescribeCasterVideoResourcesRequest) {
	request = &DescribeCasterVideoResourcesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("live", "2016-11-01", "DescribeCasterVideoResources", "live", "openAPI")
	return
}

// CreateDescribeCasterVideoResourcesResponse creates a response to parse from DescribeCasterVideoResources response
func CreateDescribeCasterVideoResourcesResponse() (response *DescribeCasterVideoResourcesResponse) {
	response = &DescribeCasterVideoResourcesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
