// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitosync

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// A request for usage information on an identity pool.
type ListIdentityPoolUsageInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to be returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" type:"integer"`

	// A pagination token for obtaining the next page of results.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation
func (s ListIdentityPoolUsageInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListIdentityPoolUsageInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "maxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "nextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Returned for a successful ListIdentityPoolUsage request.
type ListIdentityPoolUsageOutput struct {
	_ struct{} `type:"structure"`

	// Total number of identities for the identity pool.
	Count *int64 `type:"integer"`

	// Usage information for the identity pools.
	IdentityPoolUsages []IdentityPoolUsage `type:"list"`

	// The maximum number of results to be returned.
	MaxResults *int64 `type:"integer"`

	// A pagination token for obtaining the next page of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListIdentityPoolUsageOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListIdentityPoolUsageOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Count != nil {
		v := *s.Count

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Count", protocol.Int64Value(v), metadata)
	}
	if s.IdentityPoolUsages != nil {
		v := s.IdentityPoolUsages

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "IdentityPoolUsages", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opListIdentityPoolUsage = "ListIdentityPoolUsage"

// ListIdentityPoolUsageRequest returns a request value for making API operation for
// Amazon Cognito Sync.
//
// Gets a list of identity pools registered with Cognito.
//
// ListIdentityPoolUsage can only be called with developer credentials. You
// cannot make this API call with the temporary user credentials provided by
// Cognito Identity.
//
//    // Example sending a request using ListIdentityPoolUsageRequest.
//    req := client.ListIdentityPoolUsageRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-sync-2014-06-30/ListIdentityPoolUsage
func (c *Client) ListIdentityPoolUsageRequest(input *ListIdentityPoolUsageInput) ListIdentityPoolUsageRequest {
	op := &aws.Operation{
		Name:       opListIdentityPoolUsage,
		HTTPMethod: "GET",
		HTTPPath:   "/identitypools",
	}

	if input == nil {
		input = &ListIdentityPoolUsageInput{}
	}

	req := c.newRequest(op, input, &ListIdentityPoolUsageOutput{})
	return ListIdentityPoolUsageRequest{Request: req, Input: input, Copy: c.ListIdentityPoolUsageRequest}
}

// ListIdentityPoolUsageRequest is the request type for the
// ListIdentityPoolUsage API operation.
type ListIdentityPoolUsageRequest struct {
	*aws.Request
	Input *ListIdentityPoolUsageInput
	Copy  func(*ListIdentityPoolUsageInput) ListIdentityPoolUsageRequest
}

// Send marshals and sends the ListIdentityPoolUsage API request.
func (r ListIdentityPoolUsageRequest) Send(ctx context.Context) (*ListIdentityPoolUsageResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListIdentityPoolUsageResponse{
		ListIdentityPoolUsageOutput: r.Request.Data.(*ListIdentityPoolUsageOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListIdentityPoolUsageResponse is the response type for the
// ListIdentityPoolUsage API operation.
type ListIdentityPoolUsageResponse struct {
	*ListIdentityPoolUsageOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListIdentityPoolUsage request.
func (r *ListIdentityPoolUsageResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
