// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/example/library/v1/library.proto

package library

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	context "golang.org/x/net/context"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// A single book in the library.
type Book struct {
	// The resource name of the book.
	// Book names have the form `shelves/{shelf_id}/books/{book_id}`.
	// The name is ignored when creating a book.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The name of the book author.
	Author string `protobuf:"bytes,2,opt,name=author,proto3" json:"author,omitempty"`
	// The title of the book.
	Title string `protobuf:"bytes,3,opt,name=title,proto3" json:"title,omitempty"`
	// Value indicating whether the book has been read.
	Read                 bool     `protobuf:"varint,4,opt,name=read,proto3" json:"read,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Book) Reset()         { *m = Book{} }
func (m *Book) String() string { return proto.CompactTextString(m) }
func (*Book) ProtoMessage()    {}
func (*Book) Descriptor() ([]byte, []int) {
	return fileDescriptor_40bd7925372a20e3, []int{0}
}

func (m *Book) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Book.Unmarshal(m, b)
}
func (m *Book) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Book.Marshal(b, m, deterministic)
}
func (m *Book) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Book.Merge(m, src)
}
func (m *Book) XXX_Size() int {
	return xxx_messageInfo_Book.Size(m)
}
func (m *Book) XXX_DiscardUnknown() {
	xxx_messageInfo_Book.DiscardUnknown(m)
}

var xxx_messageInfo_Book proto.InternalMessageInfo

func (m *Book) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Book) GetAuthor() string {
	if m != nil {
		return m.Author
	}
	return ""
}

func (m *Book) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *Book) GetRead() bool {
	if m != nil {
		return m.Read
	}
	return false
}

// A Shelf contains a collection of books with a theme.
type Shelf struct {
	// The resource name of the shelf.
	// Shelf names have the form `shelves/{shelf_id}`.
	// The name is ignored when creating a shelf.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The theme of the shelf
	Theme                string   `protobuf:"bytes,2,opt,name=theme,proto3" json:"theme,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Shelf) Reset()         { *m = Shelf{} }
func (m *Shelf) String() string { return proto.CompactTextString(m) }
func (*Shelf) ProtoMessage()    {}
func (*Shelf) Descriptor() ([]byte, []int) {
	return fileDescriptor_40bd7925372a20e3, []int{1}
}

func (m *Shelf) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Shelf.Unmarshal(m, b)
}
func (m *Shelf) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Shelf.Marshal(b, m, deterministic)
}
func (m *Shelf) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Shelf.Merge(m, src)
}
func (m *Shelf) XXX_Size() int {
	return xxx_messageInfo_Shelf.Size(m)
}
func (m *Shelf) XXX_DiscardUnknown() {
	xxx_messageInfo_Shelf.DiscardUnknown(m)
}

var xxx_messageInfo_Shelf proto.InternalMessageInfo

func (m *Shelf) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Shelf) GetTheme() string {
	if m != nil {
		return m.Theme
	}
	return ""
}

// Request message for LibraryService.CreateShelf.
type CreateShelfRequest struct {
	// The shelf to create.
	Shelf                *Shelf   `protobuf:"bytes,1,opt,name=shelf,proto3" json:"shelf,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateShelfRequest) Reset()         { *m = CreateShelfRequest{} }
func (m *CreateShelfRequest) String() string { return proto.CompactTextString(m) }
func (*CreateShelfRequest) ProtoMessage()    {}
func (*CreateShelfRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_40bd7925372a20e3, []int{2}
}

func (m *CreateShelfRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateShelfRequest.Unmarshal(m, b)
}
func (m *CreateShelfRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateShelfRequest.Marshal(b, m, deterministic)
}
func (m *CreateShelfRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateShelfRequest.Merge(m, src)
}
func (m *CreateShelfRequest) XXX_Size() int {
	return xxx_messageInfo_CreateShelfRequest.Size(m)
}
func (m *CreateShelfRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateShelfRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateShelfRequest proto.InternalMessageInfo

func (m *CreateShelfRequest) GetShelf() *Shelf {
	if m != nil {
		return m.Shelf
	}
	return nil
}

// Request message for LibraryService.GetShelf.
type GetShelfRequest struct {
	// The name of the shelf to retrieve.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetShelfRequest) Reset()         { *m = GetShelfRequest{} }
func (m *GetShelfRequest) String() string { return proto.CompactTextString(m) }
func (*GetShelfRequest) ProtoMessage()    {}
func (*GetShelfRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_40bd7925372a20e3, []int{3}
}

func (m *GetShelfRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetShelfRequest.Unmarshal(m, b)
}
func (m *GetShelfRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetShelfRequest.Marshal(b, m, deterministic)
}
func (m *GetShelfRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetShelfRequest.Merge(m, src)
}
func (m *GetShelfRequest) XXX_Size() int {
	return xxx_messageInfo_GetShelfRequest.Size(m)
}
func (m *GetShelfRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetShelfRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetShelfRequest proto.InternalMessageInfo

func (m *GetShelfRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for LibraryService.ListShelves.
type ListShelvesRequest struct {
	// Requested page size. Server may return fewer shelves than requested.
	// If unspecified, server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,1,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results the server should return.
	// Typically, this is the value of
	// [ListShelvesResponse.next_page_token][google.example.library.v1.ListShelvesResponse.next_page_token]
	// returned from the previous call to `ListShelves` method.
	PageToken            string   `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListShelvesRequest) Reset()         { *m = ListShelvesRequest{} }
func (m *ListShelvesRequest) String() string { return proto.CompactTextString(m) }
func (*ListShelvesRequest) ProtoMessage()    {}
func (*ListShelvesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_40bd7925372a20e3, []int{4}
}

func (m *ListShelvesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListShelvesRequest.Unmarshal(m, b)
}
func (m *ListShelvesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListShelvesRequest.Marshal(b, m, deterministic)
}
func (m *ListShelvesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListShelvesRequest.Merge(m, src)
}
func (m *ListShelvesRequest) XXX_Size() int {
	return xxx_messageInfo_ListShelvesRequest.Size(m)
}
func (m *ListShelvesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListShelvesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListShelvesRequest proto.InternalMessageInfo

func (m *ListShelvesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListShelvesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response message for LibraryService.ListShelves.
type ListShelvesResponse struct {
	// The list of shelves.
	Shelves []*Shelf `protobuf:"bytes,1,rep,name=shelves,proto3" json:"shelves,omitempty"`
	// A token to retrieve next page of results.
	// Pass this value in the
	// [ListShelvesRequest.page_token][google.example.library.v1.ListShelvesRequest.page_token]
	// field in the subsequent call to `ListShelves` method to retrieve the next
	// page of results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListShelvesResponse) Reset()         { *m = ListShelvesResponse{} }
func (m *ListShelvesResponse) String() string { return proto.CompactTextString(m) }
func (*ListShelvesResponse) ProtoMessage()    {}
func (*ListShelvesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_40bd7925372a20e3, []int{5}
}

func (m *ListShelvesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListShelvesResponse.Unmarshal(m, b)
}
func (m *ListShelvesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListShelvesResponse.Marshal(b, m, deterministic)
}
func (m *ListShelvesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListShelvesResponse.Merge(m, src)
}
func (m *ListShelvesResponse) XXX_Size() int {
	return xxx_messageInfo_ListShelvesResponse.Size(m)
}
func (m *ListShelvesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListShelvesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListShelvesResponse proto.InternalMessageInfo

func (m *ListShelvesResponse) GetShelves() []*Shelf {
	if m != nil {
		return m.Shelves
	}
	return nil
}

func (m *ListShelvesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for LibraryService.DeleteShelf.
type DeleteShelfRequest struct {
	// The name of the shelf to delete.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteShelfRequest) Reset()         { *m = DeleteShelfRequest{} }
func (m *DeleteShelfRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteShelfRequest) ProtoMessage()    {}
func (*DeleteShelfRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_40bd7925372a20e3, []int{6}
}

func (m *DeleteShelfRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteShelfRequest.Unmarshal(m, b)
}
func (m *DeleteShelfRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteShelfRequest.Marshal(b, m, deterministic)
}
func (m *DeleteShelfRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteShelfRequest.Merge(m, src)
}
func (m *DeleteShelfRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteShelfRequest.Size(m)
}
func (m *DeleteShelfRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteShelfRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteShelfRequest proto.InternalMessageInfo

func (m *DeleteShelfRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Describes the shelf being removed (other_shelf_name) and updated
// (name) in this merge.
type MergeShelvesRequest struct {
	// The name of the shelf we're adding books to.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The name of the shelf we're removing books from and deleting.
	OtherShelfName       string   `protobuf:"bytes,2,opt,name=other_shelf_name,json=otherShelfName,proto3" json:"other_shelf_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MergeShelvesRequest) Reset()         { *m = MergeShelvesRequest{} }
func (m *MergeShelvesRequest) String() string { return proto.CompactTextString(m) }
func (*MergeShelvesRequest) ProtoMessage()    {}
func (*MergeShelvesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_40bd7925372a20e3, []int{7}
}

func (m *MergeShelvesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MergeShelvesRequest.Unmarshal(m, b)
}
func (m *MergeShelvesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MergeShelvesRequest.Marshal(b, m, deterministic)
}
func (m *MergeShelvesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MergeShelvesRequest.Merge(m, src)
}
func (m *MergeShelvesRequest) XXX_Size() int {
	return xxx_messageInfo_MergeShelvesRequest.Size(m)
}
func (m *MergeShelvesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MergeShelvesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MergeShelvesRequest proto.InternalMessageInfo

func (m *MergeShelvesRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *MergeShelvesRequest) GetOtherShelfName() string {
	if m != nil {
		return m.OtherShelfName
	}
	return ""
}

// Request message for LibraryService.CreateBook.
type CreateBookRequest struct {
	// The name of the shelf in which the book is created.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The book to create.
	Book                 *Book    `protobuf:"bytes,2,opt,name=book,proto3" json:"book,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateBookRequest) Reset()         { *m = CreateBookRequest{} }
func (m *CreateBookRequest) String() string { return proto.CompactTextString(m) }
func (*CreateBookRequest) ProtoMessage()    {}
func (*CreateBookRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_40bd7925372a20e3, []int{8}
}

func (m *CreateBookRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateBookRequest.Unmarshal(m, b)
}
func (m *CreateBookRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateBookRequest.Marshal(b, m, deterministic)
}
func (m *CreateBookRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateBookRequest.Merge(m, src)
}
func (m *CreateBookRequest) XXX_Size() int {
	return xxx_messageInfo_CreateBookRequest.Size(m)
}
func (m *CreateBookRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateBookRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateBookRequest proto.InternalMessageInfo

func (m *CreateBookRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *CreateBookRequest) GetBook() *Book {
	if m != nil {
		return m.Book
	}
	return nil
}

// Request message for LibraryService.GetBook.
type GetBookRequest struct {
	// The name of the book to retrieve.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetBookRequest) Reset()         { *m = GetBookRequest{} }
func (m *GetBookRequest) String() string { return proto.CompactTextString(m) }
func (*GetBookRequest) ProtoMessage()    {}
func (*GetBookRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_40bd7925372a20e3, []int{9}
}

func (m *GetBookRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetBookRequest.Unmarshal(m, b)
}
func (m *GetBookRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetBookRequest.Marshal(b, m, deterministic)
}
func (m *GetBookRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetBookRequest.Merge(m, src)
}
func (m *GetBookRequest) XXX_Size() int {
	return xxx_messageInfo_GetBookRequest.Size(m)
}
func (m *GetBookRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetBookRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetBookRequest proto.InternalMessageInfo

func (m *GetBookRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for LibraryService.ListBooks.
type ListBooksRequest struct {
	// The name of the shelf whose books we'd like to list.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Requested page size. Server may return fewer books than requested.
	// If unspecified, server will pick an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A token identifying a page of results the server should return.
	// Typically, this is the value of
	// [ListBooksResponse.next_page_token][google.example.library.v1.ListBooksResponse.next_page_token].
	// returned from the previous call to `ListBooks` method.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListBooksRequest) Reset()         { *m = ListBooksRequest{} }
func (m *ListBooksRequest) String() string { return proto.CompactTextString(m) }
func (*ListBooksRequest) ProtoMessage()    {}
func (*ListBooksRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_40bd7925372a20e3, []int{10}
}

func (m *ListBooksRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListBooksRequest.Unmarshal(m, b)
}
func (m *ListBooksRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListBooksRequest.Marshal(b, m, deterministic)
}
func (m *ListBooksRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListBooksRequest.Merge(m, src)
}
func (m *ListBooksRequest) XXX_Size() int {
	return xxx_messageInfo_ListBooksRequest.Size(m)
}
func (m *ListBooksRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListBooksRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListBooksRequest proto.InternalMessageInfo

func (m *ListBooksRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *ListBooksRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListBooksRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// Response message for LibraryService.ListBooks.
type ListBooksResponse struct {
	// The list of books.
	Books []*Book `protobuf:"bytes,1,rep,name=books,proto3" json:"books,omitempty"`
	// A token to retrieve next page of results.
	// Pass this value in the
	// [ListBooksRequest.page_token][google.example.library.v1.ListBooksRequest.page_token]
	// field in the subsequent call to `ListBooks` method to retrieve the next
	// page of results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListBooksResponse) Reset()         { *m = ListBooksResponse{} }
func (m *ListBooksResponse) String() string { return proto.CompactTextString(m) }
func (*ListBooksResponse) ProtoMessage()    {}
func (*ListBooksResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_40bd7925372a20e3, []int{11}
}

func (m *ListBooksResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListBooksResponse.Unmarshal(m, b)
}
func (m *ListBooksResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListBooksResponse.Marshal(b, m, deterministic)
}
func (m *ListBooksResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListBooksResponse.Merge(m, src)
}
func (m *ListBooksResponse) XXX_Size() int {
	return xxx_messageInfo_ListBooksResponse.Size(m)
}
func (m *ListBooksResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListBooksResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListBooksResponse proto.InternalMessageInfo

func (m *ListBooksResponse) GetBooks() []*Book {
	if m != nil {
		return m.Books
	}
	return nil
}

func (m *ListBooksResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for LibraryService.UpdateBook.
type UpdateBookRequest struct {
	// The name of the book to update.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The book to update with. The name must match or be empty.
	Book                 *Book    `protobuf:"bytes,2,opt,name=book,proto3" json:"book,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateBookRequest) Reset()         { *m = UpdateBookRequest{} }
func (m *UpdateBookRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateBookRequest) ProtoMessage()    {}
func (*UpdateBookRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_40bd7925372a20e3, []int{12}
}

func (m *UpdateBookRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateBookRequest.Unmarshal(m, b)
}
func (m *UpdateBookRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateBookRequest.Marshal(b, m, deterministic)
}
func (m *UpdateBookRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateBookRequest.Merge(m, src)
}
func (m *UpdateBookRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateBookRequest.Size(m)
}
func (m *UpdateBookRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateBookRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateBookRequest proto.InternalMessageInfo

func (m *UpdateBookRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *UpdateBookRequest) GetBook() *Book {
	if m != nil {
		return m.Book
	}
	return nil
}

// Request message for LibraryService.DeleteBook.
type DeleteBookRequest struct {
	// The name of the book to delete.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteBookRequest) Reset()         { *m = DeleteBookRequest{} }
func (m *DeleteBookRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteBookRequest) ProtoMessage()    {}
func (*DeleteBookRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_40bd7925372a20e3, []int{13}
}

func (m *DeleteBookRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteBookRequest.Unmarshal(m, b)
}
func (m *DeleteBookRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteBookRequest.Marshal(b, m, deterministic)
}
func (m *DeleteBookRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteBookRequest.Merge(m, src)
}
func (m *DeleteBookRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteBookRequest.Size(m)
}
func (m *DeleteBookRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteBookRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteBookRequest proto.InternalMessageInfo

func (m *DeleteBookRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Describes what book to move (name) and what shelf we're moving it
// to (other_shelf_name).
type MoveBookRequest struct {
	// The name of the book to move.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The name of the destination shelf.
	OtherShelfName       string   `protobuf:"bytes,2,opt,name=other_shelf_name,json=otherShelfName,proto3" json:"other_shelf_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MoveBookRequest) Reset()         { *m = MoveBookRequest{} }
func (m *MoveBookRequest) String() string { return proto.CompactTextString(m) }
func (*MoveBookRequest) ProtoMessage()    {}
func (*MoveBookRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_40bd7925372a20e3, []int{14}
}

func (m *MoveBookRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MoveBookRequest.Unmarshal(m, b)
}
func (m *MoveBookRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MoveBookRequest.Marshal(b, m, deterministic)
}
func (m *MoveBookRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MoveBookRequest.Merge(m, src)
}
func (m *MoveBookRequest) XXX_Size() int {
	return xxx_messageInfo_MoveBookRequest.Size(m)
}
func (m *MoveBookRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MoveBookRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MoveBookRequest proto.InternalMessageInfo

func (m *MoveBookRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *MoveBookRequest) GetOtherShelfName() string {
	if m != nil {
		return m.OtherShelfName
	}
	return ""
}

func init() {
	proto.RegisterType((*Book)(nil), "google.example.library.v1.Book")
	proto.RegisterType((*Shelf)(nil), "google.example.library.v1.Shelf")
	proto.RegisterType((*CreateShelfRequest)(nil), "google.example.library.v1.CreateShelfRequest")
	proto.RegisterType((*GetShelfRequest)(nil), "google.example.library.v1.GetShelfRequest")
	proto.RegisterType((*ListShelvesRequest)(nil), "google.example.library.v1.ListShelvesRequest")
	proto.RegisterType((*ListShelvesResponse)(nil), "google.example.library.v1.ListShelvesResponse")
	proto.RegisterType((*DeleteShelfRequest)(nil), "google.example.library.v1.DeleteShelfRequest")
	proto.RegisterType((*MergeShelvesRequest)(nil), "google.example.library.v1.MergeShelvesRequest")
	proto.RegisterType((*CreateBookRequest)(nil), "google.example.library.v1.CreateBookRequest")
	proto.RegisterType((*GetBookRequest)(nil), "google.example.library.v1.GetBookRequest")
	proto.RegisterType((*ListBooksRequest)(nil), "google.example.library.v1.ListBooksRequest")
	proto.RegisterType((*ListBooksResponse)(nil), "google.example.library.v1.ListBooksResponse")
	proto.RegisterType((*UpdateBookRequest)(nil), "google.example.library.v1.UpdateBookRequest")
	proto.RegisterType((*DeleteBookRequest)(nil), "google.example.library.v1.DeleteBookRequest")
	proto.RegisterType((*MoveBookRequest)(nil), "google.example.library.v1.MoveBookRequest")
}

func init() {
	proto.RegisterFile("google/example/library/v1/library.proto", fileDescriptor_40bd7925372a20e3)
}

var fileDescriptor_40bd7925372a20e3 = []byte{
	// 838 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x56, 0xdb, 0x4e, 0xdb, 0x48,
	0x18, 0x96, 0x21, 0x81, 0xf0, 0x87, 0x53, 0x06, 0x84, 0xb2, 0x26, 0x2c, 0xd9, 0x11, 0x87, 0x6c,
	0x96, 0xb5, 0x05, 0x68, 0xf7, 0x22, 0x55, 0xa5, 0x8a, 0xb6, 0xe2, 0x06, 0xda, 0x28, 0x69, 0x6f,
	0x2a, 0xa4, 0xc8, 0x81, 0xc1, 0xb1, 0x48, 0x3c, 0xc6, 0x36, 0x11, 0x07, 0xf5, 0xa2, 0x95, 0x10,
	0x52, 0x6f, 0xfb, 0x0a, 0x7d, 0xa3, 0xbe, 0x42, 0x1f, 0xa4, 0x9a, 0x83, 0xc1, 0x24, 0x66, 0x9c,
	0x5e, 0xf4, 0xce, 0x33, 0xf3, 0xcd, 0xf7, 0x7f, 0xff, 0x61, 0xbe, 0x04, 0x36, 0x6d, 0x4a, 0xed,
	0x2e, 0x31, 0xc9, 0xa5, 0xd5, 0xf3, 0xba, 0xc4, 0xec, 0x3a, 0x6d, 0xdf, 0xf2, 0xaf, 0xcc, 0xfe,
	0x76, 0xf4, 0x69, 0x78, 0x3e, 0x0d, 0x29, 0xfa, 0x43, 0x00, 0x0d, 0x09, 0x34, 0xa2, 0xd3, 0xfe,
	0xb6, 0x5e, 0x92, 0x1c, 0x96, 0xe7, 0x98, 0x96, 0xeb, 0xd2, 0xd0, 0x0a, 0x1d, 0xea, 0x06, 0xe2,
	0xa2, 0xbe, 0x2c, 0x4f, 0xf9, 0xaa, 0x7d, 0x71, 0x6a, 0x92, 0x9e, 0x17, 0x4a, 0x56, 0x7c, 0x04,
	0x99, 0x3d, 0x4a, 0xcf, 0x10, 0x82, 0x8c, 0x6b, 0xf5, 0x48, 0x51, 0x2b, 0x6b, 0x95, 0xa9, 0x06,
	0xff, 0x46, 0x4b, 0x30, 0x61, 0x5d, 0x84, 0x1d, 0xea, 0x17, 0xc7, 0xf8, 0xae, 0x5c, 0xa1, 0x45,
	0xc8, 0x86, 0x4e, 0xd8, 0x25, 0xc5, 0x71, 0xbe, 0x2d, 0x16, 0x8c, 0xc1, 0x27, 0xd6, 0x49, 0x31,
	0x53, 0xd6, 0x2a, 0xb9, 0x06, 0xff, 0xc6, 0xdb, 0x90, 0x6d, 0x76, 0x48, 0xf7, 0x34, 0x91, 0x9e,
	0xd1, 0x74, 0x48, 0x8f, 0x48, 0x76, 0xb1, 0xc0, 0x07, 0x80, 0x5e, 0xfa, 0xc4, 0x0a, 0x09, 0xbf,
	0xd8, 0x20, 0xe7, 0x17, 0x24, 0x08, 0xd1, 0xff, 0x90, 0x0d, 0xd8, 0x9a, 0x13, 0xe4, 0x77, 0xca,
	0xc6, 0x93, 0xc5, 0x30, 0xc4, 0x3d, 0x01, 0xc7, 0xeb, 0x30, 0xb7, 0x4f, 0xc2, 0x47, 0x54, 0x09,
	0x52, 0x70, 0x1d, 0xd0, 0x81, 0x13, 0x70, 0x5c, 0x9f, 0x04, 0x11, 0x72, 0x19, 0xa6, 0x3c, 0xcb,
	0x26, 0xad, 0xc0, 0xb9, 0x16, 0xf0, 0x6c, 0x23, 0xc7, 0x36, 0x9a, 0xce, 0x35, 0x41, 0x2b, 0x00,
	0xfc, 0x30, 0xa4, 0x67, 0xc4, 0x95, 0x29, 0x70, 0xf8, 0x3b, 0xb6, 0x81, 0xaf, 0x60, 0xe1, 0x11,
	0x63, 0xe0, 0x51, 0x37, 0x20, 0xa8, 0x06, 0x93, 0x81, 0xd8, 0x2a, 0x6a, 0xe5, 0xf1, 0x91, 0x32,
	0x89, 0x2e, 0xa0, 0x0d, 0x98, 0x73, 0xc9, 0x65, 0xd8, 0x1a, 0x0a, 0x3b, 0xc3, 0xb6, 0xeb, 0xf7,
	0xa1, 0x2b, 0x80, 0x5e, 0x91, 0x2e, 0x19, 0xa8, 0x60, 0x52, 0xda, 0x4d, 0x58, 0x38, 0x24, 0xbe,
	0x4d, 0x06, 0xf2, 0x4e, 0x6a, 0x56, 0x05, 0xe6, 0x69, 0xd8, 0x21, 0x7e, 0x8b, 0xd7, 0xb5, 0xc5,
	0xcf, 0x45, 0xf4, 0x59, 0xbe, 0xcf, 0x63, 0xbd, 0x61, 0xa4, 0x47, 0x50, 0x10, 0x0d, 0x64, 0x73,
	0xa5, 0xa2, 0xdc, 0x85, 0x4c, 0x9b, 0xd2, 0x33, 0x4e, 0x93, 0xdf, 0x59, 0x55, 0x14, 0x82, 0x33,
	0x71, 0x30, 0x5e, 0x83, 0xd9, 0x7d, 0x12, 0xa6, 0x50, 0xe3, 0x36, 0xcc, 0xb3, 0xea, 0x33, 0x98,
	0x32, 0xab, 0x47, 0x1d, 0x1e, 0x53, 0x76, 0x78, 0x7c, 0xb0, 0xc3, 0x3e, 0x14, 0x62, 0x31, 0x64,
	0x7f, 0xff, 0x83, 0x2c, 0x93, 0x19, 0x75, 0x37, 0x35, 0x29, 0x81, 0x1e, 0xb9, 0xb5, 0x47, 0x50,
	0x78, 0xef, 0x9d, 0xfc, 0xae, 0xda, 0x6e, 0x42, 0x41, 0x0c, 0x4e, 0x5a, 0x79, 0xdf, 0xc2, 0xdc,
	0x21, 0xed, 0xa7, 0x8a, 0x18, 0x79, 0x66, 0x76, 0xbe, 0xe5, 0x61, 0xf6, 0x40, 0x68, 0x6a, 0x12,
	0xbf, 0xef, 0x1c, 0x13, 0x74, 0x0d, 0xf9, 0x98, 0x0f, 0xa0, 0x7f, 0x15, 0x29, 0x0c, 0xfb, 0x85,
	0x9e, 0xfa, 0xac, 0xb0, 0xfe, 0xf9, 0xfb, 0x8f, 0xaf, 0x63, 0x8b, 0x38, 0xcf, 0x9c, 0x56, 0x3e,
	0xb1, 0x9a, 0x70, 0x0d, 0xd4, 0x87, 0x5c, 0xe4, 0x1a, 0xa8, 0xaa, 0x60, 0x1a, 0xb0, 0x96, 0x11,
	0xa2, 0x96, 0x78, 0xd4, 0x25, 0xb4, 0xc8, 0xa2, 0xde, 0xb0, 0x8a, 0x3c, 0x97, 0xb1, 0xcd, 0xea,
	0x47, 0xf4, 0x49, 0x83, 0x7c, 0xcc, 0x35, 0x94, 0x49, 0x0f, 0xfb, 0x95, 0x6e, 0x8c, 0x0a, 0x17,
	0xc3, 0x8a, 0x17, 0xb8, 0x98, 0x19, 0x14, 0x2f, 0x01, 0xf2, 0x21, 0x1f, 0x73, 0x0f, 0xa5, 0x84,
	0x61, 0x97, 0xd1, 0x97, 0x22, 0x78, 0xf4, 0x63, 0x63, 0xbc, 0x66, 0x3f, 0x36, 0x51, 0xde, 0xd5,
	0xe4, 0xbc, 0xef, 0x34, 0x98, 0x8e, 0x1b, 0x11, 0x52, 0x65, 0x92, 0xe0, 0x58, 0x23, 0x14, 0x7e,
	0x9d, 0x0b, 0x58, 0xc5, 0x7a, 0x92, 0x80, 0x5a, 0x8f, 0x71, 0xd6, 0xb4, 0x2a, 0xba, 0xd5, 0x00,
	0x1e, 0xdc, 0x0b, 0x6d, 0xa5, 0x4e, 0x5d, 0xec, 0x0d, 0xe8, 0x69, 0xcf, 0x0c, 0x57, 0xb8, 0x08,
	0x9c, 0x2c, 0xc2, 0xe4, 0x56, 0x50, 0xe3, 0x4f, 0x11, 0xdd, 0xc0, 0xa4, 0xb4, 0x39, 0xf4, 0xb7,
	0x7a, 0x00, 0x7f, 0x49, 0xc0, 0x1a, 0x17, 0xf0, 0x27, 0x2a, 0x25, 0x08, 0x10, 0xf1, 0x59, 0x3b,
	0xbe, 0x68, 0x30, 0x75, 0x6f, 0x6d, 0xe8, 0x9f, 0x94, 0xa9, 0x8a, 0x9b, 0xac, 0xbe, 0x35, 0x1a,
	0x58, 0x0e, 0x20, 0xe6, 0x72, 0x4a, 0x48, 0x51, 0x0f, 0x74, 0x09, 0xf0, 0x60, 0x4a, 0xca, 0x86,
	0x0c, 0x79, 0xd7, 0x93, 0xd3, 0x28, 0xcb, 0x50, 0x55, 0x97, 0xe1, 0x4e, 0x03, 0x78, 0x70, 0x5b,
	0x65, 0xe8, 0x21, 0x53, 0x4e, 0x6f, 0x45, 0x95, 0x6b, 0x58, 0xd3, 0x95, 0x1a, 0xe4, 0x34, 0xdc,
	0x6a, 0x90, 0x8b, 0x0c, 0x57, 0x69, 0x48, 0x03, 0xae, 0x9c, 0xae, 0x62, 0x8b, 0xab, 0xd8, 0xc0,
	0x7f, 0x29, 0x55, 0xf4, 0x68, 0x9f, 0xbd, 0x8e, 0xbd, 0x73, 0x58, 0x39, 0xa6, 0xbd, 0xa7, 0x39,
	0xf7, 0xa6, 0xa5, 0x89, 0xd7, 0x59, 0xbd, 0xeb, 0xda, 0x87, 0x17, 0x12, 0x6a, 0xd3, 0xae, 0xe5,
	0xda, 0x06, 0xf5, 0x6d, 0xd3, 0x26, 0x2e, 0xef, 0x86, 0x29, 0x8e, 0x2c, 0xcf, 0x09, 0x12, 0xfe,
	0xfb, 0x3e, 0x93, 0x9f, 0xed, 0x09, 0x0e, 0xde, 0xfd, 0x19, 0x00, 0x00, 0xff, 0xff, 0x2b, 0x13,
	0xc5, 0x7e, 0x27, 0x0b, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// LibraryServiceClient is the client API for LibraryService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type LibraryServiceClient interface {
	// Creates a shelf, and returns the new Shelf.
	CreateShelf(ctx context.Context, in *CreateShelfRequest, opts ...grpc.CallOption) (*Shelf, error)
	// Gets a shelf. Returns NOT_FOUND if the shelf does not exist.
	GetShelf(ctx context.Context, in *GetShelfRequest, opts ...grpc.CallOption) (*Shelf, error)
	// Lists shelves. The order is unspecified but deterministic. Newly created
	// shelves will not necessarily be added to the end of this list.
	ListShelves(ctx context.Context, in *ListShelvesRequest, opts ...grpc.CallOption) (*ListShelvesResponse, error)
	// Deletes a shelf. Returns NOT_FOUND if the shelf does not exist.
	DeleteShelf(ctx context.Context, in *DeleteShelfRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Merges two shelves by adding all books from the shelf named
	// `other_shelf_name` to shelf `name`, and deletes
	// `other_shelf_name`. Returns the updated shelf.
	// The book ids of the moved books may not be the same as the original books.
	//
	// Returns NOT_FOUND if either shelf does not exist.
	// This call is a no-op if the specified shelves are the same.
	MergeShelves(ctx context.Context, in *MergeShelvesRequest, opts ...grpc.CallOption) (*Shelf, error)
	// Creates a book, and returns the new Book.
	CreateBook(ctx context.Context, in *CreateBookRequest, opts ...grpc.CallOption) (*Book, error)
	// Gets a book. Returns NOT_FOUND if the book does not exist.
	GetBook(ctx context.Context, in *GetBookRequest, opts ...grpc.CallOption) (*Book, error)
	// Lists books in a shelf. The order is unspecified but deterministic. Newly
	// created books will not necessarily be added to the end of this list.
	// Returns NOT_FOUND if the shelf does not exist.
	ListBooks(ctx context.Context, in *ListBooksRequest, opts ...grpc.CallOption) (*ListBooksResponse, error)
	// Deletes a book. Returns NOT_FOUND if the book does not exist.
	DeleteBook(ctx context.Context, in *DeleteBookRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Updates a book. Returns INVALID_ARGUMENT if the name of the book
	// is non-empty and does equal the previous name.
	UpdateBook(ctx context.Context, in *UpdateBookRequest, opts ...grpc.CallOption) (*Book, error)
	// Moves a book to another shelf, and returns the new book. The book
	// id of the new book may not be the same as the original book.
	MoveBook(ctx context.Context, in *MoveBookRequest, opts ...grpc.CallOption) (*Book, error)
}

type libraryServiceClient struct {
	cc *grpc.ClientConn
}

func NewLibraryServiceClient(cc *grpc.ClientConn) LibraryServiceClient {
	return &libraryServiceClient{cc}
}

func (c *libraryServiceClient) CreateShelf(ctx context.Context, in *CreateShelfRequest, opts ...grpc.CallOption) (*Shelf, error) {
	out := new(Shelf)
	err := c.cc.Invoke(ctx, "/google.example.library.v1.LibraryService/CreateShelf", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *libraryServiceClient) GetShelf(ctx context.Context, in *GetShelfRequest, opts ...grpc.CallOption) (*Shelf, error) {
	out := new(Shelf)
	err := c.cc.Invoke(ctx, "/google.example.library.v1.LibraryService/GetShelf", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *libraryServiceClient) ListShelves(ctx context.Context, in *ListShelvesRequest, opts ...grpc.CallOption) (*ListShelvesResponse, error) {
	out := new(ListShelvesResponse)
	err := c.cc.Invoke(ctx, "/google.example.library.v1.LibraryService/ListShelves", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *libraryServiceClient) DeleteShelf(ctx context.Context, in *DeleteShelfRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.example.library.v1.LibraryService/DeleteShelf", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *libraryServiceClient) MergeShelves(ctx context.Context, in *MergeShelvesRequest, opts ...grpc.CallOption) (*Shelf, error) {
	out := new(Shelf)
	err := c.cc.Invoke(ctx, "/google.example.library.v1.LibraryService/MergeShelves", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *libraryServiceClient) CreateBook(ctx context.Context, in *CreateBookRequest, opts ...grpc.CallOption) (*Book, error) {
	out := new(Book)
	err := c.cc.Invoke(ctx, "/google.example.library.v1.LibraryService/CreateBook", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *libraryServiceClient) GetBook(ctx context.Context, in *GetBookRequest, opts ...grpc.CallOption) (*Book, error) {
	out := new(Book)
	err := c.cc.Invoke(ctx, "/google.example.library.v1.LibraryService/GetBook", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *libraryServiceClient) ListBooks(ctx context.Context, in *ListBooksRequest, opts ...grpc.CallOption) (*ListBooksResponse, error) {
	out := new(ListBooksResponse)
	err := c.cc.Invoke(ctx, "/google.example.library.v1.LibraryService/ListBooks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *libraryServiceClient) DeleteBook(ctx context.Context, in *DeleteBookRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.example.library.v1.LibraryService/DeleteBook", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *libraryServiceClient) UpdateBook(ctx context.Context, in *UpdateBookRequest, opts ...grpc.CallOption) (*Book, error) {
	out := new(Book)
	err := c.cc.Invoke(ctx, "/google.example.library.v1.LibraryService/UpdateBook", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *libraryServiceClient) MoveBook(ctx context.Context, in *MoveBookRequest, opts ...grpc.CallOption) (*Book, error) {
	out := new(Book)
	err := c.cc.Invoke(ctx, "/google.example.library.v1.LibraryService/MoveBook", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// LibraryServiceServer is the server API for LibraryService service.
type LibraryServiceServer interface {
	// Creates a shelf, and returns the new Shelf.
	CreateShelf(context.Context, *CreateShelfRequest) (*Shelf, error)
	// Gets a shelf. Returns NOT_FOUND if the shelf does not exist.
	GetShelf(context.Context, *GetShelfRequest) (*Shelf, error)
	// Lists shelves. The order is unspecified but deterministic. Newly created
	// shelves will not necessarily be added to the end of this list.
	ListShelves(context.Context, *ListShelvesRequest) (*ListShelvesResponse, error)
	// Deletes a shelf. Returns NOT_FOUND if the shelf does not exist.
	DeleteShelf(context.Context, *DeleteShelfRequest) (*empty.Empty, error)
	// Merges two shelves by adding all books from the shelf named
	// `other_shelf_name` to shelf `name`, and deletes
	// `other_shelf_name`. Returns the updated shelf.
	// The book ids of the moved books may not be the same as the original books.
	//
	// Returns NOT_FOUND if either shelf does not exist.
	// This call is a no-op if the specified shelves are the same.
	MergeShelves(context.Context, *MergeShelvesRequest) (*Shelf, error)
	// Creates a book, and returns the new Book.
	CreateBook(context.Context, *CreateBookRequest) (*Book, error)
	// Gets a book. Returns NOT_FOUND if the book does not exist.
	GetBook(context.Context, *GetBookRequest) (*Book, error)
	// Lists books in a shelf. The order is unspecified but deterministic. Newly
	// created books will not necessarily be added to the end of this list.
	// Returns NOT_FOUND if the shelf does not exist.
	ListBooks(context.Context, *ListBooksRequest) (*ListBooksResponse, error)
	// Deletes a book. Returns NOT_FOUND if the book does not exist.
	DeleteBook(context.Context, *DeleteBookRequest) (*empty.Empty, error)
	// Updates a book. Returns INVALID_ARGUMENT if the name of the book
	// is non-empty and does equal the previous name.
	UpdateBook(context.Context, *UpdateBookRequest) (*Book, error)
	// Moves a book to another shelf, and returns the new book. The book
	// id of the new book may not be the same as the original book.
	MoveBook(context.Context, *MoveBookRequest) (*Book, error)
}

func RegisterLibraryServiceServer(s *grpc.Server, srv LibraryServiceServer) {
	s.RegisterService(&_LibraryService_serviceDesc, srv)
}

func _LibraryService_CreateShelf_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateShelfRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LibraryServiceServer).CreateShelf(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.example.library.v1.LibraryService/CreateShelf",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LibraryServiceServer).CreateShelf(ctx, req.(*CreateShelfRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LibraryService_GetShelf_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetShelfRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LibraryServiceServer).GetShelf(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.example.library.v1.LibraryService/GetShelf",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LibraryServiceServer).GetShelf(ctx, req.(*GetShelfRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LibraryService_ListShelves_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListShelvesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LibraryServiceServer).ListShelves(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.example.library.v1.LibraryService/ListShelves",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LibraryServiceServer).ListShelves(ctx, req.(*ListShelvesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LibraryService_DeleteShelf_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteShelfRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LibraryServiceServer).DeleteShelf(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.example.library.v1.LibraryService/DeleteShelf",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LibraryServiceServer).DeleteShelf(ctx, req.(*DeleteShelfRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LibraryService_MergeShelves_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MergeShelvesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LibraryServiceServer).MergeShelves(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.example.library.v1.LibraryService/MergeShelves",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LibraryServiceServer).MergeShelves(ctx, req.(*MergeShelvesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LibraryService_CreateBook_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateBookRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LibraryServiceServer).CreateBook(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.example.library.v1.LibraryService/CreateBook",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LibraryServiceServer).CreateBook(ctx, req.(*CreateBookRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LibraryService_GetBook_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBookRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LibraryServiceServer).GetBook(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.example.library.v1.LibraryService/GetBook",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LibraryServiceServer).GetBook(ctx, req.(*GetBookRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LibraryService_ListBooks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBooksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LibraryServiceServer).ListBooks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.example.library.v1.LibraryService/ListBooks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LibraryServiceServer).ListBooks(ctx, req.(*ListBooksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LibraryService_DeleteBook_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteBookRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LibraryServiceServer).DeleteBook(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.example.library.v1.LibraryService/DeleteBook",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LibraryServiceServer).DeleteBook(ctx, req.(*DeleteBookRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LibraryService_UpdateBook_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateBookRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LibraryServiceServer).UpdateBook(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.example.library.v1.LibraryService/UpdateBook",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LibraryServiceServer).UpdateBook(ctx, req.(*UpdateBookRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LibraryService_MoveBook_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MoveBookRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LibraryServiceServer).MoveBook(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.example.library.v1.LibraryService/MoveBook",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LibraryServiceServer).MoveBook(ctx, req.(*MoveBookRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _LibraryService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.example.library.v1.LibraryService",
	HandlerType: (*LibraryServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateShelf",
			Handler:    _LibraryService_CreateShelf_Handler,
		},
		{
			MethodName: "GetShelf",
			Handler:    _LibraryService_GetShelf_Handler,
		},
		{
			MethodName: "ListShelves",
			Handler:    _LibraryService_ListShelves_Handler,
		},
		{
			MethodName: "DeleteShelf",
			Handler:    _LibraryService_DeleteShelf_Handler,
		},
		{
			MethodName: "MergeShelves",
			Handler:    _LibraryService_MergeShelves_Handler,
		},
		{
			MethodName: "CreateBook",
			Handler:    _LibraryService_CreateBook_Handler,
		},
		{
			MethodName: "GetBook",
			Handler:    _LibraryService_GetBook_Handler,
		},
		{
			MethodName: "ListBooks",
			Handler:    _LibraryService_ListBooks_Handler,
		},
		{
			MethodName: "DeleteBook",
			Handler:    _LibraryService_DeleteBook_Handler,
		},
		{
			MethodName: "UpdateBook",
			Handler:    _LibraryService_UpdateBook_Handler,
		},
		{
			MethodName: "MoveBook",
			Handler:    _LibraryService_MoveBook_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/example/library/v1/library.proto",
}
