// +build go1.9

// Copyright 2019 Microsoft Corporation
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package eventgrid

import original "github.com/Azure/azure-sdk-for-go/services/preview/eventgrid/mgmt/2018-09-15-preview/eventgrid"

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type BaseClient = original.BaseClient
type DomainsClient = original.DomainsClient
type DomainTopicsClient = original.DomainTopicsClient
type EventSubscriptionsClient = original.EventSubscriptionsClient
type DomainProvisioningState = original.DomainProvisioningState

const (
	Canceled  DomainProvisioningState = original.Canceled
	Creating  DomainProvisioningState = original.Creating
	Deleting  DomainProvisioningState = original.Deleting
	Failed    DomainProvisioningState = original.Failed
	Succeeded DomainProvisioningState = original.Succeeded
	Updating  DomainProvisioningState = original.Updating
)

type EndpointType = original.EndpointType

const (
	EndpointTypeEventHub                     EndpointType = original.EndpointTypeEventHub
	EndpointTypeEventSubscriptionDestination EndpointType = original.EndpointTypeEventSubscriptionDestination
	EndpointTypeHybridConnection             EndpointType = original.EndpointTypeHybridConnection
	EndpointTypeStorageQueue                 EndpointType = original.EndpointTypeStorageQueue
	EndpointTypeWebHook                      EndpointType = original.EndpointTypeWebHook
)

type EndpointTypeBasicDeadLetterDestination = original.EndpointTypeBasicDeadLetterDestination

const (
	EndpointTypeDeadLetterDestination EndpointTypeBasicDeadLetterDestination = original.EndpointTypeDeadLetterDestination
	EndpointTypeStorageBlob           EndpointTypeBasicDeadLetterDestination = original.EndpointTypeStorageBlob
)

type EventDeliverySchema = original.EventDeliverySchema

const (
	CloudEventV01Schema EventDeliverySchema = original.CloudEventV01Schema
	CustomInputSchema   EventDeliverySchema = original.CustomInputSchema
	EventGridSchema     EventDeliverySchema = original.EventGridSchema
)

type EventSubscriptionProvisioningState = original.EventSubscriptionProvisioningState

const (
	EventSubscriptionProvisioningStateAwaitingManualAction EventSubscriptionProvisioningState = original.EventSubscriptionProvisioningStateAwaitingManualAction
	EventSubscriptionProvisioningStateCanceled             EventSubscriptionProvisioningState = original.EventSubscriptionProvisioningStateCanceled
	EventSubscriptionProvisioningStateCreating             EventSubscriptionProvisioningState = original.EventSubscriptionProvisioningStateCreating
	EventSubscriptionProvisioningStateDeleting             EventSubscriptionProvisioningState = original.EventSubscriptionProvisioningStateDeleting
	EventSubscriptionProvisioningStateFailed               EventSubscriptionProvisioningState = original.EventSubscriptionProvisioningStateFailed
	EventSubscriptionProvisioningStateSucceeded            EventSubscriptionProvisioningState = original.EventSubscriptionProvisioningStateSucceeded
	EventSubscriptionProvisioningStateUpdating             EventSubscriptionProvisioningState = original.EventSubscriptionProvisioningStateUpdating
)

type InputSchema = original.InputSchema

const (
	InputSchemaCloudEventV01Schema InputSchema = original.InputSchemaCloudEventV01Schema
	InputSchemaCustomEventSchema   InputSchema = original.InputSchemaCustomEventSchema
	InputSchemaEventGridSchema     InputSchema = original.InputSchemaEventGridSchema
)

type InputSchemaMappingType = original.InputSchemaMappingType

const (
	InputSchemaMappingTypeInputSchemaMapping InputSchemaMappingType = original.InputSchemaMappingTypeInputSchemaMapping
	InputSchemaMappingTypeJSON               InputSchemaMappingType = original.InputSchemaMappingTypeJSON
)

type OperatorType = original.OperatorType

const (
	OperatorTypeAdvancedFilter            OperatorType = original.OperatorTypeAdvancedFilter
	OperatorTypeBoolEquals                OperatorType = original.OperatorTypeBoolEquals
	OperatorTypeNumberGreaterThan         OperatorType = original.OperatorTypeNumberGreaterThan
	OperatorTypeNumberGreaterThanOrEquals OperatorType = original.OperatorTypeNumberGreaterThanOrEquals
	OperatorTypeNumberIn                  OperatorType = original.OperatorTypeNumberIn
	OperatorTypeNumberLessThan            OperatorType = original.OperatorTypeNumberLessThan
	OperatorTypeNumberLessThanOrEquals    OperatorType = original.OperatorTypeNumberLessThanOrEquals
	OperatorTypeNumberNotIn               OperatorType = original.OperatorTypeNumberNotIn
	OperatorTypeStringBeginsWith          OperatorType = original.OperatorTypeStringBeginsWith
	OperatorTypeStringContains            OperatorType = original.OperatorTypeStringContains
	OperatorTypeStringEndsWith            OperatorType = original.OperatorTypeStringEndsWith
	OperatorTypeStringIn                  OperatorType = original.OperatorTypeStringIn
	OperatorTypeStringNotIn               OperatorType = original.OperatorTypeStringNotIn
)

type ResourceRegionType = original.ResourceRegionType

const (
	GlobalResource   ResourceRegionType = original.GlobalResource
	RegionalResource ResourceRegionType = original.RegionalResource
)

type TopicProvisioningState = original.TopicProvisioningState

const (
	TopicProvisioningStateCanceled  TopicProvisioningState = original.TopicProvisioningStateCanceled
	TopicProvisioningStateCreating  TopicProvisioningState = original.TopicProvisioningStateCreating
	TopicProvisioningStateDeleting  TopicProvisioningState = original.TopicProvisioningStateDeleting
	TopicProvisioningStateFailed    TopicProvisioningState = original.TopicProvisioningStateFailed
	TopicProvisioningStateSucceeded TopicProvisioningState = original.TopicProvisioningStateSucceeded
	TopicProvisioningStateUpdating  TopicProvisioningState = original.TopicProvisioningStateUpdating
)

type TopicTypeProvisioningState = original.TopicTypeProvisioningState

const (
	TopicTypeProvisioningStateCanceled  TopicTypeProvisioningState = original.TopicTypeProvisioningStateCanceled
	TopicTypeProvisioningStateCreating  TopicTypeProvisioningState = original.TopicTypeProvisioningStateCreating
	TopicTypeProvisioningStateDeleting  TopicTypeProvisioningState = original.TopicTypeProvisioningStateDeleting
	TopicTypeProvisioningStateFailed    TopicTypeProvisioningState = original.TopicTypeProvisioningStateFailed
	TopicTypeProvisioningStateSucceeded TopicTypeProvisioningState = original.TopicTypeProvisioningStateSucceeded
	TopicTypeProvisioningStateUpdating  TopicTypeProvisioningState = original.TopicTypeProvisioningStateUpdating
)

type BasicAdvancedFilter = original.BasicAdvancedFilter
type AdvancedFilter = original.AdvancedFilter
type BoolEqualsAdvancedFilter = original.BoolEqualsAdvancedFilter
type BasicDeadLetterDestination = original.BasicDeadLetterDestination
type DeadLetterDestination = original.DeadLetterDestination
type Domain = original.Domain
type DomainProperties = original.DomainProperties
type DomainRegenerateKeyRequest = original.DomainRegenerateKeyRequest
type DomainsCreateOrUpdateFuture = original.DomainsCreateOrUpdateFuture
type DomainsDeleteFuture = original.DomainsDeleteFuture
type DomainSharedAccessKeys = original.DomainSharedAccessKeys
type DomainsListResult = original.DomainsListResult
type DomainsUpdateFuture = original.DomainsUpdateFuture
type DomainTopic = original.DomainTopic
type DomainTopicsListResult = original.DomainTopicsListResult
type DomainUpdateParameters = original.DomainUpdateParameters
type EventHubEventSubscriptionDestination = original.EventHubEventSubscriptionDestination
type EventHubEventSubscriptionDestinationProperties = original.EventHubEventSubscriptionDestinationProperties
type EventSubscription = original.EventSubscription
type BasicEventSubscriptionDestination = original.BasicEventSubscriptionDestination
type EventSubscriptionDestination = original.EventSubscriptionDestination
type EventSubscriptionFilter = original.EventSubscriptionFilter
type EventSubscriptionFullURL = original.EventSubscriptionFullURL
type EventSubscriptionProperties = original.EventSubscriptionProperties
type EventSubscriptionsCreateOrUpdateFuture = original.EventSubscriptionsCreateOrUpdateFuture
type EventSubscriptionsDeleteFuture = original.EventSubscriptionsDeleteFuture
type EventSubscriptionsListResult = original.EventSubscriptionsListResult
type EventSubscriptionsUpdateFuture = original.EventSubscriptionsUpdateFuture
type EventSubscriptionUpdateParameters = original.EventSubscriptionUpdateParameters
type EventType = original.EventType
type EventTypeProperties = original.EventTypeProperties
type EventTypesListResult = original.EventTypesListResult
type HybridConnectionEventSubscriptionDestination = original.HybridConnectionEventSubscriptionDestination
type HybridConnectionEventSubscriptionDestinationProperties = original.HybridConnectionEventSubscriptionDestinationProperties
type BasicInputSchemaMapping = original.BasicInputSchemaMapping
type InputSchemaMapping = original.InputSchemaMapping
type JSONField = original.JSONField
type JSONFieldWithDefault = original.JSONFieldWithDefault
type JSONInputSchemaMapping = original.JSONInputSchemaMapping
type JSONInputSchemaMappingProperties = original.JSONInputSchemaMappingProperties
type NumberGreaterThanAdvancedFilter = original.NumberGreaterThanAdvancedFilter
type NumberGreaterThanOrEqualsAdvancedFilter = original.NumberGreaterThanOrEqualsAdvancedFilter
type NumberInAdvancedFilter = original.NumberInAdvancedFilter
type NumberLessThanAdvancedFilter = original.NumberLessThanAdvancedFilter
type NumberLessThanOrEqualsAdvancedFilter = original.NumberLessThanOrEqualsAdvancedFilter
type NumberNotInAdvancedFilter = original.NumberNotInAdvancedFilter
type Operation = original.Operation
type OperationInfo = original.OperationInfo
type OperationsListResult = original.OperationsListResult
type Resource = original.Resource
type RetryPolicy = original.RetryPolicy
type StorageBlobDeadLetterDestination = original.StorageBlobDeadLetterDestination
type StorageBlobDeadLetterDestinationProperties = original.StorageBlobDeadLetterDestinationProperties
type StorageQueueEventSubscriptionDestination = original.StorageQueueEventSubscriptionDestination
type StorageQueueEventSubscriptionDestinationProperties = original.StorageQueueEventSubscriptionDestinationProperties
type StringBeginsWithAdvancedFilter = original.StringBeginsWithAdvancedFilter
type StringContainsAdvancedFilter = original.StringContainsAdvancedFilter
type StringEndsWithAdvancedFilter = original.StringEndsWithAdvancedFilter
type StringInAdvancedFilter = original.StringInAdvancedFilter
type StringNotInAdvancedFilter = original.StringNotInAdvancedFilter
type Topic = original.Topic
type TopicProperties = original.TopicProperties
type TopicRegenerateKeyRequest = original.TopicRegenerateKeyRequest
type TopicsCreateOrUpdateFuture = original.TopicsCreateOrUpdateFuture
type TopicsDeleteFuture = original.TopicsDeleteFuture
type TopicSharedAccessKeys = original.TopicSharedAccessKeys
type TopicsListResult = original.TopicsListResult
type TopicsUpdateFuture = original.TopicsUpdateFuture
type TopicTypeInfo = original.TopicTypeInfo
type TopicTypeProperties = original.TopicTypeProperties
type TopicTypesListResult = original.TopicTypesListResult
type TopicUpdateParameters = original.TopicUpdateParameters
type TrackedResource = original.TrackedResource
type WebHookEventSubscriptionDestination = original.WebHookEventSubscriptionDestination
type WebHookEventSubscriptionDestinationProperties = original.WebHookEventSubscriptionDestinationProperties
type OperationsClient = original.OperationsClient
type TopicsClient = original.TopicsClient
type TopicTypesClient = original.TopicTypesClient

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func NewDomainsClient(subscriptionID string) DomainsClient {
	return original.NewDomainsClient(subscriptionID)
}
func NewDomainsClientWithBaseURI(baseURI string, subscriptionID string) DomainsClient {
	return original.NewDomainsClientWithBaseURI(baseURI, subscriptionID)
}
func NewDomainTopicsClient(subscriptionID string) DomainTopicsClient {
	return original.NewDomainTopicsClient(subscriptionID)
}
func NewDomainTopicsClientWithBaseURI(baseURI string, subscriptionID string) DomainTopicsClient {
	return original.NewDomainTopicsClientWithBaseURI(baseURI, subscriptionID)
}
func NewEventSubscriptionsClient(subscriptionID string) EventSubscriptionsClient {
	return original.NewEventSubscriptionsClient(subscriptionID)
}
func NewEventSubscriptionsClientWithBaseURI(baseURI string, subscriptionID string) EventSubscriptionsClient {
	return original.NewEventSubscriptionsClientWithBaseURI(baseURI, subscriptionID)
}
func PossibleDomainProvisioningStateValues() []DomainProvisioningState {
	return original.PossibleDomainProvisioningStateValues()
}
func PossibleEndpointTypeValues() []EndpointType {
	return original.PossibleEndpointTypeValues()
}
func PossibleEndpointTypeBasicDeadLetterDestinationValues() []EndpointTypeBasicDeadLetterDestination {
	return original.PossibleEndpointTypeBasicDeadLetterDestinationValues()
}
func PossibleEventDeliverySchemaValues() []EventDeliverySchema {
	return original.PossibleEventDeliverySchemaValues()
}
func PossibleEventSubscriptionProvisioningStateValues() []EventSubscriptionProvisioningState {
	return original.PossibleEventSubscriptionProvisioningStateValues()
}
func PossibleInputSchemaValues() []InputSchema {
	return original.PossibleInputSchemaValues()
}
func PossibleInputSchemaMappingTypeValues() []InputSchemaMappingType {
	return original.PossibleInputSchemaMappingTypeValues()
}
func PossibleOperatorTypeValues() []OperatorType {
	return original.PossibleOperatorTypeValues()
}
func PossibleResourceRegionTypeValues() []ResourceRegionType {
	return original.PossibleResourceRegionTypeValues()
}
func PossibleTopicProvisioningStateValues() []TopicProvisioningState {
	return original.PossibleTopicProvisioningStateValues()
}
func PossibleTopicTypeProvisioningStateValues() []TopicTypeProvisioningState {
	return original.PossibleTopicTypeProvisioningStateValues()
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewTopicsClient(subscriptionID string) TopicsClient {
	return original.NewTopicsClient(subscriptionID)
}
func NewTopicsClientWithBaseURI(baseURI string, subscriptionID string) TopicsClient {
	return original.NewTopicsClientWithBaseURI(baseURI, subscriptionID)
}
func NewTopicTypesClient(subscriptionID string) TopicTypesClient {
	return original.NewTopicTypesClient(subscriptionID)
}
func NewTopicTypesClientWithBaseURI(baseURI string, subscriptionID string) TopicTypesClient {
	return original.NewTopicTypesClientWithBaseURI(baseURI, subscriptionID)
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
