package sql

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"net/http"
)

// ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient is the the Azure SQL Database management API provides a
// RESTful set of web services that interact with Azure SQL Database services to manage your databases. The API enables
// you to create, retrieve, update, and delete databases.
type ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient struct {
	BaseClient
}

// NewManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient creates an instance of the
// ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient client.
func NewManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient(subscriptionID string) ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient {
	return NewManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientWithBaseURI creates an instance of the
// ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient client.
func NewManagedDatabaseVulnerabilityAssessmentRuleBaselinesClientWithBaseURI(baseURI string, subscriptionID string) ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient {
	return ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CreateOrUpdate creates or updates a database's vulnerability assessment rule baseline.
// Parameters:
// resourceGroupName - the name of the resource group that contains the resource. You can obtain this value
// from the Azure Resource Manager API or the portal.
// managedInstanceName - the name of the managed instance.
// databaseName - the name of the database for which the vulnerability assessment rule baseline is defined.
// ruleID - the vulnerability assessment rule ID.
// baselineName - the name of the vulnerability assessment rule baseline (default implies a baseline on a
// database level rule and master for server level rule).
// parameters - the requested rule baseline resource.
func (client ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient) CreateOrUpdate(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, ruleID string, baselineName VulnerabilityAssessmentPolicyBaselineName, parameters DatabaseVulnerabilityAssessmentRuleBaseline) (result DatabaseVulnerabilityAssessmentRuleBaseline, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.DatabaseVulnerabilityAssessmentRuleBaselineProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "parameters.DatabaseVulnerabilityAssessmentRuleBaselineProperties.BaselineResults", Name: validation.Null, Rule: true, Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("sql.ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient", "CreateOrUpdate", err.Error())
	}

	req, err := client.CreateOrUpdatePreparer(ctx, resourceGroupName, managedInstanceName, databaseName, ruleID, baselineName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient", "CreateOrUpdate", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient", "CreateOrUpdate", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient", "CreateOrUpdate", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdatePreparer prepares the CreateOrUpdate request.
func (client ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient) CreateOrUpdatePreparer(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, ruleID string, baselineName VulnerabilityAssessmentPolicyBaselineName, parameters DatabaseVulnerabilityAssessmentRuleBaseline) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"baselineName":                autorest.Encode("path", baselineName),
		"databaseName":                autorest.Encode("path", databaseName),
		"managedInstanceName":         autorest.Encode("path", managedInstanceName),
		"resourceGroupName":           autorest.Encode("path", resourceGroupName),
		"ruleId":                      autorest.Encode("path", ruleID),
		"subscriptionId":              autorest.Encode("path", client.SubscriptionID),
		"vulnerabilityAssessmentName": autorest.Encode("path", "default"),
	}

	const APIVersion = "2017-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSender sends the CreateOrUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient) CreateOrUpdateSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateResponder handles the response to the CreateOrUpdate request. The method always
// closes the http.Response Body.
func (client ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient) CreateOrUpdateResponder(resp *http.Response) (result DatabaseVulnerabilityAssessmentRuleBaseline, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete removes the database's vulnerability assessment rule baseline.
// Parameters:
// resourceGroupName - the name of the resource group that contains the resource. You can obtain this value
// from the Azure Resource Manager API or the portal.
// managedInstanceName - the name of the managed instance.
// databaseName - the name of the database for which the vulnerability assessment rule baseline is defined.
// ruleID - the vulnerability assessment rule ID.
// baselineName - the name of the vulnerability assessment rule baseline (default implies a baseline on a
// database level rule and master for server level rule).
func (client ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient) Delete(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, ruleID string, baselineName VulnerabilityAssessmentPolicyBaselineName) (result autorest.Response, err error) {
	req, err := client.DeletePreparer(ctx, resourceGroupName, managedInstanceName, databaseName, ruleID, baselineName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient", "Delete", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "sql.ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient", "Delete", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient", "Delete", resp, "Failure responding to request")
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient) DeletePreparer(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, ruleID string, baselineName VulnerabilityAssessmentPolicyBaselineName) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"baselineName":                autorest.Encode("path", baselineName),
		"databaseName":                autorest.Encode("path", databaseName),
		"managedInstanceName":         autorest.Encode("path", managedInstanceName),
		"resourceGroupName":           autorest.Encode("path", resourceGroupName),
		"ruleId":                      autorest.Encode("path", ruleID),
		"subscriptionId":              autorest.Encode("path", client.SubscriptionID),
		"vulnerabilityAssessmentName": autorest.Encode("path", "default"),
	}

	const APIVersion = "2017-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient) DeleteSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get gets a database's vulnerability assessment rule baseline.
// Parameters:
// resourceGroupName - the name of the resource group that contains the resource. You can obtain this value
// from the Azure Resource Manager API or the portal.
// managedInstanceName - the name of the managed instance.
// databaseName - the name of the database for which the vulnerability assessment rule baseline is defined.
// ruleID - the vulnerability assessment rule ID.
// baselineName - the name of the vulnerability assessment rule baseline (default implies a baseline on a
// database level rule and master for server level rule).
func (client ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient) Get(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, ruleID string, baselineName VulnerabilityAssessmentPolicyBaselineName) (result DatabaseVulnerabilityAssessmentRuleBaseline, err error) {
	req, err := client.GetPreparer(ctx, resourceGroupName, managedInstanceName, databaseName, ruleID, baselineName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "sql.ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "sql.ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient) GetPreparer(ctx context.Context, resourceGroupName string, managedInstanceName string, databaseName string, ruleID string, baselineName VulnerabilityAssessmentPolicyBaselineName) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"baselineName":                autorest.Encode("path", baselineName),
		"databaseName":                autorest.Encode("path", databaseName),
		"managedInstanceName":         autorest.Encode("path", managedInstanceName),
		"resourceGroupName":           autorest.Encode("path", resourceGroupName),
		"ruleId":                      autorest.Encode("path", ruleID),
		"subscriptionId":              autorest.Encode("path", client.SubscriptionID),
		"vulnerabilityAssessmentName": autorest.Encode("path", "default"),
	}

	const APIVersion = "2017-10-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Sql/managedInstances/{managedInstanceName}/databases/{databaseName}/vulnerabilityAssessments/{vulnerabilityAssessmentName}/rules/{ruleId}/baselines/{baselineName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient) GetSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client ManagedDatabaseVulnerabilityAssessmentRuleBaselinesClient) GetResponder(resp *http.Response) (result DatabaseVulnerabilityAssessmentRuleBaseline, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
