// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/assistant/embedded/v1alpha2/embedded_assistant.proto

package embedded

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	context "golang.org/x/net/context"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	latlng "google.golang.org/genproto/googleapis/type/latlng"
	grpc "google.golang.org/grpc"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Indicates the type of event.
type AssistResponse_EventType int32

const (
	// No event specified.
	AssistResponse_EVENT_TYPE_UNSPECIFIED AssistResponse_EventType = 0
	// This event indicates that the server has detected the end of the user's
	// speech utterance and expects no additional speech. Therefore, the server
	// will not process additional audio (although it may subsequently return
	// additional results). The client should stop sending additional audio
	// data, half-close the gRPC connection, and wait for any additional results
	// until the server closes the gRPC connection.
	AssistResponse_END_OF_UTTERANCE AssistResponse_EventType = 1
)

var AssistResponse_EventType_name = map[int32]string{
	0: "EVENT_TYPE_UNSPECIFIED",
	1: "END_OF_UTTERANCE",
}

var AssistResponse_EventType_value = map[string]int32{
	"EVENT_TYPE_UNSPECIFIED": 0,
	"END_OF_UTTERANCE":       1,
}

func (x AssistResponse_EventType) String() string {
	return proto.EnumName(AssistResponse_EventType_name, int32(x))
}

func (AssistResponse_EventType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_a514007bdf931c71, []int{1, 0}
}

// Audio encoding of the data sent in the audio message.
// Audio must be one-channel (mono).
type AudioInConfig_Encoding int32

const (
	// Not specified. Will return result [google.rpc.Code.INVALID_ARGUMENT][].
	AudioInConfig_ENCODING_UNSPECIFIED AudioInConfig_Encoding = 0
	// Uncompressed 16-bit signed little-endian samples (Linear PCM).
	// This encoding includes no header, only the raw audio bytes.
	AudioInConfig_LINEAR16 AudioInConfig_Encoding = 1
	// [`FLAC`](https://xiph.org/flac/documentation.html) (Free Lossless Audio
	// Codec) is the recommended encoding because it is
	// lossless--therefore recognition is not compromised--and
	// requires only about half the bandwidth of `LINEAR16`. This encoding
	// includes the `FLAC` stream header followed by audio data. It supports
	// 16-bit and 24-bit samples, however, not all fields in `STREAMINFO` are
	// supported.
	AudioInConfig_FLAC AudioInConfig_Encoding = 2
)

var AudioInConfig_Encoding_name = map[int32]string{
	0: "ENCODING_UNSPECIFIED",
	1: "LINEAR16",
	2: "FLAC",
}

var AudioInConfig_Encoding_value = map[string]int32{
	"ENCODING_UNSPECIFIED": 0,
	"LINEAR16":             1,
	"FLAC":                 2,
}

func (x AudioInConfig_Encoding) String() string {
	return proto.EnumName(AudioInConfig_Encoding_name, int32(x))
}

func (AudioInConfig_Encoding) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_a514007bdf931c71, []int{4, 0}
}

// Audio encoding of the data returned in the audio message. All encodings are
// raw audio bytes with no header, except as indicated below.
type AudioOutConfig_Encoding int32

const (
	// Not specified. Will return result [google.rpc.Code.INVALID_ARGUMENT][].
	AudioOutConfig_ENCODING_UNSPECIFIED AudioOutConfig_Encoding = 0
	// Uncompressed 16-bit signed little-endian samples (Linear PCM).
	AudioOutConfig_LINEAR16 AudioOutConfig_Encoding = 1
	// MP3 audio encoding. The sample rate is encoded in the payload.
	AudioOutConfig_MP3 AudioOutConfig_Encoding = 2
	// Opus-encoded audio wrapped in an ogg container. The result will be a
	// file which can be played natively on Android and in some browsers (such
	// as Chrome). The quality of the encoding is considerably higher than MP3
	// while using the same bitrate. The sample rate is encoded in the payload.
	AudioOutConfig_OPUS_IN_OGG AudioOutConfig_Encoding = 3
)

var AudioOutConfig_Encoding_name = map[int32]string{
	0: "ENCODING_UNSPECIFIED",
	1: "LINEAR16",
	2: "MP3",
	3: "OPUS_IN_OGG",
}

var AudioOutConfig_Encoding_value = map[string]int32{
	"ENCODING_UNSPECIFIED": 0,
	"LINEAR16":             1,
	"MP3":                  2,
	"OPUS_IN_OGG":          3,
}

func (x AudioOutConfig_Encoding) String() string {
	return proto.EnumName(AudioOutConfig_Encoding_name, int32(x))
}

func (AudioOutConfig_Encoding) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_a514007bdf931c71, []int{5, 0}
}

// Possible modes for visual screen-output on the device.
type ScreenOutConfig_ScreenMode int32

const (
	// No video mode specified.
	// The Assistant may respond as if in `OFF` mode.
	ScreenOutConfig_SCREEN_MODE_UNSPECIFIED ScreenOutConfig_ScreenMode = 0
	// Screen is off (or has brightness or other settings set so low it is
	// not visible). The Assistant will typically not return a screen response
	// in this mode.
	ScreenOutConfig_OFF ScreenOutConfig_ScreenMode = 1
	// The Assistant will typically return a partial-screen response in this
	// mode.
	ScreenOutConfig_PLAYING ScreenOutConfig_ScreenMode = 3
)

var ScreenOutConfig_ScreenMode_name = map[int32]string{
	0: "SCREEN_MODE_UNSPECIFIED",
	1: "OFF",
	3: "PLAYING",
}

var ScreenOutConfig_ScreenMode_value = map[string]int32{
	"SCREEN_MODE_UNSPECIFIED": 0,
	"OFF":                     1,
	"PLAYING":                 3,
}

func (x ScreenOutConfig_ScreenMode) String() string {
	return proto.EnumName(ScreenOutConfig_ScreenMode_name, int32(x))
}

func (ScreenOutConfig_ScreenMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_a514007bdf931c71, []int{6, 0}
}

// Possible formats of the screen data.
type ScreenOut_Format int32

const (
	// No format specified.
	ScreenOut_FORMAT_UNSPECIFIED ScreenOut_Format = 0
	// Data will contain a fully-formed HTML5 layout encoded in UTF-8, e.g.
	// `<html><body><div>...</div></body></html>`. It is intended to be rendered
	// along with the audio response. Note that HTML5 doctype should be included
	// in the actual HTML data.
	ScreenOut_HTML ScreenOut_Format = 1
)

var ScreenOut_Format_name = map[int32]string{
	0: "FORMAT_UNSPECIFIED",
	1: "HTML",
}

var ScreenOut_Format_value = map[string]int32{
	"FORMAT_UNSPECIFIED": 0,
	"HTML":               1,
}

func (x ScreenOut_Format) String() string {
	return proto.EnumName(ScreenOut_Format_name, int32(x))
}

func (ScreenOut_Format) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_a514007bdf931c71, []int{10, 0}
}

// Possible states of the microphone after a `Assist` RPC completes.
type DialogStateOut_MicrophoneMode int32

const (
	// No mode specified.
	DialogStateOut_MICROPHONE_MODE_UNSPECIFIED DialogStateOut_MicrophoneMode = 0
	// The service is not expecting a follow-on question from the user.
	// The microphone should remain off until the user re-activates it.
	DialogStateOut_CLOSE_MICROPHONE DialogStateOut_MicrophoneMode = 1
	// The service is expecting a follow-on question from the user. The
	// microphone should be re-opened when the `AudioOut` playback completes
	// (by starting a new `Assist` RPC call to send the new audio).
	DialogStateOut_DIALOG_FOLLOW_ON DialogStateOut_MicrophoneMode = 2
)

var DialogStateOut_MicrophoneMode_name = map[int32]string{
	0: "MICROPHONE_MODE_UNSPECIFIED",
	1: "CLOSE_MICROPHONE",
	2: "DIALOG_FOLLOW_ON",
}

var DialogStateOut_MicrophoneMode_value = map[string]int32{
	"MICROPHONE_MODE_UNSPECIFIED": 0,
	"CLOSE_MICROPHONE":            1,
	"DIALOG_FOLLOW_ON":            2,
}

func (x DialogStateOut_MicrophoneMode) String() string {
	return proto.EnumName(DialogStateOut_MicrophoneMode_name, int32(x))
}

func (DialogStateOut_MicrophoneMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_a514007bdf931c71, []int{13, 0}
}

// The top-level message sent by the client. Clients must send at least two, and
// typically numerous `AssistRequest` messages. The first message must
// contain a `config` message and must not contain `audio_in` data. All
// subsequent messages must contain `audio_in` data and must not contain a
// `config` message.
type AssistRequest struct {
	// Exactly one of these fields must be specified in each `AssistRequest`.
	//
	// Types that are valid to be assigned to Type:
	//	*AssistRequest_Config
	//	*AssistRequest_AudioIn
	Type                 isAssistRequest_Type `protobuf_oneof:"type"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *AssistRequest) Reset()         { *m = AssistRequest{} }
func (m *AssistRequest) String() string { return proto.CompactTextString(m) }
func (*AssistRequest) ProtoMessage()    {}
func (*AssistRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a514007bdf931c71, []int{0}
}

func (m *AssistRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AssistRequest.Unmarshal(m, b)
}
func (m *AssistRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AssistRequest.Marshal(b, m, deterministic)
}
func (m *AssistRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AssistRequest.Merge(m, src)
}
func (m *AssistRequest) XXX_Size() int {
	return xxx_messageInfo_AssistRequest.Size(m)
}
func (m *AssistRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_AssistRequest.DiscardUnknown(m)
}

var xxx_messageInfo_AssistRequest proto.InternalMessageInfo

type isAssistRequest_Type interface {
	isAssistRequest_Type()
}

type AssistRequest_Config struct {
	Config *AssistConfig `protobuf:"bytes,1,opt,name=config,proto3,oneof"`
}

type AssistRequest_AudioIn struct {
	AudioIn []byte `protobuf:"bytes,2,opt,name=audio_in,json=audioIn,proto3,oneof"`
}

func (*AssistRequest_Config) isAssistRequest_Type() {}

func (*AssistRequest_AudioIn) isAssistRequest_Type() {}

func (m *AssistRequest) GetType() isAssistRequest_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *AssistRequest) GetConfig() *AssistConfig {
	if x, ok := m.GetType().(*AssistRequest_Config); ok {
		return x.Config
	}
	return nil
}

func (m *AssistRequest) GetAudioIn() []byte {
	if x, ok := m.GetType().(*AssistRequest_AudioIn); ok {
		return x.AudioIn
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*AssistRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _AssistRequest_OneofMarshaler, _AssistRequest_OneofUnmarshaler, _AssistRequest_OneofSizer, []interface{}{
		(*AssistRequest_Config)(nil),
		(*AssistRequest_AudioIn)(nil),
	}
}

func _AssistRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*AssistRequest)
	// type
	switch x := m.Type.(type) {
	case *AssistRequest_Config:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Config); err != nil {
			return err
		}
	case *AssistRequest_AudioIn:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.AudioIn)
	case nil:
	default:
		return fmt.Errorf("AssistRequest.Type has unexpected type %T", x)
	}
	return nil
}

func _AssistRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*AssistRequest)
	switch tag {
	case 1: // type.config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AssistConfig)
		err := b.DecodeMessage(msg)
		m.Type = &AssistRequest_Config{msg}
		return true, err
	case 2: // type.audio_in
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.Type = &AssistRequest_AudioIn{x}
		return true, err
	default:
		return false, nil
	}
}

func _AssistRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*AssistRequest)
	// type
	switch x := m.Type.(type) {
	case *AssistRequest_Config:
		s := proto.Size(x.Config)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AssistRequest_AudioIn:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.AudioIn)))
		n += len(x.AudioIn)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// The top-level message received by the client. A series of one or more
// `AssistResponse` messages are streamed back to the client.
type AssistResponse struct {
	// *Output-only* Indicates the type of event.
	EventType AssistResponse_EventType `protobuf:"varint,1,opt,name=event_type,json=eventType,proto3,enum=google.assistant.embedded.v1alpha2.AssistResponse_EventType" json:"event_type,omitempty"`
	// *Output-only* The audio containing the Assistant's response to the query.
	AudioOut *AudioOut `protobuf:"bytes,3,opt,name=audio_out,json=audioOut,proto3" json:"audio_out,omitempty"`
	// *Output-only* Contains the Assistant's visual response to the query.
	ScreenOut *ScreenOut `protobuf:"bytes,4,opt,name=screen_out,json=screenOut,proto3" json:"screen_out,omitempty"`
	// *Output-only* Contains the action triggered by the query with the
	// appropriate payloads and semantic parsing.
	DeviceAction *DeviceAction `protobuf:"bytes,6,opt,name=device_action,json=deviceAction,proto3" json:"device_action,omitempty"`
	// *Output-only* This repeated list contains zero or more speech recognition
	// results that correspond to consecutive portions of the audio currently
	// being processed, starting with the portion corresponding to the earliest
	// audio (and most stable portion) to the portion corresponding to the most
	// recent audio. The strings can be concatenated to view the full
	// in-progress response. When the speech recognition completes, this list
	// will contain one item with `stability` of `1.0`.
	SpeechResults []*SpeechRecognitionResult `protobuf:"bytes,2,rep,name=speech_results,json=speechResults,proto3" json:"speech_results,omitempty"`
	// *Output-only* Contains output related to the user's query.
	DialogStateOut *DialogStateOut `protobuf:"bytes,5,opt,name=dialog_state_out,json=dialogStateOut,proto3" json:"dialog_state_out,omitempty"`
	// *Output-only* Debugging info for developer. Only returned if request set
	// `return_debug_info` to true.
	DebugInfo            *DebugInfo `protobuf:"bytes,8,opt,name=debug_info,json=debugInfo,proto3" json:"debug_info,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *AssistResponse) Reset()         { *m = AssistResponse{} }
func (m *AssistResponse) String() string { return proto.CompactTextString(m) }
func (*AssistResponse) ProtoMessage()    {}
func (*AssistResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_a514007bdf931c71, []int{1}
}

func (m *AssistResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AssistResponse.Unmarshal(m, b)
}
func (m *AssistResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AssistResponse.Marshal(b, m, deterministic)
}
func (m *AssistResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AssistResponse.Merge(m, src)
}
func (m *AssistResponse) XXX_Size() int {
	return xxx_messageInfo_AssistResponse.Size(m)
}
func (m *AssistResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_AssistResponse.DiscardUnknown(m)
}

var xxx_messageInfo_AssistResponse proto.InternalMessageInfo

func (m *AssistResponse) GetEventType() AssistResponse_EventType {
	if m != nil {
		return m.EventType
	}
	return AssistResponse_EVENT_TYPE_UNSPECIFIED
}

func (m *AssistResponse) GetAudioOut() *AudioOut {
	if m != nil {
		return m.AudioOut
	}
	return nil
}

func (m *AssistResponse) GetScreenOut() *ScreenOut {
	if m != nil {
		return m.ScreenOut
	}
	return nil
}

func (m *AssistResponse) GetDeviceAction() *DeviceAction {
	if m != nil {
		return m.DeviceAction
	}
	return nil
}

func (m *AssistResponse) GetSpeechResults() []*SpeechRecognitionResult {
	if m != nil {
		return m.SpeechResults
	}
	return nil
}

func (m *AssistResponse) GetDialogStateOut() *DialogStateOut {
	if m != nil {
		return m.DialogStateOut
	}
	return nil
}

func (m *AssistResponse) GetDebugInfo() *DebugInfo {
	if m != nil {
		return m.DebugInfo
	}
	return nil
}

// Debug info for developer. Only returned if request set `return_debug_info`
// to true.
type DebugInfo struct {
	// The original JSON response from an Action-on-Google agent to Google server.
	// See
	// https://developers.google.com/actions/reference/rest/Shared.Types/AppResponse.
	// It will only be populated if the request maker owns the AoG project and the
	// AoG project is in preview mode.
	AogAgentToAssistantJson string   `protobuf:"bytes,1,opt,name=aog_agent_to_assistant_json,json=aogAgentToAssistantJson,proto3" json:"aog_agent_to_assistant_json,omitempty"`
	XXX_NoUnkeyedLiteral    struct{} `json:"-"`
	XXX_unrecognized        []byte   `json:"-"`
	XXX_sizecache           int32    `json:"-"`
}

func (m *DebugInfo) Reset()         { *m = DebugInfo{} }
func (m *DebugInfo) String() string { return proto.CompactTextString(m) }
func (*DebugInfo) ProtoMessage()    {}
func (*DebugInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_a514007bdf931c71, []int{2}
}

func (m *DebugInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DebugInfo.Unmarshal(m, b)
}
func (m *DebugInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DebugInfo.Marshal(b, m, deterministic)
}
func (m *DebugInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DebugInfo.Merge(m, src)
}
func (m *DebugInfo) XXX_Size() int {
	return xxx_messageInfo_DebugInfo.Size(m)
}
func (m *DebugInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_DebugInfo.DiscardUnknown(m)
}

var xxx_messageInfo_DebugInfo proto.InternalMessageInfo

func (m *DebugInfo) GetAogAgentToAssistantJson() string {
	if m != nil {
		return m.AogAgentToAssistantJson
	}
	return ""
}

// Specifies how to process the `AssistRequest` messages.
type AssistConfig struct {
	// Types that are valid to be assigned to Type:
	//	*AssistConfig_AudioInConfig
	//	*AssistConfig_TextQuery
	Type isAssistConfig_Type `protobuf_oneof:"type"`
	// *Required* Specifies how to format the audio that will be returned.
	AudioOutConfig *AudioOutConfig `protobuf:"bytes,2,opt,name=audio_out_config,json=audioOutConfig,proto3" json:"audio_out_config,omitempty"`
	// *Optional* Specifies the desired format to use when server returns a
	// visual screen response.
	ScreenOutConfig *ScreenOutConfig `protobuf:"bytes,8,opt,name=screen_out_config,json=screenOutConfig,proto3" json:"screen_out_config,omitempty"`
	// *Required* Represents the current dialog state.
	DialogStateIn *DialogStateIn `protobuf:"bytes,3,opt,name=dialog_state_in,json=dialogStateIn,proto3" json:"dialog_state_in,omitempty"`
	// Device configuration that uniquely identifies a specific device.
	DeviceConfig *DeviceConfig `protobuf:"bytes,4,opt,name=device_config,json=deviceConfig,proto3" json:"device_config,omitempty"`
	// *Optional* Debugging parameters for the whole `Assist` RPC.
	DebugConfig          *DebugConfig `protobuf:"bytes,5,opt,name=debug_config,json=debugConfig,proto3" json:"debug_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *AssistConfig) Reset()         { *m = AssistConfig{} }
func (m *AssistConfig) String() string { return proto.CompactTextString(m) }
func (*AssistConfig) ProtoMessage()    {}
func (*AssistConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_a514007bdf931c71, []int{3}
}

func (m *AssistConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AssistConfig.Unmarshal(m, b)
}
func (m *AssistConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AssistConfig.Marshal(b, m, deterministic)
}
func (m *AssistConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AssistConfig.Merge(m, src)
}
func (m *AssistConfig) XXX_Size() int {
	return xxx_messageInfo_AssistConfig.Size(m)
}
func (m *AssistConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_AssistConfig.DiscardUnknown(m)
}

var xxx_messageInfo_AssistConfig proto.InternalMessageInfo

type isAssistConfig_Type interface {
	isAssistConfig_Type()
}

type AssistConfig_AudioInConfig struct {
	AudioInConfig *AudioInConfig `protobuf:"bytes,1,opt,name=audio_in_config,json=audioInConfig,proto3,oneof"`
}

type AssistConfig_TextQuery struct {
	TextQuery string `protobuf:"bytes,6,opt,name=text_query,json=textQuery,proto3,oneof"`
}

func (*AssistConfig_AudioInConfig) isAssistConfig_Type() {}

func (*AssistConfig_TextQuery) isAssistConfig_Type() {}

func (m *AssistConfig) GetType() isAssistConfig_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *AssistConfig) GetAudioInConfig() *AudioInConfig {
	if x, ok := m.GetType().(*AssistConfig_AudioInConfig); ok {
		return x.AudioInConfig
	}
	return nil
}

func (m *AssistConfig) GetTextQuery() string {
	if x, ok := m.GetType().(*AssistConfig_TextQuery); ok {
		return x.TextQuery
	}
	return ""
}

func (m *AssistConfig) GetAudioOutConfig() *AudioOutConfig {
	if m != nil {
		return m.AudioOutConfig
	}
	return nil
}

func (m *AssistConfig) GetScreenOutConfig() *ScreenOutConfig {
	if m != nil {
		return m.ScreenOutConfig
	}
	return nil
}

func (m *AssistConfig) GetDialogStateIn() *DialogStateIn {
	if m != nil {
		return m.DialogStateIn
	}
	return nil
}

func (m *AssistConfig) GetDeviceConfig() *DeviceConfig {
	if m != nil {
		return m.DeviceConfig
	}
	return nil
}

func (m *AssistConfig) GetDebugConfig() *DebugConfig {
	if m != nil {
		return m.DebugConfig
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*AssistConfig) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _AssistConfig_OneofMarshaler, _AssistConfig_OneofUnmarshaler, _AssistConfig_OneofSizer, []interface{}{
		(*AssistConfig_AudioInConfig)(nil),
		(*AssistConfig_TextQuery)(nil),
	}
}

func _AssistConfig_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*AssistConfig)
	// type
	switch x := m.Type.(type) {
	case *AssistConfig_AudioInConfig:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AudioInConfig); err != nil {
			return err
		}
	case *AssistConfig_TextQuery:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.TextQuery)
	case nil:
	default:
		return fmt.Errorf("AssistConfig.Type has unexpected type %T", x)
	}
	return nil
}

func _AssistConfig_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*AssistConfig)
	switch tag {
	case 1: // type.audio_in_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AudioInConfig)
		err := b.DecodeMessage(msg)
		m.Type = &AssistConfig_AudioInConfig{msg}
		return true, err
	case 6: // type.text_query
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Type = &AssistConfig_TextQuery{x}
		return true, err
	default:
		return false, nil
	}
}

func _AssistConfig_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*AssistConfig)
	// type
	switch x := m.Type.(type) {
	case *AssistConfig_AudioInConfig:
		s := proto.Size(x.AudioInConfig)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AssistConfig_TextQuery:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.TextQuery)))
		n += len(x.TextQuery)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Specifies how to process the `audio_in` data that will be provided in
// subsequent requests. For recommended settings, see the Google Assistant SDK
// [best practices](https://developers.google.com/assistant/sdk/guides/service/python/best-practices/audio).
type AudioInConfig struct {
	// *Required* Encoding of audio data sent in all `audio_in` messages.
	Encoding AudioInConfig_Encoding `protobuf:"varint,1,opt,name=encoding,proto3,enum=google.assistant.embedded.v1alpha2.AudioInConfig_Encoding" json:"encoding,omitempty"`
	// *Required* Sample rate (in Hertz) of the audio data sent in all `audio_in`
	// messages. Valid values are from 16000-24000, but 16000 is optimal.
	// For best results, set the sampling rate of the audio source to 16000 Hz.
	// If that's not possible, use the native sample rate of the audio source
	// (instead of re-sampling).
	SampleRateHertz      int32    `protobuf:"varint,2,opt,name=sample_rate_hertz,json=sampleRateHertz,proto3" json:"sample_rate_hertz,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AudioInConfig) Reset()         { *m = AudioInConfig{} }
func (m *AudioInConfig) String() string { return proto.CompactTextString(m) }
func (*AudioInConfig) ProtoMessage()    {}
func (*AudioInConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_a514007bdf931c71, []int{4}
}

func (m *AudioInConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AudioInConfig.Unmarshal(m, b)
}
func (m *AudioInConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AudioInConfig.Marshal(b, m, deterministic)
}
func (m *AudioInConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AudioInConfig.Merge(m, src)
}
func (m *AudioInConfig) XXX_Size() int {
	return xxx_messageInfo_AudioInConfig.Size(m)
}
func (m *AudioInConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_AudioInConfig.DiscardUnknown(m)
}

var xxx_messageInfo_AudioInConfig proto.InternalMessageInfo

func (m *AudioInConfig) GetEncoding() AudioInConfig_Encoding {
	if m != nil {
		return m.Encoding
	}
	return AudioInConfig_ENCODING_UNSPECIFIED
}

func (m *AudioInConfig) GetSampleRateHertz() int32 {
	if m != nil {
		return m.SampleRateHertz
	}
	return 0
}

// Specifies the desired format for the server to use when it returns
// `audio_out` messages.
type AudioOutConfig struct {
	// *Required* The encoding of audio data to be returned in all `audio_out`
	// messages.
	Encoding AudioOutConfig_Encoding `protobuf:"varint,1,opt,name=encoding,proto3,enum=google.assistant.embedded.v1alpha2.AudioOutConfig_Encoding" json:"encoding,omitempty"`
	// *Required* The sample rate in Hertz of the audio data returned in
	// `audio_out` messages. Valid values are: 16000-24000.
	SampleRateHertz int32 `protobuf:"varint,2,opt,name=sample_rate_hertz,json=sampleRateHertz,proto3" json:"sample_rate_hertz,omitempty"`
	// *Required* Current volume setting of the device's audio output.
	// Valid values are 1 to 100 (corresponding to 1% to 100%).
	VolumePercentage     int32    `protobuf:"varint,3,opt,name=volume_percentage,json=volumePercentage,proto3" json:"volume_percentage,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AudioOutConfig) Reset()         { *m = AudioOutConfig{} }
func (m *AudioOutConfig) String() string { return proto.CompactTextString(m) }
func (*AudioOutConfig) ProtoMessage()    {}
func (*AudioOutConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_a514007bdf931c71, []int{5}
}

func (m *AudioOutConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AudioOutConfig.Unmarshal(m, b)
}
func (m *AudioOutConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AudioOutConfig.Marshal(b, m, deterministic)
}
func (m *AudioOutConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AudioOutConfig.Merge(m, src)
}
func (m *AudioOutConfig) XXX_Size() int {
	return xxx_messageInfo_AudioOutConfig.Size(m)
}
func (m *AudioOutConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_AudioOutConfig.DiscardUnknown(m)
}

var xxx_messageInfo_AudioOutConfig proto.InternalMessageInfo

func (m *AudioOutConfig) GetEncoding() AudioOutConfig_Encoding {
	if m != nil {
		return m.Encoding
	}
	return AudioOutConfig_ENCODING_UNSPECIFIED
}

func (m *AudioOutConfig) GetSampleRateHertz() int32 {
	if m != nil {
		return m.SampleRateHertz
	}
	return 0
}

func (m *AudioOutConfig) GetVolumePercentage() int32 {
	if m != nil {
		return m.VolumePercentage
	}
	return 0
}

// Specifies the desired format for the server to use when it returns
// `screen_out` response.
type ScreenOutConfig struct {
	// Current visual screen-mode for the device while issuing the query.
	ScreenMode           ScreenOutConfig_ScreenMode `protobuf:"varint,1,opt,name=screen_mode,json=screenMode,proto3,enum=google.assistant.embedded.v1alpha2.ScreenOutConfig_ScreenMode" json:"screen_mode,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *ScreenOutConfig) Reset()         { *m = ScreenOutConfig{} }
func (m *ScreenOutConfig) String() string { return proto.CompactTextString(m) }
func (*ScreenOutConfig) ProtoMessage()    {}
func (*ScreenOutConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_a514007bdf931c71, []int{6}
}

func (m *ScreenOutConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ScreenOutConfig.Unmarshal(m, b)
}
func (m *ScreenOutConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ScreenOutConfig.Marshal(b, m, deterministic)
}
func (m *ScreenOutConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScreenOutConfig.Merge(m, src)
}
func (m *ScreenOutConfig) XXX_Size() int {
	return xxx_messageInfo_ScreenOutConfig.Size(m)
}
func (m *ScreenOutConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_ScreenOutConfig.DiscardUnknown(m)
}

var xxx_messageInfo_ScreenOutConfig proto.InternalMessageInfo

func (m *ScreenOutConfig) GetScreenMode() ScreenOutConfig_ScreenMode {
	if m != nil {
		return m.ScreenMode
	}
	return ScreenOutConfig_SCREEN_MODE_UNSPECIFIED
}

// Provides information about the current dialog state.
type DialogStateIn struct {
	// *Required* This field must always be set to the
	// [DialogStateOut.conversation_state][google.assistant.embedded.v1alpha2.DialogStateOut.conversation_state] value that was returned in the prior
	// `Assist` RPC. It should only be omitted (field not set) if there was no
	// prior `Assist` RPC because this is the first `Assist` RPC made by this
	// device after it was first setup and/or a factory-default reset.
	ConversationState []byte `protobuf:"bytes,1,opt,name=conversation_state,json=conversationState,proto3" json:"conversation_state,omitempty"`
	// *Required* Language of the request in
	// [IETF BCP 47 syntax](https://tools.ietf.org/html/bcp47) (for example,
	// "en-US"). See [Language Support](https://developers.google.com/assistant/sdk/reference/rpc/languages)
	// for more information. If you have selected a language for this `device_id`
	// using the [Settings](https://developers.google.com/assistant/sdk/reference/assistant-app/assistant-settings)
	// menu in your phone's Google Assistant app, that selection will override
	// this value.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// *Optional* Location of the device where the query originated.
	DeviceLocation *DeviceLocation `protobuf:"bytes,5,opt,name=device_location,json=deviceLocation,proto3" json:"device_location,omitempty"`
	// *Optional* If true, the server will treat the request as a new conversation
	// and not use state from the prior request. Set this field to true when the
	// conversation should be restarted, such as after a device reboot, or after a
	// significant lapse of time since the prior query.
	IsNewConversation    bool     `protobuf:"varint,7,opt,name=is_new_conversation,json=isNewConversation,proto3" json:"is_new_conversation,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DialogStateIn) Reset()         { *m = DialogStateIn{} }
func (m *DialogStateIn) String() string { return proto.CompactTextString(m) }
func (*DialogStateIn) ProtoMessage()    {}
func (*DialogStateIn) Descriptor() ([]byte, []int) {
	return fileDescriptor_a514007bdf931c71, []int{7}
}

func (m *DialogStateIn) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DialogStateIn.Unmarshal(m, b)
}
func (m *DialogStateIn) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DialogStateIn.Marshal(b, m, deterministic)
}
func (m *DialogStateIn) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DialogStateIn.Merge(m, src)
}
func (m *DialogStateIn) XXX_Size() int {
	return xxx_messageInfo_DialogStateIn.Size(m)
}
func (m *DialogStateIn) XXX_DiscardUnknown() {
	xxx_messageInfo_DialogStateIn.DiscardUnknown(m)
}

var xxx_messageInfo_DialogStateIn proto.InternalMessageInfo

func (m *DialogStateIn) GetConversationState() []byte {
	if m != nil {
		return m.ConversationState
	}
	return nil
}

func (m *DialogStateIn) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *DialogStateIn) GetDeviceLocation() *DeviceLocation {
	if m != nil {
		return m.DeviceLocation
	}
	return nil
}

func (m *DialogStateIn) GetIsNewConversation() bool {
	if m != nil {
		return m.IsNewConversation
	}
	return false
}

// *Required* Fields that identify the device to the Assistant.
//
// See also:
//
// *   [Register a Device - REST
// API](https://developers.google.com/assistant/sdk/reference/device-registration/register-device-manual)
// *   [Device Model and Instance
// Schemas](https://developers.google.com/assistant/sdk/reference/device-registration/model-and-instance-schemas)
// *   [Device
// Proto](https://developers.google.com/assistant/sdk/reference/rpc/google.assistant.devices.v1alpha2#device)
type DeviceConfig struct {
	// *Required* Unique identifier for the device. The id length must be 128
	// characters or less. Example: DBCDW098234. This MUST match the device_id
	// returned from device registration. This device_id is used to match against
	// the user's registered devices to lookup the supported traits and
	// capabilities of this device. This information should not change across
	// device reboots. However, it should not be saved across
	// factory-default resets.
	DeviceId string `protobuf:"bytes,1,opt,name=device_id,json=deviceId,proto3" json:"device_id,omitempty"`
	// *Required* Unique identifier for the device model. The combination of
	// device_model_id and device_id must have been previously associated through
	// device registration.
	DeviceModelId        string   `protobuf:"bytes,3,opt,name=device_model_id,json=deviceModelId,proto3" json:"device_model_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeviceConfig) Reset()         { *m = DeviceConfig{} }
func (m *DeviceConfig) String() string { return proto.CompactTextString(m) }
func (*DeviceConfig) ProtoMessage()    {}
func (*DeviceConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_a514007bdf931c71, []int{8}
}

func (m *DeviceConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeviceConfig.Unmarshal(m, b)
}
func (m *DeviceConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeviceConfig.Marshal(b, m, deterministic)
}
func (m *DeviceConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeviceConfig.Merge(m, src)
}
func (m *DeviceConfig) XXX_Size() int {
	return xxx_messageInfo_DeviceConfig.Size(m)
}
func (m *DeviceConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_DeviceConfig.DiscardUnknown(m)
}

var xxx_messageInfo_DeviceConfig proto.InternalMessageInfo

func (m *DeviceConfig) GetDeviceId() string {
	if m != nil {
		return m.DeviceId
	}
	return ""
}

func (m *DeviceConfig) GetDeviceModelId() string {
	if m != nil {
		return m.DeviceModelId
	}
	return ""
}

// The audio containing the Assistant's response to the query. Sequential chunks
// of audio data are received in sequential `AssistResponse` messages.
type AudioOut struct {
	// *Output-only* The audio data containing the Assistant's response to the
	// query. Sequential chunks of audio data are received in sequential
	// `AssistResponse` messages.
	AudioData            []byte   `protobuf:"bytes,1,opt,name=audio_data,json=audioData,proto3" json:"audio_data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AudioOut) Reset()         { *m = AudioOut{} }
func (m *AudioOut) String() string { return proto.CompactTextString(m) }
func (*AudioOut) ProtoMessage()    {}
func (*AudioOut) Descriptor() ([]byte, []int) {
	return fileDescriptor_a514007bdf931c71, []int{9}
}

func (m *AudioOut) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AudioOut.Unmarshal(m, b)
}
func (m *AudioOut) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AudioOut.Marshal(b, m, deterministic)
}
func (m *AudioOut) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AudioOut.Merge(m, src)
}
func (m *AudioOut) XXX_Size() int {
	return xxx_messageInfo_AudioOut.Size(m)
}
func (m *AudioOut) XXX_DiscardUnknown() {
	xxx_messageInfo_AudioOut.DiscardUnknown(m)
}

var xxx_messageInfo_AudioOut proto.InternalMessageInfo

func (m *AudioOut) GetAudioData() []byte {
	if m != nil {
		return m.AudioData
	}
	return nil
}

// The Assistant's visual output response to query. Enabled by
// `screen_out_config`.
type ScreenOut struct {
	// *Output-only* The format of the provided screen data.
	Format ScreenOut_Format `protobuf:"varint,1,opt,name=format,proto3,enum=google.assistant.embedded.v1alpha2.ScreenOut_Format" json:"format,omitempty"`
	// *Output-only* The raw screen data to be displayed as the result of the
	// Assistant query.
	Data                 []byte   `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ScreenOut) Reset()         { *m = ScreenOut{} }
func (m *ScreenOut) String() string { return proto.CompactTextString(m) }
func (*ScreenOut) ProtoMessage()    {}
func (*ScreenOut) Descriptor() ([]byte, []int) {
	return fileDescriptor_a514007bdf931c71, []int{10}
}

func (m *ScreenOut) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ScreenOut.Unmarshal(m, b)
}
func (m *ScreenOut) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ScreenOut.Marshal(b, m, deterministic)
}
func (m *ScreenOut) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScreenOut.Merge(m, src)
}
func (m *ScreenOut) XXX_Size() int {
	return xxx_messageInfo_ScreenOut.Size(m)
}
func (m *ScreenOut) XXX_DiscardUnknown() {
	xxx_messageInfo_ScreenOut.DiscardUnknown(m)
}

var xxx_messageInfo_ScreenOut proto.InternalMessageInfo

func (m *ScreenOut) GetFormat() ScreenOut_Format {
	if m != nil {
		return m.Format
	}
	return ScreenOut_FORMAT_UNSPECIFIED
}

func (m *ScreenOut) GetData() []byte {
	if m != nil {
		return m.Data
	}
	return nil
}

// The response returned to the device if the user has triggered a Device
// Action. For example, a device which supports the query *Turn on the light*
// would receive a `DeviceAction` with a JSON payload containing the semantics
// of the request.
type DeviceAction struct {
	// JSON containing the device command response generated from the triggered
	// Device Action grammar. The format is given by the
	// `action.devices.EXECUTE` intent for a given
	// [trait](https://developers.google.com/assistant/sdk/reference/traits/).
	DeviceRequestJson    string   `protobuf:"bytes,1,opt,name=device_request_json,json=deviceRequestJson,proto3" json:"device_request_json,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeviceAction) Reset()         { *m = DeviceAction{} }
func (m *DeviceAction) String() string { return proto.CompactTextString(m) }
func (*DeviceAction) ProtoMessage()    {}
func (*DeviceAction) Descriptor() ([]byte, []int) {
	return fileDescriptor_a514007bdf931c71, []int{11}
}

func (m *DeviceAction) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeviceAction.Unmarshal(m, b)
}
func (m *DeviceAction) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeviceAction.Marshal(b, m, deterministic)
}
func (m *DeviceAction) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeviceAction.Merge(m, src)
}
func (m *DeviceAction) XXX_Size() int {
	return xxx_messageInfo_DeviceAction.Size(m)
}
func (m *DeviceAction) XXX_DiscardUnknown() {
	xxx_messageInfo_DeviceAction.DiscardUnknown(m)
}

var xxx_messageInfo_DeviceAction proto.InternalMessageInfo

func (m *DeviceAction) GetDeviceRequestJson() string {
	if m != nil {
		return m.DeviceRequestJson
	}
	return ""
}

// The estimated transcription of a phrase the user has spoken. This could be
// a single segment or the full guess of the user's spoken query.
type SpeechRecognitionResult struct {
	// *Output-only* Transcript text representing the words that the user spoke.
	Transcript string `protobuf:"bytes,1,opt,name=transcript,proto3" json:"transcript,omitempty"`
	// *Output-only* An estimate of the likelihood that the Assistant will not
	// change its guess about this result. Values range from 0.0 (completely
	// unstable) to 1.0 (completely stable and final). The default of 0.0 is a
	// sentinel value indicating `stability` was not set.
	Stability            float32  `protobuf:"fixed32,2,opt,name=stability,proto3" json:"stability,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SpeechRecognitionResult) Reset()         { *m = SpeechRecognitionResult{} }
func (m *SpeechRecognitionResult) String() string { return proto.CompactTextString(m) }
func (*SpeechRecognitionResult) ProtoMessage()    {}
func (*SpeechRecognitionResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_a514007bdf931c71, []int{12}
}

func (m *SpeechRecognitionResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SpeechRecognitionResult.Unmarshal(m, b)
}
func (m *SpeechRecognitionResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SpeechRecognitionResult.Marshal(b, m, deterministic)
}
func (m *SpeechRecognitionResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SpeechRecognitionResult.Merge(m, src)
}
func (m *SpeechRecognitionResult) XXX_Size() int {
	return xxx_messageInfo_SpeechRecognitionResult.Size(m)
}
func (m *SpeechRecognitionResult) XXX_DiscardUnknown() {
	xxx_messageInfo_SpeechRecognitionResult.DiscardUnknown(m)
}

var xxx_messageInfo_SpeechRecognitionResult proto.InternalMessageInfo

func (m *SpeechRecognitionResult) GetTranscript() string {
	if m != nil {
		return m.Transcript
	}
	return ""
}

func (m *SpeechRecognitionResult) GetStability() float32 {
	if m != nil {
		return m.Stability
	}
	return 0
}

// The dialog state resulting from the user's query. Multiple of these messages
// may be received.
type DialogStateOut struct {
	// *Output-only* Supplemental display text from the Assistant. This could be
	// the same as the speech spoken in `AssistResponse.audio_out` or it could
	// be some additional information which aids the user's understanding.
	SupplementalDisplayText string `protobuf:"bytes,1,opt,name=supplemental_display_text,json=supplementalDisplayText,proto3" json:"supplemental_display_text,omitempty"`
	// *Output-only* State information for the subsequent `Assist` RPC. This
	// value should be saved in the client and returned in the
	// [`DialogStateIn.conversation_state`](#dialogstatein) field with the next
	// `Assist` RPC. (The client does not need to interpret or otherwise use this
	// value.) This information should be saved across device reboots. However,
	// this value should be cleared (not saved in the client) during a
	// factory-default reset.
	ConversationState []byte `protobuf:"bytes,2,opt,name=conversation_state,json=conversationState,proto3" json:"conversation_state,omitempty"`
	// *Output-only* Specifies the mode of the microphone after this `Assist`
	// RPC is processed.
	MicrophoneMode DialogStateOut_MicrophoneMode `protobuf:"varint,3,opt,name=microphone_mode,json=microphoneMode,proto3,enum=google.assistant.embedded.v1alpha2.DialogStateOut_MicrophoneMode" json:"microphone_mode,omitempty"`
	// *Output-only* Updated volume level. The value will be 0 or omitted
	// (indicating no change) unless a voice command such as *Increase the volume*
	// or *Set volume level 4* was recognized, in which case the value will be
	// between 1 and 100 (corresponding to the new volume level of 1% to 100%).
	// Typically, a client should use this volume level when playing the
	// `audio_out` data, and retain this value as the current volume level and
	// supply it in the `AudioOutConfig` of the next `AssistRequest`. (Some
	// clients may also implement other ways to allow the current volume level to
	// be changed, for example, by providing a knob that the user can turn.)
	VolumePercentage     int32    `protobuf:"varint,4,opt,name=volume_percentage,json=volumePercentage,proto3" json:"volume_percentage,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DialogStateOut) Reset()         { *m = DialogStateOut{} }
func (m *DialogStateOut) String() string { return proto.CompactTextString(m) }
func (*DialogStateOut) ProtoMessage()    {}
func (*DialogStateOut) Descriptor() ([]byte, []int) {
	return fileDescriptor_a514007bdf931c71, []int{13}
}

func (m *DialogStateOut) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DialogStateOut.Unmarshal(m, b)
}
func (m *DialogStateOut) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DialogStateOut.Marshal(b, m, deterministic)
}
func (m *DialogStateOut) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DialogStateOut.Merge(m, src)
}
func (m *DialogStateOut) XXX_Size() int {
	return xxx_messageInfo_DialogStateOut.Size(m)
}
func (m *DialogStateOut) XXX_DiscardUnknown() {
	xxx_messageInfo_DialogStateOut.DiscardUnknown(m)
}

var xxx_messageInfo_DialogStateOut proto.InternalMessageInfo

func (m *DialogStateOut) GetSupplementalDisplayText() string {
	if m != nil {
		return m.SupplementalDisplayText
	}
	return ""
}

func (m *DialogStateOut) GetConversationState() []byte {
	if m != nil {
		return m.ConversationState
	}
	return nil
}

func (m *DialogStateOut) GetMicrophoneMode() DialogStateOut_MicrophoneMode {
	if m != nil {
		return m.MicrophoneMode
	}
	return DialogStateOut_MICROPHONE_MODE_UNSPECIFIED
}

func (m *DialogStateOut) GetVolumePercentage() int32 {
	if m != nil {
		return m.VolumePercentage
	}
	return 0
}

// Debugging parameters for the current request.
type DebugConfig struct {
	// When this field is set to true, the `debug_info` field in `AssistResponse`
	// may be populated. However it will significantly increase latency of
	// responses. Do not set this field true in production code.
	ReturnDebugInfo      bool     `protobuf:"varint,6,opt,name=return_debug_info,json=returnDebugInfo,proto3" json:"return_debug_info,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DebugConfig) Reset()         { *m = DebugConfig{} }
func (m *DebugConfig) String() string { return proto.CompactTextString(m) }
func (*DebugConfig) ProtoMessage()    {}
func (*DebugConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_a514007bdf931c71, []int{14}
}

func (m *DebugConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DebugConfig.Unmarshal(m, b)
}
func (m *DebugConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DebugConfig.Marshal(b, m, deterministic)
}
func (m *DebugConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DebugConfig.Merge(m, src)
}
func (m *DebugConfig) XXX_Size() int {
	return xxx_messageInfo_DebugConfig.Size(m)
}
func (m *DebugConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_DebugConfig.DiscardUnknown(m)
}

var xxx_messageInfo_DebugConfig proto.InternalMessageInfo

func (m *DebugConfig) GetReturnDebugInfo() bool {
	if m != nil {
		return m.ReturnDebugInfo
	}
	return false
}

// There are three sources of locations. They are used with this precedence:
//
// 1. This `DeviceLocation`, which is primarily used for mobile devices with
//    GPS .
// 2. Location specified by the user during device setup; this is per-user, per
//    device. This location is used if `DeviceLocation` is not specified.
// 3. Inferred location based on IP address. This is used only if neither of the
//    above are specified.
type DeviceLocation struct {
	// Types that are valid to be assigned to Type:
	//	*DeviceLocation_Coordinates
	Type                 isDeviceLocation_Type `protobuf_oneof:"type"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *DeviceLocation) Reset()         { *m = DeviceLocation{} }
func (m *DeviceLocation) String() string { return proto.CompactTextString(m) }
func (*DeviceLocation) ProtoMessage()    {}
func (*DeviceLocation) Descriptor() ([]byte, []int) {
	return fileDescriptor_a514007bdf931c71, []int{15}
}

func (m *DeviceLocation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeviceLocation.Unmarshal(m, b)
}
func (m *DeviceLocation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeviceLocation.Marshal(b, m, deterministic)
}
func (m *DeviceLocation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeviceLocation.Merge(m, src)
}
func (m *DeviceLocation) XXX_Size() int {
	return xxx_messageInfo_DeviceLocation.Size(m)
}
func (m *DeviceLocation) XXX_DiscardUnknown() {
	xxx_messageInfo_DeviceLocation.DiscardUnknown(m)
}

var xxx_messageInfo_DeviceLocation proto.InternalMessageInfo

type isDeviceLocation_Type interface {
	isDeviceLocation_Type()
}

type DeviceLocation_Coordinates struct {
	Coordinates *latlng.LatLng `protobuf:"bytes,1,opt,name=coordinates,proto3,oneof"`
}

func (*DeviceLocation_Coordinates) isDeviceLocation_Type() {}

func (m *DeviceLocation) GetType() isDeviceLocation_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *DeviceLocation) GetCoordinates() *latlng.LatLng {
	if x, ok := m.GetType().(*DeviceLocation_Coordinates); ok {
		return x.Coordinates
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*DeviceLocation) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _DeviceLocation_OneofMarshaler, _DeviceLocation_OneofUnmarshaler, _DeviceLocation_OneofSizer, []interface{}{
		(*DeviceLocation_Coordinates)(nil),
	}
}

func _DeviceLocation_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*DeviceLocation)
	// type
	switch x := m.Type.(type) {
	case *DeviceLocation_Coordinates:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Coordinates); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("DeviceLocation.Type has unexpected type %T", x)
	}
	return nil
}

func _DeviceLocation_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*DeviceLocation)
	switch tag {
	case 1: // type.coordinates
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(latlng.LatLng)
		err := b.DecodeMessage(msg)
		m.Type = &DeviceLocation_Coordinates{msg}
		return true, err
	default:
		return false, nil
	}
}

func _DeviceLocation_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*DeviceLocation)
	// type
	switch x := m.Type.(type) {
	case *DeviceLocation_Coordinates:
		s := proto.Size(x.Coordinates)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

func init() {
	proto.RegisterEnum("google.assistant.embedded.v1alpha2.AssistResponse_EventType", AssistResponse_EventType_name, AssistResponse_EventType_value)
	proto.RegisterEnum("google.assistant.embedded.v1alpha2.AudioInConfig_Encoding", AudioInConfig_Encoding_name, AudioInConfig_Encoding_value)
	proto.RegisterEnum("google.assistant.embedded.v1alpha2.AudioOutConfig_Encoding", AudioOutConfig_Encoding_name, AudioOutConfig_Encoding_value)
	proto.RegisterEnum("google.assistant.embedded.v1alpha2.ScreenOutConfig_ScreenMode", ScreenOutConfig_ScreenMode_name, ScreenOutConfig_ScreenMode_value)
	proto.RegisterEnum("google.assistant.embedded.v1alpha2.ScreenOut_Format", ScreenOut_Format_name, ScreenOut_Format_value)
	proto.RegisterEnum("google.assistant.embedded.v1alpha2.DialogStateOut_MicrophoneMode", DialogStateOut_MicrophoneMode_name, DialogStateOut_MicrophoneMode_value)
	proto.RegisterType((*AssistRequest)(nil), "google.assistant.embedded.v1alpha2.AssistRequest")
	proto.RegisterType((*AssistResponse)(nil), "google.assistant.embedded.v1alpha2.AssistResponse")
	proto.RegisterType((*DebugInfo)(nil), "google.assistant.embedded.v1alpha2.DebugInfo")
	proto.RegisterType((*AssistConfig)(nil), "google.assistant.embedded.v1alpha2.AssistConfig")
	proto.RegisterType((*AudioInConfig)(nil), "google.assistant.embedded.v1alpha2.AudioInConfig")
	proto.RegisterType((*AudioOutConfig)(nil), "google.assistant.embedded.v1alpha2.AudioOutConfig")
	proto.RegisterType((*ScreenOutConfig)(nil), "google.assistant.embedded.v1alpha2.ScreenOutConfig")
	proto.RegisterType((*DialogStateIn)(nil), "google.assistant.embedded.v1alpha2.DialogStateIn")
	proto.RegisterType((*DeviceConfig)(nil), "google.assistant.embedded.v1alpha2.DeviceConfig")
	proto.RegisterType((*AudioOut)(nil), "google.assistant.embedded.v1alpha2.AudioOut")
	proto.RegisterType((*ScreenOut)(nil), "google.assistant.embedded.v1alpha2.ScreenOut")
	proto.RegisterType((*DeviceAction)(nil), "google.assistant.embedded.v1alpha2.DeviceAction")
	proto.RegisterType((*SpeechRecognitionResult)(nil), "google.assistant.embedded.v1alpha2.SpeechRecognitionResult")
	proto.RegisterType((*DialogStateOut)(nil), "google.assistant.embedded.v1alpha2.DialogStateOut")
	proto.RegisterType((*DebugConfig)(nil), "google.assistant.embedded.v1alpha2.DebugConfig")
	proto.RegisterType((*DeviceLocation)(nil), "google.assistant.embedded.v1alpha2.DeviceLocation")
}

func init() {
	proto.RegisterFile("google/assistant/embedded/v1alpha2/embedded_assistant.proto", fileDescriptor_a514007bdf931c71)
}

var fileDescriptor_a514007bdf931c71 = []byte{
	// 1449 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x57, 0x41, 0x73, 0xdb, 0xc6,
	0x15, 0x16, 0x28, 0x8a, 0x22, 0x1f, 0x29, 0x92, 0x5a, 0x7b, 0x6c, 0x56, 0x72, 0x6b, 0x0d, 0x3a,
	0xe3, 0x51, 0xdd, 0x9a, 0xb4, 0xe8, 0x4e, 0x3b, 0xb5, 0x5c, 0x77, 0x68, 0x12, 0x94, 0xe0, 0x52,
	0x04, 0x0d, 0x52, 0xf6, 0xb8, 0x6e, 0x07, 0xb3, 0x22, 0x56, 0x10, 0x3c, 0xe0, 0x2e, 0x0d, 0x2c,
	0x65, 0xab, 0xa7, 0x1c, 0x73, 0x4b, 0xae, 0xb9, 0xe6, 0x9c, 0x5b, 0x7e, 0x49, 0x8e, 0xf9, 0x17,
	0x99, 0xc9, 0x1f, 0xc8, 0xec, 0x62, 0x41, 0x91, 0x8a, 0x95, 0x90, 0xce, 0x0d, 0xfb, 0xde, 0xbe,
	0x0f, 0x0f, 0xbb, 0xdf, 0xf7, 0xde, 0x03, 0xec, 0x7b, 0x8c, 0x79, 0x01, 0xa9, 0xe1, 0x28, 0xf2,
	0x23, 0x8e, 0x29, 0xaf, 0x91, 0xd1, 0x09, 0x71, 0x5d, 0xe2, 0xd6, 0xce, 0xf7, 0x70, 0x30, 0x3e,
	0xc3, 0xf5, 0xa9, 0xc5, 0x99, 0x6e, 0xaa, 0x8e, 0x43, 0xc6, 0x19, 0xd2, 0xe3, 0xe0, 0xea, 0xa5,
	0x3d, 0xd9, 0x5a, 0x4d, 0x82, 0xb7, 0xee, 0x24, 0x2f, 0x18, 0xfb, 0x35, 0x4c, 0x29, 0xe3, 0x98,
	0xfb, 0x8c, 0x46, 0x31, 0xc2, 0x56, 0x45, 0x79, 0xf9, 0xc5, 0x98, 0xd4, 0x02, 0xcc, 0x03, 0xea,
	0xc5, 0x1e, 0xfd, 0x33, 0x0d, 0x36, 0x1a, 0x12, 0xd7, 0x26, 0xef, 0x26, 0x24, 0xe2, 0xe8, 0x39,
	0x64, 0x86, 0x8c, 0x9e, 0xfa, 0x5e, 0x45, 0xdb, 0xd1, 0x76, 0xf3, 0xf5, 0x87, 0xd5, 0x5f, 0x7f,
	0x7d, 0x35, 0x86, 0x68, 0xca, 0xb8, 0xc3, 0x15, 0x5b, 0x21, 0xa0, 0x6d, 0xc8, 0xe2, 0x89, 0xeb,
	0x33, 0xc7, 0xa7, 0x95, 0xd4, 0x8e, 0xb6, 0x5b, 0x38, 0x5c, 0xb1, 0xd7, 0xa5, 0xc5, 0xa4, 0xcf,
	0x32, 0x90, 0x16, 0xf9, 0xe8, 0xdf, 0xac, 0x41, 0x31, 0x49, 0x21, 0x1a, 0x33, 0x1a, 0x11, 0xf4,
	0x06, 0x80, 0x9c, 0x13, 0xca, 0x1d, 0xb1, 0x41, 0xe6, 0x51, 0xac, 0x3f, 0x59, 0x3c, 0x8f, 0x04,
	0xa7, 0x6a, 0x08, 0x90, 0xc1, 0xc5, 0x98, 0xd8, 0x39, 0x92, 0x3c, 0x22, 0x13, 0x72, 0x71, 0x52,
	0x6c, 0xc2, 0x2b, 0xab, 0xf2, 0x1b, 0xff, 0xb2, 0x10, 0xb6, 0x08, 0xb2, 0x26, 0xdc, 0x8e, 0xbf,
	0xc9, 0x9a, 0x70, 0xd4, 0x01, 0x88, 0x86, 0x21, 0x21, 0x54, 0x62, 0xa5, 0x25, 0xd6, 0x83, 0x45,
	0xb0, 0xfa, 0x32, 0x4a, 0x80, 0xe5, 0xa2, 0xe4, 0x11, 0x1d, 0xc3, 0x86, 0x4b, 0xce, 0xfd, 0x21,
	0x71, 0xf0, 0x50, 0xdc, 0x5e, 0x25, 0xb3, 0xf8, 0x05, 0xb4, 0x64, 0x60, 0x43, 0xc6, 0xd9, 0x05,
	0x77, 0x66, 0x85, 0x4e, 0xa0, 0x18, 0x8d, 0x09, 0x19, 0x9e, 0x39, 0x21, 0x89, 0x26, 0x01, 0x8f,
	0x2a, 0xa9, 0x9d, 0xd5, 0xdd, 0x7c, 0x7d, 0x7f, 0xa1, 0x44, 0x65, 0xa4, 0x4d, 0x86, 0xcc, 0xa3,
	0xbe, 0x04, 0x97, 0x18, 0xf6, 0x46, 0xa4, 0x1c, 0x12, 0x11, 0xfd, 0x17, 0xca, 0xae, 0x8f, 0x03,
	0xe6, 0x39, 0x11, 0xc7, 0x9c, 0xc8, 0xe3, 0x58, 0x93, 0xd9, 0xd7, 0x17, 0xca, 0x5e, 0xc6, 0xf6,
	0x45, 0xa8, 0x38, 0x93, 0xa2, 0x3b, 0xb7, 0x16, 0xc7, 0xec, 0x92, 0x93, 0x89, 0xe7, 0xf8, 0xf4,
	0x94, 0x55, 0xb2, 0x8b, 0x1f, 0x73, 0x4b, 0x44, 0x99, 0xf4, 0x94, 0xd9, 0x39, 0x37, 0x79, 0xd4,
	0xff, 0x09, 0xb9, 0x29, 0x2f, 0xd0, 0x16, 0xdc, 0x32, 0x5e, 0x1a, 0xdd, 0x81, 0x33, 0x78, 0xdd,
	0x33, 0x9c, 0xe3, 0x6e, 0xbf, 0x67, 0x34, 0xcd, 0xb6, 0x69, 0xb4, 0xca, 0x2b, 0xe8, 0x26, 0x94,
	0x8d, 0x6e, 0xcb, 0xb1, 0xda, 0xce, 0xf1, 0x60, 0x60, 0xd8, 0x8d, 0x6e, 0xd3, 0x28, 0x6b, 0xba,
	0x09, 0xb9, 0x29, 0x2c, 0x7a, 0x02, 0xdb, 0x98, 0x79, 0x0e, 0xf6, 0x24, 0x59, 0xd9, 0xa5, 0x74,
	0x9d, 0xb7, 0x11, 0xa3, 0x92, 0xb9, 0x39, 0xfb, 0x36, 0x66, 0x5e, 0x43, 0xec, 0x18, 0xb0, 0x46,
	0xe2, 0x7f, 0x1e, 0x31, 0xaa, 0x7f, 0x9f, 0x86, 0xc2, 0xac, 0x72, 0xd0, 0x1b, 0x28, 0x25, 0x7a,
	0x71, 0xe6, 0x44, 0xb8, 0xb7, 0x30, 0x41, 0x4d, 0x3a, 0x55, 0xe1, 0x06, 0x9e, 0x35, 0xa0, 0xbb,
	0x00, 0x9c, 0x7c, 0xe0, 0xce, 0xbb, 0x09, 0x09, 0x2f, 0x24, 0xb7, 0x72, 0x87, 0x2b, 0x76, 0x4e,
	0xd8, 0x5e, 0x08, 0x93, 0xb8, 0xc4, 0xa9, 0x30, 0x92, 0xd7, 0xa7, 0x16, 0xbf, 0xc4, 0x44, 0x1f,
	0xf1, 0xeb, 0xec, 0x22, 0x9e, 0x5b, 0x23, 0x07, 0x36, 0x2f, 0xb5, 0x92, 0xc0, 0xc7, 0x77, 0xf9,
	0x68, 0x29, 0xc9, 0x28, 0xfc, 0x52, 0x34, 0x6f, 0x40, 0xaf, 0xa1, 0x34, 0xc7, 0x41, 0x9f, 0x2a,
	0x75, 0xef, 0x2d, 0x49, 0x41, 0x93, 0xda, 0x1b, 0xee, 0xec, 0x72, 0x46, 0x99, 0x2a, 0xef, 0xf4,
	0xb2, 0xca, 0x54, 0x49, 0x2b, 0x65, 0xaa, 0x8c, 0x6d, 0x28, 0xc4, 0xbc, 0x56, 0xa8, 0xb1, 0x62,
	0x6a, 0x0b, 0x33, 0x5b, 0x81, 0xe6, 0xdd, 0xcb, 0xc5, 0xb4, 0xaa, 0x7e, 0x27, 0x0a, 0xfb, 0xdc,
	0xfd, 0xbf, 0x84, 0x2c, 0xa1, 0x43, 0xe6, 0xfa, 0xd4, 0x53, 0x25, 0xf5, 0xf1, 0xd2, 0xac, 0xaa,
	0x1a, 0x0a, 0xc1, 0x9e, 0x62, 0xa1, 0xfb, 0xb0, 0x19, 0xe1, 0xd1, 0x38, 0x20, 0x4e, 0x28, 0x8e,
	0xfd, 0x8c, 0x84, 0xfc, 0xff, 0x92, 0x37, 0x6b, 0x76, 0x29, 0x76, 0xd8, 0x98, 0x93, 0x43, 0x61,
	0xd6, 0x9f, 0x40, 0x36, 0x41, 0x40, 0x15, 0xb8, 0x69, 0x74, 0x9b, 0x56, 0xcb, 0xec, 0x1e, 0x5c,
	0x11, 0x5e, 0x01, 0xb2, 0x1d, 0xb3, 0x6b, 0x34, 0xec, 0xbd, 0xbf, 0x95, 0x35, 0x94, 0x85, 0x74,
	0xbb, 0xd3, 0x68, 0x96, 0x53, 0xfa, 0x97, 0x29, 0x28, 0xce, 0xb3, 0x0c, 0xbd, 0xfa, 0xd9, 0x47,
	0xed, 0x2f, 0xcf, 0xd5, 0xdf, 0xf8, 0x55, 0xe8, 0xcf, 0xb0, 0x79, 0xce, 0x82, 0xc9, 0x88, 0x38,
	0x63, 0x12, 0x0e, 0x09, 0xe5, 0xd8, 0x23, 0x92, 0x7b, 0x6b, 0x76, 0x39, 0x76, 0xf4, 0xa6, 0x76,
	0xbd, 0xf3, 0x09, 0x47, 0xb0, 0x0e, 0xab, 0x47, 0xbd, 0x47, 0xe5, 0x14, 0x2a, 0x41, 0xde, 0xea,
	0x1d, 0xf7, 0x1d, 0xb3, 0xeb, 0x58, 0x07, 0x07, 0xe5, 0x55, 0xfd, 0x5b, 0x0d, 0x4a, 0x57, 0x94,
	0x81, 0x1c, 0xc8, 0x2b, 0xa5, 0x8d, 0x98, 0x9b, 0xb4, 0xcf, 0xa7, 0x9f, 0xa0, 0x31, 0xb5, 0x3e,
	0x62, 0x2e, 0xb1, 0x55, 0xa3, 0x13, 0xcf, 0xfa, 0xbf, 0x00, 0x2e, 0x3d, 0x68, 0x1b, 0x6e, 0xf7,
	0x9b, 0xb6, 0x61, 0x74, 0x9d, 0x23, 0xab, 0x75, 0xb5, 0x86, 0xae, 0xc3, 0xaa, 0xd5, 0x6e, 0x97,
	0x35, 0x94, 0x87, 0xf5, 0x5e, 0xa7, 0xf1, 0xda, 0xec, 0x8a, 0xac, 0x7f, 0xd0, 0x60, 0x63, 0x4e,
	0x70, 0xe8, 0x01, 0xa0, 0x21, 0xa3, 0xe7, 0x24, 0x8c, 0xe4, 0xe0, 0x12, 0x4b, 0x58, 0xa6, 0x5e,
	0xb0, 0x37, 0x67, 0x3d, 0x32, 0x00, 0xfd, 0x11, 0x36, 0x02, 0x4c, 0xbd, 0x09, 0xf6, 0x84, 0x24,
	0x5d, 0x22, 0x6f, 0x26, 0x67, 0x17, 0x12, 0x63, 0x53, 0x24, 0xf6, 0x06, 0x4a, 0x4a, 0xb5, 0x01,
	0x1b, 0xca, 0xe0, 0xa5, 0x7a, 0x92, 0x0c, 0xed, 0xa8, 0x48, 0xbb, 0xe8, 0xce, 0xad, 0x51, 0x15,
	0x6e, 0xf8, 0x91, 0x43, 0xc9, 0x7b, 0x67, 0x36, 0xbb, 0xca, 0xfa, 0x8e, 0xb6, 0x9b, 0xb5, 0x37,
	0xfd, 0xa8, 0x4b, 0xde, 0x37, 0x67, 0x1c, 0x7a, 0x1f, 0x0a, 0xb3, 0x95, 0x00, 0x6d, 0x43, 0x4e,
	0x25, 0xe7, 0xbb, 0xaa, 0x4f, 0x64, 0x63, 0x83, 0xe9, 0xa2, 0x7b, 0xd3, 0xcc, 0xc5, 0x0d, 0x06,
	0x62, 0xcb, 0xaa, 0xdc, 0xa2, 0xca, 0x90, 0x38, 0xf7, 0xc0, 0x74, 0xf5, 0x3f, 0x41, 0x36, 0x61,
	0x32, 0xfa, 0x3d, 0x40, 0x5c, 0xbd, 0x5d, 0xcc, 0xb1, 0x3a, 0xb9, 0x78, 0xd0, 0x69, 0x61, 0x8e,
	0xf5, 0xaf, 0x34, 0xc8, 0x4d, 0xaf, 0x17, 0x75, 0x20, 0x73, 0xca, 0xc2, 0x11, 0xe6, 0x8a, 0x1d,
	0x7f, 0x5d, 0x8a, 0x1d, 0xd5, 0xb6, 0x8c, 0xb5, 0x15, 0x06, 0x42, 0x90, 0x96, 0x2f, 0x95, 0x23,
	0x9e, 0x2d, 0x9f, 0xf5, 0xfb, 0x90, 0x89, 0x77, 0xa1, 0x5b, 0x80, 0xda, 0x96, 0x7d, 0xd4, 0x18,
	0x5c, 0xa1, 0x46, 0x16, 0xd2, 0x87, 0x83, 0xa3, 0x4e, 0x59, 0xd3, 0x9f, 0x26, 0x67, 0xa3, 0x26,
	0x96, 0x2a, 0xdc, 0x50, 0x9f, 0x1f, 0xc6, 0x43, 0xe9, 0x6c, 0x37, 0xdd, 0x8c, 0x5d, 0x6a, 0x5c,
	0x95, 0x7d, 0xf4, 0x15, 0xdc, 0xbe, 0x66, 0x4e, 0x41, 0x7f, 0x00, 0xe0, 0x21, 0xa6, 0xd1, 0x30,
	0xf4, 0xc7, 0x5c, 0x21, 0xcc, 0x58, 0xd0, 0x1d, 0xc8, 0x45, 0x1c, 0x9f, 0xf8, 0x81, 0xcf, 0x2f,
	0x64, 0xfe, 0x29, 0xfb, 0xd2, 0xa0, 0xff, 0x98, 0x82, 0xe2, 0xfc, 0x6c, 0x82, 0x1e, 0xc3, 0xef,
	0xa2, 0xc9, 0x78, 0x1c, 0x90, 0x91, 0xd0, 0x73, 0xe0, 0xb8, 0x7e, 0x34, 0x0e, 0xf0, 0x85, 0x23,
	0xda, 0x68, 0xd2, 0xef, 0x67, 0x37, 0xb4, 0x62, 0xff, 0x80, 0x7c, 0xe0, 0xd7, 0x90, 0x3c, 0x75,
	0x1d, 0xc9, 0xdf, 0x42, 0x69, 0xe4, 0x0f, 0x43, 0x36, 0x3e, 0x63, 0x34, 0x66, 0x82, 0x64, 0x41,
	0xb1, 0xde, 0x58, 0x7e, 0xa6, 0xaa, 0x1e, 0x4d, 0x91, 0xa4, 0x9c, 0x8b, 0xa3, 0xb9, 0xf5, 0xc7,
	0x4b, 0x58, 0xfa, 0x9a, 0x12, 0xf6, 0x3f, 0x28, 0xce, 0xc3, 0xa1, 0xbb, 0xb0, 0x7d, 0x64, 0x36,
	0x6d, 0xab, 0x77, 0x68, 0x75, 0x8d, 0x8f, 0xd5, 0x81, 0x9b, 0x50, 0x6e, 0x76, 0xac, 0xbe, 0xe1,
	0x5c, 0x6e, 0x2b, 0x6b, 0xc2, 0xda, 0x32, 0x1b, 0x1d, 0xeb, 0xc0, 0x69, 0x5b, 0x9d, 0x8e, 0xf5,
	0xca, 0xb1, 0xba, 0xe5, 0x94, 0xfe, 0x0f, 0xc8, 0xcf, 0xb4, 0x37, 0x51, 0x89, 0x43, 0xc2, 0x27,
	0x21, 0x75, 0x66, 0x86, 0xc0, 0x8c, 0xd4, 0x59, 0x29, 0x76, 0x4c, 0xe7, 0x31, 0xfd, 0x05, 0x14,
	0xe7, 0x75, 0x8b, 0xfe, 0x0e, 0xf9, 0x21, 0x63, 0xa1, 0xeb, 0x53, 0xcc, 0x49, 0xa4, 0xc6, 0xa9,
	0x1b, 0xc9, 0x01, 0x8a, 0x56, 0x59, 0xed, 0x60, 0xde, 0xa1, 0x62, 0x60, 0x9a, 0xdd, 0x99, 0x34,
	0xd2, 0xfa, 0xe7, 0x1a, 0x6c, 0x1a, 0xea, 0x74, 0xa7, 0xe3, 0x1b, 0x8a, 0x20, 0x13, 0x2f, 0xd0,
	0xde, 0x32, 0xff, 0x25, 0x92, 0xb3, 0x5b, 0xf5, 0xe5, 0x7f, 0x65, 0x76, 0xb5, 0x87, 0xda, 0xb3,
	0x2f, 0x34, 0xb8, 0x37, 0x64, 0xa3, 0x05, 0xa2, 0x9f, 0x15, 0xa7, 0xa9, 0xf6, 0xc4, 0x7f, 0x5e,
	0x4f, 0xfb, 0xcf, 0x73, 0x15, 0xe5, 0x31, 0x51, 0x24, 0xab, 0x2c, 0xf4, 0x6a, 0x1e, 0xa1, 0xf2,
	0x2f, 0xb0, 0x16, 0xbb, 0xf0, 0xd8, 0x8f, 0x7e, 0xe9, 0x0f, 0x75, 0x3f, 0xb1, 0x7c, 0x9d, 0xca,
	0x34, 0xfa, 0x83, 0x7e, 0xeb, 0xdf, 0x27, 0x19, 0x19, 0xff, 0xe8, 0xa7, 0x00, 0x00, 0x00, 0xff,
	0xff, 0xb9, 0x08, 0x29, 0x0f, 0xe0, 0x0e, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// EmbeddedAssistantClient is the client API for EmbeddedAssistant service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type EmbeddedAssistantClient interface {
	// Initiates or continues a conversation with the embedded Assistant Service.
	// Each call performs one round-trip, sending an audio request to the service
	// and receiving the audio response. Uses bidirectional streaming to receive
	// results, such as the `END_OF_UTTERANCE` event, while sending audio.
	//
	// A conversation is one or more gRPC connections, each consisting of several
	// streamed requests and responses.
	// For example, the user says *Add to my shopping list* and the Assistant
	// responds *What do you want to add?*. The sequence of streamed requests and
	// responses in the first gRPC message could be:
	//
	// *   AssistRequest.config
	// *   AssistRequest.audio_in
	// *   AssistRequest.audio_in
	// *   AssistRequest.audio_in
	// *   AssistRequest.audio_in
	// *   AssistResponse.event_type.END_OF_UTTERANCE
	// *   AssistResponse.speech_results.transcript "add to my shopping list"
	// *   AssistResponse.dialog_state_out.microphone_mode.DIALOG_FOLLOW_ON
	// *   AssistResponse.audio_out
	// *   AssistResponse.audio_out
	// *   AssistResponse.audio_out
	//
	//
	// The user then says *bagels* and the Assistant responds
	// *OK, I've added bagels to your shopping list*. This is sent as another gRPC
	// connection call to the `Assist` method, again with streamed requests and
	// responses, such as:
	//
	// *   AssistRequest.config
	// *   AssistRequest.audio_in
	// *   AssistRequest.audio_in
	// *   AssistRequest.audio_in
	// *   AssistResponse.event_type.END_OF_UTTERANCE
	// *   AssistResponse.dialog_state_out.microphone_mode.CLOSE_MICROPHONE
	// *   AssistResponse.audio_out
	// *   AssistResponse.audio_out
	// *   AssistResponse.audio_out
	// *   AssistResponse.audio_out
	//
	// Although the precise order of responses is not guaranteed, sequential
	// `AssistResponse.audio_out` messages will always contain sequential portions
	// of audio.
	Assist(ctx context.Context, opts ...grpc.CallOption) (EmbeddedAssistant_AssistClient, error)
}

type embeddedAssistantClient struct {
	cc *grpc.ClientConn
}

func NewEmbeddedAssistantClient(cc *grpc.ClientConn) EmbeddedAssistantClient {
	return &embeddedAssistantClient{cc}
}

func (c *embeddedAssistantClient) Assist(ctx context.Context, opts ...grpc.CallOption) (EmbeddedAssistant_AssistClient, error) {
	stream, err := c.cc.NewStream(ctx, &_EmbeddedAssistant_serviceDesc.Streams[0], "/google.assistant.embedded.v1alpha2.EmbeddedAssistant/Assist", opts...)
	if err != nil {
		return nil, err
	}
	x := &embeddedAssistantAssistClient{stream}
	return x, nil
}

type EmbeddedAssistant_AssistClient interface {
	Send(*AssistRequest) error
	Recv() (*AssistResponse, error)
	grpc.ClientStream
}

type embeddedAssistantAssistClient struct {
	grpc.ClientStream
}

func (x *embeddedAssistantAssistClient) Send(m *AssistRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *embeddedAssistantAssistClient) Recv() (*AssistResponse, error) {
	m := new(AssistResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// EmbeddedAssistantServer is the server API for EmbeddedAssistant service.
type EmbeddedAssistantServer interface {
	// Initiates or continues a conversation with the embedded Assistant Service.
	// Each call performs one round-trip, sending an audio request to the service
	// and receiving the audio response. Uses bidirectional streaming to receive
	// results, such as the `END_OF_UTTERANCE` event, while sending audio.
	//
	// A conversation is one or more gRPC connections, each consisting of several
	// streamed requests and responses.
	// For example, the user says *Add to my shopping list* and the Assistant
	// responds *What do you want to add?*. The sequence of streamed requests and
	// responses in the first gRPC message could be:
	//
	// *   AssistRequest.config
	// *   AssistRequest.audio_in
	// *   AssistRequest.audio_in
	// *   AssistRequest.audio_in
	// *   AssistRequest.audio_in
	// *   AssistResponse.event_type.END_OF_UTTERANCE
	// *   AssistResponse.speech_results.transcript "add to my shopping list"
	// *   AssistResponse.dialog_state_out.microphone_mode.DIALOG_FOLLOW_ON
	// *   AssistResponse.audio_out
	// *   AssistResponse.audio_out
	// *   AssistResponse.audio_out
	//
	//
	// The user then says *bagels* and the Assistant responds
	// *OK, I've added bagels to your shopping list*. This is sent as another gRPC
	// connection call to the `Assist` method, again with streamed requests and
	// responses, such as:
	//
	// *   AssistRequest.config
	// *   AssistRequest.audio_in
	// *   AssistRequest.audio_in
	// *   AssistRequest.audio_in
	// *   AssistResponse.event_type.END_OF_UTTERANCE
	// *   AssistResponse.dialog_state_out.microphone_mode.CLOSE_MICROPHONE
	// *   AssistResponse.audio_out
	// *   AssistResponse.audio_out
	// *   AssistResponse.audio_out
	// *   AssistResponse.audio_out
	//
	// Although the precise order of responses is not guaranteed, sequential
	// `AssistResponse.audio_out` messages will always contain sequential portions
	// of audio.
	Assist(EmbeddedAssistant_AssistServer) error
}

func RegisterEmbeddedAssistantServer(s *grpc.Server, srv EmbeddedAssistantServer) {
	s.RegisterService(&_EmbeddedAssistant_serviceDesc, srv)
}

func _EmbeddedAssistant_Assist_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(EmbeddedAssistantServer).Assist(&embeddedAssistantAssistServer{stream})
}

type EmbeddedAssistant_AssistServer interface {
	Send(*AssistResponse) error
	Recv() (*AssistRequest, error)
	grpc.ServerStream
}

type embeddedAssistantAssistServer struct {
	grpc.ServerStream
}

func (x *embeddedAssistantAssistServer) Send(m *AssistResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *embeddedAssistantAssistServer) Recv() (*AssistRequest, error) {
	m := new(AssistRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _EmbeddedAssistant_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.assistant.embedded.v1alpha2.EmbeddedAssistant",
	HandlerType: (*EmbeddedAssistantServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "Assist",
			Handler:       _EmbeddedAssistant_Assist_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google/assistant/embedded/v1alpha2/embedded_assistant.proto",
}
