// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/dialogflow/v2beta1/intent.proto

package dialogflow

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	empty "github.com/golang/protobuf/ptypes/empty"
	_struct "github.com/golang/protobuf/ptypes/struct"
	context "golang.org/x/net/context"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Represents the options for views of an intent.
// An intent can be a sizable object. Therefore, we provide a resource view that
// does not return training phrases in the response by default.
type IntentView int32

const (
	// Training phrases field is not populated in the response.
	IntentView_INTENT_VIEW_UNSPECIFIED IntentView = 0
	// All fields are populated.
	IntentView_INTENT_VIEW_FULL IntentView = 1
)

var IntentView_name = map[int32]string{
	0: "INTENT_VIEW_UNSPECIFIED",
	1: "INTENT_VIEW_FULL",
}

var IntentView_value = map[string]int32{
	"INTENT_VIEW_UNSPECIFIED": 0,
	"INTENT_VIEW_FULL":        1,
}

func (x IntentView) String() string {
	return proto.EnumName(IntentView_name, int32(x))
}

func (IntentView) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0}
}

// Represents the different states that webhooks can be in.
type Intent_WebhookState int32

const (
	// Webhook is disabled in the agent and in the intent.
	Intent_WEBHOOK_STATE_UNSPECIFIED Intent_WebhookState = 0
	// Webhook is enabled in the agent and in the intent.
	Intent_WEBHOOK_STATE_ENABLED Intent_WebhookState = 1
	// Webhook is enabled in the agent and in the intent. Also, each slot
	// filling prompt is forwarded to the webhook.
	Intent_WEBHOOK_STATE_ENABLED_FOR_SLOT_FILLING Intent_WebhookState = 2
)

var Intent_WebhookState_name = map[int32]string{
	0: "WEBHOOK_STATE_UNSPECIFIED",
	1: "WEBHOOK_STATE_ENABLED",
	2: "WEBHOOK_STATE_ENABLED_FOR_SLOT_FILLING",
}

var Intent_WebhookState_value = map[string]int32{
	"WEBHOOK_STATE_UNSPECIFIED":              0,
	"WEBHOOK_STATE_ENABLED":                  1,
	"WEBHOOK_STATE_ENABLED_FOR_SLOT_FILLING": 2,
}

func (x Intent_WebhookState) String() string {
	return proto.EnumName(Intent_WebhookState_name, int32(x))
}

func (Intent_WebhookState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 0}
}

// Represents different types of training phrases.
type Intent_TrainingPhrase_Type int32

const (
	// Not specified. This value should never be used.
	Intent_TrainingPhrase_TYPE_UNSPECIFIED Intent_TrainingPhrase_Type = 0
	// Examples do not contain @-prefixed entity type names, but example parts
	// can be annotated with entity types.
	Intent_TrainingPhrase_EXAMPLE Intent_TrainingPhrase_Type = 1
	// Templates are not annotated with entity types, but they can contain
	// @-prefixed entity type names as substrings.
	Intent_TrainingPhrase_TEMPLATE Intent_TrainingPhrase_Type = 2
)

var Intent_TrainingPhrase_Type_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "EXAMPLE",
	2: "TEMPLATE",
}

var Intent_TrainingPhrase_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED": 0,
	"EXAMPLE":          1,
	"TEMPLATE":         2,
}

func (x Intent_TrainingPhrase_Type) String() string {
	return proto.EnumName(Intent_TrainingPhrase_Type_name, int32(x))
}

func (Intent_TrainingPhrase_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 0, 0}
}

// Represents different platforms that a rich message can be intended for.
type Intent_Message_Platform int32

const (
	// Not specified.
	Intent_Message_PLATFORM_UNSPECIFIED Intent_Message_Platform = 0
	// Facebook.
	Intent_Message_FACEBOOK Intent_Message_Platform = 1
	// Slack.
	Intent_Message_SLACK Intent_Message_Platform = 2
	// Telegram.
	Intent_Message_TELEGRAM Intent_Message_Platform = 3
	// Kik.
	Intent_Message_KIK Intent_Message_Platform = 4
	// Skype.
	Intent_Message_SKYPE Intent_Message_Platform = 5
	// Line.
	Intent_Message_LINE Intent_Message_Platform = 6
	// Viber.
	Intent_Message_VIBER Intent_Message_Platform = 7
	// Actions on Google.
	// When using Actions on Google, you can choose one of the specific
	// Intent.Message types that mention support for Actions on Google,
	// or you can use the advanced Intent.Message.payload field.
	// The payload field provides access to AoG features not available in the
	// specific message types.
	// If using the Intent.Message.payload field, it should have a structure
	// similar to the JSON message shown here. For more information, see
	// [Actions on Google Webhook
	// Format](https://developers.google.com/actions/dialogflow/webhook)
	// <pre>{
	//   "expectUserResponse": true,
	//   "isSsml": false,
	//   "noInputPrompts": [],
	//   "richResponse": {
	//     "items": [
	//       {
	//         "simpleResponse": {
	//           "displayText": "hi",
	//           "textToSpeech": "hello"
	//         }
	//       }
	//     ],
	//     "suggestions": [
	//       {
	//         "title": "Say this"
	//       },
	//       {
	//         "title": "or this"
	//       }
	//     ]
	//   },
	//   "systemIntent": {
	//     "data": {
	//       "@type": "type.googleapis.com/google.actions.v2.OptionValueSpec",
	//       "listSelect": {
	//         "items": [
	//           {
	//             "optionInfo": {
	//               "key": "key1",
	//               "synonyms": [
	//                 "key one"
	//               ]
	//             },
	//             "title": "must not be empty, but unique"
	//           },
	//           {
	//             "optionInfo": {
	//               "key": "key2",
	//               "synonyms": [
	//                 "key two"
	//               ]
	//             },
	//             "title": "must not be empty, but unique"
	//           }
	//         ]
	//       }
	//     },
	//     "intent": "actions.intent.OPTION"
	//   }
	// }</pre>
	Intent_Message_ACTIONS_ON_GOOGLE Intent_Message_Platform = 8
	// Telephony Gateway.
	Intent_Message_TELEPHONY Intent_Message_Platform = 10
)

var Intent_Message_Platform_name = map[int32]string{
	0:  "PLATFORM_UNSPECIFIED",
	1:  "FACEBOOK",
	2:  "SLACK",
	3:  "TELEGRAM",
	4:  "KIK",
	5:  "SKYPE",
	6:  "LINE",
	7:  "VIBER",
	8:  "ACTIONS_ON_GOOGLE",
	10: "TELEPHONY",
}

var Intent_Message_Platform_value = map[string]int32{
	"PLATFORM_UNSPECIFIED": 0,
	"FACEBOOK":             1,
	"SLACK":                2,
	"TELEGRAM":             3,
	"KIK":                  4,
	"SKYPE":                5,
	"LINE":                 6,
	"VIBER":                7,
	"ACTIONS_ON_GOOGLE":    8,
	"TELEPHONY":            10,
}

func (x Intent_Message_Platform) String() string {
	return proto.EnumName(Intent_Message_Platform_name, int32(x))
}

func (Intent_Message_Platform) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 0}
}

// Represents an intent.
// Intents convert a number of user expressions or patterns into an action. An
// action is an extraction of a user command or sentence semantics.
type Intent struct {
	// Required for all methods except `create` (`create` populates the name
	// automatically.
	// The unique identifier of this intent.
	// Format: `projects/<Project ID>/agent/intents/<Intent ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The name of this intent.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. Indicates whether webhooks are enabled for the intent.
	WebhookState Intent_WebhookState `protobuf:"varint,6,opt,name=webhook_state,json=webhookState,proto3,enum=google.cloud.dialogflow.v2beta1.Intent_WebhookState" json:"webhook_state,omitempty"`
	// Optional. The priority of this intent. Higher numbers represent higher
	// priorities. Zero or negative numbers mean that the intent is disabled.
	Priority int32 `protobuf:"varint,3,opt,name=priority,proto3" json:"priority,omitempty"`
	// Optional. Indicates whether this is a fallback intent.
	IsFallback bool `protobuf:"varint,4,opt,name=is_fallback,json=isFallback,proto3" json:"is_fallback,omitempty"`
	// Optional. Indicates whether Machine Learning is enabled for the intent.
	// Note: If `ml_enabled` setting is set to false, then this intent is not
	// taken into account during inference in `ML ONLY` match mode. Also,
	// auto-markup in the UI is turned off.
	// DEPRECATED! Please use `ml_disabled` field instead.
	// NOTE: If both `ml_enabled` and `ml_disabled` are either not set or false,
	// then the default value is determined as follows:
	// - Before April 15th, 2018 the default is:
	//   ml_enabled = false / ml_disabled = true.
	// - After April 15th, 2018 the default is:
	//   ml_enabled = true / ml_disabled = false.
	MlEnabled bool `protobuf:"varint,5,opt,name=ml_enabled,json=mlEnabled,proto3" json:"ml_enabled,omitempty"` // Deprecated: Do not use.
	// Optional. Indicates whether Machine Learning is disabled for the intent.
	// Note: If `ml_disabled` setting is set to true, then this intent is not
	// taken into account during inference in `ML ONLY` match mode. Also,
	// auto-markup in the UI is turned off.
	MlDisabled bool `protobuf:"varint,19,opt,name=ml_disabled,json=mlDisabled,proto3" json:"ml_disabled,omitempty"`
	// Optional. Indicates that this intent ends an interaction. Some integrations
	// (e.g., Actions on Google or Dialogflow phone gateway) use this information
	// to close interaction with an end user. Default is false.
	EndInteraction bool `protobuf:"varint,21,opt,name=end_interaction,json=endInteraction,proto3" json:"end_interaction,omitempty"`
	// Optional. The list of context names required for this intent to be
	// triggered.
	// Format: `projects/<Project ID>/agent/sessions/-/contexts/<Context ID>`.
	InputContextNames []string `protobuf:"bytes,7,rep,name=input_context_names,json=inputContextNames,proto3" json:"input_context_names,omitempty"`
	// Optional. The collection of event names that trigger the intent.
	// If the collection of input contexts is not empty, all of the contexts must
	// be present in the active user session for an event to trigger this intent.
	Events []string `protobuf:"bytes,8,rep,name=events,proto3" json:"events,omitempty"`
	// Optional. The collection of examples/templates that the agent is
	// trained on.
	TrainingPhrases []*Intent_TrainingPhrase `protobuf:"bytes,9,rep,name=training_phrases,json=trainingPhrases,proto3" json:"training_phrases,omitempty"`
	// Optional. The name of the action associated with the intent.
	// Note: The action name must not contain whitespaces.
	Action string `protobuf:"bytes,10,opt,name=action,proto3" json:"action,omitempty"`
	// Optional. The collection of contexts that are activated when the intent
	// is matched. Context messages in this collection should not set the
	// parameters field. Setting the `lifespan_count` to 0 will reset the context
	// when the intent is matched.
	// Format: `projects/<Project ID>/agent/sessions/-/contexts/<Context ID>`.
	OutputContexts []*Context `protobuf:"bytes,11,rep,name=output_contexts,json=outputContexts,proto3" json:"output_contexts,omitempty"`
	// Optional. Indicates whether to delete all contexts in the current
	// session when this intent is matched.
	ResetContexts bool `protobuf:"varint,12,opt,name=reset_contexts,json=resetContexts,proto3" json:"reset_contexts,omitempty"`
	// Optional. The collection of parameters associated with the intent.
	Parameters []*Intent_Parameter `protobuf:"bytes,13,rep,name=parameters,proto3" json:"parameters,omitempty"`
	// Optional. The collection of rich messages corresponding to the
	// `Response` field in the Dialogflow console.
	Messages []*Intent_Message `protobuf:"bytes,14,rep,name=messages,proto3" json:"messages,omitempty"`
	// Optional. The list of platforms for which the first response will be
	// taken from among the messages assigned to the DEFAULT_PLATFORM.
	DefaultResponsePlatforms []Intent_Message_Platform `protobuf:"varint,15,rep,packed,name=default_response_platforms,json=defaultResponsePlatforms,proto3,enum=google.cloud.dialogflow.v2beta1.Intent_Message_Platform" json:"default_response_platforms,omitempty"`
	// The unique identifier of the root intent in the chain of followup intents.
	// It identifies the correct followup intents chain for this intent.
	// Format: `projects/<Project ID>/agent/intents/<Intent ID>`.
	RootFollowupIntentName string `protobuf:"bytes,16,opt,name=root_followup_intent_name,json=rootFollowupIntentName,proto3" json:"root_followup_intent_name,omitempty"`
	// The unique identifier of the parent intent in the chain of followup
	// intents.
	// It identifies the parent followup intent.
	// Format: `projects/<Project ID>/agent/intents/<Intent ID>`.
	ParentFollowupIntentName string `protobuf:"bytes,17,opt,name=parent_followup_intent_name,json=parentFollowupIntentName,proto3" json:"parent_followup_intent_name,omitempty"`
	// Optional. Collection of information about all followup intents that have
	// name of this intent as a root_name.
	FollowupIntentInfo   []*Intent_FollowupIntentInfo `protobuf:"bytes,18,rep,name=followup_intent_info,json=followupIntentInfo,proto3" json:"followup_intent_info,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *Intent) Reset()         { *m = Intent{} }
func (m *Intent) String() string { return proto.CompactTextString(m) }
func (*Intent) ProtoMessage()    {}
func (*Intent) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0}
}

func (m *Intent) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent.Unmarshal(m, b)
}
func (m *Intent) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent.Marshal(b, m, deterministic)
}
func (m *Intent) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent.Merge(m, src)
}
func (m *Intent) XXX_Size() int {
	return xxx_messageInfo_Intent.Size(m)
}
func (m *Intent) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent.DiscardUnknown(m)
}

var xxx_messageInfo_Intent proto.InternalMessageInfo

func (m *Intent) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Intent) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Intent) GetWebhookState() Intent_WebhookState {
	if m != nil {
		return m.WebhookState
	}
	return Intent_WEBHOOK_STATE_UNSPECIFIED
}

func (m *Intent) GetPriority() int32 {
	if m != nil {
		return m.Priority
	}
	return 0
}

func (m *Intent) GetIsFallback() bool {
	if m != nil {
		return m.IsFallback
	}
	return false
}

// Deprecated: Do not use.
func (m *Intent) GetMlEnabled() bool {
	if m != nil {
		return m.MlEnabled
	}
	return false
}

func (m *Intent) GetMlDisabled() bool {
	if m != nil {
		return m.MlDisabled
	}
	return false
}

func (m *Intent) GetEndInteraction() bool {
	if m != nil {
		return m.EndInteraction
	}
	return false
}

func (m *Intent) GetInputContextNames() []string {
	if m != nil {
		return m.InputContextNames
	}
	return nil
}

func (m *Intent) GetEvents() []string {
	if m != nil {
		return m.Events
	}
	return nil
}

func (m *Intent) GetTrainingPhrases() []*Intent_TrainingPhrase {
	if m != nil {
		return m.TrainingPhrases
	}
	return nil
}

func (m *Intent) GetAction() string {
	if m != nil {
		return m.Action
	}
	return ""
}

func (m *Intent) GetOutputContexts() []*Context {
	if m != nil {
		return m.OutputContexts
	}
	return nil
}

func (m *Intent) GetResetContexts() bool {
	if m != nil {
		return m.ResetContexts
	}
	return false
}

func (m *Intent) GetParameters() []*Intent_Parameter {
	if m != nil {
		return m.Parameters
	}
	return nil
}

func (m *Intent) GetMessages() []*Intent_Message {
	if m != nil {
		return m.Messages
	}
	return nil
}

func (m *Intent) GetDefaultResponsePlatforms() []Intent_Message_Platform {
	if m != nil {
		return m.DefaultResponsePlatforms
	}
	return nil
}

func (m *Intent) GetRootFollowupIntentName() string {
	if m != nil {
		return m.RootFollowupIntentName
	}
	return ""
}

func (m *Intent) GetParentFollowupIntentName() string {
	if m != nil {
		return m.ParentFollowupIntentName
	}
	return ""
}

func (m *Intent) GetFollowupIntentInfo() []*Intent_FollowupIntentInfo {
	if m != nil {
		return m.FollowupIntentInfo
	}
	return nil
}

// Represents an example or template that the agent is trained on.
type Intent_TrainingPhrase struct {
	// Required. The unique identifier of this training phrase.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The type of the training phrase.
	Type Intent_TrainingPhrase_Type `protobuf:"varint,2,opt,name=type,proto3,enum=google.cloud.dialogflow.v2beta1.Intent_TrainingPhrase_Type" json:"type,omitempty"`
	// Required. The collection of training phrase parts (can be annotated).
	// Fields: `entity_type`, `alias` and `user_defined` should be populated
	// only for the annotated parts of the training phrase.
	Parts []*Intent_TrainingPhrase_Part `protobuf:"bytes,3,rep,name=parts,proto3" json:"parts,omitempty"`
	// Optional. Indicates how many times this example or template was added to
	// the intent. Each time a developer adds an existing sample by editing an
	// intent or training, this counter is increased.
	TimesAddedCount      int32    `protobuf:"varint,4,opt,name=times_added_count,json=timesAddedCount,proto3" json:"times_added_count,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Intent_TrainingPhrase) Reset()         { *m = Intent_TrainingPhrase{} }
func (m *Intent_TrainingPhrase) String() string { return proto.CompactTextString(m) }
func (*Intent_TrainingPhrase) ProtoMessage()    {}
func (*Intent_TrainingPhrase) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 0}
}

func (m *Intent_TrainingPhrase) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_TrainingPhrase.Unmarshal(m, b)
}
func (m *Intent_TrainingPhrase) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_TrainingPhrase.Marshal(b, m, deterministic)
}
func (m *Intent_TrainingPhrase) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_TrainingPhrase.Merge(m, src)
}
func (m *Intent_TrainingPhrase) XXX_Size() int {
	return xxx_messageInfo_Intent_TrainingPhrase.Size(m)
}
func (m *Intent_TrainingPhrase) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_TrainingPhrase.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_TrainingPhrase proto.InternalMessageInfo

func (m *Intent_TrainingPhrase) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Intent_TrainingPhrase) GetType() Intent_TrainingPhrase_Type {
	if m != nil {
		return m.Type
	}
	return Intent_TrainingPhrase_TYPE_UNSPECIFIED
}

func (m *Intent_TrainingPhrase) GetParts() []*Intent_TrainingPhrase_Part {
	if m != nil {
		return m.Parts
	}
	return nil
}

func (m *Intent_TrainingPhrase) GetTimesAddedCount() int32 {
	if m != nil {
		return m.TimesAddedCount
	}
	return 0
}

// Represents a part of a training phrase.
type Intent_TrainingPhrase_Part struct {
	// Required. The text corresponding to the example or template,
	// if there are no annotations. For
	// annotated examples, it is the text for one of the example's parts.
	Text string `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// Optional. The entity type name prefixed with `@`. This field is
	// required for the annotated part of the text and applies only to
	// examples.
	EntityType string `protobuf:"bytes,2,opt,name=entity_type,json=entityType,proto3" json:"entity_type,omitempty"`
	// Optional. The parameter name for the value extracted from the
	// annotated part of the example.
	Alias string `protobuf:"bytes,3,opt,name=alias,proto3" json:"alias,omitempty"`
	// Optional. Indicates whether the text was manually annotated by the
	// developer.
	UserDefined          bool     `protobuf:"varint,4,opt,name=user_defined,json=userDefined,proto3" json:"user_defined,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Intent_TrainingPhrase_Part) Reset()         { *m = Intent_TrainingPhrase_Part{} }
func (m *Intent_TrainingPhrase_Part) String() string { return proto.CompactTextString(m) }
func (*Intent_TrainingPhrase_Part) ProtoMessage()    {}
func (*Intent_TrainingPhrase_Part) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 0, 0}
}

func (m *Intent_TrainingPhrase_Part) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_TrainingPhrase_Part.Unmarshal(m, b)
}
func (m *Intent_TrainingPhrase_Part) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_TrainingPhrase_Part.Marshal(b, m, deterministic)
}
func (m *Intent_TrainingPhrase_Part) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_TrainingPhrase_Part.Merge(m, src)
}
func (m *Intent_TrainingPhrase_Part) XXX_Size() int {
	return xxx_messageInfo_Intent_TrainingPhrase_Part.Size(m)
}
func (m *Intent_TrainingPhrase_Part) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_TrainingPhrase_Part.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_TrainingPhrase_Part proto.InternalMessageInfo

func (m *Intent_TrainingPhrase_Part) GetText() string {
	if m != nil {
		return m.Text
	}
	return ""
}

func (m *Intent_TrainingPhrase_Part) GetEntityType() string {
	if m != nil {
		return m.EntityType
	}
	return ""
}

func (m *Intent_TrainingPhrase_Part) GetAlias() string {
	if m != nil {
		return m.Alias
	}
	return ""
}

func (m *Intent_TrainingPhrase_Part) GetUserDefined() bool {
	if m != nil {
		return m.UserDefined
	}
	return false
}

// Represents intent parameters.
type Intent_Parameter struct {
	// The unique identifier of this parameter.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The name of the parameter.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Optional. The definition of the parameter value. It can be:
	// - a constant string,
	// - a parameter value defined as `$parameter_name`,
	// - an original parameter value defined as `$parameter_name.original`,
	// - a parameter value from some context defined as
	//   `#context_name.parameter_name`.
	Value string `protobuf:"bytes,3,opt,name=value,proto3" json:"value,omitempty"`
	// Optional. The default value to use when the `value` yields an empty
	// result.
	// Default values can be extracted from contexts by using the following
	// syntax: `#context_name.parameter_name`.
	DefaultValue string `protobuf:"bytes,4,opt,name=default_value,json=defaultValue,proto3" json:"default_value,omitempty"`
	// Optional. The name of the entity type, prefixed with `@`, that
	// describes values of the parameter. If the parameter is
	// required, this must be provided.
	EntityTypeDisplayName string `protobuf:"bytes,5,opt,name=entity_type_display_name,json=entityTypeDisplayName,proto3" json:"entity_type_display_name,omitempty"`
	// Optional. Indicates whether the parameter is required. That is,
	// whether the intent cannot be completed without collecting the parameter
	// value.
	Mandatory bool `protobuf:"varint,6,opt,name=mandatory,proto3" json:"mandatory,omitempty"`
	// Optional. The collection of prompts that the agent can present to the
	// user in order to collect value for the parameter.
	Prompts []string `protobuf:"bytes,7,rep,name=prompts,proto3" json:"prompts,omitempty"`
	// Optional. Indicates whether the parameter represents a list of values.
	IsList               bool     `protobuf:"varint,8,opt,name=is_list,json=isList,proto3" json:"is_list,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Intent_Parameter) Reset()         { *m = Intent_Parameter{} }
func (m *Intent_Parameter) String() string { return proto.CompactTextString(m) }
func (*Intent_Parameter) ProtoMessage()    {}
func (*Intent_Parameter) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 1}
}

func (m *Intent_Parameter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Parameter.Unmarshal(m, b)
}
func (m *Intent_Parameter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Parameter.Marshal(b, m, deterministic)
}
func (m *Intent_Parameter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Parameter.Merge(m, src)
}
func (m *Intent_Parameter) XXX_Size() int {
	return xxx_messageInfo_Intent_Parameter.Size(m)
}
func (m *Intent_Parameter) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Parameter.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Parameter proto.InternalMessageInfo

func (m *Intent_Parameter) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Intent_Parameter) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *Intent_Parameter) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

func (m *Intent_Parameter) GetDefaultValue() string {
	if m != nil {
		return m.DefaultValue
	}
	return ""
}

func (m *Intent_Parameter) GetEntityTypeDisplayName() string {
	if m != nil {
		return m.EntityTypeDisplayName
	}
	return ""
}

func (m *Intent_Parameter) GetMandatory() bool {
	if m != nil {
		return m.Mandatory
	}
	return false
}

func (m *Intent_Parameter) GetPrompts() []string {
	if m != nil {
		return m.Prompts
	}
	return nil
}

func (m *Intent_Parameter) GetIsList() bool {
	if m != nil {
		return m.IsList
	}
	return false
}

// Corresponds to the `Response` field in the Dialogflow console.
type Intent_Message struct {
	// Required. The rich response message.
	//
	// Types that are valid to be assigned to Message:
	//	*Intent_Message_Text_
	//	*Intent_Message_Image_
	//	*Intent_Message_QuickReplies_
	//	*Intent_Message_Card_
	//	*Intent_Message_Payload
	//	*Intent_Message_SimpleResponses_
	//	*Intent_Message_BasicCard_
	//	*Intent_Message_Suggestions_
	//	*Intent_Message_LinkOutSuggestion_
	//	*Intent_Message_ListSelect_
	//	*Intent_Message_CarouselSelect_
	//	*Intent_Message_TelephonyPlayAudio_
	//	*Intent_Message_TelephonySynthesizeSpeech_
	//	*Intent_Message_TelephonyTransferCall_
	Message isIntent_Message_Message `protobuf_oneof:"message"`
	// Optional. The platform that this message is intended for.
	Platform             Intent_Message_Platform `protobuf:"varint,6,opt,name=platform,proto3,enum=google.cloud.dialogflow.v2beta1.Intent_Message_Platform" json:"platform,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *Intent_Message) Reset()         { *m = Intent_Message{} }
func (m *Intent_Message) String() string { return proto.CompactTextString(m) }
func (*Intent_Message) ProtoMessage()    {}
func (*Intent_Message) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2}
}

func (m *Intent_Message) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message.Unmarshal(m, b)
}
func (m *Intent_Message) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message.Marshal(b, m, deterministic)
}
func (m *Intent_Message) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message.Merge(m, src)
}
func (m *Intent_Message) XXX_Size() int {
	return xxx_messageInfo_Intent_Message.Size(m)
}
func (m *Intent_Message) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message proto.InternalMessageInfo

type isIntent_Message_Message interface {
	isIntent_Message_Message()
}

type Intent_Message_Text_ struct {
	Text *Intent_Message_Text `protobuf:"bytes,1,opt,name=text,proto3,oneof"`
}

type Intent_Message_Image_ struct {
	Image *Intent_Message_Image `protobuf:"bytes,2,opt,name=image,proto3,oneof"`
}

type Intent_Message_QuickReplies_ struct {
	QuickReplies *Intent_Message_QuickReplies `protobuf:"bytes,3,opt,name=quick_replies,json=quickReplies,proto3,oneof"`
}

type Intent_Message_Card_ struct {
	Card *Intent_Message_Card `protobuf:"bytes,4,opt,name=card,proto3,oneof"`
}

type Intent_Message_Payload struct {
	Payload *_struct.Struct `protobuf:"bytes,5,opt,name=payload,proto3,oneof"`
}

type Intent_Message_SimpleResponses_ struct {
	SimpleResponses *Intent_Message_SimpleResponses `protobuf:"bytes,7,opt,name=simple_responses,json=simpleResponses,proto3,oneof"`
}

type Intent_Message_BasicCard_ struct {
	BasicCard *Intent_Message_BasicCard `protobuf:"bytes,8,opt,name=basic_card,json=basicCard,proto3,oneof"`
}

type Intent_Message_Suggestions_ struct {
	Suggestions *Intent_Message_Suggestions `protobuf:"bytes,9,opt,name=suggestions,proto3,oneof"`
}

type Intent_Message_LinkOutSuggestion_ struct {
	LinkOutSuggestion *Intent_Message_LinkOutSuggestion `protobuf:"bytes,10,opt,name=link_out_suggestion,json=linkOutSuggestion,proto3,oneof"`
}

type Intent_Message_ListSelect_ struct {
	ListSelect *Intent_Message_ListSelect `protobuf:"bytes,11,opt,name=list_select,json=listSelect,proto3,oneof"`
}

type Intent_Message_CarouselSelect_ struct {
	CarouselSelect *Intent_Message_CarouselSelect `protobuf:"bytes,12,opt,name=carousel_select,json=carouselSelect,proto3,oneof"`
}

type Intent_Message_TelephonyPlayAudio_ struct {
	TelephonyPlayAudio *Intent_Message_TelephonyPlayAudio `protobuf:"bytes,13,opt,name=telephony_play_audio,json=telephonyPlayAudio,proto3,oneof"`
}

type Intent_Message_TelephonySynthesizeSpeech_ struct {
	TelephonySynthesizeSpeech *Intent_Message_TelephonySynthesizeSpeech `protobuf:"bytes,14,opt,name=telephony_synthesize_speech,json=telephonySynthesizeSpeech,proto3,oneof"`
}

type Intent_Message_TelephonyTransferCall_ struct {
	TelephonyTransferCall *Intent_Message_TelephonyTransferCall `protobuf:"bytes,15,opt,name=telephony_transfer_call,json=telephonyTransferCall,proto3,oneof"`
}

func (*Intent_Message_Text_) isIntent_Message_Message() {}

func (*Intent_Message_Image_) isIntent_Message_Message() {}

func (*Intent_Message_QuickReplies_) isIntent_Message_Message() {}

func (*Intent_Message_Card_) isIntent_Message_Message() {}

func (*Intent_Message_Payload) isIntent_Message_Message() {}

func (*Intent_Message_SimpleResponses_) isIntent_Message_Message() {}

func (*Intent_Message_BasicCard_) isIntent_Message_Message() {}

func (*Intent_Message_Suggestions_) isIntent_Message_Message() {}

func (*Intent_Message_LinkOutSuggestion_) isIntent_Message_Message() {}

func (*Intent_Message_ListSelect_) isIntent_Message_Message() {}

func (*Intent_Message_CarouselSelect_) isIntent_Message_Message() {}

func (*Intent_Message_TelephonyPlayAudio_) isIntent_Message_Message() {}

func (*Intent_Message_TelephonySynthesizeSpeech_) isIntent_Message_Message() {}

func (*Intent_Message_TelephonyTransferCall_) isIntent_Message_Message() {}

func (m *Intent_Message) GetMessage() isIntent_Message_Message {
	if m != nil {
		return m.Message
	}
	return nil
}

func (m *Intent_Message) GetText() *Intent_Message_Text {
	if x, ok := m.GetMessage().(*Intent_Message_Text_); ok {
		return x.Text
	}
	return nil
}

func (m *Intent_Message) GetImage() *Intent_Message_Image {
	if x, ok := m.GetMessage().(*Intent_Message_Image_); ok {
		return x.Image
	}
	return nil
}

func (m *Intent_Message) GetQuickReplies() *Intent_Message_QuickReplies {
	if x, ok := m.GetMessage().(*Intent_Message_QuickReplies_); ok {
		return x.QuickReplies
	}
	return nil
}

func (m *Intent_Message) GetCard() *Intent_Message_Card {
	if x, ok := m.GetMessage().(*Intent_Message_Card_); ok {
		return x.Card
	}
	return nil
}

func (m *Intent_Message) GetPayload() *_struct.Struct {
	if x, ok := m.GetMessage().(*Intent_Message_Payload); ok {
		return x.Payload
	}
	return nil
}

func (m *Intent_Message) GetSimpleResponses() *Intent_Message_SimpleResponses {
	if x, ok := m.GetMessage().(*Intent_Message_SimpleResponses_); ok {
		return x.SimpleResponses
	}
	return nil
}

func (m *Intent_Message) GetBasicCard() *Intent_Message_BasicCard {
	if x, ok := m.GetMessage().(*Intent_Message_BasicCard_); ok {
		return x.BasicCard
	}
	return nil
}

func (m *Intent_Message) GetSuggestions() *Intent_Message_Suggestions {
	if x, ok := m.GetMessage().(*Intent_Message_Suggestions_); ok {
		return x.Suggestions
	}
	return nil
}

func (m *Intent_Message) GetLinkOutSuggestion() *Intent_Message_LinkOutSuggestion {
	if x, ok := m.GetMessage().(*Intent_Message_LinkOutSuggestion_); ok {
		return x.LinkOutSuggestion
	}
	return nil
}

func (m *Intent_Message) GetListSelect() *Intent_Message_ListSelect {
	if x, ok := m.GetMessage().(*Intent_Message_ListSelect_); ok {
		return x.ListSelect
	}
	return nil
}

func (m *Intent_Message) GetCarouselSelect() *Intent_Message_CarouselSelect {
	if x, ok := m.GetMessage().(*Intent_Message_CarouselSelect_); ok {
		return x.CarouselSelect
	}
	return nil
}

func (m *Intent_Message) GetTelephonyPlayAudio() *Intent_Message_TelephonyPlayAudio {
	if x, ok := m.GetMessage().(*Intent_Message_TelephonyPlayAudio_); ok {
		return x.TelephonyPlayAudio
	}
	return nil
}

func (m *Intent_Message) GetTelephonySynthesizeSpeech() *Intent_Message_TelephonySynthesizeSpeech {
	if x, ok := m.GetMessage().(*Intent_Message_TelephonySynthesizeSpeech_); ok {
		return x.TelephonySynthesizeSpeech
	}
	return nil
}

func (m *Intent_Message) GetTelephonyTransferCall() *Intent_Message_TelephonyTransferCall {
	if x, ok := m.GetMessage().(*Intent_Message_TelephonyTransferCall_); ok {
		return x.TelephonyTransferCall
	}
	return nil
}

func (m *Intent_Message) GetPlatform() Intent_Message_Platform {
	if m != nil {
		return m.Platform
	}
	return Intent_Message_PLATFORM_UNSPECIFIED
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Intent_Message) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Intent_Message_OneofMarshaler, _Intent_Message_OneofUnmarshaler, _Intent_Message_OneofSizer, []interface{}{
		(*Intent_Message_Text_)(nil),
		(*Intent_Message_Image_)(nil),
		(*Intent_Message_QuickReplies_)(nil),
		(*Intent_Message_Card_)(nil),
		(*Intent_Message_Payload)(nil),
		(*Intent_Message_SimpleResponses_)(nil),
		(*Intent_Message_BasicCard_)(nil),
		(*Intent_Message_Suggestions_)(nil),
		(*Intent_Message_LinkOutSuggestion_)(nil),
		(*Intent_Message_ListSelect_)(nil),
		(*Intent_Message_CarouselSelect_)(nil),
		(*Intent_Message_TelephonyPlayAudio_)(nil),
		(*Intent_Message_TelephonySynthesizeSpeech_)(nil),
		(*Intent_Message_TelephonyTransferCall_)(nil),
	}
}

func _Intent_Message_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Intent_Message)
	// message
	switch x := m.Message.(type) {
	case *Intent_Message_Text_:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Text); err != nil {
			return err
		}
	case *Intent_Message_Image_:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Image); err != nil {
			return err
		}
	case *Intent_Message_QuickReplies_:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.QuickReplies); err != nil {
			return err
		}
	case *Intent_Message_Card_:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Card); err != nil {
			return err
		}
	case *Intent_Message_Payload:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Payload); err != nil {
			return err
		}
	case *Intent_Message_SimpleResponses_:
		b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SimpleResponses); err != nil {
			return err
		}
	case *Intent_Message_BasicCard_:
		b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.BasicCard); err != nil {
			return err
		}
	case *Intent_Message_Suggestions_:
		b.EncodeVarint(9<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Suggestions); err != nil {
			return err
		}
	case *Intent_Message_LinkOutSuggestion_:
		b.EncodeVarint(10<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.LinkOutSuggestion); err != nil {
			return err
		}
	case *Intent_Message_ListSelect_:
		b.EncodeVarint(11<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ListSelect); err != nil {
			return err
		}
	case *Intent_Message_CarouselSelect_:
		b.EncodeVarint(12<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CarouselSelect); err != nil {
			return err
		}
	case *Intent_Message_TelephonyPlayAudio_:
		b.EncodeVarint(13<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TelephonyPlayAudio); err != nil {
			return err
		}
	case *Intent_Message_TelephonySynthesizeSpeech_:
		b.EncodeVarint(14<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TelephonySynthesizeSpeech); err != nil {
			return err
		}
	case *Intent_Message_TelephonyTransferCall_:
		b.EncodeVarint(15<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TelephonyTransferCall); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Intent_Message.Message has unexpected type %T", x)
	}
	return nil
}

func _Intent_Message_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Intent_Message)
	switch tag {
	case 1: // message.text
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Intent_Message_Text)
		err := b.DecodeMessage(msg)
		m.Message = &Intent_Message_Text_{msg}
		return true, err
	case 2: // message.image
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Intent_Message_Image)
		err := b.DecodeMessage(msg)
		m.Message = &Intent_Message_Image_{msg}
		return true, err
	case 3: // message.quick_replies
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Intent_Message_QuickReplies)
		err := b.DecodeMessage(msg)
		m.Message = &Intent_Message_QuickReplies_{msg}
		return true, err
	case 4: // message.card
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Intent_Message_Card)
		err := b.DecodeMessage(msg)
		m.Message = &Intent_Message_Card_{msg}
		return true, err
	case 5: // message.payload
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(_struct.Struct)
		err := b.DecodeMessage(msg)
		m.Message = &Intent_Message_Payload{msg}
		return true, err
	case 7: // message.simple_responses
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Intent_Message_SimpleResponses)
		err := b.DecodeMessage(msg)
		m.Message = &Intent_Message_SimpleResponses_{msg}
		return true, err
	case 8: // message.basic_card
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Intent_Message_BasicCard)
		err := b.DecodeMessage(msg)
		m.Message = &Intent_Message_BasicCard_{msg}
		return true, err
	case 9: // message.suggestions
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Intent_Message_Suggestions)
		err := b.DecodeMessage(msg)
		m.Message = &Intent_Message_Suggestions_{msg}
		return true, err
	case 10: // message.link_out_suggestion
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Intent_Message_LinkOutSuggestion)
		err := b.DecodeMessage(msg)
		m.Message = &Intent_Message_LinkOutSuggestion_{msg}
		return true, err
	case 11: // message.list_select
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Intent_Message_ListSelect)
		err := b.DecodeMessage(msg)
		m.Message = &Intent_Message_ListSelect_{msg}
		return true, err
	case 12: // message.carousel_select
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Intent_Message_CarouselSelect)
		err := b.DecodeMessage(msg)
		m.Message = &Intent_Message_CarouselSelect_{msg}
		return true, err
	case 13: // message.telephony_play_audio
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Intent_Message_TelephonyPlayAudio)
		err := b.DecodeMessage(msg)
		m.Message = &Intent_Message_TelephonyPlayAudio_{msg}
		return true, err
	case 14: // message.telephony_synthesize_speech
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Intent_Message_TelephonySynthesizeSpeech)
		err := b.DecodeMessage(msg)
		m.Message = &Intent_Message_TelephonySynthesizeSpeech_{msg}
		return true, err
	case 15: // message.telephony_transfer_call
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Intent_Message_TelephonyTransferCall)
		err := b.DecodeMessage(msg)
		m.Message = &Intent_Message_TelephonyTransferCall_{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Intent_Message_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Intent_Message)
	// message
	switch x := m.Message.(type) {
	case *Intent_Message_Text_:
		s := proto.Size(x.Text)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Intent_Message_Image_:
		s := proto.Size(x.Image)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Intent_Message_QuickReplies_:
		s := proto.Size(x.QuickReplies)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Intent_Message_Card_:
		s := proto.Size(x.Card)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Intent_Message_Payload:
		s := proto.Size(x.Payload)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Intent_Message_SimpleResponses_:
		s := proto.Size(x.SimpleResponses)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Intent_Message_BasicCard_:
		s := proto.Size(x.BasicCard)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Intent_Message_Suggestions_:
		s := proto.Size(x.Suggestions)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Intent_Message_LinkOutSuggestion_:
		s := proto.Size(x.LinkOutSuggestion)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Intent_Message_ListSelect_:
		s := proto.Size(x.ListSelect)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Intent_Message_CarouselSelect_:
		s := proto.Size(x.CarouselSelect)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Intent_Message_TelephonyPlayAudio_:
		s := proto.Size(x.TelephonyPlayAudio)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Intent_Message_TelephonySynthesizeSpeech_:
		s := proto.Size(x.TelephonySynthesizeSpeech)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Intent_Message_TelephonyTransferCall_:
		s := proto.Size(x.TelephonyTransferCall)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// The text response message.
type Intent_Message_Text struct {
	// Optional. The collection of the agent's responses.
	Text                 []string `protobuf:"bytes,1,rep,name=text,proto3" json:"text,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Intent_Message_Text) Reset()         { *m = Intent_Message_Text{} }
func (m *Intent_Message_Text) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_Text) ProtoMessage()    {}
func (*Intent_Message_Text) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 0}
}

func (m *Intent_Message_Text) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_Text.Unmarshal(m, b)
}
func (m *Intent_Message_Text) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_Text.Marshal(b, m, deterministic)
}
func (m *Intent_Message_Text) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_Text.Merge(m, src)
}
func (m *Intent_Message_Text) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_Text.Size(m)
}
func (m *Intent_Message_Text) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_Text.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_Text proto.InternalMessageInfo

func (m *Intent_Message_Text) GetText() []string {
	if m != nil {
		return m.Text
	}
	return nil
}

// The image response message.
type Intent_Message_Image struct {
	// Optional. The public URI to an image file.
	ImageUri string `protobuf:"bytes,1,opt,name=image_uri,json=imageUri,proto3" json:"image_uri,omitempty"`
	// A text description of the image to be used for accessibility,
	// e.g., screen readers. Required if image_uri is set for CarouselSelect.
	AccessibilityText    string   `protobuf:"bytes,2,opt,name=accessibility_text,json=accessibilityText,proto3" json:"accessibility_text,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Intent_Message_Image) Reset()         { *m = Intent_Message_Image{} }
func (m *Intent_Message_Image) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_Image) ProtoMessage()    {}
func (*Intent_Message_Image) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 1}
}

func (m *Intent_Message_Image) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_Image.Unmarshal(m, b)
}
func (m *Intent_Message_Image) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_Image.Marshal(b, m, deterministic)
}
func (m *Intent_Message_Image) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_Image.Merge(m, src)
}
func (m *Intent_Message_Image) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_Image.Size(m)
}
func (m *Intent_Message_Image) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_Image.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_Image proto.InternalMessageInfo

func (m *Intent_Message_Image) GetImageUri() string {
	if m != nil {
		return m.ImageUri
	}
	return ""
}

func (m *Intent_Message_Image) GetAccessibilityText() string {
	if m != nil {
		return m.AccessibilityText
	}
	return ""
}

// The quick replies response message.
type Intent_Message_QuickReplies struct {
	// Optional. The title of the collection of quick replies.
	Title string `protobuf:"bytes,1,opt,name=title,proto3" json:"title,omitempty"`
	// Optional. The collection of quick replies.
	QuickReplies         []string `protobuf:"bytes,2,rep,name=quick_replies,json=quickReplies,proto3" json:"quick_replies,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Intent_Message_QuickReplies) Reset()         { *m = Intent_Message_QuickReplies{} }
func (m *Intent_Message_QuickReplies) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_QuickReplies) ProtoMessage()    {}
func (*Intent_Message_QuickReplies) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 2}
}

func (m *Intent_Message_QuickReplies) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_QuickReplies.Unmarshal(m, b)
}
func (m *Intent_Message_QuickReplies) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_QuickReplies.Marshal(b, m, deterministic)
}
func (m *Intent_Message_QuickReplies) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_QuickReplies.Merge(m, src)
}
func (m *Intent_Message_QuickReplies) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_QuickReplies.Size(m)
}
func (m *Intent_Message_QuickReplies) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_QuickReplies.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_QuickReplies proto.InternalMessageInfo

func (m *Intent_Message_QuickReplies) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *Intent_Message_QuickReplies) GetQuickReplies() []string {
	if m != nil {
		return m.QuickReplies
	}
	return nil
}

// The card response message.
type Intent_Message_Card struct {
	// Optional. The title of the card.
	Title string `protobuf:"bytes,1,opt,name=title,proto3" json:"title,omitempty"`
	// Optional. The subtitle of the card.
	Subtitle string `protobuf:"bytes,2,opt,name=subtitle,proto3" json:"subtitle,omitempty"`
	// Optional. The public URI to an image file for the card.
	ImageUri string `protobuf:"bytes,3,opt,name=image_uri,json=imageUri,proto3" json:"image_uri,omitempty"`
	// Optional. The collection of card buttons.
	Buttons              []*Intent_Message_Card_Button `protobuf:"bytes,4,rep,name=buttons,proto3" json:"buttons,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *Intent_Message_Card) Reset()         { *m = Intent_Message_Card{} }
func (m *Intent_Message_Card) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_Card) ProtoMessage()    {}
func (*Intent_Message_Card) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 3}
}

func (m *Intent_Message_Card) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_Card.Unmarshal(m, b)
}
func (m *Intent_Message_Card) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_Card.Marshal(b, m, deterministic)
}
func (m *Intent_Message_Card) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_Card.Merge(m, src)
}
func (m *Intent_Message_Card) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_Card.Size(m)
}
func (m *Intent_Message_Card) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_Card.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_Card proto.InternalMessageInfo

func (m *Intent_Message_Card) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *Intent_Message_Card) GetSubtitle() string {
	if m != nil {
		return m.Subtitle
	}
	return ""
}

func (m *Intent_Message_Card) GetImageUri() string {
	if m != nil {
		return m.ImageUri
	}
	return ""
}

func (m *Intent_Message_Card) GetButtons() []*Intent_Message_Card_Button {
	if m != nil {
		return m.Buttons
	}
	return nil
}

// Optional. Contains information about a button.
type Intent_Message_Card_Button struct {
	// Optional. The text to show on the button.
	Text string `protobuf:"bytes,1,opt,name=text,proto3" json:"text,omitempty"`
	// Optional. The text to send back to the Dialogflow API or a URI to
	// open.
	Postback             string   `protobuf:"bytes,2,opt,name=postback,proto3" json:"postback,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Intent_Message_Card_Button) Reset()         { *m = Intent_Message_Card_Button{} }
func (m *Intent_Message_Card_Button) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_Card_Button) ProtoMessage()    {}
func (*Intent_Message_Card_Button) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 3, 0}
}

func (m *Intent_Message_Card_Button) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_Card_Button.Unmarshal(m, b)
}
func (m *Intent_Message_Card_Button) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_Card_Button.Marshal(b, m, deterministic)
}
func (m *Intent_Message_Card_Button) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_Card_Button.Merge(m, src)
}
func (m *Intent_Message_Card_Button) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_Card_Button.Size(m)
}
func (m *Intent_Message_Card_Button) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_Card_Button.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_Card_Button proto.InternalMessageInfo

func (m *Intent_Message_Card_Button) GetText() string {
	if m != nil {
		return m.Text
	}
	return ""
}

func (m *Intent_Message_Card_Button) GetPostback() string {
	if m != nil {
		return m.Postback
	}
	return ""
}

// The simple response message containing speech or text.
type Intent_Message_SimpleResponse struct {
	// One of text_to_speech or ssml must be provided. The plain text of the
	// speech output. Mutually exclusive with ssml.
	TextToSpeech string `protobuf:"bytes,1,opt,name=text_to_speech,json=textToSpeech,proto3" json:"text_to_speech,omitempty"`
	// One of text_to_speech or ssml must be provided. Structured spoken
	// response to the user in the SSML format. Mutually exclusive with
	// text_to_speech.
	Ssml string `protobuf:"bytes,2,opt,name=ssml,proto3" json:"ssml,omitempty"`
	// Optional. The text to display.
	DisplayText          string   `protobuf:"bytes,3,opt,name=display_text,json=displayText,proto3" json:"display_text,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Intent_Message_SimpleResponse) Reset()         { *m = Intent_Message_SimpleResponse{} }
func (m *Intent_Message_SimpleResponse) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_SimpleResponse) ProtoMessage()    {}
func (*Intent_Message_SimpleResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 4}
}

func (m *Intent_Message_SimpleResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_SimpleResponse.Unmarshal(m, b)
}
func (m *Intent_Message_SimpleResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_SimpleResponse.Marshal(b, m, deterministic)
}
func (m *Intent_Message_SimpleResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_SimpleResponse.Merge(m, src)
}
func (m *Intent_Message_SimpleResponse) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_SimpleResponse.Size(m)
}
func (m *Intent_Message_SimpleResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_SimpleResponse.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_SimpleResponse proto.InternalMessageInfo

func (m *Intent_Message_SimpleResponse) GetTextToSpeech() string {
	if m != nil {
		return m.TextToSpeech
	}
	return ""
}

func (m *Intent_Message_SimpleResponse) GetSsml() string {
	if m != nil {
		return m.Ssml
	}
	return ""
}

func (m *Intent_Message_SimpleResponse) GetDisplayText() string {
	if m != nil {
		return m.DisplayText
	}
	return ""
}

// The collection of simple response candidates.
// This message in `QueryResult.fulfillment_messages` and
// `WebhookResponse.fulfillment_messages` should contain only one
// `SimpleResponse`.
type Intent_Message_SimpleResponses struct {
	// Required. The list of simple responses.
	SimpleResponses      []*Intent_Message_SimpleResponse `protobuf:"bytes,1,rep,name=simple_responses,json=simpleResponses,proto3" json:"simple_responses,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                         `json:"-"`
	XXX_unrecognized     []byte                           `json:"-"`
	XXX_sizecache        int32                            `json:"-"`
}

func (m *Intent_Message_SimpleResponses) Reset()         { *m = Intent_Message_SimpleResponses{} }
func (m *Intent_Message_SimpleResponses) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_SimpleResponses) ProtoMessage()    {}
func (*Intent_Message_SimpleResponses) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 5}
}

func (m *Intent_Message_SimpleResponses) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_SimpleResponses.Unmarshal(m, b)
}
func (m *Intent_Message_SimpleResponses) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_SimpleResponses.Marshal(b, m, deterministic)
}
func (m *Intent_Message_SimpleResponses) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_SimpleResponses.Merge(m, src)
}
func (m *Intent_Message_SimpleResponses) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_SimpleResponses.Size(m)
}
func (m *Intent_Message_SimpleResponses) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_SimpleResponses.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_SimpleResponses proto.InternalMessageInfo

func (m *Intent_Message_SimpleResponses) GetSimpleResponses() []*Intent_Message_SimpleResponse {
	if m != nil {
		return m.SimpleResponses
	}
	return nil
}

// The basic card message. Useful for displaying information.
type Intent_Message_BasicCard struct {
	// Optional. The title of the card.
	Title string `protobuf:"bytes,1,opt,name=title,proto3" json:"title,omitempty"`
	// Optional. The subtitle of the card.
	Subtitle string `protobuf:"bytes,2,opt,name=subtitle,proto3" json:"subtitle,omitempty"`
	// Required, unless image is present. The body text of the card.
	FormattedText string `protobuf:"bytes,3,opt,name=formatted_text,json=formattedText,proto3" json:"formatted_text,omitempty"`
	// Optional. The image for the card.
	Image *Intent_Message_Image `protobuf:"bytes,4,opt,name=image,proto3" json:"image,omitempty"`
	// Optional. The collection of card buttons.
	Buttons              []*Intent_Message_BasicCard_Button `protobuf:"bytes,5,rep,name=buttons,proto3" json:"buttons,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *Intent_Message_BasicCard) Reset()         { *m = Intent_Message_BasicCard{} }
func (m *Intent_Message_BasicCard) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_BasicCard) ProtoMessage()    {}
func (*Intent_Message_BasicCard) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 6}
}

func (m *Intent_Message_BasicCard) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_BasicCard.Unmarshal(m, b)
}
func (m *Intent_Message_BasicCard) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_BasicCard.Marshal(b, m, deterministic)
}
func (m *Intent_Message_BasicCard) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_BasicCard.Merge(m, src)
}
func (m *Intent_Message_BasicCard) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_BasicCard.Size(m)
}
func (m *Intent_Message_BasicCard) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_BasicCard.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_BasicCard proto.InternalMessageInfo

func (m *Intent_Message_BasicCard) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *Intent_Message_BasicCard) GetSubtitle() string {
	if m != nil {
		return m.Subtitle
	}
	return ""
}

func (m *Intent_Message_BasicCard) GetFormattedText() string {
	if m != nil {
		return m.FormattedText
	}
	return ""
}

func (m *Intent_Message_BasicCard) GetImage() *Intent_Message_Image {
	if m != nil {
		return m.Image
	}
	return nil
}

func (m *Intent_Message_BasicCard) GetButtons() []*Intent_Message_BasicCard_Button {
	if m != nil {
		return m.Buttons
	}
	return nil
}

// The button object that appears at the bottom of a card.
type Intent_Message_BasicCard_Button struct {
	// Required. The title of the button.
	Title string `protobuf:"bytes,1,opt,name=title,proto3" json:"title,omitempty"`
	// Required. Action to take when a user taps on the button.
	OpenUriAction        *Intent_Message_BasicCard_Button_OpenUriAction `protobuf:"bytes,2,opt,name=open_uri_action,json=openUriAction,proto3" json:"open_uri_action,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                       `json:"-"`
	XXX_unrecognized     []byte                                         `json:"-"`
	XXX_sizecache        int32                                          `json:"-"`
}

func (m *Intent_Message_BasicCard_Button) Reset()         { *m = Intent_Message_BasicCard_Button{} }
func (m *Intent_Message_BasicCard_Button) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_BasicCard_Button) ProtoMessage()    {}
func (*Intent_Message_BasicCard_Button) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 6, 0}
}

func (m *Intent_Message_BasicCard_Button) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_BasicCard_Button.Unmarshal(m, b)
}
func (m *Intent_Message_BasicCard_Button) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_BasicCard_Button.Marshal(b, m, deterministic)
}
func (m *Intent_Message_BasicCard_Button) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_BasicCard_Button.Merge(m, src)
}
func (m *Intent_Message_BasicCard_Button) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_BasicCard_Button.Size(m)
}
func (m *Intent_Message_BasicCard_Button) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_BasicCard_Button.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_BasicCard_Button proto.InternalMessageInfo

func (m *Intent_Message_BasicCard_Button) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *Intent_Message_BasicCard_Button) GetOpenUriAction() *Intent_Message_BasicCard_Button_OpenUriAction {
	if m != nil {
		return m.OpenUriAction
	}
	return nil
}

// Opens the given URI.
type Intent_Message_BasicCard_Button_OpenUriAction struct {
	// Required. The HTTP or HTTPS scheme URI.
	Uri                  string   `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Intent_Message_BasicCard_Button_OpenUriAction) Reset() {
	*m = Intent_Message_BasicCard_Button_OpenUriAction{}
}
func (m *Intent_Message_BasicCard_Button_OpenUriAction) String() string {
	return proto.CompactTextString(m)
}
func (*Intent_Message_BasicCard_Button_OpenUriAction) ProtoMessage() {}
func (*Intent_Message_BasicCard_Button_OpenUriAction) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 6, 0, 0}
}

func (m *Intent_Message_BasicCard_Button_OpenUriAction) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_BasicCard_Button_OpenUriAction.Unmarshal(m, b)
}
func (m *Intent_Message_BasicCard_Button_OpenUriAction) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_BasicCard_Button_OpenUriAction.Marshal(b, m, deterministic)
}
func (m *Intent_Message_BasicCard_Button_OpenUriAction) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_BasicCard_Button_OpenUriAction.Merge(m, src)
}
func (m *Intent_Message_BasicCard_Button_OpenUriAction) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_BasicCard_Button_OpenUriAction.Size(m)
}
func (m *Intent_Message_BasicCard_Button_OpenUriAction) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_BasicCard_Button_OpenUriAction.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_BasicCard_Button_OpenUriAction proto.InternalMessageInfo

func (m *Intent_Message_BasicCard_Button_OpenUriAction) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

// The suggestion chip message that the user can tap to quickly post a reply
// to the conversation.
type Intent_Message_Suggestion struct {
	// Required. The text shown the in the suggestion chip.
	Title                string   `protobuf:"bytes,1,opt,name=title,proto3" json:"title,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Intent_Message_Suggestion) Reset()         { *m = Intent_Message_Suggestion{} }
func (m *Intent_Message_Suggestion) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_Suggestion) ProtoMessage()    {}
func (*Intent_Message_Suggestion) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 7}
}

func (m *Intent_Message_Suggestion) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_Suggestion.Unmarshal(m, b)
}
func (m *Intent_Message_Suggestion) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_Suggestion.Marshal(b, m, deterministic)
}
func (m *Intent_Message_Suggestion) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_Suggestion.Merge(m, src)
}
func (m *Intent_Message_Suggestion) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_Suggestion.Size(m)
}
func (m *Intent_Message_Suggestion) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_Suggestion.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_Suggestion proto.InternalMessageInfo

func (m *Intent_Message_Suggestion) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

// The collection of suggestions.
type Intent_Message_Suggestions struct {
	// Required. The list of suggested replies.
	Suggestions          []*Intent_Message_Suggestion `protobuf:"bytes,1,rep,name=suggestions,proto3" json:"suggestions,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *Intent_Message_Suggestions) Reset()         { *m = Intent_Message_Suggestions{} }
func (m *Intent_Message_Suggestions) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_Suggestions) ProtoMessage()    {}
func (*Intent_Message_Suggestions) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 8}
}

func (m *Intent_Message_Suggestions) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_Suggestions.Unmarshal(m, b)
}
func (m *Intent_Message_Suggestions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_Suggestions.Marshal(b, m, deterministic)
}
func (m *Intent_Message_Suggestions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_Suggestions.Merge(m, src)
}
func (m *Intent_Message_Suggestions) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_Suggestions.Size(m)
}
func (m *Intent_Message_Suggestions) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_Suggestions.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_Suggestions proto.InternalMessageInfo

func (m *Intent_Message_Suggestions) GetSuggestions() []*Intent_Message_Suggestion {
	if m != nil {
		return m.Suggestions
	}
	return nil
}

// The suggestion chip message that allows the user to jump out to the app
// or website associated with this agent.
type Intent_Message_LinkOutSuggestion struct {
	// Required. The name of the app or site this chip is linking to.
	DestinationName string `protobuf:"bytes,1,opt,name=destination_name,json=destinationName,proto3" json:"destination_name,omitempty"`
	// Required. The URI of the app or site to open when the user taps the
	// suggestion chip.
	Uri                  string   `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Intent_Message_LinkOutSuggestion) Reset()         { *m = Intent_Message_LinkOutSuggestion{} }
func (m *Intent_Message_LinkOutSuggestion) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_LinkOutSuggestion) ProtoMessage()    {}
func (*Intent_Message_LinkOutSuggestion) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 9}
}

func (m *Intent_Message_LinkOutSuggestion) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_LinkOutSuggestion.Unmarshal(m, b)
}
func (m *Intent_Message_LinkOutSuggestion) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_LinkOutSuggestion.Marshal(b, m, deterministic)
}
func (m *Intent_Message_LinkOutSuggestion) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_LinkOutSuggestion.Merge(m, src)
}
func (m *Intent_Message_LinkOutSuggestion) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_LinkOutSuggestion.Size(m)
}
func (m *Intent_Message_LinkOutSuggestion) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_LinkOutSuggestion.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_LinkOutSuggestion proto.InternalMessageInfo

func (m *Intent_Message_LinkOutSuggestion) GetDestinationName() string {
	if m != nil {
		return m.DestinationName
	}
	return ""
}

func (m *Intent_Message_LinkOutSuggestion) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

// The card for presenting a list of options to select from.
type Intent_Message_ListSelect struct {
	// Optional. The overall title of the list.
	Title string `protobuf:"bytes,1,opt,name=title,proto3" json:"title,omitempty"`
	// Required. List items.
	Items                []*Intent_Message_ListSelect_Item `protobuf:"bytes,2,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *Intent_Message_ListSelect) Reset()         { *m = Intent_Message_ListSelect{} }
func (m *Intent_Message_ListSelect) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_ListSelect) ProtoMessage()    {}
func (*Intent_Message_ListSelect) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 10}
}

func (m *Intent_Message_ListSelect) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_ListSelect.Unmarshal(m, b)
}
func (m *Intent_Message_ListSelect) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_ListSelect.Marshal(b, m, deterministic)
}
func (m *Intent_Message_ListSelect) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_ListSelect.Merge(m, src)
}
func (m *Intent_Message_ListSelect) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_ListSelect.Size(m)
}
func (m *Intent_Message_ListSelect) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_ListSelect.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_ListSelect proto.InternalMessageInfo

func (m *Intent_Message_ListSelect) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *Intent_Message_ListSelect) GetItems() []*Intent_Message_ListSelect_Item {
	if m != nil {
		return m.Items
	}
	return nil
}

// An item in the list.
type Intent_Message_ListSelect_Item struct {
	// Required. Additional information about this option.
	Info *Intent_Message_SelectItemInfo `protobuf:"bytes,1,opt,name=info,proto3" json:"info,omitempty"`
	// Required. The title of the list item.
	Title string `protobuf:"bytes,2,opt,name=title,proto3" json:"title,omitempty"`
	// Optional. The main text describing the item.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. The image to display.
	Image                *Intent_Message_Image `protobuf:"bytes,4,opt,name=image,proto3" json:"image,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *Intent_Message_ListSelect_Item) Reset()         { *m = Intent_Message_ListSelect_Item{} }
func (m *Intent_Message_ListSelect_Item) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_ListSelect_Item) ProtoMessage()    {}
func (*Intent_Message_ListSelect_Item) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 10, 0}
}

func (m *Intent_Message_ListSelect_Item) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_ListSelect_Item.Unmarshal(m, b)
}
func (m *Intent_Message_ListSelect_Item) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_ListSelect_Item.Marshal(b, m, deterministic)
}
func (m *Intent_Message_ListSelect_Item) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_ListSelect_Item.Merge(m, src)
}
func (m *Intent_Message_ListSelect_Item) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_ListSelect_Item.Size(m)
}
func (m *Intent_Message_ListSelect_Item) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_ListSelect_Item.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_ListSelect_Item proto.InternalMessageInfo

func (m *Intent_Message_ListSelect_Item) GetInfo() *Intent_Message_SelectItemInfo {
	if m != nil {
		return m.Info
	}
	return nil
}

func (m *Intent_Message_ListSelect_Item) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *Intent_Message_ListSelect_Item) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Intent_Message_ListSelect_Item) GetImage() *Intent_Message_Image {
	if m != nil {
		return m.Image
	}
	return nil
}

// The card for presenting a carousel of options to select from.
type Intent_Message_CarouselSelect struct {
	// Required. Carousel items.
	Items                []*Intent_Message_CarouselSelect_Item `protobuf:"bytes,1,rep,name=items,proto3" json:"items,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                              `json:"-"`
	XXX_unrecognized     []byte                                `json:"-"`
	XXX_sizecache        int32                                 `json:"-"`
}

func (m *Intent_Message_CarouselSelect) Reset()         { *m = Intent_Message_CarouselSelect{} }
func (m *Intent_Message_CarouselSelect) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_CarouselSelect) ProtoMessage()    {}
func (*Intent_Message_CarouselSelect) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 11}
}

func (m *Intent_Message_CarouselSelect) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_CarouselSelect.Unmarshal(m, b)
}
func (m *Intent_Message_CarouselSelect) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_CarouselSelect.Marshal(b, m, deterministic)
}
func (m *Intent_Message_CarouselSelect) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_CarouselSelect.Merge(m, src)
}
func (m *Intent_Message_CarouselSelect) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_CarouselSelect.Size(m)
}
func (m *Intent_Message_CarouselSelect) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_CarouselSelect.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_CarouselSelect proto.InternalMessageInfo

func (m *Intent_Message_CarouselSelect) GetItems() []*Intent_Message_CarouselSelect_Item {
	if m != nil {
		return m.Items
	}
	return nil
}

// An item in the carousel.
type Intent_Message_CarouselSelect_Item struct {
	// Required. Additional info about the option item.
	Info *Intent_Message_SelectItemInfo `protobuf:"bytes,1,opt,name=info,proto3" json:"info,omitempty"`
	// Required. Title of the carousel item.
	Title string `protobuf:"bytes,2,opt,name=title,proto3" json:"title,omitempty"`
	// Optional. The body text of the card.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Optional. The image to display.
	Image                *Intent_Message_Image `protobuf:"bytes,4,opt,name=image,proto3" json:"image,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *Intent_Message_CarouselSelect_Item) Reset()         { *m = Intent_Message_CarouselSelect_Item{} }
func (m *Intent_Message_CarouselSelect_Item) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_CarouselSelect_Item) ProtoMessage()    {}
func (*Intent_Message_CarouselSelect_Item) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 11, 0}
}

func (m *Intent_Message_CarouselSelect_Item) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_CarouselSelect_Item.Unmarshal(m, b)
}
func (m *Intent_Message_CarouselSelect_Item) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_CarouselSelect_Item.Marshal(b, m, deterministic)
}
func (m *Intent_Message_CarouselSelect_Item) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_CarouselSelect_Item.Merge(m, src)
}
func (m *Intent_Message_CarouselSelect_Item) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_CarouselSelect_Item.Size(m)
}
func (m *Intent_Message_CarouselSelect_Item) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_CarouselSelect_Item.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_CarouselSelect_Item proto.InternalMessageInfo

func (m *Intent_Message_CarouselSelect_Item) GetInfo() *Intent_Message_SelectItemInfo {
	if m != nil {
		return m.Info
	}
	return nil
}

func (m *Intent_Message_CarouselSelect_Item) GetTitle() string {
	if m != nil {
		return m.Title
	}
	return ""
}

func (m *Intent_Message_CarouselSelect_Item) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *Intent_Message_CarouselSelect_Item) GetImage() *Intent_Message_Image {
	if m != nil {
		return m.Image
	}
	return nil
}

// Additional info about the select item for when it is triggered in a
// dialog.
type Intent_Message_SelectItemInfo struct {
	// Required. A unique key that will be sent back to the agent if this
	// response is given.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// Optional. A list of synonyms that can also be used to trigger this
	// item in dialog.
	Synonyms             []string `protobuf:"bytes,2,rep,name=synonyms,proto3" json:"synonyms,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Intent_Message_SelectItemInfo) Reset()         { *m = Intent_Message_SelectItemInfo{} }
func (m *Intent_Message_SelectItemInfo) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_SelectItemInfo) ProtoMessage()    {}
func (*Intent_Message_SelectItemInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 12}
}

func (m *Intent_Message_SelectItemInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_SelectItemInfo.Unmarshal(m, b)
}
func (m *Intent_Message_SelectItemInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_SelectItemInfo.Marshal(b, m, deterministic)
}
func (m *Intent_Message_SelectItemInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_SelectItemInfo.Merge(m, src)
}
func (m *Intent_Message_SelectItemInfo) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_SelectItemInfo.Size(m)
}
func (m *Intent_Message_SelectItemInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_SelectItemInfo.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_SelectItemInfo proto.InternalMessageInfo

func (m *Intent_Message_SelectItemInfo) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *Intent_Message_SelectItemInfo) GetSynonyms() []string {
	if m != nil {
		return m.Synonyms
	}
	return nil
}

// Plays audio from a file in Telephony Gateway.
type Intent_Message_TelephonyPlayAudio struct {
	// Required. URI to a Google Cloud Storage object containing the audio to
	// play, e.g., "gs://bucket/object". The object must contain a single
	// channel (mono) of linear PCM audio (2 bytes / sample) at 8kHz.
	//
	// This object must be readable by the `service-<Project
	// Number>@gcp-sa-dialogflow.iam.gserviceaccount.com` service account
	// where <Project Number> is the number of the Telephony Gateway project
	// (usually the same as the Dialogflow agent project). If the Google Cloud
	// Storage bucket is in the Telephony Gateway project, this permission is
	// added by default when enabling the Dialogflow V2 API.
	//
	// For audio from other sources, consider using the
	// `TelephonySynthesizeSpeech` message with SSML.
	AudioUri             string   `protobuf:"bytes,1,opt,name=audio_uri,json=audioUri,proto3" json:"audio_uri,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Intent_Message_TelephonyPlayAudio) Reset()         { *m = Intent_Message_TelephonyPlayAudio{} }
func (m *Intent_Message_TelephonyPlayAudio) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_TelephonyPlayAudio) ProtoMessage()    {}
func (*Intent_Message_TelephonyPlayAudio) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 13}
}

func (m *Intent_Message_TelephonyPlayAudio) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_TelephonyPlayAudio.Unmarshal(m, b)
}
func (m *Intent_Message_TelephonyPlayAudio) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_TelephonyPlayAudio.Marshal(b, m, deterministic)
}
func (m *Intent_Message_TelephonyPlayAudio) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_TelephonyPlayAudio.Merge(m, src)
}
func (m *Intent_Message_TelephonyPlayAudio) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_TelephonyPlayAudio.Size(m)
}
func (m *Intent_Message_TelephonyPlayAudio) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_TelephonyPlayAudio.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_TelephonyPlayAudio proto.InternalMessageInfo

func (m *Intent_Message_TelephonyPlayAudio) GetAudioUri() string {
	if m != nil {
		return m.AudioUri
	}
	return ""
}

// Synthesizes speech and plays back the synthesized audio to the caller in
// Telephony Gateway.
//
// Telephony Gateway takes the synthesizer settings from
// `DetectIntentResponse.output_audio_config` which can either be set
// at request-level or can come from the agent-level synthesizer config.
type Intent_Message_TelephonySynthesizeSpeech struct {
	// Required. The source to be synthesized.
	//
	// Types that are valid to be assigned to Source:
	//	*Intent_Message_TelephonySynthesizeSpeech_Text
	//	*Intent_Message_TelephonySynthesizeSpeech_Ssml
	Source               isIntent_Message_TelephonySynthesizeSpeech_Source `protobuf_oneof:"source"`
	XXX_NoUnkeyedLiteral struct{}                                          `json:"-"`
	XXX_unrecognized     []byte                                            `json:"-"`
	XXX_sizecache        int32                                             `json:"-"`
}

func (m *Intent_Message_TelephonySynthesizeSpeech) Reset() {
	*m = Intent_Message_TelephonySynthesizeSpeech{}
}
func (m *Intent_Message_TelephonySynthesizeSpeech) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_TelephonySynthesizeSpeech) ProtoMessage()    {}
func (*Intent_Message_TelephonySynthesizeSpeech) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 14}
}

func (m *Intent_Message_TelephonySynthesizeSpeech) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_TelephonySynthesizeSpeech.Unmarshal(m, b)
}
func (m *Intent_Message_TelephonySynthesizeSpeech) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_TelephonySynthesizeSpeech.Marshal(b, m, deterministic)
}
func (m *Intent_Message_TelephonySynthesizeSpeech) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_TelephonySynthesizeSpeech.Merge(m, src)
}
func (m *Intent_Message_TelephonySynthesizeSpeech) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_TelephonySynthesizeSpeech.Size(m)
}
func (m *Intent_Message_TelephonySynthesizeSpeech) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_TelephonySynthesizeSpeech.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_TelephonySynthesizeSpeech proto.InternalMessageInfo

type isIntent_Message_TelephonySynthesizeSpeech_Source interface {
	isIntent_Message_TelephonySynthesizeSpeech_Source()
}

type Intent_Message_TelephonySynthesizeSpeech_Text struct {
	Text string `protobuf:"bytes,1,opt,name=text,proto3,oneof"`
}

type Intent_Message_TelephonySynthesizeSpeech_Ssml struct {
	Ssml string `protobuf:"bytes,2,opt,name=ssml,proto3,oneof"`
}

func (*Intent_Message_TelephonySynthesizeSpeech_Text) isIntent_Message_TelephonySynthesizeSpeech_Source() {
}

func (*Intent_Message_TelephonySynthesizeSpeech_Ssml) isIntent_Message_TelephonySynthesizeSpeech_Source() {
}

func (m *Intent_Message_TelephonySynthesizeSpeech) GetSource() isIntent_Message_TelephonySynthesizeSpeech_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *Intent_Message_TelephonySynthesizeSpeech) GetText() string {
	if x, ok := m.GetSource().(*Intent_Message_TelephonySynthesizeSpeech_Text); ok {
		return x.Text
	}
	return ""
}

func (m *Intent_Message_TelephonySynthesizeSpeech) GetSsml() string {
	if x, ok := m.GetSource().(*Intent_Message_TelephonySynthesizeSpeech_Ssml); ok {
		return x.Ssml
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Intent_Message_TelephonySynthesizeSpeech) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Intent_Message_TelephonySynthesizeSpeech_OneofMarshaler, _Intent_Message_TelephonySynthesizeSpeech_OneofUnmarshaler, _Intent_Message_TelephonySynthesizeSpeech_OneofSizer, []interface{}{
		(*Intent_Message_TelephonySynthesizeSpeech_Text)(nil),
		(*Intent_Message_TelephonySynthesizeSpeech_Ssml)(nil),
	}
}

func _Intent_Message_TelephonySynthesizeSpeech_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Intent_Message_TelephonySynthesizeSpeech)
	// source
	switch x := m.Source.(type) {
	case *Intent_Message_TelephonySynthesizeSpeech_Text:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.Text)
	case *Intent_Message_TelephonySynthesizeSpeech_Ssml:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.Ssml)
	case nil:
	default:
		return fmt.Errorf("Intent_Message_TelephonySynthesizeSpeech.Source has unexpected type %T", x)
	}
	return nil
}

func _Intent_Message_TelephonySynthesizeSpeech_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Intent_Message_TelephonySynthesizeSpeech)
	switch tag {
	case 1: // source.text
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Source = &Intent_Message_TelephonySynthesizeSpeech_Text{x}
		return true, err
	case 2: // source.ssml
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Source = &Intent_Message_TelephonySynthesizeSpeech_Ssml{x}
		return true, err
	default:
		return false, nil
	}
}

func _Intent_Message_TelephonySynthesizeSpeech_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Intent_Message_TelephonySynthesizeSpeech)
	// source
	switch x := m.Source.(type) {
	case *Intent_Message_TelephonySynthesizeSpeech_Text:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Text)))
		n += len(x.Text)
	case *Intent_Message_TelephonySynthesizeSpeech_Ssml:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Ssml)))
		n += len(x.Ssml)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Transfers the call in Telephony Gateway.
type Intent_Message_TelephonyTransferCall struct {
	// Required. The phone number to transfer the call to
	// in [E.164 format](https://en.wikipedia.org/wiki/E.164).
	//
	// We currently only allow transferring to US numbers (+1xxxyyyzzzz).
	PhoneNumber          string   `protobuf:"bytes,1,opt,name=phone_number,json=phoneNumber,proto3" json:"phone_number,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Intent_Message_TelephonyTransferCall) Reset()         { *m = Intent_Message_TelephonyTransferCall{} }
func (m *Intent_Message_TelephonyTransferCall) String() string { return proto.CompactTextString(m) }
func (*Intent_Message_TelephonyTransferCall) ProtoMessage()    {}
func (*Intent_Message_TelephonyTransferCall) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 2, 15}
}

func (m *Intent_Message_TelephonyTransferCall) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_Message_TelephonyTransferCall.Unmarshal(m, b)
}
func (m *Intent_Message_TelephonyTransferCall) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_Message_TelephonyTransferCall.Marshal(b, m, deterministic)
}
func (m *Intent_Message_TelephonyTransferCall) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_Message_TelephonyTransferCall.Merge(m, src)
}
func (m *Intent_Message_TelephonyTransferCall) XXX_Size() int {
	return xxx_messageInfo_Intent_Message_TelephonyTransferCall.Size(m)
}
func (m *Intent_Message_TelephonyTransferCall) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_Message_TelephonyTransferCall.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_Message_TelephonyTransferCall proto.InternalMessageInfo

func (m *Intent_Message_TelephonyTransferCall) GetPhoneNumber() string {
	if m != nil {
		return m.PhoneNumber
	}
	return ""
}

// Represents a single followup intent in the chain.
type Intent_FollowupIntentInfo struct {
	// The unique identifier of the followup intent.
	// Format: `projects/<Project ID>/agent/intents/<Intent ID>`.
	FollowupIntentName string `protobuf:"bytes,1,opt,name=followup_intent_name,json=followupIntentName,proto3" json:"followup_intent_name,omitempty"`
	// The unique identifier of the followup intent parent.
	// Format: `projects/<Project ID>/agent/intents/<Intent ID>`.
	ParentFollowupIntentName string   `protobuf:"bytes,2,opt,name=parent_followup_intent_name,json=parentFollowupIntentName,proto3" json:"parent_followup_intent_name,omitempty"`
	XXX_NoUnkeyedLiteral     struct{} `json:"-"`
	XXX_unrecognized         []byte   `json:"-"`
	XXX_sizecache            int32    `json:"-"`
}

func (m *Intent_FollowupIntentInfo) Reset()         { *m = Intent_FollowupIntentInfo{} }
func (m *Intent_FollowupIntentInfo) String() string { return proto.CompactTextString(m) }
func (*Intent_FollowupIntentInfo) ProtoMessage()    {}
func (*Intent_FollowupIntentInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{0, 3}
}

func (m *Intent_FollowupIntentInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Intent_FollowupIntentInfo.Unmarshal(m, b)
}
func (m *Intent_FollowupIntentInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Intent_FollowupIntentInfo.Marshal(b, m, deterministic)
}
func (m *Intent_FollowupIntentInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Intent_FollowupIntentInfo.Merge(m, src)
}
func (m *Intent_FollowupIntentInfo) XXX_Size() int {
	return xxx_messageInfo_Intent_FollowupIntentInfo.Size(m)
}
func (m *Intent_FollowupIntentInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_Intent_FollowupIntentInfo.DiscardUnknown(m)
}

var xxx_messageInfo_Intent_FollowupIntentInfo proto.InternalMessageInfo

func (m *Intent_FollowupIntentInfo) GetFollowupIntentName() string {
	if m != nil {
		return m.FollowupIntentName
	}
	return ""
}

func (m *Intent_FollowupIntentInfo) GetParentFollowupIntentName() string {
	if m != nil {
		return m.ParentFollowupIntentName
	}
	return ""
}

// The request message for [Intents.ListIntents][google.cloud.dialogflow.v2beta1.Intents.ListIntents].
type ListIntentsRequest struct {
	// Required. The agent to list all intents from.
	// Format: `projects/<Project ID>/agent`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The language to list training phrases, parameters and rich
	// messages for. If not specified, the agent's default language is used.
	// [More than a dozen
	// languages](https://dialogflow.com/docs/reference/language) are supported.
	// Note: languages must be enabled in the agent before they can be used.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Optional. The resource view to apply to the returned intent.
	IntentView IntentView `protobuf:"varint,3,opt,name=intent_view,json=intentView,proto3,enum=google.cloud.dialogflow.v2beta1.IntentView" json:"intent_view,omitempty"`
	// Optional. The maximum number of items to return in a single page. By
	// default 100 and at most 1000.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. The next_page_token value returned from a previous list request.
	PageToken            string   `protobuf:"bytes,5,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListIntentsRequest) Reset()         { *m = ListIntentsRequest{} }
func (m *ListIntentsRequest) String() string { return proto.CompactTextString(m) }
func (*ListIntentsRequest) ProtoMessage()    {}
func (*ListIntentsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{1}
}

func (m *ListIntentsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListIntentsRequest.Unmarshal(m, b)
}
func (m *ListIntentsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListIntentsRequest.Marshal(b, m, deterministic)
}
func (m *ListIntentsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListIntentsRequest.Merge(m, src)
}
func (m *ListIntentsRequest) XXX_Size() int {
	return xxx_messageInfo_ListIntentsRequest.Size(m)
}
func (m *ListIntentsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListIntentsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListIntentsRequest proto.InternalMessageInfo

func (m *ListIntentsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListIntentsRequest) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *ListIntentsRequest) GetIntentView() IntentView {
	if m != nil {
		return m.IntentView
	}
	return IntentView_INTENT_VIEW_UNSPECIFIED
}

func (m *ListIntentsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListIntentsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// The response message for [Intents.ListIntents][google.cloud.dialogflow.v2beta1.Intents.ListIntents].
type ListIntentsResponse struct {
	// The list of agent intents. There will be a maximum number of items
	// returned based on the page_size field in the request.
	Intents []*Intent `protobuf:"bytes,1,rep,name=intents,proto3" json:"intents,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no
	// more results in the list.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListIntentsResponse) Reset()         { *m = ListIntentsResponse{} }
func (m *ListIntentsResponse) String() string { return proto.CompactTextString(m) }
func (*ListIntentsResponse) ProtoMessage()    {}
func (*ListIntentsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{2}
}

func (m *ListIntentsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListIntentsResponse.Unmarshal(m, b)
}
func (m *ListIntentsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListIntentsResponse.Marshal(b, m, deterministic)
}
func (m *ListIntentsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListIntentsResponse.Merge(m, src)
}
func (m *ListIntentsResponse) XXX_Size() int {
	return xxx_messageInfo_ListIntentsResponse.Size(m)
}
func (m *ListIntentsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListIntentsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListIntentsResponse proto.InternalMessageInfo

func (m *ListIntentsResponse) GetIntents() []*Intent {
	if m != nil {
		return m.Intents
	}
	return nil
}

func (m *ListIntentsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// The request message for [Intents.GetIntent][google.cloud.dialogflow.v2beta1.Intents.GetIntent].
type GetIntentRequest struct {
	// Required. The name of the intent.
	// Format: `projects/<Project ID>/agent/intents/<Intent ID>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The language to retrieve training phrases, parameters and rich
	// messages for. If not specified, the agent's default language is used.
	// [More than a dozen
	// languages](https://dialogflow.com/docs/reference/language) are supported.
	// Note: languages must be enabled in the agent, before they can be used.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Optional. The resource view to apply to the returned intent.
	IntentView           IntentView `protobuf:"varint,3,opt,name=intent_view,json=intentView,proto3,enum=google.cloud.dialogflow.v2beta1.IntentView" json:"intent_view,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *GetIntentRequest) Reset()         { *m = GetIntentRequest{} }
func (m *GetIntentRequest) String() string { return proto.CompactTextString(m) }
func (*GetIntentRequest) ProtoMessage()    {}
func (*GetIntentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{3}
}

func (m *GetIntentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetIntentRequest.Unmarshal(m, b)
}
func (m *GetIntentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetIntentRequest.Marshal(b, m, deterministic)
}
func (m *GetIntentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetIntentRequest.Merge(m, src)
}
func (m *GetIntentRequest) XXX_Size() int {
	return xxx_messageInfo_GetIntentRequest.Size(m)
}
func (m *GetIntentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetIntentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetIntentRequest proto.InternalMessageInfo

func (m *GetIntentRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GetIntentRequest) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *GetIntentRequest) GetIntentView() IntentView {
	if m != nil {
		return m.IntentView
	}
	return IntentView_INTENT_VIEW_UNSPECIFIED
}

// The request message for [Intents.CreateIntent][google.cloud.dialogflow.v2beta1.Intents.CreateIntent].
type CreateIntentRequest struct {
	// Required. The agent to create a intent for.
	// Format: `projects/<Project ID>/agent`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The intent to create.
	Intent *Intent `protobuf:"bytes,2,opt,name=intent,proto3" json:"intent,omitempty"`
	// Optional. The language of training phrases, parameters and rich messages
	// defined in `intent`. If not specified, the agent's default language is
	// used. [More than a dozen
	// languages](https://dialogflow.com/docs/reference/language) are supported.
	// Note: languages must be enabled in the agent, before they can be used.
	LanguageCode string `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Optional. The resource view to apply to the returned intent.
	IntentView           IntentView `protobuf:"varint,4,opt,name=intent_view,json=intentView,proto3,enum=google.cloud.dialogflow.v2beta1.IntentView" json:"intent_view,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *CreateIntentRequest) Reset()         { *m = CreateIntentRequest{} }
func (m *CreateIntentRequest) String() string { return proto.CompactTextString(m) }
func (*CreateIntentRequest) ProtoMessage()    {}
func (*CreateIntentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{4}
}

func (m *CreateIntentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateIntentRequest.Unmarshal(m, b)
}
func (m *CreateIntentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateIntentRequest.Marshal(b, m, deterministic)
}
func (m *CreateIntentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateIntentRequest.Merge(m, src)
}
func (m *CreateIntentRequest) XXX_Size() int {
	return xxx_messageInfo_CreateIntentRequest.Size(m)
}
func (m *CreateIntentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateIntentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateIntentRequest proto.InternalMessageInfo

func (m *CreateIntentRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateIntentRequest) GetIntent() *Intent {
	if m != nil {
		return m.Intent
	}
	return nil
}

func (m *CreateIntentRequest) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *CreateIntentRequest) GetIntentView() IntentView {
	if m != nil {
		return m.IntentView
	}
	return IntentView_INTENT_VIEW_UNSPECIFIED
}

// The request message for [Intents.UpdateIntent][google.cloud.dialogflow.v2beta1.Intents.UpdateIntent].
type UpdateIntentRequest struct {
	// Required. The intent to update.
	// Format: `projects/<Project ID>/agent/intents/<Intent ID>`.
	Intent *Intent `protobuf:"bytes,1,opt,name=intent,proto3" json:"intent,omitempty"`
	// Optional. The language of training phrases, parameters and rich messages
	// defined in `intent`. If not specified, the agent's default language is
	// used. [More than a dozen
	// languages](https://dialogflow.com/docs/reference/language) are supported.
	// Note: languages must be enabled in the agent, before they can be used.
	LanguageCode string `protobuf:"bytes,2,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Optional. The mask to control which fields get updated.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Optional. The resource view to apply to the returned intent.
	IntentView           IntentView `protobuf:"varint,4,opt,name=intent_view,json=intentView,proto3,enum=google.cloud.dialogflow.v2beta1.IntentView" json:"intent_view,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *UpdateIntentRequest) Reset()         { *m = UpdateIntentRequest{} }
func (m *UpdateIntentRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateIntentRequest) ProtoMessage()    {}
func (*UpdateIntentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{5}
}

func (m *UpdateIntentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateIntentRequest.Unmarshal(m, b)
}
func (m *UpdateIntentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateIntentRequest.Marshal(b, m, deterministic)
}
func (m *UpdateIntentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateIntentRequest.Merge(m, src)
}
func (m *UpdateIntentRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateIntentRequest.Size(m)
}
func (m *UpdateIntentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateIntentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateIntentRequest proto.InternalMessageInfo

func (m *UpdateIntentRequest) GetIntent() *Intent {
	if m != nil {
		return m.Intent
	}
	return nil
}

func (m *UpdateIntentRequest) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *UpdateIntentRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateIntentRequest) GetIntentView() IntentView {
	if m != nil {
		return m.IntentView
	}
	return IntentView_INTENT_VIEW_UNSPECIFIED
}

// The request message for [Intents.DeleteIntent][google.cloud.dialogflow.v2beta1.Intents.DeleteIntent].
type DeleteIntentRequest struct {
	// Required. The name of the intent to delete.
	// Format: `projects/<Project ID>/agent/intents/<Intent ID>`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteIntentRequest) Reset()         { *m = DeleteIntentRequest{} }
func (m *DeleteIntentRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteIntentRequest) ProtoMessage()    {}
func (*DeleteIntentRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{6}
}

func (m *DeleteIntentRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteIntentRequest.Unmarshal(m, b)
}
func (m *DeleteIntentRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteIntentRequest.Marshal(b, m, deterministic)
}
func (m *DeleteIntentRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteIntentRequest.Merge(m, src)
}
func (m *DeleteIntentRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteIntentRequest.Size(m)
}
func (m *DeleteIntentRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteIntentRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteIntentRequest proto.InternalMessageInfo

func (m *DeleteIntentRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// The request message for [Intents.BatchUpdateIntents][google.cloud.dialogflow.v2beta1.Intents.BatchUpdateIntents].
type BatchUpdateIntentsRequest struct {
	// Required. The name of the agent to update or create intents in.
	// Format: `projects/<Project ID>/agent`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The source of the intent batch.
	//
	// Types that are valid to be assigned to IntentBatch:
	//	*BatchUpdateIntentsRequest_IntentBatchUri
	//	*BatchUpdateIntentsRequest_IntentBatchInline
	IntentBatch isBatchUpdateIntentsRequest_IntentBatch `protobuf_oneof:"intent_batch"`
	// Optional. The language of training phrases, parameters and rich messages
	// defined in `intents`. If not specified, the agent's default language is
	// used. [More than a dozen
	// languages](https://dialogflow.com/docs/reference/language) are supported.
	// Note: languages must be enabled in the agent, before they can be used.
	LanguageCode string `protobuf:"bytes,4,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Optional. The mask to control which fields get updated.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,5,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Optional. The resource view to apply to the returned intent.
	IntentView           IntentView `protobuf:"varint,6,opt,name=intent_view,json=intentView,proto3,enum=google.cloud.dialogflow.v2beta1.IntentView" json:"intent_view,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *BatchUpdateIntentsRequest) Reset()         { *m = BatchUpdateIntentsRequest{} }
func (m *BatchUpdateIntentsRequest) String() string { return proto.CompactTextString(m) }
func (*BatchUpdateIntentsRequest) ProtoMessage()    {}
func (*BatchUpdateIntentsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{7}
}

func (m *BatchUpdateIntentsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchUpdateIntentsRequest.Unmarshal(m, b)
}
func (m *BatchUpdateIntentsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchUpdateIntentsRequest.Marshal(b, m, deterministic)
}
func (m *BatchUpdateIntentsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchUpdateIntentsRequest.Merge(m, src)
}
func (m *BatchUpdateIntentsRequest) XXX_Size() int {
	return xxx_messageInfo_BatchUpdateIntentsRequest.Size(m)
}
func (m *BatchUpdateIntentsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchUpdateIntentsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BatchUpdateIntentsRequest proto.InternalMessageInfo

func (m *BatchUpdateIntentsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

type isBatchUpdateIntentsRequest_IntentBatch interface {
	isBatchUpdateIntentsRequest_IntentBatch()
}

type BatchUpdateIntentsRequest_IntentBatchUri struct {
	IntentBatchUri string `protobuf:"bytes,2,opt,name=intent_batch_uri,json=intentBatchUri,proto3,oneof"`
}

type BatchUpdateIntentsRequest_IntentBatchInline struct {
	IntentBatchInline *IntentBatch `protobuf:"bytes,3,opt,name=intent_batch_inline,json=intentBatchInline,proto3,oneof"`
}

func (*BatchUpdateIntentsRequest_IntentBatchUri) isBatchUpdateIntentsRequest_IntentBatch() {}

func (*BatchUpdateIntentsRequest_IntentBatchInline) isBatchUpdateIntentsRequest_IntentBatch() {}

func (m *BatchUpdateIntentsRequest) GetIntentBatch() isBatchUpdateIntentsRequest_IntentBatch {
	if m != nil {
		return m.IntentBatch
	}
	return nil
}

func (m *BatchUpdateIntentsRequest) GetIntentBatchUri() string {
	if x, ok := m.GetIntentBatch().(*BatchUpdateIntentsRequest_IntentBatchUri); ok {
		return x.IntentBatchUri
	}
	return ""
}

func (m *BatchUpdateIntentsRequest) GetIntentBatchInline() *IntentBatch {
	if x, ok := m.GetIntentBatch().(*BatchUpdateIntentsRequest_IntentBatchInline); ok {
		return x.IntentBatchInline
	}
	return nil
}

func (m *BatchUpdateIntentsRequest) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *BatchUpdateIntentsRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *BatchUpdateIntentsRequest) GetIntentView() IntentView {
	if m != nil {
		return m.IntentView
	}
	return IntentView_INTENT_VIEW_UNSPECIFIED
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*BatchUpdateIntentsRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _BatchUpdateIntentsRequest_OneofMarshaler, _BatchUpdateIntentsRequest_OneofUnmarshaler, _BatchUpdateIntentsRequest_OneofSizer, []interface{}{
		(*BatchUpdateIntentsRequest_IntentBatchUri)(nil),
		(*BatchUpdateIntentsRequest_IntentBatchInline)(nil),
	}
}

func _BatchUpdateIntentsRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*BatchUpdateIntentsRequest)
	// intent_batch
	switch x := m.IntentBatch.(type) {
	case *BatchUpdateIntentsRequest_IntentBatchUri:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.IntentBatchUri)
	case *BatchUpdateIntentsRequest_IntentBatchInline:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.IntentBatchInline); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("BatchUpdateIntentsRequest.IntentBatch has unexpected type %T", x)
	}
	return nil
}

func _BatchUpdateIntentsRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*BatchUpdateIntentsRequest)
	switch tag {
	case 2: // intent_batch.intent_batch_uri
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.IntentBatch = &BatchUpdateIntentsRequest_IntentBatchUri{x}
		return true, err
	case 3: // intent_batch.intent_batch_inline
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(IntentBatch)
		err := b.DecodeMessage(msg)
		m.IntentBatch = &BatchUpdateIntentsRequest_IntentBatchInline{msg}
		return true, err
	default:
		return false, nil
	}
}

func _BatchUpdateIntentsRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*BatchUpdateIntentsRequest)
	// intent_batch
	switch x := m.IntentBatch.(type) {
	case *BatchUpdateIntentsRequest_IntentBatchUri:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.IntentBatchUri)))
		n += len(x.IntentBatchUri)
	case *BatchUpdateIntentsRequest_IntentBatchInline:
		s := proto.Size(x.IntentBatchInline)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// The response message for [Intents.BatchUpdateIntents][google.cloud.dialogflow.v2beta1.Intents.BatchUpdateIntents].
type BatchUpdateIntentsResponse struct {
	// The collection of updated or created intents.
	Intents              []*Intent `protobuf:"bytes,1,rep,name=intents,proto3" json:"intents,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *BatchUpdateIntentsResponse) Reset()         { *m = BatchUpdateIntentsResponse{} }
func (m *BatchUpdateIntentsResponse) String() string { return proto.CompactTextString(m) }
func (*BatchUpdateIntentsResponse) ProtoMessage()    {}
func (*BatchUpdateIntentsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{8}
}

func (m *BatchUpdateIntentsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchUpdateIntentsResponse.Unmarshal(m, b)
}
func (m *BatchUpdateIntentsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchUpdateIntentsResponse.Marshal(b, m, deterministic)
}
func (m *BatchUpdateIntentsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchUpdateIntentsResponse.Merge(m, src)
}
func (m *BatchUpdateIntentsResponse) XXX_Size() int {
	return xxx_messageInfo_BatchUpdateIntentsResponse.Size(m)
}
func (m *BatchUpdateIntentsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchUpdateIntentsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_BatchUpdateIntentsResponse proto.InternalMessageInfo

func (m *BatchUpdateIntentsResponse) GetIntents() []*Intent {
	if m != nil {
		return m.Intents
	}
	return nil
}

// The request message for [Intents.BatchDeleteIntents][google.cloud.dialogflow.v2beta1.Intents.BatchDeleteIntents].
type BatchDeleteIntentsRequest struct {
	// Required. The name of the agent to delete all entities types for. Format:
	// `projects/<Project ID>/agent`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The collection of intents to delete. Only intent `name` must be
	// filled in.
	Intents              []*Intent `protobuf:"bytes,2,rep,name=intents,proto3" json:"intents,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *BatchDeleteIntentsRequest) Reset()         { *m = BatchDeleteIntentsRequest{} }
func (m *BatchDeleteIntentsRequest) String() string { return proto.CompactTextString(m) }
func (*BatchDeleteIntentsRequest) ProtoMessage()    {}
func (*BatchDeleteIntentsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{9}
}

func (m *BatchDeleteIntentsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchDeleteIntentsRequest.Unmarshal(m, b)
}
func (m *BatchDeleteIntentsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchDeleteIntentsRequest.Marshal(b, m, deterministic)
}
func (m *BatchDeleteIntentsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchDeleteIntentsRequest.Merge(m, src)
}
func (m *BatchDeleteIntentsRequest) XXX_Size() int {
	return xxx_messageInfo_BatchDeleteIntentsRequest.Size(m)
}
func (m *BatchDeleteIntentsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchDeleteIntentsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BatchDeleteIntentsRequest proto.InternalMessageInfo

func (m *BatchDeleteIntentsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *BatchDeleteIntentsRequest) GetIntents() []*Intent {
	if m != nil {
		return m.Intents
	}
	return nil
}

// This message is a wrapper around a collection of intents.
type IntentBatch struct {
	// A collection of intents.
	Intents              []*Intent `protobuf:"bytes,1,rep,name=intents,proto3" json:"intents,omitempty"`
	XXX_NoUnkeyedLiteral struct{}  `json:"-"`
	XXX_unrecognized     []byte    `json:"-"`
	XXX_sizecache        int32     `json:"-"`
}

func (m *IntentBatch) Reset()         { *m = IntentBatch{} }
func (m *IntentBatch) String() string { return proto.CompactTextString(m) }
func (*IntentBatch) ProtoMessage()    {}
func (*IntentBatch) Descriptor() ([]byte, []int) {
	return fileDescriptor_5bdb4dcc248bd417, []int{10}
}

func (m *IntentBatch) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IntentBatch.Unmarshal(m, b)
}
func (m *IntentBatch) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IntentBatch.Marshal(b, m, deterministic)
}
func (m *IntentBatch) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IntentBatch.Merge(m, src)
}
func (m *IntentBatch) XXX_Size() int {
	return xxx_messageInfo_IntentBatch.Size(m)
}
func (m *IntentBatch) XXX_DiscardUnknown() {
	xxx_messageInfo_IntentBatch.DiscardUnknown(m)
}

var xxx_messageInfo_IntentBatch proto.InternalMessageInfo

func (m *IntentBatch) GetIntents() []*Intent {
	if m != nil {
		return m.Intents
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.cloud.dialogflow.v2beta1.IntentView", IntentView_name, IntentView_value)
	proto.RegisterEnum("google.cloud.dialogflow.v2beta1.Intent_WebhookState", Intent_WebhookState_name, Intent_WebhookState_value)
	proto.RegisterEnum("google.cloud.dialogflow.v2beta1.Intent_TrainingPhrase_Type", Intent_TrainingPhrase_Type_name, Intent_TrainingPhrase_Type_value)
	proto.RegisterEnum("google.cloud.dialogflow.v2beta1.Intent_Message_Platform", Intent_Message_Platform_name, Intent_Message_Platform_value)
	proto.RegisterType((*Intent)(nil), "google.cloud.dialogflow.v2beta1.Intent")
	proto.RegisterType((*Intent_TrainingPhrase)(nil), "google.cloud.dialogflow.v2beta1.Intent.TrainingPhrase")
	proto.RegisterType((*Intent_TrainingPhrase_Part)(nil), "google.cloud.dialogflow.v2beta1.Intent.TrainingPhrase.Part")
	proto.RegisterType((*Intent_Parameter)(nil), "google.cloud.dialogflow.v2beta1.Intent.Parameter")
	proto.RegisterType((*Intent_Message)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message")
	proto.RegisterType((*Intent_Message_Text)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.Text")
	proto.RegisterType((*Intent_Message_Image)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.Image")
	proto.RegisterType((*Intent_Message_QuickReplies)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.QuickReplies")
	proto.RegisterType((*Intent_Message_Card)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.Card")
	proto.RegisterType((*Intent_Message_Card_Button)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.Card.Button")
	proto.RegisterType((*Intent_Message_SimpleResponse)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.SimpleResponse")
	proto.RegisterType((*Intent_Message_SimpleResponses)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.SimpleResponses")
	proto.RegisterType((*Intent_Message_BasicCard)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.BasicCard")
	proto.RegisterType((*Intent_Message_BasicCard_Button)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.BasicCard.Button")
	proto.RegisterType((*Intent_Message_BasicCard_Button_OpenUriAction)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.BasicCard.Button.OpenUriAction")
	proto.RegisterType((*Intent_Message_Suggestion)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.Suggestion")
	proto.RegisterType((*Intent_Message_Suggestions)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.Suggestions")
	proto.RegisterType((*Intent_Message_LinkOutSuggestion)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.LinkOutSuggestion")
	proto.RegisterType((*Intent_Message_ListSelect)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.ListSelect")
	proto.RegisterType((*Intent_Message_ListSelect_Item)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.ListSelect.Item")
	proto.RegisterType((*Intent_Message_CarouselSelect)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.CarouselSelect")
	proto.RegisterType((*Intent_Message_CarouselSelect_Item)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.CarouselSelect.Item")
	proto.RegisterType((*Intent_Message_SelectItemInfo)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.SelectItemInfo")
	proto.RegisterType((*Intent_Message_TelephonyPlayAudio)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.TelephonyPlayAudio")
	proto.RegisterType((*Intent_Message_TelephonySynthesizeSpeech)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.TelephonySynthesizeSpeech")
	proto.RegisterType((*Intent_Message_TelephonyTransferCall)(nil), "google.cloud.dialogflow.v2beta1.Intent.Message.TelephonyTransferCall")
	proto.RegisterType((*Intent_FollowupIntentInfo)(nil), "google.cloud.dialogflow.v2beta1.Intent.FollowupIntentInfo")
	proto.RegisterType((*ListIntentsRequest)(nil), "google.cloud.dialogflow.v2beta1.ListIntentsRequest")
	proto.RegisterType((*ListIntentsResponse)(nil), "google.cloud.dialogflow.v2beta1.ListIntentsResponse")
	proto.RegisterType((*GetIntentRequest)(nil), "google.cloud.dialogflow.v2beta1.GetIntentRequest")
	proto.RegisterType((*CreateIntentRequest)(nil), "google.cloud.dialogflow.v2beta1.CreateIntentRequest")
	proto.RegisterType((*UpdateIntentRequest)(nil), "google.cloud.dialogflow.v2beta1.UpdateIntentRequest")
	proto.RegisterType((*DeleteIntentRequest)(nil), "google.cloud.dialogflow.v2beta1.DeleteIntentRequest")
	proto.RegisterType((*BatchUpdateIntentsRequest)(nil), "google.cloud.dialogflow.v2beta1.BatchUpdateIntentsRequest")
	proto.RegisterType((*BatchUpdateIntentsResponse)(nil), "google.cloud.dialogflow.v2beta1.BatchUpdateIntentsResponse")
	proto.RegisterType((*BatchDeleteIntentsRequest)(nil), "google.cloud.dialogflow.v2beta1.BatchDeleteIntentsRequest")
	proto.RegisterType((*IntentBatch)(nil), "google.cloud.dialogflow.v2beta1.IntentBatch")
}

func init() {
	proto.RegisterFile("google/cloud/dialogflow/v2beta1/intent.proto", fileDescriptor_5bdb4dcc248bd417)
}

var fileDescriptor_5bdb4dcc248bd417 = []byte{
	// 2808 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xe4, 0x5a, 0xcf, 0x73, 0x23, 0x47,
	0xf5, 0xf7, 0xe8, 0x87, 0x2d, 0x3d, 0xc9, 0xb2, 0xdc, 0xf6, 0xee, 0xce, 0xce, 0x26, 0xdf, 0x38,
	0xca, 0x37, 0x89, 0x63, 0x12, 0x89, 0x75, 0x42, 0x7e, 0x78, 0x49, 0x82, 0x64, 0xcb, 0x2b, 0x61,
	0xd9, 0xd2, 0x8e, 0xe4, 0x0d, 0x9b, 0x02, 0xa6, 0x46, 0x52, 0x5b, 0x3b, 0x78, 0x34, 0x33, 0x3b,
	0xdd, 0xf2, 0x46, 0x81, 0x14, 0x14, 0x55, 0xc0, 0x81, 0x0b, 0x55, 0x9c, 0xf8, 0x71, 0x82, 0x53,
	0x28, 0x0e, 0x54, 0x6e, 0xfc, 0x09, 0x1c, 0x38, 0x71, 0xcc, 0x81, 0xa2, 0x8a, 0xe2, 0xc0, 0x5f,
	0xc0, 0x0d, 0xaa, 0x7b, 0x7a, 0xa4, 0x91, 0xa5, 0x45, 0x3f, 0xbc, 0x70, 0xe1, 0x36, 0xfd, 0xfa,
	0xf5, 0xe7, 0xfd, 0xea, 0x7e, 0xef, 0x75, 0x4b, 0xf0, 0x6a, 0xc7, 0xb6, 0x3b, 0x26, 0xce, 0xb5,
	0x4c, 0xbb, 0xd7, 0xce, 0xb5, 0x0d, 0xdd, 0xb4, 0x3b, 0x67, 0xa6, 0xfd, 0x38, 0x77, 0xb1, 0xdb,
	0xc4, 0x54, 0xbf, 0x9d, 0x33, 0x2c, 0x8a, 0x2d, 0x9a, 0x75, 0x5c, 0x9b, 0xda, 0xe8, 0x39, 0x8f,
	0x3b, 0xcb, 0xb9, 0xb3, 0x43, 0xee, 0xac, 0xe0, 0x56, 0x9e, 0x11, 0x70, 0xba, 0x63, 0xe4, 0x74,
	0xcb, 0xb2, 0xa9, 0x4e, 0x0d, 0xdb, 0x22, 0xde, 0x72, 0xe5, 0xb5, 0x69, 0xc2, 0x5a, 0xb6, 0x45,
	0xf1, 0x47, 0x42, 0x9a, 0xf2, 0x82, 0x60, 0x37, 0x6d, 0xab, 0xe3, 0xf6, 0x2c, 0xcb, 0xb0, 0x3a,
	0x39, 0xdb, 0xc1, 0xee, 0x08, 0xe6, 0x2d, 0xc1, 0xc4, 0x47, 0xcd, 0xde, 0x59, 0x0e, 0x77, 0x1d,
	0xda, 0x17, 0x93, 0x5b, 0x97, 0x27, 0xcf, 0x0c, 0x6c, 0xb6, 0xb5, 0xae, 0x4e, 0xce, 0x05, 0xc7,
	0x33, 0x97, 0x39, 0x08, 0x75, 0x7b, 0x2d, 0xa1, 0x41, 0xe6, 0x97, 0x39, 0x58, 0x2e, 0x73, 0x07,
	0x20, 0x04, 0x11, 0x4b, 0xef, 0x62, 0x59, 0xda, 0x92, 0xb6, 0xe3, 0x2a, 0xff, 0x46, 0xcf, 0x43,
	0xb2, 0x6d, 0x10, 0xc7, 0xd4, 0xfb, 0x1a, 0x9f, 0x0b, 0xf1, 0xb9, 0x84, 0xa0, 0x9d, 0x30, 0x96,
	0x07, 0xb0, 0xfa, 0x18, 0x37, 0x1f, 0xda, 0xf6, 0xb9, 0x46, 0xa8, 0x4e, 0xb1, 0xbc, 0xbc, 0x25,
	0x6d, 0xa7, 0x76, 0xdf, 0xc8, 0x4e, 0xf1, 0x64, 0xd6, 0x13, 0x9b, 0xfd, 0xc0, 0x5b, 0x5c, 0x67,
	0x6b, 0xd5, 0xe4, 0xe3, 0xc0, 0x08, 0x29, 0x10, 0x73, 0x5c, 0xc3, 0x76, 0x0d, 0xda, 0x97, 0xc3,
	0x5b, 0xd2, 0x76, 0x54, 0x1d, 0x8c, 0xd1, 0x73, 0x90, 0x30, 0x88, 0x76, 0xa6, 0x9b, 0x66, 0x53,
	0x6f, 0x9d, 0xcb, 0x91, 0x2d, 0x69, 0x3b, 0xa6, 0x82, 0x41, 0x0e, 0x05, 0x05, 0x3d, 0x0f, 0xd0,
	0x35, 0x35, 0x6c, 0xe9, 0x4d, 0x13, 0xb7, 0xe5, 0x28, 0x9b, 0x2f, 0x84, 0x64, 0x49, 0x8d, 0x77,
	0xcd, 0xa2, 0x47, 0x64, 0x18, 0x5d, 0x53, 0x6b, 0x1b, 0xc4, 0xe3, 0xd9, 0xf0, 0x30, 0xba, 0xe6,
	0x81, 0xa0, 0xa0, 0x97, 0x61, 0x0d, 0x5b, 0x6d, 0x8d, 0xed, 0x10, 0x57, 0x6f, 0xb1, 0xa0, 0xc8,
	0xd7, 0x38, 0x53, 0x0a, 0x5b, 0xed, 0xf2, 0x90, 0x8a, 0xb2, 0xb0, 0x61, 0x58, 0x4e, 0x8f, 0x6a,
	0x22, 0xbe, 0xdc, 0x5b, 0x44, 0x5e, 0xd9, 0x0a, 0x6f, 0xc7, 0xd5, 0x75, 0x3e, 0xb5, 0xef, 0xcd,
	0x30, 0x9f, 0x11, 0x74, 0x1d, 0x96, 0xf1, 0x05, 0xb6, 0x28, 0x91, 0x63, 0x9c, 0x45, 0x8c, 0x90,
	0x0e, 0x69, 0xea, 0xea, 0x06, 0xdb, 0x08, 0x9a, 0xf3, 0xd0, 0xd5, 0x09, 0x26, 0x72, 0x7c, 0x2b,
	0xbc, 0x9d, 0xd8, 0x7d, 0x73, 0x56, 0x7f, 0x36, 0xc4, 0xfa, 0x1a, 0x5f, 0xae, 0xae, 0xd1, 0x91,
	0x31, 0x17, 0x2d, 0x4c, 0x01, 0x1e, 0x4c, 0x31, 0x42, 0xf7, 0x60, 0xcd, 0xee, 0xd1, 0x80, 0x0d,
	0x44, 0x4e, 0x70, 0xc9, 0xdb, 0x53, 0x25, 0x0b, 0xd3, 0xd4, 0x94, 0x07, 0x20, 0x86, 0x04, 0xbd,
	0x08, 0x29, 0x17, 0x13, 0x1c, 0x40, 0x4c, 0x72, 0xef, 0xad, 0x72, 0xea, 0x80, 0xed, 0x1e, 0x80,
	0xa3, 0xbb, 0x7a, 0x17, 0x53, 0xec, 0x12, 0x79, 0x95, 0x0b, 0xbd, 0x3d, 0xab, 0xb9, 0x35, 0x7f,
	0xa5, 0x1a, 0x00, 0x41, 0x47, 0x10, 0xeb, 0x62, 0x42, 0xf4, 0x0e, 0x26, 0x72, 0x8a, 0x03, 0xe6,
	0x66, 0x05, 0x3c, 0xf6, 0xd6, 0xa9, 0x03, 0x00, 0x74, 0x01, 0x4a, 0x1b, 0x9f, 0xe9, 0x3d, 0x93,
	0x6a, 0x2e, 0x26, 0x8e, 0x6d, 0x11, 0xac, 0x39, 0xa6, 0x4e, 0xcf, 0x6c, 0xb7, 0x4b, 0xe4, 0xb5,
	0xad, 0xf0, 0x76, 0x6a, 0xf7, 0xed, 0x39, 0xe1, 0xb3, 0x35, 0x01, 0xa0, 0xca, 0x02, 0x5b, 0x15,
	0xd0, 0xfe, 0x04, 0x41, 0xef, 0xc0, 0x4d, 0xd7, 0xb6, 0xa9, 0x76, 0x66, 0x9b, 0xa6, 0xfd, 0xb8,
	0xe7, 0x68, 0x5e, 0xa6, 0xf2, 0x4e, 0x62, 0x9a, 0x07, 0xef, 0x3a, 0x63, 0x38, 0x14, 0xf3, 0x9e,
	0x04, 0x7e, 0x28, 0xdf, 0x85, 0x5b, 0x8e, 0xee, 0x32, 0xe6, 0x89, 0x8b, 0xd7, 0xf9, 0x62, 0xd9,
	0x63, 0x99, 0xb0, 0xdc, 0x84, 0xcd, 0xcb, 0xeb, 0x0c, 0xeb, 0xcc, 0x96, 0x11, 0x77, 0xe5, 0xde,
	0xac, 0xb6, 0x8e, 0x22, 0x97, 0xad, 0x33, 0x5b, 0x45, 0x67, 0x63, 0x34, 0xe5, 0xd7, 0x61, 0x48,
	0x8d, 0xee, 0xda, 0x89, 0xb9, 0xa8, 0x0a, 0x11, 0xda, 0x77, 0xbc, 0x1c, 0x94, 0xda, 0xbd, 0xb3,
	0xd8, 0x79, 0xc8, 0x36, 0xfa, 0x0e, 0x56, 0x39, 0x10, 0xba, 0x07, 0x51, 0x47, 0x77, 0x29, 0x91,
	0xc3, 0xdc, 0xac, 0x45, 0x11, 0x6b, 0xba, 0x4b, 0x55, 0x0f, 0x09, 0xed, 0xc0, 0x3a, 0x35, 0xba,
	0x98, 0x68, 0x7a, 0xbb, 0x8d, 0xdb, 0x5a, 0xcb, 0xee, 0x59, 0x94, 0xe7, 0xa6, 0xa8, 0xba, 0xc6,
	0x27, 0xf2, 0x8c, 0xbe, 0xcf, 0xc8, 0x0a, 0x85, 0x08, 0x5b, 0xca, 0x6c, 0x65, 0xe7, 0xc0, 0xb7,
	0x95, 0x7d, 0xb3, 0xcc, 0x84, 0x2d, 0x6a, 0xd0, 0xbe, 0x36, 0x30, 0x39, 0xae, 0x82, 0x47, 0x62,
	0x16, 0xa0, 0x4d, 0x88, 0xea, 0xa6, 0xa1, 0x13, 0x9e, 0x17, 0xe3, 0xaa, 0x37, 0x60, 0xe9, 0xba,
	0x47, 0xb0, 0xab, 0xb5, 0xf1, 0x99, 0x61, 0xe1, 0xb6, 0xc8, 0x8a, 0x09, 0x46, 0x3b, 0xf0, 0x48,
	0x99, 0xb7, 0x20, 0x22, 0x00, 0xd2, 0x8d, 0x07, 0xb5, 0xa2, 0x76, 0x7a, 0x52, 0xaf, 0x15, 0xf7,
	0xcb, 0x87, 0xe5, 0xe2, 0x41, 0x7a, 0x09, 0x25, 0x60, 0xa5, 0xf8, 0xb5, 0xfc, 0x71, 0xad, 0x52,
	0x4c, 0x4b, 0x28, 0x09, 0xb1, 0x46, 0xf1, 0xb8, 0x56, 0xc9, 0x37, 0x8a, 0xe9, 0x90, 0xf2, 0xa3,
	0x10, 0xc4, 0x07, 0x87, 0x6d, 0xd1, 0x62, 0xb1, 0x09, 0xd1, 0x0b, 0xdd, 0xec, 0x61, 0x5f, 0x6d,
	0x3e, 0x40, 0x2f, 0xc0, 0xaa, 0x7f, 0xc0, 0xbc, 0xd9, 0x08, 0x9f, 0x4d, 0x0a, 0xe2, 0x7d, 0xce,
	0xf4, 0x16, 0xc8, 0x01, 0x97, 0x68, 0x23, 0x92, 0xa2, 0x9c, 0xff, 0xda, 0xd0, 0x3f, 0x07, 0x01,
	0x99, 0xcf, 0x40, 0xbc, 0xab, 0x5b, 0x6d, 0x9d, 0xda, 0x6e, 0x9f, 0x17, 0xa7, 0x98, 0x3a, 0x24,
	0x20, 0x19, 0x56, 0x1c, 0xd7, 0xee, 0x3a, 0xd4, 0xcf, 0xd6, 0xfe, 0x10, 0xdd, 0x80, 0x15, 0x83,
	0x68, 0xa6, 0x41, 0xa8, 0x1c, 0xe3, 0xab, 0x96, 0x0d, 0x52, 0x31, 0x08, 0x55, 0xfe, 0xfe, 0x7f,
	0xb0, 0x22, 0x8e, 0x31, 0xfa, 0x6a, 0x20, 0x78, 0x89, 0xd9, 0x8b, 0x9e, 0x9f, 0x05, 0x1a, 0xf8,
	0x23, 0x5a, 0x5a, 0x12, 0x41, 0x3f, 0x86, 0xa8, 0xd1, 0xd5, 0x3b, 0x9e, 0xe3, 0x12, 0xbb, 0x5f,
	0x9a, 0x17, 0xac, 0xcc, 0x16, 0x97, 0x96, 0x54, 0x0f, 0x05, 0xb5, 0x60, 0xf5, 0x51, 0xcf, 0x68,
	0x9d, 0x6b, 0x2e, 0x76, 0x4c, 0x03, 0x7b, 0x5b, 0x25, 0xb1, 0xfb, 0xe5, 0x79, 0x61, 0xef, 0x31,
	0x10, 0xd5, 0xc3, 0x28, 0x2d, 0xa9, 0xc9, 0x47, 0x81, 0x31, 0xb3, 0xbf, 0xa5, 0xbb, 0xde, 0x4e,
	0x5b, 0xc0, 0xfe, 0x7d, 0xdd, 0x6d, 0x33, 0xfb, 0x19, 0x06, 0x7a, 0x1d, 0x56, 0x1c, 0xbd, 0x6f,
	0xda, 0xba, 0x57, 0xae, 0x13, 0xbb, 0x37, 0x7c, 0x38, 0xbf, 0x77, 0xc9, 0xd6, 0x79, 0xef, 0x52,
	0x5a, 0x52, 0x7d, 0x4e, 0x64, 0x42, 0x9a, 0x18, 0x5d, 0xc7, 0xc4, 0x83, 0xdc, 0xcc, 0x02, 0xc9,
	0x56, 0xbf, 0x3f, 0xaf, 0x32, 0x75, 0x8e, 0xe3, 0xe7, 0x61, 0x66, 0xeb, 0x1a, 0x19, 0x25, 0xa1,
	0x0f, 0x01, 0x9a, 0x3a, 0x31, 0x5a, 0x1a, 0x37, 0x3a, 0xc6, 0xe5, 0xbc, 0x33, 0xaf, 0x9c, 0x02,
	0x43, 0x10, 0x96, 0xc7, 0x9b, 0xfe, 0x00, 0x69, 0x90, 0x20, 0xbd, 0x4e, 0x07, 0x13, 0xde, 0xfc,
	0xc9, 0x71, 0x0e, 0x7e, 0x67, 0x6e, 0x23, 0x86, 0x10, 0xa5, 0x25, 0x35, 0x88, 0x88, 0x08, 0x6c,
	0x98, 0x86, 0x75, 0xae, 0xd9, 0x3d, 0xaa, 0x0d, 0xe9, 0xbc, 0x0d, 0x48, 0xec, 0xe6, 0xe7, 0x15,
	0x54, 0x31, 0xac, 0xf3, 0x6a, 0x8f, 0x0e, 0xe5, 0x95, 0x96, 0xd4, 0x75, 0xf3, 0x32, 0x11, 0x7d,
	0x03, 0x12, 0xec, 0x08, 0x69, 0x04, 0x9b, 0xb8, 0x45, 0xe5, 0x04, 0x17, 0xb6, 0x37, 0xbf, 0x30,
	0x42, 0xeb, 0x1c, 0xa1, 0xb4, 0xa4, 0x82, 0x39, 0x18, 0x21, 0x03, 0xd6, 0x5a, 0xba, 0x6b, 0xf7,
	0x08, 0x36, 0x7d, 0x11, 0x49, 0x2e, 0xe2, 0xbd, 0x05, 0xb6, 0x22, 0x87, 0x19, 0x88, 0x49, 0xb5,
	0x46, 0x28, 0xe8, 0x02, 0x36, 0x29, 0x36, 0xb1, 0xf3, 0xd0, 0xb6, 0xfa, 0x1a, 0xcf, 0x3d, 0x7a,
	0xaf, 0x6d, 0xd8, 0xf2, 0x2a, 0x97, 0x57, 0x98, 0xff, 0xe8, 0x0b, 0xac, 0x9a, 0xa9, 0xf7, 0xf3,
	0x0c, 0xa9, 0xb4, 0xa4, 0x22, 0x3a, 0x46, 0x45, 0x3f, 0x96, 0xe0, 0xd6, 0x50, 0x30, 0xe9, 0x5b,
	0xf4, 0x21, 0x26, 0xc6, 0xc7, 0x58, 0x23, 0x0e, 0xc6, 0xad, 0x87, 0x72, 0x8a, 0xcb, 0x2f, 0x2f,
	0x2c, 0xbf, 0x3e, 0x40, 0xac, 0x73, 0xc0, 0xd2, 0x92, 0x7a, 0x93, 0x3e, 0x69, 0x12, 0x7d, 0x17,
	0x6e, 0x0c, 0x95, 0xa1, 0xae, 0x6e, 0x91, 0x33, 0xec, 0x6a, 0x2d, 0xdd, 0x34, 0xe5, 0x35, 0xae,
	0x48, 0x71, 0x61, 0x45, 0x1a, 0x02, 0x6d, 0x5f, 0x37, 0xcd, 0xd2, 0x92, 0x7a, 0x8d, 0x4e, 0x9a,
	0x40, 0x0d, 0x88, 0xf9, 0xcd, 0x97, 0xb8, 0x6a, 0x2c, 0xde, 0x7b, 0x0d, 0x90, 0x14, 0x05, 0x22,
	0x2c, 0x17, 0x07, 0x8a, 0x71, 0xd8, 0x2f, 0xc6, 0x4a, 0x1d, 0xa2, 0x3c, 0xb5, 0xa2, 0x5b, 0x10,
	0xe7, 0xa9, 0x55, 0xeb, 0xb9, 0x86, 0xa8, 0x7c, 0x31, 0x4e, 0x38, 0x75, 0x0d, 0xf4, 0x1a, 0x20,
	0xbd, 0xd5, 0xc2, 0x84, 0x18, 0x4d, 0xc3, 0xe4, 0x65, 0x8a, 0xe1, 0x78, 0x35, 0x70, 0x7d, 0x64,
	0x86, 0x09, 0x52, 0xca, 0x90, 0x0c, 0x26, 0x56, 0x56, 0x19, 0xa9, 0x41, 0x4d, 0xbf, 0xa2, 0x7a,
	0x03, 0x56, 0x19, 0x47, 0x73, 0x78, 0x88, 0xeb, 0x35, 0x92, 0x83, 0x95, 0xbf, 0x49, 0x10, 0xe1,
	0x19, 0x64, 0x32, 0x86, 0x02, 0x31, 0xd2, 0x6b, 0x7a, 0x13, 0x9e, 0x3a, 0x83, 0xf1, 0xa8, 0x45,
	0xe1, 0x4b, 0x16, 0x9d, 0xc2, 0x4a, 0xb3, 0x47, 0x29, 0x4b, 0x46, 0x91, 0xf9, 0x3a, 0xa4, 0x60,
	0x7a, 0xcf, 0x16, 0x38, 0x86, 0xea, 0x63, 0x29, 0x6f, 0xc3, 0xb2, 0x47, 0x9a, 0xd8, 0xf9, 0xb0,
	0x3b, 0x9f, 0x4d, 0x28, 0xbf, 0xd4, 0x09, 0x6d, 0xfd, 0xb1, 0xd2, 0x85, 0xd4, 0x68, 0x8e, 0x46,
	0xff, 0x0f, 0x29, 0x7e, 0xdd, 0xa2, 0xb6, 0x7f, 0x1a, 0x3c, 0xac, 0x24, 0xa3, 0x36, 0x6c, 0xb1,
	0x67, 0x11, 0x44, 0x08, 0xe9, 0x9a, 0x02, 0x8f, 0x7f, 0x07, 0x9b, 0x15, 0xae, 0x43, 0x78, 0xa4,
	0x59, 0xe1, 0x21, 0xfa, 0x0e, 0xac, 0x5d, 0x2a, 0x09, 0xc8, 0x98, 0x50, 0x6d, 0x24, 0xee, 0x9b,
	0xf7, 0xae, 0x56, 0x6d, 0xc6, 0x4a, 0x8d, 0xf2, 0x87, 0x30, 0xc4, 0x07, 0x95, 0x62, 0x81, 0xd0,
	0xbe, 0x08, 0x29, 0xb6, 0xb3, 0x75, 0x4a, 0x71, 0x3b, 0x68, 0xe2, 0xea, 0x80, 0xca, 0x37, 0xfc,
	0x91, 0xdf, 0x74, 0x44, 0xae, 0xd0, 0x74, 0xf8, 0x2d, 0xc7, 0x87, 0xc3, 0x1d, 0x13, 0xe5, 0x5e,
	0xf9, 0xca, 0xc2, 0xb5, 0x71, 0x6c, 0xdb, 0xfc, 0x5e, 0x1a, 0xec, 0x9b, 0xc9, 0xce, 0xb8, 0x80,
	0x35, 0xdb, 0xc1, 0x16, 0xdb, 0xca, 0x9a, 0xb8, 0xe1, 0x7a, 0x8d, 0xd4, 0xc9, 0x55, 0x95, 0xc8,
	0x56, 0x1d, 0x6c, 0x9d, 0xba, 0x46, 0x9e, 0xa3, 0xaa, 0xab, 0x76, 0x70, 0xa8, 0x3c, 0x0f, 0xab,
	0x23, 0xf3, 0x28, 0x0d, 0xe1, 0x61, 0x82, 0x60, 0x9f, 0x4a, 0x06, 0x20, 0x50, 0x12, 0x27, 0xaa,
	0xaf, 0x9c, 0x43, 0x22, 0x50, 0xbb, 0xd1, 0xd7, 0x47, 0xbb, 0x01, 0x69, 0xbe, 0x9b, 0xd7, 0x78,
	0x37, 0x30, 0xd2, 0x0a, 0x28, 0x35, 0x58, 0x1f, 0xab, 0xdf, 0xe8, 0x15, 0x48, 0xb7, 0xd9, 0xa7,
	0xc5, 0x9f, 0x9f, 0xb4, 0x40, 0x7f, 0xbf, 0x16, 0xa0, 0xf3, 0x9e, 0x5a, 0x98, 0x18, 0x1a, 0x9a,
	0xf8, 0x79, 0x08, 0x60, 0x58, 0xa5, 0x9f, 0x10, 0xa2, 0x53, 0x88, 0x1a, 0x14, 0x77, 0xbd, 0x34,
	0xb6, 0x40, 0x87, 0x36, 0x14, 0x90, 0x2d, 0x53, 0xdc, 0x55, 0x3d, 0x34, 0xe5, 0xcf, 0x12, 0x44,
	0xd8, 0x18, 0xa9, 0x10, 0xe1, 0xf7, 0x54, 0x69, 0xb1, 0x16, 0xc0, 0x83, 0x66, 0x48, 0xfc, 0xae,
	0xca, 0xb1, 0x86, 0x96, 0x84, 0x82, 0x96, 0x6c, 0x41, 0xa2, 0x8d, 0x49, 0xcb, 0x35, 0x1c, 0xbe,
	0xd1, 0xfc, 0xec, 0x31, 0x24, 0x3d, 0xd5, 0x83, 0xa5, 0xfc, 0x31, 0x04, 0xa9, 0xd1, 0x06, 0x05,
	0x3d, 0xf0, 0x7d, 0xe9, 0x6d, 0x8d, 0xfd, 0xab, 0xf5, 0x3b, 0xff, 0x63, 0xfe, 0x7c, 0x0f, 0x52,
	0xa3, 0xca, 0xb1, 0x1d, 0x7d, 0x8e, 0xfb, 0xfe, 0xa1, 0x3d, 0xc7, 0x7d, 0x9e, 0x5c, 0xfb, 0x96,
	0x6d, 0xf5, 0xbb, 0x7e, 0xd9, 0x1d, 0x8c, 0x95, 0xdb, 0x80, 0xc6, 0xfb, 0x37, 0x56, 0x4d, 0x79,
	0x4b, 0x18, 0xec, 0x0f, 0x38, 0xe1, 0xd4, 0x35, 0x94, 0x7b, 0x70, 0xf3, 0x89, 0x2d, 0x17, 0xda,
	0x0c, 0x56, 0xc2, 0xc1, 0x85, 0x70, 0x33, 0x58, 0xb7, 0x18, 0x95, 0x8d, 0x0a, 0x31, 0x58, 0x26,
	0x76, 0xcf, 0x6d, 0x61, 0x65, 0x0f, 0xae, 0x4d, 0x6c, 0x9e, 0x58, 0x71, 0x63, 0x44, 0xac, 0x59,
	0xbd, 0x6e, 0x13, 0xbb, 0x42, 0x97, 0x04, 0xa7, 0x9d, 0x70, 0x52, 0xe6, 0xe7, 0x12, 0xc4, 0xfc,
	0x3e, 0x08, 0xc9, 0xb0, 0xc9, 0xae, 0xf9, 0x87, 0x55, 0xf5, 0xf8, 0xd2, 0x83, 0x40, 0x12, 0x62,
	0x87, 0xf9, 0xfd, 0x62, 0xa1, 0x5a, 0x3d, 0x4a, 0x4b, 0x28, 0x0e, 0xd1, 0x7a, 0x25, 0xbf, 0x7f,
	0x94, 0x0e, 0x79, 0x8f, 0x03, 0x95, 0xe2, 0x5d, 0x35, 0x7f, 0x9c, 0x0e, 0xa3, 0x15, 0x08, 0x1f,
	0x95, 0x8f, 0xd2, 0x11, 0xce, 0x71, 0xf4, 0xa0, 0x56, 0x4c, 0x47, 0x51, 0x0c, 0x22, 0x95, 0xf2,
	0x49, 0x31, 0xbd, 0xcc, 0x88, 0xf7, 0xcb, 0x85, 0xa2, 0x9a, 0x5e, 0x41, 0xd7, 0x60, 0x3d, 0xbf,
	0xdf, 0x28, 0x57, 0x4f, 0xea, 0x5a, 0xf5, 0x44, 0xbb, 0x5b, 0xad, 0xde, 0xad, 0x14, 0xd3, 0x31,
	0xb4, 0x0a, 0x71, 0x86, 0x56, 0x2b, 0x55, 0x4f, 0x1e, 0xa4, 0xa1, 0x10, 0x87, 0x15, 0xf1, 0xfa,
	0xa6, 0xfc, 0x40, 0x02, 0x34, 0xfe, 0x8e, 0x84, 0xbe, 0x38, 0xfe, 0x42, 0x15, 0xc8, 0x57, 0x97,
	0x5e, 0x99, 0x66, 0x79, 0x12, 0x0b, 0xfd, 0xfb, 0x27, 0xb1, 0x0c, 0x85, 0x64, 0xf0, 0xa5, 0x1a,
	0x3d, 0x0b, 0x37, 0x3f, 0x28, 0x16, 0x4a, 0xd5, 0xea, 0x91, 0x56, 0x6f, 0xe4, 0x1b, 0x97, 0x1f,
	0x52, 0x6e, 0xc2, 0xb5, 0xd1, 0xe9, 0xe2, 0x49, 0xbe, 0x50, 0x29, 0x1e, 0xa4, 0x25, 0xb4, 0x03,
	0x2f, 0x4d, 0x9c, 0xd2, 0x0e, 0xab, 0xaa, 0x56, 0xaf, 0x54, 0x1b, 0xda, 0x61, 0xb9, 0x52, 0x29,
	0x9f, 0xdc, 0x4d, 0x87, 0x32, 0x9f, 0x4b, 0x80, 0x58, 0xd2, 0xf3, 0x14, 0x21, 0x2a, 0x7e, 0xd4,
	0xc3, 0x84, 0xa2, 0xeb, 0xb0, 0xec, 0x29, 0x2a, 0xec, 0x15, 0x23, 0xd6, 0x2e, 0x9a, 0xba, 0xd5,
	0xe9, 0xb1, 0x8e, 0xae, 0x65, 0xb7, 0x7d, 0xab, 0x92, 0x3e, 0x71, 0xdf, 0x6e, 0x63, 0x54, 0x81,
	0x84, 0x30, 0xfc, 0xc2, 0xc0, 0x8f, 0xf9, 0x51, 0x4b, 0xed, 0x7e, 0x61, 0xc6, 0xe3, 0x74, 0xdf,
	0xc0, 0x8f, 0x55, 0x30, 0x06, 0xdf, 0x6c, 0xcf, 0x3b, 0x4c, 0x1c, 0xdb, 0xcc, 0xe2, 0xa5, 0x2b,
	0xc6, 0x08, 0x75, 0xe3, 0x63, 0xe6, 0x24, 0xe0, 0x93, 0xd4, 0x3e, 0xc7, 0x96, 0x78, 0xa5, 0xe1,
	0xec, 0x0d, 0x46, 0xc8, 0x7c, 0x4f, 0x82, 0x8d, 0x11, 0xeb, 0x44, 0x57, 0x97, 0x87, 0x15, 0x4f,
	0x82, 0x9f, 0xdc, 0x5e, 0x9e, 0x51, 0x3b, 0xd5, 0x5f, 0x87, 0x5e, 0x82, 0x35, 0x8b, 0x35, 0x86,
	0x01, 0xf1, 0x9e, 0x2f, 0x56, 0x19, 0xb9, 0x36, 0x50, 0xe1, 0x67, 0x12, 0xa4, 0xef, 0x62, 0xa1,
	0x81, 0xef, 0xde, 0x49, 0x8f, 0x5b, 0xff, 0x7d, 0xd7, 0x66, 0xfe, 0x22, 0xc1, 0xc6, 0xbe, 0x8b,
	0x75, 0x8a, 0x47, 0xd5, 0x7b, 0x52, 0xf4, 0xdf, 0x87, 0x65, 0x6f, 0xb5, 0xe8, 0x7b, 0x66, 0xf6,
	0x9a, 0x58, 0x36, 0x6e, 0x63, 0x78, 0xba, 0x8d, 0x91, 0xab, 0xd9, 0xf8, 0xc3, 0x10, 0x6c, 0x9c,
	0x3a, 0xed, 0x31, 0x1b, 0x87, 0xb6, 0x48, 0x4f, 0xc9, 0x96, 0x49, 0xf1, 0xba, 0x03, 0x89, 0x1e,
	0x17, 0xce, 0x7f, 0x30, 0x13, 0x0f, 0x64, 0xca, 0xd8, 0xab, 0xd3, 0xa1, 0x81, 0xcd, 0xf6, 0xb1,
	0x4e, 0xce, 0x55, 0xf0, 0xd8, 0xd9, 0xf7, 0x53, 0x76, 0xc4, 0x2b, 0xb0, 0x71, 0x80, 0x4d, 0x7c,
	0xd9, 0x0f, 0x13, 0xb6, 0x62, 0xe6, 0x9f, 0x21, 0xb8, 0x59, 0xd0, 0x69, 0xeb, 0x61, 0xd0, 0x71,
	0x53, 0x73, 0xc3, 0x0e, 0xa4, 0x85, 0xba, 0x4d, 0xb6, 0x56, 0x1b, 0xf4, 0x6f, 0xa5, 0x25, 0x35,
	0xe5, 0xcd, 0x78, 0xa0, 0xae, 0x81, 0xbe, 0x09, 0x1b, 0x23, 0xbc, 0x86, 0x65, 0x1a, 0x16, 0x16,
	0xfe, 0x79, 0x75, 0x46, 0x13, 0x39, 0x5a, 0x69, 0x49, 0x5d, 0x0f, 0x80, 0x97, 0x39, 0xd0, 0x78,
	0x70, 0x22, 0xd3, 0x83, 0x13, 0xbd, 0x4a, 0x70, 0x96, 0xaf, 0x14, 0x9c, 0x42, 0x0a, 0x92, 0x41,
	0x7f, 0x64, 0x34, 0x50, 0x26, 0x05, 0xe0, 0xa9, 0xa5, 0xaf, 0xcc, 0x85, 0x88, 0x70, 0x70, 0x4b,
	0x4c, 0x8d, 0x70, 0x40, 0x6e, 0x68, 0x41, 0xb9, 0x35, 0x48, 0x04, 0x82, 0xf7, 0x14, 0x2c, 0xd9,
	0x79, 0x1f, 0xa0, 0x1c, 0xac, 0x16, 0x37, 0xca, 0x27, 0x8d, 0xe2, 0x49, 0x43, 0xbb, 0x5f, 0x2e,
	0x7e, 0x70, 0xa9, 0x66, 0x6e, 0x42, 0x3a, 0x38, 0x79, 0x78, 0x5a, 0xa9, 0xa4, 0xa5, 0xdd, 0xcf,
	0xe2, 0xb0, 0x22, 0x1c, 0x80, 0x7e, 0x2b, 0x41, 0x22, 0x50, 0x30, 0xd0, 0xeb, 0x53, 0xd5, 0x19,
	0x2f, 0x9e, 0xca, 0x1b, 0xf3, 0x2d, 0xf2, 0x82, 0x9a, 0xd9, 0xfd, 0xfe, 0x9f, 0xfe, 0xfa, 0xd3,
	0xd0, 0xab, 0x68, 0x67, 0xf0, 0x53, 0xfe, 0xb7, 0x3d, 0xb7, 0xbf, 0xeb, 0xb8, 0xf6, 0xb7, 0x70,
	0x8b, 0x92, 0xdc, 0x4e, 0x4e, 0xef, 0x60, 0x8b, 0x7e, 0x92, 0xf3, 0x8b, 0xd0, 0x2f, 0x24, 0x88,
	0x0f, 0x8a, 0x0b, 0x9a, 0xfe, 0x93, 0xe6, 0xe5, 0x42, 0xa4, 0xcc, 0xea, 0xee, 0x49, 0xda, 0xb1,
	0x54, 0x31, 0xa6, 0x9b, 0xaf, 0x5a, 0x6e, 0xe7, 0x13, 0xf4, 0xa9, 0x04, 0xc9, 0x60, 0x79, 0x41,
	0xd3, 0x1d, 0x33, 0xa1, 0x1a, 0xcd, 0xae, 0xe3, 0x1e, 0xd7, 0xf1, 0x8d, 0xcc, 0x1c, 0x1e, 0xdc,
	0xf3, 0xb3, 0xf9, 0xef, 0x24, 0x48, 0x06, 0x0f, 0xdb, 0x0c, 0xba, 0x4e, 0xa8, 0x2a, 0xb3, 0xeb,
	0x9a, 0xe7, 0xba, 0xde, 0xd9, 0xbd, 0x3d, 0xd4, 0x55, 0xfc, 0x4d, 0x64, 0x9a, 0x5b, 0x07, 0x2a,
	0xff, 0x44, 0x82, 0x64, 0xf0, 0xf8, 0xce, 0xa0, 0xf2, 0x84, 0x02, 0xa0, 0x5c, 0x1f, 0x4b, 0x78,
	0xc5, 0xae, 0x43, 0xfb, 0x7e, 0xc4, 0x77, 0xe6, 0x89, 0xf8, 0x67, 0x12, 0xa0, 0xf1, 0xbc, 0x85,
	0xa6, 0xbf, 0x2a, 0x3c, 0xb1, 0xda, 0x28, 0xcf, 0xfa, 0x6b, 0x03, 0x7f, 0x61, 0xc9, 0x56, 0xfd,
	0xbf, 0xb0, 0xf8, 0x7e, 0xcc, 0xbc, 0x39, 0x47, 0xcc, 0x9b, 0x43, 0x61, 0x7b, 0xd2, 0xce, 0x50,
	0xe9, 0x91, 0x5c, 0x38, 0xab, 0xd2, 0x93, 0x12, 0xe8, 0x7f, 0x4c, 0x69, 0x4f, 0xd8, 0x9e, 0xb4,
	0x53, 0xf8, 0x54, 0x82, 0x17, 0x5a, 0x76, 0x77, 0x9a, 0x8e, 0x05, 0x91, 0x6d, 0x6b, 0x2c, 0xb6,
	0x35, 0xe9, 0xc3, 0xb2, 0xe0, 0xef, 0xd8, 0xac, 0x12, 0x66, 0x6d, 0xb7, 0x93, 0xeb, 0x60, 0x8b,
	0x47, 0x3e, 0xe7, 0x4d, 0xe9, 0x8e, 0x41, 0x9e, 0xf8, 0xef, 0xa2, 0x3b, 0x43, 0xd2, 0x3f, 0x24,
	0xe9, 0x57, 0xa1, 0xd0, 0xc1, 0xe1, 0x6f, 0x42, 0xcf, 0xdd, 0xf5, 0x30, 0xf7, 0xb9, 0x0e, 0x07,
	0x43, 0x1d, 0xee, 0x7b, 0x8b, 0x9a, 0xcb, 0x1c, 0xff, 0xf5, 0x7f, 0x05, 0x00, 0x00, 0xff, 0xff,
	0xb3, 0x5d, 0x82, 0x52, 0x29, 0x25, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// IntentsClient is the client API for Intents service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type IntentsClient interface {
	// Returns the list of all intents in the specified agent.
	ListIntents(ctx context.Context, in *ListIntentsRequest, opts ...grpc.CallOption) (*ListIntentsResponse, error)
	// Retrieves the specified intent.
	GetIntent(ctx context.Context, in *GetIntentRequest, opts ...grpc.CallOption) (*Intent, error)
	// Creates an intent in the specified agent.
	CreateIntent(ctx context.Context, in *CreateIntentRequest, opts ...grpc.CallOption) (*Intent, error)
	// Updates the specified intent.
	UpdateIntent(ctx context.Context, in *UpdateIntentRequest, opts ...grpc.CallOption) (*Intent, error)
	// Deletes the specified intent.
	DeleteIntent(ctx context.Context, in *DeleteIntentRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Updates/Creates multiple intents in the specified agent.
	//
	// Operation <response: [BatchUpdateIntentsResponse][google.cloud.dialogflow.v2beta1.BatchUpdateIntentsResponse]>
	BatchUpdateIntents(ctx context.Context, in *BatchUpdateIntentsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Deletes intents in the specified agent.
	//
	// Operation <response: [google.protobuf.Empty][google.protobuf.Empty]>
	BatchDeleteIntents(ctx context.Context, in *BatchDeleteIntentsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type intentsClient struct {
	cc *grpc.ClientConn
}

func NewIntentsClient(cc *grpc.ClientConn) IntentsClient {
	return &intentsClient{cc}
}

func (c *intentsClient) ListIntents(ctx context.Context, in *ListIntentsRequest, opts ...grpc.CallOption) (*ListIntentsResponse, error) {
	out := new(ListIntentsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.Intents/ListIntents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *intentsClient) GetIntent(ctx context.Context, in *GetIntentRequest, opts ...grpc.CallOption) (*Intent, error) {
	out := new(Intent)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.Intents/GetIntent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *intentsClient) CreateIntent(ctx context.Context, in *CreateIntentRequest, opts ...grpc.CallOption) (*Intent, error) {
	out := new(Intent)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.Intents/CreateIntent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *intentsClient) UpdateIntent(ctx context.Context, in *UpdateIntentRequest, opts ...grpc.CallOption) (*Intent, error) {
	out := new(Intent)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.Intents/UpdateIntent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *intentsClient) DeleteIntent(ctx context.Context, in *DeleteIntentRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.Intents/DeleteIntent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *intentsClient) BatchUpdateIntents(ctx context.Context, in *BatchUpdateIntentsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.Intents/BatchUpdateIntents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *intentsClient) BatchDeleteIntents(ctx context.Context, in *BatchDeleteIntentsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.dialogflow.v2beta1.Intents/BatchDeleteIntents", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// IntentsServer is the server API for Intents service.
type IntentsServer interface {
	// Returns the list of all intents in the specified agent.
	ListIntents(context.Context, *ListIntentsRequest) (*ListIntentsResponse, error)
	// Retrieves the specified intent.
	GetIntent(context.Context, *GetIntentRequest) (*Intent, error)
	// Creates an intent in the specified agent.
	CreateIntent(context.Context, *CreateIntentRequest) (*Intent, error)
	// Updates the specified intent.
	UpdateIntent(context.Context, *UpdateIntentRequest) (*Intent, error)
	// Deletes the specified intent.
	DeleteIntent(context.Context, *DeleteIntentRequest) (*empty.Empty, error)
	// Updates/Creates multiple intents in the specified agent.
	//
	// Operation <response: [BatchUpdateIntentsResponse][google.cloud.dialogflow.v2beta1.BatchUpdateIntentsResponse]>
	BatchUpdateIntents(context.Context, *BatchUpdateIntentsRequest) (*longrunning.Operation, error)
	// Deletes intents in the specified agent.
	//
	// Operation <response: [google.protobuf.Empty][google.protobuf.Empty]>
	BatchDeleteIntents(context.Context, *BatchDeleteIntentsRequest) (*longrunning.Operation, error)
}

func RegisterIntentsServer(s *grpc.Server, srv IntentsServer) {
	s.RegisterService(&_Intents_serviceDesc, srv)
}

func _Intents_ListIntents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListIntentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IntentsServer).ListIntents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.Intents/ListIntents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IntentsServer).ListIntents(ctx, req.(*ListIntentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Intents_GetIntent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIntentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IntentsServer).GetIntent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.Intents/GetIntent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IntentsServer).GetIntent(ctx, req.(*GetIntentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Intents_CreateIntent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateIntentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IntentsServer).CreateIntent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.Intents/CreateIntent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IntentsServer).CreateIntent(ctx, req.(*CreateIntentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Intents_UpdateIntent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateIntentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IntentsServer).UpdateIntent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.Intents/UpdateIntent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IntentsServer).UpdateIntent(ctx, req.(*UpdateIntentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Intents_DeleteIntent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteIntentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IntentsServer).DeleteIntent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.Intents/DeleteIntent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IntentsServer).DeleteIntent(ctx, req.(*DeleteIntentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Intents_BatchUpdateIntents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchUpdateIntentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IntentsServer).BatchUpdateIntents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.Intents/BatchUpdateIntents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IntentsServer).BatchUpdateIntents(ctx, req.(*BatchUpdateIntentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Intents_BatchDeleteIntents_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchDeleteIntentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(IntentsServer).BatchDeleteIntents(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.dialogflow.v2beta1.Intents/BatchDeleteIntents",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(IntentsServer).BatchDeleteIntents(ctx, req.(*BatchDeleteIntentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Intents_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.dialogflow.v2beta1.Intents",
	HandlerType: (*IntentsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListIntents",
			Handler:    _Intents_ListIntents_Handler,
		},
		{
			MethodName: "GetIntent",
			Handler:    _Intents_GetIntent_Handler,
		},
		{
			MethodName: "CreateIntent",
			Handler:    _Intents_CreateIntent_Handler,
		},
		{
			MethodName: "UpdateIntent",
			Handler:    _Intents_UpdateIntent_Handler,
		},
		{
			MethodName: "DeleteIntent",
			Handler:    _Intents_DeleteIntent_Handler,
		},
		{
			MethodName: "BatchUpdateIntents",
			Handler:    _Intents_BatchUpdateIntents_Handler,
		},
		{
			MethodName: "BatchDeleteIntents",
			Handler:    _Intents_BatchDeleteIntents_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/dialogflow/v2beta1/intent.proto",
}
