// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/speech/v1/cloud_speech.proto

package speech

import (
	fmt "fmt"
	proto "github.com/golang/protobuf/proto"
	_ "github.com/golang/protobuf/ptypes/any"
	duration "github.com/golang/protobuf/ptypes/duration"
	_ "github.com/golang/protobuf/ptypes/empty"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	context "golang.org/x/net/context"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	math "math"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// The encoding of the audio data sent in the request.
//
// All encodings support only 1 channel (mono) audio.
//
// For best results, the audio source should be captured and transmitted using
// a lossless encoding (`FLAC` or `LINEAR16`). The accuracy of the speech
// recognition can be reduced if lossy codecs are used to capture or transmit
// audio, particularly if background noise is present. Lossy codecs include
// `MULAW`, `AMR`, `AMR_WB`, `OGG_OPUS`, and `SPEEX_WITH_HEADER_BYTE`.
//
// The `FLAC` and `WAV` audio file formats include a header that describes the
// included audio content. You can request recognition for `WAV` files that
// contain either `LINEAR16` or `MULAW` encoded audio.
// If you send `FLAC` or `WAV` audio file format in
// your request, you do not need to specify an `AudioEncoding`; the audio
// encoding format is determined from the file header. If you specify
// an `AudioEncoding` when you send  send `FLAC` or `WAV` audio, the
// encoding configuration must match the encoding described in the audio
// header; otherwise the request returns an
// [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT] error code.
type RecognitionConfig_AudioEncoding int32

const (
	// Not specified.
	RecognitionConfig_ENCODING_UNSPECIFIED RecognitionConfig_AudioEncoding = 0
	// Uncompressed 16-bit signed little-endian samples (Linear PCM).
	RecognitionConfig_LINEAR16 RecognitionConfig_AudioEncoding = 1
	// `FLAC` (Free Lossless Audio
	// Codec) is the recommended encoding because it is
	// lossless--therefore recognition is not compromised--and
	// requires only about half the bandwidth of `LINEAR16`. `FLAC` stream
	// encoding supports 16-bit and 24-bit samples, however, not all fields in
	// `STREAMINFO` are supported.
	RecognitionConfig_FLAC RecognitionConfig_AudioEncoding = 2
	// 8-bit samples that compand 14-bit audio samples using G.711 PCMU/mu-law.
	RecognitionConfig_MULAW RecognitionConfig_AudioEncoding = 3
	// Adaptive Multi-Rate Narrowband codec. `sample_rate_hertz` must be 8000.
	RecognitionConfig_AMR RecognitionConfig_AudioEncoding = 4
	// Adaptive Multi-Rate Wideband codec. `sample_rate_hertz` must be 16000.
	RecognitionConfig_AMR_WB RecognitionConfig_AudioEncoding = 5
	// Opus encoded audio frames in Ogg container
	// ([OggOpus](https://wiki.xiph.org/OggOpus)).
	// `sample_rate_hertz` must be one of 8000, 12000, 16000, 24000, or 48000.
	RecognitionConfig_OGG_OPUS RecognitionConfig_AudioEncoding = 6
	// Although the use of lossy encodings is not recommended, if a very low
	// bitrate encoding is required, `OGG_OPUS` is highly preferred over
	// Speex encoding. The [Speex](https://speex.org/)  encoding supported by
	// Cloud Speech API has a header byte in each block, as in MIME type
	// `audio/x-speex-with-header-byte`.
	// It is a variant of the RTP Speex encoding defined in
	// [RFC 5574](https://tools.ietf.org/html/rfc5574).
	// The stream is a sequence of blocks, one block per RTP packet. Each block
	// starts with a byte containing the length of the block, in bytes, followed
	// by one or more frames of Speex data, padded to an integral number of
	// bytes (octets) as specified in RFC 5574. In other words, each RTP header
	// is replaced with a single byte containing the block length. Only Speex
	// wideband is supported. `sample_rate_hertz` must be 16000.
	RecognitionConfig_SPEEX_WITH_HEADER_BYTE RecognitionConfig_AudioEncoding = 7
)

var RecognitionConfig_AudioEncoding_name = map[int32]string{
	0: "ENCODING_UNSPECIFIED",
	1: "LINEAR16",
	2: "FLAC",
	3: "MULAW",
	4: "AMR",
	5: "AMR_WB",
	6: "OGG_OPUS",
	7: "SPEEX_WITH_HEADER_BYTE",
}

var RecognitionConfig_AudioEncoding_value = map[string]int32{
	"ENCODING_UNSPECIFIED":   0,
	"LINEAR16":               1,
	"FLAC":                   2,
	"MULAW":                  3,
	"AMR":                    4,
	"AMR_WB":                 5,
	"OGG_OPUS":               6,
	"SPEEX_WITH_HEADER_BYTE": 7,
}

func (x RecognitionConfig_AudioEncoding) String() string {
	return proto.EnumName(RecognitionConfig_AudioEncoding_name, int32(x))
}

func (RecognitionConfig_AudioEncoding) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_06c282b85cb237e9, []int{4, 0}
}

// Indicates the type of speech event.
type StreamingRecognizeResponse_SpeechEventType int32

const (
	// No speech event specified.
	StreamingRecognizeResponse_SPEECH_EVENT_UNSPECIFIED StreamingRecognizeResponse_SpeechEventType = 0
	// This event indicates that the server has detected the end of the user's
	// speech utterance and expects no additional speech. Therefore, the server
	// will not process additional audio (although it may subsequently return
	// additional results). The client should stop sending additional audio
	// data, half-close the gRPC connection, and wait for any additional results
	// until the server closes the gRPC connection. This event is only sent if
	// `single_utterance` was set to `true`, and is not used otherwise.
	StreamingRecognizeResponse_END_OF_SINGLE_UTTERANCE StreamingRecognizeResponse_SpeechEventType = 1
)

var StreamingRecognizeResponse_SpeechEventType_name = map[int32]string{
	0: "SPEECH_EVENT_UNSPECIFIED",
	1: "END_OF_SINGLE_UTTERANCE",
}

var StreamingRecognizeResponse_SpeechEventType_value = map[string]int32{
	"SPEECH_EVENT_UNSPECIFIED": 0,
	"END_OF_SINGLE_UTTERANCE":  1,
}

func (x StreamingRecognizeResponse_SpeechEventType) String() string {
	return proto.EnumName(StreamingRecognizeResponse_SpeechEventType_name, int32(x))
}

func (StreamingRecognizeResponse_SpeechEventType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_06c282b85cb237e9, []int{10, 0}
}

// The top-level message sent by the client for the `Recognize` method.
type RecognizeRequest struct {
	// *Required* Provides information to the recognizer that specifies how to
	// process the request.
	Config *RecognitionConfig `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// *Required* The audio data to be recognized.
	Audio                *RecognitionAudio `protobuf:"bytes,2,opt,name=audio,proto3" json:"audio,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *RecognizeRequest) Reset()         { *m = RecognizeRequest{} }
func (m *RecognizeRequest) String() string { return proto.CompactTextString(m) }
func (*RecognizeRequest) ProtoMessage()    {}
func (*RecognizeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_06c282b85cb237e9, []int{0}
}

func (m *RecognizeRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RecognizeRequest.Unmarshal(m, b)
}
func (m *RecognizeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RecognizeRequest.Marshal(b, m, deterministic)
}
func (m *RecognizeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RecognizeRequest.Merge(m, src)
}
func (m *RecognizeRequest) XXX_Size() int {
	return xxx_messageInfo_RecognizeRequest.Size(m)
}
func (m *RecognizeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RecognizeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RecognizeRequest proto.InternalMessageInfo

func (m *RecognizeRequest) GetConfig() *RecognitionConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *RecognizeRequest) GetAudio() *RecognitionAudio {
	if m != nil {
		return m.Audio
	}
	return nil
}

// The top-level message sent by the client for the `LongRunningRecognize`
// method.
type LongRunningRecognizeRequest struct {
	// *Required* Provides information to the recognizer that specifies how to
	// process the request.
	Config *RecognitionConfig `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// *Required* The audio data to be recognized.
	Audio                *RecognitionAudio `protobuf:"bytes,2,opt,name=audio,proto3" json:"audio,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *LongRunningRecognizeRequest) Reset()         { *m = LongRunningRecognizeRequest{} }
func (m *LongRunningRecognizeRequest) String() string { return proto.CompactTextString(m) }
func (*LongRunningRecognizeRequest) ProtoMessage()    {}
func (*LongRunningRecognizeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_06c282b85cb237e9, []int{1}
}

func (m *LongRunningRecognizeRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LongRunningRecognizeRequest.Unmarshal(m, b)
}
func (m *LongRunningRecognizeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LongRunningRecognizeRequest.Marshal(b, m, deterministic)
}
func (m *LongRunningRecognizeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LongRunningRecognizeRequest.Merge(m, src)
}
func (m *LongRunningRecognizeRequest) XXX_Size() int {
	return xxx_messageInfo_LongRunningRecognizeRequest.Size(m)
}
func (m *LongRunningRecognizeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_LongRunningRecognizeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_LongRunningRecognizeRequest proto.InternalMessageInfo

func (m *LongRunningRecognizeRequest) GetConfig() *RecognitionConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *LongRunningRecognizeRequest) GetAudio() *RecognitionAudio {
	if m != nil {
		return m.Audio
	}
	return nil
}

// The top-level message sent by the client for the `StreamingRecognize` method.
// Multiple `StreamingRecognizeRequest` messages are sent. The first message
// must contain a `streaming_config` message and must not contain `audio` data.
// All subsequent messages must contain `audio` data and must not contain a
// `streaming_config` message.
type StreamingRecognizeRequest struct {
	// The streaming request, which is either a streaming config or audio content.
	//
	// Types that are valid to be assigned to StreamingRequest:
	//	*StreamingRecognizeRequest_StreamingConfig
	//	*StreamingRecognizeRequest_AudioContent
	StreamingRequest     isStreamingRecognizeRequest_StreamingRequest `protobuf_oneof:"streaming_request"`
	XXX_NoUnkeyedLiteral struct{}                                     `json:"-"`
	XXX_unrecognized     []byte                                       `json:"-"`
	XXX_sizecache        int32                                        `json:"-"`
}

func (m *StreamingRecognizeRequest) Reset()         { *m = StreamingRecognizeRequest{} }
func (m *StreamingRecognizeRequest) String() string { return proto.CompactTextString(m) }
func (*StreamingRecognizeRequest) ProtoMessage()    {}
func (*StreamingRecognizeRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_06c282b85cb237e9, []int{2}
}

func (m *StreamingRecognizeRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingRecognizeRequest.Unmarshal(m, b)
}
func (m *StreamingRecognizeRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingRecognizeRequest.Marshal(b, m, deterministic)
}
func (m *StreamingRecognizeRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingRecognizeRequest.Merge(m, src)
}
func (m *StreamingRecognizeRequest) XXX_Size() int {
	return xxx_messageInfo_StreamingRecognizeRequest.Size(m)
}
func (m *StreamingRecognizeRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingRecognizeRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingRecognizeRequest proto.InternalMessageInfo

type isStreamingRecognizeRequest_StreamingRequest interface {
	isStreamingRecognizeRequest_StreamingRequest()
}

type StreamingRecognizeRequest_StreamingConfig struct {
	StreamingConfig *StreamingRecognitionConfig `protobuf:"bytes,1,opt,name=streaming_config,json=streamingConfig,proto3,oneof"`
}

type StreamingRecognizeRequest_AudioContent struct {
	AudioContent []byte `protobuf:"bytes,2,opt,name=audio_content,json=audioContent,proto3,oneof"`
}

func (*StreamingRecognizeRequest_StreamingConfig) isStreamingRecognizeRequest_StreamingRequest() {}

func (*StreamingRecognizeRequest_AudioContent) isStreamingRecognizeRequest_StreamingRequest() {}

func (m *StreamingRecognizeRequest) GetStreamingRequest() isStreamingRecognizeRequest_StreamingRequest {
	if m != nil {
		return m.StreamingRequest
	}
	return nil
}

func (m *StreamingRecognizeRequest) GetStreamingConfig() *StreamingRecognitionConfig {
	if x, ok := m.GetStreamingRequest().(*StreamingRecognizeRequest_StreamingConfig); ok {
		return x.StreamingConfig
	}
	return nil
}

func (m *StreamingRecognizeRequest) GetAudioContent() []byte {
	if x, ok := m.GetStreamingRequest().(*StreamingRecognizeRequest_AudioContent); ok {
		return x.AudioContent
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*StreamingRecognizeRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _StreamingRecognizeRequest_OneofMarshaler, _StreamingRecognizeRequest_OneofUnmarshaler, _StreamingRecognizeRequest_OneofSizer, []interface{}{
		(*StreamingRecognizeRequest_StreamingConfig)(nil),
		(*StreamingRecognizeRequest_AudioContent)(nil),
	}
}

func _StreamingRecognizeRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*StreamingRecognizeRequest)
	// streaming_request
	switch x := m.StreamingRequest.(type) {
	case *StreamingRecognizeRequest_StreamingConfig:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.StreamingConfig); err != nil {
			return err
		}
	case *StreamingRecognizeRequest_AudioContent:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.AudioContent)
	case nil:
	default:
		return fmt.Errorf("StreamingRecognizeRequest.StreamingRequest has unexpected type %T", x)
	}
	return nil
}

func _StreamingRecognizeRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*StreamingRecognizeRequest)
	switch tag {
	case 1: // streaming_request.streaming_config
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StreamingRecognitionConfig)
		err := b.DecodeMessage(msg)
		m.StreamingRequest = &StreamingRecognizeRequest_StreamingConfig{msg}
		return true, err
	case 2: // streaming_request.audio_content
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.StreamingRequest = &StreamingRecognizeRequest_AudioContent{x}
		return true, err
	default:
		return false, nil
	}
}

func _StreamingRecognizeRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*StreamingRecognizeRequest)
	// streaming_request
	switch x := m.StreamingRequest.(type) {
	case *StreamingRecognizeRequest_StreamingConfig:
		s := proto.Size(x.StreamingConfig)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StreamingRecognizeRequest_AudioContent:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.AudioContent)))
		n += len(x.AudioContent)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Provides information to the recognizer that specifies how to process the
// request.
type StreamingRecognitionConfig struct {
	// *Required* Provides information to the recognizer that specifies how to
	// process the request.
	Config *RecognitionConfig `protobuf:"bytes,1,opt,name=config,proto3" json:"config,omitempty"`
	// *Optional* If `false` or omitted, the recognizer will perform continuous
	// recognition (continuing to wait for and process audio even if the user
	// pauses speaking) until the client closes the input stream (gRPC API) or
	// until the maximum time limit has been reached. May return multiple
	// `StreamingRecognitionResult`s with the `is_final` flag set to `true`.
	//
	// If `true`, the recognizer will detect a single spoken utterance. When it
	// detects that the user has paused or stopped speaking, it will return an
	// `END_OF_SINGLE_UTTERANCE` event and cease recognition. It will return no
	// more than one `StreamingRecognitionResult` with the `is_final` flag set to
	// `true`.
	SingleUtterance bool `protobuf:"varint,2,opt,name=single_utterance,json=singleUtterance,proto3" json:"single_utterance,omitempty"`
	// *Optional* If `true`, interim results (tentative hypotheses) may be
	// returned as they become available (these interim results are indicated with
	// the `is_final=false` flag).
	// If `false` or omitted, only `is_final=true` result(s) are returned.
	InterimResults       bool     `protobuf:"varint,3,opt,name=interim_results,json=interimResults,proto3" json:"interim_results,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamingRecognitionConfig) Reset()         { *m = StreamingRecognitionConfig{} }
func (m *StreamingRecognitionConfig) String() string { return proto.CompactTextString(m) }
func (*StreamingRecognitionConfig) ProtoMessage()    {}
func (*StreamingRecognitionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_06c282b85cb237e9, []int{3}
}

func (m *StreamingRecognitionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingRecognitionConfig.Unmarshal(m, b)
}
func (m *StreamingRecognitionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingRecognitionConfig.Marshal(b, m, deterministic)
}
func (m *StreamingRecognitionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingRecognitionConfig.Merge(m, src)
}
func (m *StreamingRecognitionConfig) XXX_Size() int {
	return xxx_messageInfo_StreamingRecognitionConfig.Size(m)
}
func (m *StreamingRecognitionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingRecognitionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingRecognitionConfig proto.InternalMessageInfo

func (m *StreamingRecognitionConfig) GetConfig() *RecognitionConfig {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *StreamingRecognitionConfig) GetSingleUtterance() bool {
	if m != nil {
		return m.SingleUtterance
	}
	return false
}

func (m *StreamingRecognitionConfig) GetInterimResults() bool {
	if m != nil {
		return m.InterimResults
	}
	return false
}

// Provides information to the recognizer that specifies how to process the
// request.
type RecognitionConfig struct {
	// Encoding of audio data sent in all `RecognitionAudio` messages.
	// This field is optional for `FLAC` and `WAV` audio files and required
	// for all other audio formats. For details, see [AudioEncoding][google.cloud.speech.v1.RecognitionConfig.AudioEncoding].
	Encoding RecognitionConfig_AudioEncoding `protobuf:"varint,1,opt,name=encoding,proto3,enum=google.cloud.speech.v1.RecognitionConfig_AudioEncoding" json:"encoding,omitempty"`
	// Sample rate in Hertz of the audio data sent in all
	// `RecognitionAudio` messages. Valid values are: 8000-48000.
	// 16000 is optimal. For best results, set the sampling rate of the audio
	// source to 16000 Hz. If that's not possible, use the native sample rate of
	// the audio source (instead of re-sampling).
	// This field is optional for `FLAC` and `WAV` audio files and required
	// for all other audio formats. For details, see [AudioEncoding][google.cloud.speech.v1.RecognitionConfig.AudioEncoding].
	SampleRateHertz int32 `protobuf:"varint,2,opt,name=sample_rate_hertz,json=sampleRateHertz,proto3" json:"sample_rate_hertz,omitempty"`
	// *Required* The language of the supplied audio as a
	// [BCP-47](https://www.rfc-editor.org/rfc/bcp/bcp47.txt) language tag.
	// Example: "en-US".
	// See [Language Support](/speech-to-text/docs/languages)
	// for a list of the currently supported language codes.
	LanguageCode string `protobuf:"bytes,3,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// *Optional* Maximum number of recognition hypotheses to be returned.
	// Specifically, the maximum number of `SpeechRecognitionAlternative` messages
	// within each `SpeechRecognitionResult`.
	// The server may return fewer than `max_alternatives`.
	// Valid values are `0`-`30`. A value of `0` or `1` will return a maximum of
	// one. If omitted, will return a maximum of one.
	MaxAlternatives int32 `protobuf:"varint,4,opt,name=max_alternatives,json=maxAlternatives,proto3" json:"max_alternatives,omitempty"`
	// *Optional* If set to `true`, the server will attempt to filter out
	// profanities, replacing all but the initial character in each filtered word
	// with asterisks, e.g. "f***". If set to `false` or omitted, profanities
	// won't be filtered out.
	ProfanityFilter bool `protobuf:"varint,5,opt,name=profanity_filter,json=profanityFilter,proto3" json:"profanity_filter,omitempty"`
	// *Optional* array of [SpeechContext][google.cloud.speech.v1.SpeechContext].
	// A means to provide context to assist the speech recognition. For more
	// information, see [Phrase Hints](/speech-to-text/docs/basics#phrase-hints).
	SpeechContexts []*SpeechContext `protobuf:"bytes,6,rep,name=speech_contexts,json=speechContexts,proto3" json:"speech_contexts,omitempty"`
	// *Optional* If `true`, the top result includes a list of words and
	// the start and end time offsets (timestamps) for those words. If
	// `false`, no word-level time offset information is returned. The default is
	// `false`.
	EnableWordTimeOffsets bool `protobuf:"varint,8,opt,name=enable_word_time_offsets,json=enableWordTimeOffsets,proto3" json:"enable_word_time_offsets,omitempty"`
	// *Optional* If 'true', adds punctuation to recognition result hypotheses.
	// This feature is only available in select languages. Setting this for
	// requests in other languages has no effect at all.
	// The default 'false' value does not add punctuation to result hypotheses.
	// Note: This is currently offered as an experimental service, complimentary
	// to all users. In the future this may be exclusively available as a
	// premium feature.
	EnableAutomaticPunctuation bool `protobuf:"varint,11,opt,name=enable_automatic_punctuation,json=enableAutomaticPunctuation,proto3" json:"enable_automatic_punctuation,omitempty"`
	// *Optional* Which model to select for the given request. Select the model
	// best suited to your domain to get best results. If a model is not
	// explicitly specified, then we auto-select a model based on the parameters
	// in the RecognitionConfig.
	// <table>
	//   <tr>
	//     <td><b>Model</b></td>
	//     <td><b>Description</b></td>
	//   </tr>
	//   <tr>
	//     <td><code>command_and_search</code></td>
	//     <td>Best for short queries such as voice commands or voice search.</td>
	//   </tr>
	//   <tr>
	//     <td><code>phone_call</code></td>
	//     <td>Best for audio that originated from a phone call (typically
	//     recorded at an 8khz sampling rate).</td>
	//   </tr>
	//   <tr>
	//     <td><code>video</code></td>
	//     <td>Best for audio that originated from from video or includes multiple
	//         speakers. Ideally the audio is recorded at a 16khz or greater
	//         sampling rate. This is a premium model that costs more than the
	//         standard rate.</td>
	//   </tr>
	//   <tr>
	//     <td><code>default</code></td>
	//     <td>Best for audio that is not one of the specific audio models.
	//         For example, long-form audio. Ideally the audio is high-fidelity,
	//         recorded at a 16khz or greater sampling rate.</td>
	//   </tr>
	// </table>
	Model string `protobuf:"bytes,13,opt,name=model,proto3" json:"model,omitempty"`
	// *Optional* Set to true to use an enhanced model for speech recognition.
	// You must also set the `model` field to a valid, enhanced model. If
	// `use_enhanced` is set to true and the `model` field is not set, then
	// `use_enhanced` is ignored. If `use_enhanced` is true and an enhanced
	// version of the specified model does not exist, then the speech is
	// recognized using the standard version of the specified model.
	//
	// Enhanced speech models require that you opt-in to data logging using
	// instructions in the [documentation](/speech-to-text/enable-data-logging).
	// If you set `use_enhanced` to true and you have not enabled audio logging,
	// then you will receive an error.
	UseEnhanced          bool     `protobuf:"varint,14,opt,name=use_enhanced,json=useEnhanced,proto3" json:"use_enhanced,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RecognitionConfig) Reset()         { *m = RecognitionConfig{} }
func (m *RecognitionConfig) String() string { return proto.CompactTextString(m) }
func (*RecognitionConfig) ProtoMessage()    {}
func (*RecognitionConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_06c282b85cb237e9, []int{4}
}

func (m *RecognitionConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RecognitionConfig.Unmarshal(m, b)
}
func (m *RecognitionConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RecognitionConfig.Marshal(b, m, deterministic)
}
func (m *RecognitionConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RecognitionConfig.Merge(m, src)
}
func (m *RecognitionConfig) XXX_Size() int {
	return xxx_messageInfo_RecognitionConfig.Size(m)
}
func (m *RecognitionConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_RecognitionConfig.DiscardUnknown(m)
}

var xxx_messageInfo_RecognitionConfig proto.InternalMessageInfo

func (m *RecognitionConfig) GetEncoding() RecognitionConfig_AudioEncoding {
	if m != nil {
		return m.Encoding
	}
	return RecognitionConfig_ENCODING_UNSPECIFIED
}

func (m *RecognitionConfig) GetSampleRateHertz() int32 {
	if m != nil {
		return m.SampleRateHertz
	}
	return 0
}

func (m *RecognitionConfig) GetLanguageCode() string {
	if m != nil {
		return m.LanguageCode
	}
	return ""
}

func (m *RecognitionConfig) GetMaxAlternatives() int32 {
	if m != nil {
		return m.MaxAlternatives
	}
	return 0
}

func (m *RecognitionConfig) GetProfanityFilter() bool {
	if m != nil {
		return m.ProfanityFilter
	}
	return false
}

func (m *RecognitionConfig) GetSpeechContexts() []*SpeechContext {
	if m != nil {
		return m.SpeechContexts
	}
	return nil
}

func (m *RecognitionConfig) GetEnableWordTimeOffsets() bool {
	if m != nil {
		return m.EnableWordTimeOffsets
	}
	return false
}

func (m *RecognitionConfig) GetEnableAutomaticPunctuation() bool {
	if m != nil {
		return m.EnableAutomaticPunctuation
	}
	return false
}

func (m *RecognitionConfig) GetModel() string {
	if m != nil {
		return m.Model
	}
	return ""
}

func (m *RecognitionConfig) GetUseEnhanced() bool {
	if m != nil {
		return m.UseEnhanced
	}
	return false
}

// Provides "hints" to the speech recognizer to favor specific words and phrases
// in the results.
type SpeechContext struct {
	// *Optional* A list of strings containing words and phrases "hints" so that
	// the speech recognition is more likely to recognize them. This can be used
	// to improve the accuracy for specific words and phrases, for example, if
	// specific commands are typically spoken by the user. This can also be used
	// to add additional words to the vocabulary of the recognizer. See
	// [usage limits](/speech-to-text/quotas#content).
	Phrases              []string `protobuf:"bytes,1,rep,name=phrases,proto3" json:"phrases,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SpeechContext) Reset()         { *m = SpeechContext{} }
func (m *SpeechContext) String() string { return proto.CompactTextString(m) }
func (*SpeechContext) ProtoMessage()    {}
func (*SpeechContext) Descriptor() ([]byte, []int) {
	return fileDescriptor_06c282b85cb237e9, []int{5}
}

func (m *SpeechContext) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SpeechContext.Unmarshal(m, b)
}
func (m *SpeechContext) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SpeechContext.Marshal(b, m, deterministic)
}
func (m *SpeechContext) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SpeechContext.Merge(m, src)
}
func (m *SpeechContext) XXX_Size() int {
	return xxx_messageInfo_SpeechContext.Size(m)
}
func (m *SpeechContext) XXX_DiscardUnknown() {
	xxx_messageInfo_SpeechContext.DiscardUnknown(m)
}

var xxx_messageInfo_SpeechContext proto.InternalMessageInfo

func (m *SpeechContext) GetPhrases() []string {
	if m != nil {
		return m.Phrases
	}
	return nil
}

// Contains audio data in the encoding specified in the `RecognitionConfig`.
// Either `content` or `uri` must be supplied. Supplying both or neither
// returns [google.rpc.Code.INVALID_ARGUMENT][google.rpc.Code.INVALID_ARGUMENT]. See
// [content limits](/speech-to-text/quotas#content).
type RecognitionAudio struct {
	// The audio source, which is either inline content or a Google Cloud
	// Storage uri.
	//
	// Types that are valid to be assigned to AudioSource:
	//	*RecognitionAudio_Content
	//	*RecognitionAudio_Uri
	AudioSource          isRecognitionAudio_AudioSource `protobuf_oneof:"audio_source"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *RecognitionAudio) Reset()         { *m = RecognitionAudio{} }
func (m *RecognitionAudio) String() string { return proto.CompactTextString(m) }
func (*RecognitionAudio) ProtoMessage()    {}
func (*RecognitionAudio) Descriptor() ([]byte, []int) {
	return fileDescriptor_06c282b85cb237e9, []int{6}
}

func (m *RecognitionAudio) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RecognitionAudio.Unmarshal(m, b)
}
func (m *RecognitionAudio) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RecognitionAudio.Marshal(b, m, deterministic)
}
func (m *RecognitionAudio) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RecognitionAudio.Merge(m, src)
}
func (m *RecognitionAudio) XXX_Size() int {
	return xxx_messageInfo_RecognitionAudio.Size(m)
}
func (m *RecognitionAudio) XXX_DiscardUnknown() {
	xxx_messageInfo_RecognitionAudio.DiscardUnknown(m)
}

var xxx_messageInfo_RecognitionAudio proto.InternalMessageInfo

type isRecognitionAudio_AudioSource interface {
	isRecognitionAudio_AudioSource()
}

type RecognitionAudio_Content struct {
	Content []byte `protobuf:"bytes,1,opt,name=content,proto3,oneof"`
}

type RecognitionAudio_Uri struct {
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3,oneof"`
}

func (*RecognitionAudio_Content) isRecognitionAudio_AudioSource() {}

func (*RecognitionAudio_Uri) isRecognitionAudio_AudioSource() {}

func (m *RecognitionAudio) GetAudioSource() isRecognitionAudio_AudioSource {
	if m != nil {
		return m.AudioSource
	}
	return nil
}

func (m *RecognitionAudio) GetContent() []byte {
	if x, ok := m.GetAudioSource().(*RecognitionAudio_Content); ok {
		return x.Content
	}
	return nil
}

func (m *RecognitionAudio) GetUri() string {
	if x, ok := m.GetAudioSource().(*RecognitionAudio_Uri); ok {
		return x.Uri
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*RecognitionAudio) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _RecognitionAudio_OneofMarshaler, _RecognitionAudio_OneofUnmarshaler, _RecognitionAudio_OneofSizer, []interface{}{
		(*RecognitionAudio_Content)(nil),
		(*RecognitionAudio_Uri)(nil),
	}
}

func _RecognitionAudio_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*RecognitionAudio)
	// audio_source
	switch x := m.AudioSource.(type) {
	case *RecognitionAudio_Content:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.Content)
	case *RecognitionAudio_Uri:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.Uri)
	case nil:
	default:
		return fmt.Errorf("RecognitionAudio.AudioSource has unexpected type %T", x)
	}
	return nil
}

func _RecognitionAudio_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*RecognitionAudio)
	switch tag {
	case 1: // audio_source.content
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.AudioSource = &RecognitionAudio_Content{x}
		return true, err
	case 2: // audio_source.uri
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.AudioSource = &RecognitionAudio_Uri{x}
		return true, err
	default:
		return false, nil
	}
}

func _RecognitionAudio_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*RecognitionAudio)
	// audio_source
	switch x := m.AudioSource.(type) {
	case *RecognitionAudio_Content:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Content)))
		n += len(x.Content)
	case *RecognitionAudio_Uri:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Uri)))
		n += len(x.Uri)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// The only message returned to the client by the `Recognize` method. It
// contains the result as zero or more sequential `SpeechRecognitionResult`
// messages.
type RecognizeResponse struct {
	// Output only. Sequential list of transcription results corresponding to
	// sequential portions of audio.
	Results              []*SpeechRecognitionResult `protobuf:"bytes,2,rep,name=results,proto3" json:"results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *RecognizeResponse) Reset()         { *m = RecognizeResponse{} }
func (m *RecognizeResponse) String() string { return proto.CompactTextString(m) }
func (*RecognizeResponse) ProtoMessage()    {}
func (*RecognizeResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_06c282b85cb237e9, []int{7}
}

func (m *RecognizeResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RecognizeResponse.Unmarshal(m, b)
}
func (m *RecognizeResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RecognizeResponse.Marshal(b, m, deterministic)
}
func (m *RecognizeResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RecognizeResponse.Merge(m, src)
}
func (m *RecognizeResponse) XXX_Size() int {
	return xxx_messageInfo_RecognizeResponse.Size(m)
}
func (m *RecognizeResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_RecognizeResponse.DiscardUnknown(m)
}

var xxx_messageInfo_RecognizeResponse proto.InternalMessageInfo

func (m *RecognizeResponse) GetResults() []*SpeechRecognitionResult {
	if m != nil {
		return m.Results
	}
	return nil
}

// The only message returned to the client by the `LongRunningRecognize` method.
// It contains the result as zero or more sequential `SpeechRecognitionResult`
// messages. It is included in the `result.response` field of the `Operation`
// returned by the `GetOperation` call of the `google::longrunning::Operations`
// service.
type LongRunningRecognizeResponse struct {
	// Output only. Sequential list of transcription results corresponding to
	// sequential portions of audio.
	Results              []*SpeechRecognitionResult `protobuf:"bytes,2,rep,name=results,proto3" json:"results,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *LongRunningRecognizeResponse) Reset()         { *m = LongRunningRecognizeResponse{} }
func (m *LongRunningRecognizeResponse) String() string { return proto.CompactTextString(m) }
func (*LongRunningRecognizeResponse) ProtoMessage()    {}
func (*LongRunningRecognizeResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_06c282b85cb237e9, []int{8}
}

func (m *LongRunningRecognizeResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LongRunningRecognizeResponse.Unmarshal(m, b)
}
func (m *LongRunningRecognizeResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LongRunningRecognizeResponse.Marshal(b, m, deterministic)
}
func (m *LongRunningRecognizeResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LongRunningRecognizeResponse.Merge(m, src)
}
func (m *LongRunningRecognizeResponse) XXX_Size() int {
	return xxx_messageInfo_LongRunningRecognizeResponse.Size(m)
}
func (m *LongRunningRecognizeResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_LongRunningRecognizeResponse.DiscardUnknown(m)
}

var xxx_messageInfo_LongRunningRecognizeResponse proto.InternalMessageInfo

func (m *LongRunningRecognizeResponse) GetResults() []*SpeechRecognitionResult {
	if m != nil {
		return m.Results
	}
	return nil
}

// Describes the progress of a long-running `LongRunningRecognize` call. It is
// included in the `metadata` field of the `Operation` returned by the
// `GetOperation` call of the `google::longrunning::Operations` service.
type LongRunningRecognizeMetadata struct {
	// Approximate percentage of audio processed thus far. Guaranteed to be 100
	// when the audio is fully processed and the results are available.
	ProgressPercent int32 `protobuf:"varint,1,opt,name=progress_percent,json=progressPercent,proto3" json:"progress_percent,omitempty"`
	// Time when the request was received.
	StartTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Time of the most recent processing update.
	LastUpdateTime       *timestamp.Timestamp `protobuf:"bytes,3,opt,name=last_update_time,json=lastUpdateTime,proto3" json:"last_update_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *LongRunningRecognizeMetadata) Reset()         { *m = LongRunningRecognizeMetadata{} }
func (m *LongRunningRecognizeMetadata) String() string { return proto.CompactTextString(m) }
func (*LongRunningRecognizeMetadata) ProtoMessage()    {}
func (*LongRunningRecognizeMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_06c282b85cb237e9, []int{9}
}

func (m *LongRunningRecognizeMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LongRunningRecognizeMetadata.Unmarshal(m, b)
}
func (m *LongRunningRecognizeMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LongRunningRecognizeMetadata.Marshal(b, m, deterministic)
}
func (m *LongRunningRecognizeMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LongRunningRecognizeMetadata.Merge(m, src)
}
func (m *LongRunningRecognizeMetadata) XXX_Size() int {
	return xxx_messageInfo_LongRunningRecognizeMetadata.Size(m)
}
func (m *LongRunningRecognizeMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_LongRunningRecognizeMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_LongRunningRecognizeMetadata proto.InternalMessageInfo

func (m *LongRunningRecognizeMetadata) GetProgressPercent() int32 {
	if m != nil {
		return m.ProgressPercent
	}
	return 0
}

func (m *LongRunningRecognizeMetadata) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *LongRunningRecognizeMetadata) GetLastUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.LastUpdateTime
	}
	return nil
}

// `StreamingRecognizeResponse` is the only message returned to the client by
// `StreamingRecognize`. A series of zero or more `StreamingRecognizeResponse`
// messages are streamed back to the client. If there is no recognizable
// audio, and `single_utterance` is set to false, then no messages are streamed
// back to the client.
//
// Here's an example of a series of ten `StreamingRecognizeResponse`s that might
// be returned while processing audio:
//
// 1. results { alternatives { transcript: "tube" } stability: 0.01 }
//
// 2. results { alternatives { transcript: "to be a" } stability: 0.01 }
//
// 3. results { alternatives { transcript: "to be" } stability: 0.9 }
//    results { alternatives { transcript: " or not to be" } stability: 0.01 }
//
// 4. results { alternatives { transcript: "to be or not to be"
//                             confidence: 0.92 }
//              alternatives { transcript: "to bee or not to bee" }
//              is_final: true }
//
// 5. results { alternatives { transcript: " that's" } stability: 0.01 }
//
// 6. results { alternatives { transcript: " that is" } stability: 0.9 }
//    results { alternatives { transcript: " the question" } stability: 0.01 }
//
// 7. results { alternatives { transcript: " that is the question"
//                             confidence: 0.98 }
//              alternatives { transcript: " that was the question" }
//              is_final: true }
//
// Notes:
//
// - Only two of the above responses #4 and #7 contain final results; they are
//   indicated by `is_final: true`. Concatenating these together generates the
//   full transcript: "to be or not to be that is the question".
//
// - The others contain interim `results`. #3 and #6 contain two interim
//   `results`: the first portion has a high stability and is less likely to
//   change; the second portion has a low stability and is very likely to
//   change. A UI designer might choose to show only high stability `results`.
//
// - The specific `stability` and `confidence` values shown above are only for
//   illustrative purposes. Actual values may vary.
//
// - In each response, only one of these fields will be set:
//     `error`,
//     `speech_event_type`, or
//     one or more (repeated) `results`.
type StreamingRecognizeResponse struct {
	// Output only. If set, returns a [google.rpc.Status][google.rpc.Status] message that
	// specifies the error for the operation.
	Error *status.Status `protobuf:"bytes,1,opt,name=error,proto3" json:"error,omitempty"`
	// Output only. This repeated list contains zero or more results that
	// correspond to consecutive portions of the audio currently being processed.
	// It contains zero or one `is_final=true` result (the newly settled portion),
	// followed by zero or more `is_final=false` results (the interim results).
	Results []*StreamingRecognitionResult `protobuf:"bytes,2,rep,name=results,proto3" json:"results,omitempty"`
	// Output only. Indicates the type of speech event.
	SpeechEventType      StreamingRecognizeResponse_SpeechEventType `protobuf:"varint,4,opt,name=speech_event_type,json=speechEventType,proto3,enum=google.cloud.speech.v1.StreamingRecognizeResponse_SpeechEventType" json:"speech_event_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                   `json:"-"`
	XXX_unrecognized     []byte                                     `json:"-"`
	XXX_sizecache        int32                                      `json:"-"`
}

func (m *StreamingRecognizeResponse) Reset()         { *m = StreamingRecognizeResponse{} }
func (m *StreamingRecognizeResponse) String() string { return proto.CompactTextString(m) }
func (*StreamingRecognizeResponse) ProtoMessage()    {}
func (*StreamingRecognizeResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_06c282b85cb237e9, []int{10}
}

func (m *StreamingRecognizeResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingRecognizeResponse.Unmarshal(m, b)
}
func (m *StreamingRecognizeResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingRecognizeResponse.Marshal(b, m, deterministic)
}
func (m *StreamingRecognizeResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingRecognizeResponse.Merge(m, src)
}
func (m *StreamingRecognizeResponse) XXX_Size() int {
	return xxx_messageInfo_StreamingRecognizeResponse.Size(m)
}
func (m *StreamingRecognizeResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingRecognizeResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingRecognizeResponse proto.InternalMessageInfo

func (m *StreamingRecognizeResponse) GetError() *status.Status {
	if m != nil {
		return m.Error
	}
	return nil
}

func (m *StreamingRecognizeResponse) GetResults() []*StreamingRecognitionResult {
	if m != nil {
		return m.Results
	}
	return nil
}

func (m *StreamingRecognizeResponse) GetSpeechEventType() StreamingRecognizeResponse_SpeechEventType {
	if m != nil {
		return m.SpeechEventType
	}
	return StreamingRecognizeResponse_SPEECH_EVENT_UNSPECIFIED
}

// A streaming speech recognition result corresponding to a portion of the audio
// that is currently being processed.
type StreamingRecognitionResult struct {
	// Output only. May contain one or more recognition hypotheses (up to the
	// maximum specified in `max_alternatives`).
	// These alternatives are ordered in terms of accuracy, with the top (first)
	// alternative being the most probable, as ranked by the recognizer.
	Alternatives []*SpeechRecognitionAlternative `protobuf:"bytes,1,rep,name=alternatives,proto3" json:"alternatives,omitempty"`
	// Output only. If `false`, this `StreamingRecognitionResult` represents an
	// interim result that may change. If `true`, this is the final time the
	// speech service will return this particular `StreamingRecognitionResult`,
	// the recognizer will not return any further hypotheses for this portion of
	// the transcript and corresponding audio.
	IsFinal bool `protobuf:"varint,2,opt,name=is_final,json=isFinal,proto3" json:"is_final,omitempty"`
	// Output only. An estimate of the likelihood that the recognizer will not
	// change its guess about this interim result. Values range from 0.0
	// (completely unstable) to 1.0 (completely stable).
	// This field is only provided for interim results (`is_final=false`).
	// The default of 0.0 is a sentinel value indicating `stability` was not set.
	Stability            float32  `protobuf:"fixed32,3,opt,name=stability,proto3" json:"stability,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *StreamingRecognitionResult) Reset()         { *m = StreamingRecognitionResult{} }
func (m *StreamingRecognitionResult) String() string { return proto.CompactTextString(m) }
func (*StreamingRecognitionResult) ProtoMessage()    {}
func (*StreamingRecognitionResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_06c282b85cb237e9, []int{11}
}

func (m *StreamingRecognitionResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StreamingRecognitionResult.Unmarshal(m, b)
}
func (m *StreamingRecognitionResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StreamingRecognitionResult.Marshal(b, m, deterministic)
}
func (m *StreamingRecognitionResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StreamingRecognitionResult.Merge(m, src)
}
func (m *StreamingRecognitionResult) XXX_Size() int {
	return xxx_messageInfo_StreamingRecognitionResult.Size(m)
}
func (m *StreamingRecognitionResult) XXX_DiscardUnknown() {
	xxx_messageInfo_StreamingRecognitionResult.DiscardUnknown(m)
}

var xxx_messageInfo_StreamingRecognitionResult proto.InternalMessageInfo

func (m *StreamingRecognitionResult) GetAlternatives() []*SpeechRecognitionAlternative {
	if m != nil {
		return m.Alternatives
	}
	return nil
}

func (m *StreamingRecognitionResult) GetIsFinal() bool {
	if m != nil {
		return m.IsFinal
	}
	return false
}

func (m *StreamingRecognitionResult) GetStability() float32 {
	if m != nil {
		return m.Stability
	}
	return 0
}

// A speech recognition result corresponding to a portion of the audio.
type SpeechRecognitionResult struct {
	// Output only. May contain one or more recognition hypotheses (up to the
	// maximum specified in `max_alternatives`).
	// These alternatives are ordered in terms of accuracy, with the top (first)
	// alternative being the most probable, as ranked by the recognizer.
	Alternatives         []*SpeechRecognitionAlternative `protobuf:"bytes,1,rep,name=alternatives,proto3" json:"alternatives,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                        `json:"-"`
	XXX_unrecognized     []byte                          `json:"-"`
	XXX_sizecache        int32                           `json:"-"`
}

func (m *SpeechRecognitionResult) Reset()         { *m = SpeechRecognitionResult{} }
func (m *SpeechRecognitionResult) String() string { return proto.CompactTextString(m) }
func (*SpeechRecognitionResult) ProtoMessage()    {}
func (*SpeechRecognitionResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_06c282b85cb237e9, []int{12}
}

func (m *SpeechRecognitionResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SpeechRecognitionResult.Unmarshal(m, b)
}
func (m *SpeechRecognitionResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SpeechRecognitionResult.Marshal(b, m, deterministic)
}
func (m *SpeechRecognitionResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SpeechRecognitionResult.Merge(m, src)
}
func (m *SpeechRecognitionResult) XXX_Size() int {
	return xxx_messageInfo_SpeechRecognitionResult.Size(m)
}
func (m *SpeechRecognitionResult) XXX_DiscardUnknown() {
	xxx_messageInfo_SpeechRecognitionResult.DiscardUnknown(m)
}

var xxx_messageInfo_SpeechRecognitionResult proto.InternalMessageInfo

func (m *SpeechRecognitionResult) GetAlternatives() []*SpeechRecognitionAlternative {
	if m != nil {
		return m.Alternatives
	}
	return nil
}

// Alternative hypotheses (a.k.a. n-best list).
type SpeechRecognitionAlternative struct {
	// Output only. Transcript text representing the words that the user spoke.
	Transcript string `protobuf:"bytes,1,opt,name=transcript,proto3" json:"transcript,omitempty"`
	// Output only. The confidence estimate between 0.0 and 1.0. A higher number
	// indicates an estimated greater likelihood that the recognized words are
	// correct. This field is set only for the top alternative of a non-streaming
	// result or, of a streaming result where `is_final=true`.
	// This field is not guaranteed to be accurate and users should not rely on it
	// to be always provided.
	// The default of 0.0 is a sentinel value indicating `confidence` was not set.
	Confidence float32 `protobuf:"fixed32,2,opt,name=confidence,proto3" json:"confidence,omitempty"`
	// Output only. A list of word-specific information for each recognized word.
	Words                []*WordInfo `protobuf:"bytes,3,rep,name=words,proto3" json:"words,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *SpeechRecognitionAlternative) Reset()         { *m = SpeechRecognitionAlternative{} }
func (m *SpeechRecognitionAlternative) String() string { return proto.CompactTextString(m) }
func (*SpeechRecognitionAlternative) ProtoMessage()    {}
func (*SpeechRecognitionAlternative) Descriptor() ([]byte, []int) {
	return fileDescriptor_06c282b85cb237e9, []int{13}
}

func (m *SpeechRecognitionAlternative) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SpeechRecognitionAlternative.Unmarshal(m, b)
}
func (m *SpeechRecognitionAlternative) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SpeechRecognitionAlternative.Marshal(b, m, deterministic)
}
func (m *SpeechRecognitionAlternative) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SpeechRecognitionAlternative.Merge(m, src)
}
func (m *SpeechRecognitionAlternative) XXX_Size() int {
	return xxx_messageInfo_SpeechRecognitionAlternative.Size(m)
}
func (m *SpeechRecognitionAlternative) XXX_DiscardUnknown() {
	xxx_messageInfo_SpeechRecognitionAlternative.DiscardUnknown(m)
}

var xxx_messageInfo_SpeechRecognitionAlternative proto.InternalMessageInfo

func (m *SpeechRecognitionAlternative) GetTranscript() string {
	if m != nil {
		return m.Transcript
	}
	return ""
}

func (m *SpeechRecognitionAlternative) GetConfidence() float32 {
	if m != nil {
		return m.Confidence
	}
	return 0
}

func (m *SpeechRecognitionAlternative) GetWords() []*WordInfo {
	if m != nil {
		return m.Words
	}
	return nil
}

// Word-specific information for recognized words.
type WordInfo struct {
	// Output only. Time offset relative to the beginning of the audio,
	// and corresponding to the start of the spoken word.
	// This field is only set if `enable_word_time_offsets=true` and only
	// in the top hypothesis.
	// This is an experimental feature and the accuracy of the time offset can
	// vary.
	StartTime *duration.Duration `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Output only. Time offset relative to the beginning of the audio,
	// and corresponding to the end of the spoken word.
	// This field is only set if `enable_word_time_offsets=true` and only
	// in the top hypothesis.
	// This is an experimental feature and the accuracy of the time offset can
	// vary.
	EndTime *duration.Duration `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. The word corresponding to this set of information.
	Word                 string   `protobuf:"bytes,3,opt,name=word,proto3" json:"word,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *WordInfo) Reset()         { *m = WordInfo{} }
func (m *WordInfo) String() string { return proto.CompactTextString(m) }
func (*WordInfo) ProtoMessage()    {}
func (*WordInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_06c282b85cb237e9, []int{14}
}

func (m *WordInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_WordInfo.Unmarshal(m, b)
}
func (m *WordInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_WordInfo.Marshal(b, m, deterministic)
}
func (m *WordInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_WordInfo.Merge(m, src)
}
func (m *WordInfo) XXX_Size() int {
	return xxx_messageInfo_WordInfo.Size(m)
}
func (m *WordInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_WordInfo.DiscardUnknown(m)
}

var xxx_messageInfo_WordInfo proto.InternalMessageInfo

func (m *WordInfo) GetStartTime() *duration.Duration {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *WordInfo) GetEndTime() *duration.Duration {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func (m *WordInfo) GetWord() string {
	if m != nil {
		return m.Word
	}
	return ""
}

func init() {
	proto.RegisterEnum("google.cloud.speech.v1.RecognitionConfig_AudioEncoding", RecognitionConfig_AudioEncoding_name, RecognitionConfig_AudioEncoding_value)
	proto.RegisterEnum("google.cloud.speech.v1.StreamingRecognizeResponse_SpeechEventType", StreamingRecognizeResponse_SpeechEventType_name, StreamingRecognizeResponse_SpeechEventType_value)
	proto.RegisterType((*RecognizeRequest)(nil), "google.cloud.speech.v1.RecognizeRequest")
	proto.RegisterType((*LongRunningRecognizeRequest)(nil), "google.cloud.speech.v1.LongRunningRecognizeRequest")
	proto.RegisterType((*StreamingRecognizeRequest)(nil), "google.cloud.speech.v1.StreamingRecognizeRequest")
	proto.RegisterType((*StreamingRecognitionConfig)(nil), "google.cloud.speech.v1.StreamingRecognitionConfig")
	proto.RegisterType((*RecognitionConfig)(nil), "google.cloud.speech.v1.RecognitionConfig")
	proto.RegisterType((*SpeechContext)(nil), "google.cloud.speech.v1.SpeechContext")
	proto.RegisterType((*RecognitionAudio)(nil), "google.cloud.speech.v1.RecognitionAudio")
	proto.RegisterType((*RecognizeResponse)(nil), "google.cloud.speech.v1.RecognizeResponse")
	proto.RegisterType((*LongRunningRecognizeResponse)(nil), "google.cloud.speech.v1.LongRunningRecognizeResponse")
	proto.RegisterType((*LongRunningRecognizeMetadata)(nil), "google.cloud.speech.v1.LongRunningRecognizeMetadata")
	proto.RegisterType((*StreamingRecognizeResponse)(nil), "google.cloud.speech.v1.StreamingRecognizeResponse")
	proto.RegisterType((*StreamingRecognitionResult)(nil), "google.cloud.speech.v1.StreamingRecognitionResult")
	proto.RegisterType((*SpeechRecognitionResult)(nil), "google.cloud.speech.v1.SpeechRecognitionResult")
	proto.RegisterType((*SpeechRecognitionAlternative)(nil), "google.cloud.speech.v1.SpeechRecognitionAlternative")
	proto.RegisterType((*WordInfo)(nil), "google.cloud.speech.v1.WordInfo")
}

func init() {
	proto.RegisterFile("google/cloud/speech/v1/cloud_speech.proto", fileDescriptor_06c282b85cb237e9)
}

var fileDescriptor_06c282b85cb237e9 = []byte{
	// 1392 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xcc, 0x57, 0x4f, 0x73, 0xdb, 0x44,
	0x14, 0x8f, 0xe2, 0x38, 0x7f, 0x5e, 0xfe, 0x39, 0x4b, 0x68, 0x15, 0x37, 0xb4, 0x41, 0xa5, 0x43,
	0xd2, 0x83, 0x4d, 0xd2, 0x4e, 0x0b, 0x85, 0x61, 0x70, 0x1c, 0x25, 0xf1, 0x4c, 0xe2, 0x64, 0x36,
	0x0e, 0x29, 0x1c, 0xd8, 0xd9, 0xc8, 0x6b, 0x47, 0x33, 0xf6, 0x4a, 0x68, 0x57, 0xa1, 0xe9, 0xad,
	0x5c, 0x99, 0xe1, 0xc2, 0xd0, 0x33, 0x1c, 0x39, 0x71, 0xe0, 0xc2, 0x67, 0xe0, 0x08, 0x5f, 0x81,
	0x0f, 0xc1, 0x91, 0xd9, 0x5d, 0xc9, 0xb1, 0x9d, 0x38, 0x4d, 0x67, 0xca, 0x0c, 0x37, 0xed, 0xef,
	0xfd, 0xde, 0xd3, 0x4f, 0x4f, 0xef, 0x8f, 0x04, 0x2b, 0xcd, 0x20, 0x68, 0xb6, 0x58, 0xd1, 0x6b,
	0x05, 0x71, 0xbd, 0x28, 0x42, 0xc6, 0xbc, 0x93, 0xe2, 0xe9, 0xaa, 0x39, 0x13, 0x73, 0x2e, 0x84,
	0x51, 0x20, 0x03, 0x74, 0xc3, 0x50, 0x0b, 0xda, 0x54, 0x48, 0x4c, 0xa7, 0xab, 0xf9, 0xc5, 0x24,
	0x04, 0x0d, 0xfd, 0x22, 0xe5, 0x3c, 0x90, 0x54, 0xfa, 0x01, 0x17, 0xc6, 0x2b, 0x7f, 0x37, 0xb1,
	0xb6, 0x02, 0xde, 0x8c, 0x62, 0xce, 0x7d, 0xde, 0x2c, 0x06, 0x21, 0x8b, 0x7a, 0x48, 0x0b, 0x09,
	0x49, 0x9f, 0x8e, 0xe3, 0x46, 0x91, 0xf2, 0xb3, 0xc4, 0x74, 0xbb, 0xdf, 0x54, 0x8f, 0x8d, 0x6f,
	0x62, 0xbf, 0xd5, 0x6f, 0x67, 0xed, 0x50, 0xa6, 0xce, 0x77, 0xfa, 0x8d, 0xd2, 0x6f, 0x33, 0x21,
	0x69, 0x3b, 0x4c, 0x08, 0x37, 0x13, 0x42, 0x14, 0x7a, 0x45, 0x21, 0xa9, 0x8c, 0x13, 0x45, 0xce,
	0x8f, 0x16, 0xe4, 0x30, 0xf3, 0x82, 0x26, 0xf7, 0x9f, 0x33, 0xcc, 0xbe, 0x8e, 0x99, 0x90, 0xa8,
	0x04, 0xa3, 0x5e, 0xc0, 0x1b, 0x7e, 0xd3, 0xb6, 0x96, 0xac, 0xe5, 0xc9, 0xb5, 0x95, 0xc2, 0xe5,
	0x29, 0x29, 0x24, 0x9e, 0x4a, 0x66, 0x59, 0x3b, 0xe0, 0xc4, 0x11, 0x7d, 0x0a, 0x59, 0x1a, 0xd7,
	0xfd, 0xc0, 0x1e, 0xd6, 0x11, 0x96, 0xaf, 0x11, 0xa1, 0xa4, 0xf8, 0xd8, 0xb8, 0x39, 0x3f, 0x59,
	0x70, 0x6b, 0x27, 0xe0, 0x4d, 0x6c, 0x52, 0xf9, 0x7f, 0x94, 0xf8, 0xbb, 0x05, 0x0b, 0x07, 0x32,
	0x62, 0xb4, 0x7d, 0x99, 0x40, 0x02, 0x39, 0x91, 0x1a, 0x49, 0x8f, 0xd4, 0xb5, 0x41, 0x37, 0xea,
	0x0f, 0x76, 0xae, 0x79, 0x7b, 0x08, 0xcf, 0x76, 0xa2, 0x19, 0x08, 0xdd, 0x83, 0x69, 0xad, 0x43,
	0x05, 0x97, 0x8c, 0x4b, 0xfd, 0x18, 0x53, 0xdb, 0x43, 0x78, 0x4a, 0xc3, 0x65, 0x83, 0xae, 0xbf,
	0x05, 0x73, 0xe7, 0x3a, 0x22, 0x23, 0xce, 0xf9, 0xcd, 0x82, 0xfc, 0xe0, 0xbb, 0xbd, 0x89, 0xe4,
	0xae, 0x40, 0x4e, 0xf8, 0xbc, 0xd9, 0x62, 0x24, 0x96, 0x92, 0x45, 0x94, 0x7b, 0x4c, 0x0b, 0x1c,
	0xc7, 0xb3, 0x06, 0x3f, 0x4c, 0x61, 0xf4, 0x3e, 0xcc, 0xfa, 0x5c, 0xb2, 0xc8, 0x6f, 0x93, 0x88,
	0x89, 0xb8, 0x25, 0x85, 0x9d, 0xd1, 0xcc, 0x99, 0x04, 0xc6, 0x06, 0x75, 0x7e, 0xce, 0xc2, 0xdc,
	0x45, 0xb1, 0x07, 0x30, 0xce, 0xb8, 0x17, 0xd4, 0x7d, 0x6e, 0xe4, 0xce, 0xac, 0x3d, 0xbe, 0xb6,
	0xdc, 0x82, 0x7e, 0xa1, 0x6e, 0xe2, 0x8e, 0x3b, 0x81, 0xd0, 0x7d, 0x98, 0x13, 0xb4, 0x1d, 0xb6,
	0x18, 0x89, 0xa8, 0x64, 0xe4, 0x84, 0x45, 0xf2, 0xb9, 0xd6, 0x9f, 0xc5, 0xb3, 0xc6, 0x80, 0xa9,
	0x64, 0xdb, 0x0a, 0x46, 0x77, 0x61, 0xba, 0x45, 0x79, 0x33, 0xa6, 0x4d, 0x46, 0xbc, 0xa0, 0xce,
	0xb4, 0xfa, 0x09, 0x3c, 0x95, 0x82, 0xe5, 0xa0, 0xce, 0x54, 0x3e, 0xda, 0xf4, 0x19, 0xa1, 0x2d,
	0xc9, 0x22, 0x4e, 0xa5, 0x7f, 0xca, 0x84, 0x3d, 0x62, 0xe2, 0xb5, 0xe9, 0xb3, 0x52, 0x17, 0xac,
	0xa8, 0x61, 0x14, 0x34, 0x28, 0xf7, 0xe5, 0x19, 0x69, 0xf8, 0xca, 0x64, 0x67, 0x4d, 0xea, 0x3a,
	0xf8, 0xa6, 0x86, 0x51, 0x15, 0x66, 0xcd, 0xd3, 0x99, 0x22, 0x78, 0x26, 0x85, 0x3d, 0xba, 0x94,
	0x59, 0x9e, 0x5c, 0xbb, 0x37, 0xb0, 0xc6, 0xf4, 0x55, 0xd9, 0xb0, 0xf1, 0x8c, 0xe8, 0x3e, 0x0a,
	0xf4, 0x18, 0x6c, 0xc6, 0xe9, 0x71, 0x8b, 0x91, 0x6f, 0x82, 0xa8, 0x4e, 0xd4, 0x14, 0x21, 0x41,
	0xa3, 0x21, 0x98, 0x14, 0xf6, 0xb8, 0x96, 0xf0, 0xb6, 0xb1, 0x1f, 0x05, 0x51, 0xbd, 0xe6, 0xb7,
	0xd9, 0x9e, 0x31, 0xa2, 0xcf, 0x60, 0x31, 0x71, 0xa4, 0xb1, 0x0c, 0xda, 0x54, 0xfa, 0x1e, 0x09,
	0x63, 0xee, 0xc9, 0x58, 0xcf, 0x30, 0x7b, 0x52, 0x3b, 0xe7, 0x0d, 0xa7, 0x94, 0x52, 0xf6, 0xcf,
	0x19, 0x68, 0x1e, 0xb2, 0xed, 0xa0, 0xce, 0x5a, 0xf6, 0xb4, 0xce, 0x9e, 0x39, 0xa0, 0x77, 0x61,
	0x2a, 0x16, 0x8c, 0x30, 0x7e, 0xa2, 0x4a, 0xa5, 0x6e, 0xcf, 0xe8, 0x38, 0x93, 0xb1, 0x60, 0x6e,
	0x02, 0x39, 0xdf, 0x59, 0x30, 0xdd, 0xf3, 0x1a, 0x91, 0x0d, 0xf3, 0x6e, 0xb5, 0xbc, 0xb7, 0x51,
	0xa9, 0x6e, 0x91, 0xc3, 0xea, 0xc1, 0xbe, 0x5b, 0xae, 0x6c, 0x56, 0xdc, 0x8d, 0xdc, 0x10, 0x9a,
	0x82, 0xf1, 0x9d, 0x4a, 0xd5, 0x2d, 0xe1, 0xd5, 0x47, 0x39, 0x0b, 0x8d, 0xc3, 0xc8, 0xe6, 0x4e,
	0xa9, 0x9c, 0x1b, 0x46, 0x13, 0x90, 0xdd, 0x3d, 0xdc, 0x29, 0x1d, 0xe5, 0x32, 0x68, 0x0c, 0x32,
	0xa5, 0x5d, 0x9c, 0x1b, 0x41, 0x00, 0xa3, 0xa5, 0x5d, 0x4c, 0x8e, 0xd6, 0x73, 0x59, 0xe5, 0xb7,
	0xb7, 0xb5, 0x45, 0xf6, 0xf6, 0x0f, 0x0f, 0x72, 0xa3, 0x28, 0x0f, 0x37, 0x0e, 0xf6, 0x5d, 0xf7,
	0x29, 0x39, 0xaa, 0xd4, 0xb6, 0xc9, 0xb6, 0x5b, 0xda, 0x70, 0x31, 0x59, 0xff, 0xa2, 0xe6, 0xe6,
	0xc6, 0x9c, 0x15, 0x98, 0xee, 0x49, 0x31, 0xb2, 0x61, 0x2c, 0x3c, 0x89, 0xa8, 0x60, 0xc2, 0xb6,
	0x96, 0x32, 0xcb, 0x13, 0x38, 0x3d, 0x3a, 0xb8, 0x33, 0x79, 0x3b, 0xa3, 0x05, 0xe5, 0x61, 0x2c,
	0x6d, 0x67, 0x2b, 0x69, 0xe7, 0x14, 0x40, 0x08, 0x32, 0x71, 0xe4, 0xeb, 0x2a, 0x9c, 0xd8, 0x1e,
	0xc2, 0xea, 0xb0, 0x3e, 0x03, 0xa6, 0xdb, 0x89, 0x08, 0xe2, 0xc8, 0x63, 0xce, 0x57, 0x9d, 0x0e,
	0x51, 0x93, 0x48, 0x84, 0x01, 0x17, 0x0c, 0x55, 0x60, 0x2c, 0x6d, 0xac, 0x61, 0x5d, 0x1d, 0xc5,
	0xab, 0xab, 0xa3, 0x4b, 0x95, 0x69, 0x3d, 0x9c, 0xfa, 0x3b, 0x3e, 0x2c, 0x5e, 0x3e, 0x95, 0xdf,
	0xfc, 0xad, 0xfe, 0xb0, 0x2e, 0xbf, 0xd7, 0x2e, 0x93, 0xb4, 0x4e, 0x25, 0x4d, 0xfa, 0xa4, 0x19,
	0x31, 0x21, 0x48, 0xc8, 0x22, 0x2f, 0x4d, 0x5a, 0x56, 0xf7, 0x89, 0xc6, 0xf7, 0x0d, 0x8c, 0x3e,
	0x02, 0x10, 0x92, 0x46, 0x52, 0x57, 0x74, 0x32, 0xef, 0xf3, 0xa9, 0xb2, 0x74, 0x69, 0x16, 0x6a,
	0xe9, 0xd2, 0xc4, 0x13, 0x9a, 0xad, 0xce, 0x68, 0x03, 0x72, 0x2d, 0x2a, 0x24, 0x89, 0xc3, 0xba,
	0x9a, 0x04, 0x3a, 0x40, 0xe6, 0x95, 0x01, 0x66, 0x94, 0xcf, 0xa1, 0x76, 0x51, 0xa0, 0xf3, 0xe7,
	0xf0, 0xc5, 0x81, 0xdb, 0x95, 0xb6, 0x65, 0xc8, 0xb2, 0x28, 0x0a, 0xa2, 0x64, 0xde, 0xa2, 0x34,
	0x72, 0x14, 0x7a, 0x85, 0x03, 0xbd, 0xae, 0xb1, 0x21, 0xa0, 0x9d, 0xfe, 0x04, 0xbf, 0xd6, 0x36,
	0xe9, 0xcb, 0x31, 0xe2, 0x30, 0x97, 0xcc, 0x0f, 0x76, 0xca, 0xb8, 0x24, 0xf2, 0x2c, 0x64, 0x7a,
	0x2c, 0xcd, 0xac, 0xad, 0x5f, 0x37, 0xee, 0xf9, 0x63, 0x24, 0xef, 0xd4, 0x55, 0xa1, 0x6a, 0x67,
	0x21, 0xc3, 0xc9, 0x70, 0xea, 0x00, 0xce, 0x0e, 0xcc, 0xf6, 0x71, 0xd0, 0x22, 0xd8, 0xaa, 0x99,
	0xca, 0xdb, 0xc4, 0xfd, 0xdc, 0xad, 0xd6, 0xfa, 0x1a, 0xf6, 0x16, 0xdc, 0x74, 0xab, 0x1b, 0x64,
	0x6f, 0x93, 0x1c, 0x54, 0xaa, 0x5b, 0x3b, 0x2e, 0x39, 0xac, 0xd5, 0x5c, 0x5c, 0xaa, 0x96, 0xdd,
	0x9c, 0xe5, 0xfc, 0x3a, 0x60, 0x8b, 0x99, 0xa7, 0x44, 0x4f, 0x61, 0xaa, 0x67, 0xdc, 0x5a, 0x3a,
	0x5f, 0x0f, 0xaf, 0x5d, 0x90, 0x5d, 0x43, 0x19, 0xf7, 0x44, 0x42, 0x0b, 0x30, 0xee, 0x0b, 0xd2,
	0xf0, 0x39, 0x6d, 0x25, 0x4b, 0x6d, 0xcc, 0x17, 0x9b, 0xea, 0x88, 0x16, 0x41, 0xd5, 0xce, 0xb1,
	0xdf, 0xf2, 0xe5, 0x99, 0xae, 0x93, 0x61, 0x7c, 0x0e, 0x38, 0x02, 0x6e, 0x0e, 0xa8, 0xfb, 0xff,
	0x4e, 0xad, 0xf3, 0xd2, 0x82, 0xc5, 0xab, 0xe8, 0xe8, 0x36, 0x80, 0x8c, 0x28, 0x17, 0x5e, 0xe4,
	0x87, 0xa6, 0x85, 0x26, 0x70, 0x17, 0xa2, 0xec, 0x7a, 0xab, 0xd7, 0x59, 0xba, 0xc5, 0x87, 0x71,
	0x17, 0x82, 0x1e, 0x41, 0x56, 0xad, 0x0b, 0xb5, 0xb6, 0x95, 0xe6, 0xa5, 0x41, 0x9a, 0xd5, 0xd2,
	0xa8, 0xf0, 0x46, 0x80, 0x0d, 0xdd, 0xf9, 0xde, 0x82, 0xf1, 0x14, 0x43, 0x1f, 0xf6, 0xb4, 0xa8,
	0xe9, 0x83, 0x85, 0x0b, 0x1d, 0xb6, 0x91, 0x7c, 0x14, 0x77, 0x77, 0xe8, 0x43, 0xf5, 0x01, 0x50,
	0xef, 0x6e, 0xed, 0x2b, 0xfc, 0xc6, 0x18, 0xd7, 0x8b, 0x0b, 0x21, 0x18, 0x51, 0x2a, 0x92, 0x65,
	0xad, 0xaf, 0xd7, 0x7e, 0xc9, 0xc0, 0xa8, 0xc9, 0x14, 0x7a, 0x61, 0xc1, 0x44, 0xa7, 0xc0, 0xd1,
	0xab, 0xbe, 0x0d, 0x3b, 0x9f, 0x7d, 0xf9, 0x95, 0x6b, 0x30, 0x4d, 0xb7, 0x38, 0x77, 0xbe, 0xfd,
	0xeb, 0xef, 0x1f, 0x86, 0x17, 0x9c, 0x79, 0xf5, 0x1f, 0x62, 0x88, 0x4f, 0xa2, 0x94, 0xf5, 0xc4,
	0xba, 0x8f, 0x5e, 0x5a, 0x30, 0x7f, 0xd9, 0x04, 0x44, 0x0f, 0x06, 0xdd, 0xe4, 0x8a, 0x2f, 0xe6,
	0xfc, 0x3b, 0xa9, 0x53, 0xd7, 0x1f, 0x4a, 0x61, 0x2f, 0xfd, 0x43, 0x71, 0xee, 0x6b, 0x35, 0xef,
	0x39, 0x77, 0xba, 0xd4, 0x74, 0x31, 0x7b, 0x84, 0xbd, 0xb0, 0x00, 0x5d, 0x1c, 0x03, 0x68, 0xf5,
	0x75, 0x46, 0x86, 0x11, 0xb5, 0xf6, 0xfa, 0x53, 0xc6, 0x19, 0x5a, 0xb6, 0x3e, 0xb0, 0xd6, 0x5b,
	0x90, 0xf7, 0x82, 0xf6, 0x00, 0xf7, 0xf5, 0x49, 0xf3, 0x1a, 0xf7, 0xd5, 0xfb, 0xdf, 0xb7, 0xbe,
	0xfc, 0x24, 0xa1, 0x35, 0x03, 0xf5, 0x51, 0x56, 0x08, 0xa2, 0x66, 0xb1, 0xc9, 0xb8, 0xae, 0x8e,
	0xa2, 0x31, 0xd1, 0xd0, 0x17, 0xfd, 0x3f, 0x87, 0x1f, 0x9b, 0xab, 0x7f, 0x2c, 0xeb, 0x78, 0x54,
	0x73, 0x1f, 0xfc, 0x1b, 0x00, 0x00, 0xff, 0xff, 0x6d, 0x85, 0xf1, 0x69, 0x47, 0x0e, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// SpeechClient is the client API for Speech service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SpeechClient interface {
	// Performs synchronous speech recognition: receive results after all audio
	// has been sent and processed.
	Recognize(ctx context.Context, in *RecognizeRequest, opts ...grpc.CallOption) (*RecognizeResponse, error)
	// Performs asynchronous speech recognition: receive results via the
	// google.longrunning.Operations interface. Returns either an
	// `Operation.error` or an `Operation.response` which contains
	// a `LongRunningRecognizeResponse` message.
	LongRunningRecognize(ctx context.Context, in *LongRunningRecognizeRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Performs bidirectional streaming speech recognition: receive results while
	// sending audio. This method is only available via the gRPC API (not REST).
	StreamingRecognize(ctx context.Context, opts ...grpc.CallOption) (Speech_StreamingRecognizeClient, error)
}

type speechClient struct {
	cc *grpc.ClientConn
}

func NewSpeechClient(cc *grpc.ClientConn) SpeechClient {
	return &speechClient{cc}
}

func (c *speechClient) Recognize(ctx context.Context, in *RecognizeRequest, opts ...grpc.CallOption) (*RecognizeResponse, error) {
	out := new(RecognizeResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.speech.v1.Speech/Recognize", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *speechClient) LongRunningRecognize(ctx context.Context, in *LongRunningRecognizeRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.speech.v1.Speech/LongRunningRecognize", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *speechClient) StreamingRecognize(ctx context.Context, opts ...grpc.CallOption) (Speech_StreamingRecognizeClient, error) {
	stream, err := c.cc.NewStream(ctx, &_Speech_serviceDesc.Streams[0], "/google.cloud.speech.v1.Speech/StreamingRecognize", opts...)
	if err != nil {
		return nil, err
	}
	x := &speechStreamingRecognizeClient{stream}
	return x, nil
}

type Speech_StreamingRecognizeClient interface {
	Send(*StreamingRecognizeRequest) error
	Recv() (*StreamingRecognizeResponse, error)
	grpc.ClientStream
}

type speechStreamingRecognizeClient struct {
	grpc.ClientStream
}

func (x *speechStreamingRecognizeClient) Send(m *StreamingRecognizeRequest) error {
	return x.ClientStream.SendMsg(m)
}

func (x *speechStreamingRecognizeClient) Recv() (*StreamingRecognizeResponse, error) {
	m := new(StreamingRecognizeResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// SpeechServer is the server API for Speech service.
type SpeechServer interface {
	// Performs synchronous speech recognition: receive results after all audio
	// has been sent and processed.
	Recognize(context.Context, *RecognizeRequest) (*RecognizeResponse, error)
	// Performs asynchronous speech recognition: receive results via the
	// google.longrunning.Operations interface. Returns either an
	// `Operation.error` or an `Operation.response` which contains
	// a `LongRunningRecognizeResponse` message.
	LongRunningRecognize(context.Context, *LongRunningRecognizeRequest) (*longrunning.Operation, error)
	// Performs bidirectional streaming speech recognition: receive results while
	// sending audio. This method is only available via the gRPC API (not REST).
	StreamingRecognize(Speech_StreamingRecognizeServer) error
}

func RegisterSpeechServer(s *grpc.Server, srv SpeechServer) {
	s.RegisterService(&_Speech_serviceDesc, srv)
}

func _Speech_Recognize_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RecognizeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpeechServer).Recognize(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.speech.v1.Speech/Recognize",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpeechServer).Recognize(ctx, req.(*RecognizeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Speech_LongRunningRecognize_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(LongRunningRecognizeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SpeechServer).LongRunningRecognize(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.speech.v1.Speech/LongRunningRecognize",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SpeechServer).LongRunningRecognize(ctx, req.(*LongRunningRecognizeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Speech_StreamingRecognize_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(SpeechServer).StreamingRecognize(&speechStreamingRecognizeServer{stream})
}

type Speech_StreamingRecognizeServer interface {
	Send(*StreamingRecognizeResponse) error
	Recv() (*StreamingRecognizeRequest, error)
	grpc.ServerStream
}

type speechStreamingRecognizeServer struct {
	grpc.ServerStream
}

func (x *speechStreamingRecognizeServer) Send(m *StreamingRecognizeResponse) error {
	return x.ServerStream.SendMsg(m)
}

func (x *speechStreamingRecognizeServer) Recv() (*StreamingRecognizeRequest, error) {
	m := new(StreamingRecognizeRequest)
	if err := x.ServerStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

var _Speech_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.speech.v1.Speech",
	HandlerType: (*SpeechServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Recognize",
			Handler:    _Speech_Recognize_Handler,
		},
		{
			MethodName: "LongRunningRecognize",
			Handler:    _Speech_LongRunningRecognize_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamingRecognize",
			Handler:       _Speech_StreamingRecognize_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
	},
	Metadata: "google/cloud/speech/v1/cloud_speech.proto",
}
